# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=6.1.0 --output=unicodedb_6_1_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '6.1.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x0c ABOVE RIGHT'
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x03 AN'
'\x05 AND '
'\x0f AND COLD SWEAT'
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\t AND PICK'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x06 ARROW'
'\x05 BACK'
'\x04 BAR'
'\x06 BELOW'
'\t BEVERAGE'
'\x06 BLOCK'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x04 CAR'
'\x07 CER-WA'
'\n CHARACTER'
'\x06 CHART'
'\x07 CHIKI '
'\x07 CIRCLE'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING GABA'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x0b DECORATION'
'\x11 DOWN BLACK ARROW'
'\t DRACHMAS'
'\x07 ENGINE'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ILUT'
'\x03 IN'
'\x0e IN SILHOUETTE'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x0e KISIM5 TIMES '
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x0b LANE MERGE'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\x07 MUOMAE'
'\x06 MURDA'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x08 OF FOOD'
'\r OPPOSING KUR'
'\x04 ORE'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x02 P'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\x12 PLUS LU PLUS ESH2'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\x11 PLUS SHA3 PLUS A'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x06 POINT'
'\x18 POINTING BACKHAND INDEX'
'\x07 POMMEE'
'\x04 POT'
'\x0c PUNCTUATION'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x08 ROTUNDA'
'\x06 RULER'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\t SPARKLER'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\x12 THROUGH DESCENDER'
'\x07 TIMES '
'\x08 TIMES A'
'\x10 TIMES A PLUS NA'
'\n TIMES BAD'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x08 TIMES U'
'\x06 TONE-'
'\x08 TTUDDAG'
'\x02 U'
'\r VARIANT FORM'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x0b WITH COMMA'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DESCENDER'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\x17 WITH HALF-CIRCLE BELOW'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\r WITH INK PEN'
'\r WITH JEGOGAN'
'\x1b WITH LEFTWARDS ARROW ABOVE'
'\x0e WITH LONG LEG'
'\x14 WITH OBLIQUE STROKE'
'\x12 WITH PALATAL HOOK'
'\x12 WITH SMILING EYES'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x12 WITH VERTICAL BAR'
'\x07 WOLOSO'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x08-EM DASH'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x06-PIEUP'
'\n-POINTING '
'\x19-POINTING DOUBLE TRIANGLE'
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x010'
'\x080 BRONZE'
'\x050 DWO'
'\x0b0 FOOTSTOOL'
'\x040 KO'
'\x040 MA'
'\x050 MAN'
'\x040 NI'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x070 SPEAR'
'\x030 U'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 ZO'
'\x030-0'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x071 ARROW'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DU'
'\x051 DWE'
'\x061 GOLD'
'\x081 HELMET'
'\x061 HORN'
'\x041 KU'
'\x031 O'
'\x041 PO'
'\x041 QI'
'\x041 SA'
'\x041 SI'
'\x051 TWO'
'\x061 WINE'
'\x031-0'
'\x0211'
'\x03121'
'\x03155'
'\x0216'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\n2 PLUS ASH'
'\n2 PLUS GAL'
'\x0b2 PLUS GIR2'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x042 SO'
'\x042 WO'
'\x072 WOMAN'
'\x032-0'
'\x0220'
'\x0221'
'\x0222'
'\t247 DIPTE'
'\x03253'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x043 PA'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x073 WHEEL'
'\x033-0'
'\x03305'
'\x0233'
'\x0234'
'\x0239'
'\x014'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x044 KE'
'\x044 NE'
'\x044 TE'
'\x044 WA'
'\x044 ZE'
'\x034-0'
'\x0240'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AU'
'\t5 BATHTUB'
'\t5 CYPERUS'
'\x045 DE'
'\x045 JU'
'\x065 MERI'
'\x045 MO'
'\x045 NU'
'\x045 TO'
'\x045 WE'
'\x065 WOOL'
'\x035-0'
'\x0250'
'\x0253'
'\x0255'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 JE'
'\x046 JO'
'\x046 NA'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x056 TA2'
'\x066 TREE'
'\x036-0'
'\x03620'
'\x036D7'
'\x017'
'\x047 DI'
'\x047 JA'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 ZA'
'\x0270'
'\x0272'
'\x0372C'
'\x0279'
'\x018'
'\x038 A'
'\x038 E'
'\x038 I'
'\x088 KANAKO'
'\x058 NWA'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 TA'
'\x049 TU'
'\x04904A'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x06A HAAM'
'\x06A MFON'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\nA TANG LAI'
'\x07A WITH '
'\x05A YUE'
'\x04A-HA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x03AAF'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\nAB2 TIMES '
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\x06ABOVE '
'\x0eABOVE REVERSE '
'\tABULATION'
'\nAC LETTER '
'\x13ACCENT ATNAH HAFUKH'
'\x03ACE'
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x0bACKNOWLEDGE'
'\x03ACT'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x03AD3'
'\x03ADA'
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x02AE'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\tAGOLITIC '
'\x04AGON'
'\x08AGRAPHOS'
'\x02AH'
'\x08AH WITH '
'\x04AHAD'
'\x08AHAPRANA'
'\x05AHMI '
'\x02AI'
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x0cAKAARAANSAYA'
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x04ALES'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x05ALGAR'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x04AMBA'
'\x07AME DIE'
'\x03AMI'
'\x04AMLA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN2'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x06ANCORA'
'\x03AND'
'\x0fAND FEMALE SIGN'
'\x18AND MALE AND FEMALE SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x06ANGLE '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x08ANGULAR '
'\x08ANI SIGN'
'\x08ANS SIGN'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x03APE'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\x03APP'
'\rAPPED PRESENT'
'\x05APPLE'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x05AR B '
'\x04ARAE'
'\x08ARCASITE'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x07ARDNESS'
'\nARFUL FACE'
'\x05ARGE '
'\x0bARGE CIRCLE'
'\x0bARGE SQUARE'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\tARM CLOCK'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x05ARROW'
'\x06ARROW '
'\x0bARROW WITH '
'\x0eARSI YEH WITH '
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\rAS ABOVE SIGN'
'\x07AS SIGN'
'\x04ASAT'
'\x03ASE'
'\x03ASH'
'\x04ASH2'
'\x06ASHGAB'
'\x05ASKAL'
'\x05ASPER'
'\nASPIRATION'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x08ATAKANA '
'\x13ATED TELLER MACHINE'
'\x07ATH OF '
'\nATHA WITH '
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x14ATIN CAPITAL LETTER '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x02AU'
'\x07AU MARK'
'\x04AULA'
'\x07AULDRON'
'\x07AUNTLET'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x08AVAGRAHA'
'\x04AVE-'
'\x0fAVONIC ASTERISK'
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x0eAVY CHECK MARK'
'\x02AW'
'\rAWELLEMET YAZ'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x06AYEROK'
'\x0bAYING CARD '
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\nBA SATANGA'
'\x08BACKWARD'
'\x03BAD'
'\x03BAG'
'\x03BAH'
'\x0cBAHIRGOMUKHA'
'\x05BALAG'
'\x04BALL'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x08BARRED B'
')BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\tBASE UNIT'
'\x04BASH'
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x04BBON'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x06BEGIN '
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x05BENDE'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x06BGBIEE'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x03BIN'
'\x07BINING '
'\x0cBINING MARK '
'\x05BISAH'
'\x06BISCUS'
'\x0fBJOINED LETTER '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\rBLACK HEXAGON'
'\x11BLACK SHOGI PIECE'
'\x03BLE'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x07BOARDER'
'\rBOHAIRIC KHEI'
'\x08BOL SIGN'
'\x05BOLD '
'\x04BOOK'
'\x05BOOTS'
'\x06BOTTLE'
'\x11BOTTOM HALF BLACK'
'\x07BOURING'
'\x04BOVE'
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREVE'
'\x0cBREVE-MACRON'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x04BSET'
'\x03BSP'
'\nBSTRUCTION'
'\x03BU '
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\x06C SIGN'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x08CABLEWAY'
'\x03CAH'
'\x05CAKRA'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x07CANDRA '
'\x08CANDRA A'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x07CAP TEN'
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x05CECAK'
'\x05CECEK'
'\x03CEL'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x06CER-WA'
'\x05CEREK'
'\x02CH'
'\nCH BALLOON'
'\x03CHA'
'\x06CHAMKO'
'\x14CHARACTER INTRODUCER'
'\x03CHE'
'\nCHECK MARK'
'$CHED LEFT SEMICIRCLE WITH THREE DOTS'
'\x06CHEIKH'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x07CHILLU '
'\x06CHIRET'
'\x03CHO'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\rCHRYSANTHEMUM'
'\x06CHURCH'
'\x04CHWA'
'\nCHWA WITH '
'\x02CI'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x06CIRCLE'
'\rCIRCLE INSIDE'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\x04CKET'
'\x05CKING'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x0cCLOSED ENTRY'
'\x0bCLOSED EYES'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\nCOMBINING '
'\x07COMING '
'\x0fCOMING ENVELOPE'
'\x05COMMA'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x11CONSONANT SIGN PA'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x04CORE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x0fCROSS ON SHIELD'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x06CTOPUS'
'\x04CTOR'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x12CUP WITHOUT HANDLE'
'\x04CURL'
'\x06CURLY '
'\rCURLY BRACKET'
'\nCURLY LOOP'
'\tCURSIVE L'
'\x05CUTE-'
'\x03CWI'
'\nCY MESSAGE'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x07D CHIME'
'\x04D HA'
'\x07D INDEX'
'\x07D MOUTH'
'\tD SALTIRE'
'\x16D SEPARATOR MIDDLE DOT'
'\x06D SIGN'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\nDA PLUS HA'
'\nDA SATANGA'
'\x03DAA'
'\x03DAD'
'\x06DAGESH'
'\x06DAGGER'
'\x03DAH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\x0bDASH SYMBOL'
'\tDATE MARK'
'\x04DBAG'
'\x05DBOAT'
'\x02DD'
'\x04DDDA'
'\x05DDING'
'\x02DE'
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\tDESCENDER'
'\x0fDESCENDING TONE'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x05DESTY'
'\x02DF'
'\x04DGER'
'\x03DHA'
'\x07DHALATH'
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\rDIAERESIZED U'
'\tDIAGONAL '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\x0eDIFIER LETTER '
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x04DIM2'
'\x03DIN'
'\x0eDING CHARACTER'
'\x03DIO'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x05DIUM '
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x02DO'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x08DOT REPH'
'\nDOT WITHIN'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x07DOUBLE '
'\nDOUBLE BAR'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\rDOUBLE MUCAAD'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\x04DOWN'
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\tDOWN SIGN'
'\tDOWNWARDS'
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS TREND'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x06DUCEUS'
'\x03DUG'
'\x03DUN'
'\tDUN3 GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\x02DY'
'\tDY BEETLE'
'\x03DZA'
'\x03DZE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\x1fE DOT OVER TWO DOTS PUNCTUATION'
'\x05E GEE'
'\x07E GLASS'
'\x05E OF '
'\x08E OF POO'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E0'
'\x02E2'
'\x03E80'
'\x02EA'
'\x04EACE'
'\x07EAD ORE'
'\x05EAGLE'
'\x03EAM'
'\x04EANS'
'\nEARLY FORM'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\x05EBOOK'
'\x0bECTION MARK'
'\x03ED '
'\x08ED BRICK'
'\x06ED ICE'
'\x0eED PARAGRAPHOS'
'\x07ED RICE'
'\tEDESTRIAN'
'\x06EDIAL '
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x03EEM'
'\x03EEN'
'\x04EENG'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x06EFCASE'
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x0fEFTWARDS ARROWS'
'\x05EGION'
'\x02EH'
'\x08EH WITH '
'\x12EH WITH INVERTED V'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\tEIGHT OF '
'\x06EIGHTH'
'\x16EIGHTY ON BLACK SQUARE'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x0cELECTED AREA'
'\x03ELF'
'\x03ELL'
'\x0bELLOW HEART'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x05EMBIC'
'\x08EMICOLON'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x04ENCH'
'\nENCH FRIES'
'\rENCY EXCHANGE'
'\x03END'
'\x0eEND OF SECTION'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\nENS SYMBOL'
'\x07ENSHUET'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\x04ENTY'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x03EOW'
'\x08EPARATOR'
'\x05EPAYA'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\x06ER MUG'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x0fERING MEGAPHONE'
'\x05ERN W'
'\x04ERSE'
'\x06ERTED '
'\x03ERU'
'\x11ERU WITH BACK YER'
'\x02ES'
'\x08ESCENDER'
'\x1dESENTATION FORM FOR VERTICAL '
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x06ESHTIN'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\nEVANAGARI '
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\x12EVERSED C WITH DOT'
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x02EW'
'\x02EX'
'\x06EXAGON'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x17EXCLAMATION MARK SYMBOL'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EY '
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\x15F WITH TWO DOTS ABOVE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x12FACING SVASTI SIGN'
'\tFACING UP'
'\x10FALLING DIAGONAL'
'\x06FAMILY'
'\x05FATHA'
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x04FEED'
'\x03FEH'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FEUQ'
'\x06FF OF '
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIFTY'
'\x06FIFTY '
'\x0bFILE FOLDER'
'\x07FINAGH '
'\x06FINAL '
'\tFINAL NGA'
'\x08FINAL TH'
'\x07FINAL Y'
'\x04FIRE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x0cFIVE HUNDRED'
'\x02FL'
'\x04FLAG'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x16FLATTENED OPEN A ABOVE'
'\x15FLATTENED PARENTHESIS'
'\x05FLICT'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x12FORKED PARAGRAPHOS'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x04FOUR'
'\nFOUR BELOW'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x08FROM BAR'
'\x08FROWNING'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT ICE CREAM'
'\x0cFT RERENGGAN'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x03GAA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x03GAG'
'\x03GAH'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x03GAR'
'\x08GARITIC '
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\x06GERINE'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x0bGGAGE CLAIM'
'\nGGER WITH '
'\nGGRAVATION'
'\x03GGY'
'\x02GH'
'\x05GHAIN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\x04GHT '
'\rGHT ARROWHEAD'
'\x08GHT RAIL'
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x04GIDA'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GISH'
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'!GOLIAN LETTER MANCHU ALI GALI LHA'
'\x04GONG'
'\x03GOU'
'\x02GR'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x08GRAPH UK'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x02GW'
'\x13GYPTIAN HIEROGLYPH '
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x03H00'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x03HAA'
'\x07HAARKAA'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x04HAIN'
'\x03HAL'
'\x14HALA CONSONANT SIGN '
'\x04HALF'
'\x0fHALF RING ABOVE'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\tHARD SIGN'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x04HAYN'
'\x02HE'
'\x03HE '
'\x04HEAD'
'\x05HEAD '
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x08HEAVY YA'
'\x0bHEELED SHOE'
'\x04HEEN'
'\x03HEH'
'\x12HEN WITH DIAERESIS'
'\x03HER'
'\x06HERMES'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x16HEXIFORM LONG ANUSVARA'
'\x02HH'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\x0cHI TIMES BAD'
'\x03HID'
'\x05HIDET'
'\rHIEROGLYPHIC '
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\tHIMA SIMA'
'\x03HIN'
'\rHINESE TONE Y'
'\x07HIOPIC '
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x0bHJONG TILE '
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOO'
'\x04HOOK'
'\rHOOK AND TAIL'
'\tHOOK TAIL'
'\x04HOOL'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x06HORT A'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
'"HREE DOTS POINTING DOWNWARDS ABOVE'
' HREE DOTS POINTING UPWARDS BELOW'
'\tHREE FOR '
'\x08HREE OF '
'\x05HROOM'
'\x04HSHU'
'\x02HU'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x03HUR'
'\x02HV'
'\x02HW'
'\x03HWA'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x02I0'
'\x0eIAGONAL STROKE'
'\tIAL LINE '
'\tIALECT-P '
'\x10IAMOND IN SQUARE'
'\x0bIAN LETTER '
'\x0eIAN RUPEE SIGN'
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IAUDA'
'\x02IC'
'\x05ICAL '
'\x0cICE CONTROL '
'\x0cICE OF PIZZA'
'3ICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x1bIERSTRASS ELLIPTIC FUNCTION'
'\x03IES'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\x06IFIED '
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\nIGATURE OE'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\x0fIGHT ARROWHEAD '
'\x08IGHT OF '
'\x0fIGHT WITH STARS'
'\tIGHTH ASH'
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x05ILED '
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x03IMN'
'\x02IN'
'\x03IN '
'\tIN WITH T'
'\x03IN2'
'\x05INAL '
'\tINARBORAS'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x05INDEX'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\rING HAND SIGN'
'\x0eING HANDS SIGN'
'\tING HEART'
'\tING LANES'
'\x07ING OF '
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x06INGAAT'
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x08INITIAL '
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x06INKING'
'\x07INNABAR'
'\nINOCULAR O'
'\x03INS'
'\x06INSHIP'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x04INU '
'\x08INVERTED'
'\tINVERTED '
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INYA'
'\x03ION'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x0cIRAGANA HOKA'
'\nIRAL SHELL'
'\x05IRAMA'
'\x05IRCLE'
'\x06IRCLES'
'\x05IRCUT'
'\x04IRED'
'\x03IRL'
'\x04IRON'
'\x0cIRST SUBUNIT'
'\x04IRTY'
'\x02IS'
'\x08IS BELOW'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x0cIT SEPARATOR'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x15ITALIC SMALL DOTLESS '
'\x04ITAR'
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\tITRA SIGN'
'\x04ITSA'
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE SLOW SIGN'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\nIXTHS DISH'
'\x14IXTY ON BLACK SQUARE'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x02JE'
'\x0bJECT SYMBOL'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x03JOA'
'\x06JOINED'
'\x05JOKER'
'\x04JONG'
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x08K SYMBOL'
'\x07K WITH '
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\nKA SATANGA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\x03KAH'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x06KAVYKA'
'\x06KAYAH '
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x10KETBALL AND HOOP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x07KHAMTI '
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x05KHMU '
'\x02KI'
'\x04KICK'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING FACE'
'\x04KINI'
'\x0fKISIM5 TIMES BI'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x04KMA '
'\x02KO'
'\x03KO '
'\x04KOET'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x0bKTIESELSKAB'
'\x02KU'
'\x03KUE'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x03LAA'
'\x04LAAN'
'\x05LABAT'
'\x0bLABIAL SIGN'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x03LAH'
'\x03LAI'
'\x03LAL'
'\x03LAM'
'\tLAM WITH '
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\nLANE MERGE'
'\tLARGEMENT'
'\x03LAS'
'\x14LASHING SWEAT SYMBOL'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARDS'
'\x0bLCE TSA CAN'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\tLD TAMIL '
'\x04LDE '
'\x0eLDREN CROSSING'
'\x02LE'
'\x03LE '
'\x07LE LEAF'
'\nLE LETTER '
'\x13LEADING MCHAN RTAGS'
'\x0bLEAF CLOVER'
'\x05LEASE'
'\x04LED '
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\tLEFT HOOK'
'\nLEFT-HAND '
'\x12LEFT-STEM TONE BAR'
'\x0fLEFTWARDS ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\nLEK ATTAK '
'\x06LENDAR'
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x05LENIS'
'\x04LEPH'
'\x08LESS SHA'
'\x08LESSER Y'
'\x04LETH'
'\x06LETTER'
'\x07LETTER '
'\tLETTER KH'
'\x0bLETTER LLLA'
'\nLETTER SHA'
'\x15LETTER SMALL CAPITAL '
'\x10LETTER VOCALIC L'
'\x07LETTERS'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x02LF'
'\x07LF FACE'
'\x0fLF SECTION SIGN'
'\x03LFA'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0bLIEVED FACE'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\nLIGHT BULB'
'\nLIMITATION'
'\x04LINE'
'\x0eLINE EXTENSION'
'\tLINE FEED'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x07LKY WAY'
'\x02LL'
'\x08LL MOON '
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\x0cLLER COASTER'
'\x07LLEYBUS'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x07LLOWING'
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOBE '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG OVER '
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOON'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'\x16LOW PARAPHRASE BRACKET'
'\x08LOW TONE'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x02LT'
'\x0bLTERNATE YA'
'\x14LTIPLE MUSICAL NOTES'
'\x08LTRY LEG'
'\x02LU'
'\x0bLU PLUS IGI'
'\x03LUB'
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x08LWAY CAR'
'\x02LX'
'\x02LY'
'\x04LY H'
'\x07LY LOOP'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\x06M FEED'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x0bM TIMES SHE'
'\x02M0'
'\x02MA'
'\x03MAA'
'\x05MAAEH'
'\x07MAAYYAA'
'\x0bMACING FACE'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x05MALL '
'\x06MALL A'
'#MALL ARABIC LETTER TAH AND TWO DOTS'
'\x08MALL AXE'
'\x06MALL F'
'\x0cMALL LETTER '
'\x15MALL Q WITH HOOK TAIL'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x06MANYA '
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\x0eMARK LOWER DOT'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAY'
'\x02MB'
'\x03MBA'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x08MBINING '
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x05MBOL '
'\x07MBOL B0'
'\x19MBOL FOR SAMARITAN SOURCE'
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\nME PLUS DA'
'\nME PLUS EN'
'\x11ME PLUS GAN2 TENU'
'\x08MEASURE '
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x07MEDIUM '
'\x04MEEM'
'\nMEEM WITH '
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x04MERA'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x03MID'
'\x0bMIDDLE HOOK'
'\x0cMIDDLE TILDE'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIN'
'\x04MIL '
'\x0bMILING EYES'
'\nMILLE SIGN'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\nMINO TILE '
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\x05MISRA'
'\x03MIT'
'\x03MKA'
'\x03MMA'
'\x0cMMA WITH DOT'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'$MODIFIER LETTER KHAMTI REDUPLICATION'
'"MODIFIER LETTER LABIALIZATION MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\x02MP'
'\x03MPL'
'\x05MROCK'
'\x05MSHAE'
'\x03MSP'
'\x02MU'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x04MVAT'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x07N WITH '
'\x12N WITH MIDDLE HOOK'
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x08NA METEK'
'\x05NA PO'
'\x03NAA'
'\x04NAAU'
'\x06NACLES'
'\x03NAH'
'\nNAKE BELOW'
'\x03NAP'
'\x03NAR'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x13NAXIAN FIVE HUNDRED'
'\x04NBSP'
'\x05NCESS'
'\x03ND '
'\x0bND TWO DOTS'
'\x08NDA FACE'
'\nNDA PA NJI'
'\x04NDA2'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\tNDRABINDU'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x03NE '
'\x0cNE HALF SIGN'
'\x06NE OF '
'\x04NED '
'\x05NEGAR'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x04NEMA'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x0bNEUTRAL YER'
'\x03NEY'
'\x02NG'
'\x03NG '
'\x11NG STROKE OVERLAY'
'\x03NGA'
'\x04NGA2'
'\x03NGE'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x02NI'
'\x08NI ABOVE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\x05NING '
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x04NJAM'
'\x03NJI'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x06NNADA '
'\x06NNING '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\x04NOON'
'\nNOON WITH '
'\x04NOSE'
'\x05NOTCH'
'\x04NOTE'
'\nNOTE WITH '
'\x08NOWLEDGE'
'\x06NOWMAN'
'\tNS SYMBOL'
'\x06NSANAQ'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x05NTAIN'
'\tNTESSENCE'
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x02NU'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x07NUSVARA'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\tO HUNDRED'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x02O-'
'\x03O-I'
'\x02O0'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAT'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x07OCALIC '
'\tOCCLUSION'
'\x06OCENCE'
'\x08OCK SALT'
'\x0bOCOLATE BAR'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\tOENICIAN '
'\x03OF '
'\x0bOF MASHFAAT'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x08OFT SIGN'
'\x04OFUM'
'\x07OGICAL '
'\x08OGOGRAM '
'\x0fOGOGRAM KHAMTI '
'\x0cOGONEK ABOVE'
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x02OK'
'\x05OKARA'
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x06OLCANO'
'\x03OLD'
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x0bOLDING BACK'
'\x04OLIN'
'\nOLLAR SIGN'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\tOMBINING '
'\x04OMBU'
'\x07OMERANG'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x0cON US SYMBOL'
'\x13ON VIEWING CEREMONY'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE DOT '
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x14ONE HUNDRED THOUSAND'
'\tONE MARK-'
'\x0eONE SOUND WAVE'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x03ONG'
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\x05ONG S'
'\x0bONG S WITH '
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x0cONISHED FACE'
'\x10ONJOINING MACRON'
'\tONSONANT '
'\x04ONTH'
'\x07ONTIEEN'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\x06OOPED '
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x05OPARD'
'\x05OPEN '
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\tOPERATOR '
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x07OPWATCH'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\rORD SEPARATOR'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x04ORNS'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x06OSETTE'
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\x0fOTA WITH STROKE'
'\x07OTATED '
'\x13OTATED ARDHAVISARGA'
'\x08OTIFIED '
'\nOTING STAR'
'\x07OTLESS '
'\x08OTLESS J'
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x08OTPRINTS'
'\x0cOTTOM HALF O'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x11OUBLE MONOCULAR O'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x04OUBT'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x13OUR DOT PUNCTUATION'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\tOURA SIGN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x03OUT'
'\x07OUT HUB'
'\tOUT MOUTH'
'\tOUTH WIND'
'\nOUTHERN TA'
'\x0cOUTING WHALE'
'\x15OVAL WITH OVAL INSIDE'
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'\tOVER LONG'
'\tOVER MUSH'
'\x08OVER NUN'
'\x08OVER SAG'
'\tOVER SHE '
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x02OW'
'\x03OW '
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x1bOWN POINTING BACKHAND INDEX'
'\x1cOWN-POINTING DOUBLE TRIANGLE'
'\x07OX BACK'
'\x02OY'
'\x03OZE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\x11P ON BLACK SQUARE'
'\x07P PIEET'
'\nP STREAMER'
'\x07P WITH '
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x03PAH'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x0cPAP PLUS PAP'
'\x05PARAQ'
'\x0bPARENTHESIS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x11PE WITH DESCENDER'
'\x0bPEDESTRIANS'
'\x04PEEP'
'\x04PEN '
'\x05PEN E'
'\tPEN MOUTH'
'\x05PEN O'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x04PER '
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x18PERSET PRECEDING SOLIDUS'
'\x08PERSIAN '
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x03PHA'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x0ePHONE RECEIVER'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x06PICKET'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x05PIRIT'
'\x10PLACEHOLDER MARK'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x19PLICATION PROGRAM COMMAND'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x04PLUG'
'\x04PLUM'
'\nPLUS ERIN2'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\nPOLICE CAR'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x05PONSE'
'\x03POQ'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\tPPOINTED '
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x11PRESSIONLESS FACE'
'\x05PRING'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\x0ePROTECTED AREA'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x06PSTICK'
'\x05PTIC '
'\x05PTIVE'
'\x02PU'
'\x08PUN IYEK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x08PUSHPIKA'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x01Q'
'\x07Q WITH '
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x0fQUADRUPLE ARROW'
' QUALS SIGN ABOVE LEFTWARDS ARROW'
'\x05QUARE'
'\x0cQUARE BUTTON'
'\x06QUARED'
'\x07QUARTER'
'\x0bQUARTER ASH'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\tQUEEN OF '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\x06R FACE'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x0bR WITH TAIL'
'\x0eR-OFF CALENDAR'
'\x02R0'
'\x02R2'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x05RADA '
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x07RAISED '
'\nRAISED DOT'
'\x0bRAISED FLAG'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x08RAL FACE'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x0cRANCHING OUT'
'\rRANGE DIAMOND'
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x07RARIETY'
'\x05RASHA'
'\x05RATER'
'\x05RATHA'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x08RAUGHTS '
'\x03RAY'
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x05RCHID'
'\x07RD SIGN'
'\x12RDEL NAG RDEL DKAR'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\tREAK HERE'
'\x0bREAKTHROUGH'
'\x04REAT'
'\x11REATIONAL VEHICLE'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x08RECT HIT'
'\nRED CIRCLE'
'\nRED DRAGON'
'\x08RED FACE'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x0bREE HUNDRED'
'\x05REEK '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x05RELAA'
'\x06REMEDY'
'\x06RENGTH'
'\x04REPA'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x08REVERSE '
'\tREVERSED '
'\x0fREVERSED OPEN E'
'\x04RFER'
'\x02RG'
'\x04RGE '
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x0cRIAGE RETURN'
'\x0cRIAL TRAMWAY'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x03RIG'
'\x05RIGHT'
'\x06RIGHT '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x0fRIGHT RERENGGAN'
'\x0bRIGHT-HAND '
'\x0fRIGHT-POINTING '
'\x14RIGHT-POINTING ANGLE'
'+RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x10RIGHTWARDS ARROW'
'%RIGVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x03RII'
'\x06RIKRIK'
'\x07RILLIC '
'\x04RIN2'
'\x04RING'
'\nRING ABOVE'
'\nRING BELOW'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\rRIPLE SVARITA'
'\x06RIPT G'
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\x0eRK NOON GHUNNA'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x03RMT'
'\x0cRMUKHI SIGN '
'\x05RNED '
'\nRNING SIGN'
'\x02RO'
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROITIC '
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x04ROLL'
'\x03ROM'
'\x03RON'
'\x1bRONOMICAL SYMBOL FOR URANUS'
'\x04ROSH'
'\x04ROSS'
'\x07ROTUNDA'
'\x05ROUND'
'\nROUNDED ER'
'\rRPENTRY PLANE'
'\x02RR'
'\x03RRA'
'\rRRIAGE SYMBOL'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x02RT'
'\x06RT OF '
'\x06RTCAKE'
'\tRTER MARK'
'\x04RTH '
'\x07RTHIAN '
'\x07RTICAL '
'\x17RTOISE SHELL BRACKETED '
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\x05RULER'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x04RUNG'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x0fS IN SILHOUETTE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x02S0'
'\x02SA'
'\x04SA-I'
'\x03SAA'
'\x06SAADIY'
'\x03SAG'
'\x03SAH'
'\x03SAL'
'\rSAL PLUS TUG2'
'\nSALIZATION'
'\x08SALT OF '
'\x03SAM'
'\x06SANDAL'
'\x04SANG'
'\x07SANGAN '
'\x05SARGA'
'\x05SASAK'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\nSEEN WITH '
'\rSELECTED AREA'
'\tSEMICOLON'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x06SERET '
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x07SEVENTH'
'\x02SH'
'\x03SH '
'\x13SH PLUS HU PLUS ASH'
'\tSH SYMBOL'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\x04SHAD'
'\x04SHAE'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\tSHED FACE'
'\x04SHEI'
'\x04SHES'
'\x05SHESH'
'\x07SHESHIG'
'\x05SHGAB'
'\x07SHIFT T'
'\x05SHIMA'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x0fSHORT OVER LONG'
'\x0cSHORT RIKRIK'
'\x05SHPIN'
'\x04SHU2'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'\rSING DIAGONAL'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\tSIVE FACE'
'\rSIX LATE FORM'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x05SLASH'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x0eSMALL CAPITAL '
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\rSMALL LETTER '
'\rSMALL LETTERS'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\x12SMALL WHITE CIRCLE'
'\tSMALL YUS'
'\x0cSMILING EYES'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x02SO'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x0eSOUTH ARABIAN '
'\x02SP'
'\x05SPACE'
'\x13SPACING CANDRABINDU'
'\x06SPADES'
'\x06SPAPER'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x0cSQUIQUADRATE'
'\x02SS'
'\rSSAGE WAITING'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x04SSOM'
'\x0eSSPORT CONTROL'
'\x02ST'
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x07STATERS'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x07STITUTE'
'\x04STLE'
'\x05STNUT'
'\x04STOL'
'\x16STONE GRAVEYARD SYMBOL'
'\x0bSTORIC SITE'
'\x03STR'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STRING'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x18STROKE THROUGH DESCENDER'
'\nSTRUCTION '
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x03SU '
'\x13SUBSTITUTION MARKER'
'\x04SUKU'
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x05SURYA'
'\x07SVARITA'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02T0'
'\x02TA'
'\x0eTA LINK ESCAPE'
'\x03TAB'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\nTABULATION'
'\x06TAGRAM'
'\x03TAH'
'\x17TAH WITH TWO DOTS ABOVE'
'\x08TAI LUE '
'\x04TAIL'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x06TAMING'
'\x03TAN'
'\tTANDSTILL'
'\x03TAR'
'\x06TAU RO'
'\x06TAUROS'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\x0cTCHING CHICK'
'\x02TE'
'\rTE ORDER MARK'
'\x0cTE SEPARATOR'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\x04TED '
'\rTED HAND SIGN'
'\x18TED INTERPOLATION MARKER'
'\x06TEDUNG'
'\x03TEE'
'\x05TEGEH'
'\x0fTELLITE ANTENNA'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x07THIEUTH'
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOUSAND'
'\tTHOUSAND '
'\x06THREE '
'\x10THREE DOTS ABOVE'
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x03THW'
'\x02TI'
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x0bTIEE SHEUOQ'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x04TILL'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x05TKAAN'
'\x03TLE'
'\x06TLESS '
'\x05TMAAU'
'\x05TNESS'
'\x06TO BOX'
'\x03TOM'
'\x0bTONAL MARK '
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x15TONE MARK SGAW KAREN '
'\x05TONE-'
'\x0eTOP HALF BLACK'
'\tTOP RIGHT'
'\x05TORCH'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x02TR'
'\x0cTRAGRAM FOR '
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x15TRANSPOSITION BRACKET'
'\x14TRANSPOSITION MARKER'
'\x14TRATERRESTRIAL ALIEN'
'\x03TRE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\tTRETCHED '
'\x0bTRIAN CAMEL'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x0fTRIANGULAR MARK'
'\x08TRICOLON'
'\x05TRING'
'\x05TRIOL'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x05TROKE'
'\x18TROL SEQUENCE INTRODUCER'
'\x03TSA'
'\x03TSE'
'\x02TT'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x05TTER '
'\x05TTERN'
'\x05TTOCK'
'\x05TTOM '
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
"'TWO DOTS VERTICALLY BELOW AND SMALL TAH"
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x0bTWO-HEADED '
'\x02TY'
'\x0fTYSCAPE AT DUSK'
'\x01U'
'\x02U '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x03U U'
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x02U0'
'\x02U2'
'\x02U3'
'\nU3 PLUS AN'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB2'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x10UBLE PARENTHESIS'
'\x0fUBLE RING BELOW'
'\x0cUBLE SVARITA'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x06UCIBLE'
'\x02UD'
'\x05UDAAT'
'\x06UDATTA'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x02UG'
'\x06UGGAGE'
'\x04UGU '
'\x02UH'
'\x04UHUR'
'\x04UIRY'
'\x0bUISHED FACE'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x04UMAN'
'\nUMAN EARTH'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x05UMPET'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x12UNATE SIGMA SYMBOL'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x0bUND PUSHPIN'
'\x08UNDERTIE'
'\x07UNDRED '
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x03UNO'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x1aUP POINTING BACKHAND INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x18UP WITH EXCLAMATION MARK'
'\x1bUP-POINTING DOUBLE TRIANGLE'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URN'
'\x06URNAMA'
'\x06URNED '
'\x08UROPEAN '
'\x03URT'
'\x03URU'
'\x02US'
'\x07US TENT'
'\tUSED FACE'
'\x03USH'
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x02UT'
'\x04UTAE'
'\x05UTEUX'
'\x04UTH '
'\x0bUTH CORNERS'
'\x05UTIES'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\x02UX'
'\x02UZ'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02V0'
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x0bVAMAGOMUKHA'
'\x07VANESE '
'\x07VAPOURS'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x08VE SASAK'
'\x04VEDE'
'\x03VEE'
'!VELOPE WITH DOWNWARDS ARROW ABOVE'
'\tVELOPMENT'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x17VERTICAL BAR WITH QUILL'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x08VESSEL B'
'\x07VESTAN '
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x02VI'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x03VIN'
'\x04VINE'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x07VOICING'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x03VOP'
'\x0cVORCE SYMBOL'
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x11VOWEL LENGTH MARK'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x04VUEQ'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\x13W BRIGHTNESS SYMBOL'
'\nW OR MODEL'
'\x08W PRINTS'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\x03WAN'
'\x06WARDS '
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\tWAW WITH '
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x05WEST '
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x05WFISH'
'\x02WG'
'\x0bWHITE ARROW'
'\x0cWHITE CIRCLE'
'\x1cWHITE DOWN-POINTING TRIANGLE'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\x05WIANG'
'\x07WIGNYAN'
'\x05WINDU'
'\nWING HEART'
'\tWING STAR'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\tWITH CURL'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\x0cWITH STROKE '
'\tWITH TIP '
'\x18WITH TWO DOTS BELOW AND '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x05WLING'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x1aWNING FACE WITH OPEN MOUTH'
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'\x07WO FOR '
'\x06WO OF '
'\nWO SHORTS '
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\tWRY SMILE'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x07X BELOW'
'\tX MACHINE'
'\x1eX POINTED STAR WITH MIDDLE DOT'
'\x13X WITH PALATAL HOOK'
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x02XG'
'\tXHAUSTION'
'\x02XI'
'\x05XING '
'\x07XOPHONE'
'\x02XT'
'\x07XT LINE'
'\x05XTILE'
'\x05XTRA-'
'\x03XWG'
'\x01Y'
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\x0eY SMALL SQUARE'
'\x07Y WITH '
'\x03Y00'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x04YANG'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x03YIN'
'\x06YIN-DO'
'\x10YIR MKPARAQ MEUN'
'\x05YIZET'
'\x08YLLABLE '
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\x1bYMBOL MULTIPLE MEASURE REST'
'\x02YN'
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x04YODH'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x02YP'
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x08YRILLIC '
'\nYRILLIC EN'
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'\x01Z'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAH'
'\x03ZAI'
'\x04ZAIN'
'\x0eZAKAYA LANTERN'
'\tZAL SASAK'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\tZIR SASAK'
'\x03ZOA'
'\x03ZOO'
'\x02ZW'
'\x08ZWARAKAY'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[68108,
 -58419,
 -1,
 132311,
 34343,
 -1,
 197838,
 88547,
 -1,
 263229,
 161929,
 -1,
 327835,
 210129,
 -1,
 393314,
 265921,
 73909,
 458832,
 330803,
 73911,
 589823,
 393216,
 -1,
 589903,
 492109,
 -1,
 655378,
 528065,
 -1,
 720910,
 591057,
 -1,
 -65524,
 672007,
 73914,
 -65523,
 735416,
 73913,
 -1,
 795449,
 73912,
 983056,
 685853,
 73917,
 -1,
 920684,
 73918,
 -65519,
 940133,
 73916,
 -1,
 1054741,
 73915,
 1245211,
 619910,
 -1,
 1310743,
 1194146,
 -1,
 1376278,
 1255554,
 73957,
 -1,
 1312180,
 73958,
 -1,
 1327041,
 73959,
 1572890,
 1248961,
 -1,
 -65511,
 1535330,
 73956,
 -1,
 1592130,
 73955,
 -1,
 1542277,
 73960,
 1835043,
 1193169,
 -1,
 1900576,
 1785446,
 73933,
 1966111,
 1838386,
 73934,
 -1,
 1901784,
 73935,
 -1,
 1928626,
 73936,
 2228223,
 1838785,
 -1,
 -65502,
 2125154,
 73932,
 -1,
 2185395,
 73931,
 2359338,
 1787965,
 -1,
 2424870,
 2310081,
 73946,
 -1,
 2360626,
 73947,
 2555945,
 2363073,
 -1,
 -65496,
 2521449,
 73945,
 -1,
 2574397,
 73944,
 -1,
 2524813,
 73948,
 2818097,
 2308258,
 -1,
 2883631,
 2756289,
 -1,
 2949166,
 2837314,
 73938,
 -1,
 2884905,
 73939,
 -1,
 2884933,
 73937,
 -65488,
 2852570,
 73941,
 -1,
 3096185,
 73940,
 3276854,
 2762882,
 -1,
 3342388,
 3233893,
 73929,
 -1,
 3278628,
 73930,
 3538943,
 3296066,
 73927,
 -1,
 3409193,
 73928,
 3604539,
 3220181,
 -1,
 3670073,
 3554918,
 73924,
 -1,
 3625574,
 73925,
 -65478,
 3638999,
 73926,
 -1,
 3739329,
 73923,
 3932225,
 3545084,
 -1,
 3997758,
 3902109,
 73921,
 -1,
 3933563,
 73922,
 4194303,
 3935937,
 -1,
 -65472,
 4091271,
 73920,
 -1,
 4137685,
 73919,
 4325444,
 3900967,
 73962,
 4456447,
 4268757,
 73963,
 -1,
 4326643,
 73964,
 4522054,
 4283482,
 73952,
 -1,
 4457579,
 73953,
 4653129,
 4477468,
 -1,
 -65464,
 4603494,
 73951,
 -1,
 4663556,
 73950,
 4849740,
 4603494,
 -1,
 -65461,
 4814628,
 73943,
 -1,
 4863767,
 73942,
 -65459,
 4816641,
 73961,
 -65458,
 5007162,
 73954,
 -1,
 5065584,
 73949,
 -1,
 550257,
 73965,
 5308502,
 415845,
 73974,
 5439487,
 5246003,
 73975,
 5505023,
 5308416,
 -1,
 -65452,
 5406794,
 73976,
 -65451,
 5465466,
 73977,
 -1,
 5513636,
 73978,
 5701721,
 5262146,
 73970,
 -65448,
 5640957,
 73972,
 -1,
 5702116,
 73971,
 5898331,
 5664098,
 73979,
 -1,
 5835978,
 73980,
 6029405,
 5841621,
 73968,
 -1,
 5964731,
 73969,
 6160479,
 5969969,
 73966,
 -1,
 6095181,
 73967,
 -65440,
 6125435,
 73981,
 -65439,
 6246940,
 73973,
 -1,
 6291987,
 73910,
 6488193,
 343654,
 73984,
 6553709,
 6450530,
 -1,
 6619243,
 6491338,
 73994,
 6750207,
 6555352,
 -1,
 -65433,
 6645562,
 73999,
 -65432,
 6705605,
 73998,
 -65431,
 6766855,
 73997,
 -65430,
 6829418,
 73996,
 -1,
 6885103,
 73995,
 7143423,
 6556723,
 73992,
 -1,
 7012883,
 73993,
 7209079,
 6518150,
 -1,
 7274614,
 7157922,
 74001,
 7405567,
 7208960,
 -1,
 7405685,
 7306773,
 -1,
 7471220,
 7356862,
 -1,
 -65421,
 7438081,
 74004,
 -1,
 7477320,
 74003,
 -1,
 7417084,
 74005,
 -1,
 7348683,
 74002,
 -1,
 7213598,
 74000,
 7864443,
 7146802,
 73988,
 7995391,
 7798784,
 -1,
 -65414,
 7890308,
 73989,
 -1,
 7938494,
 73990,
 8126592,
 7798784,
 -1,
 8192127,
 8094285,
 -1,
 -65410,
 8160807,
 73986,
 -1,
 8202370,
 73985,
 -1,
 8135090,
 73987,
 -1,
 8070409,
 73991,
 8519833,
 6456871,
 74006,
 8585354,
 8457267,
 74008,
 8716287,
 8519680,
 -1,
 8716425,
 8618573,
 -1,
 8781959,
 8669410,
 74009,
 -1,
 8718133,
 74010,
 -65400,
 8746489,
 74012,
 -1,
 8871002,
 74011,
 -1,
 8665207,
 74013,
 9109647,
 8547682,
 74021,
 9175182,
 9078311,
 -1,
 -65395,
 9139997,
 74024,
 -1,
 9197669,
 74023,
 -1,
 9113111,
 74022,
 9437333,
 9052885,
 74014,
 9568255,
 9371648,
 -1,
 9568404,
 9470541,
 -1,
 -65389,
 9521937,
 74016,
 -1,
 9572090,
 74015,
 -1,
 9528717,
 74017,
 9830551,
 9392668,
 74019,
 -1,
 9766761,
 74020,
 -65384,
 9784130,
 74018,
 -1,
 9896284,
 74007,
 10158079,
 8466028,
 73982,
 -1,
 10028883,
 73983,
 10223908,
 281410,
 -1,
 10289392,
 10161857,
 74167,
 10354922,
 10237187,
 -1,
 10420452,
 10295292,
 74168,
 10551295,
 10354688,
 -1,
 10551523,
 10453581,
 -1,
 10617001,
 10489537,
 74169,
 10682534,
 10552529,
 -1,
 -65372,
 10636296,
 74172,
 -65371,
 10696081,
 74171,
 -1,
 10756921,
 74170,
 -65369,
 10647371,
 74175,
 -65368,
 10901605,
 74174,
 -1,
 10963778,
 74173,
 11141296,
 10585639,
 74213,
 11206829,
 11076817,
 -1,
 -65364,
 11175475,
 74215,
 -1,
 11210433,
 74214,
 -65362,
 11171613,
 74218,
 -65361,
 11346645,
 74217,
 -1,
 11406433,
 74216,
 11600057,
 11105670,
 -1,
 11665592,
 11548834,
 -1,
 11731124,
 11634311,
 74207,
 -1,
 11666847,
 74208,
 11862199,
 11683354,
 -1,
 -65354,
 11829322,
 74206,
 -1,
 11889102,
 74205,
 -1,
 11806990,
 74204,
 -1,
 11634821,
 74209,
 12189888,
 11552829,
 -1,
 12255422,
 12158503,
 -1,
 12320957,
 12208962,
 74194,
 -1,
 12256527,
 74195,
 -1,
 12258506,
 74193,
 12582911,
 12205670,
 74191,
 -1,
 12474469,
 74192,
 12648645,
 12143426,
 -1,
 12714179,
 12617255,
 74198,
 -1,
 12667714,
 74199,
 -65340,
 12666261,
 74197,
 -1,
 12783930,
 74196,
 12976331,
 12598886,
 -1,
 13041866,
 12931612,
 74188,
 13172735,
 12977361,
 -1,
 -65335,
 13062594,
 74190,
 -1,
 13121720,
 74189,
 -1,
 12990231,
 74187,
 13369552,
 12924113,
 -1,
 13435086,
 13338554,
 74182,
 -1,
 13370629,
 74183,
 13631487,
 13373121,
 74180,
 -1,
 13528418,
 74181,
 13697237,
 13336085,
 -1,
 13762772,
 13635265,
 -1,
 -65325,
 13715596,
 74211,
 -1,
 13776081,
 74210,
 -1,
 13707499,
 74212,
 14024921,
 13652508,
 -1,
 14090456,
 13969538,
 74200,
 -1,
 14025980,
 74201,
 -1,
 14060340,
 74202,
 14287069,
 13973666,
 -1,
 14352604,
 14225089,
 74184,
 -1,
 14306114,
 74185,
 -1,
 14302877,
 74186,
 14549216,
 14227452,
 -1,
 -65313,
 14499430,
 74177,
 -1,
 14553166,
 74176,
 -65311,
 14506389,
 74203,
 -65310,
 14691332,
 74179,
 -1,
 14754727,
 74178,
 -1,
 10517368,
 74219,
 15073279,
 10382690,
 74220,
 15138815,
 14942208,
 -1,
 15139048,
 15041128,
 74221,
 -1,
 15074730,
 74222,
 15335423,
 15087735,
 74223,
 -1,
 15205427,
 74224,
 15401197,
 10310172,
 74228,
 15532031,
 15337299,
 74229,
 -1,
 15402372,
 74230,
 15597807,
 15354690,
 74226,
 -1,
 15533918,
 74227,
 -1,
 15547918,
 74225,
 15794464,
 10257959,
 74235,
 15859987,
 15731763,
 74237,
 15990783,
 15794176,
 -1,
 15991054,
 15891989,
 -1,
 16056589,
 15942078,
 -1,
 16122107,
 16009277,
 -1,
 16187642,
 16060494,
 -1,
 16253177,
 16125130,
 74246,
 -1,
 16188640,
 74247,
 -1,
 16190515,
 74245,
 -1,
 16137830,
 74248,
 16515326,
 16087148,
 -1,
 -65283,
 16468097,
 74255,
 -1,
 16516320,
 74254,
 16711937,
 16472165,
 -1,
 -65280,
 16680487,
 74253,
 -1,
 16722050,
 74252,
 16908548,
 16665456,
 -1,
 -65277,
 16856347,
 74250,
 -1,
 16909536,
 74249,
 17105158,
 16854625,
 74240,
 -1,
 17041077,
 74241,
 -65273,
 17073366,
 74256,
 -65272,
 17192163,
 74251,
 -65271,
 17252750,
 74244,
 -65270,
 17316595,
 74243,
 -65269,
 17380714,
 74242,
 -65268,
 17438792,
 74239,
 -1,
 17502750,
 74238,
 -1,
 16002300,
 74257,
 17760529,
 15955334,
 -1,
 -65264,
 17722559,
 74260,
 -1,
 17775263,
 74261,
 -65262,
 17719823,
 74259,
 -1,
 17900018,
 74258,
 18088217,
 15807813,
 74263,
 18219007,
 18022400,
 -1,
 18219288,
 18111711,
 -1,
 -65257,
 18189552,
 74264,
 -1,
 18246357,
 74265,
 -1,
 18184173,
 74266,
 18481436,
 18043420,
 74269,
 18612223,
 18416712,
 74270,
 -1,
 18481663,
 74271,
 -65251,
 18434882,
 74268,
 -65250,
 18626722,
 74267,
 -65249,
 18681034,
 74262,
 -1,
 18745082,
 74236,
 19005439,
 15744614,
 74231,
 -65246,
 18904861,
 74234,
 -65245,
 18962136,
 74233,
 -1,
 19024706,
 74232,
 19202457,
 10176573,
 -1,
 19267967,
 19140289,
 74071,
 19333481,
 19203800,
 -1,
 19398964,
 19281105,
 -1,
 19464493,
 19336897,
 74082,
 19530027,
 19426658,
 74085,
 -1,
 19465613,
 74086,
 -65236,
 19486899,
 74084,
 -1,
 19614530,
 74083,
 19792178,
 19414630,
 74087,
 19857713,
 19756832,
 -1,
 -65232,
 19818980,
 74089,
 -1,
 19866059,
 74090,
 -1,
 19819951,
 74088,
 20185087,
 19760679,
 74091,
 -1,
 20082109,
 74092,
 20250942,
 19363206,
 -1,
 20316474,
 20199586,
 -1,
 -65225,
 20284967,
 74115,
 -65224,
 20332481,
 74114,
 -65223,
 20392066,
 74113,
 -1,
 20451009,
 74112,
 20644156,
 20254401,
 74110,
 -1,
 20606306,
 74111,
 -65219,
 20613136,
 74117,
 -1,
 20725894,
 74116,
 20906310,
 20206108,
 -1,
 20971844,
 20850818,
 74100,
 21102591,
 20907217,
 -1,
 -65214,
 21004179,
 74103,
 -65213,
 21051156,
 74102,
 -1,
 21112843,
 74101,
 21364735,
 20921958,
 74104,
 -1,
 21235055,
 74105,
 21430603,
 20874791,
 74119,
 -65208,
 21395229,
 74123,
 -65207,
 21452774,
 74122,
 -65206,
 21504725,
 74121,
 -1,
 21564467,
 74120,
 21758289,
 21370876,
 -1,
 21823824,
 21696193,
 -1,
 -65202,
 21785954,
 74078,
 -65201,
 21842877,
 74077,
 -1,
 21897941,
 74076,
 -1,
 21773926,
 74079,
 22151509,
 21696193,
 74072,
 22217044,
 22094549,
 74073,
 -1,
 22152479,
 74074,
 -1,
 22181720,
 74075,
 22413657,
 22104125,
 -1,
 22479192,
 22363750,
 74096,
 -1,
 22422229,
 74097,
 -1,
 22417918,
 74095,
 22675804,
 22370405,
 -1,
 -65189,
 22644942,
 74107,
 -1,
 22685826,
 74106,
 22872415,
 22629186,
 -1,
 -65186,
 22840871,
 74099,
 -1,
 22888038,
 74098,
 23069026,
 22822502,
 -1,
 -65183,
 23024156,
 74094,
 -1,
 23082772,
 74093,
 23265637,
 23013506,
 -1,
 -65180,
 23230296,
 74081,
 -1,
 23294689,
 74080,
 -65178,
 23238414,
 74124,
 -65177,
 23428966,
 74118,
 -65176,
 23491849,
 74109,
 -1,
 23554327,
 74108,
 23724399,
 19276501,
 -1,
 23789932,
 23661936,
 74131,
 -1,
 23725083,
 74132,
 -65171,
 23727410,
 74130,
 -65170,
 23858378,
 74129,
 -1,
 23923763,
 74128,
 24117619,
 23689577,
 74140,
 24248319,
 24051712,
 -1,
 -65166,
 24143295,
 74142,
 -1,
 24202183,
 74141,
 24379767,
 24070978,
 74135,
 24510463,
 24313856,
 -1,
 -65162,
 24412756,
 74136,
 -1,
 24453605,
 74137,
 24641914,
 24334876,
 -1,
 -65159,
 24579378,
 74139,
 -1,
 24644659,
 74138,
 24838524,
 24594493,
 74133,
 -1,
 24774453,
 74134,
 24969598,
 24775731,
 74125,
 -1,
 24904041,
 74126,
 -1,
 24909820,
 74127,
 25166219,
 19236391,
 74154,
 25231746,
 25128290,
 74163,
 -1,
 25166738,
 74164,
 25362820,
 25185090,
 74160,
 -1,
 25297427,
 74161,
 25493894,
 25300274,
 74157,
 -1,
 25429904,
 74158,
 -65145,
 25458786,
 74165,
 -65144,
 25581669,
 74162,
 -65143,
 25628183,
 74159,
 -65142,
 25693386,
 74156,
 -1,
 25756626,
 74155,
 25952663,
 25116262,
 74144,
 26018193,
 25916806,
 -1,
 26083727,
 25969041,
 74152,
 -1,
 26018854,
 74153,
 -65136,
 26032290,
 74151,
 -1,
 26153502,
 74150,
 26345877,
 25954008,
 -1,
 26411412,
 26314279,
 74146,
 -1,
 26354389,
 74147,
 -1,
 26351688,
 74145,
 -65130,
 26302565,
 74149,
 -1,
 26550997,
 74148,
 -65128,
 25924455,
 74166,
 -1,
 26685025,
 74143,
 26870272,
 19166598,
 -1,
 26935761,
 26818722,
 -1,
 27001268,
 26885734,
 -1,
 27066794,
 26956316,
 74438,
 27197439,
 27002584,
 -1,
 27197856,
 27083015,
 74444,
 -1,
 27132435,
 74445,
 27328931,
 27138044,
 -1,
 -65118,
 27297920,
 74441,
 -1,
 27333150,
 74440,
 -65116,
 27293173,
 74449,
 -65115,
 27482053,
 74448,
 -65114,
 27546073,
 74447,
 -65113,
 27609877,
 74446,
 -65112,
 27669905,
 74443,
 -65111,
 27731218,
 74442,
 -1,
 27791041,
 74439,
 27984302,
 27028834,
 74451,
 28114943,
 27918336,
 -1,
 -65107,
 28016714,
 74452,
 -1,
 28075548,
 74453,
 28246450,
 27927253,
 74435,
 28377087,
 28182232,
 -1,
 -65103,
 28262798,
 74437,
 -1,
 28315329,
 74436,
 -65101,
 28212875,
 74454,
 -1,
 28465787,
 74450,
 28639682,
 26939073,
 74413,
 28705215,
 28576970,
 74414,
 28835839,
 28640984,
 -1,
 28836281,
 28739111,
 74421,
 -1,
 28771544,
 74422,
 -65094,
 28804364,
 74420,
 -65093,
 28932194,
 74419,
 -65092,
 28989845,
 74418,
 -65091,
 29046626,
 74417,
 -65090,
 29104200,
 74416,
 -1,
 29167297,
 74415,
 -65088,
 28667311,
 74425,
 -65087,
 29300778,
 74424,
 -1,
 29363677,
 74423,
 29557197,
 28584066,
 74426,
 29622726,
 29521693,
 74432,
 -65083,
 29576204,
 74434,
 -1,
 29625395,
 74433,
 29819339,
 29556736,
 -1,
 29884874,
 29779474,
 -1,
 -65079,
 29851297,
 74429,
 -1,
 29898019,
 74428,
 -1,
 29834771,
 74427,
 -65076,
 29775973,
 74431,
 -1,
 30094592,
 74430,
 30343167,
 29525543,
 74455,
 -65073,
 30219156,
 74458,
 -65072,
 30280755,
 74457,
 -1,
 30344200,
 74456,
 30540272,
 26873537,
 74387,
 30605804,
 30487761,
 74389,
 30736383,
 30539776,
 -1,
 30736873,
 30638669,
 -1,
 30802395,
 30705191,
 -1,
 -65065,
 30766877,
 74406,
 -65064,
 30829922,
 74405,
 -65063,
 30888476,
 74404,
 -65062,
 30939132,
 74403,
 -1,
 31001651,
 74402,
 31195614,
 30766470,
 -1,
 -65059,
 31144704,
 74400,
 -1,
 31199774,
 74399,
 31392225,
 31148093,
 -1,
 -65056,
 31361693,
 74395,
 -1,
 31396350,
 74394,
 31588835,
 31336459,
 74391,
 -1,
 31528956,
 74392,
 -65052,
 31555229,
 74401,
 -65051,
 31677530,
 74398,
 -65050,
 31741445,
 74397,
 -65049,
 31805917,
 74396,
 -65048,
 31865016,
 74393,
 -1,
 31919809,
 74390,
 -65046,
 30696969,
 74407,
 -65045,
 32070772,
 74388,
 -1,
 32127095,
 74408,
 32309742,
 30559042,
 74409,
 -1,
 32244376,
 74410,
 -65041,
 32271714,
 74412,
 -1,
 32397894,
 74411,
 32571897,
 30508583,
 74466,
 32637427,
 32533858,
 74473,
 -1,
 32575114,
 74474,
 32768501,
 32592412,
 74471,
 -1,
 32708120,
 74472,
 32899575,
 32711381,
 74468,
 -1,
 32836659,
 74469,
 -65032,
 32849474,
 74470,
 -1,
 32965791,
 74467,
 33226751,
 32521830,
 74459,
 33227261,
 33109201,
 74461,
 33357823,
 33164594,
 74462,
 -1,
 33227919,
 74463,
 -65026,
 33180540,
 74465,
 -65025,
 33376382,
 74464,
 -1,
 33423891,
 74460,
 33620580,
 26838567,
 74507,
 33686068,
 33582434,
 74536,
 33751585,
 33654311,
 74551,
 33817119,
 33687256,
 -1,
 33882634,
 33764561,
 -1,
 33948169,
 33820353,
 74556,
 -65017,
 33910114,
 74559,
 -65016,
 33970355,
 74558,
 -1,
 34032450,
 74557,
 -1,
 33916455,
 74560,
 34275854,
 33850919,
 -1,
 -65012,
 34239761,
 74574,
 -65011,
 34284245,
 74573,
 -1,
 34342149,
 74572,
 34538002,
 34225766,
 -1,
 -65008,
 34502429,
 74564,
 -65007,
 34558492,
 74563,
 -1,
 34617108,
 74562,
 34800149,
 34502022,
 -1,
 -65004,
 34750608,
 74570,
 -1,
 34814490,
 74569,
 34996759,
 34737857,
 74552,
 -1,
 34961397,
 74553,
 -65000,
 34964687,
 74571,
 -64999,
 35088186,
 74568,
 -64998,
 35149426,
 74567,
 -64997,
 35213789,
 74566,
 -64996,
 35277360,
 74565,
 -64995,
 35338424,
 74561,
 -64994,
 35399725,
 74555,
 -1,
 35461257,
 74554,
 35717119,
 33760050,
 74575,
 -1,
 35587956,
 74576,
 35783214,
 33688627,
 74539,
 35913727,
 35718872,
 -1,
 35914279,
 35817095,
 74545,
 36044799,
 35849425,
 -1,
 -64986,
 35920310,
 74547,
 -1,
 35984920,
 74546,
 36176428,
 35851969,
 -1,
 36241963,
 36111569,
 -1,
 -64982,
 36198587,
 74541,
 -1,
 36255928,
 74540,
 -1,
 36195138,
 74542,
 -64979,
 36133978,
 74544,
 -1,
 36452536,
 74543,
 36635184,
 35733094,
 74549,
 -1,
 36572362,
 74550,
 36766259,
 36569088,
 -1,
 -64974,
 36730861,
 74538,
 -1,
 36774438,
 74537,
 -1,
 36703538,
 74548,
 37028416,
 33628885,
 74515,
 37093951,
 36962304,
 -1,
 37159483,
 37061197,
 -1,
 37225017,
 37127740,
 74519,
 -1,
 37159443,
 74520,
 -64966,
 37180933,
 74518,
 -1,
 37296200,
 74517,
 37487165,
 37124077,
 74522,
 -1,
 37422842,
 74523,
 -64962,
 37440277,
 74516,
 -1,
 37566583,
 74521,
 -1,
 37062654,
 74524,
 37814859,
 36983324,
 74525,
 37880390,
 37750488,
 -1,
 -64957,
 37848615,
 74529,
 -64956,
 37910368,
 74528,
 -64955,
 37967064,
 74527,
 -1,
 38030273,
 74526,
 38208074,
 37849221,
 74531,
 38338559,
 38143704,
 -1,
 -64951,
 38233914,
 74533,
 -1,
 38291752,
 74532,
 -1,
 38148591,
 74530,
 38535764,
 37779229,
 74577,
 38601297,
 38471384,
 -1,
 38666831,
 38554378,
 74579,
 -1,
 38628706,
 74580,
 -64944,
 38633217,
 74581,
 -1,
 38735553,
 74578,
 -64942,
 38572923,
 74582,
 -64941,
 38897866,
 74584,
 -1,
 38931507,
 74583,
 39125595,
 38469632,
 -1,
 39191129,
 39085663,
 -1,
 -64937,
 39159372,
 74512,
 -64936,
 39222639,
 74511,
 -1,
 39282507,
 74510,
 -64934,
 39159399,
 74509,
 -1,
 39401571,
 74508,
 39584351,
 39097871,
 -1,
 39649886,
 39521482,
 74586,
 -1,
 39585605,
 74587,
 -1,
 39618087,
 74588,
 39846497,
 39540837,
 74534,
 -1,
 39780883,
 74535,
 -64926,
 39814397,
 74585,
 -64925,
 39917564,
 74514,
 -1,
 39980083,
 74513,
 40174259,
 33558209,
 73728,
 40239740,
 40114172,
 73738,
 40305269,
 40173568,
 -1,
 40370804,
 40272461,
 -1,
 40436331,
 40320614,
 -1,
 -64918,
 40392306,
 73745,
 -1,
 40449815,
 73744,
 40632942,
 40383747,
 -1,
 -64915,
 40589491,
 73742,
 -1,
 40651586,
 73741,
 -64913,
 40601148,
 73748,
 -64912,
 40794087,
 73747,
 -64911,
 40848321,
 73746,
 -64910,
 40908984,
 73743,
 -64909,
 40970289,
 73740,
 -1,
 41031196,
 73739,
 -1,
 40319095,
 73749,
 41353215,
 40242227,
 73750,
 41418751,
 41223896,
 -1,
 -64904,
 41320193,
 73755,
 -64903,
 41383776,
 73754,
 -64902,
 41440483,
 73753,
 -64901,
 41497962,
 73752,
 -1,
 41556065,
 73751,
 41747081,
 40192834,
 73760,
 41812615,
 41682648,
 -1,
 41878145,
 41764925,
 -1,
 -64896,
 41827942,
 73766,
 -1,
 41881681,
 73765,
 -64894,
 41847604,
 73768,
 -64893,
 42039242,
 73767,
 -64892,
 42088632,
 73764,
 -64891,
 42153826,
 73763,
 -64890,
 42214669,
 73762,
 -1,
 42275358,
 73761,
 -64888,
 41758018,
 73770,
 -1,
 42406702,
 73769,
 42599061,
 41710982,
 -1,
 42664596,
 42547362,
 73784,
 42730130,
 42598400,
 -1,
 42795664,
 42689858,
 -1,
 42861199,
 42755385,
 73788,
 -1,
 42795309,
 73789,
 -1,
 42829019,
 73787,
 -64879,
 42768145,
 73785,
 -1,
 43010236,
 73786,
 -64877,
 42677531,
 73791,
 -1,
 43125811,
 73790,
 -1,
 42603077,
 73783,
 43385502,
 42534616,
 -1,
 -64873,
 43349485,
 73736,
 -64872,
 43407400,
 73735,
 -64871,
 43469800,
 73734,
 -64870,
 43532551,
 73733,
 -64869,
 43595960,
 73732,
 -64868,
 43660650,
 73731,
 -64867,
 43718728,
 73730,
 -1,
 43781825,
 73729,
 43975334,
 43341925,
 73773,
 44040869,
 43909120,
 -1,
 44106403,
 44001753,
 -1,
 -64862,
 44071800,
 73777,
 -1,
 44130785,
 73776,
 -64860,
 44073375,
 73775,
 -1,
 44262705,
 73774,
 -1,
 44005322,
 73778,
 44499626,
 43937122,
 -1,
 44565161,
 44437582,
 73780,
 -1,
 44500819,
 73781,
 -1,
 44517560,
 73782,
 44761774,
 44451901,
 73757,
 44892159,
 44697304,
 -1,
 -64851,
 44791817,
 73759,
 -1,
 44838389,
 73758,
 45023920,
 44717023,
 73771,
 -1,
 44959593,
 73772,
 -64847,
 44984662,
 73779,
 -64846,
 45097685,
 73756,
 -1,
 45157427,
 73737,
 45351677,
 40130661,
 -1,
 45417169,
 45319719,
 74337,
 45482704,
 45373541,
 74339,
 45548229,
 45452205,
 74349,
 45678591,
 45481984,
 -1,
 45679299,
 45551455,
 -1,
 -64838,
 45647495,
 74359,
 -64837,
 45709483,
 74358,
 -64836,
 45767061,
 74357,
 -64835,
 45828976,
 74356,
 -64834,
 45893834,
 74355,
 -64833,
 45957387,
 74354,
 -64832,
 46020707,
 74353,
 -64831,
 46082089,
 74352,
 -64830,
 46143926,
 74351,
 -1,
 46208545,
 74350,
 46465023,
 45632091,
 74360,
 -1,
 46335885,
 74361,
 46596095,
 45481984,
 -1,
 46596812,
 46484467,
 -1,
 46662345,
 46560757,
 74342,
 -1,
 46597237,
 74343,
 -64822,
 46631732,
 74344,
 -64821,
 46748726,
 74341,
 -1,
 46806417,
 74340,
 46990030,
 46539277,
 74347,
 -1,
 46924458,
 74348,
 -64817,
 46956618,
 74345,
 -1,
 47080960,
 74346,
 -1,
 45419541,
 74338,
 47317740,
 45366886,
 74316,
 47383269,
 47274319,
 74322,
 47513599,
 47318744,
 -1,
 47514329,
 47413194,
 74330,
 47644671,
 47449304,
 -1,
 47645400,
 47544093,
 74332,
 -1,
 47580384,
 74333,
 -1,
 47579190,
 74331,
 47842013,
 47451841,
 -1,
 47907548,
 47806237,
 74324,
 -1,
 47842528,
 74325,
 -1,
 47863909,
 74323,
 48104160,
 47810087,
 -1,
 -64801,
 48068381,
 74335,
 -1,
 48106593,
 74334,
 48300771,
 48060517,
 -1,
 -64798,
 48269518,
 74329,
 -1,
 48310402,
 74328,
 -64796,
 48256238,
 74327,
 -1,
 48445539,
 74326,
 48628457,
 47338012,
 74319,
 48758783,
 48563994,
 -1,
 -64792,
 48655734,
 74321,
 -1,
 48715955,
 74320,
 -64790,
 48592365,
 74336,
 -64789,
 48827443,
 74318,
 -1,
 48891653,
 74317,
 49087223,
 47255233,
 74302,
 49152755,
 49034499,
 74304,
 49218290,
 49086464,
 -1,
 -64784,
 49185394,
 74306,
 -64783,
 49242652,
 74307,
 -1,
 49300545,
 74305,
 -1,
 49180002,
 74308,
 49545974,
 49107484,
 74310,
 -64779,
 49482803,
 74311,
 -1,
 49546086,
 74309,
 -1,
 49482803,
 74303,
 49872895,
 49031298,
 74312,
 49938431,
 49741824,
 -1,
 49939196,
 49840717,
 -1,
 -64773,
 49907642,
 74314,
 -1,
 49942209,
 74313,
 -1,
 49903597,
 74315,
 50201403,
 45294293,
 -1,
 50266914,
 50138817,
 73813,
 50332445,
 50214097,
 73814,
 50462719,
 50266755,
 -1,
 50463495,
 50345169,
 -1,
 50529028,
 50413158,
 73821,
 -1,
 50490799,
 73822,
 50660102,
 50466497,
 73819,
 -1,
 50595160,
 73820,
 -1,
 50628538,
 73823,
 50856716,
 50416450,
 -1,
 50922251,
 50824743,
 73829,
 -64758,
 50876956,
 73831,
 -1,
 50922851,
 73830,
 -1,
 50859713,
 73828,
 51184399,
 50824743,
 -1,
 -64754,
 51148573,
 73837,
 -1,
 51186807,
 73836,
 51381009,
 51135767,
 73825,
 -1,
 51316028,
 73826,
 51512084,
 51320828,
 -1,
 -64749,
 51461734,
 73818,
 -1,
 51515982,
 73817,
 51708695,
 51449537,
 -1,
 -64746,
 51663839,
 73816,
 -1,
 51709272,
 73815,
 -64744,
 51674881,
 73835,
 -64743,
 51869804,
 73834,
 -64742,
 51931077,
 73833,
 -64741,
 51992981,
 73832,
 -64740,
 52054242,
 73827,
 -1,
 52115640,
 73824,
 52298529,
 50294114,
 73839,
 52428799,
 52235969,
 -1,
 -64736,
 52301106,
 73841,
 -1,
 52366538,
 73840,
 -1,
 52253212,
 73838,
 52626227,
 50234919,
 73850,
 52691752,
 52582501,
 73860,
 52757287,
 52628682,
 73861,
 52887551,
 52691475,
 73862,
 -1,
 52757011,
 73863,
 -1,
 52694322,
 73864,
 53019435,
 52631548,
 73854,
 -64726,
 52956211,
 73856,
 -1,
 53020430,
 73855,
 53216047,
 52953088,
 -1,
 -64723,
 53180397,
 73853,
 -64722,
 53241173,
 73851,
 -1,
 53295223,
 73852,
 53478193,
 53163217,
 73857,
 -1,
 53446586,
 73858,
 -64718,
 53439919,
 73865,
 -1,
 53557410,
 73859,
 53805055,
 52575846,
 73842,
 53805879,
 53695004,
 73844,
 -64714,
 53742643,
 73846,
 -1,
 53806953,
 73845,
 54002489,
 53762149,
 73847,
 -1,
 53936736,
 73848,
 -64710,
 53966621,
 73849,
 -1,
 54073340,
 73843,
 54264688,
 50145410,
 73866,
 54330196,
 54236819,
 73889,
 54460415,
 54265560,
 -1,
 54461251,
 54348610,
 -1,
 54526785,
 54398657,
 73903,
 -1,
 54479684,
 73904,
 -64702,
 54494759,
 73906,
 -1,
 54607462,
 73905,
 54788935,
 54398657,
 73890,
 54854470,
 54723890,
 73891,
 -1,
 54789982,
 73892,
 -1,
 54810725,
 73893,
 55051083,
 54741053,
 -1,
 55116618,
 54990376,
 73900,
 -1,
 55051881,
 73901,
 -1,
 55084682,
 73902,
 55313230,
 55019047,
 -1,
 -64691,
 55255765,
 73908,
 -1,
 55315507,
 73907,
 55509840,
 55261368,
 73897,
 -1,
 55443987,
 73898,
 55640914,
 55453745,
 73895,
 -1,
 55575059,
 73896,
 -64685,
 55591179,
 73899,
 -1,
 55711816,
 73894,
 55903069,
 54286437,
 73879,
 56033279,
 55836672,
 -1,
 56034138,
 55935565,
 -1,
 56099673,
 55981413,
 73880,
 -1,
 56034997,
 73881,
 -1,
 56054988,
 73882,
 -64677,
 55999352,
 73885,
 -64676,
 56254967,
 73884,
 -1,
 56304024,
 73883,
 56492902,
 55839795,
 73869,
 56623103,
 56428248,
 -1,
 56623970,
 56522118,
 -1,
 -64671,
 56572442,
 73874,
 -1,
 56627742,
 73873,
 -64669,
 56591911,
 73875,
 -64668,
 56776197,
 73872,
 -64667,
 56833425,
 73871,
 -1,
 56889053,
 73870,
 57082729,
 56454498,
 -1,
 -64664,
 57033209,
 73887,
 -1,
 57093124,
 73886,
 57279340,
 57016320,
 -1,
 -64661,
 57246302,
 73867,
 -1,
 57304413,
 73868,
 -64659,
 57243480,
 73888,
 -64658,
 57428802,
 73878,
 -64657,
 57489246,
 73877,
 -1,
 57550098,
 73876,
 57738135,
 54230549,
 -1,
 57803655,
 57675457,
 74475,
 57869179,
 57750737,
 74483,
 57999359,
 57804504,
 -1,
 58000247,
 57898781,
 -1,
 -64650,
 57968167,
 74487,
 -1,
 58009730,
 74486,
 -64648,
 57968570,
 74489,
 -64647,
 58164438,
 74488,
 -64646,
 58210403,
 74485,
 -1,
 58268086,
 74484,
 58459009,
 57802752,
 -1,
 58524543,
 58425933,
 -1,
 -64642,
 58480133,
 74478,
 -1,
 58538730,
 74477,
 -64640,
 58472567,
 74479,
 -1,
 58660450,
 74476,
 58852229,
 58398716,
 74480,
 58982399,
 58785792,
 -1,
 -64636,
 58882936,
 74482,
 -1,
 58943027,
 74481,
 -64634,
 58813794,
 74491,
 -1,
 59066508,
 74490,
 59245455,
 57753190,
 74494,
 59310989,
 59207010,
 74497,
 59441151,
 59244544,
 -1,
 59442060,
 59336278,
 74499,
 -1,
 59376100,
 74500,
 -1,
 59409025,
 74498,
 -64626,
 59263810,
 74496,
 -1,
 59573941,
 74495,
 59769749,
 59213351,
 74501,
 59835282,
 59731298,
 74505,
 -1,
 59770024,
 74506,
 -64621,
 59789852,
 74504,
 -64620,
 59918397,
 74503,
 -1,
 59979002,
 74502,
 60227583,
 59713666,
 74492,
 -1,
 60097043,
 74493,
 60294075,
 57692700,
 -1,
 60359598,
 60261927,
 74284,
 60425129,
 60323613,
 74290,
 60490658,
 60358656,
 -1,
 60556191,
 60457549,
 -1,
 -64611,
 60528159,
 74293,
 -64610,
 60574481,
 74292,
 -1,
 60624577,
 74291,
 60818337,
 60515830,
 74294,
 -1,
 60753641,
 74295,
 -1,
 60760575,
 74296,
 61079551,
 60427466,
 74297,
 61145087,
 60948480,
 -1,
 61146024,
 61047373,
 -1,
 61211559,
 61083329,
 74298,
 -1,
 61146346,
 74299,
 -1,
 61154437,
 74300,
 -1,
 61094007,
 74301,
 61473707,
 60372177,
 74286,
 -1,
 61407763,
 74287,
 -64596,
 61436200,
 74289,
 -64595,
 61561752,
 74288,
 -1,
 61604962,
 74285,
 61801399,
 60296897,
 74272,
 61866929,
 61765405,
 74278,
 -1,
 61803571,
 74279,
 61998004,
 61800448,
 -1,
 -64589,
 61964929,
 74273,
 -1,
 62011511,
 74274,
 -64587,
 61959522,
 74277,
 -64586,
 62142626,
 74276,
 -1,
 62196787,
 74275,
 62391225,
 61750886,
 74282,
 -1,
 62347365,
 74283,
 62586879,
 62335106,
 74280,
 -1,
 62485894,
 74281,
 62653398,
 60243558,
 74047,
 62718915,
 62607900,
 74062,
 62784450,
 62652416,
 -1,
 -64577,
 62751361,
 74063,
 -64576,
 62815096,
 74066,
 -64575,
 62874115,
 74065,
 -1,
 62923225,
 74064,
 -1,
 62734824,
 74067,
 63177674,
 62665937,
 74053,
 63307775,
 63127142,
 74054,
 63373311,
 63176704,
 -1,
 -64569,
 63271240,
 74056,
 -64568,
 63333788,
 74057,
 -64567,
 63387767,
 74058,
 -1,
 63448287,
 74055,
 63636429,
 63130434,
 74059,
 -64564,
 63573043,
 74061,
 -1,
 63637284,
 74060,
 63833041,
 63579401,
 74050,
 63963135,
 63767548,
 -1,
 -64560,
 63863672,
 74052,
 -1,
 63904660,
 74051,
 -64558,
 63797021,
 74070,
 -64557,
 64056674,
 74069,
 -64556,
 64116837,
 74068,
 -64555,
 64165884,
 74049,
 -1,
 64225282,
 74048,
 64422896,
 62601378,
 -1,
 64488418,
 64372326,
 74029,
 64618495,
 64423640,
 -1,
 64619483,
 64493080,
 74030,
 -1,
 64556083,
 74031,
 -64548,
 64587303,
 74038,
 -64547,
 64714698,
 74037,
 -64546,
 64773210,
 74036,
 -64545,
 64834104,
 74035,
 -64544,
 64894239,
 74034,
 -64543,
 64955726,
 74033,
 -1,
 65017928,
 74032,
 65209323,
 64456231,
 74039,
 65274858,
 65148946,
 74040,
 65404927,
 65210072,
 -1,
 -64538,
 65308602,
 74045,
 -64537,
 65359785,
 74044,
 -64536,
 65423656,
 74043,
 -64535,
 65485051,
 74042,
 -1,
 65540910,
 74041,
 -1,
 65227629,
 74046,
 65863679,
 65146561,
 74025,
 65864687,
 65732608,
 -1,
 -64530,
 65830986,
 74026,
 -1,
 65878135,
 74027,
 -1,
 65817410,
 74028,
 66126859,
 64382715,
 -1,
 66192390,
 66076262,
 74367,
 66257919,
 66125824,
 -1,
 66323454,
 66224717,
 -1,
 66388982,
 66291239,
 74375,
 -1,
 66325555,
 74376,
 66520056,
 66338406,
 74373,
 -1,
 66459644,
 74374,
 66651131,
 66459644,
 -1,
 -64518,
 66618919,
 74371,
 -1,
 66666086,
 74370,
 66847741,
 66588353,
 74368,
 -1,
 66787324,
 74369,
 -1,
 66791554,
 74372,
 -1,
 66265626,
 74377,
 67174399,
 66220499,
 74378,
 67239935,
 67043328,
 -1,
 67240965,
 67142221,
 -1,
 -64509,
 67212831,
 74381,
 -64508,
 67274682,
 74380,
 -1,
 67324139,
 74379,
 -1,
 67199530,
 74382,
 67568650,
 66129601,
 74362,
 -64504,
 67528443,
 74365,
 -64503,
 67590245,
 74364,
 -1,
 67642069,
 74363,
 -1,
 67513953,
 74366,
 67896356,
 66066428,
 -1,
 67961877,
 67833537,
 73792,
 68027408,
 67914562,
 73796,
 -64497,
 67965239,
 73798,
 -1,
 68027301,
 73797,
 68224018,
 67988834,
 73799,
 -1,
 68161328,
 73800,
 -64493,
 68172227,
 73795,
 -64492,
 68302077,
 73794,
 -1,
 68362965,
 73793,
 68551711,
 67929639,
 73805,
 68617243,
 68485120,
 -1,
 68682778,
 68576588,
 -1,
 -64487,
 68651214,
 73807,
 -1,
 68685660,
 73806,
 -1,
 68624780,
 73808,
 68944925,
 68578658,
 73811,
 -1,
 68881459,
 73812,
 69140479,
 68899285,
 73809,
 -1,
 69010351,
 73810,
 69271551,
 68501094,
 73801,
 69337087,
 69142232,
 -1,
 -64478,
 69222667,
 73804,
 -64477,
 69285265,
 73803,
 -1,
 69340865,
 73802,
 69534776,
 67868175,
 -1,
 69600300,
 69484134,
 74595,
 69665832,
 69539836,
 74598,
 -1,
 69599822,
 74599,
 -64471,
 69637660,
 74601,
 -64470,
 69743825,
 74600,
 -64469,
 69799114,
 74597,
 -1,
 69862589,
 74596,
 70059057,
 69568039,
 74602,
 70124591,
 69995888,
 74603,
 -1,
 70059744,
 74604,
 -64464,
 70079004,
 74606,
 -1,
 70196116,
 74605,
 70386743,
 69996225,
 74589,
 70452277,
 70320128,
 -1,
 -64460,
 70418506,
 74590,
 -1,
 70482825,
 74591,
 -64458,
 70408265,
 74593,
 -1,
 70595793,
 74592,
 -1,
 70330735,
 74594,
 70909951,
 69496162,
 -1,
 70911035,
 70782657,
 74383,
 -1,
 70850556,
 74384,
 -64452,
 70878759,
 74386,
 -1,
 70991462,
 74385,
 71173320,
 220236,
 -1,
 71238756,
 71119198,
 -1,
 71304275,
 71197814,
 -1,
 71369797,
 71273545,
 74812,
 71435332,
 71303168,
 -1,
 -64445,
 71374844,
 74815,
 -1,
 71438017,
 74814,
 -1,
 71372082,
 74813,
 71697481,
 71309308,
 -1,
 71763016,
 71635761,
 74834,
 -1,
 71698320,
 74835,
 -1,
 71731995,
 74808,
 71959628,
 71661491,
 -1,
 -64437,
 71927335,
 74800,
 -1,
 71961651,
 74790,
 72156239,
 71906934,
 -1,
 -64434,
 72123943,
 74785,
 -1,
 72158259,
 74776,
 72352849,
 72095256,
 74754,
 -1,
 72287925,
 74828,
 -64430,
 72320551,
 74767,
 -1,
 72426830,
 74761,
 72679423,
 71255699,
 -1,
 72680537,
 72578438,
 -1,
 72746072,
 72628671,
 -1,
 -64425,
 72713767,
 74801,
 -1,
 72748083,
 74791,
 -1,
 72697591,
 74844,
 73008221,
 72620028,
 -1,
 73073756,
 72946481,
 74836,
 -1,
 73009040,
 74837,
 -1,
 73042715,
 74809,
 73270368,
 72955510,
 -1,
 -64417,
 73238055,
 74786,
 -1,
 73272371,
 74777,
 73466978,
 73209368,
 74755,
 -1,
 73402037,
 74829,
 -64413,
 73434663,
 74768,
 -1,
 73540942,
 74762,
 73729160,
 71204373,
 -1,
 73794680,
 73678186,
 -1,
 73860203,
 73758643,
 -1,
 73925737,
 73827879,
 74798,
 -1,
 73861008,
 74799,
 74121215,
 73862195,
 74788,
 -1,
 73992080,
 74789,
 74187887,
 73799676,
 -1,
 74253422,
 74156827,
 74806,
 -1,
 74188688,
 74807,
 -1,
 74191665,
 74833,
 74450034,
 74157074,
 -1,
 -64399,
 74386604,
 74811,
 -1,
 74452000,
 74810,
 74646645,
 74397302,
 -1,
 -64396,
 74614311,
 74784,
 -1,
 74648627,
 74775,
 74843255,
 74585624,
 74753,
 -1,
 74778293,
 74827,
 -1,
 74786126,
 74760,
 75104255,
 73765489,
 -1,
 75105404,
 75006267,
 -1,
 -64389,
 75074545,
 74846,
 -1,
 75113806,
 74843,
 75302015,
 75069363,
 -1,
 -64386,
 75269671,
 74797,
 -1,
 75303987,
 74787,
 75498626,
 75249270,
 -1,
 -64383,
 75466279,
 74783,
 -1,
 75500595,
 74774,
 75695237,
 75438076,
 -1,
 -64380,
 75664155,
 74805,
 -1,
 75698993,
 74832,
 75891847,
 75634200,
 74752,
 -1,
 75826869,
 74826,
 -1,
 75837030,
 74841,
 76088479,
 73692550,
 -1,
 76154004,
 76033932,
 -1,
 76219535,
 76123191,
 -1,
 76285070,
 76152832,
 -1,
 -64371,
 76224508,
 74819,
 -1,
 76287681,
 74818,
 -1,
 76221642,
 74817,
 -64368,
 76187175,
 74770,
 -64367,
 76511160,
 74793,
 -64366,
 76559995,
 74779,
 -64365,
 76621134,
 74764,
 -1,
 76682776,
 74757,
 76874908,
 76105443,
 -1,
 76940439,
 76813848,
 74756,
 -1,
 76875445,
 74830,
 -64360,
 76909568,
 74816,
 -64359,
 77039143,
 74769,
 -64358,
 77100984,
 74792,
 -64357,
 77149819,
 74778,
 -1,
 77210958,
 74763,
 77463551,
 76822984,
 -1,
 -64354,
 77354610,
 74803,
 -1,
 77407566,
 74802,
 77595826,
 76045535,
 -1,
 77661359,
 77552024,
 -1,
 77726884,
 77627686,
 -1,
 -64349,
 77695985,
 74845,
 -1,
 77735246,
 74842,
 77923495,
 77674102,
 -1,
 -64346,
 77891111,
 74782,
 -1,
 77925427,
 74773,
 78120106,
 77867138,
 -1,
 -64343,
 78084046,
 74840,
 -1,
 78135549,
 74847,
 78316717,
 78059516,
 -1,
 -64340,
 78285595,
 74804,
 -1,
 78320433,
 74831,
 -64338,
 78280644,
 74796,
 -1,
 78474446,
 74848,
 78708735,
 77614271,
 -1,
 -64335,
 78608716,
 74849,
 -1,
 78671046,
 74850,
 78841024,
 77552226,
 -1,
 78906557,
 78797208,
 -1,
 78972088,
 78875683,
 74822,
 -64330,
 78908722,
 74824,
 -64329,
 78974154,
 74823,
 -1,
 79036418,
 74825,
 -64327,
 78939687,
 74772,
 -64326,
 79198136,
 74795,
 -64325,
 79246971,
 74781,
 -64324,
 79308110,
 74766,
 -1,
 79369752,
 74759,
 79626239,
 78853939,
 -1,
 -64321,
 79517298,
 74838,
 -1,
 79572573,
 74839,
 79822847,
 78785346,
 -1,
 79824067,
 79727708,
 74820,
 -1,
 79760586,
 74821,
 -64316,
 79791655,
 74771,
 -64315,
 79919032,
 74794,
 -64314,
 79967867,
 74780,
 -64313,
 80029006,
 74765,
 -1,
 80090648,
 74758,
 80347135,
 71134176,
 -1,
 80348364,
 80225454,
 -1,
 -64309,
 80315444,
 74867,
 -1,
 80355370,
 74866,
 -64307,
 80317783,
 74865,
 -1,
 80502487,
 74864,
 80676051,
 159074,
 -1,
 80741586,
 80637282,
 -1,
 -64303,
 80712753,
 127835,
 -1,
 80751721,
 128177,
 -1,
 80695828,
 10160,
 81003734,
 80641022,
 -1,
 -64299,
 80961410,
 128707,
 -1,
 81007897,
 127854,
 -1,
 80963338,
 9982,
 81266288,
 89311,
 -1,
 81331608,
 81220709,
 -1,
 81397016,
 81271757,
 -1,
 81462551,
 81368555,
 -1,
 81528078,
 81415753,
 -1,
 81593571,
 81471618,
 -1,
 81659103,
 81556870,
 11757,
 -1,
 81595156,
 11765,
 -64288,
 81620322,
 11756,
 -64287,
 81746021,
 11753,
 -64286,
 81809948,
 11752,
 -1,
 81873730,
 11751,
 82052329,
 81542758,
 42613,
 82117864,
 82011056,
 -1,
 -64282,
 82061442,
 42655,
 -64281,
 82123228,
 11775,
 -1,
 82185921,
 11772,
 -1,
 82061442,
 11767,
 82445550,
 82023471,
 -1,
 -64277,
 82413095,
 11771,
 -64276,
 82460262,
 42614,
 -64275,
 82521629,
 42617,
 -1,
 82581099,
 11770,
 82773235,
 82408838,
 -1,
 82838770,
 82720930,
 -1,
 -64271,
 82779575,
 11763,
 -1,
 82841281,
 11762,
 -1,
 82796042,
 42618,
 83100918,
 82744847,
 -1,
 -64267,
 83048986,
 11748,
 -1,
 83110018,
 11749,
 83297528,
 83068455,
 42615,
 -1,
 83249901,
 42612,
 83428603,
 83262997,
 -1,
 -64262,
 83392123,
 11760,
 -1,
 83437698,
 11758,
 83625213,
 83385567,
 11754,
 -1,
 83580253,
 42619,
 83756287,
 83572920,
 11759,
 -1,
 83717976,
 42616,
 83887362,
 83698389,
 -1,
 -64255,
 83838897,
 11768,
 -1,
 83896450,
 11747,
 84083973,
 83826684,
 -1,
 -64252,
 84033673,
 11774,
 -1,
 84093058,
 11744,
 -64250,
 84053125,
 11745,
 -64249,
 84240400,
 11755,
 -64248,
 84301675,
 11769,
 -64247,
 84365230,
 11773,
 -64246,
 84428943,
 11750,
 -64245,
 84489914,
 11746,
 -64244,
 84554529,
 11764,
 -64243,
 84614615,
 11761,
 -1,
 84676289,
 11766,
 84870417,
 81493525,
 -1,
 -64240,
 84819263,
 42610,
 -1,
 84880403,
 42608,
 85067028,
 84829947,
 -1,
 -64237,
 85024449,
 1159,
 -1,
 85071845,
 42621,
 -64235,
 85036866,
 42607,
 -64234,
 85215599,
 42620,
 -1,
 85278252,
 42609,
 -1,
 81420488,
 65062,
 85525823,
 81339093,
 -1,
 85591345,
 85471100,
 -1,
 85656872,
 85533943,
 -1,
 85722398,
 85622293,
 -1,
 -64227,
 85693038,
 43234,
 -1,
 85736805,
 43235,
 85919009,
 85685638,
 -1,
 -64224,
 85870304,
 43238,
 -1,
 85929863,
 43239,
 86115620,
 85864798,
 -1,
 -64221,
 86074482,
 43236,
 -1,
 86132367,
 43237,
 -64219,
 86087341,
 43232,
 -64218,
 86269942,
 43233,
 -64217,
 86334103,
 43241,
 -1,
 86387516,
 43240,
 86574384,
 85610057,
 -1,
 -64214,
 86543824,
 43248,
 -64213,
 86607399,
 43243,
 -64212,
 86666688,
 43247,
 -64211,
 86730554,
 43246,
 -64210,
 86792379,
 43245,
 -64209,
 86853775,
 43244,
 -1,
 86904513,
 43242,
 -1,
 86538383,
 43249,
 87228415,
 85548255,
 -1,
 87229754,
 87131917,
 -1,
 87295285,
 87184022,
 862,
 -1,
 87228614,
 863,
 87426359,
 87235370,
 861,
 -1,
 87359686,
 860,
 -64200,
 87388918,
 858,
 -64199,
 87508052,
 7676,
 -1,
 87564017,
 7629,
 87818239,
 87195157,
 -1,
 87819582,
 87719877,
 -1,
 -64195,
 87767038,
 7616,
 -1,
 87822389,
 7617,
 -1,
 87752716,
 856,
 88081764,
 85478210,
 -1,
 88147290,
 88020723,
 -1,
 88212820,
 88111610,
 -1,
 88278342,
 88149697,
 -1,
 -64188,
 88247216,
 7638,
 -64187,
 88300767,
 7637,
 -1,
 88352898,
 7636,
 88540489,
 88239460,
 -1,
 -64184,
 88503402,
 7651,
 -1,
 88545609,
 7626,
 88737099,
 88492866,
 7645,
 -1,
 88694931,
 7653,
 -64180,
 88708623,
 7654,
 -64179,
 88831366,
 7652,
 -64178,
 88889445,
 7648,
 -64177,
 88950845,
 7644,
 -64176,
 89015297,
 7640,
 -64175,
 89076945,
 7642,
 -64174,
 89142094,
 7635,
 -64173,
 89206440,
 7641,
 -1,
 89267154,
 7639,
 89522175,
 88166002,
 -1,
 -64170,
 89419106,
 7650,
 -64169,
 89479269,
 7649,
 -64168,
 89543196,
 7647,
 -64167,
 89606978,
 7646,
 -1,
 89666769,
 7643,
 89851235,
 88091368,
 -1,
 89916770,
 89784320,
 -1,
 89982305,
 89855403,
 -1,
 90047840,
 89930278,
 -1,
 -64161,
 89987401,
 852,
 -1,
 90050480,
 7678,
 -1,
 89981126,
 8430,
 -1,
 89930009,
 849,
 -1,
 89886644,
 8429,
 -1,
 89809016,
 8427,
 90506609,
 88043991,
 -1,
 90572144,
 90439680,
 -1,
 90637679,
 90510763,
 -1,
 90703214,
 90585638,
 -1,
 90768749,
 90640065,
 -1,
 90834284,
 90724651,
 -1,
 -64149,
 90802632,
 854,
 -1,
 90842985,
 7679,
 -1,
 90774258,
 848,
 -1,
 90708297,
 853,
 -1,
 90636486,
 8431,
 -1,
 90585369,
 855,
 -1,
 90542004,
 8428,
 91358585,
 90460822,
 -1,
 91424118,
 91294174,
 -1,
 -64140,
 91371512,
 7622,
 -64139,
 91429674,
 7628,
 -1,
 91492399,
 7620,
 91750399,
 91357184,
 -1,
 -64136,
 91648496,
 65061,
 -1,
 91704698,
 65060,
 91882882,
 91305913,
 -1,
 91948415,
 91826823,
 -1,
 92013950,
 91913749,
 -1,
 -64131,
 91976566,
 119362,
 -1,
 92024498,
 119363,
 -1,
 91973767,
 119364,
 92340223,
 91887475,
 -1,
 -64127,
 92230294,
 7621,
 -1,
 92278850,
 7624,
 92472714,
 91819713,
 -1,
 92538246,
 92437592,
 -1,
 -64123,
 92477769,
 857,
 -1,
 92540848,
 8432,
 92734857,
 92480183,
 -1,
 -64120,
 92689046,
 7623,
 -1,
 92747787,
 7625,
 -1,
 92688457,
 7677,
 92997005,
 92444443,
 -1,
 -64116,
 92936521,
 7631,
 -1,
 92999600,
 859,
 93193616,
 92964391,
 -1,
 -64113,
 93156747,
 7634,
 -1,
 93220199,
 7633,
 93390227,
 93156742,
 -1,
 -64110,
 93358951,
 7619,
 -1,
 93411553,
 7618,
 -64108,
 93361021,
 851,
 -64107,
 93543993,
 7630,
 -64106,
 93603182,
 7632,
 -64105,
 93663824,
 850,
 -1,
 93723440,
 7627,
 93914687,
 81292188,
 -1,
 93980138,
 93877638,
 -1,
 94045664,
 93934455,
 -1,
 94111154,
 94002399,
 11423,
 94176689,
 94063803,
 -1,
 94242219,
 94118128,
 -1,
 94307747,
 94189730,
 -1,
 94373281,
 94244545,
 11471,
 -1,
 94338581,
 11477,
 -64094,
 94331547,
 11469,
 -1,
 94448433,
 11475,
 94635430,
 94271261,
 -1,
 -64091,
 94585237,
 11483,
 -1,
 94645041,
 11461,
 -64089,
 94593347,
 11455,
 -64088,
 94778751,
 11479,
 -64087,
 94842461,
 11463,
 -64086,
 94905724,
 11481,
 -1,
 94966202,
 11445,
 95223807,
 94198799,
 -1,
 95225263,
 95115365,
 -1,
 -64082,
 95196469,
 11489,
 -1,
 95237908,
 11487,
 -64080,
 95195094,
 11491,
 -1,
 95385603,
 11485,
 -1,
 94135305,
 11441,
 95618489,
 94053077,
 -1,
 95684024,
 95567578,
 -1,
 -64075,
 95640162,
 11451,
 -64074,
 95701241,
 11449,
 -64073,
 95763648,
 11467,
 -1,
 95818348,
 11443,
 -1,
 95621731,
 11399,
 96077248,
 95559957,
 -1,
 96142783,
 96048585,
 -1,
 -64068,
 96106461,
 11500,
 -64067,
 96164450,
 11453,
 -64066,
 96220543,
 11502,
 -1,
 96283448,
 11447,
 -1,
 96101185,
 11459,
 96536004,
 96040326,
 -1,
 -64062,
 96494601,
 11403,
 -64061,
 96551317,
 11429,
 -1,
 96604957,
 11457,
 96798152,
 96487485,
 -1,
 -64058,
 96761964,
 11421,
 -64057,
 96811754,
 11437,
 -1,
 96867443,
 11413,
 97060299,
 96763413,
 -1,
 -64054,
 97008313,
 11409,
 -1,
 97064760,
 11431,
 97256910,
 97019643,
 -1,
 -64051,
 97220716,
 11439,
 -1,
 97271398,
 11425,
 97453521,
 97209154,
 -1,
 -64048,
 97392451,
 11415,
 -1,
 97454810,
 11473,
 97650132,
 97390273,
 -1,
 -64045,
 97603278,
 11393,
 -1,
 97667613,
 11465,
 -64043,
 97621627,
 11405,
 -64042,
 97816019,
 11395,
 -64041,
 97879704,
 11433,
 -64040,
 97940461,
 11427,
 -64039,
 97999458,
 11419,
 -64038,
 98063877,
 11417,
 -64037,
 98123586,
 11411,
 -64036,
 98187786,
 11407,
 -64035,
 98252127,
 11397,
 -64034,
 98316973,
 11435,
 -64033,
 98380600,
 11401,
 -1,
 98441897,
 11507,
 98697215,
 94016871,
 -1,
 98698724,
 98596230,
 -1,
 -64029,
 98664305,
 11495,
 -1,
 98712512,
 11498,
 98895335,
 98650173,
 -1,
 -64026,
 98843373,
 11497,
 -1,
 98898326,
 11492,
 -64024,
 98860906,
 11496,
 -64023,
 99051802,
 11494,
 -1,
 99112460,
 11493,
 99288630,
 93920205,
 -1,
 99354161,
 99226772,
 -1,
 99419651,
 99310815,
 11422,
 99485186,
 99372219,
 -1,
 99550716,
 99426544,
 -1,
 99616244,
 99498146,
 -1,
 99681778,
 99552961,
 11470,
 -1,
 99646997,
 11476,
 -64013,
 99639963,
 11468,
 -1,
 99756849,
 11474,
 99943927,
 99579677,
 -1,
 -64010,
 99893653,
 11482,
 -1,
 99953457,
 11460,
 -64008,
 99901763,
 11454,
 -64007,
 100087167,
 11478,
 -64006,
 100150877,
 11462,
 -64005,
 100214140,
 11480,
 -1,
 100274618,
 11444,
 100532223,
 99507215,
 -1,
 100533760,
 100423781,
 -1,
 -64001,
 100504885,
 11488,
 -1,
 100546324,
 11486,
 -63999,
 100503510,
 11490,
 -1,
 100694019,
 11484,
 -1,
 99443721,
 11440,
 100926986,
 99361493,
 -1,
 100992521,
 100875994,
 -1,
 -63994,
 100948578,
 11450,
 -63993,
 101009657,
 11448,
 -63992,
 101072064,
 11466,
 -1,
 101126764,
 11442,
 -1,
 100930147,
 11398,
 101385745,
 100868373,
 -1,
 101451280,
 101357001,
 -1,
 -63987,
 101414877,
 11499,
 -63986,
 101472866,
 11452,
 -63985,
 101528959,
 11501,
 -1,
 101591864,
 11446,
 -1,
 101409601,
 11458,
 101844501,
 101348742,
 -1,
 -63981,
 101803017,
 11402,
 -63980,
 101859733,
 11428,
 -1,
 101913373,
 11456,
 102106649,
 101795901,
 -1,
 -63977,
 102070380,
 11420,
 -63976,
 102120170,
 11436,
 -1,
 102175859,
 11412,
 102368796,
 102071829,
 -1,
 -63973,
 102316729,
 11408,
 -1,
 102373176,
 11430,
 102565407,
 102328059,
 -1,
 -63970,
 102529132,
 11438,
 -1,
 102579814,
 11424,
 102762018,
 102517570,
 -1,
 -63967,
 102700867,
 11414,
 -1,
 102763226,
 11472,
 102958629,
 102698689,
 -1,
 -63964,
 102911694,
 11392,
 -1,
 102976029,
 11464,
 -63962,
 102930043,
 11404,
 -63961,
 103124435,
 11394,
 -63960,
 103188120,
 11432,
 -63959,
 103248877,
 11426,
 -63958,
 103307874,
 11418,
 -63957,
 103372293,
 11416,
 -63956,
 103432002,
 11410,
 -63955,
 103496202,
 11406,
 -63954,
 103560543,
 11396,
 -63953,
 103625389,
 11434,
 -63952,
 103689016,
 11400,
 -1,
 103750313,
 11506,
 104005631,
 99311461,
 -1,
 104007221,
 103906129,
 -1,
 -63948,
 103960096,
 11505,
 -1,
 104011310,
 11504,
 -1,
 103963237,
 11503,
 104269371,
 99245809,
 -1,
 -63944,
 104238363,
 11516,
 -63943,
 104284765,
 11515,
 -63942,
 104346816,
 11513,
 -1,
 104408361,
 11514,
 104597054,
 104214878,
 -1,
 -63939,
 104564837,
 11518,
 -1,
 104623586,
 11517,
 -1,
 104552329,
 11519,
 104859228,
 93881895,
 -1,
 104924763,
 104815595,
 -1,
 104990286,
 104892789,
 -1,
 105055813,
 104955413,
 -1,
 -63932,
 105026158,
 119649,
 -1,
 105069925,
 119650,
 105252424,
 105018758,
 -1,
 -63929,
 105203424,
 119653,
 -1,
 105262983,
 119654,
 105449035,
 105197918,
 -1,
 -63926,
 105407602,
 119651,
 -1,
 105465487,
 119652,
 -63924,
 105406454,
 119648,
 -63923,
 105601687,
 119656,
 -1,
 105655100,
 119655,
 105906175,
 104955960,
 -1,
 105907794,
 105807381,
 -1,
 -63919,
 105878126,
 119658,
 -1,
 105921893,
 119659,
 106104405,
 105870726,
 -1,
 -63916,
 106055392,
 119662,
 -1,
 106114951,
 119663,
 106301016,
 106049886,
 -1,
 -63913,
 106259570,
 119660,
 -1,
 106317455,
 119661,
 -63911,
 106258422,
 119657,
 -63910,
 106453655,
 119665,
 -1,
 106507068,
 119664,
 -1,
 104884608,
 128145,
 106759782,
 104814693,
 -1,
 106825313,
 106705246,
 -1,
 -63905,
 106793770,
 128533,
 -63904,
 106849382,
 128534,
 -1,
 106901220,
 127882,
 107087460,
 106790182,
 -1,
 -63901,
 107058002,
 128119,
 -1,
 107116676,
 128679,
 -63899,
 107056349,
 127978,
 -1,
 107250798,
 983186,
 107415147,
 106716826,
 -1,
 107480682,
 107363942,
 -1,
 -63895,
 107436585,
 127859,
 -1,
 107489410,
 127850,
 -1,
 107424341,
 127834,
 107742829,
 107384648,
 128004,
 -1,
 107676094,
 128046,
 -63890,
 107696173,
 128165,
 -63889,
 107819672,
 9904,
 -1,
 107880308,
 127864,
 108070737,
 81213602,
 -1,
 108136259,
 108007105,
 -1,
 108201695,
 108089886,
 -1,
 108267190,
 108154441,
 -1,
 108332672,
 108212945,
 -1,
 108398199,
 108288101,
 43590,
 -1,
 108344529,
 43586,
 -63880,
 108368943,
 43592,
 -63879,
 108494357,
 43589,
 -63878,
 108559272,
 43595,
 -63877,
 108621154,
 43593,
 -63876,
 108685051,
 43591,
 -63875,
 108743490,
 43594,
 -63874,
 108808253,
 43584,
 -63873,
 108868817,
 43585,
 -1,
 108928425,
 43588,
 109119114,
 108288101,
 -1,
 109184645,
 109066402,
 -1,
 -63869,
 109152219,
 43536,
 -63868,
 109201237,
 43538,
 -1,
 109252289,
 43537,
 109446792,
 109130961,
 -1,
 -63865,
 109414363,
 43530,
 -1,
 109448897,
 43531,
 -63863,
 109414363,
 43543,
 -1,
 109579969,
 43544,
 109774478,
 109078267,
 -1,
 -63860,
 109733690,
 43547,
 -63859,
 109787320,
 43548,
 -1,
 109842113,
 43546,
 110036626,
 109716181,
 -1,
 -63856,
 109983928,
 43542,
 -63855,
 110043954,
 43545,
 -1,
 110104257,
 43541,
 110298774,
 109975548,
 -1,
 -63852,
 110246072,
 43550,
 -63851,
 110303281,
 43553,
 -1,
 110366401,
 43549,
 110560921,
 110263829,
 -1,
 -63848,
 110508216,
 43540,
 -1,
 110563009,
 43539,
 110757532,
 110523782,
 -1,
 -63845,
 110720474,
 43558,
 -1,
 110759617,
 43559,
 110954143,
 110711324,
 -1,
 -63842,
 110921691,
 43551,
 -1,
 110956225,
 43552,
 111150754,
 110905405,
 -1,
 -63839,
 111098040,
 43527,
 -1,
 111152833,
 43526,
 111347365,
 111101751,
 -1,
 -63836,
 111294648,
 43535,
 -1,
 111349441,
 43534,
 111543976,
 111293649,
 -1,
 -63833,
 111491256,
 43529,
 -1,
 111546049,
 43528,
 111740587,
 111484329,
 -1,
 -63830,
 111687864,
 43533,
 -1,
 111742657,
 43532,
 111937197,
 111677121,
 43520,
 -1,
 111885926,
 43524,
 -63826,
 111907953,
 43554,
 -63825,
 112036806,
 43557,
 -63824,
 112100903,
 43522,
 -63823,
 112160192,
 43555,
 -63822,
 112221407,
 43525,
 -63821,
 112282480,
 43556,
 -63820,
 112344678,
 43521,
 -63819,
 112408760,
 43560,
 -1,
 112470146,
 43523,
 112658114,
 108236503,
 -1,
 112723643,
 112594625,
 -1,
 -63815,
 112690727,
 43569,
 -63814,
 112737894,
 43568,
 -1,
 112791233,
 43561,
 112985789,
 112690727,
 43565,
 -1,
 112928898,
 43570,
 113116863,
 112942303,
 43567,
 -1,
 113059970,
 43566,
 113247937,
 113065574,
 43562,
 -1,
 113196646,
 43563,
 -1,
 113191729,
 43564,
 113444560,
 112600311,
 -1,
 113510086,
 113409557,
 -1,
 -63803,
 113480302,
 43602,
 -1,
 113524069,
 43603,
 113706697,
 113472902,
 -1,
 -63800,
 113657568,
 43606,
 -1,
 113717127,
 43607,
 113903308,
 113652062,
 -1,
 -63797,
 113861746,
 43604,
 -1,
 113919631,
 43605,
 -63795,
 113874605,
 43600,
 -63794,
 114057206,
 43601,
 -63793,
 114121367,
 43609,
 -1,
 114174780,
 43608,
 114362073,
 113385609,
 -1,
 114427605,
 114307793,
 -1,
 -63789,
 114383401,
 43587,
 -63788,
 114446876,
 43596,
 -1,
 114505890,
 43597,
 -63786,
 114398321,
 43571,
 -63785,
 114659215,
 43574,
 -63784,
 114716096,
 43572,
 -1,
 114772848,
 43573,
 115015679,
 114322368,
 -1,
 115017437,
 114893525,
 -1,
 -63780,
 114975763,
 43614,
 -1,
 115020713,
 43613,
 -63778,
 114984009,
 43615,
 -1,
 115178302,
 43612,
 115345209,
 108153489,
 -1,
 115410705,
 115297865,
 -1,
 115476199,
 115375637,
 -1,
 115541733,
 115441173,
 -1,
 -63772,
 115488973,
 69906,
 -1,
 115543866,
 69905,
 -63770,
 115488973,
 69911,
 -1,
 115674938,
 69910,
 115869420,
 115431525,
 -1,
 -63767,
 115840116,
 69904,
 -63766,
 115890381,
 69909,
 -63765,
 115946758,
 69899,
 -1,
 116002618,
 69914,
 116197106,
 115811029,
 -1,
 116262640,
 116138709,
 -1,
 -63761,
 116209869,
 69908,
 -1,
 116264762,
 69907,
 -63759,
 116209869,
 69913,
 -1,
 116395834,
 69912,
 116590325,
 116167727,
 -1,
 -63756,
 116561012,
 69920,
 -1,
 116592442,
 69921,
 116786936,
 116549371,
 -1,
 -63753,
 116734157,
 69916,
 -1,
 116789050,
 69915,
 116983547,
 116738109,
 -1,
 -63750,
 116930765,
 69896,
 -1,
 116985658,
 69895,
 117180158,
 116934455,
 -1,
 -63747,
 117127373,
 69903,
 -1,
 117182266,
 69902,
 117376769,
 117126353,
 -1,
 -63744,
 117323981,
 69898,
 -1,
 117378874,
 69897,
 117573380,
 117316557,
 -1,
 -63741,
 117520589,
 69901,
 -1,
 117575482,
 69900,
 117769991,
 117512188,
 -1,
 -63738,
 117717197,
 69918,
 -1,
 117772090,
 69917,
 -63736,
 117739410,
 69924,
 -63735,
 117933607,
 69893,
 -63734,
 117994978,
 69925,
 -63733,
 118058455,
 69922,
 -63732,
 118116984,
 69919,
 -63731,
 118180736,
 69923,
 -63730,
 118242918,
 69892,
 -63729,
 118307021,
 69926,
 -63728,
 118368386,
 69894,
 -1,
 118427450,
 69891,
 118621986,
 115352277,
 -1,
 118687520,
 118571284,
 -1,
 118753046,
 118652437,
 -1,
 -63723,
 118723182,
 69944,
 -1,
 118766949,
 69945,
 118949657,
 118715782,
 -1,
 -63720,
 118900448,
 69948,
 -1,
 118960007,
 69949,
 119146268,
 118894942,
 -1,
 -63717,
 119104626,
 69946,
 -1,
 119162511,
 69947,
 -63715,
 119117485,
 69942,
 -63714,
 119300086,
 69943,
 -63713,
 119364247,
 69951,
 -1,
 119417660,
 69950,
 -63711,
 118645779,
 69954,
 -1,
 119542697,
 69953,
 119736111,
 118590384,
 -1,
 119801646,
 119695011,
 -1,
 119867175,
 119738049,
 69927,
 -63706,
 119834151,
 69935,
 -1,
 119881318,
 69933,
 120063785,
 119834151,
 69930,
 -1,
 120030759,
 69931,
 120194859,
 120020191,
 69934,
 -1,
 120143462,
 69936,
 120325933,
 120143462,
 69928,
 -1,
 120274534,
 69929,
 -1,
 120268930,
 69932,
 -1,
 119751986,
 69939,
 120588085,
 119698822,
 -1,
 120653620,
 120537380,
 -1,
 -63694,
 120622585,
 69890,
 -63693,
 120659042,
 69888,
 -1,
 120722531,
 69889,
 -1,
 120597030,
 69952,
 -63690,
 120548624,
 69955,
 -63689,
 120937717,
 69937,
 -63688,
 121000578,
 69940,
 -1,
 121050939,
 69938,
 121243458,
 115305826,
 -1,
 121308990,
 121208448,
 -1,
 121374525,
 121277058,
 128200,
 -1,
 121307302,
 128185,
 -1,
 121317307,
 128201,
 121634815,
 121245726,
 983058,
 121700351,
 121503744,
 -1,
 -63679,
 121606541,
 983139,
 -1,
 121665278,
 983136,
 -1,
 121193432,
 9939,
 121898826,
 108079234,
 -1,
 121964359,
 121861265,
 -1,
 -63674,
 121934908,
 127800,
 -1,
 121978959,
 127826,
 -63672,
 121928828,
 127792,
 -63671,
 122121467,
 127937,
 -1,
 122170875,
 128227,
 122357582,
 121847398,
 -1,
 -63668,
 122319936,
 9911,
 -63667,
 122375391,
 128696,
 -1,
 122429284,
 128020,
 -63665,
 122325713,
 9962,
 -63664,
 122581902,
 127876,
 -1,
 122641791,
 127851,
 122816563,
 108041263,
 -1,
 122882030,
 122778329,
 -1,
 122947487,
 122845690,
 -1,
 123012956,
 122888917,
 -1,
 123078489,
 122983951,
 -1,
 -63657,
 123049611,
 42633,
 -63656,
 123113509,
 42627,
 -1,
 123153350,
 42563,
 -63654,
 123047973,
 42625,
 -63653,
 123298847,
 42605,
 -1,
 123357105,
 42569,
 123537251,
 122977813,
 -1,
 123602784,
 123499910,
 -1,
 -63649,
 123572261,
 42639,
 -1,
 123631227,
 42641,
 -63647,
 123572261,
 42637,
 -63646,
 123742519,
 42635,
 -1,
 123805143,
 42643,
 123996012,
 123499910,
 -1,
 124061545,
 123952645,
 -1,
 124127080,
 124004482,
 -1,
 -63641,
 124080668,
 42599,
 -1,
 124144450,
 42597,
 -1,
 124068826,
 42595,
 124452863,
 124008610,
 -1,
 -63637,
 124358693,
 42647,
 -1,
 124401851,
 1319,
 124585843,
 123956578,
 -1,
 124651378,
 124530663,
 -1,
 -63633,
 124622475,
 1297,
 -63632,
 124687871,
 42581,
 -63631,
 124748939,
 42593,
 -1,
 124790905,
 42565,
 -1,
 124598456,
 1303,
 125044601,
 124536068,
 -1,
 125110136,
 124993642,
 -1,
 -63626,
 125080785,
 42579,
 -63625,
 125116334,
 42589,
 -1,
 125177537,
 42583,
 -1,
 125046465,
 42567,
 125437821,
 125015087,
 -1,
 -63621,
 125392997,
 42591,
 -63620,
 125447713,
 42577,
 -1,
 125505671,
 1305,
 125699970,
 125384866,
 -1,
 125765505,
 125636368,
 -1,
 -63616,
 125730004,
 1279,
 -1,
 125779090,
 1277,
 -1,
 125734949,
 42645,
 126027655,
 125642882,
 -1,
 126093190,
 125979472,
 -1,
 -63611,
 126047766,
 1313,
 -1,
 126106770,
 1299,
 -1,
 126048393,
 1315,
 126355339,
 125966332,
 -1,
 -63607,
 126317556,
 42573,
 -63606,
 126373385,
 42587,
 -1,
 126436301,
 42603,
 126617486,
 126326287,
 -1,
 -63603,
 126565968,
 42629,
 -1,
 126626800,
 42561,
 126814097,
 126576379,
 -1,
 -63600,
 126757145,
 1317,
 -1,
 126816988,
 1231,
 127010708,
 126768987,
 -1,
 -63597,
 126957522,
 42571,
 -1,
 127017567,
 42601,
 127207319,
 126957246,
 -1,
 -63594,
 127171811,
 1275,
 -1,
 127214648,
 1271,
 127403930,
 127146957,
 -1,
 -63591,
 127357144,
 42585,
 -1,
 127409623,
 42631,
 -63589,
 127373349,
 1309,
 -63588,
 127560749,
 1307,
 -63587,
 127621657,
 42575,
 -63586,
 127684314,
 1301,
 -1,
 127734420,
 1311,
 127928297,
 122887324,
 -1,
 127993768,
 127869653,
 -1,
 128059301,
 127964687,
 -1,
 -63581,
 128030347,
 42632,
 -63580,
 128094245,
 42626,
 -1,
 128134086,
 42562,
 -63578,
 128028709,
 42624,
 -63577,
 128279583,
 42604,
 -1,
 128337841,
 42568,
 128518063,
 127958549,
 -1,
 128583596,
 128480646,
 -1,
 -63573,
 128552997,
 42638,
 -1,
 128611963,
 42640,
 -63571,
 128552997,
 42636,
 -63570,
 128723255,
 42634,
 -1,
 128785879,
 42642,
 128976824,
 128480646,
 -1,
 129042357,
 128933381,
 -1,
 129107892,
 128985218,
 -1,
 -63565,
 129061404,
 42598,
 -1,
 129125186,
 42596,
 -1,
 129049562,
 42594,
 129433599,
 128989346,
 -1,
 -63561,
 129339429,
 42646,
 -1,
 129382587,
 1318,
 129566655,
 128937314,
 -1,
 129632190,
 129511399,
 -1,
 -63557,
 129603211,
 1296,
 -63556,
 129668607,
 42580,
 -63555,
 129729675,
 42592,
 -1,
 129771641,
 42564,
 -1,
 129579192,
 1302,
 130025413,
 129516804,
 -1,
 130090948,
 129974378,
 -1,
 -63550,
 130061521,
 42578,
 -63549,
 130097070,
 42588,
 -1,
 130158273,
 42582,
 -1,
 130027201,
 42566,
 130418633,
 129995823,
 -1,
 -63545,
 130373733,
 42590,
 -63544,
 130428449,
 42576,
 -1,
 130486407,
 1304,
 130680782,
 130365602,
 -1,
 130746317,
 130617104,
 -1,
 -63540,
 130710740,
 1278,
 -1,
 130759826,
 1276,
 -1,
 130715685,
 42644,
 131008467,
 130623618,
 -1,
 131074002,
 130960208,
 -1,
 -63535,
 131028502,
 1312,
 -1,
 131087506,
 1298,
 -1,
 131029129,
 1314,
 131336151,
 130947068,
 -1,
 -63531,
 131298292,
 42572,
 -63530,
 131354121,
 42586,
 -1,
 131417037,
 42602,
 131598298,
 131307023,
 -1,
 -63527,
 131546704,
 42628,
 -1,
 131607536,
 42560,
 131794909,
 131553115,
 -1,
 -63524,
 131741650,
 42570,
 -1,
 131801695,
 42600,
 131991520,
 131741374,
 -1,
 -63521,
 131955939,
 1274,
 -1,
 131998776,
 1270,
 132188131,
 131931085,
 -1,
 -63518,
 132141272,
 42584,
 -1,
 132193751,
 42630,
 -63516,
 132157477,
 1308,
 -63515,
 132344877,
 1306,
 -63514,
 132409363,
 1316,
 -63513,
 132471321,
 42574,
 -63512,
 132533978,
 1300,
 -1,
 132584084,
 1310,
 132777964,
 127880777,
 -1,
 -63509,
 132741582,
 7467,
 -1,
 132798419,
 42606,
 -63507,
 132737019,
 42623,
 -1,
 132925807,
 42622,
 133105714,
 122841932,
 -1,
 133171189,
 133070357,
 -1,
 -63503,
 133137959,
 67633,
 -63502,
 133192927,
 67632,
 -63501,
 133250662,
 67631,
 -63500,
 133310594,
 67630,
 -1,
 133369537,
 67629,
 133564411,
 133133702,
 -1,
 -63497,
 133531175,
 67628,
 -63496,
 133586143,
 67627,
 -63495,
 133643878,
 67626,
 -63494,
 133703810,
 67625,
 -1,
 133762753,
 67624,
 133957633,
 133524834,
 -1,
 -63491,
 133924391,
 67623,
 -63490,
 133979359,
 67622,
 -63489,
 134037094,
 67621,
 -63488,
 134097026,
 67620,
 -1,
 134155969,
 67619,
 134350855,
 133916411,
 -1,
 -63485,
 134317607,
 67618,
 -63484,
 134372575,
 67617,
 -63483,
 134430310,
 67616,
 -63482,
 134490242,
 67615,
 -1,
 134549185,
 67614,
 134744077,
 134305893,
 -1,
 -63479,
 134710823,
 67613,
 -63478,
 134765791,
 67612,
 -63477,
 134823526,
 67611,
 -63476,
 134883458,
 67610,
 -1,
 134942401,
 67609,
 135137299,
 134697500,
 -1,
 -63473,
 135104039,
 67608,
 -63472,
 135159007,
 67607,
 -63471,
 135216742,
 67606,
 -63470,
 135276674,
 67605,
 -1,
 135335617,
 67604,
 135530521,
 135088962,
 -1,
 -63467,
 135497255,
 67603,
 -63466,
 135552223,
 67602,
 -63465,
 135609958,
 67601,
 -63464,
 135669890,
 67600,
 -1,
 135728833,
 67599,
 135923743,
 135481405,
 -1,
 -63461,
 135890471,
 67598,
 -63460,
 135945439,
 67597,
 -63459,
 136003174,
 67596,
 -63458,
 136063106,
 67595,
 -1,
 136122049,
 67594,
 136316964,
 135892808,
 -1,
 -63455,
 136273119,
 67637,
 -63454,
 136330854,
 67636,
 -63453,
 136390786,
 67635,
 -1,
 136449729,
 67634,
 136644647,
 136287759,
 -1,
 -63450,
 136600799,
 67647,
 -1,
 136646337,
 67644,
 136841258,
 136614779,
 -1,
 -63447,
 136784002,
 67640,
 -1,
 136842945,
 67639,
 137037869,
 136791863,
 -1,
 -63444,
 136994015,
 67592,
 -1,
 137039553,
 67589,
 -63442,
 137004583,
 67588,
 -63441,
 137190623,
 67587,
 -63440,
 137248358,
 67586,
 -63439,
 137308290,
 67585,
 -1,
 137367233,
 67584,
 -1,
 133046159,
 127744,
 137627858,
 122767324,
 -1,
 137693357,
 137568349,
 -1,
 137758790,
 137632717,
 -1,
 -63433,
 137703774,
 64207,
 -63432,
 137767042,
 64206,
 -63431,
 137831125,
 64205,
 -63430,
 137894861,
 64204,
 -63429,
 137959420,
 64203,
 -63428,
 138022593,
 64202,
 -63427,
 138088074,
 64201,
 -63426,
 138153558,
 64200,
 -63425,
 138219031,
 64199,
 -63424,
 138284509,
 64198,
 -63423,
 138349936,
 64197,
 -63422,
 138415410,
 64196,
 -63421,
 138480842,
 64195,
 -63420,
 138546227,
 64194,
 -63419,
 138611619,
 64193,
 -1,
 138677024,
 64192,
 138872919,
 137697276,
 -1,
 -63416,
 138817886,
 64191,
 -63415,
 138881154,
 64190,
 -63414,
 138945237,
 64189,
 -63413,
 139008973,
 64188,
 -63412,
 139073532,
 64187,
 -63411,
 139136705,
 64186,
 -63410,
 139202186,
 64185,
 -63409,
 139267670,
 64184,
 -63408,
 139333143,
 64183,
 -63407,
 139398621,
 64182,
 -63406,
 139464048,
 64181,
 -63405,
 139529522,
 64180,
 -63404,
 139594954,
 64179,
 -63403,
 139660339,
 64178,
 -63402,
 139725731,
 64177,
 -1,
 139791136,
 64176,
 139987048,
 138809025,
 -1,
 -63399,
 139931998,
 64175,
 -63398,
 139995266,
 64174,
 -63397,
 140059349,
 64173,
 -63396,
 140123085,
 64172,
 -63395,
 140187644,
 64171,
 -63394,
 140250817,
 64170,
 -63393,
 140316298,
 64169,
 -63392,
 140381782,
 64168,
 -63391,
 140447255,
 64167,
 -63390,
 140512733,
 64166,
 -63389,
 140578160,
 64165,
 -63388,
 140643634,
 64164,
 -63387,
 140709066,
 64163,
 -63386,
 140774451,
 64162,
 -63385,
 140839843,
 64161,
 -1,
 140905248,
 64160,
 141101177,
 139923082,
 -1,
 -63382,
 141046110,
 64159,
 -63381,
 141109378,
 64158,
 -63380,
 141173461,
 64157,
 -63379,
 141237197,
 64156,
 -63378,
 141301756,
 64155,
 -63377,
 141364929,
 64154,
 -63376,
 141430410,
 64153,
 -63375,
 141495894,
 64152,
 -63374,
 141561367,
 64151,
 -63373,
 141626845,
 64150,
 -63372,
 141692272,
 64149,
 -63371,
 141757746,
 64148,
 -63370,
 141823178,
 64147,
 -63369,
 141888563,
 64146,
 -63368,
 141953955,
 64145,
 -1,
 142019360,
 64144,
 142215306,
 141037142,
 -1,
 -63365,
 142160222,
 64143,
 -63364,
 142223490,
 64142,
 -63363,
 142287573,
 64141,
 -63362,
 142351309,
 64140,
 -63361,
 142415868,
 64139,
 -63360,
 142479041,
 64138,
 -63359,
 142544522,
 64137,
 -63358,
 142610006,
 64136,
 -63357,
 142675479,
 64135,
 -63356,
 142740957,
 64134,
 -63355,
 142806384,
 64133,
 -63354,
 142871858,
 64132,
 -63353,
 142937290,
 64131,
 -63352,
 143002675,
 64130,
 -63351,
 143068067,
 64129,
 -1,
 143133472,
 64128,
 143329435,
 142151191,
 -1,
 -63348,
 143274334,
 64127,
 -63347,
 143337602,
 64126,
 -63346,
 143401685,
 64125,
 -63345,
 143465421,
 64124,
 -63344,
 143529980,
 64123,
 -63343,
 143593153,
 64122,
 -63342,
 143658634,
 64121,
 -63341,
 143724118,
 64120,
 -63340,
 143789591,
 64119,
 -63339,
 143855069,
 64118,
 -63338,
 143920496,
 64117,
 -63337,
 143985970,
 64116,
 -63336,
 144051402,
 64115,
 -63335,
 144116787,
 64114,
 -63334,
 144182179,
 64113,
 -1,
 144247584,
 64112,
 144443558,
 143270613,
 -1,
 -63331,
 144379530,
 64217,
 -63330,
 144445014,
 64216,
 -63329,
 144510487,
 64215,
 -63328,
 144575965,
 64214,
 -63327,
 144641392,
 64213,
 -63326,
 144706866,
 64212,
 -63325,
 144772298,
 64211,
 -63324,
 144837683,
 64210,
 -63323,
 144903075,
 64209,
 -1,
 144968480,
 64208,
 145164458,
 144379357,
 -1,
 -63320,
 145105621,
 64109,
 -63319,
 145169357,
 64108,
 -1,
 145233916,
 64107,
 145489919,
 145099827,
 -1,
 -63316,
 145371486,
 64047,
 -1,
 145434754,
 64046,
 145686527,
 137657563,
 -1,
 145688764,
 145569954,
 12752,
 145754296,
 145659407,
 12757,
 145819828,
 145724943,
 12741,
 145885363,
 145790479,
 12750,
 -1,
 145831121,
 12769,
 -1,
 145843963,
 12747,
 146081974,
 145788744,
 12749,
 -1,
 146027729,
 12744,
 -63305,
 146046485,
 12746,
 -1,
 146158801,
 12742,
 146344122,
 145712891,
 12743,
 -1,
 146313343,
 12748,
 -63301,
 146314283,
 12768,
 -1,
 146420945,
 12758,
 146606278,
 145651078,
 12753,
 146671808,
 146576911,
 12759,
 -63297,
 146642447,
 12766,
 -1,
 146706559,
 12745,
 146868419,
 146640712,
 12740,
 -63294,
 146839055,
 12760,
 -1,
 146879697,
 12767,
 -63292,
 146832917,
 12761,
 -63291,
 147023611,
 12755,
 -1,
 147076305,
 12762,
 147261642,
 146564859,
 12754,
 -63288,
 147232271,
 12764,
 -63287,
 147272913,
 12770,
 -1,
 147333845,
 12763,
 147523788,
 147226133,
 12736,
 -1,
 147478629,
 12765,
 -63283,
 147493878,
 12738,
 -63282,
 147624063,
 12737,
 -63281,
 147680287,
 12771,
 -63280,
 147740773,
 12751,
 -63279,
 147792597,
 12756,
 -1,
 147856313,
 12739,
 148048265,
 137563841,
 -1,
 148113735,
 148002917,
 983098,
 148179268,
 148050034,
 -1,
 148244709,
 148135135,
 -1,
 148310244,
 148195268,
 -1,
 148375773,
 148265061,
 6361,
 148504575,
 148344648,
 -1,
 148506843,
 148397279,
 6347,
 -1,
 148462815,
 6349,
 148701183,
 148455014,
 6343,
 -1,
 148586086,
 6345,
 148768991,
 148338054,
 6362,
 -1,
 148715682,
 6363,
 -63264,
 148733461,
 6357,
 -63263,
 148858619,
 6356,
 -63262,
 148918812,
 6360,
 -63261,
 148981821,
 6358,
 -1,
 149035981,
 6359,
 -1,
 148280367,
 6320,
 149293302,
 148213576,
 -1,
 149358832,
 149250301,
 -1,
 149424367,
 149324238,
 -1,
 149489898,
 149380319,
 5754,
 -1,
 149445855,
 5755,
 149620972,
 149438054,
 5752,
 -1,
 149569126,
 5753,
 149752046,
 149556929,
 5756,
 -1,
 149688001,
 5757,
 -1,
 149695099,
 5751,
 -1,
 149369570,
 5758,
 150014197,
 149302903,
 -1,
 150079732,
 149948946,
 -1,
 -63245,
 150036720,
 6369,
 -1,
 150081338,
 6370,
 -1,
 150023691,
 6365,
 -1,
 149952457,
 6323,
 150407427,
 149255558,
 -1,
 150472958,
 150345673,
 6335,
 150601727,
 150422937,
 -1,
 150604028,
 150501149,
 -1,
 -63237,
 150573093,
 6378,
 -1,
 150626544,
 6379,
 -63235,
 150554677,
 6385,
 -1,
 150748302,
 6380,
 150931714,
 150419618,
 -1,
 -63232,
 150901593,
 6338,
 -63231,
 150955764,
 6336,
 -1,
 151001033,
 6337,
 -1,
 150890228,
 6334,
 151259407,
 150371861,
 -1,
 151324936,
 151224497,
 -1,
 -63226,
 151293989,
 6373,
 -63225,
 151347440,
 6374,
 -1,
 151392058,
 6375,
 151587083,
 151277271,
 -1,
 -63222,
 151556133,
 6376,
 -1,
 151609584,
 6377,
 151783694,
 151535177,
 -1,
 -63219,
 151726210,
 6371,
 -1,
 151785153,
 6372,
 -1,
 151721929,
 6327,
 152045849,
 151219554,
 -1,
 152111383,
 152014664,
 -1,
 152176915,
 152067295,
 6353,
 -1,
 152132831,
 6354,
 152307989,
 152125030,
 6351,
 -1,
 152256102,
 6352,
 -63210,
 152251003,
 6350,
 -1,
 152374977,
 6355,
 -63208,
 152049609,
 6341,
 -1,
 152504858,
 6368,
 152701217,
 152000613,
 -1,
 152766751,
 152670024,
 -1,
 152832285,
 152722655,
 6346,
 -1,
 152788191,
 6348,
 153026559,
 152780390,
 6342,
 -1,
 152911462,
 6344,
 -63200,
 152725236,
 6331,
 -1,
 153032649,
 6332,
 153225515,
 152640723,
 -1,
 153291047,
 153171153,
 -1,
 153356582,
 153259848,
 -1,
 -63195,
 153323047,
 6381,
 -1,
 153358017,
 6384,
 -1,
 153292602,
 6383,
 153618730,
 153232404,
 -1,
 -63191,
 153583391,
 6389,
 -1,
 153626830,
 6382,
 -1,
 153569337,
 6386,
 153880879,
 153183995,
 -1,
 -63187,
 153850713,
 6326,
 -63186,
 153904884,
 6324,
 -1,
 153950153,
 6325,
 154143028,
 153819132,
 -1,
 154208563,
 154085882,
 -1,
 -63182,
 154168674,
 6388,
 -1,
 154225474,
 6387,
 -1,
 154160050,
 5759,
 154470711,
 154113071,
 -1,
 -63178,
 154429172,
 6339,
 -1,
 154474441,
 6340,
 154667322,
 154421309,
 -1,
 -63175,
 154636300,
 6329,
 -1,
 154671049,
 6328,
 154863933,
 154612433,
 -1,
 -63172,
 154827305,
 6366,
 -1,
 154889788,
 6367,
 155060544,
 154799809,
 -1,
 -63169,
 155030575,
 6321,
 -1,
 155064265,
 6322,
 -63167,
 155014216,
 6330,
 -63166,
 155208856,
 6333,
 -63165,
 155270751,
 5120,
 -1,
 155331024,
 6364,
 155519302,
 148118902,
 983097,
 -1,
 155451659,
 983170,
 -1,
 155461736,
 127852,
 155715968,
 148073826,
 -1,
 155781499,
 155664117,
 -1,
 155846991,
 155747879,
 66226,
 155975679,
 155813415,
 66239,
 156041215,
 155878951,
 66212,
 -63155,
 155944487,
 66235,
 -63154,
 155978954,
 66256,
 -1,
 156044339,
 66248,
 156240213,
 155809158,
 66224,
 156305746,
 156204565,
 66242,
 -1,
 156240947,
 66243,
 156436820,
 156252322,
 66222,
 -1,
 156372019,
 66223,
 -1,
 156398982,
 66232,
 156633434,
 156193308,
 66218,
 156762111,
 156571644,
 66250,
 -63144,
 156634418,
 66253,
 -63143,
 156699850,
 66252,
 -1,
 156765235,
 66251,
 156961118,
 156588133,
 66229,
 -63140,
 156915813,
 66227,
 -63139,
 156972241,
 66244,
 -1,
 157033173,
 66238,
 157223265,
 156925461,
 66221,
 157351935,
 157187605,
 66247,
 -1,
 157223987,
 66230,
 157419876,
 157174594,
 66211,
 157548543,
 157360853,
 66214,
 -1,
 157420595,
 66254,
 157616486,
 157379938,
 66213,
 -1,
 157576546,
 66249,
 157747560,
 157574907,
 66231,
 -1,
 157682739,
 66209,
 157878634,
 157698109,
 66236,
 -1,
 157813811,
 66237,
 158009708,
 157826662,
 66233,
 -1,
 157957734,
 66245,
 158140782,
 157955281,
 66240,
 -1,
 158075955,
 66241,
 158271856,
 158083202,
 66234,
 -1,
 158207027,
 66255,
 158402930,
 158212821,
 66210,
 -1,
 158338099,
 66220,
 158534005,
 158342115,
 -1,
 -63116,
 158469423,
 66246,
 -1,
 158534691,
 66225,
 158730615,
 158469825,
 66208,
 -1,
 158665779,
 66215,
 -63112,
 158700411,
 66228,
 -63111,
 158821407,
 66216,
 -63110,
 158883039,
 66219,
 -1,
 158930940,
 66217,
 -63108,
 155742539,
 983073,
 -63107,
 159082276,
 127887,
 -63106,
 159147208,
 127904,
 -63105,
 159195887,
 128199,
 -1,
 159254102,
 9936,
 159451525,
 155680277,
 128008,
 159580159,
 159383998,
 128049,
 159645695,
 159451044,
 -1,
 -63100,
 159552349,
 128572,
 -1,
 159612856,
 128569,
 -63098,
 159415415,
 9963,
 -63097,
 159733188,
 128247,
 -63096,
 159796738,
 128197,
 -1,
 159851082,
 127797,
 160041415,
 147999554,
 -1,
 160106945,
 159997151,
 -1,
 160172474,
 160046918,
 -1,
 160238006,
 160104900,
 -1,
 160303515,
 160202261,
 -1,
 160369045,
 160272200,
 -1,
 160434578,
 160324831,
 -1,
 -63087,
 160369432,
 128349,
 -1,
 160433007,
 128337,
 160694271,
 160377807,
 -1,
 -63084,
 160566040,
 128359,
 -1,
 160629615,
 128347,
 160827800,
 160316773,
 -1,
 -63081,
 160762648,
 128350,
 -1,
 160826223,
 128338,
 161087487,
 160771076,
 -1,
 -63078,
 160959256,
 128357,
 -1,
 161022831,
 128345,
 161221026,
 160265606,
 -1,
 161286559,
 161171168,
 -1,
 -63074,
 161221400,
 128353,
 -1,
 161284975,
 128341,
 161546239,
 161230727,
 -1,
 -63071,
 161418008,
 128354,
 -1,
 161481583,
 128342,
 161679785,
 161165662,
 -1,
 161745318,
 161637490,
 -1,
 -63067,
 161680152,
 128351,
 -1,
 161743727,
 128339,
 162004991,
 161695375,
 -1,
 -63064,
 161876760,
 128352,
 -1,
 161940335,
 128340,
 162138544,
 161622146,
 -1,
 162204077,
 162090669,
 -1,
 -63060,
 162138904,
 128358,
 -1,
 162202479,
 128346,
 162463743,
 162152649,
 -1,
 -63057,
 162335512,
 128355,
 -1,
 162399087,
 128343,
 162597299,
 162095094,
 -1,
 -63054,
 162532120,
 128348,
 -1,
 162595695,
 128336,
 162856959,
 162552471,
 -1,
 -63051,
 162728728,
 128356,
 -1,
 162792303,
 128344,
 163053567,
 160207196,
 -1,
 163056057,
 162951787,
 128257,
 -1,
 162990056,
 128258,
 -1,
 162998162,
 128259,
 163315711,
 160134827,
 -1,
 163318206,
 163205863,
 -1,
 -63043,
 163278407,
 128235,
 -1,
 163336536,
 128234,
 -63041,
 163285163,
 127746,
 -63040,
 163467376,
 128272,
 -1,
 163519174,
 128213,
 163711428,
 160054886,
 -1,
 -63037,
 163670019,
 128203,
 -1,
 163732206,
 127867,
 163971071,
 163648675,
 -1,
 -63034,
 163857130,
 128079,
 -1,
 163917167,
 127916,
 164104688,
 159989350,
 -1,
 164170222,
 164065076,
 -1,
 164235757,
 164121902,
 -1,
 164301270,
 164191271,
 -1,
 164366799,
 164265493,
 -1,
 -63027,
 164335662,
 12873,
 -63026,
 164379620,
 12874,
 -1,
 164441140,
 12872,
 164628946,
 164328838,
 -1,
 -63023,
 164579074,
 12877,
 -1,
 164638650,
 12878,
 164825557,
 164573534,
 -1,
 -63020,
 164782874,
 12875,
 -1,
 164839537,
 12876,
 -1,
 164768614,
 12879,
 165087715,
 164249190,
 -1,
 165153248,
 165028910,
 -1,
 165218779,
 165103677,
 -1,
 -63014,
 165176298,
 12871,
 -1,
 165233215,
 12869,
 165415390,
 165154497,
 -1,
 -63011,
 165357654,
 127568,
 -1,
 165420359,
 127569,
 -63009,
 165377616,
 12870,
 -1,
 165571847,
 12868,
 165806079,
 165117741,
 -1,
 -63006,
 165703010,
 127276,
 -1,
 165747661,
 127275,
 165939688,
 165026765,
 -1,
 166005223,
 165901413,
 -1,
 -63002,
 165954307,
 9938,
 -1,
 166004190,
 128320,
 -1,
 165946069,
 127277,
 166267371,
 165890743,
 -1,
 -62998,
 166217775,
 12925,
 -1,
 166272443,
 12924,
 -62996,
 166237048,
 127278,
 -1,
 166410662,
 12926,
 -1,
 164203298,
 127914,
 -62993,
 164136471,
 127750,
 -1,
 166615532,
 127910,
 166791686,
 164064610,
 983074,
 166857214,
 166747359,
 -1,
 166922748,
 166820776,
 -1,
 166988279,
 166865458,
 -1,
 -62987,
 166952357,
 9876,
 -62986,
 167008699,
 127370,
 -1,
 167064392,
 127884,
 167250427,
 166920192,
 -1,
 167315962,
 167209598,
 128322,
 -1,
 167250095,
 128321,
 -1,
 167269356,
 10060,
 -1,
 167199491,
 9932,
 -62979,
 166892099,
 128081,
 -1,
 167518223,
 128010,
 167709187,
 166827055,
 -1,
 167774722,
 167658145,
 -1,
 -62975,
 167719358,
 128546,
 -1,
 167779564,
 128575,
 -1,
 167738401,
 128302,
 168099839,
 167651458,
 -1,
 -62971,
 167999045,
 127769,
 -1,
 168043859,
 128179,
 168233481,
 166733954,
 -1,
 -62968,
 168194195,
 9907,
 -1,
 168240280,
 8373,
 -62966,
 168196204,
 983187,
 -62965,
 168376167,
 983200,
 -1,
 168435113,
 983171,
 168628143,
 10370,
 -1,
 168693427,
 168573055,
 -1,
 168757902,
 168627905,
 -1,
 168823399,
 168692512,
 -1,
 168888863,
 168758578,
 -1,
 168954387,
 168824176,
 77877,
 -1,
 168890049,
 77878,
 169085461,
 168889546,
 77874,
 -1,
 169021121,
 77875,
 169216535,
 169020467,
 77872,
 -1,
 169152193,
 77873,
 169347609,
 169151264,
 77869,
 -1,
 169283265,
 77870,
 -62950,
 169283210,
 77882,
 -62949,
 169414230,
 77881,
 -62948,
 169479703,
 77880,
 -62947,
 169545181,
 77879,
 -62946,
 169610546,
 77876,
 -1,
 169675683,
 77871,
 169871916,
 168823715,
 -1,
 169937442,
 169807383,
 77844,
 -1,
 169873089,
 77845,
 170068516,
 169872690,
 77840,
 -1,
 170004161,
 77841,
 -62939,
 170004106,
 77847,
 -62938,
 170135126,
 77846,
 -62937,
 170200541,
 77843,
 -62936,
 170265968,
 77842,
 -62935,
 170331338,
 77839,
 -62934,
 170396723,
 77838,
 -62933,
 170462115,
 77837,
 -1,
 170527520,
 77836,
 170723897,
 169806624,
 -1,
 170789424,
 170659293,
 77830,
 -62929,
 170727420,
 77832,
 -1,
 170790593,
 77831,
 170986034,
 170724720,
 77828,
 -1,
 170921665,
 77829,
 -62925,
 170921610,
 77835,
 -62924,
 171052630,
 77834,
 -62923,
 171118103,
 77833,
 -62922,
 171183410,
 77827,
 -62921,
 171248842,
 77826,
 -62920,
 171314227,
 77825,
 -1,
 171379619,
 77824,
 171575877,
 170659018,
 -1,
 171641404,
 171510835,
 77860,
 -1,
 171577025,
 77861,
 -62915,
 171576970,
 77868,
 -62914,
 171707990,
 77867,
 -62913,
 171773463,
 77866,
 -62912,
 171838941,
 77865,
 -62911,
 171904368,
 77864,
 -62910,
 171969842,
 77863,
 -62909,
 172035274,
 77862,
 -62908,
 172100515,
 77859,
 -1,
 172165920,
 77858,
 172362320,
 171511261,
 -1,
 -62905,
 172297866,
 77902,
 -62904,
 172363350,
 77901,
 -62903,
 172428823,
 77900,
 -62902,
 172494301,
 77899,
 -62901,
 172559728,
 77898,
 -62900,
 172625202,
 77897,
 -62899,
 172690634,
 77896,
 -62898,
 172756019,
 77895,
 -62897,
 172821411,
 77894,
 -1,
 172886816,
 77893,
 173083227,
 172297584,
 -1,
 -62894,
 173018762,
 77892,
 -62893,
 173084246,
 77891,
 -62892,
 173149719,
 77890,
 -62891,
 173215197,
 77889,
 -62890,
 173280624,
 77888,
 -62889,
 173346098,
 77887,
 -62888,
 173411530,
 77886,
 -62887,
 173476915,
 77885,
 -62886,
 173542307,
 77884,
 -1,
 173607712,
 77883,
 173804134,
 173018163,
 -1,
 -62883,
 173739658,
 77857,
 -62882,
 173805142,
 77856,
 -62881,
 173870615,
 77855,
 -62880,
 173936093,
 77854,
 -62879,
 174001520,
 77853,
 -62878,
 174066994,
 77852,
 -62877,
 174132426,
 77851,
 -62876,
 174197811,
 77850,
 -62875,
 174263203,
 77849,
 -1,
 174328608,
 77848,
 -1,
 173739593,
 77903,
 174653439,
 168759085,
 -1,
 174656116,
 174525216,
 -1,
 174721644,
 174591511,
 78867,
 -62869,
 174659580,
 78869,
 -1,
 174722753,
 78868,
 -62867,
 174657162,
 78871,
 -62866,
 174853718,
 78870,
 -62865,
 174919133,
 78866,
 -62864,
 174984560,
 78865,
 -62863,
 175050034,
 78864,
 -62862,
 175115466,
 78863,
 -62861,
 175180851,
 78862,
 -1,
 175246243,
 78861,
 175442559,
 174591027,
 -1,
 -62858,
 175378058,
 78891,
 -62857,
 175443542,
 78890,
 -62856,
 175509015,
 78889,
 -62855,
 175574493,
 78888,
 -62854,
 175639920,
 78887,
 -62853,
 175705394,
 78886,
 -62852,
 175770826,
 78885,
 -62851,
 175836211,
 78884,
 -62850,
 175901603,
 78883,
 -1,
 175967008,
 78882,
 176163466,
 175377315,
 -1,
 -62847,
 176098954,
 78881,
 -62846,
 176164438,
 78880,
 -62845,
 176229911,
 78879,
 -62844,
 176295389,
 78878,
 -62843,
 176360816,
 78877,
 -62842,
 176426290,
 78876,
 -62841,
 176491722,
 78875,
 -62840,
 176557107,
 78874,
 -62839,
 176622499,
 78873,
 -1,
 176687904,
 78872,
 176947199,
 176098506,
 -1,
 -62836,
 176819251,
 78894,
 -62835,
 176884643,
 78893,
 -1,
 176950048,
 78892,
 177146621,
 168712293,
 -1,
 177212102,
 177081120,
 -1,
 177277599,
 177147082,
 -1,
 177343123,
 177212951,
 78361,
 -1,
 177278657,
 78362,
 177474197,
 177278320,
 78358,
 -1,
 177409729,
 78359,
 177605271,
 177409330,
 78356,
 -1,
 177540801,
 78357,
 177736345,
 177540298,
 78354,
 -1,
 177671873,
 78355,
 -62822,
 177671818,
 78364,
 -62821,
 177802838,
 78363,
 -62820,
 177868253,
 78360,
 -62819,
 177933363,
 78353,
 -62818,
 177998755,
 78352,
 -1,
 178064160,
 78351,
 178260652,
 177212323,
 -1,
 178326179,
 178196054,
 78336,
 -62814,
 178264060,
 78338,
 -1,
 178327233,
 78337,
 -62812,
 178261642,
 78339,
 -62811,
 178458135,
 78335,
 -62810,
 178523613,
 78334,
 -62809,
 178589040,
 78333,
 -62808,
 178654514,
 78332,
 -62807,
 178719946,
 78331,
 -62806,
 178785331,
 78330,
 -62805,
 178850723,
 78329,
 -1,
 178916128,
 78328,
 179112632,
 178195507,
 -1,
 179178159,
 179047792,
 78345,
 -1,
 179113665,
 78346,
 -62800,
 179113610,
 78350,
 -62799,
 179244630,
 78349,
 -62798,
 179310103,
 78348,
 -62797,
 179375581,
 78347,
 -62796,
 179440946,
 78344,
 -62795,
 179506378,
 78343,
 -62794,
 179571763,
 78342,
 -62793,
 179637155,
 78341,
 -1,
 179702560,
 78340,
 179899074,
 179047200,
 -1,
 -62790,
 179834506,
 78327,
 -62789,
 179899990,
 78326,
 -62788,
 179965463,
 78325,
 -62787,
 180030941,
 78324,
 -62786,
 180096368,
 78323,
 -62785,
 180161842,
 78322,
 -62784,
 180227274,
 78321,
 -62783,
 180292659,
 78320,
 -1,
 180358051,
 78319,
 180617215,
 179834162,
 -1,
 -62780,
 180489267,
 78367,
 -62779,
 180554659,
 78366,
 -1,
 180620064,
 78365,
 180816612,
 177178244,
 -1,
 180882133,
 180751267,
 -1,
 180947658,
 180817494,
 78409,
 -1,
 180883137,
 78410,
 181078732,
 180882339,
 78401,
 -1,
 181014209,
 78402,
 181209806,
 181013280,
 78399,
 -1,
 181145281,
 78400,
 -62769,
 181145226,
 78411,
 -62768,
 181276183,
 78408,
 -62767,
 181341661,
 78407,
 -62766,
 181407088,
 78406,
 -62765,
 181472562,
 78405,
 -62764,
 181537994,
 78404,
 -1,
 181603379,
 78403,
 181799647,
 180816672,
 -1,
 -62761,
 181735050,
 78398,
 -62760,
 181800534,
 78397,
 -62759,
 181866007,
 78396,
 -62758,
 181931485,
 78395,
 -62757,
 181996912,
 78394,
 -62756,
 182062386,
 78393,
 -62755,
 182127818,
 78392,
 -62754,
 182193203,
 78391,
 -1,
 182258595,
 78390,
 182517759,
 181734451,
 -1,
 182520546,
 182389811,
 78414,
 -1,
 182456001,
 78415,
 -62749,
 182455203,
 78413,
 -1,
 182586144,
 78412,
 182845439,
 180767590,
 -1,
 182848241,
 182717347,
 -1,
 182913768,
 182783511,
 78385,
 -1,
 182849217,
 78386,
 -62743,
 182849162,
 78388,
 -62742,
 182980182,
 78387,
 -62741,
 183045597,
 78384,
 -62740,
 183111024,
 78383,
 -62739,
 183176498,
 78382,
 -62738,
 183241930,
 78381,
 -62737,
 183307315,
 78380,
 -62736,
 183372707,
 78379,
 -1,
 183438112,
 78378,
 183634684,
 182782752,
 -1,
 183700212,
 183569776,
 78372,
 -1,
 183635649,
 78373,
 -62731,
 183635594,
 78377,
 -62730,
 183766614,
 78376,
 -62729,
 183832087,
 78375,
 -62728,
 183897565,
 78374,
 -62727,
 183962930,
 78371,
 -62726,
 184028362,
 78370,
 -62725,
 184093747,
 78369,
 -1,
 184159139,
 78368,
 -1,
 183569577,
 78389,
 184421217,
 177087271,
 -1,
 184486676,
 184356208,
 -1,
 184552201,
 184421152,
 77997,
 -62719,
 184499814,
 78006,
 -62718,
 184563874,
 78005,
 -62717,
 184628433,
 78004,
 -62716,
 184693086,
 78003,
 -62715,
 184756354,
 78002,
 -62714,
 184820437,
 78001,
 -62713,
 184884173,
 78000,
 -62712,
 184948732,
 77999,
 -1,
 185011905,
 77998,
 185207563,
 184487218,
 78011,
 -1,
 185142977,
 78012,
 185338637,
 185142323,
 78008,
 -1,
 185274049,
 78009,
 -62706,
 185273994,
 78017,
 -62705,
 185405014,
 78016,
 -62704,
 185470487,
 78015,
 -62703,
 185535965,
 78014,
 -62702,
 185601392,
 78013,
 -62701,
 185666762,
 78010,
 -1,
 185732003,
 78007,
 185928485,
 184421853,
 -1,
 185994014,
 185863703,
 78025,
 -62697,
 185940130,
 78033,
 -62696,
 186004689,
 78032,
 -62695,
 186069342,
 78031,
 -62694,
 186132610,
 78030,
 -62693,
 186196693,
 78029,
 -62692,
 186260429,
 78028,
 -62691,
 186324988,
 78027,
 -1,
 186388161,
 78026,
 -62689,
 185929181,
 78024,
 -62688,
 186518896,
 78023,
 -62687,
 186584370,
 78022,
 -62686,
 186649802,
 78021,
 -62685,
 186715187,
 78020,
 -62684,
 186780579,
 78019,
 -1,
 186845984,
 78018,
 187042610,
 185863474,
 -1,
 187108136,
 186977878,
 77994,
 -1,
 187043521,
 77995,
 187239210,
 187043293,
 77991,
 -1,
 187174593,
 77992,
 -62677,
 187174538,
 77996,
 -62676,
 187305495,
 77993,
 -62675,
 187370864,
 77990,
 -62674,
 187436338,
 77989,
 -62673,
 187501770,
 77988,
 -62672,
 187567155,
 77987,
 -62671,
 187632547,
 77986,
 -1,
 187697952,
 77985,
 187894591,
 186977482,
 -1,
 187960117,
 187829554,
 77978,
 -1,
 187895489,
 77979,
 188091191,
 187894691,
 77974,
 -1,
 188026561,
 77975,
 -62664,
 188026506,
 77984,
 -62663,
 188157526,
 77983,
 -62662,
 188222999,
 77982,
 -62661,
 188288477,
 77981,
 -62660,
 188353904,
 77980,
 -62659,
 188419274,
 77977,
 -62658,
 188484659,
 77976,
 -1,
 188549920,
 77973,
 188746571,
 187829299,
 -1,
 188812098,
 188681751,
 77969,
 -1,
 188747457,
 77970,
 -62653,
 188747402,
 77972,
 -62652,
 188878422,
 77971,
 -62651,
 188943837,
 77968,
 -62650,
 189009264,
 77967,
 -62649,
 189074738,
 77966,
 -62648,
 189140170,
 77965,
 -62647,
 189205555,
 77964,
 -62646,
 189270947,
 77963,
 -1,
 189336352,
 77962,
 189533014,
 188681123,
 -1,
 -62643,
 189468298,
 77961,
 -62642,
 189533782,
 77960,
 -62641,
 189599255,
 77959,
 -62640,
 189664733,
 77958,
 -62639,
 189730160,
 77957,
 -62638,
 189795634,
 77956,
 -62637,
 189861066,
 77955,
 -62636,
 189926451,
 77954,
 -62635,
 189991843,
 77953,
 -1,
 190057248,
 77952,
 190316543,
 189467424,
 -1,
 190319449,
 190189142,
 77949,
 -1,
 190254785,
 77950,
 -62630,
 190254730,
 77951,
 -62629,
 190385687,
 77948,
 -62628,
 190451165,
 77947,
 -62627,
 190516592,
 77946,
 -62626,
 190582066,
 77945,
 -62625,
 190647498,
 77944,
 -62624,
 190712883,
 77943,
 -1,
 190778275,
 77942,
 190974899,
 184388547,
 -1,
 191040380,
 190909491,
 -1,
 191105904,
 190974752,
 78726,
 -62619,
 191056706,
 78738,
 -62618,
 191121469,
 78737,
 -62617,
 191186743,
 78736,
 -62616,
 191250022,
 78735,
 -62615,
 191314082,
 78734,
 -62614,
 191378641,
 78733,
 -62613,
 191443294,
 78732,
 -62612,
 191506562,
 78731,
 -62611,
 191570645,
 78730,
 -62610,
 191634381,
 78729,
 -62609,
 191698940,
 78728,
 -1,
 191762113,
 78727,
 191957874,
 191041162,
 78749,
 -1,
 191893185,
 78750,
 192088948,
 191893078,
 78747,
 -1,
 192024257,
 78748,
 192220022,
 192023754,
 78741,
 -1,
 192155329,
 78742,
 -62601,
 192155159,
 78746,
 -62600,
 192286173,
 78745,
 -62599,
 192351600,
 78744,
 -62598,
 192417074,
 78743,
 -62597,
 192482355,
 78740,
 -1,
 192547747,
 78739,
 192744338,
 190974752,
 -1,
 192809863,
 192678819,
 78690,
 -62593,
 192757350,
 78699,
 -62592,
 192821410,
 78698,
 -62591,
 192885969,
 78697,
 -62590,
 192950622,
 78696,
 -62589,
 193013890,
 78695,
 -62588,
 193077973,
 78694,
 -62587,
 193141709,
 78693,
 -62586,
 193206268,
 78692,
 -1,
 193269441,
 78691,
 193465226,
 192744983,
 78706,
 -62583,
 193402876,
 78708,
 -1,
 193466049,
 78707,
 193661836,
 193399859,
 78700,
 -1,
 193597121,
 78701,
 -62579,
 193597066,
 78710,
 -62578,
 193728086,
 78709,
 -62577,
 193793501,
 78705,
 -62576,
 193858928,
 78704,
 -62575,
 193924402,
 78703,
 -1,
 193989834,
 78702,
 194186146,
 192678819,
 -1,
 194251671,
 194120611,
 78712,
 -62571,
 194190285,
 78715,
 -62570,
 194254844,
 78714,
 -1,
 194318017,
 78713,
 194513818,
 194186291,
 78716,
 -62567,
 194451452,
 78718,
 -1,
 194514625,
 78717,
 -62565,
 194449034,
 78725,
 -62564,
 194645590,
 78724,
 -62563,
 194711063,
 78723,
 -62562,
 194776541,
 78722,
 -62561,
 194841968,
 78721,
 -62560,
 194907442,
 78720,
 -62559,
 194972874,
 78719,
 -1,
 195037984,
 78711,
 195234737,
 194120906,
 -1,
 195300261,
 195169815,
 78761,
 -1,
 195235521,
 78762,
 195431335,
 195235018,
 78756,
 -1,
 195366593,
 78757,
 195562409,
 195365795,
 78753,
 -1,
 195497665,
 78754,
 195693483,
 195496736,
 78751,
 -1,
 195628737,
 78752,
 -62548,
 195628682,
 78764,
 -62547,
 195759702,
 78763,
 -62546,
 195825117,
 78760,
 -62545,
 195890544,
 78759,
 -62544,
 195956018,
 78758,
 -1,
 196021299,
 78755,
 196280319,
 195169636,
 78765,
 -1,
 196153025,
 78766,
 196348933,
 190930187,
 -1,
 196414406,
 196283168,
 -1,
 196479932,
 196349405,
 78423,
 -62537,
 196424030,
 78429,
 -62536,
 196487298,
 78428,
 -62535,
 196551381,
 78427,
 -62534,
 196615117,
 78426,
 -62533,
 196679676,
 78425,
 -1,
 196742849,
 78424,
 196938686,
 196414832,
 78421,
 -1,
 196873921,
 78422,
 197069760,
 196873123,
 78416,
 -1,
 197004993,
 78417,
 -62527,
 197004938,
 78432,
 -62526,
 197135958,
 78431,
 -62525,
 197201431,
 78430,
 -62524,
 197266738,
 78420,
 -62523,
 197332170,
 78419,
 -1,
 197397555,
 78418,
 197594071,
 196349130,
 -1,
 197659596,
 197529053,
 78469,
 -62519,
 197599957,
 78473,
 -62518,
 197663693,
 78472,
 -62517,
 197728252,
 78471,
 -1,
 197791425,
 78470,
 197987278,
 197594314,
 78465,
 -1,
 197922497,
 78466,
 198118352,
 197921568,
 78461,
 -1,
 198053569,
 78462,
 -62511,
 198053514,
 78476,
 -62510,
 198184534,
 78475,
 -62509,
 198250007,
 78474,
 -62508,
 198315376,
 78468,
 -62507,
 198380850,
 78467,
 -62506,
 198446131,
 78464,
 -1,
 198511523,
 78463,
 198708198,
 197528627,
 -1,
 198773722,
 198643338,
 78459,
 -1,
 198708929,
 78460,
 198904796,
 198708592,
 78454,
 -1,
 198840001,
 78455,
 199035870,
 198839602,
 78452,
 -1,
 198971073,
 78453,
 199166944,
 198970144,
 78447,
 -1,
 199102145,
 78448,
 -62495,
 199102038,
 78458,
 -62494,
 199233047,
 78457,
 -62493,
 199298525,
 78456,
 -62492,
 199363786,
 78451,
 -62491,
 199429171,
 78450,
 -1,
 199494563,
 78449,
 199691253,
 198642595,
 -1,
 199756779,
 199625504,
 78433,
 -62487,
 199695309,
 78436,
 -62486,
 199759868,
 78435,
 -1,
 199823041,
 78434,
 200018925,
 199691914,
 78445,
 -1,
 199954113,
 78446,
 -62482,
 199954006,
 78444,
 -62481,
 200085015,
 78443,
 -62480,
 200150493,
 78442,
 -62479,
 200215920,
 78441,
 -62478,
 200281394,
 78440,
 -62477,
 200346826,
 78439,
 -62476,
 200412211,
 78438,
 -1,
 200477603,
 78437,
 200674304,
 199626034,
 -1,
 -62473,
 200609418,
 78486,
 -62472,
 200674902,
 78485,
 -62471,
 200740375,
 78484,
 -62470,
 200805853,
 78483,
 -62469,
 200871280,
 78482,
 -62468,
 200936754,
 78481,
 -62467,
 201002186,
 78480,
 -62466,
 201067571,
 78479,
 -62465,
 201132963,
 78478,
 -1,
 201198368,
 78477,
 201457663,
 200609136,
 -1,
 201460740,
 201329440,
 78487,
 -62461,
 201398268,
 78489,
 -1,
 201461441,
 78488,
 -1,
 201395107,
 78490,
 201722957,
 196301426,
 -1,
 201788445,
 201657251,
 -1,
 201853968,
 201722931,
 78268,
 -62455,
 201799842,
 78276,
 -62454,
 201864401,
 78275,
 -62453,
 201929054,
 78274,
 -62452,
 201992322,
 78273,
 -62451,
 202056405,
 78272,
 -62450,
 202120141,
 78271,
 -62449,
 202184700,
 78270,
 -1,
 202247873,
 78269,
 202443794,
 201788951,
 78283,
 -1,
 202378945,
 78284,
 202574868,
 202378717,
 78281,
 -1,
 202510017,
 78282,
 202705942,
 202509680,
 78279,
 -1,
 202641089,
 78280,
 202837016,
 202640160,
 78265,
 -1,
 202772161,
 78266,
 -62439,
 202772106,
 78286,
 -62438,
 202903126,
 78285,
 -62437,
 202968370,
 78278,
 -62436,
 203033802,
 78277,
 -1,
 203099043,
 78267,
 203295787,
 201723082,
 -1,
 203361313,
 203230410,
 78304,
 -62432,
 203298812,
 78306,
 -1,
 203361985,
 78305,
 203557923,
 203295651,
 78301,
 -1,
 203493057,
 78302,
 -62428,
 203493002,
 78312,
 -62427,
 203624022,
 78311,
 -62426,
 203689495,
 78310,
 -62425,
 203754973,
 78309,
 -62424,
 203820400,
 78308,
 -62423,
 203885874,
 78307,
 -62422,
 203951155,
 78303,
 -1,
 204016416,
 78300,
 204213305,
 203230259,
 -1,
 204278830,
 204148310,
 78297,
 -1,
 204213953,
 78298,
 204409904,
 204213554,
 78292,
 -1,
 204345025,
 78293,
 204540978,
 204344371,
 78289,
 -1,
 204476097,
 78290,
 -62413,
 204476042,
 78299,
 -62412,
 204606999,
 78296,
 -62411,
 204672477,
 78295,
 -62410,
 204737904,
 78294,
 -62409,
 204803274,
 78291,
 -62408,
 204868515,
 78288,
 -1,
 204933920,
 78287,
 205130822,
 204147488,
 -1,
 205196349,
 205065123,
 78253,
 -62404,
 205133820,
 78255,
 -1,
 205196993,
 78254,
 205392959,
 205130954,
 78257,
 -1,
 205328065,
 78258,
 -62400,
 205328010,
 78264,
 -62399,
 205459030,
 78263,
 -62398,
 205524503,
 78262,
 -62397,
 205589981,
 78261,
 -62396,
 205655408,
 78260,
 -62395,
 205720882,
 78259,
 -1,
 205786163,
 78256,
 206045183,
 205065522,
 -1,
 206048329,
 205916960,
 78313,
 -1,
 205983425,
 78314,
 -62390,
 205983026,
 78318,
 -62389,
 206113994,
 78317,
 -62388,
 206179379,
 78316,
 -1,
 206244771,
 78315,
 206441621,
 201666989,
 -1,
 206507100,
 206376242,
 -1,
 206572625,
 206442007,
 78132,
 -1,
 206507713,
 78133,
 206703699,
 206507485,
 78130,
 -1,
 206638785,
 78131,
 206834773,
 206638448,
 78128,
 -1,
 206769857,
 78129,
 -62378,
 206769802,
 78135,
 -62377,
 206900822,
 78134,
 -62376,
 206966066,
 78127,
 -62375,
 207031498,
 78126,
 -62374,
 207096883,
 78125,
 -62373,
 207162275,
 78124,
 -1,
 207227680,
 78123,
 207424618,
 206441674,
 -1,
 207490143,
 207359574,
 78120,
 -1,
 207425217,
 78121,
 207621217,
 207425047,
 78118,
 -1,
 207556289,
 78119,
 207752291,
 207555491,
 78111,
 -1,
 207687361,
 78112,
 -62364,
 207687306,
 78122,
 -62363,
 207818205,
 78117,
 -62362,
 207883632,
 78116,
 -62361,
 207949106,
 78115,
 -62360,
 208014538,
 78114,
 -62359,
 208079923,
 78113,
 -1,
 208145184,
 78110,
 208342134,
 207359027,
 -1,
 208407661,
 208276387,
 78100,
 -1,
 208342721,
 78101,
 -62354,
 208342666,
 78109,
 -62353,
 208473686,
 78108,
 -62352,
 208539159,
 78107,
 -62351,
 208604637,
 78106,
 -62350,
 208670064,
 78105,
 -62349,
 208735538,
 78104,
 -62348,
 208800970,
 78103,
 -62347,
 208866355,
 78102,
 -1,
 208931616,
 78099,
 209128578,
 208276387,
 -1,
 209194105,
 209063114,
 78091,
 -1,
 209129153,
 78092,
 -62342,
 209129098,
 78098,
 -62341,
 209260118,
 78097,
 -62340,
 209325591,
 78096,
 -62339,
 209391069,
 78095,
 -62338,
 209456496,
 78094,
 -62337,
 209521970,
 78093,
 -62336,
 209587251,
 78090,
 -62335,
 209652643,
 78089,
 -1,
 209718048,
 78088,
 209915021,
 209062688,
 -1,
 209980549,
 209849251,
 78078,
 -1,
 209915585,
 78079,
 -62330,
 209915530,
 78087,
 -62329,
 210046550,
 78086,
 -62328,
 210112023,
 78085,
 -62327,
 210177501,
 78084,
 -62326,
 210242928,
 78083,
 -62325,
 210308402,
 78082,
 -62324,
 210373834,
 78081,
 -1,
 210439219,
 78080,
 210698239,
 209849712,
 -1,
 210701458,
 210570147,
 78137,
 -62320,
 210639821,
 78140,
 -62319,
 210704380,
 78139,
 -1,
 210767553,
 78138,
 -62317,
 210635978,
 78142,
 -62316,
 210897971,
 78141,
 -1,
 210963232,
 78136,
 211160284,
 206386423,
 -1,
 211225763,
 211094834,
 -1,
 211291289,
 211160432,
 78196,
 -1,
 211226305,
 78197,
 211422363,
 211225802,
 78193,
 -1,
 211357377,
 78194,
 -62308,
 211357322,
 78201,
 -62307,
 211488342,
 78200,
 -62306,
 211553815,
 78199,
 -62305,
 211619293,
 78198,
 -62304,
 211684658,
 78195,
 -62303,
 211749939,
 78192,
 -62302,
 211815331,
 78191,
 -1,
 211880736,
 78190,
 212077744,
 211160266,
 -1,
 212143270,
 212012567,
 78186,
 -1,
 212078273,
 78187,
 212274344,
 212078045,
 78184,
 -1,
 212209345,
 78185,
 -62295,
 212209290,
 78189,
 -62294,
 212340310,
 78188,
 -62293,
 212405616,
 78183,
 -62292,
 212471090,
 78182,
 -62291,
 212536522,
 78181,
 -62290,
 212601907,
 78180,
 -62289,
 212667299,
 78179,
 -1,
 212732704,
 78178,
 212929725,
 212012083,
 -1,
 212995251,
 212864477,
 78173,
 -1,
 212930241,
 78174,
 213126325,
 212929312,
 78166,
 -1,
 213061313,
 78167,
 -62282,
 213061258,
 78177,
 -62281,
 213192278,
 78176,
 -62280,
 213257751,
 78175,
 -62279,
 213323120,
 78172,
 -62278,
 213388594,
 78171,
 -62277,
 213454026,
 78170,
 -62276,
 213519411,
 78169,
 -1,
 213584803,
 78168,
 213781706,
 212863776,
 -1,
 213847233,
 213716503,
 78150,
 -62272,
 213784572,
 78152,
 -1,
 213847745,
 78151,
 214043843,
 213781981,
 78148,
 -1,
 213978817,
 78149,
 -62268,
 213978762,
 78154,
 -62267,
 214109782,
 78153,
 -62266,
 214175088,
 78147,
 -62265,
 214240562,
 78146,
 -62264,
 214305994,
 78145,
 -62263,
 214371379,
 78144,
 -1,
 214436771,
 78143,
 214633686,
 213715875,
 -1,
 214699213,
 214567843,
 78156,
 -1,
 214634177,
 78157,
 -62258,
 214634122,
 78165,
 -62257,
 214765142,
 78164,
 -62256,
 214830615,
 78163,
 -62255,
 214896093,
 78162,
 -62254,
 214961520,
 78161,
 -62253,
 215026994,
 78160,
 -62252,
 215092426,
 78159,
 -62251,
 215157811,
 78158,
 -1,
 215223072,
 78155,
 215482367,
 214568304,
 -1,
 -62248,
 215354674,
 78206,
 -62247,
 215420106,
 78205,
 -62246,
 215485491,
 78204,
 -62245,
 215550883,
 78203,
 -1,
 215616288,
 78202,
 215813400,
 211121623,
 -1,
 215878891,
 215747491,
 -1,
 215944417,
 215813426,
 78560,
 -62240,
 215881724,
 78562,
 -1,
 215944897,
 78561,
 216141027,
 215879191,
 78565,
 -1,
 216075969,
 78566,
 -62236,
 216075914,
 78568,
 -62235,
 216206934,
 78567,
 -62234,
 216272349,
 78564,
 -62233,
 216337776,
 78563,
 -62232,
 216403146,
 78559,
 -62231,
 216468531,
 78558,
 -62230,
 216533923,
 78557,
 -1,
 216599328,
 78556,
 216796408,
 215813171,
 -1,
 216861935,
 216731101,
 78575,
 -62226,
 216799228,
 78577,
 -1,
 216862401,
 78576,
 -62224,
 216796810,
 78580,
 -62223,
 216993366,
 78579,
 -62222,
 217058839,
 78578,
 -62221,
 217124208,
 78574,
 -62220,
 217189682,
 78573,
 -62219,
 217255114,
 78572,
 -62218,
 217320499,
 78571,
 -62217,
 217385891,
 78570,
 -1,
 217451296,
 78569,
 217648388,
 216730826,
 -1,
 217713915,
 217582960,
 78586,
 -1,
 217648833,
 78587,
 -62212,
 217648778,
 78591,
 -62211,
 217779798,
 78590,
 -62210,
 217845271,
 78589,
 -62209,
 217910749,
 78588,
 -62208,
 217976114,
 78585,
 -62207,
 218041546,
 78584,
 -62206,
 218106931,
 78583,
 -62205,
 218172323,
 78582,
 -1,
 218237728,
 78581,
 218434832,
 217582368,
 -1,
 218500359,
 218369501,
 78551,
 -1,
 218435265,
 78552,
 218631433,
 218434611,
 78546,
 -1,
 218566337,
 78547,
 -62198,
 218566282,
 78555,
 -62197,
 218697302,
 78554,
 -62196,
 218762775,
 78553,
 -62195,
 218828144,
 78550,
 -62194,
 218893618,
 78549,
 -62193,
 218959050,
 78548,
 -1,
 219024291,
 78545,
 219283455,
 218369330,
 -1,
 -62190,
 219155933,
 78598,
 -62189,
 219221360,
 78597,
 -62188,
 219286834,
 78596,
 -62187,
 219352266,
 78595,
 -62186,
 219417651,
 78594,
 -62185,
 219483043,
 78593,
 -1,
 219548448,
 78592,
 219745613,
 215778948,
 -1,
 219811110,
 219679795,
 -1,
 219876636,
 219745930,
 78674,
 -1,
 219811521,
 78675,
 220007710,
 219811018,
 78667,
 -1,
 219942593,
 78668,
 -62177,
 219942486,
 78673,
 -62176,
 220073495,
 78672,
 -62175,
 220138973,
 78671,
 -62174,
 220204400,
 78670,
 -62173,
 220269874,
 78669,
 -62172,
 220335155,
 78666,
 -62171,
 220400547,
 78665,
 -1,
 220465952,
 78664,
 220663090,
 219745482,
 -1,
 220728617,
 220597299,
 78678,
 -1,
 220663489,
 78679,
 -62166,
 220663434,
 78686,
 -62165,
 220794454,
 78685,
 -62164,
 220859927,
 78684,
 -62163,
 220925405,
 78683,
 -62162,
 220990832,
 78682,
 -62161,
 221056306,
 78681,
 -62160,
 221121738,
 78680,
 -62159,
 221186979,
 78677,
 -1,
 221252384,
 78676,
 221449534,
 220597024,
 -1,
 221515062,
 221384157,
 78648,
 -62155,
 221452284,
 78650,
 -1,
 221515457,
 78649,
 -62153,
 221449866,
 78653,
 -62152,
 221646422,
 78652,
 -62151,
 221711895,
 78651,
 -62150,
 221777264,
 78647,
 -62149,
 221842738,
 78646,
 -62148,
 221908170,
 78645,
 -62147,
 221973555,
 78644,
 -1,
 222038947,
 78643,
 222235977,
 221383587,
 -1,
 -62144,
 222170762,
 78663,
 -62143,
 222236246,
 78662,
 -62142,
 222301719,
 78661,
 -62141,
 222367197,
 78660,
 -62140,
 222432624,
 78659,
 -62139,
 222498098,
 78658,
 -62138,
 222563530,
 78657,
 -62137,
 222628915,
 78656,
 -62136,
 222694307,
 78655,
 -1,
 222759712,
 78654,
 223019007,
 222170418,
 -1,
 -62133,
 222891059,
 78689,
 -62132,
 222956451,
 78688,
 -1,
 223021856,
 78687,
 223219070,
 219709064,
 -1,
 223284572,
 223152928,
 -1,
 223350097,
 223219338,
 78610,
 -1,
 223284929,
 78611,
 223481171,
 223284822,
 78608,
 -1,
 223416001,
 78609,
 223612245,
 223415831,
 78606,
 -1,
 223547073,
 78607,
 223743319,
 223546570,
 78601,
 -1,
 223678145,
 78602,
 -62120,
 223677917,
 78605,
 -62119,
 223808880,
 78604,
 -62118,
 223874354,
 78603,
 -62117,
 223939635,
 78600,
 -1,
 224005027,
 78599,
 224202089,
 223218595,
 -1,
 224267615,
 224136669,
 78619,
 -1,
 224202433,
 78620,
 224398689,
 224201635,
 78613,
 -1,
 224333505,
 78614,
 -62110,
 224333450,
 78623,
 -62109,
 224464470,
 78622,
 -62108,
 224529943,
 78621,
 -62107,
 224595312,
 78618,
 -62106,
 224660786,
 78617,
 -62105,
 224726218,
 78616,
 -62104,
 224791603,
 78615,
 -1,
 224856864,
 78612,
 225054068,
 224136243,
 -1,
 -62101,
 224988810,
 78633,
 -62100,
 225054294,
 78632,
 -62099,
 225119767,
 78631,
 -62098,
 225185245,
 78630,
 -62097,
 225250672,
 78629,
 -62096,
 225316146,
 78628,
 -62095,
 225381578,
 78627,
 -62094,
 225446963,
 78626,
 -62093,
 225512355,
 78625,
 -1,
 225577760,
 78624,
 225837055,
 224988362,
 -1,
 225840503,
 225709258,
 78638,
 -1,
 225775297,
 78639,
 225971577,
 225774643,
 78636,
 -1,
 225906369,
 78637,
 -62086,
 225906141,
 78642,
 -62085,
 226037104,
 78641,
 -62084,
 226102578,
 78640,
 -62083,
 226167715,
 78635,
 -1,
 226233120,
 78634,
 226430383,
 223160684,
 -1,
 226495884,
 226364467,
 -1,
 226561410,
 226430550,
 78066,
 -1,
 226496193,
 78067,
 226692484,
 226495264,
 78057,
 -1,
 226627265,
 78058,
 -62075,
 226627210,
 78068,
 -62074,
 226758167,
 78065,
 -62073,
 226823645,
 78064,
 -62072,
 226889072,
 78063,
 -62071,
 226954546,
 78062,
 -62070,
 227019978,
 78061,
 -62069,
 227085363,
 78060,
 -1,
 227150755,
 78059,
 227347865,
 226429859,
 -1,
 227413391,
 227282455,
 78053,
 -1,
 227348161,
 78054,
 227544465,
 227347933,
 78051,
 -1,
 227479233,
 78052,
 -62062,
 227479178,
 78056,
 -62061,
 227610198,
 78055,
 -62060,
 227675504,
 78050,
 -62059,
 227740978,
 78049,
 -62058,
 227806410,
 78048,
 -62057,
 227871795,
 78047,
 -62056,
 227937187,
 78046,
 -1,
 228002592,
 78045,
 228199845,
 227281696,
 -1,
 228265372,
 228134538,
 78043,
 -1,
 228200129,
 78044,
 228396446,
 228200022,
 78041,
 -1,
 228331201,
 78042,
 -62049,
 228331031,
 78040,
 -62048,
 228462045,
 78039,
 -62047,
 228527472,
 78038,
 -62046,
 228592946,
 78037,
 -62045,
 228658378,
 78036,
 -62044,
 228723763,
 78035,
 -1,
 228789155,
 78034,
 229048319,
 228134090,
 -1,
 229051816,
 228920626,
 78073,
 -1,
 228986561,
 78074,
 -62039,
 228986454,
 78077,
 -62038,
 229117463,
 78076,
 -62037,
 229182941,
 78075,
 -62036,
 229248202,
 78072,
 -62035,
 229313587,
 78071,
 -62034,
 229378979,
 78070,
 -1,
 229444384,
 78069,
 229641691,
 226399769,
 -1,
 229707209,
 229575587,
 -1,
 229772731,
 229641584,
 78842,
 -62029,
 229719654,
 78851,
 -62028,
 229783714,
 78850,
 -62027,
 229848273,
 78849,
 -62026,
 229912926,
 78848,
 -62025,
 229976194,
 78847,
 -62024,
 230040277,
 78846,
 -62023,
 230104013,
 78845,
 -62022,
 230168572,
 78844,
 -1,
 230231745,
 78843,
 230428100,
 229707229,
 78852,
 -62019,
 230373538,
 78860,
 -62018,
 230438097,
 78859,
 -62017,
 230502750,
 78858,
 -62016,
 230566018,
 78857,
 -62015,
 230630101,
 78856,
 -62014,
 230693837,
 78855,
 -62013,
 230758396,
 78854,
 -1,
 230821569,
 78853,
 -62011,
 230362418,
 78841,
 -62010,
 230952138,
 78840,
 -62009,
 231017523,
 78839,
 -62008,
 231082915,
 78838,
 -1,
 231148320,
 78837,
 231407615,
 229640992,
 -1,
 231411151,
 231279667,
 78821,
 -62004,
 231350997,
 78825,
 -62003,
 231414733,
 78824,
 -62002,
 231479292,
 78823,
 -1,
 231542465,
 78822,
 231738834,
 231345354,
 78826,
 -61999,
 231675900,
 78828,
 -1,
 231739073,
 78827,
 231935444,
 231673200,
 78831,
 -1,
 231870145,
 78832,
 232066518,
 231869746,
 78829,
 -1,
 232001217,
 78830,
 -61993,
 232001162,
 78836,
 -61992,
 232132182,
 78835,
 -61991,
 232197655,
 78834,
 -61990,
 232263133,
 78833,
 -1,
 232328099,
 78820,
 232525313,
 229600684,
 -1,
 232590825,
 232459171,
 -1,
 232656351,
 232525277,
 78530,
 -1,
 232591041,
 78531,
 232787425,
 232590112,
 78523,
 -1,
 232722113,
 78524,
 -61982,
 232722058,
 78534,
 -61981,
 232853078,
 78533,
 -61980,
 232918551,
 78532,
 -61979,
 232983920,
 78529,
 -61978,
 233049394,
 78528,
 -61977,
 233114826,
 78527,
 -61976,
 233180211,
 78526,
 -1,
 233245603,
 78525,
 233442806,
 232524576,
 -1,
 233508333,
 233376970,
 78514,
 -61972,
 233445372,
 78516,
 -1,
 233508545,
 78515,
 233704943,
 233442355,
 78512,
 -1,
 233639617,
 78513,
 -61968,
 233639562,
 78522,
 -61967,
 233770582,
 78521,
 -61966,
 233836055,
 78520,
 -61965,
 233901533,
 78519,
 -61964,
 233966960,
 78518,
 -61963,
 234032434,
 78517,
 -1,
 234097571,
 78511,
 234356735,
 233376819,
 -1,
 -61960,
 234229386,
 78544,
 -61959,
 234294870,
 78543,
 -61958,
 234360343,
 78542,
 -61957,
 234425821,
 78541,
 -61956,
 234491248,
 78540,
 -61955,
 234556722,
 78539,
 -61954,
 234622154,
 78538,
 -61953,
 234687539,
 78537,
 -61952,
 234752931,
 78536,
 -1,
 234818336,
 78535,
 235015717,
 232492940,
 -1,
 235081233,
 234949539,
 -1,
 235146757,
 235015766,
 78789,
 -1,
 235081409,
 78790,
 235277831,
 235081239,
 78787,
 -1,
 235212481,
 78788,
 235408905,
 235212082,
 78783,
 -1,
 235343553,
 78784,
 235539979,
 235342624,
 78778,
 -1,
 235474625,
 78779,
 -61940,
 235474570,
 78791,
 -61939,
 235605469,
 78786,
 -61938,
 235670896,
 78785,
 -61937,
 235736266,
 78782,
 -61936,
 235801651,
 78781,
 -1,
 235867043,
 78780,
 236064285,
 235014944,
 -1,
 236129812,
 235998858,
 78776,
 -1,
 236064449,
 78777,
 236260886,
 236063946,
 78769,
 -1,
 236195521,
 78770,
 -61929,
 236195414,
 78775,
 -61928,
 236326423,
 78774,
 -61927,
 236391901,
 78773,
 -61926,
 236457328,
 78772,
 -61925,
 236522802,
 78771,
 -61924,
 236588083,
 78768,
 -1,
 236653475,
 78767,
 236912639,
 235998259,
 -1,
 236916256,
 236784946,
 78796,
 -1,
 236850881,
 78797,
 -61919,
 236850544,
 78798,
 -61918,
 236981450,
 78795,
 -61917,
 237046835,
 78794,
 -61916,
 237112227,
 78793,
 -1,
 237177632,
 78792,
 237375045,
 234953702,
 -1,
 237440563,
 237308704,
 -1,
 237506091,
 237374515,
 77915,
 -61911,
 237444045,
 77918,
 -61910,
 237508604,
 77917,
 -1,
 237571777,
 77916,
 -61908,
 237440650,
 77925,
 -61907,
 237702742,
 77924,
 -61906,
 237768215,
 77923,
 -61905,
 237833693,
 77922,
 -61904,
 237899120,
 77921,
 -61903,
 237964594,
 77920,
 -61902,
 238030026,
 77919,
 -1,
 238095267,
 77914,
 238292543,
 237374371,
 -1,
 238358070,
 238226208,
 77926,
 -1,
 238292673,
 77927,
 -61897,
 238292618,
 77936,
 -61896,
 238423638,
 77935,
 -61895,
 238489111,
 77934,
 -61894,
 238554589,
 77933,
 -61893,
 238620016,
 77932,
 -61892,
 238685490,
 77931,
 -61891,
 238750922,
 77930,
 -61890,
 238816307,
 77929,
 -1,
 238881699,
 77928,
 239140863,
 238226483,
 -1,
 -61887,
 239013170,
 77941,
 -61886,
 239078602,
 77940,
 -61885,
 239143987,
 77939,
 -61884,
 239209379,
 77938,
 -1,
 239274784,
 77937,
 239472219,
 237321918,
 -1,
 239537746,
 239405856,
 -1,
 239603273,
 239472266,
 78225,
 -1,
 239537857,
 78226,
 239734347,
 239537520,
 78220,
 -1,
 239668929,
 78221,
 -61876,
 239668822,
 78224,
 -61875,
 239799831,
 78223,
 -61874,
 239865309,
 78222,
 -61873,
 239930674,
 78219,
 -61872,
 239996106,
 78218,
 -61871,
 240061491,
 78217,
 -1,
 240126883,
 78216,
 240386047,
 239471523,
 -1,
 240389717,
 240257955,
 78229,
 -1,
 240324289,
 78230,
 240520791,
 240323360,
 78227,
 -1,
 240455361,
 78228,
 -61864,
 240455024,
 78234,
 -61863,
 240586034,
 78233,
 -61862,
 240651466,
 78232,
 -1,
 240716851,
 78231,
 240914027,
 239429431,
 -1,
 240979560,
 240847648,
 -1,
 241045087,
 240913610,
 78494,
 -1,
 240979649,
 78495,
 241176161,
 240978851,
 78491,
 -1,
 241110721,
 78492,
 -61854,
 241110666,
 78501,
 -61853,
 241241686,
 78500,
 -61852,
 241307159,
 78499,
 -61851,
 241372637,
 78498,
 -61850,
 241438064,
 78497,
 -61849,
 241503538,
 78496,
 -1,
 241568819,
 78493,
 241827839,
 240913315,
 -1,
 -61846,
 241699747,
 78503,
 -1,
 241765152,
 78502,
 241962616,
 240882626,
 -1,
 242028143,
 241896754,
 78802,
 -61842,
 241965052,
 78804,
 -1,
 242028225,
 78803,
 242224753,
 241962582,
 78809,
 -1,
 242159297,
 78810,
 242355827,
 242159069,
 78806,
 -1,
 242290369,
 78807,
 -61836,
 242290199,
 78808,
 -61835,
 242421104,
 78805,
 -61834,
 242486474,
 78801,
 -61833,
 242551859,
 78800,
 -1,
 242617251,
 78799,
 242814595,
 241912681,
 -1,
 242880123,
 242748893,
 78249,
 -1,
 242814657,
 78250,
 243011197,
 242814003,
 78244,
 -1,
 242945729,
 78245,
 -61826,
 242945622,
 78252,
 -61825,
 243076631,
 78251,
 -61824,
 243142000,
 78248,
 -61823,
 243207474,
 78247,
 -61822,
 243272906,
 78246,
 -1,
 243338147,
 78243,
 243535502,
 242751502,
 -1,
 243601030,
 243469680,
 77908,
 -1,
 243535553,
 77909,
 -61817,
 243535498,
 77913,
 -61816,
 243666518,
 77912,
 -61815,
 243731991,
 77911,
 -61814,
 243797469,
 77910,
 -61813,
 243862834,
 77907,
 -61812,
 243928266,
 77906,
 -61811,
 243993651,
 77905,
 -1,
 244059043,
 77904,
 244256408,
 243504237,
 -1,
 244321937,
 244190115,
 78811,
 -1,
 244256449,
 78812,
 -61806,
 244256342,
 78819,
 -61805,
 244387351,
 78818,
 -61804,
 244452829,
 78817,
 -61803,
 244518256,
 78816,
 -61802,
 244583730,
 78815,
 -61801,
 244649162,
 78814,
 -1,
 244714547,
 78813,
 244911778,
 244201652,
 -1,
 244977307,
 244846045,
 78212,
 -1,
 244911809,
 78213,
 -61796,
 244911702,
 78215,
 -61795,
 245042711,
 78214,
 -61794,
 245108080,
 78211,
 -61793,
 245173554,
 78210,
 -61792,
 245238986,
 78209,
 -61791,
 245304371,
 78208,
 -1,
 245369763,
 78207,
 245567147,
 244861050,
 -1,
 -61788,
 245501526,
 78242,
 -61787,
 245566999,
 78241,
 -61786,
 245632477,
 78240,
 -61785,
 245697904,
 78239,
 -61784,
 245763378,
 78238,
 -61783,
 245828810,
 78237,
 -61782,
 245894195,
 78236,
 -1,
 245959587,
 78235,
 246218751,
 245525545,
 -1,
 -61779,
 246091287,
 78510,
 -61778,
 246156765,
 78509,
 -61777,
 246222192,
 78508,
 -61776,
 246287666,
 78507,
 -61775,
 246353098,
 78506,
 -61774,
 246418483,
 78505,
 -1,
 246483875,
 78504,
 246681461,
 168656405,
 -1,
 246746995,
 246627292,
 -1,
 246812513,
 246707590,
 -1,
 246878048,
 246781278,
 -1,
 246943442,
 246815693,
 -1,
 247008976,
 246881229,
 -1,
 247074505,
 246954146,
 -1,
 247140034,
 247019682,
 -1,
 247205565,
 247081090,
 43813,
 -1,
 247146626,
 43812,
 247336639,
 247140033,
 43808,
 -1,
 247271105,
 43811,
 -61760,
 247301671,
 43809,
 -61759,
 247422175,
 43814,
 -1,
 247479910,
 43810,
 247664324,
 247081090,
 11709,
 -1,
 247605378,
 11708,
 247795398,
 247598785,
 11704,
 -1,
 247729857,
 11707,
 -61753,
 247760423,
 11705,
 -61752,
 247880927,
 11710,
 -1,
 247938662,
 11706,
 248123083,
 247015554,
 11693,
 -1,
 248064130,
 11692,
 248254157,
 248057537,
 11688,
 -1,
 248188609,
 11691,
 -61746,
 248219175,
 11689,
 -61745,
 248339679,
 11694,
 -1,
 248397414,
 11690,
 -61743,
 246963470,
 11655,
 -1,
 248527973,
 11664,
 248712931,
 246887633,
 -1,
 248778459,
 248681519,
 -1,
 248843990,
 248719490,
 11741,
 -1,
 248785026,
 11740,
 248975064,
 248778433,
 11736,
 -1,
 248909505,
 11739,
 -61735,
 248940071,
 11737,
 -61734,
 249060575,
 11742,
 -1,
 249118310,
 11738,
 249302753,
 248723580,
 -1,
 249368286,
 249243778,
 11670,
 -1,
 249309314,
 11669,
 249499360,
 249302721,
 11667,
 -1,
 249433793,
 4895,
 -1,
 249445990,
 11668,
 -61726,
 249257230,
 4879,
 -1,
 249647349,
 11658,
 249827061,
 248652501,
 -1,
 249892589,
 249766613,
 -1,
 249958124,
 249837730,
 -1,
 250023656,
 249899138,
 43789,
 -1,
 249964674,
 43788,
 -61719,
 249988647,
 43785,
 -61718,
 250109151,
 43790,
 -61717,
 250166886,
 43786,
 -1,
 250220346,
 43787,
 -1,
 249912590,
 11661,
 250482420,
 249861647,
 -1,
 250547952,
 250423426,
 43797,
 -1,
 250488962,
 43796,
 -61711,
 250512935,
 43793,
 -61710,
 250633439,
 43798,
 -61709,
 250691174,
 43794,
 -1,
 250744634,
 43795,
 -1,
 250436878,
 11660,
 251006725,
 249787782,
 -1,
 251072254,
 250967430,
 -1,
 251137785,
 251013250,
 11685,
 -1,
 251078786,
 11684,
 251268859,
 251072193,
 11680,
 -1,
 251203265,
 11683,
 -61700,
 251233831,
 11681,
 -61699,
 251354335,
 11686,
 -1,
 251412070,
 11682,
 251596547,
 251013644,
 -1,
 -61696,
 251554843,
 5004,
 -61695,
 251615301,
 4992,
 -61694,
 251671757,
 5000,
 -1,
 251730869,
 4996,
 -61692,
 251550990,
 11651,
 -1,
 251870309,
 11652,
 252055315,
 250943484,
 -1,
 252120846,
 251992060,
 -1,
 252186377,
 252061826,
 43821,
 -1,
 252127362,
 43820,
 252317451,
 252120769,
 43816,
 -1,
 252251841,
 43819,
 -61684,
 252282407,
 43817,
 -61683,
 252402911,
 43822,
 -1,
 252460646,
 43818,
 252645138,
 252088136,
 -1,
 252710673,
 252586114,
 4999,
 -1,
 252651650,
 4998,
 -1,
 252657254,
 4997,
 -1,
 252599566,
 11653,
 252972830,
 252018197,
 -1,
 253038363,
 252936369,
 -1,
 253103895,
 252979330,
 43781,
 -1,
 253044866,
 43780,
 -61672,
 253068839,
 43777,
 -61671,
 253189343,
 43782,
 -61670,
 253247078,
 43778,
 -1,
 253300538,
 43779,
 -61668,
 253007661,
 4935,
 -61667,
 253451534,
 11654,
 -1,
 253508709,
 11663,
 253693736,
 252941839,
 -1,
 253759271,
 253662735,
 -1,
 253824802,
 253700226,
 11701,
 -1,
 253765762,
 11700,
 253955876,
 253759169,
 11696,
 -1,
 253890241,
 11699,
 -61659,
 253920807,
 11697,
 -61658,
 254041311,
 11702,
 -1,
 254099046,
 11698,
 -1,
 253713678,
 11659,
 254349106,
 253662075,
 -1,
 254414641,
 254317615,
 -1,
 254480172,
 254355586,
 11733,
 -1,
 254421122,
 11732,
 254611246,
 254414529,
 11728,
 -1,
 254545601,
 11731,
 -61649,
 254576167,
 11729,
 -61648,
 254696671,
 11734,
 -1,
 254754406,
 11730,
 -1,
 254369038,
 4743,
 255004476,
 254307359,
 -1,
 255070011,
 254972975,
 -1,
 255135542,
 255010946,
 11717,
 -1,
 255076482,
 11716,
 255266616,
 255069889,
 11712,
 -1,
 255200961,
 11715,
 -61639,
 255231527,
 11713,
 -61638,
 255352031,
 11718,
 -1,
 255409766,
 11714,
 -1,
 255024398,
 4679,
 255659846,
 254953533,
 -1,
 255725381,
 255628335,
 -1,
 255790912,
 255666306,
 11725,
 -1,
 255731842,
 11724,
 255921986,
 255725249,
 11720,
 -1,
 255856321,
 11723,
 -61629,
 255886887,
 11721,
 -61628,
 256007391,
 11726,
 -1,
 256065126,
 11722,
 -1,
 255679758,
 4783,
 256315213,
 255616763,
 -1,
 256380747,
 256282440,
 -1,
 256446282,
 256321666,
 5007,
 -1,
 256387202,
 5006,
 -1,
 256392806,
 5005,
 -61620,
 256335118,
 11666,
 -1,
 256588901,
 11665,
 256773971,
 256266780,
 -1,
 256839506,
 256741192,
 -1,
 256905041,
 256780418,
 4995,
 -1,
 256845954,
 4994,
 -1,
 256851558,
 4993,
 -1,
 256793870,
 11649,
 257167191,
 256718026,
 -1,
 257232726,
 257108098,
 5003,
 -1,
 257173634,
 5002,
 -1,
 257179238,
 5001,
 257429338,
 257120357,
 -1,
 -61607,
 257398173,
 11657,
 -1,
 257449230,
 11656,
 -61605,
 257398173,
 4847,
 -61604,
 257594106,
 4815,
 -61603,
 257651696,
 11650,
 -61602,
 257708129,
 11648,
 -61601,
 257771510,
 11662,
 -1,
 257834085,
 4615,
 -1,
 246819366,
 4960,
 258084718,
 246776543,
 -1,
 258150246,
 258024149,
 -1,
 258215781,
 258092482,
 5009,
 -1,
 258148931,
 5016,
 -1,
 258162789,
 5012,
 258412393,
 258099261,
 -1,
 -61592,
 258378519,
 5017,
 -1,
 258419796,
 5013,
 -61590,
 258381144,
 5008,
 -61589,
 258570319,
 5011,
 -61588,
 258634450,
 5010,
 -61587,
 258685700,
 5015,
 -1,
 258743881,
 5014,
 258998271,
 258023476,
 -1,
 259002226,
 258881074,
 -1,
 -61583,
 258954220,
 4959,
 -1,
 259003259,
 4957,
 -1,
 258969269,
 4958,
 -61580,
 246715259,
 983047,
 -1,
 259201020,
 983096,
 259395461,
 246634597,
 -1,
 259460994,
 259334871,
 -1,
 259526529,
 259415529,
 -1,
 259592060,
 259489301,
 -1,
 259657595,
 259550932,
 983048,
 -1,
 259588311,
 983095,
 -1,
 259600531,
 983046,
 -61571,
 259552955,
 983134,
 -61570,
 259812204,
 983178,
 -61569,
 259872035,
 983099,
 -61568,
 259936065,
 983064,
 -1,
 259995734,
 983177,
 -1,
 259494304,
 128282,
 260247428,
 259419167,
 983051,
 -1,
 260212757,
 983050,
 -1,
 260213937,
 128233,
 260444048,
 259331295,
 128066,
 260509581,
 260407476,
 -1,
 260575116,
 260460645,
 -1,
 260640651,
 260509377,
 -1,
 -61558,
 260601967,
 127759,
 -1,
 260658633,
 127758,
 -1,
 260583270,
 127757,
 -1,
 260535410,
 9178,
 261029887,
 260440951,
 -1,
 -61553,
 260927870,
 127806,
 -1,
 260985589,
 127805,
 261164952,
 260394222,
 -1,
 261230487,
 261104190,
 -1,
 261296022,
 261160960,
 -1,
 -61548,
 261260089,
 128294,
 -61547,
 261319108,
 128268,
 -1,
 261377835,
 128161,
 -1,
 261231157,
 9191,
 -1,
 261187824,
 128024,
 261689244,
 261125510,
 -1,
 261754779,
 261626829,
 983104,
 -1,
 261690492,
 983103,
 -1,
 261689025,
 983135,
 261951392,
 261643487,
 -1,
 -61538,
 261914133,
 983049,
 -61537,
 261968412,
 983100,
 -1,
 262032194,
 983067,
 262213539,
 261919957,
 -1,
 -61534,
 262174086,
 128064,
 -1,
 262223730,
 128083,
 262410150,
 262181755,
 -1,
 -61531,
 262374328,
 128125,
 -1,
 262433588,
 128529,
 262606761,
 262376206,
 -1,
 -61528,
 262564510,
 127972,
 -1,
 262610149,
 127984,
 -61526,
 262573315,
 127794,
 -61525,
 262761611,
 11072,
 -61524,
 262825786,
 983179,
 -61523,
 262883194,
 9167,
 -61522,
 262939996,
 11790,
 -1,
 262998629,
 128231,
 263198094,
 168564732,
 -1,
 263263323,
 263130817,
 -1,
 263328599,
 263215073,
 -1,
 263394124,
 263278153,
 -1,
 263459566,
 263350011,
 -1,
 263525094,
 263404032,
 -1,
 263590036,
 263465092,
 -1,
 263655410,
 263542885,
 -1,
 263720913,
 263599313,
 -1,
 263786433,
 263669821,
 -1,
 263851964,
 263751207,
 -1,
 -61509,
 263808763,
 92598,
 -1,
 263868956,
 92619,
 264048575,
 263794414,
 -1,
 -61506,
 264016763,
 92543,
 -1,
 264048790,
 92553,
 264306687,
 263982785,
 92531,
 -1,
 264180493,
 92601,
 264376266,
 263730385,
 -1,
 264441798,
 264341031,
 -1,
 -61500,
 264400377,
 92550,
 -61499,
 264464123,
 92624,
 -1,
 264507610,
 92563,
 264765439,
 264382594,
 -1,
 264769481,
 264668827,
 92607,
 -1,
 264732181,
 92535,
 -1,
 264710782,
 92557,
 264966092,
 264341147,
 92640,
 -1,
 264928789,
 92657,
 265097167,
 264920287,
 -1,
 -61490,
 265055263,
 92544,
 -1,
 265119483,
 92541,
 -61488,
 265039696,
 92579,
 -1,
 265227969,
 92658,
 265424859,
 263660245,
 -1,
 265490391,
 265359041,
 -1,
 265555926,
 265424579,
 -1,
 -61483,
 265517738,
 92562,
 -1,
 265574479,
 92637,
 -1,
 265512699,
 92518,
 265818074,
 265436774,
 -1,
 -61479,
 265776159,
 92558,
 -1,
 265819356,
 92592,
 -1,
 265783502,
 92528,
 266080225,
 265373495,
 -1,
 266145760,
 266020994,
 -1,
 266211295,
 266086530,
 92628,
 -1,
 266142128,
 92648,
 -1,
 266177450,
 92547,
 -1,
 266080416,
 92554,
 266473446,
 266041117,
 -1,
 266538981,
 266438183,
 -1,
 -61468,
 266494279,
 92527,
 -1,
 266545282,
 92545,
 -1,
 266485795,
 92540,
 266801129,
 266442255,
 -1,
 -61464,
 266766992,
 92609,
 -1,
 266802396,
 92583,
 266997740,
 266769720,
 -1,
 -61461,
 266936199,
 92589,
 -1,
 267000210,
 92608,
 267194351,
 266960405,
 -1,
 -61458,
 267159685,
 92604,
 -1,
 267195504,
 92622,
 267390961,
 267128513,
 92662,
 -1,
 267331714,
 92613,
 -1,
 267340455,
 92584,
 267587594,
 263612155,
 -1,
 267653113,
 267552295,
 92576,
 267718647,
 267587265,
 -1,
 -61450,
 267676703,
 92618,
 -1,
 267724930,
 92529,
 -61448,
 267670044,
 92561,
 -1,
 267856002,
 92649,
 268046335,
 267587265,
 -1,
 268111868,
 267980481,
 92524,
 -1,
 268063260,
 92536,
 268304383,
 268043462,
 -1,
 -61442,
 268194298,
 92634,
 -1,
 268250394,
 92625,
 268439555,
 267992678,
 92663,
 268566527,
 268380290,
 -1,
 -61438,
 268467733,
 92621,
 -1,
 268512613,
 92593,
 268701704,
 268380290,
 -1,
 268767239,
 268666407,
 -1,
 -61434,
 268735355,
 92647,
 -1,
 268795413,
 92605,
 -1,
 268708820,
 92548,
 269090815,
 268655839,
 92568,
 -1,
 268984198,
 92610,
 269160477,
 267538972,
 -1,
 269226000,
 269094593,
 92667,
 269291534,
 269166722,
 92600,
 -1,
 269242908,
 92542,
 -61425,
 269249567,
 92668,
 -1,
 269379323,
 92555,
 269553682,
 269172326,
 92654,
 -1,
 269494907,
 92611,
 269684757,
 269497793,
 -1,
 -61420,
 269626372,
 92581,
 -1,
 269684417,
 92551,
 269881368,
 269621518,
 -1,
 -61417,
 269846661,
 92520,
 -1,
 269887618,
 92582,
 -61415,
 269848016,
 92617,
 -61414,
 270042779,
 92614,
 -61413,
 270098310,
 92671,
 -61412,
 270152280,
 92591,
 -1,
 270216196,
 92666,
 270405680,
 269123093,
 -1,
 270471204,
 270339777,
 -1,
 270536737,
 270405313,
 92635,
 -1,
 270494751,
 92577,
 -61406,
 270494751,
 92636,
 -61405,
 270619164,
 92530,
 -1,
 270674980,
 92559,
 270864424,
 270435879,
 -1,
 270929959,
 270815772,
 92586,
 -1,
 270864519,
 92569,
 -1,
 270864519,
 92566,
 271126572,
 270818527,
 -1,
 271192107,
 271080671,
 92537,
 -1,
 271145061,
 92519,
 -1,
 271150111,
 92630,
 271450111,
 271067266,
 -1,
 271454255,
 271353383,
 92669,
 -1,
 271388868,
 92572,
 -1,
 271407205,
 92672,
 271650882,
 270373935,
 -1,
 271716406,
 271615527,
 -1,
 -61389,
 271674399,
 92644,
 -61388,
 271734885,
 92645,
 -61387,
 271789413,
 92594,
 -1,
 271847597,
 92641,
 272044091,
 271658734,
 -1,
 272109625,
 271978631,
 92567,
 -1,
 272072213,
 92623,
 -61382,
 272077691,
 92639,
 -1,
 272192028,
 92606,
 272371774,
 271999556,
 -1,
 -61379,
 272334236,
 92642,
 -1,
 272376079,
 92643,
 272568385,
 272318054,
 -1,
 -61376,
 272530965,
 92590,
 -1,
 272575099,
 92564,
 -1,
 272503920,
 92588,
 272830542,
 271611270,
 -1,
 272896072,
 272775330,
 -1,
 272961606,
 272850143,
 92659,
 -1,
 272919583,
 92660,
 -61369,
 272909583,
 92638,
 -1,
 273035028,
 92580,
 273223755,
 272836738,
 -1,
 -61366,
 273186325,
 92560,
 -1,
 273229954,
 92534,
 -61364,
 273188516,
 92571,
 -61363,
 273375050,
 92525,
 -1,
 273420090,
 92549,
 273616987,
 272780098,
 -1,
 273682517,
 273571039,
 -1,
 273748051,
 273636575,
 -1,
 -61358,
 273710613,
 92556,
 -1,
 273766501,
 92523,
 -61356,
 273706015,
 92664,
 -1,
 273895964,
 92539,
 274075737,
 273616577,
 -1,
 -61353,
 274033695,
 92633,
 -61352,
 274097915,
 92521,
 -1,
 274141949,
 92575,
 -61350,
 274040359,
 92653,
 -1,
 274280193,
 92595,
 274468968,
 273565757,
 -1,
 274534496,
 274433575,
 -1,
 -61346,
 274497045,
 92620,
 -61345,
 274555207,
 92538,
 -1,
 274607748,
 92587,
 274796645,
 274475138,
 -1,
 274862180,
 274761255,
 -1,
 -61341,
 274830203,
 92646,
 -1,
 274862215,
 92570,
 -1,
 274824725,
 92599,
 -61338,
 274753764,
 92532,
 -61337,
 275078367,
 92665,
 -1,
 275136102,
 92670,
 275320948,
 274411870,
 -1,
 275386480,
 275285543,
 -1,
 275452014,
 275316736,
 -1,
 -61332,
 275411045,
 92661,
 -61331,
 275463782,
 92616,
 -1,
 275520534,
 92626,
 275775487,
 275392642,
 92596,
 -1,
 275676693,
 92612,
 275845234,
 275320513,
 92603,
 -1,
 275803167,
 92673,
 -61325,
 275799882,
 92627,
 -1,
 275917435,
 92651,
 276107393,
 275264721,
 -1,
 276172926,
 276052130,
 -1,
 276238460,
 276113538,
 -1,
 276303995,
 276203047,
 -1,
 -61319,
 276271995,
 92552,
 -61318,
 276322405,
 92565,
 -1,
 276369543,
 92615,
 -1,
 276266517,
 92602,
 -61315,
 276193098,
 92674,
 -1,
 276565829,
 92578,
 276824063,
 276109582,
 -1,
 -61312,
 276728746,
 92597,
 -1,
 276790805,
 92585,
 276959367,
 276065634,
 -1,
 277024901,
 276893377,
 -1,
 -61308,
 276982815,
 92526,
 -1,
 277031042,
 92656,
 -61306,
 276971972,
 92546,
 -1,
 277163896,
 92655,
 277352588,
 276926280,
 -1,
 277418123,
 277317159,
 -1,
 -61302,
 277372127,
 92533,
 -1,
 277424258,
 92650,
 -1,
 277360504,
 92574,
 277680273,
 277318576,
 -1,
 277745808,
 277620866,
 -1,
 -61297,
 277710491,
 92573,
 -1,
 277751938,
 92652,
 -1,
 277700426,
 92522,
 -61294,
 277634271,
 92631,
 -61293,
 277954150,
 92632,
 -1,
 278007489,
 92629,
 278204731,
 263529175,
 -1,
 278270153,
 278157413,
 -1,
 278335655,
 278213841,
 -1,
 278401183,
 278284349,
 -1,
 278466715,
 278343406,
 -1,
 -61286,
 278425928,
 92432,
 -1,
 278466756,
 92457,
 -61284,
 278435048,
 92435,
 -61283,
 278628558,
 92412,
 -61282,
 278675491,
 92476,
 -1,
 278729840,
 92414,
 278986751,
 278344913,
 -1,
 278991012,
 278859457,
 -1,
 279056547,
 278926077,
 92465,
 -1,
 278990983,
 92409,
 -1,
 279013115,
 92483,
 -61275,
 278957979,
 92467,
 -61274,
 279218590,
 92485,
 -1,
 279261048,
 92475,
 279449775,
 278284087,
 -1,
 279515306,
 279395942,
 92403,
 -1,
 279456379,
 92405,
 279646381,
 279457518,
 -1,
 -61268,
 279608853,
 92407,
 -1,
 279646358,
 92430,
 -61266,
 279611386,
 92487,
 -1,
 279778416,
 92418,
 279974071,
 279410054,
 -1,
 280039603,
 279920675,
 -1,
 -61262,
 280002069,
 92459,
 -1,
 280061691,
 92447,
 280236214,
 279984290,
 -1,
 -61259,
 280202102,
 92486,
 -1,
 280242811,
 92408,
 -1,
 280201349,
 92480,
 280498364,
 279942191,
 -1,
 -61255,
 280463323,
 92463,
 -61254,
 280510054,
 92493,
 -61253,
 280571524,
 92450,
 -1,
 280630013,
 92410,
 280826050,
 280437461,
 -1,
 280891584,
 280766594,
 -1,
 -61249,
 280857514,
 92425,
 -1,
 280897666,
 92437,
 -61247,
 280846214,
 92440,
 -1,
 281023229,
 92471,
 281219271,
 280788501,
 -1,
 281284806,
 281159810,
 -1,
 -61243,
 281249925,
 92472,
 -1,
 281290882,
 92505,
 -1,
 281250720,
 92514,
 -61240,
 281183783,
 92503,
 -1,
 281493094,
 92507,
 281678052,
 278221340,
 92497,
 281743569,
 281620830,
 -1,
 281809101,
 281697503,
 92445,
 -1,
 281761893,
 92404,
 281940176,
 281751278,
 -1,
 -61233,
 281902613,
 92424,
 -1,
 281940103,
 92458,
 -1,
 281886755,
 92466,
 282202325,
 281687489,
 -1,
 -61229,
 282156563,
 92438,
 -61228,
 282214435,
 92444,
 -1,
 282275631,
 92442,
 282464474,
 282142850,
 -1,
 282530009,
 282428967,
 -1,
 -61224,
 282492437,
 92427,
 -1,
 282548325,
 92478,
 -1,
 282471038,
 92496,
 282792158,
 282400764,
 -1,
 282857693,
 282726202,
 92448,
 -1,
 282789442,
 92515,
 -1,
 282823067,
 92401,
 283054305,
 282726081,
 -1,
 -61216,
 283004211,
 92426,
 -1,
 283061413,
 92482,
 -61214,
 283020947,
 92510,
 -61213,
 283215399,
 92499,
 -1,
 283271351,
 92441,
 283447543,
 281638278,
 -1,
 283513070,
 283392162,
 -1,
 283578603,
 283453570,
 -1,
 283644138,
 283543079,
 -1,
 -61207,
 283612027,
 92501,
 -1,
 283644039,
 92417,
 -1,
 283584642,
 92413,
 -61204,
 283543079,
 92504,
 -61203,
 283861569,
 92508,
 -1,
 283918659,
 92500,
 284102898,
 283477543,
 -1,
 -61200,
 284067367,
 92498,
 -61199,
 284108930,
 92419,
 -1,
 284168327,
 92473,
 284365045,
 284036801,
 -1,
 -61196,
 284322847,
 92516,
 -1,
 284387067,
 92423,
 -61194,
 284320594,
 92452,
 -1,
 284503828,
 92428,
 284692741,
 283396157,
 -1,
 284758271,
 284633218,
 -1,
 284823806,
 284722727,
 -1,
 -61189,
 284780283,
 92460,
 -61188,
 284844896,
 92431,
 -61187,
 284906012,
 92454,
 -1,
 284954854,
 92415,
 -1,
 284786197,
 92420,
 285217027,
 284722727,
 92489,
 -61183,
 285174815,
 92479,
 -61182,
 285237066,
 92422,
 -1,
 285300837,
 92474,
 -61180,
 285185256,
 92502,
 -1,
 285446048,
 92449,
 285610257,
 284655125,
 -1,
 285675788,
 285550722,
 -1,
 285741323,
 285640231,
 -1,
 -61175,
 285703701,
 92416,
 -61174,
 285759589,
 92481,
 -1,
 285806765,
 92451,
 -1,
 285682302,
 92456,
 286069006,
 285640231,
 92433,
 -1,
 286024530,
 92477,
 -61169,
 286024257,
 92492,
 -61168,
 286146150,
 92513,
 -1,
 286199943,
 92491,
 286396699,
 285559618,
 -1,
 286462232,
 286337154,
 -1,
 286527766,
 286426663,
 -1,
 -61163,
 286478876,
 92484,
 -1,
 286527674,
 92439,
 -61161,
 286490133,
 92464,
 -1,
 286665342,
 92495,
 -61159,
 286427269,
 92446,
 -61158,
 286810689,
 92511,
 -1,
 286867491,
 92406,
 287052068,
 286353147,
 -1,
 287117599,
 287016487,
 -1,
 -61154,
 287083382,
 92443,
 -1,
 287140895,
 92509,
 287314210,
 287058050,
 -1,
 -61151,
 287279993,
 92462,
 -1,
 287320194,
 92506,
 -61149,
 287261960,
 92461,
 -1,
 287446128,
 92469,
 287641900,
 287020079,
 -1,
 287707434,
 287606311,
 -1,
 287772969,
 287661279,
 -1,
 -61144,
 287729403,
 92470,
 -1,
 287789596,
 92468,
 -1,
 287740696,
 92453,
 -61141,
 287648772,
 92429,
 -1,
 287969446,
 92421,
 288166194,
 287599970,
 -1,
 288231728,
 288107527,
 -1,
 -61137,
 288186067,
 92490,
 -1,
 288249792,
 92512,
 -61135,
 288178499,
 92494,
 -1,
 288362646,
 92455,
 288559413,
 288132936,
 -1,
 -61132,
 288523940,
 92411,
 -1,
 288560240,
 92402,
 288756024,
 288503466,
 -1,
 -61129,
 288698108,
 92488,
 -1,
 288755514,
 92434,
 289013759,
 288698718,
 -1,
 -61126,
 288894746,
 92436,
 -1,
 288952122,
 92517,
 289149390,
 278141903,
 -1,
 289214832,
 289101925,
 -1,
 289280330,
 289158353,
 -1,
 289345861,
 289223889,
 -1,
 289411396,
 289310247,
 92362,
 -61119,
 289365894,
 92341,
 -61118,
 289427996,
 92347,
 -61117,
 289483468,
 92370,
 -1,
 289542321,
 92336,
 -1,
 289352708,
 92307,
 289804616,
 289294397,
 -1,
 -61113,
 289769442,
 92303,
 -1,
 289805532,
 92309,
 -61111,
 289759050,
 92368,
 -1,
 289936604,
 92395,
 290132306,
 289240454,
 -1,
 290197838,
 290096679,
 -1,
 -61107,
 290153321,
 92359,
 -1,
 290216037,
 92374,
 -61105,
 290152266,
 92371,
 -61104,
 290339259,
 92351,
 -61103,
 290402055,
 92325,
 -1,
 290459329,
 92350,
 290656603,
 290071253,
 -1,
 290722134,
 290598638,
 -1,
 -61099,
 290684437,
 92349,
 -1,
 290721992,
 92308,
 290918745,
 290655937,
 -1,
 -61096,
 290875131,
 92378,
 -1,
 290935324,
 92375,
 -61094,
 290873199,
 92317,
 -1,
 291061700,
 92331,
 291246435,
 290604855,
 -1,
 291311967,
 291186818,
 -1,
 -61090,
 291277738,
 92389,
 -1,
 291318398,
 92360,
 291508578,
 291245761,
 -1,
 -61087,
 291459612,
 92367,
 -1,
 291515348,
 92356,
 -1,
 291473402,
 92333,
 291770729,
 291208725,
 -1,
 291836263,
 291711106,
 -1,
 -61082,
 291801435,
 92345,
 -1,
 291854437,
 92372,
 -61080,
 291800620,
 92314,
 -1,
 291966778,
 92340,
 292163948,
 291739151,
 -1,
 -61077,
 292106027,
 92323,
 -1,
 292163265,
 92304,
 292360559,
 292097729,
 -1,
 -61074,
 292318239,
 92396,
 -1,
 292379511,
 92338,
 -1,
 292328775,
 92313,
 292622733,
 289165852,
 -1,
 292688259,
 292558844,
 -1,
 292753784,
 292628610,
 -1,
 292819318,
 292718119,
 -1,
 -61067,
 292787067,
 92385,
 -1,
 292835868,
 92315,
 -61065,
 292777465,
 92354,
 -1,
 292957056,
 92311,
 293147003,
 292699750,
 92381,
 -61062,
 293109269,
 92326,
 -1,
 293171615,
 92343,
 293343616,
 293080769,
 -1,
 293409151,
 293277379,
 -1,
 -61058,
 293366052,
 92387,
 -1,
 293411830,
 92318,
 -1,
 293362886,
 92383,
 293732351,
 293307943,
 -1,
 -61054,
 293611650,
 92324,
 -1,
 293671062,
 92364,
 293867914,
 292622017,
 -1,
 293933447,
 293808258,
 -1,
 -61050,
 293894252,
 92363,
 -1,
 293950543,
 92382,
 294191103,
 293863424,
 -1,
 -61047,
 294083454,
 92376,
 -1,
 294144475,
 92339,
 -61045,
 293832347,
 92391,
 -61044,
 294273059,
 92390,
 -1,
 294335961,
 92344,
 294523294,
 292571197,
 -1,
 294588825,
 294463618,
 -1,
 294654357,
 294553127,
 -1,
 294719891,
 294614406,
 -1,
 -61038,
 294664901,
 92319,
 -1,
 294727544,
 92384,
 -61036,
 294670876,
 92386,
 -1,
 294865169,
 92321,
 295047576,
 294606951,
 -1,
 -61033,
 294997140,
 92393,
 -1,
 295055890,
 92394,
 -1,
 295009813,
 92361,
 295309724,
 294553127,
 -1,
 -61029,
 295271957,
 92366,
 -1,
 295330132,
 92373,
 -61027,
 295266258,
 92328,
 -1,
 295440186,
 92329,
 295637413,
 294491183,
 -1,
 295702947,
 295601703,
 -1,
 -61023,
 295670552,
 92388,
 -61022,
 295719452,
 92305,
 -1,
 295764800,
 92322,
 -61020,
 295644998,
 92327,
 -1,
 295898938,
 92377,
 296096173,
 295599637,
 -1,
 296161705,
 296044014,
 -1,
 -61016,
 296126121,
 92358,
 -1,
 296161048,
 92334,
 296358316,
 296102018,
 -1,
 -61013,
 296323966,
 92346,
 -1,
 296386069,
 92400,
 -1,
 296292181,
 92332,
 296620469,
 296056198,
 -1,
 296686001,
 296564898,
 -1,
 -61008,
 296650746,
 92379,
 -1,
 296699151,
 92392,
 296882612,
 296626306,
 -1,
 -61005,
 296848298,
 92330,
 -1,
 296911020,
 92380,
 -1,
 296847029,
 92335,
 297144763,
 296569666,
 -1,
 297210297,
 297078465,
 -1,
 -61000,
 297166587,
 92342,
 -1,
 297226780,
 92357,
 -60998,
 297174567,
 92365,
 -1,
 297354511,
 92397,
 297537984,
 297101051,
 -1,
 297603519,
 297483878,
 -1,
 -60994,
 297562527,
 92316,
 -1,
 297621605,
 92398,
 -1,
 297544708,
 92399,
 297865669,
 297481425,
 -1,
 297931204,
 297810104,
 -1,
 -60989,
 297889273,
 92310,
 -1,
 297953019,
 92320,
 -1,
 297867512,
 92312,
 298193352,
 297832264,
 -1,
 -60985,
 298158511,
 92369,
 -1,
 298193905,
 92306,
 298389963,
 298159544,
 -1,
 -60982,
 298357627,
 92337,
 -1,
 298389694,
 92353,
 -60980,
 298349833,
 92355,
 -60979,
 298529980,
 92348,
 -1,
 298589071,
 92352,
 298783308,
 289083075,
 -1,
 298848754,
 298735717,
 -1,
 298914262,
 298810901,
 -1,
 298979797,
 298849392,
 92223,
 299106303,
 298909696,
 -1,
 -60972,
 298998726,
 92194,
 -1,
 299062772,
 92185,
 -1,
 298934869,
 92178,
 299307484,
 298857681,
 -1,
 299373018,
 299256589,
 -1,
 -60967,
 299326681,
 92182,
 -1,
 299369274,
 92160,
 -60965,
 299316814,
 92229,
 -1,
 299504656,
 92173,
 299700704,
 299275311,
 -1,
 299766239,
 299646566,
 92239,
 -1,
 299728466,
 92225,
 -1,
 299708036,
 92233,
 299962851,
 299669007,
 -1,
 -60958,
 299927761,
 92191,
 -1,
 299962061,
 92167,
 300159462,
 299923229,
 -1,
 -60955,
 300105763,
 92237,
 -1,
 300158657,
 92241,
 300356073,
 300107837,
 -1,
 -60952,
 300302929,
 92180,
 -1,
 300355407,
 92227,
 300552684,
 300294962,
 -1,
 -60949,
 300487648,
 92212,
 -1,
 300548820,
 92201,
 300749295,
 300486337,
 -1,
 -60946,
 300706847,
 92245,
 -1,
 300748493,
 92164,
 -60944,
 300697445,
 92231,
 -60943,
 300892490,
 92204,
 -1,
 300952580,
 92244,
 301142537,
 298799644,
 -1,
 301208062,
 301076161,
 -1,
 301273596,
 301148290,
 -1,
 301339129,
 301224476,
 92238,
 -60937,
 301305291,
 92174,
 -60936,
 301353704,
 92203,
 -1,
 301406618,
 92171,
 -60934,
 301299820,
 92230,
 -60933,
 301554886,
 92210,
 -1,
 301615587,
 92186,
 -60931,
 301229852,
 92221,
 -1,
 301751186,
 92175,
 301928963,
 301161695,
 -1,
 301994498,
 301883210,
 -1,
 -60927,
 301951986,
 92198,
 -1,
 302002036,
 92214,
 -1,
 301946986,
 92190,
 302256646,
 301865009,
 -1,
 -60923,
 302214175,
 92246,
 -1,
 302275782,
 92232,
 -60921,
 302222780,
 92176,
 -60920,
 302396883,
 92196,
 -1,
 302460723,
 92197,
 302649881,
 301102470,
 -1,
 302715410,
 302594210,
 -1,
 302780942,
 302679591,
 -1,
 -60915,
 302731804,
 92215,
 -1,
 302787781,
 92165,
 302977553,
 302726758,
 -1,
 -60912,
 302935545,
 92222,
 -1,
 302995780,
 92168,
 -1,
 302932552,
 92224,
 303239702,
 302669023,
 -1,
 -60908,
 303201813,
 92235,
 -60907,
 303262751,
 92220,
 -1,
 303323877,
 92208,
 -60905,
 303205280,
 92181,
 -60904,
 303449472,
 92195,
 -1,
 303509311,
 92177,
 303698474,
 302606075,
 -1,
 303764001,
 303632065,
 -1,
 303829534,
 303697601,
 -1,
 -60899,
 303787513,
 92226,
 -1,
 303845916,
 92236,
 -60897,
 303789942,
 92187,
 -60896,
 303978412,
 92189,
 -1,
 304022228,
 92200,
 304222760,
 303718281,
 -1,
 304288293,
 304179005,
 -1,
 -60892,
 304231913,
 92169,
 -1,
 304289841,
 92170,
 304545791,
 304240121,
 -1,
 -60889,
 304428521,
 92162,
 -1,
 304486449,
 92163,
 -60887,
 304187823,
 92205,
 -1,
 304623236,
 92202,
 304812595,
 303646781,
 -1,
 304878126,
 304752770,
 -1,
 -60883,
 304842799,
 92179,
 -1,
 304905749,
 92211,
 305074737,
 304811713,
 -1,
 -60880,
 305032223,
 92240,
 -1,
 305082811,
 92199,
 -60878,
 305039787,
 92213,
 -1,
 305228442,
 92219,
 305402427,
 304774677,
 -1,
 305467959,
 305366567,
 -1,
 -60874,
 305402042,
 92206,
 -1,
 305464082,
 92172,
 305664570,
 305409774,
 -1,
 -60871,
 305627296,
 92209,
 -1,
 305664173,
 92234,
 -1,
 305612305,
 92166,
 305926721,
 305351490,
 -1,
 305992254,
 305890855,
 92243,
 -1,
 305926330,
 92207,
 -60865,
 305946492,
 92216,
 -60864,
 306065031,
 92184,
 -1,
 306123895,
 92183,
 306319942,
 305870033,
 -1,
 306385477,
 306264767,
 -1,
 -60860,
 306343417,
 92188,
 -1,
 306394831,
 92193,
 -1,
 306321875,
 92161,
 306647625,
 306284071,
 -1,
 -60856,
 306600702,
 92228,
 -1,
 306645461,
 92192,
 -60854,
 306613421,
 92242,
 -60853,
 306803772,
 92218,
 -1,
 306852600,
 92217,
 307040925,
 298719230,
 -1,
 307106400,
 306991644,
 -1,
 307171925,
 307042300,
 -1,
 307237458,
 307105473,
 -1,
 -60847,
 307172584,
 92255,
 -1,
 307233546,
 92252,
 -60845,
 307202475,
 92292,
 -60844,
 307381749,
 92268,
 -1,
 307441495,
 92286,
 307630681,
 307105473,
 92300,
 307757055,
 307561295,
 -1,
 -60840,
 307661459,
 92296,
 -1,
 307703565,
 92295,
 307892828,
 307573086,
 -1,
 -60837,
 307847074,
 92267,
 -1,
 307906332,
 92284,
 308089439,
 307834606,
 -1,
 -60834,
 308051551,
 92290,
 -1,
 308112415,
 92281,
 -1,
 308044008,
 92287,
 308351601,
 307058789,
 -1,
 308417129,
 308294865,
 -1,
 308482663,
 308360401,
 -1,
 308548197,
 308447659,
 92282,
 -1,
 308478669,
 92283,
 -60826,
 308489969,
 92277,
 -1,
 308612929,
 92298,
 -60824,
 308436810,
 92302,
 -1,
 308759100,
 92276,
 308941420,
 308384815,
 -1,
 -60821,
 308887153,
 92269,
 -1,
 308940954,
 92288,
 309138031,
 308901254,
 -1,
 -60818,
 309083675,
 92247,
 -1,
 309144580,
 92299,
 -60816,
 309101038,
 92260,
 -1,
 309274638,
 92261,
 309465721,
 308311430,
 -1,
 309531253,
 309410330,
 -1,
 -60812,
 309495470,
 92266,
 -1,
 309558888,
 92265,
 -60810,
 309495771,
 92285,
 -60809,
 309674019,
 92249,
 -60808,
 309735054,
 92250,
 -1,
 309793298,
 92279,
 309990018,
 309413949,
 -1,
 310055550,
 309931758,
 -1,
 -60804,
 310023472,
 92272,
 -60803,
 310078450,
 92270,
 -1,
 310120598,
 92294,
 310317697,
 310001254,
 -1,
 -60800,
 310275103,
 92301,
 -1,
 310323880,
 92253,
 -1,
 310252285,
 92256,
 310579847,
 309946107,
 -1,
 -60796,
 310544724,
 92289,
 -60795,
 310593006,
 92263,
 -60794,
 310651590,
 92257,
 -1,
 310711769,
 92274,
 310907533,
 310528834,
 -1,
 310973067,
 310841025,
 -1,
 -60790,
 310923840,
 92259,
 -1,
 310973241,
 92273,
 -60788,
 310927181,
 92251,
 -1,
 311111300,
 92297,
 311300754,
 310869525,
 -1,
 311366289,
 311264809,
 -1,
 -60784,
 311319422,
 92264,
 -1,
 311382720,
 92248,
 -1,
 311299905,
 92280,
 311628437,
 311268399,
 -1,
 -60780,
 311570250,
 92254,
 -1,
 311628074,
 92258,
 311825048,
 311572182,
 -1,
 -60777,
 311789215,
 92262,
 -1,
 311842917,
 92271,
 312021659,
 311767578,
 -1,
 -60774,
 311987114,
 92291,
 -1,
 312027266,
 92293,
 -60772,
 311989101,
 92278,
 -1,
 312184262,
 92275,
 312410111,
 306983264,
 -1,
 312414892,
 312301669,
 -1,
 312480417,
 312378919,
 92697,
 -1,
 312414343,
 92696,
 312611492,
 312428343,
 -1,
 -60765,
 312575643,
 92698,
 -1,
 312610966,
 92688,
 312808103,
 312554705,
 -1,
 -60762,
 312757024,
 92711,
 -1,
 312816899,
 92712,
 -60760,
 312775989,
 92681,
 -60759,
 312967160,
 92704,
 -60758,
 313030492,
 92702,
 -60757,
 313081446,
 92708,
 -1,
 313140047,
 92687,
 313332405,
 312374662,
 -1,
 313397937,
 313276578,
 -1,
 -60753,
 313361959,
 92700,
 -60752,
 313416927,
 92713,
 -1,
 313475395,
 92691,
 -60750,
 313363360,
 92690,
 -60749,
 313605734,
 92692,
 -60748,
 313667448,
 92693,
 -1,
 313725696,
 92727,
 313922238,
 313280573,
 -1,
 313987769,
 313862274,
 -1,
 -60744,
 313949717,
 92695,
 -1,
 314005605,
 92710,
 -60742,
 313955560,
 92694,
 -60741,
 314148391,
 92677,
 -60740,
 314206010,
 92726,
 -60739,
 314268895,
 92719,
 -1,
 314314433,
 92675,
 314512071,
 313879906,
 -1,
 314577603,
 314452098,
 -1,
 -60735,
 314543018,
 92709,
 -60734,
 314595429,
 92721,
 -1,
 314648706,
 92679,
 314839750,
 314523238,
 -1,
 -60731,
 314785382,
 92683,
 -1,
 314845819,
 92684,
 -1,
 314803751,
 92707,
 315101902,
 314462748,
 92689,
 315167435,
 315037692,
 -1,
 -60726,
 315108356,
 92720,
 -1,
 315166522,
 92724,
 -60724,
 315120863,
 92723,
 -60723,
 315304578,
 92685,
 -1,
 315363009,
 92722,
 315560659,
 315063829,
 -1,
 315626194,
 315494081,
 -1,
 -60719,
 315566210,
 92680,
 -1,
 315625153,
 92686,
 -1,
 315567748,
 92725,
 315888344,
 315516667,
 -1,
 315953879,
 315828354,
 -1,
 -60714,
 315919274,
 92703,
 -1,
 315959426,
 92706,
 -1,
 315917979,
 92714,
 316216028,
 315837250,
 -1,
 -60710,
 316170817,
 92718,
 -60709,
 316227174,
 92717,
 -1,
 316280513,
 92682,
 316478175,
 316183599,
 -1,
 -60706,
 316432961,
 92699,
 -1,
 316477121,
 92701,
 316674786,
 316444488,
 -1,
 -60703,
 316639195,
 92705,
 -1,
 316673729,
 92716,
 -60701,
 316641077,
 92728,
 -60700,
 316835367,
 92676,
 -60699,
 316879803,
 92715,
 -1,
 316942971,
 92678,
 317133545,
 263489063,
 -1,
 -60696,
 317073538,
 42696,
 -1,
 317132935,
 42711,
 317330156,
 317073538,
 -1,
 -60693,
 317295530,
 42693,
 -1,
 317335682,
 42698,
 -60691,
 317275750,
 42717,
 -1,
 317460161,
 42667,
 317657857,
 263411813,
 -1,
 317723379,
 317605687,
 -1,
 -60687,
 317687451,
 42686,
 -60686,
 317729403,
 42694,
 -1,
 317788310,
 42674,
 317985527,
 317666513,
 -1,
 -60683,
 317934368,
 42707,
 -60682,
 317994243,
 42708,
 -1,
 318049985,
 42709,
 318247673,
 317949479,
 42685,
 -1,
 318181511,
 42684,
 318378748,
 318209557,
 -1,
 -60677,
 318344096,
 42731,
 -1,
 318384763,
 42695,
 -60675,
 318346549,
 42664,
 -60674,
 318535516,
 42691,
 -60673,
 318586470,
 42703,
 -60672,
 318645071,
 42673,
 -1,
 318705345,
 42715,
 318903054,
 317605949,
 -1,
 318968581,
 318856415,
 42719,
 -60668,
 318934842,
 42734,
 -1,
 318977764,
 42735,
 319165193,
 318908546,
 -1,
 -60665,
 319130538,
 42692,
 -60664,
 319192597,
 42683,
 -1,
 319248485,
 42706,
 -60662,
 319132904,
 42682,
 -60661,
 319391271,
 42659,
 -60660,
 319448890,
 42729,
 -60659,
 319503974,
 42725,
 -1,
 319557313,
 42657,
 319755033,
 318853660,
 42675,
 319820562,
 319694978,
 -1,
 -60655,
 319772773,
 42722,
 -1,
 319826558,
 42671,
 320017173,
 319756284,
 -1,
 -60652,
 319958020,
 42720,
 -1,
 320016186,
 42727,
 -60650,
 319981095,
 42677,
 -60649,
 320167135,
 42726,
 -60648,
 320224870,
 42702,
 -1,
 320278209,
 42723,
 320475939,
 319714694,
 -1,
 320541471,
 320420002,
 -1,
 -60644,
 320505383,
 42688,
 -60643,
 320560351,
 42710,
 -60642,
 320618819,
 42678,
 -1,
 320679800,
 42680,
 -60640,
 320506784,
 42676,
 -60639,
 320814694,
 42679,
 -60638,
 320876408,
 42681,
 -1,
 320934656,
 42732,
 321131309,
 320433506,
 -1,
 321196840,
 321071234,
 -1,
 -60634,
 321162154,
 42704,
 -60633,
 321214565,
 42721,
 -1,
 321267842,
 42661,
 321458987,
 321142374,
 -1,
 -60630,
 321404518,
 42668,
 -1,
 321464955,
 42669,
 -60628,
 321422887,
 42700,
 -1,
 321589383,
 42705,
 321786677,
 321093141,
 -1,
 321852209,
 321726594,
 -1,
 -60624,
 321814037,
 42728,
 -1,
 321869925,
 42730,
 322048820,
 321785537,
 -1,
 -60621,
 321988738,
 42662,
 -1,
 322047681,
 42672,
 -1,
 321994342,
 42724,
 322310971,
 321735490,
 -1,
 -60617,
 322274855,
 42701,
 -60616,
 322331201,
 42718,
 -60615,
 322387558,
 42716,
 -60614,
 322448002,
 42670,
 -1,
 322506433,
 42666,
 322704192,
 322253150,
 -1,
 -60611,
 322668071,
 42712,
 -60610,
 322723658,
 42713,
 -60609,
 322775675,
 42699,
 -1,
 322834245,
 42733,
 323031876,
 322671663,
 -1,
 -60606,
 322996880,
 42689,
 -60605,
 323052097,
 42687,
 -1,
 323096257,
 42690,
 323294023,
 322998088,
 -1,
 -60602,
 323258331,
 42697,
 -1,
 323292865,
 42714,
 -60600,
 323257895,
 42658,
 -60599,
 323443935,
 42663,
 -60598,
 323501670,
 42665,
 -60597,
 323562107,
 42660,
 -1,
 323620545,
 42656,
 323818323,
 263331852,
 -1,
 323883858,
 323768860,
 -1,
 323949393,
 323820027,
 -1,
 -60592,
 323912962,
 42737,
 -1,
 323963567,
 42736,
 -1,
 323900021,
 42741,
 -1,
 323833987,
 42740,
 -60588,
 323778249,
 42742,
 -60587,
 324234512,
 42743,
 -60586,
 324295389,
 42738,
 -1,
 324351168,
 42739,
 324539383,
 263277378,
 -1,
 324604918,
 324485782,
 -1,
 324670361,
 324554313,
 -1,
 324735841,
 324632085,
 -1,
 324801376,
 324669121,
 6946,
 324927487,
 324730880,
 -1,
 -60578,
 324829048,
 6947,
 -60577,
 324884504,
 6942,
 -1,
 324947034,
 6941,
 -1,
 324769571,
 6983,
 325194598,
 324687973,
 -1,
 325260132,
 325127873,
 6950,
 -1,
 325191160,
 6945,
 -60571,
 325227633,
 6940,
 -1,
 325334275,
 6935,
 325522283,
 325142589,
 -1,
 325587818,
 325455553,
 6931,
 -60567,
 325529974,
 6981,
 -1,
 325583642,
 6932,
 -1,
 325532963,
 6982,
 325849969,
 325460786,
 6948,
 325976063,
 325780231,
 -1,
 325981040,
 325880539,
 -1,
 -60561,
 325931722,
 6944,
 -1,
 325980900,
 6943,
 -1,
 325914755,
 6949,
 326243190,
 325783233,
 -1,
 326308724,
 326191381,
 6917,
 -1,
 326239911,
 6918,
 -60555,
 326270473,
 6987,
 -1,
 326385998,
 6928,
 326570874,
 326202842,
 6962,
 326696959,
 326501919,
 -1,
 -60551,
 326592314,
 6961,
 -1,
 326644995,
 6960,
 326833021,
 326528448,
 6957,
 326959103,
 326764041,
 6923,
 -1,
 326829735,
 6924,
 327029632,
 326781808,
 6958,
 327155711,
 326959845,
 6925,
 -1,
 327026343,
 6926,
 327226242,
 326993961,
 6921,
 -1,
 327157415,
 6922,
 327357316,
 327182138,
 6951,
 -1,
 327287385,
 6952,
 327488390,
 327311005,
 6929,
 -1,
 327419559,
 6930,
 327619464,
 327436117,
 6938,
 -1,
 327549512,
 6939,
 327750538,
 327565646,
 6919,
 -1,
 327681703,
 6920,
 327881612,
 327693571,
 6933,
 -1,
 327811597,
 6934,
 328012687,
 327821442,
 -1,
 -60530,
 327960853,
 6927,
 -1,
 328020342,
 6984,
 328209297,
 327949289,
 6936,
 -1,
 328139410,
 6937,
 328340371,
 328144945,
 6953,
 -1,
 328270458,
 6954,
 -60524,
 328308286,
 6986,
 -60523,
 328438897,
 6956,
 -60522,
 328503183,
 6959,
 -60521,
 328567967,
 6985,
 -60520,
 328618613,
 6955,
 -1,
 328677560,
 6963,
 328864706,
 324622381,
 -1,
 328930216,
 328803029,
 -1,
 328995746,
 328863425,
 -1,
 329061280,
 328948265,
 7012,
 329187327,
 328990720,
 -1,
 -60513,
 329088380,
 7013,
 -1,
 329135661,
 7018,
 -60511,
 329007773,
 7017,
 -1,
 329264289,
 7015,
 329454501,
 328935554,
 -1,
 -60508,
 329419079,
 7016,
 -1,
 329472553,
 7010,
 -60506,
 329419079,
 7011,
 -60505,
 329605236,
 7009,
 -1,
 329663133,
 7014,
 329847731,
 328867892,
 -1,
 329913262,
 329796021,
 -1,
 329978796,
 329877573,
 7021,
 -1,
 329910554,
 7024,
 330170367,
 329928432,
 7022,
 -1,
 330041626,
 7025,
 -60497,
 329875452,
 7019,
 -60496,
 330188708,
 7023,
 -60495,
 330250160,
 7027,
 -60494,
 330312842,
 7020,
 -1,
 330373455,
 7026,
 330568635,
 329797040,
 -1,
 330634168,
 330523039,
 -1,
 -60490,
 330598727,
 7033,
 -60489,
 330646173,
 7036,
 -1,
 330699719,
 7032,
 330956799,
 330571712,
 -1,
 -60486,
 330860582,
 7035,
 -1,
 330895870,
 7034,
 331153407,
 330527290,
 -1,
 331158463,
 331047275,
 -1,
 -60482,
 331122686,
 7028,
 -1,
 331157815,
 7029,
 331415551,
 331096010,
 -1,
 -60479,
 331319334,
 7030,
 -1,
 331354622,
 7031,
 331551700,
 328830679,
 -1,
 331617226,
 331513365,
 -1,
 331682761,
 331551410,
 6974,
 331808767,
 331612160,
 -1,
 331813832,
 331706483,
 6975,
 -1,
 331744935,
 6977,
 -1,
 331775985,
 6976,
 -1,
 331623029,
 6965,
 332075980,
 331581559,
 6966,
 -1,
 332006947,
 6967,
 332207054,
 332037473,
 6968,
 -1,
 332137007,
 6969,
 332338128,
 332164547,
 6970,
 -1,
 332269223,
 6971,
 332469202,
 332294289,
 6978,
 -1,
 332400295,
 6979,
 332660735,
 332417907,
 6972,
 -1,
 332531367,
 6973,
 332731362,
 331490551,
 -1,
 332796888,
 332693013,
 -1,
 -60457,
 332763758,
 6994,
 -1,
 332807525,
 6995,
 332993499,
 332756358,
 -1,
 -60454,
 332941024,
 6998,
 -1,
 333000583,
 6999,
 333190110,
 332935518,
 -1,
 -60451,
 333145202,
 6996,
 -1,
 333203087,
 6997,
 -60449,
 333158061,
 6992,
 -60448,
 333340662,
 6993,
 -60447,
 333404823,
 7001,
 -1,
 333458236,
 7000,
 333648874,
 332691593,
 -1,
 333714406,
 333613179,
 -1,
 -60443,
 333672835,
 6912,
 -1,
 333716540,
 6913,
 -60441,
 333675900,
 6915,
 -60440,
 333869189,
 6964,
 -60439,
 333913456,
 6914,
 -1,
 333978120,
 6916,
 334173167,
 333604666,
 -1,
 334238702,
 334123548,
 -1,
 -60435,
 334179472,
 7008,
 -1,
 334237781,
 7003,
 -1,
 334191579,
 7002,
 334500852,
 334109894,
 -1,
 334566387,
 334456634,
 -1,
 -60430,
 334524557,
 7007,
 -1,
 334583807,
 7005,
 -1,
 334526630,
 7006,
 -60427,
 334467375,
 7004,
 -1,
 334762088,
 6980,
 -1,
 324554948,
 127880,
 335025217,
 324501013,
 -1,
 335090750,
 334959105,
 -1,
 335156261,
 335040073,
 -1,
 335221768,
 335115654,
 -1,
 335287302,
 335167897,
 -1,
 -60419,
 335254641,
 7132,
 -60418,
 335318927,
 7116,
 -60417,
 335377882,
 7129,
 -60416,
 335441344,
 7123,
 -60415,
 335505210,
 7112,
 -60414,
 335565429,
 7125,
 -60413,
 335629168,
 7135,
 -60412,
 335689912,
 7107,
 -60411,
 335754499,
 7119,
 -1,
 335810241,
 7105,
 -60409,
 335242499,
 7126,
 -1,
 335941313,
 7128,
 336139278,
 335173733,
 -1,
 -60406,
 336106609,
 7136,
 -60405,
 336159503,
 7127,
 -60404,
 336213251,
 7133,
 -60403,
 336274226,
 7138,
 -1,
 336334529,
 7113,
 336532501,
 336089628,
 -1,
 336598036,
 336465601,
 7124,
 336723967,
 336550228,
 -1,
 -60398,
 336623066,
 7130,
 -60397,
 336681147,
 7114,
 -1,
 336738488,
 7108,
 -1,
 336533553,
 7139,
 336991255,
 336488250,
 7111,
 -1,
 336939744,
 7117,
 -60392,
 336958577,
 7131,
 -60391,
 337088399,
 7115,
 -60390,
 337151527,
 7141,
 -60389,
 337210816,
 7122,
 -60388,
 337267568,
 7134,
 -60387,
 337332512,
 7110,
 -60386,
 337397589,
 7120,
 -60385,
 337460838,
 7140,
 -60384,
 337524920,
 7106,
 -60383,
 337589507,
 7118,
 -60382,
 337650482,
 7121,
 -60381,
 337714153,
 7137,
 -60380,
 337778737,
 7109,
 -1,
 337841857,
 7104,
 338039856,
 335122135,
 -1,
 338105384,
 338003495,
 7150,
 -1,
 338035147,
 7151,
 338236459,
 338053402,
 -1,
 -60374,
 338189535,
 7149,
 -1,
 338247270,
 7147,
 338433069,
 338176130,
 7143,
 -1,
 338372738,
 7145,
 -60370,
 338388839,
 7144,
 -60369,
 338517215,
 7148,
 -1,
 338574950,
 7146,
 338760760,
 337999238,
 -1,
 338826295,
 338728302,
 -1,
 338891829,
 338781947,
 -1,
 -60364,
 338838019,
 7165,
 -1,
 338891784,
 7167,
 -60362,
 338843838,
 7164,
 -1,
 339036201,
 7166,
 -1,
 338772278,
 7142,
 339285051,
 338716568,
 -1,
 -60358,
 339239077,
 7155,
 -1,
 339294088,
 7154,
 339542015,
 339222665,
 -1,
 -60355,
 339434025,
 7152,
 -1,
 339490978,
 7153,
 339678272,
 335034530,
 128704,
 -1,
 339641554,
 128705,
 -1,
 339640475,
 128267,
 339874889,
 334977125,
 -1,
 339940424,
 339822653,
 127974,
 340066303,
 339893074,
 -1,
 -60347,
 339973365,
 128180,
 -60346,
 340028074,
 128183,
 -60345,
 340078428,
 128182,
 -1,
 340141461,
 128181,
 -1,
 339874613,
 127820,
 340399183,
 339811261,
 128118,
 340525055,
 340328448,
 -1,
 -60340,
 340426194,
 128700,
 -60339,
 340467251,
 128036,
 -60338,
 340531921,
 127868,
 -1,
 340595674,
 128124,
 340792404,
 340335565,
 -1,
 340857939,
 340740157,
 -1,
 -60334,
 340818689,
 983056,
 -1,
 340855080,
 128281,
 -1,
 340820982,
 128043,
 341120087,
 340751750,
 -1,
 -60330,
 341068234,
 127936,
 -1,
 341125638,
 9918,
 341316698,
 341077346,
 -1,
 -60327,
 341252442,
 128136,
 -1,
 341311766,
 128202,
 -1,
 341259908,
 128708,
 341579001,
 263220578,
 -1,
 341644528,
 341512592,
 -1,
 341709985,
 341593673,
 -1,
 341775461,
 341674928,
 -1,
 341840996,
 341728605,
 -1,
 341906530,
 341798242,
 69643,
 -1,
 341863778,
 69644,
 342097919,
 341855042,
 69645,
 -1,
 341986114,
 69646,
 -1,
 341774017,
 69679,
 342234219,
 341736981,
 -1,
 342299753,
 342195733,
 -1,
 -60312,
 342243512,
 69662,
 -1,
 342298305,
 69661,
 -60310,
 342243512,
 69667,
 -1,
 342429377,
 69666,
 342627440,
 342187231,
 69649,
 342753279,
 342576336,
 -1,
 -60306,
 342652052,
 69686,
 -60305,
 342711066,
 69687,
 -1,
 342773820,
 69685,
 342955125,
 342579301,
 -1,
 -60302,
 342922353,
 69660,
 -60301,
 342972603,
 69665,
 -60300,
 343028995,
 69655,
 -1,
 343084737,
 69670,
 343282811,
 342893269,
 -1,
 343348345,
 343220949,
 -1,
 -60296,
 343292088,
 69664,
 -1,
 343346881,
 69663,
 -60294,
 343292088,
 69669,
 -1,
 343477953,
 69668,
 343676031,
 343215809,
 69637,
 -60291,
 343639591,
 69650,
 -60290,
 343686758,
 69648,
 -1,
 343740097,
 69638,
 343938179,
 343635334,
 -1,
 -60287,
 343897562,
 69681,
 -60286,
 343947448,
 69680,
 -1,
 344002241,
 69682,
 344200325,
 343901735,
 69641,
 -1,
 344163879,
 69642,
 344331400,
 344155899,
 -1,
 -60281,
 344275128,
 69672,
 -1,
 344329921,
 69671,
 344528011,
 344279874,
 -1,
 -60278,
 344476528,
 69684,
 -1,
 344526529,
 69678,
 344724622,
 344475709,
 -1,
 -60275,
 344668344,
 69652,
 -1,
 344723137,
 69651,
 344921233,
 344672055,
 -1,
 -60272,
 344864952,
 69659,
 -1,
 344919745,
 69658,
 345117843,
 344866406,
 69639,
 -1,
 345063014,
 69640,
 345248918,
 345060561,
 -1,
 -60267,
 345192632,
 69654,
 -1,
 345247425,
 69653,
 345445529,
 345185229,
 -1,
 -60264,
 345389240,
 69657,
 -1,
 345444033,
 69656,
 345642140,
 345380860,
 -1,
 -60261,
 345585848,
 69674,
 -1,
 345640641,
 69673,
 -60259,
 345609329,
 69676,
 -60258,
 345796032,
 69677,
 -60257,
 345854581,
 69675,
 -60256,
 345913528,
 69683,
 -1,
 345974914,
 69647,
 346166462,
 341662759,
 -1,
 346231978,
 346127893,
 -1,
 346297510,
 346197832,
 -1,
 -60251,
 346250463,
 69715,
 -1,
 346303735,
 69724,
 346494121,
 346241186,
 -1,
 -60248,
 346452010,
 69716,
 -1,
 346506598,
 69725,
 -1,
 346434564,
 69723,
 346756271,
 346191238,
 -1,
 346821805,
 346703584,
 69719,
 -1,
 346785300,
 69728,
 347013119,
 346763143,
 69720,
 -1,
 346916372,
 69729,
 347083958,
 346698078,
 -1,
 347149491,
 347036895,
 -1,
 -60238,
 347114141,
 69717,
 -1,
 347174149,
 69726,
 347406335,
 347094630,
 -1,
 -60235,
 347311237,
 69718,
 -1,
 347354296,
 69727,
 347542714,
 347037686,
 69714,
 347668479,
 347471872,
 -1,
 -60231,
 347570515,
 69733,
 -1,
 347618852,
 69732,
 347804860,
 347495063,
 69722,
 -1,
 347768340,
 69731,
 347996159,
 347745084,
 69721,
 -1,
 347903023,
 69730,
 348067025,
 346131376,
 -1,
 348132560,
 348022435,
 -1,
 348198085,
 348098097,
 -1,
 348263619,
 348155234,
 69694,
 -1,
 348220770,
 69695,
 348454911,
 348212034,
 69696,
 -1,
 348343106,
 69697,
 348525769,
 348131009,
 -1,
 -60217,
 348489255,
 69701,
 -60216,
 348536422,
 69699,
 -1,
 348589761,
 69688,
 348787915,
 348489255,
 69692,
 -1,
 348751399,
 69693,
 348918989,
 348733030,
 69690,
 -1,
 348864102,
 69691,
 -60210,
 348871903,
 69700,
 -60209,
 348989570,
 69698,
 -1,
 349051297,
 69689,
 -1,
 348079410,
 69702,
 349312226,
 348005077,
 -1,
 349377760,
 349258004,
 -1,
 349443286,
 349339157,
 -1,
 -60203,
 349409902,
 69736,
 -1,
 349453669,
 69737,
 349639897,
 349402502,
 -1,
 -60200,
 349587168,
 69740,
 -1,
 349646727,
 69741,
 349836508,
 349581662,
 -1,
 -60197,
 349791346,
 69738,
 -1,
 349849231,
 69739,
 -60195,
 349804205,
 69734,
 -60194,
 349986806,
 69735,
 -60193,
 350050967,
 69743,
 -1,
 350104380,
 69742,
 -60191,
 349332499,
 69704,
 -1,
 350229417,
 69703,
 350426344,
 349272201,
 -1,
 -60188,
 350391801,
 69634,
 -60187,
 350456384,
 69636,
 -60186,
 350504908,
 69635,
 -60185,
 350559330,
 69632,
 -1,
 350622819,
 69633,
 350879743,
 350383040,
 -1,
 350885100,
 350767938,
 -1,
 -60181,
 350839812,
 69709,
 -1,
 350896756,
 69707,
 351081711,
 350823819,
 -1,
 -60178,
 351045406,
 69706,
 -1,
 351108629,
 69705,
 -1,
 351019326,
 69708,
 351343861,
 341589606,
 -1,
 351409396,
 351281877,
 -1,
 -60173,
 351352322,
 127753,
 -1,
 351414624,
 128112,
 -1,
 351349456,
 128188,
 351671544,
 351283574,
 -1,
 -60169,
 351619160,
 983124,
 -1,
 351675093,
 127838,
 -1,
 351624867,
 128148,
 351933733,
 341542439,
 -1,
 351999264,
 351876305,
 128027,
 352124927,
 351945366,
 -1,
 352130328,
 352013897,
 -1,
 352195846,
 352082021,
 -1,
 352261377,
 352162863,
 -1,
 -60160,
 352197609,
 6671,
 -1,
 352259777,
 6670,
 352457988,
 352203985,
 -1,
 -60157,
 352405647,
 6659,
 -1,
 352456385,
 6658,
 -60155,
 352415168,
 6667,
 -1,
 352587457,
 6666,
 352785673,
 352145948,
 -1,
 -60152,
 352741178,
 6663,
 -1,
 352784065,
 6662,
 -60150,
 352752753,
 6672,
 -60149,
 352947142,
 6675,
 -60148,
 353009291,
 6664,
 -60147,
 353072602,
 6676,
 -60146,
 353136064,
 6673,
 -60145,
 353199930,
 6660,
 -60144,
 353258352,
 6674,
 -60143,
 353323151,
 6656,
 -60142,
 353388373,
 6669,
 -60141,
 353450168,
 6678,
 -60140,
 353514755,
 6657,
 -60139,
 353575730,
 6665,
 -60138,
 353639401,
 6668,
 -60137,
 353703985,
 6661,
 -1,
 353767105,
 6677,
 353965342,
 352095959,
 -1,
 -60134,
 353928743,
 6680,
 -60133,
 353983711,
 6682,
 -60132,
 354041446,
 6679,
 -60131,
 354101378,
 6681,
 -1,
 354160775,
 6683,
 -60129,
 353920893,
 6686,
 -1,
 354299003,
 6687,
 354549759,
 351958406,
 128652,
 354555172,
 354450965,
 -1,
 -60125,
 354514323,
 128101,
 -1,
 354550329,
 128100,
 -1,
 354485883,
 128655,
 354817369,
 351882050,
 -1,
 354882899,
 354750473,
 -1,
 354948398,
 354841990,
 -1,
 355013932,
 354898742,
 -1,
 -60118,
 354974777,
 11089,
 -60117,
 355029349,
 11050,
 -1,
 355083464,
 11049,
 -60115,
 354970802,
 128306,
 -1,
 355228518,
 9927,
 355407158,
 354896706,
 -1,
 355472691,
 355347176,
 -1,
 355538226,
 355404439,
 9194,
 -1,
 355469754,
 9198,
 -1,
 355467969,
 9944,
 355794943,
 355407152,
 -1,
 -60107,
 355695458,
 11035,
 -1,
 355737286,
 11044,
 355931451,
 355365446,
 -1,
 355996985,
 355870514,
 9193,
 -1,
 355928506,
 9197,
 -60102,
 355959810,
 9199,
 -1,
 356083828,
 11091,
 356259136,
 355881500,
 -1,
 356324671,
 356199022,
 -1,
 -60098,
 356274533,
 11047,
 -1,
 356328648,
 11045,
 -1,
 356278562,
 9912,
 356586821,
 356197077,
 -1,
 356652356,
 356544292,
 -1,
 -60093,
 356602787,
 9922,
 -1,
 356665927,
 9923,
 -1,
 356607695,
 9196,
 356914504,
 356551916,
 -1,
 -60089,
 356881494,
 11037,
 -1,
 356942304,
 11054,
 357111115,
 356875797,
 -1,
 -60086,
 357077730,
 9942,
 -1,
 357135628,
 9951,
 357307726,
 357054626,
 -1,
 -60083,
 357261999,
 11052,
 -1,
 357314621,
 11042,
 -60081,
 357272100,
 9195,
 -60080,
 357461278,
 10067,
 -60079,
 357525620,
 11039,
 -60078,
 357577526,
 9873,
 -1,
 357638524,
 9960,
 357832022,
 354846686,
 -1,
 -60075,
 357775935,
 128153,
 -1,
 357833414,
 128216,
 358088703,
 357784799,
 -1,
 -60072,
 357994617,
 128033,
 -1,
 358054890,
 127804,
 358225263,
 354770143,
 -1,
 358290784,
 358188228,
 -1,
 -60068,
 358253380,
 9185,
 -60067,
 358314508,
 11813,
 -60066,
 358377432,
 9181,
 -60065,
 358436244,
 11812,
 -1,
 358490772,
 9183,
 358684005,
 358247045,
 -1,
 -60062,
 358651713,
 12730,
 -60061,
 358698711,
 12729,
 -60060,
 358760768,
 12589,
 -1,
 358823594,
 12728,
 359011689,
 358637210,
 -1,
 359077224,
 358962156,
 128278,
 -1,
 359007896,
 128209,
 -1,
 359036294,
 128218,
 359273835,
 358961692,
 983246,
 -1,
 359208956,
 128163,
 -60052,
 359240751,
 128102,
 -60051,
 359371325,
 127923,
 -60050,
 359434903,
 128144,
 -1,
 359470303,
 128023,
 359667072,
 358164610,
 -1,
 359732601,
 359618661,
 -1,
 359798135,
 359675209,
 -1,
 359863669,
 359747153,
 -1,
 -60044,
 359810290,
 983621,
 -1,
 359863214,
 2510,
 -60042,
 359823503,
 2493,
 -1,
 360002932,
 2555,
 -60040,
 359765655,
 9187,
 -1,
 360153812,
 127857,
 360322428,
 359680834,
 983055,
 360447999,
 360270658,
 128276,
 -1,
 360318926,
 128277,
 360519039,
 360255169,
 -1,
 -60034,
 360481431,
 128147,
 -1,
 360541551,
 128059,
 -1,
 360459640,
 127866,
 360781193,
 359612006,
 -1,
 360846724,
 360738146,
 -1,
 -60029,
 360808690,
 127874,
 -1,
 360850133,
 128038,
 361043335,
 360784592,
 -1,
 -60026,
 360990145,
 128692,
 -1,
 361048194,
 128690,
 -60024,
 360992798,
 127921,
 -1,
 361187926,
 128089,
 361371020,
 360748079,
 -1,
 -60021,
 361338440,
 983248,
 -1,
 361398166,
 983245,
 -60019,
 361330054,
 983057,
 -1,
 361523433,
 983125,
 361699908,
 263146306,
 -1,
 361764774,
 361631425,
 -1,
 361830284,
 361726604,
 -1,
 361895608,
 361788806,
 -1,
 361961125,
 361845558,
 -1,
 362026658,
 361909833,
 -1,
 362091954,
 361987605,
 -1,
 362157478,
 362055207,
 -1,
 362223013,
 362116060,
 -1,
 362288538,
 362187707,
 -1,
 -60007,
 362231800,
 983615,
 -1,
 362287151,
 983616,
 362485149,
 362241247,
 -1,
 -60004,
 362440763,
 7432,
 -1,
 362489986,
 7444,
 362681759,
 362430054,
 7433,
 -1,
 362634149,
 42879,
 362812833,
 362625188,
 686,
 -1,
 362741896,
 687,
 -59998,
 362769809,
 11385,
 -59997,
 362892098,
 42881,
 -59996,
 362951889,
 7543,
 -1,
 363008135,
 7426,
 -1,
 362172956,
 42871,
 363271594,
 362100898,
 -1,
 363337129,
 363225824,
 42853,
 -1,
 363267781,
 42855,
 -1,
 363268494,
 7546,
 363533742,
 363202468,
 -1,
 -59988,
 363484706,
 7541,
 -59987,
 363537592,
 11366,
 -1,
 363602568,
 566,
 -59985,
 363501071,
 42793,
 -59984,
 363753640,
 42795,
 -59983,
 363815242,
 7446,
 -1,
 363860391,
 11383,
 364058060,
 362031234,
 -1,
 364123588,
 363988900,
 -1,
 364189112,
 364088678,
 983555,
 364314623,
 364118074,
 -1,
 -59977,
 364197880,
 983557,
 -1,
 364253231,
 983559,
 364451259,
 364142150,
 -1,
 -59974,
 364413469,
 983585,
 -1,
 364449839,
 983583,
 364647870,
 364389822,
 -1,
 -59971,
 364610077,
 983589,
 -1,
 364646447,
 983587,
 364844481,
 364584724,
 -1,
 -59968,
 364794518,
 983561,
 -1,
 364846285,
 983563,
 -59966,
 364805332,
 583,
 -59965,
 364998840,
 7570,
 -1,
 365058887,
 11384,
 365237703,
 364083010,
 -1,
 -59962,
 365195448,
 7576,
 -1,
 365258608,
 7563,
 365434314,
 365181075,
 -1,
 -59959,
 365382969,
 42787,
 -1,
 365445608,
 42789,
 -59957,
 365401837,
 7578,
 -1,
 365592085,
 42859,
 365762015,
 364017030,
 -1,
 365827540,
 365707248,
 -1,
 365893073,
 365780191,
 7441,
 -59952,
 365848651,
 7442,
 -1,
 365889954,
 7443,
 -59950,
 365856295,
 7453,
 -59949,
 366052657,
 7455,
 -1,
 366093472,
 7454,
 366286298,
 365758372,
 -1,
 -59946,
 366251366,
 983575,
 -59945,
 366312849,
 575,
 -59944,
 366372720,
 7562,
 -59943,
 366435646,
 42921,
 -1,
 366499362,
 7540,
 366679518,
 366222994,
 -1,
 -59940,
 366637240,
 7573,
 -59939,
 366688248,
 983617,
 -1,
 366743599,
 983618,
 -1,
 366613230,
 42892,
 367007219,
 365706854,
 -1,
 367072746,
 366938020,
 -1,
 367138277,
 367011262,
 -1,
 -59933,
 367100445,
 983591,
 -59932,
 367147000,
 983590,
 -1,
 367202351,
 983566,
 367400424,
 367091282,
 -1,
 -59929,
 367362589,
 983595,
 -1,
 367398959,
 983593,
 -59927,
 367358136,
 7574,
 -1,
 367547049,
 983565,
 367728113,
 367025053,
 -1,
 -59924,
 367689237,
 42887,
 -59923,
 367752582,
 42885,
 -59922,
 367816034,
 42883,
 -59921,
 367867089,
 7545,
 -59920,
 367931742,
 42876,
 -1,
 367993557,
 42874,
 -59918,
 367687046,
 42861,
 -1,
 368141188,
 7548,
 368317955,
 366939841,
 -1,
 368383483,
 368248740,
 -1,
 368449016,
 368336454,
 -1,
 -59913,
 368411165,
 983581,
 -1,
 368447535,
 983579,
 -59911,
 368409812,
 11365,
 -59910,
 368603320,
 7567,
 -1,
 368661161,
 983553,
 368842237,
 368348080,
 42809,
 -1,
 368773330,
 42811,
 -59906,
 368809007,
 42813,
 -59905,
 368936487,
 42807,
 -59904,
 368991455,
 42805,
 -59903,
 369054070,
 7568,
 -59902,
 369109290,
 983612,
 -1,
 369168065,
 42803,
 369366547,
 368274786,
 -1,
 369432077,
 369295360,
 -1,
 369497612,
 369398119,
 -1,
 -59897,
 369459741,
 983603,
 -59896,
 369523924,
 589,
 -59895,
 369583984,
 7561,
 -59894,
 369646910,
 42919,
 -59893,
 369710626,
 7538,
 -1,
 369767170,
 7539,
 -1,
 369456234,
 42843,
 370021905,
 369373159,
 -1,
 370087440,
 369957837,
 8580,
 -1,
 370018390,
 42815,
 -1,
 370041209,
 7572,
 370343935,
 369985669,
 42869,
 -1,
 370214415,
 42845,
 370415140,
 369319135,
 -1,
 370480669,
 370345892,
 -1,
 370546201,
 370445670,
 983569,
 370671615,
 370475066,
 -1,
 -59880,
 370554872,
 983571,
 -1,
 370610223,
 983573,
 370868223,
 370495582,
 -1,
 -59877,
 370773874,
 11386,
 -59876,
 370827591,
 42829,
 -1,
 370891312,
 42827,
 371070499,
 370436150,
 -1,
 371136034,
 371023100,
 -1,
 -59872,
 371093688,
 7575,
 -59871,
 371144696,
 983613,
 -1,
 371200047,
 983614,
 -1,
 371075402,
 7571,
 -1,
 371023071,
 42831,
 371529265,
 370378279,
 -1,
 371594798,
 371460004,
 -1,
 371660330,
 371544733,
 -1,
 -59864,
 371622429,
 983611,
 -59863,
 371668984,
 983577,
 -1,
 371724335,
 983609,
 371922477,
 371613254,
 -1,
 -59860,
 371884573,
 983607,
 -1,
 371920943,
 983605,
 -1,
 371880120,
 7577,
 -59857,
 371551106,
 7551,
 -59856,
 372134428,
 42872,
 -1,
 372189314,
 7531,
 372381245,
 371477314,
 -1,
 372446777,
 372311972,
 -1,
 -59852,
 372408861,
 983599,
 -59851,
 372469959,
 42894,
 -59850,
 372533104,
 7557,
 -59849,
 372587384,
 42825,
 -59848,
 372647596,
 11361,
 -1,
 372712072,
 564,
 372905532,
 372400281,
 -1,
 -59845,
 372849528,
 7837,
 -1,
 372909240,
 7836,
 -1,
 372869253,
 42866,
 373167687,
 372318933,
 -1,
 373233219,
 373098404,
 -1,
 -59840,
 373188464,
 7553,
 -59839,
 373249570,
 7533,
 -59838,
 373308567,
 7569,
 -1,
 373367432,
 545,
 -59836,
 373196933,
 42865,
 -59835,
 373515212,
 567,
 -59834,
 373566410,
 7839,
 -1,
 373626881,
 568,
 373823056,
 373132208,
 -1,
 373888589,
 373753764,
 -1,
 -59830,
 373846559,
 11377,
 -59829,
 373909360,
 7564,
 -59828,
 373957816,
 42847,
 -1,
 374022792,
 11380,
 -59826,
 373855279,
 42849,
 -59825,
 374162858,
 42851,
 -1,
 374221943,
 42857,
 374412889,
 373774437,
 -1,
 374478423,
 374343588,
 -1,
 -59821,
 374433648,
 7559,
 -59820,
 374496574,
 42917,
 -59819,
 374560290,
 7536,
 -59818,
 374613048,
 42897,
 -1,
 374678152,
 565,
 -59816,
 374442117,
 42868,
 -1,
 374813924,
 983567,
 375002721,
 374368047,
 -1,
 375068254,
 374961542,
 -1,
 375133789,
 375030888,
 7549,
 -1,
 375064261,
 42833,
 -1,
 375090517,
 42837,
 -59809,
 375023472,
 7560,
 -59808,
 375281186,
 7537,
 -1,
 375337857,
 42835,
 375527018,
 374952476,
 -1,
 375592550,
 375457700,
 -1,
 -59804,
 375554589,
 983601,
 -59803,
 375613296,
 7558,
 -1,
 375674402,
 7535,
 375854697,
 375537608,
 -1,
 -59800,
 375819184,
 7933,
 -1,
 375869392,
 7931,
 -1,
 375818373,
 42867,
 376116850,
 375474290,
 -1,
 376182381,
 376077524,
 42817,
 -1,
 376111184,
 42821,
 376313456,
 376120021,
 -1,
 -59793,
 376258241,
 42819,
 -1,
 376319542,
 11370,
 -59791,
 376268656,
 7556,
 -1,
 376462654,
 42915,
 376641145,
 376060066,
 -1,
 376706678,
 376594696,
 -1,
 -59787,
 376649720,
 983619,
 -1,
 376705071,
 983620,
 -59785,
 376646817,
 42791,
 -59784,
 376836774,
 11382,
 -1,
 376899632,
 11368,
 377099904,
 376576973,
 -1,
 377165436,
 377063118,
 42797,
 -1,
 377096194,
 42799,
 377296511,
 377096100,
 -1,
 -59778,
 377257172,
 572,
 -1,
 377297033,
 42899,
 -1,
 377249670,
 42863,
 377558661,
 377067025,
 -1,
 -59774,
 377519505,
 576,
 -59773,
 377579376,
 7566,
 -59772,
 377640482,
 7542,
 -1,
 377693240,
 11372,
 377886347,
 377515039,
 -1,
 377951882,
 377816996,
 -1,
 -59768,
 377912589,
 42839,
 -59767,
 377961637,
 587,
 -1,
 378021048,
 42841,
 -1,
 377906944,
 569,
 378279569,
 377828561,
 -1,
 378345103,
 378210212,
 -1,
 -59762,
 378300272,
 7555,
 -1,
 378363198,
 42913,
 -59760,
 378294527,
 578,
 -1,
 378484920,
 983199,
 378672791,
 378214396,
 -1,
 378738325,
 378603428,
 -1,
 -59756,
 378693488,
 7552,
 -1,
 378754594,
 7532,
 -59754,
 378696739,
 42823,
 -1,
 378889207,
 7447,
 379066010,
 378639461,
 -1,
 -59751,
 379026644,
 591,
 -1,
 379080905,
 7935,
 379262621,
 379012921,
 -1,
 -59748,
 379223252,
 585,
 -1,
 379266509,
 983597,
 379459232,
 379203983,
 -1,
 -59745,
 379414384,
 7554,
 -1,
 379475490,
 7534,
 -59743,
 379425710,
 7565,
 -1,
 379621248,
 11379,
 379846655,
 361962652,
 -1,
 -59740,
 379749995,
 7550,
 -1,
 379797161,
 7547,
 380043263,
 361924488,
 -1,
 380049064,
 379942278,
 8347,
 -1,
 379985549,
 8340,
 -59735,
 380015483,
 8339,
 -59734,
 380144560,
 7525,
 -59733,
 380208679,
 7524,
 -59732,
 380272149,
 8348,
 -59731,
 380333410,
 7523,
 -59730,
 380397307,
 8346,
 -59729,
 380460255,
 8338,
 -59728,
 380524645,
 8345,
 -59727,
 380588572,
 8344,
 -59726,
 380652354,
 8343,
 -59725,
 380717117,
 8342,
 -59724,
 380782391,
 11388,
 -59723,
 380845670,
 7522,
 -59722,
 380909730,
 8341,
 -59721,
 380971138,
 8337,
 -1,
 381030081,
 8336,
 381228896,
 361831580,
 -1,
 381294285,
 381167746,
 -1,
 381359817,
 381224868,
 -1,
 381425343,
 381324646,
 983554,
 381550591,
 381354042,
 -1,
 -59714,
 381433848,
 983556,
 -1,
 381489199,
 983558,
 381687490,
 381378118,
 -1,
 -59711,
 381649437,
 983584,
 -1,
 381685807,
 983582,
 381884101,
 381625790,
 -1,
 -59708,
 381846045,
 983588,
 -1,
 381882415,
 983586,
 382080712,
 381820692,
 -1,
 -59705,
 382030486,
 983560,
 -1,
 382082253,
 983562,
 -1,
 382041300,
 582,
 382342860,
 381302931,
 -1,
 -59701,
 382291257,
 42786,
 -1,
 382353896,
 42788,
 -1,
 382303765,
 42858,
 382605018,
 381255189,
 -1,
 382670549,
 382569223,
 -1,
 382736081,
 382602945,
 11375,
 -1,
 382685553,
 11376,
 -59694,
 382700464,
 581,
 -59693,
 382815042,
 42880,
 -59692,
 382878731,
 42878,
 -1,
 382941346,
 42893,
 383129303,
 382614790,
 42852,
 -1,
 383059653,
 42854,
 -59688,
 383096335,
 42792,
 -59687,
 383217832,
 42794,
 -1,
 383256640,
 574,
 383457000,
 382537409,
 -1,
 383522529,
 383387556,
 -1,
 383588063,
 383475270,
 -1,
 -59682,
 383549981,
 983580,
 -1,
 383586351,
 983578,
 -59680,
 383548628,
 570,
 -1,
 383734441,
 983552,
 383915747,
 383486896,
 42808,
 -1,
 383846610,
 42810,
 -59676,
 383882287,
 42812,
 -59675,
 384009767,
 42806,
 -59674,
 384064735,
 42804,
 -59673,
 384127345,
 11373,
 -1,
 384175809,
 42802,
 384374518,
 383401574,
 -1,
 384440048,
 384326557,
 -1,
 -59669,
 384400917,
 42886,
 -59668,
 384464262,
 42884,
 -59667,
 384527714,
 42882,
 -59666,
 384578769,
 42877,
 -59665,
 384643422,
 42875,
 -1,
 384705237,
 42873,
 384898805,
 384370596,
 -1,
 384964340,
 384851526,
 -1,
 -59661,
 384926237,
 983594,
 -1,
 384962607,
 983592,
 -1,
 384914089,
 983564,
 -1,
 384857478,
 42860,
 385292033,
 384331106,
 -1,
 385357567,
 385220608,
 -1,
 385423102,
 385323367,
 -1,
 385488636,
 385383957,
 -1,
 -59653,
 385433964,
 983602,
 -1,
 385487257,
 11364,
 -59651,
 385449172,
 588,
 -1,
 385637694,
 42918,
 -1,
 385381482,
 42842,
 -59648,
 385321104,
 42844,
 -1,
 385822704,
 42814,
 386012939,
 385254953,
 -1,
 386078474,
 385978727,
 -1,
 386144007,
 386028189,
 -1,
 -59643,
 386105885,
 983610,
 -59642,
 386152440,
 983576,
 -1,
 386207791,
 983608,
 386465791,
 386096710,
 -1,
 -59639,
 386368029,
 983606,
 -1,
 386404399,
 983604,
 -1,
 386013321,
 580,
 386668307,
 385971590,
 -1,
 386733840,
 386598820,
 -1,
 -59634,
 386698598,
 983574,
 -59633,
 386760081,
 11390,
 -1,
 386817342,
 42920,
 -59631,
 386683780,
 586,
 -59630,
 386939377,
 7838,
 -1,
 386994926,
 42891,
 387192605,
 386620639,
 -1,
 387258140,
 387123108,
 -1,
 387323673,
 387222886,
 983568,
 387448831,
 387252282,
 -1,
 -59624,
 387332088,
 983570,
 -1,
 387387439,
 983572,
 387645439,
 387272798,
 -1,
 -59621,
 387539271,
 42828,
 -1,
 387602992,
 42826,
 -1,
 387210463,
 42830,
 387847971,
 387140432,
 -1,
 -59617,
 387809821,
 983598,
 -59616,
 387864098,
 11362,
 -59615,
 387922808,
 42824,
 -59614,
 387983020,
 11360,
 -1,
 388044937,
 573,
 388241194,
 387795058,
 -1,
 388306726,
 388201684,
 42816,
 -1,
 388235344,
 42820,
 388437801,
 388244181,
 -1,
 -59608,
 388382401,
 42818,
 -1,
 388443702,
 11369,
 -1,
 388390206,
 42914,
 388699953,
 388176845,
 -1,
 388765485,
 388662990,
 42796,
 -1,
 388696066,
 42798,
 388896560,
 388695972,
 -1,
 -59601,
 388857044,
 571,
 -1,
 388896905,
 42898,
 -1,
 388849542,
 42862,
 389158710,
 388664240,
 -1,
 -59597,
 389125167,
 42848,
 -59596,
 389170602,
 42850,
 -59595,
 389229687,
 42856,
 -1,
 389285952,
 42846,
 389486396,
 389113647,
 -1,
 389551931,
 389444998,
 -1,
 389617466,
 389514344,
 11363,
 -1,
 389547717,
 42832,
 -1,
 389573973,
 42836,
 -1,
 389493633,
 42834,
 389879619,
 389435932,
 -1,
 389945152,
 389824456,
 -1,
 -59585,
 389909424,
 7932,
 -1,
 389959632,
 7930,
 390201343,
 389875620,
 -1,
 -59582,
 390103581,
 983600,
 -1,
 390151314,
 11374,
 390338377,
 389822626,
 -1,
 390403911,
 390268836,
 -1,
 -59578,
 390347922,
 42922,
 -1,
 390407224,
 11367,
 -59576,
 390343841,
 42790,
 -1,
 390533798,
 11381,
 390731597,
 390280401,
 -1,
 -59573,
 390680831,
 577,
 -59572,
 390740152,
 983198,
 -1,
 390793555,
 42912,
 390993744,
 390698513,
 -1,
 -59569,
 390954385,
 11391,
 -1,
 390997048,
 11371,
 391190355,
 390960229,
 -1,
 -59566,
 391150804,
 590,
 -1,
 391205065,
 7934,
 391386966,
 391146529,
 -1,
 -59563,
 391347469,
 42838,
 -1,
 391390392,
 42840,
 391583577,
 391338113,
 -1,
 -59560,
 391535934,
 42916,
 -1,
 391586872,
 42896,
 391780188,
 391530297,
 -1,
 -59557,
 391741981,
 983596,
 -1,
 391806164,
 584,
 391976799,
 391714812,
 -1,
 -59554,
 391935011,
 42822,
 -1,
 391973282,
 579,
 -1,
 391942016,
 11378,
 392238980,
 381177417,
 -1,
 392304514,
 392198591,
 -1,
 392370023,
 392265237,
 7451,
 392495103,
 392334087,
 -1,
 -59547,
 392392034,
 7450,
 -59546,
 392450588,
 43002,
 -1,
 392505474,
 11387,
 392697708,
 392326498,
 -1,
 392763243,
 392638439,
 -1,
 -59542,
 392719714,
 7449,
 -1,
 392779877,
 7438,
 -1,
 392726661,
 42870,
 393025391,
 392649951,
 7439,
 -59538,
 392988199,
 7445,
 -1,
 393046091,
 7440,
 393222002,
 392964226,
 7431,
 -59535,
 393189098,
 7459,
 -1,
 393248945,
 7430,
 393418612,
 393154241,
 7424,
 -1,
 393357442,
 7425,
 -59531,
 393385487,
 7458,
 -59530,
 393514824,
 7457,
 -59529,
 393579440,
 7456,
 -59528,
 393643559,
 7452,
 -59527,
 393704838,
 42801,
 -59526,
 393766651,
 7448,
 -59525,
 393826844,
 7437,
 -59524,
 393890648,
 7436,
 -59523,
 393955389,
 7435,
 -59522,
 394020663,
 7434,
 -59521,
 394080606,
 42800,
 -59520,
 394142421,
 7429,
 -59519,
 394206157,
 7428,
 -1,
 394270898,
 7427,
 -59517,
 392269404,
 7460,
 -1,
 394400186,
 7461,
 394657791,
 392179026,
 -1,
 394663816,
 394555624,
 -1,
 -59513,
 394618619,
 43004,
 -1,
 394670430,
 43003,
 394860427,
 394608230,
 -1,
 -59510,
 394812545,
 43005,
 -1,
 394855160,
 43006,
 -1,
 394794230,
 43007,
 395122585,
 361787658,
 -1,
 395188114,
 395074783,
 -1,
 395253649,
 395139480,
 -1,
 -59504,
 395211521,
 68415,
 -1,
 395257354,
 68413,
 -1,
 395210430,
 128310,
 395515797,
 395150695,
 -1,
 -59500,
 395473697,
 68414,
 -1,
 395519548,
 68412,
 395712408,
 395451019,
 -1,
 -59497,
 395650248,
 128311,
 -1,
 395714246,
 128309,
 -1,
 395669491,
 128308,
 395974562,
 395074795,
 -1,
 396040093,
 395921962,
 -1,
 -59492,
 395992277,
 3807,
 -1,
 396048254,
 3806,
 396236704,
 395981730,
 -1,
 -59489,
 396189574,
 983202,
 -1,
 396236745,
 983203,
 -59487,
 396194797,
 983204,
 -1,
 396382302,
 983205,
 396564389,
 395934732,
 -1,
 -59484,
 396530039,
 127772,
 -1,
 396590546,
 127767,
 -1,
 396503147,
 128030,
 396826960,
 361709158,
 -1,
 396892338,
 396777573,
 -1,
 396957873,
 396830850,
 -1,
 397023405,
 396891362,
 -1,
 397088826,
 396967897,
 -1,
 397154328,
 397023228,
 -1,
 397219834,
 397085603,
 -1,
 397285313,
 397151008,
 -1,
 397350834,
 397217136,
 -1,
 -59472,
 397300307,
 65669,
 -59471,
 397357423,
 65668,
 -1,
 397410743,
 65667,
 397612981,
 397282954,
 -1,
 -59468,
 397562408,
 65677,
 -1,
 397619555,
 65676,
 397809592,
 397545046,
 -1,
 -59465,
 397759009,
 65675,
 -1,
 397816201,
 65674,
 398006203,
 397741591,
 -1,
 -59462,
 397955638,
 65673,
 -1,
 398012798,
 65672,
 398202814,
 397938141,
 -1,
 -59459,
 398152269,
 65671,
 -1,
 398209385,
 65670,
 -59457,
 398134587,
 65666,
 -59456,
 398331037,
 65665,
 -1,
 398396231,
 65664,
 398596044,
 397217245,
 -1,
 -59453,
 398528138,
 65713,
 -59452,
 398593622,
 65712,
 -59451,
 398659095,
 65711,
 -59450,
 398724573,
 65710,
 -59449,
 398790000,
 65709,
 -59448,
 398855474,
 65708,
 -59447,
 398920921,
 65707,
 -59446,
 398986309,
 65706,
 -59445,
 399051683,
 65705,
 -1,
 399117088,
 65704,
 399316950,
 398528023,
 -1,
 -59442,
 399249034,
 65722,
 -59441,
 399314518,
 65721,
 -59440,
 399379991,
 65720,
 -59439,
 399445508,
 65719,
 -59438,
 399510834,
 65718,
 -59437,
 399576300,
 65717,
 -59436,
 399641651,
 65716,
 -59435,
 399707043,
 65715,
 -1,
 399772448,
 65714,
 399972319,
 399248752,
 -1,
 -59432,
 399904396,
 65703,
 -59431,
 399969878,
 65702,
 -59430,
 400035351,
 65701,
 -59429,
 400100658,
 65699,
 -59428,
 400166090,
 65698,
 -59427,
 400231475,
 65697,
 -59426,
 400296928,
 65696,
 -1,
 400362272,
 65695,
 400562151,
 399904342,
 -1,
 -59423,
 400494218,
 65729,
 -59422,
 400559472,
 65728,
 -59421,
 400624946,
 65727,
 -59420,
 400690378,
 65726,
 -59419,
 400755763,
 65725,
 -59418,
 400821155,
 65724,
 -1,
 400886560,
 65723,
 401086445,
 400493874,
 -1,
 -59415,
 401018333,
 65694,
 -59414,
 401083829,
 65693,
 -59413,
 401148979,
 65692,
 -59412,
 401214416,
 65691,
 -1,
 401279778,
 65690,
 401479667,
 401017907,
 -1,
 -59409,
 401411462,
 65682,
 -59408,
 401476873,
 65681,
 -59407,
 401542228,
 65680,
 -59406,
 401607597,
 65679,
 -1,
 401673070,
 65678,
 401872887,
 401411274,
 -1,
 -59403,
 401804339,
 65687,
 -59402,
 401869834,
 65686,
 -1,
 401935186,
 65685,
 402194431,
 401804938,
 -1,
 -59399,
 402066391,
 65731,
 -1,
 402131744,
 65730,
 402391039,
 397151283,
 -1,
 402397189,
 402263408,
 -1,
 -59395,
 402329226,
 65757,
 -59394,
 402394710,
 65756,
 -59393,
 402460183,
 65755,
 -59392,
 402525661,
 65754,
 -59391,
 402591088,
 65753,
 -59390,
 402656564,
 65752,
 -59389,
 402721994,
 65751,
 -59388,
 402787379,
 65750,
 -1,
 402852771,
 65749,
 403052558,
 402328882,
 -1,
 -59385,
 402984586,
 65748,
 -59384,
 403050070,
 65747,
 -59383,
 403115485,
 65745,
 -59382,
 403180912,
 65744,
 -59381,
 403246361,
 65743,
 -59380,
 403311669,
 65742,
 -59379,
 403377078,
 65741,
 -1,
 403442550,
 65740,
 403642389,
 402984138,
 -1,
 -59376,
 403574237,
 65739,
 -59375,
 403639602,
 65738,
 -59374,
 403705105,
 65737,
 -59373,
 403770419,
 65736,
 -59372,
 403835813,
 65735,
 -1,
 403901282,
 65734,
 404160511,
 403573811,
 -1,
 -59369,
 404032892,
 65733,
 -1,
 404097841,
 65732,
 404357119,
 397118887,
 -1,
 404363320,
 404229171,
 -1,
 404428837,
 404294563,
 -1,
 -59364,
 404360842,
 65778,
 -59363,
 404426326,
 65777,
 -59362,
 404491799,
 65776,
 -59361,
 404557277,
 65775,
 -59360,
 404622704,
 65774,
 -59359,
 404688178,
 65773,
 -59358,
 404753610,
 65772,
 -59357,
 404818995,
 65771,
 -59356,
 404884387,
 65770,
 -1,
 404949792,
 65769,
 405149744,
 404359968,
 -1,
 -59353,
 405081738,
 65768,
 -59352,
 405147222,
 65767,
 -59351,
 405212695,
 65766,
 -59350,
 405278173,
 65765,
 -59349,
 405343600,
 65764,
 -59348,
 405409074,
 65763,
 -59347,
 405474506,
 65762,
 -59346,
 405539891,
 65761,
 -59345,
 405605283,
 65760,
 -1,
 405670688,
 65759,
 405870647,
 405081139,
 -1,
 -59342,
 405802634,
 65784,
 -59341,
 405868118,
 65783,
 -59340,
 405933591,
 65782,
 -59339,
 405999069,
 65781,
 -59338,
 406064179,
 65780,
 -1,
 406129571,
 65779,
 -1,
 405802432,
 65785,
 -59335,
 404294949,
 65786,
 -1,
 406326300,
 65758,
 406526115,
 397049260,
 -1,
 406591632,
 406474724,
 -1,
 406657094,
 406523415,
 -1,
 -59330,
 406589043,
 65572,
 -59329,
 406654499,
 65551,
 -59328,
 406719987,
 65608,
 -59327,
 406785456,
 65592,
 -59326,
 406850907,
 65597,
 -59325,
 406916327,
 65558,
 -59324,
 406981724,
 65567,
 -59323,
 407047114,
 65603,
 -1,
 407112509,
 65554,
 407312464,
 406588784,
 -1,
 -59320,
 407244452,
 65586,
 -59319,
 407309950,
 65585,
 -59318,
 407375390,
 65546,
 -59317,
 407440806,
 65565,
 -59316,
 407506262,
 65591,
 -59315,
 407571716,
 65578,
 -59314,
 407637071,
 65564,
 -59313,
 407702469,
 65545,
 -1,
 407767896,
 65570,
 407967834,
 407243827,
 -1,
 -59310,
 407899801,
 65606,
 -59309,
 407965280,
 65538,
 -59308,
 408030772,
 65577,
 -59307,
 408096249,
 65580,
 -59306,
 408161650,
 65600,
 -59305,
 408227148,
 65562,
 -59304,
 408292596,
 65560,
 -59303,
 408357877,
 65573,
 -1,
 408423309,
 65599,
 408623204,
 407898912,
 -1,
 -59300,
 408555167,
 65582,
 -59299,
 408620632,
 65536,
 -59298,
 408686105,
 65543,
 -59297,
 408751593,
 65561,
 -59296,
 408817067,
 65589,
 -59295,
 408882513,
 65587,
 -59294,
 408947961,
 65566,
 -59293,
 409013390,
 65579,
 -1,
 409078720,
 65541,
 409278573,
 408554973,
 -1,
 -59290,
 409210537,
 65590,
 -59289,
 409276024,
 65610,
 -59288,
 409341487,
 65553,
 -59287,
 409406974,
 65611,
 -59286,
 409472405,
 65550,
 -59285,
 409537667,
 65607,
 -59284,
 409603052,
 65539,
 -1,
 409668445,
 65576,
 409868406,
 409210162,
 -1,
 -59281,
 409800301,
 65605,
 -59280,
 409865695,
 65547,
 -59279,
 409931152,
 65542,
 -59278,
 409996615,
 65552,
 -59277,
 410062028,
 65601,
 -59276,
 410127512,
 65594,
 -59275,
 410192895,
 65583,
 -1,
 410258312,
 65593,
 410458239,
 409799882,
 -1,
 -59272,
 410390164,
 65568,
 -59271,
 410455644,
 65537,
 -59270,
 410521145,
 65588,
 -59269,
 410586596,
 65549,
 -59268,
 410651902,
 65609,
 -59267,
 410717321,
 65574,
 -59266,
 410782714,
 65581,
 -1,
 410848077,
 65563,
 411048072,
 410389411,
 -1,
 -59263,
 410979908,
 65596,
 -59262,
 411045358,
 65571,
 -59261,
 411110817,
 65559,
 -59260,
 411176258,
 65544,
 -59259,
 411241698,
 65557,
 -59258,
 411307155,
 65584,
 -59257,
 411372528,
 65569,
 -1,
 411437930,
 65540,
 411637901,
 410979926,
 -1,
 -59254,
 411569726,
 65612,
 -59253,
 411635063,
 65602,
 -59252,
 411700199,
 65555,
 -1,
 411765570,
 65556,
 412024831,
 411569802,
 -1,
 -59249,
 411896836,
 65613,
 -1,
 411962155,
 65604,
 412221439,
 406541454,
 -1,
 412227734,
 412094038,
 -1,
 -59245,
 412159626,
 65629,
 -59244,
 412224989,
 65628,
 -59243,
 412290250,
 65627,
 -1,
 412355635,
 65626,
 412555417,
 412159453,
 -1,
 -59240,
 412486962,
 65624,
 -1,
 412552394,
 65623,
 412752028,
 412486962,
 -1,
 -59237,
 412683914,
 65621,
 -1,
 412749335,
 65620,
 412948639,
 412683171,
 -1,
 -59234,
 412880522,
 65617,
 -1,
 412946006,
 65616,
 -59232,
 412880467,
 65625,
 -59231,
 413076941,
 65622,
 -59230,
 413142316,
 65619,
 -1,
 413207727,
 65618,
 413466623,
 406476640,
 -1,
 413472940,
 413338531,
 -1,
 413538472,
 413404362,
 -1,
 -59225,
 413470106,
 65689,
 -1,
 413535441,
 65688,
 413735083,
 413469747,
 -1,
 -59222,
 413666916,
 65684,
 -1,
 413732392,
 65683,
 -1,
 413666768,
 65700,
 -1,
 413404338,
 65746,
 414121983,
 396951552,
 -1,
 414128304,
 414023365,
 983068,
 -1,
 414058045,
 983142,
 -1,
 414069307,
 983062,
 -1,
 396904553,
 128279,
 414390541,
 396841500,
 -1,
 414456076,
 414325609,
 -1,
 414521563,
 414404169,
 -1,
 414587065,
 414479750,
 -1,
 -59209,
 414545370,
 6426,
 -59208,
 414595256,
 6425,
 -1,
 414650049,
 6427,
 414849211,
 414553201,
 6421,
 -1,
 414799973,
 6410,
 414980286,
 414809621,
 -1,
 -59203,
 414922936,
 6412,
 -1,
 414977729,
 6411,
 415176897,
 414934779,
 -1,
 -59200,
 415119544,
 6417,
 -1,
 415174337,
 6416,
 415373508,
 415127653,
 -1,
 -59197,
 415315203,
 6405,
 -1,
 415370945,
 6415,
 415570119,
 415320125,
 -1,
 -59194,
 415512760,
 6402,
 -1,
 415567553,
 6401,
 415766730,
 415516471,
 -1,
 -59191,
 415709368,
 6409,
 -1,
 415764161,
 6408,
 415963341,
 415708369,
 -1,
 -59188,
 415905976,
 6404,
 -1,
 415960769,
 6403,
 416159952,
 415900373,
 -1,
 -59185,
 416102584,
 6414,
 -1,
 416157377,
 6413,
 416356563,
 416095181,
 -1,
 -59182,
 416299192,
 6407,
 -1,
 416353985,
 6406,
 416553174,
 416290812,
 -1,
 -59179,
 416495800,
 6419,
 -1,
 416550593,
 6418,
 -59177,
 416518031,
 6424,
 -59176,
 416705984,
 6422,
 -59175,
 416764533,
 6420,
 -59174,
 416828272,
 6423,
 -1,
 416889016,
 6428,
 417077488,
 414479750,
 -1,
 417143015,
 417026935,
 -1,
 417208544,
 417093733,
 -1,
 -59169,
 417150211,
 6449,
 -1,
 417205953,
 6452,
 -59167,
 417169035,
 6451,
 -59166,
 417361344,
 6455,
 -59165,
 417425210,
 6453,
 -59164,
 417485429,
 6454,
 -59163,
 417549168,
 6456,
 -59162,
 417613967,
 6448,
 -1,
 417666147,
 6450,
 417863916,
 417087780,
 -1,
 -59159,
 417822173,
 6459,
 -59158,
 417880009,
 6457,
 -59157,
 417943728,
 6464,
 -1,
 418007482,
 6458,
 418250751,
 417826541,
 -1,
 -59154,
 418157681,
 6441,
 -59153,
 418221967,
 6443,
 -1,
 418278848,
 6442,
 418453756,
 417042088,
 -1,
 418519291,
 418383439,
 -1,
 418584821,
 418451137,
 6432,
 -59148,
 418547239,
 6438,
 -1,
 418594406,
 6436,
 418781431,
 418536671,
 6440,
 -1,
 418733279,
 6437,
 418912505,
 418719874,
 6439,
 -1,
 418850946,
 6435,
 -59142,
 418874919,
 6434,
 -1,
 418987622,
 6433,
 -1,
 418449910,
 6400,
 419240202,
 418391287,
 -1,
 419305728,
 419200533,
 -1,
 -59137,
 419271278,
 6472,
 -1,
 419315045,
 6473,
 419502339,
 419263878,
 -1,
 -59134,
 419448544,
 6476,
 -1,
 419508103,
 6477,
 419698950,
 419443038,
 -1,
 -59131,
 419652722,
 6474,
 -1,
 419710607,
 6475,
 -59129,
 419665581,
 6470,
 -59128,
 419848182,
 6471,
 -59127,
 419912343,
 6479,
 -1,
 419965756,
 6478,
 -59125,
 419196176,
 6469,
 -1,
 420098128,
 6468,
 -1,
 414402121,
 13007,
 420354381,
 414350665,
 -1,
 420419914,
 420302409,
 -1,
 420485405,
 420380181,
 -1,
 420550936,
 420438010,
 -1,
 420616471,
 420501592,
 -1,
 -59117,
 420577746,
 42232,
 -59116,
 420632763,
 42236,
 -59115,
 420693948,
 42237,
 -59114,
 420750028,
 42234,
 -1,
 420813470,
 42235,
 -1,
 420567239,
 42233,
 421075227,
 420509062,
 -1,
 -59110,
 421017784,
 42206,
 -1,
 421072577,
 42205,
 -59108,
 421017784,
 42197,
 -1,
 421203649,
 42196,
 421402912,
 420447783,
 42228,
 -59105,
 421345442,
 42230,
 -1,
 421406850,
 42229,
 421599523,
 421369359,
 -1,
 -59102,
 421542072,
 42211,
 -1,
 421596865,
 42212,
 421796134,
 421557638,
 -1,
 -59099,
 421738680,
 42219,
 -1,
 421793473,
 42210,
 421992745,
 421750523,
 -1,
 -59096,
 421935288,
 42194,
 -1,
 421990081,
 42193,
 422189355,
 421944543,
 42227,
 -1,
 422127746,
 42231,
 422320430,
 422140005,
 -1,
 -59091,
 422262019,
 42213,
 -1,
 422317761,
 42208,
 422517041,
 422266941,
 -1,
 -59088,
 422459576,
 42200,
 -1,
 422514369,
 42199,
 422713652,
 422459554,
 -1,
 -59085,
 422656184,
 42216,
 -1,
 422710977,
 42214,
 422910263,
 422655185,
 -1,
 -59082,
 422852792,
 42221,
 -1,
 422907585,
 42198,
 423106873,
 422848642,
 42224,
 -1,
 423069223,
 42225,
 423237948,
 423043797,
 -1,
 -59077,
 423204383,
 42204,
 -1,
 423235265,
 42195,
 423434559,
 423173069,
 -1,
 -59074,
 423377080,
 42203,
 -1,
 423431873,
 42202,
 423631169,
 423366337,
 42222,
 -1,
 423569538,
 42223,
 -59070,
 423597169,
 42220,
 -59069,
 423728070,
 42215,
 -59068,
 423792527,
 42218,
 -59067,
 423842421,
 42207,
 -59066,
 423906160,
 42209,
 -59065,
 423970645,
 42201,
 -59064,
 424033894,
 42226,
 -59063,
 424096187,
 42217,
 -1,
 424155185,
 42192,
 424411135,
 420375488,
 -1,
 -59060,
 424293568,
 42239,
 -1,
 424353879,
 42238,
 -59058,
 420319002,
 8374,
 -59057,
 424504213,
 128132,
 -1,
 424556288,
 128648,
 424745460,
 396765314,
 -1,
 424810934,
 424699914,
 -1,
 424876424,
 424758857,
 -1,
 424941916,
 424836629,
 -1,
 425007447,
 424902165,
 -1,
 -59050,
 424949944,
 7246,
 -1,
 425004737,
 7245,
 425204058,
 424965510,
 -1,
 -59047,
 425146552,
 7192,
 -1,
 425201345,
 7191,
 -59045,
 425146552,
 7179,
 -1,
 425332417,
 7178,
 425531744,
 424896251,
 -1,
 -59042,
 425479024,
 7183,
 -59041,
 425539768,
 7184,
 -1,
 425594561,
 7182,
 425793892,
 425482341,
 -1,
 -59038,
 425759857,
 7177,
 -59037,
 425800963,
 7173,
 -1,
 425856705,
 7181,
 426056040,
 425740349,
 -1,
 -59034,
 426003312,
 7169,
 -59033,
 426064056,
 7170,
 -1,
 426118849,
 7168,
 426318188,
 425992917,
 -1,
 -59030,
 426284575,
 7193,
 -59029,
 426320690,
 7247,
 -1,
 426380993,
 7180,
 426580335,
 426276230,
 -1,
 -59026,
 426522808,
 7201,
 -1,
 426577601,
 7200,
 426776946,
 426529308,
 -1,
 -59023,
 426724208,
 7190,
 -1,
 426774209,
 7189,
 426973557,
 426719394,
 -1,
 -59020,
 426920816,
 7198,
 -1,
 426970817,
 7197,
 427170168,
 426915025,
 -1,
 -59017,
 427117424,
 7172,
 -1,
 427167425,
 7171,
 427366779,
 427110750,
 -1,
 -59014,
 427314032,
 7186,
 -1,
 427364033,
 7185,
 427563390,
 427301837,
 -1,
 -59011,
 427505848,
 7175,
 -1,
 427560641,
 7174,
 427760001,
 427497468,
 -1,
 -59008,
 427707248,
 7188,
 -1,
 427757249,
 7187,
 -59006,
 427725937,
 7194,
 -59005,
 427921295,
 7202,
 -59004,
 427985862,
 7199,
 -59003,
 428043712,
 7195,
 -59002,
 428100464,
 7196,
 -59001,
 428164949,
 7176,
 -1,
 428216001,
 7203,
 428415382,
 424813815,
 -1,
 428480908,
 428375573,
 -1,
 -58997,
 428446318,
 7234,
 -1,
 428490085,
 7235,
 428677519,
 428438918,
 -1,
 -58994,
 428623584,
 7238,
 -1,
 428683143,
 7239,
 428874130,
 428618078,
 -1,
 -58991,
 428827762,
 7236,
 -1,
 428885647,
 7237,
 -58989,
 428840621,
 7232,
 -58988,
 429023222,
 7233,
 -58987,
 429087383,
 7241,
 -1,
 429140796,
 7240,
 429332896,
 428351625,
 -1,
 429398425,
 429283429,
 7216,
 -1,
 429364544,
 7220,
 429529499,
 429344829,
 7213,
 -1,
 429462471,
 7221,
 -58980,
 429489685,
 7219,
 -58979,
 429616482,
 7218,
 -58978,
 429680379,
 7217,
 -58977,
 429740572,
 7214,
 -1,
 429804354,
 7215,
 429988264,
 429297367,
 -1,
 430053795,
 429950503,
 7210,
 -1,
 430016039,
 7211,
 430184869,
 430005471,
 7208,
 -1,
 430136543,
 7209,
 -58970,
 430128742,
 7207,
 -58969,
 430254210,
 7212,
 -1,
 430313274,
 7206,
 430512559,
 429943744,
 -1,
 430578093,
 430472725,
 -1,
 430643628,
 430536740,
 7231,
 -1,
 430571779,
 7230,
 -1,
 430575395,
 7227,
 -58962,
 430529715,
 7228,
 -1,
 430775708,
 7229,
 431030271,
 430470534,
 -1,
 431036851,
 430933741,
 -1,
 -58958,
 431002737,
 7204,
 -1,
 431058368,
 7205,
 431292415,
 430981412,
 -1,
 -58955,
 431189677,
 7222,
 -1,
 431250461,
 7223,
 431430128,
 424752249,
 -1,
 431495637,
 431394733,
 -1,
 431561160,
 431429041,
 -1,
 431626690,
 431526247,
 -1,
 431692225,
 431586837,
 -1,
 431757758,
 431637771,
 -1,
 -58947,
 431721082,
 11025,
 -1,
 431761288,
 11024,
 432013311,
 431690141,
 -1,
 -58944,
 431918458,
 11065,
 -1,
 431957826,
 11066,
 -1,
 431629949,
 11064,
 432216519,
 431558582,
 -1,
 432282054,
 432173279,
 -1,
 -58939,
 432243235,
 11083,
 -1,
 432280264,
 11074,
 -1,
 432214728,
 11082,
 -1,
 432177588,
 11070,
 432609747,
 431523336,
 -1,
 432675282,
 432543153,
 -1,
 432740817,
 432640359,
 -1,
 432806351,
 432701180,
 11067,
 432930815,
 432736164,
 -1,
 -58930,
 432835962,
 11068,
 -1,
 432875330,
 11069,
 -58928,
 432770426,
 11060,
 -1,
 433006402,
 11061,
 -1,
 432682081,
 11062,
 -1,
 432637014,
 11063,
 -58924,
 432565371,
 11077,
 -1,
 433265189,
 11013,
 433461739,
 431423488,
 -1,
 433527258,
 433419654,
 -1,
 -58920,
 433489823,
 11778,
 -58919,
 433537027,
 11814,
 -1,
 433588932,
 10181,
 433789407,
 433483106,
 -1,
 433854942,
 433733838,
 -1,
 -58915,
 433819778,
 11012,
 -1,
 433855013,
 11020,
 -1,
 433787326,
 11788,
 434117090,
 433736514,
 -1,
 -58911,
 434079745,
 128709,
 -1,
 434136692,
 11804,
 434313701,
 434054539,
 -1,
 -58908,
 434276135,
 11816,
 -1,
 434341016,
 11780,
 434510312,
 434247096,
 -1,
 -58905,
 434469343,
 11056,
 -1,
 434511588,
 11058,
 -58903,
 434474303,
 11808,
 -58902,
 434668429,
 11785,
 -1,
 434708373,
 9948,
 434962431,
 433392094,
 -1,
 434969070,
 434844110,
 4054,
 -1,
 434899057,
 4056,
 -58897,
 434924098,
 128269,
 -1,
 435042669,
 9958,
 -58895,
 431382879,
 128006,
 -58894,
 435181394,
 127819,
 -58893,
 435233904,
 128210,
 -1,
 435294467,
 127811,
 435493424,
 424711215,
 -1,
 435558931,
 435429024,
 -1,
 435624441,
 435518997,
 66199,
 -58888,
 435584533,
 66200,
 -1,
 435632290,
 66185,
 435821051,
 435574885,
 66191,
 -1,
 435771493,
 66193,
 435952125,
 435769884,
 66190,
 -1,
 435900956,
 66192,
 436083199,
 435898429,
 66187,
 -1,
 436029501,
 66196,
 436214273,
 436021378,
 66177,
 -1,
 436164709,
 66202,
 436345347,
 436148220,
 66178,
 -1,
 436287650,
 66179,
 436476421,
 436276929,
 66176,
 -1,
 436426853,
 66201,
 -58874,
 436442639,
 66184,
 -58873,
 436573051,
 66204,
 -58872,
 436637512,
 66183,
 -58871,
 436700711,
 66194,
 -58870,
 436761990,
 66198,
 -58869,
 436825442,
 66197,
 -58868,
 436890655,
 66188,
 -58867,
 436954875,
 66195,
 -58866,
 437013314,
 66189,
 -58865,
 437077815,
 66186,
 -58864,
 437141094,
 66182,
 -58863,
 437205154,
 66203,
 -58862,
 437269713,
 66180,
 -1,
 437330645,
 66181,
 437583871,
 435496153,
 -1,
 437590575,
 437472841,
 -1,
 437656087,
 437550613,
 67887,
 -1,
 437616149,
 67892,
 437787161,
 437613958,
 67891,
 -1,
 437745030,
 67886,
 437918235,
 437737573,
 67883,
 -1,
 437868645,
 67896,
 438049309,
 437865282,
 67881,
 -1,
 438015023,
 67895,
 438180383,
 437987458,
 67876,
 -1,
 438130789,
 67894,
 438311457,
 438111937,
 67872,
 -1,
 438261861,
 67893,
 -58846,
 438277167,
 67879,
 -58845,
 438406064,
 67877,
 -58844,
 438470183,
 67888,
 -58843,
 438529378,
 67885,
 -58842,
 438594591,
 67890,
 -58841,
 438656223,
 67884,
 -58840,
 438719004,
 67882,
 -58839,
 438782013,
 67880,
 -58838,
 438845030,
 67878,
 -58837,
 438908113,
 67874,
 -58836,
 438972766,
 67889,
 -58835,
 439034581,
 67875,
 -58834,
 439098317,
 67897,
 -1,
 439162876,
 67873,
 -1,
 437552164,
 67903,
 439425599,
 435444959,
 -1,
 439491126,
 439361350,
 128274,
 439556661,
 439436106,
 -1,
 -58828,
 439522989,
 983079,
 -1,
 439574518,
 983076,
 -1,
 439486732,
 128271,
 439818809,
 439454856,
 -1,
 -58824,
 439766594,
 128140,
 -1,
 439827757,
 127977,
 440015420,
 439769644,
 -1,
 -58821,
 439963102,
 11059,
 -1,
 440018291,
 10188,
 -58819,
 439979850,
 128261,
 -58818,
 440174538,
 128557,
 -1,
 440225830,
 127853,
 440408643,
 439381346,
 -1,
 -58815,
 440360159,
 983219,
 -58814,
 440422940,
 983214,
 -1,
 440477826,
 983216,
 -1,
 440349022,
 983065,
 440737268,
 361663408,
 -1,
 440802466,
 440667841,
 -1,
 440867745,
 440745576,
 -1,
 440933264,
 440827308,
 -1,
 440998781,
 440881116,
 -1,
 441064060,
 440948837,
 -1,
 441129559,
 441005265,
 42507,
 441195092,
 441070801,
 -1,
 441260623,
 441133186,
 42500,
 -58802,
 441210981,
 42501,
 -1,
 441264258,
 42271,
 441457233,
 441212127,
 42460,
 -1,
 441408735,
 42384,
 -58798,
 441419303,
 42421,
 -58797,
 441532006,
 42308,
 -1,
 441585345,
 42348,
 -58795,
 441147270,
 42428,
 -58794,
 441723908,
 42467,
 -1,
 441783086,
 42315,
 441981541,
 441066197,
 -1,
 442047072,
 441933023,
 42450,
 442112607,
 441994481,
 -1,
 -58789,
 442071780,
 42514,
 -58788,
 442126965,
 42538,
 -58787,
 442189967,
 42513,
 -58786,
 442249659,
 42512,
 -1,
 442312075,
 42539,
 -1,
 442064095,
 42374,
 442571362,
 441985154,
 42490,
 -1,
 442509442,
 42261,
 -58781,
 442533415,
 42411,
 -58780,
 442646118,
 42298,
 -1,
 442699457,
 42337,
 442899053,
 441947183,
 -1,
 442964584,
 442850527,
 42464,
 -1,
 442916063,
 42388,
 443095658,
 442902658,
 42506,
 -1,
 443033730,
 42275,
 -58773,
 443057703,
 42425,
 -58772,
 443170406,
 42312,
 -1,
 443223745,
 42352,
 443423349,
 442844983,
 -1,
 443488880,
 443374815,
 42457,
 -1,
 443440351,
 42381,
 443619954,
 443426946,
 42497,
 -1,
 443558018,
 42268,
 -58765,
 443581991,
 42418,
 -58764,
 443694694,
 42305,
 -1,
 443748033,
 42344,
 443947639,
 443374815,
 42463,
 -1,
 443899103,
 42387,
 444078713,
 443885698,
 42505,
 -1,
 444016770,
 42274,
 -58758,
 444040743,
 42424,
 -58757,
 444153446,
 42311,
 -1,
 444206785,
 42351,
 444406420,
 441012764,
 -1,
 444471941,
 444347841,
 -1,
 444537472,
 444423391,
 42438,
 -1,
 444488927,
 42363,
 444668546,
 444475522,
 42478,
 -1,
 444606594,
 42250,
 -58749,
 444630567,
 42400,
 -58748,
 444743270,
 42287,
 -1,
 444796609,
 42326,
 444996237,
 444405756,
 -1,
 445061768,
 444947679,
 42436,
 -1,
 445013215,
 42361,
 445192842,
 444999810,
 42475,
 -1,
 445130882,
 42248,
 -58741,
 445154855,
 42398,
 -58740,
 445267558,
 42285,
 -1,
 445320897,
 42323,
 445520527,
 444947679,
 42462,
 -1,
 445471967,
 42386,
 445651601,
 445458562,
 42504,
 -1,
 445589634,
 42273,
 -58734,
 445613607,
 42423,
 -58733,
 445726310,
 42310,
 -1,
 445779649,
 42350,
 445979308,
 444342997,
 -1,
 446044837,
 445921442,
 -1,
 446110366,
 445986978,
 -1,
 446175897,
 446061791,
 42446,
 -1,
 446127327,
 42370,
 446306971,
 446113922,
 42486,
 -1,
 446244994,
 42257,
 -58724,
 446268967,
 42407,
 -58723,
 446381670,
 42294,
 -1,
 446435009,
 42333,
 446634656,
 446061791,
 42445,
 -1,
 446586079,
 42369,
 446765730,
 446572674,
 42485,
 -1,
 446703746,
 42256,
 -58717,
 446727719,
 42406,
 -58716,
 446840422,
 42293,
 -1,
 446893761,
 42332,
 447093415,
 445996255,
 42449,
 -1,
 447044831,
 42373,
 447224489,
 447031426,
 42489,
 -1,
 447162498,
 42260,
 -58710,
 447186471,
 42410,
 -58709,
 447299174,
 42297,
 -1,
 447352513,
 42336,
 447552191,
 445925437,
 -1,
 447617719,
 447506171,
 -1,
 447683249,
 447555714,
 42476,
 -58704,
 447633509,
 42477,
 -1,
 447686786,
 42249,
 447879859,
 447634655,
 42437,
 -1,
 447831263,
 42362,
 448010933,
 447811265,
 42324,
 -1,
 447961189,
 42325,
 -58698,
 447972903,
 42399,
 -1,
 448085606,
 42286,
 448273081,
 447569119,
 42459,
 -1,
 448224479,
 42383,
 448404155,
 448211074,
 42499,
 -1,
 448342146,
 42270,
 448535229,
 448335553,
 42346,
 -1,
 448485477,
 42347,
 -58690,
 448497191,
 42420,
 -1,
 448609894,
 42307,
 448797394,
 447493329,
 -1,
 448862922,
 448731132,
 -1,
 448928452,
 448814303,
 42439,
 -58685,
 448879839,
 42364,
 -1,
 448944229,
 42440,
 449125063,
 448866434,
 42479,
 -58682,
 449075301,
 42480,
 -1,
 449128578,
 42251,
 -58680,
 449087015,
 42401,
 -58679,
 449265254,
 42288,
 -1,
 449318593,
 42327,
 449518285,
 448800898,
 42502,
 -58676,
 449468517,
 42503,
 -1,
 449521794,
 42272,
 449714895,
 449469663,
 42461,
 -1,
 449666271,
 42385,
 -58672,
 449676839,
 42422,
 -58671,
 449789542,
 42309,
 -1,
 449842881,
 42349,
 450042594,
 448763407,
 -1,
 450108123,
 449984674,
 -1,
 450173654,
 450059487,
 42454,
 -1,
 450125023,
 42378,
 450304728,
 450111618,
 42494,
 -1,
 450242690,
 42265,
 -58663,
 450266663,
 42415,
 -58662,
 450379366,
 42302,
 -1,
 450432705,
 42341,
 450632413,
 450059487,
 42453,
 -1,
 450583775,
 42377,
 450763487,
 450570370,
 42493,
 -1,
 450701442,
 42264,
 -58656,
 450725415,
 42414,
 -58655,
 450838118,
 42301,
 -1,
 450891457,
 42340,
 451091185,
 450006856,
 -1,
 451156711,
 451042527,
 42431,
 451222246,
 451108063,
 42356,
 -1,
 451172453,
 42357,
 -1,
 451172453,
 42432,
 451418859,
 451094658,
 42470,
 451484394,
 451356802,
 42243,
 -1,
 451434597,
 42244,
 -1,
 451434597,
 42471,
 451681005,
 451380775,
 42393,
 -1,
 451631205,
 42394,
 451812079,
 451624550,
 42280,
 -1,
 451762277,
 42281,
 452001791,
 451743425,
 42318,
 -1,
 451893349,
 42319,
 452074241,
 451051029,
 -1,
 452139770,
 452016290,
 -1,
 452205301,
 452091103,
 42444,
 -1,
 452156639,
 42368,
 452336375,
 452143234,
 42484,
 -1,
 452274306,
 42255,
 -58632,
 452298279,
 42405,
 -58631,
 452410982,
 42292,
 -1,
 452464321,
 42331,
 452664060,
 452091103,
 42443,
 -1,
 452615391,
 42367,
 452795134,
 452601986,
 42483,
 -1,
 452733058,
 42254,
 -58625,
 452757031,
 42404,
 -58624,
 452869734,
 42291,
 -1,
 452923073,
 42330,
 453122833,
 452031878,
 -1,
 453188362,
 453064866,
 -1,
 453253893,
 453139679,
 42452,
 -1,
 453205215,
 42376,
 453384967,
 453191810,
 42492,
 -1,
 453322882,
 42263,
 -58616,
 453346855,
 42413,
 -58615,
 453459558,
 42300,
 -1,
 453512897,
 42339,
 453712652,
 453139679,
 42451,
 -1,
 453663967,
 42375,
 453843726,
 453650562,
 42491,
 -1,
 453781634,
 42262,
 -58609,
 453805607,
 42412,
 -58608,
 453918310,
 42299,
 -1,
 453971649,
 42338,
 454171425,
 453056508,
 -1,
 454236954,
 454113442,
 -1,
 454302485,
 454188255,
 42434,
 -1,
 454253791,
 42359,
 454433559,
 454240386,
 42473,
 -1,
 454371458,
 42246,
 -58600,
 454395431,
 42396,
 -58599,
 454508134,
 42283,
 -1,
 454561473,
 42321,
 454761244,
 454188255,
 42435,
 -1,
 454712543,
 42360,
 454892318,
 454699138,
 42474,
 -1,
 454830210,
 42247,
 -58593,
 454854183,
 42397,
 -58592,
 454966886,
 42284,
 -1,
 455020225,
 42322,
 455220014,
 454113442,
 -1,
 455285541,
 455171295,
 42429,
 -58588,
 455236831,
 42355,
 -1,
 455301221,
 42430,
 455482152,
 455223426,
 42468,
 -58585,
 455432293,
 42469,
 -1,
 455485570,
 42242,
 455678762,
 455444007,
 42391,
 -1,
 455628901,
 42392,
 455809836,
 455622246,
 42278,
 -1,
 455759973,
 42279,
 455999487,
 455741121,
 42316,
 -1,
 455891045,
 42317,
 456071991,
 455166786,
 -1,
 456137522,
 456009858,
 42487,
 -58575,
 456088148,
 42508,
 -1,
 456140930,
 42258,
 456334132,
 456088799,
 42447,
 -1,
 456285407,
 42371,
 -58571,
 456295975,
 42408,
 -58570,
 456408678,
 42295,
 -1,
 456462017,
 42334,
 456661823,
 456037423,
 -1,
 456727354,
 456613087,
 42458,
 -1,
 456678623,
 42382,
 456858428,
 456665218,
 42498,
 -1,
 456796290,
 42269,
 -58563,
 456820263,
 42419,
 -58562,
 456932966,
 42306,
 -1,
 456986305,
 42345,
 457186119,
 456625072,
 -1,
 457251650,
 457137375,
 42442,
 -1,
 457202911,
 42366,
 457382724,
 457189506,
 42482,
 -1,
 457320578,
 42253,
 -58555,
 457344551,
 42403,
 -58554,
 457457254,
 42290,
 -1,
 457510593,
 42329,
 457710415,
 457141602,
 -1,
 457775946,
 457661663,
 42448,
 -1,
 457727199,
 42372,
 457907020,
 457713794,
 42488,
 -1,
 457844866,
 42259,
 -58547,
 457868839,
 42409,
 -58546,
 457981542,
 42296,
 -1,
 458034881,
 42335,
 458234711,
 457664251,
 -1,
 458300242,
 458185951,
 42433,
 -1,
 458251487,
 42358,
 458431316,
 458238082,
 42472,
 -1,
 458369154,
 42245,
 -58539,
 458393127,
 42395,
 -58538,
 458505830,
 42282,
 -1,
 458559169,
 42320,
 458759007,
 458180407,
 -1,
 458824538,
 458710239,
 42456,
 -1,
 458775775,
 42380,
 458955612,
 458762370,
 42496,
 -1,
 458893442,
 42267,
 -58531,
 458917415,
 42417,
 -58530,
 459030118,
 42304,
 -1,
 459083457,
 42343,
 459283303,
 458699102,
 -1,
 459348834,
 459234527,
 42441,
 -1,
 459300063,
 42365,
 459479908,
 459286658,
 42481,
 -1,
 459417730,
 42252,
 -58523,
 459441703,
 42402,
 -58522,
 459554406,
 42289,
 -1,
 459607745,
 42328,
 459807599,
 459217869,
 -1,
 459873130,
 459758815,
 42455,
 -1,
 459824351,
 42379,
 460004204,
 459810946,
 42495,
 -1,
 459942018,
 42266,
 -58515,
 459965991,
 42416,
 -58514,
 460078694,
 42303,
 -1,
 460132033,
 42342,
 460331891,
 459758815,
 42426,
 460397426,
 460283103,
 42353,
 -1,
 460347493,
 42354,
 -1,
 460347493,
 42427,
 460594039,
 460269698,
 42465,
 460659574,
 460531842,
 42240,
 -1,
 460609637,
 42241,
 -1,
 460609637,
 42466,
 460856185,
 460555815,
 42389,
 -1,
 460806245,
 42390,
 460987259,
 460799590,
 42276,
 -1,
 460937317,
 42277,
 461176831,
 460918465,
 42313,
 -1,
 461068389,
 42314,
 461307903,
 440947848,
 -1,
 461314946,
 461209109,
 -1,
 -58496,
 461267060,
 42525,
 -58495,
 461324957,
 42517,
 -1,
 461377338,
 42521,
 461577095,
 461251285,
 -1,
 461642630,
 461528287,
 -1,
 -58491,
 461594740,
 42523,
 -1,
 461638274,
 42526,
 -1,
 461575111,
 42522,
 461904778,
 461523005,
 -1,
 -58487,
 461867335,
 42524,
 -1,
 461908656,
 42516,
 462101389,
 461844830,
 -1,
 -58484,
 462039728,
 42515,
 -1,
 462098234,
 42520,
 -58482,
 462051987,
 42518,
 -58481,
 462243847,
 42527,
 -1,
 462297208,
 42519,
 462494622,
 440870135,
 -1,
 462560148,
 462454293,
 -1,
 -58477,
 462525038,
 42530,
 -1,
 462568805,
 42531,
 462756759,
 462517638,
 -1,
 -58474,
 462702304,
 42534,
 -1,
 462761863,
 42535,
 462953370,
 462696798,
 -1,
 -58471,
 462906482,
 42532,
 -1,
 462964367,
 42533,
 -58469,
 462919341,
 42528,
 -58468,
 463101942,
 42529,
 -58467,
 463166103,
 42537,
 -1,
 463219516,
 42536,
 -58465,
 462449936,
 42511,
 -58464,
 463353024,
 42510,
 -1,
 463413335,
 42509,
 463667199,
 440824165,
 -1,
 463674385,
 463539107,
 -1,
 463739822,
 463605386,
 917762,
 -58459,
 463670922,
 917942,
 -58458,
 463736406,
 917941,
 -58457,
 463801879,
 917940,
 -58456,
 463867357,
 917939,
 -58455,
 463932784,
 917938,
 -58454,
 463998258,
 917937,
 -58453,
 464063690,
 917936,
 -58452,
 464129075,
 917935,
 -58451,
 464194467,
 917934,
 -1,
 464259872,
 917933,
 464460729,
 463670870,
 917761,
 -58448,
 464391818,
 917932,
 -58447,
 464457302,
 917931,
 -58446,
 464522775,
 917930,
 -58445,
 464588253,
 917929,
 -58444,
 464653680,
 917928,
 -58443,
 464719154,
 917927,
 -58442,
 464784586,
 917926,
 -58441,
 464849971,
 917925,
 -58440,
 464915363,
 917924,
 -1,
 464980768,
 917923,
 465181636,
 464391703,
 917760,
 -58437,
 465112714,
 917922,
 -58436,
 465178198,
 917921,
 -58435,
 465243671,
 917920,
 -58434,
 465309149,
 917919,
 -58433,
 465374576,
 917918,
 -58432,
 465440050,
 917917,
 -58431,
 465505482,
 917916,
 -58430,
 465570867,
 917915,
 -58429,
 465636259,
 917914,
 -1,
 465701664,
 917913,
 465902543,
 465112541,
 -1,
 -58426,
 465833610,
 917912,
 -58425,
 465899094,
 917911,
 -58424,
 465964567,
 917910,
 -58423,
 466030045,
 917909,
 -58422,
 466095472,
 917908,
 -58421,
 466160946,
 917907,
 -58420,
 466226378,
 917906,
 -58419,
 466291763,
 917905,
 -58418,
 466357155,
 917904,
 -1,
 466422560,
 917903,
 466623450,
 465833328,
 -1,
 -58415,
 466554506,
 917902,
 -58414,
 466619990,
 917901,
 -58413,
 466685463,
 917900,
 -58412,
 466750941,
 917899,
 -58411,
 466816368,
 917898,
 -58410,
 466881842,
 917897,
 -58409,
 466947274,
 917896,
 -58408,
 467012659,
 917895,
 -58407,
 467078051,
 917894,
 -1,
 467143456,
 917893,
 467344357,
 466554162,
 -1,
 -58404,
 467275402,
 917892,
 -58403,
 467340886,
 917891,
 -58402,
 467406359,
 917890,
 -58401,
 467471837,
 917889,
 -58400,
 467537264,
 917888,
 -58399,
 467602738,
 917887,
 -58398,
 467668170,
 917886,
 -58397,
 467733555,
 917885,
 -58396,
 467798947,
 917884,
 -1,
 467864352,
 917883,
 468065264,
 467274954,
 -1,
 -58393,
 467996298,
 917882,
 -58392,
 468061782,
 917881,
 -58391,
 468127255,
 917880,
 -58390,
 468192733,
 917879,
 -58389,
 468258160,
 917878,
 -58388,
 468323634,
 917877,
 -58387,
 468389066,
 917876,
 -58386,
 468454451,
 917875,
 -58385,
 468519843,
 917874,
 -1,
 468585248,
 917873,
 468786171,
 467995699,
 -1,
 -58382,
 468717194,
 917872,
 -58381,
 468782678,
 917871,
 -58380,
 468848151,
 917870,
 -58379,
 468913629,
 917869,
 -58378,
 468979056,
 917868,
 -58377,
 469044530,
 917867,
 -58376,
 469109962,
 917866,
 -58375,
 469175347,
 917865,
 -58374,
 469240739,
 917864,
 -1,
 469306144,
 917863,
 469507078,
 468716451,
 -1,
 -58371,
 469438090,
 917862,
 -58370,
 469503574,
 917861,
 -58369,
 469569047,
 917860,
 -58368,
 469634525,
 917859,
 -58367,
 469699952,
 917858,
 -58366,
 469765426,
 917857,
 -58365,
 469830858,
 917856,
 -58364,
 469896243,
 917855,
 -58363,
 469961635,
 917854,
 -1,
 470027040,
 917853,
 470286335,
 469437216,
 -1,
 -58360,
 470158986,
 917852,
 -58359,
 470224470,
 917851,
 -58358,
 470289943,
 917850,
 -58357,
 470355421,
 917849,
 -58356,
 470420848,
 917848,
 -58355,
 470486322,
 917847,
 -58354,
 470551754,
 917846,
 -58353,
 470617139,
 917845,
 -58352,
 470682531,
 917844,
 -1,
 470747936,
 917843,
 470948949,
 463604787,
 -1,
 471014429,
 470879538,
 917767,
 -58348,
 470945418,
 917992,
 -58347,
 471010902,
 917991,
 -58346,
 471076375,
 917990,
 -58345,
 471141853,
 917989,
 -58344,
 471207280,
 917988,
 -58343,
 471272754,
 917987,
 -58342,
 471338186,
 917986,
 -58341,
 471403571,
 917985,
 -58340,
 471468963,
 917984,
 -1,
 471534368,
 917983,
 471735336,
 470944970,
 917766,
 -58337,
 471666314,
 917982,
 -58336,
 471731798,
 917981,
 -58335,
 471797271,
 917980,
 -58334,
 471862749,
 917979,
 -58333,
 471928176,
 917978,
 -58332,
 471993650,
 917977,
 -58331,
 472059082,
 917976,
 -58330,
 472124467,
 917975,
 -58329,
 472189859,
 917974,
 -1,
 472255264,
 917973,
 472456243,
 471665715,
 917765,
 -58326,
 472387210,
 917972,
 -58325,
 472452694,
 917971,
 -58324,
 472518167,
 917970,
 -58323,
 472583645,
 917969,
 -58322,
 472649072,
 917968,
 -58321,
 472714546,
 917967,
 -58320,
 472779978,
 917966,
 -58319,
 472845363,
 917965,
 -58318,
 472910755,
 917964,
 -1,
 472976160,
 917963,
 473177150,
 472386467,
 917764,
 -58315,
 473108106,
 917962,
 -58314,
 473173590,
 917961,
 -58313,
 473239063,
 917960,
 -58312,
 473304541,
 917959,
 -58311,
 473369968,
 917958,
 -58310,
 473435442,
 917957,
 -58309,
 473500874,
 917956,
 -58308,
 473566259,
 917955,
 -58307,
 473631651,
 917954,
 -1,
 473697056,
 917953,
 473898057,
 473107232,
 917763,
 -58304,
 473829002,
 917952,
 -58303,
 473894486,
 917951,
 -58302,
 473959959,
 917950,
 -58301,
 474025437,
 917949,
 -58300,
 474090864,
 917948,
 -58299,
 474156338,
 917947,
 -58298,
 474221770,
 917946,
 -58297,
 474287155,
 917945,
 -58296,
 474352547,
 917944,
 -1,
 474417952,
 917943,
 474618961,
 473828720,
 917768,
 -58293,
 474549725,
 917999,
 -58292,
 474615152,
 917998,
 -58291,
 474680626,
 917997,
 -58290,
 474746058,
 917996,
 -58289,
 474811443,
 917995,
 -58288,
 474876835,
 917994,
 -1,
 474942240,
 917993,
 -58286,
 474549898,
 917772,
 -58285,
 475074134,
 917771,
 -58284,
 475139607,
 917770,
 -1,
 475205085,
 917769,
 475405408,
 470879882,
 -1,
 -58281,
 475336330,
 917842,
 -58280,
 475401814,
 917841,
 -58279,
 475467287,
 917840,
 -58278,
 475532765,
 917839,
 -58277,
 475598192,
 917838,
 -58276,
 475663666,
 917837,
 -58275,
 475729098,
 917836,
 -58274,
 475794483,
 917835,
 -58273,
 475859875,
 917834,
 -1,
 475925280,
 917833,
 476126315,
 475336278,
 -1,
 -58270,
 476057226,
 917832,
 -58269,
 476122710,
 917831,
 -58268,
 476188183,
 917830,
 -58267,
 476253661,
 917829,
 -58266,
 476319088,
 917828,
 -58265,
 476384562,
 917827,
 -58264,
 476449994,
 917826,
 -58263,
 476515379,
 917825,
 -58262,
 476580771,
 917824,
 -1,
 476646176,
 917823,
 476847222,
 476057111,
 -1,
 -58259,
 476778122,
 917822,
 -58258,
 476843606,
 917821,
 -58257,
 476909079,
 917820,
 -58256,
 476974557,
 917819,
 -58255,
 477039984,
 917818,
 -58254,
 477105458,
 917817,
 -58253,
 477170890,
 917816,
 -58252,
 477236275,
 917815,
 -58251,
 477301667,
 917814,
 -1,
 477367072,
 917813,
 477568129,
 476777949,
 -1,
 -58248,
 477499018,
 917812,
 -58247,
 477564502,
 917811,
 -58246,
 477629975,
 917810,
 -58245,
 477695453,
 917809,
 -58244,
 477760880,
 917808,
 -58243,
 477826354,
 917807,
 -58242,
 477891786,
 917806,
 -58241,
 477957171,
 917805,
 -58240,
 478022563,
 917804,
 -1,
 478087968,
 917803,
 478289036,
 477498736,
 -1,
 -58237,
 478219914,
 917802,
 -58236,
 478285398,
 917801,
 -58235,
 478350871,
 917800,
 -58234,
 478416349,
 917799,
 -58233,
 478481776,
 917798,
 -58232,
 478547250,
 917797,
 -58231,
 478612682,
 917796,
 -58230,
 478678067,
 917795,
 -58229,
 478743459,
 917794,
 -1,
 478808864,
 917793,
 479009943,
 478219570,
 -1,
 -58226,
 478940810,
 917792,
 -58225,
 479006294,
 917791,
 -58224,
 479071767,
 917790,
 -58223,
 479137245,
 917789,
 -58222,
 479202672,
 917788,
 -58221,
 479268146,
 917787,
 -58220,
 479333578,
 917786,
 -58219,
 479398963,
 917785,
 -58218,
 479464355,
 917784,
 -1,
 479529760,
 917783,
 479789055,
 478940362,
 -1,
 -58215,
 479661706,
 917782,
 -58214,
 479727190,
 917781,
 -58213,
 479792663,
 917780,
 -58212,
 479858141,
 917779,
 -58211,
 479923568,
 917778,
 -58210,
 479989042,
 917777,
 -58209,
 480054474,
 917776,
 -58208,
 480119859,
 917775,
 -58207,
 480185251,
 917774,
 -1,
 480250656,
 917773,
 480452003,
 440759686,
 -1,
 480517394,
 480381859,
 983229,
 480582831,
 480448138,
 983251,
 -58202,
 480513674,
 983431,
 -58201,
 480579158,
 983430,
 -58200,
 480644631,
 983429,
 -58199,
 480710109,
 983428,
 -58198,
 480775536,
 983427,
 -58197,
 480841010,
 983426,
 -58196,
 480906442,
 983425,
 -58195,
 480971827,
 983424,
 -58194,
 481037219,
 983423,
 -1,
 481102624,
 983422,
 481303738,
 480513622,
 983250,
 -58191,
 481234570,
 983421,
 -58190,
 481300054,
 983420,
 -58189,
 481365527,
 983419,
 -58188,
 481431005,
 983418,
 -58187,
 481496432,
 983417,
 -58186,
 481561906,
 983416,
 -58185,
 481627338,
 983415,
 -58184,
 481692723,
 983414,
 -58183,
 481758115,
 983413,
 -1,
 481823520,
 983412,
 482024645,
 481234455,
 983249,
 -58180,
 481955466,
 983411,
 -58179,
 482020950,
 983410,
 -58178,
 482086423,
 983409,
 -58177,
 482151901,
 983408,
 -58176,
 482217328,
 983407,
 -58175,
 482282802,
 983406,
 -58174,
 482348234,
 983405,
 -58173,
 482413619,
 983404,
 -58172,
 482479011,
 983403,
 -1,
 482544416,
 983402,
 482745552,
 481955293,
 983244,
 -58169,
 482676362,
 983401,
 -58168,
 482741846,
 983400,
 -58167,
 482807319,
 983399,
 -58166,
 482872797,
 983398,
 -58165,
 482938224,
 983397,
 -58164,
 483003698,
 983396,
 -58163,
 483069130,
 983395,
 -58162,
 483134515,
 983394,
 -58161,
 483199907,
 983393,
 -1,
 483265312,
 983392,
 483466459,
 482676080,
 983243,
 -58158,
 483397258,
 983391,
 -58157,
 483462742,
 983390,
 -58156,
 483528215,
 983389,
 -58155,
 483593693,
 983388,
 -58154,
 483659120,
 983387,
 -58153,
 483724594,
 983386,
 -58152,
 483790026,
 983385,
 -58151,
 483855411,
 983384,
 -58150,
 483920803,
 983383,
 -1,
 483986208,
 983382,
 484187366,
 483396914,
 983242,
 -58147,
 484118154,
 983381,
 -58146,
 484183638,
 983380,
 -58145,
 484249111,
 983379,
 -58144,
 484314589,
 983378,
 -58143,
 484380016,
 983377,
 -58142,
 484445490,
 983376,
 -58141,
 484510922,
 983375,
 -58140,
 484576307,
 983374,
 -58139,
 484641699,
 983373,
 -1,
 484707104,
 983372,
 484908273,
 484117706,
 983241,
 -58136,
 484839050,
 983371,
 -58135,
 484904534,
 983370,
 -58134,
 484970007,
 983369,
 -58133,
 485035485,
 983368,
 -58132,
 485100912,
 983367,
 -58131,
 485166386,
 983366,
 -58130,
 485231818,
 983365,
 -58129,
 485297203,
 983364,
 -58128,
 485362595,
 983363,
 -1,
 485428000,
 983362,
 485629180,
 484838451,
 983240,
 -58125,
 485559946,
 983361,
 -58124,
 485625430,
 983360,
 -58123,
 485690903,
 983359,
 -58122,
 485756381,
 983358,
 -58121,
 485821808,
 983357,
 -58120,
 485887282,
 983356,
 -58119,
 485952714,
 983355,
 -58118,
 486018099,
 983354,
 -58117,
 486083491,
 983353,
 -1,
 486148896,
 983352,
 486350087,
 485559203,
 983239,
 -58114,
 486280842,
 983351,
 -58113,
 486346326,
 983350,
 -58112,
 486411799,
 983349,
 -58111,
 486477277,
 983348,
 -58110,
 486542704,
 983347,
 -58109,
 486608178,
 983346,
 -58108,
 486673610,
 983345,
 -58107,
 486738995,
 983344,
 -58106,
 486804387,
 983343,
 -1,
 486869792,
 983342,
 487129087,
 486279968,
 983238,
 -58103,
 487001738,
 983341,
 -58102,
 487067222,
 983340,
 -58101,
 487132695,
 983339,
 -58100,
 487198173,
 983338,
 -58099,
 487263600,
 983337,
 -58098,
 487329074,
 983336,
 -58097,
 487394506,
 983335,
 -58096,
 487459891,
 983334,
 -58095,
 487525283,
 983333,
 -1,
 487590688,
 983332,
 487791958,
 480447539,
 983230,
 487857438,
 487722290,
 983256,
 -58091,
 487788170,
 983481,
 -58090,
 487853654,
 983480,
 -58089,
 487919127,
 983479,
 -58088,
 487984605,
 983478,
 -58087,
 488050032,
 983477,
 -58086,
 488115506,
 983476,
 -58085,
 488180938,
 983475,
 -58084,
 488246323,
 983474,
 -58083,
 488311715,
 983473,
 -1,
 488377120,
 983472,
 488578345,
 487787722,
 983255,
 -58080,
 488509066,
 983471,
 -58079,
 488574550,
 983470,
 -58078,
 488640023,
 983469,
 -58077,
 488705501,
 983468,
 -58076,
 488770928,
 983467,
 -58075,
 488836402,
 983466,
 -58074,
 488901834,
 983465,
 -58073,
 488967219,
 983464,
 -58072,
 489032611,
 983463,
 -1,
 489098016,
 983462,
 489299252,
 488508467,
 983254,
 -58069,
 489229962,
 983461,
 -58068,
 489295446,
 983460,
 -58067,
 489360919,
 983459,
 -58066,
 489426397,
 983458,
 -58065,
 489491824,
 983457,
 -58064,
 489557298,
 983456,
 -58063,
 489622730,
 983455,
 -58062,
 489688115,
 983454,
 -58061,
 489753507,
 983453,
 -1,
 489818912,
 983452,
 490020159,
 489229219,
 983253,
 -58058,
 489950858,
 983451,
 -58057,
 490016342,
 983450,
 -58056,
 490081815,
 983449,
 -58055,
 490147293,
 983448,
 -58054,
 490212720,
 983447,
 -58053,
 490278194,
 983446,
 -58052,
 490343626,
 983445,
 -58051,
 490409011,
 983444,
 -58050,
 490474403,
 983443,
 -1,
 490539808,
 983442,
 490741066,
 489949984,
 983252,
 -58047,
 490671754,
 983441,
 -58046,
 490737238,
 983440,
 -58045,
 490802711,
 983439,
 -58044,
 490868189,
 983438,
 -58043,
 490933616,
 983437,
 -58042,
 490999090,
 983436,
 -58041,
 491064522,
 983435,
 -58040,
 491129907,
 983434,
 -58039,
 491195299,
 983433,
 -1,
 491260704,
 983432,
 491461970,
 490671472,
 983257,
 -58036,
 491392477,
 983488,
 -58035,
 491457904,
 983487,
 -58034,
 491523378,
 983486,
 -58033,
 491588810,
 983485,
 -58032,
 491654195,
 983484,
 -58031,
 491719587,
 983483,
 -1,
 491784992,
 983482,
 -58029,
 491392650,
 983261,
 -58028,
 491916886,
 983260,
 -58027,
 491982359,
 983259,
 -1,
 492047837,
 983258,
 492248417,
 487722634,
 983237,
 -58024,
 492179082,
 983331,
 -58023,
 492244566,
 983330,
 -58022,
 492310039,
 983329,
 -58021,
 492375517,
 983328,
 -58020,
 492440944,
 983327,
 -58019,
 492506418,
 983326,
 -58018,
 492571850,
 983325,
 -58017,
 492637235,
 983324,
 -58016,
 492702627,
 983323,
 -1,
 492768032,
 983322,
 492969324,
 492179030,
 983236,
 -58013,
 492899978,
 983321,
 -58012,
 492965462,
 983320,
 -58011,
 493030935,
 983319,
 -58010,
 493096413,
 983318,
 -58009,
 493161840,
 983317,
 -58008,
 493227314,
 983316,
 -58007,
 493292746,
 983315,
 -58006,
 493358131,
 983314,
 -58005,
 493423523,
 983313,
 -1,
 493488928,
 983312,
 493690231,
 492899863,
 983235,
 -58002,
 493620874,
 983311,
 -58001,
 493686358,
 983310,
 -58000,
 493751831,
 983309,
 -57999,
 493817309,
 983308,
 -57998,
 493882736,
 983307,
 -57997,
 493948210,
 983306,
 -57996,
 494013642,
 983305,
 -57995,
 494079027,
 983304,
 -57994,
 494144419,
 983303,
 -1,
 494209824,
 983302,
 494411138,
 493620701,
 983234,
 -57991,
 494341770,
 983301,
 -57990,
 494407254,
 983300,
 -57989,
 494472727,
 983299,
 -57988,
 494538205,
 983298,
 -57987,
 494603632,
 983297,
 -57986,
 494669106,
 983296,
 -57985,
 494734538,
 983295,
 -57984,
 494799923,
 983294,
 -57983,
 494865315,
 983293,
 -1,
 494930720,
 983292,
 495132045,
 494341488,
 983233,
 -57980,
 495062666,
 983291,
 -57979,
 495128150,
 983290,
 -57978,
 495193623,
 983289,
 -57977,
 495259101,
 983288,
 -57976,
 495324528,
 983287,
 -57975,
 495390002,
 983286,
 -57974,
 495455434,
 983285,
 -57973,
 495520819,
 983284,
 -57972,
 495586211,
 983283,
 -1,
 495651616,
 983282,
 495852952,
 495062322,
 983232,
 -57969,
 495783562,
 983281,
 -57968,
 495849046,
 983280,
 -57967,
 495914519,
 983279,
 -57966,
 495979997,
 983278,
 -57965,
 496045424,
 983277,
 -57964,
 496110898,
 983276,
 -57963,
 496176330,
 983275,
 -57962,
 496241715,
 983274,
 -57961,
 496307107,
 983273,
 -1,
 496372512,
 983272,
 496631807,
 495783114,
 983231,
 -57958,
 496504458,
 983271,
 -57957,
 496569942,
 983270,
 -57956,
 496635415,
 983269,
 -57955,
 496700893,
 983268,
 -57954,
 496766320,
 983267,
 -57953,
 496831794,
 983266,
 -57952,
 496897226,
 983265,
 -57951,
 496962611,
 983264,
 -57950,
 497028003,
 983263,
 -1,
 497093408,
 983262,
 497294819,
 480389250,
 -1,
 497360344,
 497231075,
 -1,
 497425857,
 497318025,
 -1,
 497491374,
 497356481,
 -1,
 497556909,
 497441899,
 -1,
 497622442,
 497519573,
 7403,
 -1,
 497551791,
 7404,
 -57941,
 497583838,
 7409,
 -57940,
 497686612,
 7402,
 -1,
 497751096,
 7401,
 -1,
 497512307,
 7410,
 498015668,
 497454593,
 -1,
 498081201,
 497977283,
 7395,
 -1,
 498010543,
 7399,
 498212275,
 498013274,
 7397,
 -1,
 498141615,
 7400,
 -1,
 498171273,
 7394,
 498408890,
 497970530,
 -1,
 498474424,
 498348070,
 -1,
 -57929,
 498436035,
 7396,
 -1,
 498472026,
 7398,
 -57927,
 498434270,
 7408,
 -1,
 498623388,
 7411,
 -57925,
 498373780,
 7380,
 -57924,
 498764352,
 7414,
 -57923,
 498827952,
 7405,
 -57922,
 498883209,
 7379,
 -57921,
 498946199,
 7407,
 -57920,
 499009484,
 7413,
 -1,
 499071692,
 7406,
 499318783,
 497386219,
 -1,
 499326407,
 499225736,
 -1,
 499391941,
 499272019,
 7383,
 -1,
 499320370,
 7385,
 -57914,
 499335693,
 7382,
 -1,
 499454271,
 7381,
 499654091,
 499285525,
 -1,
 -57911,
 499618462,
 7390,
 -57910,
 499675996,
 7387,
 -1,
 499727777,
 7391,
 499916238,
 499599503,
 -1,
 -57907,
 499876029,
 7388,
 -1,
 499938486,
 7376,
 500112849,
 499852683,
 -1,
 -57904,
 500074312,
 7386,
 -1,
 500137517,
 7389,
 500309460,
 500046915,
 -1,
 -57901,
 500242761,
 7384,
 -1,
 500305840,
 7412,
 -57899,
 500266942,
 7377,
 -57898,
 500462248,
 7392,
 -57897,
 500525854,
 7378,
 -1,
 500569779,
 7393,
 500768226,
 497317093,
 -1,
 500833758,
 500727317,
 -1,
 500899292,
 500764620,
 983069,
 -1,
 500827709,
 983143,
 -57891,
 500854275,
 128678,
 -1,
 500973932,
 11823,
 -57889,
 500781849,
 9896,
 -57888,
 501108550,
 9168,
 -57887,
 501167126,
 8286,
 -1,
 501225623,
 10186,
 -1,
 500726813,
 9910,
 501489131,
 497237606,
 -1,
 501554665,
 501425194,
 -1,
 501620200,
 501481472,
 -1,
 -57881,
 501560661,
 127918,
 -1,
 501619745,
 128249,
 -1,
 501554396,
 128252,
 -57878,
 501505816,
 127931,
 -1,
 501816093,
 128243,
 502013425,
 501450833,
 -1,
 502078960,
 501964794,
 -1,
 -57874,
 502038596,
 8530,
 -57873,
 502101781,
 8528,
 -1,
 502160054,
 8529,
 -1,
 502044382,
 8585,
 502406643,
 501972501,
 983070,
 -1,
 502363526,
 983144,
 -1,
 502357708,
 127755,
 502604354,
 440696341,
 -1,
 502669542,
 502533825,
 -1,
 502734679,
 502617677,
 -1,
 502800177,
 502693295,
 -1,
 502865465,
 502749285,
 -1,
 502930963,
 502814821,
 -1,
 502996487,
 502880357,
 -1,
 503062015,
 502927041,
 -1,
 -57859,
 503023143,
 983843,
 -57858,
 503070310,
 983840,
 -1,
 503123649,
 983833,
 503324161,
 503023143,
 983836,
 -1,
 503285287,
 983837,
 503455235,
 503274719,
 983841,
 -1,
 503405791,
 983842,
 503586309,
 503397990,
 983834,
 -1,
 503529062,
 983835,
 503775231,
 503523458,
 983838,
 -1,
 503654530,
 983839,
 503848459,
 502927041,
 -1,
 -57847,
 503809575,
 983711,
 -57846,
 503856742,
 983708,
 -1,
 503910081,
 983701,
 504110605,
 503809575,
 983704,
 -1,
 504071719,
 983705,
 504241679,
 504061151,
 983709,
 -1,
 504192223,
 983710,
 504372753,
 504184422,
 983702,
 -1,
 504315494,
 983703,
 504561663,
 504309890,
 983706,
 -1,
 504440962,
 983707,
 504634912,
 502895663,
 -1,
 504700440,
 504565441,
 -1,
 -57834,
 504661543,
 983689,
 -57833,
 504708710,
 983686,
 -1,
 504762049,
 983679,
 504962586,
 504661543,
 983682,
 -1,
 504923687,
 983683,
 505093660,
 504913119,
 983687,
 -1,
 505044191,
 983688,
 505224734,
 505036390,
 983680,
 -1,
 505167462,
 983681,
 505413631,
 505161858,
 983684,
 -1,
 505292930,
 983685,
 505486893,
 504575185,
 -1,
 505552421,
 505417409,
 -1,
 -57821,
 505513511,
 983667,
 -57820,
 505560678,
 983664,
 -1,
 505614017,
 983657,
 505814567,
 505513511,
 983660,
 -1,
 505775655,
 983661,
 505945641,
 505765087,
 983665,
 -1,
 505896159,
 983666,
 506076715,
 505888358,
 983658,
 -1,
 506019430,
 983659,
 506265599,
 506013826,
 983662,
 -1,
 506144898,
 983663,
 506338865,
 505417409,
 -1,
 -57809,
 506299943,
 983733,
 -57808,
 506347110,
 983730,
 -1,
 506400449,
 983723,
 506601011,
 506299943,
 983726,
 -1,
 506562087,
 983727,
 506732085,
 506551519,
 983731,
 -1,
 506682591,
 983732,
 506863159,
 506674790,
 983724,
 -1,
 506805862,
 983725,
 507052031,
 506800258,
 983728,
 -1,
 506931330,
 983729,
 507125345,
 502822278,
 -1,
 507190856,
 507066530,
 -1,
 507256383,
 507121345,
 -1,
 -57795,
 507217447,
 983865,
 -57794,
 507264614,
 983862,
 -1,
 507317953,
 983855,
 507518529,
 507217447,
 983858,
 -1,
 507479591,
 983859,
 507649603,
 507469023,
 983863,
 -1,
 507600095,
 983864,
 507780677,
 507592294,
 983856,
 -1,
 507723366,
 983857,
 507911751,
 507717762,
 983860,
 -1,
 507848834,
 983861,
 -1,
 507867854,
 983911,
 508108373,
 507147654,
 -1,
 508173901,
 508038849,
 -1,
 -57781,
 508134951,
 983876,
 -57780,
 508182118,
 983873,
 -1,
 508235457,
 983866,
 508436047,
 508134951,
 983869,
 -1,
 508397095,
 983870,
 508567121,
 508386527,
 983874,
 -1,
 508517599,
 983875,
 508698195,
 508509798,
 983867,
 -1,
 508640870,
 983868,
 508887039,
 508635266,
 983871,
 -1,
 508766338,
 983872,
 508960345,
 508038849,
 -1,
 -57769,
 508921383,
 983887,
 -57768,
 508968550,
 983884,
 -1,
 509021889,
 983877,
 509222491,
 508921383,
 983880,
 -1,
 509183527,
 983881,
 509353565,
 509172959,
 983885,
 -1,
 509304031,
 983886,
 509484639,
 509296230,
 983878,
 -1,
 509427302,
 983879,
 509673471,
 509421698,
 983882,
 -1,
 509552770,
 983883,
 509746824,
 507071298,
 -1,
 509812348,
 509692738,
 -1,
 509877872,
 509758274,
 -1,
 509943400,
 509808321,
 -1,
 -57754,
 509904423,
 983810,
 -57753,
 509951590,
 983807,
 -1,
 510004929,
 983800,
 510205546,
 509904423,
 983803,
 -1,
 510166567,
 983804,
 510336620,
 510155999,
 983808,
 -1,
 510287071,
 983809,
 510467694,
 510279270,
 983801,
 -1,
 510410342,
 983802,
 510656511,
 510404738,
 983805,
 -1,
 510535810,
 983806,
 510729844,
 509808321,
 -1,
 -57742,
 510690855,
 983821,
 -57741,
 510738022,
 983818,
 -1,
 510791361,
 983811,
 510991990,
 510690855,
 983814,
 -1,
 510952999,
 983815,
 511123064,
 510942431,
 983819,
 -1,
 511073503,
 983820,
 511254138,
 511065702,
 983812,
 -1,
 511196774,
 983813,
 511442943,
 511191170,
 983816,
 -1,
 511322242,
 983817,
 511516288,
 509742785,
 -1,
 -57730,
 511477287,
 983788,
 -57729,
 511524454,
 983785,
 -1,
 511577793,
 983778,
 511778434,
 511477287,
 983781,
 -1,
 511739431,
 983782,
 511909508,
 511728863,
 983786,
 -1,
 511859935,
 983787,
 512040582,
 511852134,
 983779,
 -1,
 511983206,
 983780,
 512229375,
 511977602,
 983783,
 -1,
 512108674,
 983784,
 512302754,
 509691965,
 -1,
 512368278,
 512261032,
 -1,
 512433806,
 512298689,
 983899,
 -57716,
 512394791,
 983910,
 -57715,
 512441958,
 983907,
 -1,
 512495297,
 983900,
 512695952,
 512394791,
 983903,
 -1,
 512656935,
 983904,
 512827026,
 512646367,
 983908,
 -1,
 512777439,
 983909,
 512958100,
 512769638,
 983901,
 -1,
 512900710,
 983902,
 513146879,
 512895106,
 983905,
 -1,
 513026178,
 983906,
 513220250,
 512298689,
 -1,
 -57704,
 513181223,
 983656,
 -57703,
 513228390,
 983653,
 -1,
 513281729,
 983646,
 513482396,
 513181223,
 983649,
 -1,
 513443367,
 983650,
 513613470,
 513432799,
 983654,
 -1,
 513563871,
 983655,
 513744544,
 513556070,
 983647,
 -1,
 513687142,
 983648,
 513933311,
 513681538,
 983651,
 -1,
 513812610,
 983652,
 514006716,
 512261653,
 -1,
 514072240,
 513965589,
 -1,
 514137768,
 514002625,
 -1,
 -57690,
 514098727,
 983700,
 -57689,
 514145894,
 983697,
 -1,
 514199233,
 983690,
 514399914,
 514098727,
 983693,
 -1,
 514360871,
 983694,
 514530988,
 514350303,
 983698,
 -1,
 514481375,
 983699,
 514662062,
 514473574,
 983691,
 -1,
 514604646,
 983692,
 514850815,
 514599042,
 983695,
 -1,
 514730114,
 983696,
 514924212,
 514002625,
 -1,
 -57678,
 514885159,
 983722,
 -57677,
 514932326,
 983719,
 -1,
 514985665,
 983712,
 515186358,
 514885159,
 983715,
 -1,
 515147303,
 983716,
 515317432,
 515136735,
 983720,
 -1,
 515267807,
 983721,
 515448506,
 515260006,
 983713,
 -1,
 515391078,
 983714,
 515637247,
 515385474,
 983717,
 -1,
 515516546,
 983718,
 515710678,
 513961314,
 -1,
 515776202,
 515665250,
 -1,
 515841730,
 515706561,
 -1,
 -57664,
 515802663,
 983832,
 -57663,
 515849830,
 983829,
 -1,
 515903169,
 983822,
 516103876,
 515802663,
 983825,
 -1,
 516064807,
 983826,
 516234950,
 516054239,
 983830,
 -1,
 516185311,
 983831,
 516366024,
 516177510,
 983823,
 -1,
 516308582,
 983824,
 516554751,
 516302978,
 983827,
 -1,
 516434050,
 983828,
 516628174,
 515706561,
 -1,
 -57652,
 516589095,
 983777,
 -57651,
 516636262,
 983774,
 -1,
 516689601,
 983767,
 516890320,
 516589095,
 983770,
 -1,
 516851239,
 983771,
 517021394,
 516840671,
 983775,
 -1,
 516971743,
 983776,
 517152468,
 516963942,
 983768,
 -1,
 517095014,
 983769,
 517341183,
 517089410,
 983772,
 -1,
 517220482,
 983773,
 517414627,
 515675183,
 -1,
 517480155,
 517344961,
 -1,
 -57639,
 517441063,
 983766,
 -57638,
 517488230,
 983763,
 -1,
 517541569,
 983756,
 517742301,
 517441063,
 983759,
 -1,
 517703207,
 983760,
 517873375,
 517692639,
 983764,
 -1,
 517823711,
 983765,
 518004449,
 517815910,
 983757,
 -1,
 517946982,
 983758,
 518193151,
 517941378,
 983761,
 -1,
 518072450,
 983762,
 518266608,
 517376944,
 -1,
 518332136,
 518196929,
 -1,
 -57626,
 518293031,
 983799,
 -57625,
 518340198,
 983796,
 -1,
 518393537,
 983789,
 518594282,
 518293031,
 983792,
 -1,
 518555175,
 983793,
 518725356,
 518544607,
 983797,
 -1,
 518675679,
 983798,
 518856430,
 518667878,
 983790,
 -1,
 518798950,
 983791,
 519045119,
 518793346,
 983794,
 -1,
 518924418,
 983795,
 519118589,
 518219515,
 -1,
 519184117,
 519048897,
 -1,
 -57613,
 519144999,
 983744,
 -57612,
 519192166,
 983741,
 -1,
 519245505,
 983734,
 519446263,
 519144999,
 983737,
 -1,
 519407143,
 983738,
 519577337,
 519396575,
 983742,
 -1,
 519527647,
 983743,
 519708411,
 519519846,
 983735,
 -1,
 519650918,
 983736,
 519897087,
 519645314,
 983739,
 -1,
 519776386,
 983740,
 519970570,
 519066140,
 -1,
 520036098,
 519900865,
 -1,
 -57600,
 519996967,
 983755,
 -57599,
 520044134,
 983752,
 -1,
 520097473,
 983745,
 520298244,
 519996967,
 983748,
 -1,
 520259111,
 983749,
 520429318,
 520248543,
 983753,
 -1,
 520379615,
 983754,
 520560392,
 520371814,
 983746,
 -1,
 520502886,
 983747,
 520749055,
 520497282,
 983750,
 -1,
 520628354,
 983751,
 520822551,
 519915319,
 -1,
 520888079,
 520752833,
 -1,
 -57587,
 520848935,
 983854,
 -57586,
 520896102,
 983851,
 -1,
 520949441,
 983844,
 521150225,
 520848935,
 983847,
 -1,
 521111079,
 983848,
 521281299,
 521100511,
 983852,
 -1,
 521231583,
 983853,
 521412373,
 521223782,
 983845,
 -1,
 521354854,
 983846,
 521601023,
 521349250,
 983849,
 -1,
 521480322,
 983850,
 521674532,
 520763554,
 -1,
 521740060,
 521604801,
 -1,
 -57574,
 521700903,
 983898,
 -57573,
 521748070,
 983895,
 -1,
 521801409,
 983888,
 522002206,
 521700903,
 983891,
 -1,
 521963047,
 983892,
 522133280,
 521952479,
 983896,
 -1,
 522083551,
 983897,
 522264354,
 522075750,
 983889,
 -1,
 522206822,
 983890,
 522452991,
 522201218,
 983893,
 -1,
 522332290,
 983894,
 522584063,
 521608141,
 -1,
 522592041,
 522456769,
 -1,
 -57561,
 522552871,
 983678,
 -57560,
 522600038,
 983675,
 -1,
 522653377,
 983668,
 522854187,
 522552871,
 983671,
 -1,
 522815015,
 983672,
 522985261,
 522804447,
 983676,
 -1,
 522935519,
 983677,
 523116335,
 522927718,
 983669,
 -1,
 523058790,
 983670,
 523304959,
 523053186,
 983673,
 -1,
 523184258,
 983674,
 523378508,
 502733773,
 -1,
 523444043,
 523329753,
 -1,
 523509560,
 523393125,
 983629,
 523575094,
 523458661,
 983627,
 -1,
 523524197,
 983639,
 -57545,
 523539503,
 983625,
 -1,
 523646161,
 983623,
 523837243,
 523466118,
 983643,
 -57542,
 523793798,
 983642,
 -1,
 523843746,
 983641,
 524033854,
 523782978,
 983634,
 524156927,
 523979586,
 983637,
 -1,
 524045122,
 983636,
 524230464,
 523992597,
 983628,
 -1,
 524189205,
 983626,
 524361538,
 524184930,
 983633,
 -1,
 524316002,
 983638,
 524492612,
 524306493,
 983622,
 -1,
 524450728,
 983645,
 -57531,
 524457007,
 983632,
 -57530,
 524585904,
 983635,
 -57529,
 524642043,
 983630,
 -57528,
 524702236,
 983631,
 -57527,
 524764983,
 983640,
 -57526,
 524826786,
 983644,
 -1,
 524884941,
 983624,
 -1,
 523399199,
 3063,
 525147984,
 523313877,
 -1,
 -57522,
 525091098,
 3046,
 -57521,
 525150742,
 3062,
 -1,
 525211596,
 3059,
 -57519,
 525112536,
 3061,
 -57518,
 525366610,
 3065,
 -57517,
 525426506,
 3024,
 -57516,
 525491247,
 3066,
 -57515,
 525555576,
 3060,
 -57514,
 525618791,
 2998,
 -1,
 525669881,
 3064,
 525869192,
 502677096,
 -1,
 525934592,
 525828300,
 -1,
 526000029,
 525880905,
 -1,
 526065522,
 525945666,
 -1,
 526131054,
 526018154,
 -1,
 526196576,
 526075965,
 -1,
 -57506,
 526160838,
 6692,
 -57505,
 526203064,
 6693,
 -1,
 526257857,
 6691,
 526458723,
 526155285,
 -1,
 -57502,
 526399672,
 6709,
 -1,
 526454465,
 6708,
 526655334,
 526411515,
 -1,
 -57499,
 526596280,
 6717,
 -1,
 526651073,
 6715,
 526851945,
 526588877,
 -1,
 -57496,
 526792888,
 6699,
 -1,
 526847681,
 6697,
 -57494,
 526816369,
 6719,
 -57493,
 527005146,
 6698,
 -57492,
 527068916,
 6704,
 -57491,
 527120568,
 6732,
 -1,
 527184315,
 6716,
 527376240,
 526061249,
 6723,
 -1,
 527313026,
 6739,
 -57487,
 527337435,
 6724,
 -1,
 527453040,
 6730,
 527638408,
 526007116,
 -1,
 527703927,
 527594886,
 -1,
 -57483,
 527660506,
 6727,
 -57482,
 527710392,
 6726,
 -1,
 527765185,
 6728,
 527966075,
 527648829,
 -1,
 -57479,
 527930310,
 6690,
 -57478,
 527972536,
 6689,
 -1,
 528027329,
 6688,
 528228222,
 527924757,
 -1,
 -57475,
 528169144,
 6707,
 -1,
 528223937,
 6706,
 528424833,
 528180987,
 -1,
 -57472,
 528365752,
 6713,
 -1,
 528420545,
 6712,
 528621444,
 528358349,
 -1,
 -57469,
 528562360,
 6696,
 -1,
 528617153,
 6695,
 -57467,
 528585841,
 6720,
 -57466,
 528772852,
 6702,
 -57465,
 528824504,
 6729,
 -1,
 528888251,
 6714,
 529080205,
 527592802,
 -1,
 529145740,
 529010369,
 6721,
 -57461,
 529104523,
 6701,
 -1,
 529160379,
 6705,
 -1,
 529106907,
 6722,
 529407889,
 529029221,
 -1,
 -57457,
 529372273,
 6700,
 -57456,
 529413379,
 6694,
 -1,
 529469121,
 6710,
 529670035,
 529368615,
 6735,
 -1,
 529630759,
 6736,
 529801109,
 529612390,
 6733,
 -1,
 529743462,
 6734,
 -57450,
 529764239,
 6725,
 -57449,
 529883376,
 6738,
 -57448,
 529945205,
 6718,
 -57447,
 530003991,
 6740,
 -57446,
 530066043,
 6737,
 -57445,
 530129714,
 6703,
 -57444,
 530192433,
 6711,
 -1,
 530255553,
 6731,
 530456511,
 525957257,
 -1,
 530522024,
 530401341,
 -1,
 530587557,
 530464278,
 -1,
 530653092,
 530515837,
 -1,
 -57438,
 530582896,
 6777,
 -57437,
 530648370,
 6776,
 -1,
 530713802,
 6775,
 -1,
 530582106,
 6780,
 530980775,
 530517835,
 6824,
 -1,
 530926364,
 6825,
 -1,
 530918688,
 6819,
 531177389,
 530478554,
 -1,
 531242923,
 531137207,
 6826,
 -1,
 531188508,
 6827,
 -57428,
 531206057,
 6818,
 -1,
 531319516,
 6752,
 531505074,
 531124948,
 -1,
 531570608,
 531450100,
 6772,
 -1,
 531497660,
 6744,
 -57423,
 531535030,
 6823,
 -1,
 531658267,
 6779,
 531832756,
 531468577,
 6816,
 -1,
 531795862,
 6817,
 531963831,
 531792666,
 -1,
 -57418,
 531893299,
 6774,
 -1,
 531958691,
 6773,
 532160442,
 531918178,
 -1,
 -57415,
 532099089,
 6822,
 -1,
 532156102,
 6778,
 532357053,
 532101282,
 -1,
 -57412,
 532309748,
 6820,
 -1,
 532353991,
 6828,
 -57410,
 532293006,
 6821,
 -1,
 532487152,
 6829,
 532684757,
 530419415,
 -1,
 532750278,
 532634847,
 6763,
 532815812,
 532680387,
 -1,
 -57405,
 532748617,
 6764,
 -1,
 532811696,
 6771,
 -57403,
 532780079,
 6765,
 -1,
 532962527,
 6768,
 533143498,
 532710951,
 6761,
 533209033,
 533104167,
 6762,
 -1,
 533145730,
 6760,
 -1,
 533145730,
 6759,
 533405646,
 533073601,
 6753,
 -57396,
 533347942,
 6769,
 -57395,
 533407874,
 6767,
 -1,
 533466817,
 6755,
 533667793,
 533364245,
 -1,
 -57392,
 533608755,
 6770,
 -1,
 533664449,
 6756,
 533864403,
 533610086,
 6757,
 -1,
 533806694,
 6758,
 -57388,
 533811935,
 6754,
 -1,
 533932162,
 6766,
 534126563,
 532644050,
 -1,
 534192089,
 534085141,
 -1,
 -57384,
 534155886,
 6802,
 -1,
 534199653,
 6803,
 534388700,
 534148486,
 -1,
 -57381,
 534333152,
 6806,
 -1,
 534392711,
 6807,
 534585311,
 534327646,
 -1,
 -57378,
 534537330,
 6804,
 -1,
 534595215,
 6805,
 -57376,
 534550189,
 6800,
 -57375,
 534732790,
 6801,
 -57374,
 534796951,
 6809,
 -1,
 534850364,
 6808,
 535044081,
 534068404,
 -1,
 535109607,
 535002645,
 -1,
 -57370,
 535073390,
 6786,
 -1,
 535117157,
 6787,
 535306218,
 535065990,
 -1,
 -57367,
 535250656,
 6790,
 -1,
 535310215,
 6791,
 535502829,
 535245150,
 -1,
 -57364,
 535454834,
 6788,
 -1,
 535512719,
 6789,
 -57362,
 535467693,
 6784,
 -57361,
 535650294,
 6785,
 -57360,
 535714455,
 6793,
 -1,
 535767868,
 6792,
 536018943,
 534978572,
 -1,
 536027135,
 535911300,
 -1,
 536092664,
 535974428,
 -1,
 536158199,
 536029799,
 -1,
 -57354,
 536112576,
 6741,
 -1,
 536169328,
 6742,
 -1,
 536088257,
 6748,
 536420347,
 536038210,
 -1,
 -57350,
 536372846,
 6746,
 -1,
 536416005,
 6743,
 -57348,
 536376794,
 6750,
 -57347,
 536558418,
 6747,
 -57346,
 536621784,
 6745,
 -1,
 536680497,
 6749,
 -1,
 535975022,
 6783,
 536944734,
 525897187,
 -1,
 537010240,
 536890953,
 -1,
 537075745,
 536957204,
 -1,
 537141255,
 537024613,
 -1,
 -57339,
 537105818,
 43664,
 -57338,
 537156831,
 43672,
 -1,
 537212798,
 43656,
 537403404,
 537086013,
 -1,
 537468939,
 537344162,
 -1,
 -57334,
 537418975,
 43650,
 -1,
 537476187,
 43652,
 -1,
 537418975,
 43648,
 537731087,
 537361941,
 -1,
 -57330,
 537681119,
 43668,
 -1,
 537738331,
 43670,
 537927698,
 537683707,
 -1,
 -57327,
 537877727,
 43676,
 -1,
 537934939,
 43678,
 538124309,
 537861069,
 -1,
 -57324,
 538074335,
 43658,
 -1,
 538131547,
 43660,
 -57322,
 538088858,
 43684,
 -57321,
 538283543,
 43690,
 -57320,
 538344103,
 43662,
 -57319,
 538407917,
 43686,
 -57318,
 538467551,
 43694,
 -57317,
 538531577,
 43682,
 -57316,
 538595422,
 43688,
 -57315,
 538655835,
 43692,
 -57314,
 538720126,
 43654,
 -57313,
 538784671,
 43680,
 -57312,
 538846603,
 43666,
 -1,
 538909342,
 43674,
 539164671,
 537017164,
 -1,
 539172902,
 539056229,
 -1,
 -57308,
 539137434,
 43665,
 -57307,
 539188447,
 43673,
 -1,
 539244414,
 43657,
 539435051,
 539117629,
 -1,
 539500586,
 539375778,
 -1,
 -57303,
 539450591,
 43651,
 -1,
 539507803,
 43653,
 -1,
 539450591,
 43649,
 539762734,
 539393557,
 -1,
 -57299,
 539712735,
 43669,
 -1,
 539769947,
 43671,
 539959345,
 539715323,
 -1,
 -57296,
 539909343,
 43677,
 -1,
 539966555,
 43679,
 540155956,
 539892685,
 -1,
 -57293,
 540105951,
 43659,
 -1,
 540163163,
 43661,
 -57291,
 540120474,
 43685,
 -57290,
 540315159,
 43691,
 -57289,
 540375719,
 43663,
 -57288,
 540439533,
 43687,
 -57287,
 540499167,
 43695,
 -57286,
 540563193,
 43683,
 -57285,
 540627038,
 43689,
 -57284,
 540687451,
 43693,
 -57283,
 540751742,
 43655,
 -57282,
 540816287,
 43681,
 -57281,
 540878219,
 43667,
 -1,
 540940958,
 43675,
 541139023,
 536972974,
 -1,
 541204551,
 541068993,
 -1,
 -57277,
 541168687,
 43708,
 -57276,
 541231067,
 43707,
 -57275,
 541284453,
 43709,
 -57274,
 541348380,
 43710,
 -1,
 541396673,
 43697,
 541597771,
 541165095,
 43700,
 541663306,
 541534338,
 43699,
 -1,
 541593281,
 43705,
 -1,
 541593281,
 43706,
 541859917,
 541539942,
 43698,
 -1,
 541789889,
 43704,
 -57266,
 541809887,
 43702,
 -1,
 541927554,
 43701,
 542122070,
 541097433,
 -1,
 542187603,
 542067350,
 -1,
 -57262,
 542136421,
 43739,
 -1,
 542195307,
 43743,
 -57260,
 542144027,
 43741,
 -57259,
 542333975,
 43740,
 -1,
 542391390,
 43742,
 542580827,
 542081786,
 -1,
 -57256,
 542540111,
 43713,
 -57255,
 542603999,
 43714,
 -57254,
 542661655,
 43712,
 -1,
 542714749,
 43711,
 542965759,
 542528217,
 -1,
 -57251,
 542850042,
 43703,
 -1,
 542905287,
 43696,
 543162367,
 536890621,
 -1,
 543170667,
 543063573,
 -1,
 543236198,
 543121519,
 -1,
 -57246,
 543165917,
 6516,
 -57245,
 543231344,
 6515,
 -57244,
 543296818,
 6514,
 -57243,
 543362250,
 6513,
 -1,
 543427635,
 6512,
 543629417,
 543192454,
 -1,
 -57240,
 543570104,
 6497,
 -1,
 543624897,
 6483,
 -57238,
 543570104,
 6487,
 -1,
 543755969,
 6486,
 543957102,
 543107202,
 6507,
 -57235,
 543897762,
 6502,
 -1,
 543959170,
 6501,
 544153713,
 543887041,
 6499,
 -57232,
 544114651,
 6508,
 -1,
 544161382,
 6509,
 544350323,
 544114215,
 6503,
 -1,
 544286850,
 6506,
 544481398,
 544302843,
 -1,
 -57227,
 544422072,
 6490,
 -1,
 544476865,
 6489,
 544678008,
 544431327,
 6505,
 -1,
 544627935,
 6504,
 544809083,
 544626789,
 -1,
 -57222,
 544748803,
 6482,
 -1,
 544804545,
 6498,
 545005694,
 544753725,
 -1,
 -57219,
 544946360,
 6496,
 -1,
 545001153,
 6480,
 -57217,
 544969841,
 6485,
 -57216,
 545166278,
 6481,
 -57215,
 545229766,
 6493,
 -57214,
 545289690,
 6484,
 -57213,
 545352749,
 6495,
 -57212,
 545411701,
 6491,
 -57211,
 545475440,
 6488,
 -57210,
 545537638,
 6500,
 -57209,
 545601720,
 6494,
 -1,
 545665467,
 6492,
 545857761,
 525814521,
 -1,
 545923266,
 545803849,
 -1,
 545988752,
 545881621,
 -1,
 546054286,
 545947157,
 -1,
 -57203,
 545994936,
 71317,
 -1,
 546049729,
 71316,
 -57201,
 545994936,
 71322,
 -1,
 546180801,
 71321,
 546381973,
 545937509,
 -1,
 -57198,
 546346097,
 71315,
 -57197,
 546396347,
 71320,
 -57196,
 546452739,
 71310,
 -1,
 546508481,
 71325,
 546709659,
 546317013,
 -1,
 546775193,
 546644693,
 -1,
 -57192,
 546715832,
 71319,
 -1,
 546770625,
 71318,
 -57190,
 546715832,
 71324,
 -1,
 546901697,
 71323,
 547102879,
 546639553,
 71296,
 -57187,
 547063335,
 71305,
 -57186,
 547110502,
 71303,
 -1,
 547163841,
 71297,
 547365025,
 547063335,
 71300,
 -1,
 547325479,
 71301,
 547496100,
 547321222,
 -1,
 -57181,
 547436728,
 71335,
 -1,
 547491521,
 71336,
 547692711,
 547450210,
 -1,
 -57178,
 547646912,
 71338,
 -1,
 547688129,
 71332,
 547889322,
 547645179,
 -1,
 -57175,
 547829944,
 71327,
 -1,
 547884737,
 71326,
 548085933,
 547833917,
 -1,
 -57172,
 548026552,
 71307,
 -1,
 548081345,
 71306,
 548282544,
 548030263,
 -1,
 -57169,
 548223160,
 71314,
 -1,
 548277953,
 71313,
 548479154,
 548224614,
 71298,
 -1,
 548421222,
 71299,
 548610229,
 548418769,
 -1,
 -57164,
 548550840,
 71309,
 -1,
 548605633,
 71308,
 548806840,
 548543437,
 -1,
 -57161,
 548747448,
 71312,
 -1,
 548802241,
 71311,
 549003451,
 548739068,
 -1,
 -57158,
 548944056,
 71329,
 -1,
 548998849,
 71328,
 -57156,
 548967537,
 71331,
 -57155,
 549161926,
 71334,
 -57154,
 549215455,
 71304,
 -57153,
 549278325,
 71330,
 -57152,
 549342064,
 71333,
 -57151,
 549402808,
 71337,
 -1,
 549464194,
 71302,
 549658832,
 545858807,
 -1,
 549724358,
 549617173,
 -1,
 -57147,
 549687918,
 71362,
 -1,
 549731685,
 71363,
 549920969,
 549680518,
 -1,
 -57144,
 549865184,
 71366,
 -1,
 549924743,
 71367,
 550117580,
 549859678,
 -1,
 -57141,
 550069362,
 71364,
 -1,
 550127247,
 71365,
 -57139,
 550082221,
 71360,
 -57138,
 550264822,
 71361,
 -57137,
 550328983,
 71369,
 -1,
 550382396,
 71368,
 550576347,
 549621463,
 -1,
 550641877,
 550506177,
 -1,
 -57133,
 550602279,
 71349,
 -57132,
 550649446,
 71347,
 -1,
 550702785,
 71341,
 550904023,
 550602279,
 71344,
 -1,
 550864423,
 71345,
 551035097,
 550846054,
 71342,
 -1,
 550977126,
 71343,
 -57126,
 550984927,
 71348,
 -1,
 551102594,
 71346,
 551354367,
 550533257,
 -1,
 551362783,
 551259600,
 -1,
 -57122,
 551319091,
 71340,
 -1,
 551382696,
 71350,
 -57120,
 551312413,
 71351,
 -1,
 551490659,
 71339,
 551690468,
 545806437,
 -1,
 -57117,
 551630447,
 127818,
 -1,
 551685994,
 127883,
 -57115,
 551654403,
 128661,
 -1,
 551819260,
 983061,
 552018302,
 502605954,
 -1,
 552083805,
 551977827,
 -1,
 552149242,
 552016845,
 -1,
 552214771,
 552099039,
 -1,
 552280304,
 552163429,
 -1,
 552345839,
 552238613,
 -1,
 -57107,
 552300256,
 119563,
 -57106,
 552348900,
 119582,
 -1,
 552407066,
 119573,
 -1,
 552303666,
 119608,
 552730623,
 552228770,
 -1,
 -57102,
 552615696,
 119634,
 -1,
 552677036,
 119630,
 552870136,
 552161492,
 -1,
 552935671,
 552806530,
 -1,
 -57098,
 552884756,
 119590,
 -1,
 552936183,
 119613,
 -1,
 552897249,
 119631,
 -57095,
 552810912,
 119585,
 -1,
 553135339,
 119558,
 553328904,
 552084181,
 -1,
 553394433,
 553270886,
 -1,
 553459967,
 553341468,
 -1,
 -57090,
 553408118,
 119625,
 -1,
 553468807,
 119612,
 -57088,
 553422074,
 119568,
 -1,
 553595507,
 119636,
 553787653,
 553330818,
 -1,
 -57085,
 553740275,
 119623,
 -57084,
 553792029,
 119567,
 -1,
 553852708,
 119586,
 -57082,
 553749397,
 119584,
 -57081,
 554001485,
 119619,
 -1,
 554046803,
 119624,
 554246417,
 553265282,
 -1,
 554311949,
 554195045,
 -1,
 -57077,
 554257463,
 119603,
 -57076,
 554312678,
 119583,
 -1,
 554377478,
 119600,
 -57074,
 554275833,
 119626,
 -57073,
 554533011,
 119610,
 -57072,
 554587219,
 119618,
 -1,
 554636820,
 119580,
 554836251,
 554200418,
 -1,
 554901786,
 554772610,
 -1,
 554967320,
 554857862,
 -1,
 555032855,
 554909286,
 -1,
 -57066,
 554990635,
 119579,
 -1,
 555033624,
 119596,
 -1,
 554986132,
 119598,
 -57063,
 554913064,
 119578,
 -1,
 555225089,
 119572,
 -1,
 554845830,
 119605,
 555491620,
 554774878,
 -1,
 555557151,
 555452513,
 -1,
 -57058,
 555506196,
 119595,
 -1,
 555548965,
 119559,
 555753762,
 555506911,
 -1,
 -57055,
 555711568,
 119638,
 -1,
 555765825,
 119576,
 -57053,
 555700005,
 119606,
 -1,
 555880883,
 119632,
 556081452,
 555447686,
 -1,
 556146986,
 556039701,
 -1,
 556212521,
 556096735,
 -1,
 -57048,
 556174469,
 119601,
 -1,
 556231365,
 119628,
 -1,
 556167276,
 119593,
 -57045,
 556090302,
 119621,
 -1,
 556412881,
 119627,
 556605746,
 556020945,
 -1,
 556671279,
 556537556,
 119592,
 -1,
 556597813,
 119615,
 -57040,
 556631738,
 119614,
 -57039,
 556756934,
 119602,
 -1,
 556818055,
 119599,
 556998968,
 556558075,
 -1,
 557064502,
 556928705,
 -1,
 -57035,
 557024440,
 119604,
 -1,
 557064046,
 119588,
 -57033,
 557026038,
 119594,
 -1,
 557198486,
 119571,
 557392189,
 556928705,
 -1,
 -57030,
 557348415,
 119564,
 -57029,
 557397659,
 119633,
 -57028,
 557459535,
 119577,
 -1,
 557522263,
 119617,
 557719873,
 557339164,
 -1,
 -57025,
 557663563,
 119560,
 -57024,
 557722074,
 119609,
 -1,
 557782591,
 119616,
 557982022,
 557665090,
 -1,
 558047557,
 557911745,
 -1,
 -57020,
 558010206,
 119597,
 -1,
 558045930,
 119637,
 -1,
 557984513,
 119589,
 558309706,
 557914108,
 -1,
 -57016,
 558263985,
 119566,
 -57015,
 558325501,
 119587,
 -1,
 558372260,
 119561,
 558571853,
 558272399,
 -1,
 -57012,
 558530434,
 119620,
 -1,
 558581347,
 119575,
 558768464,
 558521567,
 -1,
 -57009,
 558721763,
 119565,
 -1,
 558782581,
 119635,
 558965075,
 558712893,
 -1,
 -57006,
 558908380,
 119591,
 -1,
 558967481,
 119562,
 559161686,
 558907880,
 -1,
 -57003,
 559110649,
 119622,
 -1,
 559161655,
 119570,
 559358297,
 559102114,
 -1,
 -57000,
 559308556,
 119574,
 -1,
 559355165,
 119629,
 -56998,
 559322553,
 119569,
 -56997,
 559516782,
 119607,
 -56996,
 559581569,
 119611,
 -1,
 559630348,
 119581,
 559817079,
 552028994,
 -1,
 559882611,
 559777800,
 -1,
 559948139,
 559821905,
 -1,
 560013671,
 559906325,
 -1,
 560079204,
 559977160,
 -1,
 -56989,
 560029089,
 3194,
 -1,
 560082854,
 3197,
 560332799,
 560020981,
 -1,
 -56986,
 560225697,
 3195,
 -1,
 560279462,
 3198,
 560472426,
 559964178,
 -1,
 -56983,
 560422305,
 3193,
 -1,
 560476070,
 3196,
 -1,
 560436920,
 3192,
 560734573,
 559910661,
 3170,
 -1,
 560679746,
 3171,
 560865648,
 560691337,
 -1,
 -56977,
 560825693,
 3199,
 -1,
 560863082,
 3133,
 561119231,
 560811593,
 -1,
 -56974,
 561022087,
 3160,
 -1,
 561064053,
 3161,
 561315839,
 559818882,
 -1,
 -56971,
 561221130,
 128250,
 -56970,
 561280599,
 128301,
 -1,
 561342728,
 128222,
 561521019,
 559765605,
 -1,
 -56967,
 561479189,
 9978,
 -56966,
 561535676,
 127934,
 -1,
 561591822,
 8376,
 561840127,
 561450689,
 -1,
 -56963,
 561737117,
 128198,
 -1,
 561783413,
 127861,
 561979877,
 551960166,
 -1,
 562045378,
 561918665,
 -1,
 562110911,
 561991241,
 -1,
 562176429,
 562074671,
 -1,
 562241960,
 562106049,
 11568,
 562307463,
 562176725,
 11575,
 562372998,
 562242261,
 11577,
 -1,
 562313378,
 11578,
 -1,
 562313378,
 11576,
 562569610,
 562271759,
 11619,
 -56951,
 562533903,
 11621,
 -1,
 562575522,
 11594,
 562766221,
 562527765,
 11612,
 -56948,
 562724373,
 11615,
 -1,
 562772130,
 11613,
 562962832,
 562722182,
 11609,
 -56945,
 562918790,
 11610,
 -1,
 562968738,
 11611,
 563159443,
 562907197,
 11581,
 563281919,
 563099810,
 11589,
 -1,
 563165346,
 11583,
 563356054,
 563098833,
 11571,
 563478527,
 563296418,
 11606,
 -1,
 563361954,
 11572,
 563552664,
 563309922,
 11604,
 -1,
 563506530,
 11605,
 563683738,
 563493026,
 11584,
 -1,
 563624098,
 11587,
 563814812,
 563615740,
 11569,
 -1,
 563755170,
 11570,
 -56931,
 563778607,
 11618,
 -56930,
 563908424,
 11617,
 -56929,
 563973040,
 11616,
 -56928,
 564030495,
 11591,
 -56927,
 564094715,
 11602,
 -56926,
 564156517,
 11599,
 -56925,
 564220444,
 11598,
 -56924,
 564284226,
 11597,
 -56923,
 564348727,
 11574,
 -56922,
 564408670,
 11580,
 -56921,
 564469161,
 11614,
 -1,
 564530881,
 11588,
 564732330,
 562178178,
 11622,
 -1,
 564696111,
 11579,
 -56917,
 564692519,
 11603,
 -56916,
 564813023,
 11623,
 -1,
 564870758,
 11593,
 565060025,
 562134549,
 -1,
 565125560,
 565020357,
 -1,
 565191089,
 565069885,
 11582,
 -1,
 565131426,
 11590,
 565322164,
 565130449,
 -1,
 -56909,
 565270629,
 11600,
 -1,
 565328034,
 11607,
 -56907,
 565286634,
 11596,
 -56906,
 565472287,
 11592,
 -56905,
 565533225,
 11601,
 -1,
 565590178,
 11586,
 -1,
 565057467,
 11620,
 565846460,
 564992355,
 -1,
 -56901,
 565790519,
 11573,
 -1,
 565852322,
 11585,
 566099967,
 565776065,
 -1,
 -56898,
 566007069,
 11608,
 -1,
 566048985,
 11595,
 -56896,
 562067176,
 11632,
 -56895,
 566187823,
 11631,
 -1,
 566239352,
 11647,
 566436312,
 561977734,
 -1,
 566501837,
 566383601,
 -1,
 566567367,
 566433788,
 -1,
 -56890,
 566524242,
 4048,
 -1,
 566577309,
 983206,
 -56888,
 566526832,
 4058,
 -56887,
 566713546,
 4050,
 -56886,
 566777570,
 4049,
 -56885,
 566840584,
 4057,
 -56884,
 566903706,
 4051,
 -1,
 566960090,
 4052,
 567157205,
 566457734,
 -1,
 567222738,
 567117566,
 -1,
 -56880,
 567170243,
 3982,
 -56879,
 567233711,
 3981,
 -1,
 567297191,
 3983,
 567541759,
 567165220,
 -1,
 -56876,
 567439200,
 4046,
 -1,
 567493799,
 3980,
 567738367,
 567103049,
 -1,
 -56873,
 567637140,
 3948,
 -1,
 567691917,
 3947,
 567878111,
 566381786,
 -1,
 567943646,
 567841127,
 -1,
 568009181,
 567879087,
 -1,
 -56868,
 567941449,
 11807,
 -1,
 568004528,
 11806,
 -1,
 567964395,
 11803,
 -1,
 567894459,
 11081,
 568336865,
 567817835,
 128005,
 -1,
 568263102,
 128047,
 -56862,
 568291337,
 128555,
 -56861,
 568417422,
 68410,
 -56860,
 568481210,
 9202,
 -1,
 568532841,
 127915,
 568730116,
 561929439,
 -1,
 568795638,
 568685805,
 -1,
 568861173,
 568729391,
 -1,
 568926700,
 568790493,
 -1,
 -56854,
 568856143,
 127552,
 -56853,
 568921545,
 127560,
 -1,
 568986812,
 127557,
 569188847,
 568856087,
 -1,
 -56850,
 569118227,
 127558,
 -1,
 569183135,
 127556,
 569385458,
 569118064,
 -1,
 -56847,
 569317421,
 127555,
 -1,
 569380038,
 127559,
 569638911,
 569314669,
 -1,
 -56844,
 569511555,
 127554,
 -1,
 569576348,
 127553,
 -1,
 568806525,
 127274,
 569844224,
 568747773,
 -1,
 569909754,
 569784504,
 -1,
 -56839,
 569867797,
 127913,
 -1,
 569921214,
 11833,
 -56837,
 569872921,
 128285,
 -56836,
 570065732,
 9184,
 -56835,
 570126860,
 11811,
 -56834,
 570189784,
 9180,
 -56833,
 570248596,
 11810,
 -1,
 570303124,
 9182,
 -56831,
 569793117,
 128069,
 -56830,
 570446915,
 127813,
 -56829,
 570510136,
 128508,
 -1,
 570573175,
 128701,
 570761752,
 568683874,
 -1,
 570827276,
 570711263,
 -1,
 570892811,
 570779387,
 -1,
 570958346,
 570834763,
 -1,
 -56823,
 570897149,
 128032,
 -1,
 570959845,
 127865,
 -1,
 570900052,
 127942,
 -1,
 570839062,
 128654,
 571286034,
 570768998,
 -1,
 571351568,
 571216917,
 -1,
 -56817,
 571307286,
 128208,
 -1,
 571355963,
 128681,
 -56815,
 571286558,
 128305,
 -1,
 571482154,
 8285,
 571679255,
 571215553,
 -1,
 571744789,
 571626012,
 128650,
 -1,
 571670782,
 128651,
 -56810,
 571687400,
 128646,
 -1,
 571810361,
 128668,
 -1,
 571640004,
 127930,
 572072490,
 570701986,
 -1,
 572138020,
 572026922,
 -1,
 572203555,
 572063744,
 -1,
 572269088,
 572148546,
 -1,
 572334623,
 572211845,
 -1,
 -56802,
 572289495,
 9886,
 -1,
 572345700,
 9887,
 -1,
 572271345,
 11057,
 572653567,
 572203733,
 -1,
 -56798,
 572547953,
 8278,
 -1,
 572604845,
 10176,
 -1,
 572131876,
 11835,
 572858921,
 572098087,
 -1,
 572924456,
 572806334,
 -1,
 -56793,
 572885507,
 128077,
 -1,
 572925822,
 128078,
 -1,
 572873059,
 9928,
 -1,
 572810322,
 128173,
 573252150,
 572032551,
 -1,
 573317685,
 573205858,
 -1,
 573383220,
 573266352,
 -1,
 573448752,
 573339014,
 -1,
 -56785,
 573395824,
 8526,
 -1,
 573451229,
 11829,
 -56783,
 573411570,
 9929,
 -56782,
 573580126,
 11832,
 -56781,
 573644887,
 11826,
 -1,
 573708876,
 9930,
 -1,
 573342397,
 128034,
 -1,
 573263752,
 127799,
 574038593,
 573214536,
 -1,
 574104128,
 573988063,
 -1,
 574169663,
 574029824,
 -1,
 574235196,
 574105003,
 -1,
 -56773,
 574191011,
 11818,
 -1,
 574227947,
 8282,
 -56771,
 574198532,
 128109,
 -56770,
 574379400,
 128108,
 -1,
 574437975,
 128149,
 -1,
 574097956,
 11834,
 -1,
 574047685,
 128256,
 -1,
 573967085,
 128085,
 574825981,
 502551068,
 -1,
 574890794,
 574774495,
 -1,
 574956298,
 574825704,
 -1,
 575021725,
 574911878,
 -1,
 575087255,
 574968630,
 -1,
 575152725,
 575045141,
 7511,
 575218258,
 575113991,
 -1,
 575283788,
 575147713,
 7492,
 -56757,
 575230321,
 7579,
 -1,
 575285378,
 7494,
 575480398,
 575230492,
 7514,
 -1,
 575408452,
 7597,
 -56753,
 575441840,
 7610,
 -56752,
 575562098,
 7500,
 -56751,
 575618662,
 7502,
 -1,
 575682722,
 7587,
 -56749,
 575168842,
 7508,
 -56748,
 575814319,
 7615,
 -1,
 575867240,
 7605,
 576070238,
 575085517,
 7580,
 576135772,
 576001164,
 -1,
 576201305,
 576077414,
 7590,
 -1,
 576129442,
 7591,
 -56742,
 576161319,
 7608,
 -56741,
 576280677,
 7600,
 -1,
 576342850,
 7595,
 -56739,
 576076522,
 7521,
 -1,
 576456718,
 7581,
 576660067,
 576006274,
 7497,
 -56736,
 576624362,
 7614,
 -56735,
 576684209,
 7582,
 -56734,
 576747293,
 7604,
 -1,
 576805417,
 7505,
 576987753,
 576615814,
 -1,
 577053287,
 576920525,
 -1,
 -56730,
 577008490,
 7586,
 -1,
 577060428,
 7498,
 -56728,
 576995321,
 7513,
 -1,
 577177799,
 7603,
 577380973,
 576919548,
 7495,
 -56725,
 577332215,
 7509,
 -56724,
 577384084,
 7517,
 -1,
 577443214,
 7601,
 577643121,
 577345039,
 7611,
 577765375,
 577570724,
 -1,
 -56720,
 577663160,
 7612,
 -1,
 577708680,
 7613,
 577905268,
 577603111,
 7512,
 -56717,
 577858427,
 7607,
 -1,
 577896641,
 7606,
 578101880,
 577854687,
 7506,
 578224127,
 578054198,
 -1,
 -56713,
 578116831,
 7507,
 -1,
 578168962,
 7499,
 578364029,
 578046786,
 -1,
 578429564,
 578291620,
 -1,
 -56709,
 578384056,
 7593,
 -1,
 578447216,
 7594,
 -1,
 578371770,
 43001,
 578691713,
 578303185,
 7501,
 578813951,
 578646074,
 -1,
 -56704,
 578709750,
 7520,
 -1,
 578762079,
 7518,
 578953860,
 578626261,
 7496,
 -56701,
 578905045,
 7585,
 -1,
 578956234,
 7519,
 579150471,
 578883265,
 7491,
 -56698,
 579096945,
 7493,
 -1,
 579158504,
 7516,
 579347081,
 579111856,
 7515,
 -1,
 579274951,
 7609,
 579478155,
 579299067,
 7510,
 -1,
 579418858,
 7602,
 579609230,
 579426433,
 -1,
 -56691,
 579563704,
 7599,
 -1,
 579620262,
 7598,
 579805840,
 579555868,
 7504,
 -1,
 579733703,
 7596,
 579936915,
 579747430,
 -1,
 -56686,
 579888000,
 7589,
 -1,
 579930530,
 7588,
 -56684,
 579891442,
 7583,
 -56683,
 580077629,
 7503,
 -56682,
 580142913,
 7592,
 -1,
 580202846,
 7584,
 580395674,
 575046625,
 -1,
 -56679,
 580342064,
 42785,
 -1,
 580402052,
 42784,
 580648959,
 580335778,
 -1,
 -56676,
 580543221,
 42890,
 -1,
 580594594,
 765,
 580788934,
 574954445,
 -1,
 580854457,
 580719756,
 -1,
 580919971,
 580808034,
 7487,
 581042175,
 580857831,
 -1,
 -56670,
 580933733,
 7483,
 -1,
 580987010,
 7474,
 581182117,
 580869343,
 7484,
 -1,
 581142055,
 7485,
 581313191,
 581122210,
 7476,
 -1,
 581241250,
 43000,
 581444265,
 581244924,
 7470,
 -1,
 581375366,
 7471,
 581575339,
 581373633,
 7468,
 -1,
 581511298,
 7469,
 -56660,
 581537608,
 7490,
 -56659,
 581667760,
 11389,
 -56658,
 581731879,
 7489,
 -56657,
 581795349,
 7488,
 -56656,
 581854971,
 7486,
 -56655,
 581916773,
 7482,
 -56654,
 581980700,
 7481,
 -56653,
 582044482,
 7480,
 -56652,
 582109245,
 7479,
 -56651,
 582174519,
 7478,
 -56650,
 582237798,
 7477,
 -56649,
 582300881,
 7475,
 -56648,
 582363266,
 7473,
 -1,
 582427349,
 7472,
 582623940,
 580795342,
 -1,
 582689471,
 582566379,
 -1,
 -56644,
 582645653,
 42754,
 -56643,
 582710537,
 42758,
 -56642,
 582773876,
 42756,
 -1,
 582838618,
 42752,
 583073791,
 582620107,
 -1,
 -56639,
 582973333,
 42755,
 -56638,
 583038217,
 42759,
 -56637,
 583101556,
 42757,
 -1,
 583166298,
 42753,
 -56635,
 582587892,
 7544,
 -1,
 583294769,
 42889,
 583475929,
 580735248,
 -1,
 583541464,
 583401472,
 -1,
 583606988,
 583486820,
 -1,
 583672523,
 583532724,
 767,
 -1,
 583612961,
 753,
 -1,
 583600884,
 42773,
 583869137,
 583542155,
 -1,
 583934672,
 583828626,
 -1,
 -56625,
 583893745,
 42763,
 -1,
 583945659,
 42768,
 -1,
 583897670,
 751,
 584196820,
 583823688,
 -1,
 -56621,
 584145449,
 755,
 -1,
 584201970,
 754,
 -56619,
 584157627,
 752,
 -56618,
 584352285,
 759,
 -56617,
 584402061,
 42783,
 -1,
 584457986,
 42888,
 -1,
 583478655,
 42778,
 584721130,
 583411842,
 -1,
 584786663,
 584684581,
 -1,
 584852193,
 584732948,
 -1,
 584917727,
 584787546,
 -1,
 -56610,
 584876785,
 42764,
 -1,
 584928699,
 42769,
 -56608,
 584863163,
 42774,
 -1,
 585052448,
 983972,
 585302015,
 584792908,
 -1,
 585310949,
 585180762,
 -1,
 -56604,
 585270001,
 42760,
 -1,
 585321915,
 42765,
 -56602,
 585256379,
 42770,
 -1,
 585445692,
 983971,
 585695231,
 584735019,
 -1,
 -56599,
 585584944,
 764,
 -1,
 585644932,
 762,
 585835253,
 584668690,
 -1,
 585900784,
 585770368,
 -1,
 585966319,
 585836196,
 -1,
 -56594,
 585906174,
 757,
 -1,
 585961525,
 758,
 -1,
 585906174,
 756,
 586285055,
 585826304,
 -1,
 586294004,
 586163802,
 -1,
 -56589,
 586253041,
 42762,
 -1,
 586304955,
 42767,
 -1,
 586239419,
 42772,
 586556155,
 585788980,
 -1,
 -56585,
 586516914,
 42779,
 -56584,
 586564749,
 42782,
 -56583,
 586625104,
 42781,
 -56582,
 586688350,
 42780,
 -1,
 586752042,
 760,
 586949376,
 586496844,
 -1,
 587014911,
 586884698,
 -1,
 -56578,
 586973937,
 42761,
 -1,
 587025851,
 42766,
 -1,
 586960315,
 42771,
 587277060,
 586884527,
 -1,
 -56574,
 587238706,
 42775,
 -56573,
 587299188,
 42776,
 -1,
 587349200,
 42777,
 587539207,
 587208999,
 -1,
 -56570,
 587485488,
 763,
 -1,
 587545476,
 761,
 -56568,
 587500319,
 42864,
 -56567,
 587686310,
 766,
 -1,
 587740766,
 4348,
 587932440,
 574904421,
 -1,
 587997970,
 587881695,
 -1,
 588063505,
 587937724,
 -1,
 588129040,
 588026927,
 -1,
 -56561,
 588071400,
 9867,
 -1,
 588125127,
 9866,
 -1,
 588065201,
 119552,
 -1,
 588017191,
 128669,
 588456724,
 587942376,
 128018,
 -1,
 588382654,
 128053,
 588587799,
 588394842,
 -1,
 -56554,
 588550706,
 128184,
 -1,
 588585036,
 128176,
 -1,
 588527502,
 6314,
 588849955,
 587892263,
 -1,
 588915488,
 588798894,
 -1,
 588981023,
 588845498,
 9968,
 589103103,
 588906496,
 -1,
 -56547,
 589000236,
 128670,
 -56546,
 589044739,
 128672,
 -1,
 589109693,
 128693,
 -1,
 588906974,
 128507,
 589374242,
 588871291,
 128001,
 -1,
 589300158,
 128045,
 -1,
 589332657,
 128068,
 589570855,
 588782052,
 128241,
 589692927,
 589496320,
 -1,
 -56538,
 589599179,
 128242,
 -1,
 589651449,
 128244,
 -56536,
 589534340,
 128511,
 -56535,
 589794776,
 127909,
 -1,
 589848505,
 127889,
 590029813,
 574826626,
 -1,
 590095253,
 589967004,
 -1,
 590160745,
 590039874,
 -1,
 590226280,
 590098120,
 -1,
 590291765,
 590174309,
 -1,
 590357297,
 590231477,
 43977,
 -1,
 590283519,
 44001,
 590488371,
 590286529,
 43973,
 -1,
 590414591,
 43999,
 -56524,
 590451825,
 43747,
 -1,
 590567611,
 43752,
 590750524,
 590249493,
 -1,
 590816057,
 590708245,
 -1,
 -56520,
 590756024,
 43749,
 -1,
 590810817,
 43748,
 591012667,
 590758232,
 43975,
 -1,
 590938879,
 44000,
 -1,
 590953779,
 43978,
 591209282,
 590684885,
 -1,
 591274816,
 591143637,
 -1,
 -56513,
 591214776,
 43751,
 -1,
 591269569,
 43750,
 -56511,
 591216984,
 43991,
 -1,
 591412531,
 43993,
 591602502,
 591164806,
 -1,
 -56508,
 591558106,
 43754,
 -56507,
 591607992,
 43753,
 -1,
 591663869,
 43969,
 591864650,
 591554299,
 -1,
 591930185,
 591793857,
 43972,
 -1,
 591856383,
 43998,
 -1,
 591870255,
 43984,
 592126798,
 591808573,
 -1,
 592192333,
 592076442,
 43968,
 -1,
 592118527,
 43995,
 -1,
 592133427,
 43976,
 592388944,
 592074431,
 43971,
 -1,
 592315135,
 43997,
 592520018,
 592333828,
 43970,
 -1,
 592446207,
 43996,
 592651093,
 592463671,
 -1,
 -56492,
 592593240,
 43990,
 -1,
 592656687,
 43987,
 592847703,
 592592486,
 43983,
 -1,
 592773887,
 44002,
 592978778,
 592786641,
 -1,
 -56487,
 592928410,
 43986,
 -1,
 592985395,
 43992,
 593175389,
 592911785,
 -1,
 -56484,
 593117528,
 43974,
 -1,
 593170113,
 43746,
 593372000,
 593106940,
 -1,
 -56481,
 593312047,
 43994,
 -1,
 593366721,
 43989,
 -56479,
 593335484,
 43980,
 -56478,
 593530789,
 43979,
 -56477,
 593594574,
 43982,
 -56476,
 593653283,
 43988,
 -56475,
 593714399,
 43745,
 -56474,
 593772064,
 43981,
 -56473,
 593832066,
 43744,
 -1,
 593893150,
 43985,
 -1,
 590186632,
 44012,
 594158462,
 590121904,
 -1,
 594223997,
 594110115,
 -1,
 594289521,
 594153153,
 -1,
 594355055,
 594218689,
 -1,
 -56466,
 594314791,
 43759,
 -1,
 594361958,
 43757,
 -56464,
 594314791,
 43758,
 -1,
 594499820,
 44005,
 594682740,
 594249255,
 -1,
 -56461,
 594642471,
 43756,
 -1,
 594696428,
 44008,
 594879351,
 594624102,
 -1,
 -56458,
 594827500,
 44004,
 -1,
 594886246,
 43755,
 -56456,
 594842878,
 44006,
 -56455,
 595037689,
 43765,
 -56454,
 595098344,
 44007,
 -56453,
 595156977,
 44003,
 -56452,
 595221598,
 44010,
 -1,
 595271186,
 44009,
 -1,
 594167090,
 43766,
 595534732,
 594093303,
 -1,
 595600258,
 595492373,
 -1,
 -56447,
 595563118,
 44018,
 -1,
 595606885,
 44019,
 595796869,
 595555718,
 -1,
 -56444,
 595740384,
 44022,
 -1,
 595799943,
 44023,
 595993480,
 595734878,
 -1,
 -56441,
 595944562,
 44020,
 -1,
 596002447,
 44021,
 -56439,
 595957421,
 44016,
 -56438,
 596140022,
 44017,
 -56437,
 596204183,
 44025,
 -1,
 596257596,
 44024,
 596452240,
 595463873,
 -1,
 -56434,
 596405163,
 44013,
 -56433,
 596466410,
 43762,
 -1,
 596523412,
 43761,
 596714387,
 596385291,
 -1,
 -56430,
 596650801,
 44011,
 -1,
 596710190,
 43760,
 -56428,
 596677417,
 43764,
 -1,
 596868537,
 43763,
 597042141,
 590050331,
 -1,
 597107644,
 596982538,
 -1,
 597173178,
 597053001,
 -1,
 597238686,
 597130773,
 -1,
 597304219,
 597174402,
 67994,
 -1,
 597232099,
 67995,
 597435293,
 597233345,
 67992,
 -1,
 597363171,
 67993,
 -1,
 597384415,
 67996,
 597631907,
 597186661,
 -1,
 597697441,
 597567618,
 67980,
 -1,
 597625315,
 67981,
 597884927,
 597626561,
 67978,
 -1,
 597756387,
 67979,
 597959591,
 597587334,
 -1,
 598025126,
 597888705,
 67987,
 -1,
 597952995,
 67988,
 -1,
 597960834,
 67989,
 598221737,
 597913024,
 67982,
 -1,
 598149603,
 67983,
 598352812,
 598165565,
 -1,
 -56405,
 598292664,
 67985,
 -1,
 598347457,
 67990,
 598549422,
 598284337,
 67974,
 -1,
 598477283,
 67975,
 -56401,
 598512753,
 67972,
 -56400,
 598642575,
 67973,
 -56399,
 598699053,
 67991,
 -56398,
 598763322,
 67976,
 -56397,
 598826207,
 67971,
 -56396,
 598889077,
 67977,
 -56395,
 598952816,
 67984,
 -56394,
 599015014,
 67970,
 -56393,
 599079654,
 67986,
 -56392,
 599140482,
 67969,
 -56391,
 599204658,
 67997,
 -1,
 599264961,
 67968,
 599523327,
 597130741,
 67998,
 -1,
 599394787,
 67999,
 599654399,
 597041837,
 -1,
 599663578,
 599535304,
 -1,
 599729090,
 599621141,
 -1,
 -56384,
 599678175,
 68022,
 -56383,
 599730306,
 68021,
 -1,
 599789249,
 68020,
 599991237,
 599684486,
 -1,
 -56380,
 599926914,
 68017,
 -1,
 599985857,
 68015,
 600187848,
 599939173,
 -1,
 -56377,
 600123522,
 68010,
 -1,
 600182465,
 68009,
 600384459,
 600131645,
 -1,
 -56374,
 600324280,
 68013,
 -1,
 600379073,
 68018,
 600581069,
 600313537,
 68000,
 -1,
 600534856,
 68016,
 -56370,
 600544369,
 68004,
 -56369,
 600674191,
 68005,
 -56368,
 600731072,
 68011,
 -56367,
 600796205,
 68019,
 -56366,
 600860474,
 68007,
 -56365,
 600923359,
 68003,
 -56364,
 600986229,
 68008,
 -56363,
 601049968,
 68012,
 -56362,
 601112166,
 68002,
 -56361,
 601176806,
 68014,
 -56360,
 601237634,
 68001,
 -56359,
 601301810,
 68023,
 -1,
 601364529,
 68006,
 601620479,
 599612960,
 -1,
 -56356,
 601519051,
 68030,
 -1,
 601571812,
 68031,
 601760748,
 597001056,
 -1,
 601826283,
 601702219,
 -1,
 601891813,
 601783829,
 -1,
 601957347,
 601854679,
 -1,
 -56350,
 601908716,
 9173,
 -1,
 601966586,
 9174,
 -56348,
 601912182,
 9175,
 -1,
 602091186,
 9176,
 602285032,
 601837733,
 -1,
 -56345,
 602244594,
 9172,
 -1,
 602306602,
 9170,
 -56343,
 602241087,
 9171,
 -56342,
 602433671,
 9177,
 -1,
 602479402,
 9169,
 -1,
 601775327,
 128647,
 602743792,
 601695597,
 -1,
 -56338,
 602706062,
 9898,
 -56337,
 602765923,
 9900,
 -1,
 602806833,
 9899,
 -56335,
 602700715,
 983172,
 -56334,
 602954605,
 128697,
 -56333,
 603019001,
 128221,
 -56332,
 603082883,
 127816,
 -1,
 603133550,
 127830,
 603333805,
 589971046,
 -1,
 603399330,
 603264108,
 -1,
 603464812,
 603344457,
 -1,
 603530250,
 603422229,
 -1,
 603595777,
 603480175,
 -1,
 -56325,
 603524694,
 94105,
 -56324,
 603590167,
 94104,
 -56323,
 603655645,
 94103,
 -56322,
 603721072,
 94102,
 -56321,
 603786546,
 94101,
 -56320,
 603851978,
 94100,
 -1,
 603917363,
 94099,
 604120069,
 603551110,
 -1,
 -56317,
 604075482,
 93994,
 -56316,
 604125368,
 93998,
 -1,
 604180161,
 94007,
 604382216,
 604065495,
 -1,
 -56313,
 604345457,
 93980,
 -1,
 604376769,
 93978,
 -56311,
 604339851,
 93966,
 -1,
 604507841,
 93962,
 604709911,
 603478117,
 -1,
 604775438,
 604673071,
 -1,
 -56307,
 604715192,
 93997,
 -1,
 604769985,
 93996,
 604972049,
 604723301,
 -1,
 -56304,
 604911800,
 93973,
 -1,
 604966593,
 93972,
 605168660,
 604910801,
 -1,
 -56301,
 605108408,
 93988,
 -1,
 605163201,
 93987,
 605365270,
 605097665,
 93968,
 -1,
 605320711,
 94032,
 -1,
 605305016,
 93969,
 605561891,
 604673551,
 -1,
 605627422,
 605525519,
 -1,
 605692956,
 605582726,
 -1,
 -56293,
 605656177,
 94017,
 -1,
 605687489,
 94014,
 -56291,
 605656177,
 94016,
 -1,
 605818561,
 94013,
 606020641,
 605582726,
 -1,
 -56288,
 605960376,
 94006,
 -1,
 606015169,
 94012,
 -56286,
 605960376,
 94005,
 -1,
 606146241,
 94011,
 606348334,
 605525304,
 -1,
 606413866,
 606305813,
 -1,
 606479400,
 606369158,
 -1,
 -56281,
 606419128,
 94000,
 -1,
 606473921,
 94009,
 -56279,
 606437003,
 93964,
 -1,
 606604993,
 93965,
 -56277,
 606365498,
 93954,
 -56276,
 606755592,
 93970,
 -56275,
 606816399,
 93984,
 -1,
 606873725,
 94001,
 607069239,
 606302282,
 -1,
 607134774,
 607019119,
 -1,
 -56271,
 607063638,
 94111,
 -56270,
 607129053,
 94110,
 -56269,
 607194480,
 94109,
 -56268,
 607259954,
 94108,
 -56267,
 607325235,
 94107,
 -1,
 607390627,
 94106,
 -1,
 607090524,
 94002,
 607659073,
 607003349,
 -1,
 607724604,
 607622671,
 -1,
 -56262,
 607688223,
 93995,
 -56261,
 607729848,
 93999,
 -1,
 607784641,
 94008,
 607986751,
 607669975,
 -1,
 -56258,
 607949937,
 93981,
 -1,
 607981249,
 93979,
 -56256,
 607920946,
 93967,
 -1,
 608112321,
 93963,
 608314441,
 607588033,
 -1,
 608379976,
 608268087,
 -1,
 608445510,
 608327781,
 -1,
 -56251,
 608384259,
 93989,
 -1,
 608440001,
 93971,
 -56249,
 608409412,
 94015,
 -1,
 608588405,
 93958,
 -1,
 608319650,
 94019,
 608838735,
 608258882,
 -1,
 608904269,
 608778402,
 -1,
 -56244,
 608867441,
 93977,
 -1,
 608898753,
 93976,
 -56242,
 608867441,
 93975,
 -1,
 609029825,
 93974,
 609231955,
 608793990,
 -1,
 -56239,
 609187290,
 94004,
 -56238,
 609237176,
 94003,
 -1,
 609291969,
 94010,
 609494104,
 609170641,
 -1,
 609559639,
 609433762,
 -1,
 -56234,
 609499320,
 93993,
 -1,
 609554113,
 93992,
 -1,
 609488577,
 93983,
 609821787,
 609455024,
 -1,
 -56230,
 609759675,
 93961,
 -1,
 609816257,
 93960,
 610018398,
 609774623,
 -1,
 -56227,
 609957123,
 93986,
 -1,
 610012865,
 93985,
 610215009,
 609969915,
 -1,
 -56224,
 610159472,
 93955,
 -1,
 610209473,
 93952,
 610411620,
 610161180,
 -1,
 -56221,
 610351288,
 93957,
 -1,
 610406081,
 93956,
 610608231,
 610351266,
 -1,
 -56218,
 610547896,
 94020,
 -1,
 610602689,
 93990,
 -56216,
 610571206,
 93991,
 -56215,
 610766735,
 94018,
 -56214,
 610814095,
 93982,
 -56213,
 610873787,
 93959,
 -1,
 610932785,
 93953,
 611132568,
 603426519,
 -1,
 611198070,
 611073638,
 94049,
 611263601,
 611126977,
 94050,
 611385343,
 611211365,
 94051,
 -1,
 611267793,
 94052,
 -56206,
 611223079,
 94056,
 -56205,
 611409119,
 94053,
 -56204,
 611473961,
 94057,
 -56203,
 611532390,
 94055,
 -1,
 611592322,
 94054,
 611787903,
 611126977,
 94036,
 611853433,
 611735653,
 94039,
 -1,
 611792081,
 94040,
 611984507,
 611788930,
 94067,
 -1,
 611920002,
 94068,
 -56196,
 611943975,
 94075,
 -56195,
 612056678,
 94073,
 -56194,
 612121315,
 94038,
 -1,
 612175553,
 94037,
 612377734,
 611747367,
 94058,
 612443267,
 612306625,
 94059,
 612564991,
 612391013,
 94060,
 -1,
 612447441,
 94061,
 -56188,
 612402727,
 94062,
 -56187,
 612588073,
 94064,
 -1,
 612641585,
 94063,
 612836492,
 612313218,
 94045,
 612902025,
 612789602,
 94071,
 -1,
 612855138,
 94069,
 613033099,
 612849765,
 94046,
 -1,
 612971729,
 94047,
 -1,
 612974182,
 94074,
 613229712,
 612785375,
 94041,
 -56178,
 613189159,
 94076,
 -56177,
 613244127,
 94042,
 -1,
 613298519,
 94048,
 613491858,
 613192751,
 94065,
 -1,
 613432934,
 94066,
 613622932,
 613453640,
 94044,
 -1,
 613571807,
 94043,
 613754006,
 613577848,
 94072,
 -1,
 613707106,
 94070,
 613941247,
 613701733,
 94077,
 -1,
 613823697,
 94078,
 614016157,
 611091179,
 -1,
 -56166,
 613974831,
 94096,
 -56165,
 614035927,
 94095,
 -56164,
 614078793,
 94098,
 -1,
 614141872,
 94097,
 614399999,
 613972105,
 -1,
 614409377,
 614297664,
 -1,
 -56160,
 614370933,
 94034,
 -1,
 614405684,
 94035,
 -1,
 614340148,
 94033,
 614671529,
 603332885,
 -1,
 614737062,
 614620383,
 -1,
 -56155,
 614692439,
 128300,
 -1,
 614754562,
 127908,
 614989823,
 614662144,
 -1,
 -56152,
 614883244,
 983225,
 -1,
 614933419,
 983226,
 615130284,
 614619746,
 -1,
 -56149,
 615064905,
 128189,
 -1,
 615127967,
 128656,
 -1,
 615075784,
 127756,
 615392596,
 603262657,
 -1,
 615458037,
 615332904,
 -1,
 615523517,
 615413126,
 -1,
 615589045,
 615466736,
 -1,
 615654580,
 615521229,
 -1,
 -56141,
 615597374,
 127006,
 -1,
 615659997,
 126988,
 -1,
 615585900,
 126997,
 615916730,
 615526301,
 -1,
 615982265,
 615848909,
 -1,
 -56136,
 615925054,
 127007,
 -1,
 615987677,
 126989,
 -1,
 615913580,
 126998,
 -56133,
 615876798,
 127015,
 -56132,
 616196934,
 127014,
 -1,
 616260857,
 126977,
 616441032,
 615480853,
 -1,
 616506563,
 616403664,
 -1,
 616572098,
 616438733,
 -1,
 -56127,
 616514878,
 127002,
 -1,
 616577501,
 126984,
 -1,
 616503404,
 126993,
 616890367,
 616447487,
 -1,
 616899783,
 616766413,
 -1,
 -56122,
 616842558,
 127003,
 -1,
 616905181,
 126985,
 -1,
 616831084,
 126994,
 617161939,
 616378718,
 -1,
 617227470,
 617112744,
 -1,
 617293005,
 617159629,
 -1,
 -56116,
 617235774,
 127004,
 -1,
 617298397,
 126986,
 -1,
 617224300,
 126995,
 617611263,
 617170609,
 -1,
 617620690,
 617487309,
 -1,
 -56111,
 617563454,
 127005,
 -1,
 617626077,
 126987,
 -1,
 617551980,
 126996,
 617882842,
 617110751,
 -1,
 617948377,
 617830825,
 -1,
 618013912,
 617880525,
 -1,
 -56105,
 617956670,
 127001,
 -1,
 618019293,
 126983,
 -1,
 617945196,
 126992,
 -1,
 617901906,
 127011,
 618341601,
 617830501,
 -1,
 618407136,
 618283640,
 -1,
 618472671,
 618339277,
 -1,
 -56098,
 618415422,
 127009,
 -1,
 618478045,
 126991,
 -1,
 618403948,
 127000,
 -1,
 618357509,
 126979,
 618800360,
 618276994,
 -1,
 618865895,
 618741988,
 -1,
 618931430,
 618798029,
 -1,
 -56091,
 618874174,
 127008,
 -1,
 618936797,
 126990,
 -1,
 618862700,
 126999,
 -1,
 618796614,
 126976,
 619259116,
 618762056,
 -1,
 -56086,
 619201557,
 127017,
 -56085,
 619265022,
 126982,
 -1,
 619327099,
 126978,
 619521263,
 619190321,
 -1,
 -56082,
 619467952,
 127012,
 -1,
 619519814,
 127019,
 -56080,
 619474942,
 126980,
 -56079,
 619669961,
 127010,
 -56078,
 619726849,
 127018,
 -56077,
 619788343,
 126981,
 -56076,
 619847288,
 127013,
 -1,
 619911011,
 127016,
 620111133,
 615405669,
 128104,
 620176663,
 620045161,
 -1,
 620242195,
 620121673,
 -1,
 620307724,
 620170945,
 -1,
 620373244,
 620262790,
 2126,
 -56069,
 620336655,
 2129,
 -1,
 620378274,
 2132,
 620569854,
 620330517,
 2133,
 -1,
 620527125,
 2120,
 620700928,
 620513341,
 2122,
 -1,
 620656090,
 2121,
 -56063,
 620664335,
 2118,
 -56062,
 620784994,
 2131,
 -56061,
 620850207,
 2130,
 -56060,
 620914427,
 2128,
 -56059,
 620976229,
 2125,
 -56058,
 621040156,
 2124,
 -56057,
 621103938,
 2123,
 -56056,
 621167080,
 2136,
 -56055,
 621230242,
 2116,
 -56054,
 621294801,
 2114,
 -56053,
 621355733,
 2115,
 -1,
 621418492,
 2113,
 621618447,
 620248678,
 -1,
 -56050,
 621575701,
 2119,
 -1,
 621631589,
 2127,
 -56048,
 621579075,
 2117,
 -56047,
 621758662,
 2135,
 -56046,
 621820201,
 2112,
 -1,
 621881414,
 2134,
 -56044,
 620203588,
 2138,
 -56043,
 622029748,
 2142,
 -56042,
 622081598,
 2139,
 -1,
 622137625,
 2137,
 622339356,
 620101632,
 -1,
 622404891,
 622301543,
 -1,
 -56038,
 622363920,
 128115,
 -1,
 622409803,
 128114,
 -1,
 622334865,
 128107,
 -1,
 622294480,
 128094,
 622732607,
 620055362,
 -1,
 622798138,
 622663645,
 -1,
 622863658,
 622743113,
 -1,
 622929191,
 622796353,
 -1,
 622994723,
 622876773,
 3451,
 -1,
 622942309,
 3450,
 623125797,
 622938946,
 3453,
 -1,
 623070018,
 3454,
 -56026,
 623080593,
 3452,
 -1,
 623200317,
 3455,
 -56024,
 622888138,
 3386,
 -56023,
 623336218,
 3369,
 -1,
 623388200,
 3406,
 623584558,
 622825201,
 -1,
 623650093,
 623528770,
 3426,
 -1,
 623594306,
 3427,
 -1,
 623604881,
 3396,
 623846707,
 623533095,
 -1,
 623912242,
 623796218,
 -1,
 -56015,
 623870291,
 3442,
 -1,
 623918628,
 3441,
 -1,
 623869981,
 3440,
 624174392,
 623785031,
 -1,
 624239927,
 624123898,
 -1,
 -56010,
 624192710,
 3443,
 -1,
 624245012,
 3444,
 -1,
 624198014,
 3445,
 -56007,
 624130191,
 3389,
 -1,
 624436151,
 3449,
 624689151,
 622733444,
 -1,
 624698686,
 624595433,
 -1,
 -56003,
 624654468,
 9894,
 -1,
 624694114,
 9895,
 -1,
 624628562,
 9893,
 624960848,
 622690557,
 -1,
 625026373,
 624914760,
 -1,
 625091908,
 624965357,
 -1,
 -55997,
 625053956,
 10221,
 -1,
 625095525,
 10223,
 -1,
 625047741,
 10187,
 625354056,
 624971113,
 -1,
 -55993,
 625316100,
 10220,
 -1,
 625357669,
 10222,
 625550667,
 625296937,
 -1,
 -55990,
 625493815,
 120485,
 -1,
 625557094,
 120484,
 625747278,
 625482432,
 -1,
 -55987,
 625703404,
 120779,
 -1,
 625745036,
 120778,
 -55985,
 625702493,
 120001,
 -1,
 625881579,
 10189,
 626074963,
 624912123,
 -1,
 -55982,
 626019573,
 127809,
 -1,
 626067073,
 9967,
 -1,
 626029720,
 9901,
 626337264,
 615355585,
 -1,
 626402714,
 626281282,
 -1,
 626468246,
 626339528,
 -1,
 626533746,
 626412026,
 -1,
 626599261,
 626467541,
 -1,
 626664796,
 626533077,
 -1,
 -55973,
 626604216,
 43625,
 -1,
 626659009,
 43624,
 -1,
 626604216,
 43626,
 626926944,
 626558095,
 -1,
 -55969,
 626866360,
 43623,
 -1,
 626921153,
 43622,
 627123555,
 626874469,
 -1,
 -55966,
 627086449,
 43621,
 -1,
 627117761,
 43627,
 627320166,
 627066679,
 -1,
 -55963,
 627259576,
 43620,
 -1,
 627314369,
 43619,
 627516777,
 627259554,
 -1,
 -55960,
 627456184,
 43630,
 -1,
 627510977,
 43629,
 627713388,
 627448781,
 -1,
 -55957,
 627652792,
 43618,
 -1,
 627707585,
 43617,
 -55955,
 627676703,
 43634,
 -55954,
 627872710,
 43633,
 -55953,
 627930586,
 43628,
 -55952,
 627994048,
 43635,
 -55951,
 628045059,
 43616,
 -1,
 628109755,
 43631,
 628303237,
 626488710,
 -1,
 628368772,
 628242776,
 -1,
 628434295,
 628316261,
 -1,
 -55946,
 628397169,
 4218,
 -1,
 628428481,
 4220,
 628630906,
 628377661,
 -1,
 -55943,
 628570296,
 4214,
 -1,
 628625089,
 4213,
 -55941,
 628594207,
 4217,
 -55940,
 628785337,
 4224,
 -55939,
 628844780,
 4221,
 -55938,
 628897976,
 4225,
 -55937,
 628962563,
 4215,
 -55936,
 629027259,
 4222,
 -55935,
 629089074,
 4219,
 -55934,
 629152745,
 4216,
 -55933,
 629217329,
 4223,
 -1,
 629280449,
 4130,
 -1,
 628307379,
 4193,
 629548428,
 628250454,
 -1,
 629613961,
 629479677,
 -1,
 -55928,
 629549186,
 4189,
 -1,
 629608129,
 4188,
 -55926,
 629561922,
 4186,
 -55925,
 629753792,
 4187,
 -1,
 629811330,
 4136,
 630007184,
 629483965,
 -1,
 -55922,
 629970443,
 4207,
 -55921,
 630020872,
 4206,
 -1,
 630077199,
 4208,
 630269331,
 629968974,
 -1,
 -55918,
 630227129,
 4197,
 -1,
 630287387,
 4198,
 -55916,
 630224156,
 4238,
 -55915,
 630405143,
 4159,
 -1,
 630460907,
 43642,
 630718463,
 626417193,
 -1,
 -55912,
 630615139,
 43637,
 -55911,
 630676766,
 43636,
 -1,
 630733895,
 43638,
 630924745,
 626357638,
 -1,
 630990259,
 630866212,
 -1,
 631055783,
 630945664,
 -1,
 631121314,
 631014170,
 -1,
 -55905,
 631049693,
 4234,
 -55904,
 631115120,
 4233,
 -55903,
 631180490,
 4232,
 -1,
 631245875,
 4231,
 631504895,
 631054589,
 -1,
 631514534,
 631407386,
 -1,
 -55899,
 631442634,
 4236,
 -1,
 631508019,
 4235,
 -1,
 631450614,
 4237,
 631776685,
 631017569,
 -1,
 -55895,
 631704944,
 4205,
 -55894,
 631770418,
 4204,
 -55893,
 631835850,
 4203,
 -55892,
 631901235,
 4202,
 -1,
 631966627,
 4201,
 632169904,
 631720450,
 -1,
 -55889,
 632097994,
 4251,
 -1,
 632163235,
 4250,
 -55887,
 632124717,
 4239,
 -55886,
 632317878,
 43643,
 -1,
 632362511,
 4154,
 632563137,
 630929757,
 -1,
 632628663,
 632520213,
 -1,
 -55882,
 632590958,
 4242,
 -1,
 632634725,
 4243,
 632825274,
 632583558,
 -1,
 -55879,
 632768224,
 4246,
 -1,
 632827783,
 4247,
 633021885,
 632762718,
 -1,
 -55876,
 632972402,
 4244,
 -1,
 633030287,
 4245,
 -55874,
 632985261,
 4240,
 -55873,
 633167862,
 4241,
 -55872,
 633232023,
 4249,
 -1,
 633285436,
 4248,
 633536511,
 632526183,
 -1,
 633546182,
 633410012,
 -1,
 -55868,
 633505123,
 43641,
 -55867,
 633561078,
 43640,
 -1,
 633614404,
 43639,
 633864191,
 633501568,
 -1,
 -55864,
 633757686,
 4254,
 -1,
 633811012,
 4255,
 634004960,
 630886103,
 -1,
 634070481,
 633959814,
 -1,
 634136016,
 634009944,
 -1,
 634201550,
 634071170,
 4228,
 -1,
 634126341,
 4229,
 -55857,
 634139371,
 4230,
 -1,
 634261306,
 4227,
 -1,
 634074534,
 4194,
 634529237,
 634014070,
 -1,
 -55853,
 634488359,
 4211,
 -55852,
 634543580,
 4210,
 -1,
 634595963,
 4212,
 634791384,
 634490958,
 -1,
 -55849,
 634750939,
 4200,
 -1,
 634793710,
 4199,
 634987995,
 634738518,
 -1,
 -55846,
 634936543,
 4148,
 -1,
 634995011,
 4147,
 635184605,
 634917347,
 4252,
 -1,
 635125350,
 4253,
 -55842,
 635141961,
 4139,
 -55841,
 635254300,
 4209,
 -1,
 635316359,
 4149,
 635512300,
 633938057,
 -1,
 635577835,
 635458076,
 -1,
 635643367,
 635513447,
 -1,
 -55836,
 635606129,
 4155,
 -55835,
 635670415,
 4157,
 -55834,
 635727296,
 4156,
 -1,
 635779256,
 4158,
 636026879,
 635592599,
 -1,
 -55831,
 635918523,
 4190,
 -55830,
 635982453,
 4191,
 -1,
 636046192,
 4192,
 -1,
 635533190,
 4226,
 636298735,
 635470596,
 -1,
 -55826,
 636242327,
 4196,
 -1,
 636303887,
 4195,
 -1,
 636245770,
 43632,
 636560890,
 626296359,
 -1,
 636626425,
 636515718,
 -1,
 636691960,
 636567371,
 -1,
 636757494,
 636646790,
 -1,
 -55819,
 636720507,
 119081,
 -1,
 636756216,
 127932,
 -55817,
 636705613,
 127925,
 -1,
 636897772,
 127929,
 -1,
 636632584,
 127812,
 -1,
 636572068,
 127926,
 -55813,
 636522312,
 983173,
 -55812,
 637177650,
 983210,
 -1,
 637228978,
 983222,
 637413769,
 574780806,
 -1,
 637478589,
 637341377,
 -1,
 637544043,
 637438655,
 -1,
 637609538,
 637488713,
 -1,
 637675016,
 637569968,
 -1,
 637740551,
 637623645,
 -1,
 637806085,
 637693282,
 43144,
 -1,
 637758818,
 43145,
 637992959,
 637750082,
 43146,
 -1,
 637881154,
 43147,
 -1,
 637669057,
 43182,
 638133774,
 637632021,
 -1,
 638199308,
 638090773,
 -1,
 -55797,
 638138552,
 43165,
 -1,
 638193345,
 43164,
 -55795,
 638138552,
 43170,
 -1,
 638324417,
 43169,
 638526995,
 638081125,
 -1,
 -55792,
 638489713,
 43163,
 -55791,
 638539963,
 43168,
 -55790,
 638596355,
 43158,
 -1,
 638652097,
 43173,
 638854681,
 638460629,
 -1,
 638920215,
 638788309,
 -1,
 -55786,
 638859448,
 43167,
 -1,
 638914241,
 43166,
 -55784,
 638859448,
 43172,
 -1,
 639045313,
 43171,
 639247901,
 638783169,
 43138,
 -55781,
 639206951,
 43153,
 -55780,
 639254118,
 43150,
 -1,
 639307457,
 43139,
 639510049,
 639202694,
 -1,
 -55777,
 639464922,
 43184,
 -55776,
 639514808,
 43183,
 -1,
 639569601,
 43185,
 639772195,
 639469095,
 43142,
 -1,
 639731239,
 43143,
 639903270,
 639723259,
 -1,
 -55771,
 639842488,
 43175,
 -1,
 639897281,
 43174,
 640099880,
 639851743,
 43151,
 -1,
 640048351,
 43152,
 640230955,
 640043842,
 -1,
 -55766,
 640174960,
 43187,
 -1,
 640224961,
 43181,
 640427566,
 640174141,
 -1,
 -55763,
 640366776,
 43155,
 -1,
 640421569,
 43154,
 640624177,
 640370487,
 -1,
 -55760,
 640563384,
 43162,
 -1,
 640618177,
 43161,
 640820787,
 640564838,
 43140,
 -1,
 640761446,
 43141,
 640951862,
 640758993,
 -1,
 -55755,
 640891064,
 43157,
 -1,
 640945857,
 43156,
 641148472,
 640886914,
 43148,
 -1,
 641083522,
 43149,
 641279547,
 641080269,
 -1,
 -55750,
 641218744,
 43160,
 -1,
 641273537,
 43159,
 641476158,
 641210364,
 -1,
 -55747,
 641415352,
 43177,
 -1,
 641470145,
 43176,
 -55745,
 641438833,
 43179,
 -55744,
 641625536,
 43180,
 -55743,
 641684085,
 43178,
 -1,
 641743032,
 43186,
 641934932,
 637570775,
 -1,
 642000456,
 641895985,
 -1,
 642065990,
 641953122,
 43194,
 -1,
 642018658,
 43195,
 642252799,
 642009922,
 43196,
 -1,
 642140994,
 43197,
 642328140,
 641928897,
 -1,
 -55734,
 642287143,
 43203,
 -55733,
 642334310,
 43200,
 -1,
 642387649,
 43189,
 642590286,
 642287143,
 43192,
 -1,
 642549287,
 43193,
 642721360,
 642538719,
 43201,
 -1,
 642669791,
 43202,
 642852434,
 642661990,
 43190,
 -1,
 642793062,
 43191,
 643039231,
 642787458,
 43198,
 -1,
 642918530,
 43199,
 643114597,
 641868501,
 -1,
 643180131,
 643055892,
 -1,
 643245657,
 643137045,
 -1,
 -55720,
 643207790,
 43218,
 -1,
 643251557,
 43219,
 643442268,
 643200390,
 -1,
 -55717,
 643385056,
 43222,
 -1,
 643444615,
 43223,
 643638879,
 643379550,
 -1,
 -55714,
 643589234,
 43220,
 -1,
 643647119,
 43221,
 -55712,
 643602093,
 43216,
 -55711,
 643784694,
 43217,
 -55710,
 643848855,
 43225,
 -1,
 643902268,
 43224,
 -55708,
 643130387,
 43215,
 -1,
 644027305,
 43214,
 644228714,
 643070089,
 -1,
 644294249,
 644189648,
 -1,
 -55704,
 644249139,
 43137,
 -1,
 644312744,
 43204,
 -1,
 644224099,
 43136,
 -1,
 644161711,
 43188,
 644622009,
 637490147,
 -1,
 644687495,
 644566601,
 -1,
 644753009,
 644644373,
 -1,
 -55697,
 644707814,
 2065,
 -55696,
 644761070,
 2056,
 -1,
 644812605,
 2069,
 645015157,
 644693606,
 -1,
 -55693,
 644977711,
 2052,
 -55692,
 645037589,
 2055,
 -1,
 645093477,
 2063,
 645277304,
 644969862,
 -1,
 -55689,
 645219157,
 2062,
 -1,
 645282132,
 2068,
 645473915,
 645208060,
 -1,
 -55686,
 645416430,
 2049,
 -1,
 645467962,
 2053,
 -55684,
 645437075,
 2054,
 -55683,
 645633543,
 2057,
 -55682,
 645690237,
 2067,
 -55681,
 645754165,
 2066,
 -55680,
 645815386,
 2061,
 -55679,
 645879406,
 2060,
 -55678,
 645942153,
 2059,
 -55677,
 646006963,
 2058,
 -55676,
 646067535,
 2050,
 -55675,
 646132397,
 2064,
 -55674,
 646194041,
 2051,
 -1,
 646255177,
 2048,
 646456985,
 644648663,
 -1,
 646522510,
 646402193,
 -1,
 646588043,
 646450881,
 2082,
 -1,
 646516417,
 2079,
 -55668,
 646546983,
 2086,
 -55667,
 646659686,
 2089,
 -1,
 646719618,
 2076,
 646915729,
 646470879,
 2091,
 647036927,
 646876433,
 2081,
 -1,
 646909633,
 2078,
 647112340,
 646870406,
 -1,
 -55661,
 647071804,
 2092,
 -1,
 647118103,
 2085,
 647308950,
 647040705,
 2083,
 -1,
 647237313,
 2080,
 -55657,
 647267879,
 2087,
 -55656,
 647380582,
 2090,
 -1,
 647440514,
 2077,
 647636652,
 646409152,
 -1,
 647702177,
 647564993,
 -1,
 647767710,
 647649381,
 -1,
 -55651,
 647715025,
 2110,
 -1,
 647771689,
 2098,
 -55649,
 647725768,
 2100,
 -55648,
 647918517,
 2108,
 -1,
 647967859,
 2097,
 648160932,
 647665167,
 -1,
 -55645,
 648103186,
 2104,
 -1,
 648155274,
 2106,
 648357543,
 648115590,
 -1,
 -55642,
 648306157,
 2109,
 -1,
 648363038,
 2101,
 -55640,
 648316238,
 2107,
 -55639,
 648506461,
 2105,
 -55638,
 648567281,
 2096,
 -55637,
 648631655,
 2103,
 -1,
 648681716,
 2099,
 648881848,
 647582236,
 -1,
 648947380,
 648811854,
 -1,
 649012912,
 648888808,
 2070,
 -1,
 648940006,
 2071,
 -55631,
 648961381,
 2072,
 -55630,
 649091569,
 2093,
 -55629,
 649145651,
 2075,
 -1,
 649208663,
 2073,
 649461759,
 648895943,
 -1,
 -55626,
 649361463,
 2084,
 -55625,
 649412198,
 2088,
 -1,
 649473331,
 2074,
 -1,
 648810357,
 2102,
 -55622,
 644584460,
 127927,
 -55621,
 649691138,
 128225,
 -55620,
 649742725,
 127862,
 -1,
 649806181,
 9973,
 649996156,
 637417634,
 -1,
 650061680,
 649924289,
 -1,
 650127151,
 650014195,
 -1,
 650192640,
 650071625,
 -1,
 650258120,
 650152880,
 -1,
 650323655,
 650206557,
 -1,
 650389189,
 650276194,
 70025,
 -1,
 650341730,
 70026,
 650575871,
 650332994,
 70027,
 -1,
 650464066,
 70028,
 -1,
 650251969,
 70062,
 650716878,
 650214933,
 -1,
 650782412,
 650673685,
 -1,
 -55605,
 650721464,
 70044,
 -1,
 650776257,
 70043,
 -55603,
 650721464,
 70049,
 -1,
 650907329,
 70048,
 651110099,
 650664037,
 -1,
 -55600,
 651072625,
 70042,
 -55599,
 651122875,
 70047,
 -55598,
 651179267,
 70037,
 -1,
 651235009,
 70052,
 651437785,
 651043541,
 -1,
 651503319,
 651371221,
 -1,
 -55594,
 651442360,
 70046,
 -1,
 651497153,
 70045,
 -55592,
 651442360,
 70051,
 -1,
 651628225,
 70050,
 651831005,
 651366081,
 70019,
 -55589,
 651789863,
 70032,
 -55588,
 651837030,
 70030,
 -1,
 651890369,
 70020,
 652093153,
 651785606,
 -1,
 -55585,
 652047834,
 70064,
 -55584,
 652097720,
 70063,
 -1,
 652152513,
 70065,
 652355299,
 652052007,
 70023,
 -1,
 652314151,
 70024,
 652486374,
 652306171,
 -1,
 -55579,
 652425400,
 70054,
 -1,
 652480193,
 70053,
 652682985,
 652430146,
 -1,
 -55576,
 652626800,
 70061,
 -1,
 652676801,
 70060,
 652879596,
 652625981,
 -1,
 -55573,
 652818616,
 70034,
 -1,
 652873409,
 70033,
 653076207,
 652822327,
 -1,
 -55570,
 653015224,
 70041,
 -1,
 653070017,
 70040,
 653272817,
 653016678,
 70021,
 -1,
 653213286,
 70022,
 653403892,
 653210833,
 -1,
 -55565,
 653342904,
 70036,
 -1,
 653397697,
 70035,
 653600503,
 653335501,
 -1,
 -55562,
 653539512,
 70039,
 -1,
 653594305,
 70038,
 653797114,
 653531132,
 -1,
 -55559,
 653736120,
 70056,
 -1,
 653790913,
 70055,
 -55557,
 653759601,
 70058,
 -55556,
 653946304,
 70059,
 -55555,
 654007519,
 70031,
 -55554,
 654070389,
 70057,
 -55553,
 654129336,
 70066,
 -1,
 654190722,
 70029,
 654386960,
 650153687,
 -1,
 654452486,
 654347825,
 -1,
 654518020,
 654404962,
 70072,
 -1,
 654470498,
 70073,
 654704639,
 654461762,
 70074,
 -1,
 654592834,
 70075,
 654780170,
 654380737,
 -1,
 -55544,
 654738983,
 70079,
 -55543,
 654786150,
 70077,
 -1,
 654839489,
 70067,
 655042316,
 654738983,
 70070,
 -1,
 655001127,
 70071,
 655173390,
 654982758,
 70068,
 -1,
 655113830,
 70069,
 -55537,
 655121631,
 70078,
 -1,
 655239298,
 70076,
 655435553,
 654320341,
 -1,
 655501087,
 655376660,
 -1,
 655566613,
 655457813,
 -1,
 -55532,
 655528558,
 70098,
 -1,
 655572325,
 70099,
 655763224,
 655521158,
 -1,
 -55529,
 655705824,
 70102,
 -1,
 655765383,
 70103,
 655959835,
 655700318,
 -1,
 -55526,
 655910002,
 70100,
 -1,
 655967887,
 70101,
 -55524,
 655922861,
 70096,
 -55523,
 656105462,
 70097,
 -55522,
 656169623,
 70105,
 -1,
 656223036,
 70104,
 -55520,
 655451155,
 70086,
 -1,
 656348073,
 70085,
 656549677,
 655390086,
 -1,
 656615212,
 656490788,
 -1,
 656680742,
 656575952,
 -1,
 -55515,
 656635443,
 70018,
 -1,
 656699048,
 70080,
 656877353,
 656608961,
 -1,
 -55512,
 656837577,
 70081,
 -1,
 656890979,
 70017,
 -55510,
 656837184,
 70083,
 -55509,
 657016780,
 70082,
 -1,
 657071202,
 70016,
 -1,
 656551204,
 70088,
 -55506,
 656498506,
 70084,
 -1,
 657264519,
 70087,
 657467247,
 650087344,
 -1,
 657532782,
 657407733,
 -1,
 657598267,
 657460929,
 -1,
 657663797,
 657550690,
 -1,
 -55500,
 657616685,
 66684,
 -1,
 657664130,
 66680,
 -55498,
 657625125,
 66679,
 -55497,
 657815325,
 66664,
 -55496,
 657868055,
 66682,
 -55495,
 657930402,
 66669,
 -55494,
 657995263,
 66673,
 -1,
 658056587,
 66665,
 658253634,
 657546463,
 -1,
 -55491,
 658213750,
 66668,
 -55490,
 658271586,
 66681,
 -55489,
 658335479,
 66677,
 -55488,
 658397285,
 66666,
 -55487,
 658456920,
 66678,
 -1,
 658510334,
 66676,
 658712392,
 658188418,
 -1,
 658777926,
 658640577,
 -1,
 -55483,
 658734613,
 66672,
 -1,
 658795874,
 66685,
 -55481,
 658732177,
 66683,
 -1,
 658912897,
 66663,
 659105613,
 658669077,
 -1,
 659171148,
 659044514,
 -1,
 -55477,
 659112133,
 66644,
 -1,
 659173719,
 66654,
 -1,
 659120978,
 66641,
 659433297,
 659045990,
 -1,
 -55473,
 659370334,
 66662,
 -55472,
 659430755,
 66674,
 -1,
 659493678,
 66686,
 659695444,
 659395797,
 -1,
 -55469,
 659656520,
 66687,
 -1,
 659689153,
 66648,
 659892055,
 659657326,
 -1,
 -55466,
 659840713,
 66667,
 -1,
 659892354,
 66658,
 660088666,
 659846534,
 -1,
 -55463,
 660048609,
 66646,
 -1,
 660102367,
 66645,
 660285277,
 660034076,
 -1,
 -55460,
 660226468,
 66661,
 -1,
 660285914,
 66656,
 660481888,
 660224162,
 -1,
 -55457,
 660441415,
 66649,
 -1,
 660475678,
 66659,
 -55455,
 660444977,
 66655,
 -55454,
 660639396,
 66653,
 -55453,
 660703663,
 66675,
 -55452,
 660763647,
 66670,
 -55451,
 660826161,
 66640,
 -55450,
 660888666,
 66671,
 -55449,
 660951166,
 66660,
 -55448,
 661015091,
 66642,
 -55447,
 661080092,
 66657,
 -55446,
 661140797,
 66652,
 -55445,
 661205559,
 66643,
 -55444,
 661267425,
 66651,
 -55443,
 661331590,
 66647,
 -1,
 661395897,
 66650,
 -1,
 657467967,
 127847,
 -1,
 657414054,
 9752,
 661727094,
 650002022,
 -1,
 661792628,
 661664892,
 -1,
 -55437,
 661742819,
 983075,
 -1,
 661799400,
 983078,
 -55435,
 661743355,
 128674,
 -1,
 661937153,
 9961,
 662120314,
 661675231,
 -1,
 -55432,
 662081604,
 128703,
 -55431,
 662140103,
 127856,
 -1,
 662201273,
 127776,
 -55429,
 662082607,
 983197,
 -1,
 662317749,
 128017,
 662513674,
 649948332,
 -1,
 662579187,
 662446807,
 -1,
 662644667,
 662510541,
 -1,
 662710201,
 662587360,
 -1,
 662775700,
 662637936,
 -1,
 662841221,
 662703155,
 -1,
 -55421,
 662769228,
 127545,
 -55420,
 662834538,
 127516,
 -1,
 662899757,
 127520,
 663103368,
 662769290,
 -1,
 -55417,
 663030976,
 127511,
 -1,
 663096362,
 127509,
 663299979,
 663031090,
 -1,
 -55414,
 663227695,
 127525,
 -1,
 663292825,
 127540,
 663496590,
 663227594,
 -1,
 -55411,
 663433652,
 127534,
 -1,
 663493956,
 127506,
 -55409,
 663433655,
 127517,
 -55408,
 663626717,
 127532,
 -55407,
 663689254,
 127505,
 -55406,
 663752326,
 127524,
 -55405,
 663817689,
 127546,
 -1,
 663882790,
 127518,
 664086437,
 662703581,
 -1,
 664151961,
 664013875,
 -1,
 -55401,
 664080051,
 127527,
 -55400,
 664145347,
 127537,
 -1,
 664210791,
 127504,
 664414108,
 664079945,
 -1,
 -55397,
 664342154,
 127542,
 -1,
 664407638,
 127543,
 664610719,
 664341872,
 -1,
 -55394,
 664541195,
 127519,
 -1,
 664604346,
 127515,
 664807330,
 664538314,
 -1,
 -55391,
 664735174,
 127528,
 -1,
 664800150,
 127535,
 -55389,
 664744368,
 127526,
 -55388,
 664938866,
 127541,
 -1,
 664997391,
 127513,
 665200557,
 664014359,
 -1,
 665266089,
 665128304,
 -1,
 -55384,
 665193769,
 127544,
 -1,
 665259056,
 127522,
 -55382,
 665199402,
 127521,
 -55381,
 665390902,
 127539,
 -55380,
 665456310,
 127538,
 -1,
 665521176,
 127514,
 665724852,
 665128301,
 -1,
 665790385,
 665652000,
 -1,
 -55376,
 665718410,
 127530,
 -1,
 665783072,
 127529,
 -55374,
 665718579,
 127512,
 -55373,
 665915011,
 127508,
 -1,
 665980099,
 127533,
 666183608,
 665652822,
 -1,
 -55370,
 666116910,
 127536,
 -55369,
 666180588,
 127523,
 -1,
 666242749,
 127510,
 -1,
 666111662,
 127531,
 -55366,
 662659354,
 127378,
 -1,
 666454850,
 127377,
 666642394,
 662588226,
 -1,
 666707927,
 666572537,
 -1,
 -55362,
 666670607,
 127305,
 -55361,
 666735663,
 127304,
 -55360,
 666801019,
 127303,
 -55359,
 666865480,
 127302,
 -55358,
 666930096,
 127301,
 -55357,
 666994215,
 127300,
 -55356,
 667057685,
 127299,
 -55355,
 667121030,
 127298,
 -55354,
 667184482,
 127297,
 -55353,
 667249695,
 127296,
 -55352,
 667313915,
 127295,
 -55351,
 667376863,
 127294,
 -55350,
 667441253,
 127293,
 -55349,
 667505180,
 127292,
 -55348,
 667568962,
 127291,
 -55347,
 667633725,
 127290,
 -55346,
 667698999,
 127289,
 -55345,
 667762278,
 127288,
 -55344,
 667826338,
 127287,
 -55343,
 667890897,
 127286,
 -55342,
 667955550,
 127285,
 -55341,
 668018818,
 127284,
 -55340,
 668082901,
 127283,
 -55339,
 668146637,
 127282,
 -55338,
 668211196,
 127281,
 -1,
 668274369,
 127280,
 668532735,
 666656280,
 -1,
 -55335,
 668426843,
 10191,
 -1,
 668472142,
 10190,
 668674015,
 666596742,
 -1,
 -55332,
 668628358,
 127309,
 -55331,
 668689199,
 127384,
 -55330,
 668738261,
 127308,
 -1,
 668799734,
 9949,
 669001701,
 668616765,
 -1,
 669067236,
 668931705,
 -1,
 -55326,
 669021658,
 127490,
 -55325,
 669076130,
 127489,
 -1,
 669131738,
 127507,
 -1,
 669004119,
 9919,
 669394920,
 668948581,
 -1,
 -55321,
 669332689,
 127382,
 -1,
 669397047,
 127381,
 669591531,
 669331806,
 -1,
 -55318,
 669544490,
 127379,
 -1,
 669607045,
 11820,
 -55316,
 669552669,
 127311,
 -55315,
 669749042,
 127386,
 -55314,
 669813259,
 127385,
 -55313,
 669870837,
 127310,
 -55312,
 669933210,
 127383,
 -55311,
 669997117,
 127307,
 -55310,
 670056385,
 127380,
 -1,
 670121542,
 127306,
 670367743,
 662503424,
 -1,
 670377977,
 670273895,
 -1,
 -55306,
 670337626,
 11028,
 -55305,
 670401312,
 11026,
 -55304,
 670454073,
 11029,
 -1,
 670505688,
 11027,
 670705663,
 670311125,
 -1,
 670771198,
 670650908,
 13175,
 670892031,
 670695424,
 -1,
 -55299,
 670792568,
 13176,
 -1,
 670835289,
 13177,
 -1,
 670713655,
 127376,
 671098882,
 670644386,
 -1,
 -55295,
 671040794,
 127488,
 -1,
 671102161,
 13004,
 671295493,
 671033474,
 -1,
 -55292,
 671255472,
 13006,
 -1,
 671314183,
 13005,
 -55290,
 671255474,
 13278,
 -55289,
 671434380,
 13178,
 -55288,
 671495493,
 13311,
 -55287,
 671560713,
 9974,
 -1,
 671616724,
 13279,
 671819899,
 662472231,
 -1,
 671885428,
 671766629,
 -1,
 671950957,
 671818651,
 -1,
 672016443,
 671895113,
 -1,
 672081938,
 671963237,
 -1,
 -55280,
 672044145,
 7057,
 -55279,
 672085251,
 7053,
 -1,
 672140993,
 7060,
 672344087,
 672018782,
 -1,
 672409622,
 672285181,
 -1,
 -55275,
 672354844,
 7103,
 -1,
 672417853,
 7102,
 -1,
 672337601,
 7062,
 672671770,
 672298374,
 -1,
 -55271,
 672633969,
 7087,
 -1,
 672665281,
 7070,
 672868381,
 672623970,
 -1,
 -55268,
 672804590,
 7099,
 -1,
 672861889,
 7067,
 673064992,
 672811842,
 -1,
 -55265,
 673001198,
 7100,
 -1,
 673058497,
 7068,
 673261603,
 673007677,
 -1,
 -55262,
 673200312,
 7086,
 -1,
 673255105,
 7050,
 673458213,
 673196162,
 7048,
 -1,
 673416743,
 7049,
 673589288,
 673388540,
 -1,
 -55257,
 673527992,
 7101,
 -1,
 673582785,
 7064,
 673785898,
 673517249,
 7043,
 -1,
 673720450,
 7046,
 -55253,
 673748511,
 7056,
 -55252,
 673879153,
 7066,
 -55251,
 673944518,
 7071,
 -55250,
 674008975,
 7069,
 -55249,
 674073542,
 7063,
 -55248,
 674137639,
 7045,
 -55247,
 674201227,
 7058,
 -55246,
 674262061,
 7051,
 -55245,
 674326330,
 7061,
 -55244,
 674389215,
 7047,
 -55243,
 674452085,
 7065,
 -55242,
 674514773,
 7055,
 -55241,
 674578022,
 7044,
 -55240,
 674642104,
 7072,
 -55239,
 674706691,
 7052,
 -55238,
 674767666,
 7059,
 -1,
 674831337,
 7054,
 675031113,
 671950071,
 -1,
 675096639,
 674987541,
 -1,
 -55234,
 675058286,
 7090,
 -1,
 675102053,
 7091,
 675293250,
 675050886,
 -1,
 -55231,
 675235552,
 7094,
 -1,
 675295111,
 7095,
 675489861,
 675230046,
 -1,
 -55228,
 675439730,
 7092,
 -1,
 675497615,
 7093,
 -55226,
 675452589,
 7088,
 -55225,
 675635190,
 7089,
 -55224,
 675699351,
 7097,
 -1,
 675752764,
 7096,
 675948627,
 674982861,
 -1,
 676014157,
 675899131,
 -1,
 -55220,
 675973888,
 7362,
 -1,
 676008960,
 7361,
 -55218,
 675970435,
 7360,
 -55217,
 676155041,
 7364,
 -55216,
 676219026,
 7365,
 -55215,
 676275012,
 7366,
 -55214,
 676338704,
 7363,
 -1,
 676403252,
 7367,
 676603995,
 675909347,
 -1,
 676669530,
 676550757,
 -1,
 -55210,
 676632066,
 7077,
 -55209,
 676683574,
 7079,
 -55208,
 676738825,
 7076,
 -55207,
 676802339,
 7081,
 -1,
 676860046,
 7078,
 -1,
 676615595,
 7080,
 677128292,
 676558985,
 -1,
 677193827,
 677078842,
 -1,
 677259362,
 677140581,
 -1,
 677324897,
 677197009,
 -1,
 -55200,
 677286230,
 7042,
 -1,
 677334172,
 7041,
 -1,
 677287138,
 7040,
 -1,
 677204604,
 7082,
 -1,
 677154290,
 7083,
 677718124,
 677060804,
 -1,
 677783656,
 677672491,
 -1,
 -55193,
 677744527,
 7085,
 -1,
 677794421,
 7084,
 677980267,
 677731467,
 -1,
 -55190,
 677921108,
 7075,
 -1,
 677974553,
 7074,
 -1,
 677926536,
 7073,
 -1,
 677648234,
 7098,
 678307951,
 671904625,
 127749,
 -1,
 678233170,
 127748,
 678439026,
 678232064,
 -1,
 -55183,
 678400375,
 127774,
 -1,
 678435132,
 9925,
 -55181,
 678393602,
 127751,
 -1,
 678572938,
 127803,
 678766711,
 671839622,
 -1,
 -55178,
 678717540,
 128671,
 -1,
 678771434,
 127843,
 678963321,
 678696956,
 983102,
 -1,
 678919279,
 983101,
 -55174,
 678916354,
 127940,
 -1,
 679045310,
 10185,
 679225542,
 671781935,
 -1,
 679291064,
 679170281,
 -1,
 679356585,
 679235145,
 -1,
 679422084,
 679312917,
 -1,
 679487618,
 679378453,
 -1,
 -55167,
 679435487,
 43024,
 -1,
 679492699,
 43025,
 -55165,
 679435487,
 43028,
 -1,
 679623771,
 43029,
 679815306,
 679355093,
 -1,
 679880840,
 679748309,
 -1,
 -55161,
 679828703,
 43026,
 -1,
 679885915,
 43027,
 -55159,
 679828703,
 43030,
 -1,
 680016987,
 43031,
 680208525,
 679767394,
 -1,
 -55156,
 680162285,
 43040,
 -1,
 680221919,
 43038,
 680405136,
 680158971,
 -1,
 -55153,
 680352991,
 43033,
 -1,
 680410203,
 43034,
 680601747,
 680347709,
 -1,
 -55150,
 680549599,
 43015,
 -1,
 680606811,
 43016,
 680798358,
 680544055,
 -1,
 -55147,
 680746207,
 43022,
 -1,
 680803419,
 43023,
 680994969,
 680735953,
 -1,
 -55144,
 680942815,
 43017,
 -1,
 681000027,
 43018,
 681191580,
 680926157,
 -1,
 -55141,
 681139423,
 43020,
 -1,
 681196635,
 43021,
 681388191,
 681121788,
 -1,
 -55138,
 681336031,
 43035,
 -1,
 681393243,
 43036,
 -55136,
 681346599,
 43011,
 -55135,
 681540263,
 43041,
 -55134,
 681598175,
 43013,
 -55133,
 681663263,
 43032,
 -55132,
 681727737,
 43037,
 -55131,
 681791582,
 43039,
 -55130,
 681852518,
 43009,
 -55129,
 681917531,
 43042,
 -55128,
 681977986,
 43012,
 -1,
 682036929,
 43008,
 682240175,
 679317207,
 -1,
 -55125,
 682198567,
 43045,
 -55124,
 682254576,
 43047,
 -55123,
 682311270,
 43044,
 -55122,
 682371202,
 43046,
 -1,
 682430145,
 43043,
 682633396,
 682191369,
 -1,
 -55119,
 682560818,
 43051,
 -55118,
 682626250,
 43050,
 -55117,
 682691635,
 43049,
 -1,
 682757027,
 43048,
 683016191,
 682588297,
 -1,
 -55114,
 682899960,
 43014,
 -55113,
 682960991,
 43010,
 -1,
 683021411,
 43019,
 683223235,
 679244104,
 -1,
 683288770,
 683151318,
 -1,
 683354302,
 683244211,
 -1,
 -55108,
 683317000,
 1869,
 -55107,
 683362831,
 1870,
 -1,
 683422234,
 1871,
 683671551,
 683305175,
 -1,
 -55104,
 683554483,
 1838,
 -55103,
 683615353,
 1839,
 -1,
 683678128,
 1837,
 -1,
 683235915,
 128137,
 683944133,
 683169893,
 983094,
 -1,
 683875946,
 983093,
 -1,
 683889814,
 8527,
 684140799,
 679173343,
 983077,
 684206323,
 684092875,
 -1,
 684271845,
 684150345,
 -1,
 684337357,
 684218469,
 -1,
 -55093,
 684299384,
 69857,
 -55092,
 684340545,
 69847,
 -1,
 684396918,
 69849,
 684599504,
 684282485,
 -1,
 -55089,
 684538018,
 69846,
 -1,
 684599426,
 69864,
 684796115,
 684533890,
 -1,
 -55086,
 684734626,
 69863,
 -1,
 684796679,
 69859,
 -55084,
 684758136,
 69852,
 -55083,
 684952529,
 69850,
 -55082,
 685017101,
 69861,
 -55081,
 685080279,
 69841,
 -55080,
 685143537,
 69840,
 -55079,
 685207071,
 69853,
 -55078,
 685270883,
 69851,
 -55077,
 685334129,
 69862,
 -55076,
 685394944,
 69848,
 -55075,
 685459667,
 69855,
 -55074,
 685524833,
 69856,
 -55073,
 685588800,
 69860,
 -55072,
 685652197,
 69854,
 -55071,
 685716801,
 69845,
 -55070,
 685777765,
 69844,
 -55069,
 685841420,
 69843,
 -55068,
 685906000,
 69842,
 -1,
 685969782,
 69858,
 686227455,
 684205303,
 -1,
 686237929,
 686128661,
 -1,
 -55064,
 686199406,
 69874,
 -1,
 686243173,
 69875,
 686434540,
 686192006,
 -1,
 -55061,
 686376672,
 69878,
 -1,
 686436231,
 69879,
 686631151,
 686371166,
 -1,
 -55058,
 686580850,
 69876,
 -1,
 686638735,
 69877,
 -55056,
 686593709,
 69872,
 -55055,
 686776310,
 69873,
 -55054,
 686840471,
 69881,
 -1,
 686893884,
 69880,
 687089914,
 684166020,
 -1,
 687155447,
 687050824,
 -1,
 -55050,
 687116418,
 11011,
 -1,
 687151653,
 11019,
 687407103,
 687090103,
 -1,
 -55047,
 687313026,
 11010,
 -1,
 687348261,
 11018,
 -55045,
 687043974,
 983181,
 -55044,
 687497165,
 128284,
 -55043,
 687552674,
 983043,
 -55042,
 687617166,
 127846,
 -1,
 687676749,
 9917,
 687876380,
 684097045,
 983189,
 687941903,
 687804097,
 -1,
 688007433,
 687895744,
 -1,
 688072965,
 687961478,
 -1,
 -55036,
 688030781,
 983180,
 -1,
 688073621,
 983132,
 -55034,
 688029863,
 983044,
 -55033,
 688221036,
 983175,
 -55032,
 688273964,
 983042,
 -1,
 688339030,
 983174,
 688531724,
 687963669,
 -1,
 -55029,
 688490476,
 128509,
 -1,
 688538871,
 128649,
 688783359,
 688468573,
 -1,
 -55026,
 688667283,
 9882,
 -1,
 688722126,
 9877,
 688924950,
 687893858,
 -1,
 688990485,
 688852673,
 -1,
 689056020,
 688931017,
 -1,
 -55021,
 689003028,
 9188,
 -1,
 689047064,
 128207,
 -1,
 689016848,
 127827,
 -1,
 688931643,
 983188,
 689383705,
 688859532,
 -1,
 -55016,
 689324710,
 127836,
 -1,
 689373932,
 128642,
 -55014,
 689345403,
 983045,
 -55013,
 689534342,
 983169,
 -1,
 689594937,
 9201,
 689776945,
 687826683,
 983117,
 689842473,
 689711234,
 -1,
 689908005,
 689771006,
 -1,
 689973540,
 689843560,
 128264,
 690094079,
 689899428,
 -1,
 -55006,
 689996173,
 128266,
 -55005,
 690053190,
 128265,
 -1,
 690101288,
 128263,
 -1,
 689900146,
 128586,
 690366760,
 689842306,
 -1,
 -55001,
 690299846,
 128676,
 -1,
 690363820,
 128172,
 -1,
 690322061,
 8375,
 690628910,
 689770177,
 983176,
 690694445,
 690582471,
 -1,
 -54996,
 690635513,
 128150,
 -1,
 690695731,
 10024,
 -1,
 690632392,
 127837,
 -54993,
 690578702,
 128051,
 -54992,
 690900037,
 128166,
 -1,
 690963751,
 128026,
 691153226,
 689721884,
 -1,
 691218757,
 691093094,
 -1,
 691284292,
 691162997,
 -1,
 691349825,
 691220931,
 -1,
 691415354,
 691298708,
 128515,
 691535871,
 691339322,
 -1,
 -54984,
 691438074,
 128518,
 -54983,
 691501696,
 128516,
 -1,
 691544095,
 128517,
 691743038,
 691353762,
 -1,
 -54980,
 691692272,
 128520,
 -54979,
 691743136,
 128525,
 -1,
 691802840,
 128519,
 692060159,
 691697030,
 -1,
 -54976,
 691964257,
 128526,
 -1,
 692016722,
 128522,
 692256767,
 691281141,
 -1,
 -54973,
 692150676,
 128570,
 -1,
 692206149,
 128571,
 -1,
 691237820,
 128527,
 692463945,
 691147452,
 -1,
 -54969,
 692422030,
 68411,
 -54968,
 692478558,
 128312,
 -1,
 692525713,
 128313,
 -1,
 692412078,
 128684,
 692791645,
 691093094,
 983080,
 692857179,
 692738149,
 -1,
 692922710,
 692795258,
 -1,
 692988243,
 692846592,
 -1,
 693053777,
 692942843,
 -1,
 -54960,
 693015150,
 983154,
 -1,
 693058917,
 983157,
 -54958,
 692991963,
 983182,
 -1,
 693181890,
 983184,
 693436415,
 692914917,
 -1,
 -54955,
 693308618,
 983158,
 -1,
 693374003,
 983155,
 693633023,
 692861183,
 -1,
 693643610,
 693529954,
 -1,
 -54951,
 693579053,
 983914,
 -1,
 693637637,
 983913,
 -1,
 693605577,
 983912,
 -54948,
 692818831,
 128303,
 -1,
 693849822,
 128510,
 694036838,
 692725890,
 -1,
 694102369,
 693971074,
 -1,
 -54944,
 694035845,
 127793,
 -1,
 694094450,
 128584,
 -54942,
 694064159,
 9913,
 -54941,
 694255215,
 983168,
 -54940,
 694320027,
 9916,
 -54939,
 694376111,
 9914,
 -1,
 694425195,
 128186,
 694626671,
 693979970,
 -1,
 694692204,
 694561461,
 -1,
 694757739,
 694633121,
 -1,
 -54934,
 694713810,
 128164,
 -1,
 694759870,
 128564,
 -1,
 694719558,
 128554,
 -54931,
 694641493,
 127920,
 -54930,
 694959966,
 127829,
 -1,
 695015288,
 42611,
 695216501,
 694557645,
 -1,
 695282034,
 695155887,
 127979,
 -1,
 695207465,
 127890,
 -54925,
 695235639,
 128220,
 -54924,
 695352934,
 983185,
 -1,
 695407241,
 9878,
 695609724,
 695162981,
 -1,
 695675257,
 695559783,
 -1,
 -54920,
 695620524,
 9924,
 -1,
 695671457,
 127938,
 695926783,
 695602881,
 -1,
 -54917,
 695814530,
 128013,
 -1,
 695877976,
 128012,
 696068480,
 695563654,
 -1,
 -54914,
 695996097,
 983133,
 -54913,
 696061130,
 983159,
 -1,
 696126515,
 983156,
 696330629,
 696010813,
 -1,
 696396164,
 696270438,
 -1,
 -54909,
 696331624,
 9975,
 -1,
 696385658,
 127935,
 -1,
 696354913,
 128128,
 696658312,
 696291144,
 -1,
 -54905,
 696617291,
 8275,
 -1,
 696664542,
 127946,
 -1,
 696595964,
 983183,
 696921231,
 637341377,
 -1,
 696986413,
 696872290,
 -1,
 697051945,
 696913817,
 -1,
 697117475,
 696975360,
 -1,
 697182794,
 697062005,
 -1,
 697248329,
 697139453,
 -1,
 697313720,
 697180885,
 -1,
 697379253,
 697261279,
 -1,
 697444784,
 697337709,
 -1,
 697510296,
 697400853,
 -1,
 697575830,
 697448610,
 -1,
 -54891,
 697510663,
 126646,
 -1,
 697569822,
 126648,
 -54889,
 697510663,
 126645,
 -1,
 697700726,
 126632,
 697903516,
 697464198,
 -1,
 -54886,
 697842291,
 126644,
 -54885,
 697903788,
 126638,
 -1,
 697962574,
 126641,
 698165663,
 697865759,
 -1,
 -54882,
 698106344,
 126630,
 -1,
 698169506,
 126650,
 698362274,
 698098482,
 -1,
 -54879,
 698305346,
 126627,
 -1,
 698360533,
 126649,
 -54877,
 698324204,
 126633,
 -54876,
 698519536,
 126629,
 -54875,
 698576987,
 126643,
 -54874,
 698641461,
 126642,
 -54873,
 698702642,
 126637,
 -54872,
 698766642,
 126636,
 -54871,
 698829836,
 126635,
 -54870,
 698894837,
 126647,
 -54869,
 698959750,
 126626,
 -54868,
 699021541,
 126631,
 -54867,
 699086509,
 126651,
 -54866,
 699150912,
 126640,
 -54865,
 699210030,
 126625,
 -1,
 699273658,
 126639,
 699531263,
 697402049,
 -1,
 -54862,
 699427893,
 126495,
 -54861,
 699489074,
 126493,
 -54860,
 699544128,
 126494,
 -1,
 699603246,
 126492,
 699858943,
 697306817,
 -1,
 -54857,
 699747138,
 126467,
 -1,
 699802325,
 126489,
 700000733,
 697256770,
 -1,
 700066268,
 699949357,
 -1,
 700131776,
 700022293,
 -1,
 700197310,
 700070050,
 -1,
 -54851,
 700132103,
 126614,
 -1,
 700191262,
 126616,
 -54849,
 700132103,
 126613,
 -1,
 700322166,
 126600,
 700524996,
 700085638,
 -1,
 -54846,
 700463731,
 126612,
 -54845,
 700525228,
 126606,
 -1,
 700584014,
 126609,
 700787143,
 700487199,
 -1,
 -54842,
 700727784,
 126598,
 -1,
 700790946,
 126618,
 700983754,
 700725410,
 -1,
 -54839,
 700918535,
 126596,
 -1,
 700977526,
 126599,
 701180365,
 700916530,
 -1,
 -54836,
 701123394,
 126595,
 -1,
 701178581,
 126617,
 701376976,
 701107905,
 -1,
 -54833,
 701320505,
 126592,
 -1,
 701383144,
 126607,
 -54831,
 701338860,
 126601,
 -54830,
 701534192,
 126597,
 -54829,
 701591643,
 126611,
 -54828,
 701656117,
 126610,
 -54827,
 701717298,
 126605,
 -54826,
 701781298,
 126604,
 -54825,
 701844492,
 126603,
 -54824,
 701909493,
 126615,
 -54823,
 701974406,
 126594,
 -54822,
 702035629,
 126619,
 -54821,
 702100032,
 126608,
 -1,
 702159150,
 126593,
 -1,
 699994877,
 126475,
 702425599,
 699954566,
 -1,
 702491132,
 702383084,
 -1,
 702556643,
 702447125,
 -1,
 -54815,
 702495352,
 126582,
 -54814,
 702556935,
 126581,
 -1,
 702615926,
 126568,
 702818791,
 702510470,
 -1,
 -54811,
 702757491,
 126580,
 -54810,
 702818988,
 126574,
 -1,
 702877774,
 126577,
 703080940,
 702751445,
 -1,
 703146475,
 703030212,
 -1,
 -54806,
 703083072,
 126590,
 -1,
 703142190,
 126588,
 -1,
 703074382,
 126585,
 703408623,
 703023165,
 -1,
 -54802,
 703346917,
 126583,
 -1,
 703402240,
 126570,
 703605234,
 703346850,
 -1,
 -54799,
 703539975,
 126564,
 -1,
 703598966,
 126567,
 -54797,
 703567394,
 126586,
 -54796,
 703763692,
 126569,
 -54795,
 703818805,
 126578,
 -54794,
 703879986,
 126573,
 -54793,
 703943986,
 126572,
 -54792,
 704006022,
 126562,
 -54791,
 704067245,
 126587,
 -54790,
 704131648,
 126576,
 -54789,
 704190766,
 126561,
 -1,
 704254394,
 126575,
 -54787,
 702429811,
 126484,
 -54786,
 704391852,
 126478,
 -1,
 704450638,
 126481,
 704653848,
 702366609,
 -1,
 704719364,
 704607622,
 -1,
 -54782,
 704658035,
 126516,
 -54781,
 704719532,
 126510,
 -1,
 704778318,
 126513,
 704981511,
 704675349,
 -1,
 -54778,
 704920184,
 126518,
 -1,
 704981767,
 126517,
 705178122,
 704923709,
 -1,
 -54775,
 705116389,
 126519,
 -1,
 705171712,
 126506,
 705374733,
 705116322,
 -1,
 -54772,
 705309447,
 126500,
 -1,
 705368438,
 126503,
 -54770,
 705336556,
 126505,
 -54769,
 705522741,
 126514,
 -54768,
 705583922,
 126509,
 -54767,
 705647922,
 126508,
 -54766,
 705711116,
 126507,
 -54765,
 705775494,
 126498,
 -54764,
 705836717,
 126523,
 -54763,
 705901120,
 126512,
 -54762,
 705962835,
 126521,
 -54761,
 706025774,
 126497,
 -1,
 706089402,
 126511,
 706292274,
 704609813,
 -1,
 706357806,
 706219713,
 -1,
 706423341,
 706298225,
 -1,
 706488863,
 706377094,
 -1,
 -54755,
 706427507,
 126548,
 -54754,
 706489004,
 126542,
 -1,
 706547790,
 126545,
 706751012,
 706421461,
 -1,
 706816547,
 706700228,
 -1,
 -54750,
 706767925,
 126559,
 -1,
 706829106,
 126557,
 -1,
 706744398,
 126553,
 -54747,
 706712812,
 126537,
 -54746,
 707030069,
 126546,
 -54745,
 707091250,
 126541,
 -54744,
 707152908,
 126539,
 -54743,
 707217909,
 126551,
 -54742,
 707282822,
 126530,
 -54741,
 707344613,
 126535,
 -54740,
 707409581,
 126555,
 -1,
 707465658,
 126543,
 -1,
 706361506,
 126472,
 707734065,
 706295970,
 -1,
 -54736,
 707668743,
 126486,
 -1,
 707727902,
 126488,
 -1,
 707668743,
 126485,
 707996213,
 706254367,
 -1,
 -54732,
 707936744,
 126470,
 -1,
 707999906,
 126490,
 708192824,
 707944881,
 -1,
 -54729,
 708138306,
 126704,
 -1,
 708196585,
 126705,
 708389435,
 708134973,
 -1,
 -54726,
 708327653,
 126487,
 -1,
 708382976,
 126474,
 708586046,
 708316865,
 -1,
 -54723,
 708529465,
 126464,
 -1,
 708592104,
 126479,
 -54721,
 708547820,
 126473,
 -54720,
 708743152,
 126469,
 -54719,
 708800603,
 126483,
 -54718,
 708865077,
 126482,
 -54717,
 708926258,
 126477,
 -54716,
 708990258,
 126476,
 -54715,
 709052294,
 126466,
 -54714,
 709114085,
 126471,
 -54713,
 709179053,
 126491,
 -54712,
 709243456,
 126480,
 -1,
 709302574,
 126465,
 -1,
 697201574,
 1624,
 709569214,
 697125698,
 -1,
 709634749,
 709503106,
 -1,
 709700282,
 709592242,
 -1,
 709765725,
 709636446,
 -1,
 709831256,
 709694916,
 -1,
 709896788,
 709767319,
 -1,
 709962323,
 709852693,
 -1,
 -54702,
 709923445,
 1909,
 -1,
 709967216,
 1910,
 -1,
 709899262,
 1911,
 710224471,
 709852693,
 -1,
 -54698,
 710185616,
 1598,
 -1,
 710229393,
 1599,
 -1,
 710165735,
 1597,
 710541311,
 709765898,
 -1,
 710552156,
 710442517,
 -1,
 -54693,
 710513310,
 1888,
 -1,
 710557140,
 1889,
 -1,
 710485483,
 2212,
 710814312,
 709695794,
 -1,
 710879844,
 710770197,
 -1,
 710945379,
 710819206,
 -1,
 711010914,
 710896220,
 1874,
 -1,
 710934674,
 1875,
 -1,
 710950131,
 1872,
 -1,
 710906540,
 1876,
 711273062,
 710834751,
 1878,
 -1,
 711196870,
 2208,
 -54681,
 711214288,
 1877,
 -1,
 711337451,
 1873,
 711535218,
 710765922,
 -1,
 711600753,
 711469834,
 -1,
 711666285,
 711554438,
 -1,
 -54676,
 711623784,
 1883,
 -1,
 711676739,
 1905,
 -54674,
 711624112,
 1899,
 -54673,
 711807177,
 2218,
 -54672,
 711869671,
 1775,
 -1,
 711932232,
 1900,
 -1,
 711548532,
 2220,
 712190590,
 711477309,
 -1,
 712256123,
 712125222,
 -1,
 712321658,
 712211989,
 -1,
 712387193,
 712260998,
 -1,
 -54665,
 712338012,
 1892,
 -54664,
 712382793,
 1596,
 -1,
 712445872,
 1891,
 -1,
 712348304,
 1595,
 -1,
 712254900,
 1890,
 712835071,
 712183489,
 -1,
 -54659,
 712734745,
 1568,
 -1,
 712782231,
 1919,
 712977034,
 712128674,
 -1,
 713042569,
 712905081,
 -1,
 713108101,
 712997249,
 -1,
 713173636,
 713035457,
 -1,
 -54653,
 713120047,
 1903,
 -1,
 713169650,
 1906,
 -1,
 713103689,
 1902,
 713435784,
 713063957,
 -1,
 -54649,
 713396880,
 1879,
 -1,
 713440724,
 1880,
 -1,
 713371867,
 1916,
 -1,
 712977171,
 1791,
 713763472,
 712930992,
 -1,
 -54644,
 713721264,
 1901,
 -54643,
 713783706,
 1904,
 -54642,
 713835751,
 1918,
 -54641,
 713897003,
 1884,
 -1,
 713961652,
 1917,
 714156697,
 713690817,
 -1,
 714222230,
 714097135,
 -1,
 714287765,
 714183303,
 -1,
 -54636,
 714247574,
 1887,
 -1,
 714280880,
 1885,
 -1,
 714227121,
 1886,
 714604543,
 714165565,
 -1,
 -54632,
 714510965,
 1907,
 -1,
 714554736,
 1908,
 714746528,
 714118384,
 -1,
 714812061,
 714707456,
 -1,
 -54628,
 714750280,
 2216,
 -1,
 714810804,
 2217,
 715063295,
 714741947,
 -1,
 -54625,
 714969717,
 1914,
 -1,
 715013488,
 1915,
 715205285,
 714706932,
 -1,
 715270820,
 715141378,
 -1,
 -54621,
 715231861,
 1912,
 -1,
 715275632,
 1913,
 -1,
 715204145,
 2219,
 715532970,
 715152183,
 -1,
 715598505,
 715487610,
 -1,
 -54616,
 715557808,
 1897,
 -1,
 715620055,
 1896,
 -1,
 715556223,
 1895,
 715860655,
 715478327,
 -1,
 715926190,
 715793839,
 -1,
 -54611,
 715856201,
 1894,
 -1,
 715919280,
 1893,
 -1,
 715882861,
 2215,
 716188340,
 715793263,
 -1,
 716253875,
 716129354,
 -1,
 -54606,
 716213168,
 1774,
 -1,
 716274261,
 1882,
 -1,
 716211658,
 1881,
 716516023,
 716131344,
 -1,
 -54602,
 716449452,
 2214,
 -1,
 716511369,
 1898,
 -54600,
 716472027,
 2211,
 -54599,
 716663865,
 2213,
 -1,
 716720011,
 2210,
 716963839,
 709637248,
 -1,
 -54596,
 716839241,
 2297,
 -1,
 716902320,
 2295,
 -1,
 709574804,
 65021,
 717171439,
 709522822,
 -1,
 717236953,
 717133159,
 -1,
 717302477,
 717192725,
 -1,
 717368007,
 717263495,
 -1,
 717433541,
 717327754,
 -1,
 -54588,
 717363529,
 64446,
 -1,
 717426608,
 64445,
 -54586,
 717363529,
 64437,
 -1,
 717557680,
 64436,
 717815807,
 717307270,
 -1,
 717826763,
 717711918,
 -1,
 -54582,
 717756745,
 64441,
 -1,
 717819824,
 64440,
 -54580,
 717756745,
 64439,
 -1,
 717950896,
 64438,
 718154450,
 717235595,
 -1,
 718219985,
 718110231,
 -1,
 -54576,
 718149961,
 64435,
 -1,
 718213040,
 64434,
 -1,
 718178133,
 64444,
 718482133,
 718109236,
 -1,
 -54572,
 718412105,
 64449,
 -1,
 718475184,
 64448,
 718678744,
 718418976,
 -1,
 -54569,
 718608713,
 64443,
 -1,
 718671792,
 64442,
 -1,
 718631654,
 64447,
 718940901,
 717177124,
 -1,
 719006431,
 718894554,
 -1,
 -54564,
 718952669,
 1537,
 -54563,
 719018048,
 1540,
 -54562,
 719081454,
 1552,
 -1,
 719139497,
 1539,
 719334114,
 718958016,
 -1,
 -54559,
 719273034,
 1554,
 -1,
 719332488,
 1555,
 -54557,
 719290133,
 1556,
 -54556,
 719476409,
 1551,
 -1,
 719524435,
 1553,
 719727342,
 718885686,
 -1,
 719792875,
 719665996,
 -1,
 -54552,
 719754794,
 1559,
 -54551,
 719818736,
 2291,
 -54550,
 719879895,
 1557,
 -1,
 719933189,
 1558,
 -54548,
 719735087,
 1562,
 -54547,
 720056835,
 1560,
 -1,
 720118662,
 1561,
 -1,
 719685498,
 1622,
 720382715,
 717127189,
 -1,
 720448250,
 720330746,
 -1,
 720513780,
 720405877,
 -1,
 -54541,
 720443721,
 2286,
 -1,
 720506800,
 2283,
 720710391,
 720461833,
 -1,
 -54538,
 720640329,
 2285,
 -1,
 720703408,
 2282,
 720961535,
 720654542,
 -1,
 -54535,
 720836937,
 2287,
 -1,
 720900016,
 2284,
 -1,
 720401217,
 1566,
 721169154,
 720315021,
 -1,
 721234686,
 721111343,
 2278,
 -1,
 721190744,
 2281,
 721365760,
 721170947,
 2276,
 -1,
 721321816,
 2279,
 721551359,
 721298310,
 2277,
 -1,
 721452888,
 2280,
 721627913,
 721120610,
 -1,
 721693447,
 721567956,
 -1,
 721758982,
 721620912,
 2296,
 -1,
 721684566,
 2301,
 -1,
 721688905,
 2298,
 -54520,
 721629187,
 1629,
 -1,
 721885129,
 1544,
 722086671,
 721563998,
 -1,
 722152206,
 722015902,
 -1,
 -54516,
 722109804,
 1630,
 -54515,
 722170598,
 2292,
 -1,
 722216372,
 2293,
 -1,
 722100532,
 1538,
 722479893,
 722019029,
 -1,
 722545426,
 722428977,
 2299,
 -1,
 722470998,
 2300,
 722731007,
 722472641,
 -1,
 -54508,
 722632612,
 1549,
 -1,
 722687691,
 2302,
 722873113,
 722439895,
 -1,
 -54505,
 722827847,
 1626,
 -54504,
 722879673,
 1627,
 -1,
 722937313,
 1628,
 723135261,
 722821477,
 -1,
 -54501,
 723077450,
 2290,
 -54500,
 723137033,
 2288,
 -1,
 723198860,
 2289,
 -54498,
 723097400,
 1625,
 -54497,
 723357663,
 1631,
 -54496,
 723413495,
 1550,
 -54495,
 723475503,
 1536,
 -54494,
 723536181,
 2294,
 -1,
 723600510,
 1623,
 723845119,
 697043530,
 -1,
 723856167,
 723740823,
 -1,
 -54490,
 723812390,
 1546,
 -1,
 723867230,
 1545,
 -54488,
 723792955,
 1543,
 -1,
 723984975,
 1542,
 724183852,
 697008594,
 -1,
 -54485,
 724139009,
 127912,
 -1,
 724181607,
 128667,
 -1,
 724129178,
 1423,
 724446167,
 696929090,
 -1,
 724511697,
 724377114,
 -1,
 724577096,
 724465030,
 -1,
 724642618,
 724534823,
 -1,
 724708153,
 724572804,
 -1,
 724773688,
 724642012,
 -1,
 724839222,
 724727314,
 -1,
 -54475,
 724771030,
 128807,
 -1,
 724833361,
 128814,
 -54473,
 724771030,
 128802,
 -1,
 724964433,
 128812,
 -1,
 724714743,
 128862,
 -1,
 724651730,
 128781,
 725297984,
 724570654,
 -1,
 725363519,
 725253653,
 128788,
 725483519,
 725287799,
 -1,
 -54466,
 725360861,
 128806,
 -1,
 725423185,
 128813,
 -1,
 725289452,
 128825,
 725691204,
 725253653,
 -1,
 725756739,
 725643024,
 128860,
 -1,
 725682659,
 128861,
 -1,
 725685654,
 128850,
 -54459,
 725641567,
 128839,
 -54458,
 725900566,
 128852,
 -54457,
 725959048,
 128795,
 -1,
 726015369,
 128847,
 726215515,
 724504257,
 -1,
 726281040,
 726166647,
 -1,
 726346575,
 726204416,
 -1,
 726412109,
 726306321,
 128776,
 -1,
 726338019,
 128777,
 726597631,
 726364245,
 128774,
 -1,
 726469091,
 128775,
 -1,
 726283242,
 128773,
 726739797,
 726223682,
 -1,
 726805331,
 726681839,
 128822,
 -1,
 726731235,
 128823,
 -54444,
 726763653,
 128837,
 -1,
 726870999,
 128874,
 -54442,
 726698731,
 128829,
 -54441,
 727021538,
 128855,
 -54440,
 727086255,
 128826,
 -54439,
 727145439,
 128811,
 -54438,
 727208751,
 128859,
 -1,
 727270679,
 128769,
 727460719,
 726145997,
 -1,
 727526247,
 727412066,
 -1,
 727591779,
 727484339,
 128869,
 727711743,
 727517662,
 -1,
 -54432,
 727584112,
 128873,
 -54431,
 727649586,
 128872,
 -54430,
 727715018,
 128871,
 -1,
 727780403,
 128870,
 728039423,
 727539096,
 -1,
 728050534,
 727916758,
 128803,
 -1,
 727976419,
 128804,
 -1,
 727991636,
 128798,
 728247147,
 727453377,
 -1,
 -54423,
 728198143,
 128846,
 -54422,
 728257033,
 128844,
 -1,
 728311842,
 128848,
 728509294,
 728195546,
 -1,
 -54419,
 728457871,
 128800,
 -1,
 728503365,
 128805,
 -1,
 728449989,
 128787,
 728771455,
 727412066,
 -1,
 728836989,
 728705154,
 -1,
 728902522,
 728774769,
 128818,
 728968054,
 728828382,
 -1,
 -54412,
 728894770,
 128821,
 -54411,
 728960202,
 128820,
 -1,
 729025587,
 128819,
 729284607,
 728892279,
 -1,
 729295737,
 729158737,
 128816,
 -1,
 729221603,
 128817,
 -1,
 729236820,
 128799,
 729492348,
 728830636,
 128827,
 -1,
 729418211,
 128828,
 -1,
 729449279,
 128877,
 729743359,
 728784246,
 128792,
 -1,
 729614819,
 128793,
 729820042,
 728700924,
 -1,
 729885572,
 729768557,
 128834,
 730005503,
 729811422,
 -1,
 -54397,
 729877706,
 128836,
 -1,
 729943091,
 128835,
 730147719,
 729814678,
 -1,
 -54394,
 730106857,
 128876,
 -1,
 730158129,
 128875,
 -54392,
 730100105,
 128857,
 -54391,
 730287014,
 128783,
 -1,
 730351030,
 128830,
 730540948,
 729779120,
 -1,
 730606483,
 730480230,
 -1,
 730672017,
 730552757,
 128778,
 730737552,
 730597854,
 -1,
 -54385,
 730664138,
 128780,
 -1,
 730729523,
 128779,
 -1,
 730661756,
 128815,
 731054079,
 730629187,
 128790,
 -1,
 730925539,
 128791,
 -1,
 730541497,
 128808,
 731196318,
 730490619,
 -1,
 731261849,
 731143391,
 -1,
 731327384,
 731222048,
 128843,
 -1,
 731261494,
 128858,
 -1,
 731282981,
 128856,
 731523996,
 731219495,
 -1,
 -54373,
 731481046,
 128868,
 -1,
 731541966,
 128867,
 -54371,
 731475935,
 128863,
 -1,
 731659181,
 128782,
 731851686,
 731151893,
 -1,
 731917218,
 731791848,
 -1,
 -54367,
 731849284,
 128840,
 -1,
 731906976,
 128809,
 732113828,
 731846099,
 128831,
 -1,
 732039651,
 128832,
 -54363,
 732072859,
 128845,
 -1,
 732197262,
 128849,
 732375981,
 731795996,
 -1,
 732441515,
 732310952,
 128784,
 732561407,
 732367326,
 -1,
 -54358,
 732433610,
 128786,
 -1,
 732498995,
 128785,
 -54356,
 732389603,
 128881,
 -1,
 732632301,
 128824,
 732834740,
 732313762,
 -1,
 732900273,
 732781791,
 -1,
 -54352,
 732859037,
 128878,
 -1,
 732918950,
 128854,
 733151231,
 732828321,
 -1,
 -54349,
 733045856,
 128883,
 -1,
 733095904,
 128882,
 733293498,
 732766933,
 -1,
 733359033,
 733234539,
 -1,
 733424568,
 733313749,
 128865,
 -1,
 733350371,
 128866,
 -1,
 733381192,
 128864,
 -1,
 733288404,
 128880,
 733686718,
 733234516,
 -1,
 733752253,
 733610912,
 128796,
 -1,
 733678051,
 128797,
 -1,
 733678086,
 128801,
 733948865,
 733646735,
 -1,
 -54336,
 733909883,
 128842,
 -1,
 733970511,
 128772,
 734145476,
 733900089,
 -1,
 -54333,
 734092241,
 128768,
 -1,
 734142281,
 128833,
 734342087,
 734091874,
 -1,
 -54330,
 734299085,
 128789,
 -1,
 734344937,
 128879,
 734538698,
 734284610,
 -1,
 -54327,
 734485940,
 128851,
 -1,
 734538110,
 128810,
 734735309,
 734475473,
 -1,
 -54324,
 734693509,
 128841,
 -1,
 734748371,
 128794,
 -54322,
 734694117,
 128853,
 -54321,
 734879363,
 128838,
 -54320,
 734933747,
 128770,
 -1,
 734996913,
 128771,
 735194068,
 724445314,
 -1,
 -54317,
 735147197,
 983054,
 -1,
 735204448,
 9879,
 -54315,
 735150194,
 9941,
 -54314,
 735330343,
 128126,
 -1,
 735384946,
 9200,
 735587369,
 724379778,
 -1,
 735652904,
 735524374,
 -1,
 735718423,
 735599655,
 -1,
 735783915,
 735673877,
 -1,
 735849442,
 735743816,
 -1,
 735914976,
 735796447,
 65800,
 736034815,
 735838208,
 -1,
 -54305,
 735936851,
 65827,
 -1,
 735985188,
 65818,
 736231423,
 735849719,
 65809,
 -1,
 736102075,
 65836,
 736308201,
 735787170,
 -1,
 736373735,
 736260138,
 65801,
 736493567,
 736296960,
 -1,
 -54298,
 736395603,
 65828,
 -1,
 736443940,
 65819,
 736690175,
 736314726,
 65810,
 -1,
 736560827,
 65837,
 736821247,
 736242692,
 65808,
 -1,
 736691899,
 65835,
 736898040,
 735737222,
 -1,
 736963570,
 736839392,
 65804,
 737029103,
 736921108,
 65813,
 -1,
 736954043,
 65840,
 737214463,
 736952320,
 -1,
 -54287,
 737116499,
 65831,
 -1,
 737164836,
 65822,
 737411071,
 736898951,
 65805,
 737422325,
 737314324,
 65814,
 -1,
 737347259,
 65841,
 737607679,
 737345536,
 -1,
 -54281,
 737509715,
 65832,
 -1,
 737558052,
 65823,
 737750023,
 736833886,
 -1,
 737815552,
 737696991,
 -1,
 737881086,
 737774237,
 65802,
 738000895,
 737804288,
 -1,
 -54275,
 737902931,
 65829,
 -1,
 737951268,
 65820,
 738197503,
 737834245,
 65811,
 -1,
 738068155,
 65838,
 738328575,
 737754726,
 -1,
 738339845,
 738233477,
 65803,
 738459647,
 738263040,
 -1,
 -54268,
 738361683,
 65830,
 -1,
 738410020,
 65821,
 738656255,
 738276536,
 65812,
 -1,
 738526907,
 65839,
 738733069,
 737696407,
 65807,
 738798602,
 738690580,
 65816,
 -1,
 738723515,
 65843,
 738983935,
 738721792,
 -1,
 -54260,
 738885971,
 65834,
 -1,
 738934308,
 65825,
 739126291,
 738667324,
 65806,
 739191824,
 739087407,
 65815,
 -1,
 739116731,
 65842,
 739377151,
 739115008,
 -1,
 -54254,
 739279187,
 65833,
 -1,
 739327524,
 65824,
 739573759,
 739074038,
 65799,
 739639295,
 739442688,
 -1,
 -54250,
 739541331,
 65826,
 -1,
 739589668,
 65817,
 739781666,
 735678280,
 -1,
 739847199,
 739715906,
 -1,
 739912732,
 739783006,
 -1,
 -54245,
 739861690,
 65851,
 -1,
 739919193,
 65848,
 -54243,
 739868973,
 65850,
 -54242,
 740062850,
 65849,
 -1,
 740104421,
 65847,
 740360191,
 739795584,
 -1,
 -54239,
 740249409,
 65792,
 -1,
 740304299,
 65793,
 740502565,
 739726592,
 -1,
 -54236,
 740458797,
 65855,
 -1,
 740521602,
 65854,
 -54234,
 740446092,
 65853,
 -54233,
 740632555,
 65852,
 -1,
 740695515,
 65794,
 -1,
 735605080,
 128673,
 740961390,
 735546800,
 -1,
 741026925,
 740904521,
 -1,
 741092403,
 740953793,
 68352,
 741157935,
 741019329,
 68353,
 -54226,
 741104863,
 68355,
 -1,
 741169253,
 68357,
 741354545,
 741091458,
 68358,
 -1,
 741288066,
 68359,
 -54222,
 741301471,
 68354,
 -1,
 741431397,
 68356,
 741616699,
 741038181,
 -1,
 741682232,
 741553361,
 -1,
 -54218,
 741643477,
 68387,
 -54217,
 741706885,
 68388,
 -1,
 741746818,
 68386,
 -54215,
 741643477,
 68390,
 -54214,
 741890453,
 68391,
 -1,
 741943426,
 68389,
 742140993,
 741569926,
 -1,
 742206527,
 742078626,
 -1,
 -54210,
 742167765,
 68403,
 -1,
 742205570,
 68401,
 -54208,
 742160330,
 68404,
 -1,
 742336642,
 68399,
 742534213,
 742101883,
 -1,
 -54205,
 742495445,
 68370,
 -54204,
 742558853,
 68371,
 -1,
 742598786,
 68369,
 742796361,
 742489621,
 -1,
 -54201,
 742752147,
 68381,
 -54200,
 742799898,
 68378,
 -1,
 742860930,
 68377,
 743058509,
 742733009,
 -1,
 -54197,
 742996506,
 68374,
 -54196,
 743060991,
 68373,
 -1,
 743123074,
 68372,
 743320656,
 743020047,
 -1,
 -54193,
 743258650,
 68402,
 -1,
 743319682,
 68400,
 743517267,
 743281711,
 -1,
 -54190,
 743478485,
 68394,
 -1,
 743516290,
 68395,
 743713877,
 743474727,
 68366,
 -1,
 743671335,
 68367,
 743844951,
 743660767,
 68362,
 -1,
 743791839,
 68363,
 743976025,
 743784038,
 68364,
 -1,
 743915110,
 68365,
 744107100,
 743913634,
 -1,
 -54181,
 744051916,
 68393,
 -1,
 744106114,
 68405,
 744303710,
 744040578,
 68360,
 -1,
 744237186,
 68361,
 744434785,
 744235733,
 -1,
 -54176,
 744372762,
 68380,
 -1,
 744433794,
 68379,
 744631396,
 744364028,
 -1,
 -54173,
 744569370,
 68385,
 -1,
 744630402,
 68384,
 -54171,
 744590469,
 68396,
 -54170,
 744779647,
 68397,
 -54169,
 744843280,
 68382,
 -54168,
 744903884,
 68392,
 -54167,
 744967406,
 68398,
 -54166,
 745032066,
 68368,
 -54165,
 745097079,
 68376,
 -54164,
 745157146,
 68383,
 -1,
 745217379,
 68375,
 -1,
 740953973,
 68409,
 745483383,
 740907109,
 -1,
 745548914,
 745438741,
 128028,
 -54159,
 745488235,
 128260,
 -1,
 745548971,
 128246,
 745745526,
 745485521,
 -1,
 -54156,
 745703450,
 128551,
 -54155,
 745764192,
 128544,
 -1,
 745811349,
 128162,
 -1,
 745676372,
 9875,
 746073213,
 745440807,
 -1,
 746138747,
 746029787,
 -1,
 -54150,
 746085673,
 128663,
 -1,
 746133122,
 127975,
 -54148,
 746093742,
 8371,
 -1,
 746264949,
 127814,
 746466433,
 746003405,
 -1,
 746531968,
 746407997,
 983053,
 -1,
 746478429,
 983052,
 -1,
 746455415,
 9190,
 746728580,
 746421781,
 -1,
 -54141,
 746676054,
 9883,
 -1,
 746732603,
 128095,
 746925191,
 746683390,
 -1,
 -54138,
 746878020,
 9954,
 -1,
 746938555,
 128562,
 747121802,
 746874619,
 -1,
 -54135,
 747071892,
 983194,
 -1,
 747117517,
 983195,
 747318413,
 747065884,
 -1,
 -54132,
 747253221,
 127944,
 -1,
 747314046,
 128657,
 -54130,
 747260670,
 8525,
 -1,
 747451037,
 1547,
 747646562,
 696857809,
 -1,
 747711874,
 747597154,
 -1,
 747777398,
 747645563,
 -1,
 747842930,
 747718719,
 -1,
 747908327,
 747769537,
 -1,
 747973860,
 747839840,
 -1,
 748039354,
 747902756,
 -1,
 748104873,
 747975341,
 -1,
 748170402,
 748063877,
 65859,
 748290047,
 748093440,
 -1,
 748301469,
 748191253,
 -1,
 748367004,
 748240183,
 65862,
 -1,
 748291742,
 65870,
 -1,
 748294780,
 65864,
 748563617,
 748240420,
 65861,
 748683263,
 748486656,
 -1,
 -54112,
 748584741,
 65868,
 -1,
 748649534,
 65875,
 -1,
 748518462,
 65871,
 748945407,
 748106936,
 65860,
 749010943,
 748814336,
 -1,
 749022376,
 748912149,
 -1,
 749087911,
 748961079,
 65863,
 -1,
 749012594,
 65878,
 -1,
 749015676,
 65866,
 -1,
 748977214,
 65873,
 749350068,
 748052474,
 -1,
 749415599,
 749287586,
 -1,
 749481134,
 749373759,
 -1,
 -54099,
 749436709,
 65867,
 -1,
 749501502,
 65874,
 -1,
 749408925,
 65857,
 749743282,
 749371740,
 -1,
 -54095,
 749698853,
 65869,
 -1,
 749763646,
 65876,
 -54093,
 749694150,
 65856,
 -1,
 749873099,
 65858,
 750125055,
 749305889,
 -1,
 750136504,
 750026261,
 -1,
 -54089,
 750075221,
 65877,
 -1,
 750129788,
 65865,
 -54087,
 750091326,
 65872,
 -1,
 750278365,
 65879,
 750464211,
 747994645,
 -1,
 750529739,
 750402214,
 -1,
 750595266,
 750485013,
 -1,
 750660800,
 750532770,
 -1,
 -54081,
 750612526,
 65899,
 -1,
 750667110,
 65893,
 -54079,
 750621294,
 65884,
 -1,
 750791684,
 65892,
 750988486,
 750542838,
 65881,
 751108095,
 750911488,
 -1,
 -54075,
 751010131,
 65905,
 -1,
 751058468,
 65898,
 751304703,
 750924461,
 -1,
 751316170,
 751209608,
 -1,
 -54071,
 751272275,
 65906,
 -1,
 751320612,
 65902,
 -1,
 751252664,
 65897,
 751632383,
 750482440,
 -1,
 751643857,
 751514285,
 -1,
 751709391,
 751602821,
 65887,
 -1,
 751632934,
 65901,
 751894527,
 751645880,
 65894,
 -1,
 751763494,
 65895,
 752025599,
 751599645,
 65888,
 -1,
 751894566,
 65889,
 752102617,
 750402191,
 -1,
 752168152,
 752047782,
 -1,
 -54058,
 752123933,
 65890,
 -54057,
 752181238,
 65882,
 -1,
 752235184,
 65896,
 -1,
 752095470,
 65880,
 752495837,
 752037190,
 -1,
 752561372,
 752452963,
 65883,
 -1,
 752484766,
 65886,
 -1,
 752497446,
 65900,
 752757984,
 752425933,
 -1,
 -54049,
 752719318,
 65885,
 -1,
 752752099,
 65903,
 -54047,
 752712889,
 65908,
 -54046,
 752900364,
 65904,
 -54045,
 752965073,
 65891,
 -1,
 753017853,
 65907,
 753270783,
 747924834,
 -1,
 -54042,
 753172155,
 65926,
 -1,
 753231024,
 65927,
 753413390,
 747848675,
 -1,
 753478896,
 753339698,
 119327,
 -54038,
 753405578,
 119356,
 -54037,
 753471062,
 119355,
 -54036,
 753536535,
 119354,
 -54035,
 753601904,
 119353,
 -54034,
 753667274,
 119352,
 -54033,
 753732659,
 119351,
 -1,
 753797920,
 119350,
 754003192,
 753404835,
 119325,
 -54030,
 753929866,
 119337,
 -54029,
 753995350,
 119336,
 -54028,
 754060823,
 119335,
 -54027,
 754126130,
 119334,
 -54026,
 754191562,
 119333,
 -54025,
 754256947,
 119332,
 -1,
 754322339,
 119331,
 754527487,
 753929267,
 119326,
 -54022,
 754454154,
 119343,
 -54021,
 754519575,
 119342,
 -54020,
 754585053,
 119341,
 -54019,
 754650480,
 119340,
 -54018,
 754715954,
 119339,
 -1,
 754781386,
 119338,
 754986245,
 754453872,
 119328,
 -54015,
 754912562,
 119361,
 -54014,
 754977994,
 119360,
 -54013,
 755043379,
 119359,
 -54012,
 755108771,
 119358,
 -1,
 755174176,
 119357,
 755379468,
 754912458,
 -1,
 -54009,
 755306122,
 119349,
 -54008,
 755371606,
 119348,
 -54007,
 755437079,
 119347,
 -54006,
 755502557,
 119346,
 -54005,
 755567667,
 119345,
 -1,
 755632928,
 119344,
 -54003,
 755306070,
 119330,
 -1,
 755764759,
 119329,
 755969324,
 753372698,
 -1,
 756034842,
 755895203,
 119296,
 -53999,
 755961482,
 119314,
 -53998,
 756026966,
 119313,
 -53997,
 756092439,
 119312,
 -53996,
 756157917,
 119311,
 -53995,
 756223344,
 119310,
 -53994,
 756288818,
 119309,
 -53993,
 756354250,
 119308,
 -53992,
 756419635,
 119307,
 -53991,
 756485027,
 119306,
 -1,
 756550432,
 119305,
 756755744,
 755961200,
 119300,
 -53988,
 756682034,
 119324,
 -53987,
 756747466,
 119323,
 -53986,
 756812851,
 119322,
 -53985,
 756878243,
 119321,
 -1,
 756943648,
 119320,
 757148966,
 756681779,
 119297,
 -53982,
 757075250,
 119319,
 -53981,
 757140682,
 119318,
 -53980,
 757206067,
 119317,
 -53979,
 757271459,
 119316,
 -1,
 757336864,
 119315,
 -53977,
 757075594,
 119304,
 -53976,
 757468758,
 119303,
 -53975,
 757534231,
 119302,
 -53974,
 757599709,
 119301,
 -53973,
 757665074,
 119299,
 -1,
 757730506,
 119298,
 757935423,
 755922310,
 -1,
 758000953,
 757879606,
 -1,
 758066485,
 757943881,
 -1,
 758132018,
 758019462,
 -1,
 -53967,
 758070363,
 1016,
 -1,
 758125358,
 1019,
 -53965,
 758081413,
 887,
 -53964,
 758266543,
 881,
 -1,
 758322432,
 883,
 758525240,
 758018280,
 -1,
 -53961,
 758469094,
 891,
 -1,
 758523490,
 893,
 -1,
 758457954,
 892,
 758841343,
 757958536,
 -1,
 -53957,
 758739245,
 7528,
 -53956,
 758802678,
 7529,
 -53955,
 758855007,
 7527,
 -53954,
 758914607,
 7530,
 -1,
 758978945,
 7526,
 759180622,
 757865603,
 -1,
 759246153,
 759122754,
 -1,
 759311688,
 759181000,
 -1,
 759377221,
 759264646,
 -1,
 -53948,
 759315547,
 1015,
 -1,
 759370542,
 1018,
 -53946,
 759326597,
 886,
 -53945,
 759511727,
 880,
 -1,
 759567616,
 882,
 -1,
 759269593,
 1017,
 759835980,
 759197928,
 -1,
 -53941,
 759779814,
 1021,
 -1,
 759834210,
 1023,
 -53939,
 759777495,
 975,
 -1,
 759965282,
 1022,
 760163671,
 759135765,
 -1,
 760229202,
 760124017,
 -1,
 -53935,
 760185155,
 65911,
 -1,
 760241485,
 65917,
 760425813,
 760167786,
 -1,
 -53932,
 760376547,
 65912,
 -1,
 760438093,
 65918,
 -53930,
 760378728,
 65929,
 -1,
 760550001,
 65914,
 760753504,
 760105794,
 -1,
 760819039,
 760688335,
 -1,
 760884572,
 760768251,
 -1,
 -53925,
 760838252,
 7466,
 -1,
 760888934,
 7464,
 -53923,
 760836397,
 7465,
 -53922,
 761023519,
 7463,
 -1,
 761083231,
 7462,
 -1,
 760759927,
 65923,
 761343333,
 760700127,
 -1,
 761408867,
 761289116,
 65909,
 -1,
 761331750,
 65910,
 -53916,
 761366919,
 65924,
 -1,
 761469623,
 65916,
 761671016,
 761287196,
 -1,
 -53913,
 761629529,
 119365,
 -1,
 761671355,
 65921,
 761867627,
 761606494,
 -1,
 -53910,
 761816217,
 65919,
 -1,
 761874082,
 65920,
 -53908,
 761829076,
 65930,
 -53907,
 762025176,
 65913,
 -53906,
 762090474,
 65925,
 -53905,
 762147121,
 1020,
 -53904,
 762202918,
 65922,
 -53903,
 762263494,
 65928,
 -1,
 762324947,
 65915,
 762576895,
 747788391,
 -1,
 -53900,
 762460735,
 128154,
 -53899,
 762518214,
 128215,
 -1,
 762582197,
 127823,
 762785148,
 747716198,
 -1,
 762850683,
 762731283,
 -1,
 762916218,
 762786238,
 128512,
 -1,
 762841467,
 128513,
 -1,
 762846494,
 128568,
 -1,
 762794634,
 128556,
 763178367,
 762731743,
 -1,
 -53890,
 763138357,
 128151,
 -1,
 763202038,
 983109,
 763428863,
 763104961,
 -1,
 -53887,
 763324640,
 127815,
 -1,
 763373590,
 127891,
 763571717,
 747653954,
 -1,
 763637250,
 763498846,
 -1,
 763702723,
 763591162,
 -1,
 763768206,
 763655558,
 -1,
 763833738,
 763705506,
 -1,
 763899273,
 763788939,
 11339,
 -1,
 763848992,
 11356,
 -1,
 763825857,
 11342,
 764095884,
 763777946,
 11348,
 -1,
 764021167,
 11349,
 -53875,
 764045611,
 11346,
 -1,
 764170507,
 11332,
 764358039,
 763728943,
 -1,
 764423572,
 764291202,
 -1,
 764489107,
 764374370,
 -1,
 -53870,
 764446247,
 11343,
 -1,
 764493414,
 11344,
 -1,
 764443953,
 11317,
 -53867,
 764380711,
 11347,
 -53866,
 764697823,
 11350,
 -1,
 764745455,
 11345,
 764947871,
 764296806,
 11323,
 765013403,
 764909290,
 -1,
 -53862,
 764954241,
 11355,
 -1,
 765012098,
 11321,
 765210014,
 764961684,
 -1,
 -53859,
 765164150,
 11351,
 -1,
 765204956,
 11353,
 -1,
 765156049,
 11322,
 765472163,
 764902933,
 -1,
 -53855,
 765431596,
 11333,
 -53854,
 765491308,
 11340,
 -1,
 765555755,
 11357,
 765734311,
 765403861,
 -1,
 -53851,
 765695630,
 11319,
 -53850,
 765746520,
 11316,
 -1,
 765806518,
 11324,
 765996458,
 765695503,
 -1,
 -53847,
 765934615,
 11318,
 -1,
 765996010,
 11320,
 766193069,
 765945595,
 -1,
 -53844,
 766140091,
 11330,
 -1,
 766191746,
 11338,
 766389680,
 766139615,
 -1,
 -53841,
 766346447,
 11337,
 -1,
 766401548,
 11329,
 766586291,
 766331714,
 -1,
 -53838,
 766527522,
 11326,
 -1,
 766580494,
 11358,
 766782902,
 766521694,
 -1,
 -53835,
 766735265,
 11335,
 -1,
 766789133,
 11354,
 766979513,
 766711804,
 -1,
 -53832,
 766937153,
 11313,
 -1,
 766984329,
 11352,
 -53830,
 766938280,
 11314,
 -53829,
 767133752,
 11334,
 -53828,
 767194011,
 11331,
 -53827,
 767252742,
 11328,
 -53826,
 767318109,
 11327,
 -53825,
 767379686,
 11325,
 -53824,
 767441562,
 11336,
 -53823,
 767506282,
 11315,
 -53822,
 767565411,
 11341,
 -1,
 767629304,
 11312,
 767885311,
 763632796,
 -1,
 767897037,
 767784326,
 -1,
 767962569,
 767834274,
 -1,
 768028104,
 767917707,
 11291,
 -1,
 767977760,
 11308,
 -1,
 767954625,
 11294,
 768224715,
 767906714,
 11300,
 -1,
 768149935,
 11301,
 -53812,
 768174379,
 11298,
 -1,
 768299275,
 11284,
 768486870,
 767857711,
 -1,
 768552403,
 768419970,
 -1,
 768617938,
 768503138,
 -1,
 -53807,
 768575015,
 11295,
 -1,
 768622182,
 11296,
 -1,
 768572721,
 11269,
 -53804,
 768509479,
 11299,
 -53803,
 768826591,
 11302,
 -1,
 768874223,
 11297,
 769076702,
 768425574,
 11275,
 769142234,
 769038058,
 -1,
 -53799,
 769083009,
 11307,
 -1,
 769140866,
 11273,
 769338845,
 769090452,
 -1,
 -53796,
 769292918,
 11303,
 -1,
 769333724,
 11305,
 -1,
 769284817,
 11274,
 769600994,
 769031701,
 -1,
 -53792,
 769560364,
 11285,
 -53791,
 769620076,
 11292,
 -1,
 769684523,
 11309,
 769863142,
 769532629,
 -1,
 -53788,
 769824398,
 11271,
 -53787,
 769875288,
 11268,
 -1,
 769935286,
 11276,
 770125289,
 769824271,
 -1,
 -53784,
 770063383,
 11270,
 -1,
 770124778,
 11272,
 770321900,
 770074363,
 -1,
 -53781,
 770268859,
 11282,
 -1,
 770320514,
 11290,
 770518511,
 770268383,
 -1,
 -53778,
 770475215,
 11289,
 -1,
 770530316,
 11281,
 770715122,
 770460482,
 -1,
 -53775,
 770656290,
 11278,
 -1,
 770709262,
 11310,
 770911733,
 770650462,
 -1,
 -53772,
 770864033,
 11287,
 -1,
 770917901,
 11306,
 771108344,
 770840572,
 -1,
 -53769,
 771065921,
 11265,
 -1,
 771113097,
 11304,
 -53767,
 771067048,
 11266,
 -53766,
 771262520,
 11286,
 -53765,
 771322779,
 11283,
 -53764,
 771381510,
 11280,
 -53763,
 771446877,
 11279,
 -53762,
 771508454,
 11277,
 -53761,
 771570330,
 11288,
 -53760,
 771635050,
 11267,
 -53759,
 771694179,
 11293,
 -1,
 771758072,
 11264,
 772014079,
 763583711,
 -1,
 -53756,
 771920192,
 127775,
 -1,
 771954961,
 127760,
 772157004,
 763504770,
 -1,
 772222535,
 772104851,
 -1,
 772288060,
 772176378,
 -1,
 772353551,
 772225186,
 -1,
 772419084,
 772280001,
 -1,
 -53749,
 772369762,
 11556,
 -1,
 772417666,
 11552,
 -53747,
 772365788,
 11557,
 -53746,
 772554773,
 11554,
 -1,
 772614274,
 11553,
 772812309,
 772283341,
 -1,
 772877843,
 772749474,
 -1,
 -53742,
 772817384,
 11545,
 -1,
 772871391,
 11549,
 -53740,
 772817240,
 11548,
 -1,
 773002030,
 11546,
 773205528,
 772773391,
 -1,
 -53737,
 773142975,
 11535,
 -1,
 773204996,
 11526,
 773402139,
 773160587,
 -1,
 -53734,
 773352802,
 11538,
 -1,
 773412965,
 11527,
 773598750,
 773354886,
 -1,
 -53731,
 773536714,
 11544,
 -1,
 773591854,
 11537,
 773795361,
 773547771,
 -1,
 -53728,
 773732799,
 11540,
 -1,
 773788895,
 11534,
 773991972,
 773736509,
 -1,
 -53725,
 773929407,
 11541,
 -1,
 773985070,
 11529,
 774188583,
 773932855,
 -1,
 -53722,
 774127960,
 11547,
 -1,
 774191444,
 11551,
 774385194,
 774124753,
 -1,
 -53719,
 774322516,
 11542,
 -1,
 774378286,
 11522,
 774581805,
 774311617,
 -1,
 -53716,
 774527077,
 11520,
 -1,
 774581252,
 11565,
 -53714,
 774542743,
 11559,
 -53713,
 774738907,
 11550,
 -53712,
 774803493,
 11555,
 -53711,
 774868457,
 11525,
 -53710,
 774932686,
 11539,
 -53709,
 774991353,
 11536,
 -53708,
 775056473,
 11543,
 -53707,
 775118726,
 11533,
 -53706,
 775182576,
 11532,
 -53705,
 775246755,
 11531,
 -53704,
 775310401,
 11530,
 -53703,
 775373288,
 11528,
 -53702,
 775433220,
 11524,
 -53701,
 775497127,
 11523,
 -1,
 775559284,
 11521,
 775761476,
 772230729,
 -1,
 775827008,
 775687873,
 -1,
 -53697,
 775766504,
 4346,
 -1,
 775826436,
 4349,
 -53695,
 775784060,
 983915,
 -53694,
 775980326,
 4345,
 -53693,
 776031119,
 4351,
 -1,
 776092135,
 4350,
 776339455,
 775691420,
 -1,
 -53690,
 776246679,
 4295,
 -1,
 776278189,
 4301,
 776482379,
 772150495,
 9881,
 776601599,
 776406942,
 -1,
 -53686,
 776496359,
 9965,
 -1,
 776536601,
 9966,
 -1,
 776426078,
 128142,
 776810077,
 772113959,
 -1,
 776875604,
 776750959,
 -1,
 776941136,
 776834821,
 2786,
 -1,
 776883010,
 2787,
 777072210,
 776883848,
 2700,
 -1,
 777014082,
 2785,
 -53677,
 777024850,
 2801,
 -1,
 777129863,
 2800,
 777334361,
 776827855,
 -1,
 -53674,
 777295023,
 2677,
 -53673,
 777358841,
 2563,
 -53672,
 777422781,
 2641,
 -1,
 777457753,
 2561,
 777662044,
 777262303,
 -1,
 -53669,
 777594885,
 128130,
 -1,
 777655326,
 8370,
 -1,
 777602623,
 127928,
 -53666,
 776762758,
 983110,
 -53665,
 777870618,
 128016,
 -53664,
 777930064,
 128103,
 -53663,
 777993502,
 128123,
 -1,
 778048261,
 127922,
 778252294,
 747595515,
 -1,
 778317588,
 778188962,
 -1,
 778383087,
 778243777,
 -1,
 778448559,
 778319940,
 -1,
 778514083,
 778391113,
 -1,
 778579568,
 778468885,
 -1,
 778645099,
 778534421,
 -1,
 -53654,
 778582200,
 43114,
 -1,
 778636993,
 43113,
 778841710,
 778597766,
 -1,
 -53651,
 778778808,
 43089,
 -1,
 778833601,
 43088,
 -53649,
 778778808,
 43081,
 -1,
 778964673,
 43080,
 779169397,
 778524773,
 -1,
 -53646,
 779129969,
 43079,
 -53645,
 779180219,
 43116,
 -53644,
 779236611,
 43075,
 -1,
 779292353,
 43083,
 779497081,
 779122054,
 -1,
 -53641,
 779440956,
 43094,
 -53640,
 779499704,
 43098,
 -1,
 779554497,
 43099,
 779759229,
 779428565,
 -1,
 -53637,
 779720223,
 43090,
 -53636,
 779756338,
 43115,
 -1,
 779816641,
 43082,
 780021377,
 779688909,
 -1,
 780086912,
 779947713,
 43076,
 -1,
 780032375,
 43123,
 -1,
 780023992,
 43077,
 780283524,
 779947713,
 43101,
 -53629,
 780237637,
 43120,
 -1,
 780292504,
 43117,
 780480135,
 780244495,
 -1,
 -53626,
 780417208,
 43092,
 -1,
 780472001,
 43093,
 780676746,
 780439126,
 -1,
 -53623,
 780619307,
 43118,
 -1,
 780673770,
 43119,
 780873357,
 780625659,
 -1,
 -53620,
 780810424,
 43085,
 -1,
 780865217,
 43084,
 781069968,
 780814397,
 -1,
 -53617,
 781007032,
 43073,
 -1,
 781061825,
 43072,
 781266579,
 781006033,
 -1,
 -53614,
 781202691,
 43109,
 -1,
 781258433,
 43074,
 781463189,
 781199490,
 43104,
 -1,
 781396098,
 43110,
 -53610,
 781423729,
 43095,
 -53609,
 781554630,
 43107,
 -53608,
 781619087,
 43091,
 -53607,
 781682215,
 43103,
 -53606,
 781741504,
 43096,
 -53605,
 781806637,
 43106,
 -53604,
 781868255,
 43105,
 -53603,
 781931125,
 43087,
 -53602,
 781994864,
 43097,
 -53601,
 782059349,
 43078,
 -53600,
 782122598,
 43102,
 -53599,
 782186680,
 43100,
 -53598,
 782250427,
 43108,
 -1,
 782309425,
 43086,
 782511787,
 778466694,
 -1,
 782577322,
 782468647,
 -1,
 782642857,
 782506517,
 -1,
 -53593,
 782603377,
 43112,
 -53592,
 782667663,
 43111,
 -1,
 782724544,
 43121,
 -1,
 782592164,
 43122,
 -1,
 782517084,
 43124,
 783036078,
 782455793,
 -1,
 -53587,
 782989169,
 43126,
 -1,
 783034150,
 43127,
 -1,
 782968583,
 43125,
 783351807,
 778388957,
 -1,
 783363771,
 783227853,
 -1,
 783429301,
 783310047,
 -1,
 783494836,
 783373388,
 66020,
 -1,
 783434610,
 66045,
 -1,
 783438305,
 66022,
 783691449,
 783355585,
 -1,
 -53577,
 783646229,
 66028,
 -53576,
 783709315,
 66018,
 -1,
 783772578,
 66003,
 -53574,
 783634897,
 66012,
 -1,
 783891368,
 66004,
 784084675,
 783316358,
 -1,
 784150207,
 784022250,
 -1,
 -53570,
 784099067,
 66024,
 -1,
 784149393,
 66011,
 -53568,
 784106373,
 66042,
 -53567,
 784290663,
 66043,
 -53566,
 784355184,
 66021,
 -1,
 784406456,
 66015,
 784608970,
 784013308,
 -1,
 784674503,
 784555231,
 -1,
 -53562,
 784633672,
 66010,
 -1,
 784686964,
 66017,
 784871113,
 784607867,
 66033,
 -1,
 784808978,
 66023,
 -1,
 784828526,
 66027,
 785067728,
 784557819,
 -1,
 785133262,
 785009474,
 -1,
 -53555,
 785090740,
 66001,
 -1,
 785126334,
 66034,
 -53553,
 785066589,
 66000,
 -1,
 785257685,
 66036,
 785460948,
 785022485,
 -1,
 -53550,
 785418642,
 66032,
 -53549,
 785465149,
 66008,
 -1,
 785520427,
 66002,
 785723096,
 785397922,
 -1,
 -53546,
 785670876,
 66025,
 -53545,
 785727445,
 66026,
 -1,
 785787840,
 66006,
 785985243,
 785682248,
 -1,
 -53542,
 785932128,
 66005,
 -1,
 785979296,
 66044,
 786181854,
 785935714,
 -1,
 -53539,
 786129714,
 66037,
 -1,
 786174717,
 66029,
 786378465,
 786125429,
 -1,
 -53536,
 786334910,
 66014,
 -1,
 786389206,
 66013,
 786575076,
 786321136,
 -1,
 -53533,
 786518540,
 66038,
 -1,
 786571989,
 66016,
 786771687,
 786511057,
 -1,
 -53530,
 786722542,
 66041,
 -1,
 786765648,
 66007,
 786968298,
 786703755,
 -1,
 -53527,
 786926725,
 66031,
 -1,
 786976697,
 66019,
 -53525,
 786927085,
 66035,
 -53524,
 787113708,
 66039,
 -53523,
 787166105,
 66040,
 -53522,
 787229062,
 66030,
 -1,
 787289515,
 66009,
 787546111,
 778329567,
 -1,
 787558154,
 787435081,
 -1,
 787623669,
 787510662,
 -1,
 -53517,
 787561418,
 67860,
 -53516,
 787622886,
 67854,
 -1,
 787681380,
 67857,
 787885816,
 787578389,
 -1,
 -53513,
 787820164,
 67848,
 -1,
 787879736,
 67861,
 788082426,
 787823130,
 67844,
 -1,
 788037141,
 67847,
 788213501,
 788008641,
 -1,
 -53508,
 788156083,
 67840,
 -1,
 788218344,
 67855,
 -53506,
 788174374,
 67846,
 -53505,
 788370849,
 67849,
 -53504,
 788434902,
 67845,
 -53503,
 788493408,
 67859,
 -53502,
 788556902,
 67858,
 -53501,
 788621328,
 67856,
 -53500,
 788683866,
 67853,
 -53499,
 788747643,
 67852,
 -53498,
 788810778,
 67851,
 -53497,
 788875471,
 67850,
 -53496,
 788936026,
 67842,
 -53495,
 788997135,
 67843,
 -1,
 789059965,
 67841,
 789262099,
 787504167,
 -1,
 789327633,
 789216789,
 -1,
 789393167,
 789286728,
 -1,
 -53490,
 789339359,
 67866,
 -1,
 789392631,
 67864,
 -53488,
 789331301,
 67867,
 -1,
 789523460,
 67863,
 789774335,
 789274614,
 67862,
 -1,
 789643814,
 67865,
 -1,
 789222206,
 67871,
 789917542,
 778259266,
 -1,
 789983076,
 789845996,
 -1,
 790048550,
 789937685,
 -1,
 790114076,
 790008528,
 -1,
 -53479,
 790067995,
 127138,
 -53478,
 790116951,
 127154,
 -53477,
 790176976,
 127170,
 -1,
 790241286,
 127186,
 790441761,
 790052351,
 -1,
 -53474,
 790395675,
 127139,
 -53473,
 790444631,
 127155,
 -53472,
 790504656,
 127171,
 -1,
 790568966,
 127187,
 790822911,
 790375469,
 -1,
 -53469,
 790723355,
 127146,
 -53468,
 790772311,
 127162,
 -53467,
 790832336,
 127178,
 -1,
 790896646,
 127194,
 791097137,
 790001030,
 -1,
 791162668,
 791037680,
 -1,
 -53463,
 791116571,
 127142,
 -53462,
 791165527,
 127158,
 -53461,
 791225552,
 127174,
 -1,
 791289862,
 127190,
 791543807,
 791097245,
 -1,
 -53458,
 791444251,
 127143,
 -53457,
 791493207,
 127159,
 -53456,
 791553232,
 127175,
 -1,
 791617542,
 127191,
 791818044,
 791038013,
 -1,
 791883575,
 791763583,
 -1,
 -53452,
 791837467,
 127148,
 -53451,
 791886423,
 127164,
 -53450,
 791946448,
 127180,
 -1,
 792010758,
 127196,
 792264703,
 791823117,
 -1,
 -53447,
 792165147,
 127150,
 -53446,
 792214103,
 127166,
 -53445,
 792274128,
 127182,
 -1,
 792338438,
 127198,
 792538951,
 791753054,
 -1,
 792604482,
 792487080,
 -1,
 -53441,
 792558363,
 127140,
 -53440,
 792607319,
 127156,
 -53439,
 792667344,
 127172,
 -1,
 792731654,
 127188,
 792985599,
 792544945,
 -1,
 -53436,
 792886043,
 127141,
 -53435,
 792934999,
 127157,
 -53434,
 792995024,
 127173,
 -1,
 793059334,
 127189,
 793259852,
 792489201,
 -1,
 -53431,
 793213723,
 127149,
 -53430,
 793262679,
 127165,
 -53429,
 793322704,
 127181,
 -1,
 793387014,
 127197,
 793587537,
 793205415,
 -1,
 -53426,
 793541403,
 127145,
 -53425,
 793590359,
 127161,
 -53424,
 793650384,
 127177,
 -1,
 793714694,
 127193,
 793915222,
 793528152,
 -1,
 -53421,
 793869083,
 127147,
 -53420,
 793918039,
 127163,
 -53419,
 793978064,
 127179,
 -1,
 794042374,
 127195,
 794242907,
 793848661,
 -1,
 -53416,
 794196763,
 127144,
 -53415,
 794245719,
 127160,
 -53414,
 794305744,
 127176,
 -1,
 794370054,
 127192,
 794570592,
 794169337,
 -1,
 -53411,
 794524443,
 127137,
 -53410,
 794573399,
 127153,
 -53409,
 794633424,
 127169,
 -1,
 794697734,
 127185,
 794898275,
 794499068,
 -1,
 -53406,
 794839963,
 127183,
 -1,
 794890245,
 127136,
 -1,
 794857656,
 127199,
 -53403,
 789939751,
 983150,
 -1,
 795091669,
 983147,
 795291553,
 789843649,
 -1,
 795357072,
 795241826,
 -1,
 795422599,
 795290829,
 -1,
 795488132,
 795364455,
 -1,
 -53397,
 795448847,
 127273,
 -53396,
 795513903,
 127272,
 -53395,
 795579259,
 127271,
 -53394,
 795643720,
 127270,
 -53393,
 795708336,
 127269,
 -53392,
 795772455,
 127268,
 -53391,
 795835925,
 127267,
 -53390,
 795899270,
 127266,
 -53389,
 795962722,
 127265,
 -53388,
 796027935,
 127264,
 -53387,
 796092155,
 127263,
 -53386,
 796155103,
 127262,
 -53385,
 796219493,
 127261,
 -53384,
 796283420,
 127260,
 -53383,
 796347202,
 127259,
 -53382,
 796411965,
 127258,
 -53381,
 796477239,
 127257,
 -53380,
 796540518,
 127256,
 -53379,
 796604578,
 127255,
 -53378,
 796669137,
 127254,
 -53377,
 796733790,
 127253,
 -53376,
 796797058,
 127252,
 -53375,
 796861141,
 127251,
 -53374,
 796924877,
 127250,
 -53373,
 796989436,
 127249,
 -1,
 797052609,
 127248,
 797310975,
 795429577,
 -1,
 -53370,
 797198252,
 12829,
 -1,
 797245986,
 12830,
 797454223,
 795377173,
 -1,
 797519757,
 797392592,
 -1,
 -53366,
 797477295,
 983149,
 -53365,
 797520881,
 983145,
 -53364,
 797583193,
 983146,
 -1,
 797644863,
 983148,
 -53362,
 797480013,
 127881,
 -1,
 797792775,
 12880,
 -1,
 797380973,
 11791,
 798044053,
 795298626,
 -1,
 798109588,
 797987358,
 -1,
 -53357,
 798065617,
 127796,
 -1,
 798104342,
 11801,
 -1,
 798051393,
 9908,
 798371738,
 797980159,
 -1,
 798437273,
 798294016,
 -1,
 -53352,
 798396781,
 128195,
 -1,
 798437857,
 128196,
 -1,
 798387554,
 128223,
 798699420,
 798302933,
 983121,
 -1,
 798631190,
 983120,
 -53347,
 798658409,
 128062,
 -53346,
 798784495,
 128706,
 -53345,
 798845084,
 128206,
 -53344,
 798906683,
 128060,
 -1,
 798957406,
 128230,
 799158208,
 795241826,
 -1,
 799223733,
 799092287,
 -1,
 799289256,
 799175133,
 -1,
 799354791,
 799248580,
 -1,
 -53338,
 799295869,
 65048,
 -1,
 799350633,
 983228,
 -1,
 799308649,
 65096,
 799616939,
 799231337,
 -1,
 -53334,
 799576281,
 65047,
 -1,
 799636329,
 65095,
 799813550,
 799555555,
 -1,
 -53331,
 799749312,
 65042,
 -1,
 799809623,
 65041,
 800010161,
 799744012,
 -1,
 -53328,
 799954631,
 65040,
 -1,
 800018563,
 65043,
 -53326,
 799962825,
 65044,
 -53325,
 800156944,
 65046,
 -53324,
 800210143,
 65049,
 -1,
 800272464,
 65045,
 800522239,
 799161958,
 -1,
 800534463,
 800426950,
 -1,
 800599998,
 800489393,
 -1,
 800665531,
 800524766,
 -1,
 -53318,
 800590899,
 983166,
 -1,
 800656291,
 983163,
 800915455,
 800587776,
 -1,
 -53315,
 800818531,
 983165,
 -1,
 800874486,
 983162,
 -1,
 800531137,
 983192,
 -1,
 800479525,
 128120,
 801189852,
 799090818,
 -1,
 801255380,
 801140066,
 -1,
 801320912,
 801207686,
 -1,
 801386447,
 801267590,
 -1,
 801451982,
 801308672,
 -1,
 801517515,
 801411431,
 -1,
 801583049,
 801445884,
 -1,
 -53304,
 801525895,
 128113,
 -1,
 801575608,
 9977,
 -53302,
 801532597,
 128590,
 -1,
 801715111,
 128591,
 -53300,
 801468011,
 128588,
 -53299,
 801846378,
 128589,
 -1,
 801905403,
 128583,
 -1,
 801378849,
 128187,
 -1,
 801320922,
 128547,
 -53295,
 801269841,
 10178,
 -53294,
 802182077,
 9854,
 -53293,
 802239453,
 127917,
 -1,
 802293321,
 8524,
 802500568,
 801200229,
 -1,
 -53290,
 802455248,
 9956,
 -53289,
 802519327,
 128532,
 -1,
 802568295,
 128039,
 802762715,
 802426561,
 -1,
 -53286,
 802712930,
 127824,
 -1,
 802758057,
 127825,
 -1,
 802694238,
 128694,
 803024878,
 801135839,
 -1,
 803090403,
 802981415,
 -1,
 803155937,
 803046033,
 -1,
 -53280,
 803090878,
 128545,
 -1,
 803151084,
 128574,
 -53278,
 803099065,
 127831,
 -1,
 803282345,
 128093,
 803483623,
 803032819,
 -1,
 803549158,
 803413180,
 128659,
 -1,
 803501502,
 128680,
 -1,
 803495421,
 128110,
 803745770,
 803438101,
 -1,
 -53271,
 803671966,
 128688,
 -1,
 803734409,
 127858,
 803942381,
 803699710,
 -1,
 -53268,
 803871497,
 128238,
 -1,
 803934765,
 128239,
 -1,
 803888599,
 128041,
 804204539,
 802963046,
 -1,
 804270067,
 804140241,
 128022,
 804388863,
 804192256,
 -1,
 -53262,
 804281154,
 128061,
 -1,
 804336062,
 128055,
 804532214,
 804215189,
 -1,
 -53259,
 804459701,
 127821,
 -1,
 804520320,
 127885,
 804728825,
 804473666,
 -1,
 -53256,
 804670274,
 128138,
 -1,
 804727010,
 128169,
 -53254,
 804682882,
 128299,
 -1,
 804855622,
 9935,
 805056516,
 804161063,
 -1,
 805122047,
 805006690,
 -1,
 -53250,
 805074555,
 128091,
 -1,
 805136758,
 128156,
 -53248,
 805076533,
 128686,
 -53247,
 805271644,
 128204,
 -53246,
 805313131,
 128226,
 -53245,
 805375027,
 983167,
 -1,
 805440419,
 983164,
 -53243,
 804999708,
 983193,
 -1,
 805577837,
 983218,
 805777832,
 778192957,
 -1,
 805843178,
 805714082,
 -1,
 805908621,
 805787061,
 -1,
 805974099,
 805860742,
 -1,
 806039634,
 805934439,
 -1,
 806105122,
 805988091,
 -1,
 806170654,
 806055574,
 -1,
 806236187,
 806095326,
 -1,
 806301717,
 806164476,
 -1,
 806367250,
 806259110,
 -1,
 -53231,
 806319108,
 6649,
 -1,
 806374045,
 6633,
 806617087,
 806300468,
 -1,
 -53228,
 806515716,
 6648,
 -1,
 806570653,
 6632,
 806760472,
 806250833,
 -1,
 -53225,
 806712324,
 6647,
 -1,
 806767261,
 6631,
 807010303,
 806705164,
 -1,
 -53222,
 806908932,
 6646,
 -1,
 806963869,
 6630,
 807206911,
 806158336,
 -1,
 -53219,
 807105540,
 6645,
 -1,
 807160477,
 6629,
 807350305,
 806109510,
 -1,
 -53216,
 807302148,
 6642,
 -1,
 807357085,
 6626,
 -1,
 807278249,
 6624,
 807612472,
 806036387,
 -1,
 807678005,
 807537118,
 -1,
 807743531,
 807626491,
 -1,
 807809064,
 807693978,
 -1,
 -53209,
 807760900,
 6655,
 -1,
 807815837,
 6639,
 808058879,
 807747910,
 -1,
 -53206,
 807957508,
 6652,
 -1,
 808012445,
 6636,
 808202290,
 807671804,
 -1,
 808267823,
 808159654,
 -1,
 -53202,
 808219652,
 6654,
 -1,
 808274589,
 6638,
 808517631,
 808201012,
 -1,
 -53199,
 808416260,
 6653,
 -1,
 808471197,
 6637,
 808714239,
 808146956,
 -1,
 -53196,
 808612868,
 6651,
 -1,
 808667805,
 6635,
 808910847,
 807600128,
 -1,
 -53193,
 808809476,
 6650,
 -1,
 808864413,
 6634,
 809054279,
 807554551,
 -1,
 809119810,
 809002747,
 -1,
 809185345,
 809070230,
 6133,
 809304063,
 809109982,
 -1,
 809316415,
 809179132,
 -1,
 -53186,
 809273762,
 6137,
 -1,
 809315121,
 6136,
 -53184,
 809265485,
 6135,
 -1,
 809457671,
 6134,
 -1,
 809124163,
 6130,
 809709637,
 809048060,
 -1,
 -53180,
 809666978,
 6132,
 -1,
 809708337,
 6131,
 -53178,
 809663195,
 6128,
 -1,
 809850887,
 6129,
 810037326,
 808982524,
 -1,
 810102859,
 809994662,
 -1,
 -53174,
 810054660,
 6644,
 -1,
 810109597,
 6628,
 810352639,
 810036020,
 -1,
 -53171,
 810251268,
 6643,
 -1,
 810306205,
 6627,
 810496081,
 809981964,
 -1,
 -53168,
 810447876,
 6641,
 -1,
 810502813,
 6625,
 -1,
 810452307,
 6640,
 -1,
 805978409,
 6109,
 810823811,
 805904537,
 -1,
 810889309,
 810778133,
 -1,
 810954840,
 810844337,
 -1,
 -53161,
 810900703,
 983929,
 -1,
 810946241,
 983927,
 811151451,
 810891426,
 -1,
 -53158,
 811097311,
 983934,
 -1,
 811142849,
 983932,
 -53156,
 811097311,
 983933,
 -1,
 811273921,
 983931,
 811479138,
 810834021,
 -1,
 -53153,
 811439514,
 983925,
 -53152,
 811490527,
 983935,
 -53151,
 811546494,
 983920,
 -1,
 811601601,
 983930,
 811806824,
 811419709,
 -1,
 811872358,
 811743394,
 -1,
 -53147,
 811818207,
 983919,
 -1,
 811863745,
 983917,
 -53145,
 811818207,
 983918,
 -1,
 811994817,
 983916,
 812200046,
 811736013,
 -1,
 812265580,
 812136610,
 -1,
 -53141,
 812211423,
 983924,
 -1,
 812256961,
 983922,
 -53139,
 812211423,
 983923,
 -1,
 812388033,
 983921,
 812593266,
 812152198,
 -1,
 -53136,
 812545498,
 983946,
 -53135,
 812595384,
 983945,
 -1,
 812650177,
 983947,
 812855415,
 812541691,
 -1,
 812920950,
 812791970,
 -1,
 -53131,
 812866783,
 983939,
 -1,
 812912321,
 983937,
 -1,
 812866783,
 983938,
 813183098,
 812796738,
 -1,
 -53127,
 813128927,
 983943,
 -1,
 813174465,
 983949,
 813379709,
 813114069,
 -1,
 -53124,
 813325535,
 983928,
 -1,
 813371073,
 983926,
 -53122,
 813340058,
 983941,
 -53121,
 813534743,
 983944,
 -53120,
 813593581,
 983942,
 -53119,
 813651705,
 983940,
 -53118,
 813709496,
 983948,
 -1,
 813766705,
 983936,
 813969545,
 810762785,
 -1,
 814035078,
 813921629,
 983952,
 -1,
 813995055,
 983953,
 814219263,
 813984799,
 -1,
 -53112,
 814122535,
 983951,
 -1,
 814164098,
 983954,
 814415871,
 813928151,
 -1,
 -53109,
 814309194,
 983955,
 -53108,
 814358550,
 983950,
 -1,
 814419777,
 983956,
 814678015,
 805836156,
 -1,
 814690493,
 814566985,
 -1,
 814755990,
 814644757,
 -1,
 814821524,
 814710293,
 -1,
 -53102,
 814776505,
 68147,
 -53101,
 814823608,
 68123,
 -1,
 814878401,
 68122,
 -53099,
 814758072,
 68128,
 -1,
 815009473,
 68127,
 815214748,
 814686933,
 -1,
 815280282,
 815145685,
 -1,
 -53095,
 815216824,
 68125,
 -1,
 815271617,
 68124,
 -53093,
 815216824,
 68130,
 -1,
 815402689,
 68129,
 815607968,
 815166854,
 -1,
 -53090,
 815560154,
 68142,
 -53089,
 815610040,
 68141,
 -1,
 815664833,
 68143,
 815870116,
 815552613,
 -1,
 -53086,
 815830129,
 68121,
 -53085,
 815880379,
 68126,
 -1,
 815926977,
 68131,
 816132264,
 815810621,
 -1,
 -53082,
 816072847,
 68146,
 -53081,
 816134328,
 68113,
 -1,
 816189121,
 68112,
 816394411,
 816080635,
 -1,
 -53078,
 816330936,
 68133,
 -1,
 816385729,
 68132,
 816591022,
 816329937,
 -1,
 -53075,
 816527544,
 68115,
 -1,
 816582337,
 68114,
 816787633,
 816520141,
 -1,
 -53072,
 816724152,
 68118,
 -1,
 816778945,
 68117,
 816984244,
 816715772,
 -1,
 -53069,
 816920760,
 68135,
 -1,
 816975553,
 68134,
 -53067,
 816944671,
 68144,
 -53066,
 817140849,
 68137,
 -53065,
 817204166,
 68140,
 -53064,
 817262016,
 68138,
 -53063,
 817320565,
 68136,
 -53062,
 817384304,
 68139,
 -53061,
 817448789,
 68119,
 -53060,
 817510584,
 68145,
 -1,
 817565377,
 68096,
 817770699,
 814640064,
 -1,
 817836227,
 817701589,
 -1,
 817901762,
 817781983,
 -1,
 -53055,
 817858323,
 68183,
 -1,
 817921557,
 68176,
 -1,
 817828777,
 68182,
 818163910,
 817777474,
 -1,
 -53051,
 818111492,
 68181,
 -1,
 818168448,
 68184,
 818360521,
 818093005,
 -1,
 -53048,
 818311319,
 68179,
 -1,
 818365752,
 68178,
 -53046,
 818313695,
 68177,
 -1,
 818500559,
 68180,
 818688213,
 817728432,
 -1,
 818753748,
 818636445,
 -1,
 818819283,
 818706569,
 -1,
 -53041,
 818777658,
 68099,
 -53040,
 818841127,
 68098,
 -53039,
 818896095,
 68102,
 -53038,
 818953830,
 68097,
 -1,
 819013762,
 68101,
 -1,
 818761236,
 68108,
 -1,
 818693426,
 68159,
 819343581,
 818641033,
 -1,
 819409113,
 819275147,
 -1,
 -53032,
 819365688,
 68109,
 -1,
 819428909,
 68154,
 -53030,
 819367417,
 68111,
 -53029,
 819535161,
 68153,
 -53028,
 819599501,
 68152,
 -1,
 819663971,
 68110,
 819867876,
 819289127,
 -1,
 819933409,
 819822101,
 -1,
 -53024,
 819892264,
 68165,
 -1,
 819932164,
 68164,
 820183039,
 819879930,
 -1,
 -53021,
 820085075,
 68167,
 -1,
 820133412,
 68166,
 820379647,
 819799287,
 -1,
 820392168,
 820280853,
 -1,
 -53017,
 820351598,
 68161,
 -1,
 820395365,
 68162,
 -53015,
 820338678,
 68160,
 -1,
 820524025,
 68163,
 820720027,
 805768897,
 -1,
 820785475,
 820659805,
 -1,
 820850983,
 820727369,
 -1,
 820916468,
 820781781,
 -1,
 820982002,
 820847317,
 -1,
 -53008,
 820918456,
 69787,
 -53007,
 820978805,
 69786,
 -1,
 821038785,
 69785,
 -53005,
 820918456,
 69793,
 -1,
 821169857,
 69792,
 821375226,
 820870677,
 -1,
 821440760,
 821329429,
 -1,
 -53001,
 821377208,
 69784,
 -1,
 821432001,
 69783,
 -52999,
 821377208,
 69791,
 -1,
 821563073,
 69790,
 821768447,
 821319781,
 -1,
 -52996,
 821728369,
 69782,
 -52995,
 821778619,
 69789,
 -52994,
 821835011,
 69777,
 -1,
 821890753,
 69794,
 822096131,
 821694145,
 69763,
 -52991,
 822052391,
 69772,
 -52990,
 822099558,
 69770,
 -1,
 822152897,
 69764,
 822358279,
 822048134,
 -1,
 -52987,
 822310362,
 69805,
 -52986,
 822360248,
 69804,
 -1,
 822415041,
 69806,
 822620425,
 822314535,
 69767,
 -1,
 822576679,
 69768,
 822751500,
 822570338,
 -1,
 -52981,
 822687928,
 69788,
 -1,
 822742721,
 69801,
 822948111,
 822699771,
 -1,
 -52978,
 822884536,
 69796,
 -1,
 822939329,
 69795,
 823144722,
 822888509,
 -1,
 -52975,
 823081144,
 69774,
 -1,
 823135937,
 69773,
 823341333,
 823084855,
 -1,
 -52972,
 823277752,
 69781,
 -1,
 823332545,
 69780,
 823537943,
 823279206,
 69765,
 -1,
 823475814,
 69766,
 823669018,
 823473361,
 -1,
 -52967,
 823605432,
 69776,
 -1,
 823660225,
 69775,
 823865629,
 823598029,
 -1,
 -52964,
 823802040,
 69779,
 -1,
 823856833,
 69778,
 824062240,
 823793660,
 -1,
 -52961,
 823998648,
 69798,
 -1,
 824053441,
 69797,
 -52959,
 824022129,
 69800,
 -52958,
 824216518,
 69803,
 -52957,
 824270047,
 69771,
 -52956,
 824332917,
 69799,
 -52955,
 824396656,
 69802,
 -52954,
 824457400,
 69807,
 -1,
 824518786,
 69769,
 824717618,
 820809431,
 -1,
 824783148,
 824643265,
 -1,
 -52950,
 824739367,
 69816,
 -52949,
 824786534,
 69814,
 -1,
 824839873,
 69808,
 825045294,
 824739367,
 69811,
 -1,
 825001511,
 69812,
 825176368,
 824983142,
 69809,
 -1,
 825114214,
 69810,
 -52943,
 825122015,
 69815,
 -1,
 825239682,
 69813,
 825438523,
 824669574,
 -1,
 825504058,
 825377060,
 -1,
 825569591,
 825462224,
 -1,
 -52938,
 825521715,
 69762,
 -1,
 825585320,
 69817,
 -52936,
 825515037,
 69818,
 -52935,
 825695330,
 69760,
 -1,
 825758819,
 69761,
 -1,
 825436710,
 69822,
 826028352,
 825369301,
 -1,
 826093887,
 825975820,
 -1,
 -52930,
 826046097,
 69823,
 -1,
 826090389,
 69825,
 -1,
 826020777,
 69824,
 -52927,
 825973807,
 69821,
 -52926,
 826289408,
 69820,
 -1,
 826347399,
 69819,
 826552707,
 820745340,
 -1,
 826618216,
 826494537,
 -1,
 826683721,
 826562661,
 -1,
 -52921,
 826643569,
 43281,
 -52920,
 826684675,
 43277,
 -1,
 826740417,
 43284,
 826945868,
 826637845,
 -1,
 -52917,
 826882232,
 43294,
 -1,
 826937025,
 43282,
 827142479,
 826897798,
 -1,
 -52914,
 827078840,
 43279,
 -1,
 827133633,
 43278,
 827339090,
 827090683,
 -1,
 -52911,
 827275448,
 43286,
 -1,
 827330241,
 43285,
 827535701,
 827284703,
 -1,
 -52908,
 827481311,
 43301,
 -1,
 827533442,
 43299,
 827732312,
 827476029,
 -1,
 -52905,
 827668664,
 43275,
 -1,
 827723457,
 43274,
 827928923,
 827668642,
 -1,
 -52902,
 827883147,
 43283,
 -1,
 827920065,
 43295,
 -52900,
 827889183,
 43280,
 -52899,
 828085361,
 43291,
 -52898,
 828149647,
 43293,
 -52897,
 828214214,
 43296,
 -52896,
 828272064,
 43290,
 -52895,
 828330613,
 43287,
 -52894,
 828394352,
 43292,
 -52893,
 828456550,
 43300,
 -52892,
 828519683,
 43276,
 -52891,
 828580658,
 43288,
 -52890,
 828644329,
 43297,
 -52889,
 828708913,
 43289,
 -1,
 828772033,
 43298,
 828977526,
 826549495,
 -1,
 829043052,
 828931605,
 -1,
 -52885,
 829002350,
 43266,
 -1,
 829046117,
 43267,
 829239663,
 828994950,
 -1,
 -52882,
 829179616,
 43270,
 -1,
 829239175,
 43271,
 829436274,
 829174110,
 -1,
 -52879,
 829383794,
 43268,
 -1,
 829441679,
 43269,
 -52877,
 829396653,
 43264,
 -52876,
 829579254,
 43265,
 -52875,
 829643415,
 43273,
 -1,
 829696828,
 43272,
 829895036,
 828935854,
 -1,
 829960569,
 829851175,
 43304,
 -1,
 829892738,
 43302,
 830091643,
 829892738,
 43303,
 -1,
 830023810,
 43305,
 -1,
 830037215,
 43306,
 830288256,
 829850347,
 -1,
 830353791,
 830217243,
 43308,
 -1,
 830276809,
 43309,
 -1,
 830302653,
 43307,
 830603263,
 830240905,
 -1,
 -52862,
 830503015,
 43311,
 -1,
 830546621,
 43310,
 830747026,
 826507014,
 -1,
 830812554,
 830675399,
 -1,
 -52858,
 830768679,
 983964,
 -52857,
 830823647,
 983966,
 -52856,
 830881382,
 983963,
 -52855,
 830941314,
 983965,
 -1,
 831000257,
 983962,
 831258623,
 830738113,
 -1,
 831271313,
 831145020,
 -1,
 831336847,
 831225365,
 -1,
 -52850,
 831292967,
 983968,
 -1,
 831347935,
 983969,
 -52848,
 831284987,
 983970,
 -1,
 831462755,
 983967,
 -1,
 831221567,
 110592,
 831782911,
 830692108,
 -1,
 831795608,
 831682697,
 -1,
 -52843,
 831752768,
 3314,
 -52842,
 831806493,
 3260,
 -52841,
 831866828,
 3313,
 -1,
 831919978,
 3261,
 832123290,
 831753989,
 3298,
 -1,
 832064322,
 3299,
 -1,
 832065115,
 983201,
 832319909,
 820657766,
 -1,
 832385444,
 832273320,
 128143,
 832450979,
 832324257,
 -1,
 832516514,
 832385470,
 128535,
 832634879,
 832440228,
 -1,
 -52831,
 832535168,
 128537,
 -1,
 832577442,
 128538,
 -1,
 832445700,
 128573,
 -1,
 832373541,
 128139,
 -1,
 832329563,
 128088,
 832975271,
 832254295,
 128273,
 -1,
 832904315,
 128287,
 -1,
 832920849,
 128040,
 833172247,
 805723359,
 -1,
 833237680,
 833112898,
 -1,
 833303152,
 833168085,
 -1,
 833368685,
 833224704,
 -1,
 833434109,
 833324311,
 -1,
 833499611,
 833381076,
 -1,
 833565125,
 833425089,
 68608,
 833630650,
 833497218,
 -1,
 -52815,
 833590319,
 68632,
 -52814,
 833650197,
 68677,
 -52813,
 833713542,
 68670,
 -52812,
 833776994,
 68668,
 -52811,
 833837157,
 68644,
 -52810,
 833899330,
 68640,
 -52809,
 833964093,
 68634,
 -52808,
 834024657,
 68623,
 -52807,
 834085589,
 68627,
 -1,
 834148348,
 68619,
 834351548,
 833582470,
 68669,
 -1,
 834287778,
 68671,
 -52803,
 834311215,
 68630,
 -52802,
 834436629,
 68675,
 -52801,
 834497890,
 68666,
 -52800,
 834563103,
 68660,
 -52799,
 834623589,
 68643,
 -52798,
 834685762,
 68638,
 -52797,
 834745553,
 68621,
 -52796,
 834806485,
 68625,
 -1,
 834869244,
 68617,
 835072465,
 833497218,
 -1,
 835137995,
 835016805,
 -1,
 -52792,
 835097647,
 68650,
 -52791,
 835157525,
 68646,
 -52790,
 835204305,
 68653,
 -1,
 835263437,
 68648,
 -52788,
 835098127,
 68628,
 -52787,
 835417885,
 68673,
 -52786,
 835479291,
 68655,
 -52785,
 835539484,
 68642,
 -52784,
 835604885,
 68641,
 -1,
 835656653,
 68658,
 835858903,
 835017951,
 68614,
 835924436,
 835790978,
 68615,
 -1,
 835864637,
 68636,
 -52779,
 835878421,
 68679,
 -52778,
 836004895,
 68664,
 -1,
 836069115,
 68656,
 836252122,
 835796582,
 68611,
 -52775,
 836201503,
 68662,
 -1,
 836246477,
 68657,
 -1,
 836180207,
 68680,
 836567039,
 833459460,
 -1,
 836579823,
 836439745,
 68609,
 836645349,
 836511874,
 68610,
 836710880,
 836589669,
 68645,
 -1,
 836646097,
 68654,
 -52767,
 836670511,
 68633,
 -52766,
 836795925,
 68678,
 -52765,
 836847677,
 68635,
 -52764,
 836908241,
 68624,
 -1,
 836966396,
 68620,
 -52762,
 836604975,
 68631,
 -52761,
 837123605,
 68676,
 -52760,
 837187357,
 68672,
 -52759,
 837250402,
 68667,
 -52758,
 837315615,
 68661,
 -52757,
 837376553,
 68652,
 -52756,
 837438274,
 68639,
 -52755,
 837498065,
 68622,
 -52754,
 837558997,
 68626,
 -1,
 837621756,
 68618,
 837825015,
 836511874,
 68613,
 837890548,
 837769317,
 -1,
 -52750,
 837850159,
 68651,
 -52749,
 837910037,
 68647,
 -1,
 837950413,
 68649,
 -52747,
 837850639,
 68629,
 -52746,
 838104861,
 68674,
 -1,
 838147021,
 68659,
 838349307,
 837770463,
 -1,
 838414842,
 838281346,
 68616,
 -1,
 838355005,
 68637,
 -1,
 838364191,
 68665,
 838664191,
 838286950,
 68612,
 -1,
 838560799,
 68663,
 838742592,
 833382615,
 -1,
 838808119,
 838695049,
 -1,
 838873605,
 838738645,
 -1,
 838939139,
 838799041,
 66477,
 839057407,
 838876759,
 66508,
 -1,
 838928867,
 66509,
 -52732,
 838895143,
 66479,
 -1,
 839073382,
 66478,
 839266825,
 838799041,
 66464,
 839385087,
 839223989,
 66504,
 -52728,
 839268536,
 66506,
 -1,
 839322083,
 66505,
 839528973,
 839220757,
 -1,
 -52725,
 839484967,
 66476,
 -52724,
 839530680,
 66480,
 -1,
 839585473,
 66475,
 839791121,
 839480710,
 -1,
 -52721,
 839742938,
 66498,
 -52720,
 839792824,
 66497,
 -1,
 839847617,
 66495,
 840053269,
 839733788,
 -1,
 -52717,
 840009255,
 66488,
 -52716,
 840056422,
 66487,
 -1,
 840109761,
 66486,
 840315417,
 839981052,
 -1,
 840380952,
 840240833,
 66482,
 -1,
 840316163,
 66510,
 -1,
 840338339,
 66511,
 840577564,
 840274811,
 -1,
 -52709,
 840529765,
 66507,
 -1,
 840568513,
 66471,
 840774175,
 840534960,
 -1,
 -52706,
 840711782,
 66491,
 -1,
 840765121,
 66490,
 840970786,
 840723810,
 -1,
 -52703,
 840926759,
 66493,
 -1,
 840961729,
 66492,
 841167397,
 840915045,
 -1,
 -52700,
 841123367,
 66485,
 -1,
 841158337,
 66484,
 841364008,
 841107517,
 -1,
 -52697,
 841319975,
 66468,
 -1,
 841354945,
 66467,
 841560619,
 841303863,
 -1,
 -52694,
 841498214,
 66474,
 -1,
 841551553,
 66473,
 841757230,
 841495761,
 -1,
 -52691,
 841713191,
 66470,
 -1,
 841748161,
 66469,
 -52689,
 841717279,
 66496,
 -52688,
 841913457,
 66489,
 -52687,
 841975335,
 66466,
 -52686,
 842032954,
 66481,
 -52685,
 842091376,
 66494,
 -52684,
 842153574,
 66465,
 -52683,
 842217656,
 66499,
 -52682,
 842281403,
 66483,
 -1,
 842341353,
 66472,
 842543679,
 838753319,
 -1,
 842609213,
 842497557,
 -1,
 842674748,
 842567496,
 -1,
 -52677,
 842620127,
 66514,
 -1,
 842673399,
 66516,
 -1,
 842607620,
 66515,
 -52674,
 842555382,
 66513,
 -1,
 842874404,
 66517,
 -1,
 842502940,
 66512,
 843186175,
 838695663,
 -1,
 843199080,
 843075145,
 -1,
 843264584,
 843152917,
 -1,
 843330118,
 843200674,
 -1,
 -52667,
 843263656,
 68220,
 -1,
 843323320,
 68219,
 -52665,
 843263656,
 68215,
 -1,
 843454392,
 68201,
 843657806,
 843216262,
 -1,
 843723341,
 843583169,
 -1,
 -52661,
 843677205,
 68202,
 -52660,
 843732322,
 68207,
 -1,
 843785345,
 68206,
 -1,
 843660234,
 68198,
 844051027,
 843588309,
 -1,
 844116562,
 843987128,
 -1,
 -52655,
 844058173,
 68217,
 -1,
 844113025,
 68211,
 -1,
 844042894,
 68213,
 844378710,
 843991101,
 -1,
 -52651,
 844315316,
 68205,
 -1,
 844371080,
 68203,
 844575320,
 844315162,
 68192,
 -1,
 844529841,
 68194,
 844706395,
 844510417,
 -1,
 -52646,
 844644776,
 68212,
 -1,
 844708373,
 68214,
 844903006,
 844631745,
 -1,
 -52643,
 844862871,
 68210,
 -1,
 844909881,
 68209,
 -52641,
 844863110,
 68216,
 -52640,
 845059493,
 68218,
 -52639,
 845123568,
 68197,
 -52638,
 845181091,
 68199,
 -52637,
 845245551,
 68196,
 -52636,
 845306970,
 68204,
 -52635,
 845370747,
 68195,
 -52634,
 845433893,
 68193,
 -52633,
 845492762,
 68208,
 -1,
 845552013,
 68200,
 845807615,
 843144227,
 -1,
 845820524,
 845683029,
 -1,
 -52629,
 845766646,
 68221,
 -1,
 845820592,
 68222,
 -1,
 845753814,
 68223,
 846135295,
 833301867,
 -1,
 -52625,
 846041854,
 128117,
 -1,
 846091171,
 128116,
 846331903,
 833224989,
 -1,
 846344855,
 846220873,
 -1,
 846410364,
 846270145,
 -1,
 846475896,
 846335681,
 -1,
 -52619,
 846434120,
 7267,
 -52618,
 846483996,
 7266,
 -52617,
 846547005,
 7264,
 -1,
 846612279,
 7265,
 -52615,
 846429717,
 7259,
 -52614,
 846748201,
 7261,
 -52613,
 846809922,
 7262,
 -1,
 846869713,
 7260,
 847065731,
 846351170,
 -1,
 847131263,
 846991041,
 7258,
 -1,
 847056577,
 7263,
 -52608,
 847087143,
 7273,
 -52607,
 847207647,
 7283,
 -52606,
 847265382,
 7268,
 -1,
 847325314,
 7278,
 847524488,
 847021607,
 -1,
 -52603,
 847483951,
 7277,
 -52602,
 847534853,
 7276,
 -52601,
 847586005,
 7275,
 -1,
 847649741,
 7274,
 847852173,
 847469791,
 -1,
 -52598,
 847809456,
 7286,
 -52597,
 847873167,
 7284,
 -52596,
 847919266,
 7287,
 -1,
 847976444,
 7285,
 848179858,
 847789670,
 -1,
 -52593,
 848131462,
 7269,
 -52592,
 848194914,
 7272,
 -52591,
 848256139,
 7271,
 -1,
 848312482,
 7270,
 848560127,
 848111746,
 -1,
 -52588,
 848458897,
 7282,
 -52587,
 848520955,
 7279,
 -52586,
 848582757,
 7281,
 -1,
 848634828,
 7280,
 848835237,
 846275831,
 -1,
 848900763,
 848789013,
 -1,
 -52582,
 848859758,
 7250,
 -1,
 848903525,
 7251,
 849097374,
 848852358,
 -1,
 -52579,
 849037024,
 7254,
 -1,
 849096583,
 7255,
 849293985,
 849031518,
 -1,
 -52576,
 849241202,
 7252,
 -1,
 849299087,
 7253,
 -52574,
 849254061,
 7248,
 -52573,
 849436662,
 7249,
 -52572,
 849500823,
 7257,
 -1,
 849554236,
 7256,
 849752746,
 848783099,
 -1,
 849818281,
 849709303,
 -1,
 -52568,
 849762233,
 7294,
 -1,
 849815320,
 7295,
 -1,
 849754321,
 7292,
 850080429,
 849696694,
 -1,
 -52564,
 850004529,
 7290,
 -1,
 850069380,
 7288,
 -52562,
 850030687,
 7291,
 -52561,
 850212106,
 7289,
 -1,
 850268546,
 7293,
 850473699,
 833189254,
 -1,
 850539234,
 850416600,
 -1,
 850604756,
 850480713,
 -1,
 850670262,
 850529985,
 66710,
 -52555,
 850611513,
 66688,
 -1,
 850661057,
 66715,
 850866873,
 850621830,
 -1,
 -52552,
 850803619,
 66697,
 -1,
 850857665,
 66696,
 851063483,
 850812127,
 66713,
 -1,
 851008735,
 66717,
 851194558,
 851003453,
 -1,
 -52547,
 851130552,
 66693,
 -1,
 851185469,
 66703,
 851391168,
 851126402,
 66711,
 -1,
 851323010,
 66716,
 851522243,
 851321557,
 -1,
 -52542,
 851458232,
 66698,
 -1,
 851520148,
 66694,
 -52540,
 851481713,
 66709,
 -52539,
 851678150,
 66692,
 -52538,
 851742704,
 66707,
 -52537,
 851805735,
 66714,
 -52536,
 851869323,
 66690,
 -52535,
 851930560,
 66695,
 -52534,
 851995696,
 66702,
 -52533,
 852057212,
 66706,
 -52532,
 852121160,
 66705,
 -52531,
 852183940,
 66704,
 -52530,
 852248405,
 66691,
 -52529,
 852311654,
 66712,
 -52528,
 852375736,
 66708,
 -52527,
 852440323,
 66700,
 -52526,
 852505019,
 66701,
 -52525,
 852565311,
 66699,
 -1,
 852629553,
 66689,
 852885503,
 850535671,
 -1,
 852898520,
 852786709,
 -1,
 -52521,
 852857454,
 66722,
 -1,
 852901221,
 66723,
 853095131,
 852850054,
 -1,
 -52518,
 853034720,
 66726,
 -1,
 853094279,
 66727,
 853291742,
 853029214,
 -1,
 -52515,
 853238898,
 66724,
 -1,
 853296783,
 66725,
 -52513,
 853251757,
 66720,
 -52512,
 853434358,
 66721,
 -52511,
 853498519,
 66729,
 -1,
 853551932,
 66728,
 -1,
 850467789,
 983191,
 853816055,
 850423138,
 -1,
 853881589,
 853755671,
 -1,
 853947118,
 853816391,
 -1,
 854012651,
 853893114,
 -1,
 -52504,
 853965111,
 2933,
 -52503,
 854027462,
 2930,
 -52502,
 854079764,
 2931,
 -1,
 854141791,
 2934,
 854392831,
 853967206,
 -1,
 -52499,
 854292801,
 2935,
 -1,
 854355162,
 2932,
 854536946,
 853905137,
 -1,
 854602481,
 854477634,
 2914,
 -1,
 854543170,
 2915,
 -1,
 854553745,
 2884,
 854851583,
 854478409,
 -1,
 -52492,
 854757263,
 2929,
 -1,
 854821830,
 2869,
 -52490,
 853808080,
 128217,
 -1,
 854919264,
 10183,
 855126791,
 853763835,
 -1,
 855192325,
 855058562,
 -1,
 855257860,
 855136359,
 -1,
 855323389,
 855211334,
 -1,
 -52484,
 855271607,
 10180,
 -1,
 855317333,
 10179,
 855520000,
 855266023,
 -1,
 -52481,
 855469639,
 128236,
 -1,
 855527768,
 128237,
 -52479,
 855461995,
 128275,
 -52478,
 855652745,
 128080,
 -52477,
 855716541,
 128194,
 -1,
 855775942,
 128214,
 -1,
 855207674,
 983190,
 -52474,
 855146965,
 128191,
 -1,
 855981066,
 9934,
 856175375,
 855070821,
 -1,
 856240909,
 856105023,
 -1,
 -52470,
 856194941,
 128662,
 -52469,
 856255091,
 128660,
 -52468,
 856300447,
 128653,
 -1,
 856364888,
 128664,
 -52466,
 856172718,
 11819,
 -1,
 856492156,
 128283,
 856699666,
 856132470,
 -1,
 -52463,
 856641375,
 9885,
 -1,
 856693517,
 128228,
 -52461,
 856658811,
 128002,
 -52460,
 856836172,
 128076,
 -52459,
 856896100,
 127970,
 -52458,
 856957972,
 127842,
 -1,
 857023026,
 128025,
 857224334,
 833108130,
 -1,
 857289673,
 857149121,
 -1,
 857355201,
 857233509,
 -1,
 857420736,
 857290860,
 -1,
 857486226,
 857360183,
 -1,
 857551721,
 857432237,
 -1,
 857617202,
 857503110,
 -1,
 857682729,
 857568806,
 -1,
 857748257,
 857637390,
 55245,
 -1,
 857672325,
 55246,
 857879332,
 857700597,
 -1,
 -52445,
 857833998,
 55277,
 -1,
 857885291,
 55276,
 -52443,
 857829810,
 55255,
 -52442,
 858024245,
 55270,
 -52441,
 858085998,
 4607,
 -52440,
 858150447,
 55264,
 -1,
 858201773,
 55289,
 858456063,
 857621759,
 -1,
 858469165,
 858332109,
 -1,
 -52436,
 858406995,
 55279,
 -1,
 858471192,
 55280,
 -52434,
 858423576,
 55281,
 -52433,
 858613668,
 55278,
 -52432,
 858674735,
 55274,
 -52431,
 858736899,
 55275,
 -1,
 858798879,
 55282,
 858993473,
 857564923,
 -1,
 859059003,
 858931295,
 -1,
 859124535,
 858987469,
 -1,
 -52426,
 859062355,
 55272,
 -1,
 859126552,
 55273,
 -52424,
 859079182,
 55267,
 -52423,
 859273491,
 55271,
 -52422,
 859337152,
 55268,
 -1,
 859395631,
 55269,
 859583294,
 858995511,
 -1,
 -52419,
 859537688,
 55291,
 -1,
 859601136,
 55290,
 859832319,
 859509808,
 -1,
 -52416,
 859728181,
 55283,
 -1,
 859785475,
 55284,
 859976523,
 858943915,
 -1,
 860042053,
 859935957,
 -1,
 -52412,
 859994237,
 55259,
 -1,
 860054175,
 55260,
 860238664,
 859990331,
 -1,
 -52409,
 860193294,
 55257,
 -1,
 860252410,
 55258,
 -52407,
 860191679,
 55253,
 -52406,
 860378684,
 55256,
 -1,
 860441202,
 55254,
 860631891,
 859931157,
 -1,
 860697422,
 860584176,
 55248,
 -1,
 860621394,
 55249,
 860828497,
 860625869,
 -1,
 -52400,
 860766291,
 55250,
 -1,
 860830488,
 55251,
 -52398,
 860782872,
 55252,
 -1,
 860973365,
 55247,
 861156187,
 860571709,
 -1,
 861221722,
 861095719,
 -1,
 -52394,
 861169973,
 4603,
 -52393,
 861231726,
 4602,
 -52392,
 861293077,
 4605,
 -52391,
 861354783,
 4606,
 -1,
 861412921,
 4604,
 -1,
 861148360,
 55261,
 861680480,
 861099573,
 -1,
 -52387,
 861633483,
 55263,
 -52386,
 861694274,
 55265,
 -52385,
 861756014,
 55262,
 -1,
 861806253,
 55266,
 862008163,
 861639974,
 -1,
 -52382,
 861951535,
 55285,
 -1,
 862010143,
 55286,
 862204774,
 861952628,
 -1,
 -52379,
 862155173,
 55243,
 -1,
 862199353,
 55244,
 862453759,
 862133939,
 -1,
 -52376,
 862354390,
 55288,
 -1,
 862415157,
 55287,
 862650367,
 857508203,
 -1,
 862663541,
 862535351,
 -1,
 862729075,
 862622767,
 -1,
 862794606,
 862660738,
 55232,
 -1,
 862739679,
 55231,
 862925681,
 862719681,
 -1,
 -52368,
 862857346,
 55230,
 -1,
 862915202,
 55229,
 -52366,
 862881319,
 55235,
 -1,
 863067359,
 55234,
 -52364,
 862674183,
 55233,
 -1,
 863190630,
 55236,
 863384447,
 862622767,
 -1,
 863449978,
 863329540,
 -1,
 863515513,
 863375041,
 55218,
 -1,
 863447170,
 55219,
 -1,
 863448337,
 55220,
 863712125,
 863405689,
 -1,
 -52356,
 863657183,
 55224,
 -1,
 863703175,
 55223,
 -52354,
 863644948,
 4517,
 -1,
 863833897,
 4516,
 864039813,
 863329540,
 -1,
 864105348,
 863999023,
 -1,
 864170883,
 864030401,
 4518,
 -1,
 864102530,
 4519,
 -1,
 864103697,
 55216,
 -1,
 864050439,
 55217,
 864433034,
 863973112,
 -1,
 864498568,
 864364674,
 55227,
 -1,
 864443615,
 55226,
 -52343,
 864443615,
 55228,
 -1,
 864554689,
 55225,
 864760719,
 864358081,
 -1,
 864826254,
 864710141,
 -1,
 -52339,
 864757890,
 55238,
 -1,
 864816833,
 55237,
 -1,
 864750125,
 4515,
 865140735,
 864716409,
 -1,
 -52335,
 865047821,
 55221,
 -1,
 865091258,
 55222,
 865337343,
 857415257,
 -1,
 865350562,
 865235371,
 -1,
 865416090,
 865301894,
 -1,
 865481625,
 865367590,
 -1,
 -52329,
 865436174,
 43367,
 -52328,
 865495349,
 43370,
 -1,
 865553003,
 43365,
 -1,
 865420539,
 43372,
 865809310,
 865355837,
 -1,
 -52324,
 865748769,
 43364,
 -52323,
 865811248,
 43374,
 -1,
 865866939,
 43371,
 -52321,
 865763854,
 43366,
 -52320,
 866019637,
 43369,
 -52319,
 866080303,
 43368,
 -1,
 866131629,
 43373,
 866333608,
 865305109,
 -1,
 -52316,
 866285808,
 43362,
 -52315,
 866349477,
 4446,
 -52314,
 866412853,
 43361,
 -52313,
 866473519,
 43360,
 -1,
 866524845,
 43363,
 866726829,
 866286521,
 -1,
 -52310,
 866686225,
 43388,
 -52309,
 866746648,
 43385,
 -52308,
 866810107,
 43381,
 -1,
 866852538,
 43384,
 867054515,
 866674427,
 -1,
 867120050,
 866992223,
 -1,
 -52304,
 867072262,
 43378,
 -52303,
 867125781,
 43379,
 -1,
 867187487,
 43380,
 -1,
 867056447,
 43386,
 867447735,
 866998900,
 -1,
 -52299,
 867399920,
 4443,
 -52298,
 867449631,
 4445,
 -1,
 867507885,
 4444,
 867709883,
 867391029,
 -1,
 -52295,
 867664398,
 43376,
 -52294,
 867727600,
 43377,
 -1,
 867781227,
 43375,
 867972030,
 867647576,
 -1,
 -52291,
 867922341,
 43382,
 -1,
 867973919,
 43383,
 -52289,
 867912319,
 4442,
 -1,
 868104997,
 43387,
 -1,
 857351105,
 128092,
 868365254,
 857297436,
 -1,
 868430788,
 868308401,
 128296,
 -1,
 868352112,
 9874,
 -52283,
 868383814,
 128057,
 -1,
 868490136,
 127828,
 -52281,
 868319110,
 128035,
 -52280,
 868641538,
 128587,
 -1,
 868697413,
 128135,
 868889683,
 857221250,
 -1,
 868955177,
 868848591,
 -1,
 869020640,
 868908565,
 -1,
 869086175,
 868956701,
 -1,
 869151697,
 869014477,
 -1,
 -52273,
 869101495,
 19904,
 -52272,
 869158779,
 19933,
 -1,
 869209928,
 19953,
 869413846,
 869076673,
 -1,
 869479381,
 869363042,
 -1,
 -52268,
 869426388,
 19954,
 -1,
 869488716,
 19910,
 -1,
 869407680,
 19932,
 869741529,
 869371720,
 -1,
 -52264,
 869673894,
 19951,
 -1,
 869733302,
 19959,
 -52262,
 869691343,
 19905,
 -52261,
 869880865,
 19957,
 -52260,
 869943710,
 19955,
 -52259,
 870008848,
 19961,
 -52258,
 870069842,
 19960,
 -1,
 870134268,
 19940,
 -1,
 869035906,
 19913,
 870396906,
 868950741,
 -1,
 870462437,
 870328450,
 -1,
 -52253,
 870419667,
 19956,
 -52252,
 870469566,
 19943,
 -1,
 870523191,
 19944,
 870724584,
 870399590,
 -1,
 -52249,
 870677301,
 19962,
 -1,
 870724222,
 19906,
 -52247,
 870681289,
 19935,
 -1,
 870847836,
 19939,
 871052277,
 870331601,
 -1,
 871117812,
 871001442,
 -1,
 871183347,
 871049697,
 -1,
 871248882,
 871130875,
 -1,
 871314417,
 871193823,
 -1,
 -52240,
 871272516,
 19937,
 -1,
 871332833,
 19917,
 -1,
 871264376,
 19931,
 -1,
 871202641,
 19929,
 -1,
 871108597,
 19925,
 -1,
 871044829,
 19948,
 871773179,
 871003526,
 -1,
 871838713,
 871715638,
 -1,
 -52232,
 871792465,
 19912,
 -1,
 871852838,
 19965,
 -52230,
 871792476,
 19915,
 -1,
 871983534,
 19926,
 872166401,
 871711208,
 -1,
 872231935,
 872110181,
 -1,
 -52226,
 872177007,
 19928,
 -1,
 872230303,
 19964,
 -52224,
 872166289,
 19934,
 -1,
 872358199,
 19945,
 872559622,
 872116095,
 -1,
 872625157,
 872513045,
 -1,
 -52220,
 872581884,
 19927,
 -1,
 872640416,
 19936,
 -1,
 872582794,
 19952,
 872887306,
 872507131,
 -1,
 -52216,
 872844107,
 19949,
 -52215,
 872903699,
 19938,
 -1,
 872950137,
 19914,
 873149455,
 872832223,
 -1,
 873214990,
 873097922,
 -1,
 -52211,
 873164976,
 19950,
 -1,
 873227065,
 19941,
 -1,
 873143134,
 19942,
 873477140,
 873078796,
 -1,
 873542675,
 873420901,
 -1,
 -52206,
 873496594,
 19923,
 -1,
 873542523,
 19909,
 -1,
 873485947,
 19947,
 873804824,
 873404412,
 -1,
 -52202,
 873754516,
 19946,
 -52201,
 873809513,
 19924,
 -1,
 873867991,
 19967,
 874066972,
 873729729,
 -1,
 -52198,
 874015469,
 19922,
 -52197,
 874067112,
 19966,
 -1,
 874126214,
 19958,
 874329119,
 874024776,
 -1,
 -52194,
 874275521,
 19921,
 -1,
 874320341,
 19908,
 874525730,
 874272505,
 -1,
 -52191,
 874482569,
 19930,
 -1,
 874521703,
 19918,
 874722341,
 874459486,
 -1,
 -52188,
 874667816,
 19920,
 -1,
 874720182,
 19916,
 -52186,
 874681770,
 19907,
 -52185,
 874860342,
 19963,
 -52184,
 874921085,
 19911,
 -1,
 874982617,
 19919,
 875181127,
 868880065,
 -1,
 875246653,
 875138878,
 -1,
 875312176,
 875175622,
 11096,
 875377711,
 875235236,
 -1,
 -52178,
 875330803,
 9955,
 -1,
 875372237,
 11095,
 -1,
 875307775,
 11097,
 875639861,
 875252546,
 -1,
 875705396,
 875587178,
 -1,
 -52173,
 875657419,
 10079,
 -1,
 875701969,
 10080,
 -1,
 875631926,
 11093,
 875967544,
 875569877,
 -1,
 -52169,
 875912989,
 128178,
 -1,
 875972307,
 10135,
 -52167,
 875925659,
 9947,
 -52166,
 876112365,
 10133,
 -52165,
 876176667,
 11094,
 -52164,
 876238491,
 10134,
 -1,
 876294267,
 10071,
 876491844,
 875195746,
 -1,
 876557379,
 876445207,
 -1,
 876622914,
 876515687,
 -1,
 -52159,
 876573047,
 128157,
 -1,
 876615083,
 128152,
 -1,
 876553198,
 128159,
 -1,
 876481138,
 128585,
 877002751,
 876421845,
 -1,
 -52154,
 876903559,
 9980,
 -1,
 876964098,
 127911,
 877147215,
 875109181,
 -1,
 877212749,
 877094651,
 -1,
 877278284,
 877158036,
 -1,
 -52149,
 877227084,
 1479,
 -1,
 877280361,
 1466,
 -1,
 877234451,
 1478,
 -52146,
 877155319,
 1477,
 -1,
 877465569,
 1442,
 877671506,
 877087554,
 -1,
 -52143,
 877614559,
 9937,
 -1,
 877674399,
 128641,
 -1,
 877621041,
 127807,
 877933680,
 868834527,
 -1,
 877999202,
 877882722,
 -1,
 878064734,
 877938478,
 -1,
 878130268,
 878018069,
 -1,
 878195803,
 878055372,
 983059,
 878313471,
 878116864,
 -1,
 -52134,
 878219661,
 983140,
 -1,
 878278398,
 983137,
 -1,
 878145027,
 128677,
 -52131,
 878072601,
 9897,
 -1,
 878451262,
 11043,
 878706687,
 878016123,
 128014,
 878772223,
 878575616,
 -1,
 -52127,
 878669275,
 127943,
 -1,
 878719422,
 128052,
 878916711,
 877954599,
 -1,
 878982246,
 878868094,
 -1,
 -52123,
 878940545,
 127969,
 -1,
 878975861,
 127968,
 -1,
 878932239,
 9203,
 879244394,
 878870037,
 -1,
 -52119,
 879176582,
 127976,
 -1,
 879231181,
 9749,
 879441005,
 879188517,
 -1,
 -52116,
 879368483,
 128029,
 -1,
 879429094,
 127855,
 -52114,
 879393627,
 127973,
 -52113,
 879585019,
 983123,
 -1,
 879631952,
 128298,
 879834244,
 877870694,
 -1,
 879899769,
 879783440,
 -1,
 879965304,
 879827399,
 -1,
 -52108,
 879920679,
 983959,
 -52107,
 879975647,
 983961,
 -52106,
 880033382,
 983958,
 -52105,
 880093314,
 983960,
 -1,
 880152257,
 983957,
 -1,
 879891726,
 110593,
 880424066,
 879834794,
 -1,
 880489598,
 880347614,
 -1,
 880555133,
 880442153,
 128644,
 -1,
 880478123,
 128645,
 -1,
 880491111,
 128096,
 880803839,
 880410624,
 -1,
 -52096,
 880709245,
 9889,
 -52095,
 880762251,
 983122,
 -1,
 880810819,
 128262,
 -52093,
 880376990,
 9964,
 -1,
 880941582,
 127802,
 881144967,
 879787541,
 983060,
 -52090,
 881096070,
 983138,
 -1,
 881149751,
 983141,
 881341578,
 881104326,
 -1,
 -52087,
 881286589,
 11794,
 -1,
 881343100,
 11802,
 881538189,
 881296935,
 -1,
 -52084,
 881489875,
 128559,
 -1,
 881547649,
 128175,
 -1,
 881489274,
 8372,
 881800650,
 857167973,
 -1,
 881866059,
 881731714,
 -1,
 881931524,
 881823560,
 -1,
 881997059,
 881852416,
 -1,
 882062591,
 881950451,
 -1,
 882128086,
 882003529,
 -1,
 882193585,
 882069780,
 -1,
 882259097,
 882146837,
 -1,
 -52073,
 882210266,
 6539,
 -52072,
 882260152,
 6546,
 -1,
 882314945,
 6545,
 882521244,
 882217851,
 -1,
 -52069,
 882478022,
 6569,
 -1,
 882511553,
 6534,
 882717855,
 882472326,
 -1,
 -52066,
 882673304,
 6571,
 -1,
 882708161,
 6540,
 882914466,
 882665211,
 -1,
 -52063,
 882849976,
 6552,
 -1,
 882904769,
 6551,
 883111077,
 882858085,
 -1,
 -52060,
 883045635,
 6535,
 -1,
 883101377,
 6547,
 883307688,
 883050557,
 -1,
 -52057,
 883264454,
 6568,
 -1,
 883297985,
 6533,
 -52055,
 883266673,
 6541,
 -52054,
 883461062,
 6558,
 -52053,
 883518509,
 6529,
 -52052,
 883577461,
 6553,
 -52051,
 883641200,
 6559,
 -52050,
 883701944,
 6563,
 -52049,
 883765691,
 6557,
 -52048,
 883827506,
 6564,
 -1,
 883890225,
 6565,
 884094158,
 882129740,
 -1,
 884159670,
 884047381,
 -1,
 -52044,
 884110810,
 6536,
 -52043,
 884160696,
 6543,
 -1,
 884215489,
 6542,
 884421817,
 884118395,
 -1,
 -52040,
 884378566,
 6567,
 -1,
 884412097,
 6531,
 884618428,
 884372870,
 -1,
 -52037,
 884573848,
 6570,
 -1,
 884608705,
 6537,
 884815039,
 884565755,
 -1,
 -52034,
 884750520,
 6549,
 -1,
 884805313,
 6548,
 885011650,
 884758629,
 -1,
 -52031,
 884946179,
 6532,
 -1,
 885001921,
 6544,
 885208261,
 884951101,
 -1,
 -52028,
 885164998,
 6566,
 -1,
 885198529,
 6530,
 -52026,
 885167217,
 6538,
 -52025,
 885361606,
 6555,
 -52024,
 885419053,
 6528,
 -52023,
 885478005,
 6550,
 -52022,
 885541744,
 6556,
 -52021,
 885602488,
 6560,
 -52020,
 885666235,
 6554,
 -52019,
 885728050,
 6561,
 -1,
 885790769,
 6562,
 886046719,
 884028113,
 -1,
 886060241,
 885938277,
 6595,
 -1,
 885994705,
 6594,
 -52014,
 886016944,
 6593,
 -52013,
 886133276,
 6596,
 -52012,
 886196285,
 6597,
 -52011,
 886252245,
 6598,
 -1,
 886315004,
 6599,
 886519018,
 882085591,
 -1,
 886584540,
 886474279,
 6579,
 886650074,
 886515842,
 6585,
 -1,
 886608943,
 6591,
 -52005,
 886608943,
 6588,
 -1,
 886736423,
 6580,
 886912224,
 886529247,
 6583,
 886977759,
 886836929,
 6584,
 -1,
 886936623,
 6590,
 -1,
 886936623,
 6589,
 887174373,
 886836929,
 -1,
 887239907,
 887099073,
 6577,
 -1,
 887198767,
 6587,
 -51996,
 887198767,
 6586,
 -1,
 887302274,
 6582,
 887502056,
 887111270,
 -1,
 -51993,
 887460911,
 6592,
 -1,
 887504486,
 6578,
 -51991,
 887459527,
 6576,
 -1,
 887629954,
 6581,
 887829752,
 886449399,
 -1,
 887895278,
 887782933,
 -1,
 -51987,
 887853678,
 6610,
 -1,
 887897445,
 6611,
 888091889,
 887846278,
 -1,
 -51984,
 888030944,
 6614,
 -1,
 888090503,
 6615,
 888288500,
 888025438,
 -1,
 -51981,
 888235122,
 6612,
 -1,
 888293007,
 6613,
 -51979,
 888247981,
 6608,
 -51978,
 888430582,
 6609,
 -51977,
 888494743,
 6617,
 -1,
 888548156,
 6616,
 888747261,
 887782933,
 -1,
 888812796,
 888692796,
 -1,
 -51973,
 888736819,
 6601,
 -1,
 888802211,
 6600,
 -1,
 888748346,
 6618,
 889126911,
 888699037,
 6622,
 -1,
 889031600,
 6623,
 889206018,
 882005891,
 -1,
 -51967,
 889164151,
 127770,
 -1,
 889224658,
 127761,
 -1,
 889147201,
 983063,
 -1,
 881949474,
 128240,
 889533765,
 881866142,
 -1,
 889599271,
 889486208,
 -1,
 889664801,
 889539687,
 -1,
 -51960,
 889624079,
 127369,
 -51959,
 889689135,
 127368,
 -51958,
 889754491,
 127367,
 -51957,
 889818952,
 127366,
 -51956,
 889883568,
 127365,
 -51955,
 889947687,
 127364,
 -51954,
 890011157,
 127363,
 -51953,
 890074502,
 127362,
 -51952,
 890137954,
 127361,
 -51951,
 890203167,
 127360,
 -51950,
 890267387,
 127359,
 -51949,
 890330335,
 127358,
 -51948,
 890394725,
 127357,
 -51947,
 890458652,
 127356,
 -51946,
 890522434,
 127355,
 -51945,
 890587197,
 127354,
 -51944,
 890652471,
 127353,
 -51943,
 890715750,
 127352,
 -51942,
 890779810,
 127351,
 -51941,
 890844369,
 127350,
 -51940,
 890909022,
 127349,
 -51939,
 890972290,
 127348,
 -51938,
 891036373,
 127347,
 -51937,
 891100109,
 127346,
 -51936,
 891164668,
 127345,
 -1,
 891227841,
 127344,
 -51934,
 889622557,
 127375,
 -51933,
 891385306,
 127373,
 -51932,
 891447098,
 127372,
 -51931,
 891502408,
 127371,
 -51930,
 891560305,
 10062,
 -1,
 891621212,
 127374,
 891827524,
 889528027,
 -1,
 891893059,
 891767911,
 -1,
 -51926,
 891852303,
 127337,
 -51925,
 891917359,
 127336,
 -51924,
 891982715,
 127335,
 -51923,
 892047176,
 127334,
 -51922,
 892111792,
 127333,
 -51921,
 892175911,
 127332,
 -51920,
 892239381,
 127331,
 -51919,
 892302726,
 127330,
 -51918,
 892366178,
 127329,
 -51917,
 892431391,
 127328,
 -51916,
 892495611,
 127327,
 -51915,
 892558559,
 127326,
 -51914,
 892622949,
 127325,
 -51913,
 892686876,
 127324,
 -51912,
 892750658,
 127323,
 -51911,
 892815421,
 127322,
 -51910,
 892880695,
 127321,
 -51909,
 892943974,
 127320,
 -51908,
 893008034,
 127319,
 -51907,
 893072593,
 127318,
 -51906,
 893137246,
 127317,
 -51905,
 893200514,
 127316,
 -51904,
 893264597,
 127315,
 -51903,
 893328333,
 127314,
 -51902,
 893392892,
 127313,
 -1,
 893456065,
 127312,
 -1,
 891823358,
 9471,
 -1,
 891752462,
 983091,
 893793608,
 889490294,
 -1,
 -51897,
 893742733,
 128528,
 -1,
 893791592,
 9906,
 -51895,
 893752343,
 983130,
 -51894,
 893930306,
 983131,
 -1,
 893984641,
 128084,
 894186901,
 881805977,
 -1,
 894252404,
 894126914,
 -1,
 894317938,
 894185160,
 -1,
 894383443,
 894261349,
 2002,
 894448977,
 894342257,
 2018,
 -1,
 894372301,
 2023,
 894631935,
 894373569,
 2019,
 -1,
 894503373,
 2016,
 894711129,
 894322487,
 -1,
 894776664,
 894656492,
 -1,
 -51882,
 894725568,
 2026,
 -51881,
 894781269,
 2024,
 -1,
 894836151,
 2025,
 -1,
 894701249,
 2006,
 895104348,
 894659938,
 -1,
 -51877,
 895053248,
 2010,
 -1,
 895094465,
 2009,
 895300958,
 895048927,
 2000,
 -1,
 895245535,
 1999,
 895432032,
 895232130,
 1997,
 -1,
 895363202,
 1995,
 895563106,
 895361842,
 2008,
 -1,
 895497696,
 2001,
 -51869,
 895521905,
 2022,
 -51868,
 895651727,
 2021,
 -51867,
 895714855,
 1998,
 -51866,
 895778443,
 2005,
 -51865,
 895841754,
 2011,
 -51864,
 895903546,
 2004,
 -51863,
 895963765,
 2017,
 -51862,
 896027504,
 2015,
 -51861,
 896092303,
 2014,
 -51860,
 896155238,
 1996,
 -51859,
 896219320,
 2020,
 -51858,
 896284100,
 2012,
 -51857,
 896348603,
 2013,
 -51856,
 896409015,
 2007,
 -51855,
 896473137,
 2003,
 -1,
 896536257,
 1994,
 -51853,
 894264970,
 2037,
 -1,
 896668148,
 2042,
 896873858,
 894182647,
 -1,
 896939384,
 896826901,
 -1,
 -51849,
 896897646,
 1986,
 -1,
 896941413,
 1987,
 897135995,
 896890246,
 -1,
 -51846,
 897074912,
 1990,
 -1,
 897134471,
 1991,
 897332606,
 897069406,
 -1,
 -51843,
 897279090,
 1988,
 -1,
 897336975,
 1989,
 -51841,
 897291949,
 1984,
 -51840,
 897474550,
 1985,
 -51839,
 897538711,
 1993,
 -1,
 897592124,
 1992,
 897791376,
 896802864,
 -1,
 897856911,
 897718771,
 -1,
 897922441,
 897798289,
 -1,
 -51834,
 897872770,
 2033,
 -51833,
 897929520,
 2032,
 -51832,
 897989508,
 2031,
 -1,
 898049090,
 2030,
 898250125,
 897873968,
 -1,
 -51829,
 898200450,
 2029,
 -51828,
 898257200,
 2028,
 -1,
 898317188,
 2027,
 -51826,
 898193652,
 2034,
 -1,
 898442998,
 2035,
 -1,
 897798773,
 2040,
 898708883,
 897744345,
 -1,
 -51822,
 898654451,
 2038,
 -1,
 898708936,
 2039,
 -51820,
 898644878,
 2036,
 -1,
 898838608,
 2041,
 899036604,
 894131423,
 -1,
 899102124,
 898987224,
 -1,
 899167654,
 899039830,
 -1,
 899233185,
 899101767,
 -1,
 899298718,
 899178490,
 -1,
 -51813,
 899250487,
 43059,
 -51812,
 899312838,
 43056,
 -51811,
 899365140,
 43057,
 -1,
 899427167,
 43060,
 899678207,
 899252582,
 -1,
 -51808,
 899578177,
 43061,
 -1,
 899640538,
 43058,
 899823012,
 899181687,
 -1,
 -51805,
 899773646,
 43062,
 -1,
 899832822,
 43065,
 -51803,
 899773767,
 43064,
 -1,
 899967333,
 43063,
 900150697,
 899125320,
 -1,
 -51800,
 900108418,
 11009,
 -1,
 900143653,
 11017,
 900399103,
 900082103,
 -1,
 -51797,
 900305026,
 11008,
 -1,
 900340261,
 11016,
 900543926,
 899022848,
 -1,
 900609455,
 900476145,
 9940,
 -1,
 900531785,
 128683,
 900740530,
 900536316,
 -1,
 -51791,
 900689802,
 983126,
 -1,
 900743097,
 128691,
 -51789,
 900692632,
 128685,
 -51788,
 900884517,
 128695,
 -51787,
 900948053,
 128286,
 -1,
 901011196,
 128245,
 901199290,
 900496917,
 -1,
 901264825,
 901130784,
 128211,
 -1,
 901187609,
 128212,
 -1,
 901193190,
 128323,
 -51781,
 901150331,
 128067,
 -1,
 901404828,
 128689,
 901592512,
 898991655,
 -1,
 901658047,
 901532482,
 983041,
 -1,
 901598018,
 983040,
 -1,
 901611034,
 128297,
 901854660,
 901516993,
 -1,
 -51774,
 901797071,
 128219,
 -51773,
 901859389,
 983092,
 -1,
 901923163,
 128133,
 902116807,
 901781500,
 -1,
 -51770,
 902068990,
 983196,
 -1,
 902117538,
 983127,
 -51768,
 902060320,
 983221,
 -51767,
 902253378,
 983066,
 -1,
 902316269,
 127747,
 902510316,
 881730261,
 -1,
 902575711,
 902454495,
 -1,
 902641219,
 902518416,
 -1,
 902706696,
 902597929,
 -1,
 902772231,
 902629856,
 -1,
 902837719,
 902696459,
 -1,
 -51759,
 902761949,
 127123,
 -51758,
 902827376,
 127122,
 -51757,
 902892850,
 127121,
 -51756,
 902958282,
 127120,
 -51755,
 903023667,
 127119,
 -51754,
 903089059,
 127118,
 -1,
 903154464,
 127117,
 903362015,
 902761916,
 -1,
 -51751,
 903286237,
 127116,
 -51750,
 903351664,
 127115,
 -51749,
 903417138,
 127114,
 -51748,
 903482570,
 127113,
 -51747,
 903547955,
 127112,
 -51746,
 903613347,
 127111,
 -1,
 903678752,
 127110,
 903886311,
 903286112,
 -1,
 -51743,
 903810525,
 127109,
 -51742,
 903875952,
 127108,
 -51741,
 903941426,
 127107,
 -51740,
 904006858,
 127106,
 -51739,
 904072243,
 127105,
 -51738,
 904137635,
 127104,
 -1,
 904203040,
 127103,
 904410607,
 903810337,
 -1,
 -51735,
 904334813,
 127102,
 -51734,
 904400240,
 127101,
 -51733,
 904465714,
 127100,
 -51732,
 904531146,
 127099,
 -51731,
 904596531,
 127098,
 -51730,
 904661923,
 127097,
 -1,
 904727328,
 127096,
 904934903,
 904334501,
 -1,
 -51727,
 904859101,
 127095,
 -51726,
 904924528,
 127094,
 -51725,
 904990002,
 127093,
 -51724,
 905055434,
 127092,
 -51723,
 905120819,
 127091,
 -51722,
 905186211,
 127090,
 -1,
 905251616,
 127089,
 905459199,
 904858641,
 -1,
 -51719,
 905383389,
 127088,
 -51718,
 905448816,
 127087,
 -51717,
 905514290,
 127086,
 -51716,
 905579722,
 127085,
 -51715,
 905645107,
 127084,
 -51714,
 905710499,
 127083,
 -1,
 905775904,
 127082,
 906035199,
 905382802,
 -1,
 -51711,
 905907677,
 127081,
 -51710,
 905973104,
 127080,
 -51709,
 906038578,
 127079,
 -51708,
 906104010,
 127078,
 -51707,
 906169395,
 127077,
 -51706,
 906234787,
 127076,
 -1,
 906300192,
 127075,
 -1,
 902693051,
 127074,
 906625023,
 902642885,
 -1,
 906638914,
 906496480,
 -1,
 906704402,
 906563083,
 -1,
 -51700,
 906628573,
 127073,
 -51699,
 906694000,
 127072,
 -51698,
 906759474,
 127071,
 -51697,
 906824906,
 127070,
 -51696,
 906890291,
 127069,
 -51695,
 906955683,
 127068,
 -1,
 907021088,
 127067,
 907228698,
 906628540,
 -1,
 -51692,
 907152861,
 127066,
 -51691,
 907218288,
 127065,
 -51690,
 907283762,
 127064,
 -51689,
 907349194,
 127063,
 -51688,
 907414579,
 127062,
 -51687,
 907479971,
 127061,
 -1,
 907545376,
 127060,
 907752994,
 907152736,
 -1,
 -51684,
 907677149,
 127059,
 -51683,
 907742576,
 127058,
 -51682,
 907808050,
 127057,
 -51681,
 907873482,
 127056,
 -51680,
 907938867,
 127055,
 -51679,
 908004259,
 127054,
 -1,
 908069664,
 127053,
 908277290,
 907676961,
 -1,
 -51676,
 908201437,
 127052,
 -51675,
 908266864,
 127051,
 -51674,
 908332338,
 127050,
 -51673,
 908397770,
 127049,
 -51672,
 908463155,
 127048,
 -51671,
 908528547,
 127047,
 -1,
 908593952,
 127046,
 908801586,
 908201125,
 -1,
 -51668,
 908725725,
 127045,
 -51667,
 908791152,
 127044,
 -51666,
 908856626,
 127043,
 -51665,
 908922058,
 127042,
 -51664,
 908987443,
 127041,
 -51663,
 909052835,
 127040,
 -1,
 909118240,
 127039,
 909325882,
 908725265,
 -1,
 -51660,
 909250013,
 127038,
 -51659,
 909315440,
 127037,
 -51658,
 909380914,
 127036,
 -51657,
 909446346,
 127035,
 -51656,
 909511731,
 127034,
 -51655,
 909577123,
 127033,
 -1,
 909642528,
 127032,
 909901823,
 909249426,
 -1,
 -51652,
 909774301,
 127031,
 -51651,
 909839728,
 127030,
 -51650,
 909905202,
 127029,
 -51649,
 909970634,
 127028,
 -51648,
 910036019,
 127027,
 -51647,
 910101411,
 127026,
 -1,
 910166816,
 127025,
 -1,
 906559675,
 127024,
 910440013,
 902596135,
 -1,
 910505548,
 910367326,
 -1,
 910571080,
 910435031,
 -1,
 -51641,
 910512911,
 9891,
 -1,
 910570052,
 9890,
 910767691,
 910491648,
 -1,
 -51638,
 910712111,
 11799,
 -1,
 910762658,
 10175,
 -1,
 910691075,
 8508,
 -1,
 910440158,
 127849,
 911095379,
 910394514,
 -1,
 -51633,
 911049635,
 11784,
 -51632,
 911113058,
 11034,
 -51631,
 911176278,
 11798,
 -51630,
 911236386,
 11795,
 -1,
 911286635,
 8284,
 911488602,
 911053379,
 -1,
 911554135,
 911445933,
 -1,
 -51626,
 911481381,
 11015,
 -1,
 911545159,
 11796,
 911802367,
 911477388,
 -1,
 -51623,
 911702550,
 128317,
 -1,
 911765522,
 128315,
 911947356,
 911422673,
 128021,
 -1,
 911868350,
 128054,
 -51619,
 911893083,
 128682,
 -51618,
 912019855,
 128044,
 -1,
 912065363,
 128687,
 912275106,
 902506626,
 -1,
 912340628,
 912231344,
 -1,
 912406157,
 912266046,
 -1,
 912471668,
 912346697,
 -1,
 912537190,
 912426535,
 -1,
 -51611,
 912492507,
 2423,
 -1,
 912533634,
 2422,
 912733801,
 912481503,
 -1,
 -51608,
 912678364,
 2420,
 -1,
 912730242,
 2419,
 912930412,
 912667857,
 -1,
 -51605,
 912871679,
 2429,
 -1,
 912930051,
 2427,
 -51603,
 912889604,
 2425,
 -51602,
 913078327,
 2308,
 -51601,
 913131480,
 2428,
 -51600,
 913193566,
 2426,
 -51599,
 913253327,
 2430,
 -51598,
 913316939,
 2418,
 -51597,
 913381632,
 2431,
 -1,
 913446840,
 2421,
 913651328,
 912423049,
 -1,
 913716859,
 913579118,
 -1,
 913782393,
 913669653,
 -1,
 -51592,
 913740398,
 43253,
 -1,
 913784165,
 43254,
 -51590,
 913739250,
 43251,
 -1,
 913905514,
 43255,
 -51588,
 913668871,
 43250,
 -51587,
 914058230,
 43256,
 -51586,
 914113641,
 2304,
 -51585,
 914176871,
 2417,
 -1,
 914237111,
 43252,
 914437770,
 913608407,
 -1,
 914503300,
 914392615,
 -1,
 -51581,
 914458587,
 2391,
 -1,
 914499714,
 2390,
 914699911,
 914447583,
 -1,
 -51578,
 914644444,
 2363,
 -1,
 914696322,
 2362,
 -51576,
 914647900,
 2382,
 -51575,
 914824276,
 2389,
 -1,
 914888632,
 2383,
 -51573,
 914373172,
 43259,
 -51572,
 915027334,
 43257,
 -1,
 915086528,
 43258,
 915341311,
 912342865,
 -1,
 915355281,
 915242517,
 -1,
 -51568,
 915313262,
 983085,
 -1,
 915357029,
 983087,
 -51566,
 915307725,
 983160,
 -51565,
 915496950,
 983083,
 -1,
 915551225,
 983089,
 915748507,
 912291575,
 -1,
 915814040,
 915700218,
 -1,
 -51561,
 915758720,
 66638,
 -1,
 915812407,
 66639,
 916062207,
 915741852,
 -1,
 -51558,
 915955328,
 66598,
 -1,
 916009015,
 66599,
 916207262,
 915688258,
 983119,
 -51555,
 916145863,
 128666,
 -1,
 916205208,
 983118,
 916403873,
 916135581,
 -1,
 -51552,
 916345595,
 9192,
 -1,
 916400187,
 127795,
 -1,
 916350948,
 127980,
 916666067,
 912211558,
 -1,
 916731586,
 916600017,
 -1,
 916797108,
 916669937,
 -1,
 916862632,
 916756146,
 -1,
 -51545,
 916796608,
 127232,
 -1,
 916856919,
 127233,
 917059243,
 916815381,
 -1,
 -51542,
 917017214,
 127235,
 -1,
 917060987,
 127236,
 917255854,
 917009798,
 -1,
 -51539,
 917194471,
 127239,
 -1,
 917254034,
 127240,
 917452465,
 917188958,
 -1,
 -51536,
 917398651,
 127237,
 -1,
 917456536,
 127238,
 -51534,
 917397503,
 127234,
 -51533,
 917592732,
 127242,
 -1,
 917646153,
 127241,
 917897215,
 916745887,
 -1,
 917911225,
 917776817,
 119557,
 918028287,
 917852687,
 -1,
 -51528,
 917932187,
 119556,
 -1,
 917973478,
 119555,
 918173372,
 917851700,
 -1,
 -51525,
 918110696,
 9869,
 -1,
 918164423,
 9870,
 918369983,
 918108322,
 -1,
 -51522,
 918325408,
 119554,
 -1,
 918366700,
 119553,
 918618111,
 918304800,
 -1,
 -51519,
 918503912,
 9871,
 -1,
 918557639,
 9868,
 918763209,
 916656918,
 -1,
 918828744,
 918720871,
 -1,
 -51515,
 918782752,
 11032,
 -51514,
 918843899,
 11031,
 -51513,
 918900100,
 11030,
 -1,
 918952664,
 11033,
 -1,
 918779803,
 128160,
 919221966,
 918713818,
 -1,
 919287501,
 919169739,
 -1,
 -51508,
 919220670,
 128542,
 -1,
 919280547,
 128549,
 -1,
 919214690,
 9933,
 919549649,
 919181128,
 -1,
 -51504,
 919502290,
 128171,
 -1,
 919548350,
 128565,
 -51502,
 919506583,
 9902,
 -1,
 919695338,
 127919,
 919877339,
 916614498,
 -1,
 919942871,
 919821535,
 -1,
 -51498,
 919890319,
 128167,
 -1,
 919950601,
 128042,
 920139481,
 919867752,
 128009,
 -1,
 920060350,
 128050,
 -51494,
 920078009,
 9946,
 -1,
 920202867,
 128087,
 920401636,
 919801537,
 -1,
 920467167,
 920344677,
 -1,
 -51490,
 920401790,
 127841,
 -1,
 920460696,
 128131,
 920663778,
 920401552,
 -1,
 -51487,
 920613348,
 11831,
 -1,
 920669551,
 11830,
 -51485,
 920616590,
 983081,
 -1,
 920811320,
 128168,
 920991466,
 920329165,
 -1,
 -51482,
 920941958,
 983161,
 -51481,
 920980786,
 983090,
 -51480,
 921046218,
 983088,
 -51479,
 921111603,
 983086,
 -1,
 921176995,
 983084,
 -51477,
 920947842,
 128192,
 -1,
 921324782,
 983082,
 921516008,
 902458722,
 -1,
 921581391,
 921446530,
 -1,
 921646877,
 921519977,
 -1,
 921712395,
 921587273,
 -1,
 921777913,
 921655397,
 -1,
 921843444,
 921736239,
 -1,
 -51469,
 921782101,
 43333,
 -1,
 921833153,
 43323,
 922040055,
 921777361,
 -1,
 -51466,
 921974019,
 43331,
 -1,
 922029761,
 43314,
 -51464,
 921969458,
 43332,
 -1,
 922160833,
 43317,
 922367740,
 921719324,
 -1,
 -51461,
 922294321,
 43330,
 -1,
 922357441,
 43320,
 -51459,
 922326129,
 43327,
 -51458,
 922521487,
 43328,
 -51457,
 922582667,
 43315,
 -51456,
 922645978,
 43324,
 -51455,
 922709440,
 43325,
 -51454,
 922773306,
 43318,
 -51453,
 922831728,
 43326,
 -51452,
 922896527,
 43312,
 -51451,
 922961749,
 43322,
 -51450,
 923023544,
 43329,
 -51449,
 923088131,
 43313,
 -51448,
 923149106,
 43316,
 -51447,
 923212777,
 43321,
 -51446,
 923277361,
 43319,
 -1,
 923340481,
 43334,
 923547415,
 921668528,
 -1,
 923612950,
 923494051,
 -1,
 923678480,
 923543682,
 43337,
 -51441,
 923633191,
 43341,
 -1,
 923668161,
 43342,
 923875091,
 923602625,
 -1,
 -51438,
 923829799,
 43340,
 -1,
 923876966,
 43338,
 -51436,
 923829799,
 43336,
 -51435,
 924015839,
 43339,
 -1,
 924073574,
 43335,
 -1,
 923551026,
 43347,
 924333852,
 923476105,
 -1,
 924399386,
 924276837,
 43344,
 -1,
 924333265,
 43343,
 -51429,
 924347746,
 43345,
 -1,
 924465314,
 43346,
 -1,
 924284561,
 43359,
 924727096,
 921581374,
 -1,
 -51425,
 924685839,
 127487,
 -51424,
 924750895,
 127486,
 -51423,
 924816251,
 127485,
 -51422,
 924880712,
 127484,
 -51421,
 924945328,
 127483,
 -51420,
 925009447,
 127482,
 -51419,
 925072917,
 127481,
 -51418,
 925136262,
 127480,
 -51417,
 925199714,
 127479,
 -51416,
 925264927,
 127478,
 -51415,
 925329147,
 127477,
 -51414,
 925392095,
 127476,
 -51413,
 925456485,
 127475,
 -51412,
 925520412,
 127474,
 -51411,
 925584194,
 127473,
 -51410,
 925648957,
 127472,
 -51409,
 925714231,
 127471,
 -51408,
 925777510,
 127470,
 -51407,
 925841570,
 127469,
 -51406,
 925906129,
 127468,
 -51405,
 925970782,
 127467,
 -51404,
 926034050,
 127466,
 -51403,
 926098133,
 127465,
 -51402,
 926161869,
 127464,
 -51401,
 926226428,
 127463,
 -1,
 926289601,
 127462,
 926496581,
 924683184,
 -1,
 926562116,
 926428689,
 -1,
 926627649,
 926482432,
 -1,
 926693182,
 926581298,
 -1,
 -51395,
 926642839,
 11079,
 -1,
 926698958,
 11073,
 -51393,
 926644924,
 10184,
 -51392,
 926830421,
 983151,
 -1,
 926892619,
 983152,
 927137791,
 926556887,
 -1,
 -51389,
 927034640,
 11822,
 -1,
 927085503,
 11793,
 -1,
 926506812,
 128158,
 927348554,
 926448810,
 -1,
 927414089,
 927285159,
 -1,
 -51384,
 927337523,
 9953,
 -1,
 927402915,
 9952,
 -1,
 927359262,
 128699,
 927676237,
 927275981,
 -1,
 -51380,
 927625125,
 128665,
 -1,
 927687282,
 983112,
 -51378,
 927616761,
 128524,
 -1,
 927802074,
 127822,
 928003974,
 921536039,
 -1,
 928069506,
 927946248,
 -1,
 928135023,
 928013351,
 -1,
 928200538,
 928087573,
 -1,
 928266070,
 928157512,
 -1,
 -51371,
 928210145,
 69235,
 -1,
 928263415,
 69226,
 928462681,
 928200866,
 -1,
 -51368,
 928411694,
 69236,
 -1,
 928466278,
 69227,
 -1,
 928394244,
 69225,
 928724833,
 928150918,
 -1,
 928790366,
 928663264,
 -1,
 -51363,
 928744980,
 69230,
 -1,
 928776742,
 69239,
 929038335,
 928722823,
 -1,
 -51360,
 928941588,
 69231,
 -1,
 928973350,
 69240,
 929183592,
 928657758,
 -1,
 929249125,
 929127647,
 -1,
 -51356,
 929204896,
 69237,
 -1,
 929264901,
 69228,
 929497087,
 929185382,
 -1,
 -51353,
 929402004,
 69238,
 -1,
 929445048,
 69229,
 929642347,
 929127063,
 -1,
 -51350,
 929596948,
 69233,
 -1,
 929628710,
 69242,
 929838958,
 929573692,
 -1,
 -51347,
 929797167,
 69232,
 -1,
 929825318,
 69241,
 -1,
 929783835,
 69234,
 930101116,
 928064759,
 -1,
 930166643,
 930053653,
 -1,
 -51342,
 930124398,
 69217,
 -1,
 930168165,
 69218,
 930363254,
 930116998,
 -1,
 -51339,
 930301664,
 69221,
 -1,
 930361223,
 69222,
 930559865,
 930296158,
 -1,
 -51336,
 930505842,
 69219,
 -1,
 930563727,
 69220,
 -51334,
 930504694,
 69216,
 -51333,
 930699927,
 69224,
 -1,
 930753340,
 69223,
 931004415,
 930034759,
 -1,
 931018625,
 930897914,
 -1,
 -51329,
 930971936,
 69245,
 -51328,
 931032262,
 69244,
 -1,
 931084564,
 69243,
 -1,
 930973181,
 69246,
 931346309,
 928013061,
 -1,
 -51324,
 931283751,
 127933,
 -1,
 931343720,
 127939,
 -1,
 931280367,
 127945,
 931608494,
 927940198,
 983153,
 931674024,
 931542761,
 -1,
 931739543,
 931594240,
 -1,
 931805069,
 931689862,
 -1,
 -51317,
 931760031,
 11779,
 -51316,
 931807235,
 11815,
 -1,
 931859140,
 10182,
 932067216,
 931734923,
 -1,
 -51313,
 932022055,
 11817,
 -1,
 932086936,
 11781,
 932263827,
 931992569,
 -1,
 -51310,
 932216141,
 11776,
 -1,
 932259465,
 11777,
 -51308,
 932220223,
 11809,
 -51307,
 932414349,
 11786,
 -51306,
 932474451,
 11789,
 -1,
 932532505,
 11805,
 932722595,
 931696557,
 -1,
 932788130,
 932648369,
 -1,
 932853660,
 932745718,
 -1,
 -51301,
 932809338,
 11023,
 -1,
 932849544,
 11022,
 933050271,
 932807083,
 -1,
 -51298,
 933002598,
 11076,
 -1,
 933050410,
 11075,
 933298175,
 932974525,
 -1,
 -51295,
 933200419,
 11084,
 -1,
 933237448,
 11080,
 -1,
 932736123,
 11078,
 933560319,
 932645342,
 -1,
 933574566,
 933441998,
 4053,
 -1,
 933496945,
 4055,
 -51289,
 933521986,
 128270,
 -1,
 933640557,
 9957,
 933836714,
 931617321,
 128141,
 -1,
 933758398,
 11824,
 933967789,
 933764454,
 -1,
 -51284,
 933896472,
 127832,
 -1,
 933959783,
 127833,
 -1,
 933894409,
 127872,
 934229965,
 931552479,
 -1,
 934295494,
 934171559,
 -1,
 934361016,
 934245766,
 -1,
 934426551,
 934291586,
 -1,
 934492085,
 934384660,
 -1,
 -51276,
 934447176,
 65939,
 -1,
 934482983,
 65936,
 -51274,
 934444129,
 65944,
 -1,
 934631411,
 65938,
 -1,
 934363516,
 65941,
 934885310,
 934304835,
 -1,
 934950844,
 934818486,
 -1,
 -51269,
 934904147,
 8583,
 -1,
 934947221,
 8582,
 -51267,
 934902057,
 8581,
 -1,
 935092263,
 8584,
 935278530,
 934814421,
 -1,
 -51264,
 935234124,
 65945,
 -51263,
 935281098,
 65940,
 -1,
 935341127,
 65942,
 -51261,
 935233772,
 65937,
 -51260,
 935488829,
 65943,
 -51259,
 935533946,
 65947,
 -1,
 935597575,
 65946,
 -51257,
 934252567,
 128675,
 -51256,
 935758122,
 128205,
 -51255,
 935818875,
 127801,
 -51254,
 935879500,
 128019,
 -51253,
 935940105,
 127906,
 -51252,
 935993193,
 128640,
 -1,
 936056399,
 127840,
 936261603,
 934153921,
 -1,
 936327133,
 936197734,
 -1,
 936392666,
 936277675,
 -1,
 936458195,
 936333852,
 -1,
 -51246,
 936387360,
 127339,
 -1,
 936451036,
 127338,
 936654805,
 936388011,
 11827,
 -1,
 936607704,
 11783,
 -51242,
 936606562,
 11787,
 -51241,
 936723483,
 11782,
 -51240,
 936786280,
 9995,
 -51239,
 936850204,
 9994,
 -1,
 936910935,
 11828,
 937113564,
 936335461,
 9926,
 -1,
 937040631,
 127752,
 -1,
 937054720,
 128643,
 937310175,
 936256805,
 128251,
 -1,
 937230558,
 128280,
 937441249,
 937236740,
 128007,
 -1,
 937361854,
 128048,
 -51230,
 937393685,
 128000,
 -1,
 937513500,
 128015,
 937703399,
 936201026,
 -1,
 -51227,
 937647327,
 983220,
 -51226,
 937710108,
 983215,
 -1,
 937764994,
 983217,
 -1,
 937653638,
 983113,
 938031232,
 921452134,
 -1,
 938096722,
 937973861,
 -1,
 938162231,
 938047084,
 -1,
 938227731,
 938112221,
 -1,
 938293255,
 938167881,
 -1,
 938358770,
 938243462,
 -1,
 938424305,
 938282689,
 -1,
 -51216,
 938366306,
 68430,
 -1,
 938419329,
 68433,
 -1,
 938359754,
 68436,
 938686453,
 938311189,
 -1,
 -51212,
 938618536,
 68424,
 -1,
 938678200,
 68437,
 938883063,
 938621466,
 68420,
 -1,
 938836145,
 68423,
 939014138,
 938806977,
 -1,
 -51207,
 938972476,
 68431,
 -1,
 939019814,
 68416,
 -51205,
 938972800,
 68422,
 -51204,
 939169189,
 68425,
 -51203,
 939233264,
 68421,
 -51202,
 939290787,
 68435,
 -51201,
 939355247,
 68434,
 -51200,
 939419664,
 68432,
 -51199,
 939482202,
 68429,
 -51198,
 939545979,
 68428,
 -51197,
 939609125,
 68427,
 -51196,
 939673854,
 68426,
 -51195,
 939734840,
 68418,
 -51194,
 939795327,
 68419,
 -1,
 939858317,
 68417,
 940113919,
 938236967,
 -1,
 940128270,
 940015125,
 -1,
 940193804,
 940085064,
 -1,
 -51189,
 940137695,
 68441,
 -1,
 940190967,
 68445,
 -51187,
 940129637,
 68442,
 -1,
 940321796,
 68444,
 940521490,
 940072950,
 68440,
 940638207,
 940441600,
 -1,
 -51183,
 940540243,
 68447,
 -1,
 940588580,
 68446,
 -1,
 940454905,
 68443,
 940900351,
 938163252,
 -1,
 940914731,
 940789321,
 -1,
 940980250,
 940864902,
 -1,
 941045785,
 940904129,
 -1,
 -51176,
 940987746,
 68462,
 -1,
 941040769,
 68464,
 -1,
 940981194,
 68465,
 941307933,
 940932629,
 -1,
 -51172,
 941239976,
 68456,
 -1,
 941299640,
 68466,
 941504543,
 941242906,
 68452,
 -1,
 941457585,
 68455,
 -51168,
 941463168,
 68454,
 -51167,
 941594021,
 68457,
 -51166,
 941658110,
 68453,
 -51165,
 941713424,
 68463,
 -51164,
 941775962,
 68461,
 -51163,
 941839743,
 68460,
 -51162,
 941902885,
 68459,
 -51161,
 941967614,
 68458,
 -51160,
 942028600,
 68450,
 -51159,
 942089087,
 68451,
 -51158,
 942152077,
 68449,
 -1,
 942215811,
 68448,
 942473215,
 940858407,
 -1,
 942487602,
 942374421,
 -1,
 942553136,
 942444360,
 -1,
 -51153,
 942496991,
 68473,
 -1,
 942550263,
 68477,
 -51151,
 942488933,
 68474,
 -1,
 942681092,
 68476,
 942880822,
 942432246,
 68472,
 942997503,
 942800896,
 -1,
 -51147,
 942899539,
 68479,
 -1,
 942947876,
 68478,
 -1,
 942814201,
 68475,
 943208510,
 938109963,
 -1,
 943274044,
 943148128,
 -1,
 -51142,
 943225352,
 128289,
 -51141,
 943279769,
 128292,
 -1,
 943332524,
 128288,
 -51139,
 943226369,
 128291,
 -1,
 943479867,
 128290,
 943667270,
 943141842,
 -1,
 943732805,
 943617757,
 -1,
 943798339,
 943685141,
 -1,
 -51134,
 943755886,
 983111,
 -1,
 943799653,
 983108,
 -51132,
 943742966,
 983114,
 -1,
 943928313,
 983105,
 -1,
 943662162,
 128129,
 944191564,
 943623088,
 -1,
 944257099,
 944123414,
 -1,
 -51127,
 944212278,
 8276,
 -51126,
 944269437,
 9959,
 -1,
 944325680,
 11800,
 -1,
 944194974,
 8292,
 944584783,
 944120533,
 983129,
 -51122,
 944520961,
 8377,
 -1,
 944582714,
 983128,
 -51120,
 944537683,
 9892,
 -51119,
 944709703,
 128232,
 -1,
 944773901,
 128229,
 944978044,
 938039199,
 128127,
 945094655,
 944909767,
 -1,
 945109103,
 944983625,
 -1,
 945174618,
 945059206,
 -1,
 945240153,
 945098433,
 -1,
 -51112,
 945182050,
 67662,
 -1,
 945235073,
 67665,
 -1,
 945175498,
 67668,
 945502301,
 945126933,
 -1,
 -51108,
 945434280,
 67656,
 -1,
 945493944,
 67669,
 945698911,
 945437210,
 67652,
 -1,
 945651889,
 67655,
 945829986,
 945622721,
 -1,
 -51103,
 945788220,
 67663,
 -1,
 945835558,
 67648,
 -51101,
 945788544,
 67654,
 -51100,
 945984933,
 67657,
 -51099,
 946049008,
 67653,
 -51098,
 946106531,
 67667,
 -51097,
 946170991,
 67666,
 -51096,
 946235408,
 67664,
 -51095,
 946297946,
 67661,
 -51094,
 946361723,
 67660,
 -51093,
 946424869,
 67659,
 -51092,
 946489598,
 67658,
 -51091,
 946550584,
 67650,
 -51090,
 946611071,
 67651,
 -1,
 946674061,
 67649,
 946878587,
 945052711,
 -1,
 946944119,
 946830869,
 -1,
 947009652,
 946900808,
 -1,
 -51085,
 946953439,
 67673,
 -1,
 947006711,
 67676,
 947206262,
 946940932,
 67675,
 -1,
 947127995,
 67679,
 -1,
 947141989,
 67674,
 947453951,
 946888694,
 67672,
 947519487,
 947322880,
 -1,
 -51078,
 947421523,
 67678,
 -1,
 947469860,
 67677,
 -1,
 946828958,
 67671,
 947730559,
 944905574,
 -1,
 -51074,
 947681646,
 9976,
 -1,
 947724576,
 127848,
 -1,
 947689007,
 127982,
 947992833,
 937969463,
 -1,
 948058367,
 947916481,
 -1,
 948123894,
 948014049,
 -1,
 948189371,
 948063470,
 -1,
 948254906,
 948143282,
 -1,
 948320397,
 948197477,
 -1,
 948385929,
 948253955,
 43412,
 948502527,
 948306654,
 43402,
 -1,
 948372992,
 43403,
 948582539,
 948343921,
 43418,
 -1,
 948503368,
 43416,
 948764671,
 948506305,
 43428,
 -1,
 948634440,
 43423,
 948844690,
 948272661,
 -1,
 948910224,
 948797067,
 43419,
 -1,
 948831002,
 43420,
 949092351,
 948833985,
 43424,
 -1,
 948962120,
 43425,
 949172375,
 948773589,
 -1,
 949237909,
 949101362,
 43421,
 -1,
 949158682,
 43422,
 949420031,
 949161665,
 43426,
 -1,
 949289754,
 43427,
 949500059,
 949122522,
 43441,
 949616639,
 949420807,
 -1,
 -51046,
 949521110,
 43439,
 -1,
 949555591,
 43440,
 949762207,
 949446458,
 43429,
 949878783,
 949682176,
 -1,
 -51042,
 949770258,
 43430,
 -1,
 949820835,
 43401,
 950024355,
 949700751,
 43407,
 950140927,
 949944320,
 -1,
 -51038,
 950040121,
 43408,
 -1,
 950097938,
 43409,
 950286502,
 949960294,
 43398,
 -51035,
 950222438,
 43399,
 -1,
 950272628,
 43397,
 950483112,
 950234560,
 43435,
 -1,
 950403103,
 43436,
 950614186,
 950421333,
 43415,
 -1,
 950534938,
 43417,
 950745260,
 950547715,
 43410,
 -1,
 950666056,
 43411,
 950876334,
 950672361,
 43413,
 -1,
 950797128,
 43414,
 951007408,
 950802481,
 43431,
 -1,
 950928200,
 43432,
 951138482,
 950931137,
 43396,
 -1,
 951074406,
 43405,
 -51021,
 951096433,
 43434,
 -51020,
 951226255,
 43438,
 -51019,
 951289383,
 43400,
 -51018,
 951344351,
 43406,
 -51017,
 951407221,
 43433,
 -51016,
 951470960,
 43437,
 -51015,
 951531704,
 43442,
 -1,
 951593090,
 43404,
 -1,
 948188315,
 43457,
 951859408,
 948135738,
 -1,
 951924941,
 951788341,
 -1,
 951990466,
 951864130,
 -1,
 952056001,
 951944743,
 -1,
 -51008,
 951999055,
 43465,
 -1,
 952057410,
 43461,
 -1,
 951993196,
 43464,
 952318150,
 951914177,
 -1,
 952383685,
 952247289,
 43466,
 -1,
 952303641,
 43467,
 -1,
 952326494,
 43459,
 952580297,
 952264443,
 -1,
 -51000,
 952518020,
 43468,
 -1,
 952570858,
 43463,
 -50998,
 952537391,
 43462,
 -50997,
 952730274,
 43486,
 -50996,
 952783546,
 43460,
 -1,
 952845707,
 43487,
 953090047,
 951867945,
 -1,
 -50993,
 952987340,
 43471,
 -1,
 953043627,
 43456,
 953235678,
 951788791,
 -1,
 953301204,
 953187861,
 -1,
 -50989,
 953258606,
 43474,
 -1,
 953302373,
 43475,
 953497815,
 953251206,
 -1,
 -50986,
 953435872,
 43478,
 -1,
 953495431,
 43479,
 953694426,
 953430366,
 -1,
 -50983,
 953640050,
 43476,
 -1,
 953697935,
 43477,
 -50981,
 953652909,
 43472,
 -50980,
 953835510,
 43473,
 -50979,
 953899671,
 43481,
 -1,
 953953084,
 43480,
 954153194,
 953192151,
 -1,
 954218724,
 954105365,
 -1,
 954284259,
 954142401,
 -1,
 -50974,
 954234178,
 43444,
 -1,
 954290032,
 43450,
 -1,
 954228534,
 43445,
 954546406,
 954176371,
 43446,
 -1,
 954467115,
 43447,
 954677480,
 954498401,
 43448,
 -1,
 954598194,
 43449,
 -50967,
 954624145,
 43452,
 -1,
 954737982,
 43451,
 954939632,
 954103945,
 -1,
 955005165,
 954867050,
 43393,
 -1,
 954926767,
 43443,
 -50962,
 954962215,
 43395,
 -50961,
 955082668,
 43392,
 -1,
 955141276,
 43394,
 955332852,
 954867849,
 -1,
 -50958,
 955279452,
 43454,
 -50957,
 955337156,
 43453,
 -1,
 955390992,
 43455,
 -50955,
 955286842,
 43469,
 -1,
 955544106,
 43458,
 955726078,
 948070300,
 -1,
 -50952,
 955678177,
 128304,
 -50951,
 955738782,
 127971,
 -50950,
 955801196,
 128121,
 -50949,
 955856769,
 128122,
 -50948,
 955917729,
 127886,
 -50947,
 955981029,
 127983,
 -1,
 956045437,
 9979,
 -1,
 955653969,
 127875,
 -50944,
 948013463,
 9909,
 -1,
 956246416,
 128086,
 956447085,
 947925342,
 -1,
 956512546,
 956370625,
 -1,
 956578076,
 956439501,
 -1,
 956643610,
 956508292,
 -1,
 956709141,
 956600674,
 -1,
 956774676,
 956628992,
 -1,
 956840203,
 956726581,
 128539,
 956956671,
 956760122,
 -1,
 -50934,
 956862794,
 128540,
 -1,
 956924410,
 128541,
 957102351,
 956783839,
 -1,
 957167886,
 957048897,
 128558,
 -1,
 957087808,
 128560,
 -1,
 957106242,
 128582,
 -50928,
 957054904,
 128514,
 -50927,
 957307682,
 128581,
 -50926,
 957371670,
 128567,
 -50925,
 957436084,
 128548,
 -1,
 957489183,
 128531,
 -1,
 956720367,
 128566,
 957757720,
 956659078,
 -1,
 -50921,
 957686054,
 128561,
 -1,
 957749128,
 128523,
 -50919,
 957710782,
 128536,
 -1,
 957895739,
 128134,
 -50917,
 956597083,
 127981,
 -1,
 958036145,
 8507,
 958216479,
 956518352,
 -1,
 -50914,
 958153391,
 9950,
 -1,
 958213131,
 127810,
 -50912,
 958174085,
 128224,
 -50911,
 958365961,
 127877,
 -1,
 958420585,
 128106,
 958609719,
 956448358,
 -1,
 958675244,
 958557538,
 -1,
 958740777,
 958605442,
 128293,
 958806312,
 958698317,
 -1,
 -50905,
 958756230,
 127878,
 -1,
 958793311,
 127879,
 -1,
 958726568,
 128658,
 959119359,
 958692364,
 -1,
 -50901,
 959025527,
 127771,
 -1,
 959086034,
 127763,
 959265073,
 958625158,
 -1,
 959330608,
 959199394,
 128031,
 -50897,
 959267605,
 127907,
 -1,
 959316198,
 127845,
 -1,
 959283146,
 128074,
 959592756,
 959220876,
 -1,
 -50893,
 959540148,
 8281,
 -1,
 959599596,
 11821,
 959840255,
 959532273,
 -1,
 -50890,
 959739603,
 983106,
 -1,
 959787956,
 128193,
 959985990,
 958553311,
 -1,
 960051519,
 959940135,
 -1,
 960117054,
 959999332,
 -1,
 960182589,
 960046511,
 -1,
 -50884,
 960129972,
 8280,
 -1,
 960189420,
 8283,
 -1,
 960122140,
 127808,
 -1,
 960060363,
 9970,
 960510276,
 959999330,
 -1,
 960575811,
 960448573,
 -1,
 -50878,
 960506438,
 11792,
 -1,
 960561253,
 127860,
 -1,
 960516655,
 983071,
 -50875,
 960455662,
 128099,
 -1,
 960771750,
 127745,
 960969044,
 959925058,
 -1,
 961034573,
 960912607,
 -1,
 961100108,
 960991300,
 9880,
 961216511,
 961021126,
 -1,
 -50869,
 961120515,
 8277,
 -1,
 961170594,
 127924,
 -1,
 961047289,
 128190,
 961427792,
 960964738,
 -1,
 -50865,
 961385439,
 128170,
 -1,
 961448619,
 9884,
 961624403,
 961351361,
 -1,
 -50862,
 961577678,
 9189,
 -1,
 961623258,
 9971,
 -1,
 961579832,
 128563,
 961886555,
 960923175,
 -1,
 961952088,
 961826771,
 -1,
 -50857,
 961909111,
 127773,
 -1,
 961969618,
 127765,
 -50855,
 961902203,
 9179,
 -50854,
 962091517,
 9905,
 -1,
 962145161,
 9981,
 962345314,
 961834338,
 -1,
 962410848,
 962288863,
 -1,
 -50850,
 962368083,
 128550,
 -50849,
 962419633,
 128037,
 -1,
 962475219,
 128056,
 -50847,
 962347032,
 127844,
 -1,
 962604126,
 127839,
 962804070,
 962301746,
 -1,
 -50844,
 962727114,
 983209,
 -50843,
 962792499,
 983208,
 -1,
 962857891,
 983207,
 963066219,
 962734210,
 -1,
 963131754,
 963015825,
 -1,
 -50839,
 963089455,
 9972,
 -1,
 963134839,
 127905,
 -1,
 963056933,
 128552,
 -50836,
 963016070,
 983107,
 -1,
 963326302,
 983072,
 963525067,
 956403528,
 -1,
 963590558,
 963459234,
 -1,
 963656092,
 963528260,
 -1,
 963721590,
 963584725,
 -1,
 963787124,
 963669796,
 -1,
 -50829,
 963728291,
 9920,
 -1,
 963791431,
 9921,
 -50827,
 963733171,
 128071,
 -1,
 963919588,
 9931,
 964114811,
 963673621,
 -1,
 964180346,
 964062562,
 -1,
 -50823,
 964116246,
 10177,
 -1,
 964170880,
 9186,
 -1,
 964137698,
 9943,
 964442496,
 964064646,
 -1,
 964508031,
 964383542,
 -1,
 -50818,
 964459577,
 11090,
 -1,
 964514149,
 11051,
 -1,
 964455602,
 128307,
 964770180,
 964384042,
 -1,
 -50814,
 964721721,
 11088,
 -50813,
 964776293,
 11048,
 -1,
 964830408,
 11046,
 965032329,
 964709186,
 -1,
 965097864,
 964963052,
 -1,
 -50809,
 965044758,
 128072,
 -1,
 965102636,
 9945,
 -1,
 965023042,
 11036,
 965360014,
 964966562,
 -1,
 965425549,
 965290114,
 -1,
 -50804,
 965383113,
 11041,
 -1,
 965416873,
 9989,
 -1,
 965370543,
 11053,
 965687698,
 965292851,
 -1,
 965753233,
 965611831,
 9872,
 -1,
 965675239,
 9983,
 -1,
 965699246,
 128174,
 965949845,
 965643500,
 -1,
 -50796,
 965907542,
 11038,
 -1,
 965968352,
 11055,
 966146456,
 965898711,
 -1,
 -50793,
 966068913,
 11092,
 -1,
 966133189,
 128073,
 -50791,
 966101467,
 128070,
 -50790,
 966290718,
 10068,
 -50789,
 966355060,
 11040,
 -1,
 966406241,
 10069,
 -50787,
 963586712,
 9855,
 -1,
 966529640,
 128011,
 966736303,
 963514049,
 -1,
 966801829,
 966688847,
 -1,
 966867364,
 966721536,
 -1,
 -50782,
 966823898,
 127754,
 -50781,
 966860755,
 128702,
 -1,
 966925165,
 128003,
 -1,
 966808949,
 127817,
 967195048,
 966759430,
 -1,
 -50777,
 967128863,
 127764,
 -1,
 967188811,
 127762,
 967391659,
 967150512,
 -1,
 -50774,
 967328476,
 128075,
 -1,
 967387279,
 11071,
 967588270,
 967334576,
 -1,
 -50771,
 967522079,
 127766,
 -1,
 967582027,
 127768,
 -1,
 967537634,
 9888,
 967850429,
 966679775,
 -1,
 967915961,
 967791132,
 -1,
 967981496,
 967840558,
 128105,
 968047031,
 967931272,
 -1,
 -50764,
 967996959,
 128097,
 -50763,
 968047110,
 128082,
 -50762,
 968105982,
 128090,
 -1,
 968170187,
 128098,
 -1,
 967968701,
 128111,
 -1,
 967912634,
 128698,
 968505788,
 967863650,
 -1,
 -50757,
 968454549,
 128543,
 -1,
 968499977,
 11825,
 -1,
 968445622,
 128058,
 968767939,
 967780482,
 -1,
 968833473,
 968693214,
 -1,
 -50752,
 968765886,
 128553,
 -1,
 968826092,
 128576,
 -50750,
 968769587,
 983224,
 -1,
 968958932,
 128146,
 969161159,
 968704488,
 -1,
 -50747,
 969099852,
 128521,
 -50746,
 969156820,
 127863,
 -1,
 969220834,
 127888,
 969423306,
 969108834,
 -1,
 -50743,
 969354329,
 128295,
 -1,
 969413799,
 127873,
 -1,
 969361207,
 983223,
 969685509,
 963479079,
 -1,
 969751029,
 969618837,
 -1,
 969816564,
 969690697,
 -1,
 969882068,
 969766278,
 -1,
 969947602,
 969805505,
 -1,
 -50735,
 969889475,
 66450,
 -1,
 969941978,
 66453,
 -50733,
 969899334,
 66461,
 -1,
 970079178,
 66444,
 970275288,
 969834005,
 -1,
 -50730,
 970218719,
 66458,
 -50729,
 970275253,
 66456,
 -1,
 970337924,
 66441,
 970537435,
 970233359,
 -1,
 -50726,
 970491431,
 66449,
 -1,
 970534548,
 66439,
 970734046,
 970475581,
 -1,
 -50723,
 970668216,
 66435,
 -1,
 970723584,
 66443,
 970930656,
 970669147,
 66437,
 -1,
 970882699,
 66440,
 971061731,
 970863825,
 -1,
 -50718,
 970995958,
 66457,
 -1,
 971051793,
 66434,
 971258342,
 970990293,
 -1,
 -50715,
 971192571,
 66447,
 -1,
 971254730,
 66436,
 971454953,
 971181761,
 -1,
 -50712,
 971395437,
 66432,
 -1,
 971457000,
 66451,
 -50710,
 971412897,
 66442,
 -50709,
 971608686,
 66438,
 -50708,
 971671079,
 66460,
 -50707,
 971730664,
 66455,
 -50706,
 971795562,
 66454,
 -50705,
 971860904,
 66452,
 -50704,
 971922522,
 66448,
 -50703,
 971986299,
 66446,
 -50702,
 972049439,
 66445,
 -50701,
 972111462,
 66459,
 -1,
 972167553,
 66433,
 -1,
 969773852,
 66463,
 972438013,
 969697019,
 -1,
 972503545,
 972394413,
 -1,
 -50696,
 972429861,
 11014,
 -1,
 972493639,
 11797,
 972700156,
 972425868,
 -1,
 -50693,
 972651030,
 128316,
 -1,
 972714002,
 128314,
 -1,
 972620172,
 11021,
 972962305,
 972380261,
 -1,
 -50689,
 972903430,
 9903,
 -50688,
 972965376,
 983115,
 -1,
 973017890,
 128530,
 973224452,
 972903605,
 -1,
 -50685,
 973181371,
 9748,
 -1,
 973234061,
 9969,
 -1,
 973174150,
 983116,
 973486603,
 969643829,
 -1,
 973552137,
 973428837,
 -1,
 -50680,
 973489975,
 983212,
 -1,
 973544282,
 983247,
 -50678,
 973503230,
 983211,
 -1,
 973686583,
 983213,
 973879822,
 973444143,
 -1,
 -50675,
 973815427,
 983227,
 -1,
 973876138,
 128155,
 -1,
 973827404,
 9915]
_charnames_564 = [
5688,
5718,
5549,
5700,
5702,
5770,
5855,
5934,
5757,
5922,
5849,
5590,
5761,
5962,
5775,
5982,
5898,
5841,
5832,
5569,
5979,
5787,
5904,
5768,
5884,
5639,
5969,
5784,
]

_charnames_751 = [
8912,
8916,
8906,
8915,
8914,
8943,
8941,
8942,
8917,
8954,
8966,
8937,
8965,
8936,
8860,
8968,
8905,
]

_charnames_848 = [
1388,
1377,
1430,
1427,
1374,
1389,
1386,
1391,
1342,
1412,
1335,
1420,
1334,
1333,
1331,
1332,
]

_charnames_880 = [
11590,
11571,
11591,
11572,
-1,
-1,
11589,
11570,
-1,
-1,
-1,
11574,
11576,
11575,
]

_charnames_1015 = [
11587,
11568,
11592,
11588,
11569,
11630,
11594,
11597,
11595,
]

_charnames_1270 = [
2015,
1942,
-1,
-1,
2014,
1941,
1996,
1920,
1995,
1919,
]

_charnames_1296 = [
1978,
1902,
2001,
1925,
2023,
1949,
1982,
1906,
1992,
1916,
2020,
1947,
2019,
1946,
2024,
1950,
2000,
1924,
2002,
1926,
2021,
1935,
1975,
1899,
]

_charnames_1536 = [
11040,
10971,
11022,
10974,
10972,
-1,
11048,
11047,
11016,
11046,
11045,
11406,
-1,
11027,
11039,
10979,
10973,
10980,
10976,
10977,
10978,
10985,
10986,
10983,
10988,
10989,
10987,
-1,
-1,
-1,
11002,
-1,
10876,
]

_charnames_1622 = [
10990,
11042,
10825,
11037,
11030,
11031,
11032,
11015,
11019,
11038,
]

_charnames_1869 = [
10427,
10428,
10429,
10850,
10855,
10848,
10849,
10851,
10854,
10852,
10886,
10887,
10931,
10930,
10859,
10894,
10900,
10901,
10899,
10842,
10843,
10874,
10872,
10870,
10925,
10924,
10921,
10920,
10919,
10934,
10861,
10864,
10891,
10884,
10882,
10892,
10860,
10883,
10903,
10904,
10833,
10834,
10835,
10914,
10915,
10910,
10911,
10888,
10895,
10893,
10877,
]

_charnames_1984 = [
13694,
13695,
13686,
13687,
13692,
13693,
13689,
13690,
13697,
13696,
13681,
13663,
13675,
13662,
13668,
13661,
13660,
13665,
13646,
13680,
13671,
13669,
13656,
13679,
13664,
13659,
13658,
13670,
13677,
13678,
13674,
13673,
13650,
13672,
13647,
13649,
13676,
13667,
13666,
13648,
13654,
13655,
13653,
13708,
13707,
13706,
13704,
13703,
13702,
13701,
13709,
13710,
13715,
13682,
13713,
13714,
13711,
13716,
13683,
-1,
-1,
-1,
-1,
-1,
9862,
9849,
9859,
9861,
9842,
9850,
9851,
9843,
9839,
9852,
9858,
9857,
9856,
9855,
9846,
9844,
9860,
9838,
9854,
9853,
9847,
9840,
9902,
9903,
9904,
9907,
9911,
9906,
9869,
9880,
9872,
9866,
9877,
9871,
9865,
9876,
9909,
9875,
9867,
9878,
9910,
9868,
9879,
9870,
9874,
9905,
-1,
-1,
9897,
9888,
9885,
9899,
9886,
9894,
9912,
9898,
9890,
9896,
9891,
9895,
9887,
9893,
9884,
-1,
9489,
9483,
9481,
9482,
9480,
9487,
9472,
9485,
9469,
9471,
9470,
9478,
9477,
9476,
9465,
9486,
9475,
9466,
9474,
9473,
9467,
9468,
9490,
9488,
9479,
9494,
9491,
9493,
-1,
-1,
9492,
]

_charnames_2208 = [
10853,
-1,
10937,
10935,
10844,
10936,
10933,
10926,
10907,
10908,
10862,
10916,
10865,
]

_charnames_2276 = [
11006,
11008,
11004,
11007,
11009,
11005,
10998,
10995,
11001,
10997,
10994,
11000,
11035,
11036,
11034,
10984,
11020,
11021,
11041,
10940,
11012,
10939,
11014,
11024,
11025,
11013,
11028,
-1,
13949,
-1,
-1,
-1,
13933,
]

_charnames_2382 = [
13959,
13961,
-1,
-1,
-1,
-1,
-1,
13960,
13955,
13954,
]

_charnames_2417 = [
13950,
13937,
13928,
13927,
13939,
13925,
13924,
-1,
13932,
13935,
13931,
13934,
13930,
13936,
13938,
]

_charnames_2555 = [
5494,
-1,
-1,
-1,
-1,
-1,
11864,
-1,
11862,
]

_charnames_2929 = [
13043,
13032,
13033,
13037,
13031,
13034,
13036,
]

_charnames_3059 = [
8015,
8020,
8016,
8014,
8011,
8022,
8017,
8019,
]

_charnames_3192 = [
8554,
8552,
8546,
8549,
8553,
8547,
8550,
8558,
]

_charnames_3386 = [
9511,
-1,
-1,
9528,
-1,
-1,
-1,
-1,
-1,
-1,
9517,
]

_charnames_3440 = [
9522,
9521,
9520,
9525,
9526,
9527,
-1,
-1,
-1,
9529,
9506,
9505,
9509,
9507,
9508,
9510,
]

_charnames_4046 = [
8659,
-1,
8645,
8649,
8648,
8651,
8652,
14244,
6636,
14245,
6637,
8650,
8647,
]

_charnames_4130 = [
9603,
-1,
-1,
-1,
-1,
-1,
9611,
-1,
-1,
9693,
]

_charnames_4147 = [
9690,
9689,
9695,
-1,
-1,
-1,
-1,
9650,
9699,
9701,
9700,
9702,
9620,
]

_charnames_4186 = [
9609,
9610,
9608,
9607,
9704,
9705,
9706,
9604,
9680,
9710,
9709,
9617,
9618,
9687,
9686,
9644,
9643,
9642,
9641,
9640,
9614,
9613,
9615,
9694,
9683,
9682,
9684,
9593,
9592,
9598,
9601,
9594,
9589,
9600,
9590,
9596,
9599,
9602,
9595,
9597,
9707,
9679,
9676,
9677,
9678,
9633,
9632,
9631,
9630,
9637,
9636,
9638,
9619,
9648,
9661,
9662,
9653,
9654,
9659,
9660,
9656,
9657,
9664,
9663,
9647,
9646,
9691,
9692,
9671,
9672,
]

_charnames_4295 = [
11845,
-1,
-1,
-1,
-1,
-1,
11846,
]

_charnames_4345 = [
11841,
11838,
-1,
8969,
11839,
11843,
11842,
]

_charnames_4992 = [
3840,
3921,
3920,
3919,
3842,
3857,
3856,
3855,
3841,
3926,
3925,
3924,
3839,
3914,
3913,
3912,
3945,
3939,
3947,
3946,
3941,
3944,
3949,
3948,
3940,
3943,
]

_charnames_5751 = [
2286,
2282,
2283,
2280,
2281,
2284,
2285,
2287,
2355,
]

_charnames_6128 = [
12357,
12358,
12353,
12356,
12355,
12346,
12352,
12351,
12350,
12349,
]

_charnames_6314 = [
8983,
-1,
-1,
-1,
-1,
-1,
2276,
2366,
2367,
2293,
2349,
2350,
2348,
2318,
2361,
2360,
2368,
2335,
2336,
2369,
2306,
2295,
2304,
2305,
2303,
2357,
2358,
2327,
2333,
2267,
2334,
2268,
2331,
2265,
2332,
2266,
2325,
2323,
2324,
2321,
2322,
2326,
2272,
2271,
2274,
2275,
2273,
2263,
2269,
2270,
2371,
2292,
2363,
2364,
2328,
2290,
2291,
2316,
2317,
2309,
2310,
2311,
2313,
2314,
2298,
2299,
2301,
2340,
2345,
2342,
2341,
2300,
2346,
2354,
2353,
2344,
]

_charnames_6400 = [
6395,
6342,
6341,
6348,
6347,
6338,
6354,
6353,
6345,
6344,
6330,
6333,
6332,
6351,
6350,
6339,
6336,
6335,
6357,
6356,
6360,
6329,
6359,
6361,
6358,
6327,
6326,
6328,
6362,
-1,
-1,
-1,
6386,
6394,
6393,
6392,
6388,
6390,
6387,
6391,
6389,
6381,
6383,
6382,
-1,
-1,
-1,
-1,
6373,
6366,
6374,
6368,
6367,
6370,
6371,
6369,
6372,
6377,
6379,
6376,
-1,
-1,
-1,
-1,
6378,
-1,
-1,
-1,
6411,
6410,
6406,
6407,
6398,
6399,
6404,
6405,
6401,
6402,
6409,
6408,
8317,
8319,
8313,
8296,
8321,
8318,
8298,
8297,
8324,
8309,
8308,
8323,
8327,
8320,
8326,
8322,
8316,
8295,
8314,
8302,
8325,
8301,
8300,
8305,
8311,
8310,
8306,
8299,
8303,
8304,
-1,
-1,
8293,
8292,
8291,
8290,
8289,
]

_charnames_6528 = [
13511,
13482,
13508,
13496,
13504,
13479,
13467,
13475,
13491,
13499,
13509,
13462,
13470,
13480,
13493,
13492,
13505,
13464,
13463,
13476,
13502,
13501,
13512,
13473,
13472,
13483,
13515,
13510,
13513,
13486,
13481,
13484,
13514,
13516,
13517,
13485,
13487,
13488,
13507,
13495,
13478,
13466,
13498,
13469,
-1,
-1,
-1,
-1,
13544,
13537,
13543,
13527,
13531,
13545,
13540,
13532,
13533,
13528,
13539,
13538,
13530,
13535,
13534,
13529,
13542,
13521,
13520,
13519,
13522,
13523,
13524,
13525,
13563,
13562,
-1,
-1,
-1,
-1,
-1,
-1,
13556,
13557,
13548,
13549,
13554,
13555,
13551,
13552,
13559,
13558,
13564,
-1,
-1,
-1,
13565,
13566,
12321,
12368,
12320,
12365,
12362,
12317,
12314,
12311,
12308,
12305,
12343,
12340,
12330,
12337,
12334,
12327,
12369,
12367,
12319,
12364,
12361,
12316,
12313,
12310,
12307,
12304,
12342,
12339,
12329,
12336,
12333,
12326,
5392,
5395,
5379,
5378,
5390,
5398,
5384,
5383,
5387,
5396,
5381,
5380,
5397,
5393,
5376,
5375,
5385,
5389,
5391,
5386,
5388,
5399,
5394,
5403,
5401,
5404,
5402,
5405,
-1,
-1,
5406,
5407,
8058,
8057,
8056,
8031,
8029,
8030,
8079,
8067,
8066,
8040,
8042,
8039,
8078,
8074,
8069,
8090,
8043,
8075,
8061,
8060,
8034,
8033,
8080,
8091,
8064,
8063,
8071,
8037,
8045,
8036,
8087,
8041,
8068,
8073,
8076,
8046,
8048,
8085,
8053,
8052,
8054,
8070,
8049,
8092,
8044,
8083,
8084,
8081,
8082,
8089,
8086,
8047,
8088,
8181,
8182,
8186,
8111,
8189,
8185,
8188,
8183,
8190,
8187,
-1,
8108,
8138,
8147,
8141,
8144,
8145,
8146,
8137,
8136,
8134,
8135,
8128,
8130,
8132,
8148,
8140,
8133,
8139,
8143,
8131,
8110,
8118,
8117,
8099,
8098,
8097,
8121,
8113,
8100,
-1,
-1,
8191,
8173,
8174,
8165,
8166,
8171,
8172,
8168,
8169,
8176,
8175,
-1,
-1,
-1,
-1,
-1,
-1,
8159,
8160,
8151,
8152,
8157,
8158,
8154,
8155,
8162,
8161,
-1,
-1,
-1,
-1,
-1,
-1,
8114,
8115,
8107,
8103,
8123,
8125,
8120,
8112,
8101,
8102,
8105,
8106,
8124,
8126,
]

_charnames_6912 = [
5092,
5093,
5096,
5094,
5097,
4978,
4979,
5000,
5001,
4992,
4993,
4987,
4988,
4990,
4991,
5005,
4981,
4996,
4997,
4967,
4969,
5002,
5003,
4965,
5007,
5008,
4998,
4999,
4964,
4959,
4958,
4975,
4974,
4963,
4955,
4957,
4971,
4976,
4962,
4994,
4995,
5009,
5010,
5015,
5012,
4986,
4989,
5013,
4985,
4984,
4982,
5016,
5095,
5065,
5066,
5067,
5068,
5069,
5070,
5071,
5074,
5075,
5060,
5062,
5064,
5063,
5072,
5073,
5109,
4968,
4970,
4960,
5006,
5014,
5011,
4980,
-1,
-1,
-1,
-1,
5086,
5087,
5078,
5079,
5084,
5085,
5081,
5082,
5089,
5088,
5102,
5101,
5108,
5106,
5107,
5105,
5100,
5030,
5028,
5029,
5020,
5022,
5031,
5025,
5027,
5024,
5023,
5038,
5041,
5034,
5036,
5039,
5035,
5037,
5042,
5040,
5053,
5054,
5056,
5057,
5047,
5045,
5050,
5049,
5046,
-1,
-1,
-1,
10337,
10336,
10335,
10280,
10294,
10287,
10281,
10291,
10275,
10276,
10274,
10289,
10296,
10256,
10298,
10293,
10282,
10255,
10288,
10297,
10257,
10290,
10262,
10286,
10279,
10292,
10283,
10268,
10271,
10285,
10265,
10284,
10295,
10347,
10346,
10345,
10327,
10325,
10329,
10326,
10330,
10328,
10338,
10339,
10343,
10342,
10273,
10264,
10309,
10310,
10301,
10302,
10307,
10308,
10304,
10305,
10312,
10311,
10348,
10267,
10270,
10278,
10261,
10260,
5156,
5125,
5151,
5123,
5139,
5155,
5148,
5141,
5120,
5133,
5138,
5144,
5117,
5142,
5152,
5124,
5149,
5153,
5146,
5119,
5135,
5121,
5126,
5130,
5127,
5118,
5137,
5143,
5116,
5131,
5147,
5122,
5129,
5154,
5132,
5140,
5150,
5145,
5175,
5163,
5165,
5164,
5167,
5162,
5166,
5161,
5158,
5159,
5180,
5181,
5178,
5177,
]

_charnames_7164 = [
5173,
5171,
5174,
5172,
6503,
6501,
6502,
6519,
6518,
6498,
6525,
6524,
6534,
6497,
6491,
6490,
6507,
6499,
6495,
6493,
6494,
6522,
6521,
6528,
6527,
6513,
6512,
6489,
6488,
6505,
6529,
6532,
6533,
6516,
6515,
6531,
6510,
6509,
6530,
6535,
6577,
6578,
6567,
6565,
6563,
6564,
6561,
6562,
6566,
6553,
6558,
6559,
6551,
6557,
6556,
6555,
6552,
6554,
6580,
6581,
-1,
-1,
-1,
6572,
6573,
6574,
6571,
6570,
6546,
6547,
6538,
6539,
6544,
6545,
6541,
6542,
6549,
6548,
-1,
-1,
-1,
6486,
6485,
6506,
12961,
12962,
12953,
12954,
12959,
12960,
12956,
12957,
12964,
12963,
12925,
12920,
12923,
12921,
12922,
12926,
12918,
12919,
12917,
12916,
12929,
12942,
12945,
12944,
12943,
12927,
12935,
12934,
12933,
12932,
12930,
12948,
12950,
12949,
12947,
12928,
12938,
12940,
12937,
12939,
12972,
12974,
12971,
12973,
12969,
12975,
12967,
12968,
]

_charnames_7360 = [
10317,
10316,
10315,
10321,
10318,
10319,
10320,
10322,
]

_charnames_7376 = [
7629,
7636,
7638,
7613,
7610,
7622,
7621,
7619,
7634,
7620,
7631,
7625,
7628,
7632,
7624,
7626,
7637,
7639,
7603,
7599,
7606,
7601,
7607,
7600,
7602,
7596,
7595,
7592,
7593,
7612,
7616,
7614,
7608,
7594,
7597,
7609,
7635,
7615,
7611,
]

_charnames_7424 = [
6002,
6003,
5540,
6017,
6016,
6015,
6001,
5999,
5531,
5533,
6013,
6012,
6011,
6010,
5994,
5996,
5998,
5582,
5583,
5584,
5532,
5997,
5552,
5782,
6009,
5993,
5988,
5986,
6007,
5585,
5587,
5586,
6006,
6005,
6004,
6000,
6018,
6019,
11614,
11613,
11611,
11612,
11610,
2026,
8873,
8874,
8871,
8872,
8888,
8887,
8866,
8886,
8869,
8885,
8884,
8883,
8882,
8881,
8880,
8865,
8867,
8868,
8879,
8863,
8878,
8877,
8875,
8836,
8777,
8837,
8779,
8809,
8833,
8798,
8806,
8823,
8783,
8829,
8784,
8852,
8846,
8802,
8820,
8822,
8786,
8810,
8841,
8775,
8817,
8807,
8780,
8839,
8838,
8811,
8832,
8835,
8831,
8796,
5812,
5804,
5802,
5801,
11582,
11580,
11578,
11579,
11581,
5680,
5780,
5696,
5791,
5733,
5716,
5727,
5642,
5643,
5593,
5547,
5763,
5539,
8900,
5614,
5545,
5796,
5618,
5723,
5795,
5678,
5779,
5695,
5790,
5773,
5744,
5685,
5732,
5714,
5726,
5640,
5591,
5574,
5706,
5792,
5762,
5625,
5632,
5697,
5570,
5666,
5648,
5595,
5608,
5663,
5573,
5677,
5578,
8778,
8789,
8797,
8800,
8851,
8854,
8834,
8805,
8785,
8850,
8849,
8791,
8792,
8853,
8826,
8827,
8795,
8847,
8781,
8845,
8844,
8794,
8812,
8842,
8808,
8801,
8788,
8819,
8818,
8793,
8840,
8782,
8813,
8815,
8816,
8799,
8787,
1340,
1341,
1426,
1425,
1397,
1408,
1395,
1415,
1409,
1416,
1352,
1431,
1396,
1337,
1428,
1419,
1429,
1423,
1422,
1361,
1349,
1348,
1347,
1363,
1359,
1362,
1360,
1369,
1358,
1353,
1368,
1367,
1357,
1366,
1365,
1351,
1356,
1354,
1355,
]

_charnames_8275 = [
10630,
14408,
14666,
8737,
-1,
14651,
14642,
8763,
14652,
13906,
8721,
7648,
-1,
-1,
-1,
-1,
-1,
14411,
]

_charnames_8336 = [
5815,
5814,
5806,
5800,
5799,
5813,
5810,
5809,
5808,
5807,
5805,
5798,
5803,
]

_charnames_8370 = [
11867,
11387,
13453,
2568,
6477,
10536,
8570,
14413,
]

_charnames_8524 = [
12243,
11405,
8750,
10437,
7662,
7663,
7661,
]

_charnames_9167 = [
4012,
7647,
9194,
9191,
9192,
9190,
9185,
9186,
9187,
9188,
9193,
3980,
14680,
8701,
5469,
8703,
5471,
8699,
5467,
14713,
5495,
10514,
14673,
11392,
3990,
13983,
5431,
5424,
5454,
5444,
5432,
5425,
5433,
11222,
10523,
8675,
13414,
]

_charnames_9866 = [
8975,
8974,
14017,
14010,
14011,
14016,
14735,
5457,
13251,
11382,
2548,
10510,
10612,
11219,
14664,
11847,
10509,
11394,
14671,
13072,
8733,
8734,
14766,
13439,
13895,
13894,
14415,
9534,
9532,
9533,
7646,
13404,
9197,
9199,
9198,
9555,
14033,
14846,
1646,
14681,
13639,
2567,
12180,
14591,
7650,
1867,
5439,
10593,
10596,
14862,
10595,
10494,
5206,
10212,
14706,
14707,
5442,
5443,
10615,
10353,
14298,
5421,
8744,
8752,
8755,
14709,
2555,
14029,
13062,
12282,
2431,
13392,
2533,
1858,
13741,
11220,
5449,
14714,
5426,
14727,
14041,
13368,
6634,
10206,
14621,
5450,
14152,
14151,
11397,
13357,
12245,
14247,
6639,
14409,
5458,
10101,
1870,
2437,
13442,
11849,
11850,
9554,
8986,
14851,
14654,
14674,
14696,
9916,
10248,
10626,
14461,
12232,
8568,
14589,
13381,
14682,
1238,
14736,
-1,
-1,
-1,
-1,
-1,
14732,
-1,
-1,
-1,
-1,
14296,
14295,
]

_charnames_10060 = [
2554,
-1,
13605,
-1,
-1,
-1,
-1,
5455,
14745,
14747,
-1,
13372,
]

_charnames_10175 = [
13898,
8738,
14712,
12240,
13052,
13051,
6617,
14220,
13046,
14142,
10362,
7649,
9540,
6715,
9551,
10201,
10200,
]

_charnames_11008 = [
13738,
13735,
10488,
10485,
6620,
6612,
14839,
13909,
13739,
13736,
10489,
10486,
6621,
14844,
14235,
14234,
6589,
6588,
10230,
10232,
10229,
10231,
14022,
14021,
14020,
14023,
13903,
5428,
14728,
5446,
14739,
5456,
14746,
14731,
5453,
13405,
5429,
5438,
14723,
5437,
14722,
5419,
5418,
14718,
5452,
14733,
5447,
14740,
6630,
8735,
6631,
6714,
6607,
6608,
6609,
6610,
6593,
6591,
6592,
6603,
6605,
6606,
6599,
14762,
4010,
14141,
6597,
14238,
14237,
6611,
14242,
14140,
14241,
8670,
6598,
6596,
14240,
-1,
-1,
-1,
14721,
5417,
14717,
5434,
14742,
13364,
13370,
13358,
13355,
13359,
]

_charnames_11264 = [
11777,
11766,
11768,
11775,
11748,
11730,
11751,
11747,
11752,
11737,
11741,
11734,
11749,
11773,
11760,
11772,
11771,
11758,
11754,
11770,
11724,
11743,
11769,
11763,
11774,
11757,
11755,
11718,
11744,
11776,
11720,
11728,
11729,
11733,
11723,
11731,
11721,
11722,
11732,
11739,
11767,
11740,
11764,
11736,
11719,
11745,
11761,
-1,
11714,
11703,
11705,
11712,
11685,
11667,
11688,
11684,
11689,
11674,
11678,
11671,
11686,
11710,
11697,
11709,
11708,
11695,
11691,
11707,
11661,
11680,
11706,
11700,
11711,
11694,
11692,
11655,
11681,
11713,
11657,
11665,
11666,
11670,
11660,
11668,
11658,
11659,
11669,
11676,
11704,
11677,
11701,
11673,
11656,
11682,
11698,
-1,
5921,
5687,
5919,
5944,
5883,
5624,
5548,
5958,
5752,
5928,
5743,
5967,
5764,
5862,
5954,
5839,
5840,
5705,
5983,
5793,
5708,
5960,
5751,
5553,
5571,
5537,
5658,
5990,
5811,
8876,
5902,
5966,
1571,
1490,
1574,
1493,
1581,
1500,
1545,
1464,
1583,
1502,
1554,
1473,
1573,
1492,
1580,
1499,
1562,
1481,
1579,
1498,
1560,
1479,
1568,
1487,
1578,
1497,
1577,
1496,
1558,
1477,
1516,
1435,
1566,
1485,
1576,
1495,
1555,
1474,
1563,
1482,
1575,
1494,
1582,
1501,
1559,
1478,
1565,
1484,
1538,
1457,
1544,
1463,
1531,
1450,
1551,
1470,
1542,
1461,
1541,
1460,
1549,
1468,
1527,
1446,
1556,
1475,
1552,
1471,
1526,
1445,
1529,
1448,
1572,
1491,
1543,
1462,
1522,
1441,
1520,
1439,
1569,
1488,
1523,
1442,
1521,
1440,
1528,
1447,
1530,
1449,
1525,
1444,
1537,
1456,
1535,
1454,
1534,
1453,
1536,
1455,
1510,
1513,
1512,
1506,
1511,
1509,
1507,
1548,
1467,
1550,
1469,
1589,
1588,
1587,
1584,
1503,
-1,
-1,
-1,
-1,
-1,
1593,
1594,
1592,
1591,
1597,
1596,
1598,
11819,
11835,
11817,
11834,
11833,
11824,
11799,
11802,
11832,
11811,
11831,
11830,
11829,
11828,
11808,
11798,
11826,
11805,
11801,
11825,
11807,
11810,
11816,
11827,
11804,
11793,
11796,
11813,
11795,
11794,
11822,
11814,
11787,
11790,
11789,
11823,
11786,
11788,
-1,
11821,
-1,
-1,
-1,
-1,
-1,
11820,
-1,
-1,
8578,
8602,
8603,
8595,
8597,
8634,
8612,
8579,
8582,
8580,
8581,
8617,
8613,
8592,
8623,
8594,
8600,
8635,
8631,
8601,
8615,
8593,
8624,
8607,
8629,
8620,
8585,
8638,
8628,
8611,
8610,
8609,
8626,
8630,
8608,
8618,
8598,
8599,
8596,
8627,
8637,
8589,
8590,
8591,
8586,
8588,
8614,
8587,
8606,
8605,
8604,
8583,
8632,
8584,
8616,
8619,
]

_charnames_11647 = [
8641,
3933,
3922,
3932,
3843,
3844,
3858,
3868,
3792,
3929,
3928,
3810,
3879,
3828,
3820,
3934,
3869,
3793,
3916,
3915,
3806,
3808,
3805,
3804,
]

_charnames_11680 = [
3833,
3835,
3837,
3834,
3832,
3831,
3836,
-1,
3787,
3789,
3791,
3788,
3786,
3785,
3790,
-1,
3874,
3876,
3878,
3875,
3873,
3872,
3877,
-1,
3780,
3782,
3784,
3781,
3779,
3778,
3783,
-1,
3894,
3896,
3898,
3895,
3893,
3892,
3897,
-1,
3904,
3906,
3908,
3905,
3903,
3902,
3907,
-1,
3884,
3886,
3888,
3885,
3883,
3882,
3887,
-1,
3798,
3800,
3802,
3799,
3797,
3796,
3801,
-1,
1284,
1285,
1290,
1281,
1268,
1269,
1289,
1250,
1249,
1248,
1275,
1286,
1247,
1245,
1274,
1277,
1273,
1292,
1265,
1264,
1291,
1246,
1293,
1256,
1280,
1287,
1261,
1258,
1255,
1288,
1283,
1254,
14225,
14226,
6615,
14218,
6628,
14223,
14294,
14292,
13902,
6633,
14228,
14293,
6622,
14229,
4013,
12175,
14657,
14147,
13448,
13905,
13910,
14840,
13904,
13897,
14410,
12179,
13449,
8669,
6625,
14230,
8668,
8667,
6632,
14227,
8702,
8700,
5470,
5468,
6616,
14219,
6627,
14222,
8762,
13069,
10218,
14643,
14146,
7645,
14249,
14779,
8754,
14291,
14297,
8751,
14049,
14048,
8753,
8697,
8767,
8739,
]

_charnames_12728 = [
5476,
5474,
5473,
-1,
-1,
-1,
-1,
-1,
2250,
2253,
2252,
2257,
2240,
2224,
2231,
2232,
2229,
2239,
2230,
2227,
2233,
2228,
2225,
2255,
2222,
2236,
2246,
2244,
2256,
2223,
2235,
2237,
2241,
2243,
2245,
2249,
2247,
2251,
2238,
2242,
2234,
2226,
2248,
2254,
]

_charnames_12868 = [
2527,
2522,
2526,
2521,
2510,
2508,
2509,
2515,
2516,
2512,
2513,
2517,
12174,
]

_charnames_19904 = [
13262,
13273,
13287,
13349,
13342,
13330,
13268,
13351,
13303,
13279,
13321,
13305,
13348,
13296,
13345,
13352,
13347,
13341,
13337,
13329,
13334,
13299,
13306,
13315,
13309,
13298,
13344,
13297,
13269,
13263,
13311,
13288,
13316,
13295,
13320,
13289,
13278,
13325,
13326,
13283,
13284,
13312,
13333,
13331,
13300,
13319,
13324,
13271,
13317,
13264,
13267,
13275,
13282,
13274,
13339,
13272,
13277,
13276,
13286,
13350,
13310,
13304,
13338,
13335,
]

_charnames_42192 = [
6473,
6440,
6439,
6459,
6428,
6427,
6454,
6448,
6447,
6470,
6462,
6461,
6458,
6426,
6425,
6468,
6445,
6469,
6437,
6433,
6434,
6444,
6451,
6466,
6450,
6472,
6467,
6436,
6465,
6453,
6463,
6464,
6455,
6456,
6471,
6441,
6429,
6431,
6430,
6442,
6418,
6423,
6421,
6422,
6419,
6420,
6476,
6475,
7028,
7029,
6951,
6888,
6889,
6995,
6934,
6941,
6793,
6832,
6785,
6854,
7011,
6979,
6909,
6902,
6817,
6810,
6961,
6987,
6824,
6753,
6925,
6918,
6878,
6871,
7019,
7003,
6769,
6971,
6842,
6734,
6860,
6800,
6776,
6761,
7033,
7034,
6954,
6955,
6893,
6894,
6997,
6936,
6943,
6795,
6838,
6787,
6856,
7013,
6981,
6911,
6904,
6819,
6812,
6965,
6989,
6826,
6755,
6927,
6920,
6880,
6873,
7021,
7005,
6771,
6973,
6846,
6738,
6864,
6802,
6778,
6763,
7035,
7036,
6742,
6956,
6957,
6895,
6896,
6998,
6937,
6944,
6796,
6835,
6836,
6788,
6857,
7014,
6982,
6912,
6905,
6820,
6813,
6966,
6990,
6827,
6756,
6928,
6921,
6881,
6874,
7022,
7006,
6772,
6974,
6843,
6844,
6739,
6865,
6803,
6779,
6764,
7024,
7025,
6947,
6884,
6885,
6993,
6932,
6939,
6791,
6834,
6783,
6850,
7009,
6977,
6907,
6900,
6815,
6808,
6963,
6985,
6822,
6751,
6923,
6916,
6876,
6869,
7017,
7001,
6767,
6969,
6840,
6736,
6862,
6798,
6774,
6759,
7031,
7032,
6952,
6953,
6891,
6892,
6996,
6935,
6942,
6794,
6837,
6786,
6855,
7012,
6980,
6910,
6903,
6818,
6811,
6964,
6988,
6825,
6754,
6926,
6919,
6879,
6872,
7020,
7004,
6770,
6972,
6845,
6737,
6863,
6801,
6777,
6762,
7023,
7026,
6740,
6946,
6948,
6883,
6886,
6992,
6931,
6938,
6790,
6833,
6782,
6849,
6851,
7008,
6976,
6906,
6899,
6814,
6807,
6962,
6984,
6821,
6744,
6922,
6915,
6875,
6868,
7016,
7000,
6766,
6968,
6839,
6735,
6861,
6797,
6773,
6758,
7027,
7030,
6741,
6949,
6950,
6887,
6890,
6994,
6933,
6940,
6792,
6830,
6831,
6784,
6852,
6853,
7010,
6978,
6908,
6901,
6816,
6809,
6959,
6986,
6823,
6752,
6924,
6917,
6877,
6870,
7018,
7002,
6768,
6970,
6841,
6732,
6733,
6858,
6859,
6799,
6775,
6760,
6730,
6960,
7072,
7071,
7070,
6749,
6748,
6746,
7051,
7049,
7040,
7053,
7055,
7052,
7041,
7046,
7044,
7048,
7039,
7045,
7054,
7066,
7067,
7058,
7059,
7064,
7065,
7061,
7062,
7069,
7068,
6747,
6750,
]

_charnames_42560 = [
2009,
1933,
1956,
1880,
1981,
1905,
1988,
1912,
1959,
1883,
2011,
1938,
2004,
1928,
2022,
1948,
1991,
1915,
1985,
1909,
1979,
1903,
1987,
1911,
2017,
1944,
2005,
1929,
1986,
1910,
1990,
1914,
1980,
1904,
1972,
1896,
1971,
1895,
1970,
1894,
2012,
1939,
2006,
1930,
1958,
1882,
2027,
1300,
1296,
1302,
1295,
10606,
1271,
1251,
1259,
1270,
1278,
1260,
1266,
1276,
1301,
1299,
2029,
2028,
1957,
1881,
1955,
1879,
2008,
1932,
2018,
1945,
1954,
1878,
1965,
1889,
1964,
1888,
1962,
1886,
1963,
1887,
1966,
1890,
1997,
1921,
1974,
1898,
]

_charnames_42655 = [
1253,
4939,
4877,
4935,
4874,
4938,
4903,
4914,
4936,
4860,
4937,
4922,
4845,
4905,
4906,
4921,
4881,
4915,
4863,
4850,
4878,
4895,
4885,
4893,
4896,
4894,
4897,
4873,
4871,
4856,
4855,
4848,
4930,
4891,
4929,
4931,
4861,
4870,
4842,
4849,
4859,
4839,
4933,
4843,
4926,
4907,
4918,
4887,
4862,
4901,
4908,
4872,
4852,
4853,
4854,
4892,
4840,
4924,
4925,
4934,
4864,
4920,
4844,
4919,
4866,
4883,
4902,
4880,
4888,
4916,
4876,
4886,
4884,
4911,
4875,
4912,
4858,
4898,
4927,
4867,
4868,
4944,
4943,
4949,
4950,
4946,
4945,
4947,
4948,
]

_charnames_42752 = [
8894,
8899,
8891,
8896,
8893,
8898,
8892,
8897,
8931,
8957,
8946,
8910,
8925,
8932,
8958,
8947,
8911,
8926,
8933,
8959,
8948,
8907,
8927,
8961,
8962,
8963,
8920,
8950,
8953,
8952,
8951,
8918,
8857,
8856,
5834,
5576,
5835,
5577,
5959,
5750,
5847,
5550,
5848,
5551,
5931,
5754,
5932,
5755,
6014,
6008,
5863,
5634,
5861,
5631,
5860,
5630,
5857,
5627,
5858,
5628,
5859,
5629,
5888,
5647,
5924,
5739,
5927,
5742,
5925,
5740,
5981,
5781,
5920,
5686,
5915,
5660,
5914,
5659,
5916,
5667,
5945,
5724,
5947,
5728,
5946,
5725,
5972,
5767,
5973,
5769,
5886,
5644,
5887,
5650,
5941,
5707,
5938,
5709,
5939,
5710,
5845,
5543,
5846,
5544,
5940,
5711,
5836,
5579,
5877,
5617,
5936,
5759,
8967,
5699,
5692,
5737,
5719,
5649,
5995,
5541,
5679,
5871,
5616,
5870,
5615,
5869,
5843,
5534,
5842,
5538,
5868,
5613,
5867,
5612,
5866,
5611,
8919,
8901,
8859,
5906,
5598,
5844,
5684,
-1,
5976,
5717,
5935,
5758,
]

_charnames_42912 = [
5964,
5774,
5929,
5745,
5975,
5715,
5885,
5641,
5903,
5592,
5957,
]

_charnames_43000 = [
8870,
8828,
5989,
6023,
6022,
6025,
6026,
6027,
10408,
10405,
10422,
10399,
10407,
10401,
10421,
10385,
10386,
10391,
10392,
10423,
10394,
10395,
10388,
10389,
10368,
10369,
10374,
10375,
10370,
10371,
10376,
10377,
10402,
10382,
10383,
10397,
10398,
10403,
10380,
10404,
10379,
10400,
10406,
10414,
10412,
10410,
10413,
10411,
10419,
10418,
10417,
10416,
-1,
-1,
-1,
-1,
13723,
13724,
13728,
13722,
13725,
13727,
13730,
13733,
13732,
13731,
-1,
-1,
-1,
-1,
-1,
-1,
11919,
11918,
11922,
11891,
11902,
11904,
11934,
11889,
11887,
11886,
11900,
11892,
11916,
11915,
11938,
11932,
11885,
11884,
11898,
11927,
11909,
11910,
11894,
11925,
11929,
11933,
11895,
11896,
11936,
11905,
11935,
11928,
11923,
11931,
11930,
11926,
11937,
11921,
11924,
11943,
11942,
11882,
11881,
11899,
11890,
11907,
11912,
11913,
11906,
11944,
11945,
11903,
11946,
11950,
11948,
11949,
]

_charnames_43136 = [
9833,
9831,
9753,
9756,
9777,
9778,
9761,
9762,
9731,
9732,
9733,
9734,
9782,
9783,
9755,
9766,
9767,
9754,
9773,
9772,
9781,
9780,
9745,
9786,
9785,
9776,
9775,
9743,
9739,
9738,
9750,
9749,
9744,
9741,
9740,
9752,
9751,
9746,
9765,
9764,
9789,
9788,
9792,
9790,
9791,
9770,
9735,
9759,
9758,
9760,
9793,
9769,
9834,
9803,
9808,
9809,
9804,
9805,
9796,
9797,
9798,
9799,
9810,
9811,
9802,
9806,
9807,
9801,
9832,
]

_charnames_43214 = [
9828,
9827,
9823,
9824,
9815,
9816,
9821,
9822,
9818,
9819,
9826,
9825,
-1,
-1,
-1,
-1,
-1,
-1,
1316,
1317,
1308,
1309,
1314,
1315,
1311,
1312,
1319,
1318,
1327,
1322,
1326,
1325,
1324,
1323,
1321,
1328,
13947,
13945,
13951,
13943,
13944,
13946,
13948,
13963,
13964,
13962,
-1,
-1,
-1,
-1,
12658,
12659,
12650,
12651,
12656,
12657,
12653,
12654,
12661,
12660,
12631,
12630,
12643,
12615,
12622,
12621,
12635,
12614,
12619,
12633,
12616,
12625,
12624,
12640,
12644,
12646,
12639,
12636,
12641,
12637,
12618,
12634,
12638,
12645,
12647,
12628,
12642,
12627,
12664,
12665,
12663,
12666,
12667,
12671,
12669,
12670,
12674,
12673,
14083,
14086,
14070,
14078,
14087,
14072,
14081,
14089,
14075,
14088,
14084,
14067,
14079,
14080,
14082,
14076,
14077,
14085,
14074,
14069,
14071,
14066,
14090,
14101,
14099,
14093,
14098,
14100,
14097,
14094,
14095,
14105,
14104,
14106,
14107,
14102,
]

_charnames_43359 = [
14108,
13222,
13221,
13219,
13223,
13211,
13208,
13214,
13206,
13216,
13215,
13207,
13213,
13209,
13217,
13212,
13242,
13240,
13241,
13231,
13232,
13233,
13227,
13244,
13245,
13228,
13226,
13234,
13247,
13225,
-1,
-1,
-1,
14574,
14571,
14575,
14573,
14512,
14501,
14499,
14500,
14516,
14494,
14471,
14472,
14521,
14513,
14517,
14495,
14497,
14498,
14506,
14507,
14470,
14508,
14509,
14504,
14474,
14505,
14473,
14478,
14479,
14483,
14484,
14476,
14480,
14481,
14485,
14486,
14475,
14491,
14493,
14510,
14511,
14518,
14514,
14502,
14503,
14519,
14515,
14489,
14490,
14487,
14520,
14572,
14561,
14563,
14564,
14565,
14566,
14567,
14562,
14569,
14568,
14578,
14577,
14579,
14543,
14522,
14581,
14533,
14539,
14528,
14537,
14536,
14529,
14527,
14531,
14532,
14535,
14580,
-1,
14542,
14554,
14555,
14546,
14547,
14552,
14553,
14549,
14550,
14557,
14556,
-1,
-1,
-1,
-1,
14538,
14540,
]

_charnames_43520 = [
1707,
1715,
1711,
1717,
1708,
1713,
1697,
1696,
1703,
1702,
1670,
1671,
1706,
1705,
1700,
1699,
1666,
1668,
1667,
1688,
1687,
1681,
1679,
1672,
1673,
1680,
1677,
1675,
1676,
1685,
1683,
1693,
1694,
1684,
1709,
1712,
1714,
1710,
1690,
1691,
1716,
1722,
1727,
1728,
1729,
1723,
1726,
1725,
1721,
1720,
1724,
1749,
1751,
1752,
1750,
]

_charnames_43584 = [
1661,
1662,
1654,
1746,
1663,
1656,
1653,
1659,
1655,
1658,
1660,
1657,
1747,
1748,
-1,
-1,
1740,
1741,
1732,
1733,
1738,
1739,
1735,
1736,
1743,
1742,
-1,
-1,
1758,
1756,
1755,
1757,
9584,
9579,
9578,
9573,
9572,
9569,
9567,
9566,
9563,
9562,
9564,
9570,
9582,
9576,
9575,
9585,
9711,
9581,
9580,
9583,
9624,
9623,
9625,
9669,
9668,
9667,
9621,
9649,
-1,
-1,
-1,
-1,
8203,
8234,
8201,
8232,
8202,
8233,
8221,
8252,
8198,
8229,
8211,
8242,
8212,
8243,
8215,
8246,
8196,
8227,
8223,
8254,
8205,
8236,
8206,
8237,
8197,
8228,
8224,
8255,
8208,
8239,
8209,
8240,
8222,
8253,
8218,
8249,
8213,
8244,
8216,
8247,
8219,
8250,
8214,
8245,
8220,
8251,
8217,
8248,
8285,
8262,
8267,
8264,
8263,
8270,
8269,
8284,
8268,
8265,
8266,
8259,
8258,
8260,
8261,
8282,
8281,
8279,
8280,
]

_charnames_43739 = [
8273,
8276,
8275,
8277,
8274,
9062,
9060,
9052,
9011,
9016,
9015,
9023,
9022,
9012,
9028,
9027,
9078,
9074,
9070,
9071,
9069,
9106,
9103,
9102,
9108,
9107,
9080,
9085,
]

_charnames_43777 = [
3863,
3865,
3866,
3862,
3861,
3864,
-1,
-1,
3816,
3818,
3819,
3815,
3814,
3817,
-1,
-1,
3824,
3826,
3827,
3823,
3822,
3825,
]

_charnames_43808 = [
3773,
3775,
3777,
3774,
3772,
3771,
3776,
-1,
3849,
3851,
3853,
3850,
3848,
3847,
3852,
]

_charnames_43968 = [
9035,
9029,
9040,
9038,
9031,
9009,
9051,
9017,
9037,
9007,
9019,
9057,
9056,
9061,
9058,
9045,
9033,
9063,
9048,
9044,
9059,
9055,
9043,
9024,
9049,
9025,
9054,
9036,
9041,
9039,
9032,
9010,
9018,
9008,
9046,
9082,
9077,
9072,
9079,
9081,
9075,
9084,
9083,
9105,
9064,
9101,
-1,
-1,
9096,
9097,
9088,
9089,
9094,
9095,
9091,
9092,
9099,
9098,
]

_charnames_55216 = [
13187,
13188,
13175,
13176,
13177,
13200,
13201,
13180,
13179,
13193,
13191,
13190,
13192,
13168,
13167,
13165,
13164,
13171,
13170,
13169,
13172,
13197,
13196,
-1,
-1,
-1,
-1,
13156,
13157,
13087,
13088,
13138,
13132,
13133,
13135,
13136,
13137,
13128,
13130,
13092,
13129,
13126,
13127,
13123,
13124,
13146,
13150,
13148,
13095,
13149,
13151,
13111,
13113,
13114,
13093,
13112,
13109,
13110,
13103,
13104,
13091,
13090,
13102,
13099,
13100,
13101,
13105,
13119,
13120,
13153,
13154,
13160,
13159,
13096,
13117,
13116,
]

_charnames_64107 = [
2217,
2216,
2215,
-1,
-1,
2202,
2201,
2200,
2199,
2198,
2197,
2196,
2195,
2194,
2193,
2192,
2191,
2190,
2189,
2188,
2187,
2185,
2184,
2183,
2182,
2181,
2180,
2179,
2178,
2177,
2176,
2175,
2174,
2173,
2172,
2171,
2170,
2168,
2167,
2166,
2165,
2164,
2163,
2162,
2161,
2160,
2159,
2158,
2157,
2156,
2155,
2154,
2153,
2151,
2150,
2149,
2148,
2147,
2146,
2145,
2144,
2143,
2142,
2141,
2140,
2139,
2138,
2137,
2136,
2134,
2133,
2132,
2131,
2130,
2129,
2128,
2127,
2126,
2125,
2124,
2123,
2122,
2121,
2120,
2119,
2117,
2116,
2115,
2114,
2113,
2112,
2111,
2110,
2109,
2108,
2107,
2106,
2105,
2104,
2103,
2102,
2213,
2212,
2211,
2210,
2209,
2208,
2207,
2206,
2205,
2204,
]

_charnames_64434 = [
10960,
10959,
10950,
10949,
10956,
10955,
10954,
10953,
10967,
10966,
10961,
10948,
10947,
10968,
10964,
10963,
]

_charnames_65040 = [
12207,
12205,
12204,
12208,
12209,
12212,
12210,
12201,
12197,
12211,
]

_charnames_65536 = [
6236,
6264,
6226,
6251,
6279,
6243,
6256,
6237,
6275,
6222,
6217,
6255,
-1,
6266,
6249,
6206,
6257,
6247,
6213,
6283,
6284,
6276,
6210,
6274,
6231,
6238,
6230,
6270,
6221,
6218,
6241,
6211,
6263,
6278,
6223,
6273,
6205,
6232,
6268,
-1,
6252,
6227,
6220,
6242,
6228,
6269,
6235,
6260,
6277,
6216,
6215,
6240,
6265,
6239,
6245,
6219,
6208,
6261,
6259,
-1,
6272,
6209,
-1,
6233,
6229,
6258,
6282,
6212,
6287,
6254,
6225,
6250,
6207,
6267,
6246,
6248,
6281,
6286,
-1,
-1,
6302,
6301,
6306,
6305,
6299,
6298,
6304,
6296,
6295,
6303,
6293,
6292,
6291,
6290,
]

_charnames_65664 = [
6080,
6079,
6078,
6065,
6064,
6063,
6077,
6076,
6074,
6073,
6071,
6070,
6068,
6067,
6130,
6129,
6128,
6127,
6126,
6314,
6313,
6134,
6133,
6132,
6311,
6310,
6124,
6123,
6122,
6121,
6120,
6110,
6109,
6108,
6107,
6106,
6315,
6105,
6104,
6103,
6091,
6090,
6089,
6088,
6087,
6086,
6085,
6084,
6083,
6082,
6101,
6100,
6099,
6098,
6097,
6096,
6095,
6094,
6093,
6118,
6117,
6116,
6115,
6114,
6113,
6112,
6137,
6136,
6167,
6166,
6164,
6163,
6162,
6161,
6160,
6159,
6157,
6156,
6155,
6154,
6153,
6152,
6316,
6151,
6150,
6148,
6147,
6146,
6145,
6144,
6143,
6142,
6141,
6140,
6201,
6191,
6190,
6189,
6188,
6187,
6186,
6185,
6184,
6183,
6182,
6180,
6179,
6178,
6177,
6176,
6175,
6174,
6173,
6172,
6171,
6198,
6197,
6196,
6195,
6194,
6193,
6199,
6200,
-1,
-1,
-1,
-1,
-1,
11296,
11297,
11303,
-1,
-1,
-1,
-1,
11283,
11228,
11235,
11258,
11265,
11244,
11250,
11277,
11271,
11241,
11232,
11239,
11262,
11269,
11245,
11251,
11278,
11272,
11286,
11231,
11238,
11261,
11268,
11249,
11255,
11282,
11276,
11285,
11230,
11237,
11260,
11267,
11248,
11254,
11281,
11275,
11242,
11233,
11240,
11263,
11270,
11246,
11252,
11279,
11273,
-1,
-1,
-1,
11294,
11291,
11293,
11292,
11290,
11302,
11301,
11300,
11299,
11442,
11438,
11443,
11415,
11426,
11421,
11418,
11429,
11420,
11447,
11431,
11436,
11423,
11440,
11419,
11425,
11448,
11432,
11437,
11424,
11441,
11446,
11430,
11449,
11480,
11458,
11478,
11482,
11456,
11486,
11483,
11469,
11473,
11474,
11477,
11490,
11457,
11455,
11471,
11472,
11479,
11466,
11461,
11454,
11484,
11470,
11465,
11487,
11489,
11460,
11464,
11491,
11488,
11617,
11618,
11600,
11603,
11628,
11606,
11633,
11620,
11601,
11604,
11625,
11626,
11623,
11631,
11615,
11619,
11629,
11493,
11494,
11632,
11605,
11627,
-1,
-1,
-1,
-1,
-1,
14260,
14274,
14262,
14259,
14272,
14263,
14273,
14275,
14261,
14271,
14277,
14276,
]

_charnames_66000 = [
11982,
11980,
11987,
11960,
11962,
11993,
11991,
12006,
11986,
12014,
11973,
11966,
11961,
12000,
11999,
11970,
12003,
11974,
11959,
12009,
11954,
11969,
11956,
11976,
11965,
11989,
11990,
11977,
11958,
11997,
12013,
12008,
11985,
11975,
11981,
12010,
11983,
11996,
12002,
12011,
12012,
12005,
11967,
11968,
11994,
11955,
]

_charnames_66176 = [
6659,
6655,
6657,
6658,
6673,
6674,
6671,
6663,
6661,
6648,
6670,
6653,
6667,
6669,
6651,
6649,
6652,
6650,
6664,
6668,
6654,
6666,
6665,
6646,
6647,
6660,
6656,
6672,
6662,
-1,
-1,
-1,
2421,
2407,
2416,
2401,
2379,
2404,
2402,
2422,
2424,
2426,
2389,
2425,
2417,
2398,
2386,
2387,
2383,
2420,
2377,
2395,
2423,
2394,
2400,
2406,
2388,
2410,
2414,
2380,
2408,
2409,
2397,
2378,
2412,
2413,
2384,
2385,
2396,
2411,
2419,
2399,
2382,
2405,
2390,
2393,
2392,
2391,
2403,
2415,
2381,
]

_charnames_66432 = [
14823,
14835,
14818,
14812,
14821,
14814,
14826,
14810,
14815,
14807,
14825,
14813,
14803,
14833,
14832,
14820,
14831,
14809,
14800,
14824,
14830,
14801,
14829,
14828,
14806,
14817,
14805,
14834,
14827,
14802,
-1,
14836,
12805,
12851,
12848,
12839,
12838,
12845,
12844,
12827,
12854,
12842,
12841,
12812,
12810,
12800,
12804,
12803,
12811,
12849,
12822,
12853,
12836,
12835,
12820,
12819,
12818,
12847,
12830,
12829,
12833,
12832,
12850,
12816,
12846,
12815,
12814,
12852,
-1,
-1,
-1,
-1,
12806,
12808,
12807,
12826,
12801,
12802,
12823,
12824,
12863,
12861,
12858,
12860,
12859,
12862,
]

_charnames_66638 = [
13974,
13975,
10084,
10060,
10087,
10090,
10058,
10073,
10072,
10092,
10067,
10078,
10093,
10091,
10089,
10081,
10059,
10080,
10076,
10088,
10070,
10079,
10086,
10075,
10062,
10055,
10038,
10042,
10047,
10069,
10044,
10040,
10083,
10085,
10052,
10041,
10063,
10082,
10049,
10046,
10048,
10037,
10036,
10045,
10039,
10054,
10035,
10053,
10064,
10066,
12980,
13011,
12999,
13005,
12996,
12988,
12994,
13000,
12984,
12983,
12993,
13010,
13008,
13009,
13001,
12989,
13004,
13003,
13002,
12997,
13007,
12995,
12979,
12990,
13006,
12985,
12998,
12981,
12991,
12986,
-1,
-1,
13022,
13023,
13014,
13015,
13020,
13021,
13017,
13018,
13025,
13024,
]

_charnames_67584 = [
2097,
2096,
2095,
2094,
2093,
2092,
-1,
-1,
2091,
-1,
2078,
2077,
2076,
2075,
2074,
2072,
2071,
2070,
2069,
2068,
2066,
2065,
2064,
2063,
2062,
2060,
2059,
2058,
2057,
2056,
2054,
2053,
2052,
2051,
2050,
2048,
2047,
2046,
2045,
2044,
2042,
2041,
2040,
2039,
2038,
2036,
2035,
2034,
2033,
2032,
2083,
2082,
2081,
2080,
-1,
2089,
2088,
-1,
-1,
-1,
2086,
-1,
-1,
2085,
14433,
14446,
14444,
14445,
14429,
14436,
14434,
14430,
14427,
14435,
14443,
14442,
14441,
14440,
14423,
14432,
14439,
14424,
14438,
14437,
14425,
14428,
-1,
14459,
14455,
14450,
14454,
14452,
14451,
14458,
14457,
14453,
]

_charnames_67840 = [
12027,
12041,
12039,
12040,
12024,
12031,
12029,
12025,
12022,
12030,
12038,
12037,
12036,
12035,
12019,
12028,
12034,
12020,
12033,
12032,
12018,
12023,
12049,
12048,
12046,
12050,
12045,
12047,
-1,
-1,
-1,
12051,
6687,
6702,
6698,
6700,
6685,
6690,
6697,
6689,
6696,
6683,
6695,
6681,
6694,
6692,
6680,
6677,
6691,
6699,
6693,
6679,
6678,
6688,
6686,
6684,
6682,
6701,
-1,
-1,
-1,
-1,
-1,
6703,
]

_charnames_67968 = [
9145,
9143,
9141,
9138,
9134,
9135,
9132,
9133,
9137,
9139,
9121,
9122,
9119,
9120,
9127,
9128,
9140,
9130,
9142,
9124,
9125,
9126,
9131,
9136,
9115,
9116,
9113,
9114,
9117,
9144,
9146,
9147,
9163,
9175,
9173,
9170,
9165,
9166,
9177,
9169,
9171,
9159,
9158,
9167,
9172,
9161,
9174,
9156,
9164,
9155,
9162,
9168,
9153,
9152,
9151,
9176,
-1,
-1,
-1,
-1,
-1,
-1,
9179,
9180,
]

_charnames_68096 = [
12476,
12497,
12495,
12494,
-1,
12498,
12496,
-1,
-1,
-1,
-1,
-1,
12499,
12503,
12508,
12505,
12455,
12454,
12461,
12460,
-1,
12464,
12463,
12474,
-1,
12449,
12435,
12434,
12441,
12440,
12450,
12437,
12436,
12443,
12442,
12451,
12458,
12457,
12467,
12466,
12472,
12469,
12471,
12473,
12470,
12446,
12445,
12447,
12468,
12475,
12453,
12433,
-1,
-1,
-1,
-1,
12507,
12506,
12504,
-1,
-1,
-1,
-1,
12500,
12520,
12518,
12519,
12521,
12512,
12511,
12515,
12514,
]

_charnames_68176 = [
12481,
12489,
12488,
12487,
12490,
12484,
12482,
12480,
12485,
]

_charnames_68192 = [
12886,
12901,
12887,
12900,
12898,
12896,
12877,
12897,
12903,
12871,
12874,
12885,
12899,
12884,
12876,
12875,
12902,
12893,
12892,
12881,
12889,
12882,
12890,
12870,
12894,
12880,
12895,
12869,
12868,
12906,
12907,
12908,
]

_charnames_68352 = [
11307,
11308,
11313,
11309,
11314,
11310,
11311,
11312,
11356,
11357,
11349,
11350,
11351,
11352,
11347,
11348,
11369,
11332,
11330,
11331,
11340,
11339,
11338,
11372,
11370,
11336,
11335,
11360,
11359,
11334,
11366,
11371,
11363,
11362,
11319,
11317,
11318,
11322,
11320,
11321,
11367,
11354,
11345,
11346,
11364,
11365,
11368,
11328,
11343,
11326,
11342,
11325,
11327,
11355,
-1,
-1,
-1,
11373,
8674,
10566,
6036,
6032,
6035,
6031,
14329,
14342,
14340,
14341,
14325,
14332,
14330,
14326,
14323,
14331,
14339,
14338,
14337,
14336,
14319,
14328,
14335,
14320,
14334,
14333,
14321,
14324,
-1,
-1,
14350,
14346,
14348,
14354,
14349,
14347,
14353,
14352,
14378,
14377,
14375,
14376,
14365,
14369,
14367,
14366,
14363,
14368,
14374,
14373,
14372,
14371,
14359,
14370,
14360,
14361,
14364,
-1,
-1,
-1,
-1,
-1,
14386,
14382,
14384,
14390,
14385,
14383,
14389,
14388,
]

_charnames_68608 = [
12718,
12764,
12765,
12759,
12795,
12783,
12753,
12754,
12792,
12740,
12782,
12729,
12772,
12738,
12780,
12727,
12771,
12739,
12781,
12728,
12747,
12788,
12732,
12773,
12720,
12768,
12726,
12770,
12755,
12793,
12737,
12779,
12725,
12751,
12750,
12736,
12724,
12766,
12744,
12786,
12746,
12787,
12743,
12785,
12778,
12745,
12767,
12749,
12758,
12761,
12752,
12790,
12735,
12777,
12760,
12796,
12757,
12794,
12734,
12776,
12723,
12730,
12722,
12731,
12775,
12748,
12789,
12733,
12774,
12721,
12769,
12756,
12762,
]

_charnames_69216 = [
14201,
14193,
14194,
14199,
14200,
14196,
14197,
14203,
14202,
14169,
14165,
14168,
14180,
14183,
14172,
14175,
14188,
14185,
14190,
14164,
14167,
14179,
14182,
14173,
14176,
14189,
14186,
14208,
14207,
14206,
14209,
]

_charnames_69632 = [
5350,
5351,
5347,
5349,
5348,
5243,
5246,
5265,
5266,
5251,
5252,
5216,
5217,
5218,
5219,
5280,
5245,
5227,
5244,
5261,
5260,
5269,
5268,
5235,
5272,
5271,
5264,
5263,
5233,
5224,
5223,
5240,
5239,
5234,
5226,
5225,
5242,
5241,
5236,
5255,
5254,
5275,
5274,
5278,
5276,
5277,
5258,
5220,
5249,
5248,
5250,
5279,
5257,
5231,
5229,
5230,
5320,
5327,
5323,
5324,
5321,
5322,
5313,
5314,
5315,
5316,
5326,
5319,
5325,
5318,
5328,
5345,
5344,
5358,
5357,
5355,
5359,
5354,
-1,
-1,
-1,
-1,
5302,
5284,
5287,
5297,
5300,
5291,
5293,
5308,
5306,
5289,
5285,
5288,
5298,
5301,
5292,
5294,
5309,
5307,
5305,
5304,
5340,
5341,
5332,
5333,
5338,
5339,
5335,
5336,
5343,
5342,
]

_charnames_69760 = [
12600,
12601,
12597,
12543,
12546,
12565,
12566,
12551,
12552,
12582,
12545,
12578,
12544,
12561,
12560,
12569,
12568,
12541,
12572,
12571,
12564,
12563,
12539,
12535,
12534,
12529,
12528,
12527,
12554,
12540,
12537,
12536,
12531,
12530,
12542,
12558,
12557,
12575,
12574,
12579,
12576,
12555,
12580,
12577,
12549,
12548,
12550,
12581,
12587,
12590,
12591,
12588,
12589,
12593,
12586,
12592,
12585,
12598,
12599,
12610,
12609,
12608,
12602,
12605,
12607,
12606,
]

_charnames_69840 = [
10455,
10454,
10467,
10466,
10465,
10464,
10446,
10443,
10459,
10444,
10452,
10457,
10451,
10456,
10463,
10460,
10461,
10442,
10468,
10450,
10462,
10453,
10458,
10449,
10447,
]

_charnames_69872 = [
10479,
10480,
10471,
10472,
10477,
10478,
10474,
10475,
10482,
10481,
-1,
-1,
-1,
-1,
-1,
-1,
1842,
1843,
1841,
1808,
1805,
1800,
1807,
1786,
1785,
1792,
1791,
1770,
1795,
1794,
1789,
1788,
1768,
1764,
1763,
1775,
1774,
1769,
1766,
1765,
1777,
1776,
1771,
1783,
1782,
1798,
1797,
1803,
1779,
1780,
1802,
1804,
1799,
1801,
1806,
1828,
1835,
1836,
1831,
1832,
1837,
1830,
1833,
1829,
1834,
1846,
1848,
1838,
1847,
-1,
1820,
1821,
1812,
1813,
1818,
1819,
1815,
1816,
1823,
1822,
1844,
1825,
1824,
1845,
]

_charnames_70016 = [
10027,
10024,
10020,
9945,
9948,
9967,
9968,
9953,
9954,
9923,
9924,
9925,
9926,
9983,
9947,
9980,
9946,
9963,
9962,
9971,
9970,
9937,
9974,
9973,
9966,
9965,
9935,
9931,
9930,
9942,
9941,
9936,
9933,
9932,
9944,
9943,
9938,
9957,
9956,
9977,
9976,
9981,
9978,
9979,
9960,
9959,
9927,
9951,
9950,
9952,
9982,
9993,
9996,
9997,
9994,
9995,
9986,
9987,
9988,
9989,
9999,
9992,
9998,
9991,
10021,
10023,
10026,
10025,
10029,
10016,
10015,
10030,
10028,
]

_charnames_70096 = [
10011,
10012,
10003,
10004,
10009,
10010,
10006,
10007,
10014,
10013,
]

_charnames_71296 = [
8347,
8350,
8368,
8369,
8351,
8352,
8385,
8349,
8381,
8348,
8364,
8363,
8372,
8371,
8339,
8375,
8374,
8367,
8366,
8337,
8333,
8332,
8344,
8343,
8338,
8335,
8334,
8346,
8345,
8340,
8361,
8360,
8378,
8377,
8382,
8379,
8358,
8383,
8380,
8354,
8355,
8384,
8357,
8416,
8413,
8404,
8407,
8408,
8405,
8406,
8410,
8403,
8409,
8402,
8414,
8415,
]

_charnames_71360 = [
8396,
8397,
8388,
8389,
8394,
8395,
8391,
8392,
8399,
8398,
]

_charnames_73728 = [
612,
669,
668,
667,
666,
665,
664,
663,
662,
690,
613,
627,
626,
621,
620,
625,
618,
617,
624,
623,
622,
628,
629,
635,
634,
633,
632,
631,
689,
682,
685,
684,
636,
646,
645,
644,
643,
640,
639,
642,
641,
648,
647,
686,
687,
670,
676,
675,
674,
673,
677,
688,
679,
680,
681,
660,
650,
656,
657,
655,
653,
654,
659,
658,
1036,
1044,
1043,
1042,
1037,
1039,
1038,
1040,
1041,
1055,
1059,
1058,
1057,
1045,
1049,
1048,
1050,
1053,
1054,
1051,
1052,
766,
767,
790,
789,
787,
786,
772,
773,
770,
771,
774,
796,
783,
784,
795,
779,
776,
778,
777,
794,
793,
792,
791,
782,
781,
801,
797,
800,
799,
819,
826,
820,
822,
821,
823,
824,
825,
802,
813,
814,
812,
808,
810,
809,
815,
816,
818,
803,
804,
805,
806,
807,
817,
827,
874,
875,
861,
869,
868,
867,
865,
864,
866,
879,
878,
877,
852,
855,
856,
857,
860,
859,
858,
872,
871,
876,
828,
835,
836,
837,
838,
851,
848,
849,
846,
847,
850,
840,
841,
842,
831,
832,
834,
833,
845,
844,
5,
97,
6,
13,
12,
11,
17,
16,
14,
15,
64,
63,
60,
61,
58,
55,
56,
57,
52,
53,
50,
51,
34,
33,
28,
29,
30,
31,
46,
44,
45,
48,
47,
75,
74,
40,
39,
36,
37,
41,
78,
72,
71,
68,
69,
77,
25,
24,
20,
21,
22,
26,
76,
65,
66,
67,
79,
93,
94,
91,
92,
86,
88,
87,
96,
80,
81,
83,
84,
85,
89,
90,
95,
153,
154,
98,
126,
125,
127,
119,
121,
122,
128,
107,
108,
100,
106,
105,
104,
103,
102,
118,
110,
117,
115,
114,
116,
129,
152,
130,
133,
134,
136,
135,
137,
143,
147,
146,
148,
151,
149,
150,
138,
142,
141,
140,
1003,
1005,
1006,
1007,
983,
985,
986,
993,
992,
991,
990,
989,
988,
987,
994,
995,
1001,
1000,
999,
998,
997,
1002,
955,
981,
980,
973,
976,
975,
963,
964,
969,
966,
967,
968,
970,
972,
971,
956,
958,
961,
960,
959,
962,
979,
978,
977,
293,
337,
338,
339,
340,
335,
334,
333,
336,
356,
355,
296,
300,
299,
297,
298,
301,
305,
303,
304,
306,
307,
353,
352,
344,
342,
343,
350,
349,
319,
323,
322,
321,
324,
325,
347,
346,
360,
359,
314,
315,
313,
312,
311,
310,
317,
316,
358,
326,
330,
329,
328,
327,
357,
380,
381,
382,
366,
365,
364,
362,
363,
378,
379,
371,
373,
374,
377,
376,
367,
370,
369,
408,
395,
404,
402,
403,
406,
405,
400,
399,
397,
398,
383,
394,
393,
388,
389,
392,
386,
387,
391,
384,
385,
390,
407,
156,
158,
161,
165,
164,
163,
168,
167,
166,
223,
222,
226,
225,
206,
207,
204,
205,
218,
219,
220,
202,
198,
201,
200,
190,
191,
189,
187,
188,
196,
195,
193,
194,
214,
215,
216,
224,
183,
182,
181,
178,
179,
184,
211,
210,
212,
169,
172,
171,
175,
174,
173,
227,
228,
230,
231,
232,
233,
239,
237,
238,
234,
235,
236,
288,
291,
290,
289,
240,
287,
241,
268,
267,
260,
261,
266,
265,
264,
249,
247,
248,
250,
259,
258,
263,
256,
255,
253,
252,
262,
269,
274,
273,
271,
272,
286,
275,
278,
279,
280,
285,
284,
281,
282,
283,
942,
946,
947,
950,
949,
948,
943,
944,
953,
954,
951,
952,
920,
941,
937,
938,
940,
939,
921,
926,
925,
924,
927,
928,
929,
930,
933,
934,
935,
936,
748,
758,
749,
753,
751,
752,
754,
757,
755,
756,
759,
763,
762,
764,
721,
747,
746,
741,
744,
743,
722,
732,
730,
731,
740,
739,
738,
737,
724,
728,
726,
727,
735,
734,
745,
692,
720,
693,
715,
714,
711,
712,
713,
718,
719,
716,
717,
694,
706,
705,
704,
703,
702,
701,
700,
699,
698,
697,
707,
708,
1030,
1033,
1032,
1031,
1034,
1009,
1019,
1020,
1018,
1017,
1021,
1014,
1015,
1012,
1013,
1022,
1023,
1028,
1027,
1026,
1029,
1081,
1082,
1084,
1083,
465,
490,
466,
488,
481,
482,
487,
480,
479,
486,
485,
484,
477,
476,
483,
474,
473,
472,
471,
470,
489,
491,
492,
493,
495,
494,
436,
437,
446,
445,
444,
443,
442,
441,
439,
440,
449,
448,
447,
450,
458,
457,
456,
460,
459,
451,
453,
452,
430,
433,
432,
412,
425,
418,
417,
424,
423,
414,
415,
422,
421,
420,
419,
435,
426,
428,
429,
434,
461,
464,
463,
462,
505,
511,
506,
507,
508,
510,
509,
496,
504,
501,
502,
503,
499,
500,
497,
498,
881,
896,
894,
893,
895,
897,
900,
899,
882,
890,
889,
886,
885,
888,
887,
902,
901,
917,
918,
903,
910,
909,
904,
908,
906,
907,
911,
916,
915,
914,
912,
913,
512,
602,
601,
600,
599,
598,
611,
610,
564,
573,
570,
569,
567,
568,
574,
571,
572,
575,
576,
581,
580,
579,
578,
586,
582,
585,
584,
607,
608,
513,
562,
561,
545,
554,
553,
555,
557,
556,
547,
550,
549,
563,
558,
559,
514,
533,
534,
542,
541,
517,
520,
519,
518,
521,
540,
529,
528,
527,
539,
538,
537,
536,
532,
531,
535,
525,
524,
523,
543,
544,
587,
592,
589,
590,
591,
593,
595,
594,
609,
604,
605,
606,
1073,
1075,
1076,
1078,
1077,
1079,
1061,
1067,
1066,
1062,
1063,
1065,
1064,
1068,
1069,
1070,
1072,
1071,
]

_charnames_74752 = [
1157,
1141,
1103,
1120,
1173,
1171,
1223,
1212,
1143,
1106,
1123,
1179,
1170,
1222,
1211,
1105,
1122,
1176,
1167,
1219,
1208,
1190,
1153,
1140,
1102,
1119,
1178,
1169,
1221,
1210,
1189,
1152,
1139,
1101,
1118,
1150,
1129,
1130,
1099,
1111,
1177,
1168,
1220,
1209,
1197,
1149,
1127,
1128,
1098,
1110,
1182,
1181,
1195,
1155,
1132,
1133,
1096,
1116,
1137,
1136,
1088,
1092,
1091,
1090,
1175,
1166,
1165,
1164,
1217,
1218,
1204,
1206,
1205,
1207,
1158,
1142,
1104,
1121,
1174,
1196,
1156,
1134,
1094,
1095,
1114,
1115,
1214,
1215,
1192,
1159,
1187,
1147,
1112,
1186,
1146,
1193,
1198,
1200,
1201,
]

_charnames_77824 = [
2616,
2615,
2614,
2613,
2608,
2609,
2605,
2607,
2606,
2612,
2611,
2610,
2603,
2602,
2601,
2600,
2594,
2595,
2599,
2598,
2592,
2593,
2597,
2596,
2661,
2660,
2659,
2658,
2657,
2656,
2655,
2654,
2653,
2652,
2628,
2627,
2618,
2619,
2626,
2625,
2624,
2623,
2622,
2621,
2620,
2583,
2584,
2590,
2581,
2582,
2579,
2580,
2589,
2577,
2578,
2588,
2587,
2586,
2585,
2650,
2649,
2648,
2647,
2646,
2645,
2644,
2643,
2642,
2641,
2639,
2638,
2637,
2636,
2635,
2634,
2633,
2632,
2631,
2630,
2662,
3725,
3724,
3723,
3722,
3716,
3717,
3721,
3720,
3719,
3718,
3634,
3623,
3626,
3625,
3624,
3633,
3632,
3631,
3630,
3629,
3628,
3627,
3636,
3637,
3646,
3645,
3644,
3643,
3642,
3641,
3640,
3639,
3638,
3652,
3651,
3650,
3649,
3648,
2912,
2911,
2910,
2909,
2908,
2907,
2906,
2903,
2904,
2905,
2901,
2900,
2899,
2898,
2897,
2896,
2895,
2894,
2893,
2892,
2890,
2889,
2888,
2887,
2886,
2885,
2884,
2880,
2881,
2883,
2882,
2878,
2869,
2870,
2877,
2876,
2867,
2868,
2875,
2874,
2873,
2872,
2871,
2865,
2864,
2863,
2862,
2861,
2860,
2856,
2857,
2859,
2854,
2855,
2858,
2815,
2824,
2823,
2822,
2821,
2820,
2819,
2818,
2817,
2816,
2835,
2827,
2828,
2834,
2825,
2826,
2833,
2832,
2831,
2830,
2829,
2852,
2851,
2850,
2849,
2848,
2847,
2846,
2837,
2845,
2844,
2843,
2842,
2841,
2840,
2839,
2838,
3492,
3491,
3490,
3489,
3488,
3487,
3486,
3484,
3485,
3482,
3483,
3480,
3479,
3478,
3477,
3476,
3475,
3471,
3472,
3469,
3470,
3474,
3473,
3458,
3459,
3467,
3466,
3465,
3464,
3463,
3462,
3461,
3456,
3457,
3460,
3502,
3501,
3500,
3499,
3494,
3495,
3498,
3497,
3496,
3203,
3204,
3212,
3211,
3210,
3209,
3208,
3207,
3206,
3205,
3201,
3200,
3199,
3191,
3192,
3198,
3197,
3196,
3195,
3194,
3193,
3189,
3179,
3180,
3188,
3187,
3186,
3185,
3184,
3183,
3182,
3181,
3177,
3169,
3170,
3176,
3175,
3174,
3173,
3172,
3167,
3168,
3165,
3166,
3171,
3163,
3162,
3161,
3160,
3159,
3155,
3156,
3153,
3154,
3151,
3152,
3158,
3157,
3220,
3214,
3217,
3216,
3215,
3219,
3218,
3273,
3272,
3271,
3270,
3269,
3265,
3266,
3262,
3264,
3263,
3268,
3267,
3285,
3275,
3276,
3284,
3283,
3282,
3281,
3280,
3279,
3278,
3277,
3251,
3252,
3260,
3259,
3258,
3257,
3256,
3249,
3250,
3255,
3254,
3253,
3247,
3246,
3245,
3244,
3243,
3242,
3238,
3239,
3236,
3237,
3241,
3240,
3234,
3233,
3232,
3225,
3226,
3231,
3223,
3224,
3230,
3229,
3228,
3227,
3291,
3290,
3289,
3288,
3287,
3745,
3744,
3743,
3742,
3741,
3737,
3738,
3740,
3739,
3665,
3664,
3663,
3662,
3657,
3658,
3661,
3660,
3659,
3655,
3656,
3669,
3670,
3667,
3668,
3674,
3673,
3672,
3671,
3754,
3753,
3752,
3751,
3750,
3749,
3748,
3747,
3714,
3707,
3708,
3713,
3712,
3711,
3705,
3706,
3710,
3709,
3130,
3132,
3131,
3141,
3133,
3134,
3140,
3139,
3138,
3137,
3136,
3135,
3094,
3095,
3100,
3079,
3087,
3086,
3085,
3084,
3083,
3082,
3081,
3080,
3099,
3098,
3092,
3093,
3090,
3091,
3088,
3089,
3097,
3096,
3128,
3127,
3120,
3121,
3126,
3118,
3119,
3125,
3124,
3123,
3116,
3117,
3122,
3114,
3105,
3106,
3113,
3102,
3104,
3103,
3112,
3111,
3110,
3109,
3108,
3107,
3143,
3144,
3148,
3147,
3146,
3145,
2753,
2752,
2751,
2750,
2749,
2748,
2747,
2746,
2745,
2731,
2730,
2729,
2728,
2727,
2726,
2725,
2724,
2720,
2722,
2721,
2723,
2743,
2742,
2741,
2740,
2739,
2733,
2734,
2738,
2737,
2736,
2735,
2718,
2717,
2716,
2711,
2712,
2709,
2710,
2707,
2708,
2715,
2705,
2706,
2714,
2713,
2757,
2756,
2755,
2811,
2810,
2809,
2808,
2802,
2803,
2807,
2806,
2805,
2804,
2800,
2799,
2798,
2797,
2796,
2795,
2794,
2790,
2791,
2793,
2792,
2812,
2782,
2781,
2780,
2779,
2778,
2777,
2776,
2775,
2774,
2764,
2765,
2762,
2763,
2772,
2771,
2770,
2769,
2768,
2767,
2760,
2761,
2766,
2787,
2786,
2784,
2785,
3006,
3007,
3013,
3012,
3011,
3004,
3005,
2997,
3003,
3002,
3001,
3000,
2999,
2998,
3010,
3009,
3008,
3047,
3050,
3049,
3048,
3060,
3059,
3058,
3057,
3056,
3055,
3054,
3053,
3051,
3052,
3038,
3039,
3045,
3044,
3043,
3036,
3037,
3034,
3035,
3042,
3041,
3040,
3032,
3033,
3022,
3023,
3030,
3029,
3020,
3021,
3028,
3027,
3015,
3019,
3018,
3017,
3016,
3026,
3025,
3024,
3071,
3070,
3069,
3068,
3067,
3066,
3065,
3064,
3063,
3062,
3073,
3075,
3074,
3076,
3679,
3680,
3687,
3677,
3678,
3686,
3685,
3684,
3683,
3682,
3681,
3690,
3689,
3762,
3761,
3760,
3759,
3758,
3757,
3756,
3573,
3565,
3566,
3562,
3564,
3563,
3572,
3571,
3570,
3569,
3568,
3567,
3551,
3552,
3560,
3559,
3558,
3557,
3556,
3549,
3550,
3555,
3554,
3553,
3584,
3583,
3582,
3581,
3580,
3579,
3578,
3577,
3576,
3575,
3343,
3335,
3336,
3342,
3341,
3340,
3333,
3334,
3339,
3338,
3337,
3306,
3305,
3304,
3303,
3294,
3296,
3295,
3302,
3301,
3297,
3298,
3300,
3299,
3319,
3318,
3317,
3316,
3315,
3314,
3308,
3310,
3309,
3313,
3312,
3311,
3331,
3330,
3329,
3328,
3327,
3321,
3322,
3326,
3325,
3324,
3323,
3351,
3350,
3349,
3348,
3347,
3346,
3345,
3419,
3418,
3413,
3414,
3417,
3416,
3415,
3411,
3412,
3409,
3410,
3407,
3408,
3432,
3423,
3424,
3431,
3430,
3429,
3428,
3421,
3422,
3427,
3426,
3425,
3443,
3442,
3441,
3440,
3439,
3438,
3437,
3436,
3435,
3434,
3453,
3452,
3447,
3448,
3445,
3446,
3451,
3450,
3449,
3389,
3388,
3387,
3386,
3385,
3379,
3381,
3380,
3384,
3383,
3382,
3400,
3399,
3398,
3397,
3396,
3395,
3394,
3393,
3392,
3391,
3365,
3364,
3363,
3356,
3357,
3362,
3361,
3360,
3359,
3358,
3354,
3355,
3377,
3376,
3367,
3368,
3375,
3374,
3373,
3372,
3371,
3370,
3369,
3404,
3403,
3402,
2941,
2950,
2949,
2948,
2947,
2946,
2945,
2944,
2943,
2942,
2954,
2955,
2961,
2960,
2959,
2958,
2951,
2953,
2952,
2957,
2956,
2977,
2963,
2966,
2965,
2964,
2967,
2969,
2968,
2976,
2975,
2974,
2973,
2972,
2971,
2970,
2915,
2927,
2926,
2925,
2924,
2923,
2922,
2921,
2920,
2919,
2918,
2917,
2916,
2939,
2938,
2932,
2933,
2937,
2936,
2935,
2934,
2930,
2931,
2928,
2929,
2985,
2986,
2983,
2984,
2992,
2981,
2982,
2991,
2990,
2989,
2979,
2980,
2988,
2987,
2993,
2994,
3612,
3611,
3604,
3605,
3610,
3609,
3608,
3607,
3606,
3602,
3603,
3593,
3594,
3600,
3599,
3598,
3591,
3592,
3597,
3596,
3589,
3590,
3587,
3588,
3595,
3620,
3619,
3618,
3617,
3614,
3615,
3616,
3703,
3702,
3701,
3692,
3694,
3693,
3700,
3697,
3698,
3699,
3695,
3696,
3727,
3728,
3735,
3734,
3733,
3732,
3731,
3730,
3729,
3546,
3530,
3534,
3533,
3532,
3531,
3535,
3537,
3536,
3540,
3541,
3538,
3539,
3545,
3544,
3543,
3542,
3528,
3527,
3526,
3525,
3524,
3505,
3514,
3513,
3512,
3511,
3510,
3509,
3508,
3507,
3506,
3515,
3523,
3522,
3521,
3520,
3519,
3518,
3517,
3516,
2675,
2674,
2673,
2672,
2671,
2670,
2665,
2667,
2666,
2669,
2668,
2697,
2696,
2695,
2694,
2693,
2692,
2691,
2690,
2689,
2688,
2686,
2685,
2684,
2683,
2682,
2681,
2680,
2679,
2678,
2677,
2701,
2700,
2699,
]

_charnames_92160 = [
4569,
4677,
4646,
4647,
4590,
4621,
4666,
4578,
4624,
4643,
4644,
4600,
4662,
4571,
4598,
4605,
4614,
4632,
4565,
4652,
4583,
4630,
4568,
4672,
4671,
4564,
4603,
4638,
4675,
4639,
4610,
4577,
4680,
4676,
4563,
4631,
4615,
4616,
4608,
4656,
4640,
4587,
4649,
4599,
4592,
4648,
4661,
4669,
4629,
4664,
4602,
4653,
4586,
4657,
4609,
4620,
4670,
4683,
4682,
4658,
4628,
4604,
4623,
4561,
4625,
4574,
4636,
4584,
4679,
4570,
4601,
4591,
4613,
4575,
4665,
4627,
4637,
4580,
4597,
4573,
4655,
4581,
4681,
4668,
4593,
4589,
4612,
4717,
4752,
4726,
4727,
4747,
4689,
4736,
4755,
4688,
4737,
4741,
4756,
4745,
4719,
4720,
4758,
4740,
4751,
4724,
4723,
4698,
4691,
4714,
4732,
4759,
4731,
4746,
4742,
4764,
4712,
4709,
4763,
4728,
4753,
4702,
4707,
4708,
4699,
4725,
4692,
4703,
4715,
4739,
4701,
4761,
4690,
4762,
4733,
4696,
4695,
4748,
4710,
4718,
4693,
4735,
4711,
4422,
4459,
4513,
4551,
4420,
4437,
4423,
4546,
4471,
4548,
4463,
4455,
4469,
4541,
4441,
4478,
4497,
4547,
4500,
4514,
4458,
4481,
4432,
4473,
4515,
4508,
4509,
4530,
4442,
4524,
4450,
4520,
4532,
4419,
4553,
4462,
4489,
4456,
4416,
4535,
4474,
4492,
4453,
4522,
4417,
4556,
4436,
4433,
4431,
4557,
4554,
4470,
4555,
4449,
4536,
4519,
4428,
4446,
4504,
4415,
4485,
4482,
4537,
4506,
4448,
4424,
4550,
4418,
4430,
4454,
4507,
4429,
4440,
4488,
4516,
4439,
4527,
4531,
4472,
4486,
4479,
4498,
4468,
4499,
4477,
4512,
4445,
4491,
4490,
4528,
4502,
4503,
4425,
4461,
4538,
4542,
4543,
4523,
4317,
4404,
4264,
4300,
4265,
4378,
4267,
4277,
4258,
4283,
4403,
4252,
4330,
4254,
4349,
4360,
4329,
4270,
4336,
4350,
4395,
4353,
4340,
4302,
4286,
4319,
4311,
4342,
4394,
4268,
4347,
4249,
4364,
4407,
4251,
4409,
4287,
4306,
4373,
4288,
4323,
4308,
4381,
4307,
4299,
4376,
4274,
4315,
4356,
4282,
4362,
4341,
4393,
4348,
4401,
4363,
4250,
4303,
4273,
4346,
4386,
4384,
4280,
4374,
4257,
4304,
4260,
4392,
4387,
4391,
4289,
4292,
4337,
4354,
4262,
4253,
4365,
4312,
4352,
4278,
4361,
4320,
4259,
4372,
4261,
4276,
4269,
4406,
4351,
4398,
4368,
4366,
4281,
4400,
4375,
4313,
4297,
4335,
4322,
4333,
4328,
4355,
4295,
4331,
4293,
4385,
4296,
4332,
4382,
4321,
4377,
4399,
4367,
4294,
4316,
4339,
4410,
4054,
4138,
4118,
4183,
4240,
4178,
4090,
4172,
4227,
4067,
4058,
4086,
4130,
4031,
4197,
4233,
4170,
4040,
4091,
4137,
4190,
4180,
4069,
4046,
4109,
4029,
4045,
4068,
4229,
4063,
4103,
4173,
4035,
4116,
4216,
4030,
4064,
4111,
4177,
4041,
4056,
4131,
4169,
4087,
4052,
4037,
4160,
4217,
4135,
4151,
4104,
4134,
4195,
4171,
4142,
4238,
4235,
4184,
4083,
4128,
4221,
4047,
4167,
4115,
4119,
4072,
4081,
4224,
4133,
4191,
4161,
4074,
4159,
4123,
4057,
4098,
4148,
4186,
4206,
4223,
4026,
4196,
4108,
4032,
4219,
4208,
4077,
4102,
4154,
4039,
4075,
4071,
4105,
4113,
4207,
4080,
4121,
4218,
4204,
4120,
4085,
4027,
4189,
4097,
4078,
4152,
4036,
4094,
4205,
4210,
4061,
4243,
4139,
4241,
4242,
4182,
4093,
4127,
4129,
4053,
4166,
4153,
4042,
4149,
4156,
4157,
4146,
4147,
4194,
4101,
4062,
4088,
4234,
4211,
4239,
4185,
4112,
4230,
4228,
4043,
4048,
4164,
4165,
4203,
4079,
4095,
4179,
4198,
4124,
4107,
4110,
4141,
4199,
4122,
4143,
4209,
4220,
4797,
4835,
4794,
4837,
4802,
4816,
4775,
4827,
4804,
4805,
4812,
4817,
4779,
4771,
4807,
4785,
4784,
4786,
4787,
4793,
4791,
4768,
4767,
4770,
4829,
4782,
4830,
4777,
4821,
4776,
4832,
4822,
4806,
4778,
4800,
4792,
4773,
4774,
4783,
4823,
4836,
4833,
4826,
4825,
4796,
4809,
4801,
4813,
4811,
4810,
4818,
4795,
4788,
4834,
]

_charnames_93952 = [
9312,
9323,
9258,
9311,
9315,
9314,
9287,
9322,
9306,
9305,
9225,
9280,
9256,
9257,
9224,
9279,
9236,
9238,
9259,
9285,
9232,
9231,
9294,
9293,
9292,
9291,
9223,
9278,
9222,
9277,
9321,
9303,
9260,
9309,
9308,
9235,
9234,
9284,
9318,
9319,
9302,
9301,
9218,
9273,
9229,
9228,
9219,
9274,
9254,
9261,
9270,
9297,
9296,
9249,
9247,
9220,
9275,
9255,
9298,
9250,
9248,
9245,
9243,
9286,
9244,
9242,
9320,
9288,
9317,
]

_charnames_94032 = [
9237,
9377,
9375,
9376,
9334,
9342,
9341,
9335,
9336,
9356,
9358,
9363,
9362,
9350,
9353,
9354,
9359,
9325,
9326,
9327,
9328,
9330,
9333,
9332,
9329,
9331,
9343,
9344,
9345,
9346,
9347,
9349,
9348,
9360,
9361,
9337,
9338,
9352,
9365,
9351,
9364,
9340,
9355,
9339,
9357,
9366,
9367,
]

_charnames_94095 = [
9370,
9369,
9372,
9371,
9216,
9215,
9214,
9213,
9212,
9211,
9210,
9269,
9268,
9267,
9266,
9265,
9264,
]

_charnames_119296 = [
11535,
11552,
11563,
11562,
11546,
11561,
11560,
11559,
11558,
11545,
11544,
11543,
11542,
11541,
11540,
11539,
11538,
11537,
11536,
11557,
11556,
11555,
11554,
11553,
11551,
11550,
11549,
11548,
11547,
11504,
11512,
11496,
11519,
11533,
11532,
11511,
11510,
11509,
11508,
11507,
11506,
11505,
11518,
11517,
11516,
11515,
11514,
11513,
11531,
11530,
11529,
11528,
11527,
11526,
11503,
11502,
11501,
11500,
11499,
11498,
11497,
11524,
11523,
11522,
11521,
11520,
1404,
1405,
1406,
11622,
]

_charnames_119552 = [
8976,
14014,
14013,
14008,
14007,
14005,
8441,
8478,
8510,
8521,
8530,
8428,
8505,
8526,
8519,
8451,
8447,
8537,
8533,
8503,
8473,
8430,
8535,
8524,
8481,
8507,
8472,
8469,
8464,
8540,
8429,
8459,
8453,
8440,
8452,
8520,
8501,
8517,
8437,
8529,
8493,
8489,
8502,
8477,
8470,
8515,
8471,
8497,
8460,
8487,
8496,
8458,
8500,
8474,
8482,
8538,
8431,
8511,
8462,
8539,
8446,
8438,
8495,
8494,
8512,
8508,
8463,
8454,
8523,
8490,
8532,
8450,
8455,
8445,
8461,
8491,
8488,
8536,
8434,
8439,
8483,
8506,
8433,
8527,
8448,
8516,
8480,
]

_charnames_119648 = [
1611,
1603,
1604,
1609,
1610,
1606,
1607,
1613,
1612,
1624,
1616,
1617,
1622,
1623,
1619,
1620,
1626,
1625,
]

_charnames_126464 = [
10812,
10824,
10820,
10678,
-1,
10815,
10803,
10821,
10797,
10814,
10810,
10716,
10819,
10818,
10749,
10813,
10823,
10750,
10817,
10816,
10748,
10801,
10799,
10809,
10800,
10679,
10804,
10822,
10676,
10674,
10675,
10673,
-1,
10774,
10770,
-1,
10763,
-1,
-1,
10764,
-1,
10765,
10761,
10769,
10768,
10767,
10754,
10775,
10772,
10755,
10766,
-1,
10753,
10758,
10757,
10760,
-1,
10773,
-1,
10771,
-1,
-1,
-1,
-1,
-1,
-1,
10793,
-1,
-1,
-1,
-1,
10794,
-1,
10788,
-1,
10791,
-1,
10790,
10781,
10796,
-1,
10782,
10789,
-1,
10780,
-1,
-1,
10792,
-1,
10787,
-1,
10795,
-1,
10786,
-1,
10785,
-1,
10746,
10743,
-1,
10736,
-1,
-1,
10737,
10722,
10739,
10734,
-1,
10742,
10741,
10725,
10747,
10745,
10726,
10740,
-1,
10724,
10721,
10720,
10733,
-1,
10731,
10738,
10744,
10730,
-1,
10729,
-1,
10702,
10715,
10712,
10699,
10696,
10705,
10693,
10697,
10687,
10704,
-1,
10710,
10709,
10708,
10690,
10703,
10714,
10691,
10707,
10706,
10689,
10686,
10684,
10711,
10685,
10700,
10694,
10713,
-1,
-1,
-1,
-1,
-1,
10670,
10666,
10656,
-1,
10659,
10653,
10667,
10647,
10658,
-1,
10664,
10663,
10662,
10650,
10671,
10669,
10651,
10661,
10660,
10649,
10646,
10644,
10665,
10645,
10657,
10654,
10668,
]

_charnames_126976 = [
9447,
9404,
9451,
9440,
9455,
9458,
9450,
9431,
9409,
9414,
9420,
9425,
9395,
9400,
9445,
9438,
9432,
9410,
9415,
9421,
9426,
9396,
9401,
9446,
9439,
9430,
9408,
9413,
9419,
9424,
9394,
9399,
9444,
9437,
9456,
9433,
9453,
9459,
9403,
9402,
9460,
9449,
9457,
9454,
-1,
-1,
-1,
-1,
13890,
13889,
13888,
13887,
13886,
13885,
13884,
13883,
13881,
13880,
13879,
13878,
13877,
13876,
13875,
13873,
13872,
13871,
13870,
13869,
13868,
13867,
13865,
13864,
13863,
13862,
13861,
13860,
13859,
13857,
13856,
13855,
13854,
13853,
13852,
13851,
13849,
13848,
13847,
13846,
13845,
13844,
13843,
13841,
13840,
13839,
13838,
13837,
13836,
13835,
13831,
13830,
13829,
13828,
13827,
13826,
13825,
13824,
13822,
13821,
13820,
13819,
13818,
13817,
13816,
13814,
13813,
13812,
13811,
13810,
13809,
13808,
13806,
13805,
13804,
13803,
13802,
13801,
13800,
13798,
13797,
13796,
13795,
13794,
13793,
13792,
13790,
13789,
13788,
13787,
13786,
13785,
13784,
13782,
13781,
13780,
13779,
13778,
13777,
13776,
]

_charnames_127136 = [
12130,
12124,
12056,
12061,
12094,
12099,
12072,
12077,
12119,
12109,
12066,
12114,
12083,
12104,
12088,
-1,
-1,
12125,
12057,
12062,
12095,
12100,
12073,
12078,
12120,
12110,
12067,
12115,
12084,
12105,
12089,
-1,
-1,
12126,
12058,
12063,
12096,
12101,
12074,
12079,
12121,
12111,
12068,
12116,
12085,
12106,
12090,
12129,
-1,
12127,
12059,
12064,
12097,
12102,
12075,
12080,
12122,
12112,
12069,
12117,
12086,
12107,
12091,
12131,
]

_charnames_127232 = [
13990,
13991,
14001,
13993,
13994,
13999,
14000,
13996,
13997,
14003,
14002,
-1,
-1,
-1,
-1,
-1,
12163,
12162,
12161,
12160,
12159,
12158,
12157,
12156,
12155,
12154,
12153,
12152,
12151,
12150,
12149,
12148,
12147,
12146,
12145,
12144,
12143,
12142,
12141,
12140,
12139,
12138,
8693,
2530,
2529,
2535,
2539,
-1,
10198,
10197,
10196,
10195,
10194,
10193,
10192,
10191,
10190,
10189,
10188,
10187,
10186,
10185,
10184,
10183,
10182,
10181,
10180,
10179,
10178,
10177,
10176,
10175,
10174,
10173,
10226,
10224,
10205,
10203,
10222,
10219,
13634,
13633,
13632,
13631,
13630,
13629,
13628,
13627,
13626,
13625,
13624,
13623,
13622,
13621,
13620,
13619,
13618,
13617,
13616,
13615,
13614,
13613,
13612,
13611,
13610,
13609,
14290,
14289,
-1,
-1,
-1,
-1,
13600,
13599,
13598,
13597,
13596,
13595,
13594,
13593,
13592,
13591,
13590,
13589,
13588,
13587,
13586,
13585,
13584,
13583,
13582,
13581,
13580,
13579,
13578,
13577,
13576,
13575,
2549,
13604,
13603,
13602,
13606,
13601,
10238,
10170,
10169,
10217,
10225,
10215,
10214,
10223,
10204,
10221,
10220,
]

_charnames_127462 = [
14135,
14134,
14133,
14132,
14131,
14130,
14129,
14128,
14127,
14126,
14125,
14124,
14123,
14122,
14121,
14120,
14119,
14118,
14117,
14116,
14115,
14114,
14113,
14112,
14111,
14110,
10240,
10210,
10209,
]

_charnames_127504 = [
10136,
10128,
10125,
10211,
10162,
10119,
10167,
10118,
10161,
10148,
10156,
10142,
10115,
10126,
10131,
10141,
10116,
10153,
10152,
10166,
10129,
10121,
10146,
10134,
10144,
10160,
10159,
10168,
10127,
10163,
10124,
10145,
10165,
10135,
10155,
10154,
10122,
10147,
10138,
10139,
10151,
10114,
10130,
-1,
-1,
-1,
-1,
-1,
8681,
8692,
8691,
8688,
8686,
8683,
8685,
8689,
8682,
]

_charnames_127744 = [
2098,
14661,
2494,
13769,
10350,
10349,
2542,
10354,
14299,
5362,
14753,
7667,
9388,
3979,
3978,
3977,
11780,
13569,
14759,
14635,
14758,
14679,
14764,
6052,
14765,
2564,
13568,
14634,
6051,
14678,
10352,
11779,
10105,
]

_charnames_127792 = [
1863,
10591,
4009,
13984,
12178,
2440,
-1,
8757,
1861,
14280,
13443,
10355,
5464,
3983,
3982,
13394,
14653,
9553,
14622,
6643,
9720,
8705,
11388,
11648,
9203,
14756,
8418,
6641,
5192,
12276,
14158,
11637,
12249,
12250,
1862,
10516,
13253,
10605,
9204,
12257,
14251,
14252,
1642,
1232,
10519,
10541,
5367,
14689,
14284,
14045,
13077,
10358,
14688,
14639,
10493,
10094,
14462,
13900,
1641,
1872,
2374,
6718,
1237,
13420,
10104,
5496,
12265,
1640,
14658,
8573,
9915,
14789,
1647,
8713,
5503,
2499,
5197,
-1,
-1,
-1,
14253,
14793,
5506,
14590,
1871,
14624,
14630,
14631,
5110,
12173,
1632,
8419,
2550,
12277,
14587,
2428,
14790,
9001,
10609,
11649,
]

_charnames_127904 = [
2429,
14697,
14282,
14638,
9381,
9000,
2543,
13382,
11050,
8696,
2541,
8676,
2502,
12242,
7654,
14034,
10604,
5511,
11873,
5484,
14667,
9718,
9721,
9913,
11868,
9719,
8727,
7657,
9717,
14211,
8569,
10627,
5205,
1864,
10616,
14212,
10361,
-1,
8714,
13408,
11403,
14213,
10631,
]

_charnames_127968 = [
13413,
13412,
13076,
14584,
4007,
13421,
5186,
11386,
13416,
6712,
1636,
10608,
13985,
14618,
14463,
14588,
4008,
]

_charnames_128000 = [
14305,
8992,
13074,
14755,
1643,
8671,
6640,
14303,
2432,
14039,
2557,
14749,
10619,
10618,
13406,
14306,
11870,
10107,
8978,
14281,
1869,
13914,
12271,
5486,
3991,
13078,
10544,
5370,
11375,
13419,
6053,
14637,
8712,
5463,
8756,
13254,
5196,
14686,
5507,
12247,
12711,
12269,
14038,
5203,
13917,
8993,
1644,
8672,
14304,
2433,
14040,
10542,
13409,
8979,
13915,
12274,
14687,
13252,
14780,
5502,
12191,
12273,
12188,
-1,
4001,
-1,
3973,
13754,
8994,
8704,
14744,
14708,
14726,
14743,
14640,
14761,
13075,
8742,
8743,
2501,
13057,
2556,
14772,
4002,
13642,
8769,
14592,
14042,
12708,
5512,
14773,
12285,
13248,
12258,
9500,
11395,
13437,
14771,
14774,
14660,
5411,
5410,
5483,
11871,
9461,
14769,
14625,
9499,
8765,
8764,
12262,
14775,
5363,
12231,
9498,
9497,
12911,
12910,
5193,
1634,
12223,
14585,
14586,
11872,
5198,
4004,
11221,
14418,
10628,
14405,
11866,
14046,
6478,
13763,
14617,
13256,
5208,
10434,
12279,
12707,
6711,
14248,
11851,
12700,
5485,
1627,
14786,
5501,
5368,
8766,
10539,
11645,
13377,
5460,
11635,
14861,
12286,
13376,
14148,
13378,
14024,
3989,
11381,
5482,
10601,
1645,
10543,
14037,
14051,
12280,
14670,
14031,
10535,
8745,
14737,
13452,
8982,
1233,
13366,
2565,
5188,
5191,
5190,
5189,
8981,
1852,
10597,
12238,
5364,
9386,
14668,
13061,
14058,
14646,
13058,
12183,
12184,
2439,
8572,
2430,
1851,
1853,
5209,
2498,
12288,
14279,
12190,
10515,
8718,
5479,
6642,
13751,
13752,
2496,
13059,
11636,
5461,
13045,
5480,
13761,
10610,
9202,
8566,
12185,
14623,
9914,
12289,
1865,
13073,
14417,
12192,
4014,
14416,
3972,
2493,
2492,
13054,
13055,
12267,
12268,
13571,
8995,
8997,
7658,
8998,
13749,
11377,
2438,
-1,
7655,
8564,
14301,
7656,
-1,
-1,
-1,
8768,
2487,
2488,
2489,
11376,
6716,
13441,
10531,
10527,
10530,
10529,
5184,
3988,
6638,
14246,
6709,
2495,
12709,
6705,
13056,
5498,
5499,
5478,
6321,
14302,
5202,
3969,
13070,
10491,
8698,
13748,
12710,
14395,
14393,
14397,
14396,
14394,
14628,
3987,
14792,
13250,
13759,
13423,
12281,
9380,
8565,
2562,
10587,
14583,
8720,
5420,
14719,
6040,
6039,
6033,
6038,
10567,
10568,
14843,
13913,
14842,
13912,
-1,
-1,
2534,
2553,
2552,
13753,
]

_charnames_128336 = [
2482,
2449,
2455,
2469,
2472,
2462,
2465,
2479,
2485,
2458,
2476,
2452,
2481,
2448,
2454,
2468,
2471,
2461,
2464,
2478,
2484,
2457,
2475,
2451,
]

_charnames_128507 = [
8991,
8706,
10506,
10588,
8999,
11640,
11641,
14607,
10549,
10552,
10553,
10551,
10557,
10555,
14788,
10560,
14615,
14157,
10556,
10559,
10564,
13638,
4005,
14848,
14611,
12246,
1630,
1631,
12702,
14616,
12704,
12705,
14599,
14601,
14602,
14027,
14778,
11380,
12255,
2560,
12239,
14610,
14028,
14685,
11379,
14698,
14783,
10603,
8673,
11643,
6717,
14604,
13451,
14605,
14614,
11398,
14675,
10602,
14032,
14612,
14609,
11642,
2436,
10562,
10563,
2435,
12706,
12256,
2561,
14784,
-1,
-1,
-1,
-1,
14608,
14606,
12237,
10592,
13379,
10532,
13255,
12235,
12236,
12233,
12234,
]

_charnames_128640 = [
14283,
13393,
10520,
14300,
13435,
13436,
8725,
9195,
6479,
10507,
8723,
8724,
5408,
13067,
8715,
5412,
9387,
11404,
14632,
12260,
13066,
8420,
13065,
11385,
13068,
14155,
13980,
11051,
8726,
8977,
8988,
10357,
8989,
11304,
10100,
14278,
10534,
13403,
7644,
1635,
12261,
8719,
13916,
13742,
10569,
13746,
12287,
13918,
12264,
13755,
5510,
13745,
5509,
8990,
12251,
13747,
1868,
9201,
14776,
14153,
5195,
8707,
14754,
10103,
5182,
5183,
12189,
1236,
5210,
6624,
]

_charnames_128768 = [
11202,
11098,
11215,
11216,
11200,
11087,
11085,
11086,
11083,
11084,
11148,
11151,
11150,
11065,
11165,
11144,
11175,
11178,
11177,
11118,
11067,
11205,
11153,
11154,
11133,
11134,
11212,
11078,
11195,
11196,
11110,
11129,
11116,
11197,
11062,
11108,
11109,
11117,
11069,
11060,
11155,
11169,
11209,
11096,
11063,
11070,
11061,
11152,
11127,
11128,
11121,
11125,
11124,
11123,
11089,
11090,
11180,
11071,
11095,
11130,
11131,
11093,
11145,
11170,
11171,
11203,
11136,
11139,
11138,
11091,
11214,
11076,
11168,
11211,
11199,
11158,
11113,
11172,
11112,
11079,
11114,
11173,
11075,
11208,
11077,
11213,
11184,
11094,
11160,
11143,
11159,
11097,
11073,
11074,
11064,
11164,
11192,
11190,
11191,
11163,
11162,
11101,
11106,
11105,
11104,
11103,
11092,
11142,
11141,
11132,
11183,
11206,
11193,
11179,
11187,
11186,
]

_charnames_917760 = [
7097,
7086,
7075,
7230,
7219,
7208,
7197,
7186,
7241,
7252,
7251,
7250,
7249,
7329,
7328,
7327,
7326,
7325,
7324,
7323,
7322,
7321,
7320,
7318,
7317,
7316,
7315,
7314,
7313,
7312,
7311,
7310,
7309,
7307,
7306,
7305,
7304,
7303,
7302,
7301,
7300,
7299,
7298,
7296,
7295,
7294,
7293,
7292,
7291,
7290,
7289,
7288,
7287,
7285,
7284,
7283,
7282,
7281,
7280,
7279,
7278,
7277,
7276,
7274,
7273,
7272,
7271,
7270,
7269,
7268,
7267,
7266,
7265,
7263,
7262,
7261,
7260,
7259,
7258,
7257,
7256,
7255,
7254,
7184,
7183,
7182,
7181,
7180,
7179,
7178,
7177,
7176,
7175,
7173,
7172,
7171,
7170,
7169,
7168,
7167,
7166,
7165,
7164,
7162,
7161,
7160,
7159,
7158,
7157,
7156,
7155,
7154,
7153,
7151,
7150,
7149,
7148,
7147,
7146,
7145,
7144,
7143,
7142,
7140,
7139,
7138,
7137,
7136,
7135,
7134,
7133,
7132,
7131,
7129,
7128,
7127,
7126,
7125,
7124,
7123,
7122,
7121,
7120,
7118,
7117,
7116,
7115,
7114,
7113,
7112,
7111,
7110,
7109,
7107,
7106,
7105,
7104,
7103,
7102,
7101,
7100,
7099,
7098,
7096,
7095,
7094,
7093,
7092,
7091,
7090,
7089,
7088,
7087,
7085,
7084,
7083,
7082,
7081,
7080,
7079,
7078,
7077,
7076,
7240,
7239,
7238,
7237,
7236,
7235,
7234,
7233,
7232,
7231,
7229,
7228,
7227,
7226,
7225,
7224,
7223,
7222,
7221,
7220,
7218,
7217,
7216,
7215,
7214,
7213,
7212,
7211,
7210,
7209,
7207,
7206,
7205,
7204,
7203,
7202,
7201,
7200,
7199,
7198,
7196,
7195,
7194,
7193,
7192,
7191,
7190,
7189,
7188,
7187,
7248,
7247,
7246,
7245,
7244,
7243,
7242,
]

_charnames_983040 = [
13758,
13757,
10503,
10492,
10501,
10521,
3963,
3955,
3961,
3997,
3971,
3970,
11391,
11390,
11218,
5497,
5201,
5516,
1854,
13399,
13444,
8421,
6320,
13570,
3967,
6723,
13768,
3999,
6318,
7642,
7665,
14659,
14700,
2427,
2544,
10098,
6708,
10438,
10099,
6707,
10570,
14050,
14059,
13970,
14057,
13967,
14056,
13968,
14055,
13971,
14054,
13636,
13762,
10436,
10435,
3962,
3956,
2372,
2259,
3966,
3998,
10360,
10359,
3994,
3993,
14404,
14645,
14699,
14402,
11646,
11869,
14401,
14156,
14311,
14403,
14847,
14852,
10524,
13981,
13979,
12187,
12186,
13440,
13422,
5366,
5517,
13744,
13766,
14414,
14412,
13640,
13641,
10500,
10621,
3964,
3995,
1857,
13402,
13445,
1856,
13401,
13446,
6319,
7643,
7666,
12170,
12171,
12133,
12172,
12169,
12132,
14143,
14144,
14214,
10575,
10581,
10623,
10576,
10580,
10622,
13969,
14053,
12221,
12218,
12291,
12220,
12217,
12290,
10594,
10522,
2373,
2571,
9200,
9722,
10504,
10502,
10537,
3968,
3965,
4011,
10499,
10490,
10577,
10632,
10578,
10611,
1637,
2569,
10517,
10495,
13060,
13026,
12222,
12292,
11400,
11401,
13765,
10106,
5963,
5776,
2570,
12698,
6046,
6047,
6048,
6049,
8646,
14693,
14692,
14691,
9723,
14857,
14855,
14858,
6721,
14309,
6722,
14310,
12293,
6720,
14308,
13767,
9724,
14794,
14785,
9383,
9384,
14860,
12198,
7331,
7442,
7576,
7565,
7554,
7543,
7532,
7521,
7510,
7431,
7420,
7409,
7398,
7387,
7376,
7365,
5515,
5481,
14856,
5514,
7354,
7343,
7332,
7487,
7476,
7465,
7454,
7443,
7498,
7509,
7508,
7507,
7506,
7586,
7585,
7584,
7583,
7582,
7581,
7580,
7579,
7578,
7577,
7575,
7574,
7573,
7572,
7571,
7570,
7569,
7568,
7567,
7566,
7564,
7563,
7562,
7561,
7560,
7559,
7558,
7557,
7556,
7555,
7553,
7552,
7551,
7550,
7549,
7548,
7547,
7546,
7545,
7544,
7542,
7541,
7540,
7539,
7538,
7537,
7536,
7535,
7534,
7533,
7531,
7530,
7529,
7528,
7527,
7526,
7525,
7524,
7523,
7522,
7520,
7519,
7518,
7517,
7516,
7515,
7514,
7513,
7512,
7511,
7441,
7440,
7439,
7438,
7437,
7436,
7435,
7434,
7433,
7432,
7430,
7429,
7428,
7427,
7426,
7425,
7424,
7423,
7422,
7421,
7419,
7418,
7417,
7416,
7415,
7414,
7413,
7412,
7411,
7410,
7408,
7407,
7406,
7405,
7404,
7403,
7402,
7401,
7400,
7399,
7397,
7396,
7395,
7394,
7393,
7392,
7391,
7390,
7389,
7388,
7386,
7385,
7384,
7383,
7382,
7381,
7380,
7379,
7378,
7377,
7375,
7374,
7373,
7372,
7371,
7370,
7369,
7368,
7367,
7366,
7364,
7363,
7362,
7361,
7360,
7359,
7358,
7357,
7356,
7355,
7353,
7352,
7351,
7350,
7349,
7348,
7347,
7346,
7345,
7344,
7342,
7341,
7340,
7339,
7338,
7337,
7336,
7335,
7334,
7333,
7497,
7496,
7495,
7494,
7493,
7492,
7491,
7490,
7489,
7488,
7486,
7485,
7484,
7483,
7482,
7481,
7480,
7479,
7478,
7477,
7475,
7474,
7473,
7472,
7471,
7470,
7469,
7468,
7467,
7466,
7464,
7463,
7462,
7461,
7460,
7459,
7458,
7457,
7456,
7455,
7453,
7452,
7451,
7450,
7449,
7448,
7447,
7446,
7445,
7444,
7505,
7504,
7503,
7502,
7501,
7500,
7499,
]

_charnames_983552 = [
5856,
5626,
5819,
5556,
5821,
5558,
5822,
5559,
5830,
5567,
5831,
5568,
5876,
5609,
5604,
5720,
5909,
5653,
5911,
5655,
5912,
5656,
5901,
5589,
5893,
5672,
5854,
5623,
5853,
5622,
5825,
5562,
5824,
5561,
5828,
5565,
5827,
5564,
5603,
5602,
5875,
5607,
5874,
5606,
5978,
5788,
5918,
5683,
5953,
5731,
5882,
5638,
5897,
5676,
5896,
5675,
5894,
5673,
5892,
5671,
5633,
5664,
5665,
5528,
5529,
5596,
5597,
5748,
5749,
5491,
8002,
7991,
8010,
7990,
7999,
7988,
7998,
7987,
8006,
8007,
8004,
8000,
7995,
8005,
7997,
7996,
8001,
7989,
8008,
7994,
7993,
7992,
8009,
8003,
7833,
7838,
7839,
7834,
7835,
7840,
7841,
7832,
7836,
7837,
7831,
7716,
7721,
7722,
7717,
7718,
7723,
7724,
7715,
7719,
7720,
7714,
7976,
7981,
7982,
7977,
7978,
7983,
7984,
7975,
7979,
7980,
7974,
7703,
7708,
7709,
7704,
7705,
7710,
7711,
7702,
7706,
7707,
7701,
7847,
7852,
7853,
7848,
7849,
7854,
7855,
7846,
7850,
7851,
7845,
7690,
7695,
7696,
7691,
7692,
7697,
7698,
7689,
7693,
7694,
7688,
7859,
7864,
7865,
7860,
7861,
7866,
7867,
7858,
7862,
7863,
7857,
7728,
7733,
7734,
7729,
7730,
7735,
7736,
7727,
7731,
7732,
7726,
7924,
7929,
7930,
7925,
7926,
7931,
7932,
7923,
7927,
7928,
7922,
7937,
7942,
7943,
7938,
7939,
7944,
7945,
7936,
7940,
7941,
7935,
7898,
7903,
7904,
7899,
7900,
7905,
7906,
7897,
7901,
7902,
7896,
7885,
7890,
7891,
7886,
7887,
7892,
7893,
7884,
7888,
7889,
7883,
7807,
7812,
7813,
7808,
7809,
7814,
7815,
7806,
7810,
7811,
7805,
7911,
7916,
7917,
7912,
7913,
7918,
7919,
7910,
7914,
7915,
7909,
7783,
7788,
7789,
7784,
7785,
7790,
7791,
7782,
7786,
7787,
7781,
7795,
7800,
7801,
7796,
7797,
7802,
7803,
7794,
7798,
7799,
7793,
7873,
7878,
7879,
7874,
7875,
7880,
7881,
7872,
7876,
7877,
7871,
7678,
7683,
7684,
7679,
7680,
7685,
7686,
7677,
7681,
7682,
7676,
7950,
7955,
7956,
7951,
7952,
7957,
7958,
7949,
7953,
7954,
7948,
7742,
7747,
7748,
7743,
7744,
7749,
7750,
7741,
7745,
7746,
7740,
7756,
7761,
7762,
7757,
7758,
7763,
7764,
7755,
7759,
7760,
7754,
7768,
7773,
7774,
7769,
7770,
7775,
7776,
7767,
7771,
7772,
7766,
7963,
7968,
7969,
7964,
7965,
7970,
7971,
7962,
7966,
7967,
7961,
7818,
7821,
7826,
7827,
7822,
7823,
7828,
7829,
7820,
7824,
7825,
7819,
7751,
10586,
10585,
10584,
11840,
12391,
12389,
12390,
12388,
12384,
12397,
12395,
12396,
12394,
12382,
12412,
12375,
12411,
12374,
12385,
12380,
12378,
12379,
12377,
12383,
12418,
12405,
12406,
12404,
12416,
12413,
12415,
12408,
12414,
12400,
12399,
12401,
12417,
12409,
12427,
12423,
12420,
12421,
12424,
12426,
12428,
13431,
13429,
13427,
13430,
13428,
12681,
12679,
12677,
12680,
12678,
12688,
12685,
12686,
12687,
8934,
8928,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 5698
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 5535
    elif code == 687: res = 5536
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 893: res = _charnames_880[code-880]
    elif code == 975: res = 11596
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1298
    elif code == 1231: res = 1936
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1319: res = _charnames_1296[code-1296]
    elif code == 1423: res = 11052
    elif code == 1442: res = 13390
    elif code == 1466: res = 13387
    elif code == 1477: res = 13389
    elif code == 1478: res = 13388
    elif code == 1479: res = 13386
    elif 1536 <= code <= 1568: res = _charnames_1536[code-1536]
    elif code == 1595: res = 10873
    elif code == 1596: res = 10871
    elif code == 1597: res = 10839
    elif code == 1598: res = 10837
    elif code == 1599: res = 10838
    elif 1622 <= code <= 1631: res = _charnames_1622[code-1622]
    elif code == 1774: res = 10929
    elif code == 1775: res = 10863
    elif code == 1791: res = 10889
    elif code == 1837: res = 10433
    elif code == 1838: res = 10431
    elif code == 1839: res = 10432
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2142: res = _charnames_1984[code-1984]
    elif 2208 <= code <= 2220: res = _charnames_2208[code-2208]
    elif 2276 <= code <= 2308: res = _charnames_2276[code-2276]
    elif code == 2362: res = 13958
    elif code == 2363: res = 13957
    elif 2382 <= code <= 2391: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2431: res = _charnames_2417[code-2417]
    elif code == 2493: res = 5493
    elif code == 2510: res = 5492
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 11863
    elif code == 2677: res = 11861
    elif code == 2700: res = 11856
    elif code == 2785: res = 11857
    elif code == 2786: res = 11854
    elif code == 2787: res = 11855
    elif code == 2800: res = 11859
    elif code == 2801: res = 11858
    elif code == 2869: res = 13044
    elif code == 2884: res = 13041
    elif code == 2914: res = 13039
    elif code == 2915: res = 13040
    elif 2929 <= code <= 2935: res = _charnames_2929[code-2929]
    elif code == 2998: res = 8021
    elif code == 3024: res = 8018
    elif code == 3046: res = 8013
    elif 3059 <= code <= 3066: res = _charnames_3059[code-3059]
    elif code == 3133: res = 8559
    elif code == 3160: res = 8561
    elif code == 3161: res = 8562
    elif code == 3170: res = 8555
    elif code == 3171: res = 8556
    elif 3192 <= code <= 3199: res = _charnames_3192[code-3192]
    elif code == 3260: res = 12693
    elif code == 3261: res = 12695
    elif code == 3298: res = 12696
    elif code == 3299: res = 12697
    elif code == 3313: res = 12694
    elif code == 3314: res = 12692
    elif code == 3369: res = 9512
    elif 3386 <= code <= 3396: res = _charnames_3386[code-3386]
    elif code == 3406: res = 9513
    elif code == 3426: res = 9515
    elif code == 3427: res = 9516
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif code == 3806: res = 6044
    elif code == 3807: res = 6043
    elif code == 3947: res = 8663
    elif code == 3948: res = 8662
    elif code == 3980: res = 8660
    elif code == 3981: res = 8656
    elif code == 3982: res = 8655
    elif code == 3983: res = 8657
    elif 4046 <= code <= 4058: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif 4345 <= code <= 4351: res = _charnames_4345[code-4345]
    elif code == 4442: res = 13246
    elif code == 4443: res = 13236
    elif code == 4444: res = 13238
    elif code == 4445: res = 13237
    elif code == 4446: res = 13220
    elif code == 4515: res = 13198
    elif code == 4516: res = 13182
    elif code == 4517: res = 13181
    elif code == 4518: res = 13185
    elif code == 4519: res = 13186
    elif code == 4602: res = 13142
    elif code == 4603: res = 13141
    elif code == 4604: res = 13145
    elif code == 4605: res = 13143
    elif code == 4606: res = 13144
    elif code == 4607: res = 13094
    elif code == 4615: res = 3935
    elif code == 4679: res = 3899
    elif code == 4743: res = 3889
    elif code == 4783: res = 3909
    elif code == 4815: res = 3931
    elif code == 4847: res = 3930
    elif code == 4879: res = 3809
    elif code == 4895: res = 3807
    elif code == 4935: res = 3867
    elif code == 4957: res = 3953
    elif code == 4958: res = 3954
    elif code == 4959: res = 3952
    elif code == 4960: res = 3936
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif code == 5120: res = 2370
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif code == 6109: res = 12370
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6829: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7155: res = _charnames_6912[code-6912]
    elif 7164 <= code <= 7295: res = _charnames_7164[code-7164]
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif 7376 <= code <= 7414: res = _charnames_7376[code-7376]
    elif 7424 <= code <= 7654: res = _charnames_7424[code-7424]
    elif code == 7676: res = 1336
    elif code == 7677: res = 1417
    elif code == 7678: res = 1375
    elif code == 7679: res = 1387
    elif code == 7836: res = 5691
    elif code == 7837: res = 5690
    elif code == 7838: res = 5905
    elif code == 7839: res = 5701
    elif code == 7930: res = 5951
    elif code == 7931: res = 5736
    elif code == 7932: res = 5950
    elif code == 7933: res = 5735
    elif code == 7934: res = 5970
    elif code == 7935: res = 5785
    elif 8275 <= code <= 8292: res = _charnames_8275[code-8275]
    elif 8336 <= code <= 8348: res = _charnames_8336[code-8336]
    elif 8370 <= code <= 8377: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1379
    elif code == 8428: res = 1392
    elif code == 8429: res = 1378
    elif code == 8430: res = 1376
    elif code == 8431: res = 1390
    elif code == 8432: res = 1413
    elif code == 8507: res = 14619
    elif code == 8508: res = 13899
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif code == 8580: res = 5646
    elif code == 8581: res = 14268
    elif code == 8582: res = 14267
    elif code == 8583: res = 14266
    elif code == 8584: res = 14269
    elif code == 8585: res = 7664
    elif 9167 <= code <= 9203: res = _charnames_9167[code-9167]
    elif code == 9471: res = 13635
    elif code == 9748: res = 14850
    elif code == 9749: res = 13417
    elif code == 9752: res = 10095
    elif code == 9854: res = 12241
    elif code == 9855: res = 14748
    elif 9866 <= code <= 9995: res = _charnames_9866[code-9866]
    elif code == 10024: res = 10540
    elif 10060 <= code <= 10071: res = _charnames_10060[code-10060]
    elif code == 10079: res = 13362
    elif code == 10080: res = 13363
    elif code == 10133: res = 13369
    elif code == 10134: res = 13371
    elif code == 10135: res = 13367
    elif code == 10160: res = 1234
    elif 10175 <= code <= 10191: res = _charnames_10175[code-10175]
    elif code == 10220: res = 9542
    elif code == 10221: res = 9538
    elif code == 10222: res = 9543
    elif code == 10223: res = 9539
    elif 11008 <= code <= 11097: res = _charnames_11008[code-11008]
    elif 11264 <= code <= 11623: res = _charnames_11264[code-11264]
    elif code == 11631: res = 8640
    elif code == 11632: res = 8639
    elif 11647 <= code <= 11670: res = _charnames_11647[code-11647]
    elif 11680 <= code <= 11835: res = _charnames_11680[code-11680]
    elif code == 12589: res = 5475
    elif 12728 <= code <= 12771: res = _charnames_12728[code-12728]
    elif code == 12829: res = 12165
    elif code == 12830: res = 12166
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 2538
    elif code == 12925: res = 2537
    elif code == 12926: res = 2540
    elif code == 13004: res = 10241
    elif code == 13005: res = 10244
    elif code == 13006: res = 10243
    elif code == 13007: res = 6412
    elif code == 13175: res = 10234
    elif code == 13176: res = 10236
    elif code == 13177: res = 10237
    elif code == 13178: res = 10246
    elif code == 13278: res = 10245
    elif code == 13279: res = 10249
    elif code == 13311: res = 10247
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42647: res = _charnames_42560[code-42560]
    elif 42655 <= code <= 42743: res = _charnames_42655[code-42655]
    elif 42752 <= code <= 42899: res = _charnames_42752[code-42752]
    elif 42912 <= code <= 42922: res = _charnames_42912[code-42912]
    elif 43000 <= code <= 43127: res = _charnames_43000[code-43000]
    elif 43136 <= code <= 43204: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43487: res = _charnames_43359[code-43359]
    elif 43520 <= code <= 43574: res = _charnames_43520[code-43520]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif 43739 <= code <= 43766: res = _charnames_43739[code-43739]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43822: res = _charnames_43808[code-43808]
    elif 43968 <= code <= 44025: res = _charnames_43968[code-43968]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif code == 64046: res = 2220
    elif code == 64047: res = 2219
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif code == 65021: res = 10941
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif code == 65060: res = 1400
    elif code == 65061: res = 1399
    elif code == 65062: res = 1303
    elif code == 65095: res = 12202
    elif code == 65096: res = 12199
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65947: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66432 <= code <= 66517: res = _charnames_66432[code-66432]
    elif code == 66598: res = 13977
    elif code == 66599: res = 13978
    elif 66638 <= code <= 66729: res = _charnames_66638[code-66638]
    elif 67584 <= code <= 67679: res = _charnames_67584[code-67584]
    elif 67840 <= code <= 67903: res = _charnames_67840[code-67840]
    elif 67968 <= code <= 68031: res = _charnames_67968[code-67968]
    elif 68096 <= code <= 68167: res = _charnames_68096[code-68096]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68223: res = _charnames_68192[code-68192]
    elif 68352 <= code <= 68479: res = _charnames_68352[code-68352]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69760 <= code <= 69825: res = _charnames_69760[code-69760]
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 70016 <= code <= 70088: res = _charnames_70016[code-70016]
    elif 70096 <= code <= 70105: res = _charnames_70096[code-70096]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 73728 <= code <= 74606: res = _charnames_73728[code-73728]
    elif 74752 <= code <= 74850: res = _charnames_74752[code-74752]
    elif code == 74864: res = 1229
    elif code == 74865: res = 1228
    elif code == 74866: res = 1227
    elif code == 74867: res = 1226
    elif 77824 <= code <= 78894: res = _charnames_77824[code-77824]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 110592: res = 12689
    elif code == 110593: res = 13432
    elif code == 119081: res = 9716
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119665: res = _charnames_119648[code-119648]
    elif code == 120001: res = 9550
    elif code == 120484: res = 9546
    elif code == 120485: res = 9545
    elif code == 120778: res = 9549
    elif code == 120779: res = 9548
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 10806
    elif code == 126705: res = 10807
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127136 <= code <= 127199: res = _charnames_127136[code-127136]
    elif 127232 <= code <= 127386: res = _charnames_127232[code-127232]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127504 <= code <= 127560: res = _charnames_127504[code-127504]
    elif code == 127568: res = 2524
    elif code == 127569: res = 2525
    elif 127744 <= code <= 127776: res = _charnames_127744[code-127744]
    elif 127792 <= code <= 127891: res = _charnames_127792[code-127792]
    elif 127904 <= code <= 127946: res = _charnames_127904[code-127904]
    elif 127968 <= code <= 127984: res = _charnames_127968[code-127968]
    elif 128000 <= code <= 128323: res = _charnames_128000[code-128000]
    elif 128336 <= code <= 128359: res = _charnames_128336[code-128336]
    elif 128507 <= code <= 128591: res = _charnames_128507[code-128507]
    elif 128640 <= code <= 128709: res = _charnames_128640[code-128640]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983488: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983972: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7168),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcdddefghidjdklddddmddddddddd\x15\x15\x15noddddddddddd\x15\x15\x15\x15pddddddddddd'
'dddddddddddddddddddddddddddddddddddddddd\x15\x15qddddrdddddddddddddddd'
'ddddddddddddddddddddddddddddddddddddddddddddddddsddddddddddddddd'
'ddddddddddddddddtuvwxyz{dddddddddddddddddddddd|d}~\x7f\x80\x81\x82\x83\x84dddddddd'
'\x85\x865555555\x87\x88\x8955555555555555555555555\x8a55555\x8b55555555555555555\x8c5555'
'5555555555555555555555555555555555\x8d55555555555555555555555555555'
'55555555555555555555555555555555555555\x8e5555555555555555\x8f\x90\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x8a5\x90\x91\x91\x91\x91\x92'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x92'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'\x93\x94dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xce\x8a\x8a\x7f\x9c\x7f\x8a\x8b\x94i\x8a\xa9x_yx??????????y\x8a\xb7\xb6\xb7\x8a'
'\x8a33333333333333333333333333\x94\x8ai\xa3\\\xa3\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x94\xb6i\xb6\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xcb\x82\x9c\x9c\x98\x9c\xc7\x82\xa0\xc6(r\xb6\x07\xc3\xa3\xbb\xabMM\xa0\x17\x82\x84\xa0M(nSSS\x82'
'22222202222222220222222\xae0222220\x15\x15\x15\x17\x17\x17\x17\x15\x17\x15\x15\x15\x17\x15\x15\x17\x17\x15\x17\x15\x15\x17\x17\x17\xae\x15\x15\x15\x17\x15\x17\x15\x17'
'2\x152\x172\x172\x172\x172\x172\x172\x172\x152\x152\x172\x172\x172\x152\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x150\x152\x172\x17\x152\x172\x172\x170'
'\x150\x152\x152\x172\x15\x150\x152\x152\x172\x170\x152\x172\x172\x172\x172\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x172\x172\x172\x1722\x172\x172\x17\x17'
'\x1722\x172\x1722\x17222\x17\x172222\x1722\x17222\x17\x17\x1722\x1722\x172\x172\x1722\x172\x17\x172\x1722\x17222\x172\x1722\x17\x17+2\x17\x17\x17'
'++++2/\x172/\x172/\x172\x152\x152\x152\x152\x152\x152\x152\x15\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x172/\x172\x17222\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x1722\x1722\x17'
'\x172\x172222\x172\x172\x172\x172\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17+\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17         $$\x1f\x1f\x1f\x1f\x1f'
'  \xa2\xa2\xa0\xa2$"$"""$"$$\x1a\x1f\xa2\xa2\xa2\xa2\xa2\xa2\xa0\xa0\xa0\xa0\xa2\xa0\xa2\xa0     \xa2\xa2\xa2\xa2\xa2\xa2\xa2$\xa2\x1f\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888898888888888888888888888888888888888888888882\x172\x17$\xa22\x17\x11\x11\x1e\x17\x17\x17\x88\x11'
'\x11\x11\x11\x11\xa2\xa22\x89222\x112\x1122\x1700000000000000000\x11000000022\x17\x17\x17\x17\x17\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x17\x15\x15\x15\x15\x15\x15\x15\x17\x17\x17\x17\x172\x17\x17222\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x172\x17\xb32\x1722\x17\x17222'
'202222222222222200000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x17\xc1:::::662\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'22\x172\x172\x172\x172\x172\x172\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11222222222222222'
'22222222222222222222222\x11\x11\x1f\x81\x81\x81\x81\x81\x81\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x11\x81b\x11\x11\x11\x11\x9b\x11:::::::::::::::::::::::::::::::::::::::::::::d:'
'\x8e::\x8e::\x8e:\x11\x11\x11\x11\x11\x11\x11\x11...........................\x11\x11\x11\x11\x11...\x8e\x8f\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x06\x06\x06\x06\x06\x11\xb3\xb3\xa5~~\x97ws\xc6\xc6:::::::::::s\x11\x11ss''''''''''''''''''''''''''''''''"
"\x19'''''''''':::::::::::::::::::::<<<<<<<<<<~tts'':'''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''s':::::::\x06\xc6::::::\x19\x19::\xc6::::''>>>>>>>>>>'''\xba\xba'"
"ssssssssssssss\x11\x05':''''''''''''''''''''''''''''''::::::::::::::::"
":::::::::::\x11\x11'''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''':::::::::::'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'AAAAAAAAAA.................................:::::::::%%\xc6\x88\x88\x88%\x11\x11\x11\x11\x11'
'......................::::%:::::::::%:::%:::::\x11\x11\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x11'
'.........................:::\x11\x11\x8e\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'\x11'''''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::::::::::::::::\x11'
':::4++++++++++++++++++++++++++++++++++++++++++++++++++++++:4:+44'
'4::::::::4444:44+:::::::++++++++++::\x81\x81@@@@@@@@@@\x81\x1f++++++\x11+++++++'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11+\x11\x11\x11++++\x11\x11:+44'
'4::::\x11\x1144\x11\x1144:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@++\x9b\x9bPPPPPP\xc1\x9b\x11\x11\x11\x11'
'\x11::4\x11++++++\x11\x11\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11++\x11++\x11\x11:\x1144'
'4::\x11\x11\x11\x11::\x11\x11:::\x11\x11\x11:\x11\x11\x11\x11\x11\x11\x11++++\x11+\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@::+++:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11::4\x11+++++++++\x11+++\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+44'
'4:::::\x11::4\x1144:\x11\x11+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x81\x9b\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+4:'
'4::::\x11\x1144\x11\x1144:\x11\x11\x11\x11\x11\x11\x11\x11:4\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@\xc1+PPPPPP\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11:+\x11++++++\x11\x11\x11+++\x11++++\x11\x11\x11++\x11+\x11++\x11\x11\x11++\x11\x11\x11+++\x11\x11\x11++++++++++++\x11\x11\x11\x1144'
':44\x11\x11\x11444\x11444:\x11\x11+\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@PPP\xc6\xc6\xc6\xc6\xc6\xc6\x9b\xc6\x11\x11\x11\x11\x11'
'\x11444\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11\x11+::'
':4444\x11:::\x11::::\x11\x11\x11\x11\x11\x11\x11::\x11++\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11UUUUUUU\xc1'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11:+47'
'44444\x11744\x1144::\x11\x11\x11\x11\x11\x11\x1144\x11\x11\x11\x11\x11\x11\x11+\x11++::\x11\x11@@@@@@@@@@\x11++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++++++++++++++++++++\x11\x11+44'
'4::::\x11444\x11444:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@PPPPPP\x11\x11\x11\xc1++++++'
'\x11\x1144\x11++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++\x11+++++++++\x11+\x11\x11'
'+++++++\x11\x11\x11:\x11\x11\x11\x11444:::\x11:\x1144444444\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x1144\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++++++++++++++++++++++++++++++++++++++++++++:+*:::::::\x11\x11\x11\x11\x9b'
'++++++\x1f::::::::\x81@@@@@@@@@@\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++\x11+\x11\x11++\x11+\x11\x11+\x11\x11\x11\x11\x11\x11++++\x11+++++++\x11+++\x11+\x11+\x11\x11++\x11++++:+*::::::\x11::+\x11\x11'
'+++++\x11\x1f\x11::::::\x11\x11@@@@@@@@@@\x11\x11++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+\xc1\xc1\xc1\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\xc1\x81\xc1\xc1\xc1::\xc1\xc1\xc1\xc1\xc1\xc1@@@@@@@@@@PPPPPPPPPP\xc1:\xc1:\xc1:\x93h\x93h44'
'++++++++\x11++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11::::::::::::::4'
':::::\x81::+++++:::::::::::\x11::::::::::::::::::::::::::::::::::::\x11\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1:\xc1\xc1\xc1\xc1\xc1\xc1\x11\xc1\xc1\x81\x81\x81\x81\x81\xc1\xc1\xc1\xc1\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++44::::4::::::4::44::+'
'@@@@@@@@@@\x81\x81\x81\x81\x81\x81++++++44::++++:::+444++4444444+++::::+++++++++++'
'++:44::444444:+4@@@@@@@@@@444:\xc1\xc122222222222222222222222222222222'
'222222\x112\x11\x11\x11\x11\x112\x11\x11+++++++++++++++++++++++++++++++++++++++++++\x81\x1f+++'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++,,,,,++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++,,,,,,'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++\x11+\x11++++\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++++++++++++++++++++++++++++\x11++++\x11\x11+++++++\x11'
'+\x11++++\x11\x11+++++++++++++++\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11++++\x11\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++\x11\x11:::\x81\x81\x81\x81\x81\x81\x81\x81\x81QQQQQQQQQPPPPPPPPPPP\x11\x11\x11'
'++++++++++++++++\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'b+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++\x81\x81+++++++++++++++++'
'\xcd++++++++++++++++++++++++++\x93h\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++\x81\x81\x81EEE\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++\x11++++:::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++:::\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++\x11+++\x11::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++::4:::::::44'
'444444:44:::::::::::\x81\x81\x81\x1f\x81\x81\x81\x9b+:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11UUUUUUUUUU\x11\x11\x11\x11\x11\x11'
'\x88\x88\x88\x88\x88\x88b\x88\x88\x88\x88:::\xcd\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++\x1f++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++:+\x11\x11\x11\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11:::4444::444\x11\x11\x11\x1144:444444:::\x11\x11\x11\x11'
'\xc6\x11\x11\x11\x88\x88@@@@@@@@@@++++++++++++++++++++++++++++++\x11\x11+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x114444444444444444'
'4+++++++44\x11\x11\x11\x11\x11\x11@@@@@@@@@@Q\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'+++++++++++++++++++++++::444\x11\x11\x81\x81++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++4:4:::::::\x11:4:44::::::::444444::::::::::\x11\x11:'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x81\x81\x81\x81\x81\x81\x81\x1f\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::::4+++++++++++++++++++++++++++++++++++++++++++++++:4:::::4:444'
'44:44+++++++\x11\x11\x11\x11@@@@@@@@@@\x81\x81\x81\x81\x81\x81\x81\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1:::::::::\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11'
'::4++++++++++++++++++++++++++++++4::::44::4:44++@@@@@@@@@@++++++'
'++++++++++++++++++++++++++++++++++++++:4::444:4:::44\x11\x11\x11\x11\x11\x11\x11\x11\x81\x81\x81\x81'
'++++++++++++++++++++++++++++++++++++44444444::::::::44::\x11\x11\x11\x81\x81\x81\x81\x81'
'@@@@@@@@@@\x11\x11\x11+++@@@@@@@@@@++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x81\x81'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x81\x81\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11:::\x81:::::::::::::4:::::::++++:++++44:++\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                    '
'                                           \x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17 \x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                                     '
':::::::::::::::::::::::::::::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x1722222222'
'\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x17\x112\x112\x112\x112\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x11\x17\x172222/\xa2\x17\xa2'
'\xa2\xa2\x17\x17\x17\x11\x17\x172222/\xa2\xa2\xa2\x17\x17\x17\x17\x11\x11\x17\x172222\x11\xa2\xa2\xa2\x17\x17\x17\x17\x17\x17\x17\x1722222\xa2\xa2\xa2\x11\x11\x17\x17\x17\x11\x17\x172222/\xa2\xa2\x11'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x08\x08\x08\t\x0eabbaaa\x82\x88pm\x92qol\x92q\x82\x82\x82\x88\x83\x82\x82\x83\xc9\xca\n\x0f\r\x0b\x10\xcb|~||~\x82\x88\x88\x88rn\x82\x88\x88\x82['
'[\x88\x88\x88\xa6\x93h\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\xb3\x88[\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\xcd\x08\x08\x08\x08\x08\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08N \x11\x11MNNNNN\xa8\xa8\xb3\x93h\x1b'
'NMMMMNNNNN\xa8\xa8\xb3\x93h\x11             \x11\x11\x11\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9a\x9b\x9b\x98\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::6666:666::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc62\xc3\xc6\xc3\xc62\xc6\xc3\x17222\x17\x17222\x15\xc62\xc3\xc6\xb522222\xc6\xc6\xc6\xc3\xc3\xc62\xc60\xc62\xc62022\xbd\x172222\x17++++\x17\xc6\xc6\x17\x1722'
'\xb4\xb3\xb3\xb3\xb32\x17\x17\x17\x17\xc6\xb3\xc6\xc6\x17\xc1UUUSSUUUUUUSSSSUBBBBBBBBBBBBFFFFCCCCCCCCCCGGGGGG'
'EEE2\x17EEEES\x11\x11\x11\x11\x11\x11\xae\xae\xae\xae\xae\xc3\xc3\xc3\xc3\xc3\xb3\xb3\xc6\xc6\xc6\xc6\xb3\xc6\xc6\xb3\xc6\xc6\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xc6\xc6\xae\xc6\xae\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xae\xb4\xaf\xaf\xb4\xb3\xb3\xae\xaf\xb4\xb4\xaf\xb4\xb4\xb3\xae\xb3\xaf\xa8\xac\xb3\xaf\xb4\xb3\xb3\xb3\xaf\xb4\xb4\xaf\xae\xaf\xaf\xb4\xb4\xae\xb4\xae\xb4\xae\xae\xae\xae\xaf\xaf\xb4\xaf\xb4\xb4\xb4\xb4\xb4\xae\xae\xae\xae\xb3\xb4\xb3\xb4\xaf\xaf\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xaf\xb4\xb4\xb4\xaf\xb3\xb3\xb3\xb3\xb3\xaf\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xaf\xae\xb4\xb3\xaf\xaf\xaf\xaf\xb4\xb4\xaf\xaf\xb3\xb3\xaf\xaf\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xaf\xaf\xb4\xb4\xaf\xaf\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xae\xb3\xb3\xb4\xae\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xae\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xaf'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb4\xb4\xb4\xb4\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb4\xb4\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x96k\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc6\xb3\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc1\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11TTTTTTTTTSSSSSSSSSSSTTTTTTTTTSSS'
'SSSSSSSSMMMMMMMMMLLLLLLLLLLL\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf'
'\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0VSSSSSSSSSSTTTTTTTTTST'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc3\xae\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6'
'\xc3\xae\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc6\xc6\xc3\xc6\xc6\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc3\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc3\xc3\xc3\xc6\xc3\xc3\xc3\xc3\xc6\xc3\xc3\xc6\xae\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc1\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3'
'\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x93h\x93h\x93h\x93h\x93h\x93h\x93hTTTTTTTTTS'
'VVVVVVVVVUVVVVVVVVVU\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xb4\xb3\xb3\xb4\xb4\x93h\xb3\xb4\xb4\xb3\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb3\xb3\xb3\xb4\xb4\xb4\xb4\x94i\x94i\x94i\x94i\x93h\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\x93h\x94i\x93h\x93h\x93h\x93h\x93h\x93h\x93h\x93h\x93h\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb3\xb3\x93h\x93h\xb4\xb3\xb3\xb3\xb3\xb4\xb3\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\x93h\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb3\xb4\xb3\xb3\xb4\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb3\xb4\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb3\xb3'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222222222222222222222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x112\x17222\x17\x172\x172\x172\x172222\x172\x17\x172\x17\x17\x17\x17\x17\x17  22'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\xc6\xc6\xc6\xc6\xc6\xc62\x172\x17:::2\x17\x11\x11\x11\x11\x11\x88\x88\x88\x88U\x88\x88'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x17\x11\x11\x11\x11\x11\x17\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x1f\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:'
'+++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11+++++++\x11+++++++\x11'
'+++++++\x11+++++++\x11+++++++\x11+++++++\x11::::::::::::::::::::::::::::::::'
'\x88\x88rnrn\x88\x88\x88rn\x88rn\x88\x88\x88\x88\x88\x88\x88\x88\x88b\x88\x88b\x88rn\x88\x88rn\x93h\x93h\x93h\x93h\x88\x88\x88\x88\x88#\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88bb\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11'
'\xcc\x8c\x8c\x8c\xc8!,H\x96k\x96k\x96k\x96k\x96k\xc8\xc8\x96k\x96k\x96k\x96kc\x95jj\xc8HHHHHHHHH;;;;55c!!!!!\xc8\xc8HHH!,\x8c\xc8\xc6'
'\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x11\x11;;\xa4\xa4!!,c,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x8c!!!,'
'\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,\x11\xc2\xc2RRRR\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\x11RRRRRRRRRR\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2OOOOOOOO\xc8WWWWWWWWWWWWWWW\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc8\xc2'
'RRRRRRRRRR\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2WWWWWWWWWWWWWWW'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc8\xc8\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\x11'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc8\xc8\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8'
',,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'-,,-,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-'
'-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,-,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',-,---,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',----,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,--'
',,,,,,,,,,,,---,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,-,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,!,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x11\x11\x11\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x81\x81'
'++++++++++++\x1f\x88\x88\x88++++++++++++++++@@@@@@@@@@++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17+:666\x88::::::::::\x88$'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11:++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++EEEEEEEEEE::\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11'
'\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2$$$$$$$$$\xa2\xa22\x172\x172\x172\x172\x172\x172\x17\x17\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17 \x17\x17\x17\x17\x17\x17\x17\x172\x172\x1722\x17'
'2\x172\x172\x172\x17$\x9f\x9f2\x172\x17\x112\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x112\x172\x172\x172\x172\x172\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11  \x17+++++'
'++:+++:++++:+++++++++++++++++++++++44::4\xc6\xc6\xc6\xc6\x11\x11\x11\x11PPPPPP\xc1\xc1\x9b\xbc\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++\x88\x88\x88\x88\x11\x11\x11\x11\x11\x11\x11\x11'
'44++++++++++++++++++++++++++++++++++++++++++++++++++444444444444'
'4444:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x81\x81@@@@@@@@@@\x11\x11\x11\x11\x11\x11::::::::::::::::::++++++\x81\x81\x81+\x11\x11\x11\x11'
'@@@@@@@@@@++++++++++++++++++++++++++++::::::::\x81\x81++++++++++++++++'
'+++++++:::::::::::44\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x81,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11'
':::4+++++++++++++++++++++++++++++++++++++++++++++++:44::::44:444'
'4\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x11\x1f@@@@@@@@@@\x11\x11\x11\x11\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++::::::44::44::\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++:++++++++:4\x11\x11@@@@@@@@@@\x11\x11\x81\x81\x81\x81++++++++++++++++\x1f++++++\xc1\xc1\xc1+4\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++:+:::++::+++++::'
'+:+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++\x1f\x81\x81+++++++++++4::44\x81\x81+\x1f\x1f4:\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++\x11\x11++++++\x11\x11++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++44:44:44\x814:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,'
',,,,,,,\x11\x11\x11\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x17\x17\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11.:..........\xa8.............\x11.....\x11.\x11'
"..\x11..\x11..........''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e"
"\x9e\x9e\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''&&&&&&''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x92g"
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''\x11\x11''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''&&\x97\xc6\x11\x11"
'8888888888888888\x8c\x8c\x8c\x8d\x8c\x8c\x8c\x95j\x8c\x11\x11\x11\x11\x11\x11:::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x8ccc]]\x95j\x95j\x95j\x95j\x95j\x95'
"j\x95j\x95j\x8c\x8c\x95j\x8c\x8c\x8c\x8c]]]z\x8c{\x11\x8c{\x8c\x8cc\x96k\x96k\x96k\x80\x8c\x8c\xaa`\xb9\xb9\xb8\x11\x8c\x9d\x80\x8c\x11\x11\x11\x11&'&'&\x11&'&'&'&'&'"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x11\x11\x08"
'\x11\x85\x85}\x99}\x85\x86\x90e\x85\xa7u^vu==========v\x85\xb1\xb0\xb1\x85\x8511111111111111111111111111\x90\x85e\xa1Z'
'\xa1\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x90\xb0e\xb0\x90e\x87\x91f\x87\x87))))))))))\x1d)))))))))))))))'
'))))))))))))))))))))))))))))))\x1c\x1c)))))))))))))))))))))))))))))))\x11'
'\x11\x11))))))\x11\x11))))))\x11\x11))))))\x11\x11)))\x11\x11\x11\x99\x99\xb0\xa1\xc4\x99\x99\x11\xc5\xb2\xb2\xb2\xb2\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x0c\x0c\x0c\xc6\xc3\x11\x11'
'++++++++++++\x11++++++++++++++++++++++++++\x11+++++++++++++++++++\x11++\x11+'
'++++++++++++++\x11\x11++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11'
'\x81\x88\x81\x11\x11\x11\x11PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIUUUU\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6U\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1:\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++\x11PPPP\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++'
'+E++++++++E\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++\x11\x81++++++++++++++++++++++++++++++++'
'++++\x11\x11\x11\x11++++++++\x81EEEEE\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2222222222222222222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......\x11\x11.\x11............................................\x11..\x11\x11\x11.\x11\x11.'
'......................\x11\x8eXXXXXXXX\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................XXXXXX\x11\x11\x11\x88..........................\x11\x11\x11\x11\x11\x8e'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'........................................................\x11\x11\x11\x11\x11\x11..'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'.:::\x11::\x11\x11\x11\x11\x11::::....\x11...\x11...........................\x11\x11\x11\x11:::\x11\x11\x11\x11:'
'YYYYXXXX\x11\x11\x11\x11\x11\x11\x11\x11\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x11\x11\x11\x11\x11\x11\x11.............................XX\x8e'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................................................\x11\x11\x11\x88\x88\x88\x88\x88\x88\x88'
'......................\x11\x11XXXXXXXX...................\x11\x11\x11\x11\x11XXXXXXXX'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'................................................................'
'.........\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11KKKKKKKKKJJJJJJJJJJJJJJJJJJJJJJ\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'4:4+++++++++++++++++++++++++++++++++++++++++++++++++++++::::::::'
':::::::\x81\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11VVVVVVVVVUUUUUUUUUUU@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4+++++++++++++++++++++++++++++++++++++++++++++444::::44::\x81\x81\t\x81\x81'
'\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
':::++++++++++++++++++++++++++++++++++++:::::4::::::::\x11@@@@@@@@@@'
'\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4++++++++++++++++++++++++++++++++++++++++++++++++444:::::::::4'
'4++++\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++:4:44::::::4:\x11\x11\x11\x11\x11\x11\x11\x11'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEDDEEEEEEEEEEEE'
'EEEEEEEEEEEEEEEEEEEEEEDDEEEEEEEEEEE\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+4444444444444444444444444444444444444444444444\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc144:::\xc1\xc1\xc1444444\x08\x08\x08\x08\x08\x08\x08\x08:::::'
':::\xc1\xc1:::::::\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1::::\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6:::\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11PPPPPPPPPPPPPPPPPP\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222'
'22222222222222\x17\x17\x17\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222222222222222'
'22\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x1122\x11\x112\x11\x1122\x11\x112222\x1122222222\x17\x17\x17\x17\x11\x17\x11\x17\x17\x17'
'\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x1722\x112222\x11\x1122222222\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722\x112222\x11'
'22222\x112\x11\x11\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222'
'222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222'
'2222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222222222222222'
'2222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11222222222222222222222222'
'2\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172\x17\x11\x11>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
"''''\x11'''''''''''''''''''''''''''\x11''\x11'\x11\x11'\x11''''''''''\x11''''\x11'\x11'\x11\x11\x11\x11"
"\x11\x11'\x11\x11\x11\x11'\x11'\x11'\x11'''\x11''\x11'\x11\x11'\x11'\x11'\x11'\x11'\x11''\x11'\x11\x11''''\x11'''''''\x11''''\x11''''\x11'\x11"
"''''''''''\x11'''''''''''''''''\x11\x11\x11\x11\x11'''\x11'''''\x11'''''''''''''''''\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xb3\xb3\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11'
'\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'MMMMMMMMMMM\x11\x11\x11\x11\x11\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\x11\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc6\xc6\x11\x11\x11\x11\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc2\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\x11\x11\x11\x11\x11'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11'
'\xc6\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11'
'\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,-,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x11\x11'
'\x11\x08\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'888888888888888888888888888888888888888888888888\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x11\x11'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
}

_decimal_corrected = {
178: None,
179: None,
185: None,
4969: None,
4970: None,
4971: None,
4972: None,
4973: None,
4974: None,
4975: None,
4976: None,
4977: None,
8304: None,
8308: None,
8309: None,
8310: None,
8311: None,
8312: None,
8313: None,
8320: None,
8321: None,
8322: None,
8323: None,
8324: None,
8325: None,
8326: None,
8327: None,
8328: None,
8329: None,
}
_digit = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6618: 1,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
9471: 0,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
68160: 1,
68161: 2,
68162: 3,
68163: 4,
69216: 1,
69217: 2,
69218: 3,
69219: 4,
69220: 5,
69221: 6,
69222: 7,
69223: 8,
69224: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
127232: 0,
127233: 0,
127234: 1,
127235: 2,
127236: 3,
127237: 4,
127238: 5,
127239: 6,
127240: 7,
127241: 8,
127242: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
1984: 0.0,
1985: 1.0,
1986: 2.0,
1987: 3.0,
1988: 4.0,
1989: 5.0,
1990: 6.0,
1991: 7.0,
1992: 8.0,
1993: 9.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3046: 0.0,
3192: 0.0,
3193: 1.0,
3194: 2.0,
3195: 3.0,
3196: 1.0,
3197: 2.0,
3198: 3.0,
3440: 10.0,
3441: 100.0,
3442: 1000.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
4240: 0.0,
4241: 1.0,
4242: 2.0,
4243: 3.0,
4244: 4.0,
4245: 5.0,
4246: 6.0,
4247: 7.0,
4248: 8.0,
4249: 9.0,
6128: 0.0,
6129: 1.0,
6130: 2.0,
6131: 3.0,
6132: 4.0,
6133: 5.0,
6134: 6.0,
6135: 7.0,
6136: 8.0,
6137: 9.0,
6470: 0.0,
6471: 1.0,
6472: 2.0,
6473: 3.0,
6474: 4.0,
6475: 5.0,
6476: 6.0,
6477: 7.0,
6478: 8.0,
6479: 9.0,
6608: 0.0,
6609: 1.0,
6610: 2.0,
6611: 3.0,
6612: 4.0,
6613: 5.0,
6614: 6.0,
6615: 7.0,
6616: 8.0,
6617: 9.0,
6618: 1.0,
6784: 0.0,
6785: 1.0,
6786: 2.0,
6787: 3.0,
6788: 4.0,
6789: 5.0,
6790: 6.0,
6791: 7.0,
6792: 8.0,
6793: 9.0,
6800: 0.0,
6801: 1.0,
6802: 2.0,
6803: 3.0,
6804: 4.0,
6805: 5.0,
6806: 6.0,
6807: 7.0,
6808: 8.0,
6809: 9.0,
6992: 0.0,
6993: 1.0,
6994: 2.0,
6995: 3.0,
6996: 4.0,
6997: 5.0,
6998: 6.0,
6999: 7.0,
7000: 8.0,
7001: 9.0,
7088: 0.0,
7089: 1.0,
7090: 2.0,
7091: 3.0,
7092: 4.0,
7093: 5.0,
7094: 6.0,
7095: 7.0,
7096: 8.0,
7097: 9.0,
7232: 0.0,
7233: 1.0,
7234: 2.0,
7235: 3.0,
7236: 4.0,
7237: 5.0,
7238: 6.0,
7239: 7.0,
7240: 8.0,
7241: 9.0,
7248: 0.0,
7249: 1.0,
7250: 2.0,
7251: 3.0,
7252: 4.0,
7253: 5.0,
7254: 6.0,
7255: 7.0,
7256: 8.0,
7257: 9.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
8581: 6.0,
8582: 50.0,
8583: 50000.0,
8584: 100000.0,
8585: 0.0,
9471: 0.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
13317: 5.0,
13443: 2.0,
14378: 5.0,
15181: 7.0,
20118: 4.0,
20160: 10.0,
20200: 3.0,
21316: 20.0,
21324: 40.0,
21444: 3.0,
24186: 1.0,
24318: 9.0,
28422: 7.0,
36019: 2.0,
38433: 1000.0,
42528: 0.0,
42529: 1.0,
42530: 2.0,
42531: 3.0,
42532: 4.0,
42533: 5.0,
42534: 6.0,
42535: 7.0,
42536: 8.0,
42537: 9.0,
42726: 1.0,
42727: 2.0,
42728: 3.0,
42729: 4.0,
42730: 5.0,
42731: 6.0,
42732: 7.0,
42733: 8.0,
42734: 9.0,
42735: 0.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43216: 0.0,
43217: 1.0,
43218: 2.0,
43219: 3.0,
43220: 4.0,
43221: 5.0,
43222: 6.0,
43223: 7.0,
43224: 8.0,
43225: 9.0,
43264: 0.0,
43265: 1.0,
43266: 2.0,
43267: 3.0,
43268: 4.0,
43269: 5.0,
43270: 6.0,
43271: 7.0,
43272: 8.0,
43273: 9.0,
43472: 0.0,
43473: 1.0,
43474: 2.0,
43475: 3.0,
43476: 4.0,
43477: 5.0,
43478: 6.0,
43479: 7.0,
43480: 8.0,
43481: 9.0,
43600: 0.0,
43601: 1.0,
43602: 2.0,
43603: 3.0,
43604: 4.0,
43605: 5.0,
43606: 6.0,
43607: 7.0,
43608: 8.0,
43609: 9.0,
44016: 0.0,
44017: 1.0,
44018: 2.0,
44019: 3.0,
44020: 4.0,
44021: 5.0,
44022: 6.0,
44023: 7.0,
44024: 8.0,
44025: 9.0,
63851: 3.0,
63859: 10.0,
63864: 2.0,
63922: 0.0,
63953: 6.0,
63955: 6.0,
63997: 10.0,
65799: 1.0,
65800: 2.0,
65801: 3.0,
65802: 4.0,
65803: 5.0,
65804: 6.0,
65805: 7.0,
65806: 8.0,
65807: 9.0,
65808: 10.0,
65809: 20.0,
65810: 30.0,
65811: 40.0,
65812: 50.0,
65813: 60.0,
65814: 70.0,
65815: 80.0,
65816: 90.0,
65817: 100.0,
65818: 200.0,
65819: 300.0,
65820: 400.0,
65821: 500.0,
65822: 600.0,
65823: 700.0,
65824: 800.0,
65825: 900.0,
65826: 1000.0,
65827: 2000.0,
65828: 3000.0,
65829: 4000.0,
65830: 5000.0,
65831: 6000.0,
65832: 7000.0,
65833: 8000.0,
65834: 9000.0,
65835: 10000.0,
65836: 20000.0,
65837: 30000.0,
65838: 40000.0,
65839: 50000.0,
65840: 60000.0,
65841: 70000.0,
65842: 80000.0,
65843: 90000.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65858: 1.0,
65859: 5.0,
65860: 50.0,
65861: 500.0,
65862: 5000.0,
65863: 50000.0,
65864: 5.0,
65865: 10.0,
65866: 50.0,
65867: 100.0,
65868: 500.0,
65869: 1000.0,
65870: 5000.0,
65871: 5.0,
65872: 10.0,
65873: 50.0,
65874: 100.0,
65875: 500.0,
65876: 1000.0,
65877: 10000.0,
65878: 50000.0,
65879: 10.0,
65880: 1.0,
65881: 1.0,
65882: 1.0,
65883: 2.0,
65884: 2.0,
65885: 2.0,
65886: 2.0,
65887: 5.0,
65888: 10.0,
65889: 10.0,
65890: 10.0,
65891: 10.0,
65892: 10.0,
65893: 30.0,
65894: 50.0,
65895: 50.0,
65896: 50.0,
65897: 50.0,
65898: 100.0,
65899: 300.0,
65900: 500.0,
65901: 500.0,
65902: 500.0,
65903: 500.0,
65904: 500.0,
65905: 1000.0,
65906: 5000.0,
65907: 5.0,
65908: 50.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65930: 0.0,
66369: 90.0,
66378: 900.0,
66513: 1.0,
66514: 2.0,
66515: 10.0,
66516: 20.0,
66517: 100.0,
66720: 0.0,
66721: 1.0,
66722: 2.0,
66723: 3.0,
66724: 4.0,
66725: 5.0,
66726: 6.0,
66727: 7.0,
66728: 8.0,
66729: 9.0,
67672: 1.0,
67673: 2.0,
67674: 3.0,
67675: 10.0,
67676: 20.0,
67677: 100.0,
67678: 1000.0,
67679: 10000.0,
67862: 1.0,
67863: 10.0,
67864: 20.0,
67865: 100.0,
67866: 2.0,
67867: 3.0,
68160: 1.0,
68161: 2.0,
68162: 3.0,
68163: 4.0,
68164: 10.0,
68165: 20.0,
68166: 100.0,
68167: 1000.0,
68221: 1.0,
68222: 50.0,
68440: 1.0,
68441: 2.0,
68442: 3.0,
68443: 4.0,
68444: 10.0,
68445: 20.0,
68446: 100.0,
68447: 1000.0,
68472: 1.0,
68473: 2.0,
68474: 3.0,
68475: 4.0,
68476: 10.0,
68477: 20.0,
68478: 100.0,
68479: 1000.0,
69216: 1.0,
69217: 2.0,
69218: 3.0,
69219: 4.0,
69220: 5.0,
69221: 6.0,
69222: 7.0,
69223: 8.0,
69224: 9.0,
69225: 10.0,
69226: 20.0,
69227: 30.0,
69228: 40.0,
69229: 50.0,
69230: 60.0,
69231: 70.0,
69232: 80.0,
69233: 90.0,
69234: 100.0,
69235: 200.0,
69236: 300.0,
69237: 400.0,
69238: 500.0,
69239: 600.0,
69240: 700.0,
69241: 800.0,
69242: 900.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
74752: 2.0,
74753: 3.0,
74754: 4.0,
74755: 5.0,
74756: 6.0,
74757: 7.0,
74758: 8.0,
74759: 9.0,
74760: 3.0,
74761: 4.0,
74762: 5.0,
74763: 6.0,
74764: 7.0,
74765: 8.0,
74766: 9.0,
74767: 4.0,
74768: 5.0,
74769: 6.0,
74770: 7.0,
74771: 8.0,
74772: 9.0,
74773: 1.0,
74774: 2.0,
74775: 3.0,
74776: 4.0,
74777: 5.0,
74778: 6.0,
74779: 7.0,
74780: 8.0,
74781: 9.0,
74782: 1.0,
74783: 2.0,
74784: 3.0,
74785: 4.0,
74786: 5.0,
74787: 2.0,
74788: 3.0,
74789: 3.0,
74790: 4.0,
74791: 5.0,
74792: 6.0,
74793: 7.0,
74794: 8.0,
74795: 9.0,
74796: 1.0,
74797: 2.0,
74798: 3.0,
74799: 3.0,
74800: 4.0,
74801: 5.0,
74804: 1.0,
74805: 2.0,
74806: 3.0,
74807: 3.0,
74808: 4.0,
74809: 5.0,
74810: 3.0,
74811: 3.0,
74812: 4.0,
74813: 4.0,
74814: 4.0,
74815: 4.0,
74816: 6.0,
74817: 7.0,
74818: 7.0,
74819: 7.0,
74820: 8.0,
74821: 8.0,
74822: 9.0,
74823: 9.0,
74824: 9.0,
74825: 9.0,
74826: 2.0,
74827: 3.0,
74828: 4.0,
74829: 5.0,
74830: 6.0,
74831: 1.0,
74832: 2.0,
74833: 3.0,
74834: 4.0,
74835: 4.0,
74836: 5.0,
74837: 5.0,
74840: 1.0,
74841: 2.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
119648: 1.0,
119649: 2.0,
119650: 3.0,
119651: 4.0,
119652: 5.0,
119653: 6.0,
119654: 7.0,
119655: 8.0,
119656: 9.0,
119657: 10.0,
119658: 20.0,
119659: 30.0,
119660: 40.0,
119661: 50.0,
119662: 60.0,
119663: 70.0,
119664: 80.0,
119665: 90.0,
127232: 0.0,
127233: 0.0,
127234: 1.0,
127235: 2.0,
127236: 3.0,
127237: 4.0,
127238: 5.0,
127239: 6.0,
127240: 7.0,
127241: 8.0,
127242: 9.0,
131073: 7.0,
131172: 4.0,
131298: 4.0,
131361: 5.0,
133418: 1.0,
133507: 30.0,
133516: 40.0,
133532: 40.0,
133866: 6.0,
133885: 3.0,
133913: 3.0,
140176: 2.0,
141720: 3.0,
146203: 3.0,
156269: 4.0,
194704: 9.0,
}

_numeric_corrected = {
20140: None,
22419: None,
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
384: 579,
410: 573,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
613: 42893,
614: 42922,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11507: 11506,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
11559: 4295,
11565: 4301,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
66638: 66598,
66639: 66599,
}

_toupper_corrected = {
}
_tolower = {
570: 11365,
571: 572,
573: 410,
574: 11366,
577: 578,
579: 384,
580: 649,
581: 652,
582: 583,
584: 585,
586: 587,
588: 589,
590: 591,
880: 881,
882: 883,
886: 887,
975: 983,
1015: 1016,
1017: 1010,
1018: 1019,
1021: 891,
1022: 892,
1023: 893,
1216: 1231,
1270: 1271,
1274: 1275,
1276: 1277,
1278: 1279,
1296: 1297,
1298: 1299,
1300: 1301,
1302: 1303,
1304: 1305,
1306: 1307,
1308: 1309,
1310: 1311,
1312: 1313,
1314: 1315,
1316: 1317,
1318: 1319,
4256: 11520,
4257: 11521,
4258: 11522,
4259: 11523,
4260: 11524,
4261: 11525,
4262: 11526,
4263: 11527,
4264: 11528,
4265: 11529,
4266: 11530,
4267: 11531,
4268: 11532,
4269: 11533,
4270: 11534,
4271: 11535,
4272: 11536,
4273: 11537,
4274: 11538,
4275: 11539,
4276: 11540,
4277: 11541,
4278: 11542,
4279: 11543,
4280: 11544,
4281: 11545,
4282: 11546,
4283: 11547,
4284: 11548,
4285: 11549,
4286: 11550,
4287: 11551,
4288: 11552,
4289: 11553,
4290: 11554,
4291: 11555,
4292: 11556,
4293: 11557,
4295: 11559,
4301: 11565,
7838: 223,
7930: 7931,
7932: 7933,
7934: 7935,
8498: 8526,
8579: 8580,
11264: 11312,
11265: 11313,
11266: 11314,
11267: 11315,
11268: 11316,
11269: 11317,
11270: 11318,
11271: 11319,
11272: 11320,
11273: 11321,
11274: 11322,
11275: 11323,
11276: 11324,
11277: 11325,
11278: 11326,
11279: 11327,
11280: 11328,
11281: 11329,
11282: 11330,
11283: 11331,
11284: 11332,
11285: 11333,
11286: 11334,
11287: 11335,
11288: 11336,
11289: 11337,
11290: 11338,
11291: 11339,
11292: 11340,
11293: 11341,
11294: 11342,
11295: 11343,
11296: 11344,
11297: 11345,
11298: 11346,
11299: 11347,
11300: 11348,
11301: 11349,
11302: 11350,
11303: 11351,
11304: 11352,
11305: 11353,
11306: 11354,
11307: 11355,
11308: 11356,
11309: 11357,
11310: 11358,
11360: 11361,
11362: 619,
11363: 7549,
11364: 637,
11367: 11368,
11369: 11370,
11371: 11372,
11373: 593,
11374: 625,
11375: 592,
11376: 594,
11378: 11379,
11381: 11382,
11390: 575,
11391: 576,
11392: 11393,
11394: 11395,
11396: 11397,
11398: 11399,
11400: 11401,
11402: 11403,
11404: 11405,
11406: 11407,
11408: 11409,
11410: 11411,
11412: 11413,
11414: 11415,
11416: 11417,
11418: 11419,
11420: 11421,
11422: 11423,
11424: 11425,
11426: 11427,
11428: 11429,
11430: 11431,
11432: 11433,
11434: 11435,
11436: 11437,
11438: 11439,
11440: 11441,
11442: 11443,
11444: 11445,
11446: 11447,
11448: 11449,
11450: 11451,
11452: 11453,
11454: 11455,
11456: 11457,
11458: 11459,
11460: 11461,
11462: 11463,
11464: 11465,
11466: 11467,
11468: 11469,
11470: 11471,
11472: 11473,
11474: 11475,
11476: 11477,
11478: 11479,
11480: 11481,
11482: 11483,
11484: 11485,
11486: 11487,
11488: 11489,
11490: 11491,
11499: 11500,
11501: 11502,
11506: 11507,
42560: 42561,
42562: 42563,
42564: 42565,
42566: 42567,
42568: 42569,
42570: 42571,
42572: 42573,
42574: 42575,
42576: 42577,
42578: 42579,
42580: 42581,
42582: 42583,
42584: 42585,
42586: 42587,
42588: 42589,
42590: 42591,
42592: 42593,
42594: 42595,
42596: 42597,
42598: 42599,
42600: 42601,
42602: 42603,
42604: 42605,
42624: 42625,
42626: 42627,
42628: 42629,
42630: 42631,
42632: 42633,
42634: 42635,
42636: 42637,
42638: 42639,
42640: 42641,
42642: 42643,
42644: 42645,
42646: 42647,
42786: 42787,
42788: 42789,
42790: 42791,
42792: 42793,
42794: 42795,
42796: 42797,
42798: 42799,
42802: 42803,
42804: 42805,
42806: 42807,
42808: 42809,
42810: 42811,
42812: 42813,
42814: 42815,
42816: 42817,
42818: 42819,
42820: 42821,
42822: 42823,
42824: 42825,
42826: 42827,
42828: 42829,
42830: 42831,
42832: 42833,
42834: 42835,
42836: 42837,
42838: 42839,
42840: 42841,
42842: 42843,
42844: 42845,
42846: 42847,
42848: 42849,
42850: 42851,
42852: 42853,
42854: 42855,
42856: 42857,
42858: 42859,
42860: 42861,
42862: 42863,
42873: 42874,
42875: 42876,
42877: 7545,
42878: 42879,
42880: 42881,
42882: 42883,
42884: 42885,
42886: 42887,
42891: 42892,
42893: 613,
42896: 42897,
42898: 42899,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
66598: 66638,
66599: 66639,
}

_tolower_corrected = {
}
_totitle = {
384: 579,
410: 573,
453: 453,
456: 456,
459: 459,
498: 498,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
613: 42893,
614: 42922,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11507: 11506,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
11559: 4295,
11565: 4301,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
66638: 66598,
66639: 66599,
}

_totitle_corrected = {
}
_special_casing = {
223: ([223], [83, 115], [83, 83]),
304: ([105, 775], [304], [304]),
329: ([329], [700, 78], [700, 78]),
496: ([496], [74, 780], [74, 780]),
912: ([912], [921, 776, 769], [921, 776, 769]),
944: ([944], [933, 776, 769], [933, 776, 769]),
1415: ([1415], [1333, 1410], [1333, 1362]),
7830: ([7830], [72, 817], [72, 817]),
7831: ([7831], [84, 776], [84, 776]),
7832: ([7832], [87, 778], [87, 778]),
7833: ([7833], [89, 778], [89, 778]),
7834: ([7834], [65, 702], [65, 702]),
8016: ([8016], [933, 787], [933, 787]),
8018: ([8018], [933, 787, 768], [933, 787, 768]),
8020: ([8020], [933, 787, 769], [933, 787, 769]),
8022: ([8022], [933, 787, 834], [933, 787, 834]),
8064: ([8064], [8072], [7944, 921]),
8065: ([8065], [8073], [7945, 921]),
8066: ([8066], [8074], [7946, 921]),
8067: ([8067], [8075], [7947, 921]),
8068: ([8068], [8076], [7948, 921]),
8069: ([8069], [8077], [7949, 921]),
8070: ([8070], [8078], [7950, 921]),
8071: ([8071], [8079], [7951, 921]),
8072: ([8064], [8072], [7944, 921]),
8073: ([8065], [8073], [7945, 921]),
8074: ([8066], [8074], [7946, 921]),
8075: ([8067], [8075], [7947, 921]),
8076: ([8068], [8076], [7948, 921]),
8077: ([8069], [8077], [7949, 921]),
8078: ([8070], [8078], [7950, 921]),
8079: ([8071], [8079], [7951, 921]),
8080: ([8080], [8088], [7976, 921]),
8081: ([8081], [8089], [7977, 921]),
8082: ([8082], [8090], [7978, 921]),
8083: ([8083], [8091], [7979, 921]),
8084: ([8084], [8092], [7980, 921]),
8085: ([8085], [8093], [7981, 921]),
8086: ([8086], [8094], [7982, 921]),
8087: ([8087], [8095], [7983, 921]),
8088: ([8080], [8088], [7976, 921]),
8089: ([8081], [8089], [7977, 921]),
8090: ([8082], [8090], [7978, 921]),
8091: ([8083], [8091], [7979, 921]),
8092: ([8084], [8092], [7980, 921]),
8093: ([8085], [8093], [7981, 921]),
8094: ([8086], [8094], [7982, 921]),
8095: ([8087], [8095], [7983, 921]),
8096: ([8096], [8104], [8040, 921]),
8097: ([8097], [8105], [8041, 921]),
8098: ([8098], [8106], [8042, 921]),
8099: ([8099], [8107], [8043, 921]),
8100: ([8100], [8108], [8044, 921]),
8101: ([8101], [8109], [8045, 921]),
8102: ([8102], [8110], [8046, 921]),
8103: ([8103], [8111], [8047, 921]),
8104: ([8096], [8104], [8040, 921]),
8105: ([8097], [8105], [8041, 921]),
8106: ([8098], [8106], [8042, 921]),
8107: ([8099], [8107], [8043, 921]),
8108: ([8100], [8108], [8044, 921]),
8109: ([8101], [8109], [8045, 921]),
8110: ([8102], [8110], [8046, 921]),
8111: ([8103], [8111], [8047, 921]),
8114: ([8114], [8122, 837], [8122, 921]),
8115: ([8115], [8124], [913, 921]),
8116: ([8116], [902, 837], [902, 921]),
8118: ([8118], [913, 834], [913, 834]),
8119: ([8119], [913, 834, 837], [913, 834, 921]),
8124: ([8115], [8124], [913, 921]),
8130: ([8130], [8138, 837], [8138, 921]),
8131: ([8131], [8140], [919, 921]),
8132: ([8132], [905, 837], [905, 921]),
8134: ([8134], [919, 834], [919, 834]),
8135: ([8135], [919, 834, 837], [919, 834, 921]),
8140: ([8131], [8140], [919, 921]),
8146: ([8146], [921, 776, 768], [921, 776, 768]),
8147: ([8147], [921, 776, 769], [921, 776, 769]),
8150: ([8150], [921, 834], [921, 834]),
8151: ([8151], [921, 776, 834], [921, 776, 834]),
8162: ([8162], [933, 776, 768], [933, 776, 768]),
8163: ([8163], [933, 776, 769], [933, 776, 769]),
8164: ([8164], [929, 787], [929, 787]),
8166: ([8166], [933, 834], [933, 834]),
8167: ([8167], [933, 776, 834], [933, 776, 834]),
8178: ([8178], [8186, 837], [8186, 921]),
8179: ([8179], [8188], [937, 921]),
8180: ([8180], [911, 837], [911, 921]),
8182: ([8182], [937, 834], [937, 834]),
8183: ([8183], [937, 834, 837], [937, 834, 921]),
8188: ([8179], [8188], [937, 921]),
64256: ([64256], [70, 102], [70, 70]),
64257: ([64257], [70, 105], [70, 73]),
64258: ([64258], [70, 108], [70, 76]),
64259: ([64259], [70, 102, 105], [70, 70, 73]),
64260: ([64260], [70, 102, 108], [70, 70, 76]),
64261: ([64261], [83, 116], [83, 84]),
64262: ([64262], [83, 116], [83, 84]),
64275: ([64275], [1348, 1398], [1348, 1350]),
64276: ([64276], [1348, 1381], [1348, 1333]),
64277: ([64277], [1348, 1387], [1348, 1339]),
64278: ([64278], [1358, 1398], [1358, 1350]),
64279: ([64279], [1348, 1389], [1348, 1341]),
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
1017: '<compat> 03A3',
4348: '<super> 10DC',
6918: '1B05 1B35',
6920: '1B07 1B35',
6922: '1B09 1B35',
6924: '1B0B 1B35',
6926: '1B0D 1B35',
6930: '1B11 1B35',
6971: '1B3A 1B35',
6973: '1B3C 1B35',
6976: '1B3E 1B35',
6977: '1B3F 1B35',
6979: '1B42 1B35',
7468: '<super> 0041',
7469: '<super> 00C6',
7470: '<super> 0042',
7472: '<super> 0044',
7473: '<super> 0045',
7474: '<super> 018E',
7475: '<super> 0047',
7476: '<super> 0048',
7477: '<super> 0049',
7478: '<super> 004A',
7479: '<super> 004B',
7480: '<super> 004C',
7481: '<super> 004D',
7482: '<super> 004E',
7484: '<super> 004F',
7485: '<super> 0222',
7486: '<super> 0050',
7487: '<super> 0052',
7488: '<super> 0054',
7489: '<super> 0055',
7490: '<super> 0057',
7491: '<super> 0061',
7492: '<super> 0250',
7493: '<super> 0251',
7494: '<super> 1D02',
7495: '<super> 0062',
7496: '<super> 0064',
7497: '<super> 0065',
7498: '<super> 0259',
7499: '<super> 025B',
7500: '<super> 025C',
7501: '<super> 0067',
7503: '<super> 006B',
7504: '<super> 006D',
7505: '<super> 014B',
7506: '<super> 006F',
7507: '<super> 0254',
7508: '<super> 1D16',
7509: '<super> 1D17',
7510: '<super> 0070',
7511: '<super> 0074',
7512: '<super> 0075',
7513: '<super> 1D1D',
7514: '<super> 026F',
7515: '<super> 0076',
7516: '<super> 1D25',
7517: '<super> 03B2',
7518: '<super> 03B3',
7519: '<super> 03B4',
7520: '<super> 03C6',
7521: '<super> 03C7',
7522: '<sub> 0069',
7523: '<sub> 0072',
7524: '<sub> 0075',
7525: '<sub> 0076',
7526: '<sub> 03B2',
7527: '<sub> 03B3',
7528: '<sub> 03C1',
7529: '<sub> 03C6',
7530: '<sub> 03C7',
7544: '<super> 043D',
7579: '<super> 0252',
7580: '<super> 0063',
7581: '<super> 0255',
7582: '<super> 00F0',
7583: '<super> 025C',
7584: '<super> 0066',
7585: '<super> 025F',
7586: '<super> 0261',
7587: '<super> 0265',
7588: '<super> 0268',
7589: '<super> 0269',
7590: '<super> 026A',
7591: '<super> 1D7B',
7592: '<super> 029D',
7593: '<super> 026D',
7594: '<super> 1D85',
7595: '<super> 029F',
7596: '<super> 0271',
7597: '<super> 0270',
7598: '<super> 0272',
7599: '<super> 0273',
7600: '<super> 0274',
7601: '<super> 0275',
7602: '<super> 0278',
7603: '<super> 0282',
7604: '<super> 0283',
7605: '<super> 01AB',
7606: '<super> 0289',
7607: '<super> 028A',
7608: '<super> 1D1C',
7609: '<super> 028B',
7610: '<super> 028C',
7611: '<super> 007A',
7612: '<super> 0290',
7613: '<super> 0291',
7614: '<super> 0292',
7615: '<super> 03B8',
8336: '<sub> 0061',
8337: '<sub> 0065',
8338: '<sub> 006F',
8339: '<sub> 0078',
8340: '<sub> 0259',
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
8507: '<compat> 0046 0041 0058',
8508: '<font> 03C0',
8528: '<fraction> 0031 2044 0037',
8529: '<fraction> 0031 2044 0039',
8530: '<fraction> 0031 2044 0031 0030',
8585: '<fraction> 0030 2044 0033',
11388: '<sub> 006A',
11389: '<super> 0056',
11631: '<super> 2D61',
12829: '<compat> 0028 110B 1169 110C 1165 11AB 0029',
12830: '<compat> 0028 110B 1169 1112 116E 0029',
12868: '<circle> 554F',
12869: '<circle> 5E7C',
12870: '<circle> 6587',
12871: '<circle> 7B8F',
12880: '<square> 0050 0054 0045',
12924: '<circle> 110E 1161 11B7 1100 1169',
12925: '<circle> 110C 116E 110B 1174',
12926: '<circle> 110B 116E',
13004: '<square> 0048 0067',
13005: '<square> 0065 0072 0067',
13006: '<square> 0065 0056',
13007: '<square> 004C 0054 0044',
13175: '<square> 0064 006D',
13176: '<square> 0064 006D 00B2',
13177: '<square> 0064 006D 00B3',
13178: '<square> 0049 0055',
13278: '<square> 0056 2215 006D',
13279: '<square> 0041 2215 006D',
13311: '<square> 0067 0061 006C',
42864: '<super> A76F',
43000: '<super> 0126',
43001: '<super> 0153',
64046: '90DE',
64047: '96B7',
64107: '6075',
64108: '242EE',
64109: '8218',
64112: '4E26',
64113: '51B5',
64114: '5168',
64115: '4F80',
64116: '5145',
64117: '5180',
64118: '52C7',
64119: '52FA',
64120: '559D',
64121: '5555',
64122: '5599',
64123: '55E2',
64124: '585A',
64125: '58B3',
64126: '5944',
64127: '5954',
64128: '5A62',
64129: '5B28',
64130: '5ED2',
64131: '5ED9',
64132: '5F69',
64133: '5FAD',
64134: '60D8',
64135: '614E',
64136: '6108',
64137: '618E',
64138: '6160',
64139: '61F2',
64140: '6234',
64141: '63C4',
64142: '641C',
64143: '6452',
64144: '6556',
64145: '6674',
64146: '6717',
64147: '671B',
64148: '6756',
64149: '6B79',
64150: '6BBA',
64151: '6D41',
64152: '6EDB',
64153: '6ECB',
64154: '6F22',
64155: '701E',
64156: '716E',
64157: '77A7',
64158: '7235',
64159: '72AF',
64160: '732A',
64161: '7471',
64162: '7506',
64163: '753B',
64164: '761D',
64165: '761F',
64166: '76CA',
64167: '76DB',
64168: '76F4',
64169: '774A',
64170: '7740',
64171: '78CC',
64172: '7AB1',
64173: '7BC0',
64174: '7C7B',
64175: '7D5B',
64176: '7DF4',
64177: '7F3E',
64178: '8005',
64179: '8352',
64180: '83EF',
64181: '8779',
64182: '8941',
64183: '8986',
64184: '8996',
64185: '8ABF',
64186: '8AF8',
64187: '8ACB',
64188: '8B01',
64189: '8AFE',
64190: '8AED',
64191: '8B39',
64192: '8B8A',
64193: '8D08',
64194: '8F38',
64195: '9072',
64196: '9199',
64197: '9276',
64198: '967C',
64199: '96E3',
64200: '9756',
64201: '97DB',
64202: '97FF',
64203: '980B',
64204: '983B',
64205: '9B12',
64206: '9F9C',
64207: '2284A',
64208: '22844',
64209: '233D5',
64210: '3B9D',
64211: '4018',
64212: '4039',
64213: '25249',
64214: '25CD0',
64215: '27ED3',
64216: '9F43',
64217: '9F8E',
65040: '<vertical> 002C',
65041: '<vertical> 3001',
65042: '<vertical> 3002',
65043: '<vertical> 003A',
65044: '<vertical> 003B',
65045: '<vertical> 0021',
65046: '<vertical> 003F',
65047: '<vertical> 3016',
65048: '<vertical> 3017',
65049: '<vertical> 2026',
65095: '<vertical> 005B',
65096: '<vertical> 005D',
69786: '11099 110BA',
69788: '1109B 110BA',
69803: '110A5 110BA',
69934: '11131 11127',
69935: '11132 11127',
120001: '<font> 006C',
120484: '<font> 0131',
120485: '<font> 0237',
120778: '<font> 03DC',
120779: '<font> 03DD',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127232: '<compat> 0030 002E',
127233: '<compat> 0030 002C',
127234: '<compat> 0031 002C',
127235: '<compat> 0032 002C',
127236: '<compat> 0033 002C',
127237: '<compat> 0034 002C',
127238: '<compat> 0035 002C',
127239: '<compat> 0036 002C',
127240: '<compat> 0037 002C',
127241: '<compat> 0038 002C',
127242: '<compat> 0039 002C',
127248: '<compat> 0028 0041 0029',
127249: '<compat> 0028 0042 0029',
127250: '<compat> 0028 0043 0029',
127251: '<compat> 0028 0044 0029',
127252: '<compat> 0028 0045 0029',
127253: '<compat> 0028 0046 0029',
127254: '<compat> 0028 0047 0029',
127255: '<compat> 0028 0048 0029',
127256: '<compat> 0028 0049 0029',
127257: '<compat> 0028 004A 0029',
127258: '<compat> 0028 004B 0029',
127259: '<compat> 0028 004C 0029',
127260: '<compat> 0028 004D 0029',
127261: '<compat> 0028 004E 0029',
127262: '<compat> 0028 004F 0029',
127263: '<compat> 0028 0050 0029',
127264: '<compat> 0028 0051 0029',
127265: '<compat> 0028 0052 0029',
127266: '<compat> 0028 0053 0029',
127267: '<compat> 0028 0054 0029',
127268: '<compat> 0028 0055 0029',
127269: '<compat> 0028 0056 0029',
127270: '<compat> 0028 0057 0029',
127271: '<compat> 0028 0058 0029',
127272: '<compat> 0028 0059 0029',
127273: '<compat> 0028 005A 0029',
127274: '<compat> 3014 0053 3015',
127275: '<circle> 0043',
127276: '<circle> 0052',
127277: '<circle> 0043 0044',
127278: '<circle> 0057 005A',
127280: '<square> 0041',
127281: '<square> 0042',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127293: '<square> 004E',
127294: '<square> 004F',
127295: '<square> 0050',
127296: '<square> 0051',
127297: '<square> 0052',
127298: '<square> 0053',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127302: '<square> 0057',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127306: '<square> 0048 0056',
127307: '<square> 004D 0056',
127308: '<square> 0053 0044',
127309: '<square> 0053 0053',
127310: '<square> 0050 0050 0056',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127376: '<square> 0044 004A',
127488: '<square> 307B 304B',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127504: '<square> 624B',
127505: '<square> 5B57',
127506: '<square> 53CC',
127507: '<square> 30C7',
127508: '<square> 4E8C',
127509: '<square> 591A',
127510: '<square> 89E3',
127511: '<square> 5929',
127512: '<square> 4EA4',
127513: '<square> 6620',
127514: '<square> 7121',
127515: '<square> 6599',
127516: '<square> 524D',
127517: '<square> 5F8C',
127518: '<square> 518D',
127519: '<square> 65B0',
127520: '<square> 521D',
127521: '<square> 7D42',
127522: '<square> 751F',
127523: '<square> 8CA9',
127524: '<square> 58F0',
127525: '<square> 5439',
127526: '<square> 6F14',
127527: '<square> 6295',
127528: '<square> 6355',
127529: '<square> 4E00',
127530: '<square> 4E09',
127531: '<square> 904A',
127532: '<square> 5DE6',
127533: '<square> 4E2D',
127534: '<square> 53F3',
127535: '<square> 6307',
127536: '<square> 8D70',
127537: '<square> 6253',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127552: '<compat> 3014 672C 3015',
127553: '<compat> 3014 4E09 3015',
127554: '<compat> 3014 4E8C 3015',
127555: '<compat> 3014 5B89 3015',
127556: '<compat> 3014 70B9 3015',
127557: '<compat> 3014 6253 3015',
127558: '<compat> 3014 76D7 3015',
127559: '<compat> 3014 52DD 3015',
127560: '<compat> 3014 6557 3015',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
194664: '36FC',
194676: '5F53',
194847: '243AB',
194911: '7AEE',
195007: '45D7',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
}

_canon_decomposition = {
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
64046: [37086],
64047: [38583],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
69934: [69937, 69927],
69935: [69938, 69927],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
1017: [931],
4348: [4316],
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
7468: [65],
7469: [198],
7470: [66],
7472: [68],
7473: [69],
7474: [398],
7475: [71],
7476: [72],
7477: [73],
7478: [74],
7479: [75],
7480: [76],
7481: [77],
7482: [78],
7484: [79],
7485: [546],
7486: [80],
7487: [82],
7488: [84],
7489: [85],
7490: [87],
7491: [97],
7492: [592],
7493: [593],
7494: [7426],
7495: [98],
7496: [100],
7497: [101],
7498: [601],
7499: [603],
7500: [604],
7501: [103],
7503: [107],
7504: [109],
7505: [331],
7506: [111],
7507: [596],
7508: [7446],
7509: [7447],
7510: [112],
7511: [116],
7512: [117],
7513: [7453],
7514: [623],
7515: [118],
7516: [7461],
7517: [946],
7518: [947],
7519: [948],
7520: [966],
7521: [967],
7522: [105],
7523: [114],
7524: [117],
7525: [118],
7526: [946],
7527: [947],
7528: [961],
7529: [966],
7530: [967],
7544: [1085],
7579: [594],
7580: [99],
7581: [597],
7582: [240],
7583: [604],
7584: [102],
7585: [607],
7586: [609],
7587: [613],
7588: [616],
7589: [617],
7590: [618],
7591: [7547],
7592: [669],
7593: [621],
7594: [7557],
7595: [671],
7596: [625],
7597: [624],
7598: [626],
7599: [627],
7600: [628],
7601: [629],
7602: [632],
7603: [642],
7604: [643],
7605: [427],
7606: [649],
7607: [650],
7608: [7452],
7609: [651],
7610: [652],
7611: [122],
7612: [656],
7613: [657],
7614: [658],
7615: [952],
8336: [97],
8337: [101],
8338: [111],
8339: [120],
8340: [601],
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
8507: [70, 65, 88],
8508: [960],
8528: [49, 8260, 55],
8529: [49, 8260, 57],
8530: [49, 8260, 49, 48],
8585: [48, 8260, 51],
11388: [106],
11389: [86],
11631: [11617],
12829: [40, 4363, 4457, 4364, 4453, 4523, 41],
12830: [40, 4363, 4457, 4370, 4462, 41],
12868: [21839],
12869: [24188],
12870: [25991],
12871: [31631],
12880: [80, 84, 69],
12924: [4366, 4449, 4535, 4352, 4457],
12925: [4364, 4462, 4363, 4468],
12926: [4363, 4462],
13004: [72, 103],
13005: [101, 114, 103],
13006: [101, 86],
13007: [76, 84, 68],
13175: [100, 109],
13176: [100, 109, 50],
13177: [100, 109, 51],
13178: [73, 85],
13278: [86, 8725, 109],
13279: [65, 8725, 109],
13311: [103, 97, 108],
42864: [42863],
43000: [294],
43001: [339],
64046: [37086],
64047: [38583],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
65040: [44],
65041: [12289],
65042: [12290],
65043: [58],
65044: [59],
65045: [33],
65046: [63],
65047: [12310],
65048: [12311],
65049: [46, 46, 46],
65095: [91],
65096: [93],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
69934: [69937, 69927],
69935: [69938, 69927],
120001: [108],
120484: [305],
120485: [567],
120778: [988],
120779: [989],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127232: [48, 46],
127233: [48, 44],
127234: [49, 44],
127235: [50, 44],
127236: [51, 44],
127237: [52, 44],
127238: [53, 44],
127239: [54, 44],
127240: [55, 44],
127241: [56, 44],
127242: [57, 44],
127248: [40, 65, 41],
127249: [40, 66, 41],
127250: [40, 67, 41],
127251: [40, 68, 41],
127252: [40, 69, 41],
127253: [40, 70, 41],
127254: [40, 71, 41],
127255: [40, 72, 41],
127256: [40, 73, 41],
127257: [40, 74, 41],
127258: [40, 75, 41],
127259: [40, 76, 41],
127260: [40, 77, 41],
127261: [40, 78, 41],
127262: [40, 79, 41],
127263: [40, 80, 41],
127264: [40, 81, 41],
127265: [40, 82, 41],
127266: [40, 83, 41],
127267: [40, 84, 41],
127268: [40, 85, 41],
127269: [40, 86, 41],
127270: [40, 87, 41],
127271: [40, 88, 41],
127272: [40, 89, 41],
127273: [40, 90, 41],
127274: [12308, 83, 12309],
127275: [67],
127276: [82],
127277: [67, 68],
127278: [87, 90],
127280: [65],
127281: [66],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127293: [78],
127294: [79],
127295: [80],
127296: [81],
127297: [82],
127298: [83],
127299: [84],
127300: [85],
127301: [86],
127302: [87],
127303: [88],
127304: [89],
127305: [90],
127306: [72, 86],
127307: [77, 86],
127308: [83, 68],
127309: [83, 83],
127310: [80, 80, 86],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127376: [68, 74],
127488: [12411, 12363],
127489: [12467, 12467],
127490: [12469],
127504: [25163],
127505: [23383],
127506: [21452],
127507: [12486, 12441],
127508: [20108],
127509: [22810],
127510: [35299],
127511: [22825],
127512: [20132],
127513: [26144],
127514: [28961],
127515: [26009],
127516: [21069],
127517: [24460],
127518: [20877],
127519: [26032],
127520: [21021],
127521: [32066],
127522: [29983],
127523: [36009],
127524: [22768],
127525: [21561],
127526: [28436],
127527: [25237],
127528: [25429],
127529: [19968],
127530: [19977],
127531: [36938],
127532: [24038],
127533: [20013],
127534: [21491],
127535: [25351],
127536: [36208],
127537: [25171],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127552: [12308, 26412, 12309],
127553: [12308, 19977, 12309],
127554: [12308, 20108, 12309],
127555: [12308, 23433, 12309],
127556: [12308, 28857, 12309],
127557: [12308, 25171, 12309],
127558: [12308, 30423, 12309],
127559: [12308, 21213, 12309],
127560: [12308, 25943, 12309],
127568: [24471],
127569: [21487],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
3294,
3741,
3743,
3747,
3749,
4048,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8472,
9288,
9289,
40981,
65048,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65279,
65279,
65279,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
7838: [115, 115],
}

_casefolds_corrected = {
1010: None,
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
848: 230,
849: 230,
850: 230,
851: 220,
852: 220,
853: 220,
854: 220,
855: 230,
856: 232,
857: 220,
858: 220,
859: 230,
860: 233,
861: 234,
862: 234,
863: 233,
1159: 230,
1442: 220,
1466: 19,
1477: 220,
1479: 18,
1552: 230,
1553: 230,
1554: 230,
1555: 230,
1556: 230,
1557: 230,
1558: 230,
1559: 230,
1560: 30,
1561: 31,
1562: 32,
1622: 220,
1623: 230,
1624: 230,
1625: 230,
1626: 230,
1627: 230,
1628: 220,
1629: 230,
1630: 230,
1631: 220,
2027: 230,
2028: 230,
2029: 230,
2030: 230,
2031: 230,
2032: 230,
2033: 230,
2034: 220,
2035: 230,
2070: 230,
2071: 230,
2072: 230,
2073: 230,
2075: 230,
2076: 230,
2077: 230,
2078: 230,
2079: 230,
2080: 230,
2081: 230,
2082: 230,
2083: 230,
2085: 230,
2086: 230,
2087: 230,
2089: 230,
2090: 230,
2091: 230,
2092: 230,
2093: 230,
2137: 220,
2138: 220,
2139: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
3260: 7,
4154: 9,
4237: 220,
4957: 230,
4958: 230,
4959: 230,
6109: 230,
6457: 222,
6458: 230,
6459: 220,
6679: 230,
6680: 220,
6752: 9,
6773: 230,
6774: 230,
6775: 230,
6776: 230,
6777: 230,
6778: 230,
6779: 230,
6780: 230,
6783: 220,
6964: 7,
6980: 9,
7019: 230,
7020: 220,
7021: 230,
7022: 230,
7023: 230,
7024: 230,
7025: 230,
7026: 230,
7027: 230,
7082: 9,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7223: 7,
7376: 230,
7377: 230,
7378: 230,
7380: 1,
7381: 220,
7382: 220,
7383: 220,
7384: 220,
7385: 220,
7386: 230,
7387: 230,
7388: 220,
7389: 220,
7390: 220,
7391: 220,
7392: 230,
7394: 1,
7395: 1,
7396: 1,
7397: 1,
7398: 1,
7399: 1,
7400: 1,
7405: 220,
7412: 230,
7616: 230,
7617: 230,
7618: 220,
7619: 230,
7620: 230,
7621: 230,
7622: 230,
7623: 230,
7624: 230,
7625: 230,
7626: 220,
7627: 230,
7628: 230,
7629: 234,
7630: 214,
7631: 220,
7632: 202,
7633: 230,
7634: 230,
7635: 230,
7636: 230,
7637: 230,
7638: 230,
7639: 230,
7640: 230,
7641: 230,
7642: 230,
7643: 230,
7644: 230,
7645: 230,
7646: 230,
7647: 230,
7648: 230,
7649: 230,
7650: 230,
7651: 230,
7652: 230,
7653: 230,
7654: 230,
7676: 233,
7677: 220,
7678: 230,
7679: 220,
8427: 1,
8428: 220,
8429: 220,
8430: 220,
8431: 220,
8432: 230,
11503: 230,
11504: 230,
11505: 230,
11647: 9,
11744: 230,
11745: 230,
11746: 230,
11747: 230,
11748: 230,
11749: 230,
11750: 230,
11751: 230,
11752: 230,
11753: 230,
11754: 230,
11755: 230,
11756: 230,
11757: 230,
11758: 230,
11759: 230,
11760: 230,
11761: 230,
11762: 230,
11763: 230,
11764: 230,
11765: 230,
11766: 230,
11767: 230,
11768: 230,
11769: 230,
11770: 230,
11771: 230,
11772: 230,
11773: 230,
11774: 230,
11775: 230,
42607: 230,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42620: 230,
42621: 230,
42655: 230,
42736: 230,
42737: 230,
43014: 9,
43204: 9,
43232: 230,
43233: 230,
43234: 230,
43235: 230,
43236: 230,
43237: 230,
43238: 230,
43239: 230,
43240: 230,
43241: 230,
43242: 230,
43243: 230,
43244: 230,
43245: 230,
43246: 230,
43247: 230,
43248: 230,
43249: 230,
43307: 220,
43308: 220,
43309: 220,
43347: 9,
43443: 7,
43456: 9,
43696: 230,
43698: 230,
43699: 230,
43700: 220,
43703: 230,
43704: 230,
43710: 230,
43711: 230,
43713: 230,
43766: 9,
44013: 9,
65060: 230,
65061: 230,
65062: 230,
66045: 220,
68109: 220,
68111: 230,
68152: 230,
68153: 1,
68154: 220,
68159: 9,
69702: 9,
69817: 9,
69818: 7,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70080: 9,
71350: 9,
71351: 7,
119362: 230,
119363: 230,
119364: 230,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

