# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=6.0.0 --output=unicodedb_6_0_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '6.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x0c ABOVE RIGHT'
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x03 AN'
'\x05 AND '
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\t AND PICK'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x06 ARROW'
'\x05 BACK'
'\x04 BAR'
'\x06 BELOW'
'\t BEVERAGE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x04 CAR'
'\x07 CER-WA'
'\x06 CHART'
'\x07 CHIKI '
'\x07 CIRCLE'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING GABA'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x0b DECORATION'
'\x11 DOWN BLACK ARROW'
'\t DRACHMAS'
'\x07 ENGINE'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ILUT'
'\x03 IN'
'\x0e IN SILHOUETTE'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x0e KISIM5 TIMES '
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x0b LANE MERGE'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\x07 MUOMAE'
'\x06 MURDA'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x08 OF FOOD'
'\r OPPOSING KUR'
'\x04 ORE'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x02 P'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\x12 PLUS LU PLUS ESH2'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\x11 PLUS SHA3 PLUS A'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x06 POINT'
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x0c PUNCTUATION'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x08 ROTUNDA'
'\x06 RULER'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x06 SEVEN'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\t SPARKLER'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\x12 THROUGH DESCENDER'
'\x07 TIMES '
'\x08 TIMES A'
'\x10 TIMES A PLUS NA'
'\n TIMES BAD'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x08 TIMES U'
'\x06 TONE-'
'\x08 TTUDDAG'
'\x02 U'
'\r VARIANT FORM'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x0b WITH COMMA'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DESCENDER'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\r WITH INK PEN'
'\r WITH JEGOGAN'
'\x0e WITH LONG LEG'
'\x14 WITH OBLIQUE STROKE'
'\x12 WITH PALATAL HOOK'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x12 WITH VERTICAL BAR'
'\x07 WOLOSO'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x06-PIEUP'
'\n-POINTING '
'\x19-POINTING DOUBLE TRIANGLE'
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x06-SHIRT'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x010'
'\x080 BRONZE'
'\x050 DWO'
'\x0b0 FOOTSTOOL'
'\x040 KO'
'\x040 MA'
'\x050 MAN'
'\x040 NI'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x070 SPEAR'
'\x030 U'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 ZO'
'\x030-0'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x071 ARROW'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DU'
'\x051 DWE'
'\x061 GOLD'
'\x081 HELMET'
'\x061 HORN'
'\x041 KU'
'\x031 O'
'\x041 PO'
'\x041 QI'
'\x041 SA'
'\x041 SI'
'\x051 TWO'
'\x061 WINE'
'\x031-0'
'\x0211'
'\x03121'
'\x03155'
'\x0216'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\n2 PLUS ASH'
'\n2 PLUS GAL'
'\x0b2 PLUS GIR2'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x042 SO'
'\x042 WO'
'\x072 WOMAN'
'\x032-0'
'\x0220'
'\x0221'
'\x0222'
'\t247 DIPTE'
'\x03253'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x043 PA'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x073 WHEEL'
'\x033-0'
'\x03305'
'\x0233'
'\x0234'
'\x0239'
'\x014'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x044 KE'
'\x044 NE'
'\x044 TE'
'\x044 WA'
'\x044 ZE'
'\x034-0'
'\x0240'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AU'
'\t5 BATHTUB'
'\t5 CYPERUS'
'\x045 DE'
'\x045 JU'
'\x065 MERI'
'\x045 MO'
'\x045 NU'
'\x045 TO'
'\x045 WE'
'\x065 WOOL'
'\x035-0'
'\x0250'
'\x0253'
'\x0255'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 JE'
'\x046 JO'
'\x046 NA'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x056 TA2'
'\x066 TREE'
'\x036-0'
'\x03620'
'\x036D7'
'\x017'
'\x047 DI'
'\x047 JA'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 ZA'
'\x0270'
'\x0272'
'\x0372C'
'\x0279'
'\x018'
'\x038 A'
'\x038 E'
'\x038 I'
'\x088 KANAKO'
'\x058 NWA'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 TA'
'\x049 TU'
'\x04904A'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x06A HAAM'
'\x06A MFON'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\nA TANG LAI'
'\x07A WITH '
'\x05A YUE'
'\x04A-HA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x03AAF'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\nAB2 TIMES '
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\x06ABOVE '
'\x0eABOVE REVERSE '
'\nAC LETTER '
'\x13ACCENT ATNAH HAFUKH'
'\x03ACE'
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x03ACT'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x03AD3'
'\x03ADA'
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x02AE'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\tAGOLITIC '
'\x04AGON'
'\x08AGRAPHOS'
'\x08AH WITH '
'\x04AHAD'
'\x08AHAPRANA'
'\x05AHMI '
'\x02AI'
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x04ALES'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x05ALGAR'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x04AMBA'
'\x07AME DIE'
'\x03AMI'
'\x04AMLA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN2'
'\x03ANA'
'\x04ANAE'
'\x04ANAP'
'\x06ANCORA'
'\x03AND'
'\x0fAND FEMALE SIGN'
'\x18AND MALE AND FEMALE SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x06ANGLE '
'\x07ANGOLAT'
'\x04ANGU'
'\x08ANGULAR '
'\x08ANI SIGN'
'\x08ANS SIGN'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\x03APP'
'\rAPPED PRESENT'
'\x05APPLE'
'\tAPUN IYEK'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x04ARAE'
'\x08ARCASITE'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x07ARDNESS'
'\nARFUL FACE'
'\x05ARGE '
'\x0bARGE CIRCLE'
'\x0bARGE SQUARE'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\tARM CLOCK'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x05ARROW'
'\x06ARROW '
'\x0bARROW WITH '
'\x0eARSI YEH WITH '
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\rAS ABOVE SIGN'
'\x07AS SIGN'
'\x04ASAT'
'\x03ASE'
'\x03ASH'
'\x04ASH2'
'\x06ASHGAB'
'\x05ASKAL'
'\x05ASPER'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x08ATAKANA '
'\x13ATED TELLER MACHINE'
'\x07ATH OF '
'\x12ATHA WITH TWO DOTS'
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x14ATIN CAPITAL LETTER '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x02AU'
'\x04AULA'
'\x07AULDRON'
'\x07AUNTLET'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x08AVAGRAHA'
'\x04AVE-'
'\x0fAVONIC ASTERISK'
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x0eAVY CHECK MARK'
'\x02AW'
'\rAWELLEMET YAZ'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x06AYEROK'
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\x03BAD'
'\x03BAG'
'\x0cBAHIRGOMUKHA'
'\x05BALAG'
'\x04BALL'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x08BARRED B'
'\tBASE UNIT'
'\x04BASH'
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x04BBON'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x06BEGIN '
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x05BENDE'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x06BGBIEE'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\x08BICYCLES'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x03BIN'
'\x07BINING '
'\x0cBINING MARK '
'\x05BISAH'
'\x06BISCUS'
'\x0fBJOINED LETTER '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\rBLACK HEXAGON'
'\x11BLACK SHOGI PIECE'
'\x03BLE'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x07BOARDER'
'\x08BOL SIGN'
'\x05BOLD '
'\x04BOOK'
'\x05BOOTS'
'\x06BOTTLE'
'\x11BOTTOM HALF BLACK'
'\x07BOURING'
'\x04BOVE'
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREVE'
'\x0cBREVE-MACRON'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x04BSET'
'\nBSTRUCTION'
'\x03BU '
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\tC CURRENT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x08CABLEWAY'
'\x05CAKRA'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x08CANDRA A'
'\x0cCANDRA BELOW'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x07CAP TEN'
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x05CECAK'
'\x05CECEK'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x06CER-WA'
'\x05CEREK'
'\x02CH'
'\nCH BALLOON'
'\x03CHA'
'\x06CHAMKO'
'\x03CHE'
'\nCHECK MARK'
'\x08CHEIKHEI'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x04CHIL'
'\x07CHILLU '
'\x06CHIRET'
'\x03CHO'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRYSANTHEMUM'
'\x06CHURCH'
'\x04CHWA'
'\nCHWA WITH '
'\x02CI'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x06CIRCLE'
'\rCIRCLE INSIDE'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\x04CKET'
'\x05CKING'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x0cCLOSED ENTRY'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\nCOMBINING '
'\x07COMING '
'\x0fCOMING ENVELOPE'
'\x05COMMA'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x11CONSONANT SIGN PA'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x04CORE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x12CREATIONAL VEHICLE'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\x03CRO'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x0fCROSS ON SHIELD'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x06CTOPUS'
'\x04CTOR'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x12CUP WITHOUT HANDLE'
'\x04CURL'
'\rCURLY BRACKET'
'\nCURLY LOOP'
'\x05CUTE-'
'\x03CWI'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x07D CHIME'
'\x04D HA'
'\x07D INDEX'
'\x07D MOUTH'
'\tD SALTIRE'
'\x1cD WITH LEFTWARDS ARROW ABOVE'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\nDA PLUS HA'
'\x03DAA'
'\x06DAGESH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x05DAMMA'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\tDATE MARK'
'\x0eDATE SEPARATOR'
'\x04DBAG'
'\x05DBOAT'
'\x02DD'
'\x04DDDA'
'\x05DDING'
'\x02DE'
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\tDESCENDER'
'\x0fDESCENDING TONE'
'\x08DESTRIAN'
'\x05DESTY'
'\x04DGER'
'\x03DHA'
'\x07DHALATH'
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\rDIAERESIZED U'
'\tDIAGONAL '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x0fDIAN RUPEE SIGN'
'\x03DIB'
'\x04DIC '
'\x0eDIFIER LETTER '
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x04DIM2'
'\x03DIN'
'\x03DIO'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x05DIUM '
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x02DO'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x08DOT REPH'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x1bDOTTED INTERPOLATION MARKER'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x07DOUBLE '
'\nDOUBLE BAR'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\rDOUBLE MUCAAD'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\tDOWN SIGN'
'\tDOWNWARDS'
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS TREND'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x06DUCEUS'
'\x03DUG'
'\x03DUN'
'\tDUN3 GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\x02DY'
'\tDY BEETLE'
'\x03DZA'
'\x03DZE'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\x1fE DOT OVER TWO DOTS PUNCTUATION'
'\x05E GEE'
'\x07E GLASS'
'\x05E OF '
'\x08E OF POO'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E0'
'\x02E2'
'\x03E80'
'\x04EACE'
'\x03EAD'
'\x07EAD ORE'
'\x05EAGLE'
'\x03EAM'
'\x04EANS'
'\x06EAR B '
'\nEARLY FORM'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\x0bECTION MARK'
'\x03ED '
'\x08ED BRICK'
'\x06ED ICE'
'\x0eED PARAGRAPHOS'
'\x07ED RICE'
'\tEDESTRIAN'
'\x06EDIAL '
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x03EEM'
'\x04EENG'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x06EFCASE'
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x0fEFTWARDS ARROWS'
'\x05EGION'
'\x12EH WITH INVERTED V'
'\tEH WITH T'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\tEIGHT OF '
'\x06EIGHTH'
'\x16EIGHTY ON BLACK SQUARE'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x03ELF'
'\x03ELL'
'\x0bELLOW HEART'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x05EMBIC'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x04ENCH'
'\nENCH FRIES'
'\rENCY EXCHANGE'
'\x03END'
'\x0eEND OF SECTION'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\nENS SYMBOL'
'\x07ENSHUET'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\x04ENTY'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x03EOW'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\x06ER MUG'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x0fERING MEGAPHONE'
'\x05ERN W'
'\x04ERSE'
'\x06ERTED '
'\x11ERU WITH BACK YER'
'\x02ES'
'\x08ESCENDER'
'\x1dESENTATION FORM FOR VERTICAL '
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x06ESHTIN'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\nEVANAGARI '
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\x12EVERSED C WITH DOT'
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x02EW'
'\x06EXAGON'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x17EXCLAMATION MARK SYMBOL'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EY '
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\x15F WITH TWO DOTS ABOVE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x15FACE WITH CLOSED EYES'
'\x16FACE WITH SMILING EYES'
'\x12FACING SVASTI SIGN'
'\tFACING UP'
'\x06FAMILY'
'\x05FATHA'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FEUQ'
'\x06FF OF '
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIFTY'
'\x06FIFTY '
'\x0bFILE FOLDER'
'\x07FINAGH '
'\x06FINAL '
'\tFINAL NGA'
'\x08FINAL TH'
'\x07FINAL Y'
'\x04FIRE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x0cFIVE HUNDRED'
'\x02FL'
'\x04FLAG'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x16FLATTENED OPEN A ABOVE'
'\x15FLATTENED PARENTHESIS'
'\x05FLICT'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x03FOM'
'\x12FORKED PARAGRAPHOS'
'\x15FORMATION DESK PERSON'
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x04FOUR'
'\nFOUR BELOW'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x08FROM BAR'
'\x08FROWNING'
'\x05FSAAQ'
'\x02FT'
'\x0cFT ICE CREAM'
'\x0cFT RERENGGAN'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x03GAG'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x03GAR'
'\x08GARITIC '
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GE'
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\x06GERINE'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x0bGGAGE CLAIM'
'\nGGRAVATION'
'\x03GGY'
'\x02GH'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\rGHT ARROWHEAD'
'\x08GHT RAIL'
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x04GIDA'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GISH'
'\x07GLAGOLI'
'\x07GLASSES'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'!GOLIAN LETTER MANCHU ALI GALI LHA'
'\x04GONG'
'\x03GOU'
'\x02GR'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x08GRAPH UK'
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\nGUA PI MAO'
'\x03GUD'
'\x04GUIN'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x02GW'
'\x13GYPTIAN HIEROGLYPH '
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x03H00'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x07HAARKAA'
'\x0bHAGGAR YAZH'
'\x04HAIN'
'\x03HAL'
'\x04HALF'
'\x0fHALF RING ABOVE'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x04HAYN'
'\x02HE'
'\x03HE '
'\x04HEAD'
'\x05HEAD '
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x08HEAVY YA'
'\x0bHEELED SHOE'
'\x12HEN WITH DIAERESIS'
'\x03HER'
'\x06HERMES'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x16HEXIFORM LONG ANUSVARA'
'\x02HI'
'\x05HI RO'
'\x0cHI TIMES BAD'
'\x03HID'
'\x05HIDET'
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\tHIMA SIMA'
'\x03HIN'
'\rHINESE TONE Y'
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x0bHJONG TILE '
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOO'
'\x04HOOK'
'\rHOOK AND TAIL'
'\tHOOK TAIL'
'\x04HOOL'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x06HORT A'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
'"HREE DOTS POINTING DOWNWARDS ABOVE'
' HREE DOTS POINTING UPWARDS BELOW'
'\tHREE FOR '
'\x08HREE OF '
'\x05HROOM'
'\x04HSHU'
'\x02HU'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x03HUR'
'\x02HV'
'\x02HW'
'\x03HWA'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x02I0'
'\x0eIAGONAL STROKE'
'\tIALECT-P '
'\x10IAMOND IN SQUARE'
'\x0bIAN LETTER '
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IAUDA'
'\x02IC'
'\x05ICAL '
'\x0cICE OF PIZZA'
'3ICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x02ID'
'\x03IDA'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\x06IFIED '
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\x08IGHT OF '
'\x0fIGHT WITH STARS'
'\tIGHTH ASH'
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x02IN'
'\x03IN '
'\tIN WITH T'
'\x03IN2'
'\x04INAP'
'\tINARBORAS'
'\x06INCESS'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\rING HAND SIGN'
'\x0eING HANDS SIGN'
'\tING HEART'
'\tING LANES'
'\x07ING OF '
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\nING SYMBOL'
'\x06INGAAT'
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x06INKING'
'\x07INNABAR'
'\x07INNING '
'\nINOCULAR O'
'\x03INS'
'\x06INSHIP'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x04INU '
'\x08INVERTED'
'\tINVERTED '
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INYA'
'\x03ION'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x0cIRAGANA HOKA'
'\nIRAL SHELL'
'\x05IRAMA'
'\x05IRCLE'
'\x06IRCLES'
'\x05IRCUT'
'\x04IRED'
'\x03IRL'
'\x04IRON'
'\x0cIRST SUBUNIT'
'\x04IRTY'
'\x02IS'
'\x08IS BELOW'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x15ITALIC SMALL DOTLESS '
'\x04ITAR'
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\tITRA SIGN'
'\x04ITSA'
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE SLOW SIGN'
'\x0cIVISION SIGN'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\nIXTHS DISH'
'\x14IXTY ON BLACK SQUARE'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x02JE'
'\x0bJECT SYMBOL'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x03JOA'
'\x06JOINED'
'\x05JOKER'
'\x04JONG'
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x08K SYMBOL'
'\x07K WITH '
'\x1cK WITH LEFTWARDS ARROW ABOVE'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x06KASKAL'
'\x05KASRA'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x06KAVYKA'
'\x06KAYAH '
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x10KETBALL AND HOOP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x07KHAMTI '
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x02KI'
'\x04KICK'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING FACE'
'\x04KINI'
'\x0fKISIM5 TIMES BI'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x02KO'
'\x03KO '
'\x04KOET'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKTIESELSKAB'
'\x02KU'
'\x03KUE'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x04LAAN'
'\x05LABAT'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x03LAI'
'\x03LAL'
'\x03LAM'
'\x0cLAM WITH BAR'
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\nLANE MERGE'
'\tLARGEMENT'
'\x03LAS'
'\x14LASHING SWEAT SYMBOL'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARD '
'\x0cLAYING CARDS'
'\x0bLCE TSA CAN'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\tLD TAMIL '
'\x04LDE '
'\x0eLDREN CROSSING'
'\x02LE'
'\x03LE '
'\tLE FOLDER'
'\x07LE LEAF'
'\nLE LETTER '
'\x13LEADING MCHAN RTAGS'
'\x0bLEAF CLOVER'
'\x05LEASE'
'\x04LED '
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\tLEFT HALF'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\tLEFT HOOK'
'\nLEFT-HAND '
'\x12LEFT-STEM TONE BAR'
'\x0fLEFTWARDS ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\nLEK ATTAK '
'\x06LENDAR'
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x05LENIS'
'\x04LEPH'
'\x08LESS SHA'
'\x08LESSER Y'
'\x04LETH'
'\x06LETTER'
'\x07LETTER '
'\tLETTER KH'
'\x0bLETTER LLLA'
'\nLETTER SHA'
'\x15LETTER SMALL CAPITAL '
'\x10LETTER VOCALIC L'
'\x07LETTERS'
'\x05LEVEN'
'\x02LF'
'\x07LF FACE'
'\x03LFA'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0bLIEVED FACE'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\nLIGHT BULB'
'\nLIMITATION'
'\x04LINE'
'\x0eLINE EXTENSION'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x0cLIVERY TRUCK'
'\x07LKY WAY'
'\x02LL'
'\x08LL MOON '
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\x0cLLER COASTER'
'\x07LLEYBUS'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x07LLOWING'
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOBE '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG OVER '
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOON'
'\x04LOOP'
'\x03LOS'
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'\x16LOW PARAPHRASE BRACKET'
'\x08LOW TONE'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x02LT'
'\x0bLTERNATE YA'
'\x14LTIPLE MUSICAL NOTES'
'\x08LTRY LEG'
'\x02LU'
'\x0bLU PLUS IGI'
'\x03LUB'
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x08LWAY CAR'
'\x02LX'
'\x02LY'
'\x04LY H'
'\x07LY LOOP'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x0bM TIMES SHE'
'\x02M0'
'\x02MA'
'\x05MAAEH'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x05MALL '
'\x06MALL A'
'#MALL ARABIC LETTER TAH AND TWO DOTS'
'\x08MALL AXE'
'\x0cMALL LETTER '
'\x15MALL Q WITH HOOK TAIL'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\x0eMARK LOWER DOT'
'\x10MARK NOON GHUNNA'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAY'
'\x02MB'
'\x03MBA'
'\x0cMBELLISHMENT'
'\x08MBINING '
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x05MBOL '
'\x07MBOL B0'
'\x19MBOL FOR SAMARITAN SOURCE'
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\nME PLUS DA'
'\nME PLUS EN'
'\x11ME PLUS GAN2 TENU'
'\x08MEASURE '
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x07MEDIUM '
'\x0eMEEM WITH DOT '
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x04MERA'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x03MID'
'\x0bMIDDLE HOOK'
'\x0cMIDDLE TILDE'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIN'
'\x04MIL '
'\x0bMILING EYES'
'\nMILLE SIGN'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\nMINO TILE '
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\x05MISRA'
'\x03MIT'
'\x03MKA'
'\x03MMA'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'$MODIFIER LETTER KHAMTI REDUPLICATION'
'"MODIFIER LETTER LABIALIZATION MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\x02MP'
'\x03MPL'
'\x05MROCK'
'\x05MSHAE'
'\x02MU'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x07N WITH '
'\x12N WITH MIDDLE HOOK'
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x08NA METEK'
'\x05NA PO'
'\x04NAAU'
'\x06NACLES'
'\x03NAH'
'\nNAKE BELOW'
'\x03NAR'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x13NAXIAN FIVE HUNDRED'
'\x03ND '
'\x0bND TWO DOTS'
'\x08NDA FACE'
'\nNDA PA NJI'
'\x04NDA2'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\tNDRABINDU'
'\x02NE'
'\x03NE '
'\x0cNE HALF SIGN'
'\x06NE OF '
'\x04NED '
'\x05NEGAR'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x04NEMA'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x0bNEUTRAL YER'
'\x03NEY'
'\x02NG'
'\x03NG '
'\x11NG STROKE OVERLAY'
'\x03NGA'
'\x04NGA2'
'\x03NGE'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x02NI'
'\x08NI ABOVE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\x05NING '
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x04NJAM'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x06NNADA '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\nNOON WITH '
'\x04NOSE'
'\x05NOTCH'
'\x04NOTE'
'\nNOTE WITH '
'\x06NOWMAN'
'\tNS SYMBOL'
'\x06NSANAQ'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x05NTAIN'
'\tNTESSENCE'
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x02NU'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x05NZEUM'
'\x01O'
'\x02O '
'\tO HUNDRED'
'\tO LETTER '
'\x07O WITH '
'\x02O-'
'\x03O-I'
'\x02O0'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAT'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x07OCALIC '
'\tOCCLUSION'
'\x06OCENCE'
'\x08OCK SALT'
'\x0bOCOLATE BAR'
'\x08OCUS OF '
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\tOENICIAN '
'\x0bOF MASHFAAT'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x04OFUM'
'\x07OGICAL '
'\x0fOGOGRAM KHAMTI '
'\x0cOGONEK ABOVE'
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x02OK'
'\x05OKARA'
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x06OLCANO'
'\x03OLD'
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x0bOLDING BACK'
'\x04OLIN'
'\nOLLAR SIGN'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\tOMBINING '
'\x04OMBU'
'\x07OMERANG'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x13ON VIEWING CEREMONY'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x14ONE HUNDRED THOUSAND'
'\tONE MARK-'
'\x0eONE SOUND WAVE'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x03ONG'
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\x05ONG S'
'\x0bONG S WITH '
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x0cONISHED FACE'
'\x10ONJOINING MACRON'
'\tONSONANT '
'\x04ONTH'
'\x07ONTIEEN'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x05OPARD'
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x07OPWATCH'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x04ORNS'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x06OSETTE'
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\x0fOTA WITH STROKE'
'\x07OTATED '
'\x08OTIFIED '
'\nOTING STAR'
'\x08OTLESS J'
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x08OTPRINTS'
'\x0cOTTOM HALF O'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x11OUBLE MONOCULAR O'
'\x04OUBT'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x13OUR DOT PUNCTUATION'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\tOURA SIGN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x07OUT HUB'
'\tOUT MOUTH'
'\tOUTH WIND'
'\nOUTHERN TA'
'\x0cOUTING WHALE'
'\x15OVAL WITH OVAL INSIDE'
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'\tOVER LONG'
'\tOVER MUSH'
'\x08OVER NUN'
'\x08OVER SAG'
'\tOVER SHE '
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x02OW'
'\x03OW '
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x0bOWING HEART'
'\x1bOWN POINTING BACKHAND INDEX'
'\x1cOWN-POINTING DOUBLE TRIANGLE'
'\x07OX BACK'
'\x02OY'
'\x03OZE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\x11P ON BLACK SQUARE'
'\x07P PIEET'
'\nP STREAMER'
'\x07P WITH '
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x0cPAP PLUS PAP'
'\x05PARAQ'
'\x0bPARENTHESIS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x11PE WITH DESCENDER'
'\x0bPEDESTRIANS'
'\x04PEEP'
'\x04PEN '
'\x05PEN E'
'\x18PEN MOUTH AND COLD SWEAT'
'\x05PEN O'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x04PER '
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x18PERSET PRECEDING SOLIDUS'
'\x08PERSIAN '
'\x03PES'
'\x04PEUX'
'\x03PHA'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x0ePHONE RECEIVER'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x06PICKET'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x05PIRIT'
'\x10PLACEHOLDER MARK'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x04PLUG'
'\x04PLUM'
'\nPLUS ERIN2'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\nPOLICE CAR'
'\x0ePOMOFO LETTER '
'\x05PONSE'
'\x03POQ'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\tPPOINTED '
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x05PRING'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x06PSTICK'
'\x05PTIC '
'\x05PTIVE'
'\x02PU'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x08PUSHPIKA'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x01Q'
'\x07Q WITH '
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x0fQUADRUPLE ARROW'
' QUALS SIGN ABOVE LEFTWARDS ARROW'
'\x05QUARE'
'\x0cQUARE BUTTON'
'\x06QUARED'
'\x07QUARTER'
'\x0bQUARTER ASH'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\tQUEEN OF '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\x06R FACE'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x0bR WITH TAIL'
'\x0eR-OFF CALENDAR'
'\x02R0'
'\x02R2'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x07RAISED '
'\nRAISED DOT'
'\x0bRAISED FLAG'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x08RAL FACE'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x0cRANCHING OUT'
'\rRANGE DIAMOND'
'\x07RANGKEP'
'\x07RARIETY'
'\x05RASHA'
'\x05RATER'
'\x05RATHA'
'\x13RATUM SUPER STRATUM'
'\x08RAUGHTS '
'\x03RAY'
'\x02RB'
'\x02RC'
'\x08RCHAIC E'
'\x05RCHID'
'\x17RD SEPARATOR MIDDLE DOT'
'\x12RDEL NAG RDEL DKAR'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\x0bREAKTHROUGH'
'\x04REAT'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x08RECT HIT'
'\nRED CIRCLE'
'\nRED DRAGON'
'\x08RED FACE'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x04REE '
'\x0bREE HUNDRED'
'\x05REEK '
'\x05REGIA'
'\tREH WITH '
'\x05RELAA'
'\x06REMEDY'
'\x06RENGTH'
'\x04REPA'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x08REVERSE '
'\tREVERSED '
'\x0fREVERSED OPEN E'
'\x04RFER'
'\x02RG'
'\x04RGE '
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x0cRIAL TRAMWAY'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x03RIG'
'\x05RIGHT'
'\x06RIGHT '
'\nRIGHT HALF'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x0fRIGHT RERENGGAN'
'\x0bRIGHT-HAND '
'\x0fRIGHT-POINTING '
'\x14RIGHT-POINTING ANGLE'
'+RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x10RIGHTWARDS ARROW'
'%RIGVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x03RII'
'\x06RIKRIK'
'\x07RILLIC '
'\x04RIN2'
'\x04RING'
'\nRING ABOVE'
'\nRING BELOW'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\rRIPLE SVARITA'
'\x06RIPT G'
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\x02RK'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x0cRMUKHI SIGN '
'\x05RNED '
'\nRNING SIGN'
'\x02RO'
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x04ROLL'
'\x03ROM'
'\x03RON'
'\x1bRONOMICAL SYMBOL FOR URANUS'
'\x04ROSH'
'\rROSSING LANES'
'\x07ROTUNDA'
'\x05ROUND'
'\rRPENTRY PLANE'
'\x02RR'
'\x03RRA'
'\rRRIAGE SYMBOL'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x08RT WITH '
'\x06RTCAKE'
'\tRTER MARK'
'\x04RTH '
'\x07RTHIAN '
'\x07RTICAL '
'\x17RTOISE SHELL BRACKETED '
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\x05RULER'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x04RUNG'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x0fS IN SILHOUETTE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x02S0'
'\x02SA'
'\x04SA-I'
'\x06SAADIY'
'\x03SAG'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x08SALT OF '
'\x03SAM'
'\x06SANDAL'
'\x04SANG'
'\x05SARGA'
'\x05SASAK'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\nSEEN WITH '
'\tSEMICOLON'
'\x0eSEPARATOR MARK'
'\x06SERET '
'\x12SET OVER BUILDINGS'
'\x07SEVENTH'
'\x02SH'
'\x03SH '
'\x13SH PLUS HU PLUS ASH'
'\tSH SYMBOL'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\x04SHAD'
'\x04SHAE'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\x04SHEI'
'\x04SHES'
'\x05SHESH'
'\x07SHESHIG'
'\x05SHGAB'
'\x05SHIMA'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x0fSHORT OVER LONG'
'\x0cSHORT RIKRIK'
'\x05SHPIN'
'\x04SHU2'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x07SIGN PA'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\tSIVE FACE'
'\rSIX LATE FORM'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x05SLASH'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x0eSMALL CAPITAL '
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\x07SMALL F'
'\rSMALL LETTER '
'\rSMALL LETTERS'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\x12SMALL WHITE CIRCLE'
'\tSMALL YUS'
'\x07SMANYA '
'\x0cSMILING EYES'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x02SO'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x0eSOUTH ARABIAN '
'\x13SPACING CANDRABINDU'
'\x06SPADES'
'\x06SPAPER'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x0cSQUIQUADRATE'
'\x02SS'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x04SSOM'
'\x0eSSPORT CONTROL'
'\x02ST'
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x07STATERS'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x04STLE'
'\x05STNUT'
'\x04STOL'
'\x16STONE GRAVEYARD SYMBOL'
'\x0bSTORIC SITE'
'\x03STR'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x18STROKE THROUGH DESCENDER'
'\nSTRUCTION '
'\x03STU'
'\x15STUCK-OUT TONGUE AND '
'\x02SU'
'\x03SU '
'\x13SUBSTITUTION MARKER'
'\x04SUKU'
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x07SVARITA'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x02T0'
'\x02TA'
'\x03TAB'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\x06TAGRAM'
'\x03TAH'
'\x08TAI LUE '
'\x04TAIL'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x06TAMING'
'\tTANDSTILL'
'\x03TAR'
'\x06TAU RO'
'\x06TAUROS'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\x0cTCHING CHICK'
'\x02TE'
'\x0cTEARS OF JOY'
'\x06TEBOOK'
'\x04TED '
'\rTED HAND SIGN'
'\x06TEDUNG'
'\x03TEE'
'\x05TEGEH'
'\x0fTELLITE ANTENNA'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x07THIEUTH'
'\x08THIOPIC '
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOUSAND'
'\tTHOUSAND '
'\x06THREE '
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x03THW'
'\x02TI'
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x0bTIEE SHEUOQ'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x04TILL'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x05TKAAN'
'\x03TLE'
'\x05TMAAU'
'\x05TNESS'
'\x06TO BOX'
'\x03TOM'
'\x0bTONAL MARK '
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x15TONE MARK SGAW KAREN '
'\x05TONE-'
'\x0eTOP HALF BLACK'
'\x05TORCH'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x02TR'
'\rTRAFFIC LIGHT'
'\x0cTRAGRAM FOR '
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x15TRANSPOSITION BRACKET'
'\x14TRANSPOSITION MARKER'
'\x03TRE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\x0bTRIAN CAMEL'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x0fTRIANGULAR MARK'
'\x08TRICOLON'
'\x05TRIOL'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x1bTRIPLE DOT PUNCTUATION MARK'
'\x05TROKE'
'\x03TSA'
'\x03TSE'
'\x02TT'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x05TTER '
'\x05TTERN'
'\x05TTOCK'
'\x05TTOM '
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x03TWO'
'\x04TWO '
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
"'TWO DOTS VERTICALLY BELOW AND SMALL TAH"
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x0bTWO-HEADED '
'\x02TY'
'\x0fTYSCAPE AT DUSK'
'\x01U'
'\x02U '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x03U U'
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x02U0'
'\x02U2'
'\x02U3'
'\nU3 PLUS AN'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB2'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x10UBLE PARENTHESIS'
'\x0fUBLE RING BELOW'
'\x0cUBLE SVARITA'
'\x17UBLE VERTICAL BAR BELOW'
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x06UCIBLE'
'\x02UD'
'\x05UDAAT'
'\x06UDATTA'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x02UG'
'\x06UGGAGE'
'\x04UGU '
'\x04UHUR'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x04UMAN'
'\nUMAN EARTH'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x05UMPET'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x04UNAP'
'\x12UNATE SIGMA SYMBOL'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x0bUND PUSHPIN'
'\x08UNDERTIE'
'\x07UNDRED '
'\x14UNDRED POINTS SYMBOL'
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x03UNO'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x1aUP POINTING BACKHAND INDEX'
'\x07UP SIGN'
'\x18UP WITH EXCLAMATION MARK'
'\x1bUP-POINTING DOUBLE TRIANGLE'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URN'
'\x06URNED '
'\x08UROPEAN '
'\x03URT'
'\x03URU'
'\x02US'
'\x07US TENT'
'\x03USH'
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x02UT'
'\x0bUT AND BOLT'
'\x04UTAE'
'\x05UTEUX'
'\x04UTH '
'\x0bUTH CORNERS'
'\x05UTIES'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\x02UX'
'\x02UZ'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02V0'
'\x02VA'
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x07VAPOURS'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x08VE SASAK'
'\x04VEDE'
'\x03VEE'
'!VELOPE WITH DOWNWARDS ARROW ABOVE'
'\tVELOPMENT'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x17VERTICAL BAR WITH QUILL'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x08VESSEL B'
'\x07VESTAN '
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x02VI'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x03VIN'
'\x04VINE'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x03VOP'
'\x0cVORCE SYMBOL'
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x11VOWEL LENGTH MARK'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x04VUEQ'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\x13W BRIGHTNESS SYMBOL'
'\nW OR MODEL'
'\x08W PRINTS'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\x03WAN'
'\x06WARDS '
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'&WAW WITH EXTENDED ARABIC-INDIC DIGIT T'
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x05WEST '
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x05WFISH'
'\x02WG'
'\x0bWHITE ARROW'
'\x0cWHITE CIRCLE'
'\x1cWHITE DOWN-POINTING TRIANGLE'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\x05WIANG'
'\x07WIGNYAN'
'\x05WINDU'
'\tWING STAR'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\tWITH CURL'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\x0cWITH STROKE '
'\tWITH TIP '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x05WLING'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'\x07WO FOR '
'\x06WO OF '
'\nWO SHORTS '
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\tWRY SMILE'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x07X BELOW'
'\tX MACHINE'
'\x1eX POINTED STAR WITH MIDDLE DOT'
'\x13X WITH PALATAL HOOK'
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x02XG'
'\tXHAUSTION'
'\x02XI'
'\x05XING '
'\x07XOPHONE'
'\x02XT'
'\x05XTILE'
'\x05XTRA-'
'\x15XTRATERRESTRIAL ALIEN'
'\x03XWG'
'\x01Y'
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\x0eY SMALL SQUARE'
'\x07Y WITH '
'\x03Y00'
'\x02YA'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x04YANG'
'\x07YANMAR '
'\x03YAT'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'-YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x03YIN'
'\x06YIN-DO'
'\x10YIR MKPARAQ MEUN'
'\x05YIZET'
'\x08YLLABLE '
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\x1bYMBOL MULTIPLE MEASURE REST'
'\x02YN'
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x04YODH'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x02YP'
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x08YRILLIC '
'\nYRILLIC EN'
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'3YZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x01Z'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAI'
'\x04ZAIN'
'\x0eZAKAYA LANTERN'
'\tZAL SASAK'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\tZIR SASAK'
'\x03ZOA'
'\x03ZOO'
'\x08ZWARAKAY'
'\x02ZY'
'\x04ZZY '
)
_charnodes =[67986,
 -58736,
 -1,
 132311,
 32318,
 -1,
 197838,
 87379,
 -1,
 263229,
 160181,
 -1,
 327835,
 209592,
 -1,
 393314,
 265777,
 73909,
 458832,
 330659,
 73911,
 589823,
 393216,
 -1,
 589903,
 490140,
 -1,
 655378,
 527921,
 -1,
 720910,
 591014,
 -1,
 -65524,
 671177,
 73914,
 -65523,
 734797,
 73913,
 -1,
 795049,
 73912,
 983056,
 684123,
 73917,
 -1,
 920540,
 73918,
 -65519,
 939004,
 73916,
 -1,
 1054503,
 73915,
 1245211,
 618246,
 -1,
 1310743,
 1193527,
 -1,
 1376278,
 1255115,
 73957,
 -1,
 1312137,
 73958,
 -1,
 1326266,
 73959,
 1572890,
 1248817,
 -1,
 -65511,
 1533855,
 73956,
 -1,
 1591149,
 73955,
 -1,
 1540219,
 73960,
 1835043,
 1192632,
 -1,
 1900576,
 1784717,
 73933,
 1966111,
 1838242,
 73934,
 -1,
 1901741,
 73935,
 -1,
 1927151,
 73936,
 2228223,
 1838641,
 -1,
 -65502,
 2123679,
 73932,
 -1,
 2184266,
 73931,
 2359338,
 1787050,
 -1,
 2424870,
 2309306,
 73946,
 -1,
 2360583,
 73947,
 2555945,
 2362929,
 -1,
 -65496,
 2519695,
 73945,
 -1,
 2573482,
 73944,
 -1,
 2522788,
 73948,
 2818097,
 2307639,
 -1,
 2883631,
 2756145,
 -1,
 2949166,
 2836333,
 73938,
 -1,
 2884862,
 73939,
 -1,
 2884890,
 73937,
 -65488,
 2850545,
 73941,
 -1,
 3095456,
 73940,
 3276854,
 2762443,
 -1,
 3342388,
 3232764,
 73929,
 -1,
 3278572,
 73930,
 3538943,
 3295085,
 73927,
 -1,
 3409150,
 73928,
 3604539,
 3219782,
 -1,
 3670073,
 3554189,
 73924,
 -1,
 3624550,
 73925,
 -65478,
 3636974,
 73926,
 -1,
 3739185,
 73923,
 3932225,
 3544846,
 -1,
 3997758,
 3900064,
 73921,
 -1,
 3933520,
 73922,
 4194303,
 3935793,
 -1,
 -65472,
 4089796,
 73920,
 -1,
 4137286,
 73919,
 4325444,
 3898942,
 73962,
 4456447,
 4268358,
 73963,
 -1,
 4326600,
 73964,
 4522054,
 4282289,
 73952,
 -1,
 4457536,
 73953,
 4653129,
 4476451,
 -1,
 -65464,
 4602765,
 73951,
 -1,
 4663117,
 73950,
 4849740,
 4602765,
 -1,
 -65461,
 4812898,
 73943,
 -1,
 4863197,
 73942,
 -65459,
 4814741,
 73961,
 -65458,
 5005796,
 73954,
 -1,
 5064603,
 73949,
 -1,
 548879,
 73965,
 5308502,
 414716,
 73974,
 5439487,
 5245859,
 73975,
 5505023,
 5308416,
 -1,
 -65452,
 5404838,
 73976,
 -65451,
 5464088,
 73977,
 -1,
 5513265,
 73978,
 5701721,
 5261165,
 73970,
 -65448,
 5640758,
 73972,
 -1,
 5702073,
 73971,
 5898331,
 5662623,
 73979,
 -1,
 5835834,
 73980,
 6029405,
 5841222,
 73968,
 -1,
 5964688,
 73969,
 6160479,
 5969731,
 73966,
 -1,
 6095147,
 73967,
 -65440,
 6123705,
 73981,
 -65439,
 6245923,
 73973,
 -1,
 6291944,
 73910,
 6488193,
 342925,
 73984,
 6553709,
 6449055,
 -1,
 6619243,
 6491194,
 73994,
 6750207,
 6555296,
 -1,
 -65433,
 6644196,
 73999,
 -65432,
 6704588,
 73998,
 -65431,
 6766025,
 73997,
 -65430,
 6828873,
 73996,
 -1,
 6884959,
 73995,
 7143423,
 6556579,
 73992,
 -1,
 7012840,
 73993,
 7209079,
 6516486,
 -1,
 7274614,
 7157303,
 74001,
 7405567,
 7208960,
 -1,
 7405685,
 7304959,
 -1,
 7471220,
 7356026,
 -1,
 -65421,
 7436181,
 74004,
 -1,
 7477062,
 74003,
 -1,
 7416619,
 74005,
 -1,
 7348312,
 74002,
 -1,
 7213399,
 74000,
 7864443,
 7146658,
 73988,
 7995391,
 7798784,
 -1,
 -65414,
 7888930,
 73989,
 -1,
 7938123,
 73990,
 8126592,
 7798784,
 -1,
 8192127,
 8092316,
 -1,
 -65410,
 8158782,
 73986,
 -1,
 8201931,
 73985,
 -1,
 8134719,
 73987,
 -1,
 8069978,
 73991,
 8519833,
 6454846,
 74006,
 8585354,
 8457123,
 74008,
 8716287,
 8519680,
 -1,
 8716425,
 8616604,
 -1,
 8781959,
 8668492,
 74009,
 -1,
 8718077,
 74010,
 -65400,
 8744817,
 74012,
 -1,
 8869809,
 74011,
 -1,
 8664588,
 74013,
 9109647,
 8546207,
 74021,
 9175182,
 9076286,
 -1,
 -65395,
 9138267,
 74024,
 -1,
 9196540,
 74023,
 -1,
 9112967,
 74022,
 9437333,
 9052486,
 74014,
 9568255,
 9371648,
 -1,
 9568404,
 9468572,
 -1,
 -65389,
 9520956,
 74016,
 -1,
 9571946,
 74015,
 -1,
 9527339,
 74017,
 9830551,
 9391651,
 74019,
 -1,
 9766705,
 74020,
 -65384,
 9783149,
 74018,
 -1,
 9896250,
 74007,
 10158079,
 8465544,
 73982,
 -1,
 10028827,
 73983,
 10223908,
 280429,
 -1,
 10289392,
 10161713,
 74167,
 10354922,
 10236650,
 -1,
 10420452,
 10295054,
 74168,
 10551295,
 10354688,
 -1,
 10551523,
 10451612,
 -1,
 10617001,
 10489393,
 74169,
 10682534,
 10552486,
 -1,
 -65372,
 10635295,
 74172,
 -65371,
 10695536,
 74171,
 -1,
 10756521,
 74170,
 -65369,
 10645641,
 74175,
 -65368,
 10900476,
 74174,
 -1,
 10962797,
 74173,
 11141296,
 10583614,
 74213,
 11206829,
 11076774,
 -1,
 -65364,
 11173450,
 74215,
 -1,
 11210289,
 74214,
 -65362,
 11169883,
 74218,
 -65361,
 11346246,
 74217,
 -1,
 11406289,
 74216,
 11600057,
 11104006,
 -1,
 11665592,
 11548215,
 -1,
 11731124,
 11632286,
 74207,
 -1,
 11666804,
 74208,
 11862199,
 11682485,
 -1,
 -65354,
 11827366,
 74206,
 -1,
 11887718,
 74205,
 -1,
 11806551,
 74204,
 -1,
 11632763,
 74209,
 12189888,
 11551914,
 -1,
 12255422,
 12156478,
 -1,
 12320957,
 12207981,
 74194,
 -1,
 12256484,
 74195,
 -1,
 12258362,
 74193,
 12582911,
 12204941,
 74191,
 -1,
 12473340,
 74192,
 12648645,
 12142445,
 -1,
 12714179,
 12615230,
 74198,
 -1,
 12666733,
 74199,
 -65340,
 12665405,
 74197,
 -1,
 12783747,
 74196,
 12976331,
 12598157,
 -1,
 13041866,
 12930595,
 74188,
 13172735,
 12977318,
 -1,
 -65335,
 13061577,
 74190,
 -1,
 13121101,
 74189,
 -1,
 12989661,
 74187,
 13369552,
 12923576,
 -1,
 13435086,
 13336516,
 74182,
 -1,
 13370586,
 74183,
 13631487,
 13372977,
 74180,
 -1,
 13526943,
 74181,
 13697237,
 13334271,
 -1,
 13762772,
 13635121,
 -1,
 -65325,
 13714693,
 74211,
 -1,
 13775544,
 74210,
 -1,
 13707060,
 74212,
 14024921,
 13651491,
 -1,
 14090456,
 13969099,
 74200,
 -1,
 14025937,
 74201,
 -1,
 14058278,
 74202,
 14287069,
 13973047,
 -1,
 14352604,
 14224945,
 74184,
 -1,
 14305133,
 74185,
 -1,
 14302148,
 74186,
 14549216,
 14227214,
 -1,
 -65313,
 14498701,
 74177,
 -1,
 14552983,
 74176,
 -65311,
 14505221,
 74203,
 -65310,
 14690867,
 74179,
 -1,
 14754292,
 74178,
 -1,
 10515621,
 74219,
 15073279,
 10381215,
 74220,
 15138815,
 14942208,
 -1,
 15139048,
 15039159,
 74221,
 -1,
 15074687,
 74222,
 15335423,
 15087116,
 74223,
 -1,
 15205384,
 74224,
 15401197,
 10309155,
 74228,
 15532031,
 15337243,
 74229,
 -1,
 15402329,
 74230,
 15597807,
 15353709,
 74226,
 -1,
 15533862,
 74227,
 -1,
 15547189,
 74225,
 15794464,
 10255934,
 74235,
 15859987,
 15731619,
 74237,
 15990783,
 15794176,
 -1,
 15991054,
 15890175,
 -1,
 16056589,
 15941242,
 -1,
 16122107,
 16008362,
 -1,
 16187642,
 16060311,
 -1,
 16253177,
 16124986,
 74246,
 -1,
 16188597,
 74247,
 -1,
 16190371,
 74245,
 -1,
 16137101,
 74248,
 16515326,
 16085400,
 -1,
 -65283,
 16467194,
 74255,
 -1,
 16516277,
 74254,
 16711937,
 16471036,
 -1,
 -65280,
 16678462,
 74253,
 -1,
 16721611,
 74252,
 16908548,
 16664475,
 -1,
 -65277,
 16855806,
 74250,
 -1,
 16909493,
 74249,
 17105158,
 16854141,
 74240,
 -1,
 17041021,
 74241,
 -65273,
 17071360,
 74256,
 -65272,
 17191113,
 74251,
 -65271,
 17251914,
 74244,
 -65270,
 17315888,
 74243,
 -65269,
 17380169,
 74242,
 -65268,
 17438534,
 74239,
 -1,
 17502551,
 74238,
 -1,
 16001835,
 74257,
 17760529,
 15953670,
 -1,
 -65264,
 17721084,
 74260,
 -1,
 17774563,
 74261,
 -65262,
 17718519,
 74259,
 -1,
 17899647,
 74258,
 18088217,
 15807268,
 74263,
 18219007,
 18022400,
 -1,
 18219288,
 18110506,
 -1,
 -65257,
 18187500,
 74264,
 -1,
 18244966,
 74265,
 -1,
 18182433,
 74266,
 18481436,
 18042403,
 74269,
 18612223,
 18416669,
 74270,
 -1,
 18481620,
 74271,
 -65251,
 18433901,
 74268,
 -65250,
 18626103,
 74267,
 -65249,
 18680890,
 74262,
 -1,
 18745026,
 74236,
 19005439,
 15743885,
 74231,
 -65246,
 18903131,
 74234,
 -65245,
 18961016,
 74233,
 -1,
 19023725,
 74232,
 19202457,
 10175658,
 -1,
 19267967,
 19140145,
 74071,
 19333481,
 19203744,
 -1,
 19398964,
 19280568,
 -1,
 19464493,
 19336753,
 74082,
 19530027,
 19425183,
 74085,
 -1,
 19465570,
 74086,
 -65236,
 19485770,
 74084,
 -1,
 19613549,
 74083,
 19792178,
 19413901,
 74087,
 19857713,
 19755102,
 -1,
 -65232,
 19817596,
 74089,
 -1,
 19865688,
 74090,
 -1,
 19818476,
 74088,
 20185087,
 19758654,
 74091,
 -1,
 20080634,
 74092,
 20250942,
 19361542,
 -1,
 20316474,
 20198967,
 -1,
 -65225,
 20282942,
 74115,
 -65224,
 20331706,
 74114,
 -65223,
 20391627,
 74113,
 -1,
 20450865,
 74112,
 20644156,
 20254257,
 74110,
 -1,
 20604831,
 74111,
 -65219,
 20611095,
 74117,
 -1,
 20725091,
 74116,
 20906310,
 20205091,
 -1,
 20971844,
 20850379,
 74100,
 21102591,
 20907174,
 -1,
 -65214,
 21002275,
 74103,
 -65213,
 21050586,
 74102,
 -1,
 21112409,
 74101,
 21364735,
 20921229,
 74104,
 -1,
 21235012,
 74105,
 21430603,
 20872766,
 74119,
 -65208,
 21393499,
 74123,
 -65207,
 21451650,
 74122,
 -65206,
 21504326,
 74121,
 -1,
 21564323,
 74120,
 21758289,
 21370638,
 -1,
 21823824,
 21696049,
 -1,
 -65202,
 21784479,
 74078,
 -65201,
 21841880,
 74077,
 -1,
 21897542,
 74076,
 -1,
 21773197,
 74079,
 22151509,
 21696049,
 74072,
 22217044,
 22094150,
 74073,
 -1,
 22152436,
 74074,
 -1,
 22179990,
 74075,
 22413657,
 22103210,
 -1,
 22479192,
 22363021,
 74096,
 -1,
 22421830,
 74097,
 -1,
 22417732,
 74095,
 22675804,
 22369276,
 -1,
 -65189,
 22642884,
 74107,
 -1,
 22685387,
 74106,
 22872415,
 22628205,
 -1,
 -65186,
 22838846,
 74099,
 -1,
 22887309,
 74098,
 23069026,
 22821773,
 -1,
 -65183,
 23023139,
 74094,
 -1,
 23082202,
 74093,
 23265637,
 23013067,
 -1,
 -65180,
 23228566,
 74081,
 -1,
 23293079,
 74080,
 -65178,
 23236281,
 74124,
 -65177,
 23427062,
 74118,
 -65176,
 23490185,
 74109,
 -1,
 23552969,
 74108,
 23724399,
 19276102,
 -1,
 23789932,
 23661792,
 74131,
 -1,
 23725040,
 74132,
 -65171,
 23727266,
 74130,
 -65170,
 23858234,
 74129,
 -1,
 23923619,
 74128,
 24117619,
 23687823,
 74140,
 24248319,
 24051712,
 -1,
 -65166,
 24141917,
 74142,
 -1,
 24201186,
 74141,
 24379767,
 24069997,
 74135,
 24510463,
 24313856,
 -1,
 -65162,
 24410787,
 74136,
 -1,
 24453234,
 74137,
 24641914,
 24333859,
 -1,
 -65159,
 24579234,
 74139,
 -1,
 24644515,
 74138,
 24838524,
 24593578,
 74133,
 -1,
 24774397,
 74134,
 24969598,
 24775587,
 74125,
 -1,
 24904007,
 74126,
 -1,
 24909582,
 74127,
 25166219,
 19234366,
 74154,
 25231746,
 25126815,
 74163,
 -1,
 25166695,
 74164,
 25362820,
 25184109,
 74160,
 -1,
 25297384,
 74161,
 25493894,
 25300130,
 74157,
 -1,
 25429848,
 74158,
 -65145,
 25457038,
 74165,
 -65144,
 25580540,
 74162,
 -65143,
 25628039,
 74159,
 -65142,
 25693242,
 74156,
 -1,
 25756583,
 74155,
 25952663,
 25115533,
 74144,
 26018193,
 25915142,
 -1,
 26083727,
 25968205,
 74152,
 -1,
 26018811,
 74153,
 -65136,
 26031671,
 74151,
 -1,
 26153303,
 74150,
 26345877,
 25953952,
 -1,
 26411412,
 26312254,
 74146,
 -1,
 26353990,
 74147,
 -1,
 26351430,
 74145,
 -65130,
 26301436,
 74149,
 -1,
 26550598,
 74148,
 -65128,
 25922290,
 74166,
 -1,
 26684541,
 74143,
 26870272,
 19164934,
 -1,
 26935761,
 26818103,
 -1,
 27001268,
 26885005,
 -1,
 27066794,
 26955299,
 74438,
 27197439,
 27002528,
 -1,
 27197856,
 27082185,
 74444,
 -1,
 27132392,
 74445,
 27328931,
 27137806,
 -1,
 -65118,
 27295862,
 74441,
 -1,
 27332951,
 74440,
 -65116,
 27291501,
 74449,
 -65115,
 27480929,
 74448,
 -65114,
 27545056,
 74447,
 -65113,
 27608896,
 74446,
 -65112,
 27669360,
 74443,
 -65111,
 27730787,
 74442,
 -1,
 27790897,
 74439,
 27984302,
 27027359,
 74451,
 28114943,
 27918336,
 -1,
 -65107,
 28014758,
 74452,
 -1,
 28074170,
 74453,
 28246450,
 27926854,
 74435,
 28377087,
 28182176,
 -1,
 -65103,
 28261962,
 74437,
 -1,
 28315185,
 74436,
 -65101,
 28211025,
 74454,
 -1,
 28464619,
 74450,
 28639682,
 26938929,
 74413,
 28705215,
 28576826,
 74414,
 28835839,
 28640928,
 -1,
 28836281,
 28737086,
 74421,
 -1,
 28771501,
 74422,
 -65094,
 28802358,
 74420,
 -65093,
 28930446,
 74419,
 -65092,
 28988677,
 74418,
 -65091,
 29046056,
 74417,
 -65090,
 29103942,
 74416,
 -1,
 29167153,
 74415,
 -65088,
 28665836,
 74425,
 -65087,
 29300540,
 74424,
 -1,
 29363533,
 74423,
 29557197,
 28583627,
 74426,
 29622726,
 29519963,
 74432,
 -65083,
 29575203,
 74434,
 -1,
 29625251,
 74433,
 29819339,
 29556736,
 -1,
 29884874,
 29778096,
 -1,
 -65079,
 29849432,
 74429,
 -1,
 29897478,
 74428,
 -1,
 29834042,
 74427,
 -65076,
 29774844,
 74431,
 -1,
 30094055,
 74430,
 30343167,
 29523518,
 74455,
 -65073,
 30218839,
 74458,
 -65072,
 30280611,
 74457,
 -1,
 30344157,
 74456,
 30540272,
 26873393,
 74387,
 30605804,
 30487224,
 74389,
 30736383,
 30539776,
 -1,
 30736873,
 30636700,
 -1,
 30802395,
 30703166,
 -1,
 -65065,
 30765147,
 74406,
 -65064,
 30828447,
 74405,
 -65063,
 30887459,
 74404,
 -65062,
 30938894,
 74403,
 -1,
 31001507,
 74402,
 31195614,
 30764806,
 -1,
 -65059,
 31143997,
 74400,
 -1,
 31199575,
 74399,
 31392225,
 31147178,
 -1,
 -65056,
 31359648,
 74395,
 -1,
 31396164,
 74394,
 31588835,
 31336025,
 74391,
 -1,
 31528718,
 74392,
 -65052,
 31553364,
 74401,
 -65051,
 31676337,
 74398,
 -65050,
 31740338,
 74397,
 -65049,
 31804900,
 74396,
 -65048,
 31864397,
 74393,
 -1,
 31919665,
 74390,
 -65046,
 30695591,
 74407,
 -65045,
 32069571,
 74388,
 -1,
 32126476,
 74408,
 32309742,
 30558061,
 74409,
 -1,
 32244333,
 74410,
 -65041,
 32270239,
 74412,
 -1,
 32396726,
 74411,
 32571897,
 30506558,
 74466,
 32637427,
 32532383,
 74473,
 -1,
 32574970,
 74474,
 32768501,
 32591395,
 74471,
 -1,
 32707905,
 74472,
 32899575,
 32710982,
 74468,
 -1,
 32836515,
 74469,
 -65032,
 32848745,
 74470,
 -1,
 32965748,
 74467,
 33226751,
 32521101,
 74459,
 33227261,
 33108664,
 74461,
 33357823,
 33164450,
 74462,
 -1,
 33227876,
 74463,
 -65026,
 33179559,
 74465,
 -65025,
 33375479,
 74464,
 -1,
 33423848,
 74460,
 33620580,
 26836542,
 74507,
 33686068,
 33580959,
 74536,
 33751585,
 33652286,
 74551,
 33817119,
 33687200,
 -1,
 33882634,
 33764024,
 -1,
 33948169,
 33820209,
 74556,
 -65017,
 33908639,
 74559,
 -65016,
 33969226,
 74558,
 -1,
 34031469,
 74557,
 -1,
 33914430,
 74560,
 34275854,
 33848894,
 -1,
 -65012,
 34238097,
 74574,
 -65011,
 34283846,
 74573,
 -1,
 34342106,
 74572,
 34538002,
 34225037,
 -1,
 -65008,
 34500699,
 74564,
 -65007,
 34557475,
 74563,
 -1,
 34616538,
 74562,
 34800149,
 34500358,
 -1,
 -65004,
 34749805,
 74570,
 -1,
 34813807,
 74569,
 34996759,
 34737713,
 74552,
 -1,
 34959657,
 74553,
 -65000,
 34962681,
 74571,
 -64999,
 35086820,
 74568,
 -64998,
 35148319,
 74567,
 -64997,
 35212772,
 74566,
 -64996,
 35276401,
 74565,
 -64995,
 35337805,
 74561,
 -64994,
 35399291,
 74555,
 -1,
 35460995,
 74554,
 35717119,
 33759650,
 74575,
 -1,
 35587900,
 74576,
 35783214,
 33688483,
 74539,
 35913727,
 35718816,
 -1,
 35914279,
 35815070,
 74545,
 36044799,
 35849382,
 -1,
 -64986,
 35920002,
 74547,
 -1,
 35984705,
 74546,
 36176428,
 35851825,
 -1,
 36241963,
 36111526,
 -1,
 -64982,
 36197458,
 74541,
 -1,
 36255309,
 74540,
 -1,
 36194157,
 74542,
 -64979,
 36132785,
 74544,
 -1,
 36451917,
 74543,
 36635184,
 35732365,
 74549,
 -1,
 36572218,
 74550,
 36766259,
 36569088,
 -1,
 -64974,
 36729121,
 74538,
 -1,
 36774067,
 74537,
 -1,
 36703394,
 74548,
 37028416,
 33628486,
 74515,
 37093951,
 36962304,
 -1,
 37159483,
 37059228,
 -1,
 37225017,
 37125715,
 74519,
 -1,
 37159400,
 74520,
 -64966,
 37179826,
 74518,
 -1,
 37295942,
 74517,
 37487165,
 37122337,
 74522,
 -1,
 37422786,
 74523,
 -64962,
 37439296,
 74516,
 -1,
 37565964,
 74521,
 -1,
 37060616,
 74524,
 37814859,
 36982307,
 74525,
 37880390,
 37750432,
 -1,
 -64957,
 37846590,
 74529,
 -64956,
 37908638,
 74528,
 -64955,
 37966014,
 74527,
 -1,
 38029276,
 74526,
 38208074,
 37847163,
 74531,
 38338559,
 38143648,
 -1,
 -64951,
 38232548,
 74533,
 -1,
 38290834,
 74532,
 -1,
 38148292,
 74530,
 38535764,
 37777499,
 74577,
 38601297,
 38471328,
 -1,
 38666831,
 38553397,
 74579,
 -1,
 38627231,
 74580,
 -64944,
 38631317,
 74581,
 -1,
 38735409,
 74578,
 -64942,
 38570758,
 74582,
 -64941,
 38895808,
 74584,
 -1,
 38931363,
 74583,
 39125595,
 38469632,
 -1,
 39191129,
 39084285,
 -1,
 -64937,
 39157347,
 74512,
 -64936,
 39220868,
 74511,
 -1,
 39281141,
 74510,
 -64934,
 39157374,
 74509,
 -1,
 39400952,
 74508,
 39584351,
 39095793,
 -1,
 39649886,
 39521338,
 74586,
 -1,
 39585549,
 74587,
 -1,
 39616062,
 74588,
 39846497,
 39539708,
 74534,
 -1,
 39780840,
 74535,
 -64926,
 39812391,
 74585,
 -64925,
 39917326,
 74514,
 -1,
 39979939,
 74513,
 40174259,
 33558065,
 73728,
 40239740,
 40113934,
 73738,
 40305269,
 40173568,
 -1,
 40370804,
 40270492,
 -1,
 40436331,
 40319885,
 -1,
 -64918,
 40391199,
 73745,
 -1,
 40449245,
 73744,
 40632942,
 40383210,
 -1,
 -64915,
 40588362,
 73742,
 -1,
 40650605,
 73741,
 -64913,
 40599123,
 73748,
 -64912,
 40792347,
 73747,
 -64911,
 40847324,
 73746,
 -64910,
 40908365,
 73743,
 -64909,
 40969855,
 73740,
 -1,
 41030981,
 73739,
 -1,
 40318476,
 73749,
 41353215,
 40242083,
 73750,
 41418751,
 41223840,
 -1,
 -64904,
 41318293,
 73755,
 -64903,
 41382046,
 73754,
 -64902,
 41439433,
 73753,
 -64901,
 41497417,
 73752,
 -1,
 41555803,
 73751,
 41747081,
 40191853,
 73760,
 41812615,
 41682592,
 -1,
 41878145,
 41764010,
 -1,
 -64896,
 41827213,
 73766,
 -1,
 41881498,
 73765,
 -64894,
 41845542,
 73768,
 -64893,
 42037512,
 73767,
 -64892,
 42088013,
 73764,
 -64891,
 42153256,
 73763,
 -64890,
 42214238,
 73762,
 -1,
 42275159,
 73761,
 -64888,
 41757538,
 73770,
 -1,
 42406503,
 73769,
 42599061,
 41709318,
 -1,
 42664596,
 42546743,
 73784,
 42730130,
 42598400,
 -1,
 42795664,
 42688480,
 -1,
 42861199,
 42754007,
 73788,
 -1,
 42795275,
 73789,
 -1,
 42827013,
 73787,
 -64879,
 42766012,
 73785,
 -1,
 43009322,
 73786,
 -64877,
 42676990,
 73791,
 -1,
 43125667,
 73790,
 -1,
 42602878,
 73783,
 43385502,
 42534560,
 -1,
 -64873,
 43347817,
 73736,
 -64872,
 43406276,
 73735,
 -64871,
 43468803,
 73734,
 -64870,
 43531721,
 73733,
 -64869,
 43595341,
 73732,
 -64868,
 43660105,
 73731,
 -64867,
 43718470,
 73730,
 -1,
 43781681,
 73729,
 43975334,
 43340796,
 73773,
 44040869,
 43909120,
 -1,
 44106403,
 44000369,
 -1,
 -64862,
 44070053,
 73777,
 -1,
 44129481,
 73776,
 -64860,
 44071406,
 73775,
 -1,
 44261327,
 73774,
 -1,
 44003592,
 73778,
 44499626,
 43935647,
 -1,
 44565161,
 44437399,
 73780,
 -1,
 44500763,
 73781,
 -1,
 44516646,
 73782,
 44761774,
 44450986,
 73757,
 44892159,
 44697248,
 -1,
 -64851,
 44790069,
 73759,
 -1,
 44837909,
 73758,
 45023920,
 44715961,
 73771,
 -1,
 44959537,
 73772,
 -64847,
 44983304,
 73779,
 -64846,
 45097286,
 73756,
 -1,
 45157283,
 73737,
 45351677,
 40129532,
 -1,
 45417169,
 45317694,
 74337,
 45482704,
 45372412,
 74339,
 45548229,
 45450155,
 74349,
 45678591,
 45481984,
 -1,
 45679299,
 45551311,
 -1,
 -64838,
 45645470,
 74359,
 -64837,
 45707743,
 74358,
 -64836,
 45765893,
 74357,
 -64835,
 45827995,
 74356,
 -64834,
 45892920,
 74355,
 -64833,
 45956557,
 74354,
 -64832,
 46020088,
 74353,
 -64831,
 46081655,
 74352,
 -64830,
 46143618,
 74351,
 -1,
 46208330,
 74350,
 46465023,
 45631132,
 74360,
 -1,
 46335829,
 74361,
 46596095,
 45481984,
 -1,
 46596812,
 46483470,
 -1,
 46662345,
 46559085,
 74342,
 -1,
 46597194,
 74343,
 -64822,
 46629670,
 74344,
 -64821,
 46747681,
 74341,
 -1,
 46805872,
 74340,
 46990030,
 46538906,
 74347,
 -1,
 46924415,
 74348,
 -64817,
 46954662,
 74345,
 -1,
 47079582,
 74346,
 -1,
 45419397,
 74338,
 47317740,
 45366157,
 74316,
 47383269,
 47273171,
 74322,
 47513599,
 47318688,
 -1,
 47514329,
 47411464,
 74330,
 47644671,
 47449261,
 -1,
 47645400,
 47542363,
 74332,
 -1,
 47580341,
 74333,
 -1,
 47579190,
 74331,
 47842013,
 47451697,
 -1,
 47907548,
 47804507,
 74324,
 -1,
 47842485,
 74325,
 -1,
 47862780,
 74323,
 48104160,
 47808062,
 -1,
 -64801,
 48066651,
 74335,
 -1,
 48106449,
 74334,
 48300771,
 48059388,
 -1,
 -64798,
 48267460,
 74329,
 -1,
 48309963,
 74328,
 -64796,
 48255188,
 74327,
 -1,
 48444920,
 74326,
 48628457,
 47336995,
 74319,
 48758783,
 48563938,
 -1,
 -64792,
 48654259,
 74321,
 -1,
 48714826,
 74320,
 -64790,
 48590697,
 74336,
 -64789,
 48827299,
 74318,
 -1,
 48891597,
 74317,
 49087223,
 47255089,
 74302,
 49152755,
 49033962,
 74304,
 49218290,
 49086464,
 -1,
 -64784,
 49183425,
 74306,
 -64783,
 49241348,
 74307,
 -1,
 49299689,
 74305,
 -1,
 49178527,
 74308,
 49545974,
 49106467,
 74310,
 -64779,
 49482659,
 74311,
 -1,
 49546043,
 74309,
 -1,
 49482659,
 74303,
 49872895,
 49030859,
 74312,
 49938431,
 49741824,
 -1,
 49939196,
 49838748,
 -1,
 -64773,
 49905604,
 74314,
 -1,
 49942065,
 74313,
 -1,
 49901857,
 74315,
 50201403,
 45293894,
 -1,
 50266914,
 50138673,
 73813,
 50332445,
 50213560,
 73814,
 50462719,
 50266712,
 -1,
 50463495,
 50344632,
 -1,
 50529028,
 50412429,
 73821,
 -1,
 50489324,
 73822,
 50660102,
 50466353,
 73819,
 -1,
 50595117,
 73820,
 -1,
 50626500,
 73823,
 50856716,
 50415469,
 -1,
 50922251,
 50822718,
 73829,
 -64758,
 50875939,
 73831,
 -1,
 50922808,
 73830,
 -1,
 50859569,
 73828,
 51184399,
 50822718,
 -1,
 -64754,
 51146843,
 73837,
 -1,
 51186663,
 73836,
 51381009,
 51134911,
 73825,
 -1,
 51315985,
 73826,
 51512084,
 51320590,
 -1,
 -64749,
 51461005,
 73818,
 -1,
 51515783,
 73817,
 51708695,
 51449393,
 -1,
 -64746,
 51662777,
 73816,
 -1,
 51709229,
 73815,
 -64744,
 51672981,
 73835,
 -64743,
 51868056,
 73834,
 -64742,
 51929707,
 73833,
 -64741,
 51991813,
 73832,
 -64740,
 52053324,
 73827,
 -1,
 52115021,
 73824,
 52298529,
 50292639,
 73839,
 52428799,
 52235825,
 -1,
 -64736,
 52300962,
 73841,
 -1,
 52366394,
 73840,
 -1,
 52252195,
 73838,
 52626227,
 50232894,
 73850,
 52691752,
 52581372,
 73860,
 52757287,
 52628538,
 73861,
 52887551,
 52691432,
 73862,
 -1,
 52756968,
 73863,
 -1,
 52694178,
 73864,
 53019435,
 52631310,
 73854,
 -64726,
 52956067,
 73856,
 -1,
 53020374,
 73855,
 53216047,
 52953088,
 -1,
 -64723,
 53178657,
 73853,
 -64722,
 53239795,
 73851,
 -1,
 53294604,
 73852,
 53478193,
 53162680,
 73857,
 -1,
 53444548,
 73858,
 -64718,
 53438444,
 73865,
 -1,
 53556791,
 73859,
 53805055,
 52575117,
 73842,
 53805879,
 53693987,
 73844,
 -64714,
 53742499,
 73846,
 -1,
 53806897,
 73845,
 54002489,
 53761020,
 73847,
 -1,
 53936693,
 73848,
 -64710,
 53964891,
 73849,
 -1,
 54073102,
 73843,
 54264688,
 50144971,
 73866,
 54330196,
 54234686,
 73889,
 54460415,
 54265504,
 -1,
 54461251,
 54347629,
 -1,
 54526785,
 54398513,
 73903,
 -1,
 54478703,
 73904,
 -64702,
 54492734,
 73906,
 -1,
 54606733,
 73905,
 54788935,
 54398513,
 73890,
 54854470,
 54723847,
 73891,
 -1,
 54789926,
 73892,
 -1,
 54809596,
 73893,
 55051083,
 54740138,
 -1,
 55116618,
 54990161,
 73900,
 -1,
 55051825,
 73901,
 -1,
 55082657,
 73902,
 55313230,
 55017022,
 -1,
 -64691,
 55255366,
 73908,
 -1,
 55315363,
 73907,
 55509840,
 55260749,
 73897,
 -1,
 55443944,
 73898,
 55640914,
 55453311,
 73895,
 -1,
 55575016,
 73896,
 -64685,
 55590349,
 73899,
 -1,
 55711558,
 73894,
 55903069,
 54285308,
 73879,
 56033279,
 55836672,
 -1,
 56034138,
 55933596,
 -1,
 56099673,
 55980868,
 73880,
 -1,
 56034941,
 73881,
 -1,
 56053938,
 73882,
 -64677,
 55997605,
 73885,
 -64676,
 56253663,
 73884,
 -1,
 56303653,
 73883,
 56492902,
 55839651,
 73869,
 56623103,
 56428192,
 -1,
 56623970,
 56520454,
 -1,
 -64671,
 56571759,
 73874,
 -1,
 56627543,
 73873,
 -64669,
 56589886,
 73875,
 -64668,
 56775090,
 73872,
 -64667,
 56832880,
 73871,
 -1,
 56888909,
 73870,
 57082729,
 56453023,
 -1,
 -64664,
 57032369,
 73887,
 -1,
 57092659,
 73886,
 57279340,
 57016320,
 -1,
 -64661,
 57244333,
 73867,
 -1,
 57303035,
 73868,
 -64659,
 57241750,
 73888,
 -64658,
 57427821,
 73878,
 -64657,
 57488676,
 73877,
 -1,
 57549667,
 73876,
 57738135,
 54228735,
 -1,
 57803655,
 57675313,
 74475,
 57869179,
 57750200,
 74483,
 57999359,
 57804448,
 -1,
 58000247,
 57897051,
 -1,
 -64650,
 57966142,
 74487,
 -1,
 58009291,
 74486,
 -64648,
 57966532,
 74489,
 -64647,
 58162432,
 74488,
 -64646,
 58209784,
 74485,
 -1,
 58267778,
 74484,
 58459009,
 57802752,
 -1,
 58524543,
 58423964,
 -1,
 -64642,
 58479026,
 74478,
 -1,
 58538023,
 74477,
 -64640,
 58471948,
 74479,
 -1,
 58660224,
 74476,
 58852229,
 58398478,
 74480,
 58982399,
 58785792,
 -1,
 -64636,
 58881189,
 74482,
 -1,
 58941649,
 74481,
 -64634,
 58812319,
 74491,
 -1,
 59065605,
 74490,
 59245455,
 57752461,
 74494,
 59310989,
 59205535,
 74497,
 59441151,
 59244544,
 -1,
 59442060,
 59334900,
 74499,
 -1,
 59376057,
 74500,
 -1,
 59407056,
 74498,
 -64626,
 59262829,
 74496,
 -1,
 59573885,
 74495,
 59769749,
 59211326,
 74501,
 59835282,
 59729823,
 74505,
 -1,
 59769981,
 74506,
 -64621,
 59788835,
 74504,
 -64620,
 59917482,
 74503,
 -1,
 59978465,
 74502,
 60227583,
 59713227,
 74492,
 -1,
 60097000,
 74493,
 60294075,
 57691683,
 -1,
 60359598,
 60259902,
 74284,
 60425129,
 60321883,
 74290,
 60490658,
 60358656,
 -1,
 60556191,
 60455580,
 -1,
 -64611,
 60526081,
 74293,
 -64610,
 60573500,
 74292,
 -1,
 60624433,
 74291,
 60818337,
 60514452,
 74294,
 -1,
 60753585,
 74295,
 -1,
 60760204,
 74296,
 61079551,
 60427322,
 74297,
 61145087,
 60948480,
 -1,
 61146024,
 61045404,
 -1,
 61211559,
 61083185,
 74298,
 -1,
 61146303,
 74299,
 -1,
 61153990,
 74300,
 -1,
 61093388,
 74301,
 61473707,
 60371640,
 74286,
 -1,
 61407720,
 74287,
 -64596,
 61434625,
 74289,
 -64595,
 61560559,
 74288,
 -1,
 61604919,
 74285,
 61801399,
 60296753,
 74272,
 61866929,
 61763675,
 74278,
 -1,
 61803427,
 74279,
 61998004,
 61800448,
 -1,
 -64589,
 61962960,
 74273,
 -1,
 62010892,
 74274,
 -64587,
 61958047,
 74277,
 -64586,
 62142007,
 74276,
 -1,
 62196643,
 74275,
 62391225,
 61750157,
 74282,
 -1,
 62346236,
 74283,
 62586879,
 62334667,
 74280,
 -1,
 62484230,
 74281,
 62653398,
 60242829,
 74047,
 62718915,
 62606883,
 74062,
 62784450,
 62652416,
 -1,
 -64577,
 62749392,
 74063,
 -64576,
 62813349,
 74066,
 -64575,
 62872811,
 74065,
 -1,
 62922854,
 74064,
 -1,
 62733984,
 74067,
 63177674,
 62665400,
 74053,
 63307775,
 63126413,
 74054,
 63373311,
 63176704,
 -1,
 -64569,
 63269665,
 74056,
 -64568,
 63332410,
 74057,
 -64567,
 63387148,
 74058,
 -1,
 63447856,
 74055,
 63636429,
 63129453,
 74059,
 -64564,
 63572899,
 74061,
 -1,
 63637228,
 74060,
 63833041,
 63578970,
 74050,
 63963135,
 63767505,
 -1,
 -64560,
 63861925,
 74052,
 -1,
 63904343,
 74051,
 -64558,
 63795291,
 74070,
 -64557,
 64055199,
 74069,
 -64556,
 64115708,
 74068,
 -64555,
 64165646,
 74049,
 -1,
 64225282,
 74048,
 64422896,
 62600759,
 -1,
 64488418,
 64371597,
 74029,
 64618495,
 64423584,
 -1,
 64619483,
 64492865,
 74030,
 -1,
 64555939,
 74031,
 -64548,
 64585278,
 74038,
 -64547,
 64712968,
 74037,
 -64546,
 64772017,
 74036,
 -64545,
 64833145,
 74035,
 -64544,
 64893698,
 74034,
 -64543,
 64955280,
 74033,
 -1,
 65017670,
 74032,
 65209323,
 64454206,
 74039,
 65274858,
 65148708,
 74040,
 65404927,
 65210016,
 -1,
 -64538,
 65306564,
 74045,
 -64537,
 65358761,
 74044,
 -64536,
 65422738,
 74043,
 -64535,
 65484411,
 74042,
 -1,
 65540711,
 74041,
 -1,
 65226648,
 74046,
 65863679,
 65146417,
 74025,
 65864687,
 65732608,
 -1,
 -64530,
 65829030,
 74026,
 -1,
 65877516,
 74027,
 -1,
 65816429,
 74028,
 66126859,
 64381349,
 -1,
 66192390,
 66075533,
 74367,
 66257919,
 66125824,
 -1,
 66323454,
 66222748,
 -1,
 66388982,
 66289214,
 74375,
 -1,
 66325411,
 74376,
 66520056,
 66337677,
 74373,
 -1,
 66459406,
 74374,
 66651131,
 66459406,
 -1,
 -64518,
 66616894,
 74371,
 -1,
 66665357,
 74370,
 66847741,
 66588209,
 74368,
 -1,
 66787086,
 74369,
 -1,
 66791115,
 74372,
 -1,
 66265255,
 74377,
 67174399,
 66218901,
 74378,
 67239935,
 67043328,
 -1,
 67240965,
 67140252,
 -1,
 -64509,
 67210753,
 74381,
 -64508,
 67272644,
 74380,
 -1,
 67323221,
 74379,
 -1,
 67198226,
 74382,
 67568650,
 66129457,
 74362,
 -64504,
 67527077,
 74365,
 -64503,
 67589116,
 74364,
 -1,
 67641670,
 74363,
 -1,
 67513469,
 74366,
 67896356,
 66066190,
 -1,
 67961877,
 67833393,
 73792,
 68027408,
 67913581,
 73796,
 -64497,
 67965056,
 73798,
 -1,
 68027258,
 73797,
 68224018,
 67987359,
 73799,
 -1,
 68161184,
 73800,
 -64493,
 68171554,
 73795,
 -64492,
 68301540,
 73794,
 -1,
 68362566,
 73793,
 68551711,
 67927614,
 73805,
 68617243,
 68485120,
 -1,
 68682778,
 68575210,
 -1,
 -64487,
 68649156,
 73807,
 -1,
 68685516,
 73806,
 -1,
 68624409,
 73808,
 68944925,
 68577183,
 73811,
 -1,
 68881315,
 73812,
 69140479,
 68898268,
 73809,
 -1,
 69010308,
 73810,
 69271551,
 68500365,
 73801,
 69337087,
 69142176,
 -1,
 -64478,
 69221837,
 73804,
 -64477,
 69284720,
 73803,
 -1,
 69340721,
 73802,
 69534776,
 67866097,
 -1,
 69600300,
 69483405,
 74595,
 69665832,
 69539598,
 74598,
 -1,
 69599779,
 74599,
 -64471,
 69635582,
 74601,
 -64470,
 69743288,
 74600,
 -64469,
 69798970,
 74597,
 -1,
 69862546,
 74596,
 70059057,
 69566014,
 74602,
 70124591,
 69995744,
 74603,
 -1,
 70059688,
 74604,
 -64464,
 70077987,
 74606,
 -1,
 70195799,
 74605,
 70386743,
 69996081,
 74589,
 70452277,
 70320128,
 -1,
 -64460,
 70416550,
 74590,
 -1,
 70481078,
 74591,
 -64458,
 70407136,
 74593,
 -1,
 70595256,
 74592,
 -1,
 70330296,
 74594,
 70909951,
 69494687,
 -1,
 70911035,
 70782513,
 74383,
 -1,
 70850318,
 74384,
 -64452,
 70876734,
 74386,
 -1,
 70990733,
 74385,
 71173320,
 219043,
 -1,
 71238756,
 71118673,
 -1,
 71304275,
 71196440,
 -1,
 71369797,
 71271493,
 74812,
 71435332,
 71303168,
 -1,
 -64445,
 71374606,
 74815,
 -1,
 71437873,
 74814,
 -1,
 71371938,
 74813,
 71697481,
 71309070,
 -1,
 71763016,
 71635562,
 74834,
 -1,
 71698264,
 74835,
 -1,
 71729943,
 74808,
 71959628,
 71659761,
 -1,
 -64437,
 71925310,
 74800,
 -1,
 71961507,
 74790,
 72156239,
 71906386,
 -1,
 -64434,
 72121918,
 74785,
 -1,
 72158115,
 74776,
 72352849,
 72095041,
 74754,
 -1,
 72287869,
 74828,
 -64430,
 72318526,
 74767,
 -1,
 72426384,
 74761,
 72679423,
 71254830,
 -1,
 72680537,
 72576774,
 -1,
 72746072,
 72627998,
 -1,
 -64425,
 72711742,
 74801,
 -1,
 72747939,
 74791,
 -1,
 72696710,
 74844,
 73008221,
 72619790,
 -1,
 73073756,
 72946282,
 74836,
 -1,
 73008984,
 74837,
 -1,
 73040663,
 74809,
 73270368,
 72954962,
 -1,
 -64417,
 73236030,
 74786,
 -1,
 73272227,
 74777,
 73466978,
 73209153,
 74755,
 -1,
 73401981,
 74829,
 -64413,
 73432638,
 74768,
 -1,
 73540496,
 74762,
 73729160,
 71202559,
 -1,
 73794680,
 73677457,
 -1,
 73860203,
 73756913,
 -1,
 73925737,
 73825854,
 74798,
 -1,
 73860952,
 74799,
 74121215,
 73862051,
 74788,
 -1,
 73992024,
 74789,
 74187887,
 73799438,
 -1,
 74253422,
 74154775,
 74806,
 -1,
 74188632,
 74807,
 -1,
 74191466,
 74833,
 74450034,
 74155022,
 -1,
 -64399,
 74386460,
 74811,
 -1,
 74451856,
 74810,
 74646645,
 74396754,
 -1,
 -64396,
 74612286,
 74784,
 -1,
 74648483,
 74775,
 74843255,
 74585409,
 74753,
 -1,
 74778237,
 74827,
 -1,
 74785680,
 74760,
 75104255,
 73763345,
 -1,
 75105404,
 75004315,
 -1,
 -64389,
 75072493,
 74846,
 -1,
 75113360,
 74843,
 75302015,
 75067633,
 -1,
 -64386,
 75267646,
 74797,
 -1,
 75303843,
 74787,
 75498626,
 75248722,
 -1,
 -64383,
 75464254,
 74783,
 -1,
 75500451,
 74774,
 75695237,
 75437838,
 -1,
 -64380,
 75662103,
 74805,
 -1,
 75698794,
 74832,
 75891847,
 75633985,
 74752,
 -1,
 75826813,
 74826,
 -1,
 75836546,
 74841,
 76088479,
 73690886,
 -1,
 76154004,
 76033444,
 -1,
 76219535,
 76121139,
 -1,
 76285070,
 76152832,
 -1,
 -64371,
 76224270,
 74819,
 -1,
 76287537,
 74818,
 -1,
 76221498,
 74817,
 -64368,
 76185150,
 74770,
 -64367,
 76509430,
 74793,
 -64366,
 76559447,
 74779,
 -64365,
 76620688,
 74764,
 -1,
 76682561,
 74757,
 76874908,
 76104562,
 -1,
 76940439,
 76813633,
 74756,
 -1,
 76875389,
 74830,
 -64360,
 76907516,
 74816,
 -64359,
 77037118,
 74769,
 -64358,
 77099254,
 74792,
 -64357,
 77149271,
 74778,
 -1,
 77210512,
 74763,
 77463551,
 76822311,
 -1,
 -64354,
 77353503,
 74803,
 -1,
 77407120,
 74802,
 77595826,
 76044330,
 -1,
 77661359,
 77550856,
 -1,
 77726884,
 77625734,
 -1,
 -64349,
 77693933,
 74845,
 -1,
 77734800,
 74842,
 77923495,
 77673554,
 -1,
 -64346,
 77889086,
 74782,
 -1,
 77925283,
 74773,
 78120106,
 77866699,
 -1,
 -64343,
 78082316,
 74840,
 -1,
 78134719,
 74847,
 78316717,
 78059278,
 -1,
 -64340,
 78283543,
 74804,
 -1,
 78320234,
 74831,
 -64338,
 78278914,
 74796,
 -1,
 78472971,
 74848,
 78708735,
 77613286,
 -1,
 -64335,
 78606962,
 74849,
 -1,
 78669571,
 74850,
 78841024,
 77551058,
 -1,
 78906557,
 78796040,
 -1,
 78972088,
 78873631,
 74822,
 -64330,
 78908578,
 74824,
 -64329,
 78974010,
 74823,
 -1,
 79036418,
 74825,
 -64327,
 78937662,
 74772,
 -64326,
 79196406,
 74795,
 -64325,
 79246423,
 74781,
 -64324,
 79307664,
 74766,
 -1,
 79369537,
 74759,
 79626239,
 78853369,
 -1,
 -64321,
 79516191,
 74838,
 -1,
 79572089,
 74839,
 79822847,
 78784903,
 -1,
 79824067,
 79725656,
 74820,
 -1,
 79760442,
 74821,
 -64316,
 79789630,
 74771,
 -64315,
 79917302,
 74794,
 -64314,
 79967319,
 74780,
 -64313,
 80028560,
 74765,
 -1,
 80090433,
 74758,
 80347135,
 71132724,
 -1,
 80348364,
 80225007,
 -1,
 -64309,
 80313441,
 74867,
 -1,
 80354976,
 74866,
 -64307,
 80315731,
 74865,
 -1,
 80501228,
 74864,
 80676051,
 157599,
 -1,
 80741586,
 80635807,
 -1,
 -64303,
 80710602,
 127835,
 -1,
 80751256,
 128177,
 -1,
 80694811,
 10160,
 81003734,
 80639261,
 -1,
 -64299,
 80960151,
 128707,
 -1,
 81007682,
 127854,
 -1,
 80961972,
 9982,
 81266275,
 88106,
 -1,
 81331599,
 81219659,
 -1,
 81397007,
 81271440,
 -1,
 81462542,
 81366425,
 -1,
 81528069,
 81414767,
 -1,
 81593571,
 81471179,
 -1,
 81659103,
 81555206,
 11757,
 -1,
 81595012,
 11765,
 -64288,
 81618847,
 11756,
 -64287,
 81744892,
 11753,
 -64286,
 81808931,
 11752,
 -1,
 81872749,
 11751,
 82052328,
 81542029,
 -1,
 82117863,
 82009718,
 -1,
 -64282,
 82057393,
 11775,
 -1,
 82120241,
 11772,
 -1,
 82061003,
 11767,
 82380011,
 82021873,
 -1,
 -64278,
 82327407,
 11748,
 -1,
 82388683,
 11749,
 82576622,
 82349000,
 -1,
 -64275,
 82542142,
 11771,
 -1,
 82580873,
 11770,
 82773233,
 82540287,
 -1,
 -64272,
 82735072,
 11760,
 -1,
 82781899,
 11758,
 82969844,
 82735195,
 -1,
 -64269,
 82910330,
 11763,
 -1,
 82972209,
 11762,
 83166455,
 82911558,
 -1,
 -64266,
 83117086,
 11768,
 -1,
 83175115,
 11747,
 83363066,
 83105550,
 -1,
 -64263,
 83311974,
 11774,
 -1,
 83371723,
 11744,
 -64261,
 83330177,
 11745,
 -64260,
 83518134,
 11755,
 -64259,
 83580970,
 11754,
 -64258,
 83645195,
 11769,
 -64257,
 83708846,
 11773,
 -64256,
 83772680,
 11750,
 -64255,
 83834445,
 11759,
 -64254,
 83899525,
 11746,
 -64253,
 83964190,
 11764,
 -64252,
 84024453,
 11761,
 -1,
 84086321,
 11766,
 84280584,
 81491711,
 -1,
 -64249,
 84228710,
 42610,
 -1,
 84290114,
 42608,
 84477195,
 84238757,
 -1,
 -64246,
 84433366,
 1159,
 -1,
 84481795,
 42621,
 -64244,
 84444982,
 42607,
 -64243,
 84624827,
 42620,
 -1,
 84687699,
 42609,
 -1,
 81419207,
 65062,
 84935990,
 81338694,
 -1,
 85001512,
 84880788,
 -1,
 85067039,
 84943688,
 -1,
 85132565,
 85030655,
 -1,
 -64236,
 85101070,
 43234,
 -1,
 85146252,
 43235,
 85329176,
 85094150,
 -1,
 -64233,
 85279599,
 43238,
 -1,
 85339551,
 43239,
 85525787,
 85274449,
 -1,
 -64230,
 85483284,
 43236,
 -1,
 85541674,
 43237,
 -64228,
 85495384,
 43232,
 -64227,
 85678846,
 43233,
 -64226,
 85743111,
 43241,
 -1,
 85797249,
 43240,
 85984551,
 85019247,
 -1,
 -64223,
 85951948,
 43248,
 -64222,
 86015550,
 43243,
 -64221,
 86075389,
 43247,
 -64220,
 86139364,
 43246,
 -64219,
 86201426,
 43245,
 -64218,
 86263048,
 43244,
 -1,
 86314545,
 43242,
 -1,
 85946811,
 43249,
 86638591,
 84957226,
 -1,
 86639921,
 86540068,
 -1,
 86705452,
 86593150,
 862,
 -1,
 86638774,
 863,
 86836526,
 86645233,
 861,
 -1,
 86769846,
 860,
 -64209,
 86797484,
 858,
 -64208,
 86917372,
 7676,
 -1,
 86973811,
 7629,
 87228415,
 86603519,
 -1,
 87229749,
 87128122,
 -1,
 -64204,
 87176608,
 7616,
 -1,
 87232382,
 7617,
 -1,
 87162892,
 856,
 87491931,
 84887405,
 -1,
 87557457,
 87430681,
 -1,
 87622987,
 87520040,
 -1,
 87688509,
 87559729,
 -1,
 -64197,
 87655342,
 7638,
 -64196,
 87709738,
 7637,
 -1,
 87762635,
 7636,
 87950656,
 87648161,
 -1,
 -64193,
 87911926,
 7651,
 -1,
 87955477,
 7626,
 88147266,
 87902061,
 7645,
 -1,
 88103826,
 7653,
 -64189,
 88116721,
 7654,
 -64188,
 88239878,
 7652,
 -64187,
 88298492,
 7648,
 -64186,
 88360106,
 7644,
 -64185,
 88424617,
 7640,
 -64184,
 88486584,
 7642,
 -64183,
 88551755,
 7635,
 -64182,
 88616128,
 7641,
 -1,
 88677013,
 7639,
 88932351,
 87575192,
 -1,
 -64179,
 88827807,
 7650,
 -64178,
 88888316,
 7649,
 -64177,
 88952355,
 7647,
 -64176,
 89016173,
 7646,
 -1,
 89076408,
 7643,
 89261402,
 87501103,
 -1,
 89326937,
 89194496,
 -1,
 89392472,
 89265364,
 -1,
 89458007,
 89339771,
 -1,
 -64170,
 89397269,
 852,
 -1,
 89460512,
 7678,
 -1,
 89391286,
 8430,
 -1,
 89339524,
 849,
 -1,
 89294756,
 8429,
 -1,
 89217911,
 8427,
 89916776,
 87452569,
 -1,
 89982311,
 89849856,
 -1,
 90047846,
 89920724,
 -1,
 90113381,
 89995131,
 -1,
 90178916,
 90050097,
 -1,
 90244451,
 90133679,
 -1,
 -64158,
 90210776,
 854,
 -1,
 90252727,
 7679,
 -1,
 90184121,
 848,
 -1,
 90118165,
 853,
 -1,
 90046646,
 8431,
 -1,
 89994884,
 855,
 -1,
 89950116,
 8428,
 90768752,
 89869950,
 -1,
 90834285,
 90704223,
 -1,
 -64149,
 90781082,
 7622,
 -64148,
 90839537,
 7628,
 -1,
 90902392,
 7620,
 91160575,
 90767360,
 -1,
 -64145,
 91057062,
 65061,
 -1,
 91113888,
 65060,
 91293049,
 90715512,
 -1,
 91358582,
 91236562,
 -1,
 91424117,
 91322111,
 -1,
 -64140,
 91385105,
 119362,
 -1,
 91434186,
 119363,
 -1,
 91382588,
 119364,
 91750399,
 91297425,
 -1,
 -64136,
 91639422,
 7621,
 -1,
 91688843,
 7624,
 91882881,
 91229745,
 -1,
 91948413,
 91846007,
 -1,
 -64132,
 91887637,
 857,
 -1,
 91950880,
 8432,
 92145024,
 91889971,
 -1,
 -64129,
 92098174,
 7623,
 -1,
 92157357,
 7625,
 -1,
 92097622,
 7677,
 92407172,
 91852486,
 -1,
 -64125,
 92346389,
 7631,
 -1,
 92409632,
 859,
 92603783,
 92372542,
 -1,
 -64122,
 92565259,
 7634,
 -1,
 92628900,
 7633,
 92800394,
 92565254,
 -1,
 -64119,
 92767065,
 7619,
 -1,
 92820596,
 7618,
 -64117,
 92769032,
 851,
 -64116,
 92952925,
 7630,
 -64115,
 93012502,
 7632,
 -64114,
 93073485,
 850,
 -1,
 93133303,
 7627,
 93324852,
 81290764,
 -1,
 93390304,
 93286150,
 -1,
 93455830,
 93343576,
 -1,
 93521321,
 93411370,
 11423,
 93586856,
 93472994,
 -1,
 93652386,
 93527910,
 -1,
 93717914,
 93599287,
 -1,
 93783448,
 93654577,
 11471,
 -1,
 93746943,
 11477,
 -64103,
 93740405,
 11469,
 -1,
 93858166,
 11475,
 94045597,
 93679707,
 -1,
 -64100,
 93994577,
 11483,
 -1,
 94054774,
 11461,
 -64098,
 94002235,
 11455,
 -64097,
 94188382,
 11479,
 -64096,
 94252153,
 11463,
 -64095,
 94315454,
 11481,
 -1,
 94376192,
 11445,
 94633983,
 93607782,
 -1,
 94635430,
 94524412,
 -1,
 -64091,
 94604515,
 11489,
 -1,
 94647514,
 11487,
 -64089,
 94603206,
 11491,
 -1,
 94794031,
 11485,
 -1,
 93544135,
 11441,
 95028656,
 93462854,
 -1,
 95094191,
 94977015,
 -1,
 -64084,
 95049170,
 11451,
 -64083,
 95110499,
 11449,
 -64082,
 95173095,
 11467,
 -1,
 95228325,
 11443,
 -1,
 95031708,
 11399,
 95487415,
 94969739,
 -1,
 95552950,
 95456631,
 -1,
 -64077,
 95514897,
 11500,
 -64076,
 95573458,
 11453,
 -64075,
 95630174,
 11502,
 -1,
 95693181,
 11447,
 -1,
 95510043,
 11459,
 95946171,
 95448838,
 -1,
 -64071,
 95903431,
 11403,
 -64070,
 95960657,
 11429,
 -1,
 96014934,
 11457,
 96208319,
 95896746,
 -1,
 -64067,
 96170392,
 11421,
 -64066,
 96221223,
 11437,
 -1,
 96277404,
 11413,
 96470466,
 96171775,
 -1,
 -64063,
 96417789,
 11409,
 -1,
 96474718,
 11431,
 96667077,
 96428453,
 -1,
 -64060,
 96629144,
 11439,
 -1,
 96680845,
 11425,
 96863688,
 96618349,
 -1,
 -64057,
 96802401,
 11415,
 -1,
 96864850,
 11473,
 97060299,
 96800305,
 -1,
 -64054,
 97012440,
 11393,
 -1,
 97076836,
 11465,
 -64052,
 97029670,
 11405,
 -64051,
 97224143,
 11395,
 -64050,
 97287855,
 11433,
 -64049,
 97348984,
 11427,
 -64048,
 97408466,
 11419,
 -64047,
 97472946,
 11417,
 -64046,
 97533008,
 11411,
 -64045,
 97597279,
 11407,
 -64044,
 97661758,
 11397,
 -64043,
 97726634,
 11435,
 -1,
 97790333,
 11401,
 98041855,
 93424917,
 -1,
 98043354,
 97939206,
 -1,
 -64039,
 98007041,
 11495,
 -1,
 98056431,
 11498,
 98239965,
 97993898,
 -1,
 -64036,
 98187306,
 11497,
 -1,
 98242780,
 11492,
 -64034,
 98203642,
 11496,
 -64033,
 98395084,
 11494,
 -1,
 98455993,
 11493,
 98633259,
 93330064,
 -1,
 98698790,
 98571193,
 -1,
 98764281,
 98654250,
 11422,
 98829816,
 98715874,
 -1,
 98895346,
 98770790,
 -1,
 98960874,
 98842167,
 -1,
 99026408,
 98897457,
 11470,
 -1,
 98989823,
 11476,
 -64023,
 98983285,
 11468,
 -1,
 99101046,
 11474,
 99288557,
 98922587,
 -1,
 -64020,
 99237457,
 11482,
 -1,
 99297654,
 11460,
 -64018,
 99245115,
 11454,
 -64017,
 99431262,
 11478,
 -64016,
 99495033,
 11462,
 -64015,
 99558334,
 11480,
 -1,
 99619072,
 11444,
 99876863,
 98850662,
 -1,
 99878390,
 99767292,
 -1,
 -64011,
 99847395,
 11488,
 -1,
 99890394,
 11486,
 -64009,
 99846086,
 11490,
 -1,
 100036911,
 11484,
 -1,
 98787015,
 11440,
 100271616,
 98705734,
 -1,
 100337151,
 100219895,
 -1,
 -64004,
 100292050,
 11450,
 -64003,
 100353379,
 11448,
 -64002,
 100415975,
 11466,
 -1,
 100471205,
 11442,
 -1,
 100274588,
 11398,
 100730375,
 100212619,
 -1,
 100795910,
 100699511,
 -1,
 -63997,
 100757777,
 11499,
 -63996,
 100816338,
 11452,
 -63995,
 100873054,
 11501,
 -1,
 100936061,
 11446,
 -1,
 100752923,
 11458,
 101189131,
 100691718,
 -1,
 -63991,
 101146311,
 11402,
 -63990,
 101203537,
 11428,
 -1,
 101257814,
 11456,
 101451279,
 101139626,
 -1,
 -63987,
 101413272,
 11420,
 -63986,
 101464103,
 11436,
 -1,
 101520284,
 11412,
 101713426,
 101414655,
 -1,
 -63983,
 101660669,
 11408,
 -1,
 101717598,
 11430,
 101910037,
 101671333,
 -1,
 -63980,
 101872024,
 11438,
 -1,
 101923725,
 11424,
 102106648,
 101861229,
 -1,
 -63977,
 102045281,
 11414,
 -1,
 102107730,
 11472,
 102303259,
 102043185,
 -1,
 -63974,
 102255320,
 11392,
 -1,
 102319716,
 11464,
 -63972,
 102272550,
 11404,
 -63971,
 102467023,
 11394,
 -63970,
 102530735,
 11432,
 -63969,
 102591864,
 11426,
 -63968,
 102651346,
 11418,
 -63967,
 102715826,
 11416,
 -63966,
 102775888,
 11410,
 -63965,
 102840159,
 11406,
 -63964,
 102904638,
 11396,
 -63963,
 102969514,
 11434,
 -1,
 103033213,
 11400,
 103284735,
 98654842,
 -1,
 103286314,
 103183486,
 -1,
 -63959,
 103238214,
 11505,
 -1,
 103290199,
 11504,
 -1,
 103241173,
 11503,
 103548464,
 98589190,
 -1,
 -63955,
 103515415,
 11516,
 -63954,
 103563029,
 11515,
 -63953,
 103625383,
 11513,
 -1,
 103687019,
 11514,
 103876147,
 103493457,
 -1,
 -63950,
 103841883,
 11518,
 -1,
 103901199,
 11517,
 -1,
 103830313,
 11519,
 104138321,
 93290046,
 -1,
 104203856,
 104093506,
 -1,
 104269379,
 104169861,
 -1,
 104334906,
 104232703,
 -1,
 -63943,
 104303118,
 119649,
 -1,
 104348300,
 119650,
 104531517,
 104296198,
 -1,
 -63940,
 104481647,
 119653,
 -1,
 104541599,
 119654,
 104728128,
 104476497,
 -1,
 -63937,
 104685332,
 119651,
 -1,
 104743722,
 119652,
 -63935,
 104684286,
 119648,
 -63934,
 104879623,
 119656,
 -1,
 104933761,
 119655,
 105185279,
 104233108,
 -1,
 105186887,
 105084671,
 -1,
 -63930,
 105155086,
 119658,
 -1,
 105200268,
 119659,
 105383498,
 105148166,
 -1,
 -63927,
 105333615,
 119662,
 -1,
 105393567,
 119663,
 105580109,
 105328465,
 -1,
 -63924,
 105537300,
 119660,
 -1,
 105595690,
 119661,
 -63922,
 105536254,
 119657,
 -63921,
 105731591,
 119665,
 -1,
 105785729,
 119664,
 -1,
 104162354,
 128145,
 106038873,
 104092668,
 -1,
 106104405,
 106001974,
 -1,
 -63916,
 106072797,
 128119,
 -1,
 106131888,
 128679,
 106301016,
 106049361,
 -1,
 -63913,
 106258184,
 128534,
 -1,
 106310908,
 127882,
 -1,
 106267865,
 127978,
 106563166,
 105994671,
 -1,
 106628701,
 106511245,
 -1,
 -63908,
 106583449,
 127859,
 -1,
 106637003,
 127850,
 -1,
 106571936,
 127834,
 106890848,
 106530620,
 128004,
 -1,
 106824083,
 128046,
 -63903,
 106843194,
 128165,
 -63902,
 106967189,
 9904,
 -1,
 107027958,
 127864,
 107218757,
 81234888,
 -1,
 107284224,
 107179151,
 -1,
 107349681,
 107246376,
 -1,
 107415150,
 107290950,
 -1,
 107480683,
 107384305,
 -1,
 -63895,
 107449910,
 42633,
 -63894,
 107513906,
 42627,
 -1,
 107555326,
 42563,
 -63892,
 107448370,
 42625,
 -63891,
 107699933,
 42605,
 -1,
 107758622,
 42569,
 107939445,
 107378431,
 -1,
 108004978,
 107900678,
 -1,
 -63887,
 107972658,
 42639,
 -1,
 108031968,
 42641,
 -63885,
 107972658,
 42637,
 -63884,
 108144512,
 42635,
 -1,
 108207237,
 42643,
 108398206,
 107900678,
 -1,
 108463739,
 108353851,
 -1,
 108529274,
 108406475,
 -1,
 -63879,
 108482083,
 42599,
 -1,
 108545901,
 42597,
 -1,
 108470826,
 42595,
 108855295,
 108410423,
 -1,
 -63875,
 108759090,
 42647,
 -1,
 108803664,
 1319,
 108988037,
 108357535,
 -1,
 109053572,
 108932607,
 -1,
 -63871,
 109022774,
 1297,
 -63870,
 109088173,
 42581,
 -63869,
 109149365,
 42593,
 -1,
 109192903,
 42565,
 -1,
 109000269,
 1303,
 109446795,
 108937644,
 -1,
 109512330,
 109395271,
 -1,
 -63864,
 109481050,
 42579,
 -63863,
 109518372,
 42589,
 -1,
 109579825,
 42583,
 -1,
 109448753,
 42567,
 109840015,
 109415368,
 -1,
 -63859,
 109794300,
 42591,
 -63858,
 109849661,
 42577,
 -1,
 109907920,
 1305,
 110102164,
 109786679,
 -1,
 110167699,
 110038656,
 -1,
 -63854,
 110130660,
 1279,
 -1,
 110180793,
 1277,
 -1,
 110135346,
 42645,
 110429849,
 110044875,
 -1,
 110495384,
 110380923,
 -1,
 -63849,
 110449091,
 1313,
 -1,
 110508473,
 1299,
 -1,
 110449696,
 1315,
 110757533,
 110368526,
 -1,
 -63845,
 110718335,
 42573,
 -63844,
 110774831,
 42587,
 -1,
 110837877,
 42603,
 111019680,
 110726641,
 -1,
 -63841,
 110967671,
 42629,
 -1,
 111028767,
 42561,
 111216291,
 110977445,
 -1,
 -63838,
 111159138,
 1317,
 -1,
 111219221,
 1231,
 111412902,
 111170299,
 -1,
 -63835,
 111359377,
 42571,
 -1,
 111419628,
 42601,
 111609513,
 111359113,
 -1,
 -63832,
 111572467,
 1275,
 -1,
 111616648,
 1271,
 111806124,
 111549072,
 -1,
 -63829,
 111758559,
 42585,
 -1,
 111811717,
 42631,
 -63827,
 111773746,
 1309,
 -63826,
 111961729,
 1307,
 -63825,
 112022921,
 42575,
 -63824,
 112085732,
 1301,
 -1,
 112136653,
 1311,
 112330491,
 107289443,
 -1,
 112395962,
 112271686,
 -1,
 112461495,
 112365041,
 -1,
 -63819,
 112430646,
 42632,
 -63818,
 112494642,
 42626,
 -1,
 112536062,
 42562,
 -63816,
 112429106,
 42624,
 -63815,
 112680669,
 42604,
 -1,
 112739358,
 42568,
 112920257,
 112359167,
 -1,
 112985790,
 112881414,
 -1,
 -63811,
 112953394,
 42638,
 -1,
 113012704,
 42640,
 -63809,
 112953394,
 42636,
 -63808,
 113125248,
 42634,
 -1,
 113187973,
 42642,
 113379018,
 112881414,
 -1,
 113444551,
 113334587,
 -1,
 113510086,
 113387211,
 -1,
 -63803,
 113462819,
 42598,
 -1,
 113526637,
 42596,
 -1,
 113451562,
 42594,
 113836031,
 113391159,
 -1,
 -63799,
 113739826,
 42646,
 -1,
 113784400,
 1318,
 113968849,
 113338271,
 -1,
 114034384,
 113913343,
 -1,
 -63795,
 114003510,
 1296,
 -63794,
 114068909,
 42580,
 -63793,
 114130101,
 42592,
 -1,
 114173639,
 42564,
 -1,
 113981005,
 1302,
 114427607,
 113918380,
 -1,
 114493142,
 114376007,
 -1,
 -63788,
 114461786,
 42578,
 -63787,
 114499108,
 42588,
 -1,
 114560561,
 42582,
 -1,
 114429489,
 42566,
 114820827,
 114396104,
 -1,
 -63783,
 114775036,
 42590,
 -63782,
 114830397,
 42576,
 -1,
 114888656,
 1304,
 115082976,
 114767415,
 -1,
 115148511,
 115019392,
 -1,
 -63778,
 115111396,
 1278,
 -1,
 115161529,
 1276,
 -1,
 115116082,
 42644,
 115410661,
 115025611,
 -1,
 115476196,
 115361659,
 -1,
 -63773,
 115429827,
 1312,
 -1,
 115489209,
 1298,
 -1,
 115430432,
 1314,
 115738345,
 115349262,
 -1,
 -63769,
 115699071,
 42572,
 -63768,
 115755567,
 42586,
 -1,
 115818613,
 42602,
 116000492,
 115707377,
 -1,
 -63765,
 115948407,
 42628,
 -1,
 116009503,
 42560,
 116197103,
 115954427,
 -1,
 -63762,
 116143505,
 42570,
 -1,
 116203756,
 42600,
 116393714,
 116143241,
 -1,
 -63759,
 116356595,
 1274,
 -1,
 116400776,
 1270,
 116590325,
 116333200,
 -1,
 -63756,
 116542687,
 42584,
 -1,
 116595845,
 42630,
 -63754,
 116557874,
 1308,
 -63753,
 116745857,
 1306,
 -63752,
 116810425,
 1316,
 -63751,
 116872585,
 42574,
 -63750,
 116935396,
 1300,
 -1,
 116986317,
 1310,
 117180158,
 112282223,
 -1,
 -63747,
 117142260,
 7467,
 -1,
 117199727,
 42606,
 -63745,
 117138081,
 42623,
 -1,
 117327291,
 42622,
 117507908,
 107242955,
 -1,
 117573383,
 117470975,
 -1,
 -63741,
 117538366,
 67633,
 -63740,
 117594154,
 67632,
 -63739,
 117652365,
 67631,
 -63738,
 117712587,
 67630,
 -1,
 117771825,
 67629,
 117966605,
 117534470,
 -1,
 -63735,
 117931582,
 67628,
 -63734,
 117987370,
 67627,
 -63733,
 118045581,
 67626,
 -63732,
 118105803,
 67625,
 -1,
 118165041,
 67624,
 118359827,
 117925791,
 -1,
 -63729,
 118324798,
 67623,
 -63728,
 118380586,
 67622,
 -63727,
 118438797,
 67621,
 -63726,
 118499019,
 67620,
 -1,
 118558257,
 67619,
 118753049,
 118317477,
 -1,
 -63723,
 118718014,
 67618,
 -63722,
 118773802,
 67617,
 -63721,
 118832013,
 67616,
 -63720,
 118892235,
 67615,
 -1,
 118951473,
 67614,
 119146271,
 118707196,
 -1,
 -63717,
 119111230,
 67613,
 -63716,
 119167018,
 67612,
 -63715,
 119225229,
 67611,
 -63714,
 119285451,
 67610,
 -1,
 119344689,
 67609,
 119539493,
 119098915,
 -1,
 -63711,
 119504446,
 67608,
 -63710,
 119560234,
 67607,
 -63709,
 119618445,
 67606,
 -63708,
 119678667,
 67605,
 -1,
 119737905,
 67604,
 119932715,
 119490413,
 -1,
 -63705,
 119897662,
 67603,
 -63704,
 119953450,
 67602,
 -63703,
 120011661,
 67601,
 -63702,
 120071883,
 67600,
 -1,
 120131121,
 67599,
 120325937,
 119882922,
 -1,
 -63699,
 120290878,
 67598,
 -63698,
 120346666,
 67597,
 -63697,
 120404877,
 67596,
 -63696,
 120465099,
 67595,
 -1,
 120524337,
 67594,
 120719158,
 120293180,
 -1,
 -63693,
 120674346,
 67637,
 -63692,
 120732557,
 67636,
 -63691,
 120792779,
 67635,
 -1,
 120852017,
 67634,
 121046841,
 120688113,
 -1,
 -63688,
 121002026,
 67647,
 -1,
 121048625,
 67644,
 121243452,
 121015046,
 -1,
 -63685,
 121185995,
 67640,
 -1,
 121245233,
 67639,
 121440063,
 121193414,
 -1,
 -63682,
 121395242,
 67592,
 -1,
 121441841,
 67589,
 -63680,
 121404990,
 67588,
 -63679,
 121591850,
 67587,
 -63678,
 121650061,
 67586,
 -63677,
 121710283,
 67585,
 -1,
 121769521,
 67584,
 -1,
 117448209,
 127744,
 122030049,
 107168841,
 -1,
 122095548,
 121970387,
 -1,
 122160984,
 122034832,
 -1,
 -63671,
 122105681,
 64207,
 -63670,
 122169035,
 64206,
 -63669,
 122233158,
 64205,
 -63668,
 122296976,
 64204,
 -63667,
 122361614,
 64203,
 -63666,
 122424881,
 64202,
 -63665,
 122490362,
 64201,
 -63664,
 122555846,
 64200,
 -63663,
 122621319,
 64199,
 -63662,
 122686797,
 64198,
 -63661,
 122752224,
 64197,
 -63660,
 122817698,
 64196,
 -63659,
 122883130,
 64195,
 -63658,
 122948515,
 64194,
 -63657,
 123013907,
 64193,
 -1,
 123079312,
 64192,
 123275113,
 122099470,
 -1,
 -63654,
 123219793,
 64191,
 -63653,
 123283147,
 64190,
 -63652,
 123347270,
 64189,
 -63651,
 123411088,
 64188,
 -63650,
 123475726,
 64187,
 -63649,
 123538993,
 64186,
 -63648,
 123604474,
 64185,
 -63647,
 123669958,
 64184,
 -63646,
 123735431,
 64183,
 -63645,
 123800909,
 64182,
 -63644,
 123866336,
 64181,
 -63643,
 123931810,
 64180,
 -63642,
 123997242,
 64179,
 -63641,
 124062627,
 64178,
 -63640,
 124128019,
 64177,
 -1,
 124193424,
 64176,
 124389242,
 123211313,
 -1,
 -63637,
 124333905,
 64175,
 -63636,
 124397259,
 64174,
 -63635,
 124461382,
 64173,
 -63634,
 124525200,
 64172,
 -63633,
 124589838,
 64171,
 -63632,
 124653105,
 64170,
 -63631,
 124718586,
 64169,
 -63630,
 124784070,
 64168,
 -63629,
 124849543,
 64167,
 -63628,
 124915021,
 64166,
 -63627,
 124980448,
 64165,
 -63626,
 125045922,
 64164,
 -63625,
 125111354,
 64163,
 -63624,
 125176739,
 64162,
 -63623,
 125242131,
 64161,
 -1,
 125307536,
 64160,
 125503371,
 124325370,
 -1,
 -63620,
 125448017,
 64159,
 -63619,
 125511371,
 64158,
 -63618,
 125575494,
 64157,
 -63617,
 125639312,
 64156,
 -63616,
 125703950,
 64155,
 -63615,
 125767217,
 64154,
 -63614,
 125832698,
 64153,
 -63613,
 125898182,
 64152,
 -63612,
 125963655,
 64151,
 -63611,
 126029133,
 64150,
 -63610,
 126094560,
 64149,
 -63609,
 126160034,
 64148,
 -63608,
 126225466,
 64147,
 -63607,
 126290851,
 64146,
 -63606,
 126356243,
 64145,
 -1,
 126421648,
 64144,
 126617500,
 125439430,
 -1,
 -63603,
 126562129,
 64143,
 -63602,
 126625483,
 64142,
 -63601,
 126689606,
 64141,
 -63600,
 126753424,
 64140,
 -63599,
 126818062,
 64139,
 -63598,
 126881329,
 64138,
 -63597,
 126946810,
 64137,
 -63596,
 127012294,
 64136,
 -63595,
 127077767,
 64135,
 -63594,
 127143245,
 64134,
 -63593,
 127208672,
 64133,
 -63592,
 127274146,
 64132,
 -63591,
 127339578,
 64131,
 -63590,
 127404963,
 64130,
 -63589,
 127470355,
 64129,
 -1,
 127535760,
 64128,
 127731629,
 126553479,
 -1,
 -63586,
 127676241,
 64127,
 -63585,
 127739595,
 64126,
 -63584,
 127803718,
 64125,
 -63583,
 127867536,
 64124,
 -63582,
 127932174,
 64123,
 -63581,
 127995441,
 64122,
 -63580,
 128060922,
 64121,
 -63579,
 128126406,
 64120,
 -63578,
 128191879,
 64119,
 -63577,
 128257357,
 64118,
 -63576,
 128322784,
 64117,
 -63575,
 128388258,
 64116,
 -63574,
 128453690,
 64115,
 -63573,
 128519075,
 64114,
 -63572,
 128584467,
 64113,
 -1,
 128649872,
 64112,
 128845752,
 127672646,
 -1,
 -63569,
 128781818,
 64217,
 -63568,
 128847302,
 64216,
 -63567,
 128912775,
 64215,
 -63566,
 128978253,
 64214,
 -63565,
 129043680,
 64213,
 -63564,
 129109154,
 64212,
 -63563,
 129174586,
 64211,
 -63562,
 129239971,
 64210,
 -63561,
 129305363,
 64209,
 -1,
 129370768,
 64208,
 129630207,
 128781645,
 -1,
 -63558,
 129507654,
 64109,
 -63557,
 129571472,
 64108,
 -1,
 129636110,
 64107,
 129892351,
 122058219,
 -1,
 129894347,
 129775159,
 12752,
 129959879,
 129863153,
 12757,
 130025411,
 129928689,
 12741,
 130090946,
 129994225,
 12750,
 -1,
 130036408,
 12769,
 -1,
 130048421,
 12747,
 130287557,
 129992508,
 12749,
 -1,
 130233016,
 12744,
 -63546,
 130250495,
 12746,
 -1,
 130364088,
 12742,
 130549705,
 129917349,
 12743,
 -1,
 130517132,
 12748,
 -63542,
 130517956,
 12768,
 -1,
 130626232,
 12758,
 130811861,
 129855238,
 12753,
 130877391,
 130780657,
 12759,
 -63538,
 130846193,
 12766,
 -1,
 130910348,
 12745,
 131074002,
 130844476,
 12740,
 -63535,
 131042801,
 12760,
 -1,
 131084984,
 12767,
 -63533,
 131036927,
 12761,
 -63532,
 131228069,
 12755,
 -1,
 131281592,
 12762,
 131467225,
 130769317,
 12754,
 -63529,
 131436017,
 12764,
 -63528,
 131478200,
 12770,
 -1,
 131539270,
 12763,
 131729371,
 131430143,
 12736,
 -1,
 131683324,
 12765,
 -63524,
 131697537,
 12738,
 -63523,
 131827852,
 12737,
 -63522,
 131884659,
 12771,
 -63521,
 131945468,
 12751,
 -63520,
 131998022,
 12756,
 -1,
 132061820,
 12739,
 132253845,
 121966129,
 -1,
 132319316,
 132207612,
 -1,
 132384851,
 132255675,
 -1,
 132450292,
 132339754,
 -1,
 132515827,
 132400177,
 -1,
 132581356,
 132469756,
 6361,
 132710399,
 132548412,
 -1,
 132712426,
 132601898,
 6347,
 -1,
 132667434,
 6349,
 132907007,
 132660109,
 6343,
 -1,
 132791181,
 6345,
 132974574,
 132542214,
 6362,
 -1,
 132920887,
 6363,
 -63505,
 132937471,
 6357,
 -63504,
 133063077,
 6356,
 -63503,
 133123619,
 6360,
 -63502,
 133186730,
 6358,
 -1,
 133241488,
 6359,
 -1,
 132484040,
 6320,
 133498885,
 132417340,
 -1,
 133564415,
 133454844,
 -1,
 133629950,
 133528093,
 -1,
 133695481,
 133584938,
 5754,
 -1,
 133650474,
 5755,
 133826555,
 133643149,
 5752,
 -1,
 133774221,
 5753,
 133957629,
 133762609,
 5756,
 -1,
 133893681,
 5757,
 -1,
 133900486,
 5751,
 -1,
 133574879,
 5758,
 134219780,
 133508243,
 -1,
 134285315,
 134154643,
 -1,
 -63486,
 134241263,
 6369,
 -1,
 134287018,
 6370,
 -1,
 134229035,
 6365,
 -1,
 134158055,
 6323,
 134613010,
 133459718,
 -1,
 134678541,
 134551271,
 6335,
 134807551,
 134627905,
 -1,
 134809611,
 134705243,
 -1,
 -63478,
 134776882,
 6378,
 -1,
 134831087,
 6379,
 -63476,
 134759586,
 6385,
 -1,
 134953397,
 6380,
 135137297,
 134624823,
 -1,
 -63473,
 135105252,
 6338,
 -63472,
 135160222,
 6336,
 -1,
 135206631,
 6337,
 -1,
 135094686,
 6334,
 135464990,
 134575871,
 -1,
 135530519,
 135428360,
 -1,
 -63467,
 135497778,
 6373,
 -63466,
 135551983,
 6374,
 -1,
 135597738,
 6375,
 135792666,
 135482081,
 -1,
 -63463,
 135759922,
 6376,
 -1,
 135814127,
 6377,
 135989277,
 135740272,
 -1,
 -63460,
 135931595,
 6371,
 -1,
 135990833,
 6372,
 -1,
 135927527,
 6327,
 136251432,
 135423903,
 -1,
 136316966,
 136218428,
 -1,
 136382498,
 136271914,
 6353,
 -1,
 136337450,
 6354,
 136513572,
 136330125,
 6351,
 -1,
 136461197,
 6352,
 -63451,
 136456390,
 6350,
 -1,
 136580657,
 6355,
 -63449,
 136255207,
 6341,
 -1,
 136710555,
 6368,
 136906800,
 136205308,
 -1,
 136972334,
 136873788,
 -1,
 137037868,
 136927274,
 6346,
 -1,
 136992810,
 6348,
 137232383,
 136985485,
 6342,
 -1,
 137116557,
 6344,
 -63441,
 136929694,
 6331,
 -1,
 137238247,
 6332,
 137431098,
 136846234,
 -1,
 137496630,
 137376440,
 -1,
 137562165,
 137463612,
 -1,
 -63436,
 137526846,
 6381,
 -1,
 137563697,
 6384,
 -1,
 137498282,
 6383,
 137824313,
 137437796,
 -1,
 -63432,
 137787315,
 6389,
 -1,
 137832215,
 6382,
 -1,
 137774246,
 6386,
 138086462,
 137388453,
 -1,
 -63428,
 138054372,
 6326,
 -63427,
 138109342,
 6324,
 -1,
 138155751,
 6325,
 138348611,
 138024718,
 -1,
 138414146,
 138291275,
 -1,
 -63423,
 138373023,
 6388,
 -1,
 138430317,
 6387,
 -1,
 138364877,
 5759,
 138676294,
 138316744,
 -1,
 -63419,
 138633630,
 6339,
 -1,
 138680039,
 6340,
 138872905,
 138626218,
 -1,
 -63416,
 138840089,
 6329,
 -1,
 138876647,
 6328,
 139069516,
 138817742,
 -1,
 -63413,
 139031383,
 6366,
 -1,
 139094111,
 6367,
 139266127,
 139005489,
 -1,
 -63410,
 139234248,
 6321,
 -1,
 139269863,
 6322,
 -63408,
 139218995,
 6330,
 -63407,
 139413682,
 6333,
 -63406,
 139475846,
 5120,
 -1,
 139536417,
 6364,
 -1,
 132327094,
 127852,
 139790476,
 132278175,
 -1,
 139856008,
 139738130,
 -1,
 139921500,
 139820606,
 66226,
 140050431,
 139886142,
 66239,
 140115967,
 139951678,
 66212,
 -63398,
 140017214,
 66235,
 -63397,
 140053562,
 66256,
 -1,
 140118947,
 66248,
 140314722,
 139882246,
 66224,
 140380255,
 140277503,
 66242,
 -1,
 140315555,
 66243,
 140511329,
 140326455,
 66222,
 -1,
 140446627,
 66223,
 -1,
 140472070,
 66232,
 140707943,
 140267043,
 66218,
 140836863,
 140646158,
 66250,
 -63387,
 140709026,
 66253,
 -63386,
 140774458,
 66252,
 -1,
 140839843,
 66251,
 141035627,
 140661756,
 66229,
 -63383,
 140989436,
 66227,
 -63382,
 141046456,
 66244,
 -1,
 141107526,
 66238,
 141297774,
 140998399,
 66221,
 141426687,
 141260543,
 66247,
 -1,
 141298595,
 66230,
 141494385,
 141248365,
 66211,
 141623295,
 141435206,
 66214,
 -1,
 141495203,
 66254,
 141690995,
 141453215,
 66213,
 -1,
 141649823,
 66249,
 141822069,
 141648293,
 66231,
 -1,
 141757347,
 66209,
 141953143,
 141771946,
 66236,
 -1,
 141888419,
 66237,
 142084217,
 141900685,
 66233,
 -1,
 142031757,
 66245,
 142215291,
 142029496,
 66240,
 -1,
 142150563,
 66241,
 142346365,
 142157515,
 66234,
 -1,
 142281635,
 66255,
 142477439,
 142287174,
 66210,
 -1,
 142412707,
 66220,
 142608514,
 142416553,
 -1,
 -63359,
 142544031,
 66246,
 -1,
 142609299,
 66225,
 142805124,
 142544433,
 66208,
 -1,
 142740387,
 66215,
 -63355,
 142772998,
 66228,
 -63354,
 142894707,
 66216,
 -63353,
 142956586,
 66219,
 -1,
 143005454,
 66217,
 -63351,
 139813326,
 127887,
 -63350,
 143155050,
 127904,
 -63349,
 143204704,
 128199,
 -1,
 143263262,
 9936,
 143460497,
 139753215,
 128008,
 143589375,
 143393171,
 128049,
 143654911,
 143460204,
 -1,
 -63344,
 143559400,
 128572,
 -1,
 143620134,
 128569,
 -63342,
 143422862,
 9963,
 -63341,
 143741297,
 128247,
 -63340,
 143804968,
 128197,
 -1,
 143859927,
 127797,
 144050455,
 132199991,
 -1,
 144115977,
 143986225,
 -1,
 144181508,
 144068133,
 -1,
 144247003,
 144132719,
 -1,
 144312485,
 144191694,
 -1,
 144378012,
 144266236,
 43590,
 -1,
 144323256,
 43586,
 -63331,
 144346056,
 43592,
 -63330,
 144471807,
 43589,
 -63329,
 144536789,
 43595,
 -63328,
 144598943,
 43593,
 -63327,
 144662949,
 43591,
 -63326,
 144721773,
 43594,
 -63325,
 144786602,
 43584,
 -63324,
 144847544,
 43585,
 -1,
 144907372,
 43588,
 145098927,
 144266236,
 -1,
 145164458,
 145045047,
 -1,
 -63320,
 145129445,
 43536,
 -63319,
 145179620,
 43538,
 -1,
 145231409,
 43537,
 145426605,
 145109688,
 -1,
 -63316,
 145391589,
 43530,
 -1,
 145428017,
 43531,
 -63314,
 145391589,
 43543,
 -1,
 145559089,
 43544,
 145754291,
 145056165,
 -1,
 -63311,
 145711588,
 43547,
 -63310,
 145765965,
 43548,
 -1,
 145821233,
 43546,
 146016439,
 145695046,
 -1,
 -63307,
 145962573,
 43542,
 -63306,
 146022818,
 43545,
 -1,
 146083377,
 43541,
 146278587,
 145954574,
 -1,
 -63303,
 146224717,
 43550,
 -63302,
 146282307,
 43553,
 -1,
 146345521,
 43549,
 146540734,
 146241279,
 -1,
 -63299,
 146486861,
 43540,
 -1,
 146542129,
 43539,
 146737345,
 146501382,
 -1,
 -63296,
 146698074,
 43558,
 -1,
 146738737,
 43559,
 146933956,
 146689571,
 -1,
 -63293,
 146898917,
 43551,
 -1,
 146935345,
 43552,
 147130567,
 146883754,
 -1,
 -63290,
 147076685,
 43527,
 -1,
 147131953,
 43526,
 147327178,
 147080134,
 -1,
 -63287,
 147273293,
 43535,
 -1,
 147328561,
 43534,
 147523789,
 147272376,
 -1,
 -63284,
 147469901,
 43529,
 -1,
 147525169,
 43528,
 147720400,
 147463276,
 -1,
 -63281,
 147666509,
 43533,
 -1,
 147721777,
 43532,
 147917010,
 147656241,
 43520,
 -1,
 147864461,
 43524,
 -63277,
 147885066,
 43554,
 -63276,
 148014020,
 43557,
 -63275,
 148078142,
 43522,
 -63274,
 148137981,
 43555,
 -63273,
 148199466,
 43525,
 -63272,
 148260763,
 43556,
 -63271,
 148323213,
 43521,
 -63270,
 148387405,
 43560,
 -1,
 148448971,
 43523,
 148637927,
 144213707,
 -1,
 148703456,
 148573745,
 -1,
 -63266,
 148667966,
 43569,
 -63265,
 148716429,
 43568,
 -1,
 148770353,
 43561,
 148965602,
 148667966,
 43565,
 -1,
 148907723,
 43570,
 149096676,
 148920362,
 43567,
 -1,
 149038795,
 43566,
 149227750,
 149044109,
 43562,
 -1,
 149175181,
 43563,
 -1,
 149170550,
 43564,
 149424373,
 148579144,
 -1,
 149489899,
 149387007,
 -1,
 -63254,
 149457422,
 43602,
 -1,
 149502604,
 43603,
 149686510,
 149450502,
 -1,
 -63251,
 149635951,
 43606,
 -1,
 149695903,
 43607,
 149883121,
 149630801,
 -1,
 -63248,
 149839636,
 43604,
 -1,
 149898026,
 43605,
 -63246,
 149851736,
 43600,
 -63245,
 150035198,
 43601,
 -63244,
 150099463,
 43609,
 -1,
 150153601,
 43608,
 150341886,
 149364479,
 -1,
 150407418,
 150286542,
 -1,
 -63240,
 150361497,
 43587,
 -63239,
 150425123,
 43596,
 -1,
 150484535,
 43597,
 -63237,
 150375434,
 43571,
 -63236,
 150636419,
 43574,
 -63235,
 150693885,
 43572,
 -1,
 150751131,
 43573,
 150994943,
 150300199,
 -1,
 150997250,
 150872390,
 -1,
 -63231,
 150953681,
 43614,
 -1,
 150999774,
 43613,
 -63229,
 150961264,
 43615,
 -1,
 151155819,
 43612,
 151324936,
 144141886,
 -1,
 151390471,
 151290501,
 128200,
 -1,
 151322774,
 128185,
 -1,
 151332361,
 128201,
 -1,
 151273600,
 9939,
 151652624,
 144058059,
 -1,
 151718157,
 151612946,
 -1,
 -63220,
 151686101,
 127800,
 -1,
 151731500,
 127826,
 -63218,
 151680403,
 127792,
 -63217,
 151873336,
 127937,
 -1,
 151923739,
 128227,
 152111380,
 151600013,
 -1,
 -63214,
 152071619,
 9911,
 -63213,
 152127750,
 128696,
 -1,
 152182246,
 128020,
 -63211,
 152077012,
 9962,
 -63210,
 152333609,
 127876,
 -1,
 152393926,
 127851,
 152570197,
 144000877,
 -1,
 152635727,
 152524842,
 -1,
 152701256,
 152575432,
 -1,
 152766788,
 152633753,
 -1,
 152832297,
 152729343,
 -1,
 152897827,
 152799036,
 -1,
 152963360,
 152852522,
 -1,
 -63201,
 152898184,
 128349,
 -1,
 152961860,
 128337,
 153223167,
 152906247,
 -1,
 -63198,
 153094792,
 128359,
 -1,
 153158468,
 128347,
 153356582,
 152844940,
 -1,
 -63195,
 153291400,
 128350,
 -1,
 153355076,
 128338,
 153616383,
 153299507,
 -1,
 -63192,
 153488008,
 128357,
 -1,
 153551684,
 128345,
 153749808,
 152792838,
 -1,
 153815341,
 153699183,
 -1,
 -63188,
 153750152,
 128353,
 -1,
 153813828,
 128341,
 154075135,
 153759135,
 -1,
 -63185,
 153946760,
 128354,
 -1,
 154010436,
 128342,
 154208567,
 153694033,
 -1,
 154274100,
 154165012,
 -1,
 -63181,
 154208904,
 128351,
 -1,
 154272580,
 128339,
 154533887,
 154223402,
 -1,
 -63178,
 154405512,
 128352,
 -1,
 154469188,
 128340,
 154667326,
 154150603,
 -1,
 154732859,
 154618567,
 -1,
 -63174,
 154667656,
 128358,
 -1,
 154731332,
 128346,
 154992639,
 154680731,
 -1,
 -63171,
 154864264,
 128355,
 -1,
 154927940,
 128343,
 155126081,
 154622718,
 -1,
 -63168,
 155060872,
 128348,
 -1,
 155124548,
 128336,
 155385855,
 155080199,
 -1,
 -63165,
 155257480,
 128356,
 -1,
 155321156,
 128344,
 155582463,
 152734046,
 -1,
 155584839,
 155479073,
 128257,
 -1,
 155518896,
 128258,
 -1,
 155526624,
 128259,
 155844607,
 152662032,
 -1,
 155846988,
 155733711,
 -1,
 -63157,
 155805802,
 128235,
 -1,
 155864415,
 128234,
 -63155,
 155812001,
 127746,
 -63154,
 155995261,
 128272,
 -1,
 156047757,
 128213,
 156240210,
 152583053,
 -1,
 -63151,
 156197545,
 128203,
 -1,
 156259930,
 127867,
 156499967,
 156177352,
 -1,
 -63148,
 156385186,
 128079,
 -1,
 156445583,
 127916,
 156633468,
 152517517,
 -1,
 156699002,
 156592437,
 -1,
 156764537,
 156649823,
 -1,
 156830052,
 156718974,
 -1,
 156895581,
 156792575,
 -1,
 -63141,
 156862523,
 12873,
 -63140,
 156907787,
 12874,
 -1,
 156969571,
 12872,
 157157728,
 156856070,
 -1,
 -63137,
 157107089,
 12877,
 -1,
 157167058,
 12878,
 157354339,
 157101905,
 -1,
 -63134,
 157310452,
 12875,
 -1,
 157367630,
 12876,
 -1,
 157297067,
 12879,
 157616497,
 156777357,
 -1,
 157682030,
 157557374,
 -1,
 157747561,
 157631658,
 -1,
 -63128,
 157703848,
 12871,
 -1,
 157761277,
 12869,
 157944172,
 157683249,
 -1,
 -63125,
 157886116,
 127568,
 -1,
 157948942,
 127569,
 -63123,
 157904821,
 12870,
 -1,
 158099268,
 12868,
 158334975,
 157644737,
 -1,
 -63120,
 158230431,
 127276,
 -1,
 158276240,
 127275,
 158468468,
 157566707,
 -1,
 -63117,
 158418076,
 12925,
 -1,
 158473342,
 12924,
 158665079,
 158407312,
 -1,
 -63114,
 158625256,
 9938,
 -1,
 158671174,
 127277,
 -63112,
 158632707,
 127278,
 -1,
 158807813,
 12926,
 -1,
 156730142,
 127914,
 -63109,
 156663342,
 127750,
 -1,
 159012188,
 127910,
 159189391,
 156592031,
 -1,
 159254919,
 159143978,
 -1,
 159320453,
 159216853,
 -1,
 159385987,
 159262845,
 -1,
 -63103,
 159348404,
 9876,
 -63102,
 159405355,
 127370,
 -1,
 159461701,
 127884,
 -63100,
 159334331,
 9932,
 -1,
 159580922,
 10060,
 -63098,
 159287806,
 128081,
 -1,
 159719045,
 128010,
 159910284,
 159222728,
 -1,
 159975819,
 159858521,
 -1,
 -63094,
 159920049,
 128546,
 -1,
 159980467,
 128575,
 -1,
 159937856,
 128302,
 160301055,
 159852235,
 -1,
 -63090,
 160198570,
 127769,
 -1,
 160244629,
 128179,
 160497663,
 159131339,
 -1,
 -63087,
 160393836,
 9907,
 -1,
 160441049,
 8373,
 160632602,
 9931,
 -1,
 160697913,
 160577044,
 -1,
 160762388,
 160632369,
 -1,
 160827885,
 160696976,
 -1,
 160893349,
 160763042,
 -1,
 160958873,
 160828640,
 77877,
 -1,
 160894513,
 77878,
 161089947,
 160894010,
 77874,
 -1,
 161025585,
 77875,
 161221021,
 161024931,
 77872,
 -1,
 161156657,
 77873,
 161352095,
 161155728,
 77869,
 -1,
 161287729,
 77870,
 -63072,
 161287674,
 77882,
 -63071,
 161418694,
 77881,
 -63070,
 161484167,
 77880,
 -63069,
 161549645,
 77879,
 -63068,
 161615010,
 77876,
 -1,
 161680147,
 77871,
 161876402,
 160828179,
 -1,
 161941928,
 161811847,
 77844,
 -1,
 161877553,
 77845,
 162073002,
 161877154,
 77840,
 -1,
 162008625,
 77841,
 -63061,
 162008570,
 77847,
 -63060,
 162139590,
 77846,
 -63059,
 162205005,
 77843,
 -63058,
 162270432,
 77842,
 -63057,
 162335802,
 77839,
 -63056,
 162401187,
 77838,
 -63055,
 162466579,
 77837,
 -1,
 162531984,
 77836,
 162728383,
 161811088,
 -1,
 162793910,
 162663757,
 77830,
 -63051,
 162731790,
 77832,
 -1,
 162795057,
 77831,
 162990520,
 162729184,
 77828,
 -1,
 162926129,
 77829,
 -63047,
 162926074,
 77835,
 -63046,
 163057094,
 77834,
 -63045,
 163122567,
 77833,
 -63044,
 163187874,
 77827,
 -63043,
 163253306,
 77826,
 -63042,
 163318691,
 77825,
 -1,
 163384083,
 77824,
 163580363,
 162663482,
 -1,
 163645890,
 163515299,
 77860,
 -1,
 163581489,
 77861,
 -63037,
 163581434,
 77868,
 -63036,
 163712454,
 77867,
 -63035,
 163777927,
 77866,
 -63034,
 163843405,
 77865,
 -63033,
 163908832,
 77864,
 -63032,
 163974306,
 77863,
 -63031,
 164039738,
 77862,
 -63030,
 164104979,
 77859,
 -1,
 164170384,
 77858,
 164366806,
 163515725,
 -1,
 -63027,
 164302330,
 77902,
 -63026,
 164367814,
 77901,
 -63025,
 164433287,
 77900,
 -63024,
 164498765,
 77899,
 -63023,
 164564192,
 77898,
 -63022,
 164629666,
 77897,
 -63021,
 164695098,
 77896,
 -63020,
 164760483,
 77895,
 -63019,
 164825875,
 77894,
 -1,
 164891280,
 77893,
 165087713,
 164302048,
 -1,
 -63016,
 165023226,
 77892,
 -63015,
 165088710,
 77891,
 -63014,
 165154183,
 77890,
 -63013,
 165219661,
 77889,
 -63012,
 165285088,
 77888,
 -63011,
 165350562,
 77887,
 -63010,
 165415994,
 77886,
 -63009,
 165481379,
 77885,
 -63008,
 165546771,
 77884,
 -1,
 165612176,
 77883,
 165808620,
 165022627,
 -1,
 -63005,
 165744122,
 77857,
 -63004,
 165809606,
 77856,
 -63003,
 165875079,
 77855,
 -63002,
 165940557,
 77854,
 -63001,
 166005984,
 77853,
 -63000,
 166071458,
 77852,
 -62999,
 166136890,
 77851,
 -62998,
 166202275,
 77850,
 -62997,
 166267667,
 77849,
 -1,
 166333072,
 77848,
 -1,
 165744057,
 77903,
 166658047,
 160763549,
 -1,
 166660602,
 166529680,
 -1,
 166726130,
 166595975,
 78867,
 -62991,
 166663950,
 78869,
 -1,
 166727217,
 78868,
 -62989,
 166661626,
 78871,
 -62988,
 166858182,
 78870,
 -62987,
 166923597,
 78866,
 -62986,
 166989024,
 78865,
 -62985,
 167054498,
 78864,
 -62984,
 167119930,
 78863,
 -62983,
 167185315,
 78862,
 -1,
 167250707,
 78861,
 167447045,
 166595491,
 -1,
 -62980,
 167382522,
 78891,
 -62979,
 167448006,
 78890,
 -62978,
 167513479,
 78889,
 -62977,
 167578957,
 78888,
 -62976,
 167644384,
 78887,
 -62975,
 167709858,
 78886,
 -62974,
 167775290,
 78885,
 -62973,
 167840675,
 78884,
 -62972,
 167906067,
 78883,
 -1,
 167971472,
 78882,
 168167952,
 167381779,
 -1,
 -62969,
 168103418,
 78881,
 -62968,
 168168902,
 78880,
 -62967,
 168234375,
 78879,
 -62966,
 168299853,
 78878,
 -62965,
 168365280,
 78877,
 -62964,
 168430754,
 78876,
 -62963,
 168496186,
 78875,
 -62962,
 168561571,
 78874,
 -62961,
 168626963,
 78873,
 -1,
 168692368,
 78872,
 168951807,
 168102970,
 -1,
 -62958,
 168823715,
 78894,
 -62957,
 168889107,
 78893,
 -1,
 168954512,
 78892,
 169151107,
 160715772,
 -1,
 169216588,
 169085584,
 -1,
 169282085,
 169151546,
 -1,
 169347609,
 169217415,
 78361,
 -1,
 169283121,
 78362,
 169478683,
 169282784,
 78358,
 -1,
 169414193,
 78359,
 169609757,
 169413794,
 78356,
 -1,
 169545265,
 78357,
 169740831,
 169544762,
 78354,
 -1,
 169676337,
 78355,
 -62944,
 169676282,
 78364,
 -62943,
 169807302,
 78363,
 -62942,
 169872717,
 78360,
 -62941,
 169937827,
 78353,
 -62940,
 170003219,
 78352,
 -1,
 170068624,
 78351,
 170265138,
 169216787,
 -1,
 170330665,
 170200518,
 78336,
 -62936,
 170268430,
 78338,
 -1,
 170331697,
 78337,
 -62934,
 170266106,
 78339,
 -62933,
 170462599,
 78335,
 -62932,
 170528077,
 78334,
 -62931,
 170593504,
 78333,
 -62930,
 170658978,
 78332,
 -62929,
 170724410,
 78331,
 -62928,
 170789795,
 78330,
 -62927,
 170855187,
 78329,
 -1,
 170920592,
 78328,
 171117118,
 170199971,
 -1,
 171182645,
 171052256,
 78345,
 -1,
 171118129,
 78346,
 -62922,
 171118074,
 78350,
 -62921,
 171249094,
 78349,
 -62920,
 171314567,
 78348,
 -62919,
 171380045,
 78347,
 -62918,
 171445410,
 78344,
 -62917,
 171510842,
 78343,
 -62916,
 171576227,
 78342,
 -62915,
 171641619,
 78341,
 -1,
 171707024,
 78340,
 171903560,
 171051664,
 -1,
 -62912,
 171838970,
 78327,
 -62911,
 171904454,
 78326,
 -62910,
 171969927,
 78325,
 -62909,
 172035405,
 78324,
 -62908,
 172100832,
 78323,
 -62907,
 172166306,
 78322,
 -62906,
 172231738,
 78321,
 -62905,
 172297123,
 78320,
 -1,
 172362515,
 78319,
 172621823,
 171838626,
 -1,
 -62902,
 172493731,
 78367,
 -62901,
 172559123,
 78366,
 -1,
 172624528,
 78365,
 172821098,
 169180827,
 -1,
 172886619,
 172755731,
 -1,
 172952144,
 172821958,
 78409,
 -1,
 172887601,
 78410,
 173083218,
 172886803,
 78401,
 -1,
 173018673,
 78402,
 173214292,
 173017744,
 78399,
 -1,
 173149745,
 78400,
 -62891,
 173149690,
 78411,
 -62890,
 173280647,
 78408,
 -62889,
 173346125,
 78407,
 -62888,
 173411552,
 78406,
 -62887,
 173477026,
 78405,
 -62886,
 173542458,
 78404,
 -1,
 173607843,
 78403,
 173804133,
 172821136,
 -1,
 -62883,
 173739514,
 78398,
 -62882,
 173804998,
 78397,
 -62881,
 173870471,
 78396,
 -62880,
 173935949,
 78395,
 -62879,
 174001376,
 78394,
 -62878,
 174066850,
 78393,
 -62877,
 174132282,
 78392,
 -62876,
 174197667,
 78391,
 -1,
 174263059,
 78390,
 174522367,
 173738915,
 -1,
 174525032,
 174394275,
 78414,
 -1,
 174460465,
 78415,
 -62871,
 174459667,
 78413,
 -1,
 174590608,
 78412,
 174850047,
 172771217,
 -1,
 174852727,
 174721811,
 -1,
 174918254,
 174787975,
 78385,
 -1,
 174853681,
 78386,
 -62865,
 174853626,
 78388,
 -62864,
 174984646,
 78387,
 -62863,
 175050061,
 78384,
 -62862,
 175115488,
 78383,
 -62861,
 175180962,
 78382,
 -62860,
 175246394,
 78381,
 -62859,
 175311779,
 78380,
 -62858,
 175377171,
 78379,
 -1,
 175442576,
 78378,
 175639170,
 174787216,
 -1,
 175704698,
 175574240,
 78372,
 -1,
 175640113,
 78373,
 -62853,
 175640058,
 78377,
 -62852,
 175771078,
 78376,
 -62851,
 175836551,
 78375,
 -62850,
 175902029,
 78374,
 -62849,
 175967394,
 78371,
 -62848,
 176032826,
 78370,
 -62847,
 176098211,
 78369,
 -1,
 176163603,
 78368,
 -1,
 175574041,
 78389,
 176425703,
 169091479,
 -1,
 176491162,
 176360672,
 -1,
 176556687,
 176425616,
 77997,
 -62841,
 176503693,
 78006,
 -62840,
 176567863,
 78005,
 -62839,
 176632504,
 78004,
 -62838,
 176697169,
 78003,
 -62837,
 176760523,
 78002,
 -62836,
 176824646,
 78001,
 -62835,
 176888464,
 78000,
 -62834,
 176953102,
 77999,
 -1,
 177016369,
 77998,
 177212049,
 176491682,
 78011,
 -1,
 177147441,
 78012,
 177343123,
 177146787,
 78008,
 -1,
 177278513,
 78009,
 -62828,
 177278458,
 78017,
 -62827,
 177409478,
 78016,
 -62826,
 177474951,
 78015,
 -62825,
 177540429,
 78014,
 -62824,
 177605856,
 78013,
 -62823,
 177671226,
 78010,
 -1,
 177736467,
 78007,
 177932971,
 176426317,
 -1,
 177998500,
 177868167,
 78025,
 -62819,
 177944119,
 78033,
 -62818,
 178008760,
 78032,
 -62817,
 178073425,
 78031,
 -62816,
 178136779,
 78030,
 -62815,
 178200902,
 78029,
 -62814,
 178264720,
 78028,
 -62813,
 178329358,
 78027,
 -1,
 178392625,
 78026,
 -62811,
 177933645,
 78024,
 -62810,
 178523360,
 78023,
 -62809,
 178588834,
 78022,
 -62808,
 178654266,
 78021,
 -62807,
 178719651,
 78020,
 -62806,
 178785043,
 78019,
 -1,
 178850448,
 78018,
 179047096,
 177867938,
 -1,
 179112622,
 178982342,
 77994,
 -1,
 179047985,
 77995,
 179243696,
 179047757,
 77991,
 -1,
 179179057,
 77992,
 -62799,
 179179002,
 77996,
 -62798,
 179309959,
 77993,
 -62797,
 179375328,
 77990,
 -62796,
 179440802,
 77989,
 -62795,
 179506234,
 77988,
 -62794,
 179571619,
 77987,
 -62793,
 179637011,
 77986,
 -1,
 179702416,
 77985,
 179899077,
 178981946,
 -1,
 179964603,
 179834018,
 77978,
 -1,
 179899953,
 77979,
 180095677,
 179899155,
 77974,
 -1,
 180031025,
 77975,
 -62786,
 180030970,
 77984,
 -62785,
 180161990,
 77983,
 -62784,
 180227463,
 77982,
 -62783,
 180292941,
 77981,
 -62782,
 180358368,
 77980,
 -62781,
 180423738,
 77977,
 -62780,
 180489123,
 77976,
 -1,
 180554384,
 77973,
 180751057,
 179833763,
 -1,
 180816584,
 180686215,
 77969,
 -1,
 180751921,
 77970,
 -62775,
 180751866,
 77972,
 -62774,
 180882886,
 77971,
 -62773,
 180948301,
 77968,
 -62772,
 181013728,
 77967,
 -62771,
 181079202,
 77966,
 -62770,
 181144634,
 77965,
 -62769,
 181210019,
 77964,
 -62768,
 181275411,
 77963,
 -1,
 181340816,
 77962,
 181537500,
 180685587,
 -1,
 -62765,
 181472762,
 77961,
 -62764,
 181538246,
 77960,
 -62763,
 181603719,
 77959,
 -62762,
 181669197,
 77958,
 -62761,
 181734624,
 77957,
 -62760,
 181800098,
 77956,
 -62759,
 181865530,
 77955,
 -62758,
 181930915,
 77954,
 -62757,
 181996307,
 77953,
 -1,
 182061712,
 77952,
 182321151,
 181471888,
 -1,
 182323935,
 182193606,
 77949,
 -1,
 182259249,
 77950,
 -62752,
 182259194,
 77951,
 -62751,
 182390151,
 77948,
 -62750,
 182455629,
 77947,
 -62749,
 182521056,
 77946,
 -62748,
 182586530,
 77945,
 -62747,
 182651962,
 77944,
 -62746,
 182717347,
 77943,
 -1,
 182782739,
 77942,
 182979385,
 176391105,
 -1,
 183044866,
 182913955,
 -1,
 183110390,
 182979216,
 78726,
 -62741,
 183060333,
 78738,
 -62740,
 183125162,
 78737,
 -62739,
 183190470,
 78736,
 -62738,
 183253901,
 78735,
 -62737,
 183318071,
 78734,
 -62736,
 183382712,
 78733,
 -62735,
 183447377,
 78732,
 -62734,
 183510731,
 78731,
 -62733,
 183574854,
 78730,
 -62732,
 183638672,
 78729,
 -62731,
 183703310,
 78728,
 -1,
 183766577,
 78727,
 183962360,
 183045626,
 78749,
 -1,
 183897649,
 78750,
 184093434,
 183897542,
 78747,
 -1,
 184028721,
 78748,
 184224508,
 184028218,
 78741,
 -1,
 184159793,
 78742,
 -62723,
 184159623,
 78746,
 -62722,
 184290637,
 78745,
 -62721,
 184356064,
 78744,
 -62720,
 184421538,
 78743,
 -62719,
 184486819,
 78740,
 -1,
 184552211,
 78739,
 184748824,
 182979216,
 -1,
 184814349,
 184683283,
 78690,
 -62715,
 184761229,
 78699,
 -62714,
 184825399,
 78698,
 -62713,
 184890040,
 78697,
 -62712,
 184954705,
 78696,
 -62711,
 185018059,
 78695,
 -62710,
 185082182,
 78694,
 -62709,
 185146000,
 78693,
 -62708,
 185210638,
 78692,
 -1,
 185273905,
 78691,
 185469712,
 184749447,
 78706,
 -62705,
 185407246,
 78708,
 -1,
 185470513,
 78707,
 185666322,
 185404323,
 78700,
 -1,
 185601585,
 78701,
 -62701,
 185601530,
 78710,
 -62700,
 185732550,
 78709,
 -62699,
 185797965,
 78705,
 -62698,
 185863392,
 78704,
 -62697,
 185928866,
 78703,
 -1,
 185994298,
 78702,
 186190632,
 184683283,
 -1,
 186256157,
 186125075,
 78712,
 -62693,
 186194576,
 78715,
 -62692,
 186259214,
 78714,
 -1,
 186322481,
 78713,
 186518304,
 186190755,
 78716,
 -62689,
 186455822,
 78718,
 -1,
 186519089,
 78717,
 -62687,
 186453498,
 78725,
 -62686,
 186650054,
 78724,
 -62685,
 186715527,
 78723,
 -62684,
 186781005,
 78722,
 -62683,
 186846432,
 78721,
 -62682,
 186911906,
 78720,
 -62681,
 186977338,
 78719,
 -1,
 187042448,
 78711,
 187239223,
 186125370,
 -1,
 187304747,
 187174279,
 78761,
 -1,
 187239985,
 78762,
 187435821,
 187239482,
 78756,
 -1,
 187371057,
 78757,
 187566895,
 187370259,
 78753,
 -1,
 187502129,
 78754,
 187697969,
 187501200,
 78751,
 -1,
 187633201,
 78752,
 -62670,
 187633146,
 78764,
 -62669,
 187764166,
 78763,
 -62668,
 187829581,
 78760,
 -62667,
 187895008,
 78759,
 -62666,
 187960482,
 78758,
 -1,
 188025763,
 78755,
 188284927,
 187174100,
 78765,
 -1,
 188157489,
 78766,
 188353419,
 182933586,
 -1,
 188418892,
 188287632,
 -1,
 188484418,
 188353869,
 78423,
 -62659,
 188428113,
 78429,
 -62658,
 188491467,
 78428,
 -62657,
 188555590,
 78427,
 -62656,
 188619408,
 78426,
 -62655,
 188684046,
 78425,
 -1,
 188747313,
 78424,
 188943172,
 188419296,
 78421,
 -1,
 188878385,
 78422,
 189074246,
 188877587,
 78416,
 -1,
 189009457,
 78417,
 -62649,
 189009402,
 78432,
 -62648,
 189140422,
 78431,
 -62647,
 189205895,
 78430,
 -62646,
 189271202,
 78420,
 -62645,
 189336634,
 78419,
 -1,
 189402019,
 78418,
 189598557,
 188353594,
 -1,
 189664082,
 189533517,
 78469,
 -62641,
 189604166,
 78473,
 -62640,
 189667984,
 78472,
 -62639,
 189732622,
 78471,
 -1,
 189795889,
 78470,
 189991764,
 189598778,
 78465,
 -1,
 189926961,
 78466,
 190122838,
 189926032,
 78461,
 -1,
 190058033,
 78462,
 -62633,
 190057978,
 78476,
 -62632,
 190188998,
 78475,
 -62631,
 190254471,
 78474,
 -62630,
 190319840,
 78468,
 -62629,
 190385314,
 78467,
 -62628,
 190450595,
 78464,
 -1,
 190515987,
 78463,
 190712684,
 189533091,
 -1,
 190778208,
 190647802,
 78459,
 -1,
 190713393,
 78460,
 190909282,
 190713056,
 78454,
 -1,
 190844465,
 78455,
 191040356,
 190844066,
 78452,
 -1,
 190975537,
 78453,
 191171430,
 190974608,
 78447,
 -1,
 191106609,
 78448,
 -62617,
 191106502,
 78458,
 -62616,
 191237511,
 78457,
 -62615,
 191302989,
 78456,
 -62614,
 191368250,
 78451,
 -62613,
 191433635,
 78450,
 -1,
 191499027,
 78449,
 191695739,
 190647059,
 -1,
 191761265,
 191629968,
 78433,
 -62609,
 191699600,
 78436,
 -62608,
 191764238,
 78435,
 -1,
 191827505,
 78434,
 192023411,
 191696378,
 78445,
 -1,
 191958577,
 78446,
 -62604,
 191958470,
 78444,
 -62603,
 192089479,
 78443,
 -62602,
 192154957,
 78442,
 -62601,
 192220384,
 78441,
 -62600,
 192285858,
 78440,
 -62599,
 192351290,
 78439,
 -62598,
 192416675,
 78438,
 -1,
 192482067,
 78437,
 192678790,
 191630498,
 -1,
 -62595,
 192613882,
 78486,
 -62594,
 192679366,
 78485,
 -62593,
 192744839,
 78484,
 -62592,
 192810317,
 78483,
 -62591,
 192875744,
 78482,
 -62590,
 192941218,
 78481,
 -62589,
 193006650,
 78480,
 -62588,
 193072035,
 78479,
 -62587,
 193137427,
 78478,
 -1,
 193202832,
 78477,
 193462271,
 192613600,
 -1,
 193465226,
 193333904,
 78487,
 -62583,
 193402638,
 78489,
 -1,
 193465905,
 78488,
 -1,
 193399571,
 78490,
 193727443,
 188305010,
 -1,
 193792931,
 193661715,
 -1,
 193858454,
 193727395,
 78268,
 -62577,
 193803831,
 78276,
 -62576,
 193868472,
 78275,
 -62575,
 193933137,
 78274,
 -62574,
 193996491,
 78273,
 -62573,
 194060614,
 78272,
 -62572,
 194124432,
 78271,
 -62571,
 194189070,
 78270,
 -1,
 194252337,
 78269,
 194448280,
 193793415,
 78283,
 -1,
 194383409,
 78284,
 194579354,
 194383181,
 78281,
 -1,
 194514481,
 78282,
 194710428,
 194514144,
 78279,
 -1,
 194645553,
 78280,
 194841502,
 194644624,
 78265,
 -1,
 194776625,
 78266,
 -62561,
 194776570,
 78286,
 -62560,
 194907590,
 78285,
 -62559,
 194972834,
 78278,
 -62558,
 195038266,
 78277,
 -1,
 195103507,
 78267,
 195300273,
 193727546,
 -1,
 195365799,
 195234874,
 78304,
 -62554,
 195303182,
 78306,
 -1,
 195366449,
 78305,
 195562409,
 195300115,
 78301,
 -1,
 195497521,
 78302,
 -62550,
 195497466,
 78312,
 -62549,
 195628486,
 78311,
 -62548,
 195693959,
 78310,
 -62547,
 195759437,
 78309,
 -62546,
 195824864,
 78308,
 -62545,
 195890338,
 78307,
 -62544,
 195955619,
 78303,
 -1,
 196020880,
 78300,
 196217791,
 195234723,
 -1,
 196283316,
 196152774,
 78297,
 -1,
 196218417,
 78298,
 196414390,
 196218018,
 78292,
 -1,
 196349489,
 78293,
 196545464,
 196348835,
 78289,
 -1,
 196480561,
 78290,
 -62535,
 196480506,
 78299,
 -62534,
 196611463,
 78296,
 -62533,
 196676941,
 78295,
 -62532,
 196742368,
 78294,
 -62531,
 196807738,
 78291,
 -62530,
 196872979,
 78288,
 -1,
 196938384,
 78287,
 197135308,
 196151952,
 -1,
 197200835,
 197069587,
 78253,
 -62526,
 197138190,
 78255,
 -1,
 197201457,
 78254,
 197397445,
 197135418,
 78257,
 -1,
 197332529,
 78258,
 -62522,
 197332474,
 78264,
 -62521,
 197463494,
 78263,
 -62520,
 197528967,
 78262,
 -62519,
 197594445,
 78261,
 -62518,
 197659872,
 78260,
 -62517,
 197725346,
 78259,
 -1,
 197790627,
 78256,
 198049791,
 197069986,
 -1,
 198052815,
 197921424,
 78313,
 -1,
 197987889,
 78314,
 -62512,
 197987490,
 78318,
 -62511,
 198118458,
 78317,
 -62510,
 198183843,
 78316,
 -1,
 198249235,
 78315,
 198446107,
 193671072,
 -1,
 198511586,
 198380706,
 -1,
 198577111,
 198446471,
 78132,
 -1,
 198512177,
 78133,
 198708185,
 198511949,
 78130,
 -1,
 198643249,
 78131,
 198839259,
 198642912,
 78128,
 -1,
 198774321,
 78129,
 -62500,
 198774266,
 78135,
 -62499,
 198905286,
 78134,
 -62498,
 198970530,
 78127,
 -62497,
 199035962,
 78126,
 -62496,
 199101347,
 78125,
 -62495,
 199166739,
 78124,
 -1,
 199232144,
 78123,
 199429104,
 198446138,
 -1,
 199494629,
 199364038,
 78120,
 -1,
 199429681,
 78121,
 199625703,
 199429511,
 78118,
 -1,
 199560753,
 78119,
 199756777,
 199559955,
 78111,
 -1,
 199691825,
 78112,
 -62486,
 199691770,
 78122,
 -62485,
 199822669,
 78117,
 -62484,
 199888096,
 78116,
 -62483,
 199953570,
 78115,
 -62482,
 200019002,
 78114,
 -62481,
 200084387,
 78113,
 -1,
 200149648,
 78110,
 200346620,
 199363491,
 -1,
 200412147,
 200280851,
 78100,
 -1,
 200347185,
 78101,
 -62476,
 200347130,
 78109,
 -62475,
 200478150,
 78108,
 -62474,
 200543623,
 78107,
 -62473,
 200609101,
 78106,
 -62472,
 200674528,
 78105,
 -62471,
 200740002,
 78104,
 -62470,
 200805434,
 78103,
 -62469,
 200870819,
 78102,
 -1,
 200936080,
 78099,
 201133064,
 200280851,
 -1,
 201198591,
 201067578,
 78091,
 -1,
 201133617,
 78092,
 -62464,
 201133562,
 78098,
 -62463,
 201264582,
 78097,
 -62462,
 201330055,
 78096,
 -62461,
 201395533,
 78095,
 -62460,
 201460960,
 78094,
 -62459,
 201526434,
 78093,
 -62458,
 201591715,
 78090,
 -62457,
 201657107,
 78089,
 -1,
 201722512,
 78088,
 201919507,
 201067152,
 -1,
 201985035,
 201853715,
 78078,
 -1,
 201920049,
 78079,
 -62452,
 201919994,
 78087,
 -62451,
 202051014,
 78086,
 -62450,
 202116487,
 78085,
 -62449,
 202181965,
 78084,
 -62448,
 202247392,
 78083,
 -62447,
 202312866,
 78082,
 -62446,
 202378298,
 78081,
 -1,
 202443683,
 78080,
 202702847,
 201854176,
 -1,
 202705944,
 202574611,
 78137,
 -62442,
 202644112,
 78140,
 -62441,
 202708750,
 78139,
 -1,
 202772017,
 78138,
 -62439,
 202640442,
 78142,
 -62438,
 202902435,
 78141,
 -1,
 202967696,
 78136,
 203164770,
 198390494,
 -1,
 203230249,
 203099298,
 -1,
 203295775,
 203164896,
 78196,
 -1,
 203230769,
 78197,
 203426849,
 203230266,
 78193,
 -1,
 203361841,
 78194,
 -62430,
 203361786,
 78201,
 -62429,
 203492806,
 78200,
 -62428,
 203558279,
 78199,
 -62427,
 203623757,
 78198,
 -62426,
 203689122,
 78195,
 -62425,
 203754403,
 78192,
 -62424,
 203819795,
 78191,
 -1,
 203885200,
 78190,
 204082230,
 203164730,
 -1,
 204147756,
 204017031,
 78186,
 -1,
 204082737,
 78187,
 204278830,
 204082509,
 78184,
 -1,
 204213809,
 78185,
 -62417,
 204213754,
 78189,
 -62416,
 204344774,
 78188,
 -62415,
 204410080,
 78183,
 -62414,
 204475554,
 78182,
 -62413,
 204540986,
 78181,
 -62412,
 204606371,
 78180,
 -62411,
 204671763,
 78179,
 -1,
 204737168,
 78178,
 204934211,
 204016547,
 -1,
 204999737,
 204868941,
 78173,
 -1,
 204934705,
 78174,
 205130811,
 204933776,
 78166,
 -1,
 205065777,
 78167,
 -62404,
 205065722,
 78177,
 -62403,
 205196742,
 78176,
 -62402,
 205262215,
 78175,
 -62401,
 205327584,
 78172,
 -62400,
 205393058,
 78171,
 -62399,
 205458490,
 78170,
 -62398,
 205523875,
 78169,
 -1,
 205589267,
 78168,
 205786192,
 204868240,
 -1,
 205851719,
 205720967,
 78150,
 -62394,
 205788942,
 78152,
 -1,
 205852209,
 78151,
 206048329,
 205786445,
 78148,
 -1,
 205983281,
 78149,
 -62390,
 205983226,
 78154,
 -62389,
 206114246,
 78153,
 -62388,
 206179552,
 78147,
 -62387,
 206245026,
 78146,
 -62386,
 206310458,
 78145,
 -62385,
 206375843,
 78144,
 -1,
 206441235,
 78143,
 206638172,
 205720339,
 -1,
 206703699,
 206572307,
 78156,
 -1,
 206638641,
 78157,
 -62380,
 206638586,
 78165,
 -62379,
 206769606,
 78164,
 -62378,
 206835079,
 78163,
 -62377,
 206900557,
 78162,
 -62376,
 206965984,
 78161,
 -62375,
 207031458,
 78160,
 -62374,
 207096890,
 78159,
 -62373,
 207162275,
 78158,
 -1,
 207227536,
 78155,
 207486975,
 206572768,
 -1,
 -62370,
 207359138,
 78206,
 -62369,
 207424570,
 78205,
 -62368,
 207489955,
 78204,
 -62367,
 207555347,
 78203,
 -1,
 207620752,
 78202,
 207817886,
 203124567,
 -1,
 207883377,
 207751955,
 -1,
 207948903,
 207817890,
 78560,
 -62362,
 207886094,
 78562,
 -1,
 207949361,
 78561,
 208145513,
 207883655,
 78565,
 -1,
 208080433,
 78566,
 -62358,
 208080378,
 78568,
 -62357,
 208211398,
 78567,
 -62356,
 208276813,
 78564,
 -62355,
 208342240,
 78563,
 -62354,
 208407610,
 78559,
 -62353,
 208472995,
 78558,
 -62352,
 208538387,
 78557,
 -1,
 208603792,
 78556,
 208800894,
 207817635,
 -1,
 208866421,
 208735565,
 78575,
 -62348,
 208803598,
 78577,
 -1,
 208866865,
 78576,
 -62346,
 208801274,
 78580,
 -62345,
 208997830,
 78579,
 -62344,
 209063303,
 78578,
 -62343,
 209128672,
 78574,
 -62342,
 209194146,
 78573,
 -62341,
 209259578,
 78572,
 -62340,
 209324963,
 78571,
 -62339,
 209390355,
 78570,
 -1,
 209455760,
 78569,
 209652874,
 208735290,
 -1,
 209718401,
 209587424,
 78586,
 -1,
 209653297,
 78587,
 -62334,
 209653242,
 78591,
 -62333,
 209784262,
 78590,
 -62332,
 209849735,
 78589,
 -62331,
 209915213,
 78588,
 -62330,
 209980578,
 78585,
 -62329,
 210046010,
 78584,
 -62328,
 210111395,
 78583,
 -62327,
 210176787,
 78582,
 -1,
 210242192,
 78581,
 210439318,
 209586832,
 -1,
 210504845,
 210373965,
 78551,
 -1,
 210439729,
 78552,
 210635919,
 210439075,
 78546,
 -1,
 210570801,
 78547,
 -62320,
 210570746,
 78555,
 -62319,
 210701766,
 78554,
 -62318,
 210767239,
 78553,
 -62317,
 210832608,
 78550,
 -62316,
 210898082,
 78549,
 -62315,
 210963514,
 78548,
 -1,
 211028755,
 78545,
 211288063,
 210373794,
 -1,
 -62312,
 211160397,
 78598,
 -62311,
 211225824,
 78597,
 -62310,
 211291298,
 78596,
 -62309,
 211356730,
 78595,
 -62308,
 211422115,
 78594,
 -62307,
 211487507,
 78593,
 -1,
 211552912,
 78592,
 211750099,
 207781531,
 -1,
 211815596,
 211684259,
 -1,
 211881122,
 211750394,
 78674,
 -1,
 211815985,
 78675,
 212012196,
 211815482,
 78667,
 -1,
 211947057,
 78668,
 -62299,
 211946950,
 78673,
 -62298,
 212077959,
 78672,
 -62297,
 212143437,
 78671,
 -62296,
 212208864,
 78670,
 -62295,
 212274338,
 78669,
 -62294,
 212339619,
 78666,
 -62293,
 212405011,
 78665,
 -1,
 212470416,
 78664,
 212667576,
 211749946,
 -1,
 212733103,
 212601763,
 78678,
 -1,
 212667953,
 78679,
 -62288,
 212667898,
 78686,
 -62287,
 212798918,
 78685,
 -62286,
 212864391,
 78684,
 -62285,
 212929869,
 78683,
 -62284,
 212995296,
 78682,
 -62283,
 213060770,
 78681,
 -62282,
 213126202,
 78680,
 -62281,
 213191443,
 78677,
 -1,
 213256848,
 78676,
 213454020,
 212601488,
 -1,
 213519548,
 213388621,
 78648,
 -62277,
 213456654,
 78650,
 -1,
 213519921,
 78649,
 -62275,
 213454330,
 78653,
 -62274,
 213650886,
 78652,
 -62273,
 213716359,
 78651,
 -62272,
 213781728,
 78647,
 -62271,
 213847202,
 78646,
 -62270,
 213912634,
 78645,
 -62269,
 213978019,
 78644,
 -1,
 214043411,
 78643,
 214240463,
 213388051,
 -1,
 -62266,
 214175226,
 78663,
 -62265,
 214240710,
 78662,
 -62264,
 214306183,
 78661,
 -62263,
 214371661,
 78660,
 -62262,
 214437088,
 78659,
 -62261,
 214502562,
 78658,
 -62260,
 214567994,
 78657,
 -62259,
 214633379,
 78656,
 -62258,
 214698771,
 78655,
 -1,
 214764176,
 78654,
 215023615,
 214174882,
 -1,
 -62255,
 214895523,
 78689,
 -62254,
 214960915,
 78688,
 -1,
 215026320,
 78687,
 215223556,
 211711822,
 -1,
 215289058,
 215157392,
 -1,
 215354583,
 215223802,
 78610,
 -1,
 215289393,
 78611,
 215485657,
 215289286,
 78608,
 -1,
 215420465,
 78609,
 215616731,
 215420295,
 78606,
 -1,
 215551537,
 78607,
 215747805,
 215551034,
 78601,
 -1,
 215682609,
 78602,
 -62242,
 215682381,
 78605,
 -62241,
 215813344,
 78604,
 -62240,
 215878818,
 78603,
 -62239,
 215944099,
 78600,
 -1,
 216009491,
 78599,
 216206575,
 215223059,
 -1,
 216272101,
 216141133,
 78619,
 -1,
 216206897,
 78620,
 216403175,
 216206099,
 78613,
 -1,
 216337969,
 78614,
 -62232,
 216337914,
 78623,
 -62231,
 216468934,
 78622,
 -62230,
 216534407,
 78621,
 -62229,
 216599776,
 78618,
 -62228,
 216665250,
 78617,
 -62227,
 216730682,
 78616,
 -62226,
 216796067,
 78615,
 -1,
 216861328,
 78612,
 217058554,
 216140707,
 -1,
 -62223,
 216993274,
 78633,
 -62222,
 217058758,
 78632,
 -62221,
 217124231,
 78631,
 -62220,
 217189709,
 78630,
 -62219,
 217255136,
 78629,
 -62218,
 217320610,
 78628,
 -62217,
 217386042,
 78627,
 -62216,
 217451427,
 78626,
 -62215,
 217516819,
 78625,
 -1,
 217582224,
 78624,
 217841663,
 216992826,
 -1,
 217844989,
 217713722,
 78638,
 -1,
 217779761,
 78639,
 217976063,
 217779107,
 78636,
 -1,
 217910833,
 78637,
 -62208,
 217910605,
 78642,
 -62207,
 218041568,
 78641,
 -62206,
 218107042,
 78640,
 -62205,
 218172179,
 78635,
 -1,
 218237584,
 78634,
 218434869,
 215164853,
 -1,
 218500370,
 218368931,
 -1,
 218565896,
 218435014,
 78066,
 -1,
 218500657,
 78067,
 218696970,
 218499728,
 78057,
 -1,
 218631729,
 78058,
 -62197,
 218631674,
 78068,
 -62196,
 218762631,
 78065,
 -62195,
 218828109,
 78064,
 -62194,
 218893536,
 78063,
 -62193,
 218959010,
 78062,
 -62192,
 219024442,
 78061,
 -62191,
 219089827,
 78060,
 -1,
 219155219,
 78059,
 219352351,
 218434323,
 -1,
 219417877,
 219286919,
 78053,
 -1,
 219352625,
 78054,
 219548951,
 219352397,
 78051,
 -1,
 219483697,
 78052,
 -62184,
 219483642,
 78056,
 -62183,
 219614662,
 78055,
 -62182,
 219679968,
 78050,
 -62181,
 219745442,
 78049,
 -62180,
 219810874,
 78048,
 -62179,
 219876259,
 78047,
 -62178,
 219941651,
 78046,
 -1,
 220007056,
 78045,
 220204331,
 219286160,
 -1,
 220269858,
 220139002,
 78043,
 -1,
 220204593,
 78044,
 220400932,
 220204486,
 78041,
 -1,
 220335665,
 78042,
 -62171,
 220335495,
 78040,
 -62170,
 220466509,
 78039,
 -62169,
 220531936,
 78038,
 -62168,
 220597410,
 78037,
 -62167,
 220662842,
 78036,
 -62166,
 220728227,
 78035,
 -1,
 220793619,
 78034,
 221052927,
 220138554,
 -1,
 221056302,
 220925090,
 78073,
 -1,
 220991025,
 78074,
 -62161,
 220990918,
 78077,
 -62160,
 221121927,
 78076,
 -62159,
 221187405,
 78075,
 -62158,
 221252666,
 78072,
 -62157,
 221318051,
 78071,
 -62156,
 221383443,
 78070,
 -1,
 221448848,
 78069,
 221646177,
 218402299,
 -1,
 221711695,
 221580051,
 -1,
 221777217,
 221646048,
 78842,
 -62151,
 221723533,
 78851,
 -62150,
 221787703,
 78850,
 -62149,
 221852344,
 78849,
 -62148,
 221917009,
 78848,
 -62147,
 221980363,
 78847,
 -62146,
 222044486,
 78846,
 -62145,
 222108304,
 78845,
 -62144,
 222172942,
 78844,
 -1,
 222236209,
 78843,
 222432586,
 221711693,
 78852,
 -62141,
 222377527,
 78860,
 -62140,
 222442168,
 78859,
 -62139,
 222506833,
 78858,
 -62138,
 222570187,
 78857,
 -62137,
 222634310,
 78856,
 -62136,
 222698128,
 78855,
 -62135,
 222762766,
 78854,
 -1,
 222826033,
 78853,
 -62133,
 222366882,
 78841,
 -62132,
 222956602,
 78840,
 -62131,
 223021987,
 78839,
 -62130,
 223087379,
 78838,
 -1,
 223152784,
 78837,
 223412223,
 221645456,
 -1,
 223415637,
 223284131,
 78821,
 -62126,
 223355206,
 78825,
 -62125,
 223419024,
 78824,
 -62124,
 223483662,
 78823,
 -1,
 223546929,
 78822,
 223743320,
 223349818,
 78826,
 -62121,
 223680270,
 78828,
 -1,
 223743537,
 78827,
 223939930,
 223677664,
 78831,
 -1,
 223874609,
 78832,
 224071004,
 223874210,
 78829,
 -1,
 224005681,
 78830,
 -62115,
 224005626,
 78836,
 -62114,
 224136646,
 78835,
 -62113,
 224202119,
 78834,
 -62112,
 224267597,
 78833,
 -1,
 224332563,
 78820,
 224529799,
 221603817,
 -1,
 224595311,
 224463635,
 -1,
 224660837,
 224529741,
 78530,
 -1,
 224595505,
 78531,
 224791911,
 224594576,
 78523,
 -1,
 224726577,
 78524,
 -62104,
 224726522,
 78534,
 -62103,
 224857542,
 78533,
 -62102,
 224923015,
 78532,
 -62101,
 224988384,
 78529,
 -62100,
 225053858,
 78528,
 -62099,
 225119290,
 78527,
 -62098,
 225184675,
 78526,
 -1,
 225250067,
 78525,
 225447292,
 224529040,
 -1,
 225512819,
 225381434,
 78514,
 -62094,
 225449742,
 78516,
 -1,
 225513009,
 78515,
 225709429,
 225446819,
 78512,
 -1,
 225644081,
 78513,
 -62090,
 225644026,
 78522,
 -62089,
 225775046,
 78521,
 -62088,
 225840519,
 78520,
 -62087,
 225905997,
 78519,
 -62086,
 225971424,
 78518,
 -62085,
 226036898,
 78517,
 -1,
 226102035,
 78511,
 226361343,
 225381283,
 -1,
 -62082,
 226233850,
 78544,
 -62081,
 226299334,
 78543,
 -62080,
 226364807,
 78542,
 -62079,
 226430285,
 78541,
 -62078,
 226495712,
 78540,
 -62077,
 226561186,
 78539,
 -62076,
 226626618,
 78538,
 -62075,
 226692003,
 78537,
 -62074,
 226757395,
 78536,
 -1,
 226822800,
 78535,
 227020203,
 224495488,
 -1,
 227085719,
 226954003,
 -1,
 227151243,
 227020230,
 78789,
 -1,
 227085873,
 78790,
 227282317,
 227085703,
 78787,
 -1,
 227216945,
 78788,
 227413391,
 227216546,
 78783,
 -1,
 227348017,
 78784,
 227544465,
 227347088,
 78778,
 -1,
 227479089,
 78779,
 -62062,
 227479034,
 78791,
 -62061,
 227609933,
 78786,
 -62060,
 227675360,
 78785,
 -62059,
 227740730,
 78782,
 -62058,
 227806115,
 78781,
 -1,
 227871507,
 78780,
 228068771,
 227019408,
 -1,
 228134298,
 228003322,
 78776,
 -1,
 228068913,
 78777,
 228265372,
 228068410,
 78769,
 -1,
 228199985,
 78770,
 -62051,
 228199878,
 78775,
 -62050,
 228330887,
 78774,
 -62049,
 228396365,
 78773,
 -62048,
 228461792,
 78772,
 -62047,
 228527266,
 78771,
 -62046,
 228592547,
 78768,
 -1,
 228657939,
 78767,
 228917247,
 228002723,
 -1,
 228920742,
 228789410,
 78796,
 -1,
 228855345,
 78797,
 -62041,
 228855008,
 78798,
 -62040,
 228985914,
 78795,
 -62039,
 229051299,
 78794,
 -62038,
 229116691,
 78793,
 -1,
 229182096,
 78792,
 229379531,
 226957996,
 -1,
 229445049,
 229313168,
 -1,
 229510577,
 229378979,
 77915,
 -62033,
 229448336,
 77918,
 -62032,
 229512974,
 77917,
 -1,
 229576241,
 77916,
 -62030,
 229445114,
 77925,
 -62029,
 229707206,
 77924,
 -62028,
 229772679,
 77923,
 -62027,
 229838157,
 77922,
 -62026,
 229903584,
 77921,
 -62025,
 229969058,
 77920,
 -62024,
 230034490,
 77919,
 -1,
 230099731,
 77914,
 230297029,
 229378835,
 -1,
 230362556,
 230230672,
 77926,
 -1,
 230297137,
 77927,
 -62019,
 230297082,
 77936,
 -62018,
 230428102,
 77935,
 -62017,
 230493575,
 77934,
 -62016,
 230559053,
 77933,
 -62015,
 230624480,
 77932,
 -62014,
 230689954,
 77931,
 -62013,
 230755386,
 77930,
 -62012,
 230820771,
 77929,
 -1,
 230886163,
 77928,
 231145471,
 230230947,
 -1,
 -62009,
 231017634,
 77941,
 -62008,
 231083066,
 77940,
 -62007,
 231148451,
 77939,
 -62006,
 231213843,
 77938,
 -1,
 231279248,
 77937,
 231476705,
 229325797,
 -1,
 231542232,
 231410320,
 -1,
 231607759,
 231476730,
 78225,
 -1,
 231542321,
 78226,
 231738833,
 231541984,
 78220,
 -1,
 231673393,
 78221,
 -61998,
 231673286,
 78224,
 -61997,
 231804295,
 78223,
 -61996,
 231869773,
 78222,
 -61995,
 231935138,
 78219,
 -61994,
 232000570,
 78218,
 -61993,
 232065955,
 78217,
 -1,
 232131347,
 78216,
 232390655,
 231475987,
 -1,
 232394203,
 232262419,
 78229,
 -1,
 232328753,
 78230,
 232525277,
 232327824,
 78227,
 -1,
 232459825,
 78228,
 -61986,
 232459488,
 78234,
 -61985,
 232590498,
 78233,
 -61984,
 232655930,
 78232,
 -1,
 232721315,
 78231,
 232918513,
 231432673,
 -1,
 232984046,
 232852112,
 -1,
 233049573,
 232918074,
 78494,
 -1,
 232984113,
 78495,
 233180647,
 232983315,
 78491,
 -1,
 233115185,
 78492,
 -61976,
 233115130,
 78501,
 -61975,
 233246150,
 78500,
 -61974,
 233311623,
 78499,
 -61973,
 233377101,
 78498,
 -61972,
 233442528,
 78497,
 -61971,
 233508002,
 78496,
 -1,
 233573283,
 78493,
 233832447,
 232917779,
 -1,
 -61968,
 233704211,
 78503,
 -1,
 233769616,
 78502,
 233967102,
 232885069,
 -1,
 234032629,
 233901218,
 78802,
 -61964,
 233969422,
 78804,
 -1,
 234032689,
 78803,
 234229239,
 233967046,
 78809,
 -1,
 234163761,
 78810,
 234360313,
 234163533,
 78806,
 -1,
 234294833,
 78807,
 -61958,
 234294663,
 78808,
 -61957,
 234425568,
 78805,
 -61956,
 234490938,
 78801,
 -61955,
 234556323,
 78800,
 -1,
 234621715,
 78799,
 234819081,
 233916308,
 -1,
 234884609,
 234753357,
 78249,
 -1,
 234819121,
 78250,
 235015683,
 234818467,
 78244,
 -1,
 234950193,
 78245,
 -61948,
 234950086,
 78252,
 -61947,
 235081095,
 78251,
 -61946,
 235146464,
 78248,
 -61945,
 235211938,
 78247,
 -61944,
 235277370,
 78246,
 -1,
 235342611,
 78243,
 235539988,
 234755872,
 -1,
 235605516,
 235474144,
 77908,
 -1,
 235540017,
 77909,
 -61939,
 235539962,
 77913,
 -61938,
 235670982,
 77912,
 -61937,
 235736455,
 77911,
 -61936,
 235801933,
 77910,
 -61935,
 235867298,
 77907,
 -61934,
 235932730,
 77906,
 -61933,
 235998115,
 77905,
 -1,
 236063507,
 77904,
 236260894,
 235506694,
 -1,
 236326423,
 236194579,
 78811,
 -1,
 236260913,
 78812,
 -61928,
 236260806,
 78819,
 -61927,
 236391815,
 78818,
 -61926,
 236457293,
 78817,
 -61925,
 236522720,
 78816,
 -61924,
 236588194,
 78815,
 -61923,
 236653626,
 78814,
 -1,
 236719011,
 78813,
 236916264,
 236205641,
 -1,
 236981793,
 236850509,
 78212,
 -1,
 236916273,
 78213,
 -61918,
 236916166,
 78215,
 -61917,
 237047175,
 78214,
 -61916,
 237112544,
 78211,
 -61915,
 237178018,
 78210,
 -61914,
 237243450,
 78209,
 -61913,
 237308835,
 78208,
 -1,
 237374227,
 78207,
 237571633,
 236864755,
 -1,
 -61910,
 237505990,
 78242,
 -61909,
 237571463,
 78241,
 -61908,
 237636941,
 78240,
 -61907,
 237702368,
 78239,
 -61906,
 237767842,
 78238,
 -61905,
 237833274,
 78237,
 -61904,
 237898659,
 78236,
 -1,
 237964051,
 78235,
 238223359,
 237528701,
 -1,
 -61901,
 238095751,
 78510,
 -61900,
 238161229,
 78509,
 -61899,
 238226656,
 78508,
 -61898,
 238292130,
 78507,
 -61897,
 238357562,
 78506,
 -61896,
 238422947,
 78505,
 -1,
 238488339,
 78504,
 238685944,
 160659831,
 -1,
 238751462,
 238644998,
 -1,
 238816997,
 238718220,
 -1,
 238882391,
 238754448,
 -1,
 238947925,
 238819984,
 -1,
 239013454,
 238892599,
 -1,
 239078983,
 238958135,
 -1,
 239144514,
 239019723,
 43813,
 -1,
 239085259,
 43812,
 239275588,
 239078961,
 43808,
 -1,
 239210033,
 43811,
 -61883,
 239238718,
 43809,
 -61882,
 239360042,
 43814,
 -1,
 239418253,
 43810,
 239603273,
 239019723,
 11709,
 -1,
 239544011,
 11708,
 239734347,
 239537713,
 11704,
 -1,
 239668785,
 11707,
 -61876,
 239697470,
 11705,
 -61875,
 239818794,
 11710,
 -1,
 239877005,
 11706,
 240062032,
 238954187,
 11693,
 -1,
 240002763,
 11692,
 240193106,
 239996465,
 11688,
 -1,
 240127537,
 11691,
 -61869,
 240156222,
 11689,
 -61868,
 240277546,
 11694,
 -1,
 240335757,
 11690,
 -61866,
 238901333,
 11655,
 -1,
 240466316,
 11664,
 240651880,
 238826168,
 -1,
 240717408,
 240618440,
 -1,
 240782939,
 240658123,
 11741,
 -1,
 240723659,
 11740,
 240914013,
 240717361,
 11736,
 -1,
 240848433,
 11739,
 -61858,
 240877118,
 11737,
 -61857,
 240998442,
 11742,
 -1,
 241056653,
 11738,
 241241702,
 240662033,
 -1,
 241307235,
 241182411,
 11670,
 -1,
 241247947,
 11669,
 241438309,
 241241649,
 11667,
 -1,
 241372721,
 4895,
 -1,
 241384333,
 11668,
 -61849,
 241195093,
 4879,
 -1,
 241585404,
 11658,
 241766010,
 240591174,
 -1,
 241831538,
 241705286,
 -1,
 241897073,
 241776183,
 -1,
 241962605,
 241837771,
 43789,
 -1,
 241903307,
 43788,
 -61842,
 241925694,
 43785,
 -61841,
 242047018,
 43790,
 -61840,
 242105229,
 43786,
 -1,
 242159274,
 43787,
 -1,
 241850453,
 11661,
 242421369,
 241798641,
 -1,
 242486901,
 242362059,
 43797,
 -1,
 242427595,
 43796,
 -61834,
 242449982,
 43793,
 -61833,
 242571306,
 43798,
 -61832,
 242629517,
 43794,
 -1,
 242683562,
 43795,
 -1,
 242374741,
 11660,
 242945674,
 241725190,
 -1,
 243011203,
 242904838,
 -1,
 243076734,
 242951883,
 11685,
 -1,
 243017419,
 11684,
 243207808,
 243011121,
 11680,
 -1,
 243142193,
 11683,
 -61823,
 243170878,
 11681,
 -61822,
 243292202,
 11686,
 -1,
 243350413,
 11682,
 243535496,
 242952285,
 -1,
 -61819,
 243492463,
 5004,
 -61818,
 243553244,
 4992,
 -61817,
 243610292,
 5000,
 -1,
 243669624,
 4996,
 -61815,
 243488853,
 11651,
 -1,
 243808652,
 11652,
 243994264,
 242882318,
 -1,
 244059795,
 243930894,
 -1,
 244125326,
 244000459,
 43821,
 -1,
 244065995,
 43820,
 244256400,
 244059697,
 43816,
 -1,
 244190769,
 43819,
 -61807,
 244219454,
 43817,
 -61806,
 244340778,
 43822,
 -1,
 244398989,
 43818,
 244584087,
 244025148,
 -1,
 244649622,
 244524747,
 4999,
 -1,
 244590283,
 4998,
 -1,
 244595597,
 4997,
 -1,
 244537429,
 11653,
 244911779,
 243955455,
 -1,
 244977312,
 244873480,
 -1,
 245042844,
 244917963,
 43781,
 -1,
 244983499,
 43780,
 -61795,
 245005886,
 43777,
 -61794,
 245127210,
 43782,
 -61793,
 245185421,
 43778,
 -1,
 245239466,
 43779,
 -61791,
 244944600,
 4935,
 -61790,
 245389397,
 11654,
 -1,
 245447052,
 11663,
 245632685,
 244878833,
 -1,
 245698220,
 245599729,
 -1,
 245763751,
 245638859,
 11701,
 -1,
 245704395,
 11700,
 245894825,
 245698097,
 11696,
 -1,
 245829169,
 11699,
 -61782,
 245857854,
 11697,
 -61781,
 245979178,
 11702,
 -1,
 246037389,
 11698,
 -1,
 245651541,
 11659,
 246288055,
 245598982,
 -1,
 246353590,
 246254536,
 -1,
 246419121,
 246294219,
 11733,
 -1,
 246359755,
 11732,
 246550195,
 246353457,
 11728,
 -1,
 246484529,
 11731,
 -61772,
 246513214,
 11729,
 -61771,
 246634538,
 11734,
 -1,
 246692749,
 11730,
 -1,
 246306901,
 4743,
 246943425,
 246244979,
 -1,
 247008960,
 246909896,
 -1,
 247074491,
 246949579,
 11717,
 -1,
 247015115,
 11716,
 247205565,
 247008817,
 11712,
 -1,
 247139889,
 11715,
 -61762,
 247168574,
 11713,
 -61761,
 247289898,
 11718,
 -1,
 247348109,
 11714,
 -1,
 246962261,
 4679,
 247598795,
 246891690,
 -1,
 247664330,
 247565256,
 -1,
 247729861,
 247604939,
 11725,
 -1,
 247670475,
 11724,
 247860935,
 247664177,
 11720,
 -1,
 247795249,
 11723,
 -61752,
 247823934,
 11721,
 -61751,
 247945258,
 11726,
 -1,
 248003469,
 11722,
 -1,
 247617621,
 4783,
 248254162,
 247554469,
 -1,
 248319696,
 248219452,
 -1,
 248385231,
 248260299,
 5007,
 -1,
 248325835,
 5006,
 -1,
 248331149,
 5005,
 -61743,
 248272981,
 11666,
 -1,
 248527244,
 11665,
 248712920,
 248204835,
 -1,
 248778455,
 248678204,
 -1,
 248843990,
 248719051,
 4995,
 -1,
 248784587,
 4994,
 -1,
 248789901,
 4993,
 -1,
 248731733,
 11649,
 249106140,
 248656561,
 -1,
 249171675,
 249046731,
 5003,
 -1,
 249112267,
 5002,
 -1,
 249117581,
 5001,
 249368287,
 249058300,
 -1,
 -61730,
 249335115,
 11657,
 -1,
 249387093,
 11656,
 -61728,
 249335115,
 4847,
 -61727,
 249531034,
 4815,
 -61726,
 249589115,
 11650,
 -61725,
 249646190,
 11648,
 -61724,
 249709667,
 11662,
 -1,
 249772428,
 4615,
 -1,
 238758001,
 4960,
 250023667,
 238713639,
 -1,
 250089195,
 249962822,
 -1,
 250154730,
 250031074,
 5009,
 -1,
 250087867,
 5016,
 -1,
 250101058,
 5012,
 250351342,
 250037418,
 -1,
 -61715,
 250315539,
 5017,
 -1,
 250358403,
 5013,
 -61713,
 250318086,
 5008,
 -61712,
 250507643,
 5011,
 -61711,
 250571912,
 5010,
 -61710,
 250624065,
 5015,
 -1,
 250682585,
 5014,
 250937343,
 249962154,
 -1,
 250941175,
 250819598,
 -1,
 -61706,
 250892230,
 4959,
 -1,
 250942128,
 4957,
 -1,
 250906281,
 4958,
 251203331,
 238621710,
 128066,
 251268864,
 251164939,
 -1,
 251334399,
 251219058,
 -1,
 251399934,
 251268657,
 -1,
 -61699,
 251359643,
 127759,
 -1,
 251416950,
 127758,
 -1,
 251342206,
 127757,
 -1,
 251293182,
 9178,
 251789311,
 251200332,
 -1,
 -61694,
 251685706,
 127806,
 -1,
 251743965,
 127805,
 251924235,
 251152661,
 -1,
 251989770,
 251863243,
 -1,
 252055305,
 251920384,
 -1,
 -61689,
 252017527,
 128294,
 -61688,
 252077148,
 128268,
 -1,
 252136245,
 128161,
 -1,
 251990382,
 9191,
 -1,
 251945890,
 128024,
 252448526,
 251890782,
 -1,
 -61683,
 252407558,
 128064,
 -1,
 252458293,
 128083,
 252645137,
 252412682,
 -1,
 -61680,
 252601647,
 127972,
 -1,
 252648364,
 127984,
 252841748,
 252597244,
 -1,
 -61677,
 252806317,
 128233,
 -1,
 252846458,
 128282,
 -61675,
 252808110,
 128125,
 -61674,
 253003007,
 127794,
 -61673,
 253060808,
 11072,
 -61672,
 253117445,
 9167,
 -61671,
 253174686,
 11790,
 -1,
 253233629,
 128231,
 253433071,
 160569102,
 -1,
 253498308,
 253365809,
 -1,
 253563586,
 253449085,
 -1,
 253629111,
 253512303,
 -1,
 253694553,
 253583781,
 -1,
 253760081,
 253638485,
 -1,
 253825023,
 253699789,
 -1,
 253890397,
 253776892,
 -1,
 253955900,
 253833912,
 -1,
 254021420,
 253904042,
 -1,
 254086951,
 253984318,
 -1,
 -61658,
 254042533,
 92598,
 -1,
 254103075,
 92619,
 254283562,
 254029062,
 -1,
 -61655,
 254249734,
 92543,
 -1,
 254283743,
 92553,
 254541823,
 254217777,
 92531,
 -1,
 254415430,
 92601,
 254611253,
 253964984,
 -1,
 254676785,
 254574142,
 -1,
 -61649,
 254634016,
 92550,
 -61648,
 254697893,
 92624,
 -1,
 254742563,
 92563,
 255000575,
 254617291,
 -1,
 255004468,
 254901938,
 92607,
 -1,
 254965503,
 92535,
 -1,
 254945481,
 92557,
 255201079,
 254574258,
 92640,
 -1,
 255162111,
 92657,
 255332154,
 255154218,
 -1,
 -61639,
 255288947,
 92544,
 -1,
 255353253,
 92541,
 -61637,
 255274344,
 92579,
 -1,
 255462961,
 92658,
 255659846,
 253894982,
 -1,
 255725378,
 255594033,
 -1,
 255790913,
 255659571,
 -1,
 -61632,
 255751136,
 92562,
 -1,
 255808486,
 92637,
 -1,
 255746469,
 92518,
 256053061,
 255671181,
 -1,
 -61628,
 256009843,
 92558,
 -1,
 256054283,
 92592,
 -1,
 256016580,
 92528,
 256315212,
 255607750,
 -1,
 256380747,
 256255691,
 -1,
 256446282,
 256321227,
 92628,
 -1,
 256377221,
 92648,
 -1,
 256410536,
 92547,
 -1,
 256315369,
 92554,
 256708433,
 256274523,
 -1,
 256773968,
 256671294,
 -1,
 -61617,
 256728127,
 92527,
 -1,
 256779979,
 92545,
 -1,
 256720156,
 92540,
 257036116,
 256675313,
 -1,
 -61613,
 257000083,
 92609,
 -1,
 257037323,
 92583,
 257232727,
 257002726,
 -1,
 -61610,
 257170953,
 92589,
 -1,
 257235038,
 92608,
 257429338,
 257193727,
 -1,
 -61607,
 257392763,
 92604,
 -1,
 257430425,
 92622,
 257625948,
 257363505,
 92662,
 -1,
 257566411,
 92613,
 -1,
 257574627,
 92584,
 257822581,
 253845925,
 -1,
 257888100,
 257785406,
 92576,
 257953634,
 257822257,
 -1,
 -61599,
 257910387,
 92618,
 -1,
 257959627,
 92529,
 -61597,
 257904163,
 92561,
 -1,
 258090699,
 92649,
 258281322,
 257822257,
 -1,
 258346855,
 258215473,
 92524,
 -1,
 258297379,
 92536,
 258539519,
 258278555,
 -1,
 -61591,
 258428417,
 92634,
 -1,
 258485065,
 92625,
 258674542,
 258227085,
 92663,
 258801663,
 258614987,
 -1,
 -61587,
 258701055,
 92621,
 -1,
 258747269,
 92593,
 258936691,
 258614987,
 -1,
 259002226,
 258899518,
 -1,
 -61583,
 258968326,
 92647,
 -1,
 259028735,
 92605,
 -1,
 258943500,
 92548,
 259325951,
 258889770,
 92568,
 -1,
 259218075,
 92610,
 259395464,
 257773091,
 -1,
 259460987,
 259329585,
 92667,
 259526521,
 259401419,
 92600,
 -1,
 259477027,
 92542,
 -61574,
 259483251,
 92668,
 -1,
 259613093,
 92555,
 259788669,
 259406733,
 92654,
 -1,
 259729606,
 92611,
 259919744,
 259732384,
 -1,
 -61569,
 259861043,
 92581,
 -1,
 259919409,
 92551,
 260116355,
 259856350,
 -1,
 -61566,
 260079739,
 92520,
 -1,
 260122315,
 92582,
 -61564,
 260081100,
 92617,
 -61563,
 260275890,
 92614,
 -61562,
 260332187,
 92671,
 -61561,
 260386901,
 92591,
 -1,
 260450867,
 92666,
 260640667,
 259356415,
 -1,
 260706191,
 260574769,
 -1,
 260771724,
 260640305,
 92635,
 -1,
 260728435,
 92577,
 -61555,
 260728435,
 92636,
 -61554,
 260853283,
 92530,
 -1,
 260909651,
 92559,
 261099411,
 260668990,
 -1,
 261164946,
 261049891,
 92586,
 -1,
 261099472,
 92569,
 -1,
 261099472,
 92566,
 261361559,
 261052458,
 -1,
 261427094,
 261314602,
 92537,
 -1,
 261379068,
 92519,
 -1,
 261383795,
 92630,
 261685247,
 261301963,
 -1,
 261689242,
 261586494,
 92669,
 -1,
 261623821,
 92572,
 -1,
 261641212,
 92672,
 261885869,
 260606920,
 -1,
 261951393,
 261848638,
 -1,
 -61538,
 261908083,
 92644,
 -61537,
 261968892,
 92645,
 -61536,
 262024069,
 92594,
 -1,
 262082550,
 92641,
 262279078,
 261893382,
 -1,
 262344612,
 262213584,
 92567,
 -1,
 262305535,
 92623,
 -61531,
 262310662,
 92639,
 -1,
 262426147,
 92606,
 262606761,
 262233388,
 -1,
 -61528,
 262567595,
 92642,
 -1,
 262610821,
 92643,
 262803372,
 262552461,
 -1,
 -61525,
 262764287,
 92590,
 -1,
 262809798,
 92564,
 -1,
 262738841,
 92588,
 263065529,
 261844742,
 -1,
 263131059,
 263009847,
 -1,
 263196593,
 263084074,
 92659,
 -1,
 263153267,
 92660,
 -61518,
 263143863,
 92638,
 -1,
 263269676,
 92580,
 263458742,
 263071435,
 -1,
 -61515,
 263419647,
 92560,
 -1,
 263464651,
 92534,
 -61513,
 263421627,
 92571,
 -61512,
 263608927,
 92525,
 -1,
 263655082,
 92549,
 263851974,
 263014253,
 -1,
 263917504,
 263804970,
 -1,
 263983038,
 263870506,
 -1,
 -61507,
 263943935,
 92556,
 -1,
 264000508,
 92523,
 -61505,
 263939699,
 92664,
 -1,
 264130083,
 92539,
 264310724,
 263851569,
 -1,
 -61502,
 264267379,
 92633,
 -61501,
 264331685,
 92521,
 -1,
 264376886,
 92575,
 -61499,
 264273470,
 92653,
 -1,
 264514841,
 92595,
 264703955,
 263799978,
 -1,
 264769483,
 264666686,
 -1,
 -61495,
 264730367,
 92620,
 -61494,
 264789055,
 92538,
 -1,
 264842400,
 92587,
 265031632,
 264709835,
 -1,
 265097167,
 264994366,
 -1,
 -61490,
 265063174,
 92646,
 -1,
 265097168,
 92570,
 -1,
 265058047,
 92599,
 -61487,
 264987545,
 92532,
 -61486,
 265312298,
 92665,
 -1,
 265370509,
 92670,
 265555935,
 264646481,
 -1,
 265621467,
 265518654,
 -1,
 265687001,
 265551872,
 -1,
 -61481,
 265644606,
 92661,
 -61480,
 265698189,
 92616,
 -1,
 265755352,
 92626,
 266010623,
 265627339,
 92596,
 -1,
 265910015,
 92612,
 266080221,
 265555505,
 92603,
 -1,
 266036851,
 92673,
 -61474,
 266033759,
 92627,
 -1,
 266152134,
 92651,
 266342380,
 265499320,
 -1,
 266407913,
 266286647,
 -1,
 266473447,
 266348235,
 -1,
 266538982,
 266436158,
 -1,
 -61468,
 266504966,
 92552,
 -61467,
 266556412,
 92565,
 -1,
 266604496,
 92615,
 -1,
 266499839,
 92602,
 -61464,
 266426975,
 92674,
 -1,
 266800821,
 92578,
 267059199,
 266344414,
 -1,
 -61461,
 266961832,
 92597,
 -1,
 267024127,
 92585,
 267194354,
 266299295,
 -1,
 267259888,
 267128369,
 -1,
 -61457,
 267216499,
 92526,
 -1,
 267265739,
 92656,
 -61455,
 267206272,
 92546,
 -1,
 267398544,
 92655,
 267587575,
 267159356,
 -1,
 267653110,
 267550270,
 -1,
 -61451,
 267606058,
 92533,
 -1,
 267658955,
 92650,
 -1,
 267595152,
 92574,
 267915260,
 267551662,
 -1,
 267980795,
 267855563,
 -1,
 -61446,
 267943602,
 92573,
 -1,
 267986635,
 92652,
 -1,
 267934303,
 92522,
 -61443,
 267868202,
 92631,
 -61442,
 268188557,
 92632,
 -1,
 268242481,
 92629,
 268439718,
 253763912,
 -1,
 268505140,
 268391420,
 -1,
 268570642,
 268448440,
 -1,
 268636170,
 268518570,
 -1,
 268701702,
 268578054,
 -1,
 -61435,
 268659489,
 92432,
 -1,
 268701709,
 92457,
 -61433,
 268668017,
 92435,
 -61432,
 268861636,
 92412,
 -61431,
 268909852,
 92476,
 -1,
 268964761,
 92414,
 269221887,
 268579512,
 -1,
 269225999,
 269094449,
 -1,
 269291534,
 269161014,
 92465,
 -1,
 269225936,
 92409,
 -1,
 269246885,
 92483,
 -61424,
 269191051,
 92467,
 -61423,
 269451694,
 92485,
 -1,
 269495696,
 92475,
 269684762,
 268518342,
 -1,
 269750293,
 269630349,
 92403,
 -1,
 269691078,
 92405,
 269881368,
 269692166,
 -1,
 -61417,
 269842175,
 92407,
 -1,
 269881311,
 92430,
 -61415,
 269844484,
 92487,
 -1,
 270013337,
 92418,
 270209058,
 269643526,
 -1,
 270274590,
 270155036,
 -1,
 -61411,
 270235391,
 92459,
 -1,
 270295461,
 92447,
 270471201,
 270218807,
 -1,
 -61408,
 270435176,
 92486,
 -1,
 270477510,
 92408,
 -1,
 270434427,
 92480,
 270733351,
 270175176,
 -1,
 -61404,
 270696421,
 92463,
 -61403,
 270744461,
 92493,
 -61402,
 270806176,
 92450,
 -1,
 270864950,
 92410,
 271061037,
 270672198,
 -1,
 271126571,
 271001291,
 -1,
 -61398,
 271090600,
 92425,
 -1,
 271132363,
 92437,
 -61396,
 271080091,
 92440,
 -1,
 271258166,
 92471,
 271454258,
 271021823,
 -1,
 271519793,
 271394507,
 -1,
 -61392,
 271483003,
 92472,
 -1,
 271525579,
 92505,
 -1,
 271483806,
 92514,
 -61389,
 271416894,
 92503,
 -1,
 271727501,
 92507,
 271913039,
 268455459,
 92497,
 271978556,
 271855441,
 -1,
 272044088,
 271931434,
 92445,
 -1,
 271995900,
 92404,
 272175163,
 271985926,
 -1,
 -61382,
 272135935,
 92424,
 -1,
 272175056,
 92458,
 -1,
 272121116,
 92466,
 272437312,
 271922080,
 -1,
 -61378,
 272390464,
 92438,
 -61377,
 272448796,
 92444,
 -1,
 272510279,
 92442,
 272699461,
 272377547,
 -1,
 272764996,
 272662078,
 -1,
 -61373,
 272725759,
 92427,
 -1,
 272782332,
 92478,
 -1,
 272705737,
 92496,
 273027145,
 272635662,
 -1,
 273092680,
 272961194,
 92448,
 -1,
 273024522,
 92515,
 -1,
 273056171,
 92401,
 273289292,
 272961073,
 -1,
 -61365,
 273238372,
 92426,
 -1,
 273296084,
 92482,
 -61363,
 273254023,
 92510,
 -61362,
 273448510,
 92499,
 -1,
 273505206,
 92441,
 273682530,
 271871750,
 -1,
 273748057,
 273626679,
 -1,
 273813590,
 273688267,
 -1,
 273879125,
 273776190,
 -1,
 -61356,
 273844998,
 92501,
 -1,
 273878992,
 92417,
 -1,
 273819339,
 92413,
 -61353,
 273776190,
 92504,
 -61352,
 274095401,
 92508,
 -1,
 274152965,
 92500,
 274337885,
 273710654,
 -1,
 -61349,
 274300478,
 92498,
 -61348,
 274343627,
 92419,
 -1,
 274403280,
 92473,
 274600032,
 274271793,
 -1,
 -61345,
 274556531,
 92516,
 -1,
 274620837,
 92423,
 -61343,
 274554412,
 92452,
 -1,
 274738476,
 92428,
 274927728,
 273630378,
 -1,
 274993258,
 274867915,
 -1,
 275058793,
 274955838,
 -1,
 -61338,
 275014053,
 92460,
 -61337,
 275078714,
 92431,
 -61336,
 275140131,
 92454,
 -1,
 275189807,
 92415,
 -1,
 275019519,
 92420,
 275452014,
 274955838,
 92489,
 -61332,
 275408499,
 92479,
 -61331,
 275470943,
 92422,
 -1,
 275534844,
 92474,
 -61329,
 275418225,
 92502,
 -1,
 275679120,
 92449,
 275845244,
 274888447,
 -1,
 275910775,
 275785419,
 -1,
 275976310,
 275873342,
 -1,
 -61324,
 275937023,
 92416,
 -61323,
 275993596,
 92481,
 -1,
 276041718,
 92451,
 -1,
 275917001,
 92456,
 276303993,
 275873342,
 92433,
 -1,
 276258348,
 92477,
 -61318,
 276258089,
 92492,
 -61317,
 276380557,
 92513,
 -1,
 276434896,
 92491,
 276631686,
 275793773,
 -1,
 276697219,
 276571851,
 -1,
 276762753,
 276659774,
 -1,
 -61312,
 276712995,
 92484,
 -1,
 276762627,
 92439,
 -61310,
 276723455,
 92464,
 -1,
 276900041,
 92495,
 -61308,
 276660347,
 92446,
 -61307,
 277044521,
 92511,
 -1,
 277101852,
 92406,
 277287055,
 276586917,
 -1,
 277352586,
 277249598,
 -1,
 -61303,
 277316456,
 92443,
 -1,
 277374579,
 92509,
 277549197,
 277292747,
 -1,
 -61300,
 277513079,
 92462,
 -1,
 277554891,
 92506,
 -61298,
 277496240,
 92461,
 -1,
 277681049,
 92469,
 277876887,
 277253064,
 -1,
 277942421,
 277839422,
 -1,
 278007956,
 277895210,
 -1,
 -61293,
 277963173,
 92470,
 -1,
 278023715,
 92468,
 -1,
 277973688,
 92453,
 -61290,
 277883443,
 92429,
 -1,
 278204399,
 92421,
 278401181,
 277833631,
 -1,
 278466715,
 278342198,
 -1,
 -61286,
 278419944,
 92490,
 -1,
 278483804,
 92512,
 -61284,
 278412805,
 92494,
 -1,
 278597599,
 92455,
 278794400,
 278366012,
 -1,
 -61281,
 278757051,
 92411,
 -1,
 278795161,
 92402,
 278991011,
 278738043,
 -1,
 -61278,
 278932756,
 92488,
 -1,
 278990506,
 92434,
 279248895,
 278933329,
 -1,
 -61275,
 279129394,
 92436,
 -1,
 279187114,
 92517,
 279384377,
 268376722,
 -1,
 279449819,
 279335932,
 -1,
 279515317,
 279392952,
 -1,
 279580848,
 279458488,
 -1,
 279646383,
 279543358,
 92362,
 -61268,
 279599771,
 92341,
 -61267,
 279662115,
 92347,
 -61266,
 279718163,
 92370,
 -1,
 279777274,
 92336,
 -1,
 279587379,
 92307,
 280039603,
 279528618,
 -1,
 -61262,
 280002540,
 92303,
 -1,
 280040459,
 92309,
 -61260,
 279992927,
 92368,
 -1,
 280171531,
 92395,
 280367293,
 279473926,
 -1,
 280432825,
 280329790,
 -1,
 -61256,
 280387139,
 92359,
 -1,
 280450044,
 92374,
 -61254,
 280386143,
 92371,
 -61253,
 280573722,
 92351,
 -61252,
 280636703,
 92325,
 -1,
 280694321,
 92350,
 280891590,
 280305990,
 -1,
 280957121,
 280833286,
 -1,
 -61248,
 280917759,
 92349,
 -1,
 280956945,
 92308,
 281153732,
 280890929,
 -1,
 -61245,
 281108901,
 92378,
 -1,
 281169443,
 92375,
 -61243,
 281107076,
 92317,
 -1,
 281296061,
 92331,
 281481422,
 280839110,
 -1,
 281546954,
 281421515,
 -1,
 -61239,
 281510824,
 92389,
 -1,
 281553097,
 92360,
 281743565,
 281480753,
 -1,
 -61236,
 281693731,
 92367,
 -1,
 281750028,
 92356,
 -1,
 281706500,
 92333,
 282005716,
 281442047,
 -1,
 282071250,
 281945803,
 -1,
 -61231,
 282034539,
 92345,
 -1,
 282088444,
 92372,
 -61229,
 282033731,
 92314,
 -1,
 282201770,
 92340,
 282398935,
 281972209,
 -1,
 -61226,
 282340675,
 92323,
 -1,
 282398257,
 92304,
 282595546,
 282332721,
 -1,
 -61223,
 282551923,
 92396,
 -1,
 282613454,
 92338,
 -1,
 282561781,
 92313,
 282857720,
 279399971,
 -1,
 282923246,
 282793742,
 -1,
 282988771,
 282863307,
 -1,
 283054305,
 282951230,
 -1,
 -61216,
 283020038,
 92385,
 -1,
 283069987,
 92315,
 -61214,
 283011104,
 92354,
 -1,
 283191749,
 92311,
 283381990,
 282934157,
 92381,
 -61211,
 283342591,
 92326,
 -1,
 283405153,
 92343,
 283578603,
 283315761,
 -1,
 283644138,
 283512371,
 -1,
 -61207,
 283599830,
 92387,
 -1,
 283646652,
 92318,
 -1,
 283596821,
 92383,
 283967487,
 283541054,
 -1,
 -61203,
 283846347,
 92324,
 -1,
 283906015,
 92364,
 284102901,
 282857009,
 -1,
 284168434,
 284042955,
 -1,
 -61199,
 284127640,
 92363,
 -1,
 284184634,
 92382,
 284426239,
 284098560,
 -1,
 -61196,
 284317397,
 92376,
 -1,
 284378663,
 92339,
 -61194,
 284065458,
 92391,
 -61193,
 284507420,
 92390,
 -1,
 284570552,
 92344,
 284758281,
 282805418,
 -1,
 284823812,
 284698315,
 -1,
 284889344,
 284786238,
 -1,
 284954878,
 284847878,
 -1,
 -61187,
 284899337,
 92319,
 -1,
 284962192,
 92384,
 -61185,
 284904995,
 92386,
 -1,
 285099387,
 92321,
 285282563,
 284840958,
 -1,
 -61182,
 285231278,
 92393,
 -1,
 285290520,
 92394,
 -1,
 285243135,
 92361,
 285544711,
 284786238,
 -1,
 -61178,
 285505279,
 92366,
 -1,
 285563980,
 92373,
 -61176,
 285500024,
 92328,
 -1,
 285675178,
 92329,
 285872400,
 284724168,
 -1,
 285937934,
 285834814,
 -1,
 -61172,
 285903544,
 92388,
 -61171,
 285953571,
 92305,
 -1,
 285999893,
 92322,
 -61169,
 285879646,
 92327,
 -1,
 286133930,
 92377,
 286331160,
 285832959,
 -1,
 286396692,
 286278294,
 -1,
 -61165,
 286359232,
 92358,
 -1,
 286396040,
 92334,
 286593303,
 286336715,
 -1,
 -61162,
 286557052,
 92346,
 -1,
 286619391,
 92400,
 -1,
 286527173,
 92332,
 286855456,
 286289670,
 -1,
 286920988,
 286799415,
 -1,
 -61157,
 286883844,
 92379,
 -1,
 286933431,
 92392,
 287117599,
 286861003,
 -1,
 -61154,
 287081384,
 92330,
 -1,
 287144195,
 92380,
 -1,
 287080140,
 92335,
 287379750,
 286803821,
 -1,
 287445284,
 287313457,
 -1,
 -61149,
 287400357,
 92342,
 -1,
 287460899,
 92357,
 -61147,
 287407678,
 92365,
 -1,
 287588791,
 92397,
 287772971,
 287334821,
 -1,
 287838506,
 287718285,
 -1,
 -61143,
 287796065,
 92316,
 -1,
 287855612,
 92398,
 -1,
 287779379,
 92399,
 288100656,
 287716024,
 -1,
 288166191,
 288044621,
 -1,
 -61138,
 288122912,
 92310,
 -1,
 288186789,
 92320,
 -1,
 288102344,
 92312,
 288428339,
 288065340,
 -1,
 -61134,
 288391615,
 92369,
 -1,
 288428838,
 92306,
 288624950,
 288392628,
 -1,
 -61131,
 288590598,
 92337,
 -1,
 288624647,
 92353,
 -61129,
 288583305,
 92355,
 -61128,
 288764579,
 92348,
 -1,
 288823890,
 92352,
 289018295,
 279318067,
 -1,
 289083741,
 288969724,
 -1,
 289149249,
 289044223,
 -1,
 289214784,
 289084313,
 92223,
 289341439,
 289144832,
 -1,
 -61121,
 289232669,
 92194,
 -1,
 289296801,
 92185,
 -1,
 289168701,
 92178,
 289542471,
 289092280,
 -1,
 289608005,
 289490744,
 -1,
 -61116,
 289560612,
 92182,
 -1,
 289604367,
 92160,
 -61114,
 289551402,
 92229,
 -1,
 289739581,
 92173,
 289935691,
 289508296,
 -1,
 290001226,
 289880973,
 92239,
 -1,
 289961777,
 92225,
 -1,
 289942688,
 92233,
 290197838,
 289902065,
 -1,
 -61107,
 290160839,
 92191,
 -1,
 290197053,
 92167,
 290394449,
 290156635,
 -1,
 -61104,
 290340124,
 92237,
 -1,
 290393649,
 92241,
 290591060,
 290342058,
 -1,
 -61101,
 290537225,
 92180,
 -1,
 290590399,
 92227,
 290787671,
 290529698,
 -1,
 -61098,
 290722581,
 92212,
 -1,
 290783913,
 92201,
 290984282,
 290721329,
 -1,
 -61095,
 290940531,
 92245,
 -1,
 290983485,
 92164,
 -61093,
 290931696,
 92231,
 -61092,
 291126796,
 92204,
 -1,
 291187251,
 92244,
 291377524,
 289033763,
 -1,
 291443049,
 291311153,
 -1,
 291508583,
 291382987,
 -1,
 291574116,
 291458595,
 92238,
 -61086,
 291538375,
 92174,
 -61085,
 291587876,
 92203,
 -1,
 291641446,
 92171,
 -61083,
 291533208,
 92230,
 -61082,
 291788821,
 92210,
 -1,
 291849775,
 92186,
 -61080,
 291463622,
 92221,
 -1,
 291985129,
 92175,
 292163950,
 291395626,
 -1,
 292229485,
 292117087,
 -1,
 -61076,
 292185670,
 92198,
 -1,
 292236684,
 92214,
 -1,
 292180993,
 92190,
 292491633,
 292099907,
 -1,
 -61072,
 292447859,
 92246,
 -1,
 292509717,
 92232,
 -61070,
 292455864,
 92176,
 -61069,
 292631474,
 92196,
 -1,
 292695371,
 92197,
 292884868,
 291335942,
 -1,
 292950397,
 292828727,
 -1,
 293015929,
 292912702,
 -1,
 -61064,
 292965923,
 92215,
 -1,
 293022452,
 92165,
 293212540,
 292961165,
 -1,
 -61061,
 293169184,
 92222,
 -1,
 293229768,
 92168,
 -1,
 293166384,
 92224,
 293474689,
 292902954,
 -1,
 -61057,
 293435135,
 92235,
 -61056,
 293496435,
 92220,
 -1,
 293557845,
 92208,
 -61054,
 293438366,
 92181,
 -61053,
 293683752,
 92195,
 -1,
 293743959,
 92177,
 293933461,
 292839845,
 -1,
 293998988,
 293867057,
 -1,
 294064521,
 293932593,
 -1,
 -61048,
 294021152,
 92226,
 -1,
 294080035,
 92236,
 -61046,
 294023348,
 92187,
 -61045,
 294212428,
 92189,
 -1,
 294257321,
 92200,
 294457747,
 293952158,
 -1,
 294523280,
 294412775,
 -1,
 -61041,
 294466504,
 92169,
 -1,
 294524739,
 92170,
 294780927,
 294474150,
 -1,
 -61038,
 294663112,
 92162,
 -1,
 294721347,
 92163,
 -61036,
 294420927,
 92205,
 -1,
 294857888,
 92202,
 295047582,
 293881002,
 -1,
 295113113,
 294987467,
 -1,
 -61032,
 295075877,
 92179,
 -1,
 295139071,
 92211,
 295309724,
 295046705,
 -1,
 -61029,
 295265907,
 92240,
 -1,
 295317422,
 92199,
 -61027,
 295272891,
 92213,
 -1,
 295462187,
 92219,
 295637414,
 295007999,
 -1,
 295702946,
 295599678,
 -1,
 -61023,
 295636995,
 92206,
 -1,
 295699175,
 92172,
 295899557,
 295644422,
 -1,
 -61020,
 295860476,
 92209,
 -1,
 295899126,
 92234,
 -1,
 295846572,
 92166,
 296161708,
 295585645,
 -1,
 296227241,
 296123966,
 92243,
 -1,
 296161283,
 92207,
 -61014,
 296180369,
 92216,
 -61013,
 296299683,
 92184,
 -1,
 296358816,
 92183,
 296554929,
 296104632,
 -1,
 296620464,
 296499203,
 -1,
 -61009,
 296577056,
 92188,
 -1,
 296629402,
 92193,
 -1,
 296556712,
 92161,
 296882612,
 296517182,
 -1,
 -61005,
 296834666,
 92228,
 -1,
 296880470,
 92192,
 -61003,
 296846505,
 92242,
 -61002,
 297037247,
 92218,
 -1,
 297087221,
 92217,
 297275912,
 288954128,
 -1,
 297341387,
 297225763,
 -1,
 297406912,
 297277198,
 -1,
 297472445,
 297340465,
 -1,
 -60996,
 297407505,
 92255,
 -1,
 297468639,
 92252,
 -60994,
 297435579,
 92292,
 -60993,
 297616029,
 92268,
 -1,
 297676143,
 92286,
 297865668,
 297340465,
 92300,
 297992191,
 297796388,
 -1,
 -60989,
 297894550,
 92296,
 -1,
 297938213,
 92295,
 298127815,
 297807697,
 -1,
 -60986,
 298080951,
 92267,
 -1,
 298140587,
 92284,
 298324426,
 298069254,
 -1,
 -60983,
 298284862,
 92290,
 -1,
 298346099,
 92281,
 -1,
 298277863,
 92287,
 298586588,
 297292796,
 -1,
 298652116,
 298529464,
 -1,
 298717650,
 298595000,
 -1,
 298783184,
 298680763,
 92282,
 -1,
 298713762,
 92283,
 -60975,
 298724617,
 92277,
 -1,
 298847921,
 92298,
 -60973,
 298670687,
 92302,
 -1,
 298993277,
 92276,
 299176407,
 298617800,
 -1,
 -60970,
 299121560,
 92269,
 -1,
 299175907,
 92288,
 299373018,
 299134726,
 -1,
 -60967,
 299318082,
 92247,
 -1,
 299379251,
 92299,
 -60965,
 299334205,
 92260,
 -1,
 299509340,
 92261,
 299700708,
 298544902,
 -1,
 299766240,
 299644783,
 -1,
 -60961,
 299728581,
 92266,
 -1,
 299792199,
 92265,
 -60959,
 299728869,
 92285,
 -60958,
 299908380,
 92249,
 -60957,
 299969706,
 92250,
 -1,
 300028235,
 92279,
 300225005,
 299648170,
 -1,
 300290537,
 300166406,
 -1,
 -60953,
 300256478,
 92272,
 -60952,
 300312134,
 92270,
 -1,
 300355551,
 92294,
 300552684,
 300235661,
 -1,
 -60949,
 300508787,
 92301,
 -1,
 300558579,
 92253,
 -1,
 300487222,
 92256,
 300814834,
 300179877,
 -1,
 -60945,
 300777828,
 92289,
 -60944,
 300827286,
 92263,
 -60943,
 300886285,
 92257,
 -1,
 300946690,
 92274,
 301142520,
 300762989,
 -1,
 301208054,
 301076017,
 -1,
 -60939,
 301157952,
 92259,
 -1,
 301208178,
 92273,
 -60937,
 301161058,
 92251,
 -1,
 301345952,
 92297,
 301535741,
 301102847,
 -1,
 301601276,
 301497920,
 -1,
 -60933,
 301553365,
 92264,
 -1,
 301616808,
 92248,
 -1,
 301534897,
 92280,
 301863424,
 301501384,
 -1,
 -60929,
 301804898,
 92254,
 -1,
 301863027,
 92258,
 302060035,
 301806753,
 -1,
 -60926,
 302022326,
 92262,
 -1,
 302076924,
 92271,
 302256646,
 302002208,
 -1,
 -60923,
 302220200,
 92291,
 -1,
 302261963,
 92293,
 -60921,
 302222072,
 92278,
 -1,
 302417346,
 92275,
 302645247,
 297217875,
 -1,
 302649879,
 302535676,
 -1,
 302715404,
 302612030,
 92697,
 -1,
 302649296,
 92696,
 302846479,
 302662598,
 -1,
 -60914,
 302808754,
 92698,
 -1,
 302845919,
 92688,
 303043090,
 302789304,
 -1,
 -60911,
 302991179,
 92711,
 -1,
 303051498,
 92712,
 -60909,
 303008995,
 92681,
 -60908,
 303200340,
 92704,
 -60907,
 303263898,
 92702,
 -60906,
 303315853,
 92708,
 -1,
 303374772,
 92687,
 303567392,
 302608134,
 -1,
 303632924,
 303511095,
 -1,
 -60902,
 303595070,
 92700,
 -60901,
 303650858,
 92713,
 -1,
 303709701,
 92691,
 -60899,
 303596446,
 92690,
 -60898,
 303840141,
 92692,
 -60897,
 303902096,
 92693,
 -1,
 303960633,
 92727,
 304157225,
 303514794,
 -1,
 304222756,
 304096971,
 -1,
 -60893,
 304183039,
 92695,
 -1,
 304239612,
 92710,
 -60891,
 304188529,
 92694,
 -60890,
 304381502,
 92677,
 -60889,
 304439780,
 92726,
 -60888,
 304502826,
 92719,
 -1,
 304549425,
 92675,
 304747058,
 304113567,
 -1,
 304812590,
 304686795,
 -1,
 -60884,
 304776104,
 92709,
 -60883,
 304829436,
 92721,
 -1,
 304883403,
 92679,
 305074737,
 304757645,
 -1,
 -60880,
 305019789,
 92683,
 -1,
 305080518,
 92684,
 -1,
 305036862,
 92707,
 305336889,
 304696867,
 92689,
 305402422,
 305272590,
 -1,
 -60875,
 305343027,
 92720,
 -1,
 305401514,
 92724,
 -60873,
 305354794,
 92723,
 -60872,
 305539277,
 92685,
 -1,
 305598001,
 92722,
 305795646,
 305297151,
 -1,
 305861181,
 305729073,
 -1,
 -60868,
 305800907,
 92680,
 -1,
 305860145,
 92686,
 -1,
 305802400,
 92725,
 306123331,
 305750437,
 -1,
 306188866,
 306063051,
 -1,
 -60863,
 306152360,
 92703,
 -1,
 306194123,
 92706,
 -1,
 306151090,
 92714,
 306451015,
 306071405,
 -1,
 -60859,
 306404649,
 92718,
 -60858,
 306461581,
 92717,
 -1,
 306515505,
 92682,
 306713162,
 306416584,
 -1,
 -60855,
 306666793,
 92699,
 -1,
 306712113,
 92701,
 306909773,
 306677564,
 -1,
 -60852,
 306872293,
 92705,
 -1,
 306908721,
 92716,
 -60850,
 306874153,
 92728,
 -60849,
 307068478,
 92676,
 -60848,
 307114417,
 92715,
 -1,
 307177670,
 92678,
 307368532,
 253722174,
 -1,
 -60845,
 307308235,
 42696,
 -1,
 307367888,
 42711,
 307565143,
 307308235,
 -1,
 -60842,
 307528616,
 42693,
 -1,
 307570379,
 42698,
 -60840,
 307510157,
 42717,
 -1,
 307695153,
 42667,
 307892844,
 253645820,
 -1,
 307958366,
 307839942,
 -1,
 -60836,
 307920562,
 42686,
 -60835,
 307964102,
 42694,
 -1,
 308023263,
 42674,
 308220514,
 307901112,
 -1,
 -60832,
 308168523,
 42707,
 -60831,
 308228842,
 42708,
 -1,
 308284977,
 42709,
 308482660,
 308182590,
 42685,
 -1,
 308416464,
 42684,
 308613735,
 308442879,
 -1,
 -60826,
 308577182,
 42731,
 -1,
 308619462,
 42695,
 -60824,
 308579555,
 42664,
 -60823,
 308768922,
 42691,
 -60822,
 308820877,
 42703,
 -60821,
 308879796,
 42673,
 -1,
 308940337,
 42715,
 309138041,
 307840170,
 -1,
 309203568,
 309090346,
 42719,
 -60817,
 309167918,
 42734,
 -1,
 309212335,
 42735,
 309400180,
 309143243,
 -1,
 -60814,
 309363624,
 42692,
 -60813,
 309425919,
 42683,
 -1,
 309482492,
 42706,
 -60811,
 309365873,
 42682,
 -60810,
 309624382,
 42659,
 -60809,
 309682660,
 42729,
 -60808,
 309738381,
 42725,
 -1,
 309792305,
 42657,
 309990020,
 309087779,
 42675,
 310055549,
 309929675,
 -1,
 -60804,
 310006780,
 42722,
 -1,
 310061257,
 42671,
 310252160,
 309991182,
 -1,
 -60801,
 310192691,
 42720,
 -1,
 310251178,
 42727,
 -60799,
 310214206,
 42677,
 -60798,
 310401066,
 42726,
 -60797,
 310459277,
 42702,
 -1,
 310513201,
 42723,
 310710926,
 309948166,
 -1,
 310776458,
 310654519,
 -1,
 -60793,
 310738494,
 42688,
 -60792,
 310794282,
 42710,
 -60791,
 310853125,
 42678,
 -1,
 310914448,
 42680,
 -60789,
 310739870,
 42676,
 -60788,
 311049101,
 42679,
 -60787,
 311111056,
 42681,
 -1,
 311169593,
 42732,
 311366296,
 310667167,
 -1,
 311431827,
 311305931,
 -1,
 -60783,
 311395240,
 42704,
 -60782,
 311448572,
 42721,
 -1,
 311502539,
 42661,
 311693974,
 311376781,
 -1,
 -60779,
 311638925,
 42668,
 -1,
 311699654,
 42669,
 -60777,
 311655998,
 42700,
 -1,
 311824336,
 42705,
 312021664,
 311326463,
 -1,
 312087196,
 311961291,
 -1,
 -60773,
 312047359,
 42728,
 -1,
 312103932,
 42730,
 312283807,
 312020529,
 -1,
 -60770,
 312223435,
 42662,
 -1,
 312282673,
 42672,
 -1,
 312228749,
 42724,
 312545958,
 311969645,
 -1,
 -60766,
 312507966,
 42701,
 -60765,
 312565033,
 42718,
 -60764,
 312621965,
 42716,
 -60763,
 312682701,
 42670,
 -1,
 312741425,
 42666,
 312939179,
 312487761,
 -1,
 -60760,
 312901182,
 42712,
 -60759,
 312957535,
 42713,
 -60758,
 313010374,
 42699,
 -1,
 313069237,
 42733,
 313266863,
 312904648,
 -1,
 -60755,
 313229971,
 42689,
 -60754,
 313285929,
 42687,
 -1,
 313331249,
 42690,
 313529010,
 313231164,
 -1,
 -60751,
 313491429,
 42697,
 -1,
 313527857,
 42714,
 -60749,
 313491006,
 42658,
 -60748,
 313677866,
 42663,
 -60747,
 313736077,
 42665,
 -60746,
 313796806,
 42660,
 -1,
 313855537,
 42656,
 314053310,
 253566594,
 -1,
 314118845,
 314002979,
 -1,
 314184380,
 314054864,
 -1,
 -60741,
 314146092,
 42737,
 -1,
 314197739,
 42736,
 -1,
 314134133,
 42741,
 -1,
 314068112,
 42740,
 -60737,
 314011680,
 42742,
 -60736,
 314468173,
 42743,
 -60735,
 314529357,
 42738,
 -1,
 314585767,
 42739,
 314774370,
 253511533,
 -1,
 314839905,
 314720078,
 -1,
 314905348,
 314788463,
 -1,
 314970828,
 314865407,
 -1,
 315036363,
 314904113,
 6946,
 315162623,
 314966016,
 -1,
 -60727,
 315062280,
 6947,
 -60726,
 315118516,
 6942,
 -1,
 315181172,
 6941,
 -1,
 315002574,
 6983,
 315429585,
 314921980,
 -1,
 315495119,
 315362865,
 6950,
 -1,
 315426245,
 6945,
 -60720,
 315460618,
 6940,
 -1,
 315568874,
 6935,
 315757270,
 315376810,
 -1,
 315822805,
 315690545,
 6931,
 -60716,
 315764585,
 6981,
 -1,
 315818735,
 6932,
 -1,
 315767370,
 6982,
 316084956,
 315695522,
 6948,
 316211199,
 316015324,
 -1,
 316216027,
 316113630,
 -1,
 -60710,
 316165810,
 6944,
 -1,
 316215837,
 6943,
 -1,
 316149708,
 6949,
 316478177,
 316018225,
 -1,
 316543711,
 316425599,
 6917,
 -1,
 316474991,
 6918,
 -60704,
 316503795,
 6987,
 -1,
 316620304,
 6928,
 316805861,
 316436314,
 6962,
 316932095,
 316737004,
 -1,
 -60700,
 316826084,
 6961,
 -1,
 316879594,
 6960,
 317068008,
 316762109,
 6957,
 317194239,
 316999126,
 6923,
 -1,
 317064815,
 6924,
 317264619,
 317015963,
 6958,
 317390847,
 317194938,
 6925,
 -1,
 317261423,
 6926,
 317461229,
 317227039,
 6921,
 -1,
 317392495,
 6922,
 317592303,
 317415908,
 6951,
 -1,
 317522478,
 6952,
 317723377,
 317544882,
 6929,
 -1,
 317654639,
 6930,
 317854451,
 317670372,
 6938,
 -1,
 317784605,
 6939,
 317985525,
 317799952,
 6919,
 -1,
 317916783,
 6920,
 318116599,
 317928170,
 6933,
 -1,
 318046690,
 6934,
 318247674,
 318056139,
 -1,
 -60679,
 318195071,
 6927,
 -1,
 318254953,
 6984,
 318444284,
 318184111,
 6936,
 -1,
 318374503,
 6937,
 318575358,
 318379843,
 6953,
 -1,
 318505551,
 6954,
 -60673,
 318541340,
 6986,
 -60672,
 318671882,
 6956,
 -60671,
 318736259,
 6959,
 -60670,
 318801051,
 6985,
 -60669,
 318852725,
 6955,
 -1,
 318912077,
 6963,
 319099693,
 314856393,
 -1,
 319165203,
 319037766,
 -1,
 319230733,
 319098417,
 -1,
 319296267,
 319182233,
 7012,
 319422463,
 319225856,
 -1,
 -60662,
 319321745,
 7013,
 -1,
 319370249,
 7018,
 -60660,
 319242069,
 7017,
 -1,
 319498960,
 7015,
 319689488,
 319170251,
 -1,
 -60657,
 319652183,
 7016,
 -1,
 319706521,
 7010,
 -60655,
 319652183,
 7011,
 -60654,
 319839091,
 7009,
 -1,
 319897429,
 7014,
 320082718,
 319102634,
 -1,
 320148249,
 320030209,
 -1,
 320213783,
 320110651,
 7021,
 -1,
 320145610,
 7024,
 320405503,
 320162554,
 7022,
 -1,
 320276682,
 7025,
 -60646,
 320108632,
 7019,
 -60645,
 320422929,
 7023,
 -60644,
 320484719,
 7027,
 -60643,
 320547513,
 7020,
 -1,
 320608283,
 7026,
 320803622,
 320031190,
 -1,
 320869155,
 320756881,
 -1,
 -60639,
 320831831,
 7033,
 -60638,
 320880469,
 7036,
 -1,
 320934652,
 7032,
 321191935,
 320806454,
 -1,
 -60635,
 321093660,
 7035,
 -1,
 321130820,
 7034,
 321388543,
 320760816,
 -1,
 321393450,
 321281117,
 -1,
 -60631,
 321355784,
 7028,
 -1,
 321392768,
 7029,
 321650687,
 321330752,
 -1,
 -60628,
 321552412,
 7030,
 -1,
 321589572,
 7031,
 321786687,
 319063755,
 -1,
 321852213,
 321746687,
 -1,
 321917748,
 321786347,
 6974,
 322043903,
 321847296,
 -1,
 322048819,
 321940044,
 6975,
 -1,
 321980015,
 6977,
 -1,
 322009165,
 6976,
 -1,
 321857728,
 6965,
 322310967,
 321814637,
 6966,
 -1,
 322242032,
 6967,
 322442041,
 322270838,
 6968,
 -1,
 322372100,
 6969,
 322573115,
 322398208,
 6970,
 -1,
 322504303,
 6971,
 322704189,
 322528070,
 6978,
 -1,
 322635375,
 6979,
 322895871,
 322652062,
 6972,
 -1,
 322766447,
 6973,
 322966349,
 321725256,
 -1,
 323031875,
 322926335,
 -1,
 -60606,
 322996750,
 6994,
 -1,
 323041932,
 6995,
 323228486,
 322989830,
 -1,
 -60603,
 323175279,
 6998,
 -1,
 323235231,
 6999,
 323425097,
 323170129,
 -1,
 -60600,
 323378964,
 6996,
 -1,
 323437354,
 6997,
 -60598,
 323391064,
 6992,
 -60597,
 323574526,
 6993,
 -60596,
 323638791,
 7001,
 -1,
 323692929,
 7000,
 323883861,
 322924981,
 -1,
 323949393,
 323846257,
 -1,
 -60592,
 323906383,
 6912,
 -1,
 323951358,
 6913,
 -60590,
 323909265,
 6915,
 -60589,
 324102750,
 6964,
 -60588,
 324148279,
 6914,
 -1,
 324212957,
 6916,
 324408154,
 323838436,
 -1,
 324473689,
 324357667,
 -1,
 -60584,
 324414143,
 7008,
 -1,
 324472734,
 7003,
 -1,
 324425522,
 7002,
 324735839,
 324344717,
 -1,
 324801374,
 324690404,
 -1,
 -60579,
 324758118,
 7007,
 -1,
 324817819,
 7005,
 -1,
 324760026,
 7006,
 -60576,
 324700476,
 7004,
 -1,
 324997041,
 6980,
 -1,
 314789073,
 127880,
 325260204,
 314734335,
 -1,
 325325737,
 325194055,
 -1,
 325391248,
 325274223,
 -1,
 325456755,
 325349126,
 -1,
 325522289,
 325402197,
 -1,
 -60568,
 325487626,
 7132,
 -60567,
 325552003,
 7116,
 -60566,
 325611354,
 7129,
 -60565,
 325675005,
 7123,
 -60564,
 325738980,
 7112,
 -60563,
 325799541,
 7125,
 -60562,
 325863323,
 7135,
 -60561,
 325924429,
 7107,
 -60560,
 325989098,
 7119,
 -1,
 326045233,
 7105,
 -60558,
 325476257,
 7126,
 -1,
 326176305,
 7128,
 326374265,
 325407740,
 -1,
 -60555,
 326339594,
 7136,
 -60554,
 326393321,
 7127,
 -60553,
 326447850,
 7133,
 -60552,
 326508962,
 7138,
 -1,
 326569521,
 7113,
 326767488,
 326323747,
 -1,
 326833023,
 326700593,
 7124,
 326959103,
 326784216,
 -1,
 -60547,
 326856538,
 7130,
 -60546,
 326915154,
 7114,
 -1,
 326973005,
 7108,
 -1,
 326768451,
 7139,
 327226242,
 326722020,
 7111,
 -1,
 327173916,
 7117,
 -60541,
 327191562,
 7131,
 -60540,
 327321475,
 7115,
 -60539,
 327384638,
 7141,
 -60538,
 327444477,
 7122,
 -60537,
 327501723,
 7134,
 -60536,
 327566730,
 7110,
 -60535,
 327631844,
 7120,
 -60534,
 327695245,
 7140,
 -60533,
 327759437,
 7106,
 -60532,
 327824106,
 7118,
 -60531,
 327885218,
 7121,
 -60530,
 327948975,
 7137,
 -60529,
 328013635,
 7109,
 -1,
 328076849,
 7104,
 328274843,
 325355211,
 -1,
 328340371,
 328236606,
 7150,
 -1,
 328270240,
 7151,
 328471446,
 328287620,
 -1,
 -60523,
 328423466,
 7149,
 -1,
 328481677,
 7147,
 328668056,
 328410827,
 7143,
 -1,
 328607435,
 7145,
 -60519,
 328622605,
 7144,
 -60518,
 328751146,
 7148,
 -1,
 328809357,
 7146,
 328995747,
 328232710,
 -1,
 329061282,
 328961308,
 -1,
 329126816,
 329015717,
 -1,
 -60513,
 329072314,
 7165,
 -1,
 329126709,
 7167,
 -60511,
 329077845,
 7164,
 -1,
 329270422,
 7166,
 -1,
 329006584,
 7142,
 329520038,
 328950334,
 -1,
 -60507,
 329472932,
 7155,
 -1,
 329528647,
 7154,
 329777151,
 329457407,
 -1,
 -60504,
 329667993,
 7152,
 -1,
 329725495,
 7153,
 329913259,
 325269047,
 128704,
 -1,
 329874684,
 128705,
 -1,
 329873655,
 128267,
 330109876,
 325211132,
 -1,
 330175411,
 330056874,
 127974,
 330301439,
 330127026,
 -1,
 -60496,
 330206371,
 128180,
 -60495,
 330261819,
 128183,
 -60494,
 330313076,
 128182,
 -1,
 330376151,
 128181,
 -1,
 330109550,
 127820,
 330634170,
 330046080,
 128118,
 330760191,
 330563584,
 -1,
 -60489,
 330659528,
 128700,
 -60488,
 330702014,
 128036,
 -60487,
 330766744,
 127868,
 -1,
 330830607,
 128124,
 331027389,
 330592006,
 -1,
 -60484,
 330974742,
 127936,
 -1,
 331032663,
 9918,
 331224000,
 330983327,
 -1,
 -60481,
 331159590,
 128136,
 -1,
 331219188,
 128202,
 331420611,
 331160208,
 -1,
 -60478,
 331381795,
 128043,
 -1,
 331433174,
 128281,
 -1,
 331363424,
 128708,
 331682912,
 253454239,
 -1,
 331748441,
 331616470,
 -1,
 331813898,
 331696751,
 -1,
 331879374,
 331776942,
 -1,
 331944909,
 331831460,
 -1,
 332010443,
 331900831,
 69643,
 -1,
 331966367,
 69644,
 332201983,
 331958125,
 69645,
 -1,
 332089197,
 69646,
 -1,
 331877937,
 69679,
 332338132,
 331839231,
 -1,
 332403666,
 332297983,
 -1,
 -60463,
 332346957,
 69662,
 -1,
 332402225,
 69661,
 -60461,
 332346957,
 69667,
 -1,
 332533297,
 69666,
 332731353,
 332290090,
 69649,
 332857343,
 332679415,
 -1,
 -60457,
 332754453,
 69686,
 -60456,
 332813951,
 69687,
 -1,
 332876873,
 69685,
 333059038,
 332682236,
 -1,
 -60453,
 333024266,
 69660,
 -60452,
 333075538,
 69665,
 -60451,
 333132522,
 69655,
 -1,
 333188657,
 69670,
 333386724,
 332996934,
 -1,
 333452258,
 333324614,
 -1,
 -60447,
 333395533,
 69664,
 -1,
 333450801,
 69663,
 -60445,
 333395533,
 69669,
 -1,
 333581873,
 69668,
 333779944,
 333319729,
 69637,
 -60442,
 333741630,
 69650,
 -60441,
 333790093,
 69648,
 -1,
 333844017,
 69638,
 334042092,
 333737734,
 -1,
 -60438,
 333999962,
 69681,
 -60437,
 334050893,
 69680,
 -1,
 334106161,
 69682,
 334304238,
 334003774,
 69641,
 -1,
 334265918,
 69642,
 334435313,
 334258597,
 -1,
 -60432,
 334378573,
 69672,
 -1,
 334433841,
 69671,
 334631924,
 334382957,
 -1,
 -60429,
 334579611,
 69684,
 -1,
 334630449,
 69678,
 334828535,
 334578858,
 -1,
 -60426,
 334771789,
 69652,
 -1,
 334827057,
 69651,
 335025146,
 334775238,
 -1,
 -60423,
 334968397,
 69659,
 -1,
 335023665,
 69658,
 335221756,
 334969741,
 69639,
 -1,
 335166349,
 69640,
 335352831,
 335164088,
 -1,
 -60418,
 335296077,
 69654,
 -1,
 335351345,
 69653,
 335549442,
 335288976,
 -1,
 -60415,
 335492685,
 69657,
 -1,
 335547953,
 69656,
 335746053,
 335484686,
 -1,
 -60412,
 335689293,
 69674,
 -1,
 335744561,
 69673,
 -60410,
 335711242,
 69676,
 -60409,
 335898621,
 69677,
 -60408,
 335957621,
 69675,
 -60407,
 336016973,
 69683,
 -1,
 336078539,
 69647,
 336270375,
 331765630,
 -1,
 336335891,
 336230143,
 -1,
 336401423,
 336299836,
 -1,
 -60402,
 336353322,
 69715,
 -1,
 336407334,
 69724,
 336598034,
 336344631,
 -1,
 -60399,
 336554509,
 69716,
 -1,
 336609806,
 69725,
 -1,
 336538163,
 69723,
 336860184,
 336293638,
 -1,
 336925718,
 336806767,
 69719,
 -1,
 336887339,
 69728,
 337117183,
 336866719,
 69720,
 -1,
 337018411,
 69729,
 337187871,
 336801617,
 -1,
 337253404,
 337139754,
 -1,
 -60389,
 337216160,
 69717,
 -1,
 337276549,
 69726,
 337510399,
 337197965,
 -1,
 -60386,
 337413249,
 69718,
 -1,
 337457823,
 69727,
 337646627,
 337140478,
 69714,
 337772543,
 337575936,
 -1,
 -60382,
 337672627,
 69733,
 -1,
 337722187,
 69732,
 337908773,
 337597959,
 69722,
 -1,
 337870379,
 69731,
 338100223,
 337848705,
 69721,
 -1,
 338004936,
 69730,
 338170938,
 336233390,
 -1,
 338236473,
 338125121,
 -1,
 338301998,
 338200109,
 -1,
 338367532,
 338257823,
 69694,
 -1,
 338323359,
 69695,
 338558975,
 338315117,
 69696,
 -1,
 338446189,
 69697,
 338629682,
 338234929,
 -1,
 -60368,
 338591294,
 69701,
 -60367,
 338639757,
 69699,
 -1,
 338693681,
 69688,
 338891828,
 338591294,
 69692,
 -1,
 338853438,
 69693,
 339022902,
 338836365,
 69690,
 -1,
 338967437,
 69691,
 -60361,
 338974762,
 69700,
 -60360,
 339093195,
 69698,
 -1,
 339155053,
 69689,
 -1,
 338182618,
 69702,
 339416139,
 338108742,
 -1,
 339481673,
 339361238,
 -1,
 339547199,
 339441407,
 -1,
 -60354,
 339511822,
 69736,
 -1,
 339557004,
 69737,
 339743810,
 339504902,
 -1,
 -60351,
 339690351,
 69740,
 -1,
 339750303,
 69741,
 339940421,
 339685201,
 -1,
 -60348,
 339894036,
 69738,
 -1,
 339952426,
 69739,
 -60346,
 339906136,
 69734,
 -60345,
 340089598,
 69735,
 -60344,
 340153863,
 69743,
 -1,
 340208001,
 69742,
 -60342,
 339435217,
 69704,
 -1,
 340333278,
 69703,
 340530257,
 339374517,
 -1,
 -60339,
 340493813,
 69634,
 -60338,
 340558403,
 69636,
 -60337,
 340608057,
 69635,
 -60336,
 340663081,
 69632,
 -1,
 340726672,
 69633,
 340983807,
 340485671,
 -1,
 340989013,
 340871021,
 -1,
 -60332,
 340942530,
 69709,
 -1,
 340999980,
 69707,
 341185624,
 340927437,
 -1,
 -60329,
 341147445,
 69706,
 -1,
 341210879,
 69705,
 -1,
 341123015,
 69708,
 341447774,
 331692941,
 -1,
 341513309,
 341385542,
 -1,
 -60324,
 341455838,
 127753,
 -1,
 341518249,
 128112,
 -1,
 341453079,
 128188,
 -60321,
 341399992,
 128148,
 -1,
 341714884,
 127838,
 341906572,
 331644478,
 -1,
 341972103,
 341848760,
 128027,
 342097919,
 341917518,
 -1,
 342103167,
 341985903,
 -1,
 342168685,
 342053884,
 -1,
 342234216,
 342133704,
 -1,
 -60313,
 342170287,
 6671,
 -1,
 342232625,
 6670,
 342430827,
 342176440,
 -1,
 -60310,
 342377736,
 6659,
 -1,
 342429233,
 6658,
 -60308,
 342386685,
 6667,
 -1,
 342560305,
 6666,
 342758512,
 342117923,
 -1,
 -60305,
 342712804,
 6663,
 -1,
 342756913,
 6662,
 -60303,
 342723594,
 6672,
 -60302,
 342918084,
 6675,
 -60301,
 342980433,
 6664,
 -60300,
 343043930,
 6676,
 -60299,
 343107581,
 6673,
 -60298,
 343171556,
 6660,
 -60297,
 343230363,
 6674,
 -60296,
 343295240,
 6656,
 -60295,
 343360484,
 6669,
 -60294,
 343422541,
 6678,
 -60293,
 343487210,
 6657,
 -60292,
 343548322,
 6665,
 -60291,
 343612079,
 6668,
 -60290,
 343676739,
 6661,
 -1,
 343739953,
 6677,
 343938181,
 342066891,
 -1,
 -60287,
 343899710,
 6680,
 -60286,
 343955498,
 6682,
 -60285,
 344013709,
 6679,
 -60284,
 344073931,
 6681,
 -1,
 344133584,
 6683,
 -60282,
 343892515,
 6686,
 -1,
 344271530,
 6687,
 344522751,
 341929734,
 128652,
 344528011,
 344422143,
 -1,
 -60278,
 344485651,
 128101,
 -1,
 344523278,
 128100,
 -1,
 344458819,
 128655,
 344790208,
 341854061,
 -1,
 344855738,
 344723311,
 -1,
 344921237,
 344813318,
 -1,
 344986771,
 344870686,
 -1,
 -60271,
 344946008,
 11089,
 -60270,
 345001324,
 11050,
 -1,
 345056009,
 11049,
 -60268,
 344942319,
 128306,
 -1,
 345200317,
 9927,
 345379997,
 344868717,
 -1,
 345445530,
 345319727,
 -1,
 345511065,
 345377295,
 9194,
 -1,
 345442619,
 9198,
 -1,
 345440918,
 9944,
 345767935,
 345379929,
 -1,
 -60260,
 345666703,
 11035,
 -1,
 345709896,
 11044,
 345904290,
 345336828,
 -1,
 345969824,
 345843077,
 9193,
 -1,
 345901371,
 9197,
 -60255,
 345930799,
 9199,
 -1,
 346055465,
 11091,
 346231975,
 345853475,
 -1,
 346297510,
 346171577,
 -1,
 -60251,
 346246508,
 11047,
 -1,
 346301193,
 11045,
 -1,
 346250273,
 9912,
 346559660,
 346169670,
 -1,
 346625195,
 346515749,
 -1,
 -60246,
 346574724,
 9922,
 -1,
 346637960,
 9923,
 -1,
 346579321,
 9196,
 346887343,
 346522856,
 -1,
 -60242,
 346852335,
 11037,
 -1,
 346913327,
 11054,
 347083954,
 346846975,
 -1,
 -60239,
 347048578,
 9942,
 -1,
 347106956,
 9951,
 347280565,
 347026999,
 -1,
 -60236,
 347233673,
 11052,
 -1,
 347287122,
 11042,
 -60234,
 347243047,
 9195,
 -60233,
 347432795,
 10067,
 -60232,
 347497257,
 11039,
 -60231,
 347550003,
 9873,
 -1,
 347611145,
 9960,
 347804861,
 344817640,
 -1,
 -60228,
 347748236,
 128153,
 -1,
 347806093,
 128216,
 348061695,
 347756586,
 -1,
 -60225,
 347965574,
 128033,
 -1,
 348026121,
 127804,
 348198101,
 344741930,
 -1,
 348263623,
 348159214,
 -1,
 -60221,
 348224386,
 9185,
 -60220,
 348285890,
 11813,
 -60219,
 348349054,
 9181,
 -60218,
 348408250,
 11812,
 -1,
 348463386,
 9183,
 348656844,
 348218646,
 -1,
 -60215,
 348622569,
 12730,
 -60214,
 348670689,
 12729,
 -60213,
 348732930,
 12589,
 -1,
 348796027,
 12728,
 348984528,
 348608943,
 -1,
 349050063,
 348934086,
 128278,
 -1,
 348980832,
 128209,
 -1,
 349007622,
 128218,
 -60207,
 348949448,
 128102,
 -60206,
 349211128,
 127923,
 -60205,
 349274778,
 128144,
 -60204,
 349327415,
 128163,
 -1,
 349377550,
 128023,
 349574373,
 348137163,
 -1,
 349639903,
 349524988,
 -1,
 349705437,
 349582120,
 -1,
 349770971,
 349653623,
 -1,
 -60198,
 349716890,
 983621,
 -1,
 349770467,
 2510,
 -60196,
 349729211,
 2493,
 -1,
 349909843,
 2555,
 -60194,
 349670978,
 9187,
 -1,
 350059292,
 127857,
 350229729,
 349588445,
 128276,
 -1,
 350160790,
 128277,
 350360804,
 350162481,
 -1,
 -60189,
 350321382,
 128147,
 -1,
 350381996,
 128059,
 -1,
 350301080,
 127866,
 350622958,
 349518733,
 -1,
 350688489,
 350578591,
 -1,
 -60184,
 350648649,
 127874,
 -1,
 350691654,
 128038,
 350885100,
 350626113,
 -1,
 -60181,
 350831209,
 128692,
 -1,
 350889675,
 128690,
 -60179,
 350833707,
 127921,
 -1,
 351028887,
 128089,
 -1,
 350588349,
 983050,
 351279503,
 253380461,
 -1,
 351344382,
 351211057,
 -1,
 351409895,
 351304411,
 -1,
 351475223,
 351366918,
 -1,
 351540740,
 351424286,
 -1,
 351606273,
 351488623,
 -1,
 351671571,
 351565567,
 -1,
 351737095,
 351632958,
 -1,
 351802630,
 351694183,
 -1,
 351868155,
 351765433,
 -1,
 -60166,
 351810970,
 983615,
 -1,
 351866744,
 983616,
 352064766,
 351819818,
 -1,
 -60163,
 352019169,
 7432,
 -1,
 352069323,
 7444,
 352261376,
 352009101,
 7433,
 -1,
 352212732,
 42879,
 352392450,
 352204345,
 686,
 -1,
 352321656,
 687,
 -60157,
 352348110,
 11385,
 -60156,
 352470893,
 42881,
 -60155,
 352531128,
 7543,
 -1,
 352587728,
 7426,
 -1,
 351751715,
 42871,
 352851211,
 351680055,
 -1,
 352916746,
 352804282,
 42853,
 -1,
 352847501,
 42855,
 -1,
 352848143,
 7546,
 353113359,
 352782188,
 -1,
 -60147,
 353063375,
 7541,
 -60146,
 353116921,
 11366,
 -1,
 353181973,
 566,
 -60144,
 353078769,
 42793,
 -60143,
 353331841,
 42795,
 -60142,
 353393730,
 7446,
 -1,
 353439981,
 11383,
 353637677,
 351610571,
 -1,
 353703205,
 353568620,
 -1,
 353768729,
 353666402,
 983555,
 353894399,
 353697850,
 -1,
 -60136,
 353777050,
 983557,
 -1,
 353832824,
 983559,
 354030876,
 353720682,
 -1,
 -60133,
 353991276,
 983585,
 -1,
 354029432,
 983583,
 354227487,
 353969152,
 -1,
 -60130,
 354187884,
 983589,
 -1,
 354226040,
 983587,
 354424098,
 354164118,
 -1,
 -60127,
 354373246,
 983561,
 -1,
 354425748,
 983563,
 -60125,
 354383332,
 583,
 -60124,
 354577041,
 7570,
 -1,
 354637479,
 11384,
 354817320,
 353661056,
 -1,
 -60121,
 354773649,
 7576,
 -1,
 354837014,
 7563,
 355013931,
 354760232,
 -1,
 -60118,
 354961770,
 42787,
 -1,
 355024544,
 42789,
 -60116,
 354979480,
 7578,
 -1,
 355170047,
 42859,
 355341632,
 353595142,
 -1,
 355407157,
 355286249,
 -1,
 355472690,
 355358762,
 7441,
 -60111,
 355427072,
 7442,
 -1,
 355469603,
 7443,
 -60109,
 355434046,
 7453,
 -60108,
 355630427,
 7455,
 -1,
 355672801,
 7454,
 355865915,
 355338092,
 -1,
 -60105,
 355829090,
 983575,
 -60104,
 355890848,
 575,
 -60103,
 355951126,
 7562,
 -60102,
 356014213,
 42921,
 -1,
 356078031,
 7540,
 356259135,
 355802388,
 -1,
 -60099,
 356215441,
 7573,
 -60098,
 356267418,
 983617,
 -1,
 356323192,
 983618,
 -1,
 356192807,
 42892,
 356586836,
 355285901,
 -1,
 356652363,
 356517740,
 -1,
 356717894,
 356590592,
 -1,
 -60092,
 356678252,
 983591,
 -60091,
 356726170,
 983590,
 -1,
 356781944,
 983566,
 356980041,
 356669814,
 -1,
 -60088,
 356940396,
 983595,
 -1,
 356978552,
 983593,
 -60086,
 356936337,
 7574,
 -1,
 357125777,
 983565,
 357307730,
 356603636,
 -1,
 -60083,
 357267199,
 42887,
 -60082,
 357330694,
 42885,
 -60081,
 357394335,
 42883,
 -60080,
 357446328,
 7545,
 -60079,
 357510993,
 42876,
 -1,
 357572934,
 42874,
 -60077,
 357265158,
 42861,
 -1,
 357719646,
 7548,
 357897572,
 356519473,
 -1,
 357963100,
 357828460,
 -1,
 358028633,
 357914986,
 -1,
 -60072,
 357988972,
 983581,
 -1,
 358027128,
 983579,
 -60070,
 357987812,
 11365,
 -60069,
 358181521,
 7567,
 -1,
 358239889,
 983553,
 358421854,
 357925806,
 42809,
 -1,
 358353026,
 42811,
 -60065,
 358386632,
 42813,
 -60064,
 358514238,
 42807,
 -60063,
 358570026,
 42805,
 -60062,
 358632829,
 7568,
 -60061,
 358688627,
 983612,
 -1,
 358747697,
 42803,
 358946164,
 357853087,
 -1,
 359011694,
 358875136,
 -1,
 359077229,
 358975849,
 -1,
 -60056,
 359037548,
 983603,
 -60055,
 359101924,
 589,
 -60054,
 359162390,
 7561,
 -60053,
 359225477,
 42919,
 -60052,
 359289295,
 7538,
 -1,
 359346431,
 7539,
 -1,
 359034358,
 42843,
 359601522,
 358952447,
 -1,
 359667057,
 359537296,
 8580,
 -1,
 359598110,
 42815,
 -1,
 359619691,
 7572,
 359923711,
 359563387,
 42869,
 -1,
 359794140,
 42845,
 359994757,
 358897706,
 -1,
 360060286,
 359925612,
 -1,
 360125818,
 360023394,
 983569,
 360251391,
 360054842,
 -1,
 -60039,
 360134042,
 983571,
 -1,
 360189816,
 983573,
 360447999,
 360074347,
 -1,
 -60036,
 360351590,
 11386,
 -60035,
 360406079,
 42829,
 -1,
 360469920,
 42827,
 360650116,
 360014556,
 -1,
 360715651,
 360601667,
 -1,
 -60031,
 360671889,
 7575,
 -60030,
 360723866,
 983613,
 -1,
 360779640,
 983614,
 -1,
 360654739,
 7571,
 -1,
 360601642,
 42831,
 361108882,
 359956030,
 -1,
 361174415,
 361039724,
 -1,
 361239947,
 361123461,
 -1,
 -60023,
 361200236,
 983611,
 -60022,
 361248154,
 983577,
 -1,
 361303928,
 983609,
 361502094,
 361191786,
 -1,
 -60019,
 361462380,
 983607,
 -1,
 361500536,
 983605,
 -1,
 361458321,
 7577,
 -60016,
 361129458,
 7551,
 -60015,
 361713187,
 42872,
 -1,
 361768651,
 7531,
 361960862,
 361056109,
 -1,
 362026394,
 361891692,
 -1,
 -60011,
 361986668,
 983599,
 -60010,
 362048160,
 42894,
 -60009,
 362111510,
 7557,
 -60008,
 362166439,
 42825,
 -60007,
 362226943,
 11361,
 -1,
 362291477,
 564,
 362485149,
 361978776,
 -1,
 -60004,
 362428583,
 7837,
 -1,
 362488569,
 7836,
 -1,
 362446971,
 42866,
 362747304,
 361898310,
 -1,
 362812836,
 362678124,
 -1,
 -59999,
 362766870,
 7553,
 -59998,
 362828239,
 7533,
 -59997,
 362887614,
 7569,
 -1,
 362946837,
 545,
 -59995,
 362774651,
 42865,
 -59994,
 363093642,
 567,
 -59993,
 363145730,
 7839,
 -1,
 363206419,
 568,
 363402673,
 362709934,
 -1,
 363468206,
 363333484,
 -1,
 -59989,
 363424725,
 11377,
 -59988,
 363487766,
 7564,
 -59987,
 363537145,
 42847,
 -1,
 363602197,
 11380,
 -59985,
 363432904,
 42849,
 -59984,
 363741778,
 42851,
 -1,
 363801254,
 42857,
 363992506,
 363353084,
 -1,
 364058040,
 363923308,
 -1,
 -59980,
 364012054,
 7559,
 -59979,
 364075141,
 42917,
 -59978,
 364138959,
 7536,
 -59977,
 364192392,
 42897,
 -1,
 364257557,
 565,
 -59975,
 364019835,
 42868,
 -1,
 364393163,
 983567,
 364582338,
 363946457,
 -1,
 364647871,
 364539654,
 -1,
 364713406,
 364608683,
 7549,
 -1,
 364643981,
 42833,
 -1,
 364668818,
 42837,
 -59968,
 364601878,
 7560,
 -59967,
 364859855,
 7537,
 -1,
 364917118,
 42835,
 365106635,
 364531235,
 -1,
 365172167,
 365037420,
 -1,
 -59963,
 365132396,
 983601,
 -59962,
 365191702,
 7558,
 -1,
 365253071,
 7535,
 365434314,
 365116609,
 -1,
 -59959,
 365396910,
 7933,
 -1,
 365448157,
 7931,
 -1,
 365396091,
 42867,
 365696467,
 365053134,
 -1,
 365761998,
 365655524,
 42817,
 -1,
 365690944,
 42821,
 365893073,
 365699398,
 -1,
 -59952,
 365837288,
 42819,
 -1,
 365898834,
 11370,
 -59950,
 365847062,
 7556,
 -1,
 366041221,
 42915,
 366220762,
 365639223,
 -1,
 366286295,
 366173191,
 -1,
 -59946,
 366228890,
 983619,
 -1,
 366284664,
 983620,
 -59944,
 366226128,
 42791,
 -59943,
 366416351,
 11382,
 -1,
 366479352,
 11368,
 366679519,
 366185971,
 -1,
 -59940,
 366638752,
 576,
 -59939,
 366699030,
 7566,
 -59938,
 366760399,
 7542,
 -1,
 366813832,
 11372,
 367007205,
 366634611,
 -1,
 367072740,
 366937964,
 -1,
 -59934,
 367031837,
 42839,
 -59933,
 367081932,
 587,
 -1,
 367141625,
 42841,
 -1,
 367026602,
 569,
 367400427,
 366949048,
 -1,
 367465961,
 367331180,
 -1,
 -59928,
 367419926,
 7555,
 -1,
 367483013,
 42913,
 -59926,
 367414534,
 578,
 -1,
 367605325,
 983041,
 367793648,
 367336080,
 -1,
 367859182,
 367754981,
 42797,
 -1,
 367790026,
 42799,
 -59921,
 367811227,
 42863,
 -1,
 367921443,
 572,
 368121334,
 367728398,
 -1,
 368186868,
 368052076,
 -1,
 -59917,
 368140822,
 7552,
 -1,
 368202191,
 7532,
 -59915,
 368143782,
 42823,
 -1,
 368336565,
 7447,
 368514553,
 368086014,
 -1,
 -59912,
 368473572,
 591,
 -1,
 368528598,
 7935,
 368711164,
 368460744,
 -1,
 -59909,
 368670180,
 585,
 -1,
 368714767,
 983597,
 368907775,
 368652162,
 -1,
 -59906,
 368861718,
 7554,
 -1,
 368923087,
 7534,
 -59904,
 368872249,
 7565,
 -1,
 369067892,
 11379,
 369295359,
 351542115,
 -1,
 -59901,
 369196674,
 7550,
 -1,
 369245136,
 7547,
 369491967,
 351502226,
 -1,
 369497607,
 369389318,
 8347,
 -1,
 369433871,
 8340,
 -59896,
 369462022,
 8339,
 -59895,
 369591214,
 7525,
 -59894,
 369655358,
 7524,
 -59893,
 369719039,
 8348,
 -59892,
 369780639,
 7523,
 -59891,
 369844645,
 8346,
 -59890,
 369907754,
 8338,
 -59889,
 369972220,
 8345,
 -59888,
 370036259,
 8344,
 -59887,
 370100077,
 8343,
 -59886,
 370164906,
 8342,
 -59885,
 370230214,
 11388,
 -59884,
 370293645,
 7522,
 -59883,
 370357815,
 8341,
 -59882,
 370419403,
 8337,
 -1,
 370478641,
 8336,
 370677435,
 351411043,
 -1,
 370742828,
 370616011,
 -1,
 370808360,
 370673516,
 -1,
 370873886,
 370771298,
 983554,
 370999295,
 370802746,
 -1,
 -59875,
 370881946,
 983556,
 -1,
 370937720,
 983558,
 371136033,
 370825578,
 -1,
 -59872,
 371096172,
 983584,
 -1,
 371134328,
 983582,
 371332644,
 371074048,
 -1,
 -59869,
 371292780,
 983588,
 -1,
 371330936,
 983586,
 371529255,
 371269014,
 -1,
 -59866,
 371478142,
 983560,
 -1,
 371530644,
 983562,
 -1,
 371488228,
 582,
 371791403,
 370751016,
 -1,
 -59862,
 371738986,
 42786,
 -1,
 371801760,
 42788,
 -1,
 371750655,
 42858,
 372053561,
 370702079,
 -1,
 372119092,
 372015875,
 -1,
 372184624,
 372051505,
 11375,
 -1,
 372133240,
 11376,
 -59855,
 372147118,
 581,
 -59854,
 372262765,
 42880,
 -59853,
 372326579,
 42878,
 -1,
 372389431,
 42893,
 372577846,
 372062765,
 42852,
 -1,
 372508301,
 42854,
 -59849,
 372542961,
 42792,
 -59848,
 372664961,
 42794,
 -1,
 372705288,
 574,
 372905543,
 371985969,
 -1,
 372971072,
 372836204,
 -1,
 373036606,
 372922730,
 -1,
 -59843,
 372996716,
 983580,
 -1,
 373034872,
 983578,
 -59841,
 372995556,
 570,
 -1,
 373182097,
 983552,
 373364290,
 372933550,
 42808,
 -1,
 373295234,
 42810,
 -59837,
 373328840,
 42812,
 -59836,
 373456446,
 42806,
 -59835,
 373512234,
 42804,
 -59834,
 373575032,
 11373,
 -1,
 373624369,
 42802,
 373823061,
 372849549,
 -1,
 373888591,
 373774068,
 -1,
 -59830,
 373847807,
 42886,
 -59829,
 373911302,
 42884,
 -59828,
 373974943,
 42882,
 -59827,
 374026936,
 42877,
 -59826,
 374091601,
 42875,
 -1,
 374153542,
 42873,
 374347348,
 373819244,
 -1,
 374412883,
 374298986,
 -1,
 -59822,
 374372972,
 983594,
 -1,
 374411128,
 983592,
 -1,
 374361745,
 983564,
 -1,
 374304518,
 42860,
 374740576,
 373778335,
 -1,
 374806110,
 374669312,
 -1,
 374871645,
 374770025,
 -1,
 374937179,
 374830847,
 -1,
 -59814,
 374881838,
 983602,
 -1,
 374935775,
 11364,
 -59812,
 374896100,
 588,
 -1,
 375085189,
 42918,
 -1,
 374828534,
 42842,
 -59809,
 374767750,
 42844,
 -1,
 375270920,
 42814,
 375461482,
 374701632,
 -1,
 375527017,
 375425385,
 -1,
 375592550,
 375475845,
 -1,
 -59804,
 375552620,
 983610,
 -59803,
 375600538,
 983576,
 -1,
 375656312,
 983608,
 375914495,
 375544170,
 -1,
 -59800,
 375814764,
 983606,
 -1,
 375852920,
 983604,
 -1,
 375461763,
 580,
 376116850,
 375418630,
 -1,
 376182383,
 376047468,
 -1,
 -59795,
 376145250,
 983574,
 -59794,
 376207008,
 11390,
 -1,
 376264837,
 42920,
 -59792,
 376131429,
 586,
 -59791,
 376387398,
 7838,
 -1,
 376443431,
 42891,
 376641148,
 376068138,
 -1,
 376706683,
 376571756,
 -1,
 376772216,
 376669538,
 983568,
 376897535,
 376700986,
 -1,
 -59785,
 376780186,
 983570,
 -1,
 376835960,
 983572,
 377094143,
 376720491,
 -1,
 -59782,
 376986687,
 42828,
 -1,
 377050528,
 42826,
 -1,
 376657962,
 42830,
 377296514,
 376588155,
 -1,
 -59778,
 377256556,
 983598,
 -59777,
 377311695,
 11362,
 -59776,
 377370791,
 42824,
 -59775,
 377431295,
 11360,
 -1,
 377493379,
 573,
 377689737,
 377242830,
 -1,
 377755269,
 377648612,
 42816,
 -1,
 377684032,
 42820,
 377886344,
 377692486,
 -1,
 -59769,
 377830376,
 42818,
 -1,
 377891922,
 11369,
 -1,
 377837701,
 42914,
 378148494,
 377652142,
 -1,
 -59765,
 378112968,
 42848,
 -59764,
 378159698,
 42850,
 -59763,
 378219174,
 42856,
 -1,
 378275848,
 42846,
 378476180,
 378102233,
 -1,
 378541715,
 378433286,
 -1,
 378607250,
 378502315,
 11363,
 -1,
 378537613,
 42832,
 -1,
 378562450,
 42836,
 -1,
 378483070,
 42834,
 378869403,
 378424867,
 -1,
 378934936,
 378813633,
 -1,
 -59753,
 378897326,
 7932,
 -1,
 378948573,
 7930,
 379191295,
 378865516,
 -1,
 -59750,
 379091564,
 983600,
 -1,
 379140537,
 11374,
 379328160,
 378804880,
 -1,
 379393694,
 379289317,
 42796,
 -1,
 379324362,
 42798,
 -59745,
 379345563,
 42862,
 -1,
 379455779,
 571,
 379655844,
 379270711,
 -1,
 -59742,
 379595472,
 42790,
 -59741,
 379654623,
 11381,
 -1,
 379717624,
 11367,
 379917992,
 379597496,
 -1,
 -59738,
 379866374,
 577,
 -59737,
 379926093,
 983040,
 -1,
 379980007,
 42912,
 380180139,
 379882995,
 -1,
 -59734,
 380139168,
 11391,
 -1,
 380183176,
 11371,
 380376750,
 380144638,
 -1,
 -59731,
 380335588,
 590,
 -1,
 380390614,
 7934,
 380573361,
 380331637,
 -1,
 -59728,
 380532253,
 42838,
 -1,
 380576505,
 42840,
 380769972,
 380523544,
 -1,
 -59725,
 380721285,
 42916,
 -1,
 380773000,
 42896,
 380966583,
 380715976,
 -1,
 -59722,
 380926572,
 983596,
 -1,
 380990948,
 584,
 381163194,
 380901134,
 -1,
 -59719,
 381119910,
 42822,
 -1,
 381159715,
 579,
 -1,
 381126516,
 11378,
 381425375,
 370625135,
 -1,
 381490909,
 381383397,
 -1,
 381556418,
 381449983,
 7451,
 381681663,
 381518595,
 -1,
 -59712,
 381577119,
 7450,
 -59711,
 381636131,
 43002,
 -1,
 381691595,
 11387,
 381884103,
 381511583,
 -1,
 381949638,
 381824511,
 -1,
 -59707,
 381904799,
 7449,
 -1,
 381965308,
 7438,
 -1,
 381911163,
 42870,
 382211786,
 381835306,
 7439,
 -59703,
 382172734,
 7445,
 -1,
 382231296,
 7440,
 382408397,
 382150347,
 7431,
 -59700,
 382373525,
 7459,
 -1,
 382433544,
 7430,
 382605007,
 382340657,
 7424,
 -1,
 382543563,
 7425,
 -59696,
 382569969,
 7458,
 -59695,
 382699324,
 7457,
 -59694,
 382763950,
 7456,
 -59693,
 382828094,
 7452,
 -59692,
 382889734,
 42801,
 -59691,
 382951845,
 7448,
 -59690,
 383012387,
 7437,
 -59689,
 383076227,
 7436,
 -59688,
 383141034,
 7435,
 -59687,
 383206342,
 7434,
 -59686,
 383266641,
 42800,
 -59685,
 383328582,
 7429,
 -59684,
 383392400,
 7428,
 -1,
 383457196,
 7427,
 -59682,
 381453912,
 7460,
 -1,
 383586560,
 7461,
 383844351,
 381365106,
 -1,
 383850211,
 383740609,
 -1,
 -59678,
 383803813,
 43004,
 -1,
 383856465,
 43003,
 384046822,
 383794061,
 -1,
 -59675,
 383997904,
 43005,
 -1,
 384041677,
 43006,
 -1,
 383980575,
 43007,
 384308980,
 351365859,
 -1,
 384374509,
 384260138,
 -1,
 384440044,
 384324872,
 -1,
 -59669,
 384396471,
 68415,
 -1,
 384443468,
 68413,
 -1,
 384395489,
 128310,
 384702192,
 384335249,
 -1,
 -59665,
 384658647,
 68414,
 -1,
 384705651,
 68412,
 384898803,
 384637280,
 -1,
 -59662,
 384836361,
 128311,
 -1,
 384900424,
 128309,
 -1,
 384854486,
 128308,
 385160954,
 384260153,
 -1,
 385226488,
 385102239,
 -1,
 -59657,
 385178267,
 983043,
 -1,
 385226471,
 983044,
 -59655,
 385183096,
 983045,
 -1,
 385371243,
 983046,
 385554173,
 385119531,
 -1,
 -59652,
 385517945,
 127772,
 -1,
 385578696,
 127767,
 -1,
 385492665,
 128030,
 385816739,
 351288205,
 -1,
 385882117,
 385766396,
 -1,
 385947652,
 385820639,
 -1,
 386013073,
 385891538,
 -1,
 386078575,
 385947406,
 -1,
 386144081,
 386009875,
 -1,
 386209560,
 386075280,
 -1,
 386275081,
 386141408,
 -1,
 -59641,
 386223699,
 65669,
 -59640,
 386281314,
 65668,
 -1,
 386335116,
 65667,
 386537228,
 386207226,
 -1,
 -59637,
 386485807,
 65677,
 -1,
 386543446,
 65676,
 386733839,
 386469318,
 -1,
 -59634,
 386682408,
 65675,
 -1,
 386740092,
 65674,
 386930450,
 386665863,
 -1,
 -59631,
 386879030,
 65673,
 -1,
 386936689,
 65672,
 387127061,
 386862413,
 -1,
 -59628,
 387075661,
 65671,
 -1,
 387133276,
 65670,
 -59626,
 387058859,
 65666,
 -59625,
 387255309,
 65665,
 -1,
 387320503,
 65664,
 387520291,
 386141517,
 -1,
 -59622,
 387452410,
 65713,
 -59621,
 387517894,
 65712,
 -59620,
 387583367,
 65711,
 -59619,
 387648845,
 65710,
 -59618,
 387714272,
 65709,
 -59617,
 387779746,
 65708,
 -59616,
 387845193,
 65707,
 -59615,
 387910581,
 65706,
 -59614,
 387975955,
 65705,
 -1,
 388041360,
 65704,
 388241197,
 387452295,
 -1,
 -59611,
 388173306,
 65722,
 -59610,
 388238790,
 65721,
 -59609,
 388304263,
 65720,
 -59608,
 388369780,
 65719,
 -59607,
 388435106,
 65718,
 -59606,
 388500572,
 65717,
 -59605,
 388565923,
 65716,
 -59604,
 388631315,
 65715,
 -1,
 388696720,
 65714,
 388896566,
 388173024,
 -1,
 -59601,
 388828668,
 65703,
 -59600,
 388894150,
 65702,
 -59599,
 388959623,
 65701,
 -59598,
 389024930,
 65699,
 -59597,
 389090362,
 65698,
 -59596,
 389155747,
 65697,
 -59595,
 389221200,
 65696,
 -1,
 389286544,
 65695,
 389486398,
 388828614,
 -1,
 -59592,
 389418490,
 65729,
 -59591,
 389483744,
 65728,
 -59590,
 389549218,
 65727,
 -59589,
 389614650,
 65726,
 -59588,
 389680035,
 65725,
 -59587,
 389745427,
 65724,
 -1,
 389810832,
 65723,
 390010692,
 389418146,
 -1,
 -59584,
 389942605,
 65694,
 -59583,
 390008101,
 65693,
 -59582,
 390073251,
 65692,
 -59581,
 390138688,
 65691,
 -1,
 390204050,
 65690,
 390403914,
 389942179,
 -1,
 -59578,
 390335734,
 65682,
 -59577,
 390401145,
 65681,
 -59576,
 390466500,
 65680,
 -59575,
 390531869,
 65679,
 -1,
 390597342,
 65678,
 390797134,
 390335546,
 -1,
 -59572,
 390728611,
 65687,
 -59571,
 390794106,
 65686,
 -1,
 390859458,
 65685,
 391118847,
 390729210,
 -1,
 -59568,
 390990663,
 65731,
 -1,
 391056016,
 65730,
 391315455,
 386075555,
 -1,
 391321436,
 391187680,
 -1,
 -59564,
 391253498,
 65757,
 -59563,
 391318982,
 65756,
 -59562,
 391384455,
 65755,
 -59561,
 391449933,
 65754,
 -59560,
 391515360,
 65753,
 -59559,
 391580836,
 65752,
 -59558,
 391646266,
 65751,
 -59557,
 391711651,
 65750,
 -1,
 391777043,
 65749,
 391976805,
 391253154,
 -1,
 -59554,
 391908858,
 65748,
 -59553,
 391974342,
 65747,
 -59552,
 392039757,
 65745,
 -59551,
 392105184,
 65744,
 -59550,
 392170633,
 65743,
 -59549,
 392235941,
 65742,
 -59548,
 392301350,
 65741,
 -1,
 392366822,
 65740,
 392566636,
 391908410,
 -1,
 -59545,
 392498509,
 65739,
 -59544,
 392563874,
 65738,
 -59543,
 392629377,
 65737,
 -59542,
 392694691,
 65736,
 -59541,
 392760085,
 65735,
 -1,
 392825554,
 65734,
 393084927,
 392498083,
 -1,
 -59538,
 392957164,
 65733,
 -1,
 393022113,
 65732,
 393281535,
 386041251,
 -1,
 393287567,
 393153443,
 -1,
 393353084,
 393218835,
 -1,
 -59533,
 393285114,
 65778,
 -59532,
 393350598,
 65777,
 -59531,
 393416071,
 65776,
 -59530,
 393481549,
 65775,
 -59529,
 393546976,
 65774,
 -59528,
 393612450,
 65773,
 -59527,
 393677882,
 65772,
 -59526,
 393743267,
 65771,
 -59525,
 393808659,
 65770,
 -1,
 393874064,
 65769,
 394073991,
 393284240,
 -1,
 -59522,
 394006010,
 65768,
 -59521,
 394071494,
 65767,
 -59520,
 394136967,
 65766,
 -59519,
 394202445,
 65765,
 -59518,
 394267872,
 65764,
 -59517,
 394333346,
 65763,
 -59516,
 394398778,
 65762,
 -59515,
 394464163,
 65761,
 -59514,
 394529555,
 65760,
 -1,
 394594960,
 65759,
 394794894,
 394005411,
 -1,
 -59511,
 394726906,
 65784,
 -59510,
 394792390,
 65783,
 -59509,
 394857863,
 65782,
 -59508,
 394923341,
 65781,
 -59507,
 394988451,
 65780,
 -1,
 395053843,
 65779,
 -1,
 394726704,
 65785,
 -59504,
 393219221,
 65786,
 -1,
 395250572,
 65758,
 395450362,
 385971899,
 -1,
 395515879,
 395398129,
 -1,
 395581341,
 395447687,
 -1,
 -59499,
 395513315,
 65572,
 -59498,
 395578771,
 65551,
 -59497,
 395644259,
 65608,
 -59496,
 395709728,
 65592,
 -59495,
 395775179,
 65597,
 -59494,
 395840599,
 65558,
 -59493,
 395905996,
 65567,
 -59492,
 395971386,
 65603,
 -1,
 396036781,
 65554,
 396236711,
 395513056,
 -1,
 -59489,
 396168724,
 65586,
 -59488,
 396234222,
 65585,
 -59487,
 396299662,
 65546,
 -59486,
 396365078,
 65565,
 -59485,
 396430534,
 65591,
 -59484,
 396495988,
 65578,
 -59483,
 396561343,
 65564,
 -59482,
 396626741,
 65545,
 -1,
 396692168,
 65570,
 396892081,
 396168099,
 -1,
 -59479,
 396824073,
 65606,
 -59478,
 396889552,
 65538,
 -59477,
 396955044,
 65577,
 -59476,
 397020521,
 65580,
 -59475,
 397085922,
 65600,
 -59474,
 397151420,
 65562,
 -59473,
 397216868,
 65560,
 -59472,
 397282149,
 65573,
 -1,
 397347581,
 65599,
 397547451,
 396823184,
 -1,
 -59469,
 397479439,
 65582,
 -59468,
 397544904,
 65536,
 -59467,
 397610377,
 65543,
 -59466,
 397675865,
 65561,
 -59465,
 397741339,
 65589,
 -59464,
 397806785,
 65587,
 -59463,
 397872233,
 65566,
 -59462,
 397937662,
 65579,
 -1,
 398002992,
 65541,
 398202820,
 397479245,
 -1,
 -59459,
 398134809,
 65590,
 -59458,
 398200296,
 65610,
 -59457,
 398265759,
 65553,
 -59456,
 398331246,
 65611,
 -59455,
 398396677,
 65550,
 -59454,
 398461939,
 65607,
 -59453,
 398527324,
 65539,
 -1,
 398592717,
 65576,
 398792653,
 398134434,
 -1,
 -59450,
 398724573,
 65605,
 -59449,
 398789967,
 65547,
 -59448,
 398855424,
 65542,
 -59447,
 398920887,
 65552,
 -59446,
 398986300,
 65601,
 -59445,
 399051784,
 65594,
 -59444,
 399117167,
 65583,
 -1,
 399182584,
 65593,
 399382486,
 398724154,
 -1,
 -59441,
 399314436,
 65568,
 -59440,
 399379916,
 65537,
 -59439,
 399445417,
 65588,
 -59438,
 399510868,
 65549,
 -59437,
 399576174,
 65609,
 -59436,
 399641593,
 65574,
 -59435,
 399706986,
 65581,
 -1,
 399772349,
 65563,
 399972319,
 399313683,
 -1,
 -59432,
 399904180,
 65596,
 -59431,
 399969630,
 65571,
 -59430,
 400035089,
 65559,
 -59429,
 400100530,
 65544,
 -59428,
 400165970,
 65557,
 -59427,
 400231427,
 65584,
 -59426,
 400296800,
 65569,
 -1,
 400362202,
 65540,
 400562148,
 399904198,
 -1,
 -59423,
 400493998,
 65612,
 -59422,
 400559335,
 65602,
 -59421,
 400624471,
 65555,
 -1,
 400689842,
 65556,
 400949247,
 400494074,
 -1,
 -59418,
 400821108,
 65613,
 -1,
 400886427,
 65604,
 401145855,
 395464820,
 -1,
 401151981,
 401018310,
 -1,
 -59414,
 401083898,
 65629,
 -59413,
 401149261,
 65628,
 -59412,
 401214522,
 65627,
 -1,
 401279907,
 65626,
 401479664,
 401083725,
 -1,
 -59409,
 401411234,
 65624,
 -1,
 401476666,
 65623,
 401676275,
 401411234,
 -1,
 -59406,
 401608186,
 65621,
 -1,
 401673607,
 65620,
 401872886,
 401607443,
 -1,
 -59403,
 401804794,
 65617,
 -1,
 401870278,
 65616,
 -59401,
 401804739,
 65625,
 -59400,
 402001213,
 65622,
 -59399,
 402066588,
 65619,
 -1,
 402131999,
 65618,
 402391039,
 395399936,
 -1,
 402397187,
 402262803,
 -1,
 402462719,
 402328634,
 -1,
 -59394,
 402394378,
 65689,
 -1,
 402459713,
 65688,
 402659330,
 402394019,
 -1,
 -59391,
 402591188,
 65684,
 -1,
 402656664,
 65683,
 -1,
 402591040,
 65700,
 -1,
 402328610,
 65746,
 -1,
 385893573,
 128279,
 403052640,
 385830435,
 -1,
 403118175,
 402987564,
 -1,
 403183662,
 403065455,
 -1,
 403249164,
 403140358,
 -1,
 -59382,
 403205978,
 6426,
 -59381,
 403256909,
 6425,
 -1,
 403312177,
 6427,
 403511310,
 403213322,
 6421,
 -1,
 403461116,
 6410,
 403642385,
 403470079,
 -1,
 -59376,
 403584589,
 6412,
 -1,
 403639857,
 6411,
 403838996,
 403595685,
 -1,
 -59373,
 403781197,
 6417,
 -1,
 403836465,
 6416,
 404035607,
 403788796,
 -1,
 -59370,
 403976938,
 6405,
 -1,
 404033073,
 6415,
 404232218,
 403981482,
 -1,
 -59367,
 404174413,
 6402,
 -1,
 404229681,
 6401,
 404428829,
 404177862,
 -1,
 -59364,
 404371021,
 6409,
 -1,
 404426289,
 6408,
 404625440,
 404370104,
 -1,
 -59361,
 404567629,
 6404,
 -1,
 404622897,
 6403,
 404822051,
 404562246,
 -1,
 -59358,
 404764237,
 6414,
 -1,
 404819505,
 6413,
 405018662,
 404757136,
 -1,
 -59355,
 404960845,
 6407,
 -1,
 405016113,
 6406,
 405215273,
 404952846,
 -1,
 -59352,
 405157453,
 6419,
 -1,
 405212721,
 6418,
 -59350,
 405178243,
 6424,
 -59349,
 405366781,
 6422,
 -59348,
 405425781,
 6420,
 -59347,
 405489563,
 6423,
 -1,
 405550669,
 6428,
 405739587,
 403140358,
 -1,
 405805114,
 405688152,
 -1,
 405870643,
 405754876,
 -1,
 -59342,
 405811946,
 6449,
 -1,
 405868081,
 6452,
 -59340,
 405829457,
 6451,
 -59339,
 406022141,
 6455,
 -59338,
 406086116,
 6453,
 -59337,
 406146677,
 6454,
 -59336,
 406210459,
 6456,
 -59335,
 406275336,
 6448,
 -1,
 406328208,
 6450,
 406526015,
 405749222,
 -1,
 -59332,
 406482781,
 6459,
 -59331,
 406541157,
 6457,
 -59330,
 406604989,
 6464,
 -1,
 406668806,
 6458,
 406913023,
 406486788,
 -1,
 -59327,
 406817802,
 6441,
 -59326,
 406882179,
 6443,
 -1,
 406939645,
 6442,
 407115855,
 405702300,
 -1,
 407181390,
 407045655,
 -1,
 407246920,
 407113265,
 6432,
 -59321,
 407207486,
 6438,
 -1,
 407255949,
 6436,
 407443530,
 407197738,
 6440,
 -1,
 407394346,
 6437,
 407574604,
 407381707,
 6439,
 -1,
 407512779,
 6435,
 -59315,
 407535166,
 6434,
 -1,
 407649165,
 6433,
 -1,
 407112055,
 6400,
 407902301,
 407053128,
 -1,
 407967827,
 407860991,
 -1,
 -59310,
 407931406,
 6472,
 -1,
 407976588,
 6473,
 408164438,
 407924486,
 -1,
 -59307,
 408109935,
 6476,
 -1,
 408169887,
 6477,
 408361049,
 408104785,
 -1,
 -59304,
 408313620,
 6474,
 -1,
 408372010,
 6475,
 -59302,
 408325720,
 6470,
 -59301,
 408509182,
 6471,
 -59300,
 408573447,
 6479,
 -1,
 408627585,
 6478,
 -59298,
 407856973,
 6469,
 -1,
 408759909,
 6468,
 -1,
 403063524,
 13007,
 409016480,
 403011166,
 -1,
 409082013,
 408963695,
 -1,
 409147504,
 409040639,
 -1,
 409213035,
 409099010,
 -1,
 409278570,
 409162735,
 -1,
 -59290,
 409238049,
 42232,
 -59289,
 409293906,
 42236,
 -59288,
 409355305,
 42237,
 -59287,
 409411901,
 42234,
 -1,
 409475443,
 42235,
 -1,
 409228382,
 42233,
 409737326,
 409169670,
 -1,
 -59283,
 409679437,
 42206,
 -1,
 409734705,
 42205,
 -59281,
 409679437,
 42197,
 -1,
 409865777,
 42196,
 410065011,
 409108030,
 42228,
 -59278,
 410007095,
 42230,
 -1,
 410068683,
 42229,
 410261622,
 410029553,
 -1,
 -59275,
 410203725,
 42211,
 -1,
 410258993,
 42212,
 410458233,
 410218246,
 -1,
 -59272,
 410400333,
 42219,
 -1,
 410455601,
 42210,
 410654844,
 410411429,
 -1,
 -59269,
 410596941,
 42194,
 -1,
 410652209,
 42193,
 410851454,
 410605610,
 42227,
 -1,
 410789579,
 42231,
 410982529,
 410801148,
 -1,
 -59264,
 410923754,
 42213,
 -1,
 410979889,
 42208,
 411179140,
 410928298,
 -1,
 -59261,
 411121229,
 42200,
 -1,
 411176497,
 42199,
 411375751,
 411121207,
 -1,
 -59258,
 411317837,
 42216,
 -1,
 411373105,
 42214,
 411572362,
 411316920,
 -1,
 -59255,
 411514445,
 42221,
 -1,
 411569713,
 42198,
 411768972,
 411510475,
 42224,
 -1,
 411729470,
 42225,
 411900047,
 411705670,
 -1,
 -59250,
 411864577,
 42204,
 -1,
 411897393,
 42195,
 412096658,
 411835024,
 -1,
 -59247,
 412038733,
 42203,
 -1,
 412094001,
 42202,
 412293268,
 412028465,
 42222,
 -1,
 412231371,
 42223,
 -59243,
 412257290,
 42220,
 -59242,
 412388177,
 42215,
 -59241,
 412452739,
 42218,
 -59240,
 412503669,
 42207,
 -59239,
 412567451,
 42209,
 -59238,
 412632036,
 42201,
 -59237,
 412695437,
 42226,
 -59236,
 412757934,
 42217,
 -1,
 412817219,
 42192,
 413073407,
 409036327,
 -1,
 -59233,
 412955303,
 42239,
 -1,
 413015757,
 42238,
 -59231,
 408979214,
 8374,
 -59230,
 413165061,
 128132,
 -1,
 413217990,
 128648,
 413407559,
 385754827,
 -1,
 413473033,
 413360816,
 -1,
 413538523,
 413420143,
 -1,
 413604015,
 413497087,
 -1,
 413669546,
 413562623,
 -1,
 -59223,
 413611597,
 7246,
 -1,
 413666865,
 7245,
 413866157,
 413626118,
 -1,
 -59220,
 413808205,
 7192,
 -1,
 413863473,
 7191,
 -59218,
 413808205,
 7179,
 -1,
 413994545,
 7178,
 414193843,
 413557157,
 -1,
 -59215,
 414140315,
 7183,
 -59214,
 414201421,
 7184,
 -1,
 414256689,
 7182,
 414455991,
 414143484,
 -1,
 -59211,
 414419978,
 7177,
 -59210,
 414462698,
 7173,
 -1,
 414518833,
 7181,
 414718139,
 414401706,
 -1,
 -59207,
 414664603,
 7169,
 -59206,
 414725709,
 7170,
 -1,
 414780977,
 7168,
 414980287,
 414654790,
 -1,
 -59203,
 414944769,
 7193,
 -59202,
 414982562,
 7247,
 -1,
 415043121,
 7180,
 415242434,
 414936838,
 -1,
 -59199,
 415184461,
 7201,
 -1,
 415239729,
 7200,
 415439045,
 415190563,
 -1,
 -59196,
 415385499,
 7190,
 -1,
 415436337,
 7189,
 415635656,
 415381047,
 -1,
 -59193,
 415582107,
 7198,
 -1,
 415632945,
 7197,
 415832267,
 415576760,
 -1,
 -59190,
 415778715,
 7172,
 -1,
 415829553,
 7171,
 416028878,
 415772497,
 -1,
 -59187,
 415975323,
 7186,
 -1,
 416026161,
 7185,
 416225489,
 415963792,
 -1,
 -59184,
 416167501,
 7175,
 -1,
 416222769,
 7174,
 416422100,
 416159502,
 -1,
 -59181,
 416368539,
 7188,
 -1,
 416419377,
 7187,
 -59179,
 416386058,
 7194,
 -59178,
 416581507,
 7202,
 -59177,
 416646084,
 7199,
 -59176,
 416704509,
 7195,
 -59175,
 416761755,
 7196,
 -59174,
 416826340,
 7176,
 -1,
 416878129,
 7203,
 417077481,
 413475656,
 -1,
 417143007,
 417036031,
 -1,
 -59170,
 417106446,
 7234,
 -1,
 417151628,
 7235,
 417339618,
 417099526,
 -1,
 -59167,
 417284975,
 7238,
 -1,
 417344927,
 7239,
 417536229,
 417279825,
 -1,
 -59164,
 417488660,
 7236,
 -1,
 417547050,
 7237,
 -59162,
 417500760,
 7232,
 -59161,
 417684222,
 7233,
 -59160,
 417748487,
 7241,
 -1,
 417802625,
 7240,
 417994995,
 417013503,
 -1,
 418060524,
 417944572,
 7216,
 -1,
 418024686,
 7220,
 418191598,
 418006186,
 7213,
 -1,
 418124540,
 7221,
 -59153,
 418150143,
 7219,
 -59152,
 418277279,
 7218,
 -59151,
 418341285,
 7217,
 -59150,
 418401827,
 7214,
 -1,
 418465645,
 7215,
 418650363,
 417957579,
 -1,
 418715894,
 418610750,
 7210,
 -1,
 418676286,
 7211,
 418846968,
 418666538,
 7208,
 -1,
 418797610,
 7209,
 -59143,
 418790285,
 7207,
 -59142,
 418916043,
 7212,
 -1,
 418975402,
 7206,
 419174658,
 418604583,
 -1,
 419240192,
 419133183,
 -1,
 419305727,
 419197264,
 7231,
 -1,
 419234028,
 7230,
 -1,
 419237523,
 7227,
 -59135,
 419190786,
 7228,
 -1,
 419437663,
 7229,
 419692543,
 419131142,
 -1,
 419698950,
 419593988,
 -1,
 -59131,
 419662858,
 7204,
 -1,
 419719165,
 7205,
 419954687,
 419642854,
 -1,
 -59128,
 419850448,
 7222,
 -1,
 419911540,
 7223,
 420092227,
 413414002,
 -1,
 420157736,
 420054941,
 -1,
 420223259,
 420091098,
 -1,
 420288789,
 420186473,
 -1,
 420354324,
 420247295,
 -1,
 420419857,
 420299187,
 -1,
 -59120,
 420381309,
 11025,
 -1,
 420423126,
 11024,
 420675583,
 420352227,
 -1,
 -59117,
 420578678,
 11065,
 -1,
 420619669,
 11066,
 -1,
 420291792,
 11064,
 420878618,
 420220710,
 -1,
 420944153,
 420833976,
 -1,
 -59112,
 420903538,
 11083,
 -1,
 420942337,
 11074,
 -1,
 420876801,
 11082,
 -1,
 420837891,
 11070,
 421271846,
 420183583,
 -1,
 421337381,
 421205210,
 -1,
 421402916,
 421300585,
 -1,
 421468450,
 421361552,
 11067,
 421593087,
 421398380,
 -1,
 -59103,
 421496182,
 11068,
 -1,
 421537173,
 11069,
 -59101,
 421430646,
 11060,
 -1,
 421668245,
 11061,
 -1,
 421343834,
 11062,
 -1,
 421297277,
 11063,
 -59097,
 421226168,
 11077,
 -1,
 421927162,
 11013,
 422123838,
 420085760,
 -1,
 422189357,
 422080262,
 -1,
 -59093,
 422150057,
 11778,
 -59092,
 422198524,
 11814,
 -1,
 422251068,
 10181,
 422451506,
 422143903,
 -1,
 422517041,
 422395296,
 -1,
 -59088,
 422480015,
 11012,
 -1,
 422516986,
 11020,
 -1,
 422449412,
 11788,
 422779189,
 422397805,
 -1,
 -59084,
 422739979,
 128709,
 -1,
 422797586,
 11804,
 422975800,
 422716365,
 -1,
 -59081,
 422936382,
 11816,
 -1,
 423001282,
 11780,
 423172411,
 422909153,
 -1,
 -59078,
 423129861,
 11056,
 -1,
 423173478,
 11058,
 -59076,
 423134523,
 11808,
 -59075,
 423328729,
 11785,
 -1,
 423370263,
 9948,
 423624703,
 422054239,
 -1,
 423631169,
 423505902,
 4054,
 -1,
 423561273,
 4056,
 -59070,
 423584986,
 128269,
 -1,
 423704280,
 9958,
 -59068,
 420043863,
 128006,
 -59067,
 423842546,
 127819,
 -59066,
 423895729,
 128210,
 -1,
 423956556,
 127811,
 424155523,
 413371336,
 -1,
 424221030,
 424090914,
 -1,
 424286540,
 424179455,
 66199,
 -59061,
 424244991,
 66200,
 -1,
 424293943,
 66185,
 424483150,
 424236028,
 66191,
 -1,
 424432636,
 66193,
 424614224,
 424431139,
 66190,
 -1,
 424562211,
 66192,
 424745298,
 424559786,
 66187,
 -1,
 424690858,
 66196,
 424876372,
 424683211,
 66177,
 -1,
 424825852,
 66202,
 425007446,
 424810254,
 66178,
 -1,
 424949303,
 66179,
 425138520,
 424939057,
 66176,
 -1,
 425087996,
 66201,
 -59047,
 425102833,
 66184,
 -59046,
 425233158,
 66204,
 -59045,
 425297724,
 66183,
 -59044,
 425360958,
 66194,
 -59043,
 425422598,
 66198,
 -59042,
 425486239,
 66197,
 -59041,
 425551475,
 66188,
 -59040,
 425615781,
 66195,
 -59039,
 425674605,
 66189,
 -59038,
 425739206,
 66186,
 -59037,
 425802637,
 66182,
 -59036,
 425866807,
 66203,
 -59035,
 425931448,
 66180,
 -1,
 425992518,
 66181,
 426246143,
 424157978,
 -1,
 426252674,
 426134127,
 -1,
 426318186,
 426211071,
 67887,
 -1,
 426276607,
 67892,
 426449260,
 426274566,
 67891,
 -1,
 426405638,
 67886,
 426580334,
 426398716,
 67883,
 -1,
 426529788,
 67896,
 426711408,
 426526573,
 67881,
 -1,
 426675144,
 67895,
 426842482,
 426649291,
 67876,
 -1,
 426791932,
 67894,
 426973556,
 426774065,
 67872,
 -1,
 426923004,
 67893,
 -59019,
 426937288,
 67879,
 -59018,
 427066286,
 67877,
 -59017,
 427130430,
 67888,
 -59016,
 427190175,
 67885,
 -59015,
 427255411,
 67890,
 -59014,
 427317290,
 67884,
 -59013,
 427380259,
 67882,
 -59012,
 427443370,
 67880,
 -59011,
 427506573,
 67878,
 -59010,
 427569848,
 67874,
 -59009,
 427634513,
 67889,
 -59008,
 427696454,
 67875,
 -59007,
 427760272,
 67897,
 -1,
 427824910,
 67873,
 -1,
 426212433,
 67903,
 428146687,
 424106026,
 -1,
 428153223,
 428049540,
 -1,
 -59002,
 428100200,
 128140,
 -1,
 428161620,
 127977,
 428349834,
 428103068,
 -1,
 -58999,
 428296708,
 11059,
 -1,
 428352437,
 10188,
 428546444,
 428285384,
 128274,
 -1,
 428476604,
 128271,
 -58995,
 428508990,
 128261,
 -58994,
 428638164,
 128557,
 -1,
 428690483,
 127853,
 428875127,
 351237887,
 -1,
 428940327,
 428805681,
 -1,
 429005554,
 428888570,
 -1,
 429071052,
 428963518,
 -1,
 429136340,
 429020156,
 -1,
 429201838,
 429085692,
 -1,
 429267362,
 429151228,
 -1,
 429332890,
 429198897,
 -1,
 -58984,
 429293118,
 983843,
 -58983,
 429341581,
 983840,
 -1,
 429395505,
 983833,
 429595036,
 429293118,
 983836,
 -1,
 429555262,
 983837,
 429726110,
 429545514,
 983841,
 -1,
 429676586,
 983842,
 429857184,
 429669261,
 983834,
 -1,
 429800333,
 983835,
 430047231,
 429795019,
 983838,
 -1,
 429926091,
 983839,
 430119334,
 429198897,
 -1,
 -58972,
 430079550,
 983711,
 -58971,
 430128013,
 983708,
 -1,
 430181937,
 983701,
 430381480,
 430079550,
 983704,
 -1,
 430341694,
 983705,
 430512554,
 430331946,
 983709,
 -1,
 430463018,
 983710,
 430643628,
 430455693,
 983702,
 -1,
 430586765,
 983703,
 430833663,
 430581451,
 983706,
 -1,
 430712523,
 983707,
 430905787,
 429165512,
 -1,
 430971315,
 430837297,
 -1,
 -58959,
 430931518,
 983689,
 -58958,
 430979981,
 983686,
 -1,
 431033905,
 983679,
 431233461,
 430931518,
 983682,
 -1,
 431193662,
 983683,
 431364535,
 431183914,
 983687,
 -1,
 431314986,
 983688,
 431495609,
 431307661,
 983680,
 -1,
 431438733,
 983681,
 431685631,
 431433419,
 983684,
 -1,
 431564491,
 983685,
 431757768,
 430846648,
 -1,
 431823296,
 431689265,
 -1,
 -58946,
 431783486,
 983667,
 -58945,
 431831949,
 983664,
 -1,
 431885873,
 983657,
 432085442,
 431783486,
 983660,
 -1,
 432045630,
 983661,
 432216516,
 432035882,
 983665,
 -1,
 432166954,
 983666,
 432347590,
 432159629,
 983658,
 -1,
 432290701,
 983659,
 432537599,
 432285387,
 983662,
 -1,
 432416459,
 983663,
 432609740,
 431689265,
 -1,
 -58934,
 432569918,
 983733,
 -58933,
 432618381,
 983730,
 -1,
 432672305,
 983723,
 432871886,
 432569918,
 983726,
 -1,
 432832062,
 983727,
 433002960,
 432822314,
 983731,
 -1,
 432953386,
 983732,
 433134034,
 432946061,
 983724,
 -1,
 433077133,
 983725,
 433324031,
 433071819,
 983728,
 -1,
 433202891,
 983729,
 433396220,
 429092614,
 -1,
 433461731,
 433337911,
 -1,
 433527258,
 433393201,
 -1,
 -58920,
 433487422,
 983865,
 -58919,
 433535885,
 983862,
 -1,
 433589809,
 983855,
 433789404,
 433487422,
 983858,
 -1,
 433749566,
 983859,
 433920478,
 433739818,
 983863,
 -1,
 433870890,
 983864,
 434051552,
 433863565,
 983856,
 -1,
 433994637,
 983857,
 434182626,
 433989323,
 983860,
 -1,
 434120395,
 983861,
 -1,
 434138244,
 983911,
 434379248,
 433417990,
 -1,
 434444776,
 434310705,
 -1,
 -58906,
 434404926,
 983876,
 -58905,
 434453389,
 983873,
 -1,
 434507313,
 983866,
 434706922,
 434404926,
 983869,
 -1,
 434667070,
 983870,
 434837996,
 434657322,
 983874,
 -1,
 434788394,
 983875,
 434969070,
 434781069,
 983867,
 -1,
 434912141,
 983868,
 435159039,
 434906827,
 983871,
 -1,
 435037899,
 983872,
 435231220,
 434310705,
 -1,
 -58894,
 435191358,
 983887,
 -58893,
 435239821,
 983884,
 -1,
 435293745,
 983877,
 435493366,
 435191358,
 983880,
 -1,
 435453502,
 983881,
 435624440,
 435443754,
 983885,
 -1,
 435574826,
 983886,
 435755514,
 435567501,
 983878,
 -1,
 435698573,
 983879,
 435945471,
 435693259,
 983882,
 -1,
 435824331,
 983883,
 436017699,
 433342317,
 -1,
 436083223,
 435963757,
 -1,
 436148747,
 436029293,
 -1,
 436214275,
 436080177,
 -1,
 -58879,
 436174398,
 983810,
 -58878,
 436222861,
 983807,
 -1,
 436276785,
 983800,
 436476421,
 436174398,
 983803,
 -1,
 436436542,
 983804,
 436607495,
 436426794,
 983808,
 -1,
 436557866,
 983809,
 436738569,
 436550541,
 983801,
 -1,
 436681613,
 983802,
 436928511,
 436676299,
 983805,
 -1,
 436807371,
 983806,
 437000719,
 436080177,
 -1,
 -58867,
 436960830,
 983821,
 -58866,
 437009293,
 983818,
 -1,
 437063217,
 983811,
 437262865,
 436960830,
 983814,
 -1,
 437222974,
 983815,
 437393939,
 437213226,
 983819,
 -1,
 437344298,
 983820,
 437525013,
 437336973,
 983812,
 -1,
 437468045,
 983813,
 437714943,
 437462731,
 983816,
 -1,
 437593803,
 983817,
 437787163,
 436014641,
 -1,
 -58855,
 437747262,
 983788,
 -58854,
 437795725,
 983785,
 -1,
 437849649,
 983778,
 438049309,
 437747262,
 983781,
 -1,
 438009406,
 983782,
 438180383,
 437999658,
 983786,
 -1,
 438130730,
 983787,
 438311457,
 438123405,
 983779,
 -1,
 438254477,
 983780,
 438501375,
 438249163,
 983783,
 -1,
 438380235,
 983784,
 438573629,
 435963050,
 -1,
 438639153,
 438531285,
 -1,
 438704681,
 438570545,
 983899,
 -58841,
 438664766,
 983910,
 -58840,
 438713229,
 983907,
 -1,
 438767153,
 983900,
 438966827,
 438664766,
 983903,
 -1,
 438926910,
 983904,
 439097901,
 438917162,
 983908,
 -1,
 439048234,
 983909,
 439228975,
 439040909,
 983901,
 -1,
 439171981,
 983902,
 439418879,
 439166667,
 983905,
 -1,
 439297739,
 983906,
 439491125,
 438570545,
 -1,
 -58829,
 439451198,
 983656,
 -58828,
 439499661,
 983653,
 -1,
 439553585,
 983646,
 439753271,
 439451198,
 983649,
 -1,
 439713342,
 983650,
 439884345,
 439703594,
 983654,
 -1,
 439834666,
 983655,
 440015419,
 439827341,
 983647,
 -1,
 439958413,
 983648,
 440205311,
 439953099,
 983651,
 -1,
 440084171,
 983652,
 440277591,
 438531839,
 -1,
 440343115,
 440235775,
 -1,
 440408643,
 440274481,
 -1,
 -58815,
 440368702,
 983700,
 -58814,
 440417165,
 983697,
 -1,
 440471089,
 983690,
 440670789,
 440368702,
 983693,
 -1,
 440630846,
 983694,
 440801863,
 440621098,
 983698,
 -1,
 440752170,
 983699,
 440932937,
 440744845,
 983691,
 -1,
 440875917,
 983692,
 441122815,
 440870603,
 983695,
 -1,
 441001675,
 983696,
 441195087,
 440274481,
 -1,
 -58803,
 441155134,
 983722,
 -58802,
 441203597,
 983719,
 -1,
 441257521,
 983712,
 441457233,
 441155134,
 983715,
 -1,
 441417278,
 983716,
 441588307,
 441407530,
 983720,
 -1,
 441538602,
 983721,
 441719381,
 441531277,
 983713,
 -1,
 441662349,
 983714,
 441909247,
 441657035,
 983717,
 -1,
 441788107,
 983718,
 441981553,
 440231839,
 -1,
 442047077,
 441935775,
 -1,
 442112605,
 441978417,
 -1,
 -58789,
 442072638,
 983832,
 -58788,
 442121101,
 983829,
 -1,
 442175025,
 983822,
 442374751,
 442072638,
 983825,
 -1,
 442334782,
 983826,
 442505825,
 442325034,
 983830,
 -1,
 442456106,
 983831,
 442636899,
 442448781,
 983823,
 -1,
 442579853,
 983824,
 442826751,
 442574539,
 983827,
 -1,
 442705611,
 983828,
 442899049,
 441978417,
 -1,
 -58777,
 442859070,
 983777,
 -58776,
 442907533,
 983774,
 -1,
 442961457,
 983767,
 443161195,
 442859070,
 983770,
 -1,
 443121214,
 983771,
 443292269,
 443111466,
 983775,
 -1,
 443242538,
 983776,
 443423343,
 443235213,
 983768,
 -1,
 443366285,
 983769,
 443613183,
 443360971,
 983772,
 -1,
 443492043,
 983773,
 443685502,
 441945032,
 -1,
 443751030,
 443616817,
 -1,
 -58764,
 443711038,
 983766,
 -58763,
 443759501,
 983763,
 -1,
 443813425,
 983756,
 444013176,
 443711038,
 983759,
 -1,
 443973182,
 983760,
 444144250,
 443963434,
 983764,
 -1,
 444094506,
 983765,
 444275324,
 444087181,
 983757,
 -1,
 444218253,
 983758,
 444465151,
 444212939,
 983761,
 -1,
 444344011,
 983762,
 444537483,
 443646894,
 -1,
 444603011,
 444468785,
 -1,
 -58751,
 444563006,
 983799,
 -58750,
 444611469,
 983796,
 -1,
 444665393,
 983789,
 444865157,
 444563006,
 983792,
 -1,
 444825150,
 983793,
 444996231,
 444815402,
 983797,
 -1,
 444946474,
 983798,
 445127305,
 444939149,
 983790,
 -1,
 445070221,
 983791,
 445317119,
 445064907,
 983794,
 -1,
 445195979,
 983795,
 445389464,
 444490149,
 -1,
 445454992,
 445320753,
 -1,
 -58738,
 445414974,
 983744,
 -58737,
 445463437,
 983741,
 -1,
 445517361,
 983734,
 445717138,
 445414974,
 983737,
 -1,
 445677118,
 983738,
 445848212,
 445667370,
 983742,
 -1,
 445798442,
 983743,
 445979286,
 445791117,
 983735,
 -1,
 445922189,
 983736,
 446169087,
 445916875,
 983739,
 -1,
 446047947,
 983740,
 446241445,
 445337123,
 -1,
 446306973,
 446172721,
 -1,
 -58725,
 446266942,
 983755,
 -58724,
 446315405,
 983752,
 -1,
 446369329,
 983745,
 446569119,
 446266942,
 983748,
 -1,
 446529086,
 983749,
 446700193,
 446519338,
 983753,
 -1,
 446650410,
 983754,
 446831267,
 446643085,
 983746,
 -1,
 446774157,
 983747,
 447021055,
 446768843,
 983750,
 -1,
 446899915,
 983751,
 447093426,
 446186438,
 -1,
 447158954,
 447024689,
 -1,
 -58712,
 447118910,
 983854,
 -58711,
 447167373,
 983851,
 -1,
 447221297,
 983844,
 447421100,
 447118910,
 983847,
 -1,
 447381054,
 983848,
 447552174,
 447371306,
 983852,
 -1,
 447502378,
 983853,
 447683248,
 447495053,
 983845,
 -1,
 447626125,
 983846,
 447873023,
 447620811,
 983849,
 -1,
 447751883,
 983850,
 447945407,
 447034935,
 -1,
 448010935,
 447876657,
 -1,
 -58699,
 447970878,
 983898,
 -58698,
 448019341,
 983895,
 -1,
 448073265,
 983888,
 448273081,
 447970878,
 983891,
 -1,
 448233022,
 983892,
 448404155,
 448223274,
 983896,
 -1,
 448354346,
 983897,
 448535229,
 448347021,
 983889,
 -1,
 448478093,
 983890,
 448724991,
 448472779,
 983893,
 -1,
 448603851,
 983894,
 448856063,
 447879824,
 -1,
 448862916,
 448728625,
 -1,
 -58686,
 448822846,
 983678,
 -58685,
 448871309,
 983675,
 -1,
 448925233,
 983668,
 449125062,
 448822846,
 983671,
 -1,
 449084990,
 983672,
 449256136,
 449075242,
 983676,
 -1,
 449206314,
 983677,
 449387210,
 449198989,
 983669,
 -1,
 449330061,
 983670,
 449576959,
 449324747,
 983673,
 -1,
 449455819,
 983674,
 449649383,
 429005456,
 -1,
 449714918,
 449600472,
 -1,
 449780435,
 449663996,
 983629,
 449845969,
 449729532,
 983627,
 -1,
 449795068,
 983639,
 -58670,
 449809352,
 983625,
 -1,
 449917624,
 983623,
 450108118,
 449736454,
 983643,
 -58667,
 450064134,
 983642,
 -1,
 450115127,
 983641,
 450304729,
 450053997,
 983634,
 450428927,
 450250605,
 983637,
 -1,
 450316141,
 983636,
 450501339,
 450262783,
 983628,
 -1,
 450459391,
 983626,
 450632413,
 450455455,
 983633,
 -1,
 450586527,
 983638,
 450763487,
 450577578,
 983622,
 -1,
 450720981,
 983645,
 -58656,
 450726856,
 983632,
 -58655,
 450855854,
 983635,
 -58654,
 450912677,
 983630,
 -58653,
 450973219,
 983631,
 -58652,
 451036102,
 983640,
 -58651,
 451098167,
 983644,
 -1,
 451156624,
 983624,
 -1,
 449669634,
 3063,
 451418859,
 449585478,
 -1,
 -58647,
 451362268,
 3046,
 -58646,
 451422311,
 3062,
 -1,
 451483370,
 3059,
 -58644,
 451382369,
 3061,
 -58643,
 451636946,
 3065,
 -58642,
 451697247,
 3024,
 -58641,
 451762054,
 3066,
 -58640,
 451826456,
 3060,
 -58639,
 451889805,
 2998,
 -1,
 451941666,
 3064,
 452140067,
 428948367,
 -1,
 452205467,
 452098339,
 -1,
 452270904,
 452151919,
 -1,
 452336397,
 452216685,
 -1,
 452401929,
 452288776,
 -1,
 452467451,
 452347050,
 -1,
 -58631,
 452430673,
 6692,
 -58630,
 452474445,
 6693,
 -1,
 452529713,
 6691,
 452729598,
 452425471,
 -1,
 -58627,
 452671053,
 6709,
 -1,
 452726321,
 6708,
 452926209,
 452682149,
 -1,
 -58624,
 452867661,
 6717,
 -1,
 452922929,
 6715,
 453122820,
 452860560,
 -1,
 -58621,
 453064269,
 6699,
 -1,
 453119537,
 6697,
 -58619,
 453086218,
 6719,
 -58618,
 453275482,
 6698,
 -58617,
 453339403,
 6704,
 -58616,
 453391949,
 6732,
 -1,
 453455790,
 6716,
 453647115,
 452333105,
 6723,
 -1,
 453584587,
 6739,
 -58612,
 453607397,
 6724,
 -1,
 453724059,
 6730,
 453909283,
 452278395,
 -1,
 453974802,
 453865222,
 -1,
 -58608,
 453930842,
 6727,
 -58607,
 453981773,
 6726,
 -1,
 454037041,
 6728,
 454236950,
 453919914,
 -1,
 -58604,
 454200145,
 6690,
 -58603,
 454243917,
 6689,
 -1,
 454299185,
 6688,
 454499097,
 454194943,
 -1,
 -58600,
 454440525,
 6707,
 -1,
 454495793,
 6706,
 454695708,
 454451621,
 -1,
 -58597,
 454637133,
 6713,
 -1,
 454692401,
 6712,
 454892319,
 454630032,
 -1,
 -58594,
 454833741,
 6696,
 -1,
 454889009,
 6695,
 -58592,
 454855690,
 6720,
 -58591,
 455043339,
 6702,
 -58590,
 455095885,
 6729,
 -1,
 455159726,
 6714,
 455351080,
 453863327,
 -1,
 455416615,
 455282225,
 6721,
 -58586,
 455374673,
 6701,
 -1,
 455431250,
 6705,
 -1,
 455376869,
 6722,
 455678764,
 455300092,
 -1,
 -58582,
 455642122,
 6700,
 -58581,
 455684842,
 6694,
 -1,
 455740977,
 6710,
 455940910,
 455638590,
 6735,
 -1,
 455900734,
 6736,
 456071984,
 455883661,
 6733,
 -1,
 456014733,
 6734,
 -58575,
 456034179,
 6725,
 -58574,
 456154095,
 6738,
 -58573,
 456216181,
 6718,
 -58572,
 456275385,
 6740,
 -58571,
 456337606,
 6737,
 -58570,
 456401314,
 6703,
 -58569,
 456464195,
 6711,
 -1,
 456527409,
 6731,
 456727386,
 452227509,
 -1,
 456792899,
 456672426,
 -1,
 456858432,
 456735549,
 -1,
 456923967,
 456787781,
 -1,
 -58563,
 456854752,
 6777,
 -58562,
 456920226,
 6776,
 -1,
 456985658,
 6775,
 -1,
 456853970,
 6780,
 457251650,
 456789691,
 6824,
 -1,
 457197383,
 6825,
 -1,
 457190223,
 6819,
 457448264,
 456748890,
 -1,
 457513798,
 457407238,
 6826,
 -1,
 457459527,
 6827,
 -58553,
 457475993,
 6818,
 -1,
 457590552,
 6752,
 457775949,
 457395900,
 -1,
 457841483,
 457721182,
 6772,
 -1,
 457769617,
 6744,
 -58548,
 457804871,
 6823,
 -1,
 457928584,
 6779,
 458103631,
 457738542,
 6816,
 -1,
 458065798,
 6817,
 458234706,
 458062690,
 -1,
 -58543,
 458165155,
 6774,
 -1,
 458230547,
 6773,
 458431317,
 458188703,
 -1,
 -58540,
 458370601,
 6822,
 -1,
 458427958,
 6778,
 458627928,
 458372663,
 -1,
 -58537,
 458580382,
 6820,
 -1,
 458625788,
 6828,
 -58535,
 458564560,
 6821,
 -1,
 458758838,
 6829,
 458955632,
 456689355,
 -1,
 459021153,
 458905642,
 6763,
 459086687,
 458952243,
 -1,
 -58530,
 459020309,
 6764,
 -1,
 459083552,
 6771,
 -58528,
 459049928,
 6765,
 -1,
 459233322,
 6768,
 459414373,
 458980926,
 6761,
 459479908,
 459374142,
 6762,
 -1,
 459417291,
 6760,
 -1,
 459417291,
 6759,
 459676521,
 459345457,
 6753,
 -58521,
 459619213,
 6769,
 -58520,
 459679435,
 6767,
 -1,
 459738673,
 6755,
 459938668,
 459634431,
 -1,
 -58517,
 459880094,
 6770,
 -1,
 459936250,
 6756,
 460135278,
 459881357,
 6757,
 -1,
 460077965,
 6758,
 -58513,
 460082887,
 6754,
 -1,
 460203723,
 6766,
 460397438,
 458914089,
 -1,
 460462964,
 460355327,
 -1,
 -58509,
 460425742,
 6802,
 -1,
 460470924,
 6803,
 460659575,
 460418822,
 -1,
 -58506,
 460604271,
 6806,
 -1,
 460664223,
 6807,
 460856186,
 460599121,
 -1,
 -58503,
 460807956,
 6804,
 -1,
 460866346,
 6805,
 -58501,
 460820056,
 6800,
 -58500,
 461003518,
 6801,
 -58499,
 461067783,
 6809,
 -1,
 461121921,
 6808,
 461314956,
 460339675,
 -1,
 461380482,
 461272831,
 -1,
 -58495,
 461343246,
 6786,
 -1,
 461388428,
 6787,
 461577093,
 461336326,
 -1,
 -58492,
 461521775,
 6790,
 -1,
 461581727,
 6791,
 461773704,
 461516625,
 -1,
 -58489,
 461725460,
 6788,
 -1,
 461783850,
 6789,
 -58487,
 461737560,
 6784,
 -58486,
 461921022,
 6785,
 -58485,
 461985287,
 6793,
 -1,
 462039425,
 6792,
 462290943,
 461250178,
 -1,
 462298010,
 462182107,
 -1,
 462363539,
 462245411,
 -1,
 462429074,
 462301362,
 -1,
 -58479,
 462383101,
 6741,
 -1,
 462440347,
 6742,
 -1,
 462360113,
 6748,
 462691222,
 462309229,
 -1,
 -58475,
 462643468,
 6746,
 -1,
 462687861,
 6743,
 -58473,
 462647130,
 6750,
 -58472,
 462829697,
 6747,
 -58471,
 462893269,
 6745,
 -1,
 462952259,
 6749,
 -1,
 462245972,
 6783,
 463215609,
 452167135,
 -1,
 463281115,
 463161967,
 -1,
 463346620,
 463228187,
 -1,
 463412130,
 463295484,
 -1,
 -58464,
 463375688,
 43664,
 -58463,
 463427626,
 43672,
 -1,
 463484221,
 43656,
 463674279,
 463357098,
 -1,
 463739814,
 463615543,
 -1,
 -58459,
 463689770,
 43650,
 -1,
 463747458,
 43652,
 -1,
 463689770,
 43648,
 464001962,
 463632127,
 -1,
 -58455,
 463951914,
 43668,
 -1,
 464009602,
 43670,
 464198573,
 463954341,
 -1,
 -58452,
 464148522,
 43676,
 -1,
 464206210,
 43678,
 464395184,
 464132752,
 -1,
 -58449,
 464345130,
 43658,
 -1,
 464402818,
 43660,
 -58447,
 464358728,
 43684,
 -58446,
 464553491,
 43690,
 -58445,
 464614365,
 43662,
 -58444,
 464678264,
 43686,
 -58443,
 464738346,
 43694,
 -58442,
 464802457,
 43682,
 -58441,
 464866411,
 43688,
 -58440,
 464927106,
 43692,
 -58439,
 464991549,
 43654,
 -58438,
 465056156,
 43680,
 -58437,
 465118157,
 43666,
 -1,
 465181043,
 43674,
 465436671,
 463288443,
 -1,
 465443777,
 465327100,
 -1,
 -58433,
 465407304,
 43665,
 -58432,
 465459242,
 43673,
 -1,
 465515837,
 43657,
 465705926,
 465388714,
 -1,
 465771461,
 465647159,
 -1,
 -58428,
 465721386,
 43651,
 -1,
 465779074,
 43653,
 -1,
 465721386,
 43649,
 466033609,
 465663743,
 -1,
 -58424,
 465983530,
 43669,
 -1,
 466041218,
 43671,
 466230220,
 465985957,
 -1,
 -58421,
 466180138,
 43677,
 -1,
 466237826,
 43679,
 466426831,
 466164368,
 -1,
 -58418,
 466376746,
 43659,
 -1,
 466434434,
 43661,
 -58416,
 466390344,
 43685,
 -58415,
 466585107,
 43691,
 -58414,
 466645981,
 43663,
 -58413,
 466709880,
 43687,
 -58412,
 466769962,
 43695,
 -58411,
 466834073,
 43683,
 -58410,
 466898027,
 43689,
 -58409,
 466958722,
 43693,
 -58408,
 467023165,
 43655,
 -58407,
 467087772,
 43681,
 -58406,
 467149773,
 43667,
 -1,
 467212659,
 43675,
 467409898,
 463242914,
 -1,
 467475426,
 467340849,
 -1,
 -58402,
 467438536,
 43708,
 -58401,
 467501029,
 43707,
 -58400,
 467555324,
 43709,
 -58399,
 467619363,
 43710,
 -1,
 467668529,
 43697,
 467868646,
 467435070,
 43700,
 467934181,
 467805899,
 43699,
 -1,
 467865137,
 43705,
 -1,
 467865137,
 43706,
 468130792,
 467811213,
 43698,
 -1,
 468061745,
 43704,
 -58391,
 468080682,
 43702,
 -1,
 468199115,
 43701,
 468392945,
 467367631,
 -1,
 468458478,
 468338386,
 -1,
 -58387,
 468407292,
 43739,
 -1,
 468466578,
 43743,
 -58385,
 468414344,
 43741,
 -58384,
 468604782,
 43740,
 -1,
 468662661,
 43742,
 468851702,
 468351810,
 -1,
 -58381,
 468810159,
 43713,
 -58380,
 468874261,
 43714,
 -58379,
 468932462,
 43712,
 -1,
 468986306,
 43711,
 469237759,
 468799169,
 -1,
 -58376,
 469121313,
 43703,
 -1,
 469177084,
 43696,
 469434367,
 463161646,
 -1,
 469441542,
 469333759,
 -1,
 469507073,
 469392238,
 -1,
 -58371,
 469437773,
 6516,
 -58370,
 469503200,
 6515,
 -58369,
 469568674,
 6514,
 -58368,
 469634106,
 6513,
 -1,
 469699491,
 6512,
 469900292,
 469462790,
 -1,
 -58365,
 469841485,
 6497,
 -1,
 469896753,
 6483,
 -58363,
 469841485,
 6487,
 -1,
 470027825,
 6486,
 470227977,
 469378763,
 6507,
 -58360,
 470169143,
 6502,
 -1,
 470230731,
 6501,
 470424588,
 470158897,
 6499,
 -58357,
 470384613,
 6508,
 -1,
 470432653,
 6509,
 470621198,
 470384190,
 6503,
 -1,
 470558411,
 6506,
 470752273,
 470573477,
 -1,
 -58352,
 470693453,
 6490,
 -1,
 470748721,
 6489,
 470948883,
 470702122,
 6505,
 -1,
 470898730,
 6504,
 471079958,
 470897660,
 -1,
 -58347,
 471020266,
 6482,
 -1,
 471076401,
 6498,
 471276569,
 471024810,
 -1,
 -58344,
 471217741,
 6496,
 -1,
 471273009,
 6480,
 -58342,
 471239690,
 6485,
 -58341,
 471436113,
 6481,
 -58340,
 471499716,
 6493,
 -58339,
 471560026,
 6484,
 -58338,
 471623297,
 6495,
 -58337,
 471682677,
 6491,
 -58336,
 471746459,
 6488,
 -58335,
 471808909,
 6500,
 -58334,
 471873101,
 6494,
 -1,
 471936942,
 6492,
 472128550,
 452088828,
 -1,
 -58331,
 472069195,
 127818,
 -1,
 472125146,
 127883,
 -1,
 472091534,
 128661,
 472390847,
 428877515,
 -1,
 472456350,
 472349615,
 -1,
 472521787,
 472390288,
 -1,
 472587316,
 472471594,
 -1,
 472652849,
 472536060,
 -1,
 472718384,
 472610559,
 -1,
 -58322,
 472672503,
 119563,
 -58321,
 472722195,
 119582,
 -1,
 472780660,
 119573,
 -1,
 472675665,
 119608,
 473104383,
 472601410,
 -1,
 -58317,
 472988702,
 119634,
 -1,
 473050308,
 119630,
 473242681,
 472534235,
 -1,
 473308216,
 473179851,
 -1,
 -58313,
 473257348,
 119590,
 -1,
 473309544,
 119613,
 -1,
 473268964,
 119631,
 -58310,
 473183999,
 119585,
 -1,
 473508634,
 119558,
 473701449,
 472457542,
 -1,
 473766978,
 473643917,
 -1,
 473832512,
 473714211,
 -1,
 -58305,
 473780771,
 119625,
 -1,
 473841712,
 119612,
 -58303,
 473793782,
 119568,
 -1,
 473968752,
 119636,
 474160198,
 473704139,
 -1,
 -58300,
 474112665,
 119623,
 -58299,
 474165283,
 119567,
 -1,
 474226086,
 119586,
 -58297,
 474121107,
 119584,
 -58296,
 474373871,
 119619,
 -1,
 474420348,
 119624,
 474618962,
 473638603,
 -1,
 474684494,
 474567676,
 -1,
 -58292,
 474630225,
 119603,
 -58291,
 474686006,
 119583,
 -1,
 474750844,
 119600,
 -58289,
 474647428,
 119626,
 -58288,
 474904815,
 119610,
 -58287,
 474959934,
 119618,
 -1,
 475010365,
 119580,
 475208796,
 474572703,
 -1,
 475274331,
 475145931,
 -1,
 475339865,
 475229958,
 -1,
 475405400,
 475282317,
 -1,
 -58281,
 475362634,
 119579,
 -1,
 475406952,
 119596,
 -1,
 475358501,
 119598,
 -58278,
 475285849,
 119578,
 -1,
 475598695,
 119572,
 -1,
 475218721,
 119605,
 475864165,
 475148113,
 -1,
 475929696,
 475824215,
 -1,
 -58273,
 475878788,
 119595,
 -1,
 475922691,
 119559,
 476126307,
 475879466,
 -1,
 -58270,
 476083567,
 119638,
 -1,
 476138574,
 119576,
 -58268,
 476072751,
 119606,
 -1,
 476254457,
 119632,
 476453997,
 475819782,
 -1,
 476519531,
 476411647,
 -1,
 476585066,
 476469290,
 -1,
 -58263,
 476546177,
 119601,
 -1,
 476603734,
 119628,
 -1,
 476539461,
 119593,
 -58260,
 476463198,
 119621,
 -1,
 476786153,
 119627,
 476978291,
 476394168,
 -1,
 477043824,
 476911098,
 119592,
 -1,
 476971530,
 119615,
 -58255,
 477003473,
 119614,
 -58254,
 477129129,
 119602,
 -1,
 477190556,
 119599,
 477371513,
 476930469,
 -1,
 477437047,
 477302321,
 -1,
 -58250,
 477396194,
 119604,
 -1,
 477437424,
 119588,
 -58248,
 477397753,
 119594,
 -1,
 477571781,
 119571,
 477764734,
 477302321,
 -1,
 -58245,
 477720484,
 119564,
 -58244,
 477770860,
 119633,
 -58243,
 477832861,
 119577,
 -1,
 477895710,
 119617,
 478092418,
 477711907,
 -1,
 -58240,
 478036467,
 119560,
 -58239,
 478095403,
 119609,
 -1,
 478156125,
 119616,
 478354567,
 478037869,
 -1,
 478420102,
 478285361,
 -1,
 -58235,
 478381906,
 119597,
 -1,
 478419377,
 119637,
 -1,
 478357832,
 119589,
 478682251,
 478287630,
 -1,
 -58231,
 478636244,
 119566,
 -58230,
 478698002,
 119587,
 -1,
 478745805,
 119561,
 478944398,
 478644099,
 -1,
 -58227,
 478902290,
 119620,
 -1,
 478954238,
 119575,
 479141009,
 478894122,
 -1,
 -58224,
 479094132,
 119565,
 -1,
 479155212,
 119635,
 479337620,
 479085738,
 -1,
 -58221,
 479281284,
 119591,
 -1,
 479340800,
 119562,
 479534231,
 479280800,
 -1,
 -58218,
 479483241,
 119622,
 -1,
 479535021,
 119570,
 479730842,
 479475255,
 -1,
 -58215,
 479681057,
 119574,
 -1,
 479728710,
 119629,
 -58213,
 479694183,
 119569,
 -58212,
 479888490,
 119607,
 -58211,
 479953297,
 119611,
 -1,
 480003193,
 119581,
 480189624,
 472401773,
 -1,
 480255156,
 480149522,
 -1,
 480320684,
 480195146,
 -1,
 480386216,
 480278271,
 -1,
 480451749,
 480348776,
 -1,
 -58204,
 480401627,
 3194,
 -1,
 480456126,
 3197,
 480706559,
 480394012,
 -1,
 -58201,
 480598235,
 3195,
 -1,
 480652734,
 3198,
 480844971,
 480336657,
 -1,
 -58198,
 480794843,
 3193,
 -1,
 480849342,
 3196,
 -1,
 480808547,
 3192,
 481107118,
 480282361,
 3170,
 -1,
 481052525,
 3171,
 481238193,
 481063349,
 -1,
 -58192,
 481197447,
 3199,
 -1,
 481236616,
 3133,
 481492991,
 481184367,
 -1,
 -58189,
 481393841,
 3160,
 -1,
 481437379,
 3161,
 481689599,
 480192203,
 -1,
 -58186,
 481592838,
 128250,
 -58185,
 481652668,
 128301,
 -1,
 481715130,
 128222,
 481893564,
 480138236,
 -1,
 -58182,
 481851135,
 9978,
 -58181,
 481908268,
 127934,
 -1,
 481965034,
 8376,
 482213887,
 481824305,
 -1,
 -58178,
 482109402,
 128198,
 -1,
 482156802,
 127861,
 482352420,
 472333197,
 -1,
 482417921,
 482291910,
 -1,
 482483454,
 482364015,
 -1,
 482548972,
 482446280,
 -1,
 482614505,
 482479665,
 11568,
 482680008,
 482550086,
 11575,
 482745543,
 482615622,
 11577,
 -1,
 482686519,
 11578,
 -1,
 482686519,
 11576,
 482942155,
 482643441,
 11619,
 -58166,
 482905585,
 11621,
 -1,
 482948663,
 11594,
 483138766,
 482899711,
 11612,
 -58163,
 483096319,
 11615,
 -1,
 483145271,
 11613,
 483335377,
 483094278,
 11609,
 -58160,
 483290886,
 11610,
 -1,
 483341879,
 11611,
 483531988,
 483280042,
 11581,
 483655679,
 483472951,
 11589,
 -1,
 483538487,
 11583,
 483728599,
 483472056,
 11571,
 483852287,
 483669559,
 11606,
 -1,
 483735095,
 11572,
 483925209,
 483682207,
 11604,
 -1,
 483878815,
 11605,
 484056283,
 483866167,
 11584,
 -1,
 483997239,
 11587,
 484187357,
 483989262,
 11569,
 -1,
 484128311,
 11570,
 -58146,
 484150216,
 11618,
 -58145,
 484280124,
 11617,
 -58144,
 484344750,
 11616,
 -58143,
 484402803,
 11591,
 -58142,
 484467109,
 11602,
 -58141,
 484529148,
 11599,
 -58140,
 484593187,
 11598,
 -58139,
 484657005,
 11597,
 -58138,
 484721606,
 11574,
 -58137,
 484781905,
 11580,
 -58136,
 484842604,
 11614,
 -1,
 484904497,
 11588,
 -58134,
 482573886,
 11603,
 -58133,
 485047181,
 11593,
 -1,
 485109578,
 11579,
 485301496,
 482506495,
 -1,
 485367031,
 485261020,
 -1,
 485432560,
 485311658,
 11582,
 -1,
 485373495,
 11590,
 485563635,
 485372600,
 -1,
 -58126,
 485512188,
 11600,
 -1,
 485570103,
 11607,
 -58124,
 485527189,
 11596,
 -58123,
 485713523,
 11592,
 -58122,
 485774745,
 11601,
 -1,
 485832247,
 11586,
 -1,
 485299929,
 11620,
 486087931,
 485234735,
 -1,
 -58118,
 486032326,
 11573,
 -1,
 486094391,
 11585,
 486342655,
 486018609,
 -1,
 -58115,
 486247627,
 11608,
 -1,
 486291050,
 11595,
 -58113,
 482439210,
 11632,
 -58112,
 486429391,
 11631,
 -1,
 486481646,
 11647,
 486677783,
 482351186,
 -1,
 486743308,
 486625227,
 -1,
 486808838,
 486676238,
 -1,
 -58107,
 486765176,
 4048,
 -1,
 486819083,
 983047,
 -58105,
 486767548,
 4058,
 -58104,
 486955033,
 4050,
 -58103,
 487019138,
 4049,
 -58102,
 487082297,
 4057,
 -58101,
 487145530,
 4051,
 -1,
 487202384,
 4052,
 487398676,
 486698758,
 -1,
 487464209,
 487358229,
 -1,
 -58097,
 487411881,
 3982,
 -58096,
 487475414,
 3981,
 -1,
 487539023,
 3983,
 487784447,
 487407078,
 -1,
 -58093,
 487680351,
 4046,
 -1,
 487735631,
 3980,
 487981055,
 487344751,
 -1,
 -58090,
 487878165,
 3948,
 -1,
 487933646,
 3947,
 488119582,
 486623489,
 -1,
 488185117,
 488081769,
 -1,
 488250652,
 488121329,
 -1,
 -58085,
 488183829,
 11807,
 -1,
 488247072,
 11806,
 -1,
 488205473,
 11803,
 -1,
 488135843,
 11081,
 488578336,
 488059975,
 128005,
 -1,
 488505747,
 128047,
 -58079,
 488532460,
 128555,
 -58078,
 488658909,
 68410,
 -58077,
 488722791,
 9202,
 -1,
 488775147,
 127915,
 488971585,
 482301994,
 -1,
 489037109,
 488926829,
 -1,
 489102644,
 488971697,
 -1,
 489168171,
 489033037,
 -1,
 -58071,
 489098687,
 127552,
 -58070,
 489164089,
 127560,
 -1,
 489229356,
 127557,
 489430318,
 489098631,
 -1,
 -58067,
 489360771,
 127558,
 -1,
 489425679,
 127556,
 489626929,
 489360608,
 -1,
 -58064,
 489559871,
 127555,
 -1,
 489622582,
 127559,
 489881599,
 489557213,
 -1,
 -58061,
 489754099,
 127554,
 -1,
 489818892,
 127553,
 -1,
 489048215,
 127274,
 490085693,
 488989095,
 -1,
 -58057,
 490047956,
 128285,
 -58056,
 490109826,
 9184,
 -58055,
 490171330,
 11811,
 -58054,
 490234494,
 9180,
 -58053,
 490293690,
 11810,
 -58052,
 490354523,
 127913,
 -1,
 490414362,
 9182,
 -58050,
 490034637,
 128069,
 -58049,
 490557486,
 127813,
 -58048,
 490620771,
 128508,
 -1,
 490683955,
 128701,
 490872149,
 488925087,
 -1,
 490937673,
 490821674,
 -1,
 491003208,
 490889637,
 -1,
 491068743,
 490945625,
 -1,
 -58042,
 491008250,
 128032,
 -1,
 491071027,
 127865,
 -1,
 491010939,
 127942,
 -1,
 490949667,
 128654,
 491396431,
 490879885,
 -1,
 491461965,
 491328322,
 -1,
 -58036,
 491417238,
 128208,
 -1,
 491467064,
 128681,
 -58034,
 491397742,
 128305,
 -1,
 491593376,
 8285,
 491789652,
 491327025,
 -1,
 491855186,
 491736611,
 128650,
 -1,
 491782375,
 128651,
 -58029,
 491798176,
 128646,
 -1,
 491921606,
 128668,
 -1,
 491749562,
 127930,
 492182885,
 490812983,
 -1,
 492248415,
 492136977,
 -1,
 492313948,
 492193645,
 -1,
 492379483,
 492257085,
 -1,
 -58022,
 492333977,
 9886,
 -1,
 492390805,
 9887,
 -1,
 492316984,
 11057,
 492699647,
 492249414,
 -1,
 -58018,
 492592715,
 8278,
 -1,
 492650089,
 10176,
 492838244,
 492207678,
 -1,
 492903779,
 492785828,
 -1,
 -58014,
 492864006,
 128077,
 -1,
 492905932,
 128078,
 -1,
 492852455,
 9928,
 -1,
 492789492,
 128173,
 493231470,
 492144444,
 -1,
 493297005,
 493180972,
 -1,
 493362538,
 493233133,
 -1,
 -58007,
 493317923,
 11818,
 -1,
 493356472,
 8282,
 -58005,
 493324964,
 128109,
 -58004,
 493506886,
 128108,
 -1,
 493565860,
 128149,
 -1,
 493240941,
 128256,
 493821302,
 493190718,
 -1,
 493886837,
 493774751,
 -1,
 493952372,
 493835552,
 -1,
 -57998,
 493914367,
 9929,
 -57997,
 493974304,
 8526,
 -1,
 494016801,
 9930,
 -1,
 493910796,
 128034,
 -1,
 493833096,
 127799,
 -1,
 493750877,
 128085,
 494411805,
 428835758,
 -1,
 494477269,
 494341681,
 -1,
 494542548,
 494418831,
 -1,
 494608067,
 494499515,
 -1,
 494673584,
 494554089,
 -1,
 494738863,
 494621692,
 -1,
 494804362,
 494678712,
 42507,
 494869895,
 494744248,
 -1,
 494935426,
 494806731,
 42500,
 -57983,
 494883836,
 42501,
 -1,
 494937803,
 42271,
 495132036,
 494884906,
 42460,
 -1,
 495081514,
 42384,
 -57979,
 495091262,
 42421,
 -57978,
 495205261,
 42308,
 -1,
 495259185,
 42348,
 -57976,
 494819995,
 42428,
 -57975,
 495397427,
 42467,
 -1,
 495456871,
 42315,
 495656344,
 494739782,
 -1,
 495721875,
 495605802,
 42450,
 495787410,
 495667480,
 -1,
 -57970,
 495744026,
 42514,
 -57969,
 495799925,
 42538,
 -57968,
 495863048,
 42513,
 -57967,
 495923118,
 42512,
 -1,
 495985613,
 42539,
 -1,
 495736874,
 42374,
 496246165,
 495658699,
 42490,
 -1,
 496182987,
 42261,
 -57962,
 496205374,
 42411,
 -57961,
 496319373,
 42298,
 -1,
 496373297,
 42337,
 496573856,
 495619016,
 -1,
 496639387,
 496523306,
 42464,
 -1,
 496588842,
 42388,
 496770461,
 496576203,
 42506,
 -1,
 496707275,
 42275,
 -57954,
 496729662,
 42425,
 -57953,
 496843661,
 42312,
 -1,
 496897585,
 42352,
 497098152,
 496518086,
 -1,
 497163683,
 497047594,
 42457,
 -1,
 497113130,
 42381,
 497294757,
 497100491,
 42497,
 -1,
 497231563,
 42268,
 -57946,
 497253950,
 42418,
 -57945,
 497367949,
 42305,
 -1,
 497421873,
 42344,
 497622442,
 497047594,
 42463,
 -1,
 497571882,
 42387,
 497753516,
 497559243,
 42505,
 -1,
 497690315,
 42274,
 -57939,
 497712702,
 42424,
 -57938,
 497826701,
 42311,
 -1,
 497880625,
 42351,
 498081223,
 494685731,
 -1,
 498146744,
 498021280,
 -1,
 498212275,
 498096170,
 42438,
 -1,
 498161706,
 42363,
 498343349,
 498149067,
 42478,
 -1,
 498280139,
 42250,
 -57930,
 498302526,
 42400,
 -57929,
 498416525,
 42287,
 -1,
 498470449,
 42326,
 498671040,
 498079502,
 -1,
 498736571,
 498620458,
 42436,
 -1,
 498685994,
 42361,
 498867645,
 498673355,
 42475,
 -1,
 498804427,
 42248,
 -57922,
 498826814,
 42398,
 -57921,
 498940813,
 42285,
 -1,
 498994737,
 42323,
 499195330,
 498620458,
 42462,
 -1,
 499144746,
 42386,
 499326404,
 499132107,
 42504,
 -1,
 499263179,
 42273,
 -57915,
 499285566,
 42423,
 -57914,
 499399565,
 42310,
 -1,
 499453489,
 42350,
 499654111,
 498016582,
 -1,
 499719640,
 499594807,
 -1,
 499785169,
 499660343,
 -1,
 499850700,
 499734570,
 42446,
 -1,
 499800106,
 42370,
 499981774,
 499787467,
 42486,
 -1,
 499918539,
 42257,
 -57905,
 499940926,
 42407,
 -57904,
 500054925,
 42294,
 -1,
 500108849,
 42333,
 500309459,
 499734570,
 42445,
 -1,
 500258858,
 42369,
 500440533,
 500246219,
 42485,
 -1,
 500377291,
 42256,
 -57898,
 500399678,
 42406,
 -57897,
 500513677,
 42293,
 -1,
 500567601,
 42332,
 500768218,
 499669034,
 42449,
 -1,
 500717610,
 42373,
 500899292,
 500704971,
 42489,
 -1,
 500836043,
 42260,
 -57891,
 500858430,
 42410,
 -57890,
 500972429,
 42297,
 -1,
 501026353,
 42336,
 501226994,
 499598506,
 -1,
 501292522,
 501178789,
 -1,
 501358052,
 501229259,
 42476,
 -57885,
 501306364,
 42477,
 -1,
 501360331,
 42249,
 501554662,
 501307434,
 42437,
 -1,
 501504042,
 42362,
 501685736,
 501485105,
 42324,
 -1,
 501634044,
 42325,
 -57879,
 501644862,
 42399,
 -1,
 501758861,
 42286,
 501947884,
 501241898,
 42459,
 -1,
 501897258,
 42383,
 502078958,
 501884619,
 42499,
 -1,
 502015691,
 42270,
 502210032,
 502009393,
 42346,
 -1,
 502158332,
 42347,
 -57871,
 502169150,
 42420,
 -1,
 502283149,
 42307,
 502472197,
 501166776,
 -1,
 502537725,
 502404878,
 -1,
 502603255,
 502487082,
 42439,
 -57866,
 502552618,
 42364,
 -1,
 502617084,
 42440,
 502799866,
 502539979,
 42479,
 -57863,
 502748156,
 42480,
 -1,
 502802123,
 42251,
 -57861,
 502758974,
 42401,
 -57860,
 502938509,
 42288,
 -1,
 502992433,
 42327,
 503193088,
 502474443,
 42502,
 -57857,
 503141372,
 42503,
 -1,
 503195339,
 42272,
 503389698,
 503142442,
 42461,
 -1,
 503339050,
 42385,
 -57853,
 503348798,
 42422,
 -57852,
 503462797,
 42309,
 -1,
 503516721,
 42349,
 503717397,
 502435313,
 -1,
 503782926,
 503658039,
 -1,
 503848457,
 503732266,
 42454,
 -1,
 503797802,
 42378,
 503979531,
 503785163,
 42494,
 -1,
 503916235,
 42265,
 -57844,
 503938622,
 42415,
 -57843,
 504052621,
 42302,
 -1,
 504106545,
 42341,
 504307216,
 503732266,
 42453,
 -1,
 504256554,
 42377,
 504438290,
 504243915,
 42493,
 -1,
 504374987,
 42264,
 -57837,
 504397374,
 42414,
 -57836,
 504511373,
 42301,
 -1,
 504565297,
 42340,
 504765988,
 503678780,
 -1,
 504831514,
 504715306,
 42431,
 504897049,
 504780842,
 42356,
 -1,
 504845308,
 42357,
 -1,
 504845308,
 42432,
 505093662,
 504768203,
 42470,
 505159197,
 505030347,
 42243,
 -1,
 505107452,
 42244,
 -1,
 505107452,
 42471,
 505355808,
 505052734,
 42393,
 -1,
 505304060,
 42394,
 505486882,
 505297805,
 42280,
 -1,
 505435132,
 42281,
 505675775,
 505417265,
 42318,
 -1,
 505566204,
 42319,
 505749044,
 504723199,
 -1,
 505814573,
 505689655,
 -1,
 505880104,
 505763882,
 42444,
 -1,
 505829418,
 42368,
 506011178,
 505816779,
 42484,
 -1,
 505947851,
 42255,
 -57813,
 505970238,
 42405,
 -57812,
 506084237,
 42292,
 -1,
 506138161,
 42331,
 506338863,
 505763882,
 42443,
 -1,
 506288170,
 42367,
 506469937,
 506275531,
 42483,
 -1,
 506406603,
 42254,
 -57806,
 506428990,
 42404,
 -57805,
 506542989,
 42291,
 -1,
 506596913,
 42330,
 506797636,
 505704198,
 -1,
 506863165,
 506738231,
 -1,
 506928696,
 506812458,
 42452,
 -1,
 506877994,
 42376,
 507059770,
 506865355,
 42492,
 -1,
 506996427,
 42263,
 -57797,
 507018814,
 42413,
 -57796,
 507132813,
 42300,
 -1,
 507186737,
 42339,
 507387455,
 506812458,
 42451,
 -1,
 507336746,
 42375,
 507518529,
 507324107,
 42491,
 -1,
 507455179,
 42262,
 -57790,
 507477566,
 42412,
 -57789,
 507591565,
 42299,
 -1,
 507645489,
 42338,
 507846228,
 506730254,
 -1,
 507911757,
 507786807,
 -1,
 507977288,
 507861034,
 42434,
 -1,
 507926570,
 42359,
 508108362,
 507913931,
 42473,
 -1,
 508045003,
 42246,
 -57781,
 508067390,
 42396,
 -57780,
 508181389,
 42283,
 -1,
 508235313,
 42321,
 508436047,
 507861034,
 42435,
 -1,
 508385322,
 42360,
 508567121,
 508372683,
 42474,
 -1,
 508503755,
 42247,
 -57774,
 508526142,
 42397,
 -57773,
 508640141,
 42284,
 -1,
 508694065,
 42322,
 508894817,
 507786807,
 -1,
 508960344,
 508844074,
 42429,
 -57769,
 508909610,
 42355,
 -1,
 508974076,
 42430,
 509156955,
 508896971,
 42468,
 -57766,
 509105148,
 42469,
 -1,
 509159115,
 42242,
 509353565,
 509115966,
 42391,
 -1,
 509301756,
 42392,
 509484639,
 509295501,
 42278,
 -1,
 509432828,
 42279,
 509673471,
 509414961,
 42316,
 -1,
 509563900,
 42317,
 509746794,
 508839789,
 -1,
 509812325,
 509683403,
 42487,
 -57756,
 509760964,
 42508,
 -1,
 509814475,
 42258,
 510008935,
 509761578,
 42447,
 -1,
 509958186,
 42371,
 -57752,
 509967934,
 42408,
 -57751,
 510081933,
 42295,
 -1,
 510135857,
 42334,
 510336626,
 509709256,
 -1,
 510402157,
 510285866,
 42458,
 -1,
 510351402,
 42382,
 510533231,
 510338763,
 42498,
 -1,
 510469835,
 42269,
 -57744,
 510492222,
 42419,
 -57743,
 510606221,
 42306,
 -1,
 510660145,
 42345,
 510860922,
 510297006,
 -1,
 510926453,
 510810154,
 42442,
 -1,
 510875690,
 42366,
 511057527,
 510863051,
 42482,
 -1,
 510994123,
 42253,
 -57736,
 511016510,
 42403,
 -57735,
 511130509,
 42290,
 -1,
 511184433,
 42329,
 511385218,
 510814111,
 -1,
 511450749,
 511334442,
 42448,
 -1,
 511399978,
 42372,
 511581823,
 511387339,
 42488,
 -1,
 511518411,
 42259,
 -57728,
 511540798,
 42409,
 -57727,
 511654797,
 42296,
 -1,
 511708721,
 42335,
 511909514,
 511336869,
 -1,
 511975045,
 511858730,
 42433,
 -1,
 511924266,
 42358,
 512106119,
 511911627,
 42472,
 -1,
 512042699,
 42245,
 -57720,
 512065086,
 42395,
 -57719,
 512179085,
 42282,
 -1,
 512233009,
 42320,
 512433810,
 511853510,
 -1,
 512499341,
 512383018,
 42456,
 -1,
 512448554,
 42380,
 512630415,
 512435915,
 42496,
 -1,
 512566987,
 42267,
 -57712,
 512589374,
 42417,
 -57711,
 512703373,
 42304,
 -1,
 512757297,
 42343,
 512958106,
 512372561,
 -1,
 513023637,
 512907306,
 42441,
 -1,
 512972842,
 42365,
 513154711,
 512960203,
 42481,
 -1,
 513091275,
 42252,
 -57704,
 513113662,
 42402,
 -57703,
 513227661,
 42289,
 -1,
 513281585,
 42328,
 513482402,
 512891536,
 -1,
 513547933,
 513431594,
 42455,
 -1,
 513497130,
 42379,
 513679007,
 513484491,
 42495,
 -1,
 513615563,
 42266,
 -57696,
 513637950,
 42416,
 -57695,
 513751949,
 42303,
 -1,
 513805873,
 42342,
 514006694,
 513431594,
 42426,
 514072229,
 513955882,
 42353,
 -1,
 514020348,
 42354,
 -1,
 514020348,
 42427,
 514268842,
 513943243,
 42465,
 514334377,
 514205387,
 42240,
 -1,
 514282492,
 42241,
 -1,
 514282492,
 42466,
 514530988,
 514227774,
 42389,
 -1,
 514479100,
 42390,
 514662062,
 514472845,
 42276,
 -1,
 514610172,
 42277,
 514850815,
 514592305,
 42313,
 -1,
 514741244,
 42314,
 514981887,
 494620782,
 -1,
 514989749,
 514881279,
 -1,
 -57677,
 514939763,
 42525,
 -57676,
 514998101,
 42517,
 -1,
 515051178,
 42521,
 515251898,
 514924870,
 -1,
 515317433,
 515201066,
 -1,
 -57672,
 515267443,
 42523,
 -1,
 515312122,
 42526,
 -1,
 515248892,
 42522,
 515579581,
 515196074,
 -1,
 -57668,
 515539287,
 42524,
 -1,
 515582199,
 42516,
 515776192,
 515518289,
 -1,
 -57665,
 515713271,
 42515,
 -1,
 515772074,
 42520,
 -57663,
 515724803,
 42518,
 -57662,
 515916916,
 42527,
 -1,
 515970930,
 42519,
 516169425,
 494543688,
 -1,
 516234951,
 516126463,
 -1,
 -57658,
 516196878,
 42530,
 -1,
 516242060,
 42531,
 516431562,
 516189958,
 -1,
 -57655,
 516375407,
 42534,
 -1,
 516435359,
 42535,
 516628173,
 516370257,
 -1,
 -57652,
 516579092,
 42532,
 -1,
 516637482,
 42533,
 -57650,
 516591192,
 42528,
 -57649,
 516774654,
 42529,
 -57648,
 516838919,
 42537,
 -1,
 516893057,
 42536,
 -57646,
 516122445,
 42511,
 -57645,
 517026471,
 42510,
 -1,
 517086925,
 42509,
 517341183,
 494496561,
 -1,
 517349188,
 517212947,
 -1,
 517414625,
 517279226,
 917762,
 -57640,
 517344762,
 917942,
 -57639,
 517410246,
 917941,
 -57638,
 517475719,
 917940,
 -57637,
 517541197,
 917939,
 -57636,
 517606624,
 917938,
 -57635,
 517672098,
 917937,
 -57634,
 517737530,
 917936,
 -57633,
 517802915,
 917935,
 -57632,
 517868307,
 917934,
 -1,
 517933712,
 917933,
 518135532,
 517344710,
 917761,
 -57629,
 518065658,
 917932,
 -57628,
 518131142,
 917931,
 -57627,
 518196615,
 917930,
 -57626,
 518262093,
 917929,
 -57625,
 518327520,
 917928,
 -57624,
 518392994,
 917927,
 -57623,
 518458426,
 917926,
 -57622,
 518523811,
 917925,
 -57621,
 518589203,
 917924,
 -1,
 518654608,
 917923,
 518856439,
 518065543,
 917760,
 -57618,
 518786554,
 917922,
 -57617,
 518852038,
 917921,
 -57616,
 518917511,
 917920,
 -57615,
 518982989,
 917919,
 -57614,
 519048416,
 917918,
 -57613,
 519113890,
 917917,
 -57612,
 519179322,
 917916,
 -57611,
 519244707,
 917915,
 -57610,
 519310099,
 917914,
 -1,
 519375504,
 917913,
 519577346,
 518786381,
 -1,
 -57607,
 519507450,
 917912,
 -57606,
 519572934,
 917911,
 -57605,
 519638407,
 917910,
 -57604,
 519703885,
 917909,
 -57603,
 519769312,
 917908,
 -57602,
 519834786,
 917907,
 -57601,
 519900218,
 917906,
 -57600,
 519965603,
 917905,
 -57599,
 520030995,
 917904,
 -1,
 520096400,
 917903,
 520298253,
 519507168,
 -1,
 -57596,
 520228346,
 917902,
 -57595,
 520293830,
 917901,
 -57594,
 520359303,
 917900,
 -57593,
 520424781,
 917899,
 -57592,
 520490208,
 917898,
 -57591,
 520555682,
 917897,
 -57590,
 520621114,
 917896,
 -57589,
 520686499,
 917895,
 -57588,
 520751891,
 917894,
 -1,
 520817296,
 917893,
 521019160,
 520228002,
 -1,
 -57585,
 520949242,
 917892,
 -57584,
 521014726,
 917891,
 -57583,
 521080199,
 917890,
 -57582,
 521145677,
 917889,
 -57581,
 521211104,
 917888,
 -57580,
 521276578,
 917887,
 -57579,
 521342010,
 917886,
 -57578,
 521407395,
 917885,
 -57577,
 521472787,
 917884,
 -1,
 521538192,
 917883,
 521740067,
 520948794,
 -1,
 -57574,
 521670138,
 917882,
 -57573,
 521735622,
 917881,
 -57572,
 521801095,
 917880,
 -57571,
 521866573,
 917879,
 -57570,
 521932000,
 917878,
 -57569,
 521997474,
 917877,
 -57568,
 522062906,
 917876,
 -57567,
 522128291,
 917875,
 -57566,
 522193683,
 917874,
 -1,
 522259088,
 917873,
 522460974,
 521669539,
 -1,
 -57563,
 522391034,
 917872,
 -57562,
 522456518,
 917871,
 -57561,
 522521991,
 917870,
 -57560,
 522587469,
 917869,
 -57559,
 522652896,
 917868,
 -57558,
 522718370,
 917867,
 -57557,
 522783802,
 917866,
 -57556,
 522849187,
 917865,
 -57555,
 522914579,
 917864,
 -1,
 522979984,
 917863,
 523181881,
 522390291,
 -1,
 -57552,
 523111930,
 917862,
 -57551,
 523177414,
 917861,
 -57550,
 523242887,
 917860,
 -57549,
 523308365,
 917859,
 -57548,
 523373792,
 917858,
 -57547,
 523439266,
 917857,
 -57546,
 523504698,
 917856,
 -57545,
 523570083,
 917855,
 -57544,
 523635475,
 917854,
 -1,
 523700880,
 917853,
 523960319,
 523111056,
 -1,
 -57541,
 523832826,
 917852,
 -57540,
 523898310,
 917851,
 -57539,
 523963783,
 917850,
 -57538,
 524029261,
 917849,
 -57537,
 524094688,
 917848,
 -57536,
 524160162,
 917847,
 -57535,
 524225594,
 917846,
 -57534,
 524290979,
 917845,
 -57533,
 524356371,
 917844,
 -1,
 524421776,
 917843,
 524623752,
 517278627,
 -1,
 524689232,
 524553378,
 917767,
 -57529,
 524619258,
 917992,
 -57528,
 524684742,
 917991,
 -57527,
 524750215,
 917990,
 -57526,
 524815693,
 917989,
 -57525,
 524881120,
 917988,
 -57524,
 524946594,
 917987,
 -57523,
 525012026,
 917986,
 -57522,
 525077411,
 917985,
 -57521,
 525142803,
 917984,
 -1,
 525208208,
 917983,
 525410139,
 524618810,
 917766,
 -57518,
 525340154,
 917982,
 -57517,
 525405638,
 917981,
 -57516,
 525471111,
 917980,
 -57515,
 525536589,
 917979,
 -57514,
 525602016,
 917978,
 -57513,
 525667490,
 917977,
 -57512,
 525732922,
 917976,
 -57511,
 525798307,
 917975,
 -57510,
 525863699,
 917974,
 -1,
 525929104,
 917973,
 526131046,
 525339555,
 917765,
 -57507,
 526061050,
 917972,
 -57506,
 526126534,
 917971,
 -57505,
 526192007,
 917970,
 -57504,
 526257485,
 917969,
 -57503,
 526322912,
 917968,
 -57502,
 526388386,
 917967,
 -57501,
 526453818,
 917966,
 -57500,
 526519203,
 917965,
 -57499,
 526584595,
 917964,
 -1,
 526650000,
 917963,
 526851953,
 526060307,
 917764,
 -57496,
 526781946,
 917962,
 -57495,
 526847430,
 917961,
 -57494,
 526912903,
 917960,
 -57493,
 526978381,
 917959,
 -57492,
 527043808,
 917958,
 -57491,
 527109282,
 917957,
 -57490,
 527174714,
 917956,
 -57489,
 527240099,
 917955,
 -57488,
 527305491,
 917954,
 -1,
 527370896,
 917953,
 527572860,
 526781072,
 917763,
 -57485,
 527502842,
 917952,
 -57484,
 527568326,
 917951,
 -57483,
 527633799,
 917950,
 -57482,
 527699277,
 917949,
 -57481,
 527764704,
 917948,
 -57480,
 527830178,
 917947,
 -57479,
 527895610,
 917946,
 -57478,
 527960995,
 917945,
 -57477,
 528026387,
 917944,
 -1,
 528091792,
 917943,
 528293764,
 527502560,
 917768,
 -57474,
 528223565,
 917999,
 -57473,
 528288992,
 917998,
 -57472,
 528354466,
 917997,
 -57471,
 528419898,
 917996,
 -57470,
 528485283,
 917995,
 -57469,
 528550675,
 917994,
 -1,
 528616080,
 917993,
 -57467,
 528223738,
 917772,
 -57466,
 528747974,
 917771,
 -57465,
 528813447,
 917770,
 -1,
 528878925,
 917769,
 529080211,
 524553722,
 -1,
 -57462,
 529010170,
 917842,
 -57461,
 529075654,
 917841,
 -57460,
 529141127,
 917840,
 -57459,
 529206605,
 917839,
 -57458,
 529272032,
 917838,
 -57457,
 529337506,
 917837,
 -57456,
 529402938,
 917836,
 -57455,
 529468323,
 917835,
 -57454,
 529533715,
 917834,
 -1,
 529599120,
 917833,
 529801118,
 529010118,
 -1,
 -57451,
 529731066,
 917832,
 -57450,
 529796550,
 917831,
 -57449,
 529862023,
 917830,
 -57448,
 529927501,
 917829,
 -57447,
 529992928,
 917828,
 -57446,
 530058402,
 917827,
 -57445,
 530123834,
 917826,
 -57444,
 530189219,
 917825,
 -57443,
 530254611,
 917824,
 -1,
 530320016,
 917823,
 530522025,
 529730951,
 -1,
 -57440,
 530451962,
 917822,
 -57439,
 530517446,
 917821,
 -57438,
 530582919,
 917820,
 -57437,
 530648397,
 917819,
 -57436,
 530713824,
 917818,
 -57435,
 530779298,
 917817,
 -57434,
 530844730,
 917816,
 -57433,
 530910115,
 917815,
 -57432,
 530975507,
 917814,
 -1,
 531040912,
 917813,
 531242932,
 530451789,
 -1,
 -57429,
 531172858,
 917812,
 -57428,
 531238342,
 917811,
 -57427,
 531303815,
 917810,
 -57426,
 531369293,
 917809,
 -57425,
 531434720,
 917808,
 -57424,
 531500194,
 917807,
 -57423,
 531565626,
 917806,
 -57422,
 531631011,
 917805,
 -57421,
 531696403,
 917804,
 -1,
 531761808,
 917803,
 531963839,
 531172576,
 -1,
 -57418,
 531893754,
 917802,
 -57417,
 531959238,
 917801,
 -57416,
 532024711,
 917800,
 -57415,
 532090189,
 917799,
 -57414,
 532155616,
 917798,
 -57413,
 532221090,
 917797,
 -57412,
 532286522,
 917796,
 -57411,
 532351907,
 917795,
 -57410,
 532417299,
 917794,
 -1,
 532482704,
 917793,
 532684746,
 531893410,
 -1,
 -57407,
 532614650,
 917792,
 -57406,
 532680134,
 917791,
 -57405,
 532745607,
 917790,
 -57404,
 532811085,
 917789,
 -57403,
 532876512,
 917788,
 -57402,
 532941986,
 917787,
 -57401,
 533007418,
 917786,
 -57400,
 533072803,
 917785,
 -57399,
 533138195,
 917784,
 -1,
 533203600,
 917783,
 533463039,
 532614202,
 -1,
 -57396,
 533335546,
 917782,
 -57395,
 533401030,
 917781,
 -57394,
 533466503,
 917780,
 -57393,
 533531981,
 917779,
 -57392,
 533597408,
 917778,
 -57391,
 533662882,
 917777,
 -57390,
 533728314,
 917776,
 -57389,
 533793699,
 917775,
 -57388,
 533859091,
 917774,
 -1,
 533924496,
 917773,
 534126606,
 494413515,
 -1,
 534192133,
 534061876,
 -1,
 534257648,
 534147509,
 -1,
 534323168,
 534187569,
 -1,
 534388703,
 534271930,
 -1,
 534454236,
 534348743,
 7403,
 -1,
 534382896,
 7404,
 -57379,
 534413045,
 7409,
 -57378,
 534517582,
 7402,
 -1,
 534582117,
 7401,
 -1,
 534342002,
 7410,
 534847462,
 534283773,
 -1,
 534912995,
 534806477,
 7395,
 -1,
 534841648,
 7399,
 535044069,
 534844295,
 7397,
 -1,
 534972720,
 7400,
 -1,
 535000728,
 7394,
 535240683,
 534800287,
 -1,
 535306218,
 535178814,
 -1,
 -57367,
 535265229,
 7396,
 -1,
 535303047,
 7398,
 -1,
 535263541,
 7408,
 -57364,
 535202853,
 7380,
 -57363,
 535526143,
 7405,
 -57362,
 535582201,
 7379,
 -57361,
 535645348,
 7407,
 -1,
 535705616,
 7406,
 535953407,
 534215475,
 -1,
 535961590,
 535858201,
 -1,
 536027124,
 535905695,
 7383,
 -1,
 535954943,
 7385,
 -57355,
 535969483,
 7382,
 -1,
 536088712,
 7381,
 536289274,
 535918335,
 -1,
 -57352,
 536250942,
 7390,
 -57351,
 536308983,
 7387,
 -1,
 536361672,
 7391,
 536551421,
 536233224,
 -1,
 -57348,
 536508692,
 7388,
 -1,
 536571447,
 7376,
 536748032,
 536486861,
 -1,
 -57345,
 536706911,
 7386,
 -1,
 536770316,
 7389,
 -57343,
 536703228,
 7377,
 -57342,
 536898654,
 7392,
 -57341,
 536962479,
 7378,
 -57340,
 537008910,
 7384,
 -1,
 537073113,
 7393,
 537272333,
 534146661,
 -1,
 537337865,
 537229055,
 -1,
 -57336,
 537290794,
 128678,
 -1,
 537345582,
 11823,
 -57334,
 537284353,
 9896,
 -57333,
 537480016,
 9168,
 -57332,
 537539087,
 8286,
 -1,
 537597841,
 10186,
 -1,
 537228604,
 9910,
 537862166,
 534068109,
 -1,
 537927700,
 537797242,
 -1,
 537993235,
 537853952,
 -1,
 -57326,
 537932596,
 127918,
 -1,
 537991907,
 128249,
 -1,
 537926563,
 128252,
 -57323,
 537877037,
 127931,
 -1,
 538188260,
 128243,
 538386460,
 537821255,
 -1,
 538451995,
 538336002,
 -1,
 -57319,
 538409120,
 8530,
 -57318,
 538472531,
 8528,
 -1,
 538531366,
 8529,
 -1,
 538414729,
 8585,
 -1,
 538335713,
 127755,
 538845892,
 494366470,
 -1,
 538910941,
 538775089,
 -1,
 538976395,
 538870466,
 -1,
 539041890,
 538921583,
 -1,
 539107368,
 539001774,
 -1,
 539172903,
 539056292,
 -1,
 539238437,
 539125663,
 43144,
 -1,
 539191199,
 43145,
 539426815,
 539182957,
 43146,
 -1,
 539314029,
 43147,
 -1,
 539102769,
 43182,
 539566126,
 539064063,
 -1,
 539631660,
 539522815,
 -1,
 -57301,
 539571789,
 43165,
 -1,
 539627057,
 43164,
 -57299,
 539571789,
 43170,
 -1,
 539758129,
 43169,
 539959347,
 539513852,
 -1,
 -57296,
 539921418,
 43163,
 -57295,
 539972690,
 43168,
 -57294,
 540029674,
 43158,
 -1,
 540085809,
 43173,
 540287033,
 539894086,
 -1,
 540352567,
 540221766,
 -1,
 -57290,
 540292685,
 43167,
 -1,
 540347953,
 43166,
 -57288,
 540292685,
 43172,
 -1,
 540479025,
 43171,
 540680253,
 540216881,
 43138,
 -57285,
 540638782,
 43153,
 -57284,
 540687245,
 43150,
 -1,
 540741169,
 43139,
 540942401,
 540634886,
 -1,
 -57281,
 540897114,
 43184,
 -57280,
 540948045,
 43183,
 -1,
 541003313,
 43185,
 541204547,
 540900926,
 43142,
 -1,
 541163070,
 43143,
 541335622,
 541155749,
 -1,
 -57275,
 541275725,
 43175,
 -1,
 541330993,
 43174,
 541532232,
 541284394,
 43151,
 -1,
 541481002,
 43152,
 541663307,
 541476717,
 -1,
 -57270,
 541607835,
 43187,
 -1,
 541658673,
 43181,
 541859918,
 541607082,
 -1,
 -57267,
 541800013,
 43155,
 -1,
 541855281,
 43154,
 542056529,
 541803462,
 -1,
 -57264,
 541996621,
 43162,
 -1,
 542051889,
 43161,
 542253139,
 541997965,
 43140,
 -1,
 542194573,
 43141,
 542384214,
 542192312,
 -1,
 -57259,
 542324301,
 43157,
 -1,
 542379569,
 43156,
 542580824,
 542320331,
 43148,
 -1,
 542516939,
 43149,
 542711899,
 542513808,
 -1,
 -57254,
 542651981,
 43160,
 -1,
 542707249,
 43159,
 542908510,
 542643982,
 -1,
 -57251,
 542848589,
 43177,
 -1,
 542903857,
 43176,
 -57249,
 542870538,
 43179,
 -57248,
 543057917,
 43180,
 -57247,
 543116917,
 43178,
 -1,
 543176269,
 43186,
 543367284,
 539002571,
 -1,
 543432808,
 543327789,
 -1,
 543498342,
 543385503,
 43194,
 -1,
 543451039,
 43195,
 543686655,
 543442797,
 43196,
 -1,
 543573869,
 43197,
 543760492,
 543362609,
 -1,
 -57238,
 543718974,
 43203,
 -57237,
 543767437,
 43200,
 -1,
 543821361,
 43189,
 544022638,
 543718974,
 43192,
 -1,
 543981118,
 43193,
 544153712,
 543971370,
 43201,
 -1,
 544102442,
 43202,
 544284786,
 544095117,
 43190,
 -1,
 544226189,
 43191,
 544473087,
 544220875,
 43198,
 -1,
 544351947,
 43199,
 544546949,
 543301958,
 -1,
 544612483,
 544488918,
 -1,
 544678009,
 544569087,
 -1,
 -57224,
 544639502,
 43218,
 -1,
 544684684,
 43219,
 544874620,
 544632582,
 -1,
 -57221,
 544818031,
 43222,
 -1,
 544877983,
 43223,
 545071231,
 544812881,
 -1,
 -57218,
 545021716,
 43220,
 -1,
 545080106,
 43221,
 -57216,
 545033816,
 43216,
 -57215,
 545217278,
 43217,
 -57214,
 545281543,
 43225,
 -1,
 545335681,
 43224,
 -57212,
 544562897,
 43215,
 -1,
 545460958,
 43214,
 545661066,
 544502197,
 -1,
 545726601,
 545621452,
 -1,
 -57208,
 545681304,
 43137,
 -1,
 545745099,
 43204,
 -1,
 545657744,
 43136,
 -1,
 545595173,
 43188,
 546054361,
 538922941,
 -1,
 546119847,
 545999471,
 -1,
 546185361,
 546076415,
 -1,
 -57201,
 546140002,
 2065,
 -57200,
 546194070,
 2056,
 -1,
 546246317,
 2069,
 546447509,
 546126733,
 -1,
 -57197,
 546409416,
 2052,
 -57196,
 546469631,
 2055,
 -1,
 546526204,
 2063,
 546709656,
 546402054,
 -1,
 -57193,
 546652158,
 2062,
 -1,
 546715327,
 2068,
 546906267,
 546641678,
 -1,
 -57190,
 546849430,
 2049,
 -1,
 546901674,
 2053,
 -57188,
 546868798,
 2054,
 -57187,
 547065269,
 2057,
 -57186,
 547122456,
 2067,
 -57185,
 547186546,
 2066,
 -57184,
 547248049,
 2061,
 -57183,
 547312155,
 2060,
 -57182,
 547375024,
 2059,
 -57181,
 547439905,
 2058,
 -57180,
 547500846,
 2050,
 -57179,
 547565738,
 2064,
 -57178,
 547627471,
 2051,
 -1,
 547688834,
 2048,
 547889337,
 546080459,
 -1,
 547954862,
 547835038,
 -1,
 548020395,
 547884593,
 2082,
 -1,
 547950129,
 2079,
 -57172,
 547978814,
 2086,
 -57171,
 548092813,
 2089,
 -1,
 548153035,
 2076,
 548348081,
 547903530,
 2091,
 548470783,
 548308237,
 2081,
 -1,
 548343345,
 2078,
 548544692,
 548302598,
 -1,
 -57165,
 548503602,
 2092,
 -1,
 548551230,
 2085,
 548741302,
 548474417,
 2083,
 -1,
 548671025,
 2080,
 -57161,
 548699710,
 2087,
 -57160,
 548813709,
 2090,
 -1,
 548873931,
 2077,
 549069004,
 547841575,
 -1,
 549134529,
 548998705,
 -1,
 549200062,
 549082108,
 -1,
 -57155,
 549147748,
 2110,
 -1,
 549204997,
 2098,
 -57153,
 549157648,
 2100,
 -57152,
 549350724,
 2108,
 -1,
 549401196,
 2097,
 549593284,
 549096945,
 -1,
 -57149,
 549536186,
 2104,
 -1,
 549588947,
 2106,
 549789895,
 549547782,
 -1,
 -57146,
 549738787,
 2109,
 -1,
 549796165,
 2101,
 -57144,
 549748088,
 2107,
 -57143,
 549938842,
 2105,
 -57142,
 549999969,
 2096,
 -57141,
 550064421,
 2103,
 -1,
 550115268,
 2099,
 550314200,
 549015075,
 -1,
 550379732,
 550245495,
 -1,
 550445264,
 550321824,
 2070,
 -1,
 550373735,
 2071,
 -57135,
 550394028,
 2072,
 -57134,
 550524257,
 2093,
 -57133,
 550579027,
 2075,
 -1,
 550642104,
 2073,
 550895615,
 550328577,
 -1,
 -57130,
 550793571,
 2084,
 -57129,
 550845325,
 2088,
 -1,
 550906707,
 2074,
 -1,
 550244069,
 2102,
 -57126,
 546016151,
 127927,
 -57125,
 551123038,
 128225,
 -57124,
 551175633,
 127862,
 -1,
 551239207,
 9973,
 551428459,
 538863337,
 -1,
 551493972,
 551362888,
 -1,
 551559452,
 551426704,
 -1,
 551624986,
 551502925,
 -1,
 551690485,
 551554272,
 -1,
 551756006,
 551619491,
 -1,
 -57116,
 551685564,
 127545,
 -57115,
 551750874,
 127516,
 -1,
 551816093,
 127520,
 552018153,
 551685626,
 -1,
 -57112,
 551947312,
 127511,
 -1,
 552012698,
 127509,
 552214764,
 551947426,
 -1,
 -57109,
 552144031,
 127525,
 -1,
 552209161,
 127540,
 552411375,
 552143930,
 -1,
 -57106,
 552349607,
 127534,
 -1,
 552410123,
 127506,
 -57104,
 552349610,
 127517,
 -57103,
 552542765,
 127532,
 -57102,
 552605496,
 127505,
 -57101,
 552668662,
 127524,
 -57100,
 552734025,
 127546,
 -1,
 552799126,
 127518,
 553001222,
 551619917,
 -1,
 553066746,
 552930211,
 -1,
 -57096,
 552996387,
 127527,
 -57095,
 553061683,
 127537,
 -1,
 553127127,
 127504,
 553328893,
 552996281,
 -1,
 -57092,
 553258490,
 127542,
 -1,
 553323974,
 127543,
 553525504,
 553258208,
 -1,
 -57089,
 553457437,
 127519,
 -1,
 553520682,
 127515,
 553722115,
 553454650,
 -1,
 -57086,
 553651510,
 127528,
 -1,
 553716486,
 127535,
 -57084,
 553660323,
 127526,
 -57083,
 553854907,
 127541,
 -1,
 553913727,
 127513,
 554115342,
 552930695,
 -1,
 554180874,
 554044640,
 -1,
 -57079,
 554110105,
 127544,
 -1,
 554175392,
 127522,
 -57077,
 554115482,
 127521,
 -57076,
 554307238,
 127539,
 -57075,
 554372646,
 127538,
 -1,
 554437512,
 127514,
 554639637,
 554044637,
 -1,
 554705170,
 554568336,
 -1,
 -57071,
 554634746,
 127530,
 -1,
 554699408,
 127529,
 -57069,
 554634915,
 127512,
 -57068,
 554831347,
 127508,
 -1,
 554896435,
 127533,
 555098393,
 554569158,
 -1,
 -57065,
 555032990,
 127536,
 -57064,
 555096754,
 127523,
 -1,
 555159085,
 127510,
 -1,
 555027998,
 127531,
 -57061,
 551574553,
 127378,
 -1,
 555370349,
 127377,
 555557179,
 551503725,
 -1,
 555622712,
 555488799,
 -1,
 -57057,
 555585009,
 127305,
 -57056,
 555649992,
 127304,
 -57055,
 555715334,
 127303,
 -57054,
 555779900,
 127302,
 -57053,
 555844526,
 127301,
 -57052,
 555908670,
 127300,
 -57051,
 555972351,
 127299,
 -57050,
 556035846,
 127298,
 -57049,
 556099487,
 127297,
 -57048,
 556164723,
 127296,
 -57047,
 556229029,
 127295,
 -57046,
 556292138,
 127294,
 -57045,
 556356604,
 127293,
 -57044,
 556420643,
 127292,
 -57043,
 556484461,
 127291,
 -57042,
 556549290,
 127290,
 -57041,
 556614598,
 127289,
 -57040,
 556678029,
 127288,
 -57039,
 556742199,
 127287,
 -57038,
 556806840,
 127286,
 -57037,
 556871505,
 127285,
 -57036,
 556934859,
 127284,
 -57035,
 556998982,
 127283,
 -57034,
 557062800,
 127282,
 -57033,
 557127438,
 127281,
 -1,
 557190705,
 127280,
 557449215,
 555571525,
 -1,
 -57030,
 557342019,
 10191,
 -1,
 557388419,
 10190,
 557588800,
 555511558,
 -1,
 -57027,
 557543174,
 127309,
 -57026,
 557604361,
 127384,
 -57025,
 557654342,
 127308,
 -1,
 557716015,
 9949,
 557916486,
 557532330,
 -1,
 557982021,
 557847959,
 -1,
 -57021,
 557936474,
 127490,
 -57020,
 557991646,
 127489,
 -1,
 558047786,
 127507,
 -1,
 557920074,
 9919,
 558309705,
 557863932,
 -1,
 -57016,
 558248632,
 127382,
 -1,
 558313039,
 127381,
 558506316,
 558247761,
 -1,
 -57013,
 558459405,
 127379,
 -1,
 558522151,
 11820,
 -57011,
 558467114,
 127311,
 -57010,
 558663462,
 127386,
 -57009,
 558727694,
 127385,
 -57008,
 558785926,
 127310,
 -57007,
 558848431,
 127383,
 -57006,
 558912473,
 127307,
 -57005,
 558972090,
 127380,
 -1,
 559037293,
 127306,
 559284223,
 551419904,
 -1,
 559292762,
 559188329,
 -1,
 -57001,
 559252061,
 11028,
 -57000,
 559315816,
 11026,
 -56999,
 559369536,
 11029,
 -1,
 559421855,
 11027,
 559620448,
 559227206,
 -1,
 559685983,
 559566371,
 13175,
 559808511,
 559611904,
 -1,
 -56994,
 559707301,
 13176,
 -1,
 559751398,
 13177,
 -1,
 559629254,
 127376,
 560013667,
 559560247,
 -1,
 -56990,
 559956418,
 127488,
 -1,
 560018104,
 13004,
 560210278,
 559949515,
 -1,
 -56987,
 560169902,
 13006,
 -1,
 560229088,
 13005,
 -56985,
 560169904,
 13278,
 -56984,
 560349991,
 13178,
 -56983,
 560411428,
 13311,
 -56982,
 560476674,
 9974,
 -1,
 560533060,
 13279,
 560734656,
 551386686,
 -1,
 560800187,
 560681980,
 -1,
 560865716,
 560734696,
 -1,
 560931218,
 560810607,
 -1,
 560996723,
 560878588,
 -1,
 -56975,
 560958474,
 7057,
 -56974,
 561001194,
 7053,
 -1,
 561057329,
 7060,
 561258870,
 560951046,
 -1,
 -56971,
 561220618,
 7087,
 -1,
 561253937,
 7070,
 561455481,
 561202346,
 -1,
 -56968,
 561395277,
 7086,
 -1,
 561450545,
 7050,
 561652091,
 561391307,
 7048,
 -1,
 561610302,
 7049,
 561783165,
 561581617,
 7043,
 -1,
 561718987,
 7046,
 -56962,
 561745409,
 7056,
 -56961,
 561875978,
 7066,
 -56960,
 561941329,
 7071,
 -56959,
 562005891,
 7069,
 -56958,
 562070468,
 7063,
 -56957,
 562134590,
 7045,
 -56956,
 562198353,
 7058,
 -56955,
 562259965,
 7067,
 -56954,
 562325121,
 7051,
 -56953,
 562389476,
 7061,
 -56952,
 562452522,
 7047,
 -56951,
 562515573,
 7065,
 -56950,
 562579355,
 7068,
 -56949,
 562643940,
 7055,
 -56948,
 562707341,
 7044,
 -56947,
 562771533,
 7072,
 -56946,
 562836202,
 7052,
 -56945,
 562900910,
 7062,
 -56944,
 562962850,
 7059,
 -56943,
 563026607,
 7054,
 -1,
 563091267,
 7064,
 563290528,
 560866120,
 -1,
 563356054,
 563246847,
 -1,
 -56939,
 563317262,
 7090,
 -1,
 563362444,
 7091,
 563552665,
 563310342,
 -1,
 -56936,
 563495791,
 7094,
 -1,
 563555743,
 7095,
 563749276,
 563490641,
 -1,
 -56933,
 563699476,
 7092,
 -1,
 563757866,
 7093,
 -56931,
 563711576,
 7088,
 -56930,
 563895038,
 7089,
 -56929,
 563959303,
 7097,
 -1,
 564013441,
 7096,
 564208040,
 563250903,
 -1,
 564273575,
 564155388,
 -1,
 -56925,
 564235696,
 7077,
 -56924,
 564288075,
 7079,
 -56923,
 564344015,
 7076,
 -56922,
 564407611,
 7081,
 -1,
 564465623,
 7078,
 -1,
 564220248,
 7080,
 564732335,
 564163026,
 -1,
 564797870,
 564679676,
 -1,
 564863405,
 564736696,
 -1,
 -56916,
 564824408,
 7042,
 -1,
 564873398,
 7041,
 -1,
 564825195,
 7040,
 -1,
 564743800,
 7082,
 565247999,
 564666170,
 -1,
 565256627,
 565139418,
 -1,
 -56910,
 565198358,
 7075,
 -1,
 565252434,
 7074,
 -1,
 565203509,
 7073,
 565518774,
 560819468,
 127749,
 -1,
 565445671,
 127748,
 565649849,
 565444608,
 -1,
 -56904,
 565610873,
 127774,
 -1,
 565647368,
 9925,
 -56902,
 565604416,
 127751,
 -1,
 565784967,
 127803,
 565977534,
 560754438,
 -1,
 -56899,
 565928729,
 128671,
 -1,
 565983271,
 127843,
 -56897,
 565930715,
 127940,
 -1,
 566125427,
 10185,
 566305291,
 560674359,
 -1,
 566370819,
 566234673,
 -1,
 566436354,
 566330286,
 -1,
 566501889,
 566377490,
 -1,
 566567374,
 566431281,
 -1,
 566632904,
 566519711,
 -1,
 -56889,
 566585646,
 66684,
 -1,
 566634187,
 66680,
 -56887,
 566593586,
 66679,
 -56886,
 566784091,
 66664,
 -56885,
 566837695,
 66682,
 -56884,
 566900279,
 66669,
 -56883,
 566965211,
 66673,
 -1,
 567026637,
 66665,
 567222741,
 566515754,
 -1,
 -56880,
 567182184,
 66668,
 -56879,
 567240607,
 66681,
 -56878,
 567304609,
 66677,
 -56877,
 567366652,
 66666,
 -56876,
 567426586,
 66678,
 -1,
 567480644,
 66676,
 567681499,
 567158475,
 -1,
 567747033,
 567610929,
 -1,
 -56872,
 567703295,
 66672,
 -1,
 567764895,
 66685,
 -56870,
 567701010,
 66683,
 -1,
 567882845,
 66663,
 568074720,
 567637759,
 -1,
 568140255,
 568014391,
 -1,
 -56866,
 568081815,
 66644,
 -1,
 568143690,
 66654,
 -1,
 568090156,
 66641,
 568402404,
 568015757,
 -1,
 -56862,
 568340305,
 66662,
 -56861,
 568400938,
 66674,
 -1,
 568463975,
 66686,
 568664551,
 568364126,
 -1,
 -56858,
 568624956,
 66687,
 -1,
 568659505,
 66648,
 568861162,
 568625678,
 -1,
 -56855,
 568809950,
 66667,
 -1,
 568862411,
 66658,
 569057773,
 568815366,
 -1,
 -56852,
 569017060,
 66646,
 -1,
 569071658,
 66645,
 569254384,
 569003555,
 -1,
 -56849,
 569196128,
 66661,
 -1,
 569255979,
 66656,
 569450995,
 569194039,
 -1,
 -56846,
 569409879,
 66649,
 -1,
 569446030,
 66659,
 -56844,
 569413340,
 66655,
 -56843,
 569607832,
 66653,
 -56842,
 569672127,
 66675,
 -56841,
 569732490,
 66670,
 -56840,
 569795287,
 66640,
 -56839,
 569857969,
 66671,
 -56838,
 569920651,
 66660,
 -56837,
 569984628,
 66642,
 -56836,
 570049673,
 66657,
 -56835,
 570110752,
 66652,
 -56834,
 570175549,
 66643,
 -56833,
 570237489,
 66651,
 -56832,
 570301704,
 66647,
 -1,
 570366085,
 66650,
 -1,
 566438026,
 127847,
 -1,
 566383430,
 9752,
 570696199,
 566319146,
 -1,
 -56827,
 570656849,
 128703,
 -56826,
 570715719,
 127856,
 -1,
 570777215,
 127776,
 570958346,
 570637197,
 -1,
 -56823,
 570909093,
 128674,
 -1,
 570971992,
 9961,
 -1,
 570894588,
 128017,
 571220564,
 566266824,
 -1,
 571286088,
 571165936,
 -1,
 571351609,
 571230831,
 -1,
 571417108,
 571307775,
 -1,
 571482642,
 571373311,
 -1,
 -56815,
 571430954,
 43024,
 -1,
 571488642,
 43025,
 -56813,
 571430954,
 43028,
 -1,
 571619714,
 43029,
 571810330,
 571351366,
 -1,
 571875864,
 571744582,
 -1,
 -56809,
 571824170,
 43026,
 -1,
 571881858,
 43027,
 -56807,
 571824170,
 43030,
 -1,
 572012930,
 43031,
 572203549,
 571762591,
 -1,
 -56804,
 572157304,
 43040,
 -1,
 572217386,
 43038,
 572400160,
 572154277,
 -1,
 -56801,
 572348458,
 43033,
 -1,
 572406146,
 43034,
 572596771,
 572343466,
 -1,
 -56798,
 572545066,
 43015,
 -1,
 572602754,
 43016,
 572793382,
 572539846,
 -1,
 -56795,
 572741674,
 43022,
 -1,
 572799362,
 43023,
 572989993,
 572732088,
 -1,
 -56792,
 572938282,
 43017,
 -1,
 572995970,
 43018,
 573186604,
 572922512,
 -1,
 -56789,
 573134890,
 43020,
 -1,
 573192578,
 43021,
 573383215,
 573118222,
 -1,
 -56786,
 573331498,
 43035,
 -1,
 573389186,
 43036,
 -56784,
 573341246,
 43011,
 -56783,
 573535197,
 43041,
 -56782,
 573593642,
 43013,
 -56781,
 573658756,
 43032,
 -56780,
 573723289,
 43037,
 -56779,
 573787243,
 43039,
 -56778,
 573848461,
 43009,
 -56777,
 573913474,
 43042,
 -56776,
 573974219,
 43012,
 -1,
 574033457,
 43008,
 574235199,
 571311819,
 -1,
 -56773,
 574193214,
 43045,
 -56772,
 574249967,
 43047,
 -56771,
 574307213,
 43044,
 -56770,
 574367435,
 43046,
 -1,
 574426673,
 43043,
 574628420,
 574186657,
 -1,
 -56767,
 574557346,
 43051,
 -56766,
 574622778,
 43050,
 -56765,
 574688163,
 43049,
 -1,
 574753555,
 43048,
 575012863,
 574583221,
 -1,
 -56762,
 574895949,
 43014,
 -56761,
 574957229,
 43010,
 -1,
 575017872,
 43019,
 575218259,
 571239201,
 -1,
 575283794,
 575147836,
 -1,
 575349326,
 575239145,
 -1,
 -56756,
 575311539,
 1869,
 -56755,
 575358550,
 1870,
 -1,
 575418400,
 1871,
 575668223,
 575300492,
 -1,
 -56752,
 575550590,
 1838,
 -56751,
 575611578,
 1839,
 -1,
 575674492,
 1837,
 -1,
 575231419,
 128137,
 -1,
 575164540,
 8527,
 576004717,
 571166243,
 -1,
 576070248,
 575945613,
 -1,
 576135783,
 576015221,
 -1,
 576201316,
 576073654,
 -1,
 576266845,
 576150662,
 128515,
 576389119,
 576192570,
 -1,
 -56741,
 576289353,
 128518,
 -56740,
 576353206,
 128516,
 -1,
 576396949,
 128517,
 576594529,
 576206391,
 -1,
 -56737,
 576544202,
 128520,
 -56736,
 576595953,
 128525,
 -1,
 576655889,
 128519,
 576913407,
 576548614,
 -1,
 -56733,
 576815473,
 128526,
 -1,
 576868863,
 128522,
 577110015,
 576134076,
 -1,
 -56730,
 577002630,
 128570,
 -1,
 577058706,
 128571,
 -1,
 576089419,
 128527,
 577315436,
 576000501,
 -1,
 -56726,
 577273253,
 68411,
 -56725,
 577330502,
 128312,
 -1,
 577378662,
 128313,
 -1,
 577264067,
 128684,
 577643138,
 575955365,
 -1,
 577708666,
 577578699,
 -1,
 577774198,
 577638724,
 -1,
 577839733,
 577710984,
 128264,
 577961983,
 577767276,
 -1,
 -56717,
 577862108,
 128266,
 -56716,
 577919813,
 128265,
 -1,
 577968874,
 128263,
 -1,
 577767914,
 128586,
 578232953,
 577709771,
 -1,
 -56712,
 578167318,
 128676,
 -1,
 578231407,
 128172,
 -1,
 578188227,
 8375,
 578495103,
 577637937,
 -1,
 578560638,
 578448726,
 -1,
 -56707,
 578502577,
 128150,
 -1,
 578563151,
 10024,
 -1,
 578499731,
 127837,
 -56704,
 578445228,
 128051,
 -56703,
 578766943,
 128166,
 -1,
 578830799,
 128026,
 579019411,
 577599231,
 -1,
 579084938,
 578948657,
 -1,
 579150471,
 579041023,
 -1,
 -56698,
 579108854,
 128509,
 -1,
 579158431,
 128649,
 579403775,
 579088474,
 -1,
 -56695,
 579286999,
 9882,
 -1,
 579342359,
 9877,
 579543695,
 579037181,
 -1,
 579609230,
 579485083,
 -1,
 -56691,
 579556740,
 9188,
 -1,
 579601893,
 128207,
 -1,
 579569693,
 127827,
 579871378,
 579479510,
 -1,
 -56687,
 579813214,
 127836,
 -1,
 579863233,
 128642,
 -1,
 579820833,
 9201,
 580133534,
 578967594,
 -1,
 580199067,
 580092802,
 -1,
 580264600,
 580159573,
 -1,
 -56681,
 580225167,
 11011,
 -1,
 580262138,
 11019,
 580517887,
 580200456,
 -1,
 -56678,
 580421775,
 11010,
 -1,
 580458746,
 11018,
 -56676,
 580147925,
 128284,
 -56675,
 580596341,
 127846,
 -1,
 580656148,
 9917,
 580854438,
 580069067,
 -1,
 580919970,
 580789963,
 -1,
 -56671,
 580854727,
 127793,
 -1,
 580913642,
 128584,
 -56669,
 580881314,
 9913,
 -56668,
 581072072,
 9916,
 -56667,
 581128796,
 9914,
 -1,
 581178761,
 128186,
 581378733,
 580798317,
 -1,
 581444266,
 581314812,
 -1,
 -56663,
 581405663,
 128554,
 -1,
 581451763,
 128164,
 -56661,
 581393967,
 127920,
 -56660,
 581581919,
 127829,
 -1,
 581637782,
 42611,
 581837492,
 581325820,
 -1,
 581903025,
 581787909,
 -1,
 -56656,
 581848973,
 9924,
 -1,
 581900662,
 127938,
 582156287,
 581832241,
 -1,
 -56653,
 582043086,
 128013,
 -1,
 582106650,
 128012,
 582296249,
 581769872,
 -1,
 582361783,
 582236630,
 127979,
 -1,
 582288886,
 127890,
 -56648,
 582315450,
 128220,
 -1,
 582422978,
 9878,
 582623934,
 582239402,
 -1,
 582689469,
 582564749,
 -1,
 -56644,
 582626184,
 9975,
 -1,
 582680682,
 127935,
 -1,
 582647895,
 128128,
 582951617,
 582584124,
 -1,
 -56640,
 582910299,
 8275,
 -1,
 582958746,
 127946,
 583204863,
 582892429,
 -1,
 -56637,
 583109402,
 128303,
 -1,
 583158504,
 128510,
 583345499,
 538791459,
 -1,
 583410601,
 583292970,
 -1,
 583476105,
 583344953,
 -1,
 583541533,
 583429894,
 -1,
 583607063,
 583487262,
 -1,
 583672535,
 583563007,
 7511,
 583738068,
 583631619,
 -1,
 583803598,
 583667249,
 7492,
 -56627,
 583748984,
 7579,
 -1,
 583804619,
 7494,
 584000208,
 583749155,
 7514,
 -1,
 583928024,
 7597,
 -56623,
 583959470,
 7610,
 -56622,
 584080484,
 7500,
 -56621,
 584137613,
 7502,
 -1,
 584201783,
 7587,
 -56619,
 583687234,
 7508,
 -56618,
 584333299,
 7615,
 -1,
 584386812,
 7605,
 584590048,
 583604880,
 7580,
 584655582,
 584520625,
 -1,
 584721115,
 584596365,
 7590,
 -1,
 584648995,
 7591,
 -56612,
 584678974,
 7608,
 -56611,
 584799228,
 7600,
 -1,
 584861549,
 7595,
 -56609,
 584595495,
 7521,
 -1,
 584976342,
 7581,
 585179877,
 584525515,
 7497,
 -56606,
 585141909,
 7614,
 -56605,
 585201928,
 7582,
 -56604,
 585265243,
 7604,
 -1,
 585323929,
 7505,
 585507563,
 585133830,
 -1,
 585573097,
 585439888,
 -1,
 -56600,
 585526533,
 7586,
 -1,
 585579379,
 7498,
 -56598,
 585514226,
 7513,
 -1,
 585697399,
 7603,
 585900783,
 585438990,
 7495,
 -56595,
 585850549,
 7509,
 -56594,
 585903280,
 7517,
 -1,
 585962679,
 7601,
 586162931,
 585862641,
 7611,
 586285055,
 586090348,
 -1,
 -56590,
 586181265,
 7612,
 -1,
 586227989,
 7613,
 586425078,
 586120766,
 7512,
 -56587,
 586376683,
 7607,
 -1,
 586416305,
 7606,
 586621690,
 586373162,
 7506,
 586743807,
 586572508,
 -1,
 -56583,
 586635306,
 7507,
 -1,
 586688203,
 7499,
 586883838,
 586560184,
 7501,
 587005951,
 586836514,
 -1,
 -56579,
 586900392,
 7520,
 -1,
 586953534,
 7518,
 587145985,
 586817862,
 7496,
 -56576,
 587095699,
 7585,
 -1,
 587147778,
 7519,
 587342596,
 587075121,
 7491,
 -56573,
 587287928,
 7493,
 -1,
 587349664,
 7516,
 587539206,
 587301806,
 7515,
 -1,
 587466871,
 7609,
 587670280,
 587489701,
 7510,
 -1,
 587610151,
 7602,
 587801355,
 587617304,
 -1,
 -56566,
 587754129,
 7599,
 -1,
 587811276,
 7598,
 587997965,
 587746851,
 7504,
 -1,
 587925623,
 7596,
 588129040,
 587941755,
 -1,
 -56561,
 588081809,
 7593,
 -1,
 588145174,
 7594,
 588325651,
 588069773,
 -1,
 -56558,
 588275290,
 7589,
 -1,
 588319011,
 7588,
 -56556,
 588278475,
 7583,
 -56555,
 588465322,
 7503,
 -56554,
 588530640,
 7592,
 -1,
 588590929,
 7584,
 588784410,
 583564312,
 -1,
 -56551,
 588729655,
 42785,
 -1,
 588789939,
 42784,
 589037567,
 588723767,
 -1,
 -56548,
 588930511,
 42890,
 -1,
 588982746,
 765,
 589177669,
 583473808,
 -1,
 589243192,
 589108145,
 -1,
 589308707,
 589195167,
 7487,
 589430783,
 589245951,
 -1,
 -56542,
 589321212,
 7483,
 -1,
 589375179,
 7474,
 589570853,
 589256746,
 7484,
 -1,
 589528638,
 7485,
 589701927,
 589502222,
 7470,
 -1,
 589632687,
 7471,
 589833001,
 589631025,
 7468,
 -1,
 589768395,
 7469,
 -56534,
 589793084,
 7490,
 -56533,
 589923246,
 11389,
 -56532,
 589987390,
 7489,
 -56531,
 590051071,
 7488,
 -56530,
 590111141,
 7486,
 -56529,
 590173180,
 7482,
 -56528,
 590237219,
 7481,
 -56527,
 590301037,
 7480,
 -56526,
 590365866,
 7479,
 -56525,
 590431174,
 7478,
 -56524,
 590494605,
 7477,
 -56523,
 590558775,
 7476,
 -56522,
 590623416,
 7475,
 -56521,
 590685899,
 7473,
 -1,
 590750022,
 7472,
 590947139,
 589183229,
 -1,
 591012670,
 590888611,
 -1,
 -56517,
 590966995,
 42754,
 -56516,
 591031945,
 42758,
 -56515,
 591095473,
 42756,
 -1,
 591160332,
 42752,
 591396863,
 590942976,
 -1,
 -56512,
 591294675,
 42755,
 -56511,
 591359625,
 42759,
 -56510,
 591423153,
 42757,
 -1,
 591488012,
 42753,
 -56508,
 590908834,
 7544,
 -1,
 591616582,
 42889,
 591799128,
 589122839,
 -1,
 591864663,
 591724544,
 -1,
 591930187,
 591808917,
 -1,
 591995722,
 591855780,
 767,
 -1,
 591935350,
 753,
 -1,
 591923812,
 42773,
 592192336,
 591864781,
 -1,
 592257871,
 592149692,
 -1,
 -56498,
 592214841,
 42763,
 -1,
 592267745,
 42768,
 -1,
 592218625,
 751,
 592520019,
 592145185,
 -1,
 -56494,
 592467353,
 755,
 -1,
 592524472,
 754,
 -56492,
 592478667,
 752,
 -56491,
 592673388,
 759,
 -56490,
 592724277,
 42783,
 -1,
 592780676,
 42888,
 -1,
 591801247,
 42778,
 593044329,
 591734475,
 -1,
 593109862,
 593005480,
 -1,
 593175392,
 593055003,
 -1,
 593240926,
 593110161,
 -1,
 -56483,
 593197881,
 42764,
 -1,
 593250785,
 42769,
 -56481,
 593185249,
 42774,
 -1,
 593374995,
 983969,
 593625087,
 593115259,
 -1,
 593634148,
 593503377,
 -1,
 -56477,
 593591097,
 42760,
 -1,
 593644001,
 42765,
 -56475,
 593578465,
 42770,
 -1,
 593768239,
 983968,
 594018303,
 593056943,
 -1,
 -56472,
 593906999,
 764,
 -1,
 593967283,
 762,
 594158452,
 592990655,
 -1,
 594223983,
 594092994,
 -1,
 594289518,
 594158839,
 -1,
 -56467,
 594228640,
 757,
 -1,
 594284414,
 758,
 -1,
 594228640,
 756,
 594608127,
 594149376,
 -1,
 594617203,
 594486417,
 -1,
 -56462,
 594574137,
 42762,
 -1,
 594627041,
 42767,
 -1,
 594561505,
 42772,
 594879354,
 594110551,
 -1,
 -56458,
 594837954,
 42779,
 -56457,
 594886965,
 42782,
 -56456,
 594947685,
 42781,
 -56455,
 595010988,
 42780,
 -1,
 595074720,
 760,
 595272575,
 594819195,
 -1,
 595338110,
 595207313,
 -1,
 -56451,
 595295033,
 42761,
 -1,
 595347937,
 42766,
 -1,
 595282401,
 42771,
 595600259,
 595207153,
 -1,
 -56447,
 595559726,
 42775,
 -56446,
 595620506,
 42776,
 -1,
 595671543,
 42777,
 595862406,
 595531767,
 -1,
 -56443,
 595807543,
 763,
 -1,
 595867827,
 761,
 -56441,
 595821339,
 42864,
 -56440,
 596008088,
 766,
 -1,
 596063290,
 4348,
 596255639,
 583422972,
 -1,
 596321169,
 596203562,
 -1,
 596386704,
 596260219,
 -1,
 596452239,
 596347848,
 -1,
 -56434,
 596393632,
 9867,
 -1,
 596447996,
 9866,
 -1,
 596387842,
 119552,
 -1,
 596338762,
 128669,
 596779923,
 596264500,
 128018,
 -1,
 596705683,
 128053,
 596910998,
 596717389,
 -1,
 -56427,
 596871661,
 128184,
 -1,
 596907850,
 128176,
 -1,
 596849997,
 6314,
 597173154,
 596213310,
 -1,
 597238687,
 597120773,
 -1,
 597304222,
 597168384,
 9968,
 597426175,
 597229568,
 -1,
 -56420,
 597321807,
 128670,
 -56419,
 597367497,
 128672,
 -1,
 597432466,
 128693,
 -1,
 597230003,
 128507,
 597697441,
 597192672,
 128001,
 -1,
 597623187,
 128045,
 -1,
 597653768,
 128068,
 597894054,
 597104825,
 128241,
 598015999,
 597819392,
 -1,
 -56411,
 597920159,
 128242,
 -1,
 597973295,
 128244,
 -56409,
 597855253,
 128511,
 -56408,
 598115796,
 127909,
 -1,
 598170305,
 127889,
 598352973,
 583339569,
 -1,
 598418417,
 598292815,
 -1,
 598483897,
 598372102,
 -1,
 598549425,
 598426495,
 -1,
 598614960,
 598481552,
 -1,
 -56401,
 598557158,
 127006,
 -1,
 598619964,
 126988,
 -1,
 598546278,
 126997,
 598877110,
 598486453,
 -1,
 598942645,
 598809232,
 -1,
 -56396,
 598884838,
 127007,
 -1,
 598947644,
 126989,
 -1,
 598873958,
 126998,
 -56393,
 598835380,
 127015,
 -56392,
 599156165,
 127014,
 -1,
 599220119,
 126977,
 599401412,
 598439679,
 -1,
 599466943,
 599362160,
 -1,
 599532478,
 599399056,
 -1,
 -56387,
 599474662,
 127002,
 -1,
 599537468,
 126984,
 -1,
 599463782,
 126993,
 599851007,
 599407398,
 -1,
 599860163,
 599726736,
 -1,
 -56382,
 599802342,
 127003,
 -1,
 599865148,
 126985,
 -1,
 599791462,
 126994,
 600122319,
 599338833,
 -1,
 600187850,
 600072010,
 -1,
 600253385,
 600119952,
 -1,
 -56376,
 600195558,
 127004,
 -1,
 600258364,
 126986,
 -1,
 600184678,
 126995,
 600571903,
 600130380,
 -1,
 600581070,
 600447632,
 -1,
 -56371,
 600523238,
 127005,
 -1,
 600586044,
 126987,
 -1,
 600512358,
 126996,
 600843222,
 600070186,
 -1,
 600908757,
 600790297,
 -1,
 600974292,
 600840848,
 -1,
 -56365,
 600916454,
 127001,
 -1,
 600979260,
 126983,
 -1,
 600905574,
 126992,
 -1,
 600860993,
 127011,
 601301981,
 600790012,
 -1,
 601367516,
 601243440,
 -1,
 601433051,
 601299600,
 -1,
 -56358,
 601375206,
 127009,
 -1,
 601438012,
 126991,
 -1,
 601364326,
 127000,
 -1,
 601316831,
 126979,
 601760740,
 601237195,
 -1,
 601826275,
 601701798,
 -1,
 601891810,
 601758352,
 -1,
 -56351,
 601833958,
 127008,
 -1,
 601896764,
 126990,
 -1,
 601823078,
 126999,
 -1,
 601757028,
 126976,
 602219496,
 601720636,
 -1,
 -56346,
 602161341,
 127017,
 -56345,
 602224933,
 126982,
 -1,
 602287255,
 126978,
 602481643,
 602150723,
 -1,
 -56342,
 602427542,
 127012,
 -1,
 602480072,
 127019,
 -56340,
 602434017,
 126980,
 -56339,
 602629217,
 127010,
 -56338,
 602686574,
 127018,
 -56337,
 602748377,
 126981,
 -56336,
 602807546,
 127013,
 -1,
 602871425,
 127016,
 603071513,
 598365180,
 128104,
 603137043,
 603005375,
 -1,
 603202575,
 603081327,
 -1,
 603268104,
 603131441,
 -1,
 603333624,
 603221766,
 2126,
 -56329,
 603295217,
 2129,
 -1,
 603338295,
 2132,
 603530234,
 603289343,
 2133,
 -1,
 603485951,
 2120,
 603661308,
 603473066,
 2122,
 -1,
 603615066,
 2121,
 -56323,
 603622897,
 2118,
 -56322,
 603744159,
 2131,
 -56321,
 603809395,
 2130,
 -56320,
 603873701,
 2128,
 -56319,
 603935740,
 2125,
 -56318,
 603999779,
 2124,
 -56317,
 604063597,
 2123,
 -56316,
 604126880,
 2136,
 -56315,
 604190263,
 2116,
 -56314,
 604254904,
 2114,
 -56313,
 604315974,
 2115,
 -1,
 604378894,
 2113,
 604578827,
 603208589,
 -1,
 -56310,
 604534527,
 2119,
 -1,
 604591100,
 2127,
 -56308,
 604537653,
 2117,
 -56307,
 604718388,
 2135,
 -56306,
 604780180,
 2112,
 -1,
 604841620,
 2134,
 -56304,
 603162176,
 2138,
 -56303,
 604988955,
 2142,
 -56302,
 605041690,
 2139,
 -1,
 605098082,
 2137,
 605299736,
 603062272,
 -1,
 605365271,
 605260137,
 -1,
 -56298,
 605322554,
 128115,
 -1,
 605369837,
 128114,
 -1,
 605295302,
 128107,
 -1,
 605253456,
 128094,
 605692987,
 603015021,
 -1,
 605758518,
 605624059,
 -1,
 605824038,
 605702767,
 -1,
 605889571,
 605756625,
 -1,
 605955103,
 605836284,
 3451,
 -1,
 605901820,
 3450,
 606086177,
 605898605,
 3453,
 -1,
 606029677,
 3454,
 -56286,
 606039570,
 3452,
 -1,
 606160042,
 3455,
 -56284,
 605846772,
 3386,
 -56283,
 606295679,
 3369,
 -1,
 606348394,
 3406,
 606544938,
 605783781,
 -1,
 606610473,
 606488429,
 3426,
 -1,
 606553965,
 3427,
 -1,
 606563858,
 3396,
 606807087,
 606492542,
 -1,
 606872622,
 606755586,
 -1,
 -56275,
 606828979,
 3442,
 -1,
 606878539,
 3441,
 -1,
 606828665,
 3440,
 607134772,
 606745152,
 -1,
 607200307,
 607083266,
 -1,
 -56270,
 607151875,
 3443,
 -1,
 607204991,
 3444,
 -1,
 607156685,
 3445,
 -56267,
 607089083,
 3389,
 -1,
 607396344,
 3449,
 607649791,
 605693645,
 -1,
 607659066,
 607553981,
 -1,
 -56263,
 607613360,
 9894,
 -1,
 607654551,
 9895,
 -1,
 607588999,
 9893,
 607921225,
 605649236,
 -1,
 607986751,
 607873951,
 -1,
 -56258,
 607947025,
 10221,
 -1,
 607990114,
 10223,
 608183362,
 607930778,
 -1,
 -56255,
 608143633,
 10220,
 -1,
 608186722,
 10222,
 608379973,
 608125636,
 -1,
 -56252,
 608322502,
 120485,
 -1,
 608385933,
 120484,
 608576584,
 608311687,
 -1,
 -56249,
 608531218,
 120779,
 -1,
 608574291,
 120778,
 -1,
 608530370,
 120001,
 608838732,
 607871397,
 -1,
 -56245,
 608782630,
 127809,
 -1,
 608831049,
 9967,
 -1,
 608792089,
 9901,
 609101033,
 598314066,
 -1,
 609166483,
 609044333,
 -1,
 609232015,
 609103072,
 -1,
 609297515,
 609175105,
 -1,
 609363030,
 609231174,
 -1,
 609428565,
 609296710,
 -1,
 -56236,
 609367629,
 43625,
 -1,
 609422897,
 43624,
 -1,
 609367629,
 43626,
 609690713,
 609320121,
 -1,
 -56232,
 609629773,
 43623,
 -1,
 609685041,
 43622,
 609887324,
 609637372,
 -1,
 -56229,
 609848330,
 43621,
 -1,
 609881649,
 43627,
 610083935,
 609829830,
 -1,
 -56226,
 610022989,
 43620,
 -1,
 610078257,
 43619,
 610280546,
 610022967,
 -1,
 -56223,
 610219597,
 43630,
 -1,
 610274865,
 43629,
 610477157,
 610212496,
 -1,
 -56220,
 610416205,
 43618,
 -1,
 610471473,
 43617,
 -56218,
 610438657,
 43634,
 -56217,
 610634577,
 43633,
 -56216,
 610692954,
 43628,
 -56215,
 610756605,
 43635,
 -56214,
 610808554,
 43616,
 -1,
 610873262,
 43631,
 611067006,
 609251078,
 -1,
 611132541,
 611006147,
 -1,
 611198064,
 611079164,
 -1,
 -56209,
 611159050,
 4218,
 -1,
 611192369,
 4220,
 611394675,
 611140778,
 -1,
 -56206,
 611333709,
 4214,
 -1,
 611388977,
 4213,
 -56204,
 611356161,
 4217,
 -56203,
 611547408,
 4224,
 -56202,
 611607454,
 4221,
 -56201,
 611661389,
 4225,
 -56200,
 611726058,
 4215,
 -56199,
 611790766,
 4222,
 -56198,
 611852706,
 4219,
 -56197,
 611916463,
 4216,
 -56196,
 611981123,
 4223,
 -1,
 612044337,
 4130,
 -1,
 611070866,
 4193,
 612312197,
 611013366,
 -1,
 612377730,
 612243405,
 -1,
 -56191,
 612312779,
 4189,
 -1,
 612372017,
 4188,
 -56189,
 612324786,
 4186,
 -56188,
 612516909,
 4187,
 -1,
 612574923,
 4136,
 612770953,
 612247566,
 -1,
 -56185,
 612732345,
 4207,
 -56184,
 612783732,
 4206,
 -1,
 612840661,
 4208,
 613033100,
 612730971,
 -1,
 -56181,
 612989200,
 4197,
 -1,
 613049967,
 4198,
 -56179,
 612986524,
 4238,
 -56178,
 613168569,
 4159,
 -1,
 613224753,
 43642,
 613482495,
 609179981,
 -1,
 -56175,
 613377696,
 43637,
 -56174,
 613439589,
 43636,
 -1,
 613497198,
 43638,
 613688514,
 609120006,
 -1,
 613754028,
 613629414,
 -1,
 613819552,
 613707966,
 -1,
 613885083,
 613776226,
 -1,
 -56168,
 613813581,
 4234,
 -56167,
 613879008,
 4233,
 -56166,
 613944378,
 4232,
 -1,
 614009763,
 4231,
 614268927,
 613818227,
 -1,
 614278303,
 614169442,
 -1,
 -56162,
 614206522,
 4236,
 -1,
 614271907,
 4235,
 -1,
 614214181,
 4237,
 614540454,
 613779566,
 -1,
 -56158,
 614468832,
 4205,
 -56157,
 614534306,
 4204,
 -56156,
 614599738,
 4203,
 -56155,
 614665123,
 4202,
 -1,
 614730515,
 4201,
 614933673,
 614483529,
 -1,
 -56152,
 614861882,
 4251,
 -1,
 614927123,
 4250,
 -56150,
 614887085,
 4239,
 -56149,
 615080540,
 43643,
 -1,
 615126328,
 4154,
 615326906,
 613693128,
 -1,
 615392432,
 615282431,
 -1,
 -56145,
 615352846,
 4242,
 -1,
 615398028,
 4243,
 615589043,
 615345926,
 -1,
 -56142,
 615531375,
 4246,
 -1,
 615591327,
 4247,
 615785654,
 615526225,
 -1,
 -56139,
 615735060,
 4244,
 -1,
 615793450,
 4245,
 -56137,
 615747160,
 4240,
 -56136,
 615930622,
 4241,
 -56135,
 615994887,
 4249,
 -1,
 616049025,
 4248,
 616300543,
 615288085,
 -1,
 616309951,
 616173858,
 -1,
 -56131,
 616267149,
 43641,
 -56130,
 616323838,
 43640,
 -1,
 616377945,
 43639,
 616628223,
 616263870,
 -1,
 -56127,
 616520446,
 4254,
 -1,
 616574553,
 4255,
 616768729,
 613648075,
 -1,
 616834250,
 616722182,
 -1,
 616899785,
 616773315,
 -1,
 616965319,
 616834763,
 4228,
 -1,
 616890373,
 4229,
 -56120,
 616902888,
 4230,
 -1,
 617025194,
 4227,
 -1,
 616838021,
 4194,
 617293006,
 616777154,
 -1,
 -56116,
 617250366,
 4211,
 -56115,
 617306390,
 4210,
 -1,
 617359558,
 4212,
 617555153,
 617252955,
 -1,
 -56112,
 617512933,
 4200,
 -1,
 617557254,
 4199,
 617751764,
 617501430,
 -1,
 -56109,
 617699370,
 4148,
 -1,
 617758213,
 4147,
 617948374,
 617681193,
 4252,
 -1,
 617888653,
 4253,
 -56105,
 617904093,
 4139,
 -56104,
 618017784,
 4209,
 -1,
 618079952,
 4149,
 618276069,
 616701695,
 -1,
 618341604,
 618221091,
 -1,
 618407136,
 618277042,
 -1,
 -56099,
 618368010,
 4155,
 -56098,
 618432387,
 4157,
 -56097,
 618489853,
 4156,
 -1,
 618542669,
 4158,
 618790911,
 618355372,
 -1,
 -56094,
 618681426,
 4190,
 -56093,
 618745461,
 4191,
 -1,
 618809243,
 4192,
 -1,
 618295492,
 4226,
 619062504,
 618232652,
 -1,
 -56089,
 619005411,
 4196,
 -1,
 619067236,
 4195,
 -1,
 619008682,
 43632,
 619324745,
 609035979,
 -1,
 619390258,
 619261108,
 -1,
 619455769,
 619333485,
 -1,
 619521304,
 619392224,
 -1,
 619586802,
 619467772,
 -1,
 619652336,
 619525492,
 43977,
 -1,
 619578068,
 44001,
 619839487,
 619580977,
 43973,
 -1,
 619709140,
 43999,
 619914486,
 619542271,
 -1,
 619980021,
 619855386,
 43975,
 -1,
 619905748,
 44000,
 -1,
 619919962,
 43978,
 620176634,
 619864485,
 -1,
 620242169,
 620105265,
 43972,
 -1,
 620167892,
 43998,
 -1,
 620181146,
 43984,
 620438782,
 620119210,
 -1,
 620504317,
 620386735,
 43968,
 -1,
 620430036,
 43995,
 -1,
 620444250,
 43976,
 620700928,
 620384876,
 43971,
 -1,
 620626644,
 43997,
 620832002,
 620644379,
 43970,
 -1,
 620757716,
 43996,
 620963077,
 620774342,
 -1,
 -56060,
 620903962,
 43990,
 -1,
 620967578,
 43987,
 621159687,
 620903309,
 43983,
 -1,
 621085396,
 44002,
 621290762,
 621097656,
 -1,
 -56055,
 621238703,
 43986,
 -1,
 621296218,
 43992,
 621487373,
 621224262,
 -1,
 -56052,
 621428250,
 43991,
 -1,
 621492826,
 43993,
 621683984,
 621418254,
 -1,
 -56049,
 621622938,
 43994,
 -1,
 621678129,
 43989,
 -56047,
 621644877,
 43980,
 -56046,
 621840277,
 43979,
 -56045,
 621904068,
 43982,
 -56044,
 621965192,
 43969,
 -56043,
 622028870,
 43988,
 -56042,
 622082887,
 43981,
 -56041,
 622140620,
 43974,
 -1,
 622204484,
 43985,
 -1,
 619479166,
 44012,
 622470439,
 619389768,
 -1,
 622535965,
 622425855,
 -1,
 -56036,
 622496270,
 44018,
 -1,
 622541452,
 44019,
 622732576,
 622489350,
 -1,
 -56033,
 622674799,
 44022,
 -1,
 622734751,
 44023,
 622929187,
 622669649,
 -1,
 -56030,
 622878484,
 44020,
 -1,
 622936874,
 44021,
 -56028,
 622890584,
 44016,
 -56027,
 623074046,
 44017,
 -56026,
 623138311,
 44025,
 -1,
 623192449,
 44024,
 623387952,
 622429899,
 -1,
 -56023,
 623348908,
 44006,
 -56022,
 623411407,
 44008,
 -56021,
 623473694,
 44007,
 -56020,
 623532793,
 44003,
 -56019,
 623597493,
 44010,
 -56018,
 623656629,
 44004,
 -56017,
 623713437,
 44009,
 -1,
 623776375,
 44005,
 -56015,
 623320212,
 44011,
 -1,
 623907808,
 44013,
 624108865,
 619346846,
 -1,
 624174400,
 624049241,
 -1,
 624239930,
 624129791,
 -1,
 624305464,
 624200311,
 -1,
 -56009,
 624255114,
 9173,
 -1,
 624313447,
 9174,
 -56007,
 624258321,
 9175,
 -1,
 624438474,
 9176,
 624633149,
 624184498,
 -1,
 -56004,
 624590345,
 9172,
 -1,
 624652630,
 9170,
 -56002,
 624587115,
 9171,
 -56001,
 624780092,
 9177,
 -1,
 624826865,
 9169,
 -1,
 624121898,
 128647,
 625091909,
 624042927,
 -1,
 -55997,
 625051803,
 9898,
 -55996,
 625111953,
 9900,
 -1,
 625154310,
 9899,
 -55994,
 625039044,
 128697,
 -55993,
 625300121,
 128221,
 -55992,
 625364112,
 127816,
 -1,
 625415564,
 127830,
 625616211,
 619281982,
 -1,
 625681746,
 625569542,
 -1,
 625747281,
 625622105,
 -1,
 625812815,
 625700614,
 -1,
 -55986,
 625773865,
 119081,
 -1,
 625811310,
 127932,
 -55984,
 625759917,
 127925,
 -1,
 625952312,
 127929,
 -1,
 625687343,
 127812,
 -1,
 625626539,
 127926,
 626327551,
 625556365,
 -1,
 626337111,
 626218450,
 -1,
 -55978,
 626271115,
 128189,
 -1,
 626334306,
 128656,
 626533722,
 626270185,
 -1,
 -55975,
 626487228,
 128300,
 -1,
 626549684,
 127908,
 -1,
 626478037,
 127756,
 626796383,
 583274033,
 -1,
 626861572,
 626739053,
 -1,
 626927104,
 626793637,
 -1,
 626992503,
 626880262,
 -1,
 627058025,
 626949694,
 -1,
 627123560,
 626989401,
 -1,
 627189095,
 627058469,
 -1,
 627254629,
 627142527,
 -1,
 -55964,
 627187532,
 128807,
 -1,
 627250046,
 128814,
 -55962,
 627187532,
 128802,
 -1,
 627381118,
 128812,
 -1,
 627130783,
 128862,
 -1,
 627067612,
 128781,
 627713391,
 626987351,
 -1,
 627778926,
 627668735,
 128788,
 627900415,
 627704652,
 -1,
 -55955,
 627777363,
 128806,
 -1,
 627839870,
 128813,
 -1,
 627706221,
 128825,
 628106611,
 627668735,
 -1,
 628172146,
 628058385,
 128860,
 -1,
 628099428,
 128861,
 -1,
 628102335,
 128850,
 -55948,
 628057105,
 128839,
 -55947,
 628316253,
 128852,
 -55946,
 628375108,
 128795,
 -1,
 628431948,
 128847,
 628630922,
 626921009,
 -1,
 628696447,
 628582068,
 -1,
 628761982,
 628621312,
 -1,
 628827516,
 628721165,
 128776,
 -1,
 628754788,
 128777,
 629014527,
 628779560,
 128774,
 -1,
 628885860,
 128775,
 -1,
 628699627,
 128773,
 629155204,
 628639597,
 -1,
 629220738,
 629097817,
 128822,
 -1,
 629148004,
 128823,
 -55933,
 629178491,
 128837,
 -1,
 629287439,
 128874,
 -55931,
 629113582,
 128829,
 -55930,
 629436694,
 128855,
 -55929,
 629501488,
 128826,
 -55928,
 629561142,
 128811,
 -55927,
 629624599,
 128859,
 -1,
 629686719,
 128769,
 629876126,
 628562576,
 -1,
 629941654,
 629827487,
 -1,
 630007186,
 629899197,
 128869,
 630128639,
 629934431,
 -1,
 -55921,
 630000864,
 128873,
 -55920,
 630066338,
 128872,
 -55919,
 630131770,
 128871,
 -1,
 630197155,
 128870,
 630456319,
 629954770,
 -1,
 630465941,
 630333260,
 128803,
 -1,
 630393188,
 128804,
 -1,
 630407676,
 128798,
 630662554,
 629870129,
 -1,
 -55912,
 630613587,
 128846,
 -55911,
 630672912,
 128844,
 -1,
 630728304,
 128848,
 630924701,
 630611138,
 -1,
 -55908,
 630873449,
 128800,
 -1,
 630920050,
 128805,
 -1,
 630866021,
 128787,
 631186862,
 629827487,
 -1,
 631252396,
 631121611,
 -1,
 631317929,
 631191046,
 128818,
 631383461,
 631245151,
 -1,
 -55901,
 631311522,
 128821,
 -55900,
 631376954,
 128820,
 -1,
 631442339,
 128819,
 631701503,
 631309132,
 -1,
 631711144,
 631575422,
 128816,
 -1,
 631638372,
 128817,
 -1,
 631652860,
 128799,
 631907755,
 631247333,
 128827,
 -1,
 631834980,
 128828,
 -1,
 631864189,
 128877,
 632160255,
 631199933,
 128792,
 -1,
 632031588,
 128793,
 632235449,
 631117582,
 -1,
 632300979,
 632184149,
 128834,
 632422399,
 632228191,
 -1,
 -55886,
 632294458,
 128836,
 -1,
 632359843,
 128835,
 632563126,
 632231348,
 -1,
 -55883,
 632521701,
 128876,
 -1,
 632573980,
 128875,
 -55881,
 632515413,
 128857,
 -55880,
 632702913,
 128783,
 -1,
 632767070,
 128830,
 632956355,
 632193966,
 -1,
 633021890,
 632896397,
 -1,
 633087424,
 632968485,
 128778,
 633152959,
 633014623,
 -1,
 -55874,
 633080890,
 128780,
 -1,
 633146275,
 128779,
 -1,
 633078609,
 128815,
 633470975,
 633044074,
 128790,
 -1,
 633342308,
 128791,
 -1,
 632957913,
 128808,
 633611725,
 632906149,
 -1,
 633677256,
 633559082,
 -1,
 633742791,
 633636909,
 128843,
 -1,
 633677953,
 128858,
 -1,
 633698052,
 128856,
 633939403,
 633634366,
 -1,
 -55862,
 633895949,
 128868,
 -1,
 633957264,
 128867,
 -55860,
 633891266,
 128863,
 -1,
 634075356,
 128782,
 634267093,
 633566975,
 -1,
 634332625,
 634207904,
 -1,
 -55856,
 634265809,
 128840,
 -1,
 634323829,
 128809,
 634529235,
 634262780,
 128831,
 -1,
 634456420,
 128832,
 -55852,
 634487705,
 128845,
 -1,
 634612570,
 128849,
 634791388,
 634211875,
 -1,
 634856922,
 634727368,
 128784,
 634978303,
 634784095,
 -1,
 -55847,
 634850362,
 128786,
 -1,
 634915747,
 128785,
 -55845,
 634805218,
 128881,
 -1,
 635048982,
 128824,
 635250147,
 634730039,
 -1,
 635315680,
 635197482,
 -1,
 -55841,
 635273888,
 128878,
 -1,
 635334183,
 128854,
 635568127,
 635245018,
 -1,
 -55838,
 635461378,
 128883,
 -1,
 635512366,
 128882,
 635708905,
 635183430,
 -1,
 635774440,
 635650579,
 -1,
 635839975,
 635728907,
 128865,
 -1,
 635767140,
 128866,
 -1,
 635796119,
 128864,
 -1,
 635705074,
 128880,
 636102125,
 635650556,
 -1,
 636167660,
 636027765,
 128796,
 -1,
 636094820,
 128797,
 -1,
 636094855,
 128801,
 636364272,
 636061571,
 -1,
 -55825,
 636324614,
 128842,
 -1,
 636385451,
 128772,
 636560883,
 636315510,
 -1,
 -55822,
 636507944,
 128768,
 -1,
 636558795,
 128833,
 636757494,
 636507602,
 -1,
 -55819,
 636713988,
 128789,
 -1,
 636761268,
 128879,
 636954105,
 636700525,
 -1,
 -55816,
 636901614,
 128851,
 -1,
 636954568,
 128810,
 637150716,
 636891832,
 -1,
 -55813,
 637108347,
 128841,
 -1,
 637164008,
 128794,
 -55811,
 637108968,
 128853,
 -55810,
 637295000,
 128838,
 -55809,
 637350128,
 128770,
 -1,
 637413378,
 128771,
 -55807,
 626882766,
 9941,
 -55806,
 637549856,
 128126,
 -55805,
 637610511,
 9879,
 -1,
 637670555,
 9200,
 637871790,
 626812831,
 -1,
 637937323,
 637800201,
 -1,
 638002853,
 637861888,
 -1,
 638068324,
 637945709,
 -1,
 638133859,
 638004448,
 -1,
 638199319,
 638070609,
 -1,
 638264852,
 638129389,
 -1,
 638330384,
 638201512,
 -1,
 638395919,
 638285567,
 -1,
 -55794,
 638355989,
 1909,
 -1,
 638401175,
 1910,
 -1,
 638333431,
 1911,
 638658067,
 638285567,
 -1,
 -55790,
 638618160,
 1598,
 -1,
 638663352,
 1599,
 -1,
 638599567,
 1597,
 638975999,
 638200161,
 -1,
 -55786,
 638880318,
 1888,
 -1,
 638925563,
 1889,
 639116835,
 638141610,
 -1,
 639182368,
 639052139,
 -1,
 639247903,
 639137535,
 -1,
 639313438,
 639187629,
 -1,
 -55780,
 639263988,
 1892,
 -55779,
 639309845,
 1596,
 -1,
 639373088,
 1891,
 -1,
 639273520,
 1595,
 -1,
 639181814,
 1890,
 639762431,
 639110705,
 -1,
 -55774,
 639660357,
 1568,
 -1,
 639709066,
 1919,
 639903279,
 639055415,
 -1,
 639968814,
 639832255,
 -1,
 640034346,
 639922855,
 -1,
 640099881,
 639962673,
 -1,
 -55768,
 640046259,
 1903,
 -1,
 640096697,
 1906,
 -1,
 640030741,
 1902,
 640362029,
 639989503,
 -1,
 -55764,
 640322096,
 1879,
 -1,
 640367355,
 1880,
 -1,
 640298732,
 1916,
 -1,
 639904078,
 1791,
 640689721,
 639834110,
 -1,
 640755254,
 640644863,
 -1,
 640820789,
 640694957,
 -1,
 640886324,
 640771316,
 1874,
 -1,
 640811138,
 1875,
 -1,
 640825882,
 1872,
 -1,
 640780876,
 1876,
 -55753,
 640709485,
 1878,
 -55752,
 641089912,
 1877,
 -1,
 641147949,
 1873,
 641345087,
 640643093,
 -1,
 -55749,
 641301959,
 1901,
 -55748,
 641364672,
 1904,
 -55747,
 641417615,
 1918,
 -55746,
 641479204,
 1884,
 -1,
 641543877,
 1917,
 641738310,
 641296942,
 -1,
 641803843,
 641691398,
 -1,
 -55742,
 641760427,
 1883,
 -1,
 641814315,
 1905,
 -55740,
 641760711,
 1899,
 -55739,
 641941903,
 1775,
 -1,
 642004659,
 1900,
 642197071,
 641666609,
 -1,
 642262604,
 642137767,
 -1,
 642328139,
 642222631,
 -1,
 -55734,
 642286994,
 1887,
 -1,
 642322208,
 1885,
 -1,
 642267864,
 1886,
 642646015,
 642206062,
 -1,
 -55730,
 642550293,
 1907,
 -1,
 642595479,
 1908,
 642786900,
 642143895,
 -1,
 642852435,
 642740896,
 -1,
 -55726,
 642810798,
 1897,
 -1,
 642873219,
 1896,
 -1,
 642809238,
 1895,
 643114585,
 642720197,
 -1,
 643180120,
 643055858,
 -1,
 -55721,
 643138478,
 1774,
 -1,
 643199875,
 1882,
 -1,
 643136993,
 1881,
 643442268,
 643075189,
 -1,
 -55717,
 643402261,
 1914,
 -1,
 643447447,
 1915,
 643638879,
 643401700,
 -1,
 -55714,
 643598869,
 1912,
 -1,
 643644055,
 1913,
 643835490,
 643584273,
 -1,
 -55711,
 643766293,
 1894,
 -1,
 643829536,
 1893,
 -1,
 643778599,
 1898,
 -1,
 638074225,
 65021,
 644163219,
 638021382,
 -1,
 644228735,
 644123925,
 -1,
 644294259,
 644183807,
 -1,
 644359789,
 644254247,
 -1,
 644425323,
 644318598,
 -1,
 -55702,
 644356117,
 64446,
 -1,
 644419360,
 64445,
 -55700,
 644356117,
 64437,
 -1,
 644550432,
 64436,
 644808703,
 644299437,
 -1,
 644818545,
 644703430,
 -1,
 -55696,
 644749333,
 64441,
 -1,
 644812576,
 64440,
 -55694,
 644749333,
 64439,
 -1,
 644943648,
 64438,
 645146232,
 644228045,
 -1,
 645211767,
 645101313,
 -1,
 -55690,
 645142549,
 64435,
 -1,
 645205792,
 64434,
 -1,
 645169004,
 64444,
 645473915,
 645100386,
 -1,
 -55686,
 645404693,
 64449,
 -1,
 645467936,
 64448,
 645670526,
 645411353,
 -1,
 -55683,
 645601301,
 64443,
 -1,
 645664544,
 64442,
 -1,
 645622940,
 64447,
 645932682,
 644169190,
 -1,
 645998212,
 645885786,
 -1,
 -55678,
 645944432,
 1537,
 -55677,
 646007803,
 1552,
 -1,
 646066342,
 1539,
 646260359,
 645949437,
 -1,
 -55674,
 646199665,
 1554,
 -1,
 646259401,
 1555,
 -55672,
 646215593,
 1556,
 -55671,
 646402662,
 1551,
 -1,
 646451596,
 1553,
 646653586,
 645877534,
 -1,
 646719119,
 646592635,
 -1,
 -55667,
 646680072,
 1559,
 -55666,
 646739843,
 1557,
 -1,
 646793999,
 1558,
 -55664,
 646661529,
 1562,
 -55663,
 646918162,
 1560,
 -1,
 646980060,
 1561,
 -1,
 646610820,
 1622,
 647243415,
 644122315,
 -1,
 -55659,
 647197557,
 1626,
 -55658,
 647250273,
 1627,
 -1,
 647308323,
 1628,
 647505562,
 647194527,
 -1,
 -55655,
 647441947,
 1629,
 -1,
 647501543,
 1544,
 647702173,
 647442257,
 -1,
 -55652,
 647650348,
 1538,
 -1,
 647697852,
 1630,
 -55650,
 647663328,
 1625,
 -55649,
 647858127,
 1631,
 -55648,
 647920783,
 1566,
 -55647,
 647980175,
 1550,
 -55646,
 648042374,
 1536,
 -55645,
 648105952,
 1624,
 -55644,
 648167718,
 1623,
 -1,
 648225282,
 1549,
 648478719,
 637929922,
 -1,
 648488617,
 648373068,
 -1,
 -55640,
 648444034,
 1546,
 -1,
 648499723,
 1545,
 -55638,
 648426036,
 1543,
 -1,
 648618204,
 1542,
 648871935,
 637893153,
 -1,
 -55635,
 648770848,
 127912,
 -1,
 648814836,
 128667,
 649012992,
 637806283,
 -1,
 649078527,
 648950770,
 -1,
 649144046,
 649025406,
 -1,
 649209538,
 649099007,
 -1,
 649275065,
 649168700,
 -1,
 649340599,
 649222186,
 65800,
 649461759,
 649265152,
 -1,
 -55626,
 649361843,
 65827,
 -1,
 649411403,
 65818,
 649658367,
 649276198,
 65809,
 -1,
 649528963,
 65836,
 649733824,
 649213495,
 -1,
 649799358,
 649685517,
 65801,
 649920511,
 649723904,
 -1,
 -55619,
 649820595,
 65828,
 -1,
 649870155,
 65819,
 650117119,
 649740814,
 65810,
 -1,
 649987715,
 65837,
 650248191,
 649669171,
 65808,
 -1,
 650118787,
 65835,
 650323663,
 649162502,
 -1,
 650389193,
 650265455,
 65804,
 650454726,
 650346027,
 65813,
 -1,
 650380931,
 65840,
 650641407,
 650379264,
 -1,
 -55608,
 650541491,
 65831,
 -1,
 650591051,
 65822,
 650838015,
 650325407,
 65805,
 650847948,
 650739243,
 65814,
 -1,
 650774147,
 65841,
 651034623,
 650772480,
 -1,
 -55602,
 650934707,
 65832,
 -1,
 650984267,
 65823,
 651175646,
 650260305,
 -1,
 651241175,
 651122730,
 -1,
 651306709,
 651199136,
 65802,
 651427839,
 651231232,
 -1,
 -55596,
 651327923,
 65829,
 -1,
 651377483,
 65820,
 651624447,
 651259525,
 65811,
 -1,
 651495043,
 65838,
 651755519,
 651180941,
 -1,
 651765468,
 651658369,
 65803,
 651886591,
 651689984,
 -1,
 -55589,
 651786675,
 65830,
 -1,
 651836235,
 65821,
 652083199,
 651702943,
 65812,
 -1,
 651953795,
 65839,
 652158692,
 651122183,
 65807,
 652224225,
 652115499,
 65816,
 -1,
 652150403,
 65843,
 652410879,
 652148736,
 -1,
 -55581,
 652310963,
 65834,
 -1,
 652360523,
 65825,
 652551914,
 652093825,
 65806,
 652617447,
 652512200,
 65815,
 -1,
 652543619,
 65842,
 652804095,
 652541952,
 -1,
 -55575,
 652704179,
 65833,
 -1,
 652753739,
 65824,
 653000703,
 652499710,
 65799,
 653066239,
 652869632,
 -1,
 -55571,
 652966323,
 65826,
 -1,
 653015883,
 65817,
 653207289,
 649103164,
 -1,
 653272822,
 653142407,
 -1,
 653338355,
 653209425,
 -1,
 -55566,
 653287260,
 65851,
 -1,
 653345281,
 65848,
 -55564,
 653293965,
 65850,
 -55563,
 653488103,
 65849,
 -1,
 653531061,
 65847,
 653787135,
 653221210,
 -1,
 -55560,
 653675339,
 65792,
 -1,
 653730797,
 65793,
 653928188,
 653152486,
 -1,
 -55557,
 653883789,
 65855,
 -1,
 653946855,
 65854,
 -55555,
 653872012,
 65853,
 -55554,
 654059065,
 65852,
 -1,
 654122121,
 65794,
 -1,
 649030436,
 128673,
 654387013,
 648971692,
 -1,
 654452548,
 654330479,
 -1,
 654518026,
 654380593,
 68352,
 654583558,
 654446129,
 68353,
 -55547,
 654530602,
 68355,
 -1,
 654595068,
 68357,
 654780168,
 654517963,
 68358,
 -1,
 654714571,
 68359,
 -55543,
 654727210,
 68354,
 -1,
 654857212,
 68356,
 655042322,
 654463996,
 -1,
 655107855,
 654979768,
 -1,
 -55539,
 655068254,
 68387,
 -55538,
 655131777,
 68388,
 -1,
 655173323,
 68386,
 -55536,
 655068254,
 68390,
 -55535,
 655316229,
 68391,
 -1,
 655369931,
 68389,
 655566616,
 654995206,
 -1,
 655632150,
 655504951,
 -1,
 -55531,
 655592542,
 68403,
 -1,
 655632075,
 68401,
 -55529,
 655585544,
 68404,
 -1,
 655763147,
 68399,
 655959836,
 655526662,
 -1,
 -55526,
 655920222,
 68370,
 -55525,
 655983745,
 68371,
 -1,
 656025291,
 68369,
 656221984,
 655914751,
 -1,
 -55522,
 656177187,
 68381,
 -55521,
 656226159,
 68378,
 -1,
 656287435,
 68377,
 656484132,
 656159416,
 -1,
 -55518,
 656422767,
 68374,
 -55517,
 656487387,
 68373,
 -1,
 656549579,
 68372,
 656746279,
 656444913,
 -1,
 -55514,
 656684911,
 68402,
 -1,
 656746187,
 68400,
 656942890,
 656706504,
 -1,
 -55511,
 656903262,
 68394,
 -1,
 656942795,
 68395,
 657139500,
 656899646,
 68366,
 -1,
 657096254,
 68367,
 657270574,
 657086506,
 68362,
 -1,
 657217578,
 68363,
 657401648,
 657210253,
 68364,
 -1,
 657341325,
 68365,
 657532723,
 657339959,
 -1,
 -55502,
 657477810,
 68393,
 -1,
 657532619,
 68405,
 657729333,
 657467083,
 68360,
 -1,
 657663691,
 68361,
 657860408,
 657662278,
 -1,
 -55497,
 657799023,
 68380,
 -1,
 657860299,
 68379,
 658057019,
 657790734,
 -1,
 -55494,
 657995631,
 68385,
 -1,
 658056907,
 68384,
 -55492,
 658015361,
 68396,
 -55491,
 658205054,
 68397,
 -55490,
 658268854,
 68382,
 -55489,
 658329778,
 68392,
 -55488,
 658393365,
 68398,
 -55487,
 658458062,
 68368,
 -55486,
 658523138,
 68376,
 -55485,
 658583584,
 68383,
 -1,
 658644010,
 68375,
 -1,
 654380773,
 68409,
 658909005,
 654332924,
 -1,
 658974537,
 658863871,
 128028,
 -55480,
 658914412,
 128260,
 -1,
 658975450,
 128246,
 659171148,
 658911928,
 -1,
 -55477,
 659123936,
 128544,
 -1,
 659172277,
 128162,
 -1,
 659102948,
 9875,
 659433299,
 658865726,
 -1,
 659498833,
 659389219,
 -1,
 -55472,
 659445872,
 128663,
 -1,
 659494304,
 127975,
 -55470,
 659453381,
 8371,
 -1,
 659626049,
 127814,
 659826518,
 659388159,
 -1,
 -55467,
 659774059,
 9883,
 -1,
 659831138,
 128095,
 660023129,
 659780893,
 -1,
 -55464,
 659975623,
 9954,
 -1,
 660036538,
 128562,
 660219740,
 659967523,
 -1,
 -55461,
 660155397,
 127944,
 -1,
 660216385,
 128657,
 -55459,
 660162345,
 8525,
 -55458,
 660353178,
 1547,
 -1,
 660413087,
 9190,
 660613409,
 626733752,
 -1,
 660678733,
 660563871,
 -1,
 660744262,
 660613318,
 -1,
 660809794,
 660685996,
 -1,
 660875191,
 660737585,
 -1,
 660940724,
 660807661,
 -1,
 661006218,
 660870730,
 -1,
 661071737,
 660943018,
 -1,
 661137266,
 661030017,
 65859,
 661258239,
 661061632,
 -1,
 661268333,
 661157631,
 -1,
 661333868,
 661207646,
 65862,
 -1,
 661259878,
 65870,
 -1,
 661262773,
 65864,
 661530481,
 661207883,
 65861,
 661651455,
 661454848,
 -1,
 -55440,
 661551033,
 65868,
 -1,
 661615965,
 65875,
 -1,
 661484893,
 65871,
 661913599,
 661074591,
 65860,
 661979135,
 661782528,
 -1,
 661989240,
 661878527,
 -1,
 662054775,
 661928542,
 65863,
 -1,
 661980730,
 65878,
 -1,
 661983669,
 65866,
 -1,
 661943645,
 65873,
 662316932,
 661019394,
 -1,
 662382463,
 662255159,
 -1,
 662447998,
 662339898,
 -1,
 -55427,
 662403001,
 65867,
 -1,
 662467933,
 65874,
 -1,
 662376918,
 65857,
 662710146,
 662337980,
 -1,
 -55423,
 662665145,
 65869,
 -1,
 662730077,
 65876,
 -55421,
 662660867,
 65856,
 -1,
 662840857,
 65858,
 663093247,
 662272125,
 -1,
 663103368,
 662992639,
 -1,
 -55417,
 663042684,
 65877,
 -1,
 663097781,
 65865,
 -55415,
 663057757,
 65872,
 -1,
 663245437,
 65879,
 663431075,
 660961023,
 -1,
 663496603,
 663369706,
 -1,
 663562130,
 663451391,
 -1,
 663627664,
 663500343,
 -1,
 -55409,
 663579158,
 65899,
 -1,
 663634446,
 65893,
 -55407,
 663587342,
 65884,
 -1,
 663759411,
 65892,
 663955350,
 663509758,
 65881,
 664076287,
 663879680,
 -1,
 -55403,
 663976371,
 65905,
 -1,
 664025931,
 65898,
 664272895,
 663892138,
 -1,
 664283034,
 664175748,
 -1,
 -55399,
 664238515,
 65906,
 -1,
 664288075,
 65902,
 -1,
 664220319,
 65897,
 664600575,
 663448979,
 -1,
 664610721,
 664481962,
 -1,
 664676255,
 664568961,
 65887,
 -1,
 664601083,
 65901,
 664862719,
 664613535,
 65894,
 -1,
 664731686,
 65895,
 664993791,
 664565881,
 65888,
 -1,
 664862758,
 65889,
 665069481,
 663369683,
 -1,
 665135016,
 665014867,
 -1,
 -55386,
 665090169,
 65890,
 -55385,
 665148158,
 65882,
 -1,
 665202861,
 65896,
 -1,
 665063479,
 65880,
 665462701,
 665004902,
 -1,
 665528236,
 665419149,
 65883,
 -1,
 665452915,
 65886,
 -1,
 665465123,
 65900,
 665724848,
 665393808,
 -1,
 -55377,
 665685380,
 65885,
 -1,
 665720076,
 65903,
 -55375,
 665679312,
 65908,
 -55374,
 665867419,
 65904,
 -55373,
 665932158,
 65891,
 -1,
 665985613,
 65907,
 666238975,
 660891551,
 -1,
 -55370,
 666138482,
 65926,
 -1,
 666197842,
 65927,
 666380254,
 660816011,
 -1,
 666445760,
 666307746,
 119327,
 -55366,
 666373626,
 119356,
 -55365,
 666439110,
 119355,
 -55364,
 666504583,
 119354,
 -55363,
 666569952,
 119353,
 -55362,
 666635322,
 119352,
 -55361,
 666700707,
 119351,
 -1,
 666765968,
 119350,
 666970056,
 666372883,
 119325,
 -55358,
 666897914,
 119337,
 -55357,
 666963398,
 119336,
 -55356,
 667028871,
 119335,
 -55355,
 667094178,
 119334,
 -55354,
 667159610,
 119333,
 -55353,
 667224995,
 119332,
 -1,
 667290387,
 119331,
 667494351,
 666897315,
 119326,
 -55350,
 667422202,
 119343,
 -55349,
 667487623,
 119342,
 -55348,
 667553101,
 119341,
 -55347,
 667618528,
 119340,
 -55346,
 667684002,
 119339,
 -1,
 667749434,
 119338,
 667953109,
 667421920,
 119328,
 -55343,
 667880610,
 119361,
 -55342,
 667946042,
 119360,
 -55341,
 668011427,
 119359,
 -55340,
 668076819,
 119358,
 -1,
 668142224,
 119357,
 668346332,
 667880506,
 -1,
 -55337,
 668274170,
 119349,
 -55336,
 668339654,
 119348,
 -55335,
 668405127,
 119347,
 -55334,
 668470605,
 119346,
 -55333,
 668535715,
 119345,
 -1,
 668600976,
 119344,
 -55331,
 668274118,
 119330,
 -1,
 668732807,
 119329,
 668936188,
 666338838,
 -1,
 669001706,
 668863251,
 119296,
 -55327,
 668929530,
 119314,
 -55326,
 668995014,
 119313,
 -55325,
 669060487,
 119312,
 -55324,
 669125965,
 119311,
 -55323,
 669191392,
 119310,
 -55322,
 669256866,
 119309,
 -55321,
 669322298,
 119308,
 -55320,
 669387683,
 119307,
 -55319,
 669453075,
 119306,
 -1,
 669518480,
 119305,
 669722608,
 668929248,
 119300,
 -55316,
 669650082,
 119324,
 -55315,
 669715514,
 119323,
 -55314,
 669780899,
 119322,
 -55313,
 669846291,
 119321,
 -1,
 669911696,
 119320,
 670115830,
 669649827,
 119297,
 -55310,
 670043298,
 119319,
 -55309,
 670108730,
 119318,
 -55308,
 670174115,
 119317,
 -55307,
 670239507,
 119316,
 -1,
 670304912,
 119315,
 -55305,
 670043642,
 119304,
 -55304,
 670436806,
 119303,
 -55303,
 670502279,
 119302,
 -55302,
 670567757,
 119301,
 -55301,
 670633122,
 119299,
 -1,
 670698554,
 119298,
 670902287,
 668888838,
 -1,
 670967817,
 670846750,
 -1,
 671033349,
 670911087,
 -1,
 671098882,
 670985990,
 -1,
 -55295,
 671037826,
 1016,
 -1,
 671093351,
 1019,
 -55293,
 671048235,
 887,
 -55292,
 671234035,
 881,
 -1,
 671290409,
 883,
 671492104,
 670984897,
 -1,
 -55289,
 671436269,
 891,
 -1,
 671491253,
 893,
 -1,
 671425717,
 892,
 671809535,
 670924690,
 -1,
 -55285,
 671705862,
 7528,
 -55284,
 671769512,
 7529,
 -55283,
 671822654,
 7527,
 -55282,
 671882426,
 7530,
 -1,
 671946829,
 7526,
 672147486,
 670833482,
 -1,
 672213017,
 672089965,
 -1,
 672278552,
 672148704,
 -1,
 672344085,
 672231174,
 -1,
 -55276,
 672283010,
 1015,
 -1,
 672338535,
 1018,
 -55274,
 672293419,
 886,
 -55273,
 672479219,
 880,
 -1,
 672535593,
 882,
 -1,
 672235732,
 1017,
 672802844,
 672164545,
 -1,
 -55269,
 672746989,
 1021,
 -1,
 672801973,
 1023,
 -55267,
 672744769,
 975,
 -1,
 672933045,
 1022,
 673130535,
 672102143,
 -1,
 673196066,
 673090065,
 -1,
 -55263,
 673151395,
 65911,
 -1,
 673208468,
 65917,
 673392677,
 673135249,
 -1,
 -55260,
 673343264,
 65912,
 -1,
 673405076,
 65918,
 -55258,
 673345256,
 65929,
 -1,
 673517994,
 65914,
 673720368,
 673073005,
 -1,
 673785903,
 673656039,
 -1,
 673851436,
 673735077,
 -1,
 -55253,
 673804696,
 7466,
 -1,
 673856397,
 7464,
 -55251,
 673803014,
 7465,
 -55250,
 673990713,
 7463,
 -1,
 674050878,
 7462,
 -1,
 673727250,
 65923,
 674310197,
 673667114,
 -1,
 674375731,
 674256140,
 65909,
 -1,
 674299942,
 65910,
 -55244,
 674333079,
 65924,
 -1,
 674437502,
 65916,
 674637880,
 674254371,
 -1,
 -55241,
 674595659,
 119365,
 -1,
 674639059,
 65921,
 674834491,
 674574161,
 -1,
 -55238,
 674783035,
 65919,
 -1,
 674841405,
 65920,
 -55236,
 674795135,
 65930,
 -55235,
 674991201,
 65913,
 -55234,
 675056501,
 65925,
 -55233,
 675113738,
 1020,
 -55232,
 675170129,
 65922,
 -55231,
 675231109,
 65928,
 -1,
 675292705,
 65915,
 675545087,
 660755454,
 -1,
 -55228,
 675428236,
 128154,
 -55227,
 675486093,
 128215,
 -1,
 675550170,
 127823,
 675752009,
 660684909,
 -1,
 -55224,
 675688407,
 128513,
 -1,
 675748837,
 128568,
 675948620,
 675679793,
 -1,
 -55221,
 675898261,
 127815,
 -1,
 675948132,
 127891,
 -1,
 675897681,
 128151,
 676210896,
 660621165,
 -1,
 676276429,
 676139175,
 -1,
 676341902,
 676229928,
 -1,
 676407385,
 676294406,
 -1,
 676472917,
 676345399,
 -1,
 676538452,
 676427601,
 11339,
 -1,
 676488146,
 11356,
 -1,
 676466225,
 11342,
 676735063,
 676417403,
 11348,
 -1,
 676661552,
 11349,
 -55208,
 676684765,
 11346,
 -1,
 676810002,
 11332,
 676997218,
 676367304,
 -1,
 677062751,
 676931275,
 -1,
 677128286,
 677013407,
 -1,
 -55203,
 677084734,
 11343,
 -1,
 677133197,
 11344,
 -1,
 677082689,
 11317,
 -55200,
 677019198,
 11347,
 -55199,
 677337130,
 11350,
 -1,
 677385749,
 11345,
 677587050,
 676936589,
 11323,
 677652582,
 677547669,
 -1,
 -55195,
 677593884,
 11355,
 -1,
 677652171,
 11321,
 677849193,
 677600878,
 -1,
 -55192,
 677802916,
 11351,
 -1,
 677845169,
 11353,
 -1,
 677795393,
 11322,
 678111342,
 677541631,
 -1,
 -55188,
 678070048,
 11333,
 -55187,
 678130072,
 11340,
 -1,
 678194606,
 11357,
 678373490,
 678043974,
 -1,
 -55184,
 678334009,
 11319,
 -55183,
 678385823,
 11316,
 -1,
 678446115,
 11324,
 678635637,
 678333937,
 -1,
 -55180,
 678574398,
 11318,
 -1,
 678636057,
 11320,
 678832248,
 678584741,
 -1,
 -55177,
 678779344,
 11330,
 -1,
 678831819,
 11338,
 679028859,
 678778922,
 -1,
 -55174,
 678984953,
 11337,
 -1,
 679040867,
 11329,
 679225470,
 678971245,
 -1,
 -55171,
 679167119,
 11326,
 -1,
 679220788,
 11358,
 679422081,
 679161681,
 -1,
 -55168,
 679374140,
 11335,
 -1,
 679428776,
 11354,
 679618692,
 679352078,
 -1,
 -55165,
 679575607,
 11313,
 -1,
 679624038,
 11352,
 -55163,
 679576740,
 11314,
 -55162,
 679772206,
 11334,
 -55161,
 679832886,
 11331,
 -55160,
 679892117,
 11328,
 -55159,
 679957492,
 11327,
 -55158,
 680019280,
 11325,
 -55157,
 680081374,
 11336,
 -55156,
 680146221,
 11315,
 -55155,
 680205555,
 11341,
 -1,
 680269578,
 11312,
 680525823,
 676272995,
 -1,
 680536216,
 680423174,
 -1,
 680601748,
 680474167,
 -1,
 680667283,
 680556369,
 11291,
 -1,
 680616914,
 11308,
 -1,
 680594993,
 11294,
 680863894,
 680546171,
 11300,
 -1,
 680790320,
 11301,
 -55145,
 680813533,
 11298,
 -1,
 680938770,
 11284,
 681126049,
 680496072,
 -1,
 681191582,
 681060043,
 -1,
 681257117,
 681142175,
 -1,
 -55140,
 681213502,
 11295,
 -1,
 681261965,
 11296,
 -1,
 681211457,
 11269,
 -55137,
 681147966,
 11299,
 -55136,
 681465898,
 11302,
 -1,
 681514517,
 11297,
 681715881,
 681065357,
 11275,
 681781413,
 681676437,
 -1,
 -55132,
 681722652,
 11307,
 -1,
 681780939,
 11273,
 681978024,
 681729646,
 -1,
 -55129,
 681931684,
 11303,
 -1,
 681973937,
 11305,
 -1,
 681924161,
 11274,
 682240173,
 681670399,
 -1,
 -55125,
 682198816,
 11285,
 -55124,
 682258840,
 11292,
 -1,
 682323374,
 11309,
 682502321,
 682172742,
 -1,
 -55121,
 682462777,
 11271,
 -55120,
 682514591,
 11268,
 -1,
 682574883,
 11276,
 682764468,
 682462705,
 -1,
 -55117,
 682703166,
 11270,
 -1,
 682764825,
 11272,
 682961079,
 682713509,
 -1,
 -55114,
 682908112,
 11282,
 -1,
 682960587,
 11290,
 683157690,
 682907690,
 -1,
 -55111,
 683113721,
 11289,
 -1,
 683169635,
 11281,
 683354301,
 683100013,
 -1,
 -55108,
 683295887,
 11278,
 -1,
 683349556,
 11310,
 683550912,
 683290449,
 -1,
 -55105,
 683502908,
 11287,
 -1,
 683557544,
 11306,
 683747523,
 683480846,
 -1,
 -55102,
 683704375,
 11265,
 -1,
 683752806,
 11304,
 -55100,
 683705508,
 11266,
 -55099,
 683900974,
 11286,
 -55098,
 683961654,
 11283,
 -55097,
 684020885,
 11280,
 -55096,
 684086260,
 11279,
 -55095,
 684148048,
 11277,
 -55094,
 684210142,
 11288,
 -55093,
 684274989,
 11267,
 -55092,
 684334323,
 11293,
 -1,
 684398346,
 11264,
 684654591,
 676223018,
 -1,
 -55089,
 684558658,
 127775,
 -1,
 684595169,
 127760,
 684796173,
 676144843,
 -1,
 684861704,
 684744045,
 -1,
 684927236,
 684815144,
 -1,
 684992730,
 684865079,
 -1,
 685058263,
 684920369,
 -1,
 -55082,
 685008799,
 11556,
 -1,
 685057739,
 11552,
 -55080,
 685005078,
 11557,
 -55079,
 685194510,
 11554,
 -1,
 685254347,
 11553,
 685451488,
 684923536,
 -1,
 685517022,
 685389367,
 -1,
 -55075,
 685457056,
 11545,
 -1,
 685511694,
 11549,
 -55073,
 685456922,
 11548,
 -1,
 685642343,
 11546,
 685844707,
 685411825,
 -1,
 -55070,
 685782814,
 11535,
 -1,
 685845043,
 11526,
 686041318,
 685799249,
 -1,
 -55067,
 685991839,
 11538,
 -1,
 686052348,
 11527,
 686237929,
 685993734,
 -1,
 -55064,
 686176505,
 11544,
 -1,
 686232167,
 11537,
 686434540,
 686186917,
 -1,
 -55061,
 686372638,
 11540,
 -1,
 686429198,
 11534,
 686631151,
 686376106,
 -1,
 -55058,
 686569246,
 11541,
 -1,
 686625383,
 11529,
 686827762,
 686572486,
 -1,
 -55055,
 686767642,
 11547,
 -1,
 686831295,
 11551,
 687024373,
 686764728,
 -1,
 -55052,
 686962367,
 11542,
 -1,
 687018599,
 11522,
 -55050,
 686984038,
 11550,
 -55049,
 687179826,
 11555,
 -55048,
 687244773,
 11525,
 -55047,
 687308996,
 11539,
 -55046,
 687368224,
 11536,
 -55045,
 687433366,
 11543,
 -55044,
 687495835,
 11533,
 -55043,
 687559807,
 11532,
 -55042,
 687624068,
 11531,
 -55041,
 687687771,
 11530,
 -55040,
 687750816,
 11528,
 -55039,
 687811123,
 11524,
 -55038,
 687875049,
 11523,
 -55037,
 687937390,
 11521,
 -1,
 688001639,
 11520,
 688259071,
 684870255,
 -1,
 -55034,
 688160403,
 983912,
 -55033,
 688225616,
 4345,
 -1,
 688263424,
 4346,
 688466188,
 684790798,
 9881,
 688586751,
 688392038,
 -1,
 -55029,
 688480133,
 9965,
 -1,
 688521710,
 9966,
 -1,
 688410206,
 128142,
 688793885,
 684752446,
 -1,
 688859412,
 688735226,
 -1,
 688924945,
 688817913,
 2786,
 -1,
 688867181,
 2787,
 689056019,
 688868014,
 2700,
 -1,
 688998253,
 2785,
 -1,
 689008338,
 2801,
 689252633,
 688811354,
 -1,
 -55018,
 689212480,
 2677,
 -55017,
 689276405,
 2563,
 -55016,
 689340359,
 2641,
 -1,
 689377186,
 2561,
 689580316,
 689181710,
 -1,
 -55013,
 689514067,
 128130,
 -1,
 689574731,
 8370,
 -1,
 689521370,
 127928,
 -55010,
 688740449,
 128016,
 -55009,
 689783288,
 128103,
 -55008,
 689846853,
 128123,
 -1,
 689902142,
 127922,
 690105005,
 660562341,
 -1,
 690170323,
 690042423,
 -1,
 690235822,
 690097713,
 -1,
 690301294,
 690173414,
 -1,
 690366818,
 690244207,
 -1,
 690432303,
 690321151,
 -1,
 690497834,
 690386687,
 -1,
 -54999,
 690435661,
 43114,
 -1,
 690490929,
 43113,
 690694445,
 690450182,
 -1,
 -54996,
 690632269,
 43089,
 -1,
 690687537,
 43088,
 -54994,
 690632269,
 43081,
 -1,
 690818609,
 43080,
 691022132,
 690377724,
 -1,
 -54991,
 690981898,
 43079,
 -54990,
 691033170,
 43116,
 -54989,
 691090154,
 43075,
 -1,
 691146289,
 43083,
 691349816,
 690974470,
 -1,
 -54986,
 691293988,
 43094,
 -54985,
 691353165,
 43098,
 -1,
 691408433,
 43099,
 691611964,
 691282246,
 -1,
 -54982,
 691572225,
 43090,
 -54981,
 691610018,
 43115,
 -1,
 691670577,
 43082,
 691874112,
 691542672,
 -1,
 691939647,
 691801649,
 43076,
 -1,
 691885307,
 43123,
 -1,
 691877453,
 43077,
 692136259,
 691801649,
 43101,
 -54974,
 692089970,
 43120,
 -1,
 692145567,
 43117,
 692332870,
 692096497,
 -1,
 -54971,
 692270669,
 43092,
 -1,
 692325937,
 43093,
 692529481,
 692291154,
 -1,
 -54968,
 692472401,
 43118,
 -1,
 692527451,
 43119,
 692726092,
 692478373,
 -1,
 -54965,
 692663885,
 43085,
 -1,
 692719153,
 43084,
 692922703,
 692667562,
 -1,
 -54962,
 692860493,
 43073,
 -1,
 692915761,
 43072,
 693119314,
 692859576,
 -1,
 -54959,
 693056234,
 43109,
 -1,
 693112369,
 43074,
 693315924,
 693053131,
 43104,
 -1,
 693249739,
 43110,
 -54955,
 693275658,
 43095,
 -54954,
 693406545,
 43107,
 -54953,
 693471107,
 43091,
 -54952,
 693534270,
 43103,
 -54951,
 693594109,
 43096,
 -54950,
 693659265,
 43106,
 -54949,
 693721130,
 43105,
 -54948,
 693784181,
 43087,
 -54947,
 693847963,
 43097,
 -54946,
 693912548,
 43078,
 -54945,
 693975949,
 43102,
 -54944,
 694040141,
 43100,
 -54943,
 694103982,
 43108,
 -1,
 694163267,
 43086,
 694364522,
 690319110,
 -1,
 694430057,
 694320702,
 -1,
 694495592,
 694360298,
 -1,
 -54938,
 694455306,
 43112,
 -54937,
 694519683,
 43111,
 -1,
 694577149,
 43121,
 -1,
 694444889,
 43122,
 -1,
 694370309,
 43124,
 694888813,
 694308811,
 -1,
 -54932,
 694841519,
 43126,
 -1,
 694887801,
 43127,
 -1,
 694822234,
 43125,
 695205887,
 690242181,
 -1,
 695216506,
 695081616,
 -1,
 695282036,
 695162922,
 -1,
 695347571,
 695226423,
 66020,
 -1,
 695287835,
 66045,
 -1,
 695291368,
 66022,
 695544184,
 695209521,
 -1,
 -54922,
 695498495,
 66028,
 -54921,
 695561732,
 66018,
 -1,
 695625234,
 66003,
 -54919,
 695487960,
 66012,
 -1,
 695744727,
 66004,
 695937410,
 695168774,
 -1,
 696002942,
 695875623,
 -1,
 -54915,
 695951781,
 66024,
 -1,
 696003030,
 66011,
 -54913,
 695958481,
 66042,
 -54912,
 696143695,
 66043,
 -54911,
 696208240,
 66021,
 -1,
 696260310,
 66015,
 696461705,
 695867150,
 -1,
 696527238,
 696408106,
 -1,
 -54907,
 696485692,
 66010,
 -1,
 696539785,
 66017,
 696723848,
 696461510,
 66033,
 -1,
 696662329,
 66023,
 -1,
 696680548,
 66027,
 696920463,
 696410533,
 -1,
 696985997,
 696862573,
 -1,
 -54900,
 696942762,
 66001,
 -1,
 696980211,
 66034,
 -54898,
 696920232,
 66000,
 -1,
 697111556,
 66036,
 697313683,
 696874751,
 -1,
 -54895,
 697270690,
 66032,
 -54894,
 697318475,
 66008,
 -1,
 697374289,
 66002,
 697575831,
 697251383,
 -1,
 -54891,
 697523638,
 66025,
 -54890,
 697580750,
 66026,
 -1,
 697641464,
 66006,
 697837978,
 697534268,
 -1,
 -54887,
 697784949,
 66005,
 -1,
 697833150,
 66044,
 698034589,
 697788319,
 -1,
 -54884,
 697982476,
 66037,
 -1,
 698028598,
 66029,
 698231200,
 697978485,
 -1,
 -54881,
 698186984,
 66014,
 -1,
 698242153,
 66013,
 698427811,
 698174202,
 -1,
 -54878,
 698371603,
 66038,
 -1,
 698425670,
 66016,
 698624422,
 698364600,
 -1,
 -54875,
 698575109,
 66041,
 -1,
 698619502,
 66007,
 698821033,
 698557389,
 -1,
 -54872,
 698778753,
 66031,
 -1,
 698829753,
 66019,
 -54870,
 698779113,
 66035,
 -54869,
 698966422,
 66039,
 -54868,
 699019670,
 66040,
 -54867,
 699082704,
 66030,
 -1,
 699143380,
 66009,
 699400191,
 690182425,
 -1,
 699410889,
 699288175,
 -1,
 699476404,
 699363078,
 -1,
 -54862,
 699414777,
 67860,
 -54861,
 699476501,
 67854,
 -1,
 699535277,
 67857,
 699738551,
 699430655,
 -1,
 -54858,
 699673760,
 67848,
 -1,
 699733598,
 67861,
 699935161,
 699676527,
 67844,
 -1,
 699889407,
 67847,
 700066236,
 699862577,
 -1,
 -54853,
 700009165,
 67840,
 -1,
 700071584,
 67855,
 -54851,
 700026372,
 67846,
 -54850,
 700222799,
 67849,
 -54849,
 700286918,
 67845,
 -54848,
 700345827,
 67859,
 -54847,
 700409507,
 67858,
 -54846,
 700474038,
 67856,
 -54845,
 700536753,
 67853,
 -54844,
 700600633,
 67852,
 -54843,
 700663860,
 67851,
 -54842,
 700728637,
 67850,
 -54841,
 700789561,
 67842,
 -54840,
 700850783,
 67843,
 -1,
 700913737,
 67841,
 701114834,
 699357054,
 -1,
 701180368,
 701069055,
 -1,
 701245902,
 701138748,
 -1,
 -54835,
 701192234,
 67866,
 -1,
 701246246,
 67864,
 -54833,
 701184652,
 67867,
 -1,
 701377075,
 67863,
 701628415,
 701127422,
 67862,
 -1,
 701497851,
 67865,
 -1,
 701074121,
 67871,
 701770274,
 690112700,
 -1,
 701835748,
 701724415,
 -1,
 701901274,
 701794928,
 -1,
 -54825,
 701854792,
 127138,
 -54824,
 701904804,
 127154,
 -54823,
 701965073,
 127170,
 -1,
 702029436,
 127186,
 702228959,
 701840166,
 -1,
 -54820,
 702182472,
 127139,
 -54819,
 702232484,
 127155,
 -54818,
 702292753,
 127171,
 -1,
 702357116,
 127187,
 702611455,
 702163548,
 -1,
 -54815,
 702510152,
 127146,
 -54814,
 702560164,
 127162,
 -54813,
 702620433,
 127178,
 -1,
 702684796,
 127194,
 702884335,
 701787910,
 -1,
 702949866,
 702825343,
 -1,
 -54809,
 702903368,
 127142,
 -54808,
 702953380,
 127158,
 -54807,
 703013649,
 127174,
 -1,
 703078012,
 127190,
 703332351,
 702885301,
 -1,
 -54804,
 703231048,
 127143,
 -54803,
 703281060,
 127159,
 -54802,
 703341329,
 127175,
 -1,
 703405692,
 127191,
 703605242,
 702825642,
 -1,
 703670773,
 703550959,
 -1,
 -54798,
 703624264,
 127148,
 -54797,
 703674276,
 127164,
 -54796,
 703734545,
 127180,
 -1,
 703798908,
 127196,
 704053247,
 703610821,
 -1,
 -54793,
 703951944,
 127150,
 -54792,
 704001956,
 127166,
 -54791,
 704062225,
 127182,
 -1,
 704126588,
 127198,
 704326149,
 703541073,
 -1,
 704391680,
 704274250,
 -1,
 -54787,
 704345160,
 127140,
 -54786,
 704395172,
 127156,
 -54785,
 704455441,
 127172,
 -1,
 704519804,
 127188,
 704774143,
 704332620,
 -1,
 -54782,
 704672840,
 127141,
 -54781,
 704722852,
 127157,
 -54780,
 704783121,
 127173,
 -1,
 704847484,
 127189,
 705047050,
 704276270,
 -1,
 -54777,
 705000520,
 127149,
 -54776,
 705050532,
 127165,
 -54775,
 705110801,
 127181,
 -1,
 705175164,
 127197,
 705374735,
 704992791,
 -1,
 -54772,
 705328200,
 127145,
 -54771,
 705378212,
 127161,
 -54770,
 705438481,
 127177,
 -1,
 705502844,
 127193,
 705702420,
 705315815,
 -1,
 -54767,
 705655880,
 127147,
 -54766,
 705705892,
 127163,
 -54765,
 705766161,
 127179,
 -1,
 705830524,
 127195,
 706030105,
 705636762,
 -1,
 -54762,
 705983560,
 127144,
 -54761,
 706033572,
 127160,
 -54760,
 706093841,
 127176,
 -1,
 706158204,
 127192,
 706357790,
 705957727,
 -1,
 -54757,
 706311240,
 127137,
 -54756,
 706361252,
 127153,
 -54755,
 706421521,
 127169,
 -1,
 706485884,
 127185,
 706685473,
 706287374,
 -1,
 -54752,
 706627510,
 127183,
 -1,
 706678635,
 127136,
 -1,
 706644165,
 127199,
 706947670,
 701697585,
 -1,
 707013191,
 706897823,
 -1,
 707078723,
 706947836,
 -1,
 707144256,
 707020929,
 -1,
 -54745,
 707104241,
 127273,
 -54744,
 707169224,
 127272,
 -54743,
 707234566,
 127271,
 -54742,
 707299132,
 127270,
 -54741,
 707363758,
 127269,
 -54740,
 707427902,
 127268,
 -54739,
 707491583,
 127267,
 -54738,
 707555078,
 127266,
 -54737,
 707618719,
 127265,
 -54736,
 707683955,
 127264,
 -54735,
 707748261,
 127263,
 -54734,
 707811370,
 127262,
 -54733,
 707875836,
 127261,
 -54732,
 707939875,
 127260,
 -54731,
 708003693,
 127259,
 -54730,
 708068522,
 127258,
 -54729,
 708133830,
 127257,
 -54728,
 708197261,
 127256,
 -54727,
 708261431,
 127255,
 -54726,
 708326072,
 127254,
 -54725,
 708390737,
 127253,
 -54724,
 708454091,
 127252,
 -54723,
 708518214,
 127251,
 -54722,
 708582032,
 127250,
 -54721,
 708646670,
 127249,
 -1,
 708709937,
 127248,
 708968447,
 707086085,
 -1,
 -54718,
 708854809,
 12829,
 -1,
 708903415,
 12830,
 709110342,
 707032831,
 -1,
 -54715,
 709069798,
 127881,
 -1,
 709121399,
 12880,
 -1,
 709038262,
 11791,
 709372492,
 706955117,
 -1,
 709438027,
 709316133,
 -1,
 -54710,
 709393416,
 127796,
 -1,
 709433821,
 11801,
 -1,
 709380187,
 9908,
 709700177,
 709309403,
 -1,
 709765712,
 709623808,
 -1,
 -54705,
 709724527,
 128195,
 -1,
 709767169,
 128196,
 -1,
 709715871,
 128223,
 -54702,
 709658461,
 128062,
 -54701,
 709981454,
 128706,
 -54700,
 710042449,
 128206,
 -54699,
 710104255,
 128060,
 -1,
 710155744,
 128230,
 710355570,
 706881227,
 -1,
 710421098,
 710305695,
 -1,
 710486630,
 710373126,
 -1,
 710552165,
 710433435,
 -1,
 710617700,
 710475776,
 -1,
 710683233,
 710576489,
 -1,
 710748767,
 710612750,
 -1,
 -54690,
 710691988,
 128113,
 -1,
 710742513,
 9977,
 -54688,
 710698310,
 128590,
 -1,
 710881700,
 128591,
 -54686,
 710633614,
 128588,
 -54685,
 711012963,
 128589,
 -1,
 711072194,
 128583,
 -1,
 710545754,
 128187,
 -1,
 710487538,
 128547,
 -54681,
 710435590,
 10178,
 -54680,
 711348126,
 9854,
 -54679,
 711406046,
 127917,
 -1,
 711460369,
 8524,
 711666286,
 710366204,
 -1,
 -54676,
 711620476,
 9956,
 -54675,
 711684677,
 128532,
 -1,
 711734780,
 128039,
 711928433,
 711593521,
 -1,
 -54672,
 711878559,
 127824,
 -1,
 711924844,
 127825,
 -1,
 711860898,
 128694,
 712190599,
 710305695,
 -1,
 712256134,
 712125531,
 -1,
 712321657,
 712207263,
 -1,
 712387192,
 712280273,
 -1,
 -54665,
 712328649,
 65048,
 -1,
 712383979,
 983049,
 -1,
 712340630,
 65096,
 712649340,
 712264090,
 -1,
 -54661,
 712607974,
 65047,
 -1,
 712668310,
 65095,
 712845951,
 712588508,
 -1,
 -54658,
 712782503,
 65042,
 -1,
 712842957,
 65041,
 713042562,
 712777346,
 -1,
 -54655,
 712987252,
 65040,
 -1,
 713051280,
 65043,
 -54653,
 712994848,
 65044,
 -54652,
 713189197,
 65046,
 -54651,
 713243142,
 65049,
 -1,
 713305701,
 65045,
 -1,
 712195780,
 128120,
 713566873,
 712136746,
 -1,
 713632398,
 713522750,
 -1,
 713697932,
 713587424,
 -1,
 -54645,
 713633713,
 128545,
 -1,
 713694131,
 128574,
 -54643,
 713641408,
 127831,
 -1,
 713825388,
 128093,
 714025618,
 713575165,
 -1,
 714091153,
 713956227,
 128659,
 -1,
 714043198,
 128680,
 -1,
 714037555,
 128110,
 714287765,
 713979647,
 -1,
 -54636,
 714215182,
 128688,
 -1,
 714277726,
 127858,
 714484376,
 714241309,
 -1,
 -54633,
 714414544,
 128238,
 -1,
 714477926,
 128239,
 -1,
 714430737,
 128041,
 714746534,
 713505677,
 -1,
 714812062,
 714683064,
 128022,
 714932223,
 714735616,
 -1,
 -54627,
 714823330,
 128061,
 -1,
 714878897,
 128055,
 715074209,
 714757381,
 -1,
 -54624,
 715002842,
 127821,
 -1,
 715063637,
 127885,
 715270820,
 715016045,
 -1,
 -54621,
 715212653,
 128138,
 -1,
 715269931,
 128169,
 -54619,
 715224473,
 128299,
 -1,
 715398600,
 9935,
 715653119,
 714702398,
 -1,
 715664042,
 715548575,
 -1,
 -54615,
 715616224,
 128091,
 -1,
 715678760,
 128156,
 -54613,
 715618068,
 128686,
 -54612,
 715813256,
 128204,
 -1,
 715856192,
 128226,
 716057676,
 690046122,
 -1,
 716123025,
 715994679,
 -1,
 716188468,
 716067170,
 -1,
 716253946,
 716140294,
 -1,
 716319481,
 716213525,
 -1,
 716384969,
 716267941,
 -1,
 716450501,
 716335289,
 -1,
 716516034,
 716376415,
 -1,
 716581564,
 716445454,
 -1,
 716647097,
 716538294,
 -1,
 -54600,
 716598671,
 6649,
 -1,
 716654297,
 6633,
 716898303,
 716581241,
 -1,
 -54597,
 716795279,
 6648,
 -1,
 716850905,
 6632,
 717040319,
 716530691,
 -1,
 -54594,
 716991887,
 6647,
 -1,
 717047513,
 6631,
 717291519,
 716985256,
 -1,
 -54591,
 717188495,
 6646,
 -1,
 717244121,
 6630,
 717488127,
 716439552,
 -1,
 -54588,
 717385103,
 6645,
 -1,
 717440729,
 6629,
 717630152,
 716389896,
 -1,
 -54585,
 717581711,
 6642,
 -1,
 717637337,
 6626,
 -1,
 717559247,
 6624,
 717892319,
 716317168,
 -1,
 717957852,
 717818207,
 -1,
 718023378,
 717906341,
 -1,
 718088911,
 717973693,
 -1,
 -54578,
 718040463,
 6655,
 -1,
 718096089,
 6639,
 718340095,
 718028296,
 -1,
 -54575,
 718237071,
 6652,
 -1,
 718292697,
 6636,
 718482137,
 717952782,
 -1,
 718547670,
 718438838,
 -1,
 -54571,
 718499215,
 6654,
 -1,
 718554841,
 6638,
 718798847,
 718481785,
 -1,
 -54568,
 718695823,
 6653,
 -1,
 718751449,
 6637,
 718995455,
 718427048,
 -1,
 -54565,
 718892431,
 6651,
 -1,
 718948057,
 6635,
 719192063,
 717881344,
 -1,
 -54562,
 719089039,
 6650,
 -1,
 719144665,
 6634,
 719334126,
 717834781,
 -1,
 719399657,
 719282597,
 -1,
 719465192,
 719349945,
 6133,
 719585279,
 719391071,
 -1,
 719596262,
 719460110,
 -1,
 -54555,
 719552946,
 6137,
 -1,
 719595894,
 6136,
 -54553,
 719545343,
 6135,
 -1,
 719737763,
 6134,
 -1,
 719404549,
 6130,
 719989484,
 719329038,
 -1,
 -54549,
 719946162,
 6132,
 -1,
 719989110,
 6131,
 -54547,
 719942673,
 6128,
 -1,
 720130979,
 6129,
 720317173,
 719263502,
 -1,
 720382706,
 720273846,
 -1,
 -54543,
 720334223,
 6644,
 -1,
 720389849,
 6628,
 720633855,
 720316793,
 -1,
 -54540,
 720530831,
 6643,
 -1,
 720586457,
 6627,
 720775928,
 720262056,
 -1,
 -54537,
 720727439,
 6641,
 -1,
 720783065,
 6625,
 -1,
 720731517,
 6640,
 -1,
 716258795,
 6109,
 721103658,
 716185359,
 -1,
 721169156,
 721057535,
 -1,
 721234687,
 721123592,
 -1,
 -54530,
 721180714,
 983926,
 -1,
 721227313,
 983924,
 721431298,
 721172023,
 -1,
 -54527,
 721377322,
 983931,
 -1,
 721423921,
 983929,
 -54525,
 721377322,
 983930,
 -1,
 721554993,
 983928,
 721758985,
 721114108,
 -1,
 -54522,
 721718600,
 983922,
 -54521,
 721770538,
 983932,
 -54520,
 721827133,
 983917,
 -1,
 721882673,
 983927,
 722086671,
 721700010,
 -1,
 722152205,
 722023991,
 -1,
 -54516,
 722098218,
 983916,
 -1,
 722144817,
 983914,
 -54514,
 722098218,
 983915,
 -1,
 722275889,
 983913,
 722479893,
 722016912,
 -1,
 722545427,
 722417207,
 -1,
 -54510,
 722491434,
 983921,
 -1,
 722538033,
 983919,
 -54508,
 722491434,
 983920,
 -1,
 722669105,
 983918,
 722873113,
 722431750,
 -1,
 -54505,
 722825050,
 983943,
 -54504,
 722875981,
 983942,
 -1,
 722931249,
 983944,
 723135262,
 722821541,
 -1,
 723200797,
 723072567,
 -1,
 -54500,
 723146794,
 983936,
 -1,
 723193393,
 983934,
 -1,
 723146794,
 983935,
 723462945,
 723076973,
 -1,
 -54496,
 723408938,
 983940,
 -1,
 723455537,
 983946,
 723659556,
 723394886,
 -1,
 -54493,
 723605546,
 983925,
 -1,
 723652145,
 983923,
 -54491,
 723619144,
 983938,
 -54490,
 723813907,
 983941,
 -54489,
 723873144,
 983939,
 -54488,
 723931801,
 983937,
 -54487,
 723990093,
 983945,
 -1,
 724047683,
 983933,
 724249392,
 721043167,
 -1,
 724314925,
 724201181,
 983949,
 -1,
 724274120,
 983950,
 724500479,
 724264563,
 -1,
 -54481,
 724401726,
 983948,
 -1,
 724444875,
 983951,
 724697087,
 724207307,
 -1,
 -54478,
 724589151,
 983952,
 -54477,
 724639372,
 983947,
 -1,
 724700849,
 983953,
 724959231,
 716117157,
 -1,
 724970340,
 724847215,
 -1,
 725035837,
 724924159,
 -1,
 725101371,
 724989695,
 -1,
 -54471,
 725055760,
 68147,
 -54470,
 725104205,
 68123,
 -1,
 725159473,
 68122,
 -54468,
 725038669,
 68128,
 -1,
 725290545,
 68127,
 725494595,
 724967750,
 -1,
 725560129,
 725426502,
 -1,
 -54464,
 725497421,
 68125,
 -1,
 725552689,
 68124,
 -54462,
 725497421,
 68130,
 -1,
 725683761,
 68129,
 725887815,
 725446406,
 -1,
 -54459,
 725839706,
 68142,
 -54458,
 725890637,
 68141,
 -1,
 725945905,
 68143,
 726149963,
 725832700,
 -1,
 -54455,
 726109194,
 68121,
 -54454,
 726160466,
 68126,
 -1,
 726208049,
 68131,
 726412111,
 726090922,
 -1,
 -54451,
 726353160,
 68146,
 -54450,
 726414925,
 68113,
 -1,
 726470193,
 68112,
 726674258,
 726360485,
 -1,
 -54447,
 726611533,
 68133,
 -1,
 726666801,
 68132,
 726870869,
 726610616,
 -1,
 -54444,
 726808141,
 68115,
 -1,
 726863409,
 68114,
 727067480,
 726801040,
 -1,
 -54441,
 727004749,
 68118,
 -1,
 727060017,
 68117,
 727264091,
 726996750,
 -1,
 -54438,
 727201357,
 68135,
 -1,
 727256625,
 68134,
 -54436,
 727223809,
 68144,
 -54435,
 727419914,
 68137,
 -54434,
 727483332,
 68140,
 -54433,
 727541757,
 68138,
 -54432,
 727600757,
 68136,
 -54431,
 727664539,
 68139,
 -54430,
 727729124,
 68119,
 -54429,
 727791181,
 68145,
 -1,
 727846449,
 68096,
 728050546,
 724919847,
 -1,
 728116074,
 727982406,
 -1,
 728181609,
 728061994,
 -1,
 -54424,
 728137514,
 68183,
 -1,
 728200959,
 68176,
 -1,
 728109790,
 68182,
 728443757,
 728057709,
 -1,
 -54420,
 728391362,
 68181,
 -1,
 728448824,
 68184,
 728640368,
 728373904,
 -1,
 -54417,
 728590960,
 68179,
 -1,
 728646112,
 68178,
 -54415,
 728593157,
 68177,
 -1,
 728780720,
 68180,
 728968060,
 728007598,
 -1,
 729033595,
 728916283,
 -1,
 729099130,
 728986037,
 -1,
 -54410,
 729056822,
 68099,
 -54409,
 729120318,
 68098,
 -54408,
 729176106,
 68102,
 -54407,
 729234317,
 68097,
 -1,
 729294539,
 68101,
 -1,
 729041466,
 68108,
 -1,
 728973786,
 68159,
 729623428,
 728920501,
 -1,
 729688960,
 729555917,
 -1,
 -54401,
 729644879,
 68109,
 -1,
 729708300,
 68154,
 -54399,
 729646581,
 68111,
 -54398,
 729816064,
 68153,
 -54397,
 729880455,
 68152,
 -1,
 729944976,
 68110,
 730147723,
 729569150,
 -1,
 730213256,
 730101503,
 -1,
 -54393,
 730171445,
 68165,
 -1,
 730212915,
 68164,
 730464255,
 730159874,
 -1,
 -54390,
 730364339,
 68167,
 -1,
 730413899,
 68166,
 730660863,
 730080072,
 -1,
 730672015,
 730560255,
 -1,
 -54386,
 730630670,
 68161,
 -1,
 730675852,
 68162,
 -54384,
 730618622,
 68160,
 -1,
 730804722,
 68163,
 730999874,
 716049969,
 -1,
 731065322,
 730940152,
 -1,
 731130830,
 731007599,
 -1,
 731196315,
 731062598,
 -1,
 731261849,
 731128134,
 -1,
 -54377,
 731199053,
 69787,
 -54376,
 731259574,
 69786,
 -1,
 731319857,
 69785,
 -54374,
 731199053,
 69793,
 -1,
 731450929,
 69792,
 731655073,
 731150079,
 -1,
 731720607,
 731608831,
 -1,
 -54370,
 731657805,
 69784,
 -1,
 731713073,
 69783,
 -54368,
 731657805,
 69791,
 -1,
 731844145,
 69790,
 732048294,
 731599868,
 -1,
 -54365,
 732007434,
 69782,
 -54364,
 732058706,
 69789,
 -54363,
 732115690,
 69777,
 -1,
 732171825,
 69794,
 732375978,
 731975217,
 69763,
 -54360,
 732331582,
 69772,
 -54359,
 732380045,
 69770,
 -1,
 732433969,
 69764,
 732638126,
 732327686,
 -1,
 -54356,
 732589914,
 69805,
 -54355,
 732640845,
 69804,
 -1,
 732696113,
 69806,
 732900272,
 732593726,
 69767,
 -1,
 732855870,
 69768,
 733031347,
 732850079,
 -1,
 -54350,
 732968525,
 69788,
 -1,
 733023793,
 69801,
 733227958,
 732979621,
 -1,
 -54347,
 733165133,
 69796,
 -1,
 733220401,
 69795,
 733424569,
 733168810,
 -1,
 -54344,
 733361741,
 69774,
 -1,
 733417009,
 69773,
 733621180,
 733365190,
 -1,
 -54341,
 733558349,
 69781,
 -1,
 733613617,
 69780,
 733817790,
 733559693,
 69765,
 -1,
 733756301,
 69766,
 733948865,
 733754040,
 -1,
 -54336,
 733886029,
 69776,
 -1,
 733941297,
 69775,
 734145476,
 733878928,
 -1,
 -54333,
 734082637,
 69779,
 -1,
 734137905,
 69778,
 734342087,
 734074638,
 -1,
 -54330,
 734279245,
 69798,
 -1,
 734334513,
 69797,
 -54328,
 734301194,
 69800,
 -54327,
 734495684,
 69803,
 -54326,
 734550058,
 69771,
 -54325,
 734613109,
 69799,
 -54324,
 734676891,
 69802,
 -54323,
 734737997,
 69807,
 -1,
 734799563,
 69769,
 734997465,
 731088587,
 -1,
 735062995,
 734924337,
 -1,
 -54319,
 735018558,
 69816,
 -54318,
 735067021,
 69814,
 -1,
 735120945,
 69808,
 735325141,
 735018558,
 69811,
 -1,
 735280702,
 69812,
 735456215,
 735263629,
 69809,
 -1,
 735394701,
 69810,
 -54312,
 735402026,
 69815,
 -1,
 735520459,
 69813,
 735718370,
 734949126,
 -1,
 735783905,
 735657446,
 -1,
 735849438,
 735741388,
 -1,
 -54307,
 735801240,
 69762,
 -1,
 735865035,
 69817,
 -54305,
 735795060,
 69818,
 -54304,
 735976233,
 69760,
 -1,
 736039824,
 69761,
 -1,
 735717489,
 69822,
 736308199,
 735650118,
 -1,
 736373734,
 736255690,
 -1,
 -54299,
 736325622,
 69823,
 -1,
 736371170,
 69825,
 -1,
 736301790,
 69824,
 -54296,
 736253830,
 69821,
 -54295,
 736570159,
 69820,
 -1,
 736628471,
 69819,
 736832554,
 731024397,
 -1,
 736898063,
 736774767,
 -1,
 736963568,
 736842748,
 -1,
 -54290,
 736922634,
 43281,
 -54289,
 736965354,
 43277,
 -1,
 737021489,
 43284,
 737225715,
 736917247,
 -1,
 -54286,
 737162829,
 43294,
 -1,
 737218097,
 43282,
 737422326,
 737177350,
 -1,
 -54283,
 737359437,
 43279,
 -1,
 737414705,
 43278,
 737618937,
 737370533,
 -1,
 -54280,
 737556045,
 43286,
 -1,
 737611313,
 43285,
 737815548,
 737564714,
 -1,
 -54277,
 737761322,
 43301,
 -1,
 737814219,
 43299,
 738012159,
 737756330,
 -1,
 -54274,
 737949261,
 43275,
 -1,
 738004529,
 43274,
 738208770,
 737949239,
 -1,
 -54271,
 738162513,
 43283,
 -1,
 738201137,
 43295,
 -54269,
 738168321,
 43280,
 -54268,
 738364426,
 43291,
 -54267,
 738428803,
 43293,
 -54266,
 738493380,
 43296,
 -54265,
 738551805,
 43290,
 -54264,
 738610805,
 43287,
 -54263,
 738674587,
 43292,
 -54262,
 738737037,
 43300,
 -54261,
 738800362,
 43276,
 -54260,
 738861474,
 43288,
 -54259,
 738925231,
 43297,
 -54258,
 738989891,
 43289,
 -1,
 739053105,
 43298,
 739257373,
 736830280,
 -1,
 739322899,
 739211007,
 -1,
 -54254,
 739281422,
 43266,
 -1,
 739326604,
 43267,
 739519510,
 739274502,
 -1,
 -54251,
 739459951,
 43270,
 -1,
 739519903,
 43271,
 739716121,
 739454801,
 -1,
 -54248,
 739663636,
 43268,
 -1,
 739722026,
 43269,
 -54246,
 739675736,
 43264,
 -54245,
 739859198,
 43265,
 -54244,
 739923463,
 43273,
 -1,
 739977601,
 43272,
 740174883,
 739215010,
 -1,
 740240416,
 740130366,
 43304,
 -1,
 740173515,
 43302,
 740371490,
 740173515,
 43303,
 -1,
 740304587,
 43305,
 -1,
 740317226,
 43306,
 740568103,
 740129587,
 -1,
 740633638,
 740498141,
 43308,
 -1,
 740557982,
 43309,
 -1,
 740582485,
 43307,
 740884479,
 740520373,
 -1,
 -54231,
 740782483,
 43311,
 -1,
 740827449,
 43310,
 741026873,
 736786330,
 -1,
 741092401,
 740956316,
 -1,
 -54227,
 741047870,
 983961,
 -54226,
 741103658,
 983963,
 -54225,
 741161869,
 983960,
 -54224,
 741222091,
 983962,
 -1,
 741281329,
 983959,
 741539839,
 741019185,
 -1,
 741551160,
 741425380,
 -1,
 741616694,
 741504767,
 -1,
 -54219,
 741572158,
 983965,
 -1,
 741627946,
 983966,
 -54217,
 741564837,
 983967,
 -1,
 741743658,
 983964,
 -1,
 741501240,
 110592,
 742064127,
 740972152,
 -1,
 742075455,
 741962165,
 -1,
 -54212,
 742031939,
 3314,
 -54211,
 742086516,
 3260,
 -54210,
 742147129,
 3313,
 -1,
 742200968,
 3261,
 742403137,
 742033145,
 3298,
 -1,
 742344557,
 3299,
 -1,
 742345345,
 983042,
 742599753,
 730938253,
 -1,
 742665288,
 742552789,
 128143,
 742730823,
 742604633,
 -1,
 -54202,
 742666177,
 128538,
 -1,
 742726603,
 128573,
 -1,
 742654714,
 128139,
 -1,
 742609659,
 128088,
 743058507,
 742534986,
 128273,
 -1,
 742988610,
 128287,
 -1,
 743004248,
 128040,
 743255479,
 716003370,
 -1,
 743320916,
 743196525,
 -1,
 743386388,
 743252294,
 -1,
 743451921,
 743309312,
 -1,
 743517345,
 743406913,
 -1,
 743582847,
 743464366,
 -1,
 743648361,
 743509553,
 68608,
 743713886,
 743581387,
 -1,
 -54187,
 743672776,
 68632,
 -54186,
 743732991,
 68677,
 -54185,
 743796486,
 68670,
 -54184,
 743860127,
 68668,
 -54183,
 743920636,
 68644,
 -54182,
 743982957,
 68640,
 -54181,
 744047786,
 68634,
 -54180,
 744108728,
 68623,
 -54179,
 744169798,
 68627,
 -1,
 744232718,
 68619,
 744434784,
 743665414,
 68669,
 -1,
 744371767,
 68671,
 -54175,
 744393672,
 68630,
 -54174,
 744519423,
 68675,
 -54173,
 744581023,
 68666,
 -54172,
 744646259,
 68660,
 -54171,
 744707068,
 68643,
 -54170,
 744769389,
 68638,
 -54169,
 744829624,
 68621,
 -54168,
 744890694,
 68625,
 -1,
 744953614,
 68617,
 745155701,
 743581387,
 -1,
 745221231,
 745100284,
 -1,
 -54164,
 745180104,
 68650,
 -54163,
 745240319,
 68646,
 -54162,
 745288376,
 68653,
 -1,
 745347728,
 68648,
 -54160,
 745180657,
 68628,
 -54159,
 745500763,
 68673,
 -54158,
 745562533,
 68655,
 -54157,
 745623075,
 68642,
 -54156,
 745688476,
 68641,
 -1,
 745740944,
 68658,
 745942139,
 745101354,
 68614,
 746007672,
 745875147,
 68615,
 -1,
 745948330,
 68636,
 -54151,
 745961215,
 68679,
 -54150,
 746088051,
 68664,
 -1,
 746152357,
 68656,
 746335358,
 745880461,
 68611,
 -54147,
 746284659,
 68662,
 -1,
 746330768,
 68657,
 -1,
 746264511,
 68680,
 746651647,
 743541938,
 -1,
 746663059,
 746524209,
 68609,
 746728585,
 746596043,
 68610,
 746794116,
 746673148,
 68645,
 -1,
 746730168,
 68654,
 -54139,
 746752968,
 68633,
 -54138,
 746878719,
 68678,
 -54137,
 746931370,
 68635,
 -54136,
 746992312,
 68624,
 -1,
 747050766,
 68620,
 -54134,
 746687432,
 68631,
 -54133,
 747206399,
 68676,
 -54132,
 747270235,
 68672,
 -54131,
 747333535,
 68667,
 -54130,
 747398771,
 68661,
 -54129,
 747459993,
 68652,
 -54128,
 747521901,
 68639,
 -54127,
 747582136,
 68622,
 -54126,
 747643206,
 68626,
 -1,
 747706126,
 68618,
 747908251,
 746596043,
 68613,
 747973784,
 747852796,
 -1,
 -54122,
 747932616,
 68651,
 -54121,
 747992831,
 68647,
 -1,
 748034704,
 68649,
 -54119,
 747933169,
 68629,
 -54118,
 748187739,
 68674,
 -1,
 748231312,
 68659,
 748432543,
 747853866,
 -1,
 748498078,
 748365515,
 68616,
 -1,
 748438698,
 68637,
 -1,
 748447347,
 68665,
 748748799,
 748370829,
 68612,
 -1,
 748643955,
 68663,
 748825828,
 743465868,
 -1,
 748891355,
 748777909,
 -1,
 748956841,
 748822854,
 -1,
 749022375,
 748883505,
 66477,
 749142015,
 748960638,
 66508,
 -1,
 749013348,
 66509,
 -54104,
 748977726,
 66479,
 -1,
 749157261,
 66478,
 749350061,
 748883505,
 66464,
 749469695,
 749306552,
 66504,
 -54100,
 749352525,
 66506,
 -1,
 749406564,
 66505,
 749612209,
 749303551,
 -1,
 -54097,
 749567550,
 66476,
 -54096,
 749614669,
 66480,
 -1,
 749669937,
 66475,
 749874357,
 749563654,
 -1,
 -54093,
 749825882,
 66498,
 -54092,
 749876813,
 66497,
 -1,
 749932081,
 66495,
 750136505,
 749817379,
 -1,
 -54089,
 750091838,
 66488,
 -54088,
 750140301,
 66487,
 -1,
 750194225,
 66486,
 750398653,
 750065422,
 -1,
 750464188,
 750325297,
 66482,
 -1,
 750400234,
 66510,
 -1,
 750420897,
 66511,
 750660800,
 750357254,
 -1,
 -54081,
 750612643,
 66507,
 -1,
 750652977,
 66471,
 750857411,
 750617518,
 -1,
 -54078,
 750795661,
 66491,
 -1,
 750849585,
 66490,
 751054022,
 750806943,
 -1,
 -54075,
 751009342,
 66493,
 -1,
 751046193,
 66492,
 751250633,
 750998524,
 -1,
 -54072,
 751205950,
 66485,
 -1,
 751242801,
 66484,
 751447244,
 751191210,
 -1,
 -54069,
 751402558,
 66468,
 -1,
 751439409,
 66467,
 751643855,
 751387590,
 -1,
 -54066,
 751582093,
 66474,
 -1,
 751636017,
 66473,
 751840466,
 751579832,
 -1,
 -54063,
 751795774,
 66470,
 -1,
 751832625,
 66469,
 -54061,
 751799809,
 66496,
 -54060,
 751995914,
 66489,
 -54059,
 752057918,
 66466,
 -54058,
 752116196,
 66481,
 -54057,
 752175003,
 66494,
 -54056,
 752237453,
 66465,
 -54055,
 752301645,
 66499,
 -54054,
 752365486,
 66483,
 -1,
 752425647,
 66472,
 752626915,
 748836734,
 -1,
 752692449,
 752580351,
 -1,
 752757984,
 752650044,
 -1,
 -54049,
 752703530,
 66514,
 -1,
 752757542,
 66516,
 -1,
 752691763,
 66515,
 -54046,
 752638718,
 66513,
 -1,
 752958283,
 66517,
 -1,
 752585404,
 66512,
 753270783,
 748778533,
 -1,
 753282316,
 753158767,
 -1,
 753347820,
 753235711,
 -1,
 753413354,
 753284663,
 -1,
 -54039,
 753347776,
 68220,
 -1,
 753407702,
 68219,
 -54037,
 753347776,
 68215,
 -1,
 753538774,
 68201,
 753741042,
 753299206,
 -1,
 753806577,
 753667633,
 -1,
 -54033,
 753759999,
 68202,
 -54032,
 753815840,
 68207,
 -1,
 753869506,
 68206,
 -1,
 753744121,
 68198,
 754134263,
 753672518,
 -1,
 754199798,
 754071117,
 -1,
 -54027,
 754141795,
 68217,
 -1,
 754197186,
 68211,
 -1,
 754127303,
 68213,
 754461946,
 754074794,
 -1,
 -54023,
 754399224,
 68205,
 -1,
 754455469,
 68203,
 754658556,
 754399087,
 68192,
 -1,
 754612488,
 68194,
 754789631,
 754594488,
 -1,
 -54018,
 754728548,
 68212,
 -1,
 754792298,
 68214,
 754986242,
 754716209,
 -1,
 -54015,
 754945349,
 68210,
 -1,
 754993514,
 68209,
 -54013,
 754945585,
 68216,
 -54012,
 755141971,
 68218,
 -54011,
 755206112,
 68197,
 -54010,
 755264124,
 68199,
 -54009,
 755328684,
 68196,
 -54008,
 755390385,
 68204,
 -54007,
 755454265,
 68195,
 -54006,
 755517503,
 68193,
 -54005,
 755576864,
 68208,
 -1,
 755636313,
 68200,
 755892223,
 753227642,
 -1,
 755903760,
 755767329,
 -1,
 -54001,
 755849982,
 68221,
 -1,
 755904685,
 68222,
 -1,
 755837942,
 68223,
 756219903,
 743385995,
 -1,
 -53997,
 756124318,
 128117,
 -1,
 756174724,
 128116,
 756416511,
 743309563,
 -1,
 756428091,
 756304495,
 -1,
 756493600,
 756354609,
 -1,
 756559132,
 756420145,
 -1,
 -53991,
 756516668,
 7267,
 -53990,
 756567587,
 7266,
 -53989,
 756630698,
 7264,
 -1,
 756696006,
 7265,
 -53987,
 756512511,
 7259,
 -53986,
 756831641,
 7261,
 -53985,
 756893549,
 7262,
 -1,
 756953784,
 7260,
 757148967,
 756434797,
 -1,
 757214499,
 757075505,
 7258,
 -1,
 757141041,
 7263,
 -53980,
 757169726,
 7273,
 -53979,
 757291050,
 7283,
 -53978,
 757349261,
 7268,
 -1,
 757409483,
 7278,
 757607724,
 757104190,
 -1,
 -53975,
 757566408,
 7277,
 -53974,
 757618289,
 7276,
 -53973,
 757670214,
 7275,
 -1,
 757734032,
 7274,
 757935409,
 757553194,
 -1,
 -53970,
 757892014,
 7286,
 -53969,
 757955769,
 7284,
 -53968,
 758003255,
 7287,
 -1,
 758060814,
 7285,
 758263094,
 757873549,
 -1,
 -53965,
 758214406,
 7269,
 -53964,
 758278047,
 7272,
 -53963,
 758339546,
 7271,
 -1,
 758396471,
 7270,
 758644735,
 758195915,
 -1,
 -53960,
 758541842,
 7282,
 -53959,
 758604197,
 7279,
 -53958,
 758666236,
 7281,
 -1,
 758719004,
 7280,
 758918473,
 756360008,
 -1,
 758983999,
 758871807,
 -1,
 -53954,
 758942222,
 7250,
 -1,
 758987404,
 7251,
 759180610,
 758935302,
 -1,
 -53951,
 759120751,
 7254,
 -1,
 759180703,
 7255,
 759377221,
 759115601,
 -1,
 -53948,
 759324436,
 7252,
 -1,
 759382826,
 7253,
 -53946,
 759336536,
 7248,
 -53945,
 759519998,
 7249,
 -53944,
 759584263,
 7257,
 -1,
 759638401,
 7256,
 759835982,
 758866341,
 -1,
 759901517,
 759791858,
 -1,
 -53940,
 759845717,
 7294,
 -1,
 759899499,
 7295,
 -1,
 759838306,
 7292,
 760163665,
 759780178,
 -1,
 -53936,
 760089001,
 7290,
 -1,
 760153932,
 7288,
 -53934,
 760113720,
 7291,
 -53933,
 760296173,
 7289,
 -1,
 760352968,
 7293,
 760556933,
 743273390,
 -1,
 760622455,
 760498799,
 -1,
 760687961,
 760548913,
 66710,
 -53928,
 760629610,
 66688,
 -1,
 760679985,
 66715,
 760884572,
 760639238,
 -1,
 -53925,
 760821970,
 66697,
 -1,
 760876593,
 66696,
 761081182,
 760829994,
 66713,
 -1,
 761026602,
 66717,
 761212257,
 761021610,
 -1,
 -53920,
 761149005,
 66693,
 -1,
 761204397,
 66703,
 761408867,
 761145035,
 66711,
 -1,
 761341643,
 66716,
 761539942,
 761340230,
 -1,
 -53915,
 761476685,
 66698,
 -1,
 761538783,
 66694,
 -53913,
 761498634,
 66709,
 -53912,
 761695057,
 66692,
 -53911,
 761759712,
 66707,
 -53910,
 761822782,
 66714,
 -53909,
 761886545,
 66690,
 -53908,
 761948157,
 66695,
 -53907,
 762013316,
 66702,
 -53906,
 762075083,
 66706,
 -53905,
 762139125,
 66705,
 -53904,
 762202027,
 66704,
 -53903,
 762266596,
 66691,
 -53902,
 762329997,
 66712,
 -53901,
 762394189,
 66708,
 -53900,
 762458858,
 66700,
 -53899,
 762523566,
 66701,
 -53898,
 762584070,
 66699,
 -1,
 762648387,
 66689,
 762904575,
 760554312,
 -1,
 762916219,
 762803967,
 -1,
 -53894,
 762874382,
 66722,
 -1,
 762919564,
 66723,
 763112830,
 762867462,
 -1,
 -53891,
 763052911,
 66726,
 -1,
 763112863,
 66727,
 763309441,
 763047761,
 -1,
 -53888,
 763256596,
 66724,
 -1,
 763314986,
 66725,
 -53886,
 763268696,
 66720,
 -53885,
 763452158,
 66721,
 -53884,
 763516423,
 66729,
 -1,
 763570561,
 66728,
 763768217,
 760506271,
 -1,
 763833751,
 763708326,
 -1,
 763899280,
 763769408,
 -1,
 763964813,
 763845378,
 -1,
 -53878,
 763916893,
 2933,
 -53877,
 763979523,
 2930,
 -53876,
 764032639,
 2931,
 -1,
 764094884,
 2934,
 764346367,
 763918790,
 -1,
 -53873,
 764244583,
 2935,
 -1,
 764307223,
 2932,
 764489108,
 763856613,
 -1,
 764554643,
 764430189,
 2914,
 -1,
 764495725,
 2915,
 -1,
 764505618,
 2884,
 764805119,
 764430959,
 -1,
 -53866,
 764708739,
 2929,
 -1,
 764773316,
 2869,
 -53864,
 763761413,
 128217,
 -1,
 764872744,
 10183,
 765078951,
 763716005,
 -1,
 765144485,
 765012534,
 -1,
 765210014,
 765097563,
 -1,
 -53859,
 765158252,
 10180,
 -1,
 765205020,
 10179,
 765406625,
 765152975,
 -1,
 -53856,
 765356138,
 128236,
 -1,
 765414751,
 128237,
 -53854,
 765348984,
 128275,
 -53853,
 765540084,
 128080,
 -53852,
 765604026,
 128194,
 -1,
 765663629,
 128214,
 -53850,
 765098532,
 128191,
 -1,
 765802801,
 9934,
 765996463,
 765023228,
 -1,
 766061997,
 765927093,
 -1,
 -53846,
 766015501,
 128662,
 -53845,
 766076171,
 128660,
 -53844,
 766122594,
 128653,
 -1,
 766187126,
 128664,
 -53842,
 765994743,
 11819,
 -1,
 766314564,
 128283,
 766520754,
 765952872,
 -1,
 -53839,
 766462815,
 9885,
 -1,
 766515668,
 128228,
 -53837,
 766479110,
 128002,
 -53836,
 766657721,
 128076,
 -53835,
 766718049,
 127970,
 -53834,
 766780004,
 127842,
 -1,
 766845119,
 128025,
 767045410,
 743192119,
 -1,
 767110761,
 766971441,
 -1,
 767176289,
 767054844,
 -1,
 767241824,
 767112705,
 -1,
 767307314,
 767181766,
 -1,
 767372809,
 767253420,
 -1,
 767438290,
 767323910,
 -1,
 767503817,
 767389587,
 -1,
 767569345,
 767457885,
 55245,
 -1,
 767494653,
 55246,
 767700420,
 767521307,
 -1,
 -53821,
 767654493,
 55277,
 -1,
 767706796,
 55276,
 -53819,
 767650676,
 55255,
 -53818,
 767845351,
 55270,
 -53817,
 767907294,
 4607,
 -53816,
 767971804,
 55264,
 -1,
 768023855,
 55289,
 768278527,
 767443367,
 -1,
 768290253,
 768154256,
 -1,
 -53812,
 768228656,
 55279,
 -1,
 768292935,
 55280,
 -53810,
 768244079,
 55281,
 -53809,
 768434762,
 55278,
 -53808,
 768496092,
 55274,
 -53807,
 768558445,
 55275,
 -1,
 768620622,
 55282,
 768814561,
 767386021,
 -1,
 768880091,
 768752956,
 -1,
 768945623,
 768809616,
 -1,
 -53802,
 768884016,
 55272,
 -1,
 768948295,
 55273,
 -53800,
 768899677,
 55267,
 -53799,
 769094201,
 55271,
 -53798,
 769158018,
 55268,
 -1,
 769216988,
 55269,
 769404382,
 768817254,
 -1,
 -53795,
 769358191,
 55291,
 -1,
 769421846,
 55290,
 769654783,
 769332061,
 -1,
 -53792,
 769549287,
 55283,
 -1,
 769607021,
 55284,
 769797611,
 768764781,
 -1,
 769863141,
 769756254,
 -1,
 -53788,
 769814953,
 55259,
 -1,
 769875321,
 55260,
 770059752,
 769811437,
 -1,
 -53785,
 770013789,
 55257,
 -1,
 770073516,
 55258,
 -53783,
 770012382,
 55253,
 -53782,
 770200041,
 55256,
 -1,
 770262707,
 55254,
 770452979,
 769751652,
 -1,
 770518510,
 770404886,
 55248,
 -1,
 770443722,
 55249,
 770649585,
 770448016,
 -1,
 -53776,
 770587952,
 55250,
 -1,
 770652231,
 55251,
 -53774,
 770603375,
 55252,
 -1,
 770794471,
 55247,
 770977275,
 770393258,
 -1,
 771042810,
 770917302,
 -1,
 -53770,
 770991079,
 4603,
 -53769,
 771053022,
 4602,
 -53768,
 771114588,
 4605,
 -53767,
 771176526,
 4606,
 -1,
 771235012,
 4604,
 -1,
 770970615,
 55261,
 771501568,
 770920930,
 -1,
 -53763,
 771454186,
 55263,
 -53762,
 771515380,
 55265,
 -53761,
 771577310,
 55262,
 -1,
 771628335,
 55266,
 771829251,
 771460308,
 -1,
 -53758,
 771772892,
 55285,
 -1,
 771831886,
 55286,
 772025862,
 771773924,
 -1,
 -53755,
 771976039,
 55243,
 -1,
 772021444,
 55244,
 772276223,
 771956021,
 -1,
 -53752,
 772175093,
 55288,
 -1,
 772236263,
 55287,
 772472831,
 767328635,
 -1,
 772484629,
 772357086,
 -1,
 772550163,
 772443080,
 -1,
 772615694,
 772482763,
 55232,
 -1,
 772560938,
 55231,
 772746769,
 772542001,
 -1,
 -53744,
 772679371,
 55230,
 -1,
 772737530,
 55229,
 -53742,
 772701758,
 55235,
 -1,
 772888618,
 55234,
 -53740,
 772495438,
 55233,
 -1,
 773012365,
 55236,
 773205535,
 772443080,
 -1,
 773271066,
 773150795,
 -1,
 773336601,
 773197361,
 55218,
 -1,
 773269195,
 55219,
 -1,
 773270336,
 55220,
 773533213,
 773226128,
 -1,
 -53732,
 773478442,
 55224,
 -1,
 773525456,
 55223,
 -53730,
 773466947,
 4517,
 -1,
 773656217,
 4516,
 773860901,
 773150795,
 -1,
 773926436,
 773819336,
 -1,
 773991971,
 773852721,
 4518,
 -1,
 773924555,
 4519,
 -1,
 773925696,
 55216,
 -1,
 773871694,
 55217,
 774254122,
 773795088,
 -1,
 774319656,
 774186699,
 55227,
 -1,
 774264874,
 55226,
 -53719,
 774264874,
 55228,
 -1,
 774377009,
 55225,
 774581807,
 774180401,
 -1,
 774647342,
 774531108,
 -1,
 -53715,
 774579915,
 55238,
 -1,
 774639153,
 55237,
 -1,
 774572453,
 4515,
 774963199,
 774536848,
 -1,
 -53711,
 774868155,
 55221,
 -1,
 774912993,
 55222,
 775159807,
 767237353,
 -1,
 775171650,
 775056237,
 -1,
 775237178,
 775122694,
 -1,
 775302713,
 775188371,
 -1,
 -53705,
 775256669,
 43367,
 -53704,
 775316455,
 43370,
 -1,
 775374508,
 43365,
 -1,
 775242147,
 43372,
 775630398,
 775177386,
 -1,
 -53700,
 775570352,
 43364,
 -53699,
 775632991,
 43374,
 -1,
 775689194,
 43371,
 -53697,
 775584349,
 43366,
 -53696,
 775840743,
 43369,
 -53695,
 775901660,
 43368,
 -1,
 775953711,
 43373,
 776154696,
 775125604,
 -1,
 -53692,
 776106518,
 43362,
 -53691,
 776170343,
 4446,
 -53690,
 776233959,
 43361,
 -53689,
 776294876,
 43360,
 -1,
 776346927,
 43363,
 776547917,
 776107224,
 -1,
 -53686,
 776506559,
 43388,
 -53685,
 776567151,
 43385,
 -53684,
 776630817,
 43381,
 -1,
 776674620,
 43384,
 776875603,
 776495525,
 -1,
 776941138,
 776813884,
 -1,
 -53680,
 776892972,
 43378,
 -53679,
 776947292,
 43379,
 -1,
 777009230,
 43380,
 -1,
 776878190,
 43386,
 777268823,
 776820196,
 -1,
 -53675,
 777220630,
 4443,
 -53674,
 777271374,
 4445,
 -1,
 777329967,
 4444,
 777530971,
 777212386,
 -1,
 -53671,
 777484893,
 43376,
 -53670,
 777548310,
 43377,
 -1,
 777602732,
 43375,
 777793118,
 777469237,
 -1,
 -53667,
 777743207,
 43382,
 -1,
 777795662,
 43383,
 -53665,
 777733824,
 4442,
 -1,
 777926740,
 43387,
 -1,
 767173137,
 128092,
 778186342,
 767118883,
 -1,
 778251876,
 778129758,
 128296,
 -1,
 778174560,
 9874,
 -53659,
 778204517,
 128057,
 -1,
 778312283,
 127828,
 -53657,
 778139670,
 128035,
 -53656,
 778462611,
 128587,
 -1,
 778519021,
 128135,
 778710771,
 767043275,
 -1,
 778776265,
 778668890,
 -1,
 778841728,
 778729215,
 -1,
 778907263,
 778778482,
 -1,
 778972785,
 778836624,
 -1,
 -53649,
 778922394,
 19904,
 -53648,
 778980219,
 19933,
 -1,
 779032166,
 19953,
 779234934,
 778898993,
 -1,
 779300469,
 779184031,
 -1,
 -53644,
 779247478,
 19954,
 -1,
 779310051,
 19910,
 -1,
 779229827,
 19932,
 779562617,
 779192124,
 -1,
 -53640,
 779495902,
 19951,
 -1,
 779555563,
 19959,
 -53638,
 779512242,
 19905,
 -53637,
 779702284,
 19957,
 -53636,
 779765226,
 19955,
 -53635,
 779830397,
 19961,
 -53634,
 779891758,
 19960,
 -1,
 779956235,
 19940,
 -1,
 778856833,
 19913,
 780217994,
 778772806,
 -1,
 780283525,
 780150475,
 -1,
 -53629,
 780240079,
 19956,
 -53628,
 780291006,
 19943,
 -1,
 780345261,
 19944,
 780545672,
 780221325,
 -1,
 -53625,
 780498018,
 19962,
 -1,
 780546171,
 19906,
 -53623,
 780501708,
 19935,
 -1,
 780670085,
 19939,
 780873365,
 780153528,
 -1,
 780938900,
 780822431,
 -1,
 781004435,
 780871730,
 -1,
 781069970,
 780951973,
 -1,
 781135505,
 781015082,
 -1,
 -53616,
 781092945,
 19937,
 -1,
 781153536,
 19917,
 -1,
 781085265,
 19931,
 -1,
 781023205,
 19929,
 -1,
 780930907,
 19925,
 -1,
 780867075,
 19948,
 781594267,
 780824326,
 -1,
 781659801,
 781537054,
 -1,
 -53608,
 781613029,
 19912,
 -1,
 781673911,
 19965,
 -53606,
 781613036,
 19915,
 -1,
 781804614,
 19926,
 781987489,
 781532832,
 -1,
 782053023,
 781931516,
 -1,
 -53602,
 781998262,
 19928,
 -1,
 782052287,
 19964,
 -53600,
 781988238,
 19934,
 -1,
 782180269,
 19945,
 782380710,
 781937022,
 -1,
 782446245,
 782333695,
 -1,
 -53596,
 782402303,
 19927,
 -1,
 782461333,
 19936,
 -1,
 782403198,
 19952,
 782708394,
 782328229,
 -1,
 -53592,
 782664509,
 19949,
 -53591,
 782724510,
 19938,
 -1,
 782772159,
 19914,
 782970543,
 782653482,
 -1,
 783036078,
 782918995,
 -1,
 -53587,
 782985865,
 19950,
 -1,
 783048211,
 19941,
 -1,
 782965281,
 19942,
 783298228,
 782900866,
 -1,
 783363763,
 783242236,
 -1,
 -53582,
 783317102,
 19923,
 -1,
 783364472,
 19909,
 -1,
 783307304,
 19947,
 783625912,
 783226638,
 -1,
 -53578,
 783575433,
 19946,
 -53577,
 783631108,
 19924,
 -1,
 783690014,
 19967,
 783888060,
 783552049,
 -1,
 -53574,
 783836542,
 19922,
 -53573,
 783889039,
 19966,
 -1,
 783948361,
 19958,
 784150207,
 783845180,
 -1,
 -53570,
 784096667,
 19921,
 -1,
 784142619,
 19908,
 784346818,
 784093849,
 -1,
 -53567,
 784302983,
 19930,
 -1,
 784343723,
 19918,
 784543429,
 784281425,
 -1,
 -53564,
 784489021,
 19920,
 -1,
 784542190,
 19916,
 -53562,
 784502104,
 19907,
 -53561,
 784681792,
 19963,
 -53560,
 784742820,
 19911,
 -1,
 784804616,
 19919,
 785002215,
 778702385,
 -1,
 785067741,
 784959282,
 -1,
 785133264,
 784997704,
 11096,
 785198799,
 785057644,
 -1,
 -53554,
 785151491,
 9955,
 -1,
 785194319,
 11095,
 -1,
 785129840,
 11097,
 785460949,
 785074029,
 -1,
 785526484,
 785408264,
 -1,
 -53549,
 785478129,
 10079,
 -1,
 785524004,
 10080,
 -1,
 785454175,
 11093,
 785788632,
 785391942,
 -1,
 -53545,
 785734194,
 128178,
 -1,
 785793890,
 10135,
 -53543,
 785746088,
 9947,
 -53542,
 785933445,
 10133,
 -53541,
 785997753,
 11094,
 -53540,
 786059848,
 10134,
 -1,
 786116240,
 10071,
 786312932,
 785016735,
 -1,
 786378467,
 786265857,
 -1,
 786444002,
 786336105,
 -1,
 -53535,
 786393923,
 128157,
 -1,
 786437332,
 128152,
 -1,
 786375230,
 128159,
 -1,
 786303466,
 128585,
 786825215,
 786243910,
 -1,
 -53530,
 786724254,
 9980,
 -1,
 786785204,
 127911,
 786968303,
 784931332,
 -1,
 787033837,
 786915749,
 -1,
 787099372,
 786979241,
 -1,
 -53525,
 787048073,
 1479,
 -1,
 787102096,
 1466,
 -1,
 787054862,
 1478,
 -53522,
 786976721,
 1477,
 -1,
 787287879,
 1442,
 787492594,
 786909037,
 -1,
 -53519,
 787435916,
 9937,
 -1,
 787496096,
 128641,
 -1,
 787441970,
 127807,
 787754762,
 778655786,
 -1,
 787820285,
 787703711,
 -1,
 787885817,
 787771360,
 128014,
 788004863,
 787808256,
 -1,
 -53512,
 787900424,
 127943,
 -1,
 787951537,
 128052,
 788201471,
 787825597,
 -1,
 -53509,
 788102049,
 128677,
 -53508,
 788156161,
 9897,
 -1,
 788207891,
 11043,
 788410114,
 787775038,
 -1,
 788475649,
 788361187,
 -1,
 -53504,
 788433283,
 127969,
 -1,
 788470328,
 127968,
 -1,
 788425448,
 9203,
 788737797,
 788363007,
 -1,
 -53500,
 788670923,
 127976,
 -1,
 788725949,
 9749,
 788934408,
 788682133,
 -1,
 -53497,
 788862963,
 128029,
 -1,
 788923827,
 127855,
 -53495,
 788886664,
 127973,
 -1,
 789060832,
 128298,
 789262109,
 787692429,
 -1,
 789327635,
 789211191,
 -1,
 789393170,
 789256348,
 -1,
 -53490,
 789347902,
 983956,
 -53489,
 789403690,
 983958,
 -53488,
 789461901,
 983955,
 -53487,
 789522123,
 983957,
 -1,
 789581361,
 983954,
 -1,
 789320759,
 110593,
 789851931,
 789263483,
 -1,
 789917464,
 789776735,
 -1,
 789982999,
 789869654,
 128644,
 -1,
 789907315,
 128645,
 -1,
 789919668,
 128096,
 790233087,
 789839872,
 -1,
 -53478,
 790136433,
 9889,
 -1,
 790174218,
 128262,
 -53476,
 789804469,
 9964,
 -1,
 790304995,
 127802,
 790507296,
 789220724,
 -1,
 -53473,
 790452471,
 11794,
 -1,
 790509504,
 11802,
 -53471,
 790462786,
 128175,
 -1,
 790654714,
 8372,
 790835277,
 766989308,
 -1,
 790900699,
 790767307,
 -1,
 790966167,
 790857532,
 -1,
 791031702,
 790888448,
 -1,
 791097235,
 790984583,
 -1,
 791162730,
 791038575,
 -1,
 791228229,
 791104795,
 -1,
 791293741,
 791181055,
 -1,
 -53461,
 791244634,
 6539,
 -53460,
 791295565,
 6546,
 -1,
 791350833,
 6545,
 791555888,
 791251718,
 -1,
 -53457,
 791512004,
 6569,
 -1,
 791547441,
 6534,
 791752499,
 791506694,
 -1,
 -53454,
 791707311,
 6571,
 -1,
 791744049,
 6540,
 791949110,
 791699877,
 -1,
 -53451,
 791885389,
 6552,
 -1,
 791940657,
 6551,
 792145721,
 791892988,
 -1,
 -53448,
 792081130,
 6535,
 -1,
 792137265,
 6547,
 792342332,
 792085674,
 -1,
 -53445,
 792298436,
 6568,
 -1,
 792333873,
 6533,
 -53443,
 792300554,
 6541,
 -53442,
 792495044,
 6558,
 -53441,
 792553089,
 6529,
 -53440,
 792612469,
 6553,
 -53439,
 792676251,
 6559,
 -53438,
 792737357,
 6563,
 -53437,
 792801198,
 6557,
 -53436,
 792863138,
 6564,
 -1,
 792926019,
 6565,
 793128802,
 791165051,
 -1,
 793194314,
 793081599,
 -1,
 -53432,
 793145178,
 6536,
 -53431,
 793196109,
 6543,
 -1,
 793251377,
 6542,
 793456461,
 793152262,
 -1,
 -53428,
 793412548,
 6567,
 -1,
 793447985,
 6531,
 793653072,
 793407238,
 -1,
 -53425,
 793607855,
 6570,
 -1,
 793644593,
 6537,
 793849683,
 793600421,
 -1,
 -53422,
 793785933,
 6549,
 -1,
 793841201,
 6548,
 794046294,
 793793532,
 -1,
 -53419,
 793981674,
 6532,
 -1,
 794037809,
 6544,
 794242905,
 793986218,
 -1,
 -53416,
 794198980,
 6566,
 -1,
 794234417,
 6530,
 -53414,
 794201098,
 6538,
 -53413,
 794395588,
 6555,
 -53412,
 794453633,
 6528,
 -53411,
 794513013,
 6550,
 -53410,
 794576795,
 6556,
 -53409,
 794637901,
 6560,
 -53408,
 794701742,
 6554,
 -53407,
 794763682,
 6561,
 -1,
 794826563,
 6562,
 795082751,
 793063630,
 -1,
 795094885,
 794973180,
 6595,
 -1,
 795030200,
 6594,
 -53402,
 795050926,
 6593,
 -53401,
 795168291,
 6596,
 -53400,
 795231402,
 6597,
 -53399,
 795287878,
 6598,
 -1,
 795350798,
 6599,
 795553662,
 791119563,
 -1,
 795619184,
 795508286,
 6579,
 795684718,
 795551435,
 6585,
 -1,
 795642824,
 6591,
 -53393,
 795642824,
 6588,
 -1,
 795770430,
 6580,
 795946868,
 795564074,
 6583,
 796012403,
 795872817,
 6584,
 -1,
 795970504,
 6590,
 -1,
 795970504,
 6589,
 796209017,
 795872817,
 -1,
 796274551,
 796134961,
 6577,
 -1,
 796232648,
 6587,
 -53384,
 796232648,
 6586,
 -1,
 796337867,
 6582,
 796536700,
 796146573,
 -1,
 -53381,
 796494792,
 6592,
 -1,
 796539789,
 6578,
 -53379,
 796493499,
 6576,
 -1,
 796665547,
 6581,
 796864396,
 795485000,
 -1,
 796929922,
 796817151,
 -1,
 -53375,
 796887566,
 6610,
 -1,
 796932748,
 6611,
 797126533,
 796880646,
 -1,
 -53372,
 797066095,
 6614,
 -1,
 797126047,
 6615,
 797323144,
 797060945,
 -1,
 -53369,
 797269780,
 6612,
 -1,
 797328170,
 6613,
 -53367,
 797281880,
 6608,
 -53366,
 797465342,
 6609,
 -53365,
 797529607,
 6617,
 -1,
 797583745,
 6616,
 797781905,
 796817151,
 -1,
 797847440,
 797727547,
 -1,
 -53361,
 797772707,
 6601,
 -1,
 797838099,
 6600,
 -1,
 797783717,
 6618,
 798162943,
 797733321,
 6622,
 -1,
 798065582,
 6623,
 798294015,
 791040803,
 -1,
 -53355,
 798198137,
 127770,
 -1,
 798258888,
 127761,
 -1,
 790983759,
 128240,
 798502871,
 790901629,
 -1,
 798568378,
 798454957,
 -1,
 798633908,
 798509185,
 -1,
 -53349,
 798592497,
 127369,
 -53348,
 798657480,
 127368,
 -53347,
 798722822,
 127367,
 -53346,
 798787388,
 127366,
 -53345,
 798852014,
 127365,
 -53344,
 798916158,
 127364,
 -53343,
 798979839,
 127363,
 -53342,
 799043334,
 127362,
 -53341,
 799106975,
 127361,
 -53340,
 799172211,
 127360,
 -53339,
 799236517,
 127359,
 -53338,
 799299626,
 127358,
 -53337,
 799364092,
 127357,
 -53336,
 799428131,
 127356,
 -53335,
 799491949,
 127355,
 -53334,
 799556778,
 127354,
 -53333,
 799622086,
 127353,
 -53332,
 799685517,
 127352,
 -53331,
 799749687,
 127351,
 -53330,
 799814328,
 127350,
 -53329,
 799878993,
 127349,
 -53328,
 799942347,
 127348,
 -53327,
 800006470,
 127347,
 -53326,
 800070288,
 127346,
 -53325,
 800134926,
 127345,
 -1,
 800198193,
 127344,
 -53323,
 798591018,
 127375,
 -53322,
 800354138,
 127373,
 -53321,
 800416228,
 127372,
 -53320,
 800472150,
 127371,
 -53319,
 800530430,
 10062,
 -1,
 800591564,
 127374,
 800849919,
 798498141,
 -1,
 800862166,
 800737409,
 -1,
 -53315,
 800820721,
 127337,
 -53314,
 800885704,
 127336,
 -53313,
 800951046,
 127335,
 -53312,
 801015612,
 127334,
 -53311,
 801080238,
 127333,
 -53310,
 801144382,
 127332,
 -53309,
 801208063,
 127331,
 -53308,
 801271558,
 127330,
 -53307,
 801335199,
 127329,
 -53306,
 801400435,
 127328,
 -53305,
 801464741,
 127327,
 -53304,
 801527850,
 127326,
 -53303,
 801592316,
 127325,
 -53302,
 801656355,
 127324,
 -53301,
 801720173,
 127323,
 -53300,
 801785002,
 127322,
 -53299,
 801850310,
 127321,
 -53298,
 801913741,
 127320,
 -53297,
 801977911,
 127319,
 -53296,
 802042552,
 127318,
 -53295,
 802107217,
 127317,
 -53294,
 802170571,
 127316,
 -53293,
 802234694,
 127315,
 -53292,
 802298512,
 127314,
 -53291,
 802363150,
 127313,
 -1,
 802426417,
 127312,
 -1,
 800793423,
 9471,
 802697178,
 798458728,
 -1,
 -53287,
 802646192,
 128528,
 -1,
 802696072,
 9906,
 -1,
 802627075,
 128084,
 802959397,
 790841045,
 -1,
 803024900,
 802899821,
 -1,
 803090434,
 802958560,
 -1,
 803155939,
 803034108,
 2002,
 803221473,
 803113994,
 2018,
 -1,
 803146062,
 2023,
 803405823,
 803147313,
 2019,
 -1,
 803277134,
 2016,
 803483625,
 803095494,
 -1,
 803549160,
 803429108,
 -1,
 -53274,
 803497981,
 2026,
 -53273,
 803554276,
 2024,
 -1,
 803609722,
 2025,
 -1,
 803474993,
 2006,
 803876844,
 803432351,
 -1,
 -53269,
 803825661,
 2010,
 -1,
 803868209,
 2009,
 804073454,
 803821610,
 2000,
 -1,
 804018218,
 1999,
 804204528,
 804005579,
 1997,
 -1,
 804136651,
 1995,
 804335602,
 804135330,
 2008,
 -1,
 804271039,
 2001,
 -53261,
 804293642,
 2022,
 -53260,
 804423555,
 2021,
 -53259,
 804486718,
 1998,
 -53258,
 804550481,
 2005,
 -53257,
 804613978,
 2011,
 -53256,
 804676068,
 2004,
 -53255,
 804736629,
 2017,
 -53254,
 804800411,
 2015,
 -53253,
 804865288,
 2014,
 -53252,
 804928397,
 1996,
 -53251,
 804992589,
 2020,
 -53250,
 805057443,
 2012,
 -53249,
 805121966,
 2013,
 -53248,
 805182586,
 2007,
 -53247,
 805246787,
 2003,
 -1,
 805310001,
 1994,
 -53245,
 803037480,
 2037,
 -1,
 805441850,
 2042,
 805646354,
 802956104,
 -1,
 805711880,
 805598975,
 -1,
 -53241,
 805669390,
 1986,
 -1,
 805714572,
 1987,
 805908491,
 805662470,
 -1,
 -53238,
 805847919,
 1990,
 -1,
 805907871,
 1991,
 806105102,
 805842769,
 -1,
 -53235,
 806051604,
 1988,
 -1,
 806109994,
 1989,
 -53233,
 806063704,
 1984,
 -53232,
 806247166,
 1985,
 -53231,
 806311431,
 1993,
 -1,
 806365569,
 1992,
 806563872,
 805576358,
 -1,
 806629407,
 806492360,
 -1,
 806694937,
 806571166,
 -1,
 -53226,
 806645021,
 2033,
 -53225,
 806702391,
 2032,
 -53224,
 806762675,
 2031,
 -1,
 806822546,
 2030,
 807022621,
 806646108,
 -1,
 -53221,
 806972701,
 2029,
 -53220,
 807030071,
 2028,
 -1,
 807090355,
 2027,
 -53218,
 806966403,
 2034,
 -1,
 807216457,
 2035,
 -1,
 806571637,
 2040,
 807481379,
 806516431,
 -1,
 -53214,
 807427058,
 2038,
 -1,
 807482279,
 2039,
 -53212,
 807418045,
 2036,
 -1,
 807612005,
 2041,
 807809096,
 802904106,
 -1,
 807874620,
 807759448,
 -1,
 807940150,
 807812878,
 -1,
 808005681,
 807875136,
 -1,
 808071214,
 807951106,
 -1,
 -53205,
 808022621,
 43059,
 -53204,
 808085251,
 43056,
 -53203,
 808138367,
 43057,
 -1,
 808200612,
 43060,
 808452095,
 808024518,
 -1,
 -53200,
 808350311,
 43061,
 -1,
 808412951,
 43058,
 808595508,
 807954100,
 -1,
 -53197,
 808545870,
 43062,
 -1,
 808605517,
 43065,
 -53195,
 808545991,
 43064,
 -1,
 808739863,
 43063,
 808923193,
 807897173,
 -1,
 -53192,
 808880271,
 11009,
 -1,
 808917242,
 11017,
 809172991,
 808855560,
 -1,
 -53189,
 809076879,
 11008,
 -1,
 809113850,
 11016,
 809316420,
 807796736,
 -1,
 809381951,
 809249568,
 9940,
 -1,
 809305617,
 128683,
 -53184,
 809333710,
 128685,
 -53183,
 809460427,
 128695,
 -53182,
 809524052,
 128286,
 -53181,
 809587356,
 128245,
 -1,
 809638025,
 128691,
 809840710,
 809269299,
 128211,
 -1,
 809764833,
 128212,
 -53177,
 809791456,
 128067,
 -1,
 809915443,
 128689,
 810102859,
 807734833,
 -1,
 -53174,
 810045621,
 128219,
 -1,
 810106397,
 128133,
 -53172,
 810058603,
 128297,
 -1,
 810237359,
 127747,
 810430810,
 790765894,
 -1,
 810496226,
 810375210,
 -1,
 810561734,
 810439229,
 -1,
 810627211,
 810517797,
 -1,
 810692746,
 810551649,
 -1,
 810758234,
 810618235,
 -1,
 -53164,
 810683725,
 127123,
 -53163,
 810749152,
 127122,
 -53162,
 810814626,
 127121,
 -53161,
 810880058,
 127120,
 -53160,
 810945443,
 127119,
 -53159,
 811010835,
 127118,
 -1,
 811076240,
 127117,
 811282530,
 810683692,
 -1,
 -53156,
 811208013,
 127116,
 -53155,
 811273440,
 127115,
 -53154,
 811338914,
 127114,
 -53153,
 811404346,
 127113,
 -53152,
 811469731,
 127112,
 -53151,
 811535123,
 127111,
 -1,
 811600528,
 127110,
 811806826,
 811207888,
 -1,
 -53148,
 811732301,
 127109,
 -53147,
 811797728,
 127108,
 -53146,
 811863202,
 127107,
 -53145,
 811928634,
 127106,
 -53144,
 811994019,
 127105,
 -53143,
 812059411,
 127104,
 -1,
 812124816,
 127103,
 812331122,
 811732113,
 -1,
 -53140,
 812256589,
 127102,
 -53139,
 812322016,
 127101,
 -53138,
 812387490,
 127100,
 -53137,
 812452922,
 127099,
 -53136,
 812518307,
 127098,
 -53135,
 812583699,
 127097,
 -1,
 812649104,
 127096,
 812855418,
 812256277,
 -1,
 -53132,
 812780877,
 127095,
 -53131,
 812846304,
 127094,
 -53130,
 812911778,
 127093,
 -53129,
 812977210,
 127092,
 -53128,
 813042595,
 127091,
 -53127,
 813107987,
 127090,
 -1,
 813173392,
 127089,
 813379714,
 812780417,
 -1,
 -53124,
 813305165,
 127088,
 -53123,
 813370592,
 127087,
 -53122,
 813436066,
 127086,
 -53121,
 813501498,
 127085,
 -53120,
 813566883,
 127084,
 -53119,
 813632275,
 127083,
 -1,
 813697680,
 127082,
 813957119,
 813304578,
 -1,
 -53116,
 813829453,
 127081,
 -53115,
 813894880,
 127080,
 -53114,
 813960354,
 127079,
 -53113,
 814025786,
 127078,
 -53112,
 814091171,
 127077,
 -53111,
 814156563,
 127076,
 -1,
 814221968,
 127075,
 -1,
 810614955,
 127074,
 814546943,
 810564076,
 -1,
 814559429,
 814418273,
 -1,
 814624917,
 814484859,
 -1,
 -53105,
 814550349,
 127073,
 -53104,
 814615776,
 127072,
 -53103,
 814681250,
 127071,
 -53102,
 814746682,
 127070,
 -53101,
 814812067,
 127069,
 -53100,
 814877459,
 127068,
 -1,
 814942864,
 127067,
 815149213,
 814550316,
 -1,
 -53097,
 815074637,
 127066,
 -53096,
 815140064,
 127065,
 -53095,
 815205538,
 127064,
 -53094,
 815270970,
 127063,
 -53093,
 815336355,
 127062,
 -53092,
 815401747,
 127061,
 -1,
 815467152,
 127060,
 815673509,
 815074512,
 -1,
 -53089,
 815598925,
 127059,
 -53088,
 815664352,
 127058,
 -53087,
 815729826,
 127057,
 -53086,
 815795258,
 127056,
 -53085,
 815860643,
 127055,
 -53084,
 815926035,
 127054,
 -1,
 815991440,
 127053,
 816197805,
 815598737,
 -1,
 -53081,
 816123213,
 127052,
 -53080,
 816188640,
 127051,
 -53079,
 816254114,
 127050,
 -53078,
 816319546,
 127049,
 -53077,
 816384931,
 127048,
 -53076,
 816450323,
 127047,
 -1,
 816515728,
 127046,
 816722101,
 816122901,
 -1,
 -53073,
 816647501,
 127045,
 -53072,
 816712928,
 127044,
 -53071,
 816778402,
 127043,
 -53070,
 816843834,
 127042,
 -53069,
 816909219,
 127041,
 -53068,
 816974611,
 127040,
 -1,
 817040016,
 127039,
 817246397,
 816647041,
 -1,
 -53065,
 817171789,
 127038,
 -53064,
 817237216,
 127037,
 -53063,
 817302690,
 127036,
 -53062,
 817368122,
 127035,
 -53061,
 817433507,
 127034,
 -53060,
 817498899,
 127033,
 -1,
 817564304,
 127032,
 817823743,
 817171202,
 -1,
 -53057,
 817696077,
 127031,
 -53056,
 817761504,
 127030,
 -53055,
 817826978,
 127029,
 -53054,
 817892410,
 127028,
 -53053,
 817957795,
 127027,
 -53052,
 818023187,
 127026,
 -1,
 818088592,
 127025,
 -1,
 814481579,
 127024,
 818360528,
 810516030,
 -1,
 818426063,
 818288947,
 -1,
 818491595,
 818356552,
 -1,
 -53046,
 818433783,
 9891,
 -1,
 818491457,
 9890,
 818688206,
 818413568,
 -1,
 -53043,
 818632822,
 11799,
 -1,
 818684200,
 10175,
 -1,
 818612851,
 8508,
 -1,
 818361513,
 127849,
 819015894,
 818314428,
 -1,
 -53038,
 818969583,
 11784,
 -53037,
 819033231,
 11034,
 -53036,
 819096588,
 11798,
 -53035,
 819157097,
 11795,
 -1,
 819208184,
 8284,
 819409117,
 818973182,
 -1,
 819474650,
 819365789,
 -1,
 -53031,
 819403002,
 11015,
 -1,
 819466876,
 11796,
 819724287,
 819399172,
 -1,
 -53028,
 819622724,
 128317,
 -1,
 819685877,
 128315,
 819867871,
 819344056,
 128021,
 -1,
 819790227,
 128054,
 -53024,
 819813699,
 128682,
 -53023,
 819940758,
 128044,
 -1,
 819987240,
 128687,
 820195611,
 810428107,
 -1,
 820261135,
 820151251,
 -1,
 820326646,
 820202095,
 -1,
 820392168,
 820280894,
 -1,
 -53017,
 820346853,
 2423,
 -1,
 820389579,
 2422,
 820588779,
 820336682,
 -1,
 -53014,
 820533526,
 2420,
 -1,
 820586187,
 2419,
 820785390,
 820523704,
 -1,
 -53011,
 820727046,
 2429,
 -1,
 820785898,
 2427,
 -53009,
 820743855,
 2425,
 -53008,
 820932963,
 2308,
 -53007,
 820986949,
 2428,
 -53006,
 821049259,
 2426,
 -53005,
 821109279,
 2430,
 -53004,
 821172997,
 2418,
 -53003,
 821237712,
 2431,
 -1,
 821302998,
 2421,
 821506306,
 820277685,
 -1,
 821571837,
 821435189,
 -1,
 821637371,
 821524223,
 -1,
 -52998,
 821594638,
 43253,
 -1,
 821639820,
 43254,
 -52996,
 821593582,
 43251,
 -1,
 821761672,
 43255,
 -52994,
 821523508,
 43250,
 -52993,
 821913162,
 43256,
 -52992,
 821969169,
 2304,
 -52991,
 822032534,
 2417,
 -1,
 822093066,
 43252,
 822292748,
 821462731,
 -1,
 822358278,
 822246974,
 -1,
 -52987,
 822312933,
 2391,
 -1,
 822355659,
 2390,
 822554889,
 822302762,
 -1,
 -52984,
 822499606,
 2363,
 -1,
 822552267,
 2362,
 -52982,
 822502875,
 2382,
 -52981,
 822680347,
 2389,
 -1,
 822744790,
 2383,
 -52979,
 822228865,
 43259,
 -52978,
 822883173,
 43257,
 -1,
 822942599,
 43258,
 823144726,
 820211769,
 -1,
 823210259,
 823096104,
 -1,
 -52974,
 823155093,
 66638,
 -1,
 823209551,
 66639,
 823459839,
 823139171,
 -1,
 -52971,
 823351701,
 66598,
 -1,
 823406159,
 66599,
 823603481,
 823074079,
 -1,
 -52968,
 823545571,
 9192,
 -1,
 823600777,
 127795,
 -52966,
 823550602,
 127980,
 -1,
 823741384,
 128666,
 823931212,
 820132749,
 -1,
 823996731,
 823866040,
 -1,
 824062253,
 823935641,
 -1,
 824127777,
 824020573,
 -1,
 -52960,
 824062631,
 127232,
 -1,
 824123085,
 127233,
 824324388,
 824080127,
 -1,
 -52957,
 824281630,
 127235,
 -1,
 824326818,
 127236,
 824520999,
 824274694,
 -1,
 -52954,
 824460150,
 127239,
 -1,
 824520106,
 127240,
 824717610,
 824454993,
 -1,
 -52951,
 824663837,
 127237,
 -1,
 824722227,
 127238,
 -52949,
 824662791,
 127234,
 -52948,
 824858124,
 127242,
 -1,
 824912270,
 127241,
 825163775,
 824010946,
 -1,
 825176370,
 825042946,
 119557,
 825294847,
 825118230,
 -1,
 -52943,
 825196689,
 119556,
 -1,
 825239607,
 119555,
 825438517,
 825117274,
 -1,
 -52940,
 825376416,
 9869,
 -1,
 825430780,
 9870,
 825635128,
 825374263,
 -1,
 -52937,
 825589910,
 119554,
 -1,
 825632829,
 119553,
 825884671,
 825570754,
 -1,
 -52934,
 825769632,
 9871,
 -1,
 825823996,
 9868,
 826028354,
 823923279,
 -1,
 826093889,
 825985385,
 -1,
 -52930,
 826047336,
 11032,
 -52929,
 826108849,
 11031,
 -52928,
 826165674,
 11030,
 -1,
 826218911,
 11033,
 -1,
 826044633,
 128160,
 826487111,
 825978714,
 -1,
 826552646,
 826434908,
 -1,
 -52923,
 826486705,
 128542,
 -1,
 826546790,
 128549,
 -1,
 826480951,
 9933,
 826814794,
 826445548,
 -1,
 -52919,
 826767048,
 128171,
 -1,
 826814385,
 128565,
 -52917,
 826771083,
 9902,
 -1,
 826960333,
 127919,
 827142484,
 823879583,
 -1,
 827208016,
 827086890,
 -1,
 -52913,
 827155521,
 128167,
 -1,
 827216111,
 128042,
 827404626,
 827134129,
 128009,
 -1,
 827326867,
 128050,
 -52909,
 827343700,
 9946,
 -1,
 827468943,
 128087,
 827666777,
 827067953,
 -1,
 827732312,
 827610108,
 -1,
 -52905,
 827667773,
 127841,
 -1,
 827726939,
 128131,
 -1,
 827682934,
 128168,
 -1,
 827622526,
 128192,
 828060232,
 810379167,
 -1,
 828125625,
 827991755,
 -1,
 828191115,
 828064756,
 -1,
 828256633,
 828131951,
 -1,
 828322151,
 828199932,
 -1,
 828387682,
 828279752,
 -1,
 -52895,
 828326884,
 43333,
 -1,
 828378673,
 43323,
 828584293,
 828322488,
 -1,
 -52892,
 828519146,
 43331,
 -1,
 828575281,
 43314,
 -52890,
 828514722,
 43332,
 -1,
 828706353,
 43317,
 828911978,
 828263971,
 -1,
 -52887,
 828839747,
 43330,
 -1,
 828902961,
 43320,
 -52885,
 828869642,
 43327,
 -52884,
 829065091,
 43328,
 -52883,
 829126481,
 43315,
 -52882,
 829189978,
 43324,
 -52881,
 829253629,
 43325,
 -52880,
 829317604,
 43318,
 -52879,
 829376411,
 43326,
 -52878,
 829441288,
 43312,
 -52877,
 829506532,
 43322,
 -52876,
 829568589,
 43329,
 -52875,
 829633258,
 43313,
 -52874,
 829694370,
 43316,
 -52873,
 829758127,
 43321,
 -52872,
 829822787,
 43319,
 -1,
 829886001,
 43334,
 830091653,
 828212142,
 -1,
 830157188,
 830038337,
 -1,
 830222718,
 830088907,
 43337,
 -52867,
 830176830,
 43341,
 -1,
 830213681,
 43342,
 830419329,
 830148145,
 -1,
 -52864,
 830373438,
 43340,
 -1,
 830421901,
 43338,
 -52862,
 830373438,
 43336,
 -52861,
 830560298,
 43339,
 -1,
 830618509,
 43335,
 -1,
 830095834,
 43347,
 830878090,
 830021375,
 -1,
 830943624,
 830821372,
 43344,
 -1,
 830878392,
 43343,
 -52855,
 830891935,
 43345,
 -1,
 831010359,
 43346,
 -1,
 830828534,
 43359,
 831271334,
 828126468,
 -1,
 -52851,
 831229425,
 127487,
 -52850,
 831294408,
 127486,
 -52849,
 831359750,
 127485,
 -52848,
 831424316,
 127484,
 -52847,
 831488942,
 127483,
 -52846,
 831553086,
 127482,
 -52845,
 831616767,
 127481,
 -52844,
 831680262,
 127480,
 -52843,
 831743903,
 127479,
 -52842,
 831809139,
 127478,
 -52841,
 831873445,
 127477,
 -52840,
 831936554,
 127476,
 -52839,
 832001020,
 127475,
 -52838,
 832065059,
 127474,
 -52837,
 832128877,
 127473,
 -52836,
 832193706,
 127472,
 -52835,
 832259014,
 127471,
 -52834,
 832322445,
 127470,
 -52833,
 832386615,
 127469,
 -52832,
 832451256,
 127468,
 -52831,
 832515921,
 127467,
 -52830,
 832579275,
 127466,
 -52829,
 832643398,
 127465,
 -52828,
 832707216,
 127464,
 -52827,
 832771854,
 127463,
 -1,
 832835121,
 127462,
 833040817,
 831226798,
 -1,
 833106352,
 832973873,
 -1,
 833171885,
 833028096,
 -1,
 833237420,
 833124993,
 -1,
 -52821,
 833186893,
 11079,
 -1,
 833243636,
 11073,
 -1,
 833188850,
 10184,
 833552383,
 833102152,
 -1,
 -52817,
 833447757,
 11822,
 -1,
 833499573,
 11793,
 -1,
 833051217,
 128158,
 833761718,
 832992705,
 -1,
 833827253,
 833698984,
 -1,
 -52812,
 833751971,
 9953,
 -1,
 833817363,
 9952,
 -1,
 833772573,
 128699,
 -52809,
 833702659,
 128524,
 -52808,
 834019659,
 127822,
 -1,
 834084788,
 128665,
 834286064,
 828079678,
 -1,
 834351596,
 834228661,
 -1,
 834417113,
 834295678,
 -1,
 834482628,
 834369279,
 -1,
 834548160,
 834438972,
 -1,
 -52801,
 834492463,
 69235,
 -1,
 834546470,
 69226,
 834744771,
 834483767,
 -1,
 -52798,
 834693654,
 69236,
 -1,
 834748942,
 69227,
 -1,
 834677299,
 69225,
 835006923,
 834432774,
 -1,
 835072456,
 834945903,
 -1,
 -52793,
 835026475,
 69230,
 -1,
 835060219,
 69239,
 835321855,
 835005855,
 -1,
 -52790,
 835223083,
 69231,
 -1,
 835256827,
 69240,
 835465682,
 834940753,
 -1,
 835531215,
 835409962,
 -1,
 -52786,
 835486371,
 69237,
 -1,
 835546757,
 69228,
 835780607,
 835468173,
 -1,
 -52783,
 835683472,
 69238,
 -1,
 835728031,
 69229,
 835924437,
 835409415,
 -1,
 -52780,
 835878443,
 69233,
 -1,
 835912187,
 69242,
 836121048,
 835856769,
 -1,
 -52777,
 836078536,
 69232,
 -1,
 836108795,
 69241,
 -1,
 836066074,
 69234,
 836383206,
 834347848,
 -1,
 836448733,
 836335359,
 -1,
 -52772,
 836405774,
 69217,
 -1,
 836450956,
 69218,
 836645344,
 836398854,
 -1,
 -52769,
 836584303,
 69221,
 -1,
 836644255,
 69222,
 836841955,
 836579153,
 -1,
 -52766,
 836787988,
 69219,
 -1,
 836846378,
 69220,
 -52764,
 836786942,
 69216,
 -52763,
 836982279,
 69224,
 -1,
 837036417,
 69223,
 837287935,
 836317760,
 -1,
 837300715,
 837180162,
 -1,
 -52759,
 837253504,
 69245,
 -52758,
 837314307,
 69244,
 -1,
 837367423,
 69243,
 -1,
 837254676,
 69246,
 837628399,
 834295409,
 -1,
 -52754,
 837566431,
 127933,
 -1,
 837626760,
 127939,
 -1,
 837563342,
 127945,
 837890584,
 834222989,
 -1,
 837956114,
 837825716,
 -1,
 838021633,
 837877760,
 -1,
 838087159,
 837971718,
 -1,
 -52747,
 838041513,
 11779,
 -52746,
 838089980,
 11815,
 -1,
 838142524,
 10182,
 838349306,
 838017997,
 -1,
 -52743,
 838303550,
 11817,
 -1,
 838368450,
 11781,
 838545917,
 838275886,
 -1,
 -52740,
 838497890,
 11776,
 -1,
 838542556,
 11777,
 -52738,
 838501691,
 11809,
 -52737,
 838695897,
 11786,
 -52736,
 838756470,
 11789,
 -1,
 838815008,
 11805,
 839004685,
 837978013,
 -1,
 839070220,
 838931674,
 -1,
 839135750,
 839027146,
 -1,
 -52731,
 839090813,
 11023,
 -1,
 839132630,
 11022,
 839332361,
 839088634,
 -1,
 -52728,
 839284347,
 11076,
 -1,
 839333324,
 11075,
 839581695,
 839257901,
 -1,
 -52725,
 839481970,
 11084,
 -1,
 839520769,
 11080,
 -1,
 839018168,
 11078,
 839843839,
 838928735,
 -1,
 839856656,
 839725038,
 4053,
 -1,
 839780409,
 4055,
 -52719,
 839804122,
 128270,
 -1,
 839923416,
 9957,
 840118804,
 837899673,
 128141,
 -1,
 840041875,
 11824,
 840249879,
 840047661,
 -1,
 -52714,
 840179598,
 127832,
 -1,
 840243041,
 127833,
 -1,
 840177625,
 127872,
 840512055,
 837834794,
 -1,
 840577584,
 840454024,
 -1,
 840643106,
 840527622,
 -1,
 840708641,
 840574667,
 -1,
 840774175,
 840666015,
 -1,
 -52706,
 840728638,
 65939,
 -1,
 840766292,
 65936,
 -52704,
 840725888,
 65944,
 -1,
 840913807,
 65938,
 -1,
 840646200,
 65941,
 841167400,
 840587162,
 -1,
 841232934,
 841101491,
 -1,
 -52699,
 841185715,
 8583,
 -1,
 841230310,
 8582,
 -52697,
 841183823,
 8581,
 -1,
 841374502,
 8584,
 841560620,
 841097542,
 -1,
 -52694,
 841515599,
 65945,
 -52693,
 841563782,
 65940,
 -1,
 841624182,
 65942,
 -52691,
 841515239,
 65937,
 -52690,
 841770874,
 65943,
 -52689,
 841817149,
 65947,
 -1,
 841880880,
 65946,
 -52687,
 840534052,
 128675,
 -52686,
 842039589,
 128205,
 -52685,
 842100704,
 127801,
 -52684,
 842161702,
 128019,
 -52683,
 842222614,
 127906,
 -52682,
 842276331,
 128640,
 -1,
 842339693,
 127840,
 842596351,
 840437297,
 -1,
 842609218,
 842480525,
 -1,
 842674751,
 842559504,
 -1,
 -52677,
 842626191,
 11787,
 -52676,
 842678467,
 11782,
 -52675,
 842741459,
 9995,
 -52674,
 842805529,
 9994,
 -1,
 842867865,
 11783,
 843067969,
 842617852,
 9926,
 -1,
 842996158,
 127752,
 -1,
 843009543,
 128643,
 843264580,
 842539879,
 128251,
 -1,
 843186375,
 128280,
 843395654,
 843192276,
 128007,
 -1,
 843317651,
 128048,
 -52665,
 843347711,
 128000,
 -1,
 843468323,
 128015,
 843657943,
 827997069,
 -1,
 843723433,
 843600892,
 -1,
 843788951,
 843673553,
 -1,
 843854451,
 843738717,
 -1,
 843919975,
 843795055,
 -1,
 843985490,
 843869958,
 -1,
 844051025,
 843910705,
 -1,
 -52656,
 843993376,
 68430,
 -1,
 844047042,
 68433,
 -1,
 843987193,
 68436,
 844313173,
 843937535,
 -1,
 -52652,
 844246208,
 68424,
 -1,
 844306134,
 68437,
 844509783,
 844248943,
 68420,
 -1,
 844462344,
 68423,
 844640858,
 844434993,
 -1,
 -52647,
 844598506,
 68431,
 -1,
 844646988,
 68416,
 -52645,
 844598827,
 68422,
 -52644,
 844795219,
 68425,
 -52643,
 844859360,
 68421,
 -52642,
 844917372,
 68435,
 -52641,
 844981932,
 68434,
 -52640,
 845046454,
 68432,
 -52639,
 845109169,
 68429,
 -52638,
 845173049,
 68428,
 -52637,
 845236287,
 68427,
 -52636,
 845301096,
 68426,
 -52635,
 845362430,
 68418,
 -52634,
 845423061,
 68419,
 -1,
 845486169,
 68417,
 845742079,
 843863934,
 -1,
 845754990,
 845641471,
 -1,
 845820524,
 845711164,
 -1,
 -52629,
 845764650,
 68441,
 -1,
 845818662,
 68445,
 -52627,
 845757068,
 68442,
 -1,
 845949491,
 68444,
 846148210,
 845699838,
 68440,
 846266367,
 846069760,
 -1,
 -52623,
 846166451,
 68447,
 -1,
 846216011,
 68446,
 -1,
 846082546,
 68443,
 846528511,
 843790683,
 -1,
 846541451,
 846416495,
 -1,
 846606970,
 846491398,
 -1,
 846672505,
 846532145,
 -1,
 -52616,
 846614816,
 68462,
 -1,
 846668482,
 68464,
 -1,
 846608633,
 68465,
 846934653,
 846558975,
 -1,
 -52612,
 846867648,
 68456,
 -1,
 846927574,
 68466,
 847131263,
 846870383,
 68452,
 -1,
 847083784,
 68455,
 -52608,
 847089195,
 68454,
 -52607,
 847220051,
 68457,
 -52606,
 847284235,
 68453,
 -52605,
 847340214,
 68463,
 -52604,
 847402929,
 68461,
 -52603,
 847466813,
 68460,
 -52602,
 847530047,
 68459,
 -52601,
 847594856,
 68458,
 -52600,
 847656190,
 68450,
 -52599,
 847716821,
 68451,
 -52598,
 847779929,
 68449,
 -1,
 847843772,
 68448,
 848101375,
 846485374,
 -1,
 848114322,
 848000767,
 -1,
 848179856,
 848070460,
 -1,
 -52593,
 848123946,
 68473,
 -1,
 848177958,
 68477,
 -52591,
 848116364,
 68474,
 -1,
 848308787,
 68476,
 848507542,
 848059134,
 68472,
 848625663,
 848429056,
 -1,
 -52587,
 848525747,
 68479,
 -1,
 848575307,
 68478,
 -1,
 848441842,
 68475,
 848835230,
 843736671,
 -1,
 848900764,
 848775290,
 -1,
 -52582,
 848851766,
 128289,
 -52581,
 848906943,
 128292,
 -1,
 848960371,
 128288,
 -52579,
 848852715,
 128291,
 -1,
 849106834,
 128290,
 849293988,
 848790446,
 -1,
 849359523,
 849226806,
 -1,
 -52575,
 849314097,
 8276,
 -52574,
 849371954,
 9959,
 -1,
 849428696,
 11800,
 -1,
 849297990,
 8292,
 -52571,
 849246383,
 9892,
 -52570,
 849621448,
 128129,
 -52569,
 849683232,
 8377,
 -52568,
 849747645,
 128232,
 -1,
 849811924,
 128229,
 850014931,
 843666239,
 128127,
 850132991,
 849947623,
 -1,
 850145990,
 850020975,
 -1,
 850211505,
 850095878,
 -1,
 850277040,
 850136625,
 -1,
 -52561,
 850219296,
 67662,
 -1,
 850272962,
 67665,
 -1,
 850213113,
 67668,
 850539188,
 850163455,
 -1,
 -52557,
 850472128,
 67656,
 -1,
 850532054,
 67669,
 850735798,
 850474863,
 67652,
 -1,
 850688264,
 67655,
 850866873,
 850660913,
 -1,
 -52552,
 850824426,
 67663,
 -1,
 850872908,
 67648,
 -52550,
 850824747,
 67654,
 -52549,
 851021139,
 67657,
 -52548,
 851085280,
 67653,
 -52547,
 851143292,
 67667,
 -52546,
 851207852,
 67666,
 -52545,
 851272374,
 67664,
 -52544,
 851335089,
 67661,
 -52543,
 851398969,
 67660,
 -52542,
 851462207,
 67659,
 -52541,
 851527016,
 67658,
 -52540,
 851588350,
 67650,
 -52539,
 851648981,
 67651,
 -1,
 851712089,
 67649,
 851915474,
 850089854,
 -1,
 851981006,
 851867391,
 -1,
 852046539,
 851937084,
 -1,
 -52534,
 851990570,
 67673,
 -1,
 852044582,
 67676,
 852243149,
 851978803,
 67675,
 -1,
 852166275,
 67679,
 -1,
 852179596,
 67674,
 852492287,
 851925758,
 67672,
 852557823,
 852361216,
 -1,
 -52527,
 852457907,
 67678,
 -1,
 852507467,
 67677,
 -1,
 851865603,
 67671,
 852767446,
 849943597,
 -1,
 -52523,
 852718228,
 9976,
 -1,
 852762518,
 127848,
 -1,
 852725261,
 127982,
 853029720,
 843596742,
 -1,
 853095254,
 852954673,
 -1,
 853160781,
 853050333,
 -1,
 853226258,
 853100821,
 -1,
 853291793,
 853179612,
 -1,
 853357284,
 853234684,
 -1,
 853422816,
 853291754,
 43412,
 853540863,
 853344947,
 43402,
 -1,
 853411277,
 43403,
 853619426,
 853380106,
 43418,
 -1,
 853541661,
 43416,
 853803007,
 853544497,
 43428,
 -1,
 853672733,
 43423,
 853881577,
 853309183,
 -1,
 853947111,
 853833553,
 43419,
 -1,
 853869295,
 43420,
 854130687,
 853872177,
 43424,
 -1,
 854000413,
 43425,
 854209262,
 853811526,
 -1,
 854274796,
 854139298,
 43421,
 -1,
 854196975,
 43422,
 854458367,
 854199857,
 43426,
 -1,
 854328047,
 43427,
 854536946,
 854159194,
 43441,
 854654975,
 854459100,
 -1,
 -52495,
 854557401,
 43439,
 -1,
 854593741,
 43440,
 854799094,
 854483428,
 43429,
 854917119,
 854720512,
 -1,
 -52491,
 854807470,
 43430,
 -1,
 854858854,
 43401,
 855061242,
 854738184,
 43407,
 855179263,
 854982656,
 -1,
 -52487,
 855076766,
 43408,
 -1,
 855135150,
 43409,
 855323389,
 854997901,
 43398,
 -52484,
 855260045,
 43399,
 -1,
 855310921,
 43397,
 855519999,
 855271421,
 43435,
 -1,
 855441439,
 43436,
 855651073,
 855458788,
 43415,
 -1,
 855573231,
 43417,
 855782147,
 855585514,
 43410,
 -1,
 855704349,
 43411,
 855913221,
 855710383,
 43413,
 -1,
 855835421,
 43414,
 856044295,
 855840579,
 43431,
 -1,
 855966493,
 43432,
 856175369,
 855969329,
 43396,
 -1,
 856112013,
 43405,
 -52470,
 856132618,
 43434,
 -52469,
 856262531,
 43438,
 -52468,
 856325694,
 43400,
 -52467,
 856381482,
 43406,
 -52466,
 856444533,
 43433,
 -52465,
 856508315,
 43437,
 -52464,
 856569421,
 43442,
 -1,
 856630987,
 43404,
 -1,
 853226114,
 43457,
 856896295,
 853172708,
 -1,
 856961828,
 856826277,
 -1,
 857027353,
 856901485,
 -1,
 857092888,
 856981054,
 -1,
 -52457,
 857036223,
 43465,
 -1,
 857095017,
 43461,
 -1,
 857030677,
 43464,
 857355037,
 856952369,
 -1,
 857420572,
 857285193,
 43466,
 -1,
 857341977,
 43467,
 -1,
 857363682,
 43459,
 857617184,
 857301413,
 -1,
 -52449,
 857555500,
 43468,
 -1,
 857608991,
 43463,
 -52447,
 857573692,
 43462,
 -52446,
 857766641,
 43486,
 -52445,
 857820834,
 43460,
 -1,
 857883187,
 43487,
 858128383,
 856905113,
 -1,
 -52442,
 858024175,
 43471,
 -1,
 858080999,
 43456,
 858272565,
 856826696,
 -1,
 858338091,
 858224383,
 -1,
 -52438,
 858294798,
 43474,
 -1,
 858339980,
 43475,
 858534702,
 858287878,
 -1,
 -52435,
 858473327,
 43478,
 -1,
 858533279,
 43479,
 858731313,
 858468177,
 -1,
 -52432,
 858677012,
 43476,
 -1,
 858735402,
 43477,
 -52430,
 858689112,
 43472,
 -52429,
 858872574,
 43473,
 -52428,
 858936839,
 43481,
 -1,
 858990977,
 43480,
 859190081,
 858228427,
 -1,
 859255611,
 859141887,
 -1,
 859321146,
 859180593,
 -1,
 -52423,
 859270850,
 43444,
 -1,
 859327344,
 43450,
 -1,
 859265611,
 43445,
 859583293,
 859212542,
 43446,
 -1,
 859505408,
 43447,
 859714367,
 859534966,
 43448,
 -1,
 859636487,
 43449,
 -52416,
 859661126,
 43452,
 -1,
 859775872,
 43451,
 859976519,
 859140533,
 -1,
 860042052,
 859905073,
 43393,
 -1,
 859965047,
 43443,
 -52411,
 859998516,
 43395,
 -52410,
 860119634,
 43392,
 -1,
 860178614,
 43394,
 860369739,
 859905791,
 -1,
 -52407,
 860316433,
 43454,
 -52406,
 860374544,
 43453,
 -1,
 860429010,
 43455,
 -52404,
 860323172,
 43469,
 -1,
 860580832,
 43458,
 860762965,
 853107266,
 -1,
 -52401,
 860714711,
 128304,
 -52400,
 860775727,
 127971,
 -52399,
 860838288,
 128121,
 -52398,
 860894528,
 128122,
 -52397,
 860955619,
 127886,
 -52396,
 861019052,
 127983,
 -1,
 861083511,
 9979,
 -1,
 860691923,
 127875,
 -52393,
 853049767,
 9909,
 -1,
 861284314,
 128086,
 861483959,
 852963153,
 -1,
 861549431,
 861408817,
 -1,
 861614961,
 861477520,
 -1,
 861680495,
 861546189,
 -1,
 861746026,
 861636964,
 -1,
 861811561,
 861667328,
 -1,
 861877089,
 861763141,
 -1,
 -52384,
 861833548,
 128540,
 -1,
 861895241,
 128541,
 862073700,
 861820970,
 -1,
 -52381,
 862020327,
 128560,
 -1,
 862078127,
 128582,
 -52379,
 862025766,
 128514,
 -52378,
 862213767,
 128581,
 -52377,
 862277884,
 128567,
 -52376,
 862342337,
 128548,
 -1,
 862396053,
 128531,
 -1,
 861757325,
 128566,
 862663533,
 861695750,
 -1,
 -52372,
 862592924,
 128561,
 -1,
 862656166,
 128523,
 -52370,
 862616077,
 128536,
 -1,
 862801958,
 128134,
 -52368,
 861633433,
 127981,
 -1,
 862941669,
 8507,
 863122292,
 861555677,
 -1,
 -52365,
 863059815,
 9950,
 -1,
 863119930,
 127810,
 -52363,
 863079184,
 128224,
 -52362,
 863271264,
 127877,
 -1,
 863326742,
 128106,
 863515530,
 861485965,
 -1,
 863581057,
 863463327,
 -1,
 863646590,
 863512267,
 128293,
 863712125,
 863603416,
 -1,
 -52356,
 863661830,
 127878,
 -1,
 863700519,
 127879,
 -1,
 863633789,
 128658,
 864026623,
 863597867,
 -1,
 -52352,
 863930745,
 127771,
 -1,
 863991496,
 127763,
 864170886,
 863530758,
 -1,
 864236421,
 864106039,
 128031,
 -52348,
 864174029,
 127907,
 -1,
 864223439,
 127845,
 -1,
 864188479,
 128074,
 864498569,
 864126088,
 -1,
 -52344,
 864445979,
 8281,
 -1,
 864505798,
 11821,
 -1,
 864438556,
 128193,
 864760728,
 863455085,
 -1,
 864826257,
 864704554,
 -1,
 864891792,
 864782417,
 9880,
 865009663,
 864814235,
 -1,
 -52337,
 864911614,
 8277,
 -1,
 864962761,
 127924,
 -1,
 864839050,
 128190,
 865219476,
 864757451,
 -1,
 -52333,
 865176426,
 128170,
 -1,
 865239726,
 9884,
 865416087,
 865144369,
 -1,
 -52330,
 865368854,
 9189,
 -1,
 865415873,
 9971,
 -1,
 865370922,
 128563,
 865678245,
 864704554,
 -1,
 865743776,
 865631806,
 -1,
 865809311,
 865691553,
 -1,
 865874846,
 865739761,
 -1,
 -52323,
 865822235,
 8280,
 -1,
 865882054,
 8283,
 -1,
 865814861,
 127808,
 -1,
 865752866,
 9970,
 866202531,
 865692993,
 -1,
 -52318,
 866134161,
 11792,
 -1,
 866189397,
 127860,
 -52316,
 866148012,
 128099,
 -1,
 866333815,
 127745,
 866530220,
 865631806,
 -1,
 866595753,
 866470880,
 -1,
 -52312,
 866552185,
 127773,
 -1,
 866612936,
 127765,
 -52310,
 866545632,
 9179,
 -52309,
 866735469,
 9905,
 -1,
 866789838,
 9981,
 866988978,
 866477983,
 -1,
 867054512,
 866932778,
 -1,
 -52305,
 866998024,
 128037,
 -1,
 867054266,
 128056,
 -52303,
 866991377,
 127844,
 -1,
 867183245,
 127839,
 867434495,
 866920139,
 -1,
 867447734,
 867331602,
 -1,
 -52299,
 867404744,
 9972,
 -1,
 867451423,
 127905,
 -1,
 867374158,
 128552,
 867709969,
 861439804,
 -1,
 867775464,
 867644983,
 -1,
 867840998,
 867713759,
 -1,
 867906496,
 867770694,
 -1,
 867972030,
 867854629,
 -1,
 -52291,
 867913604,
 9920,
 -1,
 867976840,
 9921,
 -52289,
 867918173,
 128071,
 -1,
 868105217,
 9931,
 868299717,
 867858175,
 -1,
 868365252,
 868247455,
 -1,
 -52285,
 868301860,
 10177,
 -1,
 868357029,
 9186,
 -1,
 868321922,
 9943,
 868627402,
 868249350,
 -1,
 868692937,
 868568862,
 -1,
 -52280,
 868644184,
 11090,
 -1,
 868699500,
 11051,
 -1,
 868640495,
 128307,
 868955086,
 868569353,
 -1,
 -52276,
 868906328,
 11088,
 -52275,
 868961644,
 11048,
 -1,
 869016329,
 11046,
 869217235,
 868894573,
 -1,
 869282770,
 869148979,
 -1,
 -52271,
 869229742,
 128072,
 -1,
 869288006,
 9945,
 -1,
 869209195,
 11036,
 869544920,
 869152311,
 -1,
 869610455,
 869476043,
 -1,
 -52266,
 869567316,
 11041,
 -1,
 869603015,
 9989,
 -1,
 869555593,
 11053,
 869872604,
 869478704,
 -1,
 869938139,
 869798016,
 9872,
 -1,
 869861527,
 9983,
 -1,
 869884236,
 128174,
 870134751,
 869827816,
 -1,
 -52258,
 870091759,
 11038,
 -1,
 870152751,
 11055,
 870331362,
 870083481,
 -1,
 -52255,
 870255145,
 11092,
 -1,
 870319514,
 128073,
 -52253,
 870285803,
 128070,
 -52252,
 870475611,
 10068,
 -52251,
 870540073,
 11040,
 -1,
 870592118,
 10069,
 -52249,
 867772643,
 9855,
 -1,
 870715809,
 128011,
 870921209,
 867700273,
 -1,
 870986735,
 870873259,
 -1,
 871052270,
 870907904,
 -1,
 -52244,
 871008202,
 127754,
 -52243,
 871046729,
 128702,
 -1,
 871111216,
 128003,
 -1,
 870994227,
 127817,
 871379954,
 870943633,
 -1,
 -52239,
 871314661,
 127764,
 -1,
 871374804,
 127762,
 871576565,
 871334830,
 -1,
 -52236,
 871514004,
 128075,
 -1,
 871573208,
 11071,
 871773176,
 871519776,
 -1,
 -52233,
 871707877,
 127766,
 -1,
 871768020,
 127768,
 -1,
 871722349,
 9888,
 872035333,
 870864938,
 -1,
 872100867,
 871976483,
 -1,
 872166402,
 872026727,
 128105,
 872231937,
 872115976,
 -1,
 -52226,
 872181644,
 128097,
 -52225,
 872232795,
 128082,
 -52224,
 872291956,
 128090,
 -1,
 872356242,
 128098,
 -1,
 872155013,
 128111,
 -1,
 872098537,
 128698,
 -52220,
 872048967,
 11825,
 -1,
 872630992,
 128058,
 872821769,
 871972512,
 -1,
 -52217,
 872760973,
 128521,
 -52216,
 872818461,
 127863,
 -1,
 872882515,
 127888,
 873083918,
 872752843,
 -1,
 873149453,
 873010439,
 -1,
 -52212,
 873082801,
 128553,
 -1,
 873143219,
 128576,
 -1,
 873079332,
 128146,
 873463807,
 873031583,
 -1,
 -52208,
 873343624,
 128295,
 -1,
 873403340,
 127873,
 873608265,
 867663422,
 -1,
 873673787,
 873542516,
 -1,
 873739322,
 873613935,
 -1,
 873804826,
 873688838,
 -1,
 873870360,
 873729585,
 -1,
 -52201,
 873812592,
 66450,
 -1,
 873865770,
 66453,
 -52199,
 873821787,
 66461,
 -1,
 874002681,
 66444,
 874198046,
 873756415,
 -1,
 -52196,
 874141738,
 66458,
 -52195,
 874198804,
 66456,
 -1,
 874261664,
 66441,
 874460193,
 874155505,
 -1,
 -52192,
 874413630,
 66449,
 -1,
 874458288,
 66439,
 874656804,
 874398890,
 -1,
 -52189,
 874591821,
 66435,
 -1,
 874647625,
 66443,
 874853414,
 874592642,
 66437,
 -1,
 874805073,
 66440,
 874984489,
 874787512,
 -1,
 -52184,
 874919542,
 66457,
 -1,
 874975818,
 66434,
 875181100,
 874914118,
 -1,
 -52181,
 875116155,
 66447,
 -1,
 875178498,
 66436,
 875377711,
 875105841,
 -1,
 -52178,
 875318644,
 66432,
 -1,
 875380384,
 66451,
 -52176,
 875334991,
 66442,
 -52175,
 875530766,
 66438,
 -52174,
 875593278,
 66460,
 -52173,
 875653375,
 66455,
 -52172,
 875718311,
 66454,
 -52171,
 875783704,
 66452,
 -52170,
 875845553,
 66448,
 -52169,
 875909433,
 66446,
 -52168,
 875972665,
 66445,
 -52167,
 876034957,
 66459,
 -1,
 876091469,
 66433,
 -1,
 873695932,
 66463,
 876360771,
 873619877,
 -1,
 876426303,
 876316573,
 -1,
 -52162,
 876353786,
 11014,
 -1,
 876417660,
 11797,
 876622914,
 876349956,
 -1,
 -52159,
 876573508,
 128316,
 -1,
 876636661,
 128314,
 -1,
 876544353,
 11021,
 876885062,
 876303356,
 -1,
 -52155,
 876826609,
 9903,
 -1,
 876876379,
 128530,
 877133823,
 876826779,
 -1,
 -52152,
 877037967,
 9748,
 -1,
 877091490,
 9969,
 877278284,
 873565128,
 -1,
 -52149,
 877214634,
 983048,
 -1,
 877275618,
 128155,
 -1,
 877225865,
 9915]
_charnames_564 = [
5529,
5559,
5390,
5541,
5543,
5604,
5694,
5791,
5615,
5761,
5688,
5431,
5595,
5797,
5609,
5817,
5737,
5680,
5671,
5410,
5814,
5626,
5743,
5602,
5723,
5480,
5804,
5623,
]

_charnames_751 = [
9039,
9043,
9033,
9042,
9041,
9070,
9068,
9069,
9044,
9081,
9093,
9064,
9092,
9063,
8988,
9095,
9032,
]

_charnames_848 = [
1379,
1368,
1421,
1418,
1365,
1380,
1377,
1382,
1333,
1403,
1326,
1411,
1325,
1324,
1322,
1323,
]

_charnames_880 = [
10262,
10243,
10263,
10244,
-1,
-1,
10261,
10242,
-1,
-1,
-1,
10246,
10248,
10247,
]

_charnames_1015 = [
10259,
10240,
10264,
10260,
10241,
10302,
10266,
10269,
10267,
]

_charnames_1270 = [
1777,
1704,
-1,
-1,
1776,
1703,
1758,
1682,
1757,
1681,
]

_charnames_1296 = [
1740,
1664,
1763,
1687,
1785,
1711,
1744,
1668,
1754,
1678,
1782,
1709,
1781,
1708,
1786,
1712,
1762,
1686,
1764,
1688,
1783,
1697,
1737,
1661,
]

_charnames_1536 = [
9889,
9857,
9883,
9859,
-1,
-1,
9898,
9897,
9881,
9896,
9895,
10077,
-1,
9892,
9888,
9864,
9858,
9865,
9861,
9862,
9863,
9869,
9870,
9868,
9872,
9873,
9871,
-1,
-1,
-1,
9887,
-1,
9761,
]

_charnames_1622 = [
9874,
9891,
9890,
9885,
9876,
9877,
9878,
9880,
9884,
9886,
]

_charnames_1869 = [
8779,
8780,
8781,
9780,
9784,
9778,
9779,
9781,
9783,
9782,
9771,
9772,
9816,
9815,
9793,
9789,
9802,
9803,
9801,
9749,
9750,
9759,
9757,
9755,
9825,
9824,
9811,
9810,
9809,
9826,
9795,
9797,
9786,
9769,
9767,
9787,
9794,
9768,
9805,
9806,
9741,
9742,
9743,
9821,
9822,
9818,
9819,
9773,
9790,
9788,
9762,
]

_charnames_1984 = [
12302,
12303,
12294,
12295,
12300,
12301,
12297,
12298,
12305,
12304,
12289,
12271,
12283,
12270,
12276,
12269,
12268,
12273,
12254,
12288,
12279,
12277,
12264,
12287,
12272,
12267,
12266,
12278,
12285,
12286,
12282,
12281,
12258,
12280,
12255,
12257,
12284,
12275,
12274,
12256,
12262,
12263,
12261,
12316,
12315,
12314,
12312,
12311,
12310,
12309,
12317,
12318,
12323,
12290,
12321,
12322,
12319,
12324,
12291,
-1,
-1,
-1,
-1,
-1,
8358,
8345,
8355,
8357,
8338,
8346,
8347,
8339,
8335,
8348,
8354,
8353,
8352,
8351,
8342,
8340,
8356,
8334,
8350,
8349,
8343,
8336,
8398,
8399,
8400,
8403,
8407,
8402,
8365,
8376,
8368,
8362,
8373,
8367,
8361,
8372,
8405,
8371,
8363,
8374,
8406,
8364,
8375,
8366,
8370,
8401,
-1,
-1,
8393,
8384,
8381,
8395,
8382,
8390,
8408,
8394,
8386,
8392,
8387,
8391,
8383,
8389,
8380,
-1,
9229,
9223,
9221,
9222,
9220,
9227,
9212,
9225,
9209,
9211,
9210,
9218,
9217,
9216,
9205,
9226,
9215,
9206,
9214,
9213,
9207,
9208,
9230,
9228,
9219,
9234,
9231,
9233,
-1,
-1,
9232,
]

_charnames_2382 = [
12553,
12555,
-1,
-1,
-1,
-1,
-1,
12554,
12549,
12548,
]

_charnames_2417 = [
12544,
12531,
12522,
12521,
12533,
12519,
12518,
-1,
12526,
12529,
12525,
12528,
12524,
12530,
12532,
]

_charnames_2555 = [
5340,
-1,
-1,
-1,
-1,
-1,
10520,
-1,
10518,
]

_charnames_2929 = [
11669,
11658,
11659,
11663,
11657,
11660,
11662,
]

_charnames_3059 = [
6890,
6895,
6891,
6889,
6886,
6897,
6892,
6894,
]

_charnames_3192 = [
7339,
7337,
7331,
7334,
7338,
7332,
7335,
7343,
]

_charnames_3386 = [
9251,
-1,
-1,
9268,
-1,
-1,
-1,
-1,
-1,
-1,
9257,
]

_charnames_3440 = [
9262,
9261,
9260,
9265,
9266,
9267,
-1,
-1,
-1,
9269,
9246,
9245,
9249,
9247,
9248,
9250,
]

_charnames_4046 = [
7442,
-1,
7428,
7432,
7431,
7434,
7435,
12814,
6463,
12815,
6464,
7433,
7430,
]

_charnames_4130 = [
9340,
-1,
-1,
-1,
-1,
-1,
9348,
-1,
-1,
9430,
]

_charnames_4147 = [
9427,
9426,
9432,
-1,
-1,
-1,
-1,
9387,
9436,
9438,
9437,
9439,
9357,
]

_charnames_4186 = [
9346,
9347,
9345,
9344,
9441,
9442,
9443,
9341,
9417,
9447,
9446,
9354,
9355,
9424,
9423,
9381,
9380,
9379,
9378,
9377,
9351,
9350,
9352,
9431,
9420,
9419,
9421,
9330,
9329,
9335,
9338,
9331,
9326,
9337,
9327,
9333,
9336,
9339,
9332,
9334,
9444,
9416,
9413,
9414,
9415,
9370,
9369,
9368,
9367,
9374,
9373,
9375,
9356,
9385,
9398,
9399,
9390,
9391,
9396,
9397,
9393,
9394,
9401,
9400,
9384,
9383,
9428,
9429,
9408,
9409,
]

_charnames_4992 = [
3717,
3798,
3797,
3796,
3719,
3734,
3733,
3732,
3718,
3803,
3802,
3801,
3716,
3791,
3790,
3789,
3822,
3816,
3824,
3823,
3818,
3821,
3826,
3825,
3817,
3820,
]

_charnames_5751 = [
2045,
2041,
2042,
2039,
2040,
2043,
2044,
2046,
2114,
]

_charnames_6128 = [
10988,
10989,
10984,
10987,
10986,
10977,
10983,
10982,
10981,
10980,
]

_charnames_6314 = [
9110,
-1,
-1,
-1,
-1,
-1,
2035,
2125,
2126,
2052,
2108,
2109,
2107,
2077,
2120,
2119,
2127,
2094,
2095,
2128,
2065,
2054,
2063,
2064,
2062,
2116,
2117,
2086,
2092,
2026,
2093,
2027,
2090,
2024,
2091,
2025,
2084,
2082,
2083,
2080,
2081,
2085,
2031,
2030,
2033,
2034,
2032,
2022,
2028,
2029,
2130,
2051,
2122,
2123,
2087,
2049,
2050,
2075,
2076,
2068,
2069,
2070,
2072,
2073,
2057,
2058,
2060,
2099,
2104,
2101,
2100,
2059,
2105,
2113,
2112,
2103,
]

_charnames_6400 = [
6222,
6169,
6168,
6175,
6174,
6165,
6181,
6180,
6172,
6171,
6157,
6160,
6159,
6178,
6177,
6166,
6163,
6162,
6184,
6183,
6187,
6156,
6186,
6188,
6185,
6154,
6153,
6155,
6189,
-1,
-1,
-1,
6213,
6221,
6220,
6219,
6215,
6217,
6214,
6218,
6216,
6208,
6210,
6209,
-1,
-1,
-1,
-1,
6200,
6193,
6201,
6195,
6194,
6197,
6198,
6196,
6199,
6204,
6206,
6203,
-1,
-1,
-1,
-1,
6205,
-1,
-1,
-1,
6238,
6237,
6233,
6234,
6225,
6226,
6231,
6232,
6228,
6229,
6236,
6235,
7192,
7194,
7188,
7171,
7196,
7193,
7173,
7172,
7199,
7184,
7183,
7198,
7202,
7195,
7201,
7197,
7191,
7170,
7189,
7177,
7200,
7176,
7175,
7180,
7186,
7185,
7181,
7174,
7178,
7179,
-1,
-1,
7168,
7167,
7166,
7165,
7164,
]

_charnames_6528 = [
12123,
12094,
12120,
12108,
12116,
12091,
12079,
12087,
12103,
12111,
12121,
12074,
12082,
12092,
12105,
12104,
12117,
12076,
12075,
12088,
12114,
12113,
12124,
12085,
12084,
12095,
12127,
12122,
12125,
12098,
12093,
12096,
12126,
12128,
12129,
12097,
12099,
12100,
12119,
12107,
12090,
12078,
12110,
12081,
-1,
-1,
-1,
-1,
12156,
12149,
12155,
12139,
12143,
12157,
12152,
12144,
12145,
12140,
12151,
12150,
12142,
12147,
12146,
12141,
12154,
12133,
12132,
12131,
12134,
12135,
12136,
12137,
12175,
12174,
-1,
-1,
-1,
-1,
-1,
-1,
12168,
12169,
12160,
12161,
12166,
12167,
12163,
12164,
12171,
12170,
12176,
-1,
-1,
-1,
12177,
12178,
10952,
10999,
10951,
10996,
10993,
10948,
10945,
10942,
10939,
10936,
10974,
10971,
10961,
10968,
10965,
10958,
11000,
10998,
10950,
10995,
10992,
10947,
10944,
10941,
10938,
10935,
10973,
10970,
10960,
10967,
10964,
10957,
5239,
5242,
5226,
5225,
5237,
5245,
5231,
5230,
5234,
5243,
5228,
5227,
5244,
5240,
5223,
5222,
5232,
5236,
5238,
5233,
5235,
5246,
5241,
5250,
5248,
5251,
5249,
5252,
-1,
-1,
5253,
5254,
6933,
6932,
6931,
6906,
6904,
6905,
6954,
6942,
6941,
6915,
6917,
6914,
6953,
6949,
6944,
6965,
6918,
6950,
6936,
6935,
6909,
6908,
6955,
6966,
6939,
6938,
6946,
6912,
6920,
6911,
6962,
6916,
6943,
6948,
6951,
6921,
6923,
6960,
6928,
6927,
6929,
6945,
6924,
6967,
6919,
6958,
6959,
6956,
6957,
6964,
6961,
6922,
6963,
7056,
7057,
7061,
6986,
7064,
7060,
7063,
7058,
7065,
7062,
-1,
6983,
7013,
7022,
7016,
7019,
7020,
7021,
7012,
7011,
7009,
7010,
7003,
7005,
7007,
7023,
7015,
7008,
7014,
7018,
7006,
6985,
6993,
6992,
6974,
6973,
6972,
6996,
6988,
6975,
-1,
-1,
7066,
7048,
7049,
7040,
7041,
7046,
7047,
7043,
7044,
7051,
7050,
-1,
-1,
-1,
-1,
-1,
-1,
7034,
7035,
7026,
7027,
7032,
7033,
7029,
7030,
7037,
7036,
-1,
-1,
-1,
-1,
-1,
-1,
6989,
6990,
6982,
6978,
6998,
7000,
6995,
6987,
6976,
6977,
6980,
6981,
6999,
7001,
]

_charnames_6912 = [
4943,
4944,
4947,
4945,
4948,
4829,
4830,
4851,
4852,
4843,
4844,
4838,
4839,
4841,
4842,
4856,
4832,
4847,
4848,
4818,
4820,
4853,
4854,
4816,
4858,
4859,
4849,
4850,
4815,
4810,
4809,
4826,
4825,
4814,
4806,
4808,
4822,
4827,
4813,
4845,
4846,
4860,
4861,
4866,
4863,
4837,
4840,
4864,
4836,
4835,
4833,
4867,
4946,
4916,
4917,
4918,
4919,
4920,
4921,
4922,
4925,
4926,
4911,
4913,
4915,
4914,
4923,
4924,
4960,
4819,
4821,
4811,
4857,
4865,
4862,
4831,
-1,
-1,
-1,
-1,
4937,
4938,
4929,
4930,
4935,
4936,
4932,
4933,
4940,
4939,
4953,
4952,
4959,
4957,
4958,
4956,
4951,
4881,
4879,
4880,
4871,
4873,
4882,
4876,
4878,
4875,
4874,
4889,
4892,
4885,
4887,
4890,
4886,
4888,
4893,
4891,
4904,
4905,
4907,
4908,
4898,
4896,
4901,
4900,
4897,
-1,
-1,
-1,
8621,
8620,
8619,
8571,
8587,
8578,
8572,
8583,
8569,
8570,
8568,
8581,
8589,
8561,
8592,
8586,
8573,
8560,
8579,
8591,
8562,
8582,
8590,
8577,
8593,
8584,
8574,
8580,
8585,
8576,
8565,
8575,
8588,
8627,
8626,
8625,
8612,
8610,
8614,
8611,
8615,
8613,
8622,
-1,
-1,
-1,
8567,
8564,
8604,
8605,
8596,
8597,
8602,
8603,
8599,
8600,
8607,
8606,
-1,
-1,
-1,
-1,
-1,
-1,
5007,
4976,
5002,
4974,
4990,
5006,
4999,
4992,
4971,
4984,
4989,
4995,
4968,
4993,
5003,
4975,
5000,
5004,
4997,
4970,
4986,
4972,
4977,
4981,
4978,
4969,
4988,
4994,
4967,
4982,
4998,
4973,
4980,
5005,
4983,
4991,
5001,
4996,
5026,
5014,
5016,
5015,
5018,
5013,
5017,
5012,
5009,
5010,
5031,
5032,
5029,
5028,
]

_charnames_7164 = [
5024,
5022,
5025,
5023,
6330,
6328,
6329,
6346,
6345,
6325,
6352,
6351,
6361,
6324,
6318,
6317,
6334,
6326,
6322,
6320,
6321,
6349,
6348,
6355,
6354,
6340,
6339,
6316,
6315,
6332,
6356,
6359,
6360,
6343,
6342,
6358,
6337,
6336,
6357,
6362,
6404,
6405,
6394,
6392,
6390,
6391,
6388,
6389,
6393,
6380,
6385,
6386,
6378,
6384,
6383,
6382,
6379,
6381,
6407,
6408,
-1,
-1,
-1,
6399,
6400,
6401,
6398,
6397,
6373,
6374,
6365,
6366,
6371,
6372,
6368,
6369,
6376,
6375,
-1,
-1,
-1,
6313,
6312,
6333,
11589,
11590,
11581,
11582,
11587,
11588,
11584,
11585,
11592,
11591,
11553,
11548,
11551,
11549,
11550,
11554,
11546,
11547,
11545,
11544,
11557,
11570,
11573,
11572,
11571,
11555,
11563,
11562,
11561,
11560,
11558,
11576,
11578,
11577,
11575,
11556,
11566,
11568,
11565,
11567,
11600,
11602,
11599,
11601,
11597,
11603,
11595,
11596,
]

_charnames_7376 = [
8188,
8192,
8194,
8173,
8171,
8181,
8180,
8178,
8195,
8179,
8190,
8184,
8187,
8191,
8183,
8185,
8193,
8196,
8165,
8161,
8168,
8163,
8169,
8162,
8164,
8158,
8157,
8154,
8155,
8172,
8175,
8174,
8170,
8156,
8159,
]

_charnames_7424 = [
5837,
5838,
5381,
5852,
5851,
5850,
5836,
5834,
5372,
5374,
5848,
5847,
5846,
5845,
5829,
5831,
5833,
5423,
5424,
5425,
5373,
5832,
5393,
5621,
5844,
5828,
5823,
5821,
5842,
5426,
5428,
5427,
5841,
5840,
5839,
5835,
5853,
5854,
10286,
10285,
10283,
10284,
10282,
1788,
8999,
9000,
8997,
8998,
9015,
9014,
8994,
9013,
9012,
9011,
9010,
9009,
9008,
9007,
9006,
8993,
8995,
8996,
9005,
8991,
9004,
9003,
9001,
8961,
8907,
8962,
8909,
8939,
8958,
8928,
8936,
8953,
8913,
8954,
8914,
8980,
8971,
8932,
8950,
8952,
8916,
8940,
8966,
8905,
8947,
8937,
8910,
8964,
8963,
8941,
8957,
8960,
8956,
8926,
5651,
5643,
5641,
5640,
10254,
10252,
10250,
10251,
10253,
5521,
5619,
5537,
5630,
5574,
5557,
5568,
5483,
5484,
5434,
5388,
5597,
5380,
9027,
5455,
5386,
5635,
5459,
5564,
5634,
5519,
5618,
5536,
5629,
5607,
5585,
5526,
5573,
5555,
5567,
5481,
5432,
5415,
5547,
5631,
5596,
5466,
5473,
5538,
5411,
5507,
5489,
5436,
5449,
5504,
5414,
5518,
5419,
8908,
8919,
8927,
8930,
8979,
8982,
8959,
8935,
8915,
8978,
8977,
8921,
8922,
8981,
8974,
8975,
8925,
8972,
8911,
8970,
8969,
8924,
8942,
8967,
8938,
8931,
8918,
8949,
8948,
8923,
8965,
8912,
8943,
8945,
8946,
8929,
8917,
1331,
1332,
1417,
1416,
1388,
1399,
1386,
1406,
1400,
1407,
1343,
1422,
1387,
1328,
1419,
1410,
1420,
1414,
1413,
1352,
1340,
1339,
1338,
1354,
1350,
1353,
1351,
1360,
1349,
1344,
1359,
1358,
1348,
1357,
1356,
1342,
1347,
1345,
1346,
]

_charnames_8275 = [
8895,
12960,
13198,
7517,
-1,
13212,
13191,
7529,
13213,
12501,
7502,
8203,
-1,
-1,
-1,
-1,
-1,
12963,
]

_charnames_8336 = [
5654,
5653,
5645,
5639,
5638,
5652,
5649,
5648,
5647,
5646,
5644,
5637,
5642,
]

_charnames_8370 = [
10523,
10065,
12065,
2449,
6304,
8825,
7355,
12966,
]

_charnames_8524 = [
10857,
10076,
7538,
8787,
8217,
8218,
8216,
]

_charnames_9167 = [
3863,
8202,
9535,
9532,
9533,
9531,
9526,
9527,
9528,
9529,
9534,
3839,
13225,
7481,
5316,
7484,
5318,
7479,
5314,
13251,
5341,
8844,
13205,
10078,
3849,
12567,
5278,
5271,
5301,
5291,
5279,
5272,
5280,
9731,
8850,
7458,
12033,
]

_charnames_9866 = [
9102,
9101,
12602,
12595,
12596,
12601,
13273,
5304,
11875,
10060,
2432,
8841,
8888,
9730,
13196,
10504,
8840,
10068,
13203,
11696,
7513,
7514,
13304,
12057,
12490,
12489,
12964,
9274,
9272,
9273,
8201,
12027,
9538,
9540,
9539,
9292,
12618,
13380,
1633,
13226,
12249,
2448,
10827,
13142,
8205,
2321,
5286,
8866,
8868,
13388,
8867,
8861,
5052,
8517,
13244,
13245,
5289,
5290,
8879,
8632,
12863,
5268,
7523,
7537,
7539,
13247,
2435,
12614,
11686,
10917,
2187,
12016,
2421,
2312,
12349,
9728,
5296,
13252,
5273,
13265,
12626,
11992,
6461,
8511,
13170,
5297,
12724,
12723,
10071,
11981,
10859,
12817,
6466,
12961,
5305,
8713,
2324,
2193,
12059,
10506,
10507,
9291,
9113,
13384,
13215,
13206,
13236,
8412,
8553,
8891,
13012,
10846,
7353,
13140,
12005,
13227,
1238,
13274,
-1,
-1,
-1,
-1,
-1,
13270,
-1,
-1,
-1,
-1,
12861,
12860,
]

_charnames_10060 = [
2436,
-1,
12216,
-1,
-1,
-1,
-1,
5302,
13283,
13285,
-1,
11996,
]

_charnames_10175 = [
12493,
7518,
13250,
10854,
11677,
11676,
6444,
12790,
11672,
12716,
8639,
8204,
-1,
6537,
-1,
8506,
8505,
]

_charnames_11008 = [
12346,
12343,
8857,
8854,
6447,
6439,
13373,
12504,
12347,
12344,
8858,
8855,
6448,
13378,
12805,
12804,
6416,
6415,
8535,
8537,
8534,
8536,
12607,
12606,
12605,
12608,
12498,
5275,
13266,
5293,
13277,
5303,
13284,
13269,
5300,
12028,
5276,
5285,
13261,
5284,
13260,
5266,
5265,
13256,
5299,
13271,
5294,
13278,
6457,
7515,
6458,
6536,
6434,
6435,
6436,
6437,
6420,
6418,
6419,
6430,
6432,
6433,
6426,
13300,
3862,
12715,
6424,
12808,
12807,
6438,
12812,
12714,
12811,
7453,
6425,
6423,
12810,
-1,
-1,
-1,
13259,
5264,
13255,
5281,
13280,
11988,
11994,
11982,
11979,
11983,
]

_charnames_11264 = [
10444,
10433,
10435,
10442,
10415,
10397,
10418,
10414,
10419,
10404,
10408,
10401,
10416,
10440,
10427,
10439,
10438,
10425,
10421,
10437,
10391,
10410,
10436,
10430,
10441,
10424,
10422,
10385,
10411,
10443,
10387,
10395,
10396,
10400,
10390,
10398,
10388,
10389,
10399,
10406,
10434,
10407,
10431,
10403,
10386,
10412,
10428,
-1,
10381,
10370,
10372,
10379,
10352,
10334,
10355,
10351,
10356,
10341,
10345,
10338,
10353,
10377,
10364,
10376,
10375,
10362,
10358,
10374,
10328,
10347,
10373,
10367,
10378,
10361,
10359,
10322,
10348,
10380,
10324,
10332,
10333,
10337,
10327,
10335,
10325,
10326,
10336,
10343,
10371,
10344,
10368,
10340,
10323,
10349,
10365,
-1,
5760,
5528,
5758,
5776,
5722,
5465,
5389,
5795,
5593,
5767,
5584,
5802,
5598,
5701,
5786,
5678,
5679,
5546,
5818,
5632,
5549,
5794,
5592,
5394,
5412,
5378,
5499,
5825,
5650,
9002,
5741,
5801,
1561,
1481,
1564,
1484,
1571,
1491,
1535,
1455,
1573,
1493,
1544,
1464,
1563,
1483,
1570,
1490,
1552,
1472,
1569,
1489,
1550,
1470,
1558,
1478,
1568,
1488,
1567,
1487,
1548,
1468,
1506,
1426,
1556,
1476,
1566,
1486,
1545,
1465,
1553,
1473,
1565,
1485,
1572,
1492,
1549,
1469,
1555,
1475,
1528,
1448,
1534,
1454,
1521,
1441,
1541,
1461,
1532,
1452,
1531,
1451,
1539,
1459,
1517,
1437,
1546,
1466,
1542,
1462,
1516,
1436,
1519,
1439,
1562,
1482,
1533,
1453,
1512,
1432,
1510,
1430,
1559,
1479,
1513,
1433,
1511,
1431,
1518,
1438,
1520,
1440,
1515,
1435,
1527,
1447,
1525,
1445,
1524,
1444,
1526,
1446,
1500,
1503,
1502,
1496,
1501,
1499,
1497,
1538,
1458,
1540,
1460,
1578,
1577,
1576,
]

_charnames_11513 = [
1582,
1583,
1581,
1580,
1586,
1585,
1587,
10499,
10498,
10484,
10497,
10496,
10487,
10466,
10469,
10495,
10478,
10494,
10493,
10492,
10491,
10475,
10465,
10489,
10472,
10468,
10488,
10474,
10477,
10483,
10490,
10471,
10460,
10463,
10480,
10462,
10461,
10485,
10481,
10454,
10457,
10456,
10486,
10453,
10455,
]

_charnames_11568 = [
7363,
7387,
7388,
7380,
7382,
7417,
7397,
7364,
7367,
7365,
7366,
7403,
7398,
7377,
7406,
7379,
7385,
7418,
7414,
7386,
7400,
7378,
7407,
7392,
7412,
7402,
7370,
7421,
7411,
7396,
7395,
7394,
7409,
7413,
7393,
7401,
7383,
7384,
7381,
7410,
7420,
7374,
7375,
7376,
7371,
7373,
7399,
7372,
7391,
7390,
7389,
7368,
7415,
7369,
]

_charnames_11647 = [
7424,
3810,
3799,
3809,
3720,
3721,
3735,
3745,
3669,
3806,
3805,
3687,
3756,
3705,
3697,
3811,
3746,
3670,
3793,
3792,
3683,
3685,
3682,
3681,
]

_charnames_11680 = [
3710,
3712,
3714,
3711,
3709,
3708,
3713,
-1,
3664,
3666,
3668,
3665,
3663,
3662,
3667,
-1,
3751,
3753,
3755,
3752,
3750,
3749,
3754,
-1,
3657,
3659,
3661,
3658,
3656,
3655,
3660,
-1,
3771,
3773,
3775,
3772,
3770,
3769,
3774,
-1,
3781,
3783,
3785,
3782,
3780,
3779,
3784,
-1,
3761,
3763,
3765,
3762,
3760,
3759,
3764,
-1,
3675,
3677,
3679,
3676,
3674,
3673,
3678,
-1,
1273,
1274,
1281,
1270,
1257,
1258,
1279,
1250,
1249,
1248,
1276,
1275,
1247,
1245,
1264,
1280,
1263,
1283,
1267,
1266,
1282,
1246,
1284,
1255,
1269,
1277,
1261,
1260,
1254,
1278,
1272,
1253,
12795,
12796,
6442,
12788,
6455,
12793,
12859,
12862,
12497,
6460,
12798,
12858,
6449,
12799,
3864,
10822,
13217,
12719,
12062,
12500,
12505,
13374,
12499,
12492,
12962,
10826,
12063,
7452,
6452,
12800,
7451,
7450,
6459,
12797,
7482,
7480,
5317,
5315,
6443,
12789,
6454,
12792,
7528,
11693,
8523,
13192,
12718,
8200,
12819,
13315,
]

_charnames_12728 = [
5323,
5321,
5320,
-1,
-1,
-1,
-1,
-1,
2009,
2012,
2011,
2016,
1999,
1983,
1990,
1991,
1988,
1998,
1989,
1986,
1992,
1987,
1984,
2014,
1981,
1995,
2005,
2003,
2015,
1982,
1994,
1996,
2000,
2002,
2004,
2008,
2006,
2010,
1997,
2001,
1993,
1985,
2007,
2013,
]

_charnames_12868 = [
2413,
2408,
2412,
2407,
2396,
2394,
2395,
2401,
2402,
2398,
2399,
2403,
10821,
]

_charnames_19904 = [
11886,
11897,
11911,
11973,
11966,
11954,
11892,
11975,
11927,
11903,
11945,
11929,
11972,
11920,
11969,
11976,
11971,
11965,
11961,
11953,
11958,
11923,
11930,
11939,
11933,
11922,
11968,
11921,
11893,
11887,
11935,
11912,
11940,
11919,
11944,
11913,
11902,
11949,
11950,
11907,
11908,
11936,
11957,
11955,
11924,
11943,
11948,
11895,
11941,
11888,
11891,
11899,
11906,
11898,
11963,
11896,
11901,
11900,
11910,
11974,
11934,
11928,
11962,
11959,
]

_charnames_42192 = [
6300,
6267,
6266,
6286,
6255,
6254,
6281,
6275,
6274,
6297,
6289,
6288,
6285,
6253,
6252,
6295,
6272,
6296,
6264,
6260,
6261,
6271,
6278,
6293,
6277,
6299,
6294,
6263,
6292,
6280,
6290,
6291,
6282,
6283,
6298,
6268,
6256,
6258,
6257,
6269,
6245,
6250,
6248,
6249,
6246,
6247,
6303,
6302,
7847,
7848,
7770,
7707,
7708,
7814,
7753,
7760,
7612,
7651,
7604,
7673,
7830,
7798,
7728,
7721,
7636,
7629,
7780,
7806,
7643,
7572,
7744,
7737,
7697,
7690,
7838,
7822,
7588,
7790,
7661,
7553,
7679,
7619,
7595,
7580,
7852,
7853,
7773,
7774,
7712,
7713,
7816,
7755,
7762,
7614,
7657,
7606,
7675,
7832,
7800,
7730,
7723,
7638,
7631,
7784,
7808,
7645,
7574,
7746,
7739,
7699,
7692,
7840,
7824,
7590,
7792,
7665,
7557,
7683,
7621,
7597,
7582,
7854,
7855,
7561,
7775,
7776,
7714,
7715,
7817,
7756,
7763,
7615,
7654,
7655,
7607,
7676,
7833,
7801,
7731,
7724,
7639,
7632,
7785,
7809,
7646,
7575,
7747,
7740,
7700,
7693,
7841,
7825,
7591,
7793,
7662,
7663,
7558,
7684,
7622,
7598,
7583,
7843,
7844,
7766,
7703,
7704,
7812,
7751,
7758,
7610,
7653,
7602,
7669,
7828,
7796,
7726,
7719,
7634,
7627,
7782,
7804,
7641,
7570,
7742,
7735,
7695,
7688,
7836,
7820,
7586,
7788,
7659,
7555,
7681,
7617,
7593,
7578,
7850,
7851,
7771,
7772,
7710,
7711,
7815,
7754,
7761,
7613,
7656,
7605,
7674,
7831,
7799,
7729,
7722,
7637,
7630,
7783,
7807,
7644,
7573,
7745,
7738,
7698,
7691,
7839,
7823,
7589,
7791,
7664,
7556,
7682,
7620,
7596,
7581,
7842,
7845,
7559,
7765,
7767,
7702,
7705,
7811,
7750,
7757,
7609,
7652,
7601,
7668,
7670,
7827,
7795,
7725,
7718,
7633,
7626,
7781,
7803,
7640,
7563,
7741,
7734,
7694,
7687,
7835,
7819,
7585,
7787,
7658,
7554,
7680,
7616,
7592,
7577,
7846,
7849,
7560,
7768,
7769,
7706,
7709,
7813,
7752,
7759,
7611,
7649,
7650,
7603,
7671,
7672,
7829,
7797,
7727,
7720,
7635,
7628,
7778,
7805,
7642,
7571,
7743,
7736,
7696,
7689,
7837,
7821,
7587,
7789,
7660,
7551,
7552,
7677,
7678,
7618,
7594,
7579,
7549,
7779,
7891,
7890,
7889,
7568,
7567,
7565,
7870,
7868,
7859,
7872,
7874,
7871,
7860,
7865,
7863,
7867,
7858,
7864,
7873,
7885,
7886,
7877,
7878,
7883,
7884,
7880,
7881,
7888,
7887,
7566,
7569,
]

_charnames_42560 = [
1771,
1695,
1718,
1642,
1743,
1667,
1750,
1674,
1721,
1645,
1773,
1700,
1766,
1690,
1784,
1710,
1753,
1677,
1747,
1671,
1741,
1665,
1749,
1673,
1779,
1706,
1767,
1691,
1748,
1672,
1752,
1676,
1742,
1666,
1734,
1658,
1733,
1657,
1732,
1656,
1774,
1701,
1768,
1692,
1720,
1644,
1789,
1291,
1287,
1293,
1286,
8876,
]

_charnames_42620 = [
1292,
1290,
1791,
1790,
1719,
1643,
1717,
1641,
1770,
1694,
1780,
1707,
1716,
1640,
1727,
1651,
1726,
1650,
1724,
1648,
1725,
1649,
1728,
1652,
1759,
1683,
1736,
1660,
]

_charnames_42656 = [
4790,
4728,
4786,
4725,
4789,
4754,
4765,
4787,
4711,
4788,
4773,
4696,
4756,
4757,
4772,
4732,
4766,
4714,
4701,
4729,
4746,
4736,
4744,
4747,
4745,
4748,
4724,
4722,
4707,
4706,
4699,
4781,
4742,
4780,
4782,
4712,
4721,
4693,
4700,
4710,
4690,
4784,
4694,
4777,
4758,
4769,
4738,
4713,
4752,
4759,
4723,
4703,
4704,
4705,
4743,
4691,
4775,
4776,
4785,
4715,
4771,
4695,
4770,
4717,
4734,
4753,
4731,
4739,
4767,
4727,
4737,
4735,
4762,
4726,
4763,
4709,
4749,
4778,
4718,
4719,
4795,
4794,
4800,
4801,
4797,
4796,
4798,
4799,
]

_charnames_42752 = [
9021,
9026,
9018,
9023,
9020,
9025,
9019,
9024,
9058,
9084,
9073,
9037,
9052,
9059,
9085,
9074,
9038,
9053,
9060,
9086,
9075,
9034,
9054,
9088,
9089,
9090,
9047,
9077,
9080,
9079,
9078,
9045,
8985,
8984,
5673,
5417,
5674,
5418,
5793,
5591,
5686,
5391,
5687,
5392,
5788,
5612,
5789,
5613,
5849,
5843,
5702,
5475,
5700,
5472,
5699,
5471,
5696,
5468,
5697,
5469,
5698,
5470,
5727,
5488,
5763,
5580,
5766,
5583,
5764,
5581,
5816,
5620,
5759,
5527,
5754,
5501,
5753,
5500,
5755,
5508,
5777,
5565,
5779,
5569,
5778,
5566,
5807,
5601,
5808,
5603,
5725,
5485,
5726,
5491,
5773,
5548,
5770,
5550,
5771,
5551,
5684,
5384,
5685,
5385,
5772,
5552,
5675,
5420,
5716,
5458,
5790,
5614,
9094,
5540,
5533,
5578,
5560,
5490,
5830,
5382,
5520,
5710,
5457,
5709,
5456,
5708,
5682,
5375,
5681,
5379,
5707,
5454,
5706,
5453,
5705,
5452,
9046,
9028,
8987,
5745,
5439,
5683,
5525,
-1,
5811,
5558,
]

_charnames_42912 = [
5799,
5608,
5768,
5586,
5810,
5556,
5724,
5482,
5742,
5433,
]

_charnames_43002 = [
5824,
5858,
5857,
5860,
5861,
5862,
8760,
8757,
8774,
8751,
8759,
8753,
8773,
8737,
8738,
8743,
8744,
8775,
8746,
8747,
8740,
8741,
8720,
8721,
8726,
8727,
8722,
8723,
8728,
8729,
8754,
8734,
8735,
8749,
8750,
8755,
8732,
8756,
8731,
8752,
8758,
8766,
8764,
8762,
8765,
8763,
8771,
8770,
8769,
8768,
-1,
-1,
-1,
-1,
12331,
12332,
12336,
12330,
12333,
12335,
12338,
12341,
12340,
12339,
-1,
-1,
-1,
-1,
-1,
-1,
10574,
10573,
10577,
10546,
10557,
10559,
10589,
10544,
10542,
10541,
10555,
10547,
10571,
10570,
10593,
10587,
10540,
10539,
10553,
10582,
10564,
10565,
10549,
10580,
10584,
10588,
10550,
10551,
10591,
10560,
10590,
10583,
10578,
10586,
10585,
10581,
10592,
10576,
10579,
10598,
10597,
10537,
10536,
10554,
10545,
10562,
10567,
10568,
10561,
10599,
10600,
10558,
10601,
10605,
10603,
10604,
]

_charnames_43136 = [
8329,
8327,
8249,
8252,
8273,
8274,
8257,
8258,
8227,
8228,
8229,
8230,
8278,
8279,
8251,
8262,
8263,
8250,
8269,
8268,
8277,
8276,
8241,
8282,
8281,
8272,
8271,
8239,
8235,
8234,
8246,
8245,
8240,
8237,
8236,
8248,
8247,
8242,
8261,
8260,
8285,
8284,
8288,
8286,
8287,
8266,
8231,
8255,
8254,
8256,
8289,
8265,
8330,
8299,
8304,
8305,
8300,
8301,
8292,
8293,
8294,
8295,
8306,
8307,
8298,
8302,
8303,
8297,
8328,
]

_charnames_43214 = [
8324,
8323,
8319,
8320,
8311,
8312,
8317,
8318,
8314,
8315,
8322,
8321,
-1,
-1,
-1,
-1,
-1,
-1,
1307,
1308,
1299,
1300,
1305,
1306,
1302,
1303,
1310,
1309,
1318,
1313,
1317,
1316,
1315,
1314,
1312,
1319,
12541,
12539,
12545,
12537,
12538,
12540,
12542,
12557,
12558,
12556,
-1,
-1,
-1,
-1,
11289,
11290,
11281,
11282,
11287,
11288,
11284,
11285,
11292,
11291,
11262,
11261,
11274,
11246,
11253,
11252,
11266,
11245,
11250,
11264,
11247,
11256,
11255,
11271,
11275,
11277,
11270,
11267,
11272,
11268,
11249,
11265,
11269,
11276,
11278,
11259,
11273,
11258,
11295,
11296,
11294,
11297,
11298,
11302,
11300,
11301,
11305,
11304,
12657,
12660,
12644,
12652,
12661,
12646,
12655,
12663,
12649,
12662,
12658,
12641,
12653,
12654,
12656,
12650,
12651,
12659,
12648,
12643,
12645,
12640,
12664,
12675,
12673,
12667,
12672,
12674,
12671,
12668,
12669,
12679,
12678,
12680,
12681,
12676,
]

_charnames_43359 = [
12682,
11846,
11845,
11843,
11847,
11835,
11832,
11838,
11830,
11840,
11839,
11831,
11837,
11833,
11841,
11836,
11866,
11864,
11865,
11855,
11856,
11857,
11851,
11868,
11869,
11852,
11850,
11858,
11871,
11849,
-1,
-1,
-1,
13125,
13122,
13126,
13124,
13063,
13052,
13050,
13051,
13067,
13045,
13022,
13023,
13072,
13064,
13068,
13046,
13048,
13049,
13057,
13058,
13021,
13059,
13060,
13055,
13025,
13056,
13024,
13029,
13030,
13034,
13035,
13027,
13031,
13032,
13036,
13037,
13026,
13042,
13044,
13061,
13062,
13069,
13065,
13053,
13054,
13070,
13066,
13040,
13041,
13038,
13071,
13123,
13112,
13114,
13115,
13116,
13117,
13118,
13113,
13120,
13119,
13129,
13128,
13130,
13094,
13073,
13132,
13084,
13090,
13079,
13088,
13087,
13080,
13078,
13082,
13083,
13086,
13131,
-1,
13093,
13105,
13106,
13097,
13098,
13103,
13104,
13100,
13101,
13108,
13107,
-1,
-1,
-1,
-1,
13089,
13091,
]

_charnames_43520 = [
2256,
2264,
2260,
2266,
2257,
2262,
2246,
2245,
2252,
2251,
2219,
2220,
2255,
2254,
2249,
2248,
2215,
2217,
2216,
2237,
2236,
2230,
2228,
2221,
2222,
2229,
2226,
2224,
2225,
2234,
2232,
2242,
2243,
2233,
2258,
2261,
2263,
2259,
2239,
2240,
2265,
2271,
2276,
2277,
2278,
2272,
2275,
2274,
2270,
2269,
2273,
2298,
2300,
2301,
2299,
]

_charnames_43584 = [
2210,
2211,
2203,
2295,
2212,
2205,
2202,
2208,
2204,
2207,
2209,
2206,
2296,
2297,
-1,
-1,
2289,
2290,
2281,
2282,
2287,
2288,
2284,
2285,
2292,
2291,
-1,
-1,
2307,
2305,
2304,
2306,
9321,
9316,
9315,
9310,
9309,
9306,
9304,
9303,
9300,
9299,
9301,
9307,
9319,
9313,
9312,
9322,
9448,
9318,
9317,
9320,
9361,
9360,
9362,
9406,
9405,
9404,
9358,
9386,
-1,
-1,
-1,
-1,
7078,
7109,
7076,
7107,
7077,
7108,
7096,
7127,
7073,
7104,
7086,
7117,
7087,
7118,
7090,
7121,
7071,
7102,
7098,
7129,
7080,
7111,
7081,
7112,
7072,
7103,
7099,
7130,
7083,
7114,
7084,
7115,
7097,
7128,
7093,
7124,
7088,
7119,
7091,
7122,
7094,
7125,
7089,
7120,
7095,
7126,
7092,
7123,
7160,
7137,
7142,
7139,
7138,
7145,
7144,
7159,
7143,
7140,
7141,
7134,
7133,
7135,
7136,
7157,
7156,
7154,
7155,
]

_charnames_43777 = [
3740,
3742,
3743,
3739,
3738,
3741,
-1,
-1,
3693,
3695,
3696,
3692,
3691,
3694,
-1,
-1,
3701,
3703,
3704,
3700,
3699,
3702,
]

_charnames_43808 = [
3650,
3652,
3654,
3651,
3649,
3648,
3653,
-1,
3726,
3728,
3730,
3727,
3725,
3724,
3729,
]

_charnames_43968 = [
9467,
9491,
9472,
9470,
9463,
9456,
9494,
9459,
9469,
9454,
9461,
9489,
9488,
9493,
9490,
9477,
9465,
9495,
9480,
9476,
9492,
9487,
9475,
9483,
9481,
9484,
9486,
9468,
9473,
9471,
9464,
9457,
9460,
9455,
9478,
9515,
9517,
9519,
9512,
9514,
9513,
9518,
9516,
9520,
9496,
9521,
-1,
-1,
9507,
9508,
9499,
9500,
9505,
9506,
9502,
9503,
9510,
9509,
]

_charnames_55216 = [
11811,
11812,
11799,
11800,
11801,
11824,
11825,
11804,
11803,
11817,
11815,
11814,
11816,
11792,
11791,
11789,
11788,
11795,
11794,
11793,
11796,
11821,
11820,
-1,
-1,
-1,
-1,
11780,
11781,
11711,
11712,
11762,
11756,
11757,
11759,
11760,
11761,
11752,
11754,
11716,
11753,
11750,
11751,
11747,
11748,
11770,
11774,
11772,
11719,
11773,
11775,
11735,
11737,
11738,
11717,
11736,
11733,
11734,
11727,
11728,
11715,
11714,
11726,
11723,
11724,
11725,
11729,
11743,
11744,
11777,
11778,
11784,
11783,
11720,
11741,
11740,
]

_charnames_64107 = [
1979,
1978,
1977,
-1,
-1,
1964,
1963,
1962,
1961,
1960,
1959,
1958,
1957,
1956,
1955,
1954,
1953,
1952,
1951,
1950,
1949,
1947,
1946,
1945,
1944,
1943,
1942,
1941,
1940,
1939,
1938,
1937,
1936,
1935,
1934,
1933,
1932,
1930,
1929,
1928,
1927,
1926,
1925,
1924,
1923,
1922,
1921,
1920,
1919,
1918,
1917,
1916,
1915,
1913,
1912,
1911,
1910,
1909,
1908,
1907,
1906,
1905,
1904,
1903,
1902,
1901,
1900,
1899,
1898,
1896,
1895,
1894,
1893,
1892,
1891,
1890,
1889,
1888,
1887,
1886,
1885,
1884,
1883,
1882,
1881,
1879,
1878,
1877,
1876,
1875,
1874,
1873,
1872,
1871,
1870,
1869,
1868,
1867,
1866,
1865,
1864,
1975,
1974,
1973,
1972,
1971,
1970,
1969,
1968,
1967,
1966,
]

_charnames_64434 = [
9846,
9845,
9836,
9835,
9842,
9841,
9840,
9839,
9853,
9852,
9847,
9834,
9833,
9854,
9850,
9849,
]

_charnames_65040 = [
10880,
10878,
10877,
10881,
10882,
10885,
10883,
10874,
10870,
10884,
]

_charnames_65536 = [
6067,
6095,
6057,
6082,
6110,
6074,
6087,
6068,
6106,
6053,
6048,
6086,
-1,
6097,
6080,
6037,
6088,
6078,
6044,
6114,
6115,
6107,
6041,
6105,
6062,
6069,
6061,
6101,
6052,
6049,
6072,
6042,
6094,
6109,
6054,
6104,
6036,
6063,
6099,
-1,
6083,
6058,
6051,
6073,
6059,
6100,
6066,
6091,
6108,
6047,
6046,
6071,
6096,
6070,
6076,
6050,
6039,
6092,
6090,
-1,
6103,
6040,
-1,
6064,
6060,
6089,
6113,
6043,
6118,
6085,
6056,
6081,
6038,
6098,
6077,
6079,
6112,
6117,
-1,
-1,
6133,
6132,
6137,
6136,
6130,
6129,
6135,
6127,
6126,
6134,
6124,
6123,
6122,
6121,
]

_charnames_65664 = [
5911,
5910,
5909,
5896,
5895,
5894,
5908,
5907,
5905,
5904,
5902,
5901,
5899,
5898,
5961,
5960,
5959,
5958,
5957,
6145,
6144,
5965,
5964,
5963,
6142,
6141,
5955,
5954,
5953,
5952,
5951,
5941,
5940,
5939,
5938,
5937,
6146,
5936,
5935,
5934,
5922,
5921,
5920,
5919,
5918,
5917,
5916,
5915,
5914,
5913,
5932,
5931,
5930,
5929,
5928,
5927,
5926,
5925,
5924,
5949,
5948,
5947,
5946,
5945,
5944,
5943,
5968,
5967,
5998,
5997,
5995,
5994,
5993,
5992,
5991,
5990,
5988,
5987,
5986,
5985,
5984,
5983,
6147,
5982,
5981,
5979,
5978,
5977,
5976,
5975,
5974,
5973,
5972,
5971,
6032,
6022,
6021,
6020,
6019,
6018,
6017,
6016,
6015,
6014,
6013,
6011,
6010,
6009,
6008,
6007,
6006,
6005,
6004,
6003,
6002,
6029,
6028,
6027,
6026,
6025,
6024,
6030,
6031,
-1,
-1,
-1,
-1,
-1,
9975,
9976,
9982,
-1,
-1,
-1,
-1,
9962,
9907,
9914,
9937,
9944,
9923,
9929,
9956,
9950,
9920,
9911,
9918,
9941,
9948,
9924,
9930,
9957,
9951,
9965,
9910,
9917,
9940,
9947,
9928,
9934,
9961,
9955,
9964,
9909,
9916,
9939,
9946,
9927,
9933,
9960,
9954,
9921,
9912,
9919,
9942,
9949,
9925,
9931,
9958,
9952,
-1,
-1,
-1,
9973,
9970,
9972,
9971,
9969,
9981,
9980,
9979,
9978,
10114,
10110,
10115,
10087,
10098,
10093,
10090,
10101,
10092,
10119,
10103,
10108,
10095,
10112,
10091,
10097,
10120,
10104,
10109,
10096,
10113,
10118,
10102,
10121,
10152,
10130,
10150,
10154,
10128,
10158,
10155,
10141,
10145,
10146,
10149,
10162,
10129,
10127,
10143,
10144,
10151,
10138,
10133,
10126,
10156,
10142,
10137,
10159,
10161,
10132,
10136,
10163,
10160,
10289,
10290,
10272,
10275,
10300,
10278,
10305,
10292,
10273,
10276,
10297,
10298,
10295,
10303,
10287,
10291,
10301,
10165,
10166,
10304,
10277,
10299,
-1,
-1,
-1,
-1,
-1,
12830,
12844,
12832,
12829,
12842,
12833,
12843,
12845,
12831,
12841,
12847,
12846,
]

_charnames_66000 = [
10637,
10635,
10642,
10615,
10617,
10648,
10646,
10661,
10641,
10669,
10628,
10621,
10616,
10655,
10654,
10625,
10658,
10629,
10614,
10664,
10609,
10624,
10611,
10631,
10620,
10644,
10645,
10632,
10613,
10652,
10668,
10663,
10640,
10630,
10636,
10665,
10638,
10651,
10657,
10666,
10667,
10660,
10622,
10623,
10649,
10610,
]

_charnames_66176 = [
6486,
6482,
6484,
6485,
6500,
6501,
6498,
6490,
6488,
6475,
6497,
6480,
6494,
6496,
6478,
6476,
6479,
6477,
6491,
6495,
6481,
6493,
6492,
6473,
6474,
6487,
6483,
6499,
6489,
-1,
-1,
-1,
2178,
2164,
2173,
2158,
2136,
2161,
2159,
2179,
2181,
2183,
2146,
2182,
2174,
2155,
2143,
2144,
2140,
2177,
2134,
2152,
2180,
2151,
2157,
2163,
2145,
2167,
2171,
2137,
2165,
2166,
2154,
2135,
2169,
2170,
2141,
2142,
2153,
2168,
2176,
2156,
2139,
2162,
2147,
2150,
2149,
2148,
2160,
2172,
2138,
]

_charnames_66432 = [
13357,
13369,
13352,
13346,
13355,
13348,
13360,
13344,
13349,
13341,
13359,
13347,
13337,
13367,
13366,
13354,
13365,
13343,
13334,
13358,
13364,
13335,
13363,
13362,
13340,
13351,
13339,
13368,
13361,
13336,
-1,
13370,
11433,
11479,
11476,
11467,
11466,
11473,
11472,
11455,
11482,
11470,
11469,
11440,
11438,
11428,
11432,
11431,
11439,
11477,
11450,
11481,
11464,
11463,
11448,
11447,
11446,
11475,
11458,
11457,
11461,
11460,
11478,
11444,
11474,
11443,
11442,
11480,
-1,
-1,
-1,
-1,
11434,
11436,
11435,
11454,
11429,
11430,
11451,
11452,
11491,
11489,
11486,
11488,
11487,
11490,
]

_charnames_66638 = [
12561,
12562,
8695,
8671,
8698,
8701,
8669,
8684,
8683,
8703,
8678,
8689,
8704,
8702,
8700,
8692,
8670,
8691,
8687,
8699,
8681,
8690,
8697,
8686,
8673,
8666,
8649,
8653,
8658,
8680,
8655,
8651,
8694,
8696,
8663,
8652,
8674,
8693,
8660,
8657,
8659,
8648,
8647,
8656,
8650,
8665,
8646,
8664,
8675,
8677,
11607,
11638,
11626,
11632,
11623,
11615,
11621,
11627,
11611,
11610,
11620,
11637,
11635,
11636,
11628,
11616,
11631,
11630,
11629,
11624,
11634,
11622,
11606,
11617,
11633,
11612,
11625,
11608,
11618,
11613,
-1,
-1,
11649,
11650,
11641,
11642,
11647,
11648,
11644,
11645,
11652,
11651,
]

_charnames_67584 = [
1859,
1858,
1857,
1856,
1855,
1854,
-1,
-1,
1853,
-1,
1840,
1839,
1838,
1837,
1836,
1834,
1833,
1832,
1831,
1830,
1828,
1827,
1826,
1825,
1824,
1822,
1821,
1820,
1819,
1818,
1816,
1815,
1814,
1813,
1812,
1810,
1809,
1808,
1807,
1806,
1804,
1803,
1802,
1801,
1800,
1798,
1797,
1796,
1795,
1794,
1845,
1844,
1843,
1842,
-1,
1851,
1850,
-1,
-1,
-1,
1848,
-1,
-1,
1847,
12984,
12997,
12995,
12996,
12980,
12987,
12985,
12981,
12978,
12986,
12994,
12993,
12992,
12991,
12974,
12983,
12990,
12975,
12989,
12988,
12976,
12979,
-1,
13010,
13006,
13001,
13005,
13003,
13002,
13009,
13008,
13004,
]

_charnames_67840 = [
10682,
10696,
10694,
10695,
10679,
10686,
10684,
10680,
10677,
10685,
10693,
10692,
10691,
10690,
10674,
10683,
10689,
10675,
10688,
10687,
10673,
10678,
10704,
10703,
10701,
10705,
10700,
10702,
-1,
-1,
-1,
10706,
6514,
6529,
6525,
6527,
6512,
6517,
6524,
6516,
6523,
6510,
6522,
6508,
6521,
6519,
6507,
6504,
6518,
6526,
6520,
6506,
6505,
6515,
6513,
6511,
6509,
6528,
-1,
-1,
-1,
-1,
-1,
6530,
]

_charnames_68096 = [
11107,
11128,
11126,
11125,
-1,
11129,
11127,
-1,
-1,
-1,
-1,
-1,
11130,
11134,
11139,
11136,
11086,
11085,
11092,
11091,
-1,
11095,
11094,
11105,
-1,
11080,
11066,
11065,
11072,
11071,
11081,
11068,
11067,
11074,
11073,
11082,
11089,
11088,
11098,
11097,
11103,
11100,
11102,
11104,
11101,
11077,
11076,
11078,
11099,
11106,
11084,
11064,
-1,
-1,
-1,
-1,
11138,
11137,
11135,
-1,
-1,
-1,
-1,
11131,
11151,
11149,
11150,
11152,
11143,
11142,
11146,
11145,
]

_charnames_68176 = [
11112,
11120,
11119,
11118,
11121,
11115,
11113,
11111,
11116,
]

_charnames_68192 = [
11514,
11529,
11515,
11528,
11526,
11524,
11505,
11525,
11531,
11499,
11502,
11513,
11527,
11512,
11504,
11503,
11530,
11521,
11520,
11509,
11517,
11510,
11518,
11498,
11522,
11508,
11523,
11497,
11496,
11534,
11535,
11536,
]

_charnames_68352 = [
9986,
9987,
9992,
9988,
9993,
9989,
9990,
9991,
10035,
10036,
10028,
10029,
10030,
10031,
10026,
10027,
10048,
10011,
10009,
10010,
10019,
10018,
10017,
10051,
10049,
10015,
10014,
10039,
10038,
10013,
10045,
10050,
10042,
10041,
9998,
9996,
9997,
10001,
9999,
10000,
10046,
10033,
10024,
10025,
10043,
10044,
10047,
10007,
10022,
10005,
10021,
10004,
10006,
10034,
-1,
-1,
-1,
10052,
7457,
8809,
5871,
5867,
5870,
5866,
12889,
12902,
12900,
12901,
12885,
12892,
12890,
12886,
12883,
12891,
12899,
12898,
12897,
12896,
12879,
12888,
12895,
12880,
12894,
12893,
12881,
12884,
-1,
-1,
12910,
12906,
12908,
12914,
12909,
12907,
12913,
12912,
12938,
12937,
12935,
12936,
12925,
12929,
12927,
12926,
12923,
12928,
12934,
12933,
12932,
12931,
12919,
12930,
12920,
12921,
12924,
-1,
-1,
-1,
-1,
-1,
12946,
12942,
12944,
12950,
12945,
12943,
12949,
12948,
]

_charnames_68608 = [
11346,
11392,
11393,
11387,
11423,
11411,
11381,
11382,
11420,
11368,
11410,
11357,
11400,
11366,
11408,
11355,
11399,
11367,
11409,
11356,
11375,
11416,
11360,
11401,
11348,
11396,
11354,
11398,
11383,
11421,
11365,
11407,
11353,
11379,
11378,
11364,
11352,
11394,
11372,
11414,
11374,
11415,
11371,
11413,
11406,
11373,
11395,
11377,
11386,
11389,
11380,
11418,
11363,
11405,
11388,
11424,
11385,
11422,
11362,
11404,
11351,
11358,
11350,
11359,
11403,
11376,
11417,
11361,
11402,
11349,
11397,
11384,
11390,
]

_charnames_69216 = [
12771,
12763,
12764,
12769,
12770,
12766,
12767,
12773,
12772,
12739,
12735,
12738,
12750,
12753,
12742,
12745,
12758,
12755,
12760,
12734,
12737,
12749,
12752,
12743,
12746,
12759,
12756,
12778,
12777,
12776,
12779,
]

_charnames_69632 = [
5199,
5200,
5196,
5198,
5197,
5092,
5095,
5114,
5115,
5100,
5101,
5065,
5066,
5067,
5068,
5129,
5094,
5076,
5093,
5110,
5109,
5118,
5117,
5084,
5121,
5120,
5113,
5112,
5082,
5073,
5072,
5089,
5088,
5083,
5075,
5074,
5091,
5090,
5085,
5104,
5103,
5124,
5123,
5127,
5125,
5126,
5107,
5069,
5098,
5097,
5099,
5128,
5106,
5080,
5078,
5079,
5169,
5176,
5172,
5173,
5170,
5171,
5162,
5163,
5164,
5165,
5175,
5168,
5174,
5167,
5177,
5194,
5193,
5207,
5206,
5204,
5208,
5203,
-1,
-1,
-1,
-1,
5151,
5133,
5136,
5146,
5149,
5140,
5142,
5157,
5155,
5138,
5134,
5137,
5147,
5150,
5141,
5143,
5158,
5156,
5154,
5153,
5189,
5190,
5181,
5182,
5187,
5188,
5184,
5185,
5192,
5191,
]

_charnames_69760 = [
11231,
11232,
11228,
11174,
11177,
11196,
11197,
11182,
11183,
11213,
11176,
11209,
11175,
11192,
11191,
11200,
11199,
11172,
11203,
11202,
11195,
11194,
11170,
11166,
11165,
11160,
11159,
11158,
11185,
11171,
11168,
11167,
11162,
11161,
11173,
11189,
11188,
11206,
11205,
11210,
11207,
11186,
11211,
11208,
11180,
11179,
11181,
11212,
11218,
11221,
11222,
11219,
11220,
11224,
11217,
11223,
11216,
11229,
11230,
11241,
11240,
11239,
11233,
11236,
11238,
11237,
]

_charnames_73728 = [
612,
669,
668,
667,
666,
665,
664,
663,
662,
690,
613,
627,
626,
621,
620,
625,
618,
617,
624,
623,
622,
628,
629,
635,
634,
633,
632,
631,
689,
682,
685,
684,
636,
646,
645,
644,
643,
640,
639,
642,
641,
648,
647,
686,
687,
670,
676,
675,
674,
673,
677,
688,
679,
680,
681,
660,
650,
656,
657,
655,
653,
654,
659,
658,
1036,
1044,
1043,
1042,
1037,
1039,
1038,
1040,
1041,
1055,
1059,
1058,
1057,
1045,
1049,
1048,
1050,
1053,
1054,
1051,
1052,
766,
767,
790,
789,
787,
786,
772,
773,
770,
771,
774,
796,
783,
784,
795,
779,
776,
778,
777,
794,
793,
792,
791,
782,
781,
801,
797,
800,
799,
819,
826,
820,
822,
821,
823,
824,
825,
802,
813,
814,
812,
808,
810,
809,
815,
816,
818,
803,
804,
805,
806,
807,
817,
827,
874,
875,
861,
869,
868,
867,
865,
864,
866,
879,
878,
877,
852,
855,
856,
857,
860,
859,
858,
872,
871,
876,
828,
835,
836,
837,
838,
851,
848,
849,
846,
847,
850,
840,
841,
842,
831,
832,
834,
833,
845,
844,
5,
97,
6,
13,
12,
11,
17,
16,
14,
15,
64,
63,
60,
61,
58,
55,
56,
57,
52,
53,
50,
51,
34,
33,
28,
29,
30,
31,
46,
44,
45,
48,
47,
75,
74,
40,
39,
36,
37,
41,
78,
72,
71,
68,
69,
77,
25,
24,
20,
21,
22,
26,
76,
65,
66,
67,
79,
93,
94,
91,
92,
86,
88,
87,
96,
80,
81,
83,
84,
85,
89,
90,
95,
153,
154,
98,
126,
125,
127,
119,
121,
122,
128,
107,
108,
100,
106,
105,
104,
103,
102,
118,
110,
117,
115,
114,
116,
129,
152,
130,
133,
134,
136,
135,
137,
143,
147,
146,
148,
151,
149,
150,
138,
142,
141,
140,
1003,
1005,
1006,
1007,
983,
985,
986,
993,
992,
991,
990,
989,
988,
987,
994,
995,
1001,
1000,
999,
998,
997,
1002,
955,
981,
980,
973,
976,
975,
963,
964,
969,
966,
967,
968,
970,
972,
971,
956,
958,
961,
960,
959,
962,
979,
978,
977,
293,
337,
338,
339,
340,
335,
334,
333,
336,
356,
355,
296,
300,
299,
297,
298,
301,
305,
303,
304,
306,
307,
353,
352,
344,
342,
343,
350,
349,
319,
323,
322,
321,
324,
325,
347,
346,
360,
359,
314,
315,
313,
312,
311,
310,
317,
316,
358,
326,
330,
329,
328,
327,
357,
380,
381,
382,
366,
365,
364,
362,
363,
378,
379,
371,
373,
374,
377,
376,
367,
370,
369,
408,
395,
404,
402,
403,
406,
405,
400,
399,
397,
398,
383,
394,
393,
388,
389,
392,
386,
387,
391,
384,
385,
390,
407,
156,
158,
161,
165,
164,
163,
168,
167,
166,
223,
222,
226,
225,
206,
207,
204,
205,
218,
219,
220,
202,
198,
201,
200,
190,
191,
189,
187,
188,
196,
195,
193,
194,
214,
215,
216,
224,
183,
182,
181,
178,
179,
184,
211,
210,
212,
169,
172,
171,
175,
174,
173,
227,
228,
230,
231,
232,
233,
239,
237,
238,
234,
235,
236,
288,
291,
290,
289,
240,
287,
241,
268,
267,
260,
261,
266,
265,
264,
249,
247,
248,
250,
259,
258,
263,
256,
255,
253,
252,
262,
269,
274,
273,
271,
272,
286,
275,
278,
279,
280,
285,
284,
281,
282,
283,
942,
946,
947,
950,
949,
948,
943,
944,
953,
954,
951,
952,
920,
941,
937,
938,
940,
939,
921,
926,
925,
924,
927,
928,
929,
930,
933,
934,
935,
936,
748,
758,
749,
753,
751,
752,
754,
757,
755,
756,
759,
763,
762,
764,
721,
747,
746,
741,
744,
743,
722,
732,
730,
731,
740,
739,
738,
737,
724,
728,
726,
727,
735,
734,
745,
692,
720,
693,
715,
714,
711,
712,
713,
718,
719,
716,
717,
694,
706,
705,
704,
703,
702,
701,
700,
699,
698,
697,
707,
708,
1030,
1033,
1032,
1031,
1034,
1009,
1019,
1020,
1018,
1017,
1021,
1014,
1015,
1012,
1013,
1022,
1023,
1028,
1027,
1026,
1029,
1081,
1082,
1084,
1083,
465,
490,
466,
488,
481,
482,
487,
480,
479,
486,
485,
484,
477,
476,
483,
474,
473,
472,
471,
470,
489,
491,
492,
493,
495,
494,
436,
437,
446,
445,
444,
443,
442,
441,
439,
440,
449,
448,
447,
450,
458,
457,
456,
460,
459,
451,
453,
452,
430,
433,
432,
412,
425,
418,
417,
424,
423,
414,
415,
422,
421,
420,
419,
435,
426,
428,
429,
434,
461,
464,
463,
462,
505,
511,
506,
507,
508,
510,
509,
496,
504,
501,
502,
503,
499,
500,
497,
498,
881,
896,
894,
893,
895,
897,
900,
899,
882,
890,
889,
886,
885,
888,
887,
902,
901,
917,
918,
903,
910,
909,
904,
908,
906,
907,
911,
916,
915,
914,
912,
913,
512,
602,
601,
600,
599,
598,
611,
610,
564,
573,
570,
569,
567,
568,
574,
571,
572,
575,
576,
581,
580,
579,
578,
586,
582,
585,
584,
607,
608,
513,
562,
561,
545,
554,
553,
555,
557,
556,
547,
550,
549,
563,
558,
559,
514,
533,
534,
542,
541,
517,
520,
519,
518,
521,
540,
529,
528,
527,
539,
538,
537,
536,
532,
531,
535,
525,
524,
523,
543,
544,
587,
592,
589,
590,
591,
593,
595,
594,
609,
604,
605,
606,
1073,
1075,
1076,
1078,
1077,
1079,
1061,
1067,
1066,
1062,
1063,
1065,
1064,
1068,
1069,
1070,
1072,
1071,
]

_charnames_74752 = [
1157,
1141,
1103,
1120,
1173,
1171,
1223,
1212,
1143,
1106,
1123,
1179,
1170,
1222,
1211,
1105,
1122,
1176,
1167,
1219,
1208,
1190,
1153,
1140,
1102,
1119,
1178,
1169,
1221,
1210,
1189,
1152,
1139,
1101,
1118,
1150,
1129,
1130,
1099,
1111,
1177,
1168,
1220,
1209,
1197,
1149,
1127,
1128,
1098,
1110,
1182,
1181,
1195,
1155,
1132,
1133,
1096,
1116,
1137,
1136,
1088,
1092,
1091,
1090,
1175,
1166,
1165,
1164,
1217,
1218,
1204,
1206,
1205,
1207,
1158,
1142,
1104,
1121,
1174,
1196,
1156,
1134,
1094,
1095,
1114,
1115,
1214,
1215,
1192,
1159,
1187,
1147,
1112,
1186,
1146,
1193,
1198,
1200,
1201,
]

_charnames_77824 = [
2494,
2493,
2492,
2491,
2486,
2487,
2483,
2485,
2484,
2490,
2489,
2488,
2481,
2480,
2479,
2478,
2472,
2473,
2477,
2476,
2470,
2471,
2475,
2474,
2539,
2538,
2537,
2536,
2535,
2534,
2533,
2532,
2531,
2530,
2506,
2505,
2496,
2497,
2504,
2503,
2502,
2501,
2500,
2499,
2498,
2461,
2462,
2468,
2459,
2460,
2457,
2458,
2467,
2455,
2456,
2466,
2465,
2464,
2463,
2528,
2527,
2526,
2525,
2524,
2523,
2522,
2521,
2520,
2519,
2517,
2516,
2515,
2514,
2513,
2512,
2511,
2510,
2509,
2508,
2540,
3603,
3602,
3601,
3600,
3594,
3595,
3599,
3598,
3597,
3596,
3512,
3501,
3504,
3503,
3502,
3511,
3510,
3509,
3508,
3507,
3506,
3505,
3514,
3515,
3524,
3523,
3522,
3521,
3520,
3519,
3518,
3517,
3516,
3530,
3529,
3528,
3527,
3526,
2790,
2789,
2788,
2787,
2786,
2785,
2784,
2781,
2782,
2783,
2779,
2778,
2777,
2776,
2775,
2774,
2773,
2772,
2771,
2770,
2768,
2767,
2766,
2765,
2764,
2763,
2762,
2758,
2759,
2761,
2760,
2756,
2747,
2748,
2755,
2754,
2745,
2746,
2753,
2752,
2751,
2750,
2749,
2743,
2742,
2741,
2740,
2739,
2738,
2734,
2735,
2737,
2732,
2733,
2736,
2693,
2702,
2701,
2700,
2699,
2698,
2697,
2696,
2695,
2694,
2713,
2705,
2706,
2712,
2703,
2704,
2711,
2710,
2709,
2708,
2707,
2730,
2729,
2728,
2727,
2726,
2725,
2724,
2715,
2723,
2722,
2721,
2720,
2719,
2718,
2717,
2716,
3370,
3369,
3368,
3367,
3366,
3365,
3364,
3362,
3363,
3360,
3361,
3358,
3357,
3356,
3355,
3354,
3353,
3349,
3350,
3347,
3348,
3352,
3351,
3336,
3337,
3345,
3344,
3343,
3342,
3341,
3340,
3339,
3334,
3335,
3338,
3380,
3379,
3378,
3377,
3372,
3373,
3376,
3375,
3374,
3081,
3082,
3090,
3089,
3088,
3087,
3086,
3085,
3084,
3083,
3079,
3078,
3077,
3069,
3070,
3076,
3075,
3074,
3073,
3072,
3071,
3067,
3057,
3058,
3066,
3065,
3064,
3063,
3062,
3061,
3060,
3059,
3055,
3047,
3048,
3054,
3053,
3052,
3051,
3050,
3045,
3046,
3043,
3044,
3049,
3041,
3040,
3039,
3038,
3037,
3033,
3034,
3031,
3032,
3029,
3030,
3036,
3035,
3098,
3092,
3095,
3094,
3093,
3097,
3096,
3151,
3150,
3149,
3148,
3147,
3143,
3144,
3140,
3142,
3141,
3146,
3145,
3163,
3153,
3154,
3162,
3161,
3160,
3159,
3158,
3157,
3156,
3155,
3129,
3130,
3138,
3137,
3136,
3135,
3134,
3127,
3128,
3133,
3132,
3131,
3125,
3124,
3123,
3122,
3121,
3120,
3116,
3117,
3114,
3115,
3119,
3118,
3112,
3111,
3110,
3103,
3104,
3109,
3101,
3102,
3108,
3107,
3106,
3105,
3169,
3168,
3167,
3166,
3165,
3623,
3622,
3621,
3620,
3619,
3615,
3616,
3618,
3617,
3543,
3542,
3541,
3540,
3535,
3536,
3539,
3538,
3537,
3533,
3534,
3547,
3548,
3545,
3546,
3552,
3551,
3550,
3549,
3632,
3631,
3630,
3629,
3628,
3627,
3626,
3625,
3592,
3585,
3586,
3591,
3590,
3589,
3583,
3584,
3588,
3587,
3008,
3010,
3009,
3019,
3011,
3012,
3018,
3017,
3016,
3015,
3014,
3013,
2972,
2973,
2978,
2957,
2965,
2964,
2963,
2962,
2961,
2960,
2959,
2958,
2977,
2976,
2970,
2971,
2968,
2969,
2966,
2967,
2975,
2974,
3006,
3005,
2998,
2999,
3004,
2996,
2997,
3003,
3002,
3001,
2994,
2995,
3000,
2992,
2983,
2984,
2991,
2980,
2982,
2981,
2990,
2989,
2988,
2987,
2986,
2985,
3021,
3022,
3026,
3025,
3024,
3023,
2631,
2630,
2629,
2628,
2627,
2626,
2625,
2624,
2623,
2609,
2608,
2607,
2606,
2605,
2604,
2603,
2602,
2598,
2600,
2599,
2601,
2621,
2620,
2619,
2618,
2617,
2611,
2612,
2616,
2615,
2614,
2613,
2596,
2595,
2594,
2589,
2590,
2587,
2588,
2585,
2586,
2593,
2583,
2584,
2592,
2591,
2635,
2634,
2633,
2689,
2688,
2687,
2686,
2680,
2681,
2685,
2684,
2683,
2682,
2678,
2677,
2676,
2675,
2674,
2673,
2672,
2668,
2669,
2671,
2670,
2690,
2660,
2659,
2658,
2657,
2656,
2655,
2654,
2653,
2652,
2642,
2643,
2640,
2641,
2650,
2649,
2648,
2647,
2646,
2645,
2638,
2639,
2644,
2665,
2664,
2662,
2663,
2884,
2885,
2891,
2890,
2889,
2882,
2883,
2875,
2881,
2880,
2879,
2878,
2877,
2876,
2888,
2887,
2886,
2925,
2928,
2927,
2926,
2938,
2937,
2936,
2935,
2934,
2933,
2932,
2931,
2929,
2930,
2916,
2917,
2923,
2922,
2921,
2914,
2915,
2912,
2913,
2920,
2919,
2918,
2910,
2911,
2900,
2901,
2908,
2907,
2898,
2899,
2906,
2905,
2893,
2897,
2896,
2895,
2894,
2904,
2903,
2902,
2949,
2948,
2947,
2946,
2945,
2944,
2943,
2942,
2941,
2940,
2951,
2953,
2952,
2954,
3557,
3558,
3565,
3555,
3556,
3564,
3563,
3562,
3561,
3560,
3559,
3568,
3567,
3640,
3639,
3638,
3637,
3636,
3635,
3634,
3451,
3443,
3444,
3440,
3442,
3441,
3450,
3449,
3448,
3447,
3446,
3445,
3429,
3430,
3438,
3437,
3436,
3435,
3434,
3427,
3428,
3433,
3432,
3431,
3462,
3461,
3460,
3459,
3458,
3457,
3456,
3455,
3454,
3453,
3221,
3213,
3214,
3220,
3219,
3218,
3211,
3212,
3217,
3216,
3215,
3184,
3183,
3182,
3181,
3172,
3174,
3173,
3180,
3179,
3175,
3176,
3178,
3177,
3197,
3196,
3195,
3194,
3193,
3192,
3186,
3188,
3187,
3191,
3190,
3189,
3209,
3208,
3207,
3206,
3205,
3199,
3200,
3204,
3203,
3202,
3201,
3229,
3228,
3227,
3226,
3225,
3224,
3223,
3297,
3296,
3291,
3292,
3295,
3294,
3293,
3289,
3290,
3287,
3288,
3285,
3286,
3310,
3301,
3302,
3309,
3308,
3307,
3306,
3299,
3300,
3305,
3304,
3303,
3321,
3320,
3319,
3318,
3317,
3316,
3315,
3314,
3313,
3312,
3331,
3330,
3325,
3326,
3323,
3324,
3329,
3328,
3327,
3267,
3266,
3265,
3264,
3263,
3257,
3259,
3258,
3262,
3261,
3260,
3278,
3277,
3276,
3275,
3274,
3273,
3272,
3271,
3270,
3269,
3243,
3242,
3241,
3234,
3235,
3240,
3239,
3238,
3237,
3236,
3232,
3233,
3255,
3254,
3245,
3246,
3253,
3252,
3251,
3250,
3249,
3248,
3247,
3282,
3281,
3280,
2819,
2828,
2827,
2826,
2825,
2824,
2823,
2822,
2821,
2820,
2832,
2833,
2839,
2838,
2837,
2836,
2829,
2831,
2830,
2835,
2834,
2855,
2841,
2844,
2843,
2842,
2845,
2847,
2846,
2854,
2853,
2852,
2851,
2850,
2849,
2848,
2793,
2805,
2804,
2803,
2802,
2801,
2800,
2799,
2798,
2797,
2796,
2795,
2794,
2817,
2816,
2810,
2811,
2815,
2814,
2813,
2812,
2808,
2809,
2806,
2807,
2863,
2864,
2861,
2862,
2870,
2859,
2860,
2869,
2868,
2867,
2857,
2858,
2866,
2865,
2871,
2872,
3490,
3489,
3482,
3483,
3488,
3487,
3486,
3485,
3484,
3480,
3481,
3471,
3472,
3478,
3477,
3476,
3469,
3470,
3475,
3474,
3467,
3468,
3465,
3466,
3473,
3498,
3497,
3496,
3495,
3492,
3493,
3494,
3581,
3580,
3579,
3570,
3572,
3571,
3578,
3575,
3576,
3577,
3573,
3574,
3605,
3606,
3613,
3612,
3611,
3610,
3609,
3608,
3607,
3424,
3408,
3412,
3411,
3410,
3409,
3413,
3415,
3414,
3418,
3419,
3416,
3417,
3423,
3422,
3421,
3420,
3406,
3405,
3404,
3403,
3402,
3383,
3392,
3391,
3390,
3389,
3388,
3387,
3386,
3385,
3384,
3393,
3401,
3400,
3399,
3398,
3397,
3396,
3395,
3394,
2553,
2552,
2551,
2550,
2549,
2548,
2543,
2545,
2544,
2547,
2546,
2575,
2574,
2573,
2572,
2571,
2570,
2569,
2568,
2567,
2566,
2564,
2563,
2562,
2561,
2560,
2559,
2558,
2557,
2556,
2555,
2579,
2578,
2577,
]

_charnames_92160 = [
4420,
4528,
4497,
4498,
4441,
4472,
4517,
4429,
4475,
4494,
4495,
4451,
4513,
4422,
4449,
4456,
4465,
4483,
4416,
4503,
4434,
4481,
4419,
4523,
4522,
4415,
4454,
4489,
4526,
4490,
4461,
4428,
4531,
4527,
4414,
4482,
4466,
4467,
4459,
4507,
4491,
4438,
4500,
4450,
4443,
4499,
4512,
4520,
4480,
4515,
4453,
4504,
4437,
4508,
4460,
4471,
4521,
4534,
4533,
4509,
4479,
4455,
4474,
4412,
4476,
4425,
4487,
4435,
4530,
4421,
4452,
4442,
4464,
4426,
4516,
4478,
4488,
4431,
4448,
4424,
4506,
4432,
4532,
4519,
4444,
4440,
4463,
4568,
4603,
4577,
4578,
4598,
4540,
4587,
4606,
4539,
4588,
4592,
4607,
4596,
4570,
4571,
4609,
4591,
4602,
4575,
4574,
4549,
4542,
4565,
4583,
4610,
4582,
4597,
4593,
4615,
4563,
4560,
4614,
4579,
4604,
4553,
4558,
4559,
4550,
4576,
4543,
4554,
4566,
4590,
4552,
4612,
4541,
4613,
4584,
4547,
4546,
4599,
4561,
4569,
4544,
4586,
4562,
4273,
4310,
4364,
4402,
4271,
4288,
4274,
4397,
4322,
4399,
4314,
4306,
4320,
4392,
4292,
4329,
4348,
4398,
4351,
4365,
4309,
4332,
4283,
4324,
4366,
4359,
4360,
4381,
4293,
4375,
4301,
4371,
4383,
4270,
4404,
4313,
4340,
4307,
4267,
4386,
4325,
4343,
4304,
4373,
4268,
4407,
4287,
4284,
4282,
4408,
4405,
4321,
4406,
4300,
4387,
4370,
4279,
4297,
4355,
4266,
4336,
4333,
4388,
4357,
4299,
4275,
4401,
4269,
4281,
4305,
4358,
4280,
4291,
4339,
4367,
4290,
4378,
4382,
4323,
4337,
4330,
4349,
4319,
4350,
4328,
4363,
4296,
4342,
4341,
4379,
4353,
4354,
4276,
4312,
4389,
4393,
4394,
4374,
4168,
4255,
4115,
4151,
4116,
4229,
4118,
4128,
4109,
4134,
4254,
4103,
4181,
4105,
4200,
4211,
4180,
4121,
4187,
4201,
4246,
4204,
4191,
4153,
4137,
4170,
4162,
4193,
4245,
4119,
4198,
4100,
4215,
4258,
4102,
4260,
4138,
4157,
4224,
4139,
4174,
4159,
4232,
4158,
4150,
4227,
4125,
4166,
4207,
4133,
4213,
4192,
4244,
4199,
4252,
4214,
4101,
4154,
4124,
4197,
4237,
4235,
4131,
4225,
4108,
4155,
4111,
4243,
4238,
4242,
4140,
4143,
4188,
4205,
4113,
4104,
4216,
4163,
4203,
4129,
4212,
4171,
4110,
4223,
4112,
4127,
4120,
4257,
4202,
4249,
4219,
4217,
4132,
4251,
4226,
4164,
4148,
4186,
4173,
4184,
4179,
4206,
4146,
4182,
4144,
4236,
4147,
4183,
4233,
4172,
4228,
4250,
4218,
4145,
4167,
4190,
4261,
3905,
3989,
3969,
4034,
4091,
4029,
3941,
4023,
4078,
3918,
3909,
3937,
3981,
3882,
4048,
4084,
4021,
3891,
3942,
3988,
4041,
4031,
3920,
3897,
3960,
3880,
3896,
3919,
4080,
3914,
3954,
4024,
3886,
3967,
4067,
3881,
3915,
3962,
4028,
3892,
3907,
3982,
4020,
3938,
3903,
3888,
4011,
4068,
3986,
4002,
3955,
3985,
4046,
4022,
3993,
4089,
4086,
4035,
3934,
3979,
4072,
3898,
4018,
3966,
3970,
3923,
3932,
4075,
3984,
4042,
4012,
3925,
4010,
3974,
3908,
3949,
3999,
4037,
4057,
4074,
3877,
4047,
3959,
3883,
4070,
4059,
3928,
3953,
4005,
3890,
3926,
3922,
3956,
3964,
4058,
3931,
3972,
4069,
4055,
3971,
3936,
3878,
4040,
3948,
3929,
4003,
3887,
3945,
4056,
4061,
3912,
4094,
3990,
4092,
4093,
4033,
3944,
3978,
3980,
3904,
4017,
4004,
3893,
4000,
4007,
4008,
3997,
3998,
4045,
3952,
3913,
3939,
4085,
4062,
4090,
4036,
3963,
4081,
4079,
3894,
3899,
4015,
4016,
4054,
3930,
3946,
4030,
4049,
3975,
3958,
3961,
3992,
4050,
3973,
3994,
4060,
4071,
4648,
4686,
4645,
4688,
4653,
4667,
4626,
4678,
4655,
4656,
4663,
4668,
4630,
4622,
4658,
4636,
4635,
4637,
4638,
4644,
4642,
4619,
4618,
4621,
4680,
4633,
4681,
4628,
4672,
4627,
4683,
4673,
4657,
4629,
4651,
4643,
4624,
4625,
4634,
4674,
4687,
4684,
4677,
4676,
4647,
4660,
4652,
4664,
4662,
4661,
4669,
4646,
4639,
4685,
]

_charnames_119296 = [
10207,
10224,
10235,
10234,
10218,
10233,
10232,
10231,
10230,
10217,
10216,
10215,
10214,
10213,
10212,
10211,
10210,
10209,
10208,
10229,
10228,
10227,
10226,
10225,
10223,
10222,
10221,
10220,
10219,
10176,
10184,
10168,
10191,
10205,
10204,
10183,
10182,
10181,
10180,
10179,
10178,
10177,
10190,
10189,
10188,
10187,
10186,
10185,
10203,
10202,
10201,
10200,
10199,
10198,
10175,
10174,
10173,
10172,
10171,
10170,
10169,
10196,
10195,
10194,
10193,
10192,
1395,
1396,
1397,
10294,
]

_charnames_119552 = [
9103,
12599,
12598,
12593,
12592,
12590,
7226,
7263,
7295,
7306,
7315,
7213,
7290,
7311,
7304,
7236,
7232,
7322,
7318,
7288,
7258,
7215,
7320,
7309,
7266,
7292,
7257,
7254,
7249,
7325,
7214,
7244,
7238,
7225,
7237,
7305,
7286,
7302,
7222,
7314,
7278,
7274,
7287,
7262,
7255,
7300,
7256,
7282,
7245,
7272,
7281,
7243,
7285,
7259,
7267,
7323,
7216,
7296,
7247,
7324,
7231,
7223,
7280,
7279,
7297,
7293,
7248,
7239,
7308,
7275,
7317,
7235,
7240,
7230,
7246,
7276,
7273,
7321,
7219,
7224,
7268,
7291,
7218,
7312,
7233,
7301,
7265,
]

_charnames_119648 = [
1600,
1592,
1593,
1598,
1599,
1595,
1596,
1602,
1601,
1613,
1605,
1606,
1611,
1612,
1608,
1609,
1615,
1614,
]

_charnames_126976 = [
9187,
9144,
9191,
9180,
9195,
9198,
9190,
9171,
9149,
9154,
9160,
9165,
9135,
9140,
9185,
9178,
9172,
9150,
9155,
9161,
9166,
9136,
9141,
9186,
9179,
9170,
9148,
9153,
9159,
9164,
9134,
9139,
9184,
9177,
9196,
9173,
9193,
9199,
9143,
9142,
9200,
9189,
9197,
9194,
-1,
-1,
-1,
-1,
12485,
12484,
12483,
12482,
12481,
12480,
12479,
12478,
12476,
12475,
12474,
12473,
12472,
12471,
12470,
12468,
12467,
12466,
12465,
12464,
12463,
12462,
12460,
12459,
12458,
12457,
12456,
12455,
12454,
12452,
12451,
12450,
12449,
12448,
12447,
12446,
12444,
12443,
12442,
12441,
12440,
12439,
12438,
12436,
12435,
12434,
12433,
12432,
12431,
12430,
12426,
12425,
12424,
12423,
12422,
12421,
12420,
12419,
12417,
12416,
12415,
12414,
12413,
12412,
12411,
12409,
12408,
12407,
12406,
12405,
12404,
12403,
12401,
12400,
12399,
12398,
12397,
12396,
12395,
12393,
12392,
12391,
12390,
12389,
12388,
12387,
12385,
12384,
12383,
12382,
12381,
12380,
12379,
12377,
12376,
12375,
12374,
12373,
12372,
12371,
]

_charnames_127136 = [
10784,
10778,
10710,
10715,
10748,
10753,
10726,
10731,
10773,
10763,
10720,
10768,
10737,
10758,
10742,
-1,
-1,
10779,
10711,
10716,
10749,
10754,
10727,
10732,
10774,
10764,
10721,
10769,
10738,
10759,
10743,
-1,
-1,
10780,
10712,
10717,
10750,
10755,
10728,
10733,
10775,
10765,
10722,
10770,
10739,
10760,
10744,
10783,
-1,
10781,
10713,
10718,
10751,
10756,
10729,
10734,
10776,
10766,
10723,
10771,
10740,
10761,
10745,
10785,
]

_charnames_127232 = [
12575,
12576,
12586,
12578,
12579,
12584,
12585,
12581,
12582,
12588,
12587,
-1,
-1,
-1,
-1,
-1,
10815,
10814,
10813,
10812,
10811,
10810,
10809,
10808,
10807,
10806,
10805,
10804,
10803,
10802,
10801,
10800,
10799,
10798,
10797,
10796,
10795,
10794,
10793,
10792,
10791,
10790,
7476,
2416,
2415,
2422,
2423,
-1,
8503,
8502,
8501,
8500,
8499,
8498,
8497,
8496,
8495,
8494,
8493,
8492,
8491,
8490,
8489,
8488,
8487,
8486,
8485,
8484,
8483,
8482,
8481,
8480,
8479,
8478,
8531,
8529,
8510,
8508,
8527,
8524,
12245,
12244,
12243,
12242,
12241,
12240,
12239,
12238,
12237,
12236,
12235,
12234,
12233,
12232,
12231,
12230,
12229,
12228,
12227,
12226,
12225,
12224,
12223,
12222,
12221,
12220,
-1,
-1,
-1,
-1,
-1,
-1,
12211,
12210,
12209,
12208,
12207,
12206,
12205,
12204,
12203,
12202,
12201,
12200,
12199,
12198,
12197,
12196,
12195,
12194,
12193,
12192,
12191,
12190,
12189,
12188,
12187,
12186,
2433,
12215,
12214,
12213,
12217,
12212,
8543,
8475,
8474,
8522,
8530,
8520,
8519,
8528,
8509,
8526,
8525,
]

_charnames_127462 = [
12709,
12708,
12707,
12706,
12705,
12704,
12703,
12702,
12701,
12700,
12699,
12698,
12697,
12696,
12695,
12694,
12693,
12692,
12691,
12690,
12689,
12688,
12687,
12686,
12685,
12684,
8545,
8515,
8514,
]

_charnames_127504 = [
8441,
8433,
8430,
8516,
8467,
8424,
8472,
8423,
8466,
8453,
8461,
8447,
8420,
8431,
8436,
8446,
8421,
8458,
8457,
8471,
8434,
8426,
8451,
8439,
8449,
8465,
8464,
8473,
8432,
8468,
8429,
8450,
8470,
8440,
8460,
8459,
8427,
8452,
8443,
8444,
8456,
8419,
8435,
-1,
-1,
-1,
-1,
-1,
7464,
7475,
7474,
7471,
7469,
7466,
7468,
7472,
7465,
]

_charnames_127744 = [
1860,
13220,
2380,
12364,
8629,
8628,
2426,
8633,
12864,
5211,
13291,
8220,
9562,
3838,
3837,
3836,
10447,
12181,
13297,
13184,
13296,
13224,
13302,
5884,
13303,
2445,
12180,
13183,
5883,
13223,
8631,
10446,
8710,
]

_charnames_127792 = [
2317,
8864,
3861,
12568,
10825,
2196,
-1,
7541,
2315,
12850,
12060,
8634,
5311,
3842,
3841,
12018,
13214,
9290,
13171,
6470,
9553,
7486,
10066,
10314,
9543,
13294,
7204,
6468,
5043,
10911,
12727,
10309,
10863,
10864,
2316,
8846,
11877,
8875,
9544,
10892,
12821,
12822,
1629,
1232,
8848,
8830,
5215,
13233,
12854,
12630,
11701,
8637,
13232,
13188,
8860,
8705,
13013,
12495,
1628,
2326,
2131,
6542,
1237,
12039,
8709,
5342,
10900,
1627,
13218,
7358,
8411,
13319,
1634,
7494,
5348,
2385,
5048,
-1,
-1,
-1,
12823,
13328,
5351,
13141,
2325,
13173,
13179,
13180,
4961,
10820,
1623,
7205,
2434,
10912,
13138,
2184,
13320,
9128,
8886,
10315,
]

_charnames_127904 = [
2185,
13237,
12852,
13187,
9561,
9127,
2427,
12006,
9900,
7483,
2425,
7459,
2388,
10856,
8209,
12619,
8874,
5356,
10528,
5329,
13199,
9551,
9554,
8409,
10524,
9552,
7508,
8212,
9550,
12781,
7354,
8892,
5051,
2318,
8880,
12782,
8638,
-1,
7495,
12023,
10074,
12783,
8896,
]

_charnames_127968 = [
12032,
12031,
11700,
13135,
3855,
12040,
5037,
10064,
12035,
6534,
1624,
8885,
12569,
13167,
13014,
13139,
3856,
]

_charnames_128000 = [
12870,
9119,
11698,
13293,
1630,
7454,
6467,
12868,
2188,
12624,
2438,
13287,
8883,
8882,
12021,
12871,
10525,
8714,
9105,
12851,
2323,
12509,
10906,
5332,
3850,
11702,
8833,
5217,
10054,
12038,
5885,
13186,
7493,
5310,
7540,
11878,
5047,
13230,
5352,
10861,
11339,
10904,
12623,
5057,
12512,
9120,
1631,
7455,
12869,
2189,
12625,
8831,
12024,
9106,
12510,
10909,
13231,
11876,
13316,
5347,
10836,
10908,
10833,
-1,
3852,
-1,
3832,
12358,
9121,
7485,
13282,
13246,
13264,
13281,
13189,
13299,
11699,
7521,
7522,
2387,
11682,
2437,
13310,
3853,
12250,
7542,
13143,
12627,
11336,
5357,
13311,
10920,
11872,
10893,
9240,
10069,
12055,
13309,
13312,
13219,
5258,
5257,
5328,
10526,
9201,
13307,
13174,
9239,
7531,
7530,
10897,
13313,
5212,
10845,
9238,
9237,
11539,
11538,
5044,
1619,
10886,
13136,
13137,
10527,
5049,
3860,
9729,
12969,
8893,
12965,
10522,
12631,
6305,
12362,
13166,
11880,
5054,
8786,
10914,
11335,
6533,
12818,
10508,
11331,
5330,
1616,
13325,
5346,
5214,
7532,
8828,
10316,
12001,
5307,
10307,
13387,
10921,
12000,
12720,
12002,
12609,
3848,
10059,
5331,
8873,
1632,
8832,
12622,
12632,
10915,
13202,
12616,
8824,
7524,
13275,
12064,
9109,
1233,
11990,
2446,
5039,
5042,
5041,
5040,
9108,
2310,
8869,
10852,
5213,
9557,
13200,
11685,
12633,
13193,
11683,
10830,
10831,
2195,
7357,
2186,
2309,
2311,
5055,
2384,
10923,
12849,
10835,
8845,
7499,
5326,
6469,
12356,
12357,
2382,
11684,
10308,
5308,
11671,
5327,
12361,
8887,
9542,
7351,
10832,
13172,
8410,
10924,
2319,
11697,
12968,
10837,
3865,
12967,
3858,
2379,
2378,
11679,
11680,
10902,
10903,
12182,
9122,
9124,
8213,
9125,
12354,
10056,
2194,
-1,
8210,
7349,
12866,
8211,
-1,
-1,
-1,
7533,
2373,
2374,
2375,
10055,
6540,
12058,
8820,
8816,
8819,
8818,
5035,
3847,
6465,
12816,
6539,
2381,
11337,
6538,
11681,
5343,
5344,
5325,
6148,
12867,
5058,
3859,
11694,
8859,
7478,
12353,
11338,
12955,
12953,
12957,
12956,
12954,
13177,
3846,
13327,
11874,
12363,
12041,
10916,
9560,
7350,
2443,
8898,
13134,
7501,
5267,
13257,
5875,
5874,
5868,
5873,
8810,
8811,
13377,
12508,
13376,
12507,
]

_charnames_128336 = [
2368,
2335,
2341,
2355,
2358,
2348,
2351,
2365,
2371,
2344,
2362,
2338,
2367,
2334,
2340,
2354,
2357,
2347,
2350,
2364,
2370,
2343,
2361,
2337,
]

_charnames_128507 = [
9118,
7487,
8837,
8899,
9126,
-1,
10311,
13156,
8792,
8795,
8796,
8794,
8800,
8798,
13318,
8803,
13164,
12726,
8799,
8802,
8807,
12248,
-1,
13381,
13160,
10860,
-1,
1622,
-1,
13165,
-1,
11333,
-1,
13151,
13152,
12612,
-1,
10058,
10890,
2441,
10853,
13159,
12613,
-1,
-1,
13238,
13323,
8872,
7456,
-1,
6541,
-1,
-1,
13154,
13163,
10072,
13207,
-1,
12617,
13161,
13158,
10312,
2192,
8805,
8806,
2191,
11334,
10891,
2442,
13324,
-1,
-1,
-1,
-1,
13157,
13155,
10851,
8865,
12003,
8821,
11879,
10849,
10850,
10847,
10848,
]

_charnames_128640 = [
12853,
12017,
8849,
12865,
12053,
12054,
7506,
9536,
6306,
8838,
7504,
7505,
5255,
11691,
7496,
5259,
9558,
10075,
13181,
10895,
11690,
7206,
11689,
10063,
11692,
12728,
12570,
9901,
7507,
9104,
9115,
8636,
9116,
9983,
8712,
12848,
8823,
12026,
8199,
1620,
10896,
7500,
12511,
12350,
8812,
12351,
10922,
12513,
10899,
12359,
5355,
12355,
5354,
9117,
10865,
12352,
2322,
9541,
13314,
12725,
5046,
7488,
13292,
8708,
5033,
5034,
10834,
1236,
5059,
6451,
]

_charnames_128768 = [
9713,
9609,
9726,
9727,
9711,
9598,
9596,
9597,
9594,
9595,
9659,
9662,
9661,
9576,
9676,
9655,
9686,
9689,
9688,
9629,
9578,
9716,
9664,
9665,
9644,
9645,
9723,
9589,
9706,
9707,
9621,
9640,
9627,
9708,
9573,
9619,
9620,
9628,
9580,
9571,
9666,
9680,
9720,
9607,
9574,
9581,
9572,
9663,
9638,
9639,
9632,
9636,
9635,
9634,
9600,
9601,
9691,
9582,
9606,
9641,
9642,
9604,
9656,
9681,
9682,
9714,
9647,
9650,
9649,
9602,
9725,
9587,
9679,
9722,
9710,
9669,
9624,
9683,
9623,
9590,
9625,
9684,
9586,
9719,
9588,
9724,
9695,
9605,
9671,
9654,
9670,
9608,
9584,
9585,
9575,
9675,
9703,
9701,
9702,
9674,
9673,
9612,
9617,
9616,
9615,
9614,
9603,
9653,
9652,
9643,
9694,
9717,
9704,
9690,
9698,
9697,
]

_charnames_917760 = [
7916,
7905,
7894,
8049,
8038,
8027,
8016,
8005,
8060,
8071,
8070,
8069,
8068,
8148,
8147,
8146,
8145,
8144,
8143,
8142,
8141,
8140,
8139,
8137,
8136,
8135,
8134,
8133,
8132,
8131,
8130,
8129,
8128,
8126,
8125,
8124,
8123,
8122,
8121,
8120,
8119,
8118,
8117,
8115,
8114,
8113,
8112,
8111,
8110,
8109,
8108,
8107,
8106,
8104,
8103,
8102,
8101,
8100,
8099,
8098,
8097,
8096,
8095,
8093,
8092,
8091,
8090,
8089,
8088,
8087,
8086,
8085,
8084,
8082,
8081,
8080,
8079,
8078,
8077,
8076,
8075,
8074,
8073,
8003,
8002,
8001,
8000,
7999,
7998,
7997,
7996,
7995,
7994,
7992,
7991,
7990,
7989,
7988,
7987,
7986,
7985,
7984,
7983,
7981,
7980,
7979,
7978,
7977,
7976,
7975,
7974,
7973,
7972,
7970,
7969,
7968,
7967,
7966,
7965,
7964,
7963,
7962,
7961,
7959,
7958,
7957,
7956,
7955,
7954,
7953,
7952,
7951,
7950,
7948,
7947,
7946,
7945,
7944,
7943,
7942,
7941,
7940,
7939,
7937,
7936,
7935,
7934,
7933,
7932,
7931,
7930,
7929,
7928,
7926,
7925,
7924,
7923,
7922,
7921,
7920,
7919,
7918,
7917,
7915,
7914,
7913,
7912,
7911,
7910,
7909,
7908,
7907,
7906,
7904,
7903,
7902,
7901,
7900,
7899,
7898,
7897,
7896,
7895,
8059,
8058,
8057,
8056,
8055,
8054,
8053,
8052,
8051,
8050,
8048,
8047,
8046,
8045,
8044,
8043,
8042,
8041,
8040,
8039,
8037,
8036,
8035,
8034,
8033,
8032,
8031,
8030,
8029,
8028,
8026,
8025,
8024,
8023,
8022,
8021,
8020,
8019,
8018,
8017,
8015,
8014,
8013,
8012,
8011,
8010,
8009,
8008,
8007,
8006,
8067,
8066,
8065,
8064,
8063,
8062,
8061,
]

_charnames_983040 = [
5798,
5610,
11329,
5878,
5879,
5880,
5881,
7429,
13386,
10871,
5358,
]

_charnames_983552 = [
5695,
5467,
5658,
5397,
5660,
5399,
5661,
5400,
5669,
5408,
5670,
5409,
5715,
5450,
5445,
5561,
5748,
5494,
5750,
5496,
5751,
5497,
5740,
5430,
5732,
5513,
5693,
5464,
5692,
5463,
5664,
5403,
5663,
5402,
5667,
5406,
5666,
5405,
5444,
5443,
5714,
5448,
5713,
5447,
5813,
5627,
5757,
5524,
5785,
5572,
5721,
5479,
5736,
5517,
5735,
5516,
5733,
5514,
5731,
5512,
5474,
5505,
5506,
5369,
5370,
5437,
5438,
5589,
5590,
5337,
6877,
6866,
6885,
6865,
6874,
6863,
6873,
6862,
6881,
6882,
6879,
6875,
6870,
6880,
6872,
6871,
6876,
6864,
6883,
6869,
6868,
6867,
6884,
6878,
6708,
6713,
6714,
6709,
6710,
6715,
6716,
6707,
6711,
6712,
6706,
6591,
6596,
6597,
6592,
6593,
6598,
6599,
6590,
6594,
6595,
6589,
6851,
6856,
6857,
6852,
6853,
6858,
6859,
6850,
6854,
6855,
6849,
6578,
6583,
6584,
6579,
6580,
6585,
6586,
6577,
6581,
6582,
6576,
6722,
6727,
6728,
6723,
6724,
6729,
6730,
6721,
6725,
6726,
6720,
6565,
6570,
6571,
6566,
6567,
6572,
6573,
6564,
6568,
6569,
6563,
6734,
6739,
6740,
6735,
6736,
6741,
6742,
6733,
6737,
6738,
6732,
6603,
6608,
6609,
6604,
6605,
6610,
6611,
6602,
6606,
6607,
6601,
6799,
6804,
6805,
6800,
6801,
6806,
6807,
6798,
6802,
6803,
6797,
6812,
6817,
6818,
6813,
6814,
6819,
6820,
6811,
6815,
6816,
6810,
6773,
6778,
6779,
6774,
6775,
6780,
6781,
6772,
6776,
6777,
6771,
6760,
6765,
6766,
6761,
6762,
6767,
6768,
6759,
6763,
6764,
6758,
6682,
6687,
6688,
6683,
6684,
6689,
6690,
6681,
6685,
6686,
6680,
6786,
6791,
6792,
6787,
6788,
6793,
6794,
6785,
6789,
6790,
6784,
6658,
6663,
6664,
6659,
6660,
6665,
6666,
6657,
6661,
6662,
6656,
6670,
6675,
6676,
6671,
6672,
6677,
6678,
6669,
6673,
6674,
6668,
6748,
6753,
6754,
6749,
6750,
6755,
6756,
6747,
6751,
6752,
6746,
6553,
6558,
6559,
6554,
6555,
6560,
6561,
6552,
6556,
6557,
6551,
6825,
6830,
6831,
6826,
6827,
6832,
6833,
6824,
6828,
6829,
6823,
6617,
6622,
6623,
6618,
6619,
6624,
6625,
6616,
6620,
6621,
6615,
6631,
6636,
6637,
6632,
6633,
6638,
6639,
6630,
6634,
6635,
6629,
6643,
6648,
6649,
6644,
6645,
6650,
6651,
6642,
6646,
6647,
6641,
6838,
6843,
6844,
6839,
6840,
6845,
6846,
6837,
6841,
6842,
6836,
6693,
6696,
6701,
6702,
6697,
6698,
6703,
6704,
6695,
6699,
6700,
6694,
6626,
10501,
11022,
11020,
11021,
11019,
11015,
11028,
11026,
11027,
11025,
11013,
11043,
11006,
11042,
11005,
11016,
11011,
11009,
11010,
11008,
11014,
11049,
11036,
11037,
11035,
11047,
11044,
11046,
11039,
11045,
11031,
11030,
11032,
11048,
11040,
11058,
11054,
11051,
11052,
11055,
11057,
11059,
12049,
12047,
12045,
12048,
12046,
11312,
11310,
11308,
11311,
11309,
11319,
11316,
11317,
11318,
9061,
9055,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 5539
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 5376
    elif code == 687: res = 5377
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 893: res = _charnames_880[code-880]
    elif code == 975: res = 10268
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1289
    elif code == 1231: res = 1698
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1319: res = _charnames_1296[code-1296]
    elif code == 1442: res = 12014
    elif code == 1466: res = 12011
    elif code == 1477: res = 12013
    elif code == 1478: res = 12012
    elif code == 1479: res = 12010
    elif 1536 <= code <= 1568: res = _charnames_1536[code-1536]
    elif code == 1595: res = 9758
    elif code == 1596: res = 9756
    elif code == 1597: res = 9747
    elif code == 1598: res = 9745
    elif code == 1599: res = 9746
    elif 1622 <= code <= 1631: res = _charnames_1622[code-1622]
    elif code == 1774: res = 9814
    elif code == 1775: res = 9796
    elif code == 1791: res = 9774
    elif code == 1837: res = 8785
    elif code == 1838: res = 8783
    elif code == 1839: res = 8784
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2142: res = _charnames_1984[code-1984]
    elif code == 2304: res = 12543
    elif code == 2308: res = 12527
    elif code == 2362: res = 12552
    elif code == 2363: res = 12551
    elif 2382 <= code <= 2391: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2431: res = _charnames_2417[code-2417]
    elif code == 2493: res = 5339
    elif code == 2510: res = 5338
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 10519
    elif code == 2677: res = 10517
    elif code == 2700: res = 10513
    elif code == 2785: res = 10514
    elif code == 2786: res = 10511
    elif code == 2787: res = 10512
    elif code == 2801: res = 10515
    elif code == 2869: res = 11670
    elif code == 2884: res = 11667
    elif code == 2914: res = 11665
    elif code == 2915: res = 11666
    elif 2929 <= code <= 2935: res = _charnames_2929[code-2929]
    elif code == 2998: res = 6896
    elif code == 3024: res = 6893
    elif code == 3046: res = 6888
    elif 3059 <= code <= 3066: res = _charnames_3059[code-3059]
    elif code == 3133: res = 7344
    elif code == 3160: res = 7346
    elif code == 3161: res = 7347
    elif code == 3170: res = 7340
    elif code == 3171: res = 7341
    elif 3192 <= code <= 3199: res = _charnames_3192[code-3192]
    elif code == 3260: res = 11324
    elif code == 3261: res = 11326
    elif code == 3298: res = 11327
    elif code == 3299: res = 11328
    elif code == 3313: res = 11325
    elif code == 3314: res = 11323
    elif code == 3369: res = 9252
    elif 3386 <= code <= 3396: res = _charnames_3386[code-3386]
    elif code == 3406: res = 9253
    elif code == 3426: res = 9255
    elif code == 3427: res = 9256
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif code == 3947: res = 7446
    elif code == 3948: res = 7445
    elif code == 3980: res = 7443
    elif code == 3981: res = 7439
    elif code == 3982: res = 7438
    elif code == 3983: res = 7440
    elif 4046 <= code <= 4058: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif code == 4345: res = 10502
    elif code == 4346: res = 10503
    elif code == 4348: res = 9096
    elif code == 4442: res = 11870
    elif code == 4443: res = 11860
    elif code == 4444: res = 11862
    elif code == 4445: res = 11861
    elif code == 4446: res = 11844
    elif code == 4515: res = 11822
    elif code == 4516: res = 11806
    elif code == 4517: res = 11805
    elif code == 4518: res = 11809
    elif code == 4519: res = 11810
    elif code == 4602: res = 11766
    elif code == 4603: res = 11765
    elif code == 4604: res = 11769
    elif code == 4605: res = 11767
    elif code == 4606: res = 11768
    elif code == 4607: res = 11718
    elif code == 4615: res = 3812
    elif code == 4679: res = 3776
    elif code == 4743: res = 3766
    elif code == 4783: res = 3786
    elif code == 4815: res = 3808
    elif code == 4847: res = 3807
    elif code == 4879: res = 3686
    elif code == 4895: res = 3684
    elif code == 4935: res = 3744
    elif code == 4957: res = 3830
    elif code == 4958: res = 3831
    elif code == 4959: res = 3829
    elif code == 4960: res = 3813
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif code == 5120: res = 2129
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif code == 6109: res = 11001
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6829: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7155: res = _charnames_6912[code-6912]
    elif 7164 <= code <= 7295: res = _charnames_7164[code-7164]
    elif 7376 <= code <= 7410: res = _charnames_7376[code-7376]
    elif 7424 <= code <= 7654: res = _charnames_7424[code-7424]
    elif code == 7676: res = 1327
    elif code == 7677: res = 1408
    elif code == 7678: res = 1366
    elif code == 7679: res = 1378
    elif code == 7836: res = 5532
    elif code == 7837: res = 5531
    elif code == 7838: res = 5744
    elif code == 7839: res = 5542
    elif code == 7930: res = 5783
    elif code == 7931: res = 5577
    elif code == 7932: res = 5782
    elif code == 7933: res = 5576
    elif code == 7934: res = 5805
    elif code == 7935: res = 5624
    elif 8275 <= code <= 8292: res = _charnames_8275[code-8275]
    elif 8336 <= code <= 8348: res = _charnames_8336[code-8336]
    elif 8370 <= code <= 8377: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1370
    elif code == 8428: res = 1383
    elif code == 8429: res = 1369
    elif code == 8430: res = 1367
    elif code == 8431: res = 1381
    elif code == 8432: res = 1404
    elif code == 8507: res = 13168
    elif code == 8508: res = 12494
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif code == 8580: res = 5487
    elif code == 8581: res = 12838
    elif code == 8582: res = 12837
    elif code == 8583: res = 12836
    elif code == 8584: res = 12839
    elif code == 8585: res = 8219
    elif 9167 <= code <= 9203: res = _charnames_9167[code-9167]
    elif code == 9471: res = 12246
    elif code == 9748: res = 13383
    elif code == 9749: res = 12036
    elif code == 9752: res = 8706
    elif code == 9854: res = 10855
    elif code == 9855: res = 13286
    elif 9866 <= code <= 9995: res = _charnames_9866[code-9866]
    elif code == 10024: res = 8829
    elif 10060 <= code <= 10071: res = _charnames_10060[code-10060]
    elif code == 10079: res = 11986
    elif code == 10080: res = 11987
    elif code == 10133: res = 11993
    elif code == 10134: res = 11995
    elif code == 10135: res = 11991
    elif code == 10160: res = 1234
    elif 10175 <= code <= 10191: res = _charnames_10175[code-10175]
    elif code == 10220: res = 9280
    elif code == 10221: res = 9277
    elif code == 10222: res = 9281
    elif code == 10223: res = 9278
    elif 11008 <= code <= 11097: res = _charnames_11008[code-11008]
    elif 11264 <= code <= 11505: res = _charnames_11264[code-11264]
    elif 11513 <= code <= 11557: res = _charnames_11513[code-11513]
    elif 11568 <= code <= 11621: res = _charnames_11568[code-11568]
    elif code == 11631: res = 7423
    elif code == 11632: res = 7422
    elif 11647 <= code <= 11670: res = _charnames_11647[code-11647]
    elif 11680 <= code <= 11825: res = _charnames_11680[code-11680]
    elif code == 12589: res = 5322
    elif 12728 <= code <= 12771: res = _charnames_12728[code-12728]
    elif code == 12829: res = 10817
    elif code == 12830: res = 10818
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 2419
    elif code == 12925: res = 2418
    elif code == 12926: res = 2424
    elif code == 13004: res = 8546
    elif code == 13005: res = 8549
    elif code == 13006: res = 8548
    elif code == 13007: res = 6239
    elif code == 13175: res = 8539
    elif code == 13176: res = 8541
    elif code == 13177: res = 8542
    elif code == 13178: res = 8551
    elif code == 13278: res = 8550
    elif code == 13279: res = 8554
    elif code == 13311: res = 8552
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42611: res = _charnames_42560[code-42560]
    elif 42620 <= code <= 42647: res = _charnames_42620[code-42620]
    elif 42656 <= code <= 42743: res = _charnames_42656[code-42656]
    elif 42752 <= code <= 42897: res = _charnames_42752[code-42752]
    elif 42912 <= code <= 42921: res = _charnames_42912[code-42912]
    elif 43002 <= code <= 43127: res = _charnames_43002[code-43002]
    elif 43136 <= code <= 43204: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43487: res = _charnames_43359[code-43359]
    elif 43520 <= code <= 43574: res = _charnames_43520[code-43520]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif code == 43739: res = 7148
    elif code == 43740: res = 7151
    elif code == 43741: res = 7150
    elif code == 43742: res = 7152
    elif code == 43743: res = 7149
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43822: res = _charnames_43808[code-43808]
    elif 43968 <= code <= 44025: res = _charnames_43968[code-43968]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif code == 65021: res = 9827
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif code == 65060: res = 1391
    elif code == 65061: res = 1390
    elif code == 65062: res = 1294
    elif code == 65095: res = 10875
    elif code == 65096: res = 10872
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65947: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66432 <= code <= 66517: res = _charnames_66432[code-66432]
    elif code == 66598: res = 12564
    elif code == 66599: res = 12565
    elif 66638 <= code <= 66729: res = _charnames_66638[code-66638]
    elif 67584 <= code <= 67679: res = _charnames_67584[code-67584]
    elif 67840 <= code <= 67903: res = _charnames_67840[code-67840]
    elif 68096 <= code <= 68167: res = _charnames_68096[code-68096]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68223: res = _charnames_68192[code-68192]
    elif 68352 <= code <= 68479: res = _charnames_68352[code-68352]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69760 <= code <= 69825: res = _charnames_69760[code-69760]
    elif 73728 <= code <= 74606: res = _charnames_73728[code-73728]
    elif 74752 <= code <= 74850: res = _charnames_74752[code-74752]
    elif code == 74864: res = 1229
    elif code == 74865: res = 1228
    elif code == 74866: res = 1227
    elif code == 74867: res = 1226
    elif 77824 <= code <= 78894: res = _charnames_77824[code-77824]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif code == 110592: res = 11320
    elif code == 110593: res = 12050
    elif code == 119081: res = 9549
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119665: res = _charnames_119648[code-119648]
    elif code == 120001: res = 9288
    elif code == 120484: res = 9284
    elif code == 120485: res = 9283
    elif code == 120778: res = 9287
    elif code == 120779: res = 9286
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127136 <= code <= 127199: res = _charnames_127136[code-127136]
    elif 127232 <= code <= 127386: res = _charnames_127232[code-127232]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127504 <= code <= 127560: res = _charnames_127504[code-127504]
    elif code == 127568: res = 2410
    elif code == 127569: res = 2411
    elif 127744 <= code <= 127776: res = _charnames_127744[code-127744]
    elif 127792 <= code <= 127891: res = _charnames_127792[code-127792]
    elif 127904 <= code <= 127946: res = _charnames_127904[code-127904]
    elif 127968 <= code <= 127984: res = _charnames_127968[code-127968]
    elif 128000 <= code <= 128317: res = _charnames_128000[code-128000]
    elif 128336 <= code <= 128359: res = _charnames_128336[code-128336]
    elif 128507 <= code <= 128591: res = _charnames_128507[code-128507]
    elif 128640 <= code <= 128709: res = _charnames_128640[code-128640]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983050: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983969: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCB or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCB or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Mc', 'L', 'N', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7168),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4288),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcdddefghidjdkddddddddddddddd\x15\x15\x15lmddddddddddd\x15\x15\x15\x15nddddddddddd'
'dddddddddddddddddddddddddddddddddddddddd\x15\x15oddddddddddddddddddddd'
'ddddddddddddddddddddddddddddddddddddddddddddddddpddddddddddddddd'
'ddddddddddddddddqrstuvwxddddddddddddddddddddddddyz{|}~\x7f\x80dddddddd'
'\x81\x825555555\x83\x84\x8555555555555555555555555\x8655555\x8755555555555555555\x885555'
'5555555555555555555555555555555555\x8955555555555555555555555555555'
'55555555555555555555555555555555555555\x8a5555555555555555\x8b\x8c\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x865\x8c\x8d\x8d\x8d\x8d\x8e'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8e'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'\x8f\x90dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x91'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x91'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xc9\x85\x85z\x97z\x85\x86\x8fd\x85\xa4sZts;;;;;;;;;;t\x85\xb2\xb1\xb2\x85'
'\x8500000000000000000000000000\x8f\x85d\x9eW\x9e\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x8f\xb1d\xb1\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xc6}\x97\x97\x93\x97\xc2\xbe\x9b\xc1\x14m\xb1\x06\xbe\x9e\xb6\xa6II\x9b\x16\xbe\x7f\x9bI\x14iNNN}'
'//////-/////////-//////\xa9-/////-\x14\x14\x14\x16\x16\x16\x16\x14\x16\x14\x14\x14\x16\x14\x14\x16\x16\x14\x16\x14\x14\x16\x16\x16\xa9\x14\x14\x14\x16\x14\x16\x14\x16'
'/\x14/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x14/\x14/\x16/\x16/\x16/\x14/\x16/\x16/\x16/\x16/\x16-\x14/\x16/\x14/\x16/\x16/\x14-\x14/\x16/\x16\x14/\x16/\x16/\x16-'
'\x14-\x14/\x14/\x16/\x14\x14-\x14/\x14/\x16/\x16-\x14/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16-\x14/\x16/\x14/\x16/\x16/\x16/\x16/\x16/\x16//\x16/\x16/\x16\x16'
'\x16//\x16/\x16//\x16///\x16\x16////\x16//\x16///\x16\x16\x16//\x16//\x16/\x16/\x16//\x16/\x16\x16/\x16//\x16///\x16/\x16//\x16\x16(/\x16\x16\x16'
'((((/,\x16/,\x16/,\x16/\x14/\x14/\x14/\x14/\x14/\x14/\x14/\x14\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16/,\x16/\x16///\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16\x16\x16\x16\x16//\x16//\x16'
'\x16/\x16////\x16/\x16/\x16/\x16/\x16\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16(\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e""\x1d\x1d\x1d\x1d\x1d'
'\x1e\x1e\x9d\x9d\x9b\x9d" "   " ""\x19\x1d\x9d\x9d\x9d\x9d\x9d\x9d\x9b\x9b\x9b\x9b\x9d\x9b\x9d\x9b\x1e\x1e\x1e\x1e\x1e\x9d\x9d\x9d\x9d\x9d\x9d\x9d"\x9d\x1d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d'
'4444444444444444444444444444444444444444444444444444444444444444'
'444445444444444444444444444444444444444444444444/\x16/\x16"\x9d/\x16\x10\x10\x1c\x16\x16\x16\x83\x10'
'\x10\x10\x10\x10\x9d\x9d/\x84///\x10/\x10//\x16-----------------\x10-------//\x16\x16\x16\x16\x16\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x16\x14\x14\x14\x14\x14\x14\x14\x16\x16\x16\x16\x16/\x16\x16///\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16\x16\x16/\x16\xae/\x16//\x16\x16///'
'/-//////////////--------------------------------\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16\xbc6666622/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'//\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10///////////////'
'///////////////////////\x10\x10\x1d||||||\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x10|]\x10\x10\x10\x10\x10\x10666666666666666666666666666666666666666666666_6'
'\x8966\x8966\x896\x10\x10\x10\x10\x10\x10\x10\x10+++++++++++++++++++++++++++\x10\x10\x10\x10\x10+++\x89\x8a\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x05\x05\x05\x05\x10\x10\xae\xae\xa0yy\x92rn\xc1\xc166666666666n\x10\x10nn%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'\x18%%%%%%%%%%6666666666666666666668888888888yoon%%6%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%n%6666666\x05\xc1666666\x18\x1866\xc16666%%::::::::::%%%\xb5\xb5%'
'nnnnnnnnnnnnnn\x10\x05%6%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%6666666666666666'
'66666666666\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%66666666666%\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'==========+++++++++++++++++++++++++++++++++666666666##\xc1\x83\x83\x83#\x10\x10\x10\x10\x10'
'++++++++++++++++++++++6666#666666666#666#66666\x10\x10\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x10'
'+++++++++++++++++++++++++666\x10\x10\x89\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'6661((((((((((((((((((((((((((((((((((((((((((((((((((((((616(11'
'1666666661111611(6666666((((((((((66||<<<<<<<<<<|\x1d((((((\x10((((((('
'\x10611\x10((((((((\x10\x10((\x10\x10((((((((((((((((((((((\x10(((((((\x10(\x10\x10\x10((((\x10\x106(11'
'16666\x10\x1011\x10\x10116(\x10\x10\x10\x10\x10\x10\x10\x101\x10\x10\x10\x10((\x10(((66\x10\x10<<<<<<<<<<((\x96\x96KKKKKK\xbc\x96\x10\x10\x10\x10'
'\x10661\x10((((((\x10\x10\x10\x10((\x10\x10((((((((((((((((((((((\x10(((((((\x10((\x10((\x10((\x10\x106\x1011'
'166\x10\x10\x10\x1066\x10\x10666\x10\x10\x106\x10\x10\x10\x10\x10\x10\x10((((\x10(\x10\x10\x10\x10\x10\x10\x10<<<<<<<<<<66(((6\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10661\x10(((((((((\x10(((\x10((((((((((((((((((((((\x10(((((((\x10((\x10(((((\x10\x106(11'
'166666\x10661\x10116\x10\x10(\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10((66\x10\x10<<<<<<<<<<\x10\x96\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10611\x10((((((((\x10\x10((\x10\x10((((((((((((((((((((((\x10(((((((\x10((\x10(((((\x10\x106(16'
'16666\x10\x1011\x10\x10116\x10\x10\x10\x10\x10\x10\x10\x1061\x10\x10\x10\x10((\x10(((66\x10\x10<<<<<<<<<<\xbc(KKKKKK\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x106(\x10((((((\x10\x10\x10(((\x10((((\x10\x10\x10((\x10(\x10((\x10\x10\x10((\x10\x10\x10(((\x10\x10\x10((((((((((((\x10\x10\x10\x1011'
'611\x10\x10\x10111\x101116\x10\x10(\x10\x10\x10\x10\x10\x101\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10<<<<<<<<<<KKK\xc1\xc1\xc1\xc1\xc1\xc1\x96\xc1\x10\x10\x10\x10\x10'
'\x10111\x10((((((((\x10(((\x10(((((((((((((((((((((((\x10((((((((((\x10(((((\x10\x10\x10(66'
'61111\x10666\x106666\x10\x10\x10\x10\x10\x10\x1066\x10((\x10\x10\x10\x10\x10\x10((66\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10\x10\x10PPPPPPP\xbc'
'\x10\x1011\x10((((((((\x10(((\x10(((((((((((((((((((((((\x10((((((((((\x10(((((\x10\x106(13'
'11111\x10311\x101166\x10\x10\x10\x10\x10\x10\x1011\x10\x10\x10\x10\x10\x10\x10(\x10((66\x10\x10<<<<<<<<<<\x10((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x1011\x10((((((((\x10(((\x10(((((((((((((((((((((((((((((((((((((((((\x10\x10(11'
'16666\x10111\x101116(\x10\x10\x10\x10\x10\x10\x10\x101\x10\x10\x10\x10\x10\x10\x10\x10((66\x10\x10<<<<<<<<<<KKKKKK\x10\x10\x10\xbc(((((('
'\x10\x1011\x10((((((((((((((((((\x10\x10\x10((((((((((((((((((((((((\x10(((((((((\x10(\x10\x10'
'(((((((\x10\x10\x106\x10\x10\x10\x10111666\x106\x1011111111\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x1011|\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"\x10((((((((((((((((((((((((((((((((((((((((((((((((6('6666666\x10\x10\x10\x10\x96"
'((((((\x1d66666666|<<<<<<<<<<||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"\x10((\x10(\x10\x10((\x10(\x10\x10(\x10\x10\x10\x10\x10\x10((((\x10(((((((\x10(((\x10(\x10(\x10\x10((\x10((((6('666666\x1066(\x10\x10"
'(((((\x10\x1d\x10666666\x10\x10<<<<<<<<<<\x10\x10((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(\xbc\xbc\xbc|||||||||||||||\xbc\xbc\xbc\xbc\xbc66\xbc\xbc\xbc\xbc\xbc\xbc<<<<<<<<<<KKKKKKKKKK\xbc6\xbc6\xbc6\x8ec\x8ec11'
'((((((((\x10((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10666666666666661'
'66666|66(((((66666666666\x10666666666666666666666666666666666666\x10\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc6\xbc\xbc\xbc\xbc\xbc\xbc\x10\xbc\xbc|||||\xbc\xbc\xbc\xbc||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((11666616666661661166('
'<<<<<<<<<<||||||((((((1166((((666(111((1111111(((6666((((((((((('
'((611661111116(1<<<<<<<<<<1116\xbc\xbc////////////////////////////////'
'//////\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((((((((((((((|\x1d\x10\x10\x10'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))(((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((()))))(((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((())))))'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((\x10((((\x10\x10(((((((\x10(\x10((((\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((\x10((((\x10\x10(((((((((((((((((((((((((((((((((\x10((((\x10\x10(((((((\x10'
'(\x10((((\x10\x10(((((((((((((((\x10(((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((\x10((((\x10\x10(((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((\x10\x10666\xbc||||||||LLLLLLLLLKKKKKKKKKKK\x10\x10\x10'
'((((((((((((((((\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
']((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((||((((((((((((((((('
'\xc8((((((((((((((((((((((((((\x8ec\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((|||AAA\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((\x10((((666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10((((((((((((((((((666||\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((66\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((\x10(((\x1066\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((((((((((\x08\x081666666611'
'11111161166666666666|||\x1d|||\x96(6\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10PPPPPPPPPP\x10\x10\x10\x10\x10\x10'
'\x83\x83\x83\x83\x83\x83]\x83\x83\x83\x83666\xc8\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((\x1d((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((6(\x10\x10\x10\x10\x10(((((((((((((((('
'((((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((\x10\x10\x10666111166111\x10\x10\x10\x10116111111666\x10\x10\x10\x10'
'\xc1\x10\x10\x10\x83\x83<<<<<<<<<<((((((((((((((((((((((((((((((\x10\x10(((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x101111111111111111'
'1(((((((11\x10\x10\x10\x10\x10\x10<<<<<<<<<<L\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'(((((((((((((((((((((((66111\x10\x10||(((((((((((((((((((((((((((((((('
'(((((((((((((((((((((1616666666\x1061611666666661111116666666666\x10\x106'
'<<<<<<<<<<\x10\x10\x10\x10\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10|||||||\x1d||||||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'66661(((((((((((((((((((((((((((((((((((((((((((((((616666616111'
'11611(((((((\x10\x10\x10\x10<<<<<<<<<<|||||||\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc666666666\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\x10'
'661((((((((((((((((((((((((((((((1666611661\x10\x10\x10((<<<<<<<<<<\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((61661116166611\x10\x10\x10\x10\x10\x10\x10\x10||||'
'((((((((((((((((((((((((((((((((((((11111111666666661166\x10\x10\x10|||||'
'<<<<<<<<<<\x10\x10\x10(((<<<<<<<<<<((((((((((((((((((((((((((((((\x1d\x1d\x1d\x1d\x1d\x1d||'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10666|666666666666616666666((((6((((1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e'
'\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e'
'666666666666666666666666666666666666666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x106666'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16\x16\x16\x16\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16////////\x16\x16\x16\x16\x16\x16\x10\x10//////\x10\x10\x16\x16\x16\x16\x16\x16\x16\x16////////\x16\x16\x16\x16\x16\x16\x16\x16////////'
'\x16\x16\x16\x16\x16\x16\x10\x10//////\x10\x10\x16\x16\x16\x16\x16\x16\x16\x16\x10/\x10/\x10/\x10/\x16\x16\x16\x16\x16\x16\x16\x16////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10'
'\x16\x16\x16\x16\x16\x16\x16\x16,,,,,,,,\x16\x16\x16\x16\x16\x16\x16\x16,,,,,,,,\x16\x16\x16\x16\x16\x16\x16\x16,,,,,,,,\x16\x16\x16\x16\x16\x10\x16\x16////,\x9d\x16\x9d'
'\x9d\x9d\x16\x16\x16\x10\x16\x16////,\x9d\x9d\x9d\x16\x16\x16\x16\x10\x10\x16\x16////\x10\x9d\x9d\x9d\x16\x16\x16\x16\x16\x16\x16\x16/////\x9d\x9d\x9d\x10\x10\x16\x16\x16\x10\x16\x16////,\x9d\x9d\x10'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x07\x07\x07\x08\r\\]]\\\\\\}\x83kh\x8dljg\x8dl}}}\x83~}}~\xc4\xc5\t\x0e\x0c\n\x0f\xc6wywwy}\x83\x83\x83mi}\x83\x83}V'
'V\x83\x83\x83\xa1\x8ec\x83\x83\x83\x83\x83\x83\x83\x83\x83\x83\x83\xae\x83V\x83\x83\x83\x83\x83\x83\x83\x83\x83\x83\xc8\x07\x07\x07\x07\x07\x10\x10\x10\x10\x10\x07\x07\x07\x07\x07\x07J\x1d\x10\x10IJJJJJ\xa3\xa3\xae\x8ec\x19'
'JIIIIJJJJJ\xa3\xa3\xae\x8ec\x10\x1e\x1e\x1e\x1e\x1e\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x10\x10\x10\x96\x96\x96\x96\x96\x96\x96\x96\x96\x95\x96\x96\x93\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10666666666666622226222666666666666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1/\xbe\xc1\xbe\xc1/\xc1\xbe\x16///\x16\x16///\x14\xc1/\xbe\xc1\xb0/////\xc1\xc1\xc1\xbe\xbe\xc1/\xc1-\xc1/\xc1/-//\xb8\x16////\x16((((\x16\xc1\xc1\x16\x16//'
'\xaf\xae\xae\xae\xae/\x16\x16\x16\x16\xc1\xae\xc1\xc1\x16\xbcPPPNNPPPPPPNNNNP>>>>>>>>>>>>BBBB??????????CCCCCC'
'AAA/\x16AAAAN\x10\x10\x10\x10\x10\x10\xa9\xa9\xa9\xa9\xa9\xbe\xbe\xbe\xbe\xbe\xae\xae\xc1\xc1\xc1\xc1\xae\xc1\xc1\xae\xc1\xc1\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xc1\xc1\xa9\xc1\xa9\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xa9\xaf\xaa\xaa\xaf\xae\xae\xa9\xaa\xaf\xaf\xaa\xaf\xaf\xae\xa9\xae\xaa\xa3\xa7\xae\xaa\xaf\xae\xae\xae\xaa\xaf\xaf\xaa\xa9\xaa\xaa\xaf\xaf\xa9\xaf\xa9\xaf\xa9\xa9\xa9\xa9\xaa\xaa\xaf\xaa\xaf\xaf\xaf\xaf\xaf\xa9\xa9\xa9\xa9\xae\xaf\xae\xaf\xaa\xaa\xaf\xaf'
'\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaa\xaf\xaf\xaf\xaa\xae\xae\xae\xae\xae\xaa\xaf\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaa\xa9\xaf\xae\xaa\xaa\xaa\xaa\xaf\xaf\xaa\xaa\xae\xae\xaa\xaa\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xaf\xaf\xaa\xaa\xaf\xaf\xaa\xaa\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xaf\xaf\xae\xae\xa9\xae\xae\xaf\xa9\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xae\xa9\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaa'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xaf\xaf\xaf\xaf\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xaf\xaf\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x91f\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xc1\xae\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10OOOOOOOOONNNNNNNNNNNOOOOOOOOONNN'
'NNNNNNNNIIIIIIIIIHHHHHHHHHHH\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbbQNNNNNNNNNNOOOOOOOOONO'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xbe\xa9\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1'
'\xbe\xa9\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xc1\xc1\xbe\xc1\xc1\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae'
'\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xbe\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xbe\xbe\xbe\xc1\xbe\xbe\xbe\xbe\xc1\xbe\xbe\xc1\xa9\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe'
'\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ecOOOOOOOOON'
'QQQQQQQQQPQQQQQQQQQP\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xaf\xae\xae\xaf\xaf\x8ec\xae\xaf\xaf\xae\x10\xaf\x10\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaf\xaf\xae\xae\xae\xaf\xaf\xaf\xaf\x8fd\x8fd\x8fd\x8fd\x8ec\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xae\xae\xae\x8ec\x8fd\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xae\xae\xae\xae\xae\xae\xae'
'\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xaf\xaf\xae\xae\x8ec\x8ec\xaf\xae\xae\xae\xae\xaf\xae\xaf\xaf\xaf\xae\xae\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\x8ec\xae\xae'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xaf\xaf\xaf\xaf\xae\xae\xaf\xae\xaf\xae\xae\xaf\xae\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaf\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xae'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xae\xaf\xaf\xae\xae\xaf\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xae\xaf\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaf\xaf\xae\xae\xae\xae\xaf\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xaf\xae\xae'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xae\xae\xae\xae\xae\xc1\xc1\xae\xae\xae\xae\xae\xae\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'///////////////////////////////////////////////\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10/\x16///\x16\x16/\x16/\x16/\x16////\x16/\x16\x16/\x16\x16\x16\x16\x16\x16\x16\x1e//'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\xc1\xc1\xc1\xc1\xc1\xc1/\x16/\x16666\x10\x10\x10\x10\x10\x10\x10\x83\x83\x83\x83P\x83\x83'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((('
'((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x1d|\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x106'
'(((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((\x10(((((((\x10(((((((\x10(((((((\x10'
'(((((((\x10(((((((\x10(((((((\x10(((((((\x1066666666666666666666666666666666'
'\x83\x83mimi\x83\x83\x83mi\x83mi\x83\x83\x83\x83\x83\x83\x83\x83\x83]\x83\x83]\x83mi\x83\x83mi\x8ec\x8ec\x8ec\x8ec\x83\x83\x83\x83\x83!\x83\x83\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10'
'\xc7\x87\x87\x87\xc3\x1f)D\x91f\x91f\x91f\x91f\x91f\xc3\xc3\x91f\x91f\x91f\x91f^\x90ee\xc3DDDDDDDDD777777^\x1f\x1f\x1f\x1f\x1f\xc3\xc3DDD\x1f)\x87\xc3\xc1'
'\x10)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))\x10\x1077\x9f\x9f\x1f\x1f)^)))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))))))))))))))))))\x87\x1f\x1f\x1f)'
'\x10\x10\x10\x10\x10)))))))))))))))))))))))))))))))))))))))))\x10\x10\x10)))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))\x10\xbd\xbdMMMM\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd)))))))))))))))))))))))))))\x10\x10\x10\x10\x10'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10))))))))))))))))'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\x10MMMMMMMMMM\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xc3RRRRRRRRRRRRRRR\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xc3\xbd'
'MMMMMMMMMM\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbdRRRRRRRRRRRRRRR'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xc3\xc3\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x10'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xc3\xc3\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3'
')))))*))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))*))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))*))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'*))*)))*)*))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))'
'))))))))))))*)))))))*)*))))))))))))))))))))))))))))))))))))))))*'
'*))))))))))))))))))))))))))))))*))))))))*)))))))))))))))))))))))'
')))))))))))))*))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))*))))))))))))))))))))))))))))))))))*)*)*))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')*)***))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')****)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))))))))*)))))))*))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*)))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))**'
'))))))))))))***)*)))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*)'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))*)))))))))))))))))))))))))))))))))))))))))))))'
'))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))*)))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*)'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))*))))*))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))*))))))))))))))))))))))))))))))'
'))))))*)))))*)))))))))))))))))))))))))))))))))))))))))))*)))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
')))))))))))))))))))))\x1f))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))\x10\x10\x10\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10((((((((((((((((((((((((((((((((((((((((\x1d\x1d\x1d\x1d\x1d\x1d||'
'((((((((((((\x1d\x83\x83\x83((((((((((((((((<<<<<<<<<<((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16(6222\x83\x10\x10\x10\x10\x10\x10\x10\x1066\x83"'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((((((AAAAAAAAAA66||||||\x10\x10\x10\x10\x10\x10\x10\x10'
'\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d"""""""""\x9d\x9d/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x1e\x16\x16\x16\x16\x16\x16\x16\x16/\x16/\x16//\x16'
'/\x16/\x16/\x16/\x16"\x9a\x9a/\x16/\x16\x10/\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10/\x16/\x16/\x16/\x16/\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x16((((('
'((6(((6((((6(((((((((((((((((((((((11661\xc1\xc1\xc1\xc1\x10\x10\x10\x10KKKKKK\xbc\xbc\x96\xb7\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((((((((((\x83\x83\x83\x83\x10\x10\x10\x10\x10\x10\x10\x10'
'11((((((((((((((((((((((((((((((((((((((((((((((((((111111111111'
'11116\x10\x10\x10\x10\x10\x10\x10\x10\x10||<<<<<<<<<<\x10\x10\x10\x10\x10\x10666666666666666666((((((|||(\x10\x10\x10\x10'
'<<<<<<<<<<((((((((((((((((((((((((((((66666666||(((((((((((((((('
'(((((((6666666666611\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10|)))))))))))))))))))))))))))))\x10\x10\x10'
'6661(((((((((((((((((((((((((((((((((((((((((((((((6116666116111'
'1|||||||||||||\x10\x1d<<<<<<<<<<\x10\x10\x10\x10||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((66666611661166\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((6((((((((61\x10\x10<<<<<<<<<<\x10\x10||||((((((((((((((((\x1d((((((\xbc\xbc\xbc(1\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((((((6(666((66(((((66'
'(6(\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10((\x1d||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10((((((\x10\x10((((((\x10\x10((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((\x10(((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((11611611|16\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10))))))))))))))))'
')))))))\x10\x10\x10\x10)))))))))))))))))))))))))))))))))))))))))))))))))\x10\x10\x10\x10'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))*)))))))*))))*)))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))'
')))))))))))))))))*)*)))))))))))))))))))))))))))))))))))))))))*))'
'))))))))))))))))))))))))))))))))))))))))))))))\x11\x11))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))\x11\x11))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x16\x16\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10+6++++++++++\xa3+++++++++++++\x10+++++\x10+\x10'
'++\x10++\x10++++++++++%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99'
'\x99\x99\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%$$$$$$%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x8db'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10%%%%%%%%%%$$\x92\xc1\x10\x10'
'4444444444444444\x87\x87\x87\x88\x87\x87\x87\x90e\x87\x10\x10\x10\x10\x10\x106666666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x87^^XX\x90e\x90e\x90e\x90e\x90e\x90'
'e\x90e\x90e\x87\x87\x90e\x87\x87\x87\x87XXXu\x87v\x10\x87v\x87\x87^\x91f\x91f\x91f{\x87\x87\xa5[\xb4\xb4\xb3\x10\x87\x98{\x87\x10\x10\x10\x10$%$%$\x10$%$%$%$%$%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x10\x10\x07'
'\x10\x80\x80x\x94x\x80\x81\x8b`\x80\xa2pYqp9999999999q\x80\xac\xab\xac\x80\x80..........................\x8b\x80`\x9cU'
'\x9c\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8b\xab`\xab\x8b`\x82\x8ca\x82\x82&&&&&&&&&&\x1b&&&&&&&&&&&&&&&'
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\x1a\x1a&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\x10'
'\x10\x10&&&&&&\x10\x10&&&&&&\x10\x10&&&&&&\x10\x10&&&\x10\x10\x10\x94\x94\xab\x9c\xbf\x94\x94\x10\xc0\xad\xad\xad\xad\xc0\xc0\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x0b\x0b\x0b\xc1\xbe\x10\x10'
'((((((((((((\x10((((((((((((((((((((((((((\x10(((((((((((((((((((\x10((\x10('
'((((((((((((((\x10\x10((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10'
'|\x83\xbc\x10\x10\x10\x10KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK\x10\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEPPPP\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1P\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc6\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((\x10KKKK\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((('
'(A((((((((A\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((\x10|(((((((((((((((((((((((((((((((('
'((((\x10\x10\x10\x10((((((((|AAAAA\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'////////////////////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16(((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++\x10\x10+\x10++++++++++++++++++++++++++++++++++++++++++++\x10++\x10\x10\x10+\x10\x10+'
'++++++++++++++++++++++\x10\x89SSSSSSSS\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++++++++++++++++++SSSSSS\x10\x10\x10\x83++++++++++++++++++++++++++\x10\x10\x10\x10\x10\x89'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'+666\x1066\x10\x10\x10\x10\x106666++++\x10+++\x10+++++++++++++++++++++++++++\x10\x10\x10\x10666\x10\x10\x10\x106'
'TTTTSSSS\x10\x10\x10\x10\x10\x10\x10\x10\x89\x89\x89\x89\x89\x89\x89\x89\x89\x10\x10\x10\x10\x10\x10\x10+++++++++++++++++++++++++++++SS\x89'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++\x10\x10\x10\x83\x83\x83\x83\x83\x83\x83'
'++++++++++++++++++++++\x10\x10SSSSSSSS+++++++++++++++++++\x10\x10\x10\x10\x10SSSSSSSS'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10GGGGGGGGGFFFFFFFFFFFFFFFFFFFFFF\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'161(((((((((((((((((((((((((((((((((((((((((((((((((((((66666666'
'6666666|||||||\x10\x10\x10\x10QQQQQQQQQPPPPPPPPPPP<<<<<<<<<<\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'661(((((((((((((((((((((((((((((((((((((((((((((11166661166||\x08||'
'||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA@@AAAAAAAAAAAA'
'AAAAAAAAAAAAAAAAAAAAAA@@AAAAAAAAAAA\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10||||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'))\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc11666\xbc\xbc\xbc111111\x07\x07\x07\x07\x07\x07\x07\x0766666'
'666\xbc\xbc6666666\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc6666\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1666\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10KKKKKKKKKKKKKKKKKK\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////'
'//////////////\x16\x16\x16\x16\x16\x16\x16\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////////////////'
'//\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16/\x10//\x10\x10/\x10\x10//\x10\x10////\x10////////\x16\x16\x16\x16\x10\x16\x10\x16\x16\x16'
'\x16\x16\x16\x16\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16//\x10////\x10\x10////////\x10///////\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//\x10////\x10'
'/////\x10/\x10\x10\x10///////\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////////////'
'//////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////'
'//////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////////'
'//////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10////////////////////////'
'/\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/\x16\x10\x10::::::::::::::::::::::::::::::::::::::::::::::::::'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10'
'\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'IIIIIIIIIII\x10\x10\x10\x10\x10\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xbc\x10\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\x10\x10\x10\x10\x10\x10\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbd\xbd\xbd\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x10\x10\x10\x10\x10'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x10\x10\x10\x10\x10\x10\x10\xbd\xbd\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10'
'\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1'
'\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\x10\xc1\x10\xc1\x10\xc1\x10\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\xc1\xc1\xc1\xc1\x10\xc1\x10\x10\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
')*))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))*)))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))*)))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))*))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))*))))))))*)))))))))))))))*)))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))*))))))))))))))))))*))'
')))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))*)))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))*)))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))))*))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
')))))))))))))))))))))))))))))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x10\x10'
'\x10\x07\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07'
'\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'4444444444444444444444444444444444444444444444444444444444444444'
'4444444444444444444444444444444444444444444444444444444444444444'
'4444444444444444444444444444444444444444444444444444444444444444'
'444444444444444444444444444444444444444444444444\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x10\x10'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
}

_decimal_corrected = {
178: None,
179: None,
185: None,
4969: None,
4970: None,
4971: None,
4972: None,
4973: None,
4974: None,
4975: None,
4976: None,
4977: None,
8304: None,
8308: None,
8309: None,
8310: None,
8311: None,
8312: None,
8313: None,
8320: None,
8321: None,
8322: None,
8323: None,
8324: None,
8325: None,
8326: None,
8327: None,
8328: None,
8329: None,
}
_digit = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6618: 1,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
9471: 0,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
68160: 1,
68161: 2,
68162: 3,
68163: 4,
69216: 1,
69217: 2,
69218: 3,
69219: 4,
69220: 5,
69221: 6,
69222: 7,
69223: 8,
69224: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
127232: 0,
127233: 0,
127234: 1,
127235: 2,
127236: 3,
127237: 4,
127238: 5,
127239: 6,
127240: 7,
127241: 8,
127242: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
1984: 0.0,
1985: 1.0,
1986: 2.0,
1987: 3.0,
1988: 4.0,
1989: 5.0,
1990: 6.0,
1991: 7.0,
1992: 8.0,
1993: 9.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3046: 0.0,
3192: 0.0,
3193: 1.0,
3194: 2.0,
3195: 3.0,
3196: 1.0,
3197: 2.0,
3198: 3.0,
3440: 10.0,
3441: 100.0,
3442: 1000.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
4240: 0.0,
4241: 1.0,
4242: 2.0,
4243: 3.0,
4244: 4.0,
4245: 5.0,
4246: 6.0,
4247: 7.0,
4248: 8.0,
4249: 9.0,
6128: 0.0,
6129: 1.0,
6130: 2.0,
6131: 3.0,
6132: 4.0,
6133: 5.0,
6134: 6.0,
6135: 7.0,
6136: 8.0,
6137: 9.0,
6470: 0.0,
6471: 1.0,
6472: 2.0,
6473: 3.0,
6474: 4.0,
6475: 5.0,
6476: 6.0,
6477: 7.0,
6478: 8.0,
6479: 9.0,
6608: 0.0,
6609: 1.0,
6610: 2.0,
6611: 3.0,
6612: 4.0,
6613: 5.0,
6614: 6.0,
6615: 7.0,
6616: 8.0,
6617: 9.0,
6618: 1.0,
6784: 0.0,
6785: 1.0,
6786: 2.0,
6787: 3.0,
6788: 4.0,
6789: 5.0,
6790: 6.0,
6791: 7.0,
6792: 8.0,
6793: 9.0,
6800: 0.0,
6801: 1.0,
6802: 2.0,
6803: 3.0,
6804: 4.0,
6805: 5.0,
6806: 6.0,
6807: 7.0,
6808: 8.0,
6809: 9.0,
6992: 0.0,
6993: 1.0,
6994: 2.0,
6995: 3.0,
6996: 4.0,
6997: 5.0,
6998: 6.0,
6999: 7.0,
7000: 8.0,
7001: 9.0,
7088: 0.0,
7089: 1.0,
7090: 2.0,
7091: 3.0,
7092: 4.0,
7093: 5.0,
7094: 6.0,
7095: 7.0,
7096: 8.0,
7097: 9.0,
7232: 0.0,
7233: 1.0,
7234: 2.0,
7235: 3.0,
7236: 4.0,
7237: 5.0,
7238: 6.0,
7239: 7.0,
7240: 8.0,
7241: 9.0,
7248: 0.0,
7249: 1.0,
7250: 2.0,
7251: 3.0,
7252: 4.0,
7253: 5.0,
7254: 6.0,
7255: 7.0,
7256: 8.0,
7257: 9.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
8581: 6.0,
8582: 50.0,
8583: 50000.0,
8584: 100000.0,
8585: 0.0,
9471: 0.0,
11517: 1.0 / 2.0,
13317: 5.0,
13443: 2.0,
14378: 5.0,
15181: 7.0,
20118: 4.0,
20160: 10.0,
20200: 3.0,
21316: 20.0,
21324: 40.0,
21444: 3.0,
24186: 1.0,
24318: 9.0,
28422: 7.0,
36019: 2.0,
38433: 1000.0,
42528: 0.0,
42529: 1.0,
42530: 2.0,
42531: 3.0,
42532: 4.0,
42533: 5.0,
42534: 6.0,
42535: 7.0,
42536: 8.0,
42537: 9.0,
42726: 1.0,
42727: 2.0,
42728: 3.0,
42729: 4.0,
42730: 5.0,
42731: 6.0,
42732: 7.0,
42733: 8.0,
42734: 9.0,
42735: 0.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43216: 0.0,
43217: 1.0,
43218: 2.0,
43219: 3.0,
43220: 4.0,
43221: 5.0,
43222: 6.0,
43223: 7.0,
43224: 8.0,
43225: 9.0,
43264: 0.0,
43265: 1.0,
43266: 2.0,
43267: 3.0,
43268: 4.0,
43269: 5.0,
43270: 6.0,
43271: 7.0,
43272: 8.0,
43273: 9.0,
43472: 0.0,
43473: 1.0,
43474: 2.0,
43475: 3.0,
43476: 4.0,
43477: 5.0,
43478: 6.0,
43479: 7.0,
43480: 8.0,
43481: 9.0,
43600: 0.0,
43601: 1.0,
43602: 2.0,
43603: 3.0,
43604: 4.0,
43605: 5.0,
43606: 6.0,
43607: 7.0,
43608: 8.0,
43609: 9.0,
44016: 0.0,
44017: 1.0,
44018: 2.0,
44019: 3.0,
44020: 4.0,
44021: 5.0,
44022: 6.0,
44023: 7.0,
44024: 8.0,
44025: 9.0,
63851: 3.0,
63859: 10.0,
63864: 2.0,
63922: 0.0,
63953: 6.0,
63955: 6.0,
63997: 10.0,
65799: 1.0,
65800: 2.0,
65801: 3.0,
65802: 4.0,
65803: 5.0,
65804: 6.0,
65805: 7.0,
65806: 8.0,
65807: 9.0,
65808: 10.0,
65809: 20.0,
65810: 30.0,
65811: 40.0,
65812: 50.0,
65813: 60.0,
65814: 70.0,
65815: 80.0,
65816: 90.0,
65817: 100.0,
65818: 200.0,
65819: 300.0,
65820: 400.0,
65821: 500.0,
65822: 600.0,
65823: 700.0,
65824: 800.0,
65825: 900.0,
65826: 1000.0,
65827: 2000.0,
65828: 3000.0,
65829: 4000.0,
65830: 5000.0,
65831: 6000.0,
65832: 7000.0,
65833: 8000.0,
65834: 9000.0,
65835: 10000.0,
65836: 20000.0,
65837: 30000.0,
65838: 40000.0,
65839: 50000.0,
65840: 60000.0,
65841: 70000.0,
65842: 80000.0,
65843: 90000.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65858: 1.0,
65859: 5.0,
65860: 50.0,
65861: 500.0,
65862: 5000.0,
65863: 50000.0,
65864: 5.0,
65865: 10.0,
65866: 50.0,
65867: 100.0,
65868: 500.0,
65869: 1000.0,
65870: 5000.0,
65871: 5.0,
65872: 10.0,
65873: 50.0,
65874: 100.0,
65875: 500.0,
65876: 1000.0,
65877: 10000.0,
65878: 50000.0,
65879: 10.0,
65880: 1.0,
65881: 1.0,
65882: 1.0,
65883: 2.0,
65884: 2.0,
65885: 2.0,
65886: 2.0,
65887: 5.0,
65888: 10.0,
65889: 10.0,
65890: 10.0,
65891: 10.0,
65892: 10.0,
65893: 30.0,
65894: 50.0,
65895: 50.0,
65896: 50.0,
65897: 50.0,
65898: 100.0,
65899: 300.0,
65900: 500.0,
65901: 500.0,
65902: 500.0,
65903: 500.0,
65904: 500.0,
65905: 1000.0,
65906: 5000.0,
65907: 5.0,
65908: 50.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65930: 0.0,
66369: 90.0,
66378: 900.0,
66513: 1.0,
66514: 2.0,
66515: 10.0,
66516: 20.0,
66517: 100.0,
66720: 0.0,
66721: 1.0,
66722: 2.0,
66723: 3.0,
66724: 4.0,
66725: 5.0,
66726: 6.0,
66727: 7.0,
66728: 8.0,
66729: 9.0,
67672: 1.0,
67673: 2.0,
67674: 3.0,
67675: 10.0,
67676: 20.0,
67677: 100.0,
67678: 1000.0,
67679: 10000.0,
67862: 1.0,
67863: 10.0,
67864: 20.0,
67865: 100.0,
67866: 2.0,
67867: 3.0,
68160: 1.0,
68161: 2.0,
68162: 3.0,
68163: 4.0,
68164: 10.0,
68165: 20.0,
68166: 100.0,
68167: 1000.0,
68221: 1.0,
68222: 50.0,
68440: 1.0,
68441: 2.0,
68442: 3.0,
68443: 4.0,
68444: 10.0,
68445: 20.0,
68446: 100.0,
68447: 1000.0,
68472: 1.0,
68473: 2.0,
68474: 3.0,
68475: 4.0,
68476: 10.0,
68477: 20.0,
68478: 100.0,
68479: 1000.0,
69216: 1.0,
69217: 2.0,
69218: 3.0,
69219: 4.0,
69220: 5.0,
69221: 6.0,
69222: 7.0,
69223: 8.0,
69224: 9.0,
69225: 10.0,
69226: 20.0,
69227: 30.0,
69228: 40.0,
69229: 50.0,
69230: 60.0,
69231: 70.0,
69232: 80.0,
69233: 90.0,
69234: 100.0,
69235: 200.0,
69236: 300.0,
69237: 400.0,
69238: 500.0,
69239: 600.0,
69240: 700.0,
69241: 800.0,
69242: 900.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
74752: 2.0,
74753: 3.0,
74754: 4.0,
74755: 5.0,
74756: 6.0,
74757: 7.0,
74758: 8.0,
74759: 9.0,
74760: 3.0,
74761: 4.0,
74762: 5.0,
74763: 6.0,
74764: 7.0,
74765: 8.0,
74766: 9.0,
74767: 4.0,
74768: 5.0,
74769: 6.0,
74770: 7.0,
74771: 8.0,
74772: 9.0,
74773: 1.0,
74774: 2.0,
74775: 3.0,
74776: 4.0,
74777: 5.0,
74778: 6.0,
74779: 7.0,
74780: 8.0,
74781: 9.0,
74782: 1.0,
74783: 2.0,
74784: 3.0,
74785: 4.0,
74786: 5.0,
74787: 2.0,
74788: 3.0,
74789: 3.0,
74790: 4.0,
74791: 5.0,
74792: 6.0,
74793: 7.0,
74794: 8.0,
74795: 9.0,
74796: 1.0,
74797: 2.0,
74798: 3.0,
74799: 3.0,
74800: 4.0,
74801: 5.0,
74804: 1.0,
74805: 2.0,
74806: 3.0,
74807: 3.0,
74808: 4.0,
74809: 5.0,
74810: 3.0,
74811: 3.0,
74812: 4.0,
74813: 4.0,
74814: 4.0,
74815: 4.0,
74816: 6.0,
74817: 7.0,
74818: 7.0,
74819: 7.0,
74820: 8.0,
74821: 8.0,
74822: 9.0,
74823: 9.0,
74824: 9.0,
74825: 9.0,
74826: 2.0,
74827: 3.0,
74828: 4.0,
74829: 5.0,
74830: 6.0,
74831: 1.0,
74832: 2.0,
74833: 3.0,
74834: 4.0,
74835: 4.0,
74836: 5.0,
74837: 5.0,
74840: 1.0,
74841: 2.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
119648: 1.0,
119649: 2.0,
119650: 3.0,
119651: 4.0,
119652: 5.0,
119653: 6.0,
119654: 7.0,
119655: 8.0,
119656: 9.0,
119657: 10.0,
119658: 20.0,
119659: 30.0,
119660: 40.0,
119661: 50.0,
119662: 60.0,
119663: 70.0,
119664: 80.0,
119665: 90.0,
127232: 0.0,
127233: 0.0,
127234: 1.0,
127235: 2.0,
127236: 3.0,
127237: 4.0,
127238: 5.0,
127239: 6.0,
127240: 7.0,
127241: 8.0,
127242: 9.0,
131073: 7.0,
131172: 4.0,
131298: 4.0,
131361: 5.0,
133418: 1.0,
133507: 30.0,
133516: 40.0,
133532: 40.0,
133866: 6.0,
133885: 3.0,
133913: 3.0,
140176: 2.0,
141720: 3.0,
146203: 3.0,
156269: 4.0,
194704: 9.0,
}

_numeric_corrected = {
20140: None,
22419: None,
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
384: 579,
410: 573,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
613: 42893,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
66638: 66598,
66639: 66599,
}

_toupper_corrected = {
}
_tolower = {
570: 11365,
571: 572,
573: 410,
574: 11366,
577: 578,
579: 384,
580: 649,
581: 652,
582: 583,
584: 585,
586: 587,
588: 589,
590: 591,
880: 881,
882: 883,
886: 887,
975: 983,
1015: 1016,
1017: 1010,
1018: 1019,
1021: 891,
1022: 892,
1023: 893,
1216: 1231,
1270: 1271,
1274: 1275,
1276: 1277,
1278: 1279,
1296: 1297,
1298: 1299,
1300: 1301,
1302: 1303,
1304: 1305,
1306: 1307,
1308: 1309,
1310: 1311,
1312: 1313,
1314: 1315,
1316: 1317,
1318: 1319,
4256: 11520,
4257: 11521,
4258: 11522,
4259: 11523,
4260: 11524,
4261: 11525,
4262: 11526,
4263: 11527,
4264: 11528,
4265: 11529,
4266: 11530,
4267: 11531,
4268: 11532,
4269: 11533,
4270: 11534,
4271: 11535,
4272: 11536,
4273: 11537,
4274: 11538,
4275: 11539,
4276: 11540,
4277: 11541,
4278: 11542,
4279: 11543,
4280: 11544,
4281: 11545,
4282: 11546,
4283: 11547,
4284: 11548,
4285: 11549,
4286: 11550,
4287: 11551,
4288: 11552,
4289: 11553,
4290: 11554,
4291: 11555,
4292: 11556,
4293: 11557,
7838: 223,
7930: 7931,
7932: 7933,
7934: 7935,
8498: 8526,
8579: 8580,
11264: 11312,
11265: 11313,
11266: 11314,
11267: 11315,
11268: 11316,
11269: 11317,
11270: 11318,
11271: 11319,
11272: 11320,
11273: 11321,
11274: 11322,
11275: 11323,
11276: 11324,
11277: 11325,
11278: 11326,
11279: 11327,
11280: 11328,
11281: 11329,
11282: 11330,
11283: 11331,
11284: 11332,
11285: 11333,
11286: 11334,
11287: 11335,
11288: 11336,
11289: 11337,
11290: 11338,
11291: 11339,
11292: 11340,
11293: 11341,
11294: 11342,
11295: 11343,
11296: 11344,
11297: 11345,
11298: 11346,
11299: 11347,
11300: 11348,
11301: 11349,
11302: 11350,
11303: 11351,
11304: 11352,
11305: 11353,
11306: 11354,
11307: 11355,
11308: 11356,
11309: 11357,
11310: 11358,
11360: 11361,
11362: 619,
11363: 7549,
11364: 637,
11367: 11368,
11369: 11370,
11371: 11372,
11373: 593,
11374: 625,
11375: 592,
11376: 594,
11378: 11379,
11381: 11382,
11390: 575,
11391: 576,
11392: 11393,
11394: 11395,
11396: 11397,
11398: 11399,
11400: 11401,
11402: 11403,
11404: 11405,
11406: 11407,
11408: 11409,
11410: 11411,
11412: 11413,
11414: 11415,
11416: 11417,
11418: 11419,
11420: 11421,
11422: 11423,
11424: 11425,
11426: 11427,
11428: 11429,
11430: 11431,
11432: 11433,
11434: 11435,
11436: 11437,
11438: 11439,
11440: 11441,
11442: 11443,
11444: 11445,
11446: 11447,
11448: 11449,
11450: 11451,
11452: 11453,
11454: 11455,
11456: 11457,
11458: 11459,
11460: 11461,
11462: 11463,
11464: 11465,
11466: 11467,
11468: 11469,
11470: 11471,
11472: 11473,
11474: 11475,
11476: 11477,
11478: 11479,
11480: 11481,
11482: 11483,
11484: 11485,
11486: 11487,
11488: 11489,
11490: 11491,
11499: 11500,
11501: 11502,
42560: 42561,
42562: 42563,
42564: 42565,
42566: 42567,
42568: 42569,
42570: 42571,
42572: 42573,
42574: 42575,
42576: 42577,
42578: 42579,
42580: 42581,
42582: 42583,
42584: 42585,
42586: 42587,
42588: 42589,
42590: 42591,
42592: 42593,
42594: 42595,
42596: 42597,
42598: 42599,
42600: 42601,
42602: 42603,
42604: 42605,
42624: 42625,
42626: 42627,
42628: 42629,
42630: 42631,
42632: 42633,
42634: 42635,
42636: 42637,
42638: 42639,
42640: 42641,
42642: 42643,
42644: 42645,
42646: 42647,
42786: 42787,
42788: 42789,
42790: 42791,
42792: 42793,
42794: 42795,
42796: 42797,
42798: 42799,
42802: 42803,
42804: 42805,
42806: 42807,
42808: 42809,
42810: 42811,
42812: 42813,
42814: 42815,
42816: 42817,
42818: 42819,
42820: 42821,
42822: 42823,
42824: 42825,
42826: 42827,
42828: 42829,
42830: 42831,
42832: 42833,
42834: 42835,
42836: 42837,
42838: 42839,
42840: 42841,
42842: 42843,
42844: 42845,
42846: 42847,
42848: 42849,
42850: 42851,
42852: 42853,
42854: 42855,
42856: 42857,
42858: 42859,
42860: 42861,
42862: 42863,
42873: 42874,
42875: 42876,
42877: 7545,
42878: 42879,
42880: 42881,
42882: 42883,
42884: 42885,
42886: 42887,
42891: 42892,
42893: 613,
42896: 42897,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
66598: 66638,
66599: 66639,
}

_tolower_corrected = {
}
_totitle = {
384: 579,
410: 573,
453: 453,
456: 456,
459: 459,
498: 498,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
613: 42893,
619: 11362,
625: 11374,
637: 11364,
649: 580,
652: 581,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
66638: 66598,
66639: 66599,
}

_totitle_corrected = {
}
_special_casing = {
223: ([223], [83, 115], [83, 83]),
304: ([105, 775], [304], [304]),
329: ([329], [700, 78], [700, 78]),
496: ([496], [74, 780], [74, 780]),
912: ([912], [921, 776, 769], [921, 776, 769]),
944: ([944], [933, 776, 769], [933, 776, 769]),
1415: ([1415], [1333, 1410], [1333, 1362]),
7830: ([7830], [72, 817], [72, 817]),
7831: ([7831], [84, 776], [84, 776]),
7832: ([7832], [87, 778], [87, 778]),
7833: ([7833], [89, 778], [89, 778]),
7834: ([7834], [65, 702], [65, 702]),
8016: ([8016], [933, 787], [933, 787]),
8018: ([8018], [933, 787, 768], [933, 787, 768]),
8020: ([8020], [933, 787, 769], [933, 787, 769]),
8022: ([8022], [933, 787, 834], [933, 787, 834]),
8064: ([8064], [8072], [7944, 921]),
8065: ([8065], [8073], [7945, 921]),
8066: ([8066], [8074], [7946, 921]),
8067: ([8067], [8075], [7947, 921]),
8068: ([8068], [8076], [7948, 921]),
8069: ([8069], [8077], [7949, 921]),
8070: ([8070], [8078], [7950, 921]),
8071: ([8071], [8079], [7951, 921]),
8072: ([8064], [8072], [7944, 921]),
8073: ([8065], [8073], [7945, 921]),
8074: ([8066], [8074], [7946, 921]),
8075: ([8067], [8075], [7947, 921]),
8076: ([8068], [8076], [7948, 921]),
8077: ([8069], [8077], [7949, 921]),
8078: ([8070], [8078], [7950, 921]),
8079: ([8071], [8079], [7951, 921]),
8080: ([8080], [8088], [7976, 921]),
8081: ([8081], [8089], [7977, 921]),
8082: ([8082], [8090], [7978, 921]),
8083: ([8083], [8091], [7979, 921]),
8084: ([8084], [8092], [7980, 921]),
8085: ([8085], [8093], [7981, 921]),
8086: ([8086], [8094], [7982, 921]),
8087: ([8087], [8095], [7983, 921]),
8088: ([8080], [8088], [7976, 921]),
8089: ([8081], [8089], [7977, 921]),
8090: ([8082], [8090], [7978, 921]),
8091: ([8083], [8091], [7979, 921]),
8092: ([8084], [8092], [7980, 921]),
8093: ([8085], [8093], [7981, 921]),
8094: ([8086], [8094], [7982, 921]),
8095: ([8087], [8095], [7983, 921]),
8096: ([8096], [8104], [8040, 921]),
8097: ([8097], [8105], [8041, 921]),
8098: ([8098], [8106], [8042, 921]),
8099: ([8099], [8107], [8043, 921]),
8100: ([8100], [8108], [8044, 921]),
8101: ([8101], [8109], [8045, 921]),
8102: ([8102], [8110], [8046, 921]),
8103: ([8103], [8111], [8047, 921]),
8104: ([8096], [8104], [8040, 921]),
8105: ([8097], [8105], [8041, 921]),
8106: ([8098], [8106], [8042, 921]),
8107: ([8099], [8107], [8043, 921]),
8108: ([8100], [8108], [8044, 921]),
8109: ([8101], [8109], [8045, 921]),
8110: ([8102], [8110], [8046, 921]),
8111: ([8103], [8111], [8047, 921]),
8114: ([8114], [8122, 837], [8122, 921]),
8115: ([8115], [8124], [913, 921]),
8116: ([8116], [902, 837], [902, 921]),
8118: ([8118], [913, 834], [913, 834]),
8119: ([8119], [913, 834, 837], [913, 834, 921]),
8124: ([8115], [8124], [913, 921]),
8130: ([8130], [8138, 837], [8138, 921]),
8131: ([8131], [8140], [919, 921]),
8132: ([8132], [905, 837], [905, 921]),
8134: ([8134], [919, 834], [919, 834]),
8135: ([8135], [919, 834, 837], [919, 834, 921]),
8140: ([8131], [8140], [919, 921]),
8146: ([8146], [921, 776, 768], [921, 776, 768]),
8147: ([8147], [921, 776, 769], [921, 776, 769]),
8150: ([8150], [921, 834], [921, 834]),
8151: ([8151], [921, 776, 834], [921, 776, 834]),
8162: ([8162], [933, 776, 768], [933, 776, 768]),
8163: ([8163], [933, 776, 769], [933, 776, 769]),
8164: ([8164], [929, 787], [929, 787]),
8166: ([8166], [933, 834], [933, 834]),
8167: ([8167], [933, 776, 834], [933, 776, 834]),
8178: ([8178], [8186, 837], [8186, 921]),
8179: ([8179], [8188], [937, 921]),
8180: ([8180], [911, 837], [911, 921]),
8182: ([8182], [937, 834], [937, 834]),
8183: ([8183], [937, 834, 837], [937, 834, 921]),
8188: ([8179], [8188], [937, 921]),
64256: ([64256], [70, 102], [70, 70]),
64257: ([64257], [70, 105], [70, 73]),
64258: ([64258], [70, 108], [70, 76]),
64259: ([64259], [70, 102, 105], [70, 70, 73]),
64260: ([64260], [70, 102, 108], [70, 70, 76]),
64261: ([64261], [83, 116], [83, 84]),
64262: ([64262], [83, 116], [83, 84]),
64275: ([64275], [1348, 1398], [1348, 1350]),
64276: ([64276], [1348, 1381], [1348, 1333]),
64277: ([64277], [1348, 1387], [1348, 1339]),
64278: ([64278], [1358, 1398], [1358, 1350]),
64279: ([64279], [1348, 1389], [1348, 1341]),
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
1017: '<compat> 03A3',
4348: '<super> 10DC',
6918: '1B05 1B35',
6920: '1B07 1B35',
6922: '1B09 1B35',
6924: '1B0B 1B35',
6926: '1B0D 1B35',
6930: '1B11 1B35',
6971: '1B3A 1B35',
6973: '1B3C 1B35',
6976: '1B3E 1B35',
6977: '1B3F 1B35',
6979: '1B42 1B35',
7468: '<super> 0041',
7469: '<super> 00C6',
7470: '<super> 0042',
7472: '<super> 0044',
7473: '<super> 0045',
7474: '<super> 018E',
7475: '<super> 0047',
7476: '<super> 0048',
7477: '<super> 0049',
7478: '<super> 004A',
7479: '<super> 004B',
7480: '<super> 004C',
7481: '<super> 004D',
7482: '<super> 004E',
7484: '<super> 004F',
7485: '<super> 0222',
7486: '<super> 0050',
7487: '<super> 0052',
7488: '<super> 0054',
7489: '<super> 0055',
7490: '<super> 0057',
7491: '<super> 0061',
7492: '<super> 0250',
7493: '<super> 0251',
7494: '<super> 1D02',
7495: '<super> 0062',
7496: '<super> 0064',
7497: '<super> 0065',
7498: '<super> 0259',
7499: '<super> 025B',
7500: '<super> 025C',
7501: '<super> 0067',
7503: '<super> 006B',
7504: '<super> 006D',
7505: '<super> 014B',
7506: '<super> 006F',
7507: '<super> 0254',
7508: '<super> 1D16',
7509: '<super> 1D17',
7510: '<super> 0070',
7511: '<super> 0074',
7512: '<super> 0075',
7513: '<super> 1D1D',
7514: '<super> 026F',
7515: '<super> 0076',
7516: '<super> 1D25',
7517: '<super> 03B2',
7518: '<super> 03B3',
7519: '<super> 03B4',
7520: '<super> 03C6',
7521: '<super> 03C7',
7522: '<sub> 0069',
7523: '<sub> 0072',
7524: '<sub> 0075',
7525: '<sub> 0076',
7526: '<sub> 03B2',
7527: '<sub> 03B3',
7528: '<sub> 03C1',
7529: '<sub> 03C6',
7530: '<sub> 03C7',
7544: '<super> 043D',
7579: '<super> 0252',
7580: '<super> 0063',
7581: '<super> 0255',
7582: '<super> 00F0',
7583: '<super> 025C',
7584: '<super> 0066',
7585: '<super> 025F',
7586: '<super> 0261',
7587: '<super> 0265',
7588: '<super> 0268',
7589: '<super> 0269',
7590: '<super> 026A',
7591: '<super> 1D7B',
7592: '<super> 029D',
7593: '<super> 026D',
7594: '<super> 1D85',
7595: '<super> 029F',
7596: '<super> 0271',
7597: '<super> 0270',
7598: '<super> 0272',
7599: '<super> 0273',
7600: '<super> 0274',
7601: '<super> 0275',
7602: '<super> 0278',
7603: '<super> 0282',
7604: '<super> 0283',
7605: '<super> 01AB',
7606: '<super> 0289',
7607: '<super> 028A',
7608: '<super> 1D1C',
7609: '<super> 028B',
7610: '<super> 028C',
7611: '<super> 007A',
7612: '<super> 0290',
7613: '<super> 0291',
7614: '<super> 0292',
7615: '<super> 03B8',
8336: '<sub> 0061',
8337: '<sub> 0065',
8338: '<sub> 006F',
8339: '<sub> 0078',
8340: '<sub> 0259',
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
8507: '<compat> 0046 0041 0058',
8508: '<font> 03C0',
8528: '<fraction> 0031 2044 0037',
8529: '<fraction> 0031 2044 0039',
8530: '<fraction> 0031 2044 0031 0030',
8585: '<fraction> 0030 2044 0033',
11388: '<sub> 006A',
11389: '<super> 0056',
11631: '<super> 2D61',
12829: '<compat> 0028 110B 1169 110C 1165 11AB 0029',
12830: '<compat> 0028 110B 1169 1112 116E 0029',
12868: '<circle> 554F',
12869: '<circle> 5E7C',
12870: '<circle> 6587',
12871: '<circle> 7B8F',
12880: '<square> 0050 0054 0045',
12924: '<circle> 110E 1161 11B7 1100 1169',
12925: '<circle> 110C 116E 110B 1174',
12926: '<circle> 110B 116E',
13004: '<square> 0048 0067',
13005: '<square> 0065 0072 0067',
13006: '<square> 0065 0056',
13007: '<square> 004C 0054 0044',
13175: '<square> 0064 006D',
13176: '<square> 0064 006D 00B2',
13177: '<square> 0064 006D 00B3',
13178: '<square> 0049 0055',
13278: '<square> 0056 2215 006D',
13279: '<square> 0041 2215 006D',
13311: '<square> 0067 0061 006C',
42864: '<super> A76F',
64107: '6075',
64108: '242EE',
64109: '8218',
64112: '4E26',
64113: '51B5',
64114: '5168',
64115: '4F80',
64116: '5145',
64117: '5180',
64118: '52C7',
64119: '52FA',
64120: '559D',
64121: '5555',
64122: '5599',
64123: '55E2',
64124: '585A',
64125: '58B3',
64126: '5944',
64127: '5954',
64128: '5A62',
64129: '5B28',
64130: '5ED2',
64131: '5ED9',
64132: '5F69',
64133: '5FAD',
64134: '60D8',
64135: '614E',
64136: '6108',
64137: '618E',
64138: '6160',
64139: '61F2',
64140: '6234',
64141: '63C4',
64142: '641C',
64143: '6452',
64144: '6556',
64145: '6674',
64146: '6717',
64147: '671B',
64148: '6756',
64149: '6B79',
64150: '6BBA',
64151: '6D41',
64152: '6EDB',
64153: '6ECB',
64154: '6F22',
64155: '701E',
64156: '716E',
64157: '77A7',
64158: '7235',
64159: '72AF',
64160: '732A',
64161: '7471',
64162: '7506',
64163: '753B',
64164: '761D',
64165: '761F',
64166: '76CA',
64167: '76DB',
64168: '76F4',
64169: '774A',
64170: '7740',
64171: '78CC',
64172: '7AB1',
64173: '7BC0',
64174: '7C7B',
64175: '7D5B',
64176: '7DF4',
64177: '7F3E',
64178: '8005',
64179: '8352',
64180: '83EF',
64181: '8779',
64182: '8941',
64183: '8986',
64184: '8996',
64185: '8ABF',
64186: '8AF8',
64187: '8ACB',
64188: '8B01',
64189: '8AFE',
64190: '8AED',
64191: '8B39',
64192: '8B8A',
64193: '8D08',
64194: '8F38',
64195: '9072',
64196: '9199',
64197: '9276',
64198: '967C',
64199: '96E3',
64200: '9756',
64201: '97DB',
64202: '97FF',
64203: '980B',
64204: '983B',
64205: '9B12',
64206: '9F9C',
64207: '2284A',
64208: '22844',
64209: '233D5',
64210: '3B9D',
64211: '4018',
64212: '4039',
64213: '25249',
64214: '25CD0',
64215: '27ED3',
64216: '9F43',
64217: '9F8E',
65040: '<vertical> 002C',
65041: '<vertical> 3001',
65042: '<vertical> 3002',
65043: '<vertical> 003A',
65044: '<vertical> 003B',
65045: '<vertical> 0021',
65046: '<vertical> 003F',
65047: '<vertical> 3016',
65048: '<vertical> 3017',
65049: '<vertical> 2026',
65095: '<vertical> 005B',
65096: '<vertical> 005D',
69786: '11099 110BA',
69788: '1109B 110BA',
69803: '110A5 110BA',
120001: '<font> 006C',
120484: '<font> 0131',
120485: '<font> 0237',
120778: '<font> 03DC',
120779: '<font> 03DD',
127232: '<compat> 0030 002E',
127233: '<compat> 0030 002C',
127234: '<compat> 0031 002C',
127235: '<compat> 0032 002C',
127236: '<compat> 0033 002C',
127237: '<compat> 0034 002C',
127238: '<compat> 0035 002C',
127239: '<compat> 0036 002C',
127240: '<compat> 0037 002C',
127241: '<compat> 0038 002C',
127242: '<compat> 0039 002C',
127248: '<compat> 0028 0041 0029',
127249: '<compat> 0028 0042 0029',
127250: '<compat> 0028 0043 0029',
127251: '<compat> 0028 0044 0029',
127252: '<compat> 0028 0045 0029',
127253: '<compat> 0028 0046 0029',
127254: '<compat> 0028 0047 0029',
127255: '<compat> 0028 0048 0029',
127256: '<compat> 0028 0049 0029',
127257: '<compat> 0028 004A 0029',
127258: '<compat> 0028 004B 0029',
127259: '<compat> 0028 004C 0029',
127260: '<compat> 0028 004D 0029',
127261: '<compat> 0028 004E 0029',
127262: '<compat> 0028 004F 0029',
127263: '<compat> 0028 0050 0029',
127264: '<compat> 0028 0051 0029',
127265: '<compat> 0028 0052 0029',
127266: '<compat> 0028 0053 0029',
127267: '<compat> 0028 0054 0029',
127268: '<compat> 0028 0055 0029',
127269: '<compat> 0028 0056 0029',
127270: '<compat> 0028 0057 0029',
127271: '<compat> 0028 0058 0029',
127272: '<compat> 0028 0059 0029',
127273: '<compat> 0028 005A 0029',
127274: '<compat> 3014 0053 3015',
127275: '<circle> 0043',
127276: '<circle> 0052',
127277: '<circle> 0043 0044',
127278: '<circle> 0057 005A',
127280: '<square> 0041',
127281: '<square> 0042',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127293: '<square> 004E',
127294: '<square> 004F',
127295: '<square> 0050',
127296: '<square> 0051',
127297: '<square> 0052',
127298: '<square> 0053',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127302: '<square> 0057',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127306: '<square> 0048 0056',
127307: '<square> 004D 0056',
127308: '<square> 0053 0044',
127309: '<square> 0053 0053',
127310: '<square> 0050 0050 0056',
127311: '<square> 0057 0043',
127376: '<square> 0044 004A',
127488: '<square> 307B 304B',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127504: '<square> 624B',
127505: '<square> 5B57',
127506: '<square> 53CC',
127507: '<square> 30C7',
127508: '<square> 4E8C',
127509: '<square> 591A',
127510: '<square> 89E3',
127511: '<square> 5929',
127512: '<square> 4EA4',
127513: '<square> 6620',
127514: '<square> 7121',
127515: '<square> 6599',
127516: '<square> 524D',
127517: '<square> 5F8C',
127518: '<square> 518D',
127519: '<square> 65B0',
127520: '<square> 521D',
127521: '<square> 7D42',
127522: '<square> 751F',
127523: '<square> 8CA9',
127524: '<square> 58F0',
127525: '<square> 5439',
127526: '<square> 6F14',
127527: '<square> 6295',
127528: '<square> 6355',
127529: '<square> 4E00',
127530: '<square> 4E09',
127531: '<square> 904A',
127532: '<square> 5DE6',
127533: '<square> 4E2D',
127534: '<square> 53F3',
127535: '<square> 6307',
127536: '<square> 8D70',
127537: '<square> 6253',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127552: '<compat> 3014 672C 3015',
127553: '<compat> 3014 4E09 3015',
127554: '<compat> 3014 4E8C 3015',
127555: '<compat> 3014 5B89 3015',
127556: '<compat> 3014 70B9 3015',
127557: '<compat> 3014 6253 3015',
127558: '<compat> 3014 76D7 3015',
127559: '<compat> 3014 52DD 3015',
127560: '<compat> 3014 6557 3015',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
194664: '36FC',
194676: '5F53',
194847: '243AB',
194911: '7AEE',
195007: '45D7',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
}

_canon_decomposition = {
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
1017: [931],
4348: [4316],
6918: [6917, 6965],
6920: [6919, 6965],
6922: [6921, 6965],
6924: [6923, 6965],
6926: [6925, 6965],
6930: [6929, 6965],
6971: [6970, 6965],
6973: [6972, 6965],
6976: [6974, 6965],
6977: [6975, 6965],
6979: [6978, 6965],
7468: [65],
7469: [198],
7470: [66],
7472: [68],
7473: [69],
7474: [398],
7475: [71],
7476: [72],
7477: [73],
7478: [74],
7479: [75],
7480: [76],
7481: [77],
7482: [78],
7484: [79],
7485: [546],
7486: [80],
7487: [82],
7488: [84],
7489: [85],
7490: [87],
7491: [97],
7492: [592],
7493: [593],
7494: [7426],
7495: [98],
7496: [100],
7497: [101],
7498: [601],
7499: [603],
7500: [604],
7501: [103],
7503: [107],
7504: [109],
7505: [331],
7506: [111],
7507: [596],
7508: [7446],
7509: [7447],
7510: [112],
7511: [116],
7512: [117],
7513: [7453],
7514: [623],
7515: [118],
7516: [7461],
7517: [946],
7518: [947],
7519: [948],
7520: [966],
7521: [967],
7522: [105],
7523: [114],
7524: [117],
7525: [118],
7526: [946],
7527: [947],
7528: [961],
7529: [966],
7530: [967],
7544: [1085],
7579: [594],
7580: [99],
7581: [597],
7582: [240],
7583: [604],
7584: [102],
7585: [607],
7586: [609],
7587: [613],
7588: [616],
7589: [617],
7590: [618],
7591: [7547],
7592: [669],
7593: [621],
7594: [7557],
7595: [671],
7596: [625],
7597: [624],
7598: [626],
7599: [627],
7600: [628],
7601: [629],
7602: [632],
7603: [642],
7604: [643],
7605: [427],
7606: [649],
7607: [650],
7608: [7452],
7609: [651],
7610: [652],
7611: [122],
7612: [656],
7613: [657],
7614: [658],
7615: [952],
8336: [97],
8337: [101],
8338: [111],
8339: [120],
8340: [601],
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
8507: [70, 65, 88],
8508: [960],
8528: [49, 8260, 55],
8529: [49, 8260, 57],
8530: [49, 8260, 49, 48],
8585: [48, 8260, 51],
11388: [106],
11389: [86],
11631: [11617],
12829: [40, 4363, 4457, 4364, 4453, 4523, 41],
12830: [40, 4363, 4457, 4370, 4462, 41],
12868: [21839],
12869: [24188],
12870: [25991],
12871: [31631],
12880: [80, 84, 69],
12924: [4366, 4449, 4535, 4352, 4457],
12925: [4364, 4462, 4363, 4468],
12926: [4363, 4462],
13004: [72, 103],
13005: [101, 114, 103],
13006: [101, 86],
13007: [76, 84, 68],
13175: [100, 109],
13176: [100, 109, 50],
13177: [100, 109, 51],
13178: [73, 85],
13278: [86, 8725, 109],
13279: [65, 8725, 109],
13311: [103, 97, 108],
42864: [42863],
64107: [24693],
64108: [148206],
64109: [33304],
64112: [20006],
64113: [20917],
64114: [20840],
64115: [20352],
64116: [20805],
64117: [20864],
64118: [21191],
64119: [21242],
64120: [21917],
64121: [21845],
64122: [21913],
64123: [21986],
64124: [22618],
64125: [22707],
64126: [22852],
64127: [22868],
64128: [23138],
64129: [23336],
64130: [24274],
64131: [24281],
64132: [24425],
64133: [24493],
64134: [24792],
64135: [24910],
64136: [24840],
64137: [24974],
64138: [24928],
64139: [25074],
64140: [25140],
64141: [25540],
64142: [25628],
64143: [25682],
64144: [25942],
64145: [26228],
64146: [26391],
64147: [26395],
64148: [26454],
64149: [27513],
64150: [27578],
64151: [27969],
64152: [28379],
64153: [28363],
64154: [28450],
64155: [28702],
64156: [29038],
64157: [30631],
64158: [29237],
64159: [29359],
64160: [29482],
64161: [29809],
64162: [29958],
64163: [30011],
64164: [30237],
64165: [30239],
64166: [30410],
64167: [30427],
64168: [30452],
64169: [30538],
64170: [30528],
64171: [30924],
64172: [31409],
64173: [31680],
64174: [31867],
64175: [32091],
64176: [32244],
64177: [32574],
64178: [32773],
64179: [33618],
64180: [33775],
64181: [34681],
64182: [35137],
64183: [35206],
64184: [35222],
64185: [35519],
64186: [35576],
64187: [35531],
64188: [35585],
64189: [35582],
64190: [35565],
64191: [35641],
64192: [35722],
64193: [36104],
64194: [36664],
64195: [36978],
64196: [37273],
64197: [37494],
64198: [38524],
64199: [38627],
64200: [38742],
64201: [38875],
64202: [38911],
64203: [38923],
64204: [38971],
64205: [39698],
64206: [40860],
64207: [141386],
64208: [141380],
64209: [144341],
64210: [15261],
64211: [16408],
64212: [16441],
64213: [152137],
64214: [154832],
64215: [163539],
64216: [40771],
64217: [40846],
65040: [44],
65041: [12289],
65042: [12290],
65043: [58],
65044: [59],
65045: [33],
65046: [63],
65047: [12310],
65048: [12311],
65049: [46, 46, 46],
65095: [91],
65096: [93],
69786: [69785, 69818],
69788: [69787, 69818],
69803: [69797, 69818],
120001: [108],
120484: [305],
120485: [567],
120778: [988],
120779: [989],
127232: [48, 46],
127233: [48, 44],
127234: [49, 44],
127235: [50, 44],
127236: [51, 44],
127237: [52, 44],
127238: [53, 44],
127239: [54, 44],
127240: [55, 44],
127241: [56, 44],
127242: [57, 44],
127248: [40, 65, 41],
127249: [40, 66, 41],
127250: [40, 67, 41],
127251: [40, 68, 41],
127252: [40, 69, 41],
127253: [40, 70, 41],
127254: [40, 71, 41],
127255: [40, 72, 41],
127256: [40, 73, 41],
127257: [40, 74, 41],
127258: [40, 75, 41],
127259: [40, 76, 41],
127260: [40, 77, 41],
127261: [40, 78, 41],
127262: [40, 79, 41],
127263: [40, 80, 41],
127264: [40, 81, 41],
127265: [40, 82, 41],
127266: [40, 83, 41],
127267: [40, 84, 41],
127268: [40, 85, 41],
127269: [40, 86, 41],
127270: [40, 87, 41],
127271: [40, 88, 41],
127272: [40, 89, 41],
127273: [40, 90, 41],
127274: [12308, 83, 12309],
127275: [67],
127276: [82],
127277: [67, 68],
127278: [87, 90],
127280: [65],
127281: [66],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127293: [78],
127294: [79],
127295: [80],
127296: [81],
127297: [82],
127298: [83],
127299: [84],
127300: [85],
127301: [86],
127302: [87],
127303: [88],
127304: [89],
127305: [90],
127306: [72, 86],
127307: [77, 86],
127308: [83, 68],
127309: [83, 83],
127310: [80, 80, 86],
127311: [87, 67],
127376: [68, 74],
127488: [12411, 12363],
127489: [12467, 12467],
127490: [12469],
127504: [25163],
127505: [23383],
127506: [21452],
127507: [12486, 12441],
127508: [20108],
127509: [22810],
127510: [35299],
127511: [22825],
127512: [20132],
127513: [26144],
127514: [28961],
127515: [26009],
127516: [21069],
127517: [24460],
127518: [20877],
127519: [26032],
127520: [21021],
127521: [32066],
127522: [29983],
127523: [36009],
127524: [22768],
127525: [21561],
127526: [28436],
127527: [25237],
127528: [25429],
127529: [19968],
127530: [19977],
127531: [36938],
127532: [24038],
127533: [20013],
127534: [21491],
127535: [25351],
127536: [36208],
127537: [25171],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127552: [12308, 26412, 12309],
127553: [12308, 19977, 12309],
127554: [12308, 20108, 12309],
127555: [12308, 23433, 12309],
127556: [12308, 28857, 12309],
127557: [12308, 25171, 12309],
127558: [12308, 30423, 12309],
127559: [12308, 21213, 12309],
127560: [12308, 25943, 12309],
127568: [24471],
127569: [21487],
194664: [14076],
194676: [24403],
194847: [148395],
194911: [31470],
195007: [17879],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
418,
419,
3294,
3741,
3743,
3747,
3749,
4048,
40981,
65048,
118981,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
7838: [115, 115],
}

_casefolds_corrected = {
1010: None,
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
848: 230,
849: 230,
850: 230,
851: 220,
852: 220,
853: 220,
854: 220,
855: 230,
856: 232,
857: 220,
858: 220,
859: 230,
860: 233,
861: 234,
862: 234,
863: 233,
1159: 230,
1442: 220,
1466: 19,
1477: 220,
1479: 18,
1552: 230,
1553: 230,
1554: 230,
1555: 230,
1556: 230,
1557: 230,
1558: 230,
1559: 230,
1560: 30,
1561: 31,
1562: 32,
1622: 220,
1623: 230,
1624: 230,
1625: 230,
1626: 230,
1627: 230,
1628: 220,
1629: 230,
1630: 230,
1631: 220,
2027: 230,
2028: 230,
2029: 230,
2030: 230,
2031: 230,
2032: 230,
2033: 230,
2034: 220,
2035: 230,
2070: 230,
2071: 230,
2072: 230,
2073: 230,
2075: 230,
2076: 230,
2077: 230,
2078: 230,
2079: 230,
2080: 230,
2081: 230,
2082: 230,
2083: 230,
2085: 230,
2086: 230,
2087: 230,
2089: 230,
2090: 230,
2091: 230,
2092: 230,
2093: 230,
2137: 220,
2138: 220,
2139: 220,
3260: 7,
4154: 9,
4237: 220,
4957: 230,
4958: 230,
4959: 230,
6109: 230,
6457: 222,
6458: 230,
6459: 220,
6679: 230,
6680: 220,
6752: 9,
6773: 230,
6774: 230,
6775: 230,
6776: 230,
6777: 230,
6778: 230,
6779: 230,
6780: 230,
6783: 220,
6964: 7,
6980: 9,
7019: 230,
7020: 220,
7021: 230,
7022: 230,
7023: 230,
7024: 230,
7025: 230,
7026: 230,
7027: 230,
7082: 9,
7142: 7,
7154: 9,
7155: 9,
7223: 7,
7376: 230,
7377: 230,
7378: 230,
7380: 1,
7381: 220,
7382: 220,
7383: 220,
7384: 220,
7385: 220,
7386: 230,
7387: 230,
7388: 220,
7389: 220,
7390: 220,
7391: 220,
7392: 230,
7394: 1,
7395: 1,
7396: 1,
7397: 1,
7398: 1,
7399: 1,
7400: 1,
7405: 220,
7616: 230,
7617: 230,
7618: 220,
7619: 230,
7620: 230,
7621: 230,
7622: 230,
7623: 230,
7624: 230,
7625: 230,
7626: 220,
7627: 230,
7628: 230,
7629: 234,
7630: 214,
7631: 220,
7632: 202,
7633: 230,
7634: 230,
7635: 230,
7636: 230,
7637: 230,
7638: 230,
7639: 230,
7640: 230,
7641: 230,
7642: 230,
7643: 230,
7644: 230,
7645: 230,
7646: 230,
7647: 230,
7648: 230,
7649: 230,
7650: 230,
7651: 230,
7652: 230,
7653: 230,
7654: 230,
7676: 233,
7677: 220,
7678: 230,
7679: 220,
8427: 1,
8428: 220,
8429: 220,
8430: 220,
8431: 220,
8432: 230,
11503: 230,
11504: 230,
11505: 230,
11647: 9,
11744: 230,
11745: 230,
11746: 230,
11747: 230,
11748: 230,
11749: 230,
11750: 230,
11751: 230,
11752: 230,
11753: 230,
11754: 230,
11755: 230,
11756: 230,
11757: 230,
11758: 230,
11759: 230,
11760: 230,
11761: 230,
11762: 230,
11763: 230,
11764: 230,
11765: 230,
11766: 230,
11767: 230,
11768: 230,
11769: 230,
11770: 230,
11771: 230,
11772: 230,
11773: 230,
11774: 230,
11775: 230,
42607: 230,
42620: 230,
42621: 230,
42736: 230,
42737: 230,
43014: 9,
43204: 9,
43232: 230,
43233: 230,
43234: 230,
43235: 230,
43236: 230,
43237: 230,
43238: 230,
43239: 230,
43240: 230,
43241: 230,
43242: 230,
43243: 230,
43244: 230,
43245: 230,
43246: 230,
43247: 230,
43248: 230,
43249: 230,
43307: 220,
43308: 220,
43309: 220,
43347: 9,
43443: 7,
43456: 9,
43696: 230,
43698: 230,
43699: 230,
43700: 220,
43703: 230,
43704: 230,
43710: 230,
43711: 230,
43713: 230,
44013: 9,
65060: 230,
65061: 230,
65062: 230,
66045: 220,
68109: 220,
68111: 230,
68152: 230,
68153: 1,
68154: 220,
68159: 9,
69702: 9,
69817: 9,
69818: 7,
119362: 230,
119363: 230,
119364: 230,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

