# Generated by tools/asdl_py.py
from rpython.tool.pairtype import extendabletype
from rpython.tool.sourcetools import func_with_new_name
from rpython.rlib.objectmodel import specialize

from pypy.interpreter import typedef
from pypy.interpreter.baseobjspace import W_Root
from pypy.interpreter.error import OperationError, oefmt
from pypy.interpreter.gateway import interp2app

@specialize.arg(0)
def build(cls, *args):
    ''' works like calling cls, but replace the four positions that come at the
    end of the arguments with the positions in the concrete syntax tree node
    passed as the last argument. '''
    newargs = args[:-1] + (args[-1].get_lineno(), args[-1].get_column(),
        args[-1].get_end_lineno(), args[-1].get_end_column())
    return cls(*newargs)


def raise_required_value(space, w_obj, name):
    raise oefmt(space.w_ValueError,
                "field %s is required for %T", name, w_obj)

def check_string(space, w_obj, allow_none=False):
    if allow_none and space.is_w(w_obj, space.w_None):
        return w_obj

    if not (space.isinstance_w(w_obj, space.w_bytes) or
            space.isinstance_w(w_obj, space.w_unicode)):
        raise oefmt(space.w_TypeError,
                    "AST string must be of type str or unicode")
    return w_obj

def get_field(space, w_node, name, optional):
    w_obj = w_node.getdictvalue(space, name)
    if w_obj is None:
        if not optional:
            raise oefmt(space.w_TypeError,
                "required field \"%s\" missing from %T", name, w_node)
        w_obj = space.w_None
    return w_obj

def obj_to_int(space, w_value, optional):
    if optional and space.is_w(w_value, space.w_None):
        return 0
    if not space.isinstance_w(w_value, space.w_long):
        raise oefmt(space.w_ValueError,
                    "invalid integer value: %R", w_value)
    return space.int_w(w_value)


class AST(object):
    __metaclass__ = extendabletype
    _attrs_ = ['lineno', 'col_offset', 'end_lineno', 'end_col_offset']

    def walkabout(self, visitor):
        raise AssertionError("walkabout() implementation not provided")

    def mutate_over(self, visitor):
        raise AssertionError("mutate_over() implementation not provided")

    def copy_location(self, node_start, node_end=None):
        if node_end is None:
            node_end = node_start
        self.lineno = node_start.get_lineno()
        self.col_offset = node_start.get_column()
        self.end_lineno = node_end.get_end_lineno()
        self.end_col_offset = node_end.get_end_column()
        return self


class NodeVisitorNotImplemented(Exception):
    pass


class _FieldsWrapper(W_Root):
    "Hack around the fact we can't store tuples on a TypeDef."

    def __init__(self, fields):
        assert fields == []

    def spacebind(self, space):
        return space.newtuple([])


class W_AST(W_Root):
    w_dict = None

    def getdict(self, space):
        if self.w_dict is None:
            self.w_dict = space.newdict(instance=True)
        return self.w_dict

    def reduce_w(self, space):
        w_dict = self.w_dict
        if w_dict is None:
            w_dict = space.newdict()
        w_type = space.type(self)
        w_fields = space.getattr(w_type, space.newtext("_fields"))
        for w_name in space.fixedview(w_fields):
            try:
                space.setitem(w_dict, w_name,
                          space.getattr(self, w_name))
            except OperationError:
                pass
        w_attrs = space.findattr(w_type, space.newtext("_attributes"))
        if w_attrs:
            for w_name in space.fixedview(w_attrs):
                try:
                    space.setitem(w_dict, w_name,
                              space.getattr(self, w_name))
                except OperationError:
                    pass
        return space.newtuple([space.type(self),
                               space.newtuple([]),
                               w_dict])

    def setstate_w(self, space, w_state):
        for w_name in space.unpackiterable(w_state):
            space.setattr(self, w_name,
                          space.getitem(w_state, w_name))

def W_AST_new(space, w_type, __args__):
    node = space.allocate_instance(W_AST, w_type)
    return node

def W_AST_init(space, w_self, __args__):
    args_w, kwargs_w = __args__.unpack()
    fields_w = space.fixedview(space.getattr(space.type(w_self),
                               space.newtext("_fields")))
    num_fields = len(fields_w) if fields_w else 0
    if args_w and len(args_w) > num_fields:
        suffix = 's' if num_fields == 1 else ''
        raise oefmt(space.w_TypeError,
            "%T constructor takes at most %d positional argument%s", w_self,
            num_fields, suffix)
    if args_w:
        for i in range(min(len(fields_w), len(args_w))):
            w_field = fields_w[i]
            w_arg = args_w[i]
            space.setattr(w_self, w_field, w_arg)
    # XXX bit wrong complexity but should be fine
    for field, w_value in kwargs_w.iteritems():
        found = len(args_w)
        for i, w_field in enumerate(fields_w):
            if space.text_w(w_field) == field:
                found = i
                break
        if found < len(args_w):
            raise oefmt(space.w_TypeError,
                "%T got multiple values for argument '%8'",
                w_self, field)
        space.setattr(w_self, space.newtext(field), w_value)


W_AST.typedef = typedef.TypeDef("_ast.AST",
    _fields=_FieldsWrapper([]),
    _attributes=_FieldsWrapper([]),
    __reduce__=interp2app(W_AST.reduce_w),
    __setstate__=interp2app(W_AST.setstate_w),
    __dict__ = typedef.GetSetProperty(typedef.descr_get_dict,
                                      typedef.descr_set_dict, cls=W_AST),
    __new__=interp2app(W_AST_new),
    __init__=interp2app(W_AST_init),
)

class State:
    AST_TYPES = []

    @classmethod
    def ast_type(cls, name, base, fields, attributes=None):
        cls.AST_TYPES.append((name, base, fields, attributes))

    def __init__(self, space):
        self.w_AST = space.gettypeobject(W_AST.typedef)
        for (name, base, fields, attributes) in self.AST_TYPES:
            self.make_new_type(space, name, base, fields, attributes)

    def make_new_type(self, space, name, base, fields, attributes):
        w_base = getattr(self, 'w_%s' % base)
        w_dict = space.newdict()
        space.setitem_str(w_dict, '__module__', space.newtext('_ast'))
        if fields is not None:
            space.setitem_str(w_dict, "_fields",
                              space.newtuple([space.newtext(f) for f in fields]))
        if attributes is not None:
            space.setitem_str(w_dict, "_attributes",
                              space.newtuple([space.newtext(a) for a in attributes]))
        w_type = space.call_function(
            space.w_type,
            space.newtext(name), space.newtuple([w_base]), w_dict)
        setattr(self, 'w_%s' % name, w_type)

def get(space):
    return space.fromcache(State)

class mod(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.is_w(w_node, space.w_None):
            return None
        if space.isinstance_w(w_node, get(space).w_Module):
            return Module.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Interactive):
            return Interactive.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Expression):
            return Expression.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Suite):
            return Suite.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_FunctionType):
            return FunctionType.from_object(space, w_node)
        raise oefmt(space.w_TypeError,
                "Expected mod node, got %T", w_node)
State.ast_type('mod', 'AST', None, [])

class Module(mod):

    def __init__(self, body, type_ignores):
        self.body = body
        self.type_ignores = type_ignores

    def walkabout(self, visitor):
        visitor.visit_Module(self)

    def mutate_over(self, visitor):
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.type_ignores:
            for i in range(len(self.type_ignores)):
                if self.type_ignores[i] is not None:
                    self.type_ignores[i] = self.type_ignores[i].mutate_over(visitor)
        return visitor.visit_Module(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Module)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.type_ignores is None:
            type_ignores_w = []
        else:
            type_ignores_w = [node.to_object(space) for node in self.type_ignores] # type_ignore
        w_type_ignores = space.newlist(type_ignores_w)
        space.setattr(w_node, space.newtext('type_ignores'), w_type_ignores)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_body = get_field(space, w_node, 'body', False)
        w_type_ignores = get_field(space, w_node, 'type_ignores', False)
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        type_ignores_w = space.unpackiterable(w_type_ignores)
        _type_ignores = [type_ignore.from_object(space, w_item) for w_item in type_ignores_w]
        return Module(_body, _type_ignores)

State.ast_type('Module', 'mod', ['body', 'type_ignores'])


class Interactive(mod):

    def __init__(self, body):
        self.body = body

    def walkabout(self, visitor):
        visitor.visit_Interactive(self)

    def mutate_over(self, visitor):
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        return visitor.visit_Interactive(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Interactive)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_body = get_field(space, w_node, 'body', False)
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        return Interactive(_body)

State.ast_type('Interactive', 'mod', ['body'])


class Expression(mod):

    def __init__(self, body):
        self.body = body

    def walkabout(self, visitor):
        visitor.visit_Expression(self)

    def mutate_over(self, visitor):
        self.body = self.body.mutate_over(visitor)
        return visitor.visit_Expression(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Expression)
        w_body = self.body.to_object(space)  # expr
        space.setattr(w_node, space.newtext('body'), w_body)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_body = get_field(space, w_node, 'body', False)
        _body = expr.from_object(space, w_body)
        if _body is None:
            raise_required_value(space, w_node, 'body')
        return Expression(_body)

State.ast_type('Expression', 'mod', ['body'])


class Suite(mod):

    def __init__(self, body):
        self.body = body

    def walkabout(self, visitor):
        visitor.visit_Suite(self)

    def mutate_over(self, visitor):
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        return visitor.visit_Suite(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Suite)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_body = get_field(space, w_node, 'body', False)
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        return Suite(_body)

State.ast_type('Suite', 'mod', ['body'])


class FunctionType(mod):

    def __init__(self, argtypes, returns):
        self.argtypes = argtypes
        self.returns = returns

    def walkabout(self, visitor):
        visitor.visit_FunctionType(self)

    def mutate_over(self, visitor):
        if self.argtypes:
            for i in range(len(self.argtypes)):
                if self.argtypes[i] is not None:
                    self.argtypes[i] = self.argtypes[i].mutate_over(visitor)
        self.returns = self.returns.mutate_over(visitor)
        return visitor.visit_FunctionType(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_FunctionType)
        if self.argtypes is None:
            argtypes_w = []
        else:
            argtypes_w = [node.to_object(space) for node in self.argtypes] # expr
        w_argtypes = space.newlist(argtypes_w)
        space.setattr(w_node, space.newtext('argtypes'), w_argtypes)
        w_returns = self.returns.to_object(space)  # expr
        space.setattr(w_node, space.newtext('returns'), w_returns)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_argtypes = get_field(space, w_node, 'argtypes', False)
        w_returns = get_field(space, w_node, 'returns', False)
        argtypes_w = space.unpackiterable(w_argtypes)
        _argtypes = [expr.from_object(space, w_item) for w_item in argtypes_w]
        _returns = expr.from_object(space, w_returns)
        if _returns is None:
            raise_required_value(space, w_node, 'returns')
        return FunctionType(_argtypes, _returns)

State.ast_type('FunctionType', 'mod', ['argtypes', 'returns'])


class stmt(AST):

    def __init__(self, lineno, col_offset, end_lineno, end_col_offset):
        self.lineno = lineno
        self.col_offset = col_offset
        self.end_lineno = end_lineno
        self.end_col_offset = end_col_offset

    @staticmethod
    def from_object(space, w_node):
        if space.is_w(w_node, space.w_None):
            return None
        if space.isinstance_w(w_node, get(space).w_FunctionDef):
            return FunctionDef.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_AsyncFunctionDef):
            return AsyncFunctionDef.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_ClassDef):
            return ClassDef.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Return):
            return Return.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Delete):
            return Delete.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Assign):
            return Assign.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_AugAssign):
            return AugAssign.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_AnnAssign):
            return AnnAssign.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_For):
            return For.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_AsyncFor):
            return AsyncFor.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_While):
            return While.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_If):
            return If.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_With):
            return With.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_AsyncWith):
            return AsyncWith.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Raise):
            return Raise.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Try):
            return Try.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Assert):
            return Assert.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Import):
            return Import.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_ImportFrom):
            return ImportFrom.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Global):
            return Global.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Nonlocal):
            return Nonlocal.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Expr):
            return Expr.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Pass):
            return Pass.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Break):
            return Break.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Continue):
            return Continue.from_object(space, w_node)
        raise oefmt(space.w_TypeError,
                "Expected stmt node, got %T", w_node)
State.ast_type('stmt', 'AST', None, ['lineno', 'col_offset', 'end_lineno', 'end_col_offset'])

class FunctionDef(stmt):

    def __init__(self, name, args, body, decorator_list, returns, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.name = name
        self.args = args
        self.body = body
        self.decorator_list = decorator_list
        self.returns = returns
        self.type_comment = type_comment
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_FunctionDef(self)

    def mutate_over(self, visitor):
        self.args = self.args.mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.decorator_list:
            for i in range(len(self.decorator_list)):
                if self.decorator_list[i] is not None:
                    self.decorator_list[i] = self.decorator_list[i].mutate_over(visitor)
        if self.returns:
            self.returns = self.returns.mutate_over(visitor)
        return visitor.visit_FunctionDef(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_FunctionDef)
        w_name = space.newtext(self.name)  # identifier
        space.setattr(w_node, space.newtext('name'), w_name)
        w_args = self.args.to_object(space)  # arguments
        space.setattr(w_node, space.newtext('args'), w_args)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.decorator_list is None:
            decorator_list_w = []
        else:
            decorator_list_w = [node.to_object(space) for node in self.decorator_list] # expr
        w_decorator_list = space.newlist(decorator_list_w)
        space.setattr(w_node, space.newtext('decorator_list'), w_decorator_list)
        w_returns = self.returns.to_object(space) if self.returns is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('returns'), w_returns)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_name = get_field(space, w_node, 'name', False)
        w_args = get_field(space, w_node, 'args', False)
        w_body = get_field(space, w_node, 'body', False)
        w_decorator_list = get_field(space, w_node, 'decorator_list', False)
        w_returns = get_field(space, w_node, 'returns', True)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _name = space.text_w(w_name)
        if _name is None:
            raise_required_value(space, w_node, 'name')
        _args = arguments.from_object(space, w_args)
        if _args is None:
            raise_required_value(space, w_node, 'args')
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        decorator_list_w = space.unpackiterable(w_decorator_list)
        _decorator_list = [expr.from_object(space, w_item) for w_item in decorator_list_w]
        _returns = expr.from_object(space, w_returns)
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return FunctionDef(_name, _args, _body, _decorator_list, _returns, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('FunctionDef', 'stmt', ['name', 'args', 'body', 'decorator_list', 'returns', 'type_comment'])


class AsyncFunctionDef(stmt):

    def __init__(self, name, args, body, decorator_list, returns, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.name = name
        self.args = args
        self.body = body
        self.decorator_list = decorator_list
        self.returns = returns
        self.type_comment = type_comment
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_AsyncFunctionDef(self)

    def mutate_over(self, visitor):
        self.args = self.args.mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.decorator_list:
            for i in range(len(self.decorator_list)):
                if self.decorator_list[i] is not None:
                    self.decorator_list[i] = self.decorator_list[i].mutate_over(visitor)
        if self.returns:
            self.returns = self.returns.mutate_over(visitor)
        return visitor.visit_AsyncFunctionDef(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_AsyncFunctionDef)
        w_name = space.newtext(self.name)  # identifier
        space.setattr(w_node, space.newtext('name'), w_name)
        w_args = self.args.to_object(space)  # arguments
        space.setattr(w_node, space.newtext('args'), w_args)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.decorator_list is None:
            decorator_list_w = []
        else:
            decorator_list_w = [node.to_object(space) for node in self.decorator_list] # expr
        w_decorator_list = space.newlist(decorator_list_w)
        space.setattr(w_node, space.newtext('decorator_list'), w_decorator_list)
        w_returns = self.returns.to_object(space) if self.returns is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('returns'), w_returns)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_name = get_field(space, w_node, 'name', False)
        w_args = get_field(space, w_node, 'args', False)
        w_body = get_field(space, w_node, 'body', False)
        w_decorator_list = get_field(space, w_node, 'decorator_list', False)
        w_returns = get_field(space, w_node, 'returns', True)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _name = space.text_w(w_name)
        if _name is None:
            raise_required_value(space, w_node, 'name')
        _args = arguments.from_object(space, w_args)
        if _args is None:
            raise_required_value(space, w_node, 'args')
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        decorator_list_w = space.unpackiterable(w_decorator_list)
        _decorator_list = [expr.from_object(space, w_item) for w_item in decorator_list_w]
        _returns = expr.from_object(space, w_returns)
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return AsyncFunctionDef(_name, _args, _body, _decorator_list, _returns, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('AsyncFunctionDef', 'stmt', ['name', 'args', 'body', 'decorator_list', 'returns', 'type_comment'])


class ClassDef(stmt):

    def __init__(self, name, bases, keywords, body, decorator_list, lineno, col_offset, end_lineno, end_col_offset):
        self.name = name
        self.bases = bases
        self.keywords = keywords
        self.body = body
        self.decorator_list = decorator_list
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_ClassDef(self)

    def mutate_over(self, visitor):
        if self.bases:
            for i in range(len(self.bases)):
                if self.bases[i] is not None:
                    self.bases[i] = self.bases[i].mutate_over(visitor)
        if self.keywords:
            for i in range(len(self.keywords)):
                if self.keywords[i] is not None:
                    self.keywords[i] = self.keywords[i].mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.decorator_list:
            for i in range(len(self.decorator_list)):
                if self.decorator_list[i] is not None:
                    self.decorator_list[i] = self.decorator_list[i].mutate_over(visitor)
        return visitor.visit_ClassDef(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_ClassDef)
        w_name = space.newtext(self.name)  # identifier
        space.setattr(w_node, space.newtext('name'), w_name)
        if self.bases is None:
            bases_w = []
        else:
            bases_w = [node.to_object(space) for node in self.bases] # expr
        w_bases = space.newlist(bases_w)
        space.setattr(w_node, space.newtext('bases'), w_bases)
        if self.keywords is None:
            keywords_w = []
        else:
            keywords_w = [node.to_object(space) for node in self.keywords] # keyword
        w_keywords = space.newlist(keywords_w)
        space.setattr(w_node, space.newtext('keywords'), w_keywords)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.decorator_list is None:
            decorator_list_w = []
        else:
            decorator_list_w = [node.to_object(space) for node in self.decorator_list] # expr
        w_decorator_list = space.newlist(decorator_list_w)
        space.setattr(w_node, space.newtext('decorator_list'), w_decorator_list)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_name = get_field(space, w_node, 'name', False)
        w_bases = get_field(space, w_node, 'bases', False)
        w_keywords = get_field(space, w_node, 'keywords', False)
        w_body = get_field(space, w_node, 'body', False)
        w_decorator_list = get_field(space, w_node, 'decorator_list', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _name = space.text_w(w_name)
        if _name is None:
            raise_required_value(space, w_node, 'name')
        bases_w = space.unpackiterable(w_bases)
        _bases = [expr.from_object(space, w_item) for w_item in bases_w]
        keywords_w = space.unpackiterable(w_keywords)
        _keywords = [keyword.from_object(space, w_item) for w_item in keywords_w]
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        decorator_list_w = space.unpackiterable(w_decorator_list)
        _decorator_list = [expr.from_object(space, w_item) for w_item in decorator_list_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return ClassDef(_name, _bases, _keywords, _body, _decorator_list, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('ClassDef', 'stmt', ['name', 'bases', 'keywords', 'body', 'decorator_list'])


class Return(stmt):

    def __init__(self, value, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Return(self)

    def mutate_over(self, visitor):
        if self.value:
            self.value = self.value.mutate_over(visitor)
        return visitor.visit_Return(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Return)
        w_value = self.value.to_object(space) if self.value is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Return(_value, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Return', 'stmt', ['value'])


class Delete(stmt):

    def __init__(self, targets, lineno, col_offset, end_lineno, end_col_offset):
        self.targets = targets
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Delete(self)

    def mutate_over(self, visitor):
        if self.targets:
            for i in range(len(self.targets)):
                if self.targets[i] is not None:
                    self.targets[i] = self.targets[i].mutate_over(visitor)
        return visitor.visit_Delete(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Delete)
        if self.targets is None:
            targets_w = []
        else:
            targets_w = [node.to_object(space) for node in self.targets] # expr
        w_targets = space.newlist(targets_w)
        space.setattr(w_node, space.newtext('targets'), w_targets)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_targets = get_field(space, w_node, 'targets', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        targets_w = space.unpackiterable(w_targets)
        _targets = [expr.from_object(space, w_item) for w_item in targets_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Delete(_targets, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Delete', 'stmt', ['targets'])


class Assign(stmt):

    def __init__(self, targets, value, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.targets = targets
        self.value = value
        self.type_comment = type_comment
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Assign(self)

    def mutate_over(self, visitor):
        if self.targets:
            for i in range(len(self.targets)):
                if self.targets[i] is not None:
                    self.targets[i] = self.targets[i].mutate_over(visitor)
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Assign(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Assign)
        if self.targets is None:
            targets_w = []
        else:
            targets_w = [node.to_object(space) for node in self.targets] # expr
        w_targets = space.newlist(targets_w)
        space.setattr(w_node, space.newtext('targets'), w_targets)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_targets = get_field(space, w_node, 'targets', False)
        w_value = get_field(space, w_node, 'value', False)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        targets_w = space.unpackiterable(w_targets)
        _targets = [expr.from_object(space, w_item) for w_item in targets_w]
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Assign(_targets, _value, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Assign', 'stmt', ['targets', 'value', 'type_comment'])


class AugAssign(stmt):

    def __init__(self, target, op, value, lineno, col_offset, end_lineno, end_col_offset):
        self.target = target
        self.op = op
        self.value = value
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_AugAssign(self)

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_AugAssign(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_AugAssign)
        w_target = self.target.to_object(space)  # expr
        space.setattr(w_node, space.newtext('target'), w_target)
        w_op = operator_to_class[self.op - 1]().to_object(space)  # operator
        space.setattr(w_node, space.newtext('op'), w_op)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_target = get_field(space, w_node, 'target', False)
        w_op = get_field(space, w_node, 'op', False)
        w_value = get_field(space, w_node, 'value', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _target = expr.from_object(space, w_target)
        if _target is None:
            raise_required_value(space, w_node, 'target')
        _op = operator.from_object(space, w_op)
        if _op is None:
            raise_required_value(space, w_node, 'op')
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return AugAssign(_target, _op, _value, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('AugAssign', 'stmt', ['target', 'op', 'value'])


class AnnAssign(stmt):

    def __init__(self, target, annotation, value, simple, lineno, col_offset, end_lineno, end_col_offset):
        self.target = target
        self.annotation = annotation
        self.value = value
        self.simple = simple
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_AnnAssign(self)

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.annotation = self.annotation.mutate_over(visitor)
        if self.value:
            self.value = self.value.mutate_over(visitor)
        return visitor.visit_AnnAssign(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_AnnAssign)
        w_target = self.target.to_object(space)  # expr
        space.setattr(w_node, space.newtext('target'), w_target)
        w_annotation = self.annotation.to_object(space)  # expr
        space.setattr(w_node, space.newtext('annotation'), w_annotation)
        w_value = self.value.to_object(space) if self.value is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_simple = space.newint(self.simple)  # int
        space.setattr(w_node, space.newtext('simple'), w_simple)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_target = get_field(space, w_node, 'target', False)
        w_annotation = get_field(space, w_node, 'annotation', False)
        w_value = get_field(space, w_node, 'value', True)
        w_simple = get_field(space, w_node, 'simple', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _target = expr.from_object(space, w_target)
        if _target is None:
            raise_required_value(space, w_node, 'target')
        _annotation = expr.from_object(space, w_annotation)
        if _annotation is None:
            raise_required_value(space, w_node, 'annotation')
        _value = expr.from_object(space, w_value)
        _simple = obj_to_int(space, w_simple, False)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return AnnAssign(_target, _annotation, _value, _simple, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('AnnAssign', 'stmt', ['target', 'annotation', 'value', 'simple'])


class For(stmt):

    def __init__(self, target, iter, body, orelse, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.target = target
        self.iter = iter
        self.body = body
        self.orelse = orelse
        self.type_comment = type_comment
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_For(self)

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.iter = self.iter.mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.orelse:
            for i in range(len(self.orelse)):
                if self.orelse[i] is not None:
                    self.orelse[i] = self.orelse[i].mutate_over(visitor)
        return visitor.visit_For(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_For)
        w_target = self.target.to_object(space)  # expr
        space.setattr(w_node, space.newtext('target'), w_target)
        w_iter = self.iter.to_object(space)  # expr
        space.setattr(w_node, space.newtext('iter'), w_iter)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.orelse is None:
            orelse_w = []
        else:
            orelse_w = [node.to_object(space) for node in self.orelse] # stmt
        w_orelse = space.newlist(orelse_w)
        space.setattr(w_node, space.newtext('orelse'), w_orelse)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_target = get_field(space, w_node, 'target', False)
        w_iter = get_field(space, w_node, 'iter', False)
        w_body = get_field(space, w_node, 'body', False)
        w_orelse = get_field(space, w_node, 'orelse', False)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _target = expr.from_object(space, w_target)
        if _target is None:
            raise_required_value(space, w_node, 'target')
        _iter = expr.from_object(space, w_iter)
        if _iter is None:
            raise_required_value(space, w_node, 'iter')
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        orelse_w = space.unpackiterable(w_orelse)
        _orelse = [stmt.from_object(space, w_item) for w_item in orelse_w]
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return For(_target, _iter, _body, _orelse, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('For', 'stmt', ['target', 'iter', 'body', 'orelse', 'type_comment'])


class AsyncFor(stmt):

    def __init__(self, target, iter, body, orelse, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.target = target
        self.iter = iter
        self.body = body
        self.orelse = orelse
        self.type_comment = type_comment
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_AsyncFor(self)

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.iter = self.iter.mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.orelse:
            for i in range(len(self.orelse)):
                if self.orelse[i] is not None:
                    self.orelse[i] = self.orelse[i].mutate_over(visitor)
        return visitor.visit_AsyncFor(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_AsyncFor)
        w_target = self.target.to_object(space)  # expr
        space.setattr(w_node, space.newtext('target'), w_target)
        w_iter = self.iter.to_object(space)  # expr
        space.setattr(w_node, space.newtext('iter'), w_iter)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.orelse is None:
            orelse_w = []
        else:
            orelse_w = [node.to_object(space) for node in self.orelse] # stmt
        w_orelse = space.newlist(orelse_w)
        space.setattr(w_node, space.newtext('orelse'), w_orelse)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_target = get_field(space, w_node, 'target', False)
        w_iter = get_field(space, w_node, 'iter', False)
        w_body = get_field(space, w_node, 'body', False)
        w_orelse = get_field(space, w_node, 'orelse', False)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _target = expr.from_object(space, w_target)
        if _target is None:
            raise_required_value(space, w_node, 'target')
        _iter = expr.from_object(space, w_iter)
        if _iter is None:
            raise_required_value(space, w_node, 'iter')
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        orelse_w = space.unpackiterable(w_orelse)
        _orelse = [stmt.from_object(space, w_item) for w_item in orelse_w]
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return AsyncFor(_target, _iter, _body, _orelse, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('AsyncFor', 'stmt', ['target', 'iter', 'body', 'orelse', 'type_comment'])


class While(stmt):

    def __init__(self, test, body, orelse, lineno, col_offset, end_lineno, end_col_offset):
        self.test = test
        self.body = body
        self.orelse = orelse
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_While(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.orelse:
            for i in range(len(self.orelse)):
                if self.orelse[i] is not None:
                    self.orelse[i] = self.orelse[i].mutate_over(visitor)
        return visitor.visit_While(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_While)
        w_test = self.test.to_object(space)  # expr
        space.setattr(w_node, space.newtext('test'), w_test)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.orelse is None:
            orelse_w = []
        else:
            orelse_w = [node.to_object(space) for node in self.orelse] # stmt
        w_orelse = space.newlist(orelse_w)
        space.setattr(w_node, space.newtext('orelse'), w_orelse)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_test = get_field(space, w_node, 'test', False)
        w_body = get_field(space, w_node, 'body', False)
        w_orelse = get_field(space, w_node, 'orelse', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _test = expr.from_object(space, w_test)
        if _test is None:
            raise_required_value(space, w_node, 'test')
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        orelse_w = space.unpackiterable(w_orelse)
        _orelse = [stmt.from_object(space, w_item) for w_item in orelse_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return While(_test, _body, _orelse, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('While', 'stmt', ['test', 'body', 'orelse'])


class If(stmt):

    def __init__(self, test, body, orelse, lineno, col_offset, end_lineno, end_col_offset):
        self.test = test
        self.body = body
        self.orelse = orelse
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_If(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.orelse:
            for i in range(len(self.orelse)):
                if self.orelse[i] is not None:
                    self.orelse[i] = self.orelse[i].mutate_over(visitor)
        return visitor.visit_If(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_If)
        w_test = self.test.to_object(space)  # expr
        space.setattr(w_node, space.newtext('test'), w_test)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.orelse is None:
            orelse_w = []
        else:
            orelse_w = [node.to_object(space) for node in self.orelse] # stmt
        w_orelse = space.newlist(orelse_w)
        space.setattr(w_node, space.newtext('orelse'), w_orelse)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_test = get_field(space, w_node, 'test', False)
        w_body = get_field(space, w_node, 'body', False)
        w_orelse = get_field(space, w_node, 'orelse', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _test = expr.from_object(space, w_test)
        if _test is None:
            raise_required_value(space, w_node, 'test')
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        orelse_w = space.unpackiterable(w_orelse)
        _orelse = [stmt.from_object(space, w_item) for w_item in orelse_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return If(_test, _body, _orelse, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('If', 'stmt', ['test', 'body', 'orelse'])


class With(stmt):

    def __init__(self, items, body, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.items = items
        self.body = body
        self.type_comment = type_comment
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_With(self)

    def mutate_over(self, visitor):
        if self.items:
            for i in range(len(self.items)):
                if self.items[i] is not None:
                    self.items[i] = self.items[i].mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        return visitor.visit_With(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_With)
        if self.items is None:
            items_w = []
        else:
            items_w = [node.to_object(space) for node in self.items] # withitem
        w_items = space.newlist(items_w)
        space.setattr(w_node, space.newtext('items'), w_items)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_items = get_field(space, w_node, 'items', False)
        w_body = get_field(space, w_node, 'body', False)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        items_w = space.unpackiterable(w_items)
        _items = [withitem.from_object(space, w_item) for w_item in items_w]
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return With(_items, _body, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('With', 'stmt', ['items', 'body', 'type_comment'])


class AsyncWith(stmt):

    def __init__(self, items, body, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.items = items
        self.body = body
        self.type_comment = type_comment
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_AsyncWith(self)

    def mutate_over(self, visitor):
        if self.items:
            for i in range(len(self.items)):
                if self.items[i] is not None:
                    self.items[i] = self.items[i].mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        return visitor.visit_AsyncWith(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_AsyncWith)
        if self.items is None:
            items_w = []
        else:
            items_w = [node.to_object(space) for node in self.items] # withitem
        w_items = space.newlist(items_w)
        space.setattr(w_node, space.newtext('items'), w_items)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_items = get_field(space, w_node, 'items', False)
        w_body = get_field(space, w_node, 'body', False)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        items_w = space.unpackiterable(w_items)
        _items = [withitem.from_object(space, w_item) for w_item in items_w]
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return AsyncWith(_items, _body, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('AsyncWith', 'stmt', ['items', 'body', 'type_comment'])


class Raise(stmt):

    def __init__(self, exc, cause, lineno, col_offset, end_lineno, end_col_offset):
        self.exc = exc
        self.cause = cause
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Raise(self)

    def mutate_over(self, visitor):
        if self.exc:
            self.exc = self.exc.mutate_over(visitor)
        if self.cause:
            self.cause = self.cause.mutate_over(visitor)
        return visitor.visit_Raise(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Raise)
        w_exc = self.exc.to_object(space) if self.exc is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('exc'), w_exc)
        w_cause = self.cause.to_object(space) if self.cause is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('cause'), w_cause)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_exc = get_field(space, w_node, 'exc', True)
        w_cause = get_field(space, w_node, 'cause', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _exc = expr.from_object(space, w_exc)
        _cause = expr.from_object(space, w_cause)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Raise(_exc, _cause, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Raise', 'stmt', ['exc', 'cause'])


class Try(stmt):

    def __init__(self, body, handlers, orelse, finalbody, lineno, col_offset, end_lineno, end_col_offset):
        self.body = body
        self.handlers = handlers
        self.orelse = orelse
        self.finalbody = finalbody
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Try(self)

    def mutate_over(self, visitor):
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        if self.handlers:
            for i in range(len(self.handlers)):
                if self.handlers[i] is not None:
                    self.handlers[i] = self.handlers[i].mutate_over(visitor)
        if self.orelse:
            for i in range(len(self.orelse)):
                if self.orelse[i] is not None:
                    self.orelse[i] = self.orelse[i].mutate_over(visitor)
        if self.finalbody:
            for i in range(len(self.finalbody)):
                if self.finalbody[i] is not None:
                    self.finalbody[i] = self.finalbody[i].mutate_over(visitor)
        return visitor.visit_Try(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Try)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        if self.handlers is None:
            handlers_w = []
        else:
            handlers_w = [node.to_object(space) for node in self.handlers] # excepthandler
        w_handlers = space.newlist(handlers_w)
        space.setattr(w_node, space.newtext('handlers'), w_handlers)
        if self.orelse is None:
            orelse_w = []
        else:
            orelse_w = [node.to_object(space) for node in self.orelse] # stmt
        w_orelse = space.newlist(orelse_w)
        space.setattr(w_node, space.newtext('orelse'), w_orelse)
        if self.finalbody is None:
            finalbody_w = []
        else:
            finalbody_w = [node.to_object(space) for node in self.finalbody] # stmt
        w_finalbody = space.newlist(finalbody_w)
        space.setattr(w_node, space.newtext('finalbody'), w_finalbody)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_body = get_field(space, w_node, 'body', False)
        w_handlers = get_field(space, w_node, 'handlers', False)
        w_orelse = get_field(space, w_node, 'orelse', False)
        w_finalbody = get_field(space, w_node, 'finalbody', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        handlers_w = space.unpackiterable(w_handlers)
        _handlers = [excepthandler.from_object(space, w_item) for w_item in handlers_w]
        orelse_w = space.unpackiterable(w_orelse)
        _orelse = [stmt.from_object(space, w_item) for w_item in orelse_w]
        finalbody_w = space.unpackiterable(w_finalbody)
        _finalbody = [stmt.from_object(space, w_item) for w_item in finalbody_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Try(_body, _handlers, _orelse, _finalbody, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Try', 'stmt', ['body', 'handlers', 'orelse', 'finalbody'])


class Assert(stmt):

    def __init__(self, test, msg, lineno, col_offset, end_lineno, end_col_offset):
        self.test = test
        self.msg = msg
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Assert(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        if self.msg:
            self.msg = self.msg.mutate_over(visitor)
        return visitor.visit_Assert(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Assert)
        w_test = self.test.to_object(space)  # expr
        space.setattr(w_node, space.newtext('test'), w_test)
        w_msg = self.msg.to_object(space) if self.msg is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('msg'), w_msg)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_test = get_field(space, w_node, 'test', False)
        w_msg = get_field(space, w_node, 'msg', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _test = expr.from_object(space, w_test)
        if _test is None:
            raise_required_value(space, w_node, 'test')
        _msg = expr.from_object(space, w_msg)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Assert(_test, _msg, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Assert', 'stmt', ['test', 'msg'])


class Import(stmt):

    def __init__(self, names, lineno, col_offset, end_lineno, end_col_offset):
        self.names = names
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Import(self)

    def mutate_over(self, visitor):
        if self.names:
            for i in range(len(self.names)):
                if self.names[i] is not None:
                    self.names[i] = self.names[i].mutate_over(visitor)
        return visitor.visit_Import(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Import)
        if self.names is None:
            names_w = []
        else:
            names_w = [node.to_object(space) for node in self.names] # alias
        w_names = space.newlist(names_w)
        space.setattr(w_node, space.newtext('names'), w_names)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_names = get_field(space, w_node, 'names', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        names_w = space.unpackiterable(w_names)
        _names = [alias.from_object(space, w_item) for w_item in names_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Import(_names, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Import', 'stmt', ['names'])


class ImportFrom(stmt):

    def __init__(self, module, names, level, lineno, col_offset, end_lineno, end_col_offset):
        self.module = module
        self.names = names
        self.level = level
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_ImportFrom(self)

    def mutate_over(self, visitor):
        if self.names:
            for i in range(len(self.names)):
                if self.names[i] is not None:
                    self.names[i] = self.names[i].mutate_over(visitor)
        return visitor.visit_ImportFrom(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_ImportFrom)
        w_module = space.newtext_or_none(self.module)  # identifier
        space.setattr(w_node, space.newtext('module'), w_module)
        if self.names is None:
            names_w = []
        else:
            names_w = [node.to_object(space) for node in self.names] # alias
        w_names = space.newlist(names_w)
        space.setattr(w_node, space.newtext('names'), w_names)
        w_level = space.newint(self.level)  # int
        space.setattr(w_node, space.newtext('level'), w_level)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_module = get_field(space, w_node, 'module', True)
        w_names = get_field(space, w_node, 'names', False)
        w_level = get_field(space, w_node, 'level', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _module = space.text_or_none_w(w_module)
        names_w = space.unpackiterable(w_names)
        _names = [alias.from_object(space, w_item) for w_item in names_w]
        _level = obj_to_int(space, w_level, True)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return ImportFrom(_module, _names, _level, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('ImportFrom', 'stmt', ['module', 'names', 'level'])


class Global(stmt):

    def __init__(self, names, lineno, col_offset, end_lineno, end_col_offset):
        self.names = names
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Global(self)

    def mutate_over(self, visitor):
        return visitor.visit_Global(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Global)
        if self.names is None:
            names_w = []
        else:
            names_w = [space.newtext(node) for node in self.names] # identifier
        w_names = space.newlist(names_w)
        space.setattr(w_node, space.newtext('names'), w_names)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_names = get_field(space, w_node, 'names', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        names_w = space.unpackiterable(w_names)
        _names = [space.text_w(w_item) for w_item in names_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Global(_names, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Global', 'stmt', ['names'])


class Nonlocal(stmt):

    def __init__(self, names, lineno, col_offset, end_lineno, end_col_offset):
        self.names = names
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Nonlocal(self)

    def mutate_over(self, visitor):
        return visitor.visit_Nonlocal(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Nonlocal)
        if self.names is None:
            names_w = []
        else:
            names_w = [space.newtext(node) for node in self.names] # identifier
        w_names = space.newlist(names_w)
        space.setattr(w_node, space.newtext('names'), w_names)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_names = get_field(space, w_node, 'names', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        names_w = space.unpackiterable(w_names)
        _names = [space.text_w(w_item) for w_item in names_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Nonlocal(_names, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Nonlocal', 'stmt', ['names'])


class Expr(stmt):

    def __init__(self, value, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Expr(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Expr(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Expr)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Expr(_value, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Expr', 'stmt', ['value'])


class Pass(stmt):

    def __init__(self, lineno, col_offset, end_lineno, end_col_offset):
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Pass(self)

    def mutate_over(self, visitor):
        return visitor.visit_Pass(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Pass)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Pass(_lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Pass', 'stmt', [])


class Break(stmt):

    def __init__(self, lineno, col_offset, end_lineno, end_col_offset):
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Break(self)

    def mutate_over(self, visitor):
        return visitor.visit_Break(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Break)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Break(_lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Break', 'stmt', [])


class Continue(stmt):

    def __init__(self, lineno, col_offset, end_lineno, end_col_offset):
        stmt.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Continue(self)

    def mutate_over(self, visitor):
        return visitor.visit_Continue(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Continue)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Continue(_lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Continue', 'stmt', [])


class expr(AST):

    def __init__(self, lineno, col_offset, end_lineno, end_col_offset):
        self.lineno = lineno
        self.col_offset = col_offset
        self.end_lineno = end_lineno
        self.end_col_offset = end_col_offset

    @staticmethod
    def from_object(space, w_node):
        if space.is_w(w_node, space.w_None):
            return None
        if space.isinstance_w(w_node, get(space).w_BoolOp):
            return BoolOp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_NamedExpr):
            return NamedExpr.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_BinOp):
            return BinOp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_UnaryOp):
            return UnaryOp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Lambda):
            return Lambda.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_IfExp):
            return IfExp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Dict):
            return Dict.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Set):
            return Set.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_ListComp):
            return ListComp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_SetComp):
            return SetComp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_DictComp):
            return DictComp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_GeneratorExp):
            return GeneratorExp.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Await):
            return Await.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Yield):
            return Yield.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_YieldFrom):
            return YieldFrom.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Compare):
            return Compare.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Call):
            return Call.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_RevDBMetaVar):
            return RevDBMetaVar.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_FormattedValue):
            return FormattedValue.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_JoinedStr):
            return JoinedStr.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Constant):
            return Constant.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Attribute):
            return Attribute.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Subscript):
            return Subscript.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Starred):
            return Starred.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Name):
            return Name.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_List):
            return List.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Tuple):
            return Tuple.from_object(space, w_node)
        raise oefmt(space.w_TypeError,
                "Expected expr node, got %T", w_node)
State.ast_type('expr', 'AST', None, ['lineno', 'col_offset', 'end_lineno', 'end_col_offset'])

class BoolOp(expr):

    def __init__(self, op, values, lineno, col_offset, end_lineno, end_col_offset):
        self.op = op
        self.values = values
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_BoolOp(self)

    def mutate_over(self, visitor):
        if self.values:
            for i in range(len(self.values)):
                if self.values[i] is not None:
                    self.values[i] = self.values[i].mutate_over(visitor)
        return visitor.visit_BoolOp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_BoolOp)
        w_op = boolop_to_class[self.op - 1]().to_object(space)  # boolop
        space.setattr(w_node, space.newtext('op'), w_op)
        if self.values is None:
            values_w = []
        else:
            values_w = [node.to_object(space) for node in self.values] # expr
        w_values = space.newlist(values_w)
        space.setattr(w_node, space.newtext('values'), w_values)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_op = get_field(space, w_node, 'op', False)
        w_values = get_field(space, w_node, 'values', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _op = boolop.from_object(space, w_op)
        if _op is None:
            raise_required_value(space, w_node, 'op')
        values_w = space.unpackiterable(w_values)
        _values = [expr.from_object(space, w_item) for w_item in values_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return BoolOp(_op, _values, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('BoolOp', 'expr', ['op', 'values'])


class NamedExpr(expr):

    def __init__(self, target, value, lineno, col_offset, end_lineno, end_col_offset):
        self.target = target
        self.value = value
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_NamedExpr(self)

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_NamedExpr(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_NamedExpr)
        w_target = self.target.to_object(space)  # expr
        space.setattr(w_node, space.newtext('target'), w_target)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_target = get_field(space, w_node, 'target', False)
        w_value = get_field(space, w_node, 'value', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _target = expr.from_object(space, w_target)
        if _target is None:
            raise_required_value(space, w_node, 'target')
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return NamedExpr(_target, _value, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('NamedExpr', 'expr', ['target', 'value'])


class BinOp(expr):

    def __init__(self, left, op, right, lineno, col_offset, end_lineno, end_col_offset):
        self.left = left
        self.op = op
        self.right = right
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_BinOp(self)

    def mutate_over(self, visitor):
        self.left = self.left.mutate_over(visitor)
        self.right = self.right.mutate_over(visitor)
        return visitor.visit_BinOp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_BinOp)
        w_left = self.left.to_object(space)  # expr
        space.setattr(w_node, space.newtext('left'), w_left)
        w_op = operator_to_class[self.op - 1]().to_object(space)  # operator
        space.setattr(w_node, space.newtext('op'), w_op)
        w_right = self.right.to_object(space)  # expr
        space.setattr(w_node, space.newtext('right'), w_right)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_left = get_field(space, w_node, 'left', False)
        w_op = get_field(space, w_node, 'op', False)
        w_right = get_field(space, w_node, 'right', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _left = expr.from_object(space, w_left)
        if _left is None:
            raise_required_value(space, w_node, 'left')
        _op = operator.from_object(space, w_op)
        if _op is None:
            raise_required_value(space, w_node, 'op')
        _right = expr.from_object(space, w_right)
        if _right is None:
            raise_required_value(space, w_node, 'right')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return BinOp(_left, _op, _right, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('BinOp', 'expr', ['left', 'op', 'right'])


class UnaryOp(expr):

    def __init__(self, op, operand, lineno, col_offset, end_lineno, end_col_offset):
        self.op = op
        self.operand = operand
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_UnaryOp(self)

    def mutate_over(self, visitor):
        self.operand = self.operand.mutate_over(visitor)
        return visitor.visit_UnaryOp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_UnaryOp)
        w_op = unaryop_to_class[self.op - 1]().to_object(space)  # unaryop
        space.setattr(w_node, space.newtext('op'), w_op)
        w_operand = self.operand.to_object(space)  # expr
        space.setattr(w_node, space.newtext('operand'), w_operand)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_op = get_field(space, w_node, 'op', False)
        w_operand = get_field(space, w_node, 'operand', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _op = unaryop.from_object(space, w_op)
        if _op is None:
            raise_required_value(space, w_node, 'op')
        _operand = expr.from_object(space, w_operand)
        if _operand is None:
            raise_required_value(space, w_node, 'operand')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return UnaryOp(_op, _operand, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('UnaryOp', 'expr', ['op', 'operand'])


class Lambda(expr):

    def __init__(self, args, body, lineno, col_offset, end_lineno, end_col_offset):
        self.args = args
        self.body = body
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Lambda(self)

    def mutate_over(self, visitor):
        self.args = self.args.mutate_over(visitor)
        self.body = self.body.mutate_over(visitor)
        return visitor.visit_Lambda(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Lambda)
        w_args = self.args.to_object(space)  # arguments
        space.setattr(w_node, space.newtext('args'), w_args)
        w_body = self.body.to_object(space)  # expr
        space.setattr(w_node, space.newtext('body'), w_body)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_args = get_field(space, w_node, 'args', False)
        w_body = get_field(space, w_node, 'body', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _args = arguments.from_object(space, w_args)
        if _args is None:
            raise_required_value(space, w_node, 'args')
        _body = expr.from_object(space, w_body)
        if _body is None:
            raise_required_value(space, w_node, 'body')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Lambda(_args, _body, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Lambda', 'expr', ['args', 'body'])


class IfExp(expr):

    def __init__(self, test, body, orelse, lineno, col_offset, end_lineno, end_col_offset):
        self.test = test
        self.body = body
        self.orelse = orelse
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_IfExp(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        self.body = self.body.mutate_over(visitor)
        self.orelse = self.orelse.mutate_over(visitor)
        return visitor.visit_IfExp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_IfExp)
        w_test = self.test.to_object(space)  # expr
        space.setattr(w_node, space.newtext('test'), w_test)
        w_body = self.body.to_object(space)  # expr
        space.setattr(w_node, space.newtext('body'), w_body)
        w_orelse = self.orelse.to_object(space)  # expr
        space.setattr(w_node, space.newtext('orelse'), w_orelse)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_test = get_field(space, w_node, 'test', False)
        w_body = get_field(space, w_node, 'body', False)
        w_orelse = get_field(space, w_node, 'orelse', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _test = expr.from_object(space, w_test)
        if _test is None:
            raise_required_value(space, w_node, 'test')
        _body = expr.from_object(space, w_body)
        if _body is None:
            raise_required_value(space, w_node, 'body')
        _orelse = expr.from_object(space, w_orelse)
        if _orelse is None:
            raise_required_value(space, w_node, 'orelse')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return IfExp(_test, _body, _orelse, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('IfExp', 'expr', ['test', 'body', 'orelse'])


class Dict(expr):

    def __init__(self, keys, values, lineno, col_offset, end_lineno, end_col_offset):
        self.keys = keys
        self.values = values
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Dict(self)

    def mutate_over(self, visitor):
        if self.keys:
            for i in range(len(self.keys)):
                if self.keys[i] is not None:
                    self.keys[i] = self.keys[i].mutate_over(visitor)
        if self.values:
            for i in range(len(self.values)):
                if self.values[i] is not None:
                    self.values[i] = self.values[i].mutate_over(visitor)
        return visitor.visit_Dict(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Dict)
        if self.keys is None:
            keys_w = []
        else:
            keys_w = [node.to_object(space) if node is not None else space.w_None for node in self.keys] # expr
        w_keys = space.newlist(keys_w)
        space.setattr(w_node, space.newtext('keys'), w_keys)
        if self.values is None:
            values_w = []
        else:
            values_w = [node.to_object(space) for node in self.values] # expr
        w_values = space.newlist(values_w)
        space.setattr(w_node, space.newtext('values'), w_values)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_keys = get_field(space, w_node, 'keys', False)
        w_values = get_field(space, w_node, 'values', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        keys_w = space.unpackiterable(w_keys)
        _keys = [expr.from_object(space, w_item) for w_item in keys_w]
        values_w = space.unpackiterable(w_values)
        _values = [expr.from_object(space, w_item) for w_item in values_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Dict(_keys, _values, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Dict', 'expr', ['keys', 'values'])


class Set(expr):

    def __init__(self, elts, lineno, col_offset, end_lineno, end_col_offset):
        self.elts = elts
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Set(self)

    def mutate_over(self, visitor):
        if self.elts:
            for i in range(len(self.elts)):
                if self.elts[i] is not None:
                    self.elts[i] = self.elts[i].mutate_over(visitor)
        return visitor.visit_Set(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Set)
        if self.elts is None:
            elts_w = []
        else:
            elts_w = [node.to_object(space) for node in self.elts] # expr
        w_elts = space.newlist(elts_w)
        space.setattr(w_node, space.newtext('elts'), w_elts)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_elts = get_field(space, w_node, 'elts', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        elts_w = space.unpackiterable(w_elts)
        _elts = [expr.from_object(space, w_item) for w_item in elts_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Set(_elts, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Set', 'expr', ['elts'])


class ListComp(expr):

    def __init__(self, elt, generators, lineno, col_offset, end_lineno, end_col_offset):
        self.elt = elt
        self.generators = generators
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_ListComp(self)

    def mutate_over(self, visitor):
        self.elt = self.elt.mutate_over(visitor)
        if self.generators:
            for i in range(len(self.generators)):
                if self.generators[i] is not None:
                    self.generators[i] = self.generators[i].mutate_over(visitor)
        return visitor.visit_ListComp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_ListComp)
        w_elt = self.elt.to_object(space)  # expr
        space.setattr(w_node, space.newtext('elt'), w_elt)
        if self.generators is None:
            generators_w = []
        else:
            generators_w = [node.to_object(space) for node in self.generators] # comprehension
        w_generators = space.newlist(generators_w)
        space.setattr(w_node, space.newtext('generators'), w_generators)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_elt = get_field(space, w_node, 'elt', False)
        w_generators = get_field(space, w_node, 'generators', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _elt = expr.from_object(space, w_elt)
        if _elt is None:
            raise_required_value(space, w_node, 'elt')
        generators_w = space.unpackiterable(w_generators)
        _generators = [comprehension.from_object(space, w_item) for w_item in generators_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return ListComp(_elt, _generators, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('ListComp', 'expr', ['elt', 'generators'])


class SetComp(expr):

    def __init__(self, elt, generators, lineno, col_offset, end_lineno, end_col_offset):
        self.elt = elt
        self.generators = generators
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_SetComp(self)

    def mutate_over(self, visitor):
        self.elt = self.elt.mutate_over(visitor)
        if self.generators:
            for i in range(len(self.generators)):
                if self.generators[i] is not None:
                    self.generators[i] = self.generators[i].mutate_over(visitor)
        return visitor.visit_SetComp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_SetComp)
        w_elt = self.elt.to_object(space)  # expr
        space.setattr(w_node, space.newtext('elt'), w_elt)
        if self.generators is None:
            generators_w = []
        else:
            generators_w = [node.to_object(space) for node in self.generators] # comprehension
        w_generators = space.newlist(generators_w)
        space.setattr(w_node, space.newtext('generators'), w_generators)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_elt = get_field(space, w_node, 'elt', False)
        w_generators = get_field(space, w_node, 'generators', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _elt = expr.from_object(space, w_elt)
        if _elt is None:
            raise_required_value(space, w_node, 'elt')
        generators_w = space.unpackiterable(w_generators)
        _generators = [comprehension.from_object(space, w_item) for w_item in generators_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return SetComp(_elt, _generators, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('SetComp', 'expr', ['elt', 'generators'])


class DictComp(expr):

    def __init__(self, key, value, generators, lineno, col_offset, end_lineno, end_col_offset):
        self.key = key
        self.value = value
        self.generators = generators
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_DictComp(self)

    def mutate_over(self, visitor):
        self.key = self.key.mutate_over(visitor)
        self.value = self.value.mutate_over(visitor)
        if self.generators:
            for i in range(len(self.generators)):
                if self.generators[i] is not None:
                    self.generators[i] = self.generators[i].mutate_over(visitor)
        return visitor.visit_DictComp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_DictComp)
        w_key = self.key.to_object(space)  # expr
        space.setattr(w_node, space.newtext('key'), w_key)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        if self.generators is None:
            generators_w = []
        else:
            generators_w = [node.to_object(space) for node in self.generators] # comprehension
        w_generators = space.newlist(generators_w)
        space.setattr(w_node, space.newtext('generators'), w_generators)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_key = get_field(space, w_node, 'key', False)
        w_value = get_field(space, w_node, 'value', False)
        w_generators = get_field(space, w_node, 'generators', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _key = expr.from_object(space, w_key)
        if _key is None:
            raise_required_value(space, w_node, 'key')
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        generators_w = space.unpackiterable(w_generators)
        _generators = [comprehension.from_object(space, w_item) for w_item in generators_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return DictComp(_key, _value, _generators, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('DictComp', 'expr', ['key', 'value', 'generators'])


class GeneratorExp(expr):

    def __init__(self, elt, generators, lineno, col_offset, end_lineno, end_col_offset):
        self.elt = elt
        self.generators = generators
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_GeneratorExp(self)

    def mutate_over(self, visitor):
        self.elt = self.elt.mutate_over(visitor)
        if self.generators:
            for i in range(len(self.generators)):
                if self.generators[i] is not None:
                    self.generators[i] = self.generators[i].mutate_over(visitor)
        return visitor.visit_GeneratorExp(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_GeneratorExp)
        w_elt = self.elt.to_object(space)  # expr
        space.setattr(w_node, space.newtext('elt'), w_elt)
        if self.generators is None:
            generators_w = []
        else:
            generators_w = [node.to_object(space) for node in self.generators] # comprehension
        w_generators = space.newlist(generators_w)
        space.setattr(w_node, space.newtext('generators'), w_generators)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_elt = get_field(space, w_node, 'elt', False)
        w_generators = get_field(space, w_node, 'generators', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _elt = expr.from_object(space, w_elt)
        if _elt is None:
            raise_required_value(space, w_node, 'elt')
        generators_w = space.unpackiterable(w_generators)
        _generators = [comprehension.from_object(space, w_item) for w_item in generators_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return GeneratorExp(_elt, _generators, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('GeneratorExp', 'expr', ['elt', 'generators'])


class Await(expr):

    def __init__(self, value, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Await(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Await(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Await)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Await(_value, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Await', 'expr', ['value'])


class Yield(expr):

    def __init__(self, value, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Yield(self)

    def mutate_over(self, visitor):
        if self.value:
            self.value = self.value.mutate_over(visitor)
        return visitor.visit_Yield(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Yield)
        w_value = self.value.to_object(space) if self.value is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Yield(_value, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Yield', 'expr', ['value'])


class YieldFrom(expr):

    def __init__(self, value, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_YieldFrom(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_YieldFrom(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_YieldFrom)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return YieldFrom(_value, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('YieldFrom', 'expr', ['value'])


class Compare(expr):

    def __init__(self, left, ops, comparators, lineno, col_offset, end_lineno, end_col_offset):
        self.left = left
        self.ops = ops
        self.comparators = comparators
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Compare(self)

    def mutate_over(self, visitor):
        self.left = self.left.mutate_over(visitor)
        if self.comparators:
            for i in range(len(self.comparators)):
                if self.comparators[i] is not None:
                    self.comparators[i] = self.comparators[i].mutate_over(visitor)
        return visitor.visit_Compare(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Compare)
        w_left = self.left.to_object(space)  # expr
        space.setattr(w_node, space.newtext('left'), w_left)
        if self.ops is None:
            ops_w = []
        else:
            ops_w = [cmpop_to_class[node - 1]().to_object(space) for node in self.ops] # cmpop
        w_ops = space.newlist(ops_w)
        space.setattr(w_node, space.newtext('ops'), w_ops)
        if self.comparators is None:
            comparators_w = []
        else:
            comparators_w = [node.to_object(space) for node in self.comparators] # expr
        w_comparators = space.newlist(comparators_w)
        space.setattr(w_node, space.newtext('comparators'), w_comparators)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_left = get_field(space, w_node, 'left', False)
        w_ops = get_field(space, w_node, 'ops', False)
        w_comparators = get_field(space, w_node, 'comparators', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _left = expr.from_object(space, w_left)
        if _left is None:
            raise_required_value(space, w_node, 'left')
        ops_w = space.unpackiterable(w_ops)
        _ops = [cmpop.from_object(space, w_item) for w_item in ops_w]
        comparators_w = space.unpackiterable(w_comparators)
        _comparators = [expr.from_object(space, w_item) for w_item in comparators_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Compare(_left, _ops, _comparators, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Compare', 'expr', ['left', 'ops', 'comparators'])


class Call(expr):

    def __init__(self, func, args, keywords, lineno, col_offset, end_lineno, end_col_offset):
        self.func = func
        self.args = args
        self.keywords = keywords
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Call(self)

    def mutate_over(self, visitor):
        self.func = self.func.mutate_over(visitor)
        if self.args:
            for i in range(len(self.args)):
                if self.args[i] is not None:
                    self.args[i] = self.args[i].mutate_over(visitor)
        if self.keywords:
            for i in range(len(self.keywords)):
                if self.keywords[i] is not None:
                    self.keywords[i] = self.keywords[i].mutate_over(visitor)
        return visitor.visit_Call(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Call)
        w_func = self.func.to_object(space)  # expr
        space.setattr(w_node, space.newtext('func'), w_func)
        if self.args is None:
            args_w = []
        else:
            args_w = [node.to_object(space) for node in self.args] # expr
        w_args = space.newlist(args_w)
        space.setattr(w_node, space.newtext('args'), w_args)
        if self.keywords is None:
            keywords_w = []
        else:
            keywords_w = [node.to_object(space) for node in self.keywords] # keyword
        w_keywords = space.newlist(keywords_w)
        space.setattr(w_node, space.newtext('keywords'), w_keywords)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_func = get_field(space, w_node, 'func', False)
        w_args = get_field(space, w_node, 'args', False)
        w_keywords = get_field(space, w_node, 'keywords', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _func = expr.from_object(space, w_func)
        if _func is None:
            raise_required_value(space, w_node, 'func')
        args_w = space.unpackiterable(w_args)
        _args = [expr.from_object(space, w_item) for w_item in args_w]
        keywords_w = space.unpackiterable(w_keywords)
        _keywords = [keyword.from_object(space, w_item) for w_item in keywords_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Call(_func, _args, _keywords, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Call', 'expr', ['func', 'args', 'keywords'])


class RevDBMetaVar(expr):

    def __init__(self, metavar, lineno, col_offset, end_lineno, end_col_offset):
        self.metavar = metavar
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_RevDBMetaVar(self)

    def mutate_over(self, visitor):
        return visitor.visit_RevDBMetaVar(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_RevDBMetaVar)
        w_metavar = space.newint(self.metavar)  # int
        space.setattr(w_node, space.newtext('metavar'), w_metavar)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_metavar = get_field(space, w_node, 'metavar', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _metavar = obj_to_int(space, w_metavar, False)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return RevDBMetaVar(_metavar, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('RevDBMetaVar', 'expr', ['metavar'])


class FormattedValue(expr):

    def __init__(self, value, conversion, format_spec, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        self.conversion = conversion
        self.format_spec = format_spec
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_FormattedValue(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        if self.format_spec:
            self.format_spec = self.format_spec.mutate_over(visitor)
        return visitor.visit_FormattedValue(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_FormattedValue)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_conversion = space.newint(self.conversion)  # int
        space.setattr(w_node, space.newtext('conversion'), w_conversion)
        w_format_spec = self.format_spec.to_object(space) if self.format_spec is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('format_spec'), w_format_spec)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_conversion = get_field(space, w_node, 'conversion', True)
        w_format_spec = get_field(space, w_node, 'format_spec', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _conversion = obj_to_int(space, w_conversion, True)
        _format_spec = expr.from_object(space, w_format_spec)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return FormattedValue(_value, _conversion, _format_spec, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('FormattedValue', 'expr', ['value', 'conversion', 'format_spec'])


class JoinedStr(expr):

    def __init__(self, values, lineno, col_offset, end_lineno, end_col_offset):
        self.values = values
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_JoinedStr(self)

    def mutate_over(self, visitor):
        if self.values:
            for i in range(len(self.values)):
                if self.values[i] is not None:
                    self.values[i] = self.values[i].mutate_over(visitor)
        return visitor.visit_JoinedStr(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_JoinedStr)
        if self.values is None:
            values_w = []
        else:
            values_w = [node.to_object(space) for node in self.values] # expr
        w_values = space.newlist(values_w)
        space.setattr(w_node, space.newtext('values'), w_values)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_values = get_field(space, w_node, 'values', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        values_w = space.unpackiterable(w_values)
        _values = [expr.from_object(space, w_item) for w_item in values_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return JoinedStr(_values, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('JoinedStr', 'expr', ['values'])


class Constant(expr):

    def __init__(self, value, kind, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        self.kind = kind
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Constant(self)

    def mutate_over(self, visitor):
        return visitor.visit_Constant(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Constant)
        w_value = self.value  # constant
        space.setattr(w_node, space.newtext('value'), w_value)
        w_kind = self.kind  # string
        space.setattr(w_node, space.newtext('kind'), w_kind)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_kind = get_field(space, w_node, 'kind', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = w_value
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _kind = check_string(space, w_kind, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Constant(_value, _kind, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Constant', 'expr', ['value', 'kind'])


class Attribute(expr):

    def __init__(self, value, attr, ctx, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        self.attr = attr
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Attribute(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Attribute(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Attribute)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_attr = space.newtext(self.attr)  # identifier
        space.setattr(w_node, space.newtext('attr'), w_attr)
        w_ctx = expr_context_to_class[self.ctx - 1]().to_object(space)  # expr_context
        space.setattr(w_node, space.newtext('ctx'), w_ctx)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_attr = get_field(space, w_node, 'attr', False)
        w_ctx = get_field(space, w_node, 'ctx', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _attr = space.text_w(w_attr)
        if _attr is None:
            raise_required_value(space, w_node, 'attr')
        _ctx = expr_context.from_object(space, w_ctx)
        if _ctx is None:
            raise_required_value(space, w_node, 'ctx')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Attribute(_value, _attr, _ctx, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Attribute', 'expr', ['value', 'attr', 'ctx'])


class Subscript(expr):

    def __init__(self, value, slice, ctx, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        self.slice = slice
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Subscript(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        self.slice = self.slice.mutate_over(visitor)
        return visitor.visit_Subscript(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Subscript)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_slice = self.slice.to_object(space)  # slice
        space.setattr(w_node, space.newtext('slice'), w_slice)
        w_ctx = expr_context_to_class[self.ctx - 1]().to_object(space)  # expr_context
        space.setattr(w_node, space.newtext('ctx'), w_ctx)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_slice = get_field(space, w_node, 'slice', False)
        w_ctx = get_field(space, w_node, 'ctx', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _slice = slice.from_object(space, w_slice)
        if _slice is None:
            raise_required_value(space, w_node, 'slice')
        _ctx = expr_context.from_object(space, w_ctx)
        if _ctx is None:
            raise_required_value(space, w_node, 'ctx')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Subscript(_value, _slice, _ctx, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Subscript', 'expr', ['value', 'slice', 'ctx'])


class Starred(expr):

    def __init__(self, value, ctx, lineno, col_offset, end_lineno, end_col_offset):
        self.value = value
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Starred(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Starred(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Starred)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        w_ctx = expr_context_to_class[self.ctx - 1]().to_object(space)  # expr_context
        space.setattr(w_node, space.newtext('ctx'), w_ctx)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        w_ctx = get_field(space, w_node, 'ctx', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        _ctx = expr_context.from_object(space, w_ctx)
        if _ctx is None:
            raise_required_value(space, w_node, 'ctx')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Starred(_value, _ctx, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Starred', 'expr', ['value', 'ctx'])


class Name(expr):

    def __init__(self, id, ctx, lineno, col_offset, end_lineno, end_col_offset):
        self.id = id
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Name(self)

    def mutate_over(self, visitor):
        return visitor.visit_Name(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Name)
        w_id = space.newtext(self.id)  # identifier
        space.setattr(w_node, space.newtext('id'), w_id)
        w_ctx = expr_context_to_class[self.ctx - 1]().to_object(space)  # expr_context
        space.setattr(w_node, space.newtext('ctx'), w_ctx)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_id = get_field(space, w_node, 'id', False)
        w_ctx = get_field(space, w_node, 'ctx', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _id = space.text_w(w_id)
        if _id is None:
            raise_required_value(space, w_node, 'id')
        _ctx = expr_context.from_object(space, w_ctx)
        if _ctx is None:
            raise_required_value(space, w_node, 'ctx')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Name(_id, _ctx, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Name', 'expr', ['id', 'ctx'])


class List(expr):

    def __init__(self, elts, ctx, lineno, col_offset, end_lineno, end_col_offset):
        self.elts = elts
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_List(self)

    def mutate_over(self, visitor):
        if self.elts:
            for i in range(len(self.elts)):
                if self.elts[i] is not None:
                    self.elts[i] = self.elts[i].mutate_over(visitor)
        return visitor.visit_List(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_List)
        if self.elts is None:
            elts_w = []
        else:
            elts_w = [node.to_object(space) for node in self.elts] # expr
        w_elts = space.newlist(elts_w)
        space.setattr(w_node, space.newtext('elts'), w_elts)
        w_ctx = expr_context_to_class[self.ctx - 1]().to_object(space)  # expr_context
        space.setattr(w_node, space.newtext('ctx'), w_ctx)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_elts = get_field(space, w_node, 'elts', False)
        w_ctx = get_field(space, w_node, 'ctx', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        elts_w = space.unpackiterable(w_elts)
        _elts = [expr.from_object(space, w_item) for w_item in elts_w]
        _ctx = expr_context.from_object(space, w_ctx)
        if _ctx is None:
            raise_required_value(space, w_node, 'ctx')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return List(_elts, _ctx, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('List', 'expr', ['elts', 'ctx'])


class Tuple(expr):

    def __init__(self, elts, ctx, lineno, col_offset, end_lineno, end_col_offset):
        self.elts = elts
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_Tuple(self)

    def mutate_over(self, visitor):
        if self.elts:
            for i in range(len(self.elts)):
                if self.elts[i] is not None:
                    self.elts[i] = self.elts[i].mutate_over(visitor)
        return visitor.visit_Tuple(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Tuple)
        if self.elts is None:
            elts_w = []
        else:
            elts_w = [node.to_object(space) for node in self.elts] # expr
        w_elts = space.newlist(elts_w)
        space.setattr(w_node, space.newtext('elts'), w_elts)
        w_ctx = expr_context_to_class[self.ctx - 1]().to_object(space)  # expr_context
        space.setattr(w_node, space.newtext('ctx'), w_ctx)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_elts = get_field(space, w_node, 'elts', False)
        w_ctx = get_field(space, w_node, 'ctx', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        elts_w = space.unpackiterable(w_elts)
        _elts = [expr.from_object(space, w_item) for w_item in elts_w]
        _ctx = expr_context.from_object(space, w_ctx)
        if _ctx is None:
            raise_required_value(space, w_node, 'ctx')
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return Tuple(_elts, _ctx, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('Tuple', 'expr', ['elts', 'ctx'])


class expr_context(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.isinstance_w(w_node, get(space).w_Load):
            return 1
        if space.isinstance_w(w_node, get(space).w_Store):
            return 2
        if space.isinstance_w(w_node, get(space).w_Del):
            return 3
        if space.isinstance_w(w_node, get(space).w_AugLoad):
            return 4
        if space.isinstance_w(w_node, get(space).w_AugStore):
            return 5
        if space.isinstance_w(w_node, get(space).w_Param):
            return 6
        raise oefmt(space.w_TypeError,
                "Expected expr_context node, got %T", w_node)
State.ast_type('expr_context', 'AST', None)

class _Load(expr_context):
    def to_object(self, space):
        return space.call_function(get(space).w_Load)
State.ast_type('Load', 'expr_context', None)

class _Store(expr_context):
    def to_object(self, space):
        return space.call_function(get(space).w_Store)
State.ast_type('Store', 'expr_context', None)

class _Del(expr_context):
    def to_object(self, space):
        return space.call_function(get(space).w_Del)
State.ast_type('Del', 'expr_context', None)

class _AugLoad(expr_context):
    def to_object(self, space):
        return space.call_function(get(space).w_AugLoad)
State.ast_type('AugLoad', 'expr_context', None)

class _AugStore(expr_context):
    def to_object(self, space):
        return space.call_function(get(space).w_AugStore)
State.ast_type('AugStore', 'expr_context', None)

class _Param(expr_context):
    def to_object(self, space):
        return space.call_function(get(space).w_Param)
State.ast_type('Param', 'expr_context', None)

Load = 1
Store = 2
Del = 3
AugLoad = 4
AugStore = 5
Param = 6

expr_context_to_class = [
    _Load,
    _Store,
    _Del,
    _AugLoad,
    _AugStore,
    _Param,
]

class slice(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.is_w(w_node, space.w_None):
            return None
        if space.isinstance_w(w_node, get(space).w_Slice):
            return Slice.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_ExtSlice):
            return ExtSlice.from_object(space, w_node)
        if space.isinstance_w(w_node, get(space).w_Index):
            return Index.from_object(space, w_node)
        raise oefmt(space.w_TypeError,
                "Expected slice node, got %T", w_node)
State.ast_type('slice', 'AST', None, [])

class Slice(slice):

    def __init__(self, lower, upper, step):
        self.lower = lower
        self.upper = upper
        self.step = step

    def walkabout(self, visitor):
        visitor.visit_Slice(self)

    def mutate_over(self, visitor):
        if self.lower:
            self.lower = self.lower.mutate_over(visitor)
        if self.upper:
            self.upper = self.upper.mutate_over(visitor)
        if self.step:
            self.step = self.step.mutate_over(visitor)
        return visitor.visit_Slice(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Slice)
        w_lower = self.lower.to_object(space) if self.lower is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('lower'), w_lower)
        w_upper = self.upper.to_object(space) if self.upper is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('upper'), w_upper)
        w_step = self.step.to_object(space) if self.step is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('step'), w_step)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_lower = get_field(space, w_node, 'lower', True)
        w_upper = get_field(space, w_node, 'upper', True)
        w_step = get_field(space, w_node, 'step', True)
        _lower = expr.from_object(space, w_lower)
        _upper = expr.from_object(space, w_upper)
        _step = expr.from_object(space, w_step)
        return Slice(_lower, _upper, _step)

State.ast_type('Slice', 'slice', ['lower', 'upper', 'step'])


class ExtSlice(slice):

    def __init__(self, dims):
        self.dims = dims

    def walkabout(self, visitor):
        visitor.visit_ExtSlice(self)

    def mutate_over(self, visitor):
        if self.dims:
            for i in range(len(self.dims)):
                if self.dims[i] is not None:
                    self.dims[i] = self.dims[i].mutate_over(visitor)
        return visitor.visit_ExtSlice(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_ExtSlice)
        if self.dims is None:
            dims_w = []
        else:
            dims_w = [node.to_object(space) for node in self.dims] # slice
        w_dims = space.newlist(dims_w)
        space.setattr(w_node, space.newtext('dims'), w_dims)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_dims = get_field(space, w_node, 'dims', False)
        dims_w = space.unpackiterable(w_dims)
        _dims = [slice.from_object(space, w_item) for w_item in dims_w]
        return ExtSlice(_dims)

State.ast_type('ExtSlice', 'slice', ['dims'])


class Index(slice):

    def __init__(self, value):
        self.value = value

    def walkabout(self, visitor):
        visitor.visit_Index(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Index(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_Index)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_value = get_field(space, w_node, 'value', False)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        return Index(_value)

State.ast_type('Index', 'slice', ['value'])


class boolop(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.isinstance_w(w_node, get(space).w_And):
            return 1
        if space.isinstance_w(w_node, get(space).w_Or):
            return 2
        raise oefmt(space.w_TypeError,
                "Expected boolop node, got %T", w_node)
State.ast_type('boolop', 'AST', None)

class _And(boolop):
    def to_object(self, space):
        return space.call_function(get(space).w_And)
State.ast_type('And', 'boolop', None)

class _Or(boolop):
    def to_object(self, space):
        return space.call_function(get(space).w_Or)
State.ast_type('Or', 'boolop', None)

And = 1
Or = 2

boolop_to_class = [
    _And,
    _Or,
]

class operator(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.isinstance_w(w_node, get(space).w_Add):
            return 1
        if space.isinstance_w(w_node, get(space).w_Sub):
            return 2
        if space.isinstance_w(w_node, get(space).w_Mult):
            return 3
        if space.isinstance_w(w_node, get(space).w_MatMult):
            return 4
        if space.isinstance_w(w_node, get(space).w_Div):
            return 5
        if space.isinstance_w(w_node, get(space).w_Mod):
            return 6
        if space.isinstance_w(w_node, get(space).w_Pow):
            return 7
        if space.isinstance_w(w_node, get(space).w_LShift):
            return 8
        if space.isinstance_w(w_node, get(space).w_RShift):
            return 9
        if space.isinstance_w(w_node, get(space).w_BitOr):
            return 10
        if space.isinstance_w(w_node, get(space).w_BitXor):
            return 11
        if space.isinstance_w(w_node, get(space).w_BitAnd):
            return 12
        if space.isinstance_w(w_node, get(space).w_FloorDiv):
            return 13
        raise oefmt(space.w_TypeError,
                "Expected operator node, got %T", w_node)
State.ast_type('operator', 'AST', None)

class _Add(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_Add)
State.ast_type('Add', 'operator', None)

class _Sub(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_Sub)
State.ast_type('Sub', 'operator', None)

class _Mult(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_Mult)
State.ast_type('Mult', 'operator', None)

class _MatMult(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_MatMult)
State.ast_type('MatMult', 'operator', None)

class _Div(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_Div)
State.ast_type('Div', 'operator', None)

class _Mod(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_Mod)
State.ast_type('Mod', 'operator', None)

class _Pow(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_Pow)
State.ast_type('Pow', 'operator', None)

class _LShift(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_LShift)
State.ast_type('LShift', 'operator', None)

class _RShift(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_RShift)
State.ast_type('RShift', 'operator', None)

class _BitOr(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_BitOr)
State.ast_type('BitOr', 'operator', None)

class _BitXor(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_BitXor)
State.ast_type('BitXor', 'operator', None)

class _BitAnd(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_BitAnd)
State.ast_type('BitAnd', 'operator', None)

class _FloorDiv(operator):
    def to_object(self, space):
        return space.call_function(get(space).w_FloorDiv)
State.ast_type('FloorDiv', 'operator', None)

Add = 1
Sub = 2
Mult = 3
MatMult = 4
Div = 5
Mod = 6
Pow = 7
LShift = 8
RShift = 9
BitOr = 10
BitXor = 11
BitAnd = 12
FloorDiv = 13

operator_to_class = [
    _Add,
    _Sub,
    _Mult,
    _MatMult,
    _Div,
    _Mod,
    _Pow,
    _LShift,
    _RShift,
    _BitOr,
    _BitXor,
    _BitAnd,
    _FloorDiv,
]

class unaryop(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.isinstance_w(w_node, get(space).w_Invert):
            return 1
        if space.isinstance_w(w_node, get(space).w_Not):
            return 2
        if space.isinstance_w(w_node, get(space).w_UAdd):
            return 3
        if space.isinstance_w(w_node, get(space).w_USub):
            return 4
        raise oefmt(space.w_TypeError,
                "Expected unaryop node, got %T", w_node)
State.ast_type('unaryop', 'AST', None)

class _Invert(unaryop):
    def to_object(self, space):
        return space.call_function(get(space).w_Invert)
State.ast_type('Invert', 'unaryop', None)

class _Not(unaryop):
    def to_object(self, space):
        return space.call_function(get(space).w_Not)
State.ast_type('Not', 'unaryop', None)

class _UAdd(unaryop):
    def to_object(self, space):
        return space.call_function(get(space).w_UAdd)
State.ast_type('UAdd', 'unaryop', None)

class _USub(unaryop):
    def to_object(self, space):
        return space.call_function(get(space).w_USub)
State.ast_type('USub', 'unaryop', None)

Invert = 1
Not = 2
UAdd = 3
USub = 4

unaryop_to_class = [
    _Invert,
    _Not,
    _UAdd,
    _USub,
]

class cmpop(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.isinstance_w(w_node, get(space).w_Eq):
            return 1
        if space.isinstance_w(w_node, get(space).w_NotEq):
            return 2
        if space.isinstance_w(w_node, get(space).w_Lt):
            return 3
        if space.isinstance_w(w_node, get(space).w_LtE):
            return 4
        if space.isinstance_w(w_node, get(space).w_Gt):
            return 5
        if space.isinstance_w(w_node, get(space).w_GtE):
            return 6
        if space.isinstance_w(w_node, get(space).w_Is):
            return 7
        if space.isinstance_w(w_node, get(space).w_IsNot):
            return 8
        if space.isinstance_w(w_node, get(space).w_In):
            return 9
        if space.isinstance_w(w_node, get(space).w_NotIn):
            return 10
        raise oefmt(space.w_TypeError,
                "Expected cmpop node, got %T", w_node)
State.ast_type('cmpop', 'AST', None)

class _Eq(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_Eq)
State.ast_type('Eq', 'cmpop', None)

class _NotEq(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_NotEq)
State.ast_type('NotEq', 'cmpop', None)

class _Lt(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_Lt)
State.ast_type('Lt', 'cmpop', None)

class _LtE(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_LtE)
State.ast_type('LtE', 'cmpop', None)

class _Gt(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_Gt)
State.ast_type('Gt', 'cmpop', None)

class _GtE(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_GtE)
State.ast_type('GtE', 'cmpop', None)

class _Is(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_Is)
State.ast_type('Is', 'cmpop', None)

class _IsNot(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_IsNot)
State.ast_type('IsNot', 'cmpop', None)

class _In(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_In)
State.ast_type('In', 'cmpop', None)

class _NotIn(cmpop):
    def to_object(self, space):
        return space.call_function(get(space).w_NotIn)
State.ast_type('NotIn', 'cmpop', None)

Eq = 1
NotEq = 2
Lt = 3
LtE = 4
Gt = 5
GtE = 6
Is = 7
IsNot = 8
In = 9
NotIn = 10

cmpop_to_class = [
    _Eq,
    _NotEq,
    _Lt,
    _LtE,
    _Gt,
    _GtE,
    _Is,
    _IsNot,
    _In,
    _NotIn,
]

class comprehension(AST):

    def __init__(self, target, iter, ifs, is_async):
        self.target = target
        self.iter = iter
        self.ifs = ifs
        self.is_async = is_async

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.iter = self.iter.mutate_over(visitor)
        if self.ifs:
            for i in range(len(self.ifs)):
                if self.ifs[i] is not None:
                    self.ifs[i] = self.ifs[i].mutate_over(visitor)
        return visitor.visit_comprehension(self)

    def walkabout(self, visitor):
        visitor.visit_comprehension(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_comprehension)
        w_target = self.target.to_object(space)  # expr
        space.setattr(w_node, space.newtext('target'), w_target)
        w_iter = self.iter.to_object(space)  # expr
        space.setattr(w_node, space.newtext('iter'), w_iter)
        if self.ifs is None:
            ifs_w = []
        else:
            ifs_w = [node.to_object(space) for node in self.ifs] # expr
        w_ifs = space.newlist(ifs_w)
        space.setattr(w_node, space.newtext('ifs'), w_ifs)
        w_is_async = space.newint(self.is_async)  # int
        space.setattr(w_node, space.newtext('is_async'), w_is_async)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_target = get_field(space, w_node, 'target', False)
        w_iter = get_field(space, w_node, 'iter', False)
        w_ifs = get_field(space, w_node, 'ifs', False)
        w_is_async = get_field(space, w_node, 'is_async', False)
        _target = expr.from_object(space, w_target)
        if _target is None:
            raise_required_value(space, w_node, 'target')
        _iter = expr.from_object(space, w_iter)
        if _iter is None:
            raise_required_value(space, w_node, 'iter')
        ifs_w = space.unpackiterable(w_ifs)
        _ifs = [expr.from_object(space, w_item) for w_item in ifs_w]
        _is_async = obj_to_int(space, w_is_async, False)
        return comprehension(_target, _iter, _ifs, _is_async)

State.ast_type('comprehension', 'AST', ['target', 'iter', 'ifs', 'is_async'])

class excepthandler(AST):

    def __init__(self, lineno, col_offset, end_lineno, end_col_offset):
        self.lineno = lineno
        self.col_offset = col_offset
        self.end_lineno = end_lineno
        self.end_col_offset = end_col_offset

    @staticmethod
    def from_object(space, w_node):
        if space.is_w(w_node, space.w_None):
            return None
        if space.isinstance_w(w_node, get(space).w_ExceptHandler):
            return ExceptHandler.from_object(space, w_node)
        raise oefmt(space.w_TypeError,
                "Expected excepthandler node, got %T", w_node)
State.ast_type('excepthandler', 'AST', None, ['lineno', 'col_offset', 'end_lineno', 'end_col_offset'])

class ExceptHandler(excepthandler):

    def __init__(self, type, name, body, lineno, col_offset, end_lineno, end_col_offset):
        self.type = type
        self.name = name
        self.body = body
        excepthandler.__init__(self, lineno, col_offset, end_lineno, end_col_offset)

    def walkabout(self, visitor):
        visitor.visit_ExceptHandler(self)

    def mutate_over(self, visitor):
        if self.type:
            self.type = self.type.mutate_over(visitor)
        if self.body:
            for i in range(len(self.body)):
                if self.body[i] is not None:
                    self.body[i] = self.body[i].mutate_over(visitor)
        return visitor.visit_ExceptHandler(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_ExceptHandler)
        w_type = self.type.to_object(space) if self.type is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('type'), w_type)
        w_name = space.newtext_or_none(self.name)  # identifier
        space.setattr(w_node, space.newtext('name'), w_name)
        if self.body is None:
            body_w = []
        else:
            body_w = [node.to_object(space) for node in self.body] # stmt
        w_body = space.newlist(body_w)
        space.setattr(w_node, space.newtext('body'), w_body)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_type = get_field(space, w_node, 'type', True)
        w_name = get_field(space, w_node, 'name', True)
        w_body = get_field(space, w_node, 'body', False)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _type = expr.from_object(space, w_type)
        _name = space.text_or_none_w(w_name)
        body_w = space.unpackiterable(w_body)
        _body = [stmt.from_object(space, w_item) for w_item in body_w]
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return ExceptHandler(_type, _name, _body, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('ExceptHandler', 'excepthandler', ['type', 'name', 'body'])


class arguments(AST):

    def __init__(self, posonlyargs, args, vararg, kwonlyargs, kw_defaults, kwarg, defaults):
        self.posonlyargs = posonlyargs
        self.args = args
        self.vararg = vararg
        self.kwonlyargs = kwonlyargs
        self.kw_defaults = kw_defaults
        self.kwarg = kwarg
        self.defaults = defaults

    def mutate_over(self, visitor):
        if self.posonlyargs:
            for i in range(len(self.posonlyargs)):
                if self.posonlyargs[i] is not None:
                    self.posonlyargs[i] = self.posonlyargs[i].mutate_over(visitor)
        if self.args:
            for i in range(len(self.args)):
                if self.args[i] is not None:
                    self.args[i] = self.args[i].mutate_over(visitor)
        if self.vararg:
            self.vararg = self.vararg.mutate_over(visitor)
        if self.kwonlyargs:
            for i in range(len(self.kwonlyargs)):
                if self.kwonlyargs[i] is not None:
                    self.kwonlyargs[i] = self.kwonlyargs[i].mutate_over(visitor)
        if self.kw_defaults:
            for i in range(len(self.kw_defaults)):
                if self.kw_defaults[i] is not None:
                    self.kw_defaults[i] = self.kw_defaults[i].mutate_over(visitor)
        if self.kwarg:
            self.kwarg = self.kwarg.mutate_over(visitor)
        if self.defaults:
            for i in range(len(self.defaults)):
                if self.defaults[i] is not None:
                    self.defaults[i] = self.defaults[i].mutate_over(visitor)
        return visitor.visit_arguments(self)

    def walkabout(self, visitor):
        visitor.visit_arguments(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_arguments)
        if self.posonlyargs is None:
            posonlyargs_w = []
        else:
            posonlyargs_w = [node.to_object(space) for node in self.posonlyargs] # arg
        w_posonlyargs = space.newlist(posonlyargs_w)
        space.setattr(w_node, space.newtext('posonlyargs'), w_posonlyargs)
        if self.args is None:
            args_w = []
        else:
            args_w = [node.to_object(space) for node in self.args] # arg
        w_args = space.newlist(args_w)
        space.setattr(w_node, space.newtext('args'), w_args)
        w_vararg = self.vararg.to_object(space) if self.vararg is not None else space.w_None  # arg
        space.setattr(w_node, space.newtext('vararg'), w_vararg)
        if self.kwonlyargs is None:
            kwonlyargs_w = []
        else:
            kwonlyargs_w = [node.to_object(space) for node in self.kwonlyargs] # arg
        w_kwonlyargs = space.newlist(kwonlyargs_w)
        space.setattr(w_node, space.newtext('kwonlyargs'), w_kwonlyargs)
        if self.kw_defaults is None:
            kw_defaults_w = []
        else:
            kw_defaults_w = [node.to_object(space) if node is not None else space.w_None for node in self.kw_defaults] # expr
        w_kw_defaults = space.newlist(kw_defaults_w)
        space.setattr(w_node, space.newtext('kw_defaults'), w_kw_defaults)
        w_kwarg = self.kwarg.to_object(space) if self.kwarg is not None else space.w_None  # arg
        space.setattr(w_node, space.newtext('kwarg'), w_kwarg)
        if self.defaults is None:
            defaults_w = []
        else:
            defaults_w = [node.to_object(space) for node in self.defaults] # expr
        w_defaults = space.newlist(defaults_w)
        space.setattr(w_node, space.newtext('defaults'), w_defaults)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_posonlyargs = get_field(space, w_node, 'posonlyargs', False)
        w_args = get_field(space, w_node, 'args', False)
        w_vararg = get_field(space, w_node, 'vararg', True)
        w_kwonlyargs = get_field(space, w_node, 'kwonlyargs', False)
        w_kw_defaults = get_field(space, w_node, 'kw_defaults', False)
        w_kwarg = get_field(space, w_node, 'kwarg', True)
        w_defaults = get_field(space, w_node, 'defaults', False)
        posonlyargs_w = space.unpackiterable(w_posonlyargs)
        _posonlyargs = [arg.from_object(space, w_item) for w_item in posonlyargs_w]
        args_w = space.unpackiterable(w_args)
        _args = [arg.from_object(space, w_item) for w_item in args_w]
        _vararg = arg.from_object(space, w_vararg) if not space.is_w(w_vararg, space.w_None) else None
        kwonlyargs_w = space.unpackiterable(w_kwonlyargs)
        _kwonlyargs = [arg.from_object(space, w_item) for w_item in kwonlyargs_w]
        kw_defaults_w = space.unpackiterable(w_kw_defaults)
        _kw_defaults = [expr.from_object(space, w_item) for w_item in kw_defaults_w]
        _kwarg = arg.from_object(space, w_kwarg) if not space.is_w(w_kwarg, space.w_None) else None
        defaults_w = space.unpackiterable(w_defaults)
        _defaults = [expr.from_object(space, w_item) for w_item in defaults_w]
        return arguments(_posonlyargs, _args, _vararg, _kwonlyargs, _kw_defaults, _kwarg, _defaults)

State.ast_type('arguments', 'AST', ['posonlyargs', 'args', 'vararg', 'kwonlyargs', 'kw_defaults', 'kwarg', 'defaults'])

class arg(AST):

    def __init__(self, arg, annotation, type_comment, lineno, col_offset, end_lineno, end_col_offset):
        self.arg = arg
        self.annotation = annotation
        self.type_comment = type_comment
        self.lineno = lineno
        self.col_offset = col_offset
        self.end_lineno = end_lineno
        self.end_col_offset = end_col_offset

    def mutate_over(self, visitor):
        if self.annotation:
            self.annotation = self.annotation.mutate_over(visitor)
        return visitor.visit_arg(self)

    def walkabout(self, visitor):
        visitor.visit_arg(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_arg)
        w_arg = space.newtext(self.arg)  # identifier
        space.setattr(w_node, space.newtext('arg'), w_arg)
        w_annotation = self.annotation.to_object(space) if self.annotation is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('annotation'), w_annotation)
        w_type_comment = self.type_comment  # string
        space.setattr(w_node, space.newtext('type_comment'), w_type_comment)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_col_offset = space.newint(self.col_offset)  # int
        space.setattr(w_node, space.newtext('col_offset'), w_col_offset)
        w_end_lineno = space.newint(self.end_lineno)  # int
        space.setattr(w_node, space.newtext('end_lineno'), w_end_lineno)
        w_end_col_offset = space.newint(self.end_col_offset)  # int
        space.setattr(w_node, space.newtext('end_col_offset'), w_end_col_offset)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_arg = get_field(space, w_node, 'arg', False)
        w_annotation = get_field(space, w_node, 'annotation', True)
        w_type_comment = get_field(space, w_node, 'type_comment', True)
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_col_offset = get_field(space, w_node, 'col_offset', False)
        w_end_lineno = get_field(space, w_node, 'end_lineno', True)
        w_end_col_offset = get_field(space, w_node, 'end_col_offset', True)
        _arg = space.text_w(w_arg)
        if _arg is None:
            raise_required_value(space, w_node, 'arg')
        _annotation = expr.from_object(space, w_annotation)
        _type_comment = check_string(space, w_type_comment, 1)
        _lineno = obj_to_int(space, w_lineno, False)
        _col_offset = obj_to_int(space, w_col_offset, False)
        _end_lineno = obj_to_int(space, w_end_lineno, True)
        _end_col_offset = obj_to_int(space, w_end_col_offset, True)
        return arg(_arg, _annotation, _type_comment, _lineno, _col_offset, _end_lineno, _end_col_offset)

State.ast_type('arg', 'AST', ['arg', 'annotation', 'type_comment'], ['lineno', 'col_offset', 'end_lineno', 'end_col_offset'])

class keyword(AST):

    def __init__(self, arg, value):
        self.arg = arg
        self.value = value

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_keyword(self)

    def walkabout(self, visitor):
        visitor.visit_keyword(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_keyword)
        w_arg = space.newtext_or_none(self.arg)  # identifier
        space.setattr(w_node, space.newtext('arg'), w_arg)
        w_value = self.value.to_object(space)  # expr
        space.setattr(w_node, space.newtext('value'), w_value)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_arg = get_field(space, w_node, 'arg', True)
        w_value = get_field(space, w_node, 'value', False)
        _arg = space.text_or_none_w(w_arg)
        _value = expr.from_object(space, w_value)
        if _value is None:
            raise_required_value(space, w_node, 'value')
        return keyword(_arg, _value)

State.ast_type('keyword', 'AST', ['arg', 'value'])

class alias(AST):

    def __init__(self, name, asname):
        self.name = name
        self.asname = asname

    def mutate_over(self, visitor):
        return visitor.visit_alias(self)

    def walkabout(self, visitor):
        visitor.visit_alias(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_alias)
        w_name = space.newtext(self.name)  # identifier
        space.setattr(w_node, space.newtext('name'), w_name)
        w_asname = space.newtext_or_none(self.asname)  # identifier
        space.setattr(w_node, space.newtext('asname'), w_asname)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_name = get_field(space, w_node, 'name', False)
        w_asname = get_field(space, w_node, 'asname', True)
        _name = space.text_w(w_name)
        if _name is None:
            raise_required_value(space, w_node, 'name')
        _asname = space.text_or_none_w(w_asname)
        return alias(_name, _asname)

State.ast_type('alias', 'AST', ['name', 'asname'])

class withitem(AST):

    def __init__(self, context_expr, optional_vars):
        self.context_expr = context_expr
        self.optional_vars = optional_vars

    def mutate_over(self, visitor):
        self.context_expr = self.context_expr.mutate_over(visitor)
        if self.optional_vars:
            self.optional_vars = self.optional_vars.mutate_over(visitor)
        return visitor.visit_withitem(self)

    def walkabout(self, visitor):
        visitor.visit_withitem(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_withitem)
        w_context_expr = self.context_expr.to_object(space)  # expr
        space.setattr(w_node, space.newtext('context_expr'), w_context_expr)
        w_optional_vars = self.optional_vars.to_object(space) if self.optional_vars is not None else space.w_None  # expr
        space.setattr(w_node, space.newtext('optional_vars'), w_optional_vars)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_context_expr = get_field(space, w_node, 'context_expr', False)
        w_optional_vars = get_field(space, w_node, 'optional_vars', True)
        _context_expr = expr.from_object(space, w_context_expr)
        if _context_expr is None:
            raise_required_value(space, w_node, 'context_expr')
        _optional_vars = expr.from_object(space, w_optional_vars)
        return withitem(_context_expr, _optional_vars)

State.ast_type('withitem', 'AST', ['context_expr', 'optional_vars'])

class type_ignore(AST):
    @staticmethod
    def from_object(space, w_node):
        if space.is_w(w_node, space.w_None):
            return None
        if space.isinstance_w(w_node, get(space).w_TypeIgnore):
            return TypeIgnore.from_object(space, w_node)
        raise oefmt(space.w_TypeError,
                "Expected type_ignore node, got %T", w_node)
State.ast_type('type_ignore', 'AST', None, [])

class TypeIgnore(type_ignore):

    def __init__(self, lineno, tag):
        self.lineno = lineno
        self.tag = tag

    def walkabout(self, visitor):
        visitor.visit_TypeIgnore(self)

    def mutate_over(self, visitor):
        return visitor.visit_TypeIgnore(self)

    def to_object(self, space):
        w_node = space.call_function(get(space).w_TypeIgnore)
        w_lineno = space.newint(self.lineno)  # int
        space.setattr(w_node, space.newtext('lineno'), w_lineno)
        w_tag = self.tag  # string
        space.setattr(w_node, space.newtext('tag'), w_tag)
        return w_node

    @staticmethod
    def from_object(space, w_node):
        w_lineno = get_field(space, w_node, 'lineno', False)
        w_tag = get_field(space, w_node, 'tag', False)
        _lineno = obj_to_int(space, w_lineno, False)
        _tag = check_string(space, w_tag, 0)
        if _tag is None:
            raise_required_value(space, w_node, 'tag')
        return TypeIgnore(_lineno, _tag)

State.ast_type('TypeIgnore', 'type_ignore', ['lineno', 'tag'])


class ASTVisitor(object):

    def visit_sequence(self, seq):
        if seq is not None:
            for node in seq:
                if node is not None:
                    node.walkabout(self)

    def visit_kwonlydefaults(self, seq):
        if seq is not None:
            for node in seq:
                if node:
                    node.walkabout(self)

    def default_visitor(self, node):
        raise NodeVisitorNotImplemented

    def visit_Module(self, node):
        return self.default_visitor(node)
    def visit_Interactive(self, node):
        return self.default_visitor(node)
    def visit_Expression(self, node):
        return self.default_visitor(node)
    def visit_Suite(self, node):
        return self.default_visitor(node)
    def visit_FunctionType(self, node):
        return self.default_visitor(node)
    def visit_FunctionDef(self, node):
        return self.default_visitor(node)
    def visit_AsyncFunctionDef(self, node):
        return self.default_visitor(node)
    def visit_ClassDef(self, node):
        return self.default_visitor(node)
    def visit_Return(self, node):
        return self.default_visitor(node)
    def visit_Delete(self, node):
        return self.default_visitor(node)
    def visit_Assign(self, node):
        return self.default_visitor(node)
    def visit_AugAssign(self, node):
        return self.default_visitor(node)
    def visit_AnnAssign(self, node):
        return self.default_visitor(node)
    def visit_For(self, node):
        return self.default_visitor(node)
    def visit_AsyncFor(self, node):
        return self.default_visitor(node)
    def visit_While(self, node):
        return self.default_visitor(node)
    def visit_If(self, node):
        return self.default_visitor(node)
    def visit_With(self, node):
        return self.default_visitor(node)
    def visit_AsyncWith(self, node):
        return self.default_visitor(node)
    def visit_Raise(self, node):
        return self.default_visitor(node)
    def visit_Try(self, node):
        return self.default_visitor(node)
    def visit_Assert(self, node):
        return self.default_visitor(node)
    def visit_Import(self, node):
        return self.default_visitor(node)
    def visit_ImportFrom(self, node):
        return self.default_visitor(node)
    def visit_Global(self, node):
        return self.default_visitor(node)
    def visit_Nonlocal(self, node):
        return self.default_visitor(node)
    def visit_Expr(self, node):
        return self.default_visitor(node)
    def visit_Pass(self, node):
        return self.default_visitor(node)
    def visit_Break(self, node):
        return self.default_visitor(node)
    def visit_Continue(self, node):
        return self.default_visitor(node)
    def visit_BoolOp(self, node):
        return self.default_visitor(node)
    def visit_NamedExpr(self, node):
        return self.default_visitor(node)
    def visit_BinOp(self, node):
        return self.default_visitor(node)
    def visit_UnaryOp(self, node):
        return self.default_visitor(node)
    def visit_Lambda(self, node):
        return self.default_visitor(node)
    def visit_IfExp(self, node):
        return self.default_visitor(node)
    def visit_Dict(self, node):
        return self.default_visitor(node)
    def visit_Set(self, node):
        return self.default_visitor(node)
    def visit_ListComp(self, node):
        return self.default_visitor(node)
    def visit_SetComp(self, node):
        return self.default_visitor(node)
    def visit_DictComp(self, node):
        return self.default_visitor(node)
    def visit_GeneratorExp(self, node):
        return self.default_visitor(node)
    def visit_Await(self, node):
        return self.default_visitor(node)
    def visit_Yield(self, node):
        return self.default_visitor(node)
    def visit_YieldFrom(self, node):
        return self.default_visitor(node)
    def visit_Compare(self, node):
        return self.default_visitor(node)
    def visit_Call(self, node):
        return self.default_visitor(node)
    def visit_RevDBMetaVar(self, node):
        return self.default_visitor(node)
    def visit_FormattedValue(self, node):
        return self.default_visitor(node)
    def visit_JoinedStr(self, node):
        return self.default_visitor(node)
    def visit_Constant(self, node):
        return self.default_visitor(node)
    def visit_Attribute(self, node):
        return self.default_visitor(node)
    def visit_Subscript(self, node):
        return self.default_visitor(node)
    def visit_Starred(self, node):
        return self.default_visitor(node)
    def visit_Name(self, node):
        return self.default_visitor(node)
    def visit_List(self, node):
        return self.default_visitor(node)
    def visit_Tuple(self, node):
        return self.default_visitor(node)
    def visit_Slice(self, node):
        return self.default_visitor(node)
    def visit_ExtSlice(self, node):
        return self.default_visitor(node)
    def visit_Index(self, node):
        return self.default_visitor(node)
    def visit_comprehension(self, node):
        return self.default_visitor(node)
    def visit_ExceptHandler(self, node):
        return self.default_visitor(node)
    def visit_arguments(self, node):
        return self.default_visitor(node)
    def visit_arg(self, node):
        return self.default_visitor(node)
    def visit_keyword(self, node):
        return self.default_visitor(node)
    def visit_alias(self, node):
        return self.default_visitor(node)
    def visit_withitem(self, node):
        return self.default_visitor(node)
    def visit_TypeIgnore(self, node):
        return self.default_visitor(node)

class GenericASTVisitor(ASTVisitor):

    def visited(self, node):
        pass  # base implementation

    def visit_Module(self, node):
        self.visited(node)
        self.visit_sequence(node.body)
        self.visit_sequence(node.type_ignores)

    def visit_Interactive(self, node):
        self.visited(node)
        self.visit_sequence(node.body)

    def visit_Expression(self, node):
        self.visited(node)
        node.body.walkabout(self)

    def visit_Suite(self, node):
        self.visited(node)
        self.visit_sequence(node.body)

    def visit_FunctionType(self, node):
        self.visited(node)
        self.visit_sequence(node.argtypes)
        node.returns.walkabout(self)

    def visit_FunctionDef(self, node):
        self.visited(node)
        node.args.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.decorator_list)
        if node.returns:
            node.returns.walkabout(self)

    def visit_AsyncFunctionDef(self, node):
        self.visited(node)
        node.args.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.decorator_list)
        if node.returns:
            node.returns.walkabout(self)

    def visit_ClassDef(self, node):
        self.visited(node)
        self.visit_sequence(node.bases)
        self.visit_sequence(node.keywords)
        self.visit_sequence(node.body)
        self.visit_sequence(node.decorator_list)

    def visit_Return(self, node):
        self.visited(node)
        if node.value:
            node.value.walkabout(self)

    def visit_Delete(self, node):
        self.visited(node)
        self.visit_sequence(node.targets)

    def visit_Assign(self, node):
        self.visited(node)
        self.visit_sequence(node.targets)
        node.value.walkabout(self)

    def visit_AugAssign(self, node):
        self.visited(node)
        node.target.walkabout(self)
        node.value.walkabout(self)

    def visit_AnnAssign(self, node):
        self.visited(node)
        node.target.walkabout(self)
        node.annotation.walkabout(self)
        if node.value:
            node.value.walkabout(self)

    def visit_For(self, node):
        self.visited(node)
        node.target.walkabout(self)
        node.iter.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_AsyncFor(self, node):
        self.visited(node)
        node.target.walkabout(self)
        node.iter.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_While(self, node):
        self.visited(node)
        node.test.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_If(self, node):
        self.visited(node)
        node.test.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_With(self, node):
        self.visited(node)
        self.visit_sequence(node.items)
        self.visit_sequence(node.body)

    def visit_AsyncWith(self, node):
        self.visited(node)
        self.visit_sequence(node.items)
        self.visit_sequence(node.body)

    def visit_Raise(self, node):
        self.visited(node)
        if node.exc:
            node.exc.walkabout(self)
        if node.cause:
            node.cause.walkabout(self)

    def visit_Try(self, node):
        self.visited(node)
        self.visit_sequence(node.body)
        self.visit_sequence(node.handlers)
        self.visit_sequence(node.orelse)
        self.visit_sequence(node.finalbody)

    def visit_Assert(self, node):
        self.visited(node)
        node.test.walkabout(self)
        if node.msg:
            node.msg.walkabout(self)

    def visit_Import(self, node):
        self.visited(node)
        self.visit_sequence(node.names)

    def visit_ImportFrom(self, node):
        self.visited(node)
        self.visit_sequence(node.names)

    def visit_Global(self, node):
        self.visited(node)
        pass

    def visit_Nonlocal(self, node):
        self.visited(node)
        pass

    def visit_Expr(self, node):
        self.visited(node)
        node.value.walkabout(self)

    def visit_Pass(self, node):
        self.visited(node)
        pass

    def visit_Break(self, node):
        self.visited(node)
        pass

    def visit_Continue(self, node):
        self.visited(node)
        pass

    def visit_BoolOp(self, node):
        self.visited(node)
        self.visit_sequence(node.values)

    def visit_NamedExpr(self, node):
        self.visited(node)
        node.target.walkabout(self)
        node.value.walkabout(self)

    def visit_BinOp(self, node):
        self.visited(node)
        node.left.walkabout(self)
        node.right.walkabout(self)

    def visit_UnaryOp(self, node):
        self.visited(node)
        node.operand.walkabout(self)

    def visit_Lambda(self, node):
        self.visited(node)
        node.args.walkabout(self)
        node.body.walkabout(self)

    def visit_IfExp(self, node):
        self.visited(node)
        node.test.walkabout(self)
        node.body.walkabout(self)
        node.orelse.walkabout(self)

    def visit_Dict(self, node):
        self.visited(node)
        self.visit_sequence(node.keys)
        self.visit_sequence(node.values)

    def visit_Set(self, node):
        self.visited(node)
        self.visit_sequence(node.elts)

    def visit_ListComp(self, node):
        self.visited(node)
        node.elt.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_SetComp(self, node):
        self.visited(node)
        node.elt.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_DictComp(self, node):
        self.visited(node)
        node.key.walkabout(self)
        node.value.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_GeneratorExp(self, node):
        self.visited(node)
        node.elt.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_Await(self, node):
        self.visited(node)
        node.value.walkabout(self)

    def visit_Yield(self, node):
        self.visited(node)
        if node.value:
            node.value.walkabout(self)

    def visit_YieldFrom(self, node):
        self.visited(node)
        node.value.walkabout(self)

    def visit_Compare(self, node):
        self.visited(node)
        node.left.walkabout(self)
        self.visit_sequence(node.comparators)

    def visit_Call(self, node):
        self.visited(node)
        node.func.walkabout(self)
        self.visit_sequence(node.args)
        self.visit_sequence(node.keywords)

    def visit_RevDBMetaVar(self, node):
        self.visited(node)
        pass

    def visit_FormattedValue(self, node):
        self.visited(node)
        node.value.walkabout(self)
        if node.format_spec:
            node.format_spec.walkabout(self)

    def visit_JoinedStr(self, node):
        self.visited(node)
        self.visit_sequence(node.values)

    def visit_Constant(self, node):
        self.visited(node)
        pass

    def visit_Attribute(self, node):
        self.visited(node)
        node.value.walkabout(self)

    def visit_Subscript(self, node):
        self.visited(node)
        node.value.walkabout(self)
        node.slice.walkabout(self)

    def visit_Starred(self, node):
        self.visited(node)
        node.value.walkabout(self)

    def visit_Name(self, node):
        self.visited(node)
        pass

    def visit_List(self, node):
        self.visited(node)
        self.visit_sequence(node.elts)

    def visit_Tuple(self, node):
        self.visited(node)
        self.visit_sequence(node.elts)

    def visit_Slice(self, node):
        self.visited(node)
        if node.lower:
            node.lower.walkabout(self)
        if node.upper:
            node.upper.walkabout(self)
        if node.step:
            node.step.walkabout(self)

    def visit_ExtSlice(self, node):
        self.visited(node)
        self.visit_sequence(node.dims)

    def visit_Index(self, node):
        self.visited(node)
        node.value.walkabout(self)

    def visit_comprehension(self, node):
        self.visited(node)
        node.target.walkabout(self)
        node.iter.walkabout(self)
        self.visit_sequence(node.ifs)

    def visit_ExceptHandler(self, node):
        self.visited(node)
        if node.type:
            node.type.walkabout(self)
        self.visit_sequence(node.body)

    def visit_arguments(self, node):
        self.visited(node)
        self.visit_sequence(node.posonlyargs)
        self.visit_sequence(node.args)
        if node.vararg:
            node.vararg.walkabout(self)
        self.visit_sequence(node.kwonlyargs)
        self.visit_sequence(node.kw_defaults)
        if node.kwarg:
            node.kwarg.walkabout(self)
        self.visit_sequence(node.defaults)

    def visit_arg(self, node):
        self.visited(node)
        if node.annotation:
            node.annotation.walkabout(self)

    def visit_keyword(self, node):
        self.visited(node)
        node.value.walkabout(self)

    def visit_alias(self, node):
        self.visited(node)
        pass

    def visit_withitem(self, node):
        self.visited(node)
        node.context_expr.walkabout(self)
        if node.optional_vars:
            node.optional_vars.walkabout(self)

    def visit_TypeIgnore(self, node):
        self.visited(node)
        pass


