#!/bin/sh

JAVA_ARGS="-Xmx192M"

if [ -f /etc/default/puppetdb ]; then
	. /etc/default/puppetdb
fi

jar_cmd() {
	exec /usr/bin/java $JAVA_ARGS -cp /usr/share/puppetdb/puppetdb.jar clojure.main -m puppetlabs.puppetdb.core "$@"
}

usage() {
	cat <<-EOF
	usage: $0 import|export|version -h|ARGS
	EOF
}

case "$1" in
	version|import|export|anonymize)
		jar_cmd "$@"
		;;
	ssl-setup|config-migration)
		echo "'$1' is not supported, see /usr/share/doc/puppetdb/README.Debian." >&2
		exit 1
		;;
	*)
		usage
		exit 1
		;;
esac
