/*
 * Copyright (c) 2020, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */
// this file is auto-generated by CDSMHTest_generate.sh. Do not edit manually.

/*
 * @test id=aot
 * @summary Run the MethodHandlesGeneralTest.java test in CDSAppTester::AOT workflow.
 * @requires vm.cds & vm.compMode != "Xcomp"
 * @requires vm.cds.supports.aot.class.linking
 * @comment Some of the tests run excessively slowly with -Xcomp. The original
 *          tests aren't executed with -Xcomp in the CI pipeline, so let's exclude
 *          the generated tests from -Xcomp execution as well.
 * @library /test/lib /test/hotspot/jtreg/runtime/cds/appcds
 * @compile ../../../../../../jdk/java/lang/invoke/MethodHandlesTest.java
 *        ../../../../../../lib/jdk/test/lib/Utils.java
 *        ../../../../../../jdk/java/lang/invoke/MethodHandlesGeneralTest.java
 *        ../../../../../../jdk/java/lang/invoke/remote/RemoteExample.java
 *        ../../../../../../jdk/java/lang/invoke/common/test/java/lang/invoke/lib/CodeCacheOverflowProcessor.java
 * @run junit/othervm/timeout=480 -Dcds.app.tester.workflow=AOT MethodHandlesGeneralTest
 */
/*
 * @test id=dynamic
 * @summary Run the MethodHandlesGeneralTest.java test in CDSAppTester::DYNAMIC workflow.
 * @requires vm.cds & vm.compMode != "Xcomp"
 * @comment Some of the tests run excessively slowly with -Xcomp. The original
 *          tests aren't executed with -Xcomp in the CI pipeline, so let's exclude
 *          the generated tests from -Xcomp execution as well.
 * @library /test/lib /test/hotspot/jtreg/runtime/cds/appcds
 * @compile ../../../../../../jdk/java/lang/invoke/MethodHandlesTest.java
 *        ../../../../../../lib/jdk/test/lib/Utils.java
 *        ../../../../../../jdk/java/lang/invoke/MethodHandlesGeneralTest.java
 *        ../../../../../../jdk/java/lang/invoke/remote/RemoteExample.java
 *        ../../../../../../jdk/java/lang/invoke/common/test/java/lang/invoke/lib/CodeCacheOverflowProcessor.java
 * @build jdk.test.whitebox.WhiteBox
 * @run driver jdk.test.lib.helpers.ClassFileInstaller jdk.test.whitebox.WhiteBox
 * @run junit/othervm/timeout=480 -Dcds.app.tester.workflow=DYNAMIC -XX:+UnlockDiagnosticVMOptions -XX:+WhiteBoxAPI -Xbootclasspath/a:. MethodHandlesGeneralTest
 */
/*
 * @test id=static
 * @summary Run the MethodHandlesGeneralTest.java test in CDSAppTester::STATIC workflow.
 * @requires vm.cds & vm.compMode != "Xcomp"
 * @comment Some of the tests run excessively slowly with -Xcomp. The original
 *          tests aren't executed with -Xcomp in the CI pipeline, so let's exclude
 *          the generated tests from -Xcomp execution as well.
 * @library /test/lib /test/hotspot/jtreg/runtime/cds/appcds
 * @compile ../../../../../../jdk/java/lang/invoke/MethodHandlesTest.java
 *        ../../../../../../lib/jdk/test/lib/Utils.java
 *        ../../../../../../jdk/java/lang/invoke/MethodHandlesGeneralTest.java
 *        ../../../../../../jdk/java/lang/invoke/remote/RemoteExample.java
 *        ../../../../../../jdk/java/lang/invoke/common/test/java/lang/invoke/lib/CodeCacheOverflowProcessor.java
 * @run junit/othervm/timeout=480 -Dcds.app.tester.workflow=STATIC MethodHandlesGeneralTest
 */
import org.junit.Test;

public class MethodHandlesGeneralTest {
    @Test
    public void test() throws Exception {
        JDKMethodHandlesTestRunner.test(MethodHandlesGeneralTest.class.getName());
    }
}
