import type { IconName } from "./iconNames";
/**
 * Icon codepoints as base 10 number strings. If you need to render these strings
 * into an SVG document or as `::before` pseudo content, consider using `getIconContentString()`
 * instead.
 */
export declare const IconCodepoints: {
    "add-clip": string;
    "add-column-left": string;
    "add-column-right": string;
    "add-location": string;
    "add-row-bottom": string;
    "add-row-top": string;
    "add-to-artifact": string;
    "add-to-folder": string;
    add: string;
    "aimpoints-target": string;
    airplane: string;
    "align-center": string;
    "align-justify": string;
    "align-left": string;
    "align-right": string;
    "alignment-bottom": string;
    "alignment-horizontal-center": string;
    "alignment-left": string;
    "alignment-right": string;
    "alignment-top": string;
    "alignment-vertical-center": string;
    anchor: string;
    annotation: string;
    antenna: string;
    "app-header": string;
    application: string;
    applications: string;
    archive: string;
    "area-of-interest": string;
    "array-boolean": string;
    "array-date": string;
    "array-floating-point": string;
    "array-numeric": string;
    "array-string": string;
    "array-timestamp": string;
    array: string;
    "arrow-bottom-left": string;
    "arrow-bottom-right": string;
    "arrow-down": string;
    "arrow-left": string;
    "arrow-right": string;
    "arrow-top-left": string;
    "arrow-top-right": string;
    "arrow-up": string;
    "arrows-horizontal": string;
    "arrows-vertical": string;
    asterisk: string;
    at: string;
    "automatic-updates": string;
    axle: string;
    backlink: string;
    badge: string;
    "ban-circle": string;
    "bank-account": string;
    barcode: string;
    blank: string;
    "blocked-person": string;
    bold: string;
    book: string;
    bookmark: string;
    box: string;
    briefcase: string;
    "bring-data": string;
    bug: string;
    buggy: string;
    build: string;
    calculator: string;
    calendar: string;
    camera: string;
    "caret-down": string;
    "caret-left": string;
    "caret-right": string;
    "caret-up": string;
    "cargo-ship": string;
    "cell-tower": string;
    changes: string;
    chart: string;
    chat: string;
    "chevron-backward": string;
    "chevron-down": string;
    "chevron-forward": string;
    "chevron-left": string;
    "chevron-right": string;
    "chevron-up": string;
    "circle-arrow-down": string;
    "circle-arrow-left": string;
    "circle-arrow-right": string;
    "circle-arrow-up": string;
    circle: string;
    citation: string;
    clean: string;
    clip: string;
    clipboard: string;
    "cloud-download": string;
    "cloud-upload": string;
    cloud: string;
    "code-block": string;
    code: string;
    cog: string;
    "collapse-all": string;
    "color-fill": string;
    "column-layout": string;
    comment: string;
    comparison: string;
    compass: string;
    compressed: string;
    confirm: string;
    console: string;
    contrast: string;
    control: string;
    "credit-card": string;
    "cross-circle": string;
    cross: string;
    crown: string;
    "cube-add": string;
    "cube-remove": string;
    cube: string;
    "curved-range-chart": string;
    cut: string;
    cycle: string;
    dashboard: string;
    "data-connection": string;
    "data-lineage": string;
    database: string;
    delete: string;
    delta: string;
    "derive-column": string;
    desktop: string;
    diagnosis: string;
    "diagram-tree": string;
    "direction-left": string;
    "direction-right": string;
    disable: string;
    divide: string;
    "document-open": string;
    "document-share": string;
    document: string;
    dollar: string;
    dot: string;
    "double-caret-horizontal": string;
    "double-caret-vertical": string;
    "double-chevron-down": string;
    "double-chevron-left": string;
    "double-chevron-right": string;
    "double-chevron-up": string;
    "doughnut-chart": string;
    download: string;
    "drag-handle-horizontal": string;
    "drag-handle-vertical": string;
    draw: string;
    "drawer-left-filled": string;
    "drawer-left": string;
    "drawer-right-filled": string;
    "drawer-right": string;
    "drive-time": string;
    duplicate: string;
    edit: string;
    eject: string;
    emoji: string;
    endorsed: string;
    envelope: string;
    equals: string;
    eraser: string;
    error: string;
    euro: string;
    exchange: string;
    "exclude-row": string;
    "expand-all": string;
    export: string;
    "eye-off": string;
    "eye-on": string;
    "eye-open": string;
    "fast-backward": string;
    "fast-forward": string;
    "feed-subscribed": string;
    feed: string;
    film: string;
    "filter-keep": string;
    "filter-list": string;
    "filter-open": string;
    "filter-remove": string;
    filter: string;
    flag: string;
    flame: string;
    flash: string;
    "floating-point": string;
    "floppy-disk": string;
    "flow-branch": string;
    "flow-end": string;
    "flow-linear": string;
    "flow-review-branch": string;
    "flow-review": string;
    flows: string;
    "folder-close": string;
    "folder-new": string;
    "folder-open": string;
    "folder-shared-open": string;
    "folder-shared": string;
    follower: string;
    following: string;
    font: string;
    fork: string;
    form: string;
    fuel: string;
    "full-circle": string;
    "full-stacked-chart": string;
    fullscreen: string;
    function: string;
    "gantt-chart": string;
    geofence: string;
    geolocation: string;
    geosearch: string;
    "git-branch": string;
    "git-commit": string;
    "git-merge": string;
    "git-new-branch": string;
    "git-pull": string;
    "git-push": string;
    "git-repo": string;
    glass: string;
    "globe-network": string;
    globe: string;
    "graph-remove": string;
    graph: string;
    "greater-than-or-equal-to": string;
    "greater-than": string;
    "grid-view": string;
    grid: string;
    "group-objects": string;
    "grouped-bar-chart": string;
    "hand-down": string;
    "hand-left": string;
    "hand-right": string;
    "hand-up": string;
    hand: string;
    hat: string;
    "header-one": string;
    "header-three": string;
    "header-two": string;
    header: string;
    headset: string;
    "heart-broken": string;
    heart: string;
    "heat-grid": string;
    heatmap: string;
    helicopter: string;
    help: string;
    "helper-management": string;
    "high-priority": string;
    "high-voltage-pole": string;
    highlight: string;
    history: string;
    home: string;
    "horizontal-bar-chart-asc": string;
    "horizontal-bar-chart-desc": string;
    "horizontal-bar-chart": string;
    "horizontal-distribution": string;
    "horizontal-inbetween": string;
    hurricane: string;
    "id-number": string;
    "image-rotate-left": string;
    "image-rotate-right": string;
    import: string;
    "inbox-filtered": string;
    "inbox-geo": string;
    "inbox-search": string;
    "inbox-update": string;
    inbox: string;
    "info-sign": string;
    inheritance: string;
    "inherited-group": string;
    "inner-join": string;
    insert: string;
    intelligence: string;
    intersection: string;
    "ip-address": string;
    "issue-closed": string;
    "issue-new": string;
    issue: string;
    italic: string;
    "join-table": string;
    "key-backspace": string;
    "key-command": string;
    "key-control": string;
    "key-delete": string;
    "key-enter": string;
    "key-escape": string;
    "key-option": string;
    "key-shift": string;
    "key-tab": string;
    key: string;
    "known-vehicle": string;
    "lab-test": string;
    label: string;
    "layer-outline": string;
    layer: string;
    layers: string;
    "layout-auto": string;
    "layout-balloon": string;
    "layout-circle": string;
    "layout-grid": string;
    "layout-group-by": string;
    "layout-hierarchy": string;
    "layout-linear": string;
    "layout-skew-grid": string;
    "layout-sorted-clusters": string;
    layout: string;
    learning: string;
    "left-join": string;
    "less-than-or-equal-to": string;
    "less-than": string;
    lifesaver: string;
    lightbulb: string;
    lightning: string;
    link: string;
    "list-columns": string;
    "list-detail-view": string;
    list: string;
    locate: string;
    lock: string;
    "log-in": string;
    "log-out": string;
    "low-voltage-pole": string;
    manual: string;
    "manually-entered-data": string;
    "many-to-many": string;
    "many-to-one": string;
    "map-create": string;
    "map-marker": string;
    map: string;
    maximize: string;
    media: string;
    "menu-closed": string;
    "menu-open": string;
    menu: string;
    "merge-columns": string;
    "merge-links": string;
    minimize: string;
    minus: string;
    "mobile-phone": string;
    "mobile-video": string;
    "modal-filled": string;
    modal: string;
    moon: string;
    more: string;
    mountain: string;
    move: string;
    mugshot: string;
    "multi-select": string;
    music: string;
    nest: string;
    "new-drawing": string;
    "new-grid-item": string;
    "new-layer": string;
    "new-layers": string;
    "new-link": string;
    "new-object": string;
    "new-person": string;
    "new-prescription": string;
    "new-text-box": string;
    ninja: string;
    "not-equal-to": string;
    "notifications-snooze": string;
    "notifications-updated": string;
    notifications: string;
    "numbered-list": string;
    numerical: string;
    office: string;
    offline: string;
    "oil-field": string;
    "one-column": string;
    "one-to-many": string;
    "one-to-one": string;
    "open-application": string;
    outdated: string;
    "page-layout": string;
    "panel-stats": string;
    "panel-table": string;
    paperclip: string;
    paragraph: string;
    "path-search": string;
    path: string;
    pause: string;
    people: string;
    percentage: string;
    person: string;
    phone: string;
    "pie-chart": string;
    pin: string;
    "pivot-table": string;
    pivot: string;
    play: string;
    playbook: string;
    plus: string;
    "polygon-filter": string;
    power: string;
    "predictive-analysis": string;
    prescription: string;
    presentation: string;
    print: string;
    projects: string;
    properties: string;
    property: string;
    "publish-function": string;
    pulse: string;
    rain: string;
    random: string;
    record: string;
    "rect-height": string;
    "rect-width": string;
    rectangle: string;
    redo: string;
    refresh: string;
    regex: string;
    "regression-chart": string;
    "remove-column-left": string;
    "remove-column-right": string;
    "remove-column": string;
    "remove-row-bottom": string;
    "remove-row-top": string;
    remove: string;
    repeat: string;
    reset: string;
    resolve: string;
    rig: string;
    "right-join": string;
    ring: string;
    "rocket-slant": string;
    rocket: string;
    "rotate-document": string;
    "rotate-page": string;
    route: string;
    satellite: string;
    saved: string;
    "scatter-plot": string;
    "search-around": string;
    "search-template": string;
    "search-text": string;
    search: string;
    "segmented-control": string;
    select: string;
    selection: string;
    "send-message": string;
    "send-to-graph": string;
    "send-to-map": string;
    "send-to": string;
    "series-add": string;
    "series-configuration": string;
    "series-derived": string;
    "series-filtered": string;
    "series-search": string;
    settings: string;
    shapes: string;
    share: string;
    "shared-filter": string;
    shield: string;
    ship: string;
    shop: string;
    "shopping-cart": string;
    "signal-search": string;
    "sim-card": string;
    slash: string;
    "small-cross": string;
    "small-info-sign": string;
    "small-minus": string;
    "small-plus": string;
    "small-square": string;
    "small-tick": string;
    snowflake: string;
    "social-media": string;
    "sort-alphabetical-desc": string;
    "sort-alphabetical": string;
    "sort-asc": string;
    "sort-desc": string;
    "sort-numerical-desc": string;
    "sort-numerical": string;
    sort: string;
    "split-columns": string;
    square: string;
    "stacked-chart": string;
    "stadium-geometry": string;
    "star-empty": string;
    star: string;
    "step-backward": string;
    "step-chart": string;
    "step-forward": string;
    stop: string;
    stopwatch: string;
    strikethrough: string;
    style: string;
    "swap-horizontal": string;
    "swap-vertical": string;
    switch: string;
    "symbol-circle": string;
    "symbol-cross": string;
    "symbol-diamond": string;
    "symbol-rectangle": string;
    "symbol-square": string;
    "symbol-triangle-down": string;
    "symbol-triangle-up": string;
    syringe: string;
    tag: string;
    "take-action": string;
    tank: string;
    target: string;
    taxi: string;
    temperature: string;
    "text-highlight": string;
    "th-derived": string;
    "th-disconnect": string;
    "th-filtered": string;
    "th-list": string;
    th: string;
    "third-party": string;
    "thumbs-down": string;
    "thumbs-up": string;
    "tick-circle": string;
    tick: string;
    time: string;
    "timeline-area-chart": string;
    "timeline-bar-chart": string;
    "timeline-events": string;
    "timeline-line-chart": string;
    tint: string;
    torch: string;
    tractor: string;
    train: string;
    translate: string;
    trash: string;
    tree: string;
    "trending-down": string;
    "trending-up": string;
    truck: string;
    "two-columns": string;
    unarchive: string;
    underline: string;
    undo: string;
    "ungroup-objects": string;
    "unknown-vehicle": string;
    unlock: string;
    unpin: string;
    unresolve: string;
    updated: string;
    upload: string;
    user: string;
    variable: string;
    "vertical-bar-chart-asc": string;
    "vertical-bar-chart-desc": string;
    "vertical-distribution": string;
    "vertical-inbetween": string;
    video: string;
    virus: string;
    "volume-down": string;
    "volume-off": string;
    "volume-up": string;
    walk: string;
    "warning-sign": string;
    "waterfall-chart": string;
    waves: string;
    "widget-button": string;
    "widget-footer": string;
    "widget-header": string;
    widget: string;
    wind: string;
    wrench: string;
    "zoom-in": string;
    "zoom-out": string;
    "zoom-to-fit": string;
};
/**
 * Returns the hex code content string which represents the codepoint in the icon font
 * for a given icon. You can render this string to the DOM and if the icon font is loaded
 * as an active font family, this string will be replaced with the associated icon.
 */
export declare function getIconContentString(icon: IconName): string;
