<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/integrations/non-uniform_memory_access.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Non-Uniform Memory Access"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/Memory"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Non-Uniform Memory Access


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /sys/devices/system/node

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Information about NUMA (Non-Uniform Memory Access) nodes on the system.

NUMA is a method of configuring a cluster of microprocessor in a multiprocessing system so that they can
share memory locally, improving performance and the ability of the system to be expanded. NUMA is used in a
symmetric multiprocessing (SMP) system.

In a NUMA system, processors, memory, and I/O devices are grouped together into cells, also known as nodes.
Each node has its own memory and set of I/O devices, and one or more processors. While a processor can access
memory in any of the nodes, it does so faster when accessing memory within its own node.

The collector provides statistics on memory allocations for processes running on the NUMA nodes, revealing the
efficiency of memory allocations in multi-node systems.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per numa node



Labels:

| Label      | Description     |
|:-----------|:----------------|
| numa_node | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mem.numa_nodes | hit, miss, local, foreign, interleave, other | events/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


