/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package org.netbeans.modules.properties;

import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;
import java.awt.ContainerOrderFocusTraversalPolicy;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

import org.openide.util.NbBundle;


/**
 * Find panel for Resource Bundles table view component. GUI represenation only.
 *
 * @author  Peter Zavadsky
 */
public class FindPanel extends javax.swing.JPanel {

    /** Creates new form FindPanel. */
    public FindPanel() {
        initComponents ();
        initAccessibility ();
        findCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
             public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\n') {
                    findButton.doClick(20);
                    evt.consume();
                }
            }
        });
    }

    private String getBundleString(String s){
        return NbBundle.getMessage(FindPanel.class, s);
    }

    // Accessor methods.
    
    /** Accessor to buttons. */
    public JButton[] getButtons() {
        return new JButton[] { findButton, cancelButton};
    }
    
    /** Accessor to combo box. */
    public JComboBox getComboBox() {
        return findCombo;
    }

    /** Accessor to highlight check box. */
    public JCheckBox getHighlightCheck() {
        return highlightCheck;
    }
    
    /** Accessor to match case check box. */
    public JCheckBox getMatchCaseCheck() {
        return matchCaseCheck;
    }
    
    /** Accessor to backward check box. */
    public JCheckBox getBackwardCheck() {
        return backwardCheck;
    }
    
    /** Accessor to wrap check box. */
    public JCheckBox getWrapCheck() {
        return wrapCheck;
    }
    
    /** Accessor to row check box. */
    public JCheckBox getRowCheck() {
        return rowCheck;
    }
    
    private void initAccessibility () {
        this.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_FindPanel"));
        
        findButton.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_Find"));
        rowCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_SearchByRows"));
        wrapCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_WrapSearch"));
        matchCaseCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_MatchCaseCheck"));
        cancelButton.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_Cancel"));
        backwardCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_BackwardCheck"));
        findCombo.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_FindCombo"));
        highlightCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_HighlightCheck"));
        
    }    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        findLabel = new javax.swing.JLabel();
        findCombo = new javax.swing.JComboBox();
        highlightCheck = new javax.swing.JCheckBox();
        matchCaseCheck = new javax.swing.JCheckBox();
        backwardCheck = new javax.swing.JCheckBox();
        wrapCheck = new javax.swing.JCheckBox();
        rowCheck = new javax.swing.JCheckBox();
        findButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setFocusCycleRoot(true);
        setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        setLayout(new java.awt.GridBagLayout());

        findLabel.setLabelFor(findCombo);
        org.openide.awt.Mnemonics.setLocalizedText(findLabel, getBundleString("LBL_Find")); // NOI18N
        findLabel.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(findLabel, gridBagConstraints);

        findCombo.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 11, 0, 0);
        add(findCombo, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(highlightCheck, getBundleString("CTL_HighlightCheck")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(highlightCheck, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(matchCaseCheck, getBundleString("CTL_MatchCaseCheck")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(matchCaseCheck, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(backwardCheck, getBundleString("CTL_BackwardCheck")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 11, 0);
        add(backwardCheck, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(wrapCheck, getBundleString("CTL_WrapSearch")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(wrapCheck, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(rowCheck, getBundleString("CTL_SearchByRows")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 11, 0, 0);
        add(rowCheck, gridBagConstraints);

        findButton.setText(getBundleString("CTL_Find")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(12, 11, 0, 11);
        add(findButton, gridBagConstraints);

        cancelButton.setText(getBundleString("CTL_Cancel")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 11, 0, 11);
        add(cancelButton, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    public boolean requestFocusInWindow() {
        return findCombo.requestFocusInWindow();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox backwardCheck;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton findButton;
    private javax.swing.JComboBox findCombo;
    private javax.swing.JLabel findLabel;
    private javax.swing.JCheckBox highlightCheck;
    private javax.swing.JCheckBox matchCaseCheck;
    private javax.swing.JCheckBox rowCheck;
    private javax.swing.JCheckBox wrapCheck;
    // End of variables declaration//GEN-END:variables

}
