#define COLOR_SYNTAX_HIGHLIGHT 1 /* A Bison parser, made by GNU Bison 3.5.1.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.5.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         flowcsh_parse
#define yylex           flowcsh_lex
#define yyerror         flowcsh_error
#define yydebug         flowcsh_debug
#define yynerrs         flowcsh_nerrs

/* First part of user prologue.  */
#line 15 "flow_lang.yy"

/*
    This file is part of Msc-generator.
    Copyright (C) 2008-2021 Zoltan Turanyi
    Distributed under GNU Affero General Public License.

    Msc-generator is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Msc-generator is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with Msc-generator.  If not, see <http://www.gnu.org/licenses/>.
*/

/* The language of flowcharts is the following
    [<refname>] BOX|IF|START|STOP|STEP: label '['attrs']';
    BRANCH|THEN|ELSE|YES|NO: branch-label '['attrs']' [{ content }]|GOTO <refname>|;
    GOTO <refname>;
    REPEAT { content };
    If you do not specify anything after a branch, the continuation will be used.
*/

#ifdef COLOR_SYNTAX_HIGHLIGHT
    #undef COLOR_SYNTAX_HIGHLIGHT //so that subsequent definition in flow_csh_lang2.h causes no warning
    #define C_S_H (1)
    #define C_S_H_IS_COMPILED
    #define YYMSC_RESULT_TYPE FlowCsh
    #define RESULT csh
    #include "cgen_shapes.h"
    #include "flowcsh.h"
    #include "flowchart.h"
    #define YYGET_EXTRA flowcsh_get_extra
    #define YYLTYPE_IS_DECLARED
    #define YYLTYPE CshPos
    #define CHAR_IF_CSH(A) char
#else
    #define C_S_H (0)
    #define YYMSC_RESULT_TYPE FlowChart
    #define RESULT chart
    #define YYGET_EXTRA flow_get_extra
    #define CHAR_IF_CSH(A) A
    #include "cgen_shapes.h"
    #include "flowchart.h"
    #include "steps.h"
#endif

using namespace flow;



#line 132 "flow_csh_lang.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_FLOWCSH_FLOW_CSH_LANG_H_INCLUDED
# define YY_FLOWCSH_FLOW_CSH_LANG_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int flowcsh_debug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOK_EOF = 0,
    TOK_STRING = 258,
    TOK_QSTRING = 259,
    TOK_NUMBER = 260,
    TOK_DASH = 261,
    TOK_EQUAL = 262,
    TOK_COMMA = 263,
    TOK_SEMICOLON = 264,
    TOK_PLUS_PLUS = 265,
    TOK_OCBRACKET = 266,
    TOK_CCBRACKET = 267,
    TOK_OSBRACKET = 268,
    TOK_CSBRACKET = 269,
    TOK_IF = 270,
    TOK_STEP = 271,
    TOK_REPEAT = 272,
    TOK_START = 273,
    TOK_STOP = 274,
    TOK_GOTO = 275,
    TOK_BRANCH = 276,
    TOK_THEN = 277,
    TOK_ELSE = 278,
    TOK_YES = 279,
    TOK_NO = 280,
    TOK_SHAPE_COMMAND = 281,
    TOK_BYE = 282,
    TOK_COLON_STRING = 283,
    TOK_COLON_QUOTED_STRING = 284,
    TOK_COLORDEF = 285,
    TOK_COMMAND_DEFSHAPE = 286,
    TOK_COMMAND_DEFCOLOR = 287,
    TOK_COMMAND_DEFSTYLE = 288,
    TOK_COMMAND_DEFDESIGN = 289,
    TOK__NEVER__HAPPENS = 290,
    TOK__NEVER__HAPPENS2 = 291,
    TOK_UNRECOGNIZED_CHAR = 292
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 84 "flow_lang.yy"

    gsl::owner<char*>                       str;
    gsl::owner<std::list<std::string>*>     stringlist;
    ShapeElement::Type                      shapecommand;
    CHAR_IF_CSH(Step::KeywordHelper)        steptype; 
    gsl::owner<CHAR_IF_CSH(Shape)*>         shape;
    gsl::owner<CHAR_IF_CSH(ShapeElement)*>  shapeelement;
    gsl::owner<CHAR_IF_CSH(Attribute)*>     attribute;
    gsl::owner<CHAR_IF_CSH(AttributeList)*> attributelist;
    gsl::owner<CHAR_IF_CSH(FlowElement)*>   instruction;
    gsl::owner<CHAR_IF_CSH(FElementList)*>  instruction_list;
    gsl::owner<CHAR_IF_CSH(Branch)*>        branch;

#line 237 "flow_csh_lang.cc"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int flowcsh_parse (YYMSC_RESULT_TYPE &RESULT, void *yyscanner);

#endif /* !YY_FLOWCSH_FLOW_CSH_LANG_H_INCLUDED  */

/* Second part of user prologue.  */
#line 123 "flow_lang.yy"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <list>
#include <iostream>

#ifdef C_S_H_IS_COMPILED
    #include "flow_lang_misc.h"  //Must be after RESULT and YYMSC_RESULT_TYPE is defined
    #include "flow_csh_lang2.h"  //Needs parse_param from flow_lang_misc.h
    /* yyerror
     *  Error handling function.  Do nothing for CSH */
    void yyerror(YYLTYPE* /*loc*/, Csh & /*csh*/, void * /*yyscanner*/, const char * /*str*/) {}
#else
    #include "flow_lang_misc.h"  //Must be after RESULT and YYMSC_RESULT_TYPE is defined
    #include "flow_lang2.h"      //Needs parse_param from flow_lang_misc.h
    /* Use verbose error reporting such that the expected token names are dumped */
    //#define YYERROR_VERBOSE
    void yyerror(YYLTYPE *loc, YYMSC_RESULT_TYPE &chart, void *yyscanner, const char *str)
    {
        chart.Error.Error(CHART_POS_START(*loc), str);
    }
#endif

#ifdef C_S_H_IS_COMPILED
void FlowCshParse(YYMSC_RESULT_TYPE &RESULT, const char *buff, unsigned len)
#else
void FlowParse(YYMSC_RESULT_TYPE &RESULT, const char *buff, unsigned len)
#endif
{
    std::remove_pointer<YY_EXTRA_TYPE>::type pp;
    pp.RESULT = &RESULT;
#ifdef C_S_H_IS_COMPILED
    pp.buff.buf = buff;
    pp.buff.length = len;
    pp.buff.pos = 0;
    flowcsh_lex_init(&pp.yyscanner);
    flowcsh_set_extra(&pp, pp.yyscanner);
    flowcsh_parse(RESULT, pp.yyscanner);
    flowcsh_lex_destroy(pp.yyscanner);
#else
    pp.buffs.emplace_back(buff, len);
    flow_lex_init(&pp.yyscanner);
    flow_set_extra(&pp, pp.yyscanner);
    flow_parse(RESULT, pp.yyscanner);
    flow_lex_destroy(pp.yyscanner);
#endif
}


#line 317 "flow_csh_lang.cc"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))

/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  79
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   734

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  38
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  48
/* YYNRULES -- Number of rules.  */
#define YYNRULES  189
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  214

#define YYUNDEFTOK  2
#define YYMAXUTOK   292


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   176,   176,   180,   191,   192,   201,   213,   224,   237,
     238,   247,   261,   270,   282,   294,   306,   318,   329,   342,
     356,   365,   372,   373,   382,   383,   393,   404,   420,   421,
     422,   435,   452,   456,   463,   474,   487,   491,   501,   516,
     517,   518,   537,   559,   581,   597,   615,   631,   649,   667,
     691,   700,   709,   718,   729,   749,   764,   781,   792,   809,
     820,   834,   849,   861,   872,   885,   901,   920,   931,   948,
     959,   973,   980,   988,   997,  1006,  1015,  1024,  1034,  1044,
    1057,  1071,  1089,  1098,  1113,  1126,  1127,  1143,  1162,  1181,
    1201,  1202,  1212,  1225,  1240,  1250,  1271,  1286,  1310,  1320,
    1332,  1351,  1368,  1387,  1399,  1412,  1424,  1433,  1449,  1477,
    1501,  1530,  1559,  1587,  1617,  1650,  1651,  1661,  1675,  1675,
    1677,  1700,  1724,  1742,  1759,  1798,  1840,  1851,  1852,  1863,
    1877,  1894,  1908,  1925,  1927,  1928,  1938,  1948,  1955,  1974,
    1993,  2011,  2019,  2028,  2036,  2044,  2056,  2064,  2067,  2078,
    2089,  2101,  2114,  2126,  2138,  2152,  2156,  2169,  2176,  2185,
    2196,  2199,  2214,  2229,  2244,  2258,  2272,  2277,  2305,  2306,
    2313,  2323,  2323,  2323,  2323,  2323,  2323,  2323,  2324,  2324,
    2324,  2324,  2327,  2332,  2332,  2334,  2334,  2336,  2351,  2353
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "TOK_EOF", "error", "$undefined", "TOK_STRING", "TOK_QSTRING",
  "TOK_NUMBER", "TOK_DASH", "TOK_EQUAL", "TOK_COMMA", "TOK_SEMICOLON",
  "TOK_PLUS_PLUS", "TOK_OCBRACKET", "TOK_CCBRACKET", "TOK_OSBRACKET",
  "TOK_CSBRACKET", "TOK_IF", "TOK_STEP", "TOK_REPEAT", "TOK_START",
  "TOK_STOP", "TOK_GOTO", "TOK_BRANCH", "TOK_THEN", "TOK_ELSE", "TOK_YES",
  "TOK_NO", "TOK_SHAPE_COMMAND", "TOK_BYE", "TOK_COLON_STRING",
  "TOK_COLON_QUOTED_STRING", "TOK_COLORDEF", "TOK_COMMAND_DEFSHAPE",
  "TOK_COMMAND_DEFCOLOR", "TOK_COMMAND_DEFSTYLE", "TOK_COMMAND_DEFDESIGN",
  "TOK__NEVER__HAPPENS", "TOK__NEVER__HAPPENS2", "TOK_UNRECOGNIZED_CHAR",
  "$accept", "chart_with_bye", "eof", "chart", "top_level_instrlist",
  "braced_instrlist", "instrlist", "several_instructions",
  "instr_with_semicolon", "optlist_with_semicolon",
  "instr_needs_semicolon", "step_types", "actual_instr_needs_semicolon",
  "actual_instr", "goto", "goto_with_semicolon", "branch_with_semicolon",
  "branch_keyword", "branch_no_content", "optlist", "opt", "styledeflist",
  "styledef", "stylenamelist", "shapedef", "shapedeflist", "shapeline",
  "colordeflist", "color_string", "colordef", "designdef",
  "scope_open_empty", "designelementlist", "designelement",
  "designoptlist", "designopt", "colon_string", "full_attrlist_with_label",
  "full_attrlist", "attrlist", "attr", "entity_string",
  "reserved_word_string", "symbol_string", "alpha_string", "string",
  "scope_open", "scope_close", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292
};
# endif

#define YYPACT_NINF (-142)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-155)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     670,  -142,  -142,  -142,   -21,  -142,  -142,   109,  -142,  -142,
      66,  -142,  -142,  -142,  -142,  -142,  -142,    26,   694,   599,
      21,    34,    12,  -142,  -142,   644,  -142,  -142,  -142,   338,
     268,    45,  -142,    59,  -142,  -142,    66,    44,   303,  -142,
     715,   478,  -142,   139,  -142,  -142,  -142,    65,    82,    52,
    -142,    37,  -142,    87,  -142,  -142,  -142,  -142,  -142,  -142,
    -142,  -142,  -142,  -142,  -142,    92,  -142,  -142,  -142,    83,
    -142,   102,  -142,    24,  -142,  -142,  -142,    95,  -142,  -142,
    -142,    15,   112,  -142,   670,  -142,  -142,   114,    90,    37,
    -142,  -142,  -142,  -142,    37,  -142,  -142,  -142,   117,   197,
      93,   161,    98,  -142,  -142,  -142,  -142,   373,  -142,   122,
    -142,  -142,   233,  -142,   134,   137,  -142,  -142,    65,  -142,
     408,   694,   503,   599,   599,  -142,  -142,    79,  -142,  -142,
    -142,   110,  -142,  -142,  -142,   111,  -142,  -142,  -142,   162,
    -142,  -142,  -142,  -142,  -142,    23,  -142,  -142,  -142,   168,
     527,  -142,    41,   148,  -142,   158,   180,   443,   177,  -142,
     551,  -142,  -142,  -142,  -142,  -142,   694,   599,   178,  -142,
      88,  -142,   181,  -142,  -142,  -142,  -142,  -142,  -142,  -142,
    -142,   551,  -142,  -142,   182,   184,   190,  -142,   183,  -142,
    -142,    92,   102,   625,  -142,    26,   575,  -142,  -142,    17,
    -142,  -142,   191,  -142,  -142,  -142,  -142,  -142,   185,  -142,
    -142,   189,   199,  -142
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       7,   168,   169,    30,   187,    51,    50,    57,    52,    53,
      63,    73,    74,    76,    75,    77,   170,    43,    45,    47,
      49,     0,     0,     8,    25,     9,    22,    20,    24,     0,
       0,    59,    33,    67,    36,    32,    78,    69,     0,    82,
       0,     0,   188,     0,   142,   141,    62,   143,    58,   147,
      65,    64,    42,    98,   171,   172,   173,   175,   176,   177,
     174,   178,   179,   180,   181,    44,   115,   183,   184,   123,
     182,    46,    90,    94,   186,   185,    95,     0,    48,     1,
       4,     0,     5,     2,    10,    23,    21,     0,    27,     0,
      55,    60,    68,    80,    79,    70,    72,    71,     0,     0,
      38,     0,    89,    34,    17,   189,    19,     0,    13,   156,
     148,   155,     0,   157,   185,   167,   144,    61,   146,    66,
       0,   117,   122,    92,    96,    93,   126,     0,     3,     6,
      11,    31,    28,    56,    81,    41,    86,    85,    83,     0,
      39,    35,    87,    88,    16,     0,    18,    12,   151,   153,
     159,   149,   165,     0,   145,     0,   107,     0,     0,   116,
       0,   118,   120,   119,    91,    97,   130,   132,     0,   127,
       0,   134,     0,    29,    40,    15,    14,   150,   160,   158,
     164,   163,   161,   166,     0,   108,   106,   101,     0,   103,
     121,   129,   131,     0,   137,   136,   140,   162,   104,   109,
     102,   105,     0,   124,   128,   135,   138,   139,   111,   110,
     125,   112,   113,   114
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -142,  -142,   115,  -142,   123,     1,   169,   -22,   -19,  -142,
    -142,  -142,  -142,   -38,  -142,   174,  -142,  -142,  -142,  -142,
     126,    60,   103,  -142,  -142,  -142,  -139,    69,  -141,   118,
    -142,  -142,  -142,    47,  -142,    43,   194,    -3,   -42,  -142,
      96,     0,  -142,  -142,   -17,   -15,  -142,   -98
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    21,    83,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    71,    72,    73,    52,   157,   158,    65,   162,    66,
      78,   127,   168,   169,   170,   171,    47,    48,    49,   112,
     113,    67,    68,    74,    75,   163,    41,   108
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      40,    69,   103,    85,    76,   116,    86,    50,    46,   147,
      51,   182,    80,    81,    42,    80,   184,    53,   188,   190,
       1,     2,   208,   175,    77,    40,   114,    90,   115,     1,
       2,   125,   124,    93,    79,   105,    94,    43,    96,    82,
     197,    40,    82,    16,     1,     2,   180,   176,   119,   117,
      43,   181,    16,    95,    91,     4,    54,    55,    56,    57,
      58,    59,    60,   141,    10,    44,    45,    16,    92,     1,
       2,   161,    61,    62,    63,    64,   154,    70,    43,    43,
      44,    45,     1,     2,    40,    85,   133,   143,    86,   194,
     122,   134,    16,     4,    44,    45,   195,  -133,   120,   139,
     121,     1,     2,   142,    69,    16,   126,    40,    76,   165,
     123,   166,   167,    54,    55,    56,    57,    58,    59,    60,
       4,   129,    43,   131,    16,   132,   135,   172,   140,    61,
      62,    63,    64,   114,    70,   115,   148,    44,    45,  -154,
     109,   152,     1,     2,   153,   173,   174,  -154,  -154,    69,
    -154,  -154,    76,   110,    54,    55,    56,    57,    58,    59,
      60,  -154,  -154,  -154,  -154,    16,  -154,  -154,  -154,   102,
      61,    62,    63,    64,   111,    70,     5,     6,     7,     8,
       9,   207,   177,   183,   156,   185,   189,   193,   196,   199,
     211,   198,   201,   172,   212,   172,   128,   -84,   136,   209,
       1,     2,   200,   210,   213,   -84,   -84,   130,   -84,   -84,
     107,    97,   -84,   -84,   -84,   -84,   -84,   -84,   -84,   -84,
     -84,   -84,   -84,    16,   -84,   138,   164,   192,   -84,   -84,
     -84,   -84,   137,  -152,   149,   191,  -152,  -152,   205,   159,
     204,   150,  -152,   118,  -152,  -152,   179,   151,  -152,  -152,
    -152,  -152,  -152,  -152,  -152,  -152,  -152,  -152,  -152,  -152,
    -152,  -152,  -152,     0,  -152,  -152,  -152,  -152,   -54,    89,
       0,   -54,   -54,     0,     0,     0,     0,   -54,     0,   -54,
     -54,    43,     0,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,    44,    45,     0,   -54,
     -54,   -54,   -54,   -37,    98,     0,   -37,   -37,     0,     0,
       0,    99,   100,     0,   -37,   -37,     0,     0,   -37,   -37,
     -37,   -37,   -37,   -37,   -37,   -37,   -37,   -37,   -37,   -37,
     -37,     0,     0,     0,   -37,   -37,   -37,   -37,   -26,    87,
       0,   -26,   -26,     0,     0,     0,     0,    88,     0,   -26,
     -26,     0,     0,   -26,   -26,   -26,   -26,   -26,   -26,   -26,
     -26,   -26,   -26,   -26,   -26,   -26,     0,     0,     0,   -26,
     -26,   -26,   -26,   144,   145,     0,     1,     2,     0,     0,
       0,     0,     3,     0,     4,   105,     0,     0,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
     146,     0,     0,     0,    17,    18,    19,    20,   -99,   155,
       0,   -99,   -99,     0,     0,     0,     0,   -99,     0,   -99,
     -99,     0,     0,   -99,   -99,   -99,   -99,   -99,   -99,   -99,
     -99,   -99,   -99,   -99,   156,   -99,     0,     0,     0,   -99,
     -99,   -99,   -99,  -100,   186,     0,  -100,  -100,     0,     0,
       0,     0,  -100,     0,  -100,   187,     0,     0,  -100,  -100,
    -100,  -100,  -100,  -100,  -100,  -100,  -100,  -100,  -100,   156,
    -100,     0,     0,     0,  -100,  -100,  -100,  -100,   104,     0,
       0,     1,     2,     0,     0,     0,     0,     3,     0,     4,
     105,     0,     0,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,   106,     1,     2,     0,    17,
      18,    19,    20,   160,     0,     0,     0,     0,    54,    55,
      56,    57,    58,    59,    60,     0,     0,     0,     0,    16,
       1,     2,     0,   161,    61,    62,    63,    64,     0,    70,
       0,     0,    54,    55,    56,    57,    58,    59,    60,     0,
       0,     0,     0,    16,     1,     2,     0,     0,    61,    62,
      63,    64,   178,    70,     0,     0,    54,    55,    56,    57,
      58,    59,    60,     0,     0,     0,     0,    16,     1,     2,
     206,   161,    61,    62,    63,    64,     0,    70,     0,     0,
      54,    55,    56,    57,    58,    59,    60,     0,     0,     0,
       0,    16,     1,     2,     0,     0,    61,    62,    63,    64,
       0,    70,     0,     0,    54,    55,    56,    57,    58,    59,
      60,     0,     0,     0,     0,    16,   202,     0,     1,     2,
      61,    62,    63,    64,     0,    70,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     1,     2,     0,
       0,    16,     0,     3,     0,     4,    84,   166,   167,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,     0,     0,     1,     2,    17,    18,    19,    20,     3,
       0,     4,     0,     0,     0,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,     1,     2,     0,
       0,    17,    18,    19,    20,     0,     0,     0,     0,    54,
      55,    56,    57,    58,    59,    60,   101,     0,     0,     0,
      16,     0,   102,     0,     0,    61,    62,    63,    64,     0,
       5,     6,     7,     8,     9
};

static const yytype_int16 yycheck[] =
{
       0,    18,    40,    25,    19,    47,    25,    10,     7,   107,
      10,   152,     0,     1,    35,     0,   155,    17,   157,   160,
       3,     4,     5,     0,     3,    25,    43,    30,    43,     3,
       4,    73,     8,    36,     0,    12,    36,    13,    37,    27,
     181,    41,    27,    26,     3,     4,     5,   145,    51,    48,
      13,    10,    26,     9,     9,    11,    15,    16,    17,    18,
      19,    20,    21,   101,    20,    28,    29,    26,     9,     3,
       4,    30,    31,    32,    33,    34,   118,    36,    13,    13,
      28,    29,     3,     4,    84,   107,    89,   102,   107,     1,
       7,    94,    26,    11,    28,    29,     8,     9,    11,    99,
       8,     3,     4,     5,   121,    26,    11,   107,   123,   124,
       8,    32,    33,    15,    16,    17,    18,    19,    20,    21,
      11,     9,    13,     9,    26,    35,     9,   127,    35,    31,
      32,    33,    34,   150,    36,   150,    14,    28,    29,     0,
       1,     7,     3,     4,     7,    35,    35,     8,     9,   166,
      11,    12,   167,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,     7,
      31,    32,    33,    34,    35,    36,    15,    16,    17,    18,
      19,   196,    14,    35,    26,     5,     9,     9,     7,     5,
       5,     9,     9,   193,     5,   195,    81,     0,     1,   199,
       3,     4,    12,    12,     5,     8,     9,    84,    11,    12,
      41,    37,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    99,   123,   167,    31,    32,
      33,    34,    35,     0,     1,   166,     3,     4,   195,   121,
     193,     8,     9,    49,    11,    12,   150,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    32,    33,    34,     0,     1,
      -1,     3,     4,    -1,    -1,    -1,    -1,     9,    -1,    11,
      12,    13,    -1,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      32,    33,    34,     0,     1,    -1,     3,     4,    -1,    -1,
      -1,     8,     9,    -1,    11,    12,    -1,    -1,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    31,    32,    33,    34,     0,     1,
      -1,     3,     4,    -1,    -1,    -1,    -1,     9,    -1,    11,
      12,    -1,    -1,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    -1,    -1,    -1,    31,
      32,    33,    34,     0,     1,    -1,     3,     4,    -1,    -1,
      -1,    -1,     9,    -1,    11,    12,    -1,    -1,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    31,    32,    33,    34,     0,     1,
      -1,     3,     4,    -1,    -1,    -1,    -1,     9,    -1,    11,
      12,    -1,    -1,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    -1,    -1,    -1,    31,
      32,    33,    34,     0,     1,    -1,     3,     4,    -1,    -1,
      -1,    -1,     9,    -1,    11,    12,    -1,    -1,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    31,    32,    33,    34,     0,    -1,
      -1,     3,     4,    -1,    -1,    -1,    -1,     9,    -1,    11,
      12,    -1,    -1,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,     3,     4,    -1,    31,
      32,    33,    34,    10,    -1,    -1,    -1,    -1,    15,    16,
      17,    18,    19,    20,    21,    -1,    -1,    -1,    -1,    26,
       3,     4,    -1,    30,    31,    32,    33,    34,    -1,    36,
      -1,    -1,    15,    16,    17,    18,    19,    20,    21,    -1,
      -1,    -1,    -1,    26,     3,     4,    -1,    -1,    31,    32,
      33,    34,    35,    36,    -1,    -1,    15,    16,    17,    18,
      19,    20,    21,    -1,    -1,    -1,    -1,    26,     3,     4,
       5,    30,    31,    32,    33,    34,    -1,    36,    -1,    -1,
      15,    16,    17,    18,    19,    20,    21,    -1,    -1,    -1,
      -1,    26,     3,     4,    -1,    -1,    31,    32,    33,    34,
      -1,    36,    -1,    -1,    15,    16,    17,    18,    19,    20,
      21,    -1,    -1,    -1,    -1,    26,     1,    -1,     3,     4,
      31,    32,    33,    34,    -1,    36,    -1,    12,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,    -1,
      -1,    26,    -1,     9,    -1,    11,    12,    32,    33,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    -1,    -1,     3,     4,    31,    32,    33,    34,     9,
      -1,    11,    -1,    -1,    -1,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,     3,     4,    -1,
      -1,    31,    32,    33,    34,    -1,    -1,    -1,    -1,    15,
      16,    17,    18,    19,    20,    21,     1,    -1,    -1,    -1,
      26,    -1,     7,    -1,    -1,    31,    32,    33,    34,    -1,
      15,    16,    17,    18,    19
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     4,     9,    11,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    31,    32,    33,
      34,    39,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      79,    84,    35,    13,    28,    29,    43,    74,    75,    76,
      75,    79,    62,    79,    15,    16,    17,    18,    19,    20,
      21,    31,    32,    33,    34,    65,    67,    79,    80,    82,
      36,    59,    60,    61,    81,    82,    83,     3,    68,     0,
       0,     1,    27,    40,    12,    45,    46,     1,     9,     1,
      75,     9,     9,    75,    79,     9,    43,    53,     1,     8,
       9,     1,     7,    51,     0,    12,    27,    44,    85,     1,
      14,    35,    77,    78,    82,    83,    76,    43,    74,    75,
      11,     8,     7,     8,     8,    76,    11,    69,    40,     9,
      42,     9,    35,    75,    75,     9,     1,    35,    58,    79,
      35,    51,     5,    83,     0,     1,    27,    85,    14,     1,
       8,    14,     7,     7,    76,     1,    26,    63,    64,    67,
      10,    30,    66,    83,    60,    83,    32,    33,    70,    71,
      72,    73,    79,    35,    35,     0,    85,    14,    35,    78,
       5,    10,    66,    35,    64,     5,     1,    12,    64,     9,
      66,    65,    59,     9,     1,     8,     7,    66,     9,     5,
      12,     9,     1,    12,    71,    73,     5,    83,     5,    79,
      12,     5,     5,     5
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int8 yyr1[] =
{
       0,    38,    39,    39,    40,    40,    40,    41,    41,    42,
      42,    42,    43,    43,    43,    43,    43,    43,    43,    43,
      44,    44,    44,    44,    45,    45,    46,    46,    46,    46,
      46,    46,    46,    46,    46,    46,    46,    47,    47,    47,
      47,    47,    48,    48,    48,    48,    48,    48,    48,    48,
      49,    49,    49,    49,    50,    50,    50,    50,    50,    51,
      51,    51,    51,    52,    52,    52,    52,    53,    53,    54,
      54,    54,    54,    55,    55,    55,    55,    55,    56,    56,
      56,    56,    57,    57,    57,    57,    57,    58,    58,    58,
      59,    59,    59,    60,    60,    61,    61,    61,    62,    62,
      62,    62,    62,    63,    63,    63,    63,    64,    64,    64,
      64,    64,    64,    64,    64,    65,    65,    65,    66,    66,
      67,    67,    67,    67,    68,    68,    69,    70,    70,    71,
      71,    71,    71,    71,    72,    72,    72,    72,    73,    73,
      73,    74,    74,    75,    75,    75,    75,    75,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    77,    77,    77,
      77,    78,    78,    78,    78,    78,    78,    78,    79,    79,
      79,    80,    80,    80,    80,    80,    80,    80,    80,    80,
      80,    80,    81,    82,    82,    83,    83,    84,    84,    85
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     3,     1,     1,     2,     0,     1,     1,
       2,     3,     3,     2,     4,     4,     3,     2,     3,     2,
       1,     2,     1,     2,     1,     1,     1,     2,     3,     4,
       1,     3,     1,     1,     2,     3,     1,     1,     2,     3,
       4,     3,     2,     1,     2,     1,     2,     1,     2,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     2,     1,
       2,     3,     2,     1,     2,     2,     3,     1,     2,     1,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     2,
       2,     3,     1,     3,     2,     3,     3,     3,     3,     2,
       1,     3,     2,     2,     1,     1,     2,     3,     1,     2,
       3,     4,     5,     2,     3,     3,     2,     1,     2,     3,
       4,     4,     5,     6,     7,     1,     3,     2,     1,     1,
       3,     4,     2,     1,     5,     6,     1,     1,     3,     2,
       1,     2,     1,     1,     1,     3,     2,     2,     3,     3,
       2,     1,     1,     1,     2,     3,     2,     1,     2,     3,
       4,     3,     2,     3,     1,     2,     2,     1,     3,     2,
       3,     3,     4,     3,     3,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, RESULT, yyscanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location, RESULT, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (yylocationp);
  YYUSE (RESULT);
  YYUSE (yyscanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yytype, yyvaluep, yylocationp, RESULT, yyscanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[+yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       , RESULT, yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, RESULT, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#  else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                yy_state_t *yyssp, int yytoken)
{
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Actual size of YYARG. */
  int yycount = 0;
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[+*yyssp];
      YYPTRDIFF_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
      yysize = yysize0;
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYPTRDIFF_T yysize1
                    = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    /* Don't count the "%s"s in the final size, but reserve room for
       the terminator.  */
    YYPTRDIFF_T yysize1 = yysize + (yystrlen (yyformat) - 2 * yycount) + 1;
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (RESULT);
  YYUSE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
    case 3: /* TOK_STRING  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1579 "flow_csh_lang.cc"
        break;

    case 4: /* TOK_QSTRING  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1585 "flow_csh_lang.cc"
        break;

    case 5: /* TOK_NUMBER  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1591 "flow_csh_lang.cc"
        break;

    case 15: /* TOK_IF  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1597 "flow_csh_lang.cc"
        break;

    case 16: /* TOK_STEP  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1603 "flow_csh_lang.cc"
        break;

    case 17: /* TOK_REPEAT  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1609 "flow_csh_lang.cc"
        break;

    case 18: /* TOK_START  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1615 "flow_csh_lang.cc"
        break;

    case 19: /* TOK_STOP  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1621 "flow_csh_lang.cc"
        break;

    case 20: /* TOK_GOTO  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1627 "flow_csh_lang.cc"
        break;

    case 21: /* TOK_BRANCH  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1633 "flow_csh_lang.cc"
        break;

    case 22: /* TOK_THEN  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1639 "flow_csh_lang.cc"
        break;

    case 23: /* TOK_ELSE  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1645 "flow_csh_lang.cc"
        break;

    case 24: /* TOK_YES  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1651 "flow_csh_lang.cc"
        break;

    case 25: /* TOK_NO  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1657 "flow_csh_lang.cc"
        break;

    case 26: /* TOK_SHAPE_COMMAND  */
#line 119 "flow_lang.yy"
            { }
#line 1663 "flow_csh_lang.cc"
        break;

    case 27: /* TOK_BYE  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1669 "flow_csh_lang.cc"
        break;

    case 28: /* TOK_COLON_STRING  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1675 "flow_csh_lang.cc"
        break;

    case 29: /* TOK_COLON_QUOTED_STRING  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1681 "flow_csh_lang.cc"
        break;

    case 30: /* TOK_COLORDEF  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1687 "flow_csh_lang.cc"
        break;

    case 31: /* TOK_COMMAND_DEFSHAPE  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1693 "flow_csh_lang.cc"
        break;

    case 32: /* TOK_COMMAND_DEFCOLOR  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1699 "flow_csh_lang.cc"
        break;

    case 33: /* TOK_COMMAND_DEFSTYLE  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1705 "flow_csh_lang.cc"
        break;

    case 34: /* TOK_COMMAND_DEFDESIGN  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1711 "flow_csh_lang.cc"
        break;

    case 42: /* top_level_instrlist  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction_list);}
#line 1717 "flow_csh_lang.cc"
        break;

    case 43: /* braced_instrlist  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction_list);}
#line 1723 "flow_csh_lang.cc"
        break;

    case 44: /* instrlist  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction_list);}
#line 1729 "flow_csh_lang.cc"
        break;

    case 45: /* several_instructions  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction_list);}
#line 1735 "flow_csh_lang.cc"
        break;

    case 46: /* instr_with_semicolon  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1741 "flow_csh_lang.cc"
        break;

    case 47: /* optlist_with_semicolon  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction_list);}
#line 1747 "flow_csh_lang.cc"
        break;

    case 48: /* instr_needs_semicolon  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1753 "flow_csh_lang.cc"
        break;

    case 49: /* step_types  */
#line 119 "flow_lang.yy"
            { }
#line 1759 "flow_csh_lang.cc"
        break;

    case 50: /* actual_instr_needs_semicolon  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1765 "flow_csh_lang.cc"
        break;

    case 51: /* actual_instr  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1771 "flow_csh_lang.cc"
        break;

    case 52: /* goto  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1777 "flow_csh_lang.cc"
        break;

    case 53: /* goto_with_semicolon  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1783 "flow_csh_lang.cc"
        break;

    case 54: /* branch_with_semicolon  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).branch);}
#line 1789 "flow_csh_lang.cc"
        break;

    case 55: /* branch_keyword  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1795 "flow_csh_lang.cc"
        break;

    case 56: /* branch_no_content  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).branch);}
#line 1801 "flow_csh_lang.cc"
        break;

    case 57: /* optlist  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction_list);}
#line 1807 "flow_csh_lang.cc"
        break;

    case 58: /* opt  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1813 "flow_csh_lang.cc"
        break;

    case 61: /* stylenamelist  */
#line 120 "flow_lang.yy"
            {delete ((*yyvaluep).stringlist);}
#line 1819 "flow_csh_lang.cc"
        break;

    case 63: /* shapedeflist  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).shape);}
#line 1825 "flow_csh_lang.cc"
        break;

    case 64: /* shapeline  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).shapeelement);}
#line 1831 "flow_csh_lang.cc"
        break;

    case 66: /* color_string  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1837 "flow_csh_lang.cc"
        break;

    case 74: /* colon_string  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1843 "flow_csh_lang.cc"
        break;

    case 75: /* full_attrlist_with_label  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attributelist);}
#line 1849 "flow_csh_lang.cc"
        break;

    case 76: /* full_attrlist  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attributelist);}
#line 1855 "flow_csh_lang.cc"
        break;

    case 77: /* attrlist  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attributelist);}
#line 1861 "flow_csh_lang.cc"
        break;

    case 78: /* attr  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attribute);}
#line 1867 "flow_csh_lang.cc"
        break;

    case 79: /* entity_string  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1873 "flow_csh_lang.cc"
        break;

    case 80: /* reserved_word_string  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1879 "flow_csh_lang.cc"
        break;

    case 81: /* symbol_string  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1885 "flow_csh_lang.cc"
        break;

    case 82: /* alpha_string  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1891 "flow_csh_lang.cc"
        break;

    case 83: /* string  */
#line 118 "flow_lang.yy"
            {free(((*yyvaluep).str));}
#line 1897 "flow_csh_lang.cc"
        break;

    case 85: /* scope_close  */
#line 121 "flow_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).instruction);}
#line 1903 "flow_csh_lang.cc"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYPTRDIFF_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

/* User initialization code.  */
#line 8 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    yylloc.first_pos = 0;
    yylloc.last_pos = 0;
  #endif
}

#line 2018 "flow_csh_lang.cc"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2:
#line 177 "flow_lang.yy"
{
	YYACCEPT;
}
#line 2219 "flow_csh_lang.cc"
    break;

  case 3:
#line 181 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-1]), "Syntax error.");
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Syntax error.");
  #endif
	YYACCEPT;
}
#line 2232 "flow_csh_lang.cc"
    break;

  case 5:
#line 193 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
	csh.AddCSH_AllCommentBeyond((yylsp[0]));
  #else
  #endif
    free((yyvsp[0].str));
}
#line 2245 "flow_csh_lang.cc"
    break;

  case 6:
#line 202 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
	csh.AddCSH_AllCommentBeyond((yylsp[0]));
  #else
  #endif
    free((yyvsp[-1].str));
}
#line 2259 "flow_csh_lang.cc"
    break;

  case 7:
#line 213 "flow_lang.yy"
{
  //Add here what to do for an empty chart
  #ifdef C_S_H_IS_COMPILED
    csh.AddLineBeginToHints();
    csh.hintStatus = HINT_READY;
    csh.hintSource = EHintSourceType::LINE_START;
    csh.hintsForcedOnly = true;
  #else
    //no action for empty file
  #endif
}
#line 2275 "flow_csh_lang.cc"
    break;

  case 8:
#line 225 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintBefore((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
#else
    chart.AddElements((yyvsp[0].instruction_list));
  #endif
}
#line 2290 "flow_csh_lang.cc"
    break;

  case 10:
#line 239 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Closing brace missing its opening pair.");
  #else
    (yyval.instruction_list) = (yyvsp[-1].instruction_list);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Unexpected '}'.");
  #endif
}
#line 2303 "flow_csh_lang.cc"
    break;

  case 11:
#line 248 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-1]), "Closing brace missing its opening pair.");
  #else
    //Merge $3 into $1
    ((yyvsp[-2].instruction_list))->splice(((yyvsp[-2].instruction_list))->end(), *((yyvsp[0].instruction_list)));
    delete ((yyvsp[0].instruction_list));
    (yyval.instruction_list) = (yyvsp[-2].instruction_list);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Unexpected '}'.");
  #endif
}
#line 2319 "flow_csh_lang.cc"
    break;

  case 12:
#line 262 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
  #else
    if ((yyvsp[0].instruction)) ((yyvsp[-1].instruction_list))->Append((yyvsp[0].instruction)); //Append any potential CommandNumbering
    (yyval.instruction_list) = (yyvsp[-1].instruction_list);
  #endif
}
#line 2332 "flow_csh_lang.cc"
    break;

  case 13:
#line 271 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
  #else
    (yyval.instruction_list) = new FElementList;
    //scope_close should not return here with a CommandNumbering
    //but just in case
    if ((yyvsp[0].instruction))
        delete((yyvsp[0].instruction));
  #endif
}
#line 2348 "flow_csh_lang.cc"
    break;

  case 14:
#line 283 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as a valid line.");
  #else
    if ((yyvsp[0].instruction)) ((yyvsp[-2].instruction_list))->Append((yyvsp[0].instruction));
    (yyval.instruction_list) = (yyvsp[-2].instruction_list);
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Syntax error.");
  #endif
    yyerrok;
}
#line 2364 "flow_csh_lang.cc"
    break;

  case 15:
#line 295 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as a valid line.");
  #else
    (yyval.instruction_list) = (yyvsp[-2].instruction_list);
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-3])), CHART_POS_START((yylsp[-1])), "Here is the corresponding '{'.");
  #endif
}
#line 2380 "flow_csh_lang.cc"
    break;

  case 16:
#line 307 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing a closing brace ('}').");
  #else
    (yyval.instruction_list) = (yyvsp[-1].instruction_list);
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_AFTER((yylsp[-1])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-1])), "Here is the corresponding '{'.");
  #endif
}
#line 2396 "flow_csh_lang.cc"
    break;

  case 17:
#line 319 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing a closing brace ('}').");
  #else
    (yyval.instruction_list) = nullptr;
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_AFTER((yylsp[-1])), "Missing a corresponding '}'.");
  #endif
}
#line 2411 "flow_csh_lang.cc"
    break;

  case 18:
#line 330 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[0]), "The command 'bye' can only be used at the top level.");
  #else
    (yyval.instruction_list) = (yyvsp[-1].instruction_list);
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_START((yylsp[0])), "The command 'bye' can not be used between curly braces '{' and '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_START((yylsp[0])), "Here is the opening '{'.");
  #endif
  free((yyvsp[0].str));
}
#line 2428 "flow_csh_lang.cc"
    break;

  case 19:
#line 343 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[0]), "The command 'bye' can only be used at the top level and not inside curly braces '{' and '}'.");
  #else
    (yyval.instruction_list) = nullptr;
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_START((yylsp[0])), "The command 'bye' can not be used between curly braces '{' and '}'.");
  #endif
  free((yyvsp[0].str));
}
#line 2444 "flow_csh_lang.cc"
    break;

  case 20:
#line 357 "flow_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].instruction))
        (yyval.instruction_list) = (new FElementList)->Append((yyvsp[0].instruction)); /* New list */
    else
        (yyval.instruction_list) = new FElementList;
  #endif
}
#line 2457 "flow_csh_lang.cc"
    break;

  case 21:
#line 366 "flow_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].instruction)) ((yyvsp[-1].instruction_list))->Append((yyvsp[0].instruction));     /* Add to existing list */
    (yyval.instruction_list) = ((yyvsp[-1].instruction_list));
  #endif
}
#line 2468 "flow_csh_lang.cc"
    break;

  case 23:
#line 374 "flow_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    //TODO: Add a nested instructionlist to another instructionslist
    if ((yyvsp[0].instruction_list)) ((yyvsp[-1].instruction_list))->Append((yyvsp[0].instruction_list));     /* Add to existing list */
    (yyval.instruction_list) = ((yyvsp[-1].instruction_list));
  #endif
}
#line 2480 "flow_csh_lang.cc"
    break;

  case 25:
#line 384 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    //Standalone braced instruction lists are instructions - for the purpose of indentation
    csh.AddInstruction((yylsp[0]));
  #endif
  (yyval.instruction_list) = (yyvsp[0].instruction_list);
}
#line 2492 "flow_csh_lang.cc"
    break;

  case 26:
#line 394 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon (';').");
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.instruction)=(yyvsp[0].instruction);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
  #endif
}
#line 2507 "flow_csh_lang.cc"
    break;

  case 27:
#line 405 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.instruction)=(yyvsp[-1].instruction);
  #endif
}
#line 2525 "flow_csh_lang.cc"
    break;

  case 30:
#line 423 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction)=nullptr;
  #endif
}
#line 2542 "flow_csh_lang.cc"
    break;

  case 31:
#line 436 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.instruction)=(yyvsp[-2].instruction);
    chart.Error.Error(CHART_POS_AFTER((yylsp[-2])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-2])), "Here is the beginning of the command as I understood it.");
  #endif
}
#line 2563 "flow_csh_lang.cc"
    break;

  case 32:
#line 453 "flow_lang.yy"
{
    (yyval.instruction) = (yyvsp[0].branch); //to suppress warning of incompatible types.
}
#line 2571 "flow_csh_lang.cc"
    break;

  case 33:
#line 457 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.instruction) = (yyvsp[0].instruction);
  #endif
}
#line 2582 "flow_csh_lang.cc"
    break;

  case 34:
#line 464 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_MARKERNAME);
  #else
    (yyval.instruction) = (yyvsp[0].instruction);
    if ((yyvsp[-1].str) && (yyval.instruction))
        (yyval.instruction)->AddRefName((yyvsp[-1].str));
  #endif
    free((yyvsp[-1].str));
}
#line 2597 "flow_csh_lang.cc"
    break;

  case 35:
#line 475 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_MARKERNAME);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is this.");
  #else
    (yyval.instruction) = (yyvsp[0].instruction);
    if ((yyvsp[-2].str) && (yyval.instruction))
        (yyval.instruction)->AddRefName((yyvsp[-2].str));
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Syntax error here.");
  #endif
    free((yyvsp[-2].str));
}
#line 2614 "flow_csh_lang.cc"
    break;

  case 37:
#line 492 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon (';').");
  #else
    (yyval.instruction_list)=(yyvsp[0].instruction_list);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
  #endif
}
#line 2628 "flow_csh_lang.cc"
    break;

  case 38:
#line 502 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction_list)=(yyvsp[-1].instruction_list);
  #endif
}
#line 2645 "flow_csh_lang.cc"
    break;

  case 41:
#line 519 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction_list)=(yyvsp[-2].instruction_list);
    chart.Error.Error(CHART_POS_AFTER((yylsp[-2])), "Missing a semicolon ';' after option(s).");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-2])), "Here is the beginning of the option list as I understood it.");
  #endif
}
#line 2665 "flow_csh_lang.cc"
    break;

  case 42:
#line 538 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.SkipContent())
        csh.AddCSH_Error((yylsp[-1]), "Cannot define designs inside a procedure.");
    else
        csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (chart.SkipContent())
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Cannot define designs inside a procedure.");
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 2691 "flow_csh_lang.cc"
    break;

  case 43:
#line 560 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.SkipContent())
        csh.AddCSH_Error((yylsp[0]), "Cannot define designs inside a procedure.");
    else {
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
        csh.AddCSH_ErrorAfter((yyloc), "Missing shape name and definition.");
    }
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (chart.SkipContent())
        chart.Error.Error(CHART_POS_START((yylsp[0])), "Cannot define shapes inside a procedure.");
    else
        chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing shape name and definition.");
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 2717 "flow_csh_lang.cc"
    break;

  case 44:
#line 582 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 2737 "flow_csh_lang.cc"
    break;

  case 45:
#line 598 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing color name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a color name to (re-)define.");
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 2759 "flow_csh_lang.cc"
    break;

  case 46:
#line 616 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 2779 "flow_csh_lang.cc"
    break;

  case 47:
#line 632 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing style name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a style name to (re-)define.");
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 2801 "flow_csh_lang.cc"
    break;

  case 48:
#line 650 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.SkipContent())
        csh.AddCSH_Error((yylsp[-1]), "Cannot define designs inside a procedure.");
    else
        csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (chart.SkipContent())
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Cannot define designs inside a procedure.");
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 2823 "flow_csh_lang.cc"
    break;

  case 49:
#line 668 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.SkipContent())
        csh.AddCSH_Error((yylsp[0]), "Cannot define designs inside a procedure.");
    else {
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
        csh.AddCSH_ErrorAfter((yyloc), "Missing design name to (re-)define.");
    }
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (chart.SkipContent())
        chart.Error.Error(CHART_POS_START((yylsp[0])), "Cannot define designs inside a procedure.");
    else
        chart.Error.Error(CHART_POS((yyloc)).end, "Missing a design name to (re-)define.");
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 2850 "flow_csh_lang.cc"
    break;

  case 50:
#line 692 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
     (yyval.steptype) = true;
     free((yyvsp[0].str));
  #else
     (yyval.steptype) = {Step::BOX, (yyvsp[0].str), true};
  #endif
}
#line 2863 "flow_csh_lang.cc"
    break;

  case 51:
#line 701 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
     (yyval.steptype) = true;
     free((yyvsp[0].str));
  #else
     (yyval.steptype) = {Step::IF, (yyvsp[0].str), true};
  #endif
}
#line 2876 "flow_csh_lang.cc"
    break;

  case 52:
#line 710 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
     (yyval.steptype) = false;
     free((yyvsp[0].str));
  #else
     (yyval.steptype) = {Step::START, (yyvsp[0].str), false};
  #endif
}
#line 2889 "flow_csh_lang.cc"
    break;

  case 53:
#line 719 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
     (yyval.steptype) = false;
     free((yyvsp[0].str));
  #else
     (yyval.steptype) = {Step::STOP, (yyvsp[0].str), false};
  #endif
}
#line 2902 "flow_csh_lang.cc"
    break;

  case 54:
#line 730 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if ((yyvsp[0].steptype))
        csh.AddCSH_ErrorAfter((yyloc), "Missing label.");
  #else
    if ((yyvsp[0].steptype).must_have_label) {
        (yyval.instruction) = nullptr;
        chart.Error.Error(CHART_POS_AFTER((yyloc)), "Missing label. Ignoring it.");
    } else {
        (yyval.instruction) = new Step(&chart, (yyvsp[0].steptype).type);
        (yyval.instruction)->SetLineEnd(CHART_POS((yyloc)));
        AttributeList *list = new AttributeList;
        list->Append(std::make_unique<Attribute>("label", (yyvsp[0].steptype).keyword, CHART_POS((yylsp[0])), CHART_POS((yylsp[0])), true));
        (yyval.instruction)->AddAttributeList(list); //destroys list
    }
    free((yyvsp[0].steptype).keyword);
  #endif
}
#line 2926 "flow_csh_lang.cc"
    break;

  case 55:
#line 750 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Step::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Step::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.instruction) = new Step(&chart, (yyvsp[-1].steptype).type);
    (yyval.instruction)->SetLineEnd(CHART_POS((yyloc)));
    (yyval.instruction)->AddAttributeList((yyvsp[0].attributelist));
    free((yyvsp[-1].steptype).keyword);
  #endif
}
#line 2945 "flow_csh_lang.cc"
    break;

  case 56:
#line 765 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is this.");
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Step::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Step::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.instruction) = new Step(&chart, (yyvsp[-2].steptype).type);
    (yyval.instruction)->SetLineEnd(CHART_POS((yyloc)));
    (yyval.instruction)->AddAttributeList((yyvsp[0].attributelist));
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Syntax error here.");
    free((yyvsp[-2].steptype).keyword);
  #endif
}
#line 2966 "flow_csh_lang.cc"
    break;

  case 57:
#line 782 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yyloc), "Missing steps to repeat.");
  #else
    (yyval.instruction) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yyloc)), "Missing steps to repeat. Ignoring 'repeat'.");
  #endif
    free((yyvsp[0].str));
}
#line 2981 "flow_csh_lang.cc"
    break;

  case 58:
#line 793 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yyloc), "Missing steps to repeat.");
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Arrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Arrow::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.instruction) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yyloc)), "Missing steps to repeat. Ignoring 'repeat'.");
    delete (yyvsp[0].attributelist);
  #endif
    free((yyvsp[-1].str));
}
#line 3001 "flow_csh_lang.cc"
    break;

  case 59:
#line 810 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon (';').");
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.instruction)=(yyvsp[0].instruction);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
  #endif
}
#line 3016 "flow_csh_lang.cc"
    break;

  case 60:
#line 821 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.instruction)=(yyvsp[-1].instruction);
  #endif
}
#line 3034 "flow_csh_lang.cc"
    break;

  case 61:
#line 835 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        Arrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        Arrow::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.instruction) = new Repeat(&chart, (yyvsp[0].instruction_list));
    (yyval.instruction)->SetLineEnd(CHART_POS2((yylsp[-2]),(yylsp[-1])));
    (yyval.instruction)->AddAttributeList((yyvsp[-1].attributelist));
  #endif
    free((yyvsp[-2].str));
}
#line 3053 "flow_csh_lang.cc"
    break;

  case 62:
#line 850 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
  #else
    (yyval.instruction) = new Repeat(&chart, (yyvsp[0].instruction_list));
    (yyval.instruction)->SetLineEnd(CHART_POS((yylsp[-1])));
    (yyval.instruction)->AddAttributeList(nullptr);
  #endif
    free((yyvsp[-1].str));
}
#line 3068 "flow_csh_lang.cc"
    break;

  case 63:
#line 862 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yyloc), "Missing step name.");
  #else
    (yyval.instruction) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yyloc)), "Missing step name. Ignoring 'goto'.");
  #endif
    free((yyvsp[0].str));
}
#line 3083 "flow_csh_lang.cc"
    break;

  case 64:
#line 873 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_MARKERNAME);
  #else
    (yyval.instruction) = new Goto(&chart, (yyvsp[0].str));
    (yyval.instruction)->SetLineEnd(CHART_POS((yyloc)));
    (yyval.instruction)->AddAttributeList(nullptr);
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 3100 "flow_csh_lang.cc"
    break;

  case 65:
#line 886 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing step name.");
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Arrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Arrow::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.instruction) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yyloc)), "Missing step name. Ignoring 'goto'.");
    delete (yyvsp[0].attributelist);
  #endif
    free((yyvsp[-1].str));
}
#line 3120 "flow_csh_lang.cc"
    break;

  case 66:
#line 902 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_MARKERNAME);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Arrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Arrow::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.instruction) = new Goto(&chart, (yyvsp[-1].str));
    (yyval.instruction)->SetLineEnd(CHART_POS((yyloc)));
    (yyval.instruction)->AddAttributeList((yyvsp[0].attributelist));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
}
#line 3141 "flow_csh_lang.cc"
    break;

  case 67:
#line 921 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon (';').");
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.instruction)=(yyvsp[0].instruction);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
  #endif
}
#line 3156 "flow_csh_lang.cc"
    break;

  case 68:
#line 932 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.instruction)=(yyvsp[-1].instruction);
  #endif
}
#line 3174 "flow_csh_lang.cc"
    break;

  case 69:
#line 949 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon (';').");
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.branch)=(yyvsp[0].branch);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
  #endif
}
#line 3189 "flow_csh_lang.cc"
    break;

  case 70:
#line 960 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    //if ($1) ($1)->SetLineEnd(CHART_POS(@$));
    (yyval.branch)=(yyvsp[-1].branch);
  #endif
}
#line 3207 "flow_csh_lang.cc"
    break;

  case 71:
#line 974 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.branch) = (yyvsp[-1].branch)->AddStep((yyvsp[0].instruction));
  #endif
}
#line 3218 "flow_csh_lang.cc"
    break;

  case 72:
#line 981 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.branch) = (yyvsp[-1].branch)->AddSteps((yyvsp[0].instruction_list));
  #endif
}
#line 3229 "flow_csh_lang.cc"
    break;

  case 73:
#line 989 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
  #else
    (yyval.str) = strdup("");
    free((yyvsp[0].str));
  #endif
}
#line 3242 "flow_csh_lang.cc"
    break;

  case 74:
#line 998 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
  #else
    (yyval.str) = strdup("yes");
    free((yyvsp[0].str));
  #endif
}
#line 3255 "flow_csh_lang.cc"
    break;

  case 75:
#line 1007 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
  #else
    (yyval.str) = strdup("yes");
    free((yyvsp[0].str));
  #endif
}
#line 3268 "flow_csh_lang.cc"
    break;

  case 76:
#line 1016 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
  #else
    (yyval.str) = strdup("no");
    free((yyvsp[0].str));
  #endif
}
#line 3281 "flow_csh_lang.cc"
    break;

  case 77:
#line 1025 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
  #else
    (yyval.str) = strdup("no");
    free((yyvsp[0].str));
  #endif
}
#line 3294 "flow_csh_lang.cc"
    break;

  case 78:
#line 1035 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.branch) = new Branch(&chart);
    (yyval.branch)->SetLineEnd(CHART_POS((yyloc)));
    (yyval.branch)->AddAttributeList(nullptr);
  #endif
    free((yyvsp[0].str));
}
#line 3308 "flow_csh_lang.cc"
    break;

  case 79:
#line 1045 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #else
    (yyval.branch) = new Branch(&chart);
    (yyval.branch)->AddLabel((yyvsp[0].str));
    (yyval.branch)->SetLineEnd(CHART_POS((yyloc)));
    (yyval.branch)->AddAttributeList(nullptr);
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 3325 "flow_csh_lang.cc"
    break;

  case 80:
#line 1058 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Arrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Arrow::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.branch) = new Branch(&chart);
    (yyval.branch)->AddAttributeList((yyvsp[0].attributelist));
    (yyval.branch)->SetLineEnd(CHART_POS((yyloc)));
  #endif
    free((yyvsp[-1].str));
}
#line 3343 "flow_csh_lang.cc"
    break;

  case 81:
#line 1072 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_ATTRVALUE);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Arrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Arrow::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.branch) = new Branch(&chart);
    (yyval.branch)->AddLabel((yyvsp[-1].str))->AddAttributeList((yyvsp[0].attributelist));
    (yyval.branch)->SetLineEnd(CHART_POS((yyloc)));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
}
#line 3363 "flow_csh_lang.cc"
    break;

  case 82:
#line 1090 "flow_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].instruction))
        (yyval.instruction_list) = (new FElementList)->Append((yyvsp[0].instruction)); /* New list */
    else
        (yyval.instruction_list) = new FElementList;
  #endif
}
#line 3376 "flow_csh_lang.cc"
    break;

  case 83:
#line 1099 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].instruction)) ((yyvsp[-2].instruction_list))->Append((yyvsp[0].instruction));     /* Add to existing list */
    (yyval.instruction_list) = ((yyvsp[-2].instruction_list));
  #endif
  #endif
}
#line 3395 "flow_csh_lang.cc"
    break;

  case 84:
#line 1114 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction_list) = (yyvsp[-1].instruction_list);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Expecting an option here.");
  #endif
}
#line 3412 "flow_csh_lang.cc"
    break;

  case 86:
#line 1128 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_Error((yylsp[0]), "An option expected here.");
  #else
    (yyval.instruction_list) = (yyvsp[-2].instruction_list);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "I am not sure what is coming here.");
  #endif
}
#line 3430 "flow_csh_lang.cc"
    break;

  case 87:
#line 1144 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str))) {
        FlowChart::AttributeValues((yyvsp[-2].str), csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction) = chart.AddAttribute(Attribute((yyvsp[-2].str), (yyvsp[0].str), CHART_POS((yylsp[-2])), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 3453 "flow_csh_lang.cc"
    break;

  case 88:
#line 1163 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].str), (yyvsp[-2].str));
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str))) {
        FlowChart::AttributeValues((yyvsp[-2].str), csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.instruction) = chart.AddAttribute(Attribute((yyvsp[-2].str), (yyvsp[0].str), CHART_POS((yylsp[-2])), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 3476 "flow_csh_lang.cc"
    break;

  case 89:
#line 1182 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing option value.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-1].str))) {
        FlowChart::AttributeValues((yyvsp[-1].str), csh);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing option value.");
    (yyval.instruction) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 3499 "flow_csh_lang.cc"
    break;

  case 91:
#line 1203 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #endif
}
#line 3513 "flow_csh_lang.cc"
    break;

  case 92:
#line 1213 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing style definition here.", "Try just removing the comma.");
#endif
}
#line 3529 "flow_csh_lang.cc"
    break;

  case 93:
#line 1226 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    for (auto &str : *((yyvsp[-1].stringlist)))
        if (csh.ForbiddenStyles.find(str) == csh.ForbiddenStyles.end())
            csh.CurrentContext().StyleNames.insert(str);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        FlowStyle().AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        FlowStyle().AttributeValues(csh.hintAttrName, csh);
  #else
	chart.AddAttributeListToStyleList((yyvsp[0].attributelist), (yyvsp[-1].stringlist)); //deletes $2, as well
  #endif
    delete((yyvsp[-1].stringlist));
}
#line 3548 "flow_csh_lang.cc"
    break;

  case 94:
#line 1241 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddCSH_ErrorAfter((yyloc), "Missing attribute definitons in square brackets ('[' and ']').");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing attribute definitons in square brackets ('[' and ']').");
  #endif
    delete((yyvsp[0].stringlist));
}
#line 3561 "flow_csh_lang.cc"
    break;

  case 95:
#line 1251 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_STYLENAME);
    (yyval.stringlist) = new std::list<string>;
    if (strcmp((yyvsp[0].str), "emphasis")==0)
        ((yyval.stringlist))->push_back("box");
    else if (strcmp((yyvsp[0].str), "emptyemphasis")==0)
        ((yyval.stringlist))->push_back("emptybox");
    else ((yyval.stringlist))->push_back((yyvsp[0].str));
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME)) {
	csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.stringlist) = new std::list<string>;
    if ((yyvsp[0].str))
        ((yyval.stringlist))->emplace_back((yyvsp[0].str));
  #endif
    free((yyvsp[0].str));
}
#line 3586 "flow_csh_lang.cc"
    break;

  case 96:
#line 1272 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
	csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a style name to (re-)define.");
    if (csh.CheckHintAfter((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
		csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
	(yyval.stringlist) = (yyvsp[-1].stringlist);
  #else
    (yyval.stringlist) = (yyvsp[-1].stringlist);
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a style name to (re-)define.");
  #endif
}
#line 3605 "flow_csh_lang.cc"
    break;

  case 97:
#line 1287 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    csh.AddCSH((yylsp[0]), COLOR_STYLENAME);
    (yyval.stringlist) = (yyvsp[-2].stringlist);
    if (strcmp((yyvsp[0].str), "emphasis")==0)
        ((yyval.stringlist))->push_back("box");
    else if (strcmp((yyvsp[0].str), "emptyemphasis")==0)
        ((yyval.stringlist))->push_back("emptybox");
    else ((yyval.stringlist))->push_back((yyvsp[0].str));
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
		csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[0].str))
        ((yyvsp[-2].stringlist))->emplace_back((yyvsp[0].str));
    (yyval.stringlist) = (yyvsp[-2].stringlist);
  #endif
    free((yyvsp[0].str));
}
#line 3631 "flow_csh_lang.cc"
    break;

  case 98:
#line 1311 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    csh.AddCSH_ErrorAfter((yyloc), ("Here should come a shape definition beginning with '{'. Ignoring this malformed shape definition for '"+string((yyvsp[0].str) ? (yyvsp[0].str) : "") +"'.").c_str());
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Here should come a shape definition beginning with '{'. Ignoring this malformed shape definition for '"+string((yyvsp[0].str) ? (yyvsp[0].str) : "") +"'.");
  #endif
  free((yyvsp[0].str));
}
#line 3645 "flow_csh_lang.cc"
    break;

  case 99:
#line 1321 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddOpenBracePair((yylsp[0]));
    csh.AddCSH((yylsp[-1]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.AddCSH_ErrorAfter((yyloc), ("Here should come a shape definition beginning with 'T', 'H', 'M', 'L', 'C', 'S', 'P' or 'E'. Ignoring this malformed shape definition for '"+string((yyvsp[-1].str) ? (yyvsp[-1].str): "") +"'.").c_str());
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Here should come a shape definition beginning with 'T', 'H', 'M', 'L', 'C', 'S', 'P' or 'E'. Ignoring this malformed shape definition for '"+string((yyvsp[-1].str) ? (yyvsp[-1].str): "") +"'.");
  #endif
  free((yyvsp[-1].str));
}
#line 3661 "flow_csh_lang.cc"
    break;

  case 100:
#line 1333 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddOpenBracePair((yylsp[-1])+(yylsp[0]));
    csh.AddCSH((yylsp[-2]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[-1]), COLOR_BRACE);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a closing brace ('}').");
	csh.AddShapeName((yyvsp[-2].str));
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-1])), CHART_POS_AFTER((yylsp[0])), "Here is the corresponding '{'.");
    if ((yyvsp[0].shape)) {
        if (!chart.SkipContent())
            chart.Shapes.Add(std::string((yyvsp[-2].str)), CHART_POS_START((yylsp[-2])), chart.file_url, chart.file_info, std::move(*(yyvsp[0].shape)), chart.Error);
	delete (yyvsp[0].shape);
    }
  #endif
  free((yyvsp[-2].str));
}
#line 3684 "flow_csh_lang.cc"
    break;

  case 101:
#line 1352 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[-2]), COLOR_BRACE);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
	csh.AddShapeName((yyvsp[-3].str));
    csh.BracePairs.push_back((yylsp[-2])+(yylsp[0]));
  #else
    if ((yyvsp[-1].shape)) {
        if (!chart.SkipContent())
            chart.Shapes.Add(std::string((yyvsp[-3].str)), CHART_POS_START((yylsp[-3])), chart.file_url, chart.file_info, std::move(*(yyvsp[-1].shape)), chart.Error);
	delete (yyvsp[-1].shape);
    }
  #endif
  free((yyvsp[-3].str));
}
#line 3705 "flow_csh_lang.cc"
    break;

  case 102:
#line 1369 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[-3]), COLOR_BRACE);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.BracePairs.push_back((yylsp[-3])+(yylsp[0]));
	csh.AddShapeName((yyvsp[-4].str));
    csh.AddCSH_Error((yylsp[-1]), "Only numbers can come after shape commands.");
  #else
    if ((yyvsp[-2].shape)) {
        if (!chart.SkipContent())
            chart.Shapes.Add(std::string((yyvsp[-4].str)), CHART_POS_START((yylsp[-4])), chart.file_url, chart.file_info, std::move(*(yyvsp[-2].shape)), chart.Error);
	delete (yyvsp[-2].shape);
    }
  #endif
  free((yyvsp[-4].str));
}
#line 3727 "flow_csh_lang.cc"
    break;

  case 103:
#line 1388 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
  #else
    (yyval.shape) = new Shape;
	if ((yyvsp[-1].shapeelement)) {
		((yyval.shape))->Add(std::move(*((yyvsp[-1].shapeelement))));
		delete (yyvsp[-1].shapeelement);
	}
  #endif
}
#line 3743 "flow_csh_lang.cc"
    break;

  case 104:
#line 1400 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-2]), "I do not understand this.");
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
#else
    (yyval.shape) = new Shape;
	if ((yyvsp[-1].shapeelement)) {
		((yyval.shape))->Add(std::move(*((yyvsp[-1].shapeelement))));
		delete (yyvsp[-1].shapeelement);
	}
  #endif
}
#line 3760 "flow_csh_lang.cc"
    break;

  case 105:
#line 1413 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
  #else
	if ((yyvsp[-1].shapeelement)) {
		((yyvsp[-2].shape))->Add(std::move(*((yyvsp[-1].shapeelement))));
		delete (yyvsp[-1].shapeelement);
	}
    (yyval.shape) = (yyvsp[-2].shape);
  #endif
}
#line 3776 "flow_csh_lang.cc"
    break;

  case 106:
#line 1425 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Only numbers can come after shape commands.");
  #else
    (yyval.shape) = (yyvsp[-1].shape);
  #endif
}
#line 3788 "flow_csh_lang.cc"
    break;

  case 107:
#line 1434 "flow_lang.yy"
{
    const int num_args = 0;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[0].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
	if (should_args != num_args)
		csh.AddCSH_ErrorAfter((yyloc), ShapeElement::ErrorMsg((yyvsp[0].shapecommand), num_args));
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args != num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[0].shapecommand), num_args).append(" Ignoring line."));
	else
	    (yyval.shapeelement) = new ShapeElement((yyvsp[0].shapecommand));
  #endif
}
#line 3808 "flow_csh_lang.cc"
    break;

  case 108:
#line 1450 "flow_lang.yy"
{
    const int num_args = 1;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-1].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
	if (should_args != num_args) {
		string msg = ShapeElement::ErrorMsg((yyvsp[-1].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-1].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	} else if ((yyvsp[-1].shapecommand)>=ShapeElement::SECTION_BG && (((yyvsp[0].str))[0]<'0' || ((yyvsp[0].str))[0]>'2' || ((yyvsp[0].str))[1]!=0))
		csh.AddCSH_Error((yylsp[0]), "S (section) commands require an integer between 0 and 2.");
  #else
	(yyval.shapeelement) = nullptr;
	const double a = atof((yyvsp[0].str));
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yylsp[0])).end, ShapeElement::ErrorMsg((yyvsp[-1].shapecommand), num_args).append(" Ignoring line."));
	else if ((yyvsp[-1].shapecommand)>=ShapeElement::SECTION_BG && (a!=0 && a!=1 && a!=2))
		chart.Error.Error(CHART_POS_START((yylsp[0])), "S (section) commands require an integer between 0 and 2. Ignoring line.");
	else if ((yyvsp[-1].shapecommand)>=ShapeElement::SECTION_BG)
	    (yyval.shapeelement) = new ShapeElement(ShapeElement::Type((yyvsp[-1].shapecommand) + unsigned(a)));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-1].shapecommand), a);
  #endif
  free((yyvsp[0].str));
}
#line 3840 "flow_csh_lang.cc"
    break;

  case 109:
#line 1478 "flow_lang.yy"
{
    const int num_args = 2;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-2].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
	if (should_args != num_args) {
		string msg = ShapeElement::ErrorMsg((yyvsp[-2].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-2].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-2].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-2].shapecommand), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
  free((yyvsp[-1].str));
  free((yyvsp[0].str));
}
#line 3868 "flow_csh_lang.cc"
    break;

  case 110:
#line 1502 "flow_lang.yy"
{
    const int num_args = 3;
	  const int should_args = ShapeElement::GetNumArgs((yyvsp[-3].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
	  if (should_args != num_args) {
        std::string msg = ShapeElement::ErrorMsg((yyvsp[-3].shapecommand), num_args);
        switch (ShapeElement::GetNumArgs((yyvsp[-3].shapecommand))) {
        case 0:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
        case 1:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
        case 2:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
        default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
        }
  	} else if ((yyvsp[-3].shapecommand)!=ShapeElement::PORT)
        csh.AddCSH_Error((yylsp[0]), "You need to specify a number here.");
  #else
  	(yyval.shapeelement) = nullptr;
	  if (should_args > num_args)
	      chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-3].shapecommand), num_args).append(" Ignoring line."));
   	else if ((yyvsp[-3].shapecommand)!=ShapeElement::PORT)
	      chart.Error.Error(CHART_POS_START((yylsp[0])), "Expecting a number here. Ignoring line.");
    else
		    (yyval.shapeelement) = new ShapeElement((yyvsp[-3].shapecommand), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
  free((yyvsp[-2].str));
  free((yyvsp[-1].str));
  free((yyvsp[0].str));
}
#line 3901 "flow_csh_lang.cc"
    break;

  case 111:
#line 1531 "flow_lang.yy"
{
    const int num_args = 3;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-3].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-3].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-3].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	} else if ((yyvsp[-3].shapecommand)==ShapeElement::PORT)
        csh.AddCSH_Error((yylsp[0]), "You need to specify a port name here starting with a letter.");
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-3].shapecommand), num_args).append(" Ignoring line."));
	else if ((yyvsp[-3].shapecommand)==ShapeElement::PORT)
		chart.Error.Error(CHART_POS_START((yylsp[0])), "Expecting a port name here. Ignoring line.");
    else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-3].shapecommand), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
  free((yyvsp[-2].str));
  free((yyvsp[-1].str));
  free((yyvsp[0].str));
}
#line 3934 "flow_csh_lang.cc"
    break;

  case 112:
#line 1560 "flow_lang.yy"
{
    const int num_args = 4;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-4].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_KEYWORD);
	if (should_args != num_args) {
		string msg = ShapeElement::ErrorMsg((yyvsp[-4].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-4].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-3]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 3:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-4].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-4].shapecommand), atof((yyvsp[-3].str)), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
  free((yyvsp[-3].str));
  free((yyvsp[-2].str));
  free((yyvsp[-1].str));
  free((yyvsp[0].str));
}
#line 3966 "flow_csh_lang.cc"
    break;

  case 113:
#line 1588 "flow_lang.yy"
{
    const int num_args = 5;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-5].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-5]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-5].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-5].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-4]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-3]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 3:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 4:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-5].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-5].shapecommand), atof((yyvsp[-4].str)), atof((yyvsp[-3].str)), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
  free((yyvsp[-4].str));
  free((yyvsp[-3].str));
  free((yyvsp[-2].str));
  free((yyvsp[-1].str));
  free((yyvsp[0].str));
}
#line 4000 "flow_csh_lang.cc"
    break;

  case 114:
#line 1618 "flow_lang.yy"
{
    const int num_args = 6;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-6].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-6]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-6].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-6].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-5]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-4]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[-3]) + (yylsp[0]), std::move(msg)); break;
		case 3:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 4:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 5:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-6].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-6].shapecommand), atof((yyvsp[-5].str)), atof((yyvsp[-4].str)), atof((yyvsp[-3].str)), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
  free((yyvsp[-5].str));
  free((yyvsp[-4].str));
  free((yyvsp[-3].str));
  free((yyvsp[-2].str));
  free((yyvsp[-1].str));
  free((yyvsp[0].str));
}
#line 4036 "flow_csh_lang.cc"
    break;

  case 116:
#line 1652 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
	}
  #endif
}
#line 4050 "flow_csh_lang.cc"
    break;

  case 117:
#line 1662 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing color name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a color name to (re-)define.");
  #endif
}
#line 4067 "flow_csh_lang.cc"
    break;

  case 120:
#line 1678 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_COLORNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_COLORDEF);
    ColorType color = csh.CurrentContext().Colors.GetColor((yyvsp[0].str));
    if (color.type!=ColorType::INVALID)
        csh.CurrentContext().Colors[(yyvsp[-2].str)] = color;
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(false);
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!chart.SkipContent())
        chart.MyCurrentContext().colors.AddColor((yyvsp[-2].str), (yyvsp[0].str), chart.Error, CHART_POS((yyloc)));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 4094 "flow_csh_lang.cc"
    break;

  case 121:
#line 1701 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_COLORNAME);
    csh.AddCSH((yylsp[-2]), COLOR_EQUAL);
    csh.AddCSH((yylsp[-1]), COLOR_COLORDEF);
    csh.AddCSH((yylsp[0]), COLOR_COLORDEF);
    ColorType color = csh.CurrentContext().Colors.GetColor("++"+string((yyvsp[0].str)));
    if (color.type!=ColorType::INVALID)
        csh.CurrentContext().Colors[(yyvsp[-3].str)] = color;
    if (csh.CheckHintAt((yylsp[-3]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(false);
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!chart.SkipContent())
        chart.MyCurrentContext().colors.AddColor((yyvsp[-3].str), "++"+string((yyvsp[0].str)), chart.Error, CHART_POS((yyloc)));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[0].str));
}
#line 4122 "flow_csh_lang.cc"
    break;

  case 122:
#line 1725 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COLORNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(false);
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yyloc), "Missing color definition.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing color definition.");
  #endif
    free((yyvsp[-1].str));
}
#line 4144 "flow_csh_lang.cc"
    break;

  case 123:
#line 1743 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COLORNAME);
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing equal sign ('=') and a color definition.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing equal sign ('=') and a color definition.");
  #endif
    free((yyvsp[0].str));
}
#line 4162 "flow_csh_lang.cc"
    break;

  case 124:
#line 1760 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_DESIGNNAME);
    csh.AddCSH((yylsp[-1]), COLOR_SEMICOLON);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.BracePairs.push_back((yylsp[-3])+(yylsp[0]));
    if (!csh.SkipContent()) {
        auto &d = csh.CurrentContext().IsFull() ? csh.FullDesigns : csh.PartialDesigns;
        auto i = d.find((yyvsp[-4].str));
        if (i == d.end())
            d.emplace((yyvsp[-4].str), csh.CurrentContext());
        else
            i->second += csh.CurrentContext();
    }
    csh.PopContext();
    if ((csh.CheckHintBetween((yylsp[-3]), (yylsp[-2]), EHintSourceType::LINE_START) ||
         csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::LINE_START)) ) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!chart.SkipContent()) {
        //'scope_open_empty' pushed an empty color & style set onto the stack
        //then designelementlist added color & style definitions, procedures, etc., now we harvest those.
        //This is either a lookup if the design exists or creates a new empty design of this name
        auto i = chart.Designs.emplace(std::piecewise_construct,
                                       std::forward_as_tuple((yyvsp[-4].str)),
                                       std::forward_as_tuple(chart.MyCurrentContext().IsFull(),
                                                             EContextParse::NORMAL,
                                                             EContextCreate::EMPTY,
                                                             CHART_POS_START((yylsp[-3]))));
        //we apply the content from current context all the same if inserted or existing
        i.first->second.ApplyContextContent(std::move(chart.MyCurrentContext())); //we can move, will pop below
    }
    chart.PopContext();
  #endif
    free((yyvsp[-4].str));
}
#line 4205 "flow_csh_lang.cc"
    break;

  case 125:
#line 1799 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-5]), COLOR_DESIGNNAME);
    csh.AddCSH((yylsp[-2]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as part of a design definition.");
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.BracePairs.push_back((yylsp[-4])+(yylsp[0]));
    if (!csh.SkipContent()) {
        auto &d = csh.CurrentContext().IsFull() ? csh.FullDesigns : csh.PartialDesigns;
        auto i = d.find((yyvsp[-5].str));
        if (i == d.end())
            d.emplace((yyvsp[-5].str), csh.CurrentContext());
        else
            i->second += csh.CurrentContext();
    }
    csh.PopContext();
    if ((csh.CheckHintBetween((yylsp[-4]), (yylsp[-3]), EHintSourceType::LINE_START) ||
         csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::LINE_START))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
#else
    if (!chart.SkipContent()) {
        //if closing brace missing, still do the design definition
        //'scope_open_empty' pushed an empty color & style set onto the stack
        //then designelementlist added color & style definitions, procedures, etc., now we harvest those.
        //This is either a lookup if the design exists or creates a new empty design of this name
        auto i = chart.Designs.emplace(std::piecewise_construct,
                                       std::forward_as_tuple((yyvsp[-5].str)),
                                       std::forward_as_tuple(chart.MyCurrentContext().IsFull(),
                                                             EContextParse::NORMAL,
                                                             EContextCreate::EMPTY,
                                                             CHART_POS_START((yylsp[-4]))));
        //we apply the content from current context all the same if inserted or existing
        i.first->second.ApplyContextContent(std::move(chart.MyCurrentContext())); //we can move, will pop below
    }
    chart.PopContext();
  #endif
}
#line 4249 "flow_csh_lang.cc"
    break;

  case 126:
#line 1841 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.PushContext(true, EContextParse::NORMAL);
  #else
    //push empty color & style sets for design definition
    chart.PushContext(CHART_POS_START((yylsp[0])), EContextParse::NORMAL, EContextCreate::CLEAR);
  #endif
}
#line 4263 "flow_csh_lang.cc"
    break;

  case 128:
#line 1853 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SEMICOLON);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::LINE_START)) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
#endif
}
#line 4277 "flow_csh_lang.cc"
    break;

  case 129:
#line 1864 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
    }
  #endif
    free((yyvsp[-1].str));
}
#line 4295 "flow_csh_lang.cc"
    break;

  case 130:
#line 1878 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing color name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a color name to (re-)define.");
  #endif
    free((yyvsp[0].str));
}
#line 4316 "flow_csh_lang.cc"
    break;

  case 131:
#line 1895 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
	}
  #endif
    free((yyvsp[-1].str));
}
#line 4334 "flow_csh_lang.cc"
    break;

  case 132:
#line 1909 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing style name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a style name to (re-)define.");
  #endif
    free((yyvsp[0].str));
}
#line 4355 "flow_csh_lang.cc"
    break;

  case 135:
#line 1929 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #endif
}
#line 4369 "flow_csh_lang.cc"
    break;

  case 136:
#line 1939 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #endif
}
#line 4383 "flow_csh_lang.cc"
    break;

  case 137:
#line 1949 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Extra stuff after design options. Maybe missing a comma?");
  #endif
}
#line 4393 "flow_csh_lang.cc"
    break;

  case 138:
#line 1956 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str))) {
        FlowChart::AttributeValues((yyvsp[-2].str), csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.AddDesignAttribute(Attribute((yyvsp[-2].str), (yyvsp[0].str), CHART_POS((yyloc)), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 4416 "flow_csh_lang.cc"
    break;

  case 139:
#line 1975 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str))) {
        FlowChart::AttributeValues((yyvsp[-2].str), csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.AddDesignAttribute(Attribute((yyvsp[-2].str), (yyvsp[0].str), CHART_POS((yylsp[-2])), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 4439 "flow_csh_lang.cc"
    break;

  case 140:
#line 1994 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-1].str))) {
        FlowChart::AttributeValues((yyvsp[-1].str), csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing option value. Ignoring this.");
#endif
    free((yyvsp[-1].str));
}
#line 4460 "flow_csh_lang.cc"
    break;

  case 141:
#line 2012 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ColonString_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].str), false);
    csh.AddColonLabel((yylsp[0]), (yyvsp[0].str));
  #endif
    (yyval.str) = (yyvsp[0].str);
}
#line 4472 "flow_csh_lang.cc"
    break;

  case 142:
#line 2020 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ColonString_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].str), true);
	csh.AddColonLabel((yylsp[0]), (yyvsp[0].str));
  #endif
    (yyval.str) = (yyvsp[0].str);
}
#line 4484 "flow_csh_lang.cc"
    break;

  case 143:
#line 2029 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attributelist) = (new AttributeList)->Append(std::make_unique<Attribute>("label", (yyvsp[0].str), CHART_POS((yyloc)), CHART_POS((yyloc)).IncStartCol(), true));
  #endif
    free((yyvsp[0].str));
}
#line 4496 "flow_csh_lang.cc"
    break;

  case 144:
#line 2037 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attributelist) = ((yyvsp[0].attributelist))->Prepend(std::make_unique<Attribute>("label", (yyvsp[-1].str), CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1])).IncStartCol(), true));
  #endif
    free((yyvsp[-1].str));
}
#line 4508 "flow_csh_lang.cc"
    break;

  case 145:
#line 2045 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attributelist) = ((yyvsp[-2].attributelist))->Append(std::make_unique<Attribute>("label", (yyvsp[-1].str), CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1])).IncStartCol(), true));
        //Merge $3 at the end of $1
        ((yyvsp[-2].attributelist))->splice(((yyvsp[-2].attributelist))->end(), *((yyvsp[0].attributelist)));
        delete ((yyvsp[0].attributelist)); //empty list now
        (yyval.attributelist) = (yyvsp[-2].attributelist);
  #endif
    free((yyvsp[-1].str));
}
#line 4524 "flow_csh_lang.cc"
    break;

  case 146:
#line 2057 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attributelist) = ((yyvsp[-1].attributelist))->Append(std::make_unique<Attribute>("label", (yyvsp[0].str), CHART_POS((yylsp[0])), CHART_POS((yylsp[0])).IncStartCol(), true));
  #endif
    free((yyvsp[0].str));
}
#line 4536 "flow_csh_lang.cc"
    break;

  case 148:
#line 2068 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_BRACKET);
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = new AttributeList;
  #endif
}
#line 4551 "flow_csh_lang.cc"
    break;

  case 149:
#line 2079 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_BRACKET);
	csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = (yyvsp[-1].attributelist);
  #endif
}
#line 4566 "flow_csh_lang.cc"
    break;

  case 150:
#line 2090 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[-1]), "Extra stuff after an attribute list. Maybe missing a comma?");
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-3]), (yylsp[-2]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = (yyvsp[-2].attributelist);
  #endif
}
#line 4582 "flow_csh_lang.cc"
    break;

  case 151:
#line 2102 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as an attribute or style name.");
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = new AttributeList;
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Expecting an attribute or style name. Ignoring all until the closing square bracket (']').");
#endif
}
#line 4599 "flow_csh_lang.cc"
    break;

  case 152:
#line 2115 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_BRACKET);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a square bracket (']').");
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
	csh.SqBracketPairs.push_back((yyloc));
  #else
    (yyval.attributelist) = (yyvsp[0].attributelist);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing ']'.");
  #endif
}
#line 4615 "flow_csh_lang.cc"
    break;

  case 153:
#line 2127 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddCSH((yylsp[-2]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[0]), "Missing a ']'.");
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = (yyvsp[-1].attributelist);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing ']'.");
  #endif
}
#line 4631 "flow_csh_lang.cc"
    break;

  case 154:
#line 2139 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a square bracket (']').");
	csh.SqBracketPairs.push_back((yyloc));
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = new AttributeList;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing ']'.");
  #endif
}
#line 4647 "flow_csh_lang.cc"
    break;

  case 155:
#line 2153 "flow_lang.yy"
{
    (yyval.attributelist) = nullptr;
}
#line 4655 "flow_csh_lang.cc"
    break;

  case 156:
#line 2157 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[0]), "Missing a ']'.");
	csh.SqBracketPairs.push_back((yyloc));
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = new AttributeList;
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing ']'.");
  #endif
}
#line 4671 "flow_csh_lang.cc"
    break;

  case 157:
#line 2170 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.attributelist) = (new AttributeList)->Append((yyvsp[0].attribute));
  #endif
}
#line 4682 "flow_csh_lang.cc"
    break;

  case 158:
#line 2177 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attributelist) = ((yyvsp[-2].attributelist))->Append((yyvsp[0].attribute));
  #endif
}
#line 4695 "flow_csh_lang.cc"
    break;

  case 159:
#line 2186 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing attribute or style name.");
  #else
    (yyval.attributelist) = (yyvsp[-1].attributelist);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Expecting an attribute or style name here.");
  #endif
}
#line 4710 "flow_csh_lang.cc"
    break;

  case 161:
#line 2200 "flow_lang.yy"
{
  //string=string
  #ifdef C_S_H_IS_COMPILED
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].str), COLOR_ATTRNAME);
        csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
        csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].str), (yyvsp[-2].str));
        csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
        csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str));
  #else
        (yyval.attribute) = new Attribute((yyvsp[-2].str), (yyvsp[0].str), CHART_POS((yylsp[-2])), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 4729 "flow_csh_lang.cc"
    break;

  case 162:
#line 2215 "flow_lang.yy"
{
  //string=string
  #ifdef C_S_H_IS_COMPILED
        csh.AddCSH_AttrName((yylsp[-3]), (yyvsp[-3].str), COLOR_ATTRNAME);
        csh.AddCSH((yylsp[-2]), COLOR_EQUAL);
        csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[-1])+(yylsp[0]), (string("++")+(yyvsp[0].str)).c_str(), (yyvsp[-3].str));
        csh.CheckHintAt((yylsp[-3]), EHintSourceType::ATTR_NAME);
        csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1])+(yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-3].str));
  #else
        (yyval.attribute) = new Attribute((yyvsp[-3].str), string("++")+(yyvsp[0].str), CHART_POS((yylsp[-3])), CHART_POS2((yylsp[-1]),(yylsp[0])));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[0].str));
}
#line 4748 "flow_csh_lang.cc"
    break;

  case 163:
#line 2230 "flow_lang.yy"
{
  //string=string
  #ifdef C_S_H_IS_COMPILED
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].str), COLOR_ATTRNAME);
        csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
        csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), "++", (yyvsp[-2].str));
		csh.AddCSH_ErrorAfter((yylsp[0]), "Continue with a color name or definition.");
        csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
        csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str));
  #else
        (yyval.attribute) = new Attribute((yyvsp[-2].str), "++", CHART_POS((yylsp[-2])), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].str));
}
#line 4767 "flow_csh_lang.cc"
    break;

  case 164:
#line 2245 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].str), COLOR_ATTRNAME);
        csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
        csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
        csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
        csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str));
  #else
        (yyval.attribute) = new Attribute((yyvsp[-2].str), (yyvsp[0].str), CHART_POS((yyloc)), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 4785 "flow_csh_lang.cc"
    break;

  case 165:
#line 2259 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
        csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].str), COLOR_ATTRNAME);
        csh.AddCSH((yylsp[0]), COLOR_EQUAL);
        csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME);
        csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-1].str));
  #else
        (yyval.attribute) = new Attribute((yyvsp[-1].str), {}, CHART_POS((yyloc)), CHART_POS((yyloc)));
  #endif
    free((yyvsp[-1].str));
}
#line 4801 "flow_csh_lang.cc"
    break;

  case 166:
#line 2273 "flow_lang.yy"
{
    (yyval.attribute) = nullptr;
    free((yyvsp[-2].str));
}
#line 4810 "flow_csh_lang.cc"
    break;

  case 167:
#line 2278 "flow_lang.yy"
{
  //here we accept non alpha strings for "->" and similar style names
  #ifdef C_S_H_IS_COMPILED
        csh.AddCSH_StyleOrAttrName((yylsp[0]), (yyvsp[0].str));
        csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
        (yyval.attribute) = new Attribute((yyvsp[0].str), CHART_POS((yyloc)));
  #endif
    free((yyvsp[0].str));
}
#line 4825 "flow_csh_lang.cc"
    break;

  case 169:
#line 2307 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddQuotedString((yylsp[0]));
  #endif
  (yyval.str) = (yyvsp[0].str);
}
#line 4836 "flow_csh_lang.cc"
    break;

  case 170:
#line 2314 "flow_lang.yy"
{
	(yyval.str) = (char*)malloc(2);
	((yyval.str))[0] = ShapeElement::act_code[(yyvsp[0].shapecommand)];
	((yyval.str))[1] = 0;
}
#line 4846 "flow_csh_lang.cc"
    break;

  case 182:
#line 2328 "flow_lang.yy"
{
    (yyval.str) = nullptr;
}
#line 4854 "flow_csh_lang.cc"
    break;

  case 187:
#line 2337 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.PushContext();
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::LINE_START)) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.PushContext(CHART_POS_START((yylsp[0])));
  #endif
}
#line 4871 "flow_csh_lang.cc"
    break;

  case 189:
#line 2354 "flow_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.instruction) = nullptr;
    csh.PopContext();
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
  #else
    (yyval.instruction) = chart.PopContext();
  #endif
}
#line 4885 "flow_csh_lang.cc"
    break;


#line 4889 "flow_csh_lang.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, RESULT, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *, YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, RESULT, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, RESULT, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp, RESULT, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, RESULT, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, RESULT, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[+*yyssp], yyvsp, yylsp, RESULT, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 2365 "flow_lang.yy"



/* END OF FILE */
