/* moonshot-identities-manager.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-identities-manager.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-keyring-memory.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PASSWORD (password_get_type ())
#define PASSWORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PASSWORD, Password))
#define PASSWORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PASSWORD, PasswordClass))
#define IS_PASSWORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PASSWORD))
#define IS_PASSWORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PASSWORD))
#define PASSWORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PASSWORD, PasswordClass))

typedef struct _Password Password;
typedef struct _PasswordClass PasswordClass;
typedef struct _PasswordPrivate PasswordPrivate;
typedef struct _ParamSpecPassword ParamSpecPassword;

#define TYPE_PASSWORD_HASH_TABLE (password_hash_table_get_type ())
#define PASSWORD_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PASSWORD_HASH_TABLE, PasswordHashTable))
#define PASSWORD_HASH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PASSWORD_HASH_TABLE, PasswordHashTableClass))
#define IS_PASSWORD_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PASSWORD_HASH_TABLE))
#define IS_PASSWORD_HASH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PASSWORD_HASH_TABLE))
#define PASSWORD_HASH_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PASSWORD_HASH_TABLE, PasswordHashTableClass))

typedef struct _PasswordHashTable PasswordHashTable;
typedef struct _PasswordHashTableClass PasswordHashTableClass;
typedef struct _PasswordHashTablePrivate PasswordHashTablePrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_IIDENTITY_CARD_STORE (iidentity_card_store_get_type ())
#define IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStore))
#define IS_IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_CARD_STORE))
#define IIDENTITY_CARD_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStoreIface))

typedef struct _IIdentityCardStore IIdentityCardStore;
typedef struct _IIdentityCardStoreIface IIdentityCardStoreIface;

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;
typedef struct _IdentityManagerModelPrivate IdentityManagerModelPrivate;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;

#define TYPE_KEYRING_STORE (keyring_store_get_type ())
#define KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYRING_STORE, KeyringStore))
#define KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYRING_STORE, KeyringStoreClass))
#define IS_KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYRING_STORE))
#define IS_KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYRING_STORE))
#define KEYRING_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYRING_STORE, KeyringStoreClass))

typedef struct _KeyringStore KeyringStore;
typedef struct _KeyringStoreClass KeyringStoreClass;

#define TYPE_LOCAL_FLAT_FILE_STORE (local_flat_file_store_get_type ())
#define LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStore))
#define LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))
#define IS_LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCAL_FLAT_FILE_STORE))
#define IS_LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCAL_FLAT_FILE_STORE))
#define LOCAL_FLAT_FILE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))

typedef struct _LocalFlatFileStore LocalFlatFileStore;
typedef struct _LocalFlatFileStoreClass LocalFlatFileStoreClass;

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

struct _Password {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasswordPrivate * priv;
};

struct _PasswordClass {
	GTypeClass parent_class;
	void (*finalize) (Password *self);
};

struct _PasswordPrivate {
	const gchar* _password;
};

struct _ParamSpecPassword {
	GParamSpec parent_instance;
};

struct _PasswordHashTable {
	GObject parent_instance;
	PasswordHashTablePrivate * priv;
};

struct _PasswordHashTableClass {
	GObjectClass parent_class;
};

struct _PasswordHashTablePrivate {
	GHashTable* password_table;
};

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _IIdentityCardStoreIface {
	GTypeInterface parent_iface;
	void (*add_card) (IIdentityCardStore* self, IdCard* card);
	gboolean (*remove_card) (IIdentityCardStore* self, IdCard* card);
	IdCard* (*update_card) (IIdentityCardStore* self, IdCard* card);
	IIdentityCardStoreStoreType (*get_store_type) (IIdentityCardStore* self);
	GeeLinkedList* (*get_card_list) (IIdentityCardStore* self);
	void (*store_id_cards) (IIdentityCardStore* self);
};

struct _IdentityManagerModel {
	GObject parent_instance;
	IdentityManagerModelPrivate * priv;
};

struct _IdentityManagerModelClass {
	GObjectClass parent_class;
};

struct _IdentityManagerModelPrivate {
	PasswordHashTable* password_table;
	IIdentityCardStore* store;
	IdentityManagerApp* parent;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer password_parent_class = NULL;
static gpointer password_hash_table_parent_class = NULL;
static gpointer identity_manager_model_parent_class = NULL;
static MoonshotLogger* identity_manager_model_logger;
static MoonshotLogger* identity_manager_model_logger = NULL;

gpointer password_ref (gpointer instance);
void password_unref (gpointer instance);
GParamSpec* param_spec_password (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_password (GValue* value, gpointer v_object);
void value_take_password (GValue* value, gpointer v_object);
gpointer value_get_password (const GValue* value);
GType password_get_type (void) G_GNUC_CONST;
#define PASSWORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PASSWORD, PasswordPrivate))
enum  {
	PASSWORD_DUMMY_PROPERTY
};
void password_set_password (Password* self, const gchar* value);
Password* password_new (const gchar* in_password);
Password* password_construct (GType object_type, const gchar* in_password);
const gchar* password_get_password (Password* self);
static void password_finalize (Password* obj);
GType password_hash_table_get_type (void) G_GNUC_CONST;
#define PASSWORD_HASH_TABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PASSWORD_HASH_TABLE, PasswordHashTablePrivate))
enum  {
	PASSWORD_HASH_TABLE_DUMMY_PROPERTY
};
GType id_card_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_get_type (void) G_GNUC_CONST;
static gchar* password_hash_table_ComputeHashKey (IdCard* card, IIdentityCardStore* store);
const gchar* id_card_get_nai (IdCard* self);
IIdentityCardStoreStoreType iidentity_card_store_get_store_type (IIdentityCardStore* self);
void password_hash_table_CachePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store);
const gchar* id_card_get_password (IdCard* self);
void password_hash_table_RemovePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store);
void password_hash_table_RetrievePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store);
void id_card_set_password (IdCard* self, const gchar* value);
PasswordHashTable* password_hash_table_new (void);
PasswordHashTable* password_hash_table_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _password_unref0_ (gpointer var);
static void password_hash_table_finalize (GObject* obj);
GType identity_manager_model_get_type (void) G_GNUC_CONST;
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
#define IDENTITY_MANAGER_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelPrivate))
enum  {
	IDENTITY_MANAGER_MODEL_DUMMY_PROPERTY
};
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
#define IDENTITY_MANAGER_MODEL_FILE_NAME "identities.txt"
GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self);
GeeLinkedList* iidentity_card_store_get_card_list (IIdentityCardStore* self);
static gint __lambda4_ (IdentityManagerModel* self, IdCard* a, IdCard* b);
gboolean id_card_is_no_identity (IdCard* self);
const gchar* id_card_get_display_name (IdCard* self);
static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
IdCard* id_card_NewNoIdentity (void);
gboolean id_card_get_store_password (IdCard* self);
gboolean identity_manager_model_display_name_is_valid (IdentityManagerModel* self, const gchar* name, gchar** candidate);
static gboolean identity_manager_model_remove_duplicates (IdentityManagerModel* self, IdCard* new_card, GeeArrayList** old_duplicates);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
static gboolean identity_manager_model_remove_card_internal (IdentityManagerModel* self, IdCard* card);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
gint trust_anchor_Compare (TrustAnchor* self, TrustAnchor* other);
void trust_anchor_set_datetime_added (TrustAnchor* self, const gchar* datetime);
const gchar* trust_anchor_get_datetime_added (TrustAnchor* self);
gboolean identity_manager_model_find_duplicate_nai_sets (IdentityManagerModel* self, GeeArrayList** duplicates);
IdCard* identity_manager_model_find_id_card (IdentityManagerModel* self, const gchar* nai, gboolean force_flat_file_store);
IIdentityCardStoreStoreType identity_manager_model_get_store_type (IdentityManagerModel* self);
void identity_manager_model_set_store_type (IdentityManagerModel* self, IIdentityCardStoreStoreType type);
void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store, GeeArrayList** old_duplicates);
gboolean id_card_get_temporary (IdCard* self);
void id_card_set_display_name (IdCard* self, const gchar* value);
gchar* id_card_get_services_string (IdCard* self, const gchar* sep);
void iidentity_card_store_add_card (IIdentityCardStore* self, IdCard* card);
IdCard* identity_manager_model_update_card (IdentityManagerModel* self, IdCard* card);
IdCard* iidentity_card_store_update_card (IIdentityCardStore* self, IdCard* card);
gboolean iidentity_card_store_remove_card (IIdentityCardStore* self, IdCard* card);
gboolean identity_manager_model_remove_card (IdentityManagerModel* self, IdCard* card);
void moonshot_logger_warn (MoonshotLogger* self, const gchar* message, GError* e);
KeyringStore* keyring_store_new (void);
KeyringStore* keyring_store_construct (GType object_type);
GType keyring_store_get_type (void) G_GNUC_CONST;
LocalFlatFileStore* local_flat_file_store_new (void);
LocalFlatFileStore* local_flat_file_store_construct (GType object_type);
GType local_flat_file_store_get_type (void) G_GNUC_CONST;
gchar* trust_anchor_format_datetime_now (void);
gboolean trust_anchor_is_empty (TrustAnchor* self);
void iidentity_card_store_store_id_cards (IIdentityCardStore* self);
gboolean identity_manager_model_HasNonTrivialIdentities (IdentityManagerModel* self);
GeeArrayList* id_card_get_services (IdCard* self);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
IdentityManagerModel* identity_manager_model_new (IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
IdentityManagerModel* identity_manager_model_construct (GType object_type, IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
const gchar* iidentity_card_store_store_type_to_string (IIdentityCardStoreStoreType self);
static void identity_manager_model_finalize (GObject* obj);


Password* password_construct (GType object_type, const gchar* in_password) {
	Password* self = NULL;
	const gchar* _tmp0_ = NULL;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (in_password != NULL, NULL);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = (Password*) g_type_create_instance (object_type);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = in_password;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_set_password (self, _tmp0_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self;
#line 351 "moonshot-identities-manager.c"
}


Password* password_new (const gchar* in_password) {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return password_construct (TYPE_PASSWORD, in_password);
#line 358 "moonshot-identities-manager.c"
}


const gchar* password_get_password (Password* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->_password;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp0_;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 373 "moonshot-identities-manager.c"
}


void password_set_password (Password* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->_password;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp0_ != NULL) {
#line 386 "moonshot-identities-manager.c"
		const gchar* _tmp1_ = NULL;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp1_ = self->priv->_password;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		gnome_keyring_memory_free ((void*) _tmp1_);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		self->priv->_password = NULL;
#line 394 "moonshot-identities-manager.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = value;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp2_ != NULL) {
#line 400 "moonshot-identities-manager.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = value;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = gnome_keyring_memory_strdup (_tmp3_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		self->priv->_password = _tmp4_;
#line 409 "moonshot-identities-manager.c"
	}
}


static void value_password_init (GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	value->data[0].v_pointer = NULL;
#line 417 "moonshot-identities-manager.c"
}


static void value_password_free_value (GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (value->data[0].v_pointer) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_unref (value->data[0].v_pointer);
#line 426 "moonshot-identities-manager.c"
	}
}


static void value_password_copy_value (const GValue* src_value, GValue* dest_value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		dest_value->data[0].v_pointer = password_ref (src_value->data[0].v_pointer);
#line 436 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 440 "moonshot-identities-manager.c"
	}
}


static gpointer value_password_peek_pointer (const GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return value->data[0].v_pointer;
#line 448 "moonshot-identities-manager.c"
}


static gchar* value_password_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (collect_values[0].v_pointer) {
#line 455 "moonshot-identities-manager.c"
		Password* object;
		object = collect_values[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 462 "moonshot-identities-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 466 "moonshot-identities-manager.c"
		}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = password_ref (object);
#line 470 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = NULL;
#line 474 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return NULL;
#line 478 "moonshot-identities-manager.c"
}


static gchar* value_password_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Password** object_p;
	object_p = collect_values[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!object_p) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 489 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!value->data[0].v_pointer) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*object_p = NULL;
#line 495 "moonshot-identities-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 499 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*object_p = password_ref (value->data[0].v_pointer);
#line 503 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return NULL;
#line 507 "moonshot-identities-manager.c"
}


GParamSpec* param_spec_password (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPassword* spec;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PASSWORD), NULL);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return G_PARAM_SPEC (spec);
#line 521 "moonshot-identities-manager.c"
}


gpointer value_get_password (const GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD), NULL);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return value->data[0].v_pointer;
#line 530 "moonshot-identities-manager.c"
}


void value_set_password (GValue* value, gpointer v_object) {
	Password* old;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (v_object) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = v_object;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_ref (value->data[0].v_pointer);
#line 550 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = NULL;
#line 554 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (old) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_unref (old);
#line 560 "moonshot-identities-manager.c"
	}
}


void value_take_password (GValue* value, gpointer v_object) {
	Password* old;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (v_object) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = v_object;
#line 579 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = NULL;
#line 583 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (old) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_unref (old);
#line 589 "moonshot-identities-manager.c"
	}
}


static void password_class_init (PasswordClass * klass) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	((PasswordClass *) klass)->finalize = password_finalize;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_type_class_add_private (klass, sizeof (PasswordPrivate));
#line 601 "moonshot-identities-manager.c"
}


static void password_instance_init (Password * self) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv = PASSWORD_GET_PRIVATE (self);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->ref_count = 1;
#line 610 "moonshot-identities-manager.c"
}


static void password_finalize (Password* obj) {
	Password * self;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PASSWORD, Password);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_signal_handlers_destroy (self);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_set_password (self, NULL);
#line 622 "moonshot-identities-manager.c"
}


GType password_get_type (void) {
	static volatile gsize password_type_id__volatile = 0;
	if (g_once_init_enter (&password_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_password_init, value_password_free_value, value_password_copy_value, value_password_peek_pointer, "p", value_password_collect_value, "p", value_password_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PasswordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) password_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Password), 0, (GInstanceInitFunc) password_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType password_type_id;
		password_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Password", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&password_type_id__volatile, password_type_id);
	}
	return password_type_id__volatile;
}


gpointer password_ref (gpointer instance) {
	Password* self;
	self = instance;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return instance;
#line 647 "moonshot-identities-manager.c"
}


void password_unref (gpointer instance) {
	Password* self;
	self = instance;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		PASSWORD_GET_CLASS (self)->finalize (self);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 660 "moonshot-identities-manager.c"
	}
}


static gchar* password_hash_table_ComputeHashKey (IdCard* card, IIdentityCardStore* store) {
	gchar* result = NULL;
	IdCard* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IIdentityCardStore* _tmp3_ = NULL;
	IIdentityCardStoreStoreType _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (store != NULL, NULL);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = id_card_get_nai (_tmp0_);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = _tmp1_;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = store;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = iidentity_card_store_get_store_type (_tmp3_);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = g_strdup_printf ("%s_store_%d", _tmp2_, (gint) _tmp4_);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp5_;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 693 "moonshot-identities-manager.c"
}


void password_hash_table_CachePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store) {
	GHashTable* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IIdentityCardStore* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	IdCard* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	Password* _tmp7_ = NULL;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (store != NULL);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->password_table;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = card;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = store;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = password_hash_table_ComputeHashKey (_tmp1_, _tmp2_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = card;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = id_card_get_password (_tmp4_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = _tmp5_;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = password_new (_tmp6_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_hash_table_replace (_tmp0_, _tmp3_, _tmp7_);
#line 730 "moonshot-identities-manager.c"
}


void password_hash_table_RemovePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store) {
	GHashTable* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IIdentityCardStore* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (store != NULL);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->password_table;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = card;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = store;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = password_hash_table_ComputeHashKey (_tmp1_, _tmp2_);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = _tmp3_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_hash_table_remove (_tmp0_, _tmp4_);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp4_);
#line 760 "moonshot-identities-manager.c"
}


void password_hash_table_RetrievePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store) {
	Password* password = NULL;
	GHashTable* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IIdentityCardStore* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	Password* _tmp6_ = NULL;
	Password* _tmp7_ = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (store != NULL);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->password_table;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = card;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = store;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = password_hash_table_ComputeHashKey (_tmp1_, _tmp2_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = _tmp3_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = g_hash_table_lookup (_tmp0_, _tmp4_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = (Password*) _tmp5_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp4_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password = _tmp6_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = password;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp7_ != NULL) {
#line 802 "moonshot-identities-manager.c"
		IdCard* _tmp8_ = NULL;
		Password* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = card;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp9_ = password;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = password_get_password (_tmp9_);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = _tmp10_;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		id_card_set_password (_tmp8_, _tmp11_);
#line 817 "moonshot-identities-manager.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	var = (g_free (var), NULL);
#line 825 "moonshot-identities-manager.c"
}


static void _password_unref0_ (gpointer var) {
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	(var == NULL) ? NULL : (var = (password_unref (var), NULL));
#line 832 "moonshot-identities-manager.c"
}


PasswordHashTable* password_hash_table_construct (GType object_type) {
	PasswordHashTable * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = (PasswordHashTable*) g_object_new (object_type, NULL);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = g_str_hash;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = g_str_equal;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _password_unref0_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_hash_table_unref0 (self->priv->password_table);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv->password_table = _tmp2_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self;
#line 855 "moonshot-identities-manager.c"
}


PasswordHashTable* password_hash_table_new (void) {
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return password_hash_table_construct (TYPE_PASSWORD_HASH_TABLE);
#line 862 "moonshot-identities-manager.c"
}


static void password_hash_table_class_init (PasswordHashTableClass * klass) {
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_hash_table_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_type_class_add_private (klass, sizeof (PasswordHashTablePrivate));
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = password_hash_table_finalize;
#line 873 "moonshot-identities-manager.c"
}


static void password_hash_table_instance_init (PasswordHashTable * self) {
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv = PASSWORD_HASH_TABLE_GET_PRIVATE (self);
#line 880 "moonshot-identities-manager.c"
}


static void password_hash_table_finalize (GObject* obj) {
	PasswordHashTable * self;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PASSWORD_HASH_TABLE, PasswordHashTable);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_hash_table_unref0 (self->priv->password_table);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (password_hash_table_parent_class)->finalize (obj);
#line 892 "moonshot-identities-manager.c"
}


GType password_hash_table_get_type (void) {
	static volatile gsize password_hash_table_type_id__volatile = 0;
	if (g_once_init_enter (&password_hash_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasswordHashTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) password_hash_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasswordHashTable), 0, (GInstanceInitFunc) password_hash_table_instance_init, NULL };
		GType password_hash_table_type_id;
		password_hash_table_type_id = g_type_register_static (G_TYPE_OBJECT, "PasswordHashTable", &g_define_type_info, 0);
		g_once_init_leave (&password_hash_table_type_id__volatile, password_hash_table_type_id);
	}
	return password_hash_table_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 911 "moonshot-identities-manager.c"
}


static gint __lambda4_ (IdentityManagerModel* self, IdCard* a, IdCard* b) {
	gint result = 0;
	IdCard* id_a = NULL;
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IdCard* id_b = NULL;
	IdCard* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	IdCard* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GCompareFunc _tmp14_ = NULL;
	IdCard* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	IdCard* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = a;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ID_CARD, IdCard));
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	id_a = _tmp1_;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = b;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_ID_CARD, IdCard));
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	id_b = _tmp3_;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = id_a;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = id_card_is_no_identity (_tmp5_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp6_) {
#line 956 "moonshot-identities-manager.c"
		IdCard* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp7_ = id_b;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = id_card_is_no_identity (_tmp7_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = !_tmp8_;
#line 965 "moonshot-identities-manager.c"
	} else {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = FALSE;
#line 969 "moonshot-identities-manager.c"
	}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp4_) {
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = -1;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (id_b);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (id_a);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 981 "moonshot-identities-manager.c"
	} else {
		gboolean _tmp9_ = FALSE;
		IdCard* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = id_b;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = id_card_is_no_identity (_tmp10_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (_tmp11_) {
#line 992 "moonshot-identities-manager.c"
			IdCard* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = id_a;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = id_card_is_no_identity (_tmp12_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = !_tmp13_;
#line 1001 "moonshot-identities-manager.c"
		} else {
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = FALSE;
#line 1005 "moonshot-identities-manager.c"
		}
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (_tmp9_) {
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			result = 1;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_b);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_a);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			return result;
#line 1017 "moonshot-identities-manager.c"
		}
	}
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp14_ = g_strcmp0;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp15_ = id_a;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp16_ = id_card_get_display_name (_tmp15_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp17_ = _tmp16_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp18_ = id_b;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp19_ = id_card_get_display_name (_tmp18_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp20_ = _tmp19_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp21_ = _tmp14_ (_tmp17_, _tmp20_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp21_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (id_b);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (id_a);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1044 "moonshot-identities-manager.c"
}


static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda4_ ((IdentityManagerModel*) self, (IdCard*) a, (IdCard*) b);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1053 "moonshot-identities-manager.c"
}


GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self) {
	GeeLinkedList* result = NULL;
	GeeLinkedList* identities = NULL;
	IIdentityCardStore* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeLinkedList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->store;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = iidentity_card_store_get_card_list (_tmp0_);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identities = _tmp1_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = identities;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	gee_list_sort ((GeeList*) _tmp2_, ___lambda4__gcompare_data_func, g_object_ref (self), g_object_unref);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = identities;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = gee_collection_get_is_empty ((GeeCollection*) _tmp4_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = _tmp5_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp6_) {
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = TRUE;
#line 1089 "moonshot-identities-manager.c"
	} else {
		GeeLinkedList* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		IdCard* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp7_ = identities;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp9_ = (IdCard*) _tmp8_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = id_card_is_no_identity (_tmp9_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = !_tmp10_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_tmp9_);
#line 1107 "moonshot-identities-manager.c"
	}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp3_) {
#line 1111 "moonshot-identities-manager.c"
		GeeLinkedList* _tmp11_ = NULL;
		IdCard* _tmp12_ = NULL;
		IdCard* _tmp13_ = NULL;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = identities;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp12_ = id_card_NewNoIdentity ();
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp13_ = _tmp12_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		gee_abstract_list_insert ((GeeAbstractList*) _tmp11_, 0, _tmp13_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_tmp13_);
#line 1125 "moonshot-identities-manager.c"
	}
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp14_ = NULL;
		GeeLinkedList* _tmp15_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _id_card_index = 0;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp14_ = identities;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_list = _tmp15_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp16_ = _id_card_list;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp18_ = _tmp17_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_size = _tmp18_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_index = -1;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1154 "moonshot-identities-manager.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			IdCard* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp19_ = _id_card_index;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_card_index = _tmp19_ + 1;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp20_ = _id_card_index;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp21_ = _id_card_size;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp20_ < _tmp21_)) {
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1177 "moonshot-identities-manager.c"
			}
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp22_ = _id_card_list;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp23_ = _id_card_index;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _tmp23_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id_card = (IdCard*) _tmp24_;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp25_ = id_card;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp26_ = id_card_get_store_password (_tmp25_);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp27_ = _tmp26_;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!_tmp27_) {
#line 1195 "moonshot-identities-manager.c"
				PasswordHashTable* _tmp28_ = NULL;
				IdCard* _tmp29_ = NULL;
				IIdentityCardStore* _tmp30_ = NULL;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp28_ = self->priv->password_table;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp29_ = id_card;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp30_ = self->priv->store;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				password_hash_table_RetrievePassword (_tmp28_, _tmp29_, _tmp30_);
#line 1207 "moonshot-identities-manager.c"
			}
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_card);
#line 1211 "moonshot-identities-manager.c"
		}
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_card_list);
#line 1215 "moonshot-identities-manager.c"
	}
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = identities;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1221 "moonshot-identities-manager.c"
}


gboolean identity_manager_model_display_name_is_valid (IdentityManagerModel* self, const gchar* name, gchar** candidate) {
	gchar* _vala_candidate = NULL;
	gboolean result = FALSE;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if ((&_vala_candidate) != NULL) {
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_free0 (_vala_candidate);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_vala_candidate = NULL;
#line 1238 "moonshot-identities-manager.c"
	}
	{
		GeeLinkedList* _id_card_list = NULL;
		IIdentityCardStore* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _id_card_index = 0;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = self->priv->store;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp1_ = iidentity_card_store_get_card_list (_tmp0_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_list = _tmp1_;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = _id_card_list;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = _tmp3_;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_size = _tmp4_;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_index = -1;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1267 "moonshot-identities-manager.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			IdCard* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp5_ = _id_card_index;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_card_index = _tmp5_ + 1;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = _id_card_index;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = _id_card_size;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1291 "moonshot-identities-manager.c"
			}
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp8_ = _id_card_list;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = _id_card_index;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id_card = (IdCard*) _tmp10_;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp11_ = id_card;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = id_card_get_display_name (_tmp11_);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = _tmp12_;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp14_ = name;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				if ((&_vala_candidate) != NULL) {
#line 1313 "moonshot-identities-manager.c"
					{
						gint i = 0;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						i = 0;
#line 1318 "moonshot-identities-manager.c"
						{
							gboolean _tmp15_ = FALSE;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
							_tmp15_ = TRUE;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
							while (TRUE) {
#line 1325 "moonshot-identities-manager.c"
								gint _tmp17_ = 0;
								gchar* tmp = NULL;
								const gchar* _tmp18_ = NULL;
								gint _tmp19_ = 0;
								gchar* _tmp20_ = NULL;
								const gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								if (!_tmp15_) {
#line 1335 "moonshot-identities-manager.c"
									gint _tmp16_ = 0;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_tmp16_ = i;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									i = _tmp16_ + 1;
#line 1341 "moonshot-identities-manager.c"
								}
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp15_ = FALSE;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp17_ = i;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								if (!(_tmp17_ < 1000)) {
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									break;
#line 1351 "moonshot-identities-manager.c"
								}
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp18_ = name;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp19_ = i;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp20_ = g_strdup_printf ("%s %d", _tmp18_, _tmp19_);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								tmp = _tmp20_;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp21_ = tmp;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp22_ = identity_manager_model_display_name_is_valid (self, _tmp21_, NULL);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								if (_tmp22_) {
#line 1367 "moonshot-identities-manager.c"
									const gchar* _tmp23_ = NULL;
									gchar* _tmp24_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_tmp23_ = tmp;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_tmp24_ = g_strdup (_tmp23_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_g_free0 (_vala_candidate);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_vala_candidate = _tmp24_;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_g_free0 (tmp);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									break;
#line 1382 "moonshot-identities-manager.c"
								}
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_g_free0 (tmp);
#line 1386 "moonshot-identities-manager.c"
							}
						}
					}
				}
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				result = FALSE;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (id_card);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (_id_card_list);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				if (candidate) {
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					*candidate = _vala_candidate;
#line 1401 "moonshot-identities-manager.c"
				} else {
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_g_free0 (_vala_candidate);
#line 1405 "moonshot-identities-manager.c"
				}
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				return result;
#line 1409 "moonshot-identities-manager.c"
			}
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_card);
#line 1413 "moonshot-identities-manager.c"
		}
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_card_list);
#line 1417 "moonshot-identities-manager.c"
	}
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = TRUE;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (candidate) {
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*candidate = _vala_candidate;
#line 1425 "moonshot-identities-manager.c"
	} else {
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_free0 (_vala_candidate);
#line 1429 "moonshot-identities-manager.c"
	}
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1433 "moonshot-identities-manager.c"
}


static gboolean identity_manager_model_remove_duplicates (IdentityManagerModel* self, IdCard* new_card, GeeArrayList** old_duplicates) {
	GeeArrayList* _vala_old_duplicates = NULL;
	gboolean result = FALSE;
	GeeArrayList* dups = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeLinkedList* cards = NULL;
	IIdentityCardStore* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	GeeArrayList* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (new_card != NULL, FALSE);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = gee_array_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	dups = _tmp0_;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = self->priv->store;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = iidentity_card_store_get_card_list (_tmp1_);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	cards = _tmp2_;
#line 1462 "moonshot-identities-manager.c"
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _id_card_index = 0;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = cards;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_list = _tmp4_;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp5_ = _id_card_list;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp7_ = _tmp6_;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_size = _tmp7_;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_index = -1;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1490 "moonshot-identities-manager.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			IdCard* _tmp15_ = NULL;
			IdCard* _tmp16_ = NULL;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp8_ = _id_card_index;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_card_index = _tmp8_ + 1;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = _id_card_index;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = _id_card_size;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1513 "moonshot-identities-manager.c"
			}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp11_ = _id_card_list;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = _id_card_index;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id_card = (IdCard*) _tmp13_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp15_ = new_card;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp16_ = id_card;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp15_ != _tmp16_) {
#line 1529 "moonshot-identities-manager.c"
				IdCard* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				IdCard* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp17_ = id_card;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp18_ = id_card_get_nai (_tmp17_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp19_ = _tmp18_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp20_ = new_card;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp21_ = id_card_get_nai (_tmp20_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp22_ = _tmp21_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp14_ = g_strcmp0 (_tmp19_, _tmp22_) == 0;
#line 1550 "moonshot-identities-manager.c"
			} else {
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp14_ = FALSE;
#line 1554 "moonshot-identities-manager.c"
			}
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp14_) {
#line 1558 "moonshot-identities-manager.c"
				GeeArrayList* _tmp23_ = NULL;
				IdCard* _tmp24_ = NULL;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp23_ = dups;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp24_ = id_card;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
#line 1567 "moonshot-identities-manager.c"
			}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_card);
#line 1571 "moonshot-identities-manager.c"
		}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_card_list);
#line 1575 "moonshot-identities-manager.c"
	}
	{
		GeeArrayList* _id_card_list = NULL;
		GeeArrayList* _tmp25_ = NULL;
		GeeArrayList* _tmp26_ = NULL;
		gint _id_card_size = 0;
		GeeArrayList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _id_card_index = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp25_ = dups;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp26_ = _g_object_ref0 (_tmp25_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_list = _tmp26_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp27_ = _id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp29_ = _tmp28_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_size = _tmp29_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_index = -1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1604 "moonshot-identities-manager.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			IdCard* id_card = NULL;
			GeeArrayList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gpointer _tmp35_ = NULL;
			MoonshotLogger* _tmp36_ = NULL;
			IdCard* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			IdCard* _tmp42_ = NULL;
			IdCard* _tmp43_ = NULL;
			TrustAnchor* _tmp44_ = NULL;
			TrustAnchor* _tmp45_ = NULL;
			IdCard* _tmp46_ = NULL;
			TrustAnchor* _tmp47_ = NULL;
			TrustAnchor* _tmp48_ = NULL;
			gint _tmp49_ = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp30_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_card_index = _tmp30_ + 1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp31_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp32_ = _id_card_size;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp31_ < _tmp32_)) {
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1638 "moonshot-identities-manager.c"
			}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp33_ = _id_card_list;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp34_ = _id_card_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id_card = (IdCard*) _tmp35_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp36_ = identity_manager_model_logger;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp37_ = new_card;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp38_ = id_card_get_nai (_tmp37_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp39_ = _tmp38_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp40_ = g_strdup_printf ("removing duplicate id for '%s'\n", _tmp39_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp41_ = _tmp40_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			moonshot_logger_trace (_tmp36_, _tmp41_, NULL);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_free0 (_tmp41_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp42_ = id_card;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			identity_manager_model_remove_card_internal (self, _tmp42_);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp43_ = new_card;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp44_ = id_card_get_trust_anchor (_tmp43_);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp45_ = _tmp44_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp46_ = id_card;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp47_ = id_card_get_trust_anchor (_tmp46_);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp48_ = _tmp47_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp49_ = trust_anchor_Compare (_tmp45_, _tmp48_);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp49_ == 0) {
#line 1684 "moonshot-identities-manager.c"
				MoonshotLogger* _tmp50_ = NULL;
				IdCard* _tmp51_ = NULL;
				TrustAnchor* _tmp52_ = NULL;
				TrustAnchor* _tmp53_ = NULL;
				IdCard* _tmp54_ = NULL;
				TrustAnchor* _tmp55_ = NULL;
				TrustAnchor* _tmp56_ = NULL;
				const gchar* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp50_ = identity_manager_model_logger;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				moonshot_logger_trace (_tmp50_, "Old and new cards have same trust anchor. Re-using the datetime_added " \
"field from the old card.", NULL);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp51_ = new_card;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp52_ = id_card_get_trust_anchor (_tmp51_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp53_ = _tmp52_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp54_ = id_card;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp55_ = id_card_get_trust_anchor (_tmp54_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp56_ = _tmp55_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp57_ = trust_anchor_get_datetime_added (_tmp56_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp58_ = _tmp57_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				trust_anchor_set_datetime_added (_tmp53_, _tmp58_);
#line 1716 "moonshot-identities-manager.c"
			}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_card);
#line 1720 "moonshot-identities-manager.c"
		}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_card_list);
#line 1724 "moonshot-identities-manager.c"
	}
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if ((&_vala_old_duplicates) != NULL) {
#line 1728 "moonshot-identities-manager.c"
		GeeArrayList* _tmp59_ = NULL;
		GeeArrayList* _tmp60_ = NULL;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp59_ = dups;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp60_ = _g_object_ref0 (_tmp59_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_vala_old_duplicates = _tmp60_;
#line 1739 "moonshot-identities-manager.c"
	}
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp61_ = dups;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp62_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp61_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp63_ = _tmp62_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp63_ > 0;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (cards);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (dups);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (old_duplicates) {
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*old_duplicates = _vala_old_duplicates;
#line 1757 "moonshot-identities-manager.c"
	} else {
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 1761 "moonshot-identities-manager.c"
	}
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1765 "moonshot-identities-manager.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1777 "moonshot-identities-manager.c"
}


gboolean identity_manager_model_find_duplicate_nai_sets (IdentityManagerModel* self, GeeArrayList** duplicates) {
	GeeArrayList* _vala_duplicates = NULL;
	gboolean result = FALSE;
	GeeHashMap* nais = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeLinkedList* card_list = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_ = NULL;
	gboolean found = FALSE;
	GeeArrayList* _tmp46_ = NULL;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	nais = _tmp0_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (_vala_duplicates);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_vala_duplicates = _tmp1_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = identity_manager_model_get_card_list (self);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	card_list = _tmp2_;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = card_list;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp3_ == NULL) {
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = FALSE;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (card_list);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (nais);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (duplicates) {
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			*duplicates = _vala_duplicates;
#line 1822 "moonshot-identities-manager.c"
		} else {
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (_vala_duplicates);
#line 1826 "moonshot-identities-manager.c"
		}
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 1830 "moonshot-identities-manager.c"
	}
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	found = FALSE;
#line 1834 "moonshot-identities-manager.c"
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _id_card_index = 0;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = card_list;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_list = _tmp5_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp6_ = _id_card_list;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = _tmp7_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_size = _tmp8_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_index = -1;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1862 "moonshot-identities-manager.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			MoonshotLogger* _tmp15_ = NULL;
			IdCard* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			IdCard* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			GeeHashMap* _tmp26_ = NULL;
			IdCard* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = _id_card_index;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_card_index = _tmp9_ + 1;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = _id_card_index;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp11_ = _id_card_size;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1898 "moonshot-identities-manager.c"
			}
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = _id_card_list;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = _id_card_index;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id_card = (IdCard*) _tmp14_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp15_ = identity_manager_model_logger;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp16_ = id_card;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp17_ = id_card_get_display_name (_tmp16_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp18_ = _tmp17_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp19_ = string_to_string (_tmp18_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp20_ = id_card;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp21_ = id_card_get_nai (_tmp20_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp22_ = _tmp21_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp23_ = string_to_string (_tmp22_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp24_ = g_strconcat ("load_id_cards: Loading card with display name '", _tmp19_, "' and nai '", _tmp23_, "'", NULL);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp25_ = _tmp24_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			moonshot_logger_trace (_tmp15_, _tmp25_, NULL);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_free0 (_tmp25_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp26_ = nais;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp27_ = id_card;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp28_ = id_card_get_nai (_tmp27_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp29_ = _tmp28_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp30_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp26_, _tmp29_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp30_) {
#line 1946 "moonshot-identities-manager.c"
				GeeArrayList* list = NULL;
				GeeHashMap* _tmp31_ = NULL;
				IdCard* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				gpointer _tmp35_ = NULL;
				GeeArrayList* _tmp36_ = NULL;
				IdCard* _tmp37_ = NULL;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp31_ = nais;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp32_ = id_card;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp33_ = id_card_get_nai (_tmp32_);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp34_ = _tmp33_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp31_, _tmp34_);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				list = (GeeArrayList*) _tmp35_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp36_ = list;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp37_ = id_card;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp37_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (list);
#line 1975 "moonshot-identities-manager.c"
			} else {
				GeeArrayList* list = NULL;
				GeeArrayList* _tmp38_ = NULL;
				GeeArrayList* _tmp39_ = NULL;
				IdCard* _tmp40_ = NULL;
				GeeHashMap* _tmp41_ = NULL;
				IdCard* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				GeeArrayList* _tmp45_ = NULL;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp38_ = gee_array_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				list = _tmp38_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp39_ = list;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp40_ = id_card;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp41_ = nais;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp42_ = id_card;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp43_ = id_card_get_nai (_tmp42_);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp44_ = _tmp43_;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp45_ = list;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, _tmp44_, _tmp45_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (list);
#line 2010 "moonshot-identities-manager.c"
			}
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_card);
#line 2014 "moonshot-identities-manager.c"
		}
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_card_list);
#line 2018 "moonshot-identities-manager.c"
	}
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp46_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (_vala_duplicates);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_vala_duplicates = _tmp46_;
#line 2026 "moonshot-identities-manager.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp47_ = NULL;
		GeeSet* _tmp48_ = NULL;
		GeeSet* _tmp49_ = NULL;
		GeeSet* _tmp50_ = NULL;
		GeeIterator* _tmp51_ = NULL;
		GeeIterator* _tmp52_ = NULL;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp47_ = nais;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp48_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp47_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp49_ = _tmp48_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp50_ = _tmp49_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp52_ = _tmp51_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_tmp50_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_entry_it = _tmp52_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 2053 "moonshot-identities-manager.c"
			GeeIterator* _tmp53_ = NULL;
			gboolean _tmp54_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp55_ = NULL;
			gpointer _tmp56_ = NULL;
			GeeArrayList* list = NULL;
			GeeMapEntry* _tmp57_ = NULL;
			gconstpointer _tmp58_ = NULL;
			GeeArrayList* _tmp59_ = NULL;
			GeeArrayList* _tmp60_ = NULL;
			GeeArrayList* _tmp61_ = NULL;
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp53_ = _entry_it;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp54_ = gee_iterator_next (_tmp53_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!_tmp54_) {
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 2075 "moonshot-identities-manager.c"
			}
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp55_ = _entry_it;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp56_ = gee_iterator_get (_tmp55_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			entry = (GeeMapEntry*) _tmp56_;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp57_ = entry;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp58_ = gee_map_entry_get_value (_tmp57_);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp59_ = _tmp58_;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp60_ = _g_object_ref0 ((GeeArrayList*) _tmp59_);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			list = _tmp60_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp61_ = list;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp62_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp61_);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp63_ = _tmp62_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp63_ > 1) {
#line 2101 "moonshot-identities-manager.c"
				GeeArrayList* _tmp64_ = NULL;
				GeeArrayList* _tmp65_ = NULL;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp64_ = _vala_duplicates;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp65_ = list;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, _tmp65_);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				found = TRUE;
#line 2112 "moonshot-identities-manager.c"
			}
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (list);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (entry);
#line 2118 "moonshot-identities-manager.c"
		}
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_entry_it);
#line 2122 "moonshot-identities-manager.c"
	}
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = found;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (card_list);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (nais);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (duplicates) {
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*duplicates = _vala_duplicates;
#line 2134 "moonshot-identities-manager.c"
	} else {
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_vala_duplicates);
#line 2138 "moonshot-identities-manager.c"
	}
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2142 "moonshot-identities-manager.c"
}


IdCard* identity_manager_model_find_id_card (IdentityManagerModel* self, const gchar* nai, gboolean force_flat_file_store) {
	IdCard* result = NULL;
	IdCard* retval = NULL;
	IIdentityCardStoreStoreType saved_store_type = 0;
	IIdentityCardStoreStoreType _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	IIdentityCardStoreStoreType _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	retval = NULL;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = identity_manager_model_get_store_type (self);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	saved_store_type = _tmp0_;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = force_flat_file_store;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp1_) {
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		identity_manager_model_set_store_type (self, IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE);
#line 2169 "moonshot-identities-manager.c"
	}
	{
		GeeLinkedList* _id_list = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _id_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _id_index = 0;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = identity_manager_model_get_card_list (self);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_list = _tmp2_;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = _id_list;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp5_ = _tmp4_;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_size = _tmp5_;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_index = -1;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 2195 "moonshot-identities-manager.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			IdCard* id = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			IdCard* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = _id_index;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_index = _tmp6_ + 1;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = _id_index;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp8_ = _id_size;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 2219 "moonshot-identities-manager.c"
			}
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = _id_list;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = _id_index;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id = (IdCard*) _tmp11_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = id;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = id_card_get_nai (_tmp12_);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp14_ = _tmp13_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp15_ = nai;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
#line 2239 "moonshot-identities-manager.c"
				IdCard* _tmp16_ = NULL;
				IdCard* _tmp17_ = NULL;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp16_ = id;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp17_ = _g_object_ref0 (_tmp16_);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (retval);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				retval = _tmp17_;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (id);
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 2254 "moonshot-identities-manager.c"
			}
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id);
#line 2258 "moonshot-identities-manager.c"
		}
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_list);
#line 2262 "moonshot-identities-manager.c"
	}
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp18_ = saved_store_type;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_set_store_type (self, _tmp18_);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp20_ = force_flat_file_store;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp20_) {
#line 2272 "moonshot-identities-manager.c"
		IIdentityCardStoreStoreType _tmp21_ = 0;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp21_ = saved_store_type;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp19_ = _tmp21_ != IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE;
#line 2278 "moonshot-identities-manager.c"
	} else {
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp19_ = FALSE;
#line 2282 "moonshot-identities-manager.c"
	}
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp19_) {
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_signal_emit_by_name (self, "card-list-changed");
#line 2288 "moonshot-identities-manager.c"
	}
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = retval;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2294 "moonshot-identities-manager.c"
}


void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store, GeeArrayList** old_duplicates) {
	GeeArrayList* _vala_old_duplicates = NULL;
	IdCard* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* candidate = NULL;
	IIdentityCardStoreStoreType saved_store_type = 0;
	IIdentityCardStoreStoreType _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	IdCard* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	IdCard* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	IdCard* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	MoonshotLogger* _tmp21_ = NULL;
	IdCard* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	IdCard* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	IIdentityCardStore* _tmp30_ = NULL;
	IdCard* _tmp31_ = NULL;
	IIdentityCardStoreStoreType _tmp32_ = 0;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = id_card_get_temporary (_tmp0_);
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = _tmp1_;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp2_) {
#line 2341 "moonshot-identities-manager.c"
		MoonshotLogger* _tmp3_ = NULL;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = identity_manager_model_logger;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		moonshot_logger_trace (_tmp3_, "add_card: card is temporary; returning.", NULL);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (old_duplicates) {
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			*old_duplicates = _vala_old_duplicates;
#line 2351 "moonshot-identities-manager.c"
		} else {
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (_vala_old_duplicates);
#line 2355 "moonshot-identities-manager.c"
		}
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return;
#line 2359 "moonshot-identities-manager.c"
	}
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = identity_manager_model_get_store_type (self);
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	saved_store_type = _tmp4_;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = force_flat_file_store;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp5_) {
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		identity_manager_model_set_store_type (self, IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE);
#line 2371 "moonshot-identities-manager.c"
	}
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = card;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_remove_duplicates (self, _tmp6_, &_tmp7_);
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (_vala_old_duplicates);
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_vala_old_duplicates = _tmp7_;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp8_ = card;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp9_ = id_card_get_display_name (_tmp8_);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp10_ = _tmp9_;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp12_ = identity_manager_model_display_name_is_valid (self, _tmp10_, &_tmp11_);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (candidate);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	candidate = _tmp11_;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!_tmp12_) {
#line 2395 "moonshot-identities-manager.c"
		IdCard* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp13_ = card;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp14_ = candidate;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		id_card_set_display_name (_tmp13_, _tmp14_);
#line 2404 "moonshot-identities-manager.c"
	}
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp15_ = card;
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp16_ = id_card_get_store_password (_tmp15_);
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp17_ = _tmp16_;
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!_tmp17_) {
#line 2414 "moonshot-identities-manager.c"
		PasswordHashTable* _tmp18_ = NULL;
		IdCard* _tmp19_ = NULL;
		IIdentityCardStore* _tmp20_ = NULL;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp18_ = self->priv->password_table;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp19_ = card;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp20_ = self->priv->store;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_hash_table_CachePassword (_tmp18_, _tmp19_, _tmp20_);
#line 2426 "moonshot-identities-manager.c"
	}
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp21_ = identity_manager_model_logger;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp22_ = card;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp23_ = id_card_get_display_name (_tmp22_);
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp24_ = _tmp23_;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp25_ = card;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp26_ = id_card_get_services_string (_tmp25_, "; ");
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp27_ = _tmp26_;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp28_ = g_strdup_printf ("add_card: Adding card '%s' with services: '%s'", _tmp24_, _tmp27_);
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp29_ = _tmp28_;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	moonshot_logger_trace (_tmp21_, _tmp29_, NULL);
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp29_);
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp27_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp30_ = self->priv->store;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp31_ = card;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	iidentity_card_store_add_card (_tmp30_, _tmp31_);
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp32_ = saved_store_type;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_set_store_type (self, _tmp32_);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_signal_emit_by_name (self, "card-list-changed");
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (candidate);
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (old_duplicates) {
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*old_duplicates = _vala_old_duplicates;
#line 2470 "moonshot-identities-manager.c"
	} else {
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 2474 "moonshot-identities-manager.c"
	}
}


IdCard* identity_manager_model_update_card (IdentityManagerModel* self, IdCard* card) {
	IdCard* result = NULL;
	MoonshotLogger* _tmp0_ = NULL;
	IdCard* retval = NULL;
	IdCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	IdCard* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	IIdentityCardStore* _tmp15_ = NULL;
	IdCard* _tmp16_ = NULL;
	IdCard* _tmp17_ = NULL;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = identity_manager_model_logger;
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	moonshot_logger_trace (_tmp0_, "update_card", NULL);
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = card;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = id_card_get_temporary (_tmp1_);
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = _tmp2_;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp3_) {
#line 2508 "moonshot-identities-manager.c"
		IdCard* _tmp4_ = NULL;
		IdCard* _tmp5_ = NULL;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = card;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (retval);
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		retval = _tmp5_;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = retval;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 2523 "moonshot-identities-manager.c"
	}
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = card;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = id_card_get_store_password (_tmp6_);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp8_ = _tmp7_;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!_tmp8_) {
#line 2533 "moonshot-identities-manager.c"
		PasswordHashTable* _tmp9_ = NULL;
		IdCard* _tmp10_ = NULL;
		IIdentityCardStore* _tmp11_ = NULL;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp9_ = self->priv->password_table;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = card;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = self->priv->store;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_hash_table_CachePassword (_tmp9_, _tmp10_, _tmp11_);
#line 2545 "moonshot-identities-manager.c"
	} else {
		PasswordHashTable* _tmp12_ = NULL;
		IdCard* _tmp13_ = NULL;
		IIdentityCardStore* _tmp14_ = NULL;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp12_ = self->priv->password_table;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp13_ = card;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp14_ = self->priv->store;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_hash_table_RemovePassword (_tmp12_, _tmp13_, _tmp14_);
#line 2558 "moonshot-identities-manager.c"
	}
#line 275 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp15_ = self->priv->store;
#line 275 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp16_ = card;
#line 275 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp17_ = iidentity_card_store_update_card (_tmp15_, _tmp16_);
#line 275 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (retval);
#line 275 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	retval = _tmp17_;
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_signal_emit_by_name (self, "card-list-changed");
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = retval;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2576 "moonshot-identities-manager.c"
}


static gboolean identity_manager_model_remove_card_internal (IdentityManagerModel* self, IdCard* card) {
	gboolean result = FALSE;
	IdCard* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PasswordHashTable* _tmp3_ = NULL;
	IdCard* _tmp4_ = NULL;
	IIdentityCardStore* _tmp5_ = NULL;
	IIdentityCardStore* _tmp6_ = NULL;
	IdCard* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = id_card_get_temporary (_tmp0_);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = _tmp1_;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp2_) {
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = FALSE;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 2607 "moonshot-identities-manager.c"
	}
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = self->priv->password_table;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = card;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = self->priv->store;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_hash_table_RemovePassword (_tmp3_, _tmp4_, _tmp5_);
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = self->priv->store;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = card;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp8_ = iidentity_card_store_remove_card (_tmp6_, _tmp7_);
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp8_;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2627 "moonshot-identities-manager.c"
}


gboolean identity_manager_model_remove_card (IdentityManagerModel* self, IdCard* card) {
	gboolean result = FALSE;
	IdCard* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	MoonshotLogger* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = identity_manager_model_remove_card_internal (self, _tmp0_);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp1_) {
#line 2652 "moonshot-identities-manager.c"
		MoonshotLogger* _tmp2_ = NULL;
		IdCard* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = identity_manager_model_logger;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = card;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = id_card_get_display_name (_tmp3_);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp5_ = _tmp4_;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp6_ = string_to_string (_tmp5_);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp7_ = g_strconcat ("remove_card: Removed '", _tmp6_, "'", NULL);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = _tmp7_;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		moonshot_logger_trace (_tmp2_, _tmp8_, NULL);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_free0 (_tmp8_);
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_signal_emit_by_name (self, "card-list-changed");
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = TRUE;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 2684 "moonshot-identities-manager.c"
	}
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp9_ = identity_manager_model_logger;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp10_ = card;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp11_ = id_card_get_display_name (_tmp10_);
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp12_ = _tmp11_;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp13_ = string_to_string (_tmp12_);
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp14_ = g_strconcat ("remove_card: Couldn't remove '", _tmp13_, "'", NULL);
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp15_ = _tmp14_;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	moonshot_logger_warn (_tmp9_, _tmp15_, NULL);
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp15_);
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = FALSE;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2708 "moonshot-identities-manager.c"
}


void identity_manager_model_set_store_type (IdentityManagerModel* self, IIdentityCardStoreStoreType type) {
	gboolean _tmp0_ = FALSE;
	IIdentityCardStore* _tmp1_ = NULL;
	IIdentityCardStoreStoreType _tmp5_ = 0;
	gchar* before_now = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gboolean save_needed = FALSE;
	gboolean _tmp45_ = FALSE;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = self->priv->store;
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp1_ != NULL) {
#line 2730 "moonshot-identities-manager.c"
		IIdentityCardStore* _tmp2_ = NULL;
		IIdentityCardStoreStoreType _tmp3_ = 0;
		IIdentityCardStoreStoreType _tmp4_ = 0;
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = self->priv->store;
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = iidentity_card_store_get_store_type (_tmp2_);
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = type;
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 2742 "moonshot-identities-manager.c"
	} else {
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = FALSE;
#line 2746 "moonshot-identities-manager.c"
	}
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp0_) {
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return;
#line 2752 "moonshot-identities-manager.c"
	}
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = type;
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	switch (_tmp5_) {
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		case IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING:
#line 2760 "moonshot-identities-manager.c"
		{
			KeyringStore* _tmp6_ = NULL;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = keyring_store_new ();
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (self->priv->store);
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			self->priv->store = (IIdentityCardStore*) _tmp6_;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			break;
#line 2771 "moonshot-identities-manager.c"
		}
		default:
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		case IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE:
#line 2776 "moonshot-identities-manager.c"
		{
			LocalFlatFileStore* _tmp7_ = NULL;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = local_flat_file_store_new ();
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (self->priv->store);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			self->priv->store = (IIdentityCardStore*) _tmp7_;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			break;
#line 2787 "moonshot-identities-manager.c"
		}
	}
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp8_ = _ ("Before ");
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp9_ = trust_anchor_format_datetime_now ();
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp10_ = _tmp9_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp12_ = _tmp11_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp10_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	before_now = _tmp12_;
#line 317 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	save_needed = FALSE;
#line 2806 "moonshot-identities-manager.c"
	{
		GeeLinkedList* _id_list = NULL;
		IIdentityCardStore* _tmp13_ = NULL;
		GeeLinkedList* _tmp14_ = NULL;
		gint _id_size = 0;
		GeeLinkedList* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _id_index = 0;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp13_ = self->priv->store;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp14_ = iidentity_card_store_get_card_list (_tmp13_);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_list = _tmp14_;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp15_ = _id_list;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp17_ = _tmp16_;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_size = _tmp17_;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_index = -1;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 2834 "moonshot-identities-manager.c"
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			IdCard* id = NULL;
			GeeLinkedList* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gpointer _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			IdCard* _tmp25_ = NULL;
			TrustAnchor* _tmp26_ = NULL;
			TrustAnchor* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp18_ = _id_index;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_index = _tmp18_ + 1;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp19_ = _id_index;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp20_ = _id_size;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp19_ < _tmp20_)) {
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 2859 "moonshot-identities-manager.c"
			}
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp21_ = _id_list;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp22_ = _id_index;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp22_);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id = (IdCard*) _tmp23_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp25_ = id;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp26_ = id_card_get_trust_anchor (_tmp25_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp27_ = _tmp26_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp28_ = trust_anchor_is_empty (_tmp27_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!_tmp28_) {
#line 2879 "moonshot-identities-manager.c"
				IdCard* _tmp29_ = NULL;
				TrustAnchor* _tmp30_ = NULL;
				TrustAnchor* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp29_ = id;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp30_ = id_card_get_trust_anchor (_tmp29_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp31_ = _tmp30_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp32_ = trust_anchor_get_datetime_added (_tmp31_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp33_ = _tmp32_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp24_ = g_strcmp0 (_tmp33_, "") == 0;
#line 2897 "moonshot-identities-manager.c"
			} else {
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp24_ = FALSE;
#line 2901 "moonshot-identities-manager.c"
			}
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp24_) {
#line 2905 "moonshot-identities-manager.c"
				MoonshotLogger* _tmp34_ = NULL;
				IdCard* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				IdCard* _tmp41_ = NULL;
				TrustAnchor* _tmp42_ = NULL;
				TrustAnchor* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp34_ = identity_manager_model_logger;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp35_ = id;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp36_ = id_card_get_display_name (_tmp35_);
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp37_ = _tmp36_;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp38_ = before_now;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp39_ = g_strdup_printf ("set_store_type : Set ta_datetime_added for old trust anchor on '%s' to" \
" '%s'", _tmp37_, _tmp38_);
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp40_ = _tmp39_;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				moonshot_logger_trace (_tmp34_, _tmp40_, NULL);
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_free0 (_tmp40_);
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp41_ = id;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp42_ = id_card_get_trust_anchor (_tmp41_);
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp43_ = _tmp42_;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp44_ = before_now;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				trust_anchor_set_datetime_added (_tmp43_, _tmp44_);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				save_needed = TRUE;
#line 2947 "moonshot-identities-manager.c"
			}
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id);
#line 2951 "moonshot-identities-manager.c"
		}
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_list);
#line 2955 "moonshot-identities-manager.c"
	}
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp45_ = save_needed;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp45_) {
#line 2961 "moonshot-identities-manager.c"
		IIdentityCardStore* _tmp46_ = NULL;
#line 326 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp46_ = self->priv->store;
#line 326 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		iidentity_card_store_store_id_cards (_tmp46_);
#line 2967 "moonshot-identities-manager.c"
	}
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (before_now);
#line 2971 "moonshot-identities-manager.c"
}


IIdentityCardStoreStoreType identity_manager_model_get_store_type (IdentityManagerModel* self) {
	IIdentityCardStoreStoreType result = 0;
	IIdentityCardStore* _tmp0_ = NULL;
	IIdentityCardStoreStoreType _tmp1_ = 0;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->store;
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = iidentity_card_store_get_store_type (_tmp0_);
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp1_;
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2989 "moonshot-identities-manager.c"
}


gboolean identity_manager_model_HasNonTrivialIdentities (IdentityManagerModel* self) {
	gboolean result = FALSE;
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2997 "moonshot-identities-manager.c"
	{
		GeeLinkedList* _card_list = NULL;
		IIdentityCardStore* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _card_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _card_index = 0;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = self->priv->store;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp1_ = iidentity_card_store_get_card_list (_tmp0_);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_card_list = _tmp1_;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = _card_list;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = _tmp3_;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_card_size = _tmp4_;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_card_index = -1;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 3025 "moonshot-identities-manager.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			IdCard* card = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			IdCard* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp5_ = _card_index;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_card_index = _tmp5_ + 1;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = _card_index;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = _card_size;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 3049 "moonshot-identities-manager.c"
			}
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp8_ = _card_list;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = _card_index;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			card = (IdCard*) _tmp10_;
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = card;
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp14_ = id_card_is_no_identity (_tmp13_);
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!_tmp14_) {
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp12_ = TRUE;
#line 3067 "moonshot-identities-manager.c"
			} else {
				IdCard* _tmp15_ = NULL;
				GeeArrayList* _tmp16_ = NULL;
				GeeArrayList* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp15_ = card;
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp16_ = id_card_get_services (_tmp15_);
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp17_ = _tmp16_;
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp19_ = _tmp18_;
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp12_ = _tmp19_ > 0;
#line 3086 "moonshot-identities-manager.c"
			}
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp12_) {
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp11_ = TRUE;
#line 3092 "moonshot-identities-manager.c"
			} else {
				IdCard* _tmp20_ = NULL;
				Rule* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				Rule* _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp20_ = card;
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp21_ = id_card_get_rules (_tmp20_, &_tmp21__length1);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp22_ = _tmp21_;
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp22__length1 = _tmp21__length1;
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp11_ = _tmp22__length1 > 0;
#line 3109 "moonshot-identities-manager.c"
			}
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp11_) {
#line 341 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				result = TRUE;
#line 341 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (card);
#line 341 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (_card_list);
#line 341 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				return result;
#line 3121 "moonshot-identities-manager.c"
			}
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (card);
#line 3125 "moonshot-identities-manager.c"
		}
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_card_list);
#line 3129 "moonshot-identities-manager.c"
	}
#line 344 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = FALSE;
#line 344 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 3135 "moonshot-identities-manager.c"
}


static gpointer _identity_manager_app_ref0 (gpointer self) {
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self ? identity_manager_app_ref (self) : NULL;
#line 3142 "moonshot-identities-manager.c"
}


IdentityManagerModel* identity_manager_model_construct (GType object_type, IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type) {
	IdentityManagerModel * self = NULL;
	MoonshotLogger* _tmp0_ = NULL;
	IIdentityCardStoreStoreType _tmp1_ = 0;
	GEnumValue* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	IdentityManagerApp* _tmp5_ = NULL;
	IdentityManagerApp* _tmp6_ = NULL;
	PasswordHashTable* _tmp7_ = NULL;
	IIdentityCardStoreStoreType _tmp8_ = 0;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (parent_app != NULL, NULL);
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = (IdentityManagerModel*) g_object_new (object_type, NULL);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = identity_manager_model_logger;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = store_type;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = g_enum_get_value (g_type_class_ref (IIDENTITY_CARD_STORE_TYPE_STORE_TYPE), _tmp1_);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = g_strconcat ("IdentityManagerModel: store_type=", (_tmp2_ != NULL) ? _tmp2_->value_name : NULL, NULL);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = _tmp3_;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	moonshot_logger_trace (_tmp0_, _tmp4_, NULL);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp4_);
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = parent_app;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = _identity_manager_app_ref0 (_tmp5_);
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_identity_manager_app_unref0 (self->priv->parent);
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv->parent = _tmp6_;
#line 353 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = password_hash_table_new ();
#line 353 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (self->priv->password_table);
#line 353 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv->password_table = _tmp7_;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp8_ = store_type;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_set_store_type (self, _tmp8_);
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self;
#line 3195 "moonshot-identities-manager.c"
}


IdentityManagerModel* identity_manager_model_new (IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type) {
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return identity_manager_model_construct (TYPE_IDENTITY_MANAGER_MODEL, parent_app, store_type);
#line 3202 "moonshot-identities-manager.c"
}


static void identity_manager_model_class_init (IdentityManagerModelClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_parent_class = g_type_class_peek_parent (klass);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_type_class_add_private (klass, sizeof (IdentityManagerModelPrivate));
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = identity_manager_model_finalize;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_signal_new ("card_list_changed", TYPE_IDENTITY_MANAGER_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = get_logger ("IdentityManagerModel");
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_logger = _tmp0_;
#line 3220 "moonshot-identities-manager.c"
}


static void identity_manager_model_instance_init (IdentityManagerModel * self) {
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv = IDENTITY_MANAGER_MODEL_GET_PRIVATE (self);
#line 3227 "moonshot-identities-manager.c"
}


static void identity_manager_model_finalize (GObject* obj) {
	IdentityManagerModel * self;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (self->priv->password_table);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (self->priv->store);
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_identity_manager_app_unref0 (self->priv->parent);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (identity_manager_model_parent_class)->finalize (obj);
#line 3243 "moonshot-identities-manager.c"
}


GType identity_manager_model_get_type (void) {
	static volatile gsize identity_manager_model_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdentityManagerModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) identity_manager_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdentityManagerModel), 0, (GInstanceInitFunc) identity_manager_model_instance_init, NULL };
		GType identity_manager_model_type_id;
		identity_manager_model_type_id = g_type_register_static (G_TYPE_OBJECT, "IdentityManagerModel", &g_define_type_info, 0);
		g_once_init_leave (&identity_manager_model_type_id__volatile, identity_manager_model_type_id);
	}
	return identity_manager_model_type_id__volatile;
}



