------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;                use GNAT.IO;
with GNATCOLL.GMP.Integers;  use GNATCOLL.GMP.Integers;

procedure Test_Pow is

   A, B : Big_Integer;

begin
   Set (A, "2");
   Set (B, A ** 5);
   if B /= 32 then
      Put_Line ("test_pow failed: 2**5 should = 32");
      return;
   end if;

   Set (A, 100);
   Raise_To_N (A, 5);
   if Image (A) /= "10000000000" then
      Put_Line ("test_pow failed: 100**5 should = 10000000000");
      return;
   end if;

   Put_Line ("test_pow passed");
end Test_Pow;
