; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=CHECK-P9

define dso_local i64 @test_invalid(<16 x i8> %a) local_unnamed_addr #0 {
; CHECK-LABEL: test_invalid:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v2, 0
; CHECK-NEXT:    setbc r3, 4*cr6+un
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_invalid:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v2, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 28, 31, 31
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdsub.p(i32 6, <16 x i8> %a, <16 x i8> %a) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

define dso_local <16 x i8> @test_add(<16 x i8> %a, <16 x i8> %b, i64 %ps) local_unnamed_addr #0 {
; CHECK-LABEL: test_add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdadd. v2, v2, v3, 1
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_add:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdadd. v2, v2, v3, 1
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call <16 x i8> @llvm.ppc.bcdadd(<16 x i8> %a, <16 x i8> %b, i32 1)
  ret <16 x i8> %0
}

define dso_local i64 @test_add_ofl(<16 x i8> %a, <16 x i8> %b, i64 %ps) local_unnamed_addr #0 {
; CHECK-LABEL: test_add_ofl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdadd. v2, v2, v3, 0
; CHECK-NEXT:    setbc r3, 4*cr6+un
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_add_ofl:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdadd. v2, v2, v3, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 28, 31, 31
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdadd.p(i32 6, <16 x i8> %a, <16 x i8> %b) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

define dso_local <16 x i8> @test_sub(<16 x i8> %a, <16 x i8> %b, i64 %ps) local_unnamed_addr #0 {
; CHECK-LABEL: test_sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_sub:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call <16 x i8> @llvm.ppc.bcdsub(<16 x i8> %a, <16 x i8> %b, i32 0)
  ret <16 x i8> %0
}

define dso_local i64 @test_sub_ofl(<16 x i8> %a, <16 x i8> %b, i64 %ps) local_unnamed_addr #0 {
; CHECK-LABEL: test_sub_ofl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-NEXT:    setbc r3, 4*cr6+un
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_sub_ofl:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 28, 31, 31
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdsub.p(i32 6, <16 x i8> %a, <16 x i8> %b) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

define dso_local i64 @test_cmplt(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-LABEL: test_cmplt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-NEXT:    setbc r3, 4*cr6+lt
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_cmplt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 25, 31, 31
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdsub.p(i32 2, <16 x i8> %a, <16 x i8> %b) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

define dso_local i64 @test_cmpgt(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-LABEL: test_cmpgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-NEXT:    setbc r3, 4*cr6+gt
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_cmpgt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 26, 31, 31
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdsub.p(i32 4, <16 x i8> %a, <16 x i8> %b) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

define dso_local i64 @test_cmpeq(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-LABEL: test_cmpeq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-NEXT:    setbc r3, 4*cr6+eq
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_cmpeq:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 27, 31, 31
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdsub.p(i32 0, <16 x i8> %a, <16 x i8> %b) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

define dso_local i64 @test_cmpge(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-LABEL: test_cmpge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-NEXT:    setbcr r3, 4*cr6+lt
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_cmpge:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 25, 31, 31
; CHECK-P9-NEXT:    xori r3, r3, 1
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdsub.p(i32 3, <16 x i8> %a, <16 x i8> %b) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

define dso_local i64 @test_cmple(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-LABEL: test_cmple:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-NEXT:    setbcr r3, 4*cr6+gt
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-P9-LABEL: test_cmple:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    bcdsub. v2, v2, v3, 0
; CHECK-P9-NEXT:    mfocrf r3, 2
; CHECK-P9-NEXT:    rlwinm r3, r3, 26, 31, 31
; CHECK-P9-NEXT:    xori r3, r3, 1
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.bcdsub.p(i32 5, <16 x i8> %a, <16 x i8> %b) #2
  %conv.i = sext i32 %0 to i64
  ret i64 %conv.i
}

declare i32 @llvm.ppc.bcdsub.p(i32 immarg, <16 x i8>, <16 x i8>) #1
declare i32 @llvm.ppc.bcdadd.p(i32 immarg, <16 x i8>, <16 x i8>) #1
declare <16 x i8> @llvm.ppc.bcdadd(<16 x i8>, <16 x i8>, i32 immarg) #1
declare <16 x i8> @llvm.ppc.bcdsub(<16 x i8>, <16 x i8>, i32 immarg) #1
