/* ----------------------------------------------------------------------
    This is the

    ██╗     ██╗ ██████╗  ██████╗  ██████╗ ██╗  ██╗████████╗███████╗
    ██║     ██║██╔════╝ ██╔════╝ ██╔════╝ ██║  ██║╚══██╔══╝██╔════╝
    ██║     ██║██║  ███╗██║  ███╗██║  ███╗███████║   ██║   ███████╗
    ██║     ██║██║   ██║██║   ██║██║   ██║██╔══██║   ██║   ╚════██║
    ███████╗██║╚██████╔╝╚██████╔╝╚██████╔╝██║  ██║   ██║   ███████║
    ╚══════╝╚═╝ ╚═════╝  ╚═════╝  ╚═════╝ ╚═╝  ╚═╝   ╚═╝   ╚══════╝®

    DEM simulation engine, released by
    DCS Computing Gmbh, Linz, Austria
    http://www.dcs-computing.com, office@dcs-computing.com

    LIGGGHTS® is part of CFDEM®project:
    http://www.liggghts.com | http://www.cfdem.com

    Core developer and main author:
    Christoph Kloss, christoph.kloss@dcs-computing.com

    LIGGGHTS® is open-source, distributed under the terms of the GNU Public
    License, version 2 or later. It is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. You should have
    received a copy of the GNU General Public License along with LIGGGHTS®.
    If not, see http://www.gnu.org/licenses . See also top-level README
    and LICENSE files.

    LIGGGHTS® and CFDEM® are registered trade marks of DCS Computing GmbH,
    the producer of the LIGGGHTS® software and the CFDEM®coupling software
    See http://www.cfdem.com/terms-trademark-policy for details.

-------------------------------------------------------------------------
    Contributing author and copyright for this file:
    (if not contributing author is listed, this file has been contributed
    by the core developer)

    Copyright 2012-     DCS Computing GmbH, Linz
    Copyright 2009-2012 JKU Linz
------------------------------------------------------------------------- */

#ifdef COMPUTE_CLASS

ComputeStyle(nparticles/tracer/region,ComputeNparticlesTracerRegion)

#else

#ifndef LMP_COMPUTE_NPARTICLES_TRACER_REGION_H
#define LMP_COMPUTE_NPARTICLES_TRACER_REGION_H

#include "compute.h"

namespace LAMMPS_NS {

class ComputeNparticlesTracerRegion : public Compute {

 public:

  ComputeNparticlesTracerRegion(class LAMMPS *, int, char **);
  ~ComputeNparticlesTracerRegion();

  void init();
  void compute_vector();

 private:

  template<bool IMAGE>
  void compute_vector_eval(bool, double&, double&);

  // image stuff
  int image_dim_, image_no_;
  bool reset_marker_;

  // params for regions where to mark and where to count
  int iregion_count_;
  char *idregion_count_;

  class FixPropertyAtomTracer *fix_tracer_;
  char *fix_tracer_name_;
};

}

#endif
#endif
