/*
  SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "textautogeneratedialog.h"
#include "core/textautogeneratemanager.h"
#include "textautogeneratestackwidget.h"

#include <KConfigGroup>
#include <KLocalizedString>
#include <KSharedConfig>
#include <KWindowConfig>
#include <QDialogButtonBox>
#include <QVBoxLayout>
#include <QWindow>

namespace
{
const char myTextAutoGenerateDialogGroupName[] = "TextAutoGenerateDialog";
}
using namespace TextAutoGenerateText;

TextAutoGenerateDialog::TextAutoGenerateDialog(QWidget *parent)
    : QDialog(parent)
    , mTextAutoGenerateManager(new TextAutoGenerateText::TextAutoGenerateManager(this))
    , mTextAutoGenerateWidget(new TextAutoGenerateStackWidget(mTextAutoGenerateManager, this))
{
    setWindowTitle(i18nc("@title:window", "Conversation"));

    auto mainLayout = new QVBoxLayout(this);
    mainLayout->setObjectName(QStringLiteral("mainLayout"));

    mTextAutoGenerateWidget->setObjectName(QStringLiteral("mTextAutoGenerateWidget"));
    mainLayout->addWidget(mTextAutoGenerateWidget);

    auto button = new QDialogButtonBox(QDialogButtonBox::Close, this);
    button->setObjectName(QStringLiteral("button"));
    mainLayout->addWidget(button);
    connect(button, &QDialogButtonBox::rejected, this, &TextAutoGenerateDialog::reject);
    readConfig();
}

TextAutoGenerateDialog::~TextAutoGenerateDialog()
{
    writeConfig();
}

void TextAutoGenerateDialog::readConfig()
{
    create(); // ensure a window is created
    windowHandle()->resize(QSize(400, 300));
    KConfigGroup group(KSharedConfig::openStateConfig(), QLatin1StringView(myTextAutoGenerateDialogGroupName));
    KWindowConfig::restoreWindowSize(windowHandle(), group);
    resize(windowHandle()->size()); // workaround for QTBUG-40584
}

void TextAutoGenerateDialog::writeConfig()
{
    KConfigGroup group(KSharedConfig::openStateConfig(), QLatin1StringView(myTextAutoGenerateDialogGroupName));
    KWindowConfig::saveWindowSize(windowHandle(), group);
}

void TextAutoGenerateDialog::ask(const QString &str)
{
    mTextAutoGenerateManager->ask(str);
}

#include "moc_textautogeneratedialog.cpp"
