---
page_title: Grafana CLA
page_description: Grafana Contributor License Agreement
page_keywords: grafana, cla, contribute, documentation
---

# Grafana Contributor License Agreement

## Why is this agreement necessary?
We very much appreciate your wanting to contribute to Grafana,
but we need to add you to the contributors list first.


Note that the following agreement is not a transfer of copyright ownership,
this simply is a license agreement for contributions. You also do not change
your rights to use your own contributions for any other purpose.


For some background on why contributor license agreements are necessary,
you can read FAQs from many other open source projects:

- [Django's excellent CLA FAQ](https://www.djangoproject.com/foundation/cla/faq/)
- [A well-written chapter from Karl Fogel's Producing Open Source Software on CLAs](http://producingoss.com/en/copyright-assignment.html)
- [The Wikipedia article on CLAs](http://en.wikipedia.org/wiki/Contributor_license_agreement)

This is part of the legal framework of the open-source ecosystem that adds some red tape,
but protects both the contributor and the company / foundation behind the project.
It also gives us the option to relicense the code with a more permissive license in the future.


If you have more questions, shoot us an [email](mailto:torkel@grafana.org) or drop by #grafana on IRC (freenode).

Many thanks to [RethinkDB](http://rethinkdb.com) for permission to re-use their CLA!

## Terms of the Agreement

<hr>

This Contributor License Agreement (“Agreement”) is entered into between Coding Instinct AB,
a Swedish corporation (“Grafana,” “we” or “us” etc.) and you (as defined and further identified below).
Accordingly, you hereby agree to the following terms for your past, present and future contributions
submitted to Grafana:


**1. Definitions:**
<strong>(a)</strong> "You" (or "your") shall mean the contribution copyright owner (whether an individual or organization) or legal entity authorized by the copyright owner that is making this Agreement with Grafana.


<strong>(b)</strong> "Contribution(s)" shall mean the code, documentation or other original works of authorship, including any modifications or additions to an existing work, submitted by you to Grafana for inclusion in, or documentation of, any of the products or projects owned or managed by Grafana (the "work(s)"). For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication sent to Grafana or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, Grafana for the purpose of discussing and/or improving the work, but excluding communication that is conspicuously marked or otherwise designated in writing by you as "Not a Contribution."

**2. Grant of Copyright License.**
You hereby grant to Grafana and to recipients of software distributed by Grafana a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare derivative works of, publicly display, publicly perform, sublicense, and distribute your contributions and such derivative works.


**3. Grant of Patent License.**
With respect to any patents you own, or that you can license without payment to any third party, you hereby grant Grafana a perpetual, irrevocable, non-exclusive, worldwide, no-charge, royalty-free license to: (i) make, have made, use, sell, offer to sell, import, and otherwise distribute and exploit your contributions in whole or in part, alone or in combination with or included in any product, work or materials arising out of or relating to the Works to which your contributions were submitted; and (ii) sublicense these same rights to third parties through multiple levels of sublicensees or other licensing arrangements.


**4. Rights.**
Except as set out above, you keep all right, title, and interest in your contribution. The rights that you grant to us under this agreement are effective on the date you first submitted a contribution to us, even if your submission took place before the date you entered this agreement.


**5. You represent and warrant that:**
<strong>(i)</strong> the contributions are an original work and that you can legally grant the rights set out in this agreement;


<strong>(ii)</strong> the contributions and Grafana’s exercise of any license rights granted hereunder, does not and will not, infringe the rights of any third party;


<strong>(iii)</strong> you are not aware of any pending or threatened claims, suits, actions, or charges pertaining to the contributions, including without limitation any claims or allegations that any or all of the contributions infringes, violates, or misappropriate the intellectual property rights of any third party (you further agree that you will notify Grafana immediately if you become aware of any such actual or potential claims, suits, actions, allegations or charges).


**6. Employer Rights.**
If your employer(s) has rights to intellectual property that you create that includes your contributions, you represent and warrant that your employer has waived such rights for your contributions to Grafana, or that you have received permission to make contributions on behalf of that employer and that you are authorized to execute this agreement on behalf of your employer.


**7. Support.**
You are not expected to provide support for your contributions, except to the extent you desire to provide support. You may provide support for free, for a fee, or not at all. Except as set forth herein, and unless required by applicable law or agreed to in writing, you provide your contributions on an "as is" basis, without warranties or conditions of any kind.


**8. Enforcement.**
The failure of either party to enforce its rights under this agreement for any period shall not be construed as a waiver of such rights. No changes or modifications or waivers to this Agreement will be effective unless in writing and signed by both parties. In the event that any provision of this agreement shall be determined to be illegal or unenforceable, that provision will be limited or eliminated to the minimum extent necessary so that this agreement shall otherwise remain in full force and effect and enforceable. This agreement shall be governed by and construed in accordance with the laws of the State of California in the United States without regard to the conflicts of laws provisions thereof. In any action or proceeding to enforce rights under this agreement, the prevailing party will be entitled to recover costs and attorneys’ fees.


<iframe src="https://docs.google.com/forms/d/1iagLZBotC4IIrz7TXvEdPU5tCtFDk__C5Rs92afXpCE/viewform?embedded=true" width="800" height="820" frameborder="0" marginheight="0" marginwidth="0">Loading CLA...</iframe>