---
name: GMT release checklist
about: Checklist for a new GMT release.
title: Release GMT x.x.x
labels: ''
assignees: ''

---

**Version**:  x.x.x

**Scheduled date**: XXX XX, 20XX

**Before release**:

- [ ] check if there are new [SCM releases](https://doi.org/10.5281/zenodo.1243862)
- [ ] check if all tests pass on macOS, Linux and Windows
- [ ] check if other GMT-derived projects work well
	- [ ] MB-System (@PaulWessel)
	- [ ] GMTSAR (@PaulWessel)
	- [ ] GMT.jl (@joa-quim)
	- [ ] PyGMT (@leouieda, @seisman, @weiji14, @maxrjones)
	- [ ] gmtmex (@PaulWessel, @joa-quim)
- [ ] reserve a DOI on [zenodo](https://zenodo.org/doi/10.5281/zenodo.3407865) (@PaulWessel, @seisman)
- [ ] run `admin/gs_check.sh` to test if latest ghostscript version works
- [ ] update [changelog](https://github.com/GenericMappingTools/gmt/blob/master/doc/rst/source/changes.rst)
- [ ] update the version information in CITATION.cff
- [ ] check installation instructions in `doc/rst/source/install.rst`
- [ ] check if there are any warnings when building the documentation
- [ ] add one new entry in `doc/rst/_static/version_switch.js` if it's a minor release
- [ ] check/set values in `cmake/ConfigDefault.cmake`
    - [ ] `GMT_VERSION_YEAR` is current year
    - [ ] `GMT_PACKAGE_VERSION_*` is correctly set
    - [ ] `GMT_LIB_SOVERSION` is correctly set
    - [ ] set `GMT_PUBLIC_RELEASE` to `TRUE`
    - [ ] update `GMT_VERSION_DOI`
- [ ] freeze codes and commit all changes to GitHub

**Release**:

- [ ] create source tarballs (tar.gz and tar.xz) (@PaulWessel)
- [ ] create macOS bundle (@PaulWessel)
- [ ] create Windows win64 installer and portable installer (@joa-quim)
- [ ] check if the source tarballs for Linux work well (@Esteban82, @anbj)
- [ ] check if the macOS bundles work well (@seisman, @maxrjones)
- [ ] check if the Windows installers work well (volunteers needed!)
- [ ] upload source tarballs, macOS bundle, Windows installers to the GMT FTP (@PaulWessel)
- [ ] update README and VERSION files on the GMT FTP (@PaulWessel)
- [ ] make a tag and push it to github (**Must be done after uploading packages to the GMT FTP**)
    ```bash
    # checkout master (for minor releases) or 6.x branch (for patch releases)
    git checkout XXXX
    # create the tag x.x.x
    git tag x.x.x
    # Push tags to GitHub
    git push --tags
    ```
- [ ] make a GitHub release.
  The GitHub Actions automatically create a draft release after pushing the tag to github.
  We need to go to the [GitHub Release](https://github.com/GenericMappingTools/gmt/releases) page, and review it manually.
  - [ ] 7 files are attached as release assets (2 source tarballs, 4 installers and 1 checksum file).
  - [ ] download the checksum file and check if the checksums are correct
  - [ ] edit the draft release, set the target to the correct tag, and publish the release
- [ ] upload the tarball to [zenodo](https://zenodo.org/doi/10.5281/zenodo.3407865) (@PaulWessel, @seisman)
- [ ] make announcements in the [GMT forum](https://forum.generic-mapping-tools.org/)
- [ ] make announcements on the [GMT Instagram](https://www.instagram.com/genericmappingtools/)
- [ ] update links on the main site (Download & Documentation)
- [ ] update install instructions on the wiki if needed

**After release**:

- [ ] Reset for the next version
      - [ ] update `GMT_PACKAGE_VERSION_*` in `cmake/ConfigDefault.cmake`
      - [ ] comment the `set (GMT_PUBLIC_RELEASE TRUE)` line

**3rd-party update**

**Volunteers needed!** Please let us know if you volunteer to help to maintain GMT in these 3rd-party tools.

- [ ] update [conda-forge feedstock](https://github.com/conda-forge/gmt-feedstock) (@leouieda, @seisman, @weiji14)
- [ ] update [homebrew formula](https://github.com/Homebrew/homebrew-core/blob/master/Formula/g/gmt.rb) (@claudiodsf, @seisman)
- [ ] update [macports ports](https://github.com/macports/macports-ports/blob/master/science/gmt5/Portfile) (@remkos, @seisman)
- [ ] update [the RPM repository](https://copr.fedorainfracloud.org/coprs/genericmappingtools/gmt/) (@seisman)
- [ ] update the [try-gmt](https://github.com/GenericMappingTools/try-gmt) Jupyter lab (@weiji14, @seisman, @maxrjones)
- [ ] update [winget manifest file](https://github.com/microsoft/winget-pkgs/tree/master/manifests/g/GenericMappingTools/gmt) (@seisman)

---

- [ ] Party :tada: (don't tick before all other checkboxes are ticked!)
