/*
  Copyright 2013 Siemens Product Lifecycle Management Software Inc. All rights reserved.
  This software and related documentation are proprietary to 
  Siemens Product Lifecycle Management Software Inc.
*/
#ifndef FRUSTRUM_TOKENS_H
#define FRUSTRUM_TOKENS_H

/* File Guise Tokens */

#define FFCROL (    1) /* rollback file */
#define FFCSNP (    2) /* snapshot file */
#define FFCJNL (    3) /* journal file */
#define FFCXMT (    4) /* transmit file (generated by the C-kernel) */
#define FFCXMO (    5) /* transmit file (generated by the old Fortran kernel) */
#define FFCSCH (    6) /* schema file */
#define FFCLNC (    7) /* licence file */
#define FFCXMP (    8) /* transmit file (partition) */
#define FFCXMD (    9) /* transmit file (deltas) */
#define FFCDBG (   10) /* debug report file */

/* File Format Tokens */

#define FFBNRY (    1) /* binary */
#define FFTEXT (    2) /* text */
#define FFAPPL (    3) /* applio */
#define FFXML  (    4) /* xml */

/* File Open Mode Tokens */

#define FFSKHD (    1) /* skip header after opening file for read (usual) */
#define FFLVHD (    2) /* leave header after opening file for read (fru tests) */

/* File Close Mode Tokens */

#define FFNORM (    1) /* normal: default action on file close */
#define FFABOR (    2) /* abort: delete the newly created file */

/* GO Codes */

#define CODCOM ( 1001) /* Segment complete */
#define CODINC ( 1002) /* Segment incomplete */
#define CODUNC ( 1003) /* Segment may or may not be complete */
#define CODOVP ( 1004) /* Segment is outside all viewports */
#define CODCVP ( 1005) /* Segment is coincident with a viewport boundary */
#define CODVIS ( 1006) /* Line segment is visible */
#define CODINV ( 1007) /* Line segment is invisible */
#define CODUNV ( 1008) /* Visibility of line segment is unknown */
#define CODDRV ( 1009) /* Line segment is drafting line */
#define CODSMO ( 1014) /* Edge is "smooth" */
#define CODNSM ( 1015) /* Edge is not "smooth" */
#define CODUNS ( 1016) /* Edge "smoothness" is unknown */
#define CODSMS ( 1017) /* Edge "smooth" but coincident with silhouette */
#define CODINE ( 1018) /* Edge is internal */
#define CODNIN ( 1019) /* Edge is not internal */
#define CODINU ( 1020) /* Not known whether edge is internal */
#define CODINS ( 1021) /* Edge is internal, coincides with silhouette */
#define CODISH ( 1022) /* Line segment is invisible (hidden by its own body occ) */
#define CODIGN ( 1023) /* Edge lies on the boundary of an ignorable feature */

/* GO Segment Types */

#define SGTPBY ( 2003) /* Body (hierarchical segment) */
#define SGTPED ( 2006) /* Edge */
#define SGTPSI ( 2007) /* Silhouette line */
#define SGTPPH ( 2008) /* Planar hatch-line */
#define SGTPRH ( 2009) /* Radial hatch-line */
#define SGTPRU ( 2010) /* Rib line (unfixed blend) */
#define SGTPBB ( 2011) /* Blend-boundary line */
#define SGTPPL ( 2012) /* Parametric hatch line */
#define SGTPHU ( 2013) /* Hull line *** OBSOLETE *** */
#define SGTPFT ( 2016) /* Facet */
#define SGTPFA ( 2017) /* Face (hierarchical segment) */
#define SGTPER ( 2018) /* Error segment */
#define SGTPGC ( 2019) /* Curve (geometry) segment */
#define SGTPGS ( 2020) /* Surface (geometry) segment */
#define SGTPGB ( 2021) /* Surface boundary (geometry) segment */
#define SGTPMF ( 2022) /* Mangled facet */
#define SGTPVT ( 2023) /* Visibility transitions */
#define SGTPTS ( 2024) /* Facet strip */
#define SGTPVP ( 2025) /* Visibility transitions (parameterised) */
#define SGTPIC ( 2026) /* Interference line */
#define SGTPCL ( 2027) /* Clip line */

/* GO Line Types */

#define L3TPSL ( 3001) /* Straight line */
#define L3TPCI ( 3002) /* Partial circle */
#define L3TPCC ( 3003) /* Complete circle */
#define L3TPEL ( 3004) /* Partial ellipse */
#define L3TPCE ( 3005) /* Complete ellipse */
#define L3TPPY ( 3006) /* Poly-line */
#define L3TPFV ( 3007) /* Facet vertices */
#define L3TPFN ( 3008) /* Facet vertices plus surface normals */
#define L3TPPC ( 3009) /* Non-rational parametric curve */
#define L3TPRC ( 3010) /* Rational parametric curve */
#define L3TPTS ( 3011) /* Facet strip vertices */
#define L3TPTN ( 3012) /* Facet strip vertices plus surface normals */
#define L3TPNC ( 3013) /* Non-rational nurbs curve */
#define L3TPRN ( 3014) /* Rational nurbs curve */
#define L3TPFP ( 3015) /* Facet vertices plus parameters */
#define L3TPFI ( 3016) /* Facet vertices plus normals plus parameters */
#define L3TPTP ( 3017) /* Facet strip vertices plus parameters */
#define L3TPTI ( 3018) /* Facet strip vertices plus normals plus parameters */
#define L3TPF1 ( 3019) /* Facet vertices + normals + parameters + 1st derivs */
#define L3TPF2 ( 3020) /* Facet vertices + normals + parameters + all derivs */
#define L3TPT1 ( 3021) /* Facet strip vxs + normals + parameters + 1st derivs */
#define L3TPT2 ( 3022) /* Facet strip vxs + normals + parameters + all derivs */

/* GO Error Codes */

#define ERNOGO ( 4001) /* unspecified error */
#define ERRUBB ( 4002) /* Rubber entity (no geometry attached) */
#define ERSANG ( 4003) /* Surface angular tolerance too small */
#define ERSDIS ( 4004) /* Surface distance tolerance too small */
#define ERCANG ( 4005) /* Curve angular tolerance too small */
#define ERCDIS ( 4006) /* Curve distance tolerance too small */
#define ERCLEN ( 4007) /* Curve chord length tolerance too small */
#define ERFWID ( 4008) /* Facet width tolerance too small */
#define ERIFMF ( 4009) /* Incremental Facetting: missing face */
#define ERIFRE ( 4010) /* Incremental Facetting: refinement required */
#define ERIFER ( 4011) /* Incremental Facetting: unspecified error */

/* FG Node Operation Codes */

#define FGRECU (    1) /* Retrieve foreign curve geometry */
#define FGRESU (    2) /* Retrieve foreign surface geometry */
#define FGCOCU (   11) /* Copy foreign curve geometry */
#define FGCOSU (   12) /* Copy foreign surface geometry */
#define FGFRCU (   21) /* Free foreign curve geometry */
#define FGFRSU (   22) /* Free foreign surface geometry */
#define FGTXCU (   31) /* Transmitting foreign curve geometry */
#define FGTXSU (   32) /* Transmitting foreign surface geometry */

/* FG Evaluation Operation Codes */

#define FGEVTR (    1) /* Triangular evaluation matrix required */
#define FGEVSQ (    2) /* Square evaluation matrix required */
#define FGPRBD (    1) /* Geometry parameterisation is bounded */
#define FGPRPE (    2) /* Geometry parameterisation is periodic */

/* Rollmark Operation Codes */

#define FRROST (    1) /* Rollback status */
#define FRROSE (    2) /* Set a roll mark */
#define FRROMA (    3) /* Roll to a mark */
#define FRRODT (    4) /* Rollmark is out of date */
#define FRROON (    1) /* Rollback status is on */
#define FRROFF (    0) /* Rollback status is off */
#endif /* FRUSTRUM_TOKENS_H */

/* End Tokens */

