// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file dds_xtypes_typeobjectCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__DDS_XTYPES_TYPEOBJECTCDRAUX_IPP
#define FAST_DDS_GENERATED__DDS_XTYPES_TYPEOBJECTCDRAUX_IPP

#include <fastdds/dds/xtypes/type_representation/detail/dds_xtypes_typeobjectCdrAux.hpp>

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeObjectHashId& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case EK_COMPLETE:
                case EK_MINIMAL:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.hash(), current_alignment);
                    break;

        default:
            break;
    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeObjectHashId& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case EK_COMPLETE:
                case EK_MINIMAL:
                    scdr << eprosima::fastcdr::MemberId(1) << data.hash();
                    break;

        default:
            break;
    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeObjectHashId& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    uint8_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case EK_COMPLETE:
                                                case EK_MINIMAL:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::EquivalenceHash hash_value{0};
                                                        data.hash(std::move(hash_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                        default:
                            data._default();
                            break;
                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case EK_COMPLETE:
                                                case EK_MINIMAL:
                                                    dcdr >> data.hash();
                                                    break;

                        default:
                            break;
                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::StringSTypeDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bound(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::StringSTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bound()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::StringSTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bound();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::StringSTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bound();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::StringLTypeDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bound(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::StringLTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bound()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::StringLTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bound();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::StringLTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bound();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.equiv_kind(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.element_flags(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.equiv_kind()
        << eprosima::fastcdr::MemberId(1) << data.element_flags()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.equiv_kind();
                                            break;

                                        case 1:
                                                dcdr >> data.element_flags();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.equiv_kind();

                        scdr << data.element_flags();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::PlainSequenceSElemDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.bound(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element_identifier(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainSequenceSElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.header()
        << eprosima::fastcdr::MemberId(1) << data.bound()
        << eprosima::fastcdr::MemberId(2) << data.element_identifier()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::PlainSequenceSElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.header();
                                            break;

                                        case 1:
                                                dcdr >> data.bound();
                                            break;

                                        case 2:
                                                dcdr >> data.element_identifier();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainSequenceSElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.header());

                        scdr << data.bound();

                        scdr << data.element_identifier();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::PlainSequenceLElemDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.bound(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element_identifier(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainSequenceLElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.header()
        << eprosima::fastcdr::MemberId(1) << data.bound()
        << eprosima::fastcdr::MemberId(2) << data.element_identifier()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::PlainSequenceLElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.header();
                                            break;

                                        case 1:
                                                dcdr >> data.bound();
                                            break;

                                        case 2:
                                                dcdr >> data.element_identifier();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainSequenceLElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.header());

                        scdr << data.bound();

                        scdr << data.element_identifier();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::PlainArraySElemDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.array_bound_seq(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element_identifier(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainArraySElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.header()
        << eprosima::fastcdr::MemberId(1) << data.array_bound_seq()
        << eprosima::fastcdr::MemberId(2) << data.element_identifier()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::PlainArraySElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.header();
                                            break;

                                        case 1:
                                                dcdr >> data.array_bound_seq();
                                            break;

                                        case 2:
                                                dcdr >> data.element_identifier();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainArraySElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.header());

                        scdr << data.array_bound_seq();

                        scdr << data.element_identifier();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::PlainArrayLElemDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.array_bound_seq(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element_identifier(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainArrayLElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.header()
        << eprosima::fastcdr::MemberId(1) << data.array_bound_seq()
        << eprosima::fastcdr::MemberId(2) << data.element_identifier()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::PlainArrayLElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.header();
                                            break;

                                        case 1:
                                                dcdr >> data.array_bound_seq();
                                            break;

                                        case 2:
                                                dcdr >> data.element_identifier();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainArrayLElemDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.header());

                        scdr << data.array_bound_seq();

                        scdr << data.element_identifier();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::PlainMapSTypeDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.bound(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element_identifier(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.key_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.key_identifier(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainMapSTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.header()
        << eprosima::fastcdr::MemberId(1) << data.bound()
        << eprosima::fastcdr::MemberId(2) << data.element_identifier()
        << eprosima::fastcdr::MemberId(3) << data.key_flags()
        << eprosima::fastcdr::MemberId(4) << data.key_identifier()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::PlainMapSTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.header();
                                            break;

                                        case 1:
                                                dcdr >> data.bound();
                                            break;

                                        case 2:
                                                dcdr >> data.element_identifier();
                                            break;

                                        case 3:
                                                dcdr >> data.key_flags();
                                            break;

                                        case 4:
                                                dcdr >> data.key_identifier();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainMapSTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data);






    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.header());

                        scdr << data.bound();

                        scdr << data.element_identifier();

                        scdr << data.key_flags();

                        scdr << data.key_identifier();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::PlainMapLTypeDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.bound(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element_identifier(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.key_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.key_identifier(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainMapLTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.header()
        << eprosima::fastcdr::MemberId(1) << data.bound()
        << eprosima::fastcdr::MemberId(2) << data.element_identifier()
        << eprosima::fastcdr::MemberId(3) << data.key_flags()
        << eprosima::fastcdr::MemberId(4) << data.key_identifier()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::PlainMapLTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.header();
                                            break;

                                        case 1:
                                                dcdr >> data.bound();
                                            break;

                                        case 2:
                                                dcdr >> data.element_identifier();
                                            break;

                                        case 3:
                                                dcdr >> data.key_flags();
                                            break;

                                        case 4:
                                                dcdr >> data.key_identifier();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::PlainMapLTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::PlainCollectionHeader& data);






    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.header());

                        scdr << data.bound();

                        scdr << data.element_identifier();

                        scdr << data.key_flags();

                        scdr << data.key_identifier();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::StronglyConnectedComponentId& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.sc_component_id(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.scc_length(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.scc_index(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::StronglyConnectedComponentId& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.sc_component_id()
        << eprosima::fastcdr::MemberId(1) << data.scc_length()
        << eprosima::fastcdr::MemberId(2) << data.scc_index()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::StronglyConnectedComponentId& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.sc_component_id();
                                            break;

                                        case 1:
                                                dcdr >> data.scc_length();
                                            break;

                                        case 2:
                                                dcdr >> data.scc_index();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::StronglyConnectedComponentId& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.sc_component_id();

                        scdr << data.scc_length();

                        scdr << data.scc_index();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::ExtendedTypeDefn& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::ExtendedTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::ExtendedTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::ExtendedTypeDefn& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::Dummy& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::Dummy& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::Dummy& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::Dummy& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeIdentifier& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case TK_NONE:
                case TK_BOOLEAN:
                case TK_BYTE:
                case TK_INT8:
                case TK_INT16:
                case TK_INT32:
                case TK_INT64:
                case TK_UINT8:
                case TK_UINT16:
                case TK_UINT32:
                case TK_UINT64:
                case TK_FLOAT32:
                case TK_FLOAT64:
                case TK_FLOAT128:
                case TK_CHAR8:
                case TK_CHAR16:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.no_value(), current_alignment);
                    break;

                case TI_STRING8_SMALL:
                case TI_STRING16_SMALL:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.string_sdefn(), current_alignment);
                    break;

                case TI_STRING8_LARGE:
                case TI_STRING16_LARGE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                                data.string_ldefn(), current_alignment);
                    break;

                case TI_PLAIN_SEQUENCE_SMALL:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                                data.seq_sdefn(), current_alignment);
                    break;

                case TI_PLAIN_SEQUENCE_LARGE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                                data.seq_ldefn(), current_alignment);
                    break;

                case TI_PLAIN_ARRAY_SMALL:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                                data.array_sdefn(), current_alignment);
                    break;

                case TI_PLAIN_ARRAY_LARGE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                                data.array_ldefn(), current_alignment);
                    break;

                case TI_PLAIN_MAP_SMALL:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                                data.map_sdefn(), current_alignment);
                    break;

                case TI_PLAIN_MAP_LARGE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                                data.map_ldefn(), current_alignment);
                    break;

                case TI_STRONGLY_CONNECTED_COMPONENT:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                                data.sc_component_id(), current_alignment);
                    break;

                case EK_COMPLETE:
                case EK_MINIMAL:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                                data.equivalence_hash(), current_alignment);
                    break;

                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                                data.extended_defn(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentifier& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case TK_NONE:
                case TK_BOOLEAN:
                case TK_BYTE:
                case TK_INT8:
                case TK_INT16:
                case TK_INT32:
                case TK_INT64:
                case TK_UINT8:
                case TK_UINT16:
                case TK_UINT32:
                case TK_UINT64:
                case TK_FLOAT32:
                case TK_FLOAT64:
                case TK_FLOAT128:
                case TK_CHAR8:
                case TK_CHAR16:
                    scdr << eprosima::fastcdr::MemberId(1) << data.no_value();
                    break;

                case TI_STRING8_SMALL:
                case TI_STRING16_SMALL:
                    scdr << eprosima::fastcdr::MemberId(2) << data.string_sdefn();
                    break;

                case TI_STRING8_LARGE:
                case TI_STRING16_LARGE:
                    scdr << eprosima::fastcdr::MemberId(3) << data.string_ldefn();
                    break;

                case TI_PLAIN_SEQUENCE_SMALL:
                    scdr << eprosima::fastcdr::MemberId(4) << data.seq_sdefn();
                    break;

                case TI_PLAIN_SEQUENCE_LARGE:
                    scdr << eprosima::fastcdr::MemberId(5) << data.seq_ldefn();
                    break;

                case TI_PLAIN_ARRAY_SMALL:
                    scdr << eprosima::fastcdr::MemberId(6) << data.array_sdefn();
                    break;

                case TI_PLAIN_ARRAY_LARGE:
                    scdr << eprosima::fastcdr::MemberId(7) << data.array_ldefn();
                    break;

                case TI_PLAIN_MAP_SMALL:
                    scdr << eprosima::fastcdr::MemberId(8) << data.map_sdefn();
                    break;

                case TI_PLAIN_MAP_LARGE:
                    scdr << eprosima::fastcdr::MemberId(9) << data.map_ldefn();
                    break;

                case TI_STRONGLY_CONNECTED_COMPONENT:
                    scdr << eprosima::fastcdr::MemberId(10) << data.sc_component_id();
                    break;

                case EK_COMPLETE:
                case EK_MINIMAL:
                    scdr << eprosima::fastcdr::MemberId(11) << data.equivalence_hash();
                    break;

                default:
                    scdr << eprosima::fastcdr::MemberId(12) << data.extended_defn();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeIdentifier& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    uint8_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case TK_NONE:
                                                case TK_BOOLEAN:
                                                case TK_BYTE:
                                                case TK_INT8:
                                                case TK_INT16:
                                                case TK_INT32:
                                                case TK_INT64:
                                                case TK_UINT8:
                                                case TK_UINT16:
                                                case TK_UINT32:
                                                case TK_UINT64:
                                                case TK_FLOAT32:
                                                case TK_FLOAT64:
                                                case TK_FLOAT128:
                                                case TK_CHAR8:
                                                case TK_CHAR16:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::Dummy no_value_value;
                                                        data.no_value(std::move(no_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_STRING8_SMALL:
                                                case TI_STRING16_SMALL:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::StringSTypeDefn string_sdefn_value;
                                                        data.string_sdefn(std::move(string_sdefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_STRING8_LARGE:
                                                case TI_STRING16_LARGE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::StringLTypeDefn string_ldefn_value;
                                                        data.string_ldefn(std::move(string_ldefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_PLAIN_SEQUENCE_SMALL:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::PlainSequenceSElemDefn seq_sdefn_value;
                                                        data.seq_sdefn(std::move(seq_sdefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_PLAIN_SEQUENCE_LARGE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::PlainSequenceLElemDefn seq_ldefn_value;
                                                        data.seq_ldefn(std::move(seq_ldefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_PLAIN_ARRAY_SMALL:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::PlainArraySElemDefn array_sdefn_value;
                                                        data.array_sdefn(std::move(array_sdefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_PLAIN_ARRAY_LARGE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::PlainArrayLElemDefn array_ldefn_value;
                                                        data.array_ldefn(std::move(array_ldefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_PLAIN_MAP_SMALL:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::PlainMapSTypeDefn map_sdefn_value;
                                                        data.map_sdefn(std::move(map_sdefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_PLAIN_MAP_LARGE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::PlainMapLTypeDefn map_ldefn_value;
                                                        data.map_ldefn(std::move(map_ldefn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TI_STRONGLY_CONNECTED_COMPONENT:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::StronglyConnectedComponentId sc_component_id_value;
                                                        data.sc_component_id(std::move(sc_component_id_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EK_COMPLETE:
                                                case EK_MINIMAL:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::EquivalenceHash equivalence_hash_value{0};
                                                        data.equivalence_hash(std::move(equivalence_hash_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                default:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::ExtendedTypeDefn extended_defn_value;
                                                        data.extended_defn(std::move(extended_defn_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case TK_NONE:
                                                case TK_BOOLEAN:
                                                case TK_BYTE:
                                                case TK_INT8:
                                                case TK_INT16:
                                                case TK_INT32:
                                                case TK_INT64:
                                                case TK_UINT8:
                                                case TK_UINT16:
                                                case TK_UINT32:
                                                case TK_UINT64:
                                                case TK_FLOAT32:
                                                case TK_FLOAT64:
                                                case TK_FLOAT128:
                                                case TK_CHAR8:
                                                case TK_CHAR16:
                                                    dcdr >> data.no_value();
                                                    break;

                                                case TI_STRING8_SMALL:
                                                case TI_STRING16_SMALL:
                                                    dcdr >> data.string_sdefn();
                                                    break;

                                                case TI_STRING8_LARGE:
                                                case TI_STRING16_LARGE:
                                                    dcdr >> data.string_ldefn();
                                                    break;

                                                case TI_PLAIN_SEQUENCE_SMALL:
                                                    dcdr >> data.seq_sdefn();
                                                    break;

                                                case TI_PLAIN_SEQUENCE_LARGE:
                                                    dcdr >> data.seq_ldefn();
                                                    break;

                                                case TI_PLAIN_ARRAY_SMALL:
                                                    dcdr >> data.array_sdefn();
                                                    break;

                                                case TI_PLAIN_ARRAY_LARGE:
                                                    dcdr >> data.array_ldefn();
                                                    break;

                                                case TI_PLAIN_MAP_SMALL:
                                                    dcdr >> data.map_sdefn();
                                                    break;

                                                case TI_PLAIN_MAP_LARGE:
                                                    dcdr >> data.map_ldefn();
                                                    break;

                                                case TI_STRONGLY_CONNECTED_COMPONENT:
                                                    dcdr >> data.sc_component_id();
                                                    break;

                                                case EK_COMPLETE:
                                                case EK_MINIMAL:
                                                    dcdr >> data.equivalence_hash();
                                                    break;

                                                default:
                                                    dcdr >> data.extended_defn();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::ExtendedAnnotationParameterValue& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::ExtendedAnnotationParameterValue& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::ExtendedAnnotationParameterValue& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::ExtendedAnnotationParameterValue& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::AnnotationParameterValue& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case TK_BOOLEAN:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.boolean_value(), current_alignment);
                    break;

                case TK_BYTE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.byte_value(), current_alignment);
                    break;

                case TK_INT8:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                                data.int8_value(), current_alignment);
                    break;

                case TK_UINT8:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                                data.uint8_value(), current_alignment);
                    break;

                case TK_INT16:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                                data.int16_value(), current_alignment);
                    break;

                case TK_UINT16:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                                data.uint_16_value(), current_alignment);
                    break;

                case TK_INT32:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                                data.int32_value(), current_alignment);
                    break;

                case TK_UINT32:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                                data.uint32_value(), current_alignment);
                    break;

                case TK_INT64:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                                data.int64_value(), current_alignment);
                    break;

                case TK_UINT64:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                                data.uint64_value(), current_alignment);
                    break;

                case TK_FLOAT32:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                                data.float32_value(), current_alignment);
                    break;

                case TK_FLOAT64:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                                data.float64_value(), current_alignment);
                    break;

                case TK_FLOAT128:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(13),
                                data.float128_value(), current_alignment);
                    break;

                case TK_CHAR8:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(14),
                                data.char_value(), current_alignment);
                    break;

                case TK_CHAR16:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(15),
                                data.wchar_value(), current_alignment);
                    break;

                case TK_ENUM:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(16),
                                data.enumerated_value(), current_alignment);
                    break;

                case TK_STRING8:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(17),
                                data.string8_value(), current_alignment);
                    break;

                case TK_STRING16:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(18),
                                data.string16_value(), current_alignment);
                    break;

                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(19),
                                data.extended_value(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AnnotationParameterValue& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case TK_BOOLEAN:
                    scdr << eprosima::fastcdr::MemberId(1) << data.boolean_value();
                    break;

                case TK_BYTE:
                    scdr << eprosima::fastcdr::MemberId(2) << data.byte_value();
                    break;

                case TK_INT8:
                    scdr << eprosima::fastcdr::MemberId(3) << data.int8_value();
                    break;

                case TK_UINT8:
                    scdr << eprosima::fastcdr::MemberId(4) << data.uint8_value();
                    break;

                case TK_INT16:
                    scdr << eprosima::fastcdr::MemberId(5) << data.int16_value();
                    break;

                case TK_UINT16:
                    scdr << eprosima::fastcdr::MemberId(6) << data.uint_16_value();
                    break;

                case TK_INT32:
                    scdr << eprosima::fastcdr::MemberId(7) << data.int32_value();
                    break;

                case TK_UINT32:
                    scdr << eprosima::fastcdr::MemberId(8) << data.uint32_value();
                    break;

                case TK_INT64:
                    scdr << eprosima::fastcdr::MemberId(9) << data.int64_value();
                    break;

                case TK_UINT64:
                    scdr << eprosima::fastcdr::MemberId(10) << data.uint64_value();
                    break;

                case TK_FLOAT32:
                    scdr << eprosima::fastcdr::MemberId(11) << data.float32_value();
                    break;

                case TK_FLOAT64:
                    scdr << eprosima::fastcdr::MemberId(12) << data.float64_value();
                    break;

                case TK_FLOAT128:
                    scdr << eprosima::fastcdr::MemberId(13) << data.float128_value();
                    break;

                case TK_CHAR8:
                    scdr << eprosima::fastcdr::MemberId(14) << data.char_value();
                    break;

                case TK_CHAR16:
                    scdr << eprosima::fastcdr::MemberId(15) << data.wchar_value();
                    break;

                case TK_ENUM:
                    scdr << eprosima::fastcdr::MemberId(16) << data.enumerated_value();
                    break;

                case TK_STRING8:
                    scdr << eprosima::fastcdr::MemberId(17) << data.string8_value();
                    break;

                case TK_STRING16:
                    scdr << eprosima::fastcdr::MemberId(18) << data.string16_value();
                    break;

                default:
                    scdr << eprosima::fastcdr::MemberId(19) << data.extended_value();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::AnnotationParameterValue& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    uint8_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case TK_BOOLEAN:
                                                    {
                                                        bool boolean_value_value{false};
                                                        data.boolean_value(std::move(boolean_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_BYTE:
                                                    {
                                                        uint8_t byte_value_value{0};
                                                        data.byte_value(std::move(byte_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_INT8:
                                                    {
                                                        int8_t int8_value_value{0};
                                                        data.int8_value(std::move(int8_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_UINT8:
                                                    {
                                                        uint8_t uint8_value_value{0};
                                                        data.uint8_value(std::move(uint8_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_INT16:
                                                    {
                                                        int16_t int16_value_value{0};
                                                        data.int16_value(std::move(int16_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_UINT16:
                                                    {
                                                        uint16_t uint_16_value_value{0};
                                                        data.uint_16_value(std::move(uint_16_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_INT32:
                                                    {
                                                        int32_t int32_value_value{0};
                                                        data.int32_value(std::move(int32_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_UINT32:
                                                    {
                                                        uint32_t uint32_value_value{0};
                                                        data.uint32_value(std::move(uint32_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_INT64:
                                                    {
                                                        int64_t int64_value_value{0};
                                                        data.int64_value(std::move(int64_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_UINT64:
                                                    {
                                                        uint64_t uint64_value_value{0};
                                                        data.uint64_value(std::move(uint64_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_FLOAT32:
                                                    {
                                                        float float32_value_value{0.0};
                                                        data.float32_value(std::move(float32_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_FLOAT64:
                                                    {
                                                        double float64_value_value{0.0};
                                                        data.float64_value(std::move(float64_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_FLOAT128:
                                                    {
                                                        long double float128_value_value{0.0};
                                                        data.float128_value(std::move(float128_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_CHAR8:
                                                    {
                                                        char char_value_value{0};
                                                        data.char_value(std::move(char_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_CHAR16:
                                                    {
                                                        wchar_t wchar_value_value{0};
                                                        data.wchar_value(std::move(wchar_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_ENUM:
                                                    {
                                                        int32_t enumerated_value_value{0};
                                                        data.enumerated_value(std::move(enumerated_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_STRING8:
                                                    {
                                                        eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN> string8_value_value;
                                                        data.string8_value(std::move(string8_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_STRING16:
                                                    {
                                                        std::wstring string16_value_value;
                                                        data.string16_value(std::move(string16_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                default:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::ExtendedAnnotationParameterValue extended_value_value;
                                                        data.extended_value(std::move(extended_value_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case TK_BOOLEAN:
                                                    dcdr >> data.boolean_value();
                                                    break;

                                                case TK_BYTE:
                                                    dcdr >> data.byte_value();
                                                    break;

                                                case TK_INT8:
                                                    dcdr >> data.int8_value();
                                                    break;

                                                case TK_UINT8:
                                                    dcdr >> data.uint8_value();
                                                    break;

                                                case TK_INT16:
                                                    dcdr >> data.int16_value();
                                                    break;

                                                case TK_UINT16:
                                                    dcdr >> data.uint_16_value();
                                                    break;

                                                case TK_INT32:
                                                    dcdr >> data.int32_value();
                                                    break;

                                                case TK_UINT32:
                                                    dcdr >> data.uint32_value();
                                                    break;

                                                case TK_INT64:
                                                    dcdr >> data.int64_value();
                                                    break;

                                                case TK_UINT64:
                                                    dcdr >> data.uint64_value();
                                                    break;

                                                case TK_FLOAT32:
                                                    dcdr >> data.float32_value();
                                                    break;

                                                case TK_FLOAT64:
                                                    dcdr >> data.float64_value();
                                                    break;

                                                case TK_FLOAT128:
                                                    dcdr >> data.float128_value();
                                                    break;

                                                case TK_CHAR8:
                                                    dcdr >> data.char_value();
                                                    break;

                                                case TK_CHAR16:
                                                    dcdr >> data.wchar_value();
                                                    break;

                                                case TK_ENUM:
                                                    dcdr >> data.enumerated_value();
                                                    break;

                                                case TK_STRING8:
                                                    dcdr >> data.string8_value();
                                                    break;

                                                case TK_STRING16:
                                                    dcdr >> data.string16_value();
                                                    break;

                                                default:
                                                    dcdr >> data.extended_value();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::AppliedAnnotationParameter& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.paramname_hash(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.value(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.paramname_hash()
        << eprosima::fastcdr::MemberId(1) << data.value()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::AppliedAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.paramname_hash();
                                            break;

                                        case 1:
                                                dcdr >> data.value();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.paramname_hash();

                        scdr << data.value();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::AppliedAnnotation& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.annotation_typeid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.param_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedAnnotation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.annotation_typeid()
        << eprosima::fastcdr::MemberId(1) << data.param_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::AppliedAnnotation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.annotation_typeid();
                                            break;

                                        case 1:
                                                dcdr >> data.param_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedAnnotation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.annotation_typeid();

                        if (data.param_seq().has_value())
                        {
                            scdr << data.param_seq().value();
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::AppliedVerbatimAnnotation& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.placement(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.language(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.text(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedVerbatimAnnotation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.placement()
        << eprosima::fastcdr::MemberId(1) << data.language()
        << eprosima::fastcdr::MemberId(2) << data.text()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::AppliedVerbatimAnnotation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.placement();
                                            break;

                                        case 1:
                                                dcdr >> data.language();
                                            break;

                                        case 2:
                                                dcdr >> data.text();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedVerbatimAnnotation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.placement();

                        scdr << data.language();

                        scdr << data.text();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::AppliedBuiltinMemberAnnotations& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.unit(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.min(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.max(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.hash_id(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedBuiltinMemberAnnotations& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.unit()
        << eprosima::fastcdr::MemberId(1) << data.min()
        << eprosima::fastcdr::MemberId(2) << data.max()
        << eprosima::fastcdr::MemberId(3) << data.hash_id()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::AppliedBuiltinMemberAnnotations& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.unit();
                                            break;

                                        case 1:
                                                dcdr >> data.min();
                                            break;

                                        case 2:
                                                dcdr >> data.max();
                                            break;

                                        case 3:
                                                dcdr >> data.hash_id();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedBuiltinMemberAnnotations& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        if (data.unit().has_value())
                        {
                            scdr << data.unit().value();
                        }

                        if (data.min().has_value())
                        {
                            scdr << data.min().value();
                        }

                        if (data.max().has_value())
                        {
                            scdr << data.max().value();
                        }

                        if (data.hash_id().has_value())
                        {
                            scdr << data.hash_id().value();
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonStructMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.member_id(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.member_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.member_type_id(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.member_id()
        << eprosima::fastcdr::MemberId(1) << data.member_flags()
        << eprosima::fastcdr::MemberId(2) << data.member_type_id()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.member_id();
                                            break;

                                        case 1:
                                                dcdr >> data.member_flags();
                                            break;

                                        case 2:
                                                dcdr >> data.member_type_id();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.member_id();

                        scdr << data.member_flags();

                        scdr << data.member_type_id();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.name(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.ann_builtin(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.ann_custom(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.name()
        << eprosima::fastcdr::MemberId(1) << data.ann_builtin()
        << eprosima::fastcdr::MemberId(2) << data.ann_custom()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.name();
                                            break;

                                        case 1:
                                                dcdr >> data.ann_builtin();
                                            break;

                                        case 2:
                                                dcdr >> data.ann_custom();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::AppliedBuiltinMemberAnnotations& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.name();

                        if (data.ann_builtin().has_value())
                        {
                            serialize_key(scdr, data.ann_builtin().value());
                        }

                        if (data.ann_custom().has_value())
                        {
                            scdr << data.ann_custom().value();
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.name_hash(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.name_hash()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.name_hash();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.name_hash();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteStructMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonStructMember& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalStructMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalStructMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonStructMember& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::AppliedBuiltinTypeAnnotations& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.verbatim(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedBuiltinTypeAnnotations& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.verbatim()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::AppliedBuiltinTypeAnnotations& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.verbatim();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::AppliedBuiltinTypeAnnotations& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::AppliedVerbatimAnnotation& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        if (data.verbatim().has_value())
                        {
                            serialize_key(scdr, data.verbatim().value());
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalTypeDetail& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalTypeDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalTypeDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalTypeDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.ann_builtin(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.ann_custom(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.type_name(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.ann_builtin()
        << eprosima::fastcdr::MemberId(1) << data.ann_custom()
        << eprosima::fastcdr::MemberId(2) << data.type_name()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.ann_builtin();
                                            break;

                                        case 1:
                                                dcdr >> data.ann_custom();
                                            break;

                                        case 2:
                                                dcdr >> data.type_name();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::AppliedBuiltinTypeAnnotations& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        if (data.ann_builtin().has_value())
                        {
                            serialize_key(scdr, data.ann_builtin().value());
                        }

                        if (data.ann_custom().has_value())
                        {
                            scdr << data.ann_custom().value();
                        }

                        scdr << data.type_name();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteStructHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.base_type(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteStructHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.base_type()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteStructHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.base_type();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteStructHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.base_type();

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalStructHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.base_type(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalStructHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.base_type()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalStructHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.base_type();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalStructHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.base_type();

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteStructType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.struct_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.member_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteStructType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.struct_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.member_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteStructType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.struct_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.member_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteStructType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteStructHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.struct_flags();

                        serialize_key(scdr, data.header());

                        scdr << data.member_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalStructType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.struct_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.member_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalStructType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.struct_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.member_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalStructType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.struct_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.member_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalStructType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalStructHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.struct_flags();

                        serialize_key(scdr, data.header());

                        scdr << data.member_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonUnionMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.member_id(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.member_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.type_id(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.label_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.member_id()
        << eprosima::fastcdr::MemberId(1) << data.member_flags()
        << eprosima::fastcdr::MemberId(2) << data.type_id()
        << eprosima::fastcdr::MemberId(3) << data.label_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.member_id();
                                            break;

                                        case 1:
                                                dcdr >> data.member_flags();
                                            break;

                                        case 2:
                                                dcdr >> data.type_id();
                                            break;

                                        case 3:
                                                dcdr >> data.label_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.member_id();

                        scdr << data.member_flags();

                        scdr << data.type_id();

                        scdr << data.label_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteUnionMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonUnionMember& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalUnionMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalUnionMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonUnionMember& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonDiscriminatorMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.member_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.type_id(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.member_flags()
        << eprosima::fastcdr::MemberId(1) << data.type_id()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.member_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.type_id();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.member_flags();

                        scdr << data.type_id();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteDiscriminatorMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.ann_builtin(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.ann_custom(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.ann_builtin()
        << eprosima::fastcdr::MemberId(2) << data.ann_custom()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.ann_builtin();
                                            break;

                                        case 2:
                                                dcdr >> data.ann_custom();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonDiscriminatorMember& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::AppliedBuiltinTypeAnnotations& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        if (data.ann_builtin().has_value())
                        {
                            serialize_key(scdr, data.ann_builtin().value());
                        }

                        if (data.ann_custom().has_value())
                        {
                            scdr << data.ann_custom().value();
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalDiscriminatorMember& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalDiscriminatorMember& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonDiscriminatorMember& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteUnionHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteUnionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteUnionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteUnionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalUnionHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalUnionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalUnionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalUnionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteUnionType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.union_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.discriminator(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.member_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteUnionType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.union_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.discriminator()
        << eprosima::fastcdr::MemberId(3) << data.member_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteUnionType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.union_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.discriminator();
                                            break;

                                        case 3:
                                                dcdr >> data.member_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteUnionType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteUnionHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteDiscriminatorMember& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.union_flags();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.discriminator());

                        scdr << data.member_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalUnionType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.union_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.discriminator(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.member_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalUnionType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.union_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.discriminator()
        << eprosima::fastcdr::MemberId(3) << data.member_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalUnionType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.union_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.discriminator();
                                            break;

                                        case 3:
                                                dcdr >> data.member_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalUnionType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalUnionHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalDiscriminatorMember& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.union_flags();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.discriminator());

                        scdr << data.member_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonAnnotationParameter& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.member_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.member_type_id(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.member_flags()
        << eprosima::fastcdr::MemberId(1) << data.member_type_id()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.member_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.member_type_id();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.member_flags();

                        scdr << data.member_type_id();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationParameter& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.name(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.default_value(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.name()
        << eprosima::fastcdr::MemberId(2) << data.default_value()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.name();
                                            break;

                                        case 2:
                                                dcdr >> data.default_value();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonAnnotationParameter& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        scdr << data.name();

                        scdr << data.default_value();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationParameter& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.name_hash(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.default_value(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.name_hash()
        << eprosima::fastcdr::MemberId(2) << data.default_value()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.name_hash();
                                            break;

                                        case 2:
                                                dcdr >> data.default_value();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationParameter& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonAnnotationParameter& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        scdr << data.name_hash();

                        scdr << data.default_value();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.annotation_name(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.annotation_name()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteAnnotationHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.annotation_name();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.annotation_name();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalAnnotationHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.annotation_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.member_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.annotation_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.member_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteAnnotationType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.annotation_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.member_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAnnotationType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteAnnotationHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.annotation_flag();

                        serialize_key(scdr, data.header());

                        scdr << data.member_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.annotation_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.member_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.annotation_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.member_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalAnnotationType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.annotation_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.member_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAnnotationType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalAnnotationHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.annotation_flag();

                        serialize_key(scdr, data.header());

                        scdr << data.member_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonAliasBody& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.related_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.related_type(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.related_flags()
        << eprosima::fastcdr::MemberId(1) << data.related_type()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.related_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.related_type();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.related_flags();

                        scdr << data.related_type();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteAliasBody& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.ann_builtin(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.ann_custom(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.ann_builtin()
        << eprosima::fastcdr::MemberId(2) << data.ann_custom()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.ann_builtin();
                                            break;

                                        case 2:
                                                dcdr >> data.ann_custom();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonAliasBody& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::AppliedBuiltinMemberAnnotations& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        if (data.ann_builtin().has_value())
                        {
                            serialize_key(scdr, data.ann_builtin().value());
                        }

                        if (data.ann_custom().has_value())
                        {
                            scdr << data.ann_custom().value();
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalAliasBody& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAliasBody& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonAliasBody& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteAliasHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAliasHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteAliasHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAliasHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalAliasHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAliasHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalAliasHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAliasHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteAliasType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.alias_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.body(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAliasType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.alias_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.body()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteAliasType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.alias_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.body();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteAliasType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteAliasHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteAliasBody& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.alias_flags();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.body());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalAliasType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.alias_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.body(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAliasType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.alias_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.body()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalAliasType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.alias_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.body();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalAliasType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalAliasHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalAliasBody& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.alias_flags();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.body());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteElementDetail& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.ann_builtin(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.ann_custom(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteElementDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.ann_builtin()
        << eprosima::fastcdr::MemberId(1) << data.ann_custom()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteElementDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.ann_builtin();
                                            break;

                                        case 1:
                                                dcdr >> data.ann_custom();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteElementDetail& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::AppliedBuiltinMemberAnnotations& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        if (data.ann_builtin().has_value())
                        {
                            serialize_key(scdr, data.ann_builtin().value());
                        }

                        if (data.ann_custom().has_value())
                        {
                            scdr << data.ann_custom().value();
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonCollectionElement& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.element_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.type(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.element_flags()
        << eprosima::fastcdr::MemberId(1) << data.type()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.element_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.type();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.element_flags();

                        scdr << data.type();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonCollectionElement& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteElementDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonCollectionElement& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonCollectionHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bound(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bound()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bound();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bound();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteCollectionHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonCollectionHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        if (data.detail().has_value())
                        {
                            serialize_key(scdr, data.detail().value());
                        }

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalCollectionHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalCollectionHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonCollectionHeader& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteSequenceType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.collection_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteSequenceType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.collection_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.element()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteSequenceType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.collection_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.element();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteSequenceType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteCollectionHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.collection_flag();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.element());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalSequenceType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.collection_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalSequenceType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.collection_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.element()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalSequenceType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.collection_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.element();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalSequenceType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalCollectionHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.collection_flag();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.element());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonArrayHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bound_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bound_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bound_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bound_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteArrayHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonArrayHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalArrayHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalArrayHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonArrayHeader& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteArrayType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.collection_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteArrayType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.collection_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.element()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteArrayType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.collection_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.element();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteArrayType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteArrayHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.collection_flag();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.element());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalArrayType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.collection_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.element(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalArrayType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.collection_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.element()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalArrayType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.collection_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.element();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalArrayType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalArrayHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.collection_flag();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.element());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteMapType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.collection_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.key(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.element(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteMapType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.collection_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.key()
        << eprosima::fastcdr::MemberId(3) << data.element()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteMapType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.collection_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.key();
                                            break;

                                        case 3:
                                                dcdr >> data.element();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteMapType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteCollectionHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteCollectionElement& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.collection_flag();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.key());

                        serialize_key(scdr, data.element());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalMapType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.collection_flag(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.key(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.element(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalMapType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.collection_flag()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.key()
        << eprosima::fastcdr::MemberId(3) << data.element()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalMapType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.collection_flag();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.key();
                                            break;

                                        case 3:
                                                dcdr >> data.element();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalMapType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalCollectionHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalCollectionElement& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.collection_flag();

                        serialize_key(scdr, data.header());

                        serialize_key(scdr, data.key());

                        serialize_key(scdr, data.element());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonEnumeratedLiteral& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.flags(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value()
        << eprosima::fastcdr::MemberId(1) << data.flags()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value();
                                            break;

                                        case 1:
                                                dcdr >> data.flags();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.value();

                        scdr << data.flags();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedLiteral& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonEnumeratedLiteral& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedLiteral& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedLiteral& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonEnumeratedLiteral& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonEnumeratedHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bit_bound(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bit_bound()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bit_bound();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bit_bound();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonEnumeratedHeader& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonEnumeratedHeader& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.enum_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.literal_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.enum_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.literal_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteEnumeratedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.enum_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.literal_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteEnumeratedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteEnumeratedHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.enum_flags();

                        serialize_key(scdr, data.header());

                        scdr << data.literal_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.enum_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.literal_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.enum_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.literal_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalEnumeratedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.enum_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.literal_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalEnumeratedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalEnumeratedHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.enum_flags();

                        serialize_key(scdr, data.header());

                        scdr << data.literal_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonBitflag& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.position(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.flags(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.position()
        << eprosima::fastcdr::MemberId(1) << data.flags()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.position();
                                            break;

                                        case 1:
                                                dcdr >> data.flags();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.position();

                        scdr << data.flags();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteBitflag& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonBitflag& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalBitflag& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitflag& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonBitflag& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonBitmaskHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bit_bound(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonBitmaskHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bit_bound()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonBitmaskHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bit_bound();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonBitmaskHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bit_bound();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteBitmaskType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bitmask_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.flag_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitmaskType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bitmask_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.flag_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteBitmaskType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bitmask_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.flag_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitmaskType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bitmask_flags();

                        scdr << data.header();

                        scdr << data.flag_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalBitmaskType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bitmask_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.flag_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitmaskType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bitmask_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.flag_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalBitmaskType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bitmask_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.flag_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitmaskType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bitmask_flags();

                        scdr << data.header();

                        scdr << data.flag_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CommonBitfield& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.position(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.bitcount(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.holder_type(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.position()
        << eprosima::fastcdr::MemberId(1) << data.flags()
        << eprosima::fastcdr::MemberId(2) << data.bitcount()
        << eprosima::fastcdr::MemberId(3) << data.holder_type()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CommonBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.position();
                                            break;

                                        case 1:
                                                dcdr >> data.flags();
                                            break;

                                        case 2:
                                                dcdr >> data.bitcount();
                                            break;

                                        case 3:
                                                dcdr >> data.holder_type();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CommonBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.position();

                        scdr << data.flags();

                        scdr << data.bitcount();

                        scdr << data.holder_type();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteBitfield& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonBitfield& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteMemberDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalBitfield& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.common(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.name_hash(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.common()
        << eprosima::fastcdr::MemberId(1) << data.name_hash()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.common();
                                            break;

                                        case 1:
                                                dcdr >> data.name_hash();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitfield& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CommonBitfield& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.common());

                        scdr << data.name_hash();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteBitsetHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.detail(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitsetHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.detail()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteBitsetHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.detail();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitsetHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteTypeDetail& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.detail());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalBitsetHeader& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitsetHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalBitsetHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitsetHeader& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteBitsetType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bitset_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.field_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitsetType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bitset_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.field_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteBitsetType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bitset_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.field_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteBitsetType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::CompleteBitsetHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bitset_flags();

                        serialize_key(scdr, data.header());

                        scdr << data.field_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalBitsetType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.bitset_flags(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.header(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.field_seq(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitsetType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.bitset_flags()
        << eprosima::fastcdr::MemberId(1) << data.header()
        << eprosima::fastcdr::MemberId(2) << data.field_seq()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalBitsetType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.bitset_flags();
                                            break;

                                        case 1:
                                                dcdr >> data.header();
                                            break;

                                        case 2:
                                                dcdr >> data.field_seq();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalBitsetType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::MinimalBitsetHeader& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.bitset_flags();

                        serialize_key(scdr, data.header());

                        scdr << data.field_seq();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteExtendedType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteExtendedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteExtendedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteExtendedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::CompleteTypeObject& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case TK_ALIAS:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.alias_type(), current_alignment);
                    break;

                case TK_ANNOTATION:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.annotation_type(), current_alignment);
                    break;

                case TK_STRUCTURE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                                data.struct_type(), current_alignment);
                    break;

                case TK_UNION:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                                data.union_type(), current_alignment);
                    break;

                case TK_BITSET:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                                data.bitset_type(), current_alignment);
                    break;

                case TK_SEQUENCE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                                data.sequence_type(), current_alignment);
                    break;

                case TK_ARRAY:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                                data.array_type(), current_alignment);
                    break;

                case TK_MAP:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                                data.map_type(), current_alignment);
                    break;

                case TK_ENUM:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                                data.enumerated_type(), current_alignment);
                    break;

                case TK_BITMASK:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                                data.bitmask_type(), current_alignment);
                    break;

                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                                data.extended_type(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::CompleteTypeObject& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case TK_ALIAS:
                    scdr << eprosima::fastcdr::MemberId(1) << data.alias_type();
                    break;

                case TK_ANNOTATION:
                    scdr << eprosima::fastcdr::MemberId(2) << data.annotation_type();
                    break;

                case TK_STRUCTURE:
                    scdr << eprosima::fastcdr::MemberId(3) << data.struct_type();
                    break;

                case TK_UNION:
                    scdr << eprosima::fastcdr::MemberId(4) << data.union_type();
                    break;

                case TK_BITSET:
                    scdr << eprosima::fastcdr::MemberId(5) << data.bitset_type();
                    break;

                case TK_SEQUENCE:
                    scdr << eprosima::fastcdr::MemberId(6) << data.sequence_type();
                    break;

                case TK_ARRAY:
                    scdr << eprosima::fastcdr::MemberId(7) << data.array_type();
                    break;

                case TK_MAP:
                    scdr << eprosima::fastcdr::MemberId(8) << data.map_type();
                    break;

                case TK_ENUM:
                    scdr << eprosima::fastcdr::MemberId(9) << data.enumerated_type();
                    break;

                case TK_BITMASK:
                    scdr << eprosima::fastcdr::MemberId(10) << data.bitmask_type();
                    break;

                default:
                    scdr << eprosima::fastcdr::MemberId(11) << data.extended_type();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::CompleteTypeObject& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    uint8_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case TK_ALIAS:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteAliasType alias_type_value;
                                                        data.alias_type(std::move(alias_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_ANNOTATION:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteAnnotationType annotation_type_value;
                                                        data.annotation_type(std::move(annotation_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_STRUCTURE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteStructType struct_type_value;
                                                        data.struct_type(std::move(struct_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_UNION:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteUnionType union_type_value;
                                                        data.union_type(std::move(union_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_BITSET:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteBitsetType bitset_type_value;
                                                        data.bitset_type(std::move(bitset_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_SEQUENCE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteSequenceType sequence_type_value;
                                                        data.sequence_type(std::move(sequence_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_ARRAY:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteArrayType array_type_value;
                                                        data.array_type(std::move(array_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_MAP:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteMapType map_type_value;
                                                        data.map_type(std::move(map_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_ENUM:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteEnumeratedType enumerated_type_value;
                                                        data.enumerated_type(std::move(enumerated_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_BITMASK:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteBitmaskType bitmask_type_value;
                                                        data.bitmask_type(std::move(bitmask_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                default:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteExtendedType extended_type_value;
                                                        data.extended_type(std::move(extended_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case TK_ALIAS:
                                                    dcdr >> data.alias_type();
                                                    break;

                                                case TK_ANNOTATION:
                                                    dcdr >> data.annotation_type();
                                                    break;

                                                case TK_STRUCTURE:
                                                    dcdr >> data.struct_type();
                                                    break;

                                                case TK_UNION:
                                                    dcdr >> data.union_type();
                                                    break;

                                                case TK_BITSET:
                                                    dcdr >> data.bitset_type();
                                                    break;

                                                case TK_SEQUENCE:
                                                    dcdr >> data.sequence_type();
                                                    break;

                                                case TK_ARRAY:
                                                    dcdr >> data.array_type();
                                                    break;

                                                case TK_MAP:
                                                    dcdr >> data.map_type();
                                                    break;

                                                case TK_ENUM:
                                                    dcdr >> data.enumerated_type();
                                                    break;

                                                case TK_BITMASK:
                                                    dcdr >> data.bitmask_type();
                                                    break;

                                                default:
                                                    dcdr >> data.extended_type();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalExtendedType& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalExtendedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalExtendedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalExtendedType& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::MinimalTypeObject& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case TK_ALIAS:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.alias_type(), current_alignment);
                    break;

                case TK_ANNOTATION:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.annotation_type(), current_alignment);
                    break;

                case TK_STRUCTURE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                                data.struct_type(), current_alignment);
                    break;

                case TK_UNION:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                                data.union_type(), current_alignment);
                    break;

                case TK_BITSET:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                                data.bitset_type(), current_alignment);
                    break;

                case TK_SEQUENCE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                                data.sequence_type(), current_alignment);
                    break;

                case TK_ARRAY:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                                data.array_type(), current_alignment);
                    break;

                case TK_MAP:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                                data.map_type(), current_alignment);
                    break;

                case TK_ENUM:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                                data.enumerated_type(), current_alignment);
                    break;

                case TK_BITMASK:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                                data.bitmask_type(), current_alignment);
                    break;

                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                                data.extended_type(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::MinimalTypeObject& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case TK_ALIAS:
                    scdr << eprosima::fastcdr::MemberId(1) << data.alias_type();
                    break;

                case TK_ANNOTATION:
                    scdr << eprosima::fastcdr::MemberId(2) << data.annotation_type();
                    break;

                case TK_STRUCTURE:
                    scdr << eprosima::fastcdr::MemberId(3) << data.struct_type();
                    break;

                case TK_UNION:
                    scdr << eprosima::fastcdr::MemberId(4) << data.union_type();
                    break;

                case TK_BITSET:
                    scdr << eprosima::fastcdr::MemberId(5) << data.bitset_type();
                    break;

                case TK_SEQUENCE:
                    scdr << eprosima::fastcdr::MemberId(6) << data.sequence_type();
                    break;

                case TK_ARRAY:
                    scdr << eprosima::fastcdr::MemberId(7) << data.array_type();
                    break;

                case TK_MAP:
                    scdr << eprosima::fastcdr::MemberId(8) << data.map_type();
                    break;

                case TK_ENUM:
                    scdr << eprosima::fastcdr::MemberId(9) << data.enumerated_type();
                    break;

                case TK_BITMASK:
                    scdr << eprosima::fastcdr::MemberId(10) << data.bitmask_type();
                    break;

                default:
                    scdr << eprosima::fastcdr::MemberId(11) << data.extended_type();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::MinimalTypeObject& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    uint8_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case TK_ALIAS:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalAliasType alias_type_value;
                                                        data.alias_type(std::move(alias_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_ANNOTATION:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalAnnotationType annotation_type_value;
                                                        data.annotation_type(std::move(annotation_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_STRUCTURE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalStructType struct_type_value;
                                                        data.struct_type(std::move(struct_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_UNION:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalUnionType union_type_value;
                                                        data.union_type(std::move(union_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_BITSET:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalBitsetType bitset_type_value;
                                                        data.bitset_type(std::move(bitset_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_SEQUENCE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalSequenceType sequence_type_value;
                                                        data.sequence_type(std::move(sequence_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_ARRAY:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalArrayType array_type_value;
                                                        data.array_type(std::move(array_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_MAP:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalMapType map_type_value;
                                                        data.map_type(std::move(map_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_ENUM:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalEnumeratedType enumerated_type_value;
                                                        data.enumerated_type(std::move(enumerated_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case TK_BITMASK:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalBitmaskType bitmask_type_value;
                                                        data.bitmask_type(std::move(bitmask_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                default:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalExtendedType extended_type_value;
                                                        data.extended_type(std::move(extended_type_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case TK_ALIAS:
                                                    dcdr >> data.alias_type();
                                                    break;

                                                case TK_ANNOTATION:
                                                    dcdr >> data.annotation_type();
                                                    break;

                                                case TK_STRUCTURE:
                                                    dcdr >> data.struct_type();
                                                    break;

                                                case TK_UNION:
                                                    dcdr >> data.union_type();
                                                    break;

                                                case TK_BITSET:
                                                    dcdr >> data.bitset_type();
                                                    break;

                                                case TK_SEQUENCE:
                                                    dcdr >> data.sequence_type();
                                                    break;

                                                case TK_ARRAY:
                                                    dcdr >> data.array_type();
                                                    break;

                                                case TK_MAP:
                                                    dcdr >> data.map_type();
                                                    break;

                                                case TK_ENUM:
                                                    dcdr >> data.enumerated_type();
                                                    break;

                                                case TK_BITMASK:
                                                    dcdr >> data.bitmask_type();
                                                    break;

                                                default:
                                                    dcdr >> data.extended_type();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeObject& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case EK_COMPLETE:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.complete(), current_alignment);
                    break;

                case EK_MINIMAL:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.minimal(), current_alignment);
                    break;

        default:
            break;
    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeObject& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case EK_COMPLETE:
                    scdr << eprosima::fastcdr::MemberId(1) << data.complete();
                    break;

                case EK_MINIMAL:
                    scdr << eprosima::fastcdr::MemberId(2) << data.minimal();
                    break;

        default:
            break;
    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeObject& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    uint8_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case EK_COMPLETE:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::CompleteTypeObject complete_value;
                                                        data.complete(std::move(complete_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EK_MINIMAL:
                                                    {
                                                        eprosima::fastdds::dds::xtypes::MinimalTypeObject minimal_value;
                                                        data.minimal(std::move(minimal_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                        default:
                            data._default();
                            break;
                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case EK_COMPLETE:
                                                    dcdr >> data.complete();
                                                    break;

                                                case EK_MINIMAL:
                                                    dcdr >> data.minimal();
                                                    break;

                        default:
                            break;
                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.type_identifier(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.type_object(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.type_identifier()
        << eprosima::fastcdr::MemberId(1) << data.type_object()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.type_identifier();
                                            break;

                                        case 1:
                                                dcdr >> data.type_object();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.type_identifier();

                        scdr << data.type_object();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierPair& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.type_identifier1(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.type_identifier2(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierPair& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.type_identifier1()
        << eprosima::fastcdr::MemberId(1) << data.type_identifier2()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeIdentifierPair& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.type_identifier1();
                                            break;

                                        case 1:
                                                dcdr >> data.type_identifier2();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierPair& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.type_identifier1();

                        scdr << data.type_identifier2();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.type_id(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.typeobject_serialized_size(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.type_id()
        << eprosima::fastcdr::MemberId(1) << data.typeobject_serialized_size()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.type_id();
                                            break;

                                        case 1:
                                                dcdr >> data.typeobject_serialized_size();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.type_id();

                        scdr << data.typeobject_serialized_size();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierWithDependencies& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.typeid_with_size(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.dependent_typeid_count(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.dependent_typeids(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierWithDependencies& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.typeid_with_size()
        << eprosima::fastcdr::MemberId(1) << data.dependent_typeid_count()
        << eprosima::fastcdr::MemberId(2) << data.dependent_typeids()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeIdentifierWithDependencies& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.typeid_with_size();
                                            break;

                                        case 1:
                                                dcdr >> data.dependent_typeid_count();
                                            break;

                                        case 2:
                                                dcdr >> data.dependent_typeids();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeIdentifierWithDependencies& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize& data);




    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.typeid_with_size());

                        scdr << data.dependent_typeid_count();

                        scdr << data.dependent_typeids();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::dds::xtypes::TypeInformation& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::dds::xtypes;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00001001),
                data.minimal(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00001002),
                data.complete(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeInformation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00001001) << data.minimal()
        << eprosima::fastcdr::MemberId(0x00001002) << data.complete()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::dds::xtypes::TypeInformation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00001001:
                                                dcdr >> data.minimal();
                                            break;

                                        case 0x00001002:
                                                dcdr >> data.complete();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::dds::xtypes::TypeInformation& data)
{
    using namespace eprosima::fastdds::dds::xtypes;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::TypeIdentifierWithDependencies& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::dds::xtypes::TypeIdentifierWithDependencies& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.minimal());

                        serialize_key(scdr, data.complete());

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__DDS_XTYPES_TYPEOBJECTCDRAUX_IPP

