/*******************************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object external()
  * @type external
  * @super Object
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535246.aspx
*/

function external(){};
external.prototype= new Object();
/**
  * Property frozen
  * @type Boolean
  * @returns {Boolean}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342516.aspx
*/

external.prototype.frozen=false;
/**
  * Property menuArguments
  * @type Object
  * @returns {Object}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534165.aspx
*/

external.prototype.menuArguments=new Object();
/**
  * Property onvisibilitychange
  * @type Object
  * @returns {Object}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342517.aspx
*/

external.prototype.onvisibilitychange=new Object();
/**
  * Property scrollbar
  * @type Boolean
  * @returns {Boolean}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342519.aspx
*/

external.prototype.scrollbar=false;
/**
  * Property selectableContent
  * @type Boolean
  * @returns {Boolean}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342520.aspx
*/

external.prototype.selectableContent=false;
/**
  * Property version
  * @type String
  * @returns {String}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342522.aspx
*/

external.prototype.version="";
/**
  * Property visibility
  * @type Boolean
  * @returns {Boolean}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342523.aspx
*/

external.prototype.visibility=false;
/**
  * function AddChannel(sURLToCDF)
  * @param {String} sURLToCDF
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535923.aspx
*/

external.prototype.AddChannel=function(sURLToCDF){};
/**
  * function AddChannel(sURLToCDF)
  * @param {String} sURLToCDF
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535923.aspx
*/

external.prototype.AddChannel=function(sURLToCDF){};
/**
  * function AddDesktopComponent(sURL,sType,iLeft,iTop,iWidth,iHeight)
  * @param {String} sURL
  * @param {String} sType
  * @param {Number} iLeft
  * @param {Number} iTop
  * @param {Number} iWidth
  * @param {Number} iHeight
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535924.aspx
*/

external.prototype.AddDesktopComponent=function(sURL,sType,iLeft,iTop,iWidth,iHeight){};
/**
  * function AddFavorite(sURL,sTitle)
  * @param {String} sURL
  * @param {String} sTitle
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535926.aspx
*/

external.prototype.AddFavorite=function(sURL,sTitle){};
/**
  * function AddSearchProvider(sUrl)
  * @param {AddSearchProvider} sUrl
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535931.aspx
*/

external.prototype.AddSearchProvider=function(sUrl){};
/**
  * function AutoCompleteSaveForm(oForm)
  * @param {Object} oForm
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536344.aspx
*/

external.prototype.AutoCompleteSaveForm=function(oForm){};
/**
  * function AutoScan(sUserQuery,sURL,sTarget)
  * @param {String} sUserQuery
  * @param {String} sURL
  * @param {String} sTarget
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536345.aspx
*/

external.prototype.AutoScan=function(sUserQuery,sURL,sTarget){};
/**
  * function BrandImageUri()
  * @type String
  * @returns {String}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536348.aspx
*/

external.prototype.BrandImageUri=function(){};
/**
  * function bubbleEvent()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342525.aspx
*/

external.prototype.bubbleEvent=function(){};
/**
  * function CustomizeClearType(fSet)
  * @param {CustomizeClearType} fSet
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/bb245715.aspx
*/

external.prototype.CustomizeClearType=function(fSet){};
/**
  * function CustomizeSettings(fSQM,fPhishing,sLocale)
  * @param {Boolean} fSQM
  * @param {Boolean} fPhishing
  * @param {String} sLocale
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536404.aspx
*/

external.prototype.CustomizeSettings=function(fSQM,fPhishing,sLocale){};
/**
  * function DefaultSearchProvider()
  * @type String
  * @returns {String}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/bb245716.aspx
*/

external.prototype.DefaultSearchProvider=function(){};
/**
  * function DiagnoseConnection()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/bb245717.aspx
*/

external.prototype.DiagnoseConnection=function(){};
/**
  * function ImportExportFavorites(bImportExport,sImportExportPath)
  * @param {Boolean} bImportExport
  * @param {String} sImportExportPath
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536449.aspx
*/

external.prototype.ImportExportFavorites=function(bImportExport,sImportExportPath){};
/**
  * function IsSearchMigrated()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/bb245718.aspx
*/

external.prototype.IsSearchMigrated=function(){};
/**
  * function IsSearchProviderInstalled(sUrl)
  * @param {IsSearchProviderInstalled} sUrl
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342526.aspx
*/

external.prototype.IsSearchProviderInstalled=function(sUrl){};
/**
  * function IsSubscribed(sURLToCDF)
  * @param {String} sURLToCDF
  * @type Boolean
  * @returns {Boolean}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536459.aspx
*/

external.prototype.IsSubscribed=function(sURLToCDF){};
/**
  * function NavigateAndFind(sLocation,sQuery,sTargetFrame)
  * @param {String} sLocation
  * @param {String} sQuery
  * @param {String} sTargetFrame
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536641.aspx
*/

external.prototype.NavigateAndFind=function(sLocation,sQuery,sTargetFrame){};
/**
  * function PhishingEnabled()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536658.aspx
*/

external.prototype.PhishingEnabled=function(){};
/**
  * function raiseEvent(name,eventData)
  * @param {Required.} name				Specifies a valid event name as a string.
  * @param {Required.} eventData				Specifies event data.
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342527.aspx
*/

external.prototype.raiseEvent=function(name,eventData){};
/**
  * function RunOnceHasShown()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/bb245719.aspx
*/

external.prototype.RunOnceHasShown=function(){};
/**
  * function RunOnceShown()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536725.aspx
*/

external.prototype.RunOnceShown=function(){};
/**
  * function SearchGuideUrl()
  * @type String
  * @returns {String}
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/bb245721.aspx
*/

external.prototype.SearchGuideUrl=function(){};
/**
  * function setContextMenu(menuItemPairs)
  * @param {Required.} menuItemPairs				Specifies menu item pairs, which are command text and commands contained within the context menu.
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342529.aspx
*/

external.prototype.setContextMenu=function(menuItemPairs){};
/**
  * function ShowBrowserUI(sUI,null)
  * @param {String} sUI
  * @param {ShowBrowserUI} showerBrowserUI
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536756.aspx
*/

external.prototype.ShowBrowserUI=function(sUI,showerBrowserUI){};
/**
  * function SkipRunOnce()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536763.aspx
*/

external.prototype.SkipRunOnce=function(){};
/**
  * function SkipTabsWelcome()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa342530.aspx
*/

external.prototype.SkipTabsWelcome=function(){};
/**
  * function SqmEnabled()
  * @memberOf external
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536766.aspx
*/

external.prototype.SqmEnabled=function(){};
