/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _PNG_EXPORT_CODEC_H_
#define _PNG_EXPORT_CODEC_H_

#include "ExportCodec.h"

class PngExportCodec : public ExportCodec {
  public:
    PngExportCodec();
    virtual ~PngExportCodec();
    virtual void fillProcessingOptions( ProcessingOptions* processingOptions ) const;
    virtual void setProcessingOptions( const ProcessingOptions& _processingOptions ) const;
    virtual bool writeFile( RawImageInfoSP rawImageInfo, const QString& _fileName, const QByteArray& _data, int width, int height, const ProcessingOptions& processingOptions );
  private:
    struct Private;
    Private* const d;
};

#endif
