package definitions

func init() {
	add(`EditProxy`, &defEditProxy{})
}

type defEditProxy struct{}

func (*defEditProxy) String() string {
	return `<interface>
  <object class="GtkDialog" id="EditProxy">
    <property name="title" translatable="yes">Edit Proxy</property>
    <property name="modal">True</property>
    <signal name="close" handler="on_cancel_signal" />
    <child internal-child="vbox">
      <object class="GtkBox" id="box">
        <property name="margin">10</property>
        <child>
          <object class="GtkGrid" id="grid">
            <property name="visible">true</property>
            <property name="margin-bottom">10</property>
            <property name="row-spacing">12</property>
            <property name="column-spacing">6</property>
            <child>
              <object class="GtkLabel" id="typeLabel">
                <property name="label" translatable="yes">Proxy type:</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">0</property>
              </packing>
            </child>
            <child>
              <object class="GtkComboBoxText" id="protocol-type">
                <items>
                </items>
                <signal name="changed" handler="on_protocol_type_changed" swapped="no"/>
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">0</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="userLabel">
                <property name="label" translatable="yes">User:</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">1</property>
              </packing>
            </child>
            <child>
              <object class="GtkEntry" id="user">
                <signal name="activate" handler="on_save_signal" />
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">1</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="passLabel">
                <property name="label" translatable="yes">Password:</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">2</property>
              </packing>
            </child>
            <child>
              <object class="GtkEntry" id="password">
                <property name="visibility">false</property>
                <signal name="activate" handler="on_save_signal" />
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">2</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="serverLabel">
                <property name="label" translatable="yes">Server:</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">3</property>
              </packing>
            </child>
            <child>
              <object class="GtkEntry" id="server">
                <signal name="activate" handler="on_save_signal" />
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">3</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="portLabel">
                <property name="label" translatable="yes">Port:</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">4</property>
              </packing>
            </child>
            <child>
              <object class="GtkEntry" id="port">
                <signal name="activate" handler="on_save_signal" />
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">4</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="pathLabel">
                <property name="label" translatable="yes">Path:</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">5</property>
              </packing>
            </child>
            <child>
              <object class="GtkEntry" id="path">
                <signal name="activate" handler="on_save_signal" />
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">5</property>
              </packing>
            </child>
          </object>
        </child>

        <child internal-child="action_area">
          <object class="GtkButtonBox" id="button_box">
            <property name="orientation">GTK_ORIENTATION_HORIZONTAL</property>
            <child>
              <object class="GtkButton" id="cancel">
                <property name="label" translatable="yes">Cancel</property>
                <signal name="clicked" handler="on_cancel_signal"/>
              </object>
            </child>
            <child>
              <object class="GtkButton" id="save">
                <property name="label" translatable="yes">Save</property>
                <property name="can-default">true</property>
                <signal name="clicked" handler="on_save_signal"/>
              </object>
            </child>
          </object>
        </child>
      </object>
    </child>
  </object>
</interface>
`
}
