# CiviCRM 5.29.0

Released September 2, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Contact export is very slow, creates huge temporary tables
  ([dev/core#1725](https://lab.civicrm.org/dev/core/-/issues/1725):
  [17458](https://github.com/civicrm/civicrm-core/pull/17458))**

  Improves performance when exporting contacts by only exporting primary address
  fields.

- **Allow different output formats for CiviReport results, like native excel
  format, and untangle code
  ([dev/core#1855](https://lab.civicrm.org/dev/core/-/issues/1855):
  [17901](https://github.com/civicrm/civicrm-core/pull/17901))**

  This makes it possible to extend CiviReport by reworking the PDF and CSV
  generation code as new output handlers, and allowing for extension developers
  to add new ones.

- **Icon in status message after saving a civireport is misleading
  ([dev/report#43](https://lab.civicrm.org/dev/report/-/issues/43):
  [17863](https://github.com/civicrm/civicrm-core/pull/17863))**

  Improves icons in Status Messages for reports.

- **Show cron warning on Scheduled Jobs admin page
  ([18065](https://github.com/civicrm/civicrm-core/pull/18065))**

  A pop-up message will appear on the Scheduled Jobs page if cron has not been
  running.

- **Add APIv4 and pseudoconstants for RelationshipCache
  ()**

- **RelationshipCache - Add a high-level index to facilitate relationship
  queries (more fields)
  ([17781](https://github.com/civicrm/civicrm-core/pull/17781) and
  [17879](https://github.com/civicrm/civicrm-core/pull/17879))**

  A new table caches relationships to provide a single resource for tracking
  relationships from a specified contact's perspective.  The RelationshipCache
  records the "near" and "far" contacts and relationship names along with the
  orientation and relationship type.  Each record from `civicrm_relationship`
  will have two records in `civicrm_relationship_cache`, one for each
  orientation.

- **Remove ORDER BY and GROUP BY from alphabetQuery to improve performance
  ([16877](https://github.com/civicrm/civicrm-core/pull/16877))**

- **Differentiate smart group from regular group using icon in select2 field
  ([dev/core#785](https://lab.civicrm.org/dev/core/-/issues/785):
  [17927](https://github.com/civicrm/civicrm-core/pull/17927))**

  Improves Group's select2 by adding icon next to smart groups.

- **Feature: Ability to enable SSL for database connection.
  ([dev/core#1137](https://lab.civicrm.org/dev/core/-/issues/1137):
  [17706](https://github.com/civicrm/civicrm-core/pull/17706))**

  Makes it so sites can use ssl to connect to mysql.

- **Add in hook to allow for altering of Profile Schemas
  ([dev/core#1913](https://lab.civicrm.org/dev/core/-/issues/1913):
  [17986](https://github.com/civicrm/civicrm-core/pull/17986))**

  Extensions that allow additional fields to be added to profiles can now add
  schemas so that fields can be added from new entities.

- **Why not make the buttons flat?
  ([18054](https://github.com/civicrm/civicrm-core/pull/18054))**

  Buttons no longer have a gradient background.

- **SystemCheck: add ability to efficiently run only specified checks
  ([17824](https://github.com/civicrm/civicrm-core/pull/17824))**

  The APIv4 system check action can now filter on name, running just the
  specified check(s).

- **Change inform-icon to fa-info-circle
  ([18001](https://github.com/civicrm/civicrm-core/pull/18001))**

  The information icon is now produced with Font Awesome rather than a sprite.

- **APIv4 - Add keyword to select all custom fields
  ([17955](https://github.com/civicrm/civicrm-core/pull/17955))**

  You can now use a wildcard to select all custom fields on an entity without
  specifying each individually.

- **Improve caching of current domain
  ([17916](https://github.com/civicrm/civicrm-core/pull/17916))**

  Domain information is now cached in one central place, making it more
  straightforward to use and flush.

- **APIv4 - Specify BridgeEntities to assist with joins
  ([17808](https://github.com/civicrm/civicrm-core/pull/17808))**

  Minor entities that intermediate many-to-many relationships are now specified
  as bridge entities and extend from a new base class.  This will allow them to
  be distinguished better in the future.

- **APIv4 - Add shorthand for setCheckPermissions()
  ([17834](https://github.com/civicrm/civicrm-core/pull/17834) and
  [17874](https://github.com/civicrm/civicrm-core/pull/17874))**

  The CRUD functions of APIv4 now accept a boolean argument that corresponds to
  the value sent to `setCheckPermissions()`.  This provides a shorthand for a
  very common use case.

- **Add search extension
  ([17775](https://github.com/civicrm/civicrm-core/pull/17775),
  [17789](https://github.com/civicrm/civicrm-core/pull/17789), and
  [17864](https://github.com/civicrm/civicrm-core/pull/17864))**

  An extension that replaces Search Builder is now shipped with core, though it
  is hidden from the extensions user interface because it is currently
  incompatible with the default theming framework.

### CiviContribute

- **Add configure and priceset url icons on public contribution & event pages
  ([dev/core#1905](https://lab.civicrm.org/dev/core/-/issues/1905):
  [17942](https://github.com/civicrm/civicrm-core/pull/17942),
  [18088](https://github.com/civicrm/civicrm-core/pull/18088) and
  [18064](https://github.com/civicrm/civicrm-core/pull/18064))**

  A "Configure" button now appears to administrators when viewing a contribution
  page or event, or a priceset within either, from the frontend.  This links to
  the corresponding form to administer the contribution page, event, or
  priceset.

### CiviEvent

- **Move Event Cart to extension
  ([17741](https://github.com/civicrm/civicrm-core/pull/17741),
  [17743](https://github.com/civicrm/civicrm-core/pull/17743),
  [17861](https://github.com/civicrm/civicrm-core/pull/17861),
  [17884](https://github.com/civicrm/civicrm-core/pull/17884),
  [17885](https://github.com/civicrm/civicrm-core/pull/17885), and
  [17891](https://github.com/civicrm/civicrm-core/pull/17891))**

  The event cart features have been moved to a separate extension that is
  shipped with core.

### CiviMember

- **Option to update expired memberships as part of the job.process_membership
  ([dev/membership#18](https://lab.civicrm.org/dev/membership/-/issues/18):
  [16298](https://github.com/civicrm/civicrm-core/pull/16298))**

  Improves the Job.process_membership API/Scheduled job by adding some new
  parameters, specifically:

    - exclude_test_memberships: Exclude test memberships from calculations
      (default = TRUE)
    - only_active_membership_types: Exclude disabled membership types from
      calculations (default = TRUE)
    - exclude_membership_status_ids: Default: Exclude Pending, Cancelled,
      Expired.

  Deceased will always be excluded

-  **Add auto-renew status to membership detail report
  ([17683](https://github.com/civicrm/civicrm-core/pull/17683) and
  [17911](https://github.com/civicrm/civicrm-core/pull/17911))**

  The membership detail report can now display and filter on the auto-renew
  status of each membership.

### Backdrop Integration

- **Support for installing CiviCRM-Backdrop via "setup" UI
  ([17749](https://github.com/civicrm/civicrm-core/pull/17749) and
  [121](https://github.com/civicrm/civicrm-backdrop/pull/121))**

  Improves the installation and Setup process for Backdrop integration's so that
  one enables the CiviCRM module like any other module and then is directed to
  the setup screen to complete installation as opposed to having to navigate to
  a specific link.

### Drupal Integration

- **Upgrading a site that still has "mysql" in the dsn string breaks in latest
  master ([dev/core#1937](https://lab.civicrm.org/dev/core/-/issues/1937):
  [18174](https://github.com/civicrm/civicrm-core/pull/18174))**

  This adds an upgrade message for 5.29.0 warning that Composer patching will
  need to be enabled before upgrading to 5.30.0 or higher.

  The "mysql" in the DSN (as opposed to "mysqli") will not be a problem, but the
  solution for this is in a package patch that appears in 5.30.

- **Installation - Support "activate first" w/setup UI
  ([606](https://github.com/civicrm/civicrm-drupal/pull/606))**

  The new setup user interface for Backdrop and WordPress installations is now
  available for Drupal 7.

### WordPress Integration

- **Add system check to ensure WP base page exists
  ([17698](https://github.com/civicrm/civicrm-core/pull/17698))**

  A new system check will display a message if the base page, as set in CiviCRM,
  doesn't match an existing page in WordPress.  No message will display if
  WordPress multisite is enabled.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **CRM_Dedupe_Finder parses phone key incorrectly
  ([dev/core#1767](https://lab.civicrm.org/dev/core/-/issues/1767):
  [17361](https://github.com/civicrm/civicrm-core/pull/17361) and
  [17882](https://github.com/civicrm/civicrm-core/pull/17882))**

  The process to match duplicate contacts was not accurately identifying phone
  fields, causing contacts with matching phone numbers to be treated as if they
  didn't match.

- **Dedupe: Location type is treated inconsistently
  ([dev/core#1826](https://lab.civicrm.org/dev/core/-/issues/1826):
  [17645](https://github.com/civicrm/civicrm-core/pull/17645))**

  Duplicate matching now ignores location type for postal address fields, now
  consistent with how it has ignored phone and email location types.

- **Installing Drupal 8 using civicrm-setup leads to "incorrect resource url"
  system status check errors
  ([dev/drupal#114](https://lab.civicrm.org/dev/drupal/-/issues/114) and
  [dev/core#1647](https://lab.civicrm.org/dev/core/-/issues/1647):
  [17754](https://github.com/civicrm/civicrm-core/pull/17754))**

  Removes the resource URL status check.

- **API4: 500 error on chain with custom field
  ([dev/core#1578](https://lab.civicrm.org/dev/core/-/issues/1578):
  [17866](https://github.com/civicrm/civicrm-core/pull/17866))**

- **MySQL uses filesort index when building the query which can cause
  performance issues
  ([dev/core#1665](https://lab.civicrm.org/dev/core/-/issues/1665):
  [18052](https://github.com/civicrm/civicrm-core/pull/18052))**

- **Custom fields not copied on shared address
  ([dev/core#1670](https://lab.civicrm.org/dev/core/-/issues/1670):
  [17580](https://github.com/civicrm/civicrm-core/pull/17580))**

- **Email template permissions
  ([dev/core#1751](https://lab.civicrm.org/dev/core/-/issues/1751):
  [17480](https://github.com/civicrm/civicrm-core/pull/17480))**

  Users sending an email are no longer able to save or modify a template if they
  lack the "edit message templates" permission.

- **Using Parent tag in search form doesn't pull contacts marked with child tag
  in search form result
  ([dev/core#1795](https://lab.civicrm.org/dev/core/-/issues/1795):
  [17513](https://github.com/civicrm/civicrm-core/pull/17513))**

- **Activity Search : Tags are not working
  ([dev/core#1827](https://lab.civicrm.org/dev/core/-/issues/1827):
  [17655](https://github.com/civicrm/civicrm-core/pull/17655) and
  [17755](https://github.com/civicrm/civicrm-core/pull/17755))**

- **Autocomplete-select custom field is not searchable
  ([dev/core#1805](https://lab.civicrm.org/dev/core/-/issues/1805):
  [17569](https://github.com/civicrm/civicrm-core/pull/17569))**

- **Do not allow enabling database logging when using multilingual
  ([dev/core#1812](https://lab.civicrm.org/dev/core/-/issues/1812):
  [17815](https://github.com/civicrm/civicrm-core/pull/17815))**

  This has never worked, with network errors as the result.  This prevents it
  from being set.

- **Can't remove subtype if any required custom field is based on it
  ([dev/core#1853](https://lab.civicrm.org/dev/core/-/issues/1853):
  [17765](https://github.com/civicrm/civicrm-core/pull/17765))**

- **User account form action not passing along contact id correctly possibly
  leading to duplicate contacts
  ([dev/core#1858](https://lab.civicrm.org/dev/core/-/issues/1858):
  [17769](https://github.com/civicrm/civicrm-core/pull/17769))**

  When creating a user account from a contact record, the contact ID was not
  properly passed along.  Depending upon your unsupervised duplicate matching
  rule, it would potentially create a duplicate contact record.

- **Cannot edit a profile field of "Email" to use the Location Type "Primary"
  ([dev/core#1861](https://lab.civicrm.org/dev/core/-/issues/1861):
  [17812](https://github.com/civicrm/civicrm-core/pull/17812))**

  The location type would get reset to your default location type rather than
  staying as "primary".

- **Downgrade checkEnvironment level and skip non-prod checks (part of
  [dev/core#1863](https://lab.civicrm.org/dev/core/-/issues/1863):
  [17807](https://github.com/civicrm/civicrm-core/pull/17807))**

  In non-production environments, a system check produces a message saying so.
  This downgrades it from an "Alert" to a more appropriate level of "Notice",
  and it also suppresses cron and CiviMail system checks in this situation.

- **Slew of E_NOTICES on Profiles admin page and description field is always
  blank ([dev/core#1868](https://lab.civicrm.org/dev/core/-/issues/1868):
  [17786](https://github.com/civicrm/civicrm-core/pull/17786))**

- **CiviReport sent as email via mail_report job with a CSV attachment doesn't
  show UTF8 characters properly in Excel
  ([dev/core#1869](https://lab.civicrm.org/dev/core/-/issues/1869):
  [17806](https://github.com/civicrm/civicrm-core/pull/17806))**

- **References to packages path in security status checks are assumed to be
  under civicrm root
  ([dev/core#1872](https://lab.civicrm.org/dev/core/-/issues/1872):
  [17844](https://github.com/civicrm/civicrm-core/pull/17844))**

  This changes how package and vendor paths are calculated in system checks
  since (in Drupal 8 and potentially elsewhere) they may not be within the
  CiviCRM root folder.

- **Custom data insert/update error if using reserved words
  ([dev/core#1880](https://lab.civicrm.org/dev/core/-/issues/1880):
  [17848](https://github.com/civicrm/civicrm-core/pull/17848))**

- **Advanced Search (search by complete or partial name) returns all contacts
  ([dev/core#1895](https://lab.civicrm.org/dev/core/-/issues/1895):
  [17950](https://github.com/civicrm/civicrm-core/pull/17950))**

  The ability to search first/last name was recently added to core. The primary
  intent was to properly handle advanced searches that originate from
  quicksearch first/last name filters. While that was working, a first/last name
  search that originated directly from an advanced search was not working. This
  fixes the issue.

- **Miscellaneous E_NOTICES
  ([dev/core#1909](https://lab.civicrm.org/dev/core/-/issues/1909):
  [18006](https://github.com/civicrm/civicrm-core/pull/18006),
  [17962](https://github.com/civicrm/civicrm-core/pull/17962),
  [17964](https://github.com/civicrm/civicrm-core/pull/17964),
  [17959](https://github.com/civicrm/civicrm-core/pull/17959), and
  [17985](https://github.com/civicrm/civicrm-core/pull/17985))**

- **CRM_Core_Key::valid() does backwards comparison
  ([dev/core#1918](https://lab.civicrm.org/dev/core/-/issues/1918):
  [18007](https://github.com/civicrm/civicrm-core/pull/18007))**

  This removes legacy code that appeared to attempt to check for a valid
  quickForm key but wasn't effectively doing so.

- **Upgrade fails for 4.6 => 5.29 during status-check
  ([dev/core#1932](https://lab.civicrm.org/dev/core/-/issues/1932):
  [18085](https://github.com/civicrm/civicrm-core/pull/18085))**

- **Installation doclinks not getting url-rewritten
  ([18175](https://github.com/civicrm/civicrm-core/pull/18175))**

  Links to the new installation documentation are now handled in the same way as
  other documentation sites.

- **Wrap multi record custom field inside a div
  ([17966](https://github.com/civicrm/civicrm-core/pull/17966))**

- **Fixed filling default values for tagssets in the advanced search form
  ([17978](https://github.com/civicrm/civicrm-core/pull/17978))**

- **Simplify caching of status checks
  ([17817](https://github.com/civicrm/civicrm-core/pull/17817))**

- **Ensure custom field checkboxes are populated in profiles
  ([17977](https://github.com/civicrm/civicrm-core/pull/17977))**

- **Upgrade PEAR/mail_mime package to be compliant with PHP7.4 and deploy it
  using composer ([17948](https://github.com/civicrm/civicrm-core/pull/17948))**

- **Setup UI - Validate that at least one "Component" is enabled
  ([17778](https://github.com/civicrm/civicrm-core/pull/17778))**

  This prevents you from proceeding with installation without enabling at least
  one component.  Not enabling any components causes a messy failed
  installation.

- **Call apiv4 from Contribution create rather than fugly addActivity function
  ([17881](https://github.com/civicrm/civicrm-core/pull/17881))**

- **Search debug ([17887](https://github.com/civicrm/civicrm-core/pull/17887))**

- **Simplify flushing group contact cache query to reduce table locking and
  improve performance
  ([17846](https://github.com/civicrm/civicrm-core/pull/17846))**

- **Make api get upgrade-safe
  ([17729](https://github.com/civicrm/civicrm-core/pull/17729))**

  This avoids database errors when the code and database versions don't match by
  preventing the API from accessing fields that are unsupported in the database.

- **CheckEnv - Give new installs a grace period before 'Cron Not Running' msg
  ([17800](https://github.com/civicrm/civicrm-core/pull/17800))**

  The system check will lower the severity of the "cron not running" check for
  the first 24 hours after a site has been installed.

- **Sort permittedActivityTypes
  ([17794](https://github.com/civicrm/civicrm-core/pull/17794))**

  This improves performance on filtering activity types by making it possible to
  compare a list of permitted types with the overall list of activity type IDs.

- **APIv4 - Fix saving custom fields with same name
  ([17791](https://github.com/civicrm/civicrm-core/pull/17791))**

- **Status Checks - Use more specific label regarding "Domain"/"Organization"
  check ([17776](https://github.com/civicrm/civicrm-core/pull/17776))**

- **SQL temp table not using utf8mb4 if server default already set to utf8mb4
  ([18012](https://github.com/civicrm/civicrm-core/pull/18012))**

- **Wrong link to admin page in error message about FROM address on PCP page
  ([17996](https://github.com/civicrm/civicrm-core/pull/17996))**

- **Fix sticky table header on "Find Activities" page
  ([17917](https://github.com/civicrm/civicrm-core/pull/17917))**

- **Fixed DB Error: syntax error if line item refers to civicrm_case
  ([16626](https://github.com/civicrm/civicrm-core/pull/16626))**

- **Fix potential js error on summary screen when reloading blocks
  ([17865](https://github.com/civicrm/civicrm-core/pull/17865))**

- **Fix 'Undefined variable: jsSet in CRM_Core_BAO_Mapping::loadSavedMapping()'
  ([17816](https://github.com/civicrm/civicrm-core/pull/17816))**

- **Fixed notice error on Relationships report
  ([17787](https://github.com/civicrm/civicrm-core/pull/17787))**

- **Fix obscure dedupe scenario where 'bad' location data can overwrite good
  data ([17993](https://github.com/civicrm/civicrm-core/pull/17993))**

- **Fix JQuery Validation for radios
  ([17937](https://github.com/civicrm/civicrm-core/pull/17937))**

### CiviCase

- **Fix case activity field set to allow long details to be exported
  ([17970](https://github.com/civicrm/civicrm-core/pull/17970))**

- **Case export has two fields that are not what they say they are
  ([dev/core#1916](https://lab.civicrm.org/dev/core/-/issues/1916):
  [18043](https://github.com/civicrm/civicrm-core/pull/18043))**

- **Collapsed custom field set for activities with a required radio makes case
  activity buttons seem disabled
  ([dev/core#1928](https://lab.civicrm.org/dev/core/-/issues/1928):
  [18080](https://github.com/civicrm/civicrm-core/pull/18080))**

- **CRM_Utils_Check_Component_Case - Guard against post-upgrade crash
  ([17944](https://github.com/civicrm/civicrm-core/pull/17944))**

### CiviContribute

- **Define the logic that sets (or not) contribution receive_date in relation to
  payments
  ([dev/financial#139](https://lab.civicrm.org/dev/financial/-/issues/139):
  [17777](https://github.com/civicrm/civicrm-core/pull/17777) and
  [18000](https://github.com/civicrm/civicrm-core/pull/18000))**

  This undoes a regression where the contribution date of a pay-later
  contribution would change when a payment completes the contribution.  The
  contribution date is the accrual date and is distinct from the date the
  contribution is entered and the date when all payments have been received.

  In the process, this changes the "Update pending contribution status" search
  action to be "Record payments for contributions".  The result is generally the
  same, but the status change comes about because the payments complete the
  contributions.  You can modify contribution statuses in bulk with a profile by
  using the "Update multiple contributions" action.

- **Disable frequency/interval fields if not required. Mark required if they are
  so they are validated before submit
  ([17526](https://github.com/civicrm/civicrm-core/pull/17526))**

  The frequency and interval fields for recurring contributions now use jQuery
  validation to disable or require them as appropriate.

- **Paypal IPN sometimes fails to update the next scheduled payment date when
  recording the latest recurring payment
  ([dev/core#1679](https://lab.civicrm.org/dev/core/-/issues/1679):
  [17744](https://github.com/civicrm/civicrm-core/pull/17744))**

- **Contribution Details Statistics are multiplied under many circumstances
  ([dev/report#21](https://lab.civicrm.org/dev/report/-/issues/21):
  [15435](https://github.com/civicrm/civicrm-core/pull/15435) and
  [17809](https://github.com/civicrm/civicrm-core/pull/17809))**

- **Contribution Summary Report: The "general total" row does not take the
  currency filtered
  ([dev/report#27](https://lab.civicrm.org/dev/report/-/issues/27):
  [16736](https://github.com/civicrm/civicrm-core/pull/16736))**

  When the contribution summary report is used by filtering for a currency other
  than the site's default currency, the "grand total" row shows the sign of the
  default currency instead of the filtered currency.

- **Fix PaypalIPN single function to not receive-by-reference
  ([18044](https://github.com/civicrm/civicrm-core/pull/18044))**

- **Allow Failed -> Completed status for contributions
  ([dev/core#1906](https://lab.civicrm.org/dev/core/-/issues/1906):
  [17943](https://github.com/civicrm/civicrm-core/pull/17943))**

- **Fix currency symbol for Total Amount on contribution page
  ([17703](https://github.com/civicrm/civicrm-core/pull/17703))**

  This resolves a but where the total amount would show the default system
  currency symbol regardless of the currency configured on the contribution
  page.

- **On behalf label / Honoree Title / Honoree Description not translatable on
  contribution page
  ([dev/core#1280](https://lab.civicrm.org/dev/core/-/issues/1280):
  [16838](https://github.com/civicrm/civicrm-core/pull/16838))**

- **Load contribution page if live payment processor is disabled but test is
  available ([17828](https://github.com/civicrm/civicrm-core/pull/17828))**

- **Remove requirement to pass 'contribution_status_id' => Pending from
  order.create ([18018](https://github.com/civicrm/civicrm-core/pull/18018))**

- **Use saved contribution's line items rather than the primaryContributionID
  ([18033](https://github.com/civicrm/civicrm-core/pull/18033))**

- **Do not overwrite values saved from the repeatContribution routine
  ([17972](https://github.com/civicrm/civicrm-core/pull/17972))**

- **"Contribution Source" profile field has no effect on new contribution
  ([dev/core#1902](https://lab.civicrm.org/dev/core/-/issues/1902):
  [17930](https://github.com/civicrm/civicrm-core/pull/17930))**

- **Incorrect check for "soft_credit" after making pcp donation
  ([dev/core#1915](https://lab.civicrm.org/dev/core/-/issues/1915):
  [18002](https://github.com/civicrm/civicrm-core/pull/18002))**

- **Total Tax Amount on the Contribution (generated in backoffice/offline) no
  longer adds up to sum of the Tax Amount for the individual line items
  ([dev/core#1983](https://lab.civicrm.org/dev/core/-/issues/1983):
  [18290](https://github.com/civicrm/civicrm-core/pull/18290))**

- **Downloaded Invoice activity attaches non wkhtmltopdf invoice
  ([dev/core#1922](https://lab.civicrm.org/dev/core/-/issues/1922):
  [18056](https://github.com/civicrm/civicrm-core/pull/18056))**

  Downloading an invoice would ignore whether wkhtmltopdf was configured and
  always use dompdf.

- **Fix repeattransaction api to use custom data from the template contribution
  ([17975](https://github.com/civicrm/civicrm-core/pull/17975))**

  The Contribution.repeattransaction API will now copy custom data from the
  template rather than the earliest related contribution.

### CiviEvent

- **Can't meaningfully disable self-service transfer/cancellation once enabled
  ([dev/event#35](https://lab.civicrm.org/dev/event/-/issues/35):
  [18040](https://github.com/civicrm/civicrm-core/pull/18040))**

- **Event registration form has inconsistent labeling
  ([dev/event#38](https://lab.civicrm.org/dev/event/-/issues/38):
  [17695](https://github.com/civicrm/civicrm-core/pull/17695))**

- **Event cart hidden/enabled in buildkit 5.29 RC
  ([dev/event#40](https://lab.civicrm.org/dev/event/-/issues/40):
  [18101](https://github.com/civicrm/civicrm-core/pull/18101))**

  Ensures that the Event Cart functionality defaults to off.

### CiviMail

- **Remove URL-tracking in mass SMS
  ([dev/core#1843](https://lab.civicrm.org/dev/core/-/issues/1843):
  [17700](https://github.com/civicrm/civicrm-core/pull/17700))**

  Rewritten URLs were confusing and made SMS messages unnecessarily long.  There
  also have never been SMS tracking reports to use them anyway.

- **Test mailings create new contacts even when "Add Contacts" permission is not
  present. ([dev/mail#70](https://lab.civicrm.org/dev/mail/-/issues/70):
  [17867](https://github.com/civicrm/civicrm-core/pull/17867))**

  Ensures contacts are not created when a user without permissions to create
  contacts sends a test email.

- **Mailing Subscription form does not validate reCAPTCHA
  ([dev/core#1755](https://lab.civicrm.org/dev/core/-/issues/1755):
  [17305](https://github.com/civicrm/civicrm-core/pull/17305))**

- **Text version of unsubscribed email is missing the link to resubscribe
  ([dev/core#1919](https://lab.civicrm.org/dev/core/-/issues/1919):
  [18015](https://github.com/civicrm/civicrm-core/pull/18015))**

- **Add CiviMail synchronisation frequency setting
  (in support of [dev/core#1768](https://lab.civicrm.org/dev/core/-/issues/1768):
  [17709](https://github.com/civicrm/civicrm-core/pull/17709))**

  This adds a setting for updating how frequently the database should be updated
  with the status of emails that have been sent.  Updating the database more
  frequently can slow the process down, but it reduces the likelihood that a
  recipient will be re-emailed when recovering from a stalled mailing.

- **Mark the new routes for "open.php" and "url.php" as public
  ([17813](https://github.com/civicrm/civicrm-core/pull/17813))**

  This denotes the paths for open and URL tracking as "public" pages as they are
  meant to be used by unauthenticated email clients and recipients.

### CiviMember

- **Decimal Separator - Invalid value "total_amount" (NaN,N) creating or editing
  a membership ([dev/core#1113](https://lab.civicrm.org/dev/core/-/issues/1113):
  [16429](https://github.com/civicrm/civicrm-core/pull/16429))**

- **Offline Membership Renewal Tax Calculation is incorrect [regression]
  ([dev/core#1972](https://lab.civicrm.org/dev/core/-/issues/1972):
  [18271](https://github.com/civicrm/civicrm-core/pull/18271))**

### Drupal Integration

- **Drupal 8 - Using Create User Record action on a contact with no email is too
  quiet. Also CRM_Core_Session::setStatus is sometimes ignored.
  ([dev/drupal#127](https://lab.civicrm.org/dev/drupal/-/issues/127):
  [17914](https://github.com/civicrm/civicrm-core/pull/17914) and
  [17915](https://github.com/civicrm/civicrm-core/pull/17915))**

  Require email when adding a user and ensure that errors show.

- **The following PHP variables are not set: $_SERVER[HTTP_HOST]
  ([dev/core#750](https://lab.civicrm.org/dev/core/-/issues/750):
  [17636](https://github.com/civicrm/civicrm-core/pull/17636))**

  Skip the server variable checks if running in a CLI environment, removing an
  error when running Drush commands against Drupal 8 and Drupal 9 based sites.

- **Can't find reCAPTCHA in Drupal 8
  ([dev/core#1871](https://lab.civicrm.org/dev/core/-/issues/1871):
  [17822](https://github.com/civicrm/civicrm-core/pull/17822))**

- **Fixed for multi-select filter
  ([615](https://github.com/civicrm/civicrm-drupal/pull/615))**

  This fixes filters for multi-select fields in Views.

- **Fix URL for file field
  ([608](https://github.com/civicrm/civicrm-drupal/pull/608))**

  This fixes the generated URL for file fields in Views.

### Wordpress Integration

- **[civicrm.files] token doesn't work in some cases since 5.27
  ([dev/wordpress#66](https://lab.civicrm.org/dev/wordpress/-/issues/66):
  [18068](https://github.com/civicrm/civicrm-core/pull/18068))**

  Ensures the [civicrm.files] token plays nice for sites with older WordPress
  file directory set ups.

- **CiviCRM and the WordPress Pods plugin (since version 2.7.13) is incompatible
  due to Pods including marionette v3.3.1 for backbone, newer than CiviCRM's
  bundled marionette v1.0.3
  ([dev/core#1090](https://lab.civicrm.org/dev/core/-/issues/1090):
  [17855](https://github.com/civicrm/civicrm-core/pull/17855))**

  Ensures CiviCRM plays nicely with recent versions of Elementor Plugin.

- **Fix PHP notice on WordPress permissions form
  ([17758](https://github.com/civicrm/civicrm-core/pull/17758))**

- **Slow down the frequency of WordPress "heartbeat" calls in CiviCRM admin
  ([dev/wordpress#67](https://lab.civicrm.org/dev/wordpress/-/issues/67):
  [214](https://github.com/civicrm/civicrm-wordpress/pull/214))**

- **Be more forgiving about slash in wpBasePage ([dev/wordpress#73](https://lab.civicrm.org/dev/wordpress/issues/73):
  [18332](https://github.com/civicrm/civicrm-core/pull/18332))**

## <a name="misc"></a>Miscellany

- **APIv4 - Add BasicEntity helper class
  ([17899](https://github.com/civicrm/civicrm-core/pull/17899))**

- **Bump minimum upgradable version to 4.4.7
  ([17750](https://github.com/civicrm/civicrm-core/pull/17750))**

- **Update version in the test_data_second_domain file and also update the
  setVersion script to update the file version as necessary
  ([17897](https://github.com/civicrm/civicrm-core/pull/17897))**

- **Be a little less supportive to cvs
  ([17896](https://github.com/civicrm/civicrm-core/pull/17896))**

- **Replace a load of references to the wiki with docs links
  ([17900](https://github.com/civicrm/civicrm-core/pull/17900))**

- **Remove unneccessary isoToDate function
  ([dev/core#1921](https://lab.civicrm.org/dev/core/-/issues/1921):
  [18025](https://github.com/civicrm/civicrm-core/pull/18025))**

- **CRM_Activity_Form_SearchTest::testQill can fail semi-randomly
  ([dev/core#1894](https://lab.civicrm.org/dev/core/-/issues/1894):
  [17902](https://github.com/civicrm/civicrm-core/pull/17902))**

- **Test for fatal error on new individual form
  ([dev/core#1874](https://lab.civicrm.org/dev/core/-/issues/1874):
  [17835](https://github.com/civicrm/civicrm-core/pull/17835))**

- **Bump lodash from 4.17.15 to 4.17.19
  ([17858](https://github.com/civicrm/civicrm-core/pull/17858))**

- **Update regen.sh with new & upcoming core extensions
  ([17839](https://github.com/civicrm/civicrm-core/pull/17839))**

- **APIv4 - Add activity contacts to APIv4 field spec
  ([17766](https://github.com/civicrm/civicrm-core/pull/17766))**

- **Adjust mysql SET NAMES in remaining places as we agreed this was the go
  ([17825](https://github.com/civicrm/civicrm-core/pull/17825))**

- **CRM_Utils_SQL - Add "onDuplicate()" and "syncInto()" helpers
  ([17780](https://github.com/civicrm/civicrm-core/pull/17780))**

- **Improve efficiency of findFiles
  ([17745](https://github.com/civicrm/civicrm-core/pull/17745))**

- **APIv4 Explorer: Improve selection of fields for HAVING
  ([17746](https://github.com/civicrm/civicrm-core/pull/17746))**

- **Convert CRM.utils.formatDate tests to karma
  ([17757](https://github.com/civicrm/civicrm-core/pull/17757))**

- **Teach CRM.utils.formatDate to also show time
  ([17684](https://github.com/civicrm/civicrm-core/pull/17684))**

- **CRM_Utils_Hook: deprecation warning and short array syntax
  ([17995](https://github.com/civicrm/civicrm-core/pull/17995))**

- **Remove check for valid email in synchronizeUFMatch
  ([17771](https://github.com/civicrm/civicrm-core/pull/17771))**

- **Remove unused "ufUniqID" session variable
  ([17904](https://github.com/civicrm/civicrm-core/pull/17904))**

- **Remove duplicate cache flush
  ([17988](https://github.com/civicrm/civicrm-core/pull/17988))**

- **Remove extraneous opportunistic cache flush.
  ([17936](https://github.com/civicrm/civicrm-core/pull/17936))**

- **Hooks/Dispatcher - Close loopholes that occur around "preboot" hooks
  ([17831](https://github.com/civicrm/civicrm-core/pull/17831))**

- **Use PrematureExit exception instead of weird hack in tests
  ([17870](https://github.com/civicrm/civicrm-core/pull/17870))**

- **Remove unnecessary try/catch per #17729
  ([17823](https://github.com/civicrm/civicrm-core/pull/17823))**

- **handlePaymentNotification() should not be declared as a static method
  ([17849](https://github.com/civicrm/civicrm-core/pull/17849))**

- **MembershipRenewalTest - Fix failure
  ([17830](https://github.com/civicrm/civicrm-core/pull/17830))**

- **Remove hard coded charset.
  ([17826](https://github.com/civicrm/civicrm-core/pull/17826))**

- **getLoggedInContactID() is a static function
  ([17783](https://github.com/civicrm/civicrm-core/pull/17783))**

- **Remove PaymentExpress ipn class
  ([17763](https://github.com/civicrm/civicrm-core/pull/17763))**

- **Remove unused, deprecated functions
  ([17761](https://github.com/civicrm/civicrm-core/pull/17761))**

- **CIVICRM_BAO_CACHE_ADAPTER - Remove obsolete option
  ([17990](https://github.com/civicrm/civicrm-core/pull/17990))**

- **More unused functions in GenCode
  ([17756](https://github.com/civicrm/civicrm-core/pull/17756))**

- **Temporary tables should follow consistent naming convention
  ([dev/core#183](https://lab.civicrm.org/dev/core/-/issues/183):
  [17827](https://github.com/civicrm/civicrm-core/pull/17827))**

- **CRM_Core_BAO_Cache - Remove functions deprecated a year ago
  ([17989](https://github.com/civicrm/civicrm-core/pull/17989))**

- **Fix all core processors to implement doPayment and not doTransferPayment or
  doDirectPayment
  ([https://lab.civicrm.org/dev/financial/-/issues/135](https://lab.civicrm.org/dev/financial/-/issues/135):
  [18078](https://github.com/civicrm/civicrm-core/pull/18078) and
  [18072](https://github.com/civicrm/civicrm-core/pull/18072))**

- **[REF] Extract setUserContext on contribution form & cleanup on backend add
  membership form
  ([17968](https://github.com/civicrm/civicrm-core/pull/17968))**

- **[REF] remove unnecessary variable variables
  ([17903](https://github.com/civicrm/civicrm-core/pull/17903))**

- **[REF] - Add helper function for the repetitive task of fetching multilingual
  ([17650](https://github.com/civicrm/civicrm-core/pull/17650))**

- **[REF] Unit test attempt to create reported bugs , minor cleanup
  ([17560](https://github.com/civicrm/civicrm-core/pull/17560))**

- **[REF] Extract addToRecentItems from membership create
  ([17524](https://github.com/civicrm/civicrm-core/pull/17524))**

- **[REF] Fix a couple of jQuery errors that have cropped up
  ([17871](https://github.com/civicrm/civicrm-core/pull/17871))**

- **[REF] regen.sh - Remove unusual handling of `zipcodes.mysql`
  ([17869](https://github.com/civicrm/civicrm-core/pull/17869))**

- **[REF] ScheduledJob cleanup, remove unused var
  ([17862](https://github.com/civicrm/civicrm-core/pull/17862))**

- **[REF] Migrate Event Cart Setting into the Extension
  ([17841](https://github.com/civicrm/civicrm-core/pull/17841))**

- **[REF] Only printOnly once
  ([17850](https://github.com/civicrm/civicrm-core/pull/17850))**

- **[REF] APIv4 ConformanceTest - Split apart into per-entity sub-tests
  ([17845](https://github.com/civicrm/civicrm-core/pull/17845))**

- **[REF] WebsiteTest - Mitigate flaky failures
  ([17833](https://github.com/civicrm/civicrm-core/pull/17833))**

- **[REF] Follow up cleanup
  ([17788](https://github.com/civicrm/civicrm-core/pull/17788))**

- **[REF] Remove ACL join on temp table creation in Member ContributionDetail
  report ([17723](https://github.com/civicrm/civicrm-core/pull/17723))**

- **[REF] Do or do not - there is no try
  ([17795](https://github.com/civicrm/civicrm-core/pull/17795))**

- **[REF] Unused interface CRM_Report_Interface
  ([17767](https://github.com/civicrm/civicrm-core/pull/17767))**

- **[REF] - Cleanup StatusPreference BAO to be more standard
  ([17801](https://github.com/civicrm/civicrm-core/pull/17801))**

- **[REF] Reduce interaction between dedupe code and createProfileContact
  ([17920](https://github.com/civicrm/civicrm-core/pull/17920))**

- **[REF] Simplify field reference
  ([17941](https://github.com/civicrm/civicrm-core/pull/17941))**

- **[REF] [Test] Minor simplification on test
  ([18019](https://github.com/civicrm/civicrm-core/pull/18019))**

- **[REF] Simplify is_email_receipt in sendMail
  ([18029](https://github.com/civicrm/civicrm-core/pull/18029))**

- **[REF] Remove transaction from BaseIPN completeTransaction call
  ([18042](https://github.com/civicrm/civicrm-core/pull/18042))**

- **[REF] Simplify membership status date handling
  ([18030](https://github.com/civicrm/civicrm-core/pull/18030))**

- **[REF] Clean up handling of financial_type_id override
  ([18032](https://github.com/civicrm/civicrm-core/pull/18032))**

- **[REF] Remove transaction from completeOrder signature
  ([18046](https://github.com/civicrm/civicrm-core/pull/18046))**

- **[REF] Remove transaction instantiation in PaypalPro
  ([18026](https://github.com/civicrm/civicrm-core/pull/18026))**

- **[REF] Stop instantiating transaction in PaypalIPN
  ([18020](https://github.com/civicrm/civicrm-core/pull/18020))**

- **[REF] Remove pass-by-reference & always empty param
  ([17984](https://github.com/civicrm/civicrm-core/pull/17984))**

- **[REF] Tighten up function signature for dedupePair
  ([17923](https://github.com/civicrm/civicrm-core/pull/17923))**

- **[REF] Move noisily deprecate  BaseIPN->sendMail, call api from it rather
  than BAO function
  ([17982](https://github.com/civicrm/civicrm-core/pull/17982))**

- **[REF] Use CRM_Utils_Mail::send for sending emails for confirming unsubscribe
  resubscribe auto replies and subscribing
  ([17396](https://github.com/civicrm/civicrm-core/pull/17396))**

- **[REF] Reduce calls to CRM_Member_PseudoConstant::membershipType
  ([17987](https://github.com/civicrm/civicrm-core/pull/17987))**

- **[REF] Use Standard function cacheClause to re-use contact acl cache table
  ([17707](https://github.com/civicrm/civicrm-core/pull/17707))**

- **[REF] Make explicit what we are doing with 'values' in this code
  ([17979](https://github.com/civicrm/civicrm-core/pull/17979))**

- **[REF] Minor code clean up
  ([17974](https://github.com/civicrm/civicrm-core/pull/17974))**

- **[REF] Grant cleanup
  ([17967](https://github.com/civicrm/civicrm-core/pull/17967))**

- **[REF] Refactor to use the standard CRM_Core_Form::addRadio function for a
  number of radio elements
  ([17932](https://github.com/civicrm/civicrm-core/pull/17932))**

- **[REF] Fix the default to_financial_account_id for generated transactions
  ([17938](https://github.com/civicrm/civicrm-core/pull/17938))**

- **[REF] Upgrade dompdf version to be more compatible with PHP7.4
  ([17946](https://github.com/civicrm/civicrm-core/pull/17946))**

- **[REF] [Tests] Cleanup test declaration to take advantage of mapping
  improvements ([17939](https://github.com/civicrm/civicrm-core/pull/17939))**

- **[REF] Remove unnecessary complexity on im export
  ([17949](https://github.com/civicrm/civicrm-core/pull/17949))**

- **[REF] GroupContact BAO - Minor code cleanup
  ([17928](https://github.com/civicrm/civicrm-core/pull/17928))**

- **[REF] Minor function signuture cleanup
  ([17922](https://github.com/civicrm/civicrm-core/pull/17922))**

- **[REF] Do not pass variable by reference
  ([17921](https://github.com/civicrm/civicrm-core/pull/17921))**

- **[REF] remove first attempt to set currency in repeattransaction flow
  ([18055](https://github.com/civicrm/civicrm-core/pull/18055))**

- **[REF] Even less variable variables
  ([18058](https://github.com/civicrm/civicrm-core/pull/18058))**

- **[REF] Move handling of form elements back to the Form
  ([17981](https://github.com/civicrm/civicrm-core/pull/17981))**

- **[REF] Simplify location metadata handling in Export class
  ([17951](https://github.com/civicrm/civicrm-core/pull/17951))**

- **[REF] Do not pass by reference to the recur function
  ([18057](https://github.com/civicrm/civicrm-core/pull/18057))**

- **[REF] Simplify getMembershipStatusByDate more
  ([18051](https://github.com/civicrm/civicrm-core/pull/18051))**

- **[REF] Remove mail_mime package as now supplied by composer
  ([300](https://github.com/civicrm/civicrm-packages/pull/300))**

- **[REF] Remove some deprecated size function calls replaced with length
  ([299](https://github.com/civicrm/civicrm-packages/pull/299))**

- **Refactor "applyLocale" and remove references to "language" column in UFMatch
  table ([18049](https://github.com/civicrm/civicrm-core/pull/18049))**

- **[NFC] Fix provider unit test on PHP7.4
  ([18073](https://github.com/civicrm/civicrm-core/pull/18073))**

- **[NFC] Docblock cleanup
  ([610](https://github.com/civicrm/civicrm-drupal/pull/610))**

- **[NFC] Update versions file to remove reference to Mail_mime and Mail
  ([301](https://github.com/civicrm/civicrm-packages/pull/301))**

- **[NFC] Re run regen after recent merges
  ([17842](https://github.com/civicrm/civicrm-core/pull/17842))**

- **[NFC] Fix nonstandard header comments
  ([17880](https://github.com/civicrm/civicrm-core/pull/17880))**

- **[NFC] Add in a unit test of calling the contribution page widget endpoint
  and remove unneeded file
  ([17965](https://github.com/civicrm/civicrm-core/pull/17965))**

- **[NFC] Improve docs for APIv4 Save action
  ([18004](https://github.com/civicrm/civicrm-core/pull/18004))**

- **[NFC] Docblock cleanup
  ([17945](https://github.com/civicrm/civicrm-core/pull/17945))**

- **[NFC] Update a few doc/wiki links in code comments
  ([17918](https://github.com/civicrm/civicrm-core/pull/17918))**

- **[NFC] Comment block cleanup
  ([17872](https://github.com/civicrm/civicrm-core/pull/17872))**

- **[Test] Update hook signature in test
  ([609](https://github.com/civicrm/civicrm-drupal/pull/609))**

- **[Test] Attempt to replicate #17852
  ([18038](https://github.com/civicrm/civicrm-core/pull/18038))**

- **[Test fix] We might need this to ensure really quick test runs don't fail
  ([18045](https://github.com/civicrm/civicrm-core/pull/18045))**

- **Add testing to Authorize.net and remove the lines that are repeated
  ([18028](https://github.com/civicrm/civicrm-core/pull/18028))**

- **Add test on status calculation
  ([18037](https://github.com/civicrm/civicrm-core/pull/18037))**

- **Fix for failing test
  ([18036](https://github.com/civicrm/civicrm-core/pull/18036))**

- **[Test framework] re-re-fix test and add test for test
  ([18013](https://github.com/civicrm/civicrm-core/pull/18013))**

- **Re-fix test ([18009](https://github.com/civicrm/civicrm-core/pull/18009))**

- **[Test framework] - Update failing test
  ([18003](https://github.com/civicrm/civicrm-core/pull/18003))**

- **[Test framework] - Combine triplicate createCase functions
  ([17957](https://github.com/civicrm/civicrm-core/pull/17957))**

- **Remove error checking by-pass in tests
  ([17940](https://github.com/civicrm/civicrm-core/pull/17940))**

- **[Test Framework] - Tests for report downloads
  ([17892](https://github.com/civicrm/civicrm-core/pull/17892))**

- **api_v3_TaxContributionPageTest - Remove hard coded processor id
  ([17860](https://github.com/civicrm/civicrm-core/pull/17860))**

- **API tests - label versions in dataprovider versionThreeAndFour
  ([17847](https://github.com/civicrm/civicrm-core/pull/17847))**

- **Extract code to set isEmailReceipt in Contribution.completeOrder
  ([18039](https://github.com/civicrm/civicrm-core/pull/18039))**

- **Do not pass-by-reference to recur function
  ([18071](https://github.com/civicrm/civicrm-core/pull/18071))**

- **Unused functions in GenCode
  ([17753](https://github.com/civicrm/civicrm-core/pull/17753))**

- **Fix typo in templates/CRM/Report/Form/Tabs/GroupBy.tpl
  ([17747](https://github.com/civicrm/civicrm-core/pull/17747))**

- **Remove unused "ufUniqID" session variable
  ([213](https://github.com/civicrm/civicrm-wordpress/pull/213))**

- **Remove Net packages Net_Curl Net_DIME as they do not appear to be used
  ([294](https://github.com/civicrm/civicrm-packages/pull/294))**

- **Update contributor key for Andrew
  ([18230](https://github.com/civicrm/civicrm-core/pull/18230))**

- **Fix qill typo
  ([18041](https://github.com/civicrm/civicrm-core/pull/18041))**

- **Update flexmailer release information
  ([17912](https://github.com/civicrm/civicrm-core/pull/17912))**

- **Remove invalid use of crmMoney formatter
  ([18031](https://github.com/civicrm/civicrm-core/pull/18031))**

- **Remove main PaymentExpress class
  ([18010](https://github.com/civicrm/civicrm-core/pull/18010))**

- **Remove unused parameter ids['billing']
  ([18021](https://github.com/civicrm/civicrm-core/pull/18021))**

- **Cache loader - remove legacy handling, handle null result from setting
  ([17999](https://github.com/civicrm/civicrm-core/pull/17999))**

- **Use case id to get relationship for activity creation
  ([17256](https://github.com/civicrm/civicrm-core/pull/17256) and
  [17764](https://github.com/civicrm/civicrm-core/pull/17764))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Justin Freeman;
Christian Wach; Circle Interactive - Pradeep Nayak; CiviCoop - Jaap Jansma,
Klaas Eikelboom; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Dave D; Fuzion - Jitendra
Purohit; iXiam - César Ramos, Diego Muñio; JMA Consulting - Monish Deb, Seamus
Lee; John Kingsnorth; Joinery - Allen Shaw; Lighthouse Consulting and Design -
Brian Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MillerTech -
Chamil Wijesooriya; MJCO - Mikey O'Toole; MJW Consulting - Matthew Wire;
Progressive Technology Project - Jamie McClelland; Squiffle Consulting - Aidan
Saunders; Stephen Palmstrom; Tadpole Collective - Kevin Cristiano; Timbsoft
Technologies - Tunbola Ogunwande; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Pengyi Zhang; Andrew Thompson; Artful Robot - Rich Lott; Australian
Greens - Andrew Cormick-Dockery, John Twyman; Bastien Ho; Blackfly Solutions -
Alan Dixon; Carlos Capote; CompuCorp - Jamie Novick; DevApp - Adam Kwiatkowski;
Francesc Bassas i Bullich; Freeform Solutions - Herb van den Dool; Greenpeace
Central and Eastern Europe - Patrick Figel; Irene Meisel; JMA Consulting - Joe
Murray; Korlon - Stuart Gaston; Nicol Wistreich; Rar9; Ray Wright; Semper IT -
Karin Gerritsen; Third Sector Design - Michael McAndrew

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
