# CiviCRM 5.26.0

Released June 3, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     | **yes** |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     | **yes** |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## NOTICE: WordPress Service URLs

The upcoming release of WordPress 5.5 ([ETA August 2020](https://make.wordpress.org/core/5-5/)) requires changes to several CiviCRM URLs. CiviCRM 5.26+ adopts a new URL convention. For old URLs, there is transitional support that will work for most web-based visitors. However, this may not be sufficient for *external service integrations* (e.g. certain payment processors or email relays which send notifications to CiviCRM).

Administrators should promptly assess and update any external services which submit notifications to their CiviCRM-WordPress sites. For more information, see the blog post [CiviCRM 5.26 and WordPress: Important notice](https://civicrm.org/blog/kcristiano/civicrm-526-and-wordpress-important-notice).

## <a name="features"></a>Features

### Core CiviCRM

- **Create nl_BE translation
  ([dev/translation#4](https://lab.civicrm.org/dev/translation/issues/4):
  [17048](https://github.com/civicrm/civicrm-core/pull/17048),
  [17027](https://github.com/civicrm/civicrm-core/pull/17027) and
  [16966](https://github.com/civicrm/civicrm-core/pull/16966))**

  Adds a "Dutch (Belgium)" (shorthand: nl_BE) translation of CiviCRM which
  heavily borrows from the existing "Dutch (Netherlands)" (nl_NL) translation
  with a few changes.

- **APIv4 - Allow field options to be returned in multiple formats
  ([17167](https://github.com/civicrm/civicrm-core/pull/17167))**

  Gives more flexibility about how options are returned from APIv4 and adds
  visibility in the API explorer.

- **APIv4 - How do I interact with option values?
  ([dev/core#1705](https://lab.civicrm.org/dev/core/issues/1705):
  [17158](https://github.com/civicrm/civicrm-core/pull/17158),
  [17138](https://github.com/civicrm/civicrm-core/pull/17138) and
  [17219](https://github.com/civicrm/civicrm-core/pull/17219))**

  Adds support for pseudoconstants to APIv4.

- **APIv4 - Add MessageTemplate API
  ([17073](https://github.com/civicrm/civicrm-core/pull/17073))**

  Adds new "MessageTemplate" entity to APIv4.

- **APIv4 - Add support for HAVING clause
  ([17015](https://github.com/civicrm/civicrm-core/pull/17015))**

  Adds support for using `HAVING` clauses in APIv4.

- **APIv4 - Query Improvements (Work Towards
  [dev/report#31](https://lab.civicrm.org/dev/report/issues/31):
  [17113](https://github.com/civicrm/civicrm-core/pull/17113) and
  [17047](https://github.com/civicrm/civicrm-core/pull/17047))**

  This adds UI support for new APIv4 features.  Specifically, SQL functions and
  aliases are now available in the API explorer, as is the `HAVING` clause and
  `GROUP BY` clause.

- **End of life planning for MySQL server 5.0 - 5.6 (Work Towards
  [dev/core#1681](https://lab.civicrm.org/dev/core/issues/1681):
  [17261](https://github.com/civicrm/civicrm-core/pull/17261))**

  Adds a deprecation notice for systems using MySQL versions before 5.7 and
  requires 5.5 to install.

- **Allow inline help text title to be overriden
  ([dev/core#1693](https://lab.civicrm.org/dev/core/issues/1693):
  [16998](https://github.com/civicrm/civicrm-core/pull/16998))**

  This change makes it possible to override inline help text titles in a
  `.hlp.extra` file.

- **Update attachment message on mailing form.
  ([dev/core#1696](https://lab.civicrm.org/dev/core/issues/1696):
  [17024](https://github.com/civicrm/civicrm-core/pull/17024))**

  This updates the help text on CiviMail attachments to specify the maximum size
  of each attachment.

- **Convert CC and BCC fields to use an entity reference.
  ([17064](https://github.com/civicrm/civicrm-core/pull/17064) and [17129](https://github.com/civicrm/civicrm-core/pull/17129))**

  The CC and BCC fields on all email forms are now entity references to the
  email ID. This simplifies the code and extends filtering on the field.

- **Introduce "civi.dao.preUpdate" and "civi.dao.preInsert" events
  ([dev/core#1638](https://lab.civicrm.org/dev/core/issues/1638):
  [16714](https://github.com/civicrm/civicrm-core/pull/16714))**

  Makes it possible to use a hook to inspect the data of an Option Value prior
  to it being created or updated.

- **Add ID to custom group/field admin forms
  ([17055](https://github.com/civicrm/civicrm-core/pull/17055))**

  The ID numbers are displayed in the tables of custom fields and groups.

- **Improve AngularJS performance with one-time binding for static strings
  ([17050](https://github.com/civicrm/civicrm-core/pull/17050))**

  This improves performance of AngularJS pages and forms by having the
  translation function only execute once when the translated string is static.

- **Allow setting metadata to use the `table` option. Update example setting
  `default_invoice_page`.
  ([16903](https://github.com/civicrm/civicrm-core/pull/16903))**

  Setting metadata that refers to an entity can now be defined with reference to
  a database table, specifying the key and label columns, rather than requiring
  a pseudoconstant function to populate the options.

- **Add / make fit for purpose email.getlist api call
  ([16993](https://github.com/civicrm/civicrm-core/pull/16993))**

  Improves the `Email.getlist` API so that it is usable for entity reference
  fields.

### CiviCase

- **Add email link in case summary
  ([16959](https://github.com/civicrm/civicrm-core/pull/16959))**

  Adds an "Email" icon to the Case Summary page that when clicked opens a pop up
  window to email the client.

### CiviContribute

- **Add contribution source to recurring contribution report
  ([17187](https://github.com/civicrm/civicrm-core/pull/17187))**

  Adds "Contribution Source" as a column on the Recurring Contribution Report.

- **Show email receipt status on view recurring contribution
  ([17177](https://github.com/civicrm/civicrm-core/pull/17177))**

  When viewing a contribution this change exposes the value of
  `is_email_receipt`.

- **Add contributor email address to cancelSubscription form so it is clear who
  will be notified
  ([16716](https://github.com/civicrm/civicrm-core/pull/16716))**

  Adds the contributor email to the Cancel Recurring Contribution form so it is
  clear who will be notified.

- **Add filter and sorting for receipt date in contribution report
  ([17044](https://github.com/civicrm/civicrm-core/pull/17044) and
  [16994](https://github.com/civicrm/civicrm-core/pull/16994))**

  Adds a filter and sorting for "receipt date" to Contribution Reports.

- **Capitalise "PAN Truncation"
  ([16973](https://github.com/civicrm/civicrm-core/pull/16973) and
  [16964](https://github.com/civicrm/civicrm-core/pull/16964))**

  Capitilizes the "PAN" in "Pan Truncation" to improve user experience. PAN is
  an acronym for Primary Account Number (credit card number).

### CiviMail

- **Mailing Report: hide the HTML preview
  ([16899](https://github.com/civicrm/civicrm-core/pull/16899))**

  Improves the Mailing report by hiding the HTML preview because it was too
  short to be helpful to begin with.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **How best to handle Event Dispatchers during upgrade (Work Towards
  [dev/core#1460](https://lab.civicrm.org/dev/core/issues/1460):
  [17127](https://github.com/civicrm/civicrm-core/pull/17127) and
  [17216](https://github.com/civicrm/civicrm-core/pull/17216))**

  This updates the `CiviEventDispatcher` with a method `setDispatchPolicy()`
  that can be used to dynamically toggle support for specific events/hooks and
  updates a related test.

- **After core upgrade, extensions are not fully active
  ([dev/core#1460](https://lab.civicrm.org/dev/core/issues/1460) and
  [dev/core#1713](https://lab.civicrm.org/dev/core/issues/1713):
  [17126](https://github.com/civicrm/civicrm-core/pull/17126))**

  After performing a core upgrade, some extension functionality (e.g. routing) was
  temporariliy unavailable - and required a flush. This fix changes the way in which
  hooks and caches are managed during the upgrade.

- **Report Dev tab display SQL multiple times
  ([dev/core#1673](https://lab.civicrm.org/dev/core/issues/1673):
  [17001](https://github.com/civicrm/civicrm-core/pull/17001))**

- **Namespaced classes cannot contain an underscore
  ([dev/core#1684](https://lab.civicrm.org/dev/core/issues/1684):
  [17105](https://github.com/civicrm/civicrm-core/pull/17105))**

  Allows underscores in class names.

- **Search builder returns DB error on Group => Empty filter
  ([dev/core#1685](https://lab.civicrm.org/dev/core/issues/1685):
  [16953](https://github.com/civicrm/civicrm-core/pull/16953))**

- **Allow override of inherited CMS language when in CiviCRM
  ([17006](https://github.com/civicrm/civicrm-core/pull/17006))**

  This ensures that the language switcher can be used in CiviCRM even when the
  default language is set to inherit from the user's CMS session.

- **Longitude not checked out of box
  ([dev/core#1739](https://lab.civicrm.org/dev/core/issues/1739):
  [17238](https://github.com/civicrm/civicrm-core/pull/17238))**

  Enables the Longitude field on Address Editing by default for new installs.

- **Export selected fields doesn't export related contacts if related info is
  present in mapping
  ([dev/core#1780](https://lab.civicrm.org/dev/core/issues/1780):
  [17462](https://github.com/civicrm/civicrm-core/pull/17462))**

  This fixes a bug where exporting a child and their parent was only resulting
  in one row being exported when the related contact id was selected.

- **Regression: Fails to create smartgroup or refresh count of group
  ([dev/core#1747](https://lab.civicrm.org/dev/core/issues/1747):
  [17438](https://github.com/civicrm/civicrm-core/pull/17438))**

  The temporary table created for smart groups involving the Date Added custom
  search was removed too aggressively, resulting in database errors when
  searching or refreshing the smart group count.

- **Contact restore from trash not working
  ([dev/core#1784](https://lab.civicrm.org/dev/core/issues/1784):
  [17418](https://github.com/civicrm/civicrm-core/pull/17418))**

- **[regression] Fix error on no MIME type
  ([17265](https://github.com/civicrm/civicrm-core/pull/17265))**

  Fixes `TypeError: Argument 1 passed to
  MimeTyper\Repository\AbstractRepository::setFromMap() must be of the type
  array, null given` error.

- **SyntaxConformanceTest::testSqlOperators - Fix failure on MySQL 8
  ([17262](https://github.com/civicrm/civicrm-core/pull/17262))**

- **API explorer fatal joining to contribution from contact
  ([dev/core#1563](https://lab.civicrm.org/dev/core/issues/1563):
  [17239](https://github.com/civicrm/civicrm-core/pull/17239))**

- **APIv4 - Prevent field alias conflicts.
  ([17109](https://github.com/civicrm/civicrm-core/pull/17109))**

- **APIv4 - Fix setting offset with no limit
  ([17063](https://github.com/civicrm/civicrm-core/pull/17063))**

- **Fix admin page url for "conference slots" option values
  ([17223](https://github.com/civicrm/civicrm-core/pull/17223))**

- **Fix Dedupe entity_tag mangling bug
  ([17125](https://github.com/civicrm/civicrm-core/pull/17125))**

  Fixes a bug whereby the merge script alters non-contact entity tags, changing
  the entity they are related to.

- **Show title on status message instead of machine name
  ([17174](https://github.com/civicrm/civicrm-core/pull/17174))**

- **Do not create smarty cached templates for processed greetings
  ([16733](https://github.com/civicrm/civicrm-core/pull/16733))**

- **Add contribution ID as activity source record when downloading or emailing
  invoice ([17165](https://github.com/civicrm/civicrm-core/pull/17165))**

  Ensures that the Activity Source ID field is populated correctly for
  Activities of the type "Emailed Invoice" and "Downloaded Invoice".

- **Correct option_group pseudoconstant and regenerate DAO
  ([17166](https://github.com/civicrm/civicrm-core/pull/17166))**

  Fixes metadata for option_group pseudoconstant list so that labels are visible
  in the list.

- **Update "Colmbra" state/province to "Coimbra"
  ([17106](https://github.com/civicrm/civicrm-core/pull/17106) and
  [17136](https://github.com/civicrm/civicrm-core/pull/17136))**

  Fixes up some Portugal Province labels.

- **Fix 'selectedChild' parameter for pages with tabs
  ([17066](https://github.com/civicrm/civicrm-core/pull/17066))**

  Ensures that the tab set using the `selectedChild` URL parameter is respected.

- **Export: use X icon `fa-times` for closing things
  ([17076](https://github.com/civicrm/civicrm-core/pull/17076))**

  Ensures that the X icon is always used for closing things.

- **Dupe improve custom data handling
  ([17060](https://github.com/civicrm/civicrm-core/pull/17060) and
  [17077](https://github.com/civicrm/civicrm-core/pull/17077))**

  Reduces code complexity & locking queries when merging contacts.

- **Fixed mapping when using custom field for contact sub type
  ([16957](https://github.com/civicrm/civicrm-core/pull/16957))**

  Ensures import mappings populate contact sub-type custom fields.

- **Set is_deceased to not null in schema and upgrade script
  ([dev/core#1697](https://lab.civicrm.org/dev/core/issues/1697):
  [17025](https://github.com/civicrm/civicrm-core/pull/17025))**

  This removes the possibility of having undead contacts.

- **Allow adding variables to CRM.vars in any region
  ([16888](https://github.com/civicrm/civicrm-core/pull/16888))**

- **Fix setting custom field TextArea attributes
  ([16997](https://github.com/civicrm/civicrm-core/pull/16997))**

  Ensures attributes for existing text area custom fields are not overwritten
  during update operations.

- **Fix bug on handling 'is_required'
  ([16901](https://github.com/civicrm/civicrm-core/pull/16901))**

  Ensures that there is a "none" option for select fields that are not
  required and are created extensions using the generic form.

- **Fix values passed to tokenValues hook
  ([16623](https://github.com/civicrm/civicrm-core/pull/16623))**

  Ensures that the `hook_civicrm_tokenValues` is passed the proper values.

- **Fix slowness in opening the select fields for export screen after an advanced search
  ([dev/core#1725](ttps://lab.civicrm.org/dev/core/-/issues/1725):
  [17444](https://github.com/civicrm/civicrm-core/pull/17444))**
  Fixes a recent regression following the updating of the select fields export UI which on certain
  sites slowed down the loading of the select fields screen significantly

### CiviCase

- **Invalid and patchy XML encoding causes Case crash if status is not valid XML
  ([dev/core#1719](https://lab.civicrm.org/dev/core/issues/1719):
  [17100](https://github.com/civicrm/civicrm-core/pull/17100))**

  Fixes a bug where CiviCase would fail to fully create a CaseType if a Case
  Status' name was invalid in an XML context.

- **Case.get API returning Case Clients As Part of Related Contacts
  ([dev/core#1659](https://lab.civicrm.org/dev/core/issues/1659):
  [16837](https://github.com/civicrm/civicrm-core/pull/16837))**

- **Convert fatals to statusBounces in case forms
  ([17212](https://github.com/civicrm/civicrm-core/pull/17212))**

- **Add missing translations to case activity revisions
  ([16987](https://github.com/civicrm/civicrm-core/pull/16987))**

- **Case Details field is empty
  ([16995](https://github.com/civicrm/civicrm-core/pull/16995))**

  Ensures that the details field value is saved when creating a new case from
  the core form.

### CiviContribute

- **Contribution Detail Report gives incorrect results when `force=1`
  ([dev/report#20](https://lab.civicrm.org/dev/report/issues/20):
  [17234](https://github.com/civicrm/civicrm-core/pull/17234))**

- **Financial ACL Report check always fails
  ([dev/core#1700](https://lab.civicrm.org/dev/core/issues/1700):
  [17046](https://github.com/civicrm/civicrm-core/pull/17046))**

  Ensures that if Finacial Type ACL's are enabled and the extension
  `biz.jmaconsulting.financialaclreport` is installed the warning that you need
  to install the extension is not displayed.

- **On Behalf Of fails to populate in Email Receipt
  ([dev/core#57](https://lab.civicrm.org/dev/core/issues/57):
  [17026](https://github.com/civicrm/civicrm-core/pull/17026))**

  Fixes a bug where the On Behalf Of section was not being included in email
  receipts.

- **Fixes a regression when cancelling a recurring with no processor_id
  ([17292](https://github.com/civicrm/civicrm-core/pull/17292))**

- **Fix multiselect/checkbox custom field defaults on contribution online form
  ([16991](https://github.com/civicrm/civicrm-core/pull/16991))**

### CiviEvent

- **Fix multiselect/checkbox custom field defaults on registration profile
  ([16981](https://github.com/civicrm/civicrm-core/pull/16981))**

### CiviMail

- **Mailing Error when civicrm_mailing_group has duplicate entries of recipient
  groups([dev/mail#62](https://lab.civicrm.org/dev/mail/issues/62):
  [17130](https://github.com/civicrm/civicrm-core/pull/17130))**

### CiviMember

- **Membership batch entry: Fix join date population
  ([dev/core#1718](https://lab.civicrm.org/dev/core/issues/1718):
  [17099](https://github.com/civicrm/civicrm-core/pull/17099))**

  Ensures that when using the membership batch entry tool the "join date" is
  populated with existing data.

- **Fix bug where tax_amount is miscalculated on membership renewals
  ([16772](https://github.com/civicrm/civicrm-core/pull/16772))**

### Drupal Integration

- **UF Settings page doesn't show CiviCRM database details for Drupal 8 Views
  ([dev/core#1742](https://lab.civicrm.org/dev/core/issues/1742):
  [17232](https://github.com/civicrm/civicrm-core/pull/17232))**

### WordPress Integration

- **Support Clean URLs when using Polylang
  ([191](https://github.com/civicrm/civicrm-wordpress/pull/191),
  [189](https://github.com/civicrm/civicrm-wordpress/pull/189) and
  [176](https://github.com/civicrm/civicrm-wordpress/pull/176))**

  Ensures clean URLs work in WordPress with Polylang.

- **Fix WordPress support for Get UF Locale
  ([dev/core#1635](https://lab.civicrm.org/dev/core/issues/1635):
  [16700](https://github.com/civicrm/civicrm-core/pull/16700))**

  Ensures WordPress front end pages follow the CMS language set in CiviCRM
  instead of using the default CiviCRM language.

- **Styling issues after upgrade to WordPress 5.3
  ([dev/wordpress#46](https://lab.civicrm.org/dev/wordpress/issues/46):
  [16882](https://github.com/civicrm/civicrm-core/pull/16882))**

  Ensures Select fields look like Select2 fields for WordPress users.

- **CiviCRM front end pages broken on WP Latest (master)
  ([dev/wordpress#49](https://lab.civicrm.org/dev/wordpress/issues/49):
  [17352](https://github.com/civicrm/civicrm-core/pull/17352),
  [17424](https://github.com/civicrm/civicrm-core/pull/17424),
  [199](https://github.com/civicrm/civicrm-wordpress/pull/199), and
  [194](https://github.com/civicrm/civicrm-wordpress/pull/194))**

  `canonical_redirect()` will strip "page=CiviCRM" from front end pages. These
  changes ensures that CiviCRM plays nicely with this WordPress change.

- **Public mailing URL links are broken after merge of REST API wrapper code
  ([dev/wordpress#52](https://lab.civicrm.org/dev/wordpress/issues/52):
  [195](https://github.com/civicrm/civicrm-wordpress/pull/195))**

- **CiviMail doesn't send to full recipient list with merge of REST API wrapper
  code ([dev/wordpress#53](https://lab.civicrm.org/dev/wordpress/issues/53):
  [196](https://github.com/civicrm/civicrm-wordpress/pull/196))**

## <a name="misc"></a>Miscellany

- **CONTRIBUTORS.txt - Explain deprecation/archival ([17074](https://github.com/civicrm/civicrm-core/pull/17074))**

  Contributors are now recognized in release notes. To ensure a full history,
  the older `CONTRIBUTORS.txt` has been preserved, but it will not be updated for future releases.

- **Use isSerialized function rather guessing from html_type
  ([16979](https://github.com/civicrm/civicrm-core/pull/16979))**

- **Mitigate flaky test failure about
  "CRM_Utils_Check_Component_Env->checkVersion()"
  ([17038](https://github.com/civicrm/civicrm-core/pull/17038))**

- **Simplify groupContactCache - remove redundant query
  ([17011](https://github.com/civicrm/civicrm-core/pull/17011))**

- **Duplicate EmailCommon::buildQuickForm onto the trait
  ([17052](https://github.com/civicrm/civicrm-core/pull/17052))**

- **Make transaction param optional in completeOrder
  ([17053](https://github.com/civicrm/civicrm-core/pull/17053))**

- **Don't pass empty ids parameter, fix fatal
  ([17086](https://github.com/civicrm/civicrm-core/pull/17086))**

- **Less svn ([17159](https://github.com/civicrm/civicrm-core/pull/17159))**

- **OptionValue - Use DB defaults instead of setting them in BAO::add
  ([17170](https://github.com/civicrm/civicrm-core/pull/17170))**

- **Move batch-form support code back to the form
  ([17176](https://github.com/civicrm/civicrm-core/pull/17176))**

- **Start using apiv4 in test setup
  ([17020](https://github.com/civicrm/civicrm-core/pull/17020))**

- **Further removal of long-deprecated skipCleanMoney
  ([17175](https://github.com/civicrm/civicrm-core/pull/17175))**

- **Add workflow_name column to civicrm_msg_template, deprecate workflow_id
  ([17227](https://github.com/civicrm/civicrm-core/pull/17227))**

- **Misplaced text in the Additional Details section on New Contribution
  ([dev/user-interface#19](https://lab.civicrm.org/dev/user-interface/issues/19):
  [17135](https://github.com/civicrm/civicrm-core/pull/17135))**

- **Cleanup and throw exceptions in OpenCase form
  ([17184](https://github.com/civicrm/civicrm-core/pull/17184))**

- **Cleanup core pseudoconstant buildOptions
  ([17122](https://github.com/civicrm/civicrm-core/pull/17122))**

- **Gitlab issue template - Ask for link to stackexchange or chat conversations
  ([17186](https://github.com/civicrm/civicrm-core/pull/17186))**

- **Remove deprecated calls to optionValueQuery and no-longer-need param
  ([17182](https://github.com/civicrm/civicrm-core/pull/17182))**

- **Refactor api3 Payment.Get API to support options + most fields in
  civicrm_financial_trxn
  ([17071](https://github.com/civicrm/civicrm-core/pull/17071))**

- **Remove unused parameter, immediately overwritten parameter
  ([17131](https://github.com/civicrm/civicrm-core/pull/17131))**

- **Remove unused parameter from function
  ([17098](https://github.com/civicrm/civicrm-core/pull/17098))**

- **Remove outputHeader as a param for writeCSVFile as it is always true
  ([17051](https://github.com/civicrm/civicrm-core/pull/17051))**

- **Remove var that is defined on parent
  ([17102](https://github.com/civicrm/civicrm-core/pull/17102))**

- **Convert test to use APIV4 in setup for cleaner code
  ([17153](https://github.com/civicrm/civicrm-core/pull/17153))**

- **[Test] Extend custom field test trait & some related tests
  ([17037](https://github.com/civicrm/civicrm-core/pull/17037))**

- **E2E_Core_HookTest - Fix test failure due to leak
  ([17251](https://github.com/civicrm/civicrm-core/pull/17251))**

- **[NFC][Test] cleanup on customDataTrait for tests
  ([17022](https://github.com/civicrm/civicrm-core/pull/17022))**

- **[NFC][Test] Minor cleanup in test class
  ([17002](https://github.com/civicrm/civicrm-core/pull/17002))**

- **[NFC][Test] Preliminary cleanup
  ([17213](https://github.com/civicrm/civicrm-core/pull/17213))**

- **[NFC] [Test] minor code cleanup
  ([17152](https://github.com/civicrm/civicrm-core/pull/17152))**

- **[NFC] Minor code cleanups
  ([17019](https://github.com/civicrm/civicrm-core/pull/17019))**

- **[NFC] Superficial code clean up
  ([17155](https://github.com/civicrm/civicrm-core/pull/17155))**

- **(NFC) Remove $Id$ artifacts from old SCM
  ([17211](https://github.com/civicrm/civicrm-core/pull/17211))**

- **[NFC] A bit less svn in our code
  ([17157](https://github.com/civicrm/civicrm-core/pull/17157))**

- **[NFC] Fix use of pattern-hated-by-Coleman
  ([17049](https://github.com/civicrm/civicrm-core/pull/17049))**

- **[NFC] Cleanup CRM_Report_Form
  ([17141](https://github.com/civicrm/civicrm-core/pull/17141))**

- **(NFC) Comment clarification in test class
  ([17133](https://github.com/civicrm/civicrm-core/pull/17133))**

- **[NFC] Improve cleanup on membershipStatus to cope with undeleted memberships
  ([16756](https://github.com/civicrm/civicrm-core/pull/16756))**

- **[NFC] Remove calculation of unused parameter
  ([17093](https://github.com/civicrm/civicrm-core/pull/17093))**

- **(NFC) Gitlab Template - Request more detail about upgrade problems
  ([17101](https://github.com/civicrm/civicrm-core/pull/17101))**

- **[NFC] Remove a handful of legacy svn notations
  ([17070](https://github.com/civicrm/civicrm-core/pull/17070))**

- **[NFC/Test] - Fix typo in `if` statement that seems intended as a workaround
  ([17258](https://github.com/civicrm/civicrm-core/pull/17258))**

- **[NFC] Add Comment to avoid someone removing field only used in CiviCase
  extension ([17000](https://github.com/civicrm/civicrm-core/pull/17000))**

- **[NFC] Test cleanup
  ([17224](https://github.com/civicrm/civicrm-core/pull/17224))**

- **[NFC] Code cleanup around comments, strict comparison, formatting
  ([17058](https://github.com/civicrm/civicrm-core/pull/17058))**

- **[NFC] Remove all the places where tests unnecessarily pass  to
  Membership::create
  ([17088](https://github.com/civicrm/civicrm-core/pull/17088))**

- **[REF] SavedSearch - additional cleanup & bugfixes
  ([17090](https://github.com/civicrm/civicrm-core/pull/17090))**

- **(REF) dev/core#1744 - Cleanup event naming
  ([17240](https://github.com/civicrm/civicrm-core/pull/17240))**

- **[REF] [Test] IDE cleanup on ReportTemplateTest
  ([17197](https://github.com/civicrm/civicrm-core/pull/17197))**

- **[REF] Simplify non-creditcard participant.create
  ([16584](https://github.com/civicrm/civicrm-core/pull/16584))**

- **[REF] Fix install on Drupal 8 using new setup code
  ([17334](https://github.com/civicrm/civicrm-core/pull/17334))**

- **[REF] Minor var simplification
  ([17121](https://github.com/civicrm/civicrm-core/pull/17121))**

- **[REF] Consistently lookup dispatcher via `Civi::dispatcher()`
  ([17154](https://github.com/civicrm/civicrm-core/pull/17154))**

- **(REF,NFC) TokenProcessor - Minor DX improvements
  ([17231](https://github.com/civicrm/civicrm-core/pull/17231))**

- **[REF] Permit domain tokens being used within Thank You letters
  ([17230](https://github.com/civicrm/civicrm-core/pull/17230))**

- **(REF) CRM_Utils_Hook - Remove deprecated formulations of `invoke(int,…)`
  ([17124](https://github.com/civicrm/civicrm-core/pull/17124))**

- **[REF] Switch CRM_Utils_Array::value to empty in conditionals
  ([17091](https://github.com/civicrm/civicrm-core/pull/17091))**

- **[REF] Minor code cleanup
  ([17225](https://github.com/civicrm/civicrm-core/pull/17225))**

- **[REF] Minor code cleanup.
  ([17222](https://github.com/civicrm/civicrm-core/pull/17222))**

- **[REF] Reduce boilerplate code in BAO add/create functions
  ([17172](https://github.com/civicrm/civicrm-core/pull/17172))**

- **[REF] Minor cleanup around action schedule code.
  ([17151](https://github.com/civicrm/civicrm-core/pull/17151))**

- **[REF] get rid of variable variable structure
  ([17089](https://github.com/civicrm/civicrm-core/pull/17089))**

- **[REF] Remove duplicate checks for an array key existing
  ([17069](https://github.com/civicrm/civicrm-core/pull/17069))**

- **[REF] Import - extract duplicate code to function
  ([17080](https://github.com/civicrm/civicrm-core/pull/17080))**

- **[REF] Cleanup a few instances where we use old call to get loggedInUserID
  ([17196](https://github.com/civicrm/civicrm-core/pull/17196))**

- **[REF] Simplify determination of enabled components
  ([17195](https://github.com/civicrm/civicrm-core/pull/17195))**

- **[REF] stop overriding postProcess function in activity report detail
  ([17194](https://github.com/civicrm/civicrm-core/pull/17194))**

- **[REF] Reconcile CRM_Utils_System::getUrlPath and
  CRM_Utils_System::currentPath
  ([17068](https://github.com/civicrm/civicrm-core/pull/17068))**

- **[REF] Stop passing ids to membership::create from createRelatedMemberships
  ([17087](https://github.com/civicrm/civicrm-core/pull/17087))**

- **[REF] move all functions associated with  the submit function onto the Trait
  ([17057](https://github.com/civicrm/civicrm-core/pull/17057))**

- **[REF] APIv4 Explorer - improve performance
  ([17062](https://github.com/civicrm/civicrm-core/pull/17062))**

- **[REF] Clarify variable & tighten use.
  ([17016](https://github.com/civicrm/civicrm-core/pull/17016))**

- **[REF] Use bool instead of boolean
  ([17013](https://github.com/civicrm/civicrm-core/pull/17013))**

- **[REF] Formatting and use bool instead of boolean
  ([17012](https://github.com/civicrm/civicrm-core/pull/17012))**

- **[REF] Move generic preProcess function to the trait
  ([16954](https://github.com/civicrm/civicrm-core/pull/16954))**

- **[REF] Extract transferParticipantRegistration function
  ([16976](https://github.com/civicrm/civicrm-core/pull/16976))**

- **REF Remove redundant param from completeOrder
  ([17034](https://github.com/civicrm/civicrm-core/pull/17034))**

- **[REF] Update Contact email form to use the trait for EmailCommon functions
  ([17031](https://github.com/civicrm/civicrm-core/pull/17031))**

- **[REF] Move generic instances of listTokens to trait
  ([17029](https://github.com/civicrm/civicrm-core/pull/17029))**

- **[REF] CustomField code cleanup to use isSerialized method
  ([17009](https://github.com/civicrm/civicrm-core/pull/17009))**

- **[REF] CustomField code cleanup
  ([16968](https://github.com/civicrm/civicrm-core/pull/16968))**

- **[REF] Cleanup customField prepareCreate function
  ([16996](https://github.com/civicrm/civicrm-core/pull/16996))**

- **[REF] Update custom data handing in contact import
  ([16986](https://github.com/civicrm/civicrm-core/pull/16986))**

- **[REF] CustomGroup - cleanup handling of serialized fields in old function
  ([16970](https://github.com/civicrm/civicrm-core/pull/16970))**

- **[REF] APIv4 - Enforce contact field permissions via metadata
  ([17168](https://github.com/civicrm/civicrm-core/pull/17168))**

- **[REF] Code readability changes on activity tokens.
  ([17161](https://github.com/civicrm/civicrm-core/pull/17161))**

- **[REF] Minor extraction
  ([17160](https://github.com/civicrm/civicrm-core/pull/17160))**

- **[REF] CustomField - Remove pointless caching and move form variable to form
  class ([16975](https://github.com/civicrm/civicrm-core/pull/16975))**

- **[REF] Call makeCSVTable function directly from writeRows
  ([16980](https://github.com/civicrm/civicrm-core/pull/16980))**

- **[REF] CRM_Utils_Array::value -> empty
  ([288](https://github.com/civicrm/civicrm-packages/pull/288))**

- **[REF] Update XML file to match updated title in DAO File
  ([16969](https://github.com/civicrm/civicrm-core/pull/16969))**

- **[REF] Cleanup custom field handling... twice
  ([16989](https://github.com/civicrm/civicrm-core/pull/16989))**

- **[REF] Cleanup CustomField BAO to use its own isSerialized function
  ([16990](https://github.com/civicrm/civicrm-core/pull/16990))**

- **Cleanup custom field handling in ufGroup BAO
  ([16984](https://github.com/civicrm/civicrm-core/pull/16984))**

- **Code cleanup - replace overcomplicated test for null with isset
  ([16965](https://github.com/civicrm/civicrm-core/pull/16965))**

- **Update 5.24.2.md - Fix version number in title.
  ([17043](https://github.com/civicrm/civicrm-core/pull/17043))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

a-n The Artists Information Company - William Mortada; AGH Strategies - Alice
Frumin, Andrew Hunt; Andrei Mondoc; Christian Wach; Circle Interactive - Dave
Jenkins, Pradeep Nayak; CiviCRM - Coleman Watts, Josh Gowans, Tim Otten;
CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy; Dave D; Fuzion -
Jitendra Purohit; Greenpeace Central and Eastern Europe - Patrick Figel; All In
Appli.com - Guillaume Sorel; CompuCorp - Ivan; JMA Consulting - Seamus Lee;
Lighthouse Design and Consulting - Brian Shaughnessy; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Ray Wright; Third
Sector Design - Michael McAndrew; Timbsoft Technologies - Tunbola Ogunwande;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Andrew Cormick-Dockery; Andy Burns; Artful Robot - Rich Lott;  Blackfly
Solutions - Alan Dixon; CiviCoop - Jaap Jansma; Fuzion - Peter Davis; GMCVO
Databases - Jade Gaunt; JMA Consulting - Monish Deb; MJCO - Mikey O'Toole;
Richard van Oosterhout; Squiffle Consulting - Aidan Saunders;
Tadpole Collective - Kevin Cristiano; Team Expansion - Greg Harris

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
