*** Settings ***
Documentation       Netapp Ontap Restapi Volumes plugin

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Start Mockoon    ${MOCKOON_JSON}
Suite Teardown      Stop Mockoon
Test Timeout        120s


*** Variables ***
${MOCKOON_JSON}         ${CURDIR}${/}netapp.json

${cmd}              ${CENTREON_PLUGINS}
...                 --plugin=storage::netapp::ontap::restapi::plugin
...                 --hostname=${HOSTNAME}
...                 --port=${APIPORT}
...                 --proto=http
...                 --api-username=username
...                 --api-password=password
...                 --mode=volumes


*** Test Cases ***
Volumes ${tc}
    [Tags]    storage    netapp    ontapp    api    volumes    mockoon   
    ${command}    Catenate
    ...    ${CMD}
    ...    ${extra_options}

    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:         tc  extra_options                                                      expected_result    --
            ...       1   ${EMPTY}                                                           OK: Volume 'svm1:volume1' state: online, space usage total: 4.00 TB used: 2.82 TB (90.42%) free: 392.42 GB (9.58%), logical-usage : skipped (no value(s)), logical-usage-free : skipped (no value(s)), logical-usage-prct : skipped (no value(s)), read iops: 200, write iops: 100, other iops: 100, total iops: 1000, read latency: 0.2 ms, write latency: 0.1 ms, other latency: 0.1 ms, total latency: 1 ms | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       2   --filter-volume-name='volume1'                                     OK: Volume 'svm1:volume1' state: online, space usage total: 4.00 TB used: 2.82 TB (90.42%) free: 392.42 GB (9.58%), logical space usage total: 3.20 TB used: 2.88 TB (90.00%) free: 325.03 GB (10.00%), read iops: 200, write iops: 100, other iops: 100, total iops: 1000, read latency: 0.2 ms, write latency: 0.1 ms, other latency: 0.1 ms, total latency: 1 ms | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;;0;100 'svm1:volume1#volume.logicalspace.usage.bytes'=3169438617600B;;;0;3518437212160 'svm1:volume1#volume.logicalspace.free.bytes'=348998594560B;;;0;3518437212160 'svm1:volume1#volume.logicalspace.usage.percentage'=90.00%;;;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       3   --filter-name='volume1'                                            OK: Volume 'svm1:volume1' state: online, space usage total: 4.00 TB used: 2.82 TB (90.42%) free: 392.42 GB (9.58%), logical-usage : skipped (no value(s)), logical-usage-free : skipped (no value(s)), logical-usage-prct : skipped (no value(s)), read iops: 200, write iops: 100, other iops: 100, total iops: 1000, read latency: 0.2 ms, write latency: 0.1 ms, other latency: 0.1 ms, total latency: 1 ms | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       4   --warning-status='\\\%{state} !~ /notonline/i'                     WARNING: Volume 'svm1:volume1' state: online | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       5   --critical-status='\\\%{state} !~ /notonline/i'                    CRITICAL: Volume 'svm1:volume1' state: online | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       6   --warning-usage-prct=50                                            WARNING: Volume 'svm1:volume1' space usage total: 4.00 TB used: 2.82 TB (90.42%) free: 392.42 GB (9.58%) | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;0:50;;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       7   --critical-usage-prct=50                                           CRITICAL: Volume 'svm1:volume1' space usage total: 4.00 TB used: 2.82 TB (90.42%) free: 392.42 GB (9.58%) | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;0:50;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       8   --filter-volume-name='volume1' --warning-logical-usage-prct=50     WARNING: Volume 'svm1:volume1' logical space usage total: 3.20 TB used: 2.88 TB (90.00%) free: 325.03 GB (10.00%) | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;;0;100 'svm1:volume1#volume.logicalspace.usage.bytes'=3169438617600B;;;0;3518437212160 'svm1:volume1#volume.logicalspace.free.bytes'=348998594560B;;;0;3518437212160 'svm1:volume1#volume.logicalspace.usage.percentage'=90.00%;0:50;;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
            ...       9   --filter-volume-name='volume1' --critical-logical-usage-prct=50    CRITICAL: Volume 'svm1:volume1' logical space usage total: 3.20 TB used: 2.88 TB (90.00%) free: 325.03 GB (10.00%) | 'svm1:volume1#volume.space.usage.bytes'=3097083330560B;;;0;4398046511104 'svm1:volume1#volume.space.free.bytes'=421353881600B;;;0;4398046511104 'svm1:volume1#volume.space.usage.percentage'=90.42%;;;0;100 'svm1:volume1#volume.logicalspace.usage.bytes'=3169438617600B;;;0;3518437212160 'svm1:volume1#volume.logicalspace.free.bytes'=348998594560B;;;0;3518437212160 'svm1:volume1#volume.logicalspace.usage.percentage'=90.00%;;0:50;0;100 'svm1:volume1#volume.io.read.usage.bytespersecond'=200B/s;;;; 'svm1:volume1#volume.io.write.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.other.usage.bytespersecond'=100B/s;;;0; 'svm1:volume1#volume.io.total.usage.bytespersecond'=1000B/s;;;0; 'svm1:volume1#volume.io.read.usage.iops'=200iops;;;0; 'svm1:volume1#volume.io.write.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.other.usage.iops'=100iops;;;0; 'svm1:volume1#volume.io.total.usage.iops'=1000iops;;;0; 'svm1:volume1#volume.io.read.latency.milliseconds'=0.2ms;;;0; 'svm1:volume1#volume.io.write.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.other.latency.milliseconds'=0.1ms;;;0; 'svm1:volume1#volume.io.total.latency.milliseconds'=1ms;;;0;
