#ifndef COMPARE_H
#define COMPARE_H

#include <cmath>
#include <cstring>
#include <string>

// compare
// clang-format off
const auto is_not_equal = [](auto a, auto b) noexcept { return  (a < b || b < a); };
const auto is_equal     = [](auto a, auto b) noexcept { return !(a < b || b < a); };
const auto dbl_is_equal = [](auto a, auto b) noexcept { return (std::isnan(a) || std::isnan(b) ? (std::isnan(a) && std::isnan(b)) : is_equal(a, b)); };
// clang-format on

// #define DBL_IS_EQUAL(x,y) (!(x < y || y < x))
// #define DBL_IS_EQUAL(x, y) (std::isnan(x) || std::isnan(y) ? (std::isnan(x) && std::isnan(y) ? 1 : 0) : !(x < y || y < x))
static inline bool
DBL_IS_EQUAL(double x, double y)
{
  return (std::isnan(x) || std::isnan(y) ? (std::isnan(x) && std::isnan(y)) : !(x < y || y < x));
}

// #define IS_EQUAL(x, y) (!IS_NOT_EQUAL(x, y))
constexpr bool
IS_NOT_EQUAL(double x, double y) noexcept
{
  return (x < y || y < x);
}

constexpr bool
IS_EQUAL(double x, double y) noexcept
{
  return !(x < y || y < x);
}

static inline bool
cdo_cmpstr(const char *x, const char *y)
{
  return (strcmp(x, y) == 0);
}

static inline bool
cdo_cmpstr(const std::string &lhs, const std::string &rhs)
{
  return (lhs.compare(rhs) == 0);
}
static inline bool
cdo_cmpstr(const std::string_view &lhs, const std::string &rhs)
{
  return (lhs.compare(rhs) == 0);
}

#endif /* COMPARE_H */
