//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/SampleModel.h
//! @brief     Defines class SampleModel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_SAMPLEMODEL_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_SAMPLEMODEL_H

#include "Base/Types/OwningVector.h"
#include <QVector>
#include <QXmlStreamReader>

class SampleItem;

//! Main model to hold sample items.

class SampleModel {
public:
    ~SampleModel();
    QVector<SampleItem*> sampleItems() const;

    SampleItem* addSampleItem();
    void addSampleItem(SampleItem* sample);
    void removeSample(SampleItem* sample);

    QStringList sampleNames() const;

    void writeTo(QXmlStreamWriter* w) const;
    void readFrom(QXmlStreamReader* r);

    int selectedIndex() const { return m_selectedIndex; }
    void setSelectedIndex(int newIndex) { m_selectedIndex = newIndex; }

private:
    OwningVector<SampleItem> m_samples;
    int m_selectedIndex = -1;
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_SAMPLEMODEL_H
