/* VideoMonitor.c generated by valac 0.40.4, the Vala compiler
 * generated from VideoMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_MONITORABLE_UPDATES (monitorable_updates_get_type ())
#define MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdates))
#define MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))
#define IS_MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE_UPDATES))
#define IS_MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITORABLE_UPDATES))
#define MONITORABLE_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))

typedef struct _MonitorableUpdates MonitorableUpdates;
typedef struct _MonitorableUpdatesClass MonitorableUpdatesClass;
typedef struct _MonitorableUpdatesPrivate MonitorableUpdatesPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_VIDEO_UPDATES (video_updates_get_type ())
#define VIDEO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_UPDATES, VideoUpdates))
#define VIDEO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_UPDATES, VideoUpdatesClass))
#define IS_VIDEO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_UPDATES))
#define IS_VIDEO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_UPDATES))
#define VIDEO_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_UPDATES, VideoUpdatesClass))

typedef struct _VideoUpdates VideoUpdates;
typedef struct _VideoUpdatesClass VideoUpdatesClass;
typedef struct _VideoUpdatesPrivate VideoUpdatesPrivate;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
typedef struct _MediaMonitorPrivate MediaMonitorPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;
typedef struct _VideoMonitorPrivate VideoMonitorPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;
enum  {
	VIDEO_MONITOR_0_PROPERTY,
	VIDEO_MONITOR_NUM_PROPERTIES
};
static GParamSpec* video_monitor_properties[VIDEO_MONITOR_NUM_PROPERTIES];
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;

#define VIDEO_SOURCE_COLLECTION_TYPE_STATE (video_source_collection_state_get_type ())
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB (video_monitor_video_interpretable_check_job_get_type ())
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob))
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJobClass))
#define VIDEO_MONITOR_IS_VIDEO_INTERPRETABLE_CHECK_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB))
#define VIDEO_MONITOR_IS_VIDEO_INTERPRETABLE_CHECK_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB))
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJobClass))

typedef struct _VideoMonitorVideoInterpretableCheckJob VideoMonitorVideoInterpretableCheckJob;
typedef struct _VideoMonitorVideoInterpretableCheckJobClass VideoMonitorVideoInterpretableCheckJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _VideoMonitorVideoInterpretableCheckJobPrivate VideoMonitorVideoInterpretableCheckJobPrivate;

#define VIDEO_TYPE_INTERPRETABLE_RESULTS (video_interpretable_results_get_type ())
#define VIDEO_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults))
#define VIDEO_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))
#define VIDEO_IS_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_IS_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_INTERPRETABLE_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))

typedef struct _VideoInterpretableResults VideoInterpretableResults;
typedef struct _VideoInterpretableResultsClass VideoInterpretableResultsClass;
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _MonitorableUpdates {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorableUpdatesPrivate * priv;
	Monitorable* monitorable;
};

struct _MonitorableUpdatesClass {
	GTypeClass parent_class;
	void (*finalize) (MonitorableUpdates *self);
	gboolean (*is_in_alteration) (MonitorableUpdates* self);
	void (*set_master_file) (MonitorableUpdates* self, GFile* file);
	void (*set_master_file_info_altered) (MonitorableUpdates* self, gboolean altered);
	void (*set_master_file_info) (MonitorableUpdates* self, GFileInfo* info);
	void (*set_master_in_alteration) (MonitorableUpdates* self, gboolean in_alteration);
	void (*set_master_alterations_complete) (MonitorableUpdates* self, GFileInfo* info);
	void (*mark_offline) (MonitorableUpdates* self);
	void (*mark_online) (MonitorableUpdates* self);
	void (*reset_online_offline) (MonitorableUpdates* self);
	gboolean (*is_all_updated) (MonitorableUpdates* self);
};

struct _VideoUpdates {
	MonitorableUpdates parent_instance;
	VideoUpdatesPrivate * priv;
	Video* video;
};

struct _VideoUpdatesClass {
	MonitorableUpdatesClass parent_class;
	void (*set_check_interpretable) (VideoUpdates* self, gboolean check);
};

struct _VideoUpdatesPrivate {
	gboolean check_interpretable;
};

typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

struct _MediaMonitor {
	GObject parent_instance;
	MediaMonitorPrivate * priv;
};

struct _MediaMonitorClass {
	GObjectClass parent_class;
	MediaSourceCollection* (*get_media_source_collection) (MediaMonitor* self);
	void (*close) (MediaMonitor* self);
	gchar* (*to_string) (MediaMonitor* self);
	MonitorableUpdates* (*create_updates) (MediaMonitor* self, Monitorable* monitorable);
	void (*on_media_source_destroyed) (MediaMonitor* self, DataSource* source);
	void (*notify_discovery_started) (MediaMonitor* self);
	MediaMonitorDiscoveredFile (*notify_file_discovered) (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable* * monitorable);
	GeeCollection* (*candidates_for_unknown_file) (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
	GFile** (*get_auxilliary_backing_files) (MediaMonitor* self, Monitorable* monitorable, int* result_length1);
	void (*update_backing_file_info) (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
	void (*notify_discovery_completing) (MediaMonitor* self);
	gboolean (*is_file_represented) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_created) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_moved) (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	gboolean (*notify_file_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_attributes_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_alteration_completed) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_deleted) (MediaMonitor* self, GFile* file);
	void (*process_updates) (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
};

struct _VideoMonitor {
	MediaMonitor parent_instance;
	VideoMonitorPrivate * priv;
};

struct _VideoMonitorClass {
	MediaMonitorClass parent_class;
};

struct _VideoMonitorPrivate {
	Workers* workers;
	guint64 background_jobs;
};

typedef enum  {
	VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN,
	VIDEO_SOURCE_COLLECTION_STATE_ONLINE,
	VIDEO_SOURCE_COLLECTION_STATE_OFFLINE,
	VIDEO_SOURCE_COLLECTION_STATE_TRASH
} VideoSourceCollectionState;

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _VideoMonitorVideoInterpretableCheckJob {
	BackgroundJob parent_instance;
	VideoMonitorVideoInterpretableCheckJobPrivate * priv;
	Video* video;
	VideoInterpretableResults* results;
};

struct _VideoMonitorVideoInterpretableCheckJobClass {
	BackgroundJobClass parent_class;
};

typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);

static gpointer video_updates_parent_class = NULL;
static gpointer video_monitor_parent_class = NULL;
extern VideoSourceCollection* video_global;
static gpointer video_monitor_video_interpretable_check_job_parent_class = NULL;

gpointer monitorable_updates_ref (gpointer instance);
void monitorable_updates_unref (gpointer instance);
GParamSpec* param_spec_monitorable_updates (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_monitorable_updates (GValue* value,
                                    gpointer v_object);
void value_take_monitorable_updates (GValue* value,
                                     gpointer v_object);
gpointer value_get_monitorable_updates (const GValue* value);
GType monitorable_updates_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
GType video_updates_get_type (void) G_GNUC_CONST;
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
#define VIDEO_UPDATES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_UPDATES, VideoUpdatesPrivate))
VideoUpdates* video_updates_new (Video* video);
VideoUpdates* video_updates_construct (GType object_type,
                                       Video* video);
MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable);
MonitorableUpdates* monitorable_updates_construct (GType object_type,
                                                   Monitorable* monitorable);
void video_updates_set_check_interpretable (VideoUpdates* self,
                                            gboolean check);
static void video_updates_real_set_check_interpretable (VideoUpdates* self,
                                                 gboolean check);
static void video_updates_real_mark_online (MonitorableUpdates* base);
void monitorable_updates_mark_online (MonitorableUpdates* self);
gboolean video_updates_is_check_interpretable (VideoUpdates* self);
static gboolean video_updates_real_is_all_updated (MonitorableUpdates* base);
gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self);
static void video_updates_finalize (MonitorableUpdates * obj);
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
GType video_monitor_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_workers (GValue* value,
                        gpointer v_object);
void value_take_workers (GValue* value,
                         gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
#define VIDEO_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_MONITOR, VideoMonitorPrivate))
Workers* workers_new (guint max_threads,
                      gboolean exclusive);
Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
#define VIDEO_MONITOR_MAX_INTERPRETABLE_CHECKS_PER_CYCLE 5
VideoMonitor* video_monitor_new (GCancellable* cancellable);
VideoMonitor* video_monitor_construct (GType object_type,
                                       GCancellable* cancellable);
GType video_source_collection_get_type (void) G_GNUC_CONST;
MediaMonitor* media_monitor_construct (GType object_type,
                                       MediaSourceCollection* sources,
                                       GCancellable* cancellable);
GeeCollection* data_collection_get_all (DataCollection* self);
gboolean video_get_is_interpretable (Video* self);
void video_monitor_set_check_interpretable (VideoMonitor* self,
                                            Video* video,
                                            gboolean check);
static MonitorableUpdates* video_monitor_real_create_updates (MediaMonitor* base,
                                                       Monitorable* monitorable);
static MediaSourceCollection* video_monitor_real_get_media_source_collection (MediaMonitor* base);
static gboolean video_monitor_real_is_file_represented (MediaMonitor* base,
                                                 GFile* file);
GType video_source_collection_state_get_type (void) G_GNUC_CONST;
static Video* video_monitor_get_state (VideoMonitor* self,
                                GFile* file,
                                VideoSourceCollectionState* state);
static MediaMonitorDiscoveredFile video_monitor_real_notify_file_discovered (MediaMonitor* base,
                                                                      GFile* file,
                                                                      GFileInfo* info,
                                                                      Monitorable* * monitorable);
static GeeCollection* video_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                               GFile* file,
                                                               GFileInfo* info,
                                                               MediaMonitorDiscoveredFile* _result_);
void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self,
                                                        GFileInfo* info,
                                                        GeeCollection* matching_master);
static gboolean video_monitor_real_notify_file_created (MediaMonitor* base,
                                                 GFile* file,
                                                 GFileInfo* info);
void media_monitor_update_online (MediaMonitor* self,
                                  Monitorable* monitorable);
static gboolean video_monitor_real_notify_file_moved (MediaMonitor* base,
                                               GFile* old_file,
                                               GFile* new_file,
                                               GFileInfo* new_file_info);
void media_monitor_update_master_file (MediaMonitor* self,
                                       Monitorable* monitorable,
                                       GFile* file);
void media_monitor_update_offline (MediaMonitor* self,
                                   Monitorable* monitorable);
static gboolean video_monitor_real_notify_file_altered (MediaMonitor* base,
                                                 GFile* file);
static gboolean video_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                            GFile* file);
void media_monitor_update_master_file_info_altered (MediaMonitor* self,
                                                    Monitorable* monitorable);
void media_monitor_update_master_file_in_alteration (MediaMonitor* self,
                                                     Monitorable* monitorable,
                                                     gboolean in_alteration);
static gboolean video_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                              GFile* file,
                                                              GFileInfo* info);
void media_monitor_update_master_file_alterations_completed (MediaMonitor* self,
                                                             Monitorable* monitorable,
                                                             GFileInfo* info);
static gboolean video_monitor_real_notify_file_deleted (MediaMonitor* base,
                                                 GFile* file);
GeeCollection* media_monitor_get_monitorables (MediaMonitor* self);
VideoUpdates* video_monitor_get_existing_video_updates (VideoMonitor* self,
                                                        Video* video);
GFile* monitorable_updates_get_master_file (MonitorableUpdates* self);
GFile* media_source_get_master_file (MediaSource* self);
Video* video_source_collection_get_state_by_file (VideoSourceCollection* self,
                                                  GFile* file,
                                                  VideoSourceCollectionState* state);
VideoUpdates* video_monitor_fetch_video_updates (VideoMonitor* self,
                                                 Video* video);
MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self,
                                                 Monitorable* monitorable);
MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self,
                                                        Monitorable* monitorable);
static void video_monitor_real_process_updates (MediaMonitor* base,
                                         GeeCollection* all_updates,
                                         TransactionController* controller,
                                         gint* op_count,
                                         GError** error);
void media_monitor_process_updates (MediaMonitor* self,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error);
#define MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE 100
void media_monitor_mdbg (const gchar* msg);
void video_notify_offline_thumbs_regenerated (void);
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_background_job (GValue* value,
                               gpointer v_object);
void value_take_background_job (GValue* value,
                                gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static void video_monitor_on_interpretable_check_complete (VideoMonitor* self,
                                                    BackgroundJob* j);
static void _video_monitor_on_interpretable_check_complete_completion_callback (BackgroundJob* job,
                                                                         gpointer self);
static VideoMonitorVideoInterpretableCheckJob* video_monitor_video_interpretable_check_job_new (Video* video,
                                                                                         CompletionCallback callback,
                                                                                         void* callback_target);
static VideoMonitorVideoInterpretableCheckJob* video_monitor_video_interpretable_check_job_construct (GType object_type,
                                                                                               Video* video,
                                                                                               CompletionCallback callback,
                                                                                               void* callback_target);
static GType video_monitor_video_interpretable_check_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
gpointer video_interpretable_results_ref (gpointer instance);
void video_interpretable_results_unref (gpointer instance);
GParamSpec* video_param_spec_interpretable_results (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void video_value_set_interpretable_results (GValue* value,
                                            gpointer v_object);
void video_value_take_interpretable_results (GValue* value,
                                             gpointer v_object);
gpointer video_value_get_interpretable_results (const GValue* value);
GType video_interpretable_results_get_type (void) G_GNUC_CONST;
void video_interpretable_results_foreground_finish (VideoInterpretableResults* self);
void video_notify_normal_thumbs_regenerated (void);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         void* callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         void* cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static void video_monitor_video_interpretable_check_job_real_execute (BackgroundJob* base);
VideoInterpretableResults* video_check_is_interpretable (Video* self);
static void video_monitor_video_interpretable_check_job_finalize (BackgroundJob * obj);
static void video_monitor_finalize (GObject * obj);


static gpointer
_g_object_ref0 (gpointer self)
{
#line 15 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 661 "VideoMonitor.c"
}


VideoUpdates*
video_updates_construct (GType object_type,
                         Video* video)
{
	VideoUpdates* self = NULL;
	Video* _tmp0_;
#line 12 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO (video), NULL);
#line 13 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = (VideoUpdates*) monitorable_updates_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MONITORABLE, Monitorable));
#line 15 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = _g_object_ref0 (video);
#line 15 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (self->video);
#line 15 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->video = _tmp0_;
#line 12 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return self;
#line 683 "VideoMonitor.c"
}


VideoUpdates*
video_updates_new (Video* video)
{
#line 12 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return video_updates_construct (TYPE_VIDEO_UPDATES, video);
#line 692 "VideoMonitor.c"
}


static void
video_updates_real_set_check_interpretable (VideoUpdates* self,
                                            gboolean check)
{
#line 19 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->priv->check_interpretable = check;
#line 702 "VideoMonitor.c"
}


void
video_updates_set_check_interpretable (VideoUpdates* self,
                                       gboolean check)
{
#line 18 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_if_fail (IS_VIDEO_UPDATES (self));
#line 18 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	VIDEO_UPDATES_GET_CLASS (self)->set_check_interpretable (self, check);
#line 714 "VideoMonitor.c"
}


static void
video_updates_real_mark_online (MonitorableUpdates* base)
{
	VideoUpdates * self;
#line 22 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_UPDATES, VideoUpdates);
#line 23 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 25 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_updates_set_check_interpretable (self, TRUE);
#line 728 "VideoMonitor.c"
}


gboolean
video_updates_is_check_interpretable (VideoUpdates* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO_UPDATES (self), FALSE);
#line 29 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = self->priv->check_interpretable;
#line 29 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = _tmp0_;
#line 29 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 745 "VideoMonitor.c"
}


static gboolean
video_updates_real_is_all_updated (MonitorableUpdates* base)
{
	VideoUpdates * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
#line 32 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_UPDATES, VideoUpdates);
#line 33 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = self->priv->check_interpretable;
#line 33 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp1_ == FALSE) {
#line 33 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp0_ = MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->is_all_updated (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 764 "VideoMonitor.c"
	} else {
#line 33 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp0_ = FALSE;
#line 768 "VideoMonitor.c"
	}
#line 33 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 774 "VideoMonitor.c"
}


static void
video_updates_class_init (VideoUpdatesClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_updates_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->finalize = video_updates_finalize;
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_type_class_add_private (klass, sizeof (VideoUpdatesPrivate));
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((VideoUpdatesClass *) klass)->set_check_interpretable = (void (*) (VideoUpdates *, gboolean)) video_updates_real_set_check_interpretable;
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->mark_online = (void (*) (MonitorableUpdates *)) video_updates_real_mark_online;
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->is_all_updated = (gboolean (*) (MonitorableUpdates *)) video_updates_real_is_all_updated;
#line 793 "VideoMonitor.c"
}


static void
video_updates_instance_init (VideoUpdates * self)
{
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->priv = VIDEO_UPDATES_GET_PRIVATE (self);
#line 10 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->priv->check_interpretable = FALSE;
#line 804 "VideoMonitor.c"
}


static void
video_updates_finalize (MonitorableUpdates * obj)
{
	VideoUpdates * self;
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_UPDATES, VideoUpdates);
#line 8 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (self->video);
#line 7 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->finalize (obj);
#line 818 "VideoMonitor.c"
}


GType
video_updates_get_type (void)
{
	static volatile gsize video_updates_type_id__volatile = 0;
	if (g_once_init_enter (&video_updates_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoUpdates), 0, (GInstanceInitFunc) video_updates_instance_init, NULL };
		GType video_updates_type_id;
		video_updates_type_id = g_type_register_static (TYPE_MONITORABLE_UPDATES, "VideoUpdates", &g_define_type_info, 0);
		g_once_init_leave (&video_updates_type_id__volatile, video_updates_type_id);
	}
	return video_updates_type_id__volatile;
}


VideoMonitor*
video_monitor_construct (GType object_type,
                         GCancellable* cancellable)
{
	VideoMonitor * self = NULL;
	VideoSourceCollection* _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 66 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = video_global;
#line 66 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = (VideoMonitor*) media_monitor_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), cancellable);
#line 848 "VideoMonitor.c"
	{
		GeeIterator* _obj_it = NULL;
		VideoSourceCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp1_ = video_global;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp2_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp3_ = _tmp2_;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp5_ = _tmp4_;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_obj_it = _tmp5_;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		while (TRUE) {
#line 872 "VideoMonitor.c"
			GeeIterator* _tmp6_;
			DataObject* obj = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			Video* video = NULL;
			DataObject* _tmp9_;
			Video* _tmp10_;
			Video* _tmp11_;
			Video* _tmp12_;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp6_ = _obj_it;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				break;
#line 888 "VideoMonitor.c"
			}
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp7_ = _obj_it;
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			obj = (DataObject*) _tmp8_;
#line 69 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp9_ = obj;
#line 69 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_VIDEO) ? ((Video*) _tmp9_) : NULL);
#line 69 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			video = _tmp10_;
#line 70 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp11_ = video;
#line 70 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_vala_assert (_tmp11_ != NULL, "video != null");
#line 71 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp12_ = video;
#line 71 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (!video_get_is_interpretable (_tmp12_)) {
#line 910 "VideoMonitor.c"
				Video* _tmp13_;
#line 72 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp13_ = video;
#line 72 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				video_monitor_set_check_interpretable (self, _tmp13_, TRUE);
#line 916 "VideoMonitor.c"
			}
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (video);
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (obj);
#line 922 "VideoMonitor.c"
		}
#line 68 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (_obj_it);
#line 926 "VideoMonitor.c"
	}
#line 65 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return self;
#line 930 "VideoMonitor.c"
}


VideoMonitor*
video_monitor_new (GCancellable* cancellable)
{
#line 65 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return video_monitor_construct (TYPE_VIDEO_MONITOR, cancellable);
#line 939 "VideoMonitor.c"
}


static MonitorableUpdates*
video_monitor_real_create_updates (MediaMonitor* base,
                                   Monitorable* monitorable)
{
	VideoMonitor * self;
	MonitorableUpdates* result = NULL;
	VideoUpdates* _tmp0_;
#line 76 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 76 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 77 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (monitorable, TYPE_VIDEO), "monitorable is Video");
#line 79 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = video_updates_new (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_VIDEO, Video));
#line 79 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates);
#line 79 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 962 "VideoMonitor.c"
}


static gpointer
_data_collection_ref0 (gpointer self)
{
#line 83 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return self ? data_collection_ref (self) : NULL;
#line 971 "VideoMonitor.c"
}


static MediaSourceCollection*
video_monitor_real_get_media_source_collection (MediaMonitor* base)
{
	VideoMonitor * self;
	MediaSourceCollection* result = NULL;
	VideoSourceCollection* _tmp0_;
	MediaSourceCollection* _tmp1_;
#line 82 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 83 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = video_global;
#line 83 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = _data_collection_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 83 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = _tmp1_;
#line 83 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 992 "VideoMonitor.c"
}


static gboolean
video_monitor_real_is_file_represented (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	gboolean result = FALSE;
	VideoSourceCollectionState state = 0;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	gboolean _tmp3_;
#line 86 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 86 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 88 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
#line 88 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	state = _tmp0_;
#line 88 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 88 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 88 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (_tmp2_);
#line 88 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = _tmp3_;
#line 88 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1025 "VideoMonitor.c"
}


static MediaMonitorDiscoveredFile
video_monitor_real_notify_file_discovered (MediaMonitor* base,
                                           GFile* file,
                                           GFileInfo* info,
                                           Monitorable* * monitorable)
{
	VideoMonitor * self;
	Monitorable* _vala_monitorable = NULL;
	MediaMonitorDiscoveredFile result = 0;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	VideoSourceCollectionState _tmp3_;
#line 91 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 91 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 91 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), 0);
#line 94 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
#line 94 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	state = _tmp0_;
#line 94 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video = _tmp1_;
#line 95 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = video;
#line 95 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 96 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (_vala_monitorable);
#line 96 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_vala_monitorable = NULL;
#line 98 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 98 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (video);
#line 98 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		if (monitorable) {
#line 98 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			*monitorable = _vala_monitorable;
#line 1072 "VideoMonitor.c"
		} else {
#line 98 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 1076 "VideoMonitor.c"
		}
#line 98 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		return result;
#line 1080 "VideoMonitor.c"
	}
#line 101 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = state;
#line 101 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	switch (_tmp3_) {
#line 101 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		case VIDEO_SOURCE_COLLECTION_STATE_ONLINE:
#line 101 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		case VIDEO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 1090 "VideoMonitor.c"
		{
			Video* _tmp4_;
			Monitorable* _tmp5_;
#line 104 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp4_ = video;
#line 104 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MONITORABLE, Monitorable));
#line 104 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 104 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_vala_monitorable = _tmp5_;
#line 106 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			result = MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED;
#line 106 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (video);
#line 106 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (monitorable) {
#line 106 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				*monitorable = _vala_monitorable;
#line 1110 "VideoMonitor.c"
			} else {
#line 106 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (_vala_monitorable);
#line 1114 "VideoMonitor.c"
			}
#line 106 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			return result;
#line 1118 "VideoMonitor.c"
		}
		default:
#line 101 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		case VIDEO_SOURCE_COLLECTION_STATE_TRASH:
#line 1123 "VideoMonitor.c"
		{
#line 111 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 111 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_vala_monitorable = NULL;
#line 113 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
#line 113 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (video);
#line 113 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (monitorable) {
#line 113 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				*monitorable = _vala_monitorable;
#line 1137 "VideoMonitor.c"
			} else {
#line 113 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (_vala_monitorable);
#line 1141 "VideoMonitor.c"
			}
#line 113 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			return result;
#line 1145 "VideoMonitor.c"
		}
	}
#line 91 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (video);
#line 91 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (monitorable) {
#line 91 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		*monitorable = _vala_monitorable;
#line 1154 "VideoMonitor.c"
	} else {
#line 91 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (_vala_monitorable);
#line 1158 "VideoMonitor.c"
	}
}


static GeeCollection*
video_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                GFile* file,
                                                GFileInfo* info,
                                                MediaMonitorDiscoveredFile* _result_)
{
	VideoMonitor * self;
	MediaMonitorDiscoveredFile _vala_result = 0;
	GeeCollection* result = NULL;
	GeeCollection* matched = NULL;
	GeeArrayList* _tmp0_;
	VideoSourceCollection* _tmp1_;
#line 117 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 117 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 117 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), NULL);
#line 119 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 119 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	matched = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 120 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_global;
#line 120 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_source_collection_fetch_by_matching_backing (_tmp1_, info, matched);
#line 122 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_vala_result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 124 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = matched;
#line 124 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_result_) {
#line 124 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		*_result_ = _vala_result;
#line 1197 "VideoMonitor.c"
	}
#line 124 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1201 "VideoMonitor.c"
}


static gboolean
video_monitor_real_notify_file_created (MediaMonitor* base,
                                        GFile* file,
                                        GFileInfo* info)
{
	VideoMonitor * self;
	gboolean result = FALSE;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
#line 127 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 127 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 127 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 129 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
#line 129 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	state = _tmp0_;
#line 129 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video = _tmp1_;
#line 130 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = video;
#line 130 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 131 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		result = FALSE;
#line 131 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (video);
#line 131 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		return result;
#line 1240 "VideoMonitor.c"
	}
#line 133 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = video;
#line 133 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable));
#line 135 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = TRUE;
#line 135 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (video);
#line 135 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1252 "VideoMonitor.c"
}


static gboolean
video_monitor_real_notify_file_moved (MediaMonitor* base,
                                      GFile* old_file,
                                      GFile* new_file,
                                      GFileInfo* new_file_info)
{
	VideoMonitor * self;
	gboolean result = FALSE;
	VideoSourceCollectionState old_state = 0;
	Video* old_video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	VideoSourceCollectionState new_state = 0;
	Video* new_video = NULL;
	VideoSourceCollectionState _tmp2_ = 0;
	Video* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Video* _tmp5_;
#line 138 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 138 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (old_file), FALSE);
#line 138 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (new_file), FALSE);
#line 138 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (new_file_info), FALSE);
#line 140 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, old_file, &_tmp0_);
#line 140 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	old_state = _tmp0_;
#line 140 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	old_video = _tmp1_;
#line 143 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = video_monitor_get_state (self, new_file, &_tmp2_);
#line 143 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	new_state = _tmp2_;
#line 143 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	new_video = _tmp3_;
#line 157 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp5_ = old_video;
#line 157 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp5_ != NULL) {
#line 1298 "VideoMonitor.c"
		Video* _tmp6_;
#line 157 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp6_ = new_video;
#line 157 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp4_ = _tmp6_ == NULL;
#line 1304 "VideoMonitor.c"
	} else {
#line 157 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp4_ = FALSE;
#line 1308 "VideoMonitor.c"
	}
#line 157 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp4_) {
#line 1312 "VideoMonitor.c"
		Video* _tmp7_;
#line 159 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp7_ = old_video;
#line 159 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		media_monitor_update_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MONITORABLE, Monitorable), new_file);
#line 1318 "VideoMonitor.c"
	} else {
		gboolean _tmp8_ = FALSE;
		Video* _tmp9_;
#line 160 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp9_ = old_video;
#line 160 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		if (_tmp9_ == NULL) {
#line 1326 "VideoMonitor.c"
			Video* _tmp10_;
#line 160 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp10_ = new_video;
#line 160 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp8_ = _tmp10_ != NULL;
#line 1332 "VideoMonitor.c"
		} else {
#line 160 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp8_ = FALSE;
#line 1336 "VideoMonitor.c"
		}
#line 160 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		if (_tmp8_) {
#line 1340 "VideoMonitor.c"
			Video* _tmp11_;
#line 162 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp11_ = new_video;
#line 162 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			video_monitor_set_check_interpretable (self, _tmp11_, TRUE);
#line 1346 "VideoMonitor.c"
		} else {
			gboolean _tmp12_ = FALSE;
			Video* _tmp13_;
#line 163 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp13_ = old_video;
#line 163 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp13_ == NULL) {
#line 1354 "VideoMonitor.c"
				Video* _tmp14_;
#line 163 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp14_ = new_video;
#line 163 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp12_ = _tmp14_ == NULL;
#line 1360 "VideoMonitor.c"
			} else {
#line 163 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp12_ = FALSE;
#line 1364 "VideoMonitor.c"
			}
#line 163 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp12_) {
#line 165 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				result = FALSE;
#line 165 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (new_video);
#line 165 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (old_video);
#line 165 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				return result;
#line 1376 "VideoMonitor.c"
			} else {
				gboolean _tmp15_ = FALSE;
				Video* _tmp16_;
				Video* _tmp18_;
				Video* _tmp19_;
#line 167 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp16_ = old_video;
#line 167 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				if (_tmp16_ != NULL) {
#line 1386 "VideoMonitor.c"
					Video* _tmp17_;
#line 167 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
					_tmp17_ = new_video;
#line 167 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
					_tmp15_ = _tmp17_ != NULL;
#line 1392 "VideoMonitor.c"
				} else {
#line 167 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
					_tmp15_ = FALSE;
#line 1396 "VideoMonitor.c"
				}
#line 167 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_vala_assert (_tmp15_, "old_video != null && new_video != null");
#line 170 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp18_ = old_video;
#line 170 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_MONITORABLE, Monitorable));
#line 171 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp19_ = new_video;
#line 171 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				video_monitor_set_check_interpretable (self, _tmp19_, TRUE);
#line 1408 "VideoMonitor.c"
			}
		}
	}
#line 174 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = TRUE;
#line 174 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (new_video);
#line 174 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (old_video);
#line 174 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1420 "VideoMonitor.c"
}


static gboolean
video_monitor_real_notify_file_altered (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	gboolean result = FALSE;
	VideoSourceCollectionState state = 0;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	gboolean _tmp3_;
#line 177 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 177 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 179 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
#line 179 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	state = _tmp0_;
#line 179 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 179 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 179 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (_tmp2_);
#line 179 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = _tmp3_;
#line 179 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1453 "VideoMonitor.c"
}


static gboolean
video_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                   GFile* file)
{
	VideoMonitor * self;
	gboolean result = FALSE;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	Video* _tmp4_;
#line 182 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 182 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 184 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
#line 184 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	state = _tmp0_;
#line 184 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video = _tmp1_;
#line 185 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = video;
#line 185 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 186 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		result = FALSE;
#line 186 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (video);
#line 186 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		return result;
#line 1490 "VideoMonitor.c"
	}
#line 188 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = video;
#line 188 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable));
#line 189 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp4_ = video;
#line 189 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MONITORABLE, Monitorable), TRUE);
#line 191 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = TRUE;
#line 191 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (video);
#line 191 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1506 "VideoMonitor.c"
}


static gboolean
video_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                     GFile* file,
                                                     GFileInfo* info)
{
	VideoMonitor * self;
	gboolean result = FALSE;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
#line 194 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 194 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 194 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 196 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
#line 196 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	state = _tmp0_;
#line 196 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video = _tmp1_;
#line 197 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = video;
#line 197 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 198 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		result = FALSE;
#line 198 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (video);
#line 198 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		return result;
#line 1545 "VideoMonitor.c"
	}
#line 200 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = video;
#line 200 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable), info);
#line 202 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = TRUE;
#line 202 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (video);
#line 202 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1557 "VideoMonitor.c"
}


static gboolean
video_monitor_real_notify_file_deleted (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	gboolean result = FALSE;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	Video* _tmp4_;
#line 205 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 205 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 207 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
#line 207 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	state = _tmp0_;
#line 207 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video = _tmp1_;
#line 208 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = video;
#line 208 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 209 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		result = FALSE;
#line 209 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (video);
#line 209 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		return result;
#line 1594 "VideoMonitor.c"
	}
#line 211 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = video;
#line 211 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable), FALSE);
#line 212 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp4_ = video;
#line 212 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MONITORABLE, Monitorable));
#line 214 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = TRUE;
#line 214 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (video);
#line 214 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1610 "VideoMonitor.c"
}


static Video*
video_monitor_get_state (VideoMonitor* self,
                         GFile* file,
                         VideoSourceCollectionState* state)
{
	VideoSourceCollectionState _vala_state = 0;
	Video* result = NULL;
	GFile* real_file = NULL;
	GFile* _tmp22_ = NULL;
	GFile* _tmp23_;
	VideoSourceCollection* _tmp24_;
	VideoSourceCollectionState _tmp25_ = 0;
	Video* _tmp26_;
#line 217 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO_MONITOR (self), NULL);
#line 217 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 218 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	real_file = NULL;
#line 1633 "VideoMonitor.c"
	{
		GeeIterator* _monitorable_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp0_ = media_monitor_get_monitorables (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp1_ = _tmp0_;
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp3_ = _tmp2_;
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (_tmp1_);
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_monitorable_it = _tmp3_;
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		while (TRUE) {
#line 1654 "VideoMonitor.c"
			GeeIterator* _tmp4_;
			Monitorable* monitorable = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Video* video = NULL;
			Monitorable* _tmp7_;
			Video* _tmp8_;
			VideoUpdates* updates = NULL;
			Video* _tmp9_;
			VideoUpdates* _tmp10_;
			VideoUpdates* _tmp11_;
			gboolean _tmp12_ = FALSE;
			VideoUpdates* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_;
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp4_ = _monitorable_it;
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				break;
#line 1677 "VideoMonitor.c"
			}
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp5_ = _monitorable_it;
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			monitorable = (Monitorable*) _tmp6_;
#line 220 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp7_ = monitorable;
#line 220 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video));
#line 220 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			video = _tmp8_;
#line 222 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp9_ = video;
#line 222 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp10_ = video_monitor_get_existing_video_updates (self, _tmp9_);
#line 222 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			updates = _tmp10_;
#line 223 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp11_ = updates;
#line 223 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp11_ == NULL) {
#line 224 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 224 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (video);
#line 224 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (monitorable);
#line 224 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				continue;
#line 1709 "VideoMonitor.c"
			}
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp13_ = updates;
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp14_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp15_ = _tmp14_;
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp16_ = _tmp15_ != NULL;
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (_tmp15_);
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp16_) {
#line 1723 "VideoMonitor.c"
				VideoUpdates* _tmp17_;
				GFile* _tmp18_;
				GFile* _tmp19_;
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp17_ = updates;
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp18_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp19_ = _tmp18_;
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp12_ = g_file_equal (_tmp19_, file);
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (_tmp19_);
#line 1737 "VideoMonitor.c"
			} else {
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp12_ = FALSE;
#line 1741 "VideoMonitor.c"
			}
#line 226 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp12_) {
#line 1745 "VideoMonitor.c"
				Video* _tmp20_;
				GFile* _tmp21_;
#line 227 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp20_ = video;
#line 227 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp21_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_MEDIA_SOURCE, MediaSource));
#line 227 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (real_file);
#line 227 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				real_file = _tmp21_;
#line 229 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 229 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (video);
#line 229 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (monitorable);
#line 229 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				break;
#line 1764 "VideoMonitor.c"
			}
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_monitorable_updates_unref0 (updates);
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (video);
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (monitorable);
#line 1772 "VideoMonitor.c"
		}
#line 219 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (_monitorable_it);
#line 1776 "VideoMonitor.c"
	}
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp23_ = real_file;
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp22_ = _tmp23_;
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp22_ == NULL) {
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp22_ = file;
#line 1786 "VideoMonitor.c"
	}
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp24_ = video_global;
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp26_ = video_source_collection_get_state_by_file (_tmp24_, _tmp22_, &_tmp25_);
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_vala_state = _tmp25_;
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = _tmp26_;
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (real_file);
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (state) {
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		*state = _vala_state;
#line 1802 "VideoMonitor.c"
	}
#line 233 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1806 "VideoMonitor.c"
}


VideoUpdates*
video_monitor_fetch_video_updates (VideoMonitor* self,
                                   Video* video)
{
	VideoUpdates* result = NULL;
	VideoUpdates* updates = NULL;
	MonitorableUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
#line 236 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO_MONITOR (self), NULL);
#line 236 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO (video), NULL);
#line 237 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = media_monitor_fetch_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MONITORABLE, Monitorable));
#line 237 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_VIDEO_UPDATES) ? ((VideoUpdates*) _tmp0_) : NULL;
#line 237 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp1_ == NULL) {
#line 237 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_monitorable_updates_unref0 (_tmp0_);
#line 1830 "VideoMonitor.c"
	}
#line 237 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	updates = _tmp1_;
#line 238 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_vala_assert (updates != NULL, "updates != null");
#line 240 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = updates;
#line 240 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1840 "VideoMonitor.c"
}


VideoUpdates*
video_monitor_get_existing_video_updates (VideoMonitor* self,
                                          Video* video)
{
	VideoUpdates* result = NULL;
	MonitorableUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
#line 243 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO_MONITOR (self), NULL);
#line 243 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO (video), NULL);
#line 244 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = media_monitor_get_existing_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MONITORABLE, Monitorable));
#line 244 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_VIDEO_UPDATES) ? ((VideoUpdates*) _tmp0_) : NULL;
#line 244 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp1_ == NULL) {
#line 244 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_monitorable_updates_unref0 (_tmp0_);
#line 1863 "VideoMonitor.c"
	}
#line 244 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	result = _tmp1_;
#line 244 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return result;
#line 1869 "VideoMonitor.c"
}


void
video_monitor_set_check_interpretable (VideoMonitor* self,
                                       Video* video,
                                       gboolean check)
{
	VideoUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
#line 247 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_if_fail (IS_VIDEO_MONITOR (self));
#line 247 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_if_fail (IS_VIDEO (video));
#line 248 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = video_monitor_fetch_video_updates (self, video);
#line 248 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 248 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_updates_set_check_interpretable (_tmp1_, check);
#line 248 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 1892 "VideoMonitor.c"
}


static gpointer
_monitorable_updates_ref0 (gpointer self)
{
#line 266 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return self ? monitorable_updates_ref (self) : NULL;
#line 1901 "VideoMonitor.c"
}


static void
_video_monitor_on_interpretable_check_complete_completion_callback (BackgroundJob* job,
                                                                    gpointer self)
{
#line 287 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_monitor_on_interpretable_check_complete ((VideoMonitor*) self, job);
#line 1911 "VideoMonitor.c"
}


static void
video_monitor_real_process_updates (MediaMonitor* base,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error)
{
	VideoMonitor * self;
	GeeArrayList* check = NULL;
	GeeArrayList* _tmp20_;
	GError * _inner_error_ = NULL;
#line 251 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 251 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_if_fail (GEE_IS_COLLECTION (all_updates));
#line 251 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 253 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	MEDIA_MONITOR_CLASS (video_monitor_parent_class)->process_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), all_updates, controller, op_count, &_inner_error_);
#line 253 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 253 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		g_propagate_error (error, _inner_error_);
#line 253 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		return;
#line 1940 "VideoMonitor.c"
	}
#line 255 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	check = NULL;
#line 1944 "VideoMonitor.c"
	{
		GeeIterator* _monitorable_updates_it = NULL;
		GeeIterator* _tmp0_;
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (all_updates, GEE_TYPE_ITERABLE, GeeIterable));
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_monitorable_updates_it = _tmp0_;
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		while (TRUE) {
#line 1954 "VideoMonitor.c"
			GeeIterator* _tmp1_;
			MonitorableUpdates* monitorable_updates = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			GeeArrayList* _tmp5_;
			VideoUpdates* updates = NULL;
			MonitorableUpdates* _tmp9_;
			VideoUpdates* _tmp10_;
			VideoUpdates* _tmp11_;
			VideoUpdates* _tmp12_;
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp1_ = _monitorable_updates_it;
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				break;
#line 1972 "VideoMonitor.c"
			}
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp2_ = _monitorable_updates_it;
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			monitorable_updates = (MonitorableUpdates*) _tmp3_;
#line 258 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if ((*op_count) >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
#line 259 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_monitorable_updates_unref0 (monitorable_updates);
#line 259 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				break;
#line 1986 "VideoMonitor.c"
			}
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp5_ = check;
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp5_ != NULL) {
#line 1992 "VideoMonitor.c"
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp6_ = check;
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp8_ = _tmp7_;
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp4_ = _tmp8_ >= VIDEO_MONITOR_MAX_INTERPRETABLE_CHECKS_PER_CYCLE;
#line 2004 "VideoMonitor.c"
			} else {
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp4_ = FALSE;
#line 2008 "VideoMonitor.c"
			}
#line 263 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp4_) {
#line 264 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_monitorable_updates_unref0 (monitorable_updates);
#line 264 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				break;
#line 2016 "VideoMonitor.c"
			}
#line 266 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp9_ = monitorable_updates;
#line 266 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp10_ = _monitorable_updates_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_VIDEO_UPDATES) ? ((VideoUpdates*) _tmp9_) : NULL);
#line 266 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			updates = _tmp10_;
#line 267 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp11_ = updates;
#line 267 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (_tmp11_ == NULL) {
#line 268 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 268 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_monitorable_updates_unref0 (monitorable_updates);
#line 268 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				continue;
#line 2034 "VideoMonitor.c"
			}
#line 270 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp12_ = updates;
#line 270 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			if (video_updates_is_check_interpretable (_tmp12_)) {
#line 2040 "VideoMonitor.c"
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp15_;
				VideoUpdates* _tmp16_;
				Video* _tmp17_;
				VideoUpdates* _tmp18_;
				gint _tmp19_;
#line 271 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp13_ = check;
#line 271 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				if (_tmp13_ == NULL) {
#line 2051 "VideoMonitor.c"
					GeeArrayList* _tmp14_;
#line 272 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
					_tmp14_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 272 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
					_g_object_unref0 (check);
#line 272 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
					check = _tmp14_;
#line 2059 "VideoMonitor.c"
				}
#line 274 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp15_ = check;
#line 274 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp16_ = updates;
#line 274 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp17_ = _tmp16_->video;
#line 274 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 275 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp18_ = updates;
#line 275 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				video_updates_set_check_interpretable (_tmp18_, FALSE);
#line 276 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp19_ = *op_count;
#line 276 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				*op_count = _tmp19_ + 1;
#line 2077 "VideoMonitor.c"
			}
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_monitorable_updates_unref0 (updates);
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_monitorable_updates_unref0 (monitorable_updates);
#line 2083 "VideoMonitor.c"
		}
#line 257 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_object_unref0 (_monitorable_updates_it);
#line 2087 "VideoMonitor.c"
	}
#line 280 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp20_ = check;
#line 280 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp20_ != NULL) {
#line 2093 "VideoMonitor.c"
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		guint64 _tmp26_;
		GeeArrayList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
#line 281 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp21_ = check;
#line 281 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp22_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 281 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp23_ = _tmp22_;
#line 281 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp24_ = g_strdup_printf ("Checking interpretable for %d videos", _tmp23_);
#line 281 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp25_ = _tmp24_;
#line 281 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		media_monitor_mdbg (_tmp25_);
#line 281 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_g_free0 (_tmp25_);
#line 283 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		video_notify_offline_thumbs_regenerated ();
#line 285 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp26_ = self->priv->background_jobs;
#line 285 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp27_ = check;
#line 285 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp28_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 285 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		_tmp29_ = _tmp28_;
#line 285 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		self->priv->background_jobs = _tmp26_ + _tmp29_;
#line 2129 "VideoMonitor.c"
		{
			GeeArrayList* _video_list = NULL;
			GeeArrayList* _tmp30_;
			GeeArrayList* _tmp31_;
			gint _video_size = 0;
			GeeArrayList* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _video_index = 0;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp30_ = check;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp31_ = _g_object_ref0 (_tmp30_);
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_video_list = _tmp31_;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp32_ = _video_list;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp33_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_tmp34_ = _tmp33_;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_video_size = _tmp34_;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_video_index = -1;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			while (TRUE) {
#line 2157 "VideoMonitor.c"
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				Video* video = NULL;
				GeeArrayList* _tmp38_;
				gint _tmp39_;
				gpointer _tmp40_;
				Workers* _tmp41_;
				Video* _tmp42_;
				VideoMonitorVideoInterpretableCheckJob* _tmp43_;
				VideoMonitorVideoInterpretableCheckJob* _tmp44_;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp35_ = _video_index;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_video_index = _tmp35_ + 1;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp36_ = _video_index;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp37_ = _video_size;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				if (!(_tmp36_ < _tmp37_)) {
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
					break;
#line 2181 "VideoMonitor.c"
				}
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp38_ = _video_list;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp39_ = _video_index;
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp40_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp39_);
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				video = (Video*) _tmp40_;
#line 287 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp41_ = self->priv->workers;
#line 287 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp42_ = video;
#line 287 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp43_ = video_monitor_video_interpretable_check_job_new (_tmp42_, _video_monitor_on_interpretable_check_complete_completion_callback, self);
#line 287 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_tmp44_ = _tmp43_;
#line 287 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				workers_enqueue (_tmp41_, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 287 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_background_job_unref0 (_tmp44_);
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
				_g_object_unref0 (video);
#line 2205 "VideoMonitor.c"
			}
#line 286 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
			_g_object_unref0 (_video_list);
#line 2209 "VideoMonitor.c"
		}
	}
#line 251 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (check);
#line 2214 "VideoMonitor.c"
}


static gpointer
_background_job_ref0 (gpointer self)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return self ? background_job_ref (self) : NULL;
#line 2223 "VideoMonitor.c"
}


static void
video_monitor_on_interpretable_check_complete (VideoMonitor* self,
                                               BackgroundJob* j)
{
	VideoMonitorVideoInterpretableCheckJob* job = NULL;
	VideoMonitorVideoInterpretableCheckJob* _tmp0_;
	VideoMonitorVideoInterpretableCheckJob* _tmp1_;
	VideoInterpretableResults* _tmp2_;
	guint64 _tmp3_;
	guint64 _tmp4_;
#line 291 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_if_fail (IS_VIDEO_MONITOR (self));
#line 291 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 292 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob));
#line 292 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	job = _tmp0_;
#line 294 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = job;
#line 294 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp2_ = _tmp1_->results;
#line 294 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_interpretable_results_foreground_finish (_tmp2_);
#line 296 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp3_ = self->priv->background_jobs;
#line 296 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->priv->background_jobs = _tmp3_ - 1;
#line 297 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp4_ = self->priv->background_jobs;
#line 297 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	if (_tmp4_ <= ((guint64) 0)) {
#line 298 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
		video_notify_normal_thumbs_regenerated ();
#line 2261 "VideoMonitor.c"
	}
#line 291 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_background_job_unref0 (job);
#line 2265 "VideoMonitor.c"
}


static VideoMonitorVideoInterpretableCheckJob*
video_monitor_video_interpretable_check_job_construct (GType object_type,
                                                       Video* video,
                                                       CompletionCallback callback,
                                                       void* callback_target)
{
	VideoMonitorVideoInterpretableCheckJob* self = NULL;
	Video* _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_return_val_if_fail (IS_VIDEO (video), NULL);
#line 50 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = (VideoMonitorVideoInterpretableCheckJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (video, G_TYPE_OBJECT, GObject), callback, callback_target, NULL, NULL, NULL, NULL);
#line 51 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = _g_object_ref0 (video);
#line 51 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (self->video);
#line 51 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->video = _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return self;
#line 2289 "VideoMonitor.c"
}


static VideoMonitorVideoInterpretableCheckJob*
video_monitor_video_interpretable_check_job_new (Video* video,
                                                 CompletionCallback callback,
                                                 void* callback_target)
{
#line 49 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	return video_monitor_video_interpretable_check_job_construct (VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, video, callback, callback_target);
#line 2300 "VideoMonitor.c"
}


static void
video_monitor_video_interpretable_check_job_real_execute (BackgroundJob* base)
{
	VideoMonitorVideoInterpretableCheckJob * self;
	Video* _tmp0_;
	VideoInterpretableResults* _tmp1_;
#line 54 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob);
#line 55 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = self->video;
#line 55 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp1_ = video_check_is_interpretable (_tmp0_);
#line 55 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_video_interpretable_results_unref0 (self->results);
#line 55 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->results = _tmp1_;
#line 2320 "VideoMonitor.c"
}


static void
video_monitor_video_interpretable_check_job_class_init (VideoMonitorVideoInterpretableCheckJobClass * klass)
{
#line 42 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_monitor_video_interpretable_check_job_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = video_monitor_video_interpretable_check_job_finalize;
#line 42 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) video_monitor_video_interpretable_check_job_real_execute;
#line 2333 "VideoMonitor.c"
}


static void
video_monitor_video_interpretable_check_job_instance_init (VideoMonitorVideoInterpretableCheckJob * self)
{
#line 47 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->results = NULL;
#line 2342 "VideoMonitor.c"
}


static void
video_monitor_video_interpretable_check_job_finalize (BackgroundJob * obj)
{
	VideoMonitorVideoInterpretableCheckJob * self;
#line 42 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob);
#line 44 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_g_object_unref0 (self->video);
#line 47 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_video_interpretable_results_unref0 (self->results);
#line 42 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	BACKGROUND_JOB_CLASS (video_monitor_video_interpretable_check_job_parent_class)->finalize (obj);
#line 2358 "VideoMonitor.c"
}


static GType
video_monitor_video_interpretable_check_job_get_type (void)
{
	static volatile gsize video_monitor_video_interpretable_check_job_type_id__volatile = 0;
	if (g_once_init_enter (&video_monitor_video_interpretable_check_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoMonitorVideoInterpretableCheckJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_monitor_video_interpretable_check_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMonitorVideoInterpretableCheckJob), 0, (GInstanceInitFunc) video_monitor_video_interpretable_check_job_instance_init, NULL };
		GType video_monitor_video_interpretable_check_job_type_id;
		video_monitor_video_interpretable_check_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "VideoMonitorVideoInterpretableCheckJob", &g_define_type_info, 0);
		g_once_init_leave (&video_monitor_video_interpretable_check_job_type_id__volatile, video_monitor_video_interpretable_check_job_type_id);
	}
	return video_monitor_video_interpretable_check_job_type_id__volatile;
}


static void
video_monitor_class_init (VideoMonitorClass * klass)
{
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	video_monitor_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	g_type_class_add_private (klass, sizeof (VideoMonitorPrivate));
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->create_updates = (MonitorableUpdates* (*) (MediaMonitor *, Monitorable*)) video_monitor_real_create_updates;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->get_media_source_collection = (MediaSourceCollection* (*) (MediaMonitor *)) video_monitor_real_get_media_source_collection;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->is_file_represented = (gboolean (*) (MediaMonitor *, GFile*)) video_monitor_real_is_file_represented;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_discovered = (MediaMonitorDiscoveredFile (*) (MediaMonitor *, GFile*, GFileInfo*, Monitorable* *)) video_monitor_real_notify_file_discovered;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = (GeeCollection* (*) (MediaMonitor *, GFile*, GFileInfo*, MediaMonitorDiscoveredFile*)) video_monitor_real_candidates_for_unknown_file;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_created = (gboolean (*) (MediaMonitor *, GFile*, GFileInfo*)) video_monitor_real_notify_file_created;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_moved = (gboolean (*) (MediaMonitor *, GFile*, GFile*, GFileInfo*)) video_monitor_real_notify_file_moved;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_altered = (gboolean (*) (MediaMonitor *, GFile*)) video_monitor_real_notify_file_altered;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = (gboolean (*) (MediaMonitor *, GFile*)) video_monitor_real_notify_file_attributes_altered;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = (gboolean (*) (MediaMonitor *, GFile*, GFileInfo*)) video_monitor_real_notify_file_alteration_completed;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_deleted = (gboolean (*) (MediaMonitor *, GFile*)) video_monitor_real_notify_file_deleted;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	((MediaMonitorClass *) klass)->process_updates = (void (*) (MediaMonitor *, GeeCollection*, TransactionController*, gint*, GError**)) video_monitor_real_process_updates;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	G_OBJECT_CLASS (klass)->finalize = video_monitor_finalize;
#line 2409 "VideoMonitor.c"
}


static void
video_monitor_instance_init (VideoMonitor * self)
{
	Workers* _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->priv = VIDEO_MONITOR_GET_PRIVATE (self);
#line 62 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_tmp0_ = workers_new ((guint) 1, FALSE);
#line 62 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->priv->workers = _tmp0_;
#line 63 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self->priv->background_jobs = (guint64) 0;
#line 2425 "VideoMonitor.c"
}


static void
video_monitor_finalize (GObject * obj)
{
	VideoMonitor * self;
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_MONITOR, VideoMonitor);
#line 62 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	_workers_unref0 (self->priv->workers);
#line 37 "/home/jens/Source/shotwell/src/VideoMonitor.vala"
	G_OBJECT_CLASS (video_monitor_parent_class)->finalize (obj);
#line 2439 "VideoMonitor.c"
}


GType
video_monitor_get_type (void)
{
	static volatile gsize video_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&video_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMonitor), 0, (GInstanceInitFunc) video_monitor_instance_init, NULL };
		GType video_monitor_type_id;
		video_monitor_type_id = g_type_register_static (TYPE_MEDIA_MONITOR, "VideoMonitor", &g_define_type_info, 0);
		g_once_init_leave (&video_monitor_type_id__volatile, video_monitor_type_id);
	}
	return video_monitor_type_id__volatile;
}



