# Viewing Reports - [Results API](../README.md#results-api)

It is possible to view the reports generated by the WPT Report tool directly in the browser using a version of the report that is hosted by the WAVE server. The methods listed here return urls to those hosted reports.

## 1. `view report`

Returns a URL to a report for an API of a single session, generated by the WPT Report tool.

### HTTP Request

`GET /api/results/<session_token>/<api_name>/reporturl`

### Response Payload

```json
{
  "uri": "String"
}
```

### Example 

**Request:**

`GET /api/results/d9caaae0-c362-11e9-943f-eedb305f22f6/apiOne/reporturl`

**Response:**

```json
{
  "uri": "/results/d9caaae0-c362-11e9-943f-eedb305f22f6/apiOne/all.html"
}
```

## 2. `view multi report`

Returns a URL to a report for an API of multiple session, generated by the WPT Report tool.

### HTTP Request

`GET /api/results/<api_name>/reporturl`

### Query Parameters

| Parameter | Description                                                  | Default | Example                          |
| --------- | ------------------------------------------------------------ | ------- | -------------------------------- |
| `tokens`  | Comma separated list of tokens to create a multi report for. | none    | `tokens=token_a,token_b,token_c` |

### Example

**Request:**

`GET /api/results/apiOne/reporturl?tokens=ce2dc080-c283-11e9-b4d6-e046513784c2,cd922410-c344-11e9-858f-9063f6dd878f`

**Response:**

```json
{
  "uri": "/results/comparison-cd922410-ce2dc080-1709d631/apiOne/all.html"
}
```