/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.probatron.officeotron.CommandLineSubmission;
import org.probatron.officeotron.ReportFactory;
import org.probatron.officeotron.StdioValidationReport;
import org.probatron.officeotron.Utils;
import org.probatron.officeotron.ValidationReport;
import org.probatron.officeotron.sessionstorage.Store;
import org.probatron.officeotron.sessionstorage.ValidationSession;

public class Driver {
    static Logger logger = Logger.getLogger(Driver.class);

    public static void main(String[] stringArray) {
        boolean bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        for (bl = false; bl < stringArray.length; bl += 1) {
            if (stringArray[bl].equals("--errors-only")) {
                bl2 = true;
                continue;
            }
            if (stringArray[bl].equals("--help")) {
                System.out.println("arguments: [--errors-only] file1 ...");
                return;
            }
            if (stringArray[bl].equals("--version")) {
                String string = logger.getClass().getPackage().getImplementationVersion();
                System.out.println(string);
                return;
            }
            arrayList.add(stringArray[bl]);
        }
        bl = !bl2;
        Store.init(System.getProperty("java.io.tmpdir"), false);
        for (String string : arrayList) {
            logger.debug("Validating file " + new File(string).getAbsolutePath());
            CommandLineSubmission commandLineSubmission = new CommandLineSubmission(string);
            ValidationSession validationSession = Utils.autoCreateValidationSession(commandLineSubmission, new ReportFactory(){

                @Override
                public ValidationReport create() {
                    return new StdioValidationReport(bl);
                }
            });
            validationSession.prepare();
            validationSession.validate();
            validationSession.cleanup();
            try {
                validationSession.getCommentary().streamOut();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static {
        String string = System.getProperty("property://probatron.org/officeotron-log-level");
        string = string == null ? "ERROR" : string;
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", string + ", A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.target", "System.err");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.A1.layout.ConversionPattern", "%c %p - %m%n");
        PropertyConfigurator.configure(properties);
    }
}

