/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron.sessionstorage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.probatron.officeotron.ReportFactory;
import org.probatron.officeotron.Utils;
import org.probatron.officeotron.ValidationReport;
import org.probatron.officeotron.sessionstorage.Store;
import org.xmlopen.zipspy.ZipArchive;

public class ValidationSession {
    static Logger logger = Logger.getLogger(ValidationSession.class);
    private UUID uuid;
    private String filename;
    private ValidationReport commentary;
    protected int errCount;
    private ZipArchive zipArchive;

    public ValidationSession(UUID uUID, ReportFactory reportFactory) {
        assert (Store.tmpFolder != null) : "Store not initialized";
        this.uuid = uUID;
        this.filename = Store.getFilename(uUID);
        this.commentary = reportFactory.create();
    }

    public String getCandidateFilename() {
        return this.filename;
    }

    public ValidationReport getCommentary() {
        return this.commentary;
    }

    public int getErrCount() {
        return this.errCount;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public InputStream getPackageStream() {
        return Store.getStream(this.uuid);
    }

    public final void prepare() {
        logger.debug("Preparing session");
        this.getCommentary().addComment("Inspecting ZIP ...");
        this.getCommentary().incIndent();
        InputStream inputStream = this.getPackageStream();
        this.zipArchive = new ZipArchive(inputStream);
        if (this.zipArchive.getLocalHeaderCount() != this.zipArchive.getCentralRecordCount()) {
            this.getCommentary().addComment("WARN", "Mismatch between local header and central record (weakened ZIP resilience)");
        } else {
            this.getCommentary().addComment("" + this.zipArchive.getCentralRecordCount() + " central records found");
        }
        this.onExtendedZipInspection();
        Utils.streamClose(inputStream);
        String string = Store.getDirectory(this.uuid) + File.separator + this.uuid;
        if (!new File(string).delete()) {
            logger.warn("Attempt to delete downloaded resource failed");
        }
        String string2 = Store.getDirectory(this.uuid) + File.separator + this.uuid + "-zip.xml";
        try {
            Utils.writeBytesToFile(this.zipArchive.asXmlString().getBytes(), string2);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
        }
        this.getCommentary().decIndent();
    }

    public void onExtendedZipInspection() {
    }

    public void cleanup() {
        new Thread(){

            @Override
            public void run() {
                logger.info("Performing cleanup");
                Store.delete(ValidationSession.this.uuid);
                super.run();
            }
        }.start();
    }

    public URI getUrlForEntry(String string) {
        return Store.urlForEntry(this.uuid, string);
    }

    public ZipArchive getZipArchive() {
        return this.zipArchive;
    }

    public void validate() {
    }
}

