/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.DifferenceEnumeration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntersectionEnumeration;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class VennExpression
extends BinaryExpression {
    public VennExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public final ItemType getItemType() {
        ItemType itemType = this.operands[0].getItemType();
        ItemType itemType2 = this.operands[1].getItemType();
        return Type.getCommonSuperType(itemType, itemType2);
    }

    public final int computeCardinality() {
        int n = this.operands[0].getCardinality();
        int n2 = this.operands[1].getCardinality();
        switch (this.operator) {
            case 1: {
                if (this.operands[0] instanceof EmptySequence) {
                    return n2;
                }
                if (this.operands[1] instanceof EmptySequence) {
                    return n;
                }
                return n | n2 | 0x200 | 0x400;
            }
            case 23: {
                if (this.operands[0] instanceof EmptySequence) {
                    return 256;
                }
                if (this.operands[1] instanceof EmptySequence) {
                    return 256;
                }
                return n & n2 | 0x100 | 0x200;
            }
            case 24: {
                if (this.operands[0] instanceof EmptySequence) {
                    return 256;
                }
                if (this.operands[1] instanceof EmptySequence) {
                    return n;
                }
                return n | 0x100 | 0x200;
            }
        }
        return 1792;
    }

    public int computeSpecialProperties() {
        int n = this.operands[0].getSpecialProperties();
        int n2 = this.operands[1].getSpecialProperties();
        int n3 = 131072;
        if (this.testContextDocumentNodeSet(n, n2)) {
            n3 |= 0x10000;
        }
        if (this.testSubTree(n, n2)) {
            n3 |= 0x100000;
        }
        return n3;
    }

    private boolean testContextDocumentNodeSet(int n, int n2) {
        switch (this.operator) {
            case 1: {
                return (n & n2 & 0x10000) != 0;
            }
            case 23: {
                return ((n | n2) & 0x10000) != 0;
            }
            case 24: {
                return (n & 0x10000) != 0;
            }
        }
        return false;
    }

    private boolean testSubTree(int n, int n2) {
        switch (this.operator) {
            case 1: {
                return (n & n2 & 0x100000) != 0;
            }
            case 23: {
                return ((n | n2) & 0x100000) != 0;
            }
            case 24: {
                return (n & 0x100000) != 0;
            }
        }
        return false;
    }

    public Expression simplify() throws XPathException {
        ComputedExpression computedExpression;
        ComputedExpression computedExpression2;
        this.operands[0] = this.operands[0].simplify();
        this.operands[1] = this.operands[1].simplify();
        switch (this.operator) {
            case 1: {
                if (this.operands[0] instanceof EmptySequence && (this.operands[1].getSpecialProperties() & 0x20000) != 0) {
                    return this.operands[1];
                }
                if (!(this.operands[1] instanceof EmptySequence) || (this.operands[0].getSpecialProperties() & 0x20000) == 0) break;
                return this.operands[0];
            }
            case 23: {
                if (this.operands[0] instanceof EmptySequence) {
                    return this.operands[0];
                }
                if (!(this.operands[1] instanceof EmptySequence)) break;
                return this.operands[1];
            }
            case 24: {
                if (this.operands[0] instanceof EmptySequence) {
                    return this.operands[0];
                }
                if (!(this.operands[1] instanceof EmptySequence) || (this.operands[0].getSpecialProperties() & 0x20000) == 0) break;
                return this.operands[0];
            }
        }
        if (this.operands[0] instanceof AxisExpression && this.operands[1] instanceof AxisExpression) {
            computedExpression2 = (AxisExpression)this.operands[0];
            computedExpression = (AxisExpression)this.operands[1];
            if (((AxisExpression)computedExpression2).getAxis() == ((AxisExpression)computedExpression).getAxis()) {
                return new AxisExpression(((AxisExpression)computedExpression2).getAxis(), new CombinedNodeTest(((AxisExpression)computedExpression2).getNodeTest(), this.operator, ((AxisExpression)computedExpression).getNodeTest()));
            }
        }
        if (this.operands[0] instanceof PathExpression && this.operands[1] instanceof PathExpression) {
            computedExpression2 = (PathExpression)this.operands[0];
            computedExpression = (PathExpression)this.operands[1];
            if (((PathExpression)computedExpression2).getFirstStep().equals(((PathExpression)computedExpression).getFirstStep())) {
                Expression expression = new PathExpression(((PathExpression)computedExpression2).getFirstStep(), new VennExpression(((PathExpression)computedExpression2).getRemainingSteps(), this.operator, ((PathExpression)computedExpression).getRemainingSteps())).simplify();
                ExpressionTool.copyLocationInfo(this, expression);
                return expression;
            }
        }
        if (this.operands[0] instanceof FilterExpression && this.operands[1] instanceof FilterExpression) {
            computedExpression2 = (FilterExpression)this.operands[0];
            computedExpression = (FilterExpression)this.operands[1];
            if (!((FilterExpression)computedExpression2).isPositional() && !((FilterExpression)computedExpression).isPositional() && ((FilterExpression)computedExpression2).getBaseExpression().equals(((FilterExpression)computedExpression).getBaseExpression())) {
                BooleanExpression booleanExpression;
                switch (this.operator) {
                    case 1: {
                        booleanExpression = new BooleanExpression(((FilterExpression)computedExpression2).getFilter(), 9, ((FilterExpression)computedExpression).getFilter());
                        break;
                    }
                    case 23: {
                        booleanExpression = new BooleanExpression(((FilterExpression)computedExpression2).getFilter(), 10, ((FilterExpression)computedExpression).getFilter());
                        break;
                    }
                    case 24: {
                        FunctionCall functionCall = SystemFunction.makeSystemFunction("not");
                        Expression[] expressionArray = new Expression[]{((FilterExpression)computedExpression).getFilter()};
                        functionCall.setArguments(expressionArray);
                        booleanExpression = new BooleanExpression(((FilterExpression)computedExpression2).getFilter(), 10, functionCall);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown operator " + this.operator));
                    }
                }
                Expression expression = new FilterExpression(((FilterExpression)computedExpression2).getBaseExpression(), booleanExpression).simplify();
                ExpressionTool.copyLocationInfo(this, booleanExpression);
                ExpressionTool.copyLocationInfo(this, expression);
                return expression;
            }
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.operands[0] = this.operands[0].analyze(staticContext);
        this.operands[1] = this.operands[1].analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(1, Tokenizer.tokens[this.operator], 0);
        this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], SequenceType.NODE_SEQUENCE, false, roleLocator);
        RoleLocator roleLocator2 = new RoleLocator(1, Tokenizer.tokens[this.operator], 1);
        this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], SequenceType.NODE_SEQUENCE, false, roleLocator2);
        return this;
    }

    public int hashCode() {
        return this.operands[0].hashCode() ^ this.operands[1].hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operands[0].iterate(xPathContext);
        if ((this.operands[0].getSpecialProperties() & 0x20000) == 0) {
            sequenceIterator = new DocumentOrderIterator(sequenceIterator, GlobalOrderComparer.getInstance());
        }
        SequenceIterator sequenceIterator2 = this.operands[1].iterate(xPathContext);
        if ((this.operands[1].getSpecialProperties() & 0x20000) == 0) {
            sequenceIterator2 = new DocumentOrderIterator(sequenceIterator2, GlobalOrderComparer.getInstance());
        }
        switch (this.operator) {
            case 1: {
                return new UnionEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
            case 23: {
                return new IntersectionEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
            case 24: {
                return new DifferenceEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in Set Expression");
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        if (this.operator == 1) {
            return this.operands[0].effectiveBooleanValue(xPathContext) || this.operands[1].effectiveBooleanValue(xPathContext);
        }
        return super.effectiveBooleanValue(xPathContext);
    }
}

