/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import org.firebirdsql.gds.ng.FetchDirection;

public enum FetchType {
    NEXT(0, true){

        @Override
        public FetchDirection direction(int position) {
            return FetchDirection.FORWARD;
        }
    }
    ,
    PRIOR(1, true){

        @Override
        public FetchDirection direction(int position) {
            return FetchDirection.REVERSE;
        }
    }
    ,
    FIRST(2, false){

        @Override
        public FetchDirection direction(int position) {
            return FetchDirection.UNKNOWN;
        }
    }
    ,
    LAST(3, false){

        @Override
        public FetchDirection direction(int position) {
            return FetchDirection.UNKNOWN;
        }
    }
    ,
    ABSOLUTE(4, false){

        @Override
        public FetchDirection direction(int position) {
            return position <= 0 ? FetchDirection.REVERSE : FetchDirection.FORWARD;
        }
    }
    ,
    RELATIVE(5, false){

        @Override
        public FetchDirection direction(int position) {
            if (position < 0) {
                return FetchDirection.REVERSE;
            }
            if (position == 0) {
                return FetchDirection.IN_PLACE;
            }
            return FetchDirection.FORWARD;
        }
    };

    private final int fbFetchType;
    private final boolean batch;

    private FetchType(int fbFetchType, boolean batch) {
        this.fbFetchType = fbFetchType;
        this.batch = batch;
    }

    public int getFbFetchType() {
        return this.fbFetchType;
    }

    public boolean supportsBatch() {
        return this.batch;
    }

    public abstract FetchDirection direction(int var1);
}

