/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.bitext;

import java.io.IOException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;

public class SameTranslationRule
extends BitextRule {
    public SameTranslationRule() {
        this.setLocQualityIssueType(ITSIssueType.Untranslated);
    }

    @Override
    public String getDescription() {
        return "Check if translation is the same as source";
    }

    @Override
    public String getId() {
        return "SAME_TRANSLATION";
    }

    @Override
    public String getMessage() {
        return "Source and target translation are the same";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sourceText, AnalyzedSentence targetText) throws IOException {
        if (sourceText.getTokensWithoutWhitespace().length > 3 && sourceText.getText().equals(targetText.getText())) {
            AnalyzedTokenReadings[] tokens = targetText.getTokens();
            int endPos = tokens[tokens.length - 1].getEndPos();
            return new RuleMatch[]{new RuleMatch(this, targetText, 1, endPos, this.getMessage())};
        }
        return new RuleMatch[0];
    }
}

