/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupAction;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/indexmanagement/rollup/resthandler/RestIndexRollupAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "replacedRoutes", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "indexRollupResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "opensearch-index-management"})
public final class RestIndexRollupAction
extends BaseRestHandler {
    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_rollup/jobs", RestRequest.Method.PUT, "/_opendistro/_rollup/jobs"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_rollup/jobs/{rollupID}", RestRequest.Method.PUT, "/_opendistro/_rollup/jobs/{rollupID}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return "opendistro_index_rollup_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String id = request.param("rollupID", "");
        if (Intrinsics.areEqual((Object)"", (Object)id)) {
            throw new IllegalArgumentException("Missing rollup ID");
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        XContentParser xcp = request.contentParser();
        Intrinsics.checkNotNull((Object)xcp);
        Intrinsics.checkNotNull((Object)id);
        Rollup rollup2 = (Rollup)OpenSearchExtensionsKt.parseWithType(xcp, id, seqNo, primaryTerm, (Function4)new Function4<XContentParser, String, Long, Long, Rollup>((Object)Rollup.Companion){

            public final Rollup invoke(XContentParser p0, String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Rollup.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Rollup rollup3 = Rollup.copy$default(rollup2, null, 0L, 0L, false, 0L, null, instant, null, null, null, null, null, null, null, 0, null, false, null, null, null, 1048511, null);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkNotNull((Object)refreshPolicy);
        IndexRollupRequest indexRollupRequest = new IndexRollupRequest(rollup3, refreshPolicy);
        return arg_0 -> RestIndexRollupAction.prepareRequest$lambda$0(client, indexRollupRequest, this, arg_0);
    }

    private final RestResponseListener<IndexRollupResponse> indexRollupResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<IndexRollupResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            public RestResponse buildResponse(IndexRollupResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)"response");
                RestStatus restStatus = response2.getStatus();
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"newBuilder(...)");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(restStatus, response2.toXContent(xContentBuilder, params));
                if (response2.getStatus() == RestStatus.CREATED) {
                    String location = "/_plugins/_rollup/jobs/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, IndexRollupRequest $indexRollupRequest, RestIndexRollupAction this$0, RestChannel channel) {
        ActionType actionType = IndexRollupAction.Companion.getINSTANCE();
        ActionRequest actionRequest = (ActionRequest)$indexRollupRequest;
        Intrinsics.checkNotNull((Object)channel);
        $client.execute(actionType, actionRequest, (ActionListener)this$0.indexRollupResponse(channel));
    }
}

