/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VolumeState {
    CREATING("creating"),
    AVAILABLE("available"),
    IN_USE("in-use"),
    DELETING("deleting"),
    DELETED("deleted"),
    ERROR("error"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VolumeState> VALUE_MAP;
    private final String value;

    private VolumeState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VolumeState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VolumeState> knownValues() {
        EnumSet<VolumeState> knownValues = EnumSet.allOf(VolumeState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VolumeState.class, VolumeState::toString);
    }
}

