/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.List;
import java.util.Map;
import org.opensearch.OpenSearchException;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.DefaultDerivedFieldResolver;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.index.mapper.DerivedFieldResolver;
import org.opensearch.index.mapper.NoOpDerivedFieldResolver;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.SearchService;

public class DerivedFieldResolverFactory {
    public static DerivedFieldResolver createResolver(QueryShardContext queryShardContext, Map<String, Object> derivedFieldsObject, List<DerivedField> derivedFields, boolean derivedFieldAllowed) {
        boolean derivedFieldsPresent = DerivedFieldResolverFactory.derivedFieldsPresent(derivedFieldsObject, derivedFields);
        if (derivedFieldsPresent && !derivedFieldAllowed) {
            throw new OpenSearchException("[derived field] queries cannot be executed when '" + IndexSettings.ALLOW_DERIVED_FIELDS.getKey() + "' or '" + SearchService.CLUSTER_ALLOW_DERIVED_FIELD_SETTING.getKey() + "' is set to false.", new Object[0]);
        }
        if (derivedFieldsPresent && !queryShardContext.allowExpensiveQueries()) {
            throw new OpenSearchException("[derived field] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        if (derivedFieldAllowed) {
            return new DefaultDerivedFieldResolver(queryShardContext, derivedFieldsObject, derivedFields);
        }
        return new NoOpDerivedFieldResolver();
    }

    private static boolean derivedFieldsPresent(Map<String, Object> derivedFieldsObject, List<DerivedField> derivedFields) {
        return derivedFieldsObject != null && !derivedFieldsObject.isEmpty() || derivedFields != null && !derivedFields.isEmpty();
    }
}

