/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen.allgemein;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import mediathek.gui.dialogEinstellungen.allgemein.ModernSearchConfigPanel;
import mediathek.gui.dialogEinstellungen.allgemein.TextFieldConfigWriter;
import mediathek.gui.dialogEinstellungen.allgemein.TimedDocumentListener;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.SenderIconStyleChangedEvent;
import mediathek.gui.messages.TabVisualSettingsChangedEvent;
import mediathek.gui.messages.TrayIconEvent;
import mediathek.gui.messages.UpdateStateChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.VerticalLayout;

public class PanelEinstellungen
extends JPanel {
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private JCheckBox jCheckBoxTabsTop;
    private JCheckBox jCheckBoxTabIcon;
    private JCheckBox cbAutomaticMenuTabSwitching;
    private JCheckBox cbRestoreSelectedTab;
    private JTextField jtfUserAgent;
    private JTextField jtfProxyHost;
    private JTextField jtfProxyPort;
    private JTextField jtfProxyUser;
    private JPasswordField jpfProxyPassword;
    private JCheckBox jCheckBoxTray;
    private JCheckBox cbUseWikipediaSenderLogos;
    private JCheckBox cbAutomaticUpdateChecks;
    private JXTitledPanel modernSearchTitlePanel;

    private void setupProxySettings() {
        this.jtfProxyHost.setText(this.config.getString("http.proxy.hostname", ""));
        TextFieldConfigWriter listener = new TextFieldConfigWriter(this.jtfProxyHost, "http.proxy.hostname");
        this.jtfProxyHost.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jtfProxyPort.setText(this.config.getString("http.proxy.port", ""));
        listener = new TextFieldConfigWriter(this.jtfProxyPort, "http.proxy.port");
        this.jtfProxyPort.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jtfProxyUser.setText(this.config.getString("http.proxy.user", ""));
        listener = new TextFieldConfigWriter(this.jtfProxyUser, "http.proxy.user");
        this.jtfProxyUser.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jpfProxyPassword.setText(this.config.getString("http.proxy.password", ""));
        listener = new TextFieldConfigWriter(this.jpfProxyPassword, "http.proxy.password");
        this.jpfProxyPassword.getDocument().addDocumentListener(new TimedDocumentListener(listener));
    }

    private void setupUserAgentSettings() {
        this.jtfUserAgent.setText(ApplicationConfiguration.getConfiguration().getString("application.user_agent"));
        TextFieldConfigWriter listener = new TextFieldConfigWriter(this.jtfUserAgent, "application.user_agent");
        this.jtfUserAgent.getDocument().addDocumentListener(new TimedDocumentListener(listener));
    }

    private void cbUseWikipediaSenderLogosActionPerformed(ActionEvent evt) {
        ApplicationConfiguration.getConfiguration().setProperty("application.sender_icons.use_local", !this.cbUseWikipediaSenderLogos.isSelected());
        MessageBus.getMessageBus().publishAsync(new SenderIconStyleChangedEvent());
    }

    private void cbAutomaticUpdateChecksActionPerformed(ActionEvent evt) {
        ApplicationConfiguration.getConfiguration().setProperty("application.automatic_update_check", this.cbAutomaticUpdateChecks.isSelected());
        MessageBus.getMessageBus().publishAsync(new UpdateStateChangedEvent(this.cbAutomaticUpdateChecks.isSelected()));
    }

    private void setupTabUI() {
        boolean tabPositionTop = this.config.getBoolean("application.ui.tab_position.top", true);
        this.jCheckBoxTabsTop.setSelected(tabPositionTop);
        this.jCheckBoxTabsTop.addActionListener(ae -> {
            this.config.setProperty("application.ui.tab_position.top", this.jCheckBoxTabsTop.isSelected());
            MessageBus.getMessageBus().publishAsync(new TabVisualSettingsChangedEvent());
        });
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.jCheckBoxTabIcon.setSelected(config.getBoolean("application.ui.mainwindow.tab_icons", false));
        this.jCheckBoxTabIcon.addActionListener(ae -> {
            config.setProperty("application.ui.mainwindow.tab_icons", this.jCheckBoxTabIcon.isSelected());
            MessageBus.getMessageBus().publishAsync(new TabVisualSettingsChangedEvent());
        });
    }

    @Handler
    private void handleTrayIconEvent(TrayIconEvent e) {
        SwingUtilities.invokeLater(() -> this.jCheckBoxTray.setSelected(this.config.getBoolean("application.ui.tray.use", false)));
    }

    private void setupTray() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.jCheckBoxTray.setSelected(false);
            this.jCheckBoxTray.setEnabled(false);
        } else {
            MessageBus.getMessageBus().subscribe(this);
            this.jCheckBoxTray.setSelected(this.config.getBoolean("application.ui.tray.use", false));
            this.jCheckBoxTray.addActionListener(ae -> {
                this.config.setProperty("application.ui.tray.use", this.jCheckBoxTray.isSelected());
                MediathekGui.ui().initializeSystemTray();
            });
        }
    }

    private void setupModernSearch() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean useModernSearch = config.getBoolean("application.use.modern_search", false);
        ModernSearchConfigPanel searchPanel = new ModernSearchConfigPanel();
        searchPanel.getCbActivateModernSearch().setSelected(useModernSearch);
        searchPanel.getCbActivateModernSearch().addActionListener(l -> {
            boolean selected = searchPanel.getCbActivateModernSearch().isSelected();
            config.setProperty("application.use.modern_search", selected);
        });
        this.modernSearchTitlePanel.setContentContainer(searchPanel);
    }

    public PanelEinstellungen() {
        this.initComponents();
        this.setupModernSearch();
        this.setupUserAgentSettings();
        this.setupProxySettings();
        this.setupTabUI();
        this.setupTray();
        this.setupTabSwitchListener();
        this.cbUseWikipediaSenderLogos.addActionListener(this::cbUseWikipediaSenderLogosActionPerformed);
        boolean useLocalSenderLogos = ApplicationConfiguration.getConfiguration().getBoolean("application.sender_icons.use_local", false);
        this.cbUseWikipediaSenderLogos.setSelected(!useLocalSenderLogos);
        this.cbAutomaticUpdateChecks.addActionListener(this::cbAutomaticUpdateChecksActionPerformed);
        this.cbAutomaticUpdateChecks.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("application.automatic_update_check", true));
        if (GuiFunktionen.isUsingExternalUpdater()) {
            this.cbAutomaticUpdateChecks.setEnabled(false);
            this.cbAutomaticUpdateChecks.setToolTipText("Diese Option ist deaktiviert, da ein externer Updater verwendet wird.");
        }
        boolean restore = ApplicationConfiguration.getConfiguration().getBoolean("application.ui.restore_selected_tab", false);
        this.cbRestoreSelectedTab.setSelected(restore);
        this.cbRestoreSelectedTab.addActionListener(l -> ApplicationConfiguration.getConfiguration().setProperty("application.ui.restore_selected_tab", this.cbRestoreSelectedTab.isSelected()));
    }

    private void setupTabSwitchListener() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cbAutomaticMenuTabSwitching.setEnabled(false);
            this.config.setProperty("application.ui.install_tab_listeners", false);
        } else {
            boolean installed;
            try {
                installed = this.config.getBoolean("application.ui.install_tab_listeners");
            }
            catch (NoSuchElementException ex) {
                installed = true;
                this.config.setProperty("application.ui.install_tab_listeners", true);
            }
            this.cbAutomaticMenuTabSwitching.setSelected(installed);
            this.cbAutomaticMenuTabSwitching.addActionListener(e -> {
                boolean isOn = this.cbAutomaticMenuTabSwitching.isSelected();
                this.config.setProperty("application.ui.install_tab_listeners", isOn);
                InstallTabSwitchListenerEvent evt = new InstallTabSwitchListenerEvent();
                evt.event = isOn ? InstallTabSwitchListenerEvent.INSTALL_TYPE.INSTALL : InstallTabSwitchListenerEvent.INSTALL_TYPE.REMOVE;
                MessageBus.getMessageBus().publishAsync(evt);
            });
        }
    }

    private void initComponents() {
        JPanel jPanel5 = new JPanel();
        this.jCheckBoxTabsTop = new JCheckBox();
        this.jCheckBoxTabIcon = new JCheckBox();
        this.cbAutomaticMenuTabSwitching = new JCheckBox();
        this.cbRestoreSelectedTab = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jtfUserAgent = new JTextField();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.jtfProxyHost = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.jtfProxyPort = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.jtfProxyUser = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.jpfProxyPassword = new JPasswordField();
        JPanel panel1 = new JPanel();
        this.jCheckBoxTray = new JCheckBox();
        this.cbUseWikipediaSenderLogos = new JCheckBox();
        this.cbAutomaticUpdateChecks = new JCheckBox();
        this.modernSearchTitlePanel = new JXTitledPanel();
        this.setMaximumSize(new Dimension(10, 10));
        jPanel5.setBorder(new TitledBorder("Tab-Verhalten"));
        jPanel5.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().fill().gap().fill(), new AC().gap().fill()));
        this.jCheckBoxTabsTop.setText("Tabs oben anzeigen");
        jPanel5.add((Component)this.jCheckBoxTabsTop, new CC().cell(0, 0));
        this.jCheckBoxTabIcon.setText("Icons anzeigen");
        this.jCheckBoxTabIcon.setToolTipText("Im Tab keine Icons anzeigen");
        jPanel5.add((Component)this.jCheckBoxTabIcon, new CC().cell(1, 0));
        this.cbAutomaticMenuTabSwitching.setText("Tabs schalten automatisch bei Men\u00fcnutzung um");
        jPanel5.add((Component)this.cbAutomaticMenuTabSwitching, new CC().cell(2, 0));
        this.cbRestoreSelectedTab.setText("Letzte Auswahl beim Start wiederherstellen");
        this.cbRestoreSelectedTab.setToolTipText("Wenn gew\u00e4hlt wird beim Start des Programms automatisch das zuletzt genutzte Tab aktiviert.");
        jPanel5.add((Component)this.cbRestoreSelectedTab, new CC().cell(0, 1, 3, 1));
        jPanel3.setBorder(new TitledBorder("Download"));
        jLabel3.setText("User-Agent:");
        this.jtfUserAgent.setMinimumSize(new Dimension(200, 26));
        this.jtfUserAgent.setPreferredSize(new Dimension(520, 26));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(jLabel3).addGap(5, 5, 5).addComponent(this.jtfUserAgent, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel3)).addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jtfUserAgent, -2, -1, -2)));
        jPanel4.setBorder(new TitledBorder("HTTP-Proxy (Neustart erforderlich!)"));
        jPanel4.setToolTipText("");
        jLabel4.setText("Host:");
        jLabel5.setText("Port:");
        jLabel7.setText("User:");
        jLabel8.setText("Passwort:");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtfProxyHost, -2, 250, -2)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtfProxyUser))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel8).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jtfProxyPort, -2, 72, -2).addGap(0, 187, Short.MAX_VALUE)).addComponent(this.jpfProxyPassword)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.jtfProxyHost, -2, -1, -2).addComponent(jLabel5).addComponent(this.jtfProxyPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(this.jtfProxyUser, -2, -1, -2).addComponent(jLabel8).addComponent(this.jpfProxyPassword, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        panel1.setLayout(new VerticalLayout());
        this.jCheckBoxTray.setText("Programm ins Tray minimieren");
        panel1.add(this.jCheckBoxTray);
        this.cbUseWikipediaSenderLogos.setText("Senderlogos von Wikipedia verwenden");
        panel1.add(this.cbUseWikipediaSenderLogos);
        this.cbAutomaticUpdateChecks.setText("Programmupdates t\u00e4glich suchen");
        panel1.add(this.cbAutomaticUpdateChecks);
        this.modernSearchTitlePanel.setTitle("Moderne Suche");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(jPanel3, -1, -1, Short.MAX_VALUE).addComponent(jPanel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(jPanel4, -2, -1, -2).addComponent(panel1, -2, -1, -2)).addGap(0, 20, Short.MAX_VALUE)).addComponent(this.modernSearchTitlePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modernSearchTitlePanel, -1, 143, Short.MAX_VALUE).addContainerGap()));
    }
}

