import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListConflictingAliasesCommand, se_ListConflictingAliasesCommand } from "../protocols/Aws_restXml";
export { $Command };
export class ListConflictingAliasesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "ListConflictingAliases", {})
    .n("CloudFrontClient", "ListConflictingAliasesCommand")
    .f(void 0, void 0)
    .ser(se_ListConflictingAliasesCommand)
    .de(de_ListConflictingAliasesCommand)
    .build() {
}
