/* SPDX-License-Identifier: GPL-2.0+ */
// s2dos05.h
//
// Copyright (c) 2016 Samsung Electronics Co., Ltd
//              http://www.samsung.com
// Copyright (C) 2024 Dzmitry Sankouski <dsankouski@gmail.com>

#ifndef __LINUX_S2DOS05_H
#define __LINUX_S2DOS05_H

// S2DOS05 registers
// Slave Addr : 0xC0
enum S2DOS05_reg {
	S2DOS05_REG_DEV_ID,
	S2DOS05_REG_TOPSYS_STAT,
	S2DOS05_REG_STAT,
	S2DOS05_REG_EN,
	S2DOS05_REG_LDO1_CFG,
	S2DOS05_REG_LDO2_CFG,
	S2DOS05_REG_LDO3_CFG,
	S2DOS05_REG_LDO4_CFG,
	S2DOS05_REG_BUCK_CFG,
	S2DOS05_REG_BUCK_VOUT,
	S2DOS05_REG_IRQ_MASK = 0x0D,
	S2DOS05_REG_SSD_TSD = 0x0E,
	S2DOS05_REG_OCL = 0x10,
	S2DOS05_REG_IRQ = 0x11
};

// S2DOS05 regulator ids
enum S2DOS05_regulators {
	S2DOS05_LDO1,
	S2DOS05_LDO2,
	S2DOS05_LDO3,
	S2DOS05_LDO4,
	S2DOS05_BUCK1,
	S2DOS05_REG_MAX,
};

#define S2DOS05_IRQ_PWRMT_MASK	BIT(5)
#define S2DOS05_IRQ_TSD_MASK	BIT(4)
#define S2DOS05_IRQ_SSD_MASK	BIT(3)
#define S2DOS05_IRQ_SCP_MASK	BIT(2)
#define S2DOS05_IRQ_UVLO_MASK	BIT(1)
#define S2DOS05_IRQ_OCD_MASK	BIT(0)

#define S2DOS05_BUCK_MIN1	506250
#define S2DOS05_LDO_MIN1	1500000
#define S2DOS05_LDO_MIN2	2700000
#define S2DOS05_BUCK_STEP1	6250
#define S2DOS05_LDO_STEP1	25000
#define S2DOS05_LDO_VSEL_MASK	0x7F
#define S2DOS05_LDO_FD_MASK	0x80
#define S2DOS05_BUCK_VSEL_MASK	0xFF
#define S2DOS05_BUCK_FD_MASK	0x08

#define S2DOS05_ENABLE_MASK_L1	BIT(0)
#define S2DOS05_ENABLE_MASK_L2	BIT(1)
#define S2DOS05_ENABLE_MASK_L3	BIT(2)
#define S2DOS05_ENABLE_MASK_L4	BIT(3)
#define S2DOS05_ENABLE_MASK_B1	BIT(4)

#define S2DOS05_RAMP_DELAY	12000

#define S2DOS05_ENABLE_TIME_LDO		50
#define S2DOS05_ENABLE_TIME_BUCK	350

#define S2DOS05_LDO_N_VOLTAGES	(S2DOS05_LDO_VSEL_MASK + 1)
#define S2DOS05_BUCK_N_VOLTAGES (S2DOS05_BUCK_VSEL_MASK + 1)

#define S2DOS05_REGULATOR_MAX	(S2DOS05_REG_MAX)

#endif // __LINUX_S2DOS05_H
