/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UidCreateChildToken uidCreateChildToken is a command that creates a new child token using Akeyless Universal Identity.
type UidCreateChildToken struct {
	// The universal identity auth method name, required only when uid-token is not provided
	AuthMethodName *string `json:"auth-method-name,omitempty"`
	// Deny from new child to create their own children
	ChildDenyInheritance *bool `json:"child-deny-inheritance,omitempty"`
	// Deny from new child to rotate
	ChildDenyRotate *bool `json:"child-deny-rotate,omitempty"`
	// New child token ttl
	ChildTtl *int32 `json:"child-ttl,omitempty"`
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// The ID of the uid-token, required only when uid-token is not provided
	UidTokenId *string `json:"uid-token-id,omitempty"`
}

// NewUidCreateChildToken instantiates a new UidCreateChildToken object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUidCreateChildToken() *UidCreateChildToken {
	this := UidCreateChildToken{}
	var json bool = false
	this.Json = &json
	return &this
}

// NewUidCreateChildTokenWithDefaults instantiates a new UidCreateChildToken object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUidCreateChildTokenWithDefaults() *UidCreateChildToken {
	this := UidCreateChildToken{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAuthMethodName returns the AuthMethodName field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetAuthMethodName() string {
	if o == nil || o.AuthMethodName == nil {
		var ret string
		return ret
	}
	return *o.AuthMethodName
}

// GetAuthMethodNameOk returns a tuple with the AuthMethodName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetAuthMethodNameOk() (*string, bool) {
	if o == nil || o.AuthMethodName == nil {
		return nil, false
	}
	return o.AuthMethodName, true
}

// HasAuthMethodName returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasAuthMethodName() bool {
	if o != nil && o.AuthMethodName != nil {
		return true
	}

	return false
}

// SetAuthMethodName gets a reference to the given string and assigns it to the AuthMethodName field.
func (o *UidCreateChildToken) SetAuthMethodName(v string) {
	o.AuthMethodName = &v
}

// GetChildDenyInheritance returns the ChildDenyInheritance field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetChildDenyInheritance() bool {
	if o == nil || o.ChildDenyInheritance == nil {
		var ret bool
		return ret
	}
	return *o.ChildDenyInheritance
}

// GetChildDenyInheritanceOk returns a tuple with the ChildDenyInheritance field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetChildDenyInheritanceOk() (*bool, bool) {
	if o == nil || o.ChildDenyInheritance == nil {
		return nil, false
	}
	return o.ChildDenyInheritance, true
}

// HasChildDenyInheritance returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasChildDenyInheritance() bool {
	if o != nil && o.ChildDenyInheritance != nil {
		return true
	}

	return false
}

// SetChildDenyInheritance gets a reference to the given bool and assigns it to the ChildDenyInheritance field.
func (o *UidCreateChildToken) SetChildDenyInheritance(v bool) {
	o.ChildDenyInheritance = &v
}

// GetChildDenyRotate returns the ChildDenyRotate field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetChildDenyRotate() bool {
	if o == nil || o.ChildDenyRotate == nil {
		var ret bool
		return ret
	}
	return *o.ChildDenyRotate
}

// GetChildDenyRotateOk returns a tuple with the ChildDenyRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetChildDenyRotateOk() (*bool, bool) {
	if o == nil || o.ChildDenyRotate == nil {
		return nil, false
	}
	return o.ChildDenyRotate, true
}

// HasChildDenyRotate returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasChildDenyRotate() bool {
	if o != nil && o.ChildDenyRotate != nil {
		return true
	}

	return false
}

// SetChildDenyRotate gets a reference to the given bool and assigns it to the ChildDenyRotate field.
func (o *UidCreateChildToken) SetChildDenyRotate(v bool) {
	o.ChildDenyRotate = &v
}

// GetChildTtl returns the ChildTtl field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetChildTtl() int32 {
	if o == nil || o.ChildTtl == nil {
		var ret int32
		return ret
	}
	return *o.ChildTtl
}

// GetChildTtlOk returns a tuple with the ChildTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetChildTtlOk() (*int32, bool) {
	if o == nil || o.ChildTtl == nil {
		return nil, false
	}
	return o.ChildTtl, true
}

// HasChildTtl returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasChildTtl() bool {
	if o != nil && o.ChildTtl != nil {
		return true
	}

	return false
}

// SetChildTtl gets a reference to the given int32 and assigns it to the ChildTtl field.
func (o *UidCreateChildToken) SetChildTtl(v int32) {
	o.ChildTtl = &v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *UidCreateChildToken) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *UidCreateChildToken) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UidCreateChildToken) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UidCreateChildToken) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UidCreateChildToken) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUidTokenId returns the UidTokenId field value if set, zero value otherwise.
func (o *UidCreateChildToken) GetUidTokenId() string {
	if o == nil || o.UidTokenId == nil {
		var ret string
		return ret
	}
	return *o.UidTokenId
}

// GetUidTokenIdOk returns a tuple with the UidTokenId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidCreateChildToken) GetUidTokenIdOk() (*string, bool) {
	if o == nil || o.UidTokenId == nil {
		return nil, false
	}
	return o.UidTokenId, true
}

// HasUidTokenId returns a boolean if a field has been set.
func (o *UidCreateChildToken) HasUidTokenId() bool {
	if o != nil && o.UidTokenId != nil {
		return true
	}

	return false
}

// SetUidTokenId gets a reference to the given string and assigns it to the UidTokenId field.
func (o *UidCreateChildToken) SetUidTokenId(v string) {
	o.UidTokenId = &v
}

func (o UidCreateChildToken) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AuthMethodName != nil {
		toSerialize["auth-method-name"] = o.AuthMethodName
	}
	if o.ChildDenyInheritance != nil {
		toSerialize["child-deny-inheritance"] = o.ChildDenyInheritance
	}
	if o.ChildDenyRotate != nil {
		toSerialize["child-deny-rotate"] = o.ChildDenyRotate
	}
	if o.ChildTtl != nil {
		toSerialize["child-ttl"] = o.ChildTtl
	}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UidTokenId != nil {
		toSerialize["uid-token-id"] = o.UidTokenId
	}
	return json.Marshal(toSerialize)
}

type NullableUidCreateChildToken struct {
	value *UidCreateChildToken
	isSet bool
}

func (v NullableUidCreateChildToken) Get() *UidCreateChildToken {
	return v.value
}

func (v *NullableUidCreateChildToken) Set(val *UidCreateChildToken) {
	v.value = val
	v.isSet = true
}

func (v NullableUidCreateChildToken) IsSet() bool {
	return v.isSet
}

func (v *NullableUidCreateChildToken) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUidCreateChildToken(val *UidCreateChildToken) *NullableUidCreateChildToken {
	return &NullableUidCreateChildToken{value: val, isSet: true}
}

func (v NullableUidCreateChildToken) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUidCreateChildToken) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


