/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreateHashiVault struct for TargetCreateHashiVault
type TargetCreateHashiVault struct {
	// Description of the object
	Description *string `json:"description,omitempty"`
	// HashiCorp Vault API URL, e.g. https://vault-mgr01:8200
	HashiUrl *string `json:"hashi-url,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Comma-separated list of vault namespaces
	Namespace *[]string `json:"namespace,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Vault access token with sufficient permissions
	VaultToken *string `json:"vault-token,omitempty"`
}

// NewTargetCreateHashiVault instantiates a new TargetCreateHashiVault object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreateHashiVault(name string, ) *TargetCreateHashiVault {
	this := TargetCreateHashiVault{}
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewTargetCreateHashiVaultWithDefaults instantiates a new TargetCreateHashiVault object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreateHashiVaultWithDefaults() *TargetCreateHashiVault {
	this := TargetCreateHashiVault{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreateHashiVault) SetDescription(v string) {
	o.Description = &v
}

// GetHashiUrl returns the HashiUrl field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetHashiUrl() string {
	if o == nil || o.HashiUrl == nil {
		var ret string
		return ret
	}
	return *o.HashiUrl
}

// GetHashiUrlOk returns a tuple with the HashiUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetHashiUrlOk() (*string, bool) {
	if o == nil || o.HashiUrl == nil {
		return nil, false
	}
	return o.HashiUrl, true
}

// HasHashiUrl returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasHashiUrl() bool {
	if o != nil && o.HashiUrl != nil {
		return true
	}

	return false
}

// SetHashiUrl gets a reference to the given string and assigns it to the HashiUrl field.
func (o *TargetCreateHashiVault) SetHashiUrl(v string) {
	o.HashiUrl = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreateHashiVault) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreateHashiVault) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreateHashiVault) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreateHashiVault) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreateHashiVault) SetName(v string) {
	o.Name = v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetNamespace() []string {
	if o == nil || o.Namespace == nil {
		var ret []string
		return ret
	}
	return *o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetNamespaceOk() (*[]string, bool) {
	if o == nil || o.Namespace == nil {
		return nil, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasNamespace() bool {
	if o != nil && o.Namespace != nil {
		return true
	}

	return false
}

// SetNamespace gets a reference to the given []string and assigns it to the Namespace field.
func (o *TargetCreateHashiVault) SetNamespace(v []string) {
	o.Namespace = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreateHashiVault) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreateHashiVault) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVaultToken returns the VaultToken field value if set, zero value otherwise.
func (o *TargetCreateHashiVault) GetVaultToken() string {
	if o == nil || o.VaultToken == nil {
		var ret string
		return ret
	}
	return *o.VaultToken
}

// GetVaultTokenOk returns a tuple with the VaultToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateHashiVault) GetVaultTokenOk() (*string, bool) {
	if o == nil || o.VaultToken == nil {
		return nil, false
	}
	return o.VaultToken, true
}

// HasVaultToken returns a boolean if a field has been set.
func (o *TargetCreateHashiVault) HasVaultToken() bool {
	if o != nil && o.VaultToken != nil {
		return true
	}

	return false
}

// SetVaultToken gets a reference to the given string and assigns it to the VaultToken field.
func (o *TargetCreateHashiVault) SetVaultToken(v string) {
	o.VaultToken = &v
}

func (o TargetCreateHashiVault) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.HashiUrl != nil {
		toSerialize["hashi-url"] = o.HashiUrl
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Namespace != nil {
		toSerialize["namespace"] = o.Namespace
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.VaultToken != nil {
		toSerialize["vault-token"] = o.VaultToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreateHashiVault struct {
	value *TargetCreateHashiVault
	isSet bool
}

func (v NullableTargetCreateHashiVault) Get() *TargetCreateHashiVault {
	return v.value
}

func (v *NullableTargetCreateHashiVault) Set(val *TargetCreateHashiVault) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreateHashiVault) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreateHashiVault) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreateHashiVault(val *TargetCreateHashiVault) *NullableTargetCreateHashiVault {
	return &NullableTargetCreateHashiVault{value: val, isSet: true}
}

func (v NullableTargetCreateHashiVault) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreateHashiVault) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


