/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ListItemsInPathOutput struct for ListItemsInPathOutput
type ListItemsInPathOutput struct {
	Folders *[]string `json:"folders,omitempty"`
	Items *[]Item `json:"items,omitempty"`
	NextPage *string `json:"next_page,omitempty"`
}

// NewListItemsInPathOutput instantiates a new ListItemsInPathOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListItemsInPathOutput() *ListItemsInPathOutput {
	this := ListItemsInPathOutput{}
	return &this
}

// NewListItemsInPathOutputWithDefaults instantiates a new ListItemsInPathOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListItemsInPathOutputWithDefaults() *ListItemsInPathOutput {
	this := ListItemsInPathOutput{}
	return &this
}

// GetFolders returns the Folders field value if set, zero value otherwise.
func (o *ListItemsInPathOutput) GetFolders() []string {
	if o == nil || o.Folders == nil {
		var ret []string
		return ret
	}
	return *o.Folders
}

// GetFoldersOk returns a tuple with the Folders field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListItemsInPathOutput) GetFoldersOk() (*[]string, bool) {
	if o == nil || o.Folders == nil {
		return nil, false
	}
	return o.Folders, true
}

// HasFolders returns a boolean if a field has been set.
func (o *ListItemsInPathOutput) HasFolders() bool {
	if o != nil && o.Folders != nil {
		return true
	}

	return false
}

// SetFolders gets a reference to the given []string and assigns it to the Folders field.
func (o *ListItemsInPathOutput) SetFolders(v []string) {
	o.Folders = &v
}

// GetItems returns the Items field value if set, zero value otherwise.
func (o *ListItemsInPathOutput) GetItems() []Item {
	if o == nil || o.Items == nil {
		var ret []Item
		return ret
	}
	return *o.Items
}

// GetItemsOk returns a tuple with the Items field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListItemsInPathOutput) GetItemsOk() (*[]Item, bool) {
	if o == nil || o.Items == nil {
		return nil, false
	}
	return o.Items, true
}

// HasItems returns a boolean if a field has been set.
func (o *ListItemsInPathOutput) HasItems() bool {
	if o != nil && o.Items != nil {
		return true
	}

	return false
}

// SetItems gets a reference to the given []Item and assigns it to the Items field.
func (o *ListItemsInPathOutput) SetItems(v []Item) {
	o.Items = &v
}

// GetNextPage returns the NextPage field value if set, zero value otherwise.
func (o *ListItemsInPathOutput) GetNextPage() string {
	if o == nil || o.NextPage == nil {
		var ret string
		return ret
	}
	return *o.NextPage
}

// GetNextPageOk returns a tuple with the NextPage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListItemsInPathOutput) GetNextPageOk() (*string, bool) {
	if o == nil || o.NextPage == nil {
		return nil, false
	}
	return o.NextPage, true
}

// HasNextPage returns a boolean if a field has been set.
func (o *ListItemsInPathOutput) HasNextPage() bool {
	if o != nil && o.NextPage != nil {
		return true
	}

	return false
}

// SetNextPage gets a reference to the given string and assigns it to the NextPage field.
func (o *ListItemsInPathOutput) SetNextPage(v string) {
	o.NextPage = &v
}

func (o ListItemsInPathOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Folders != nil {
		toSerialize["folders"] = o.Folders
	}
	if o.Items != nil {
		toSerialize["items"] = o.Items
	}
	if o.NextPage != nil {
		toSerialize["next_page"] = o.NextPage
	}
	return json.Marshal(toSerialize)
}

type NullableListItemsInPathOutput struct {
	value *ListItemsInPathOutput
	isSet bool
}

func (v NullableListItemsInPathOutput) Get() *ListItemsInPathOutput {
	return v.value
}

func (v *NullableListItemsInPathOutput) Set(val *ListItemsInPathOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableListItemsInPathOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableListItemsInPathOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListItemsInPathOutput(val *ListItemsInPathOutput) *NullableListItemsInPathOutput {
	return &NullableListItemsInPathOutput{value: val, isSet: true}
}

func (v NullableListItemsInPathOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListItemsInPathOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


