/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GwUpdateRemoteAccessSessionLogsGoogleChronicle gwUpdateRemoteAccessSessionLogsGoogleChronicle is a command that updates session log forwarding config (google-chronicle target)
type GwUpdateRemoteAccessSessionLogsGoogleChronicle struct {
	// Google chronicle customer id
	CustomerId *string `json:"customer-id,omitempty"`
	// Enable Log Forwarding [true/false]
	Enable *string `json:"enable,omitempty"`
	// Base64-encoded service account private key text
	GcpKey *string `json:"gcp-key,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Google chronicle log type
	LogType *string `json:"log-type,omitempty"`
	// Logs format [text/json]
	OutputFormat *string `json:"output-format,omitempty"`
	// Pull interval in seconds
	PullInterval *string `json:"pull-interval,omitempty"`
	// Google chronicle region [eu_multi_region/london/us_multi_region/singapore/tel_aviv]
	Region *string `json:"region,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGwUpdateRemoteAccessSessionLogsGoogleChronicle instantiates a new GwUpdateRemoteAccessSessionLogsGoogleChronicle object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGwUpdateRemoteAccessSessionLogsGoogleChronicle() *GwUpdateRemoteAccessSessionLogsGoogleChronicle {
	this := GwUpdateRemoteAccessSessionLogsGoogleChronicle{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	return &this
}

// NewGwUpdateRemoteAccessSessionLogsGoogleChronicleWithDefaults instantiates a new GwUpdateRemoteAccessSessionLogsGoogleChronicle object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGwUpdateRemoteAccessSessionLogsGoogleChronicleWithDefaults() *GwUpdateRemoteAccessSessionLogsGoogleChronicle {
	this := GwUpdateRemoteAccessSessionLogsGoogleChronicle{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	return &this
}

// GetCustomerId returns the CustomerId field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetCustomerId() string {
	if o == nil || o.CustomerId == nil {
		var ret string
		return ret
	}
	return *o.CustomerId
}

// GetCustomerIdOk returns a tuple with the CustomerId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetCustomerIdOk() (*string, bool) {
	if o == nil || o.CustomerId == nil {
		return nil, false
	}
	return o.CustomerId, true
}

// HasCustomerId returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasCustomerId() bool {
	if o != nil && o.CustomerId != nil {
		return true
	}

	return false
}

// SetCustomerId gets a reference to the given string and assigns it to the CustomerId field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetCustomerId(v string) {
	o.CustomerId = &v
}

// GetEnable returns the Enable field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetEnable() string {
	if o == nil || o.Enable == nil {
		var ret string
		return ret
	}
	return *o.Enable
}

// GetEnableOk returns a tuple with the Enable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetEnableOk() (*string, bool) {
	if o == nil || o.Enable == nil {
		return nil, false
	}
	return o.Enable, true
}

// HasEnable returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasEnable() bool {
	if o != nil && o.Enable != nil {
		return true
	}

	return false
}

// SetEnable gets a reference to the given string and assigns it to the Enable field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetEnable(v string) {
	o.Enable = &v
}

// GetGcpKey returns the GcpKey field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetGcpKey() string {
	if o == nil || o.GcpKey == nil {
		var ret string
		return ret
	}
	return *o.GcpKey
}

// GetGcpKeyOk returns a tuple with the GcpKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetGcpKeyOk() (*string, bool) {
	if o == nil || o.GcpKey == nil {
		return nil, false
	}
	return o.GcpKey, true
}

// HasGcpKey returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasGcpKey() bool {
	if o != nil && o.GcpKey != nil {
		return true
	}

	return false
}

// SetGcpKey gets a reference to the given string and assigns it to the GcpKey field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetGcpKey(v string) {
	o.GcpKey = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetJson(v bool) {
	o.Json = &v
}

// GetLogType returns the LogType field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetLogType() string {
	if o == nil || o.LogType == nil {
		var ret string
		return ret
	}
	return *o.LogType
}

// GetLogTypeOk returns a tuple with the LogType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetLogTypeOk() (*string, bool) {
	if o == nil || o.LogType == nil {
		return nil, false
	}
	return o.LogType, true
}

// HasLogType returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasLogType() bool {
	if o != nil && o.LogType != nil {
		return true
	}

	return false
}

// SetLogType gets a reference to the given string and assigns it to the LogType field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetLogType(v string) {
	o.LogType = &v
}

// GetOutputFormat returns the OutputFormat field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetOutputFormat() string {
	if o == nil || o.OutputFormat == nil {
		var ret string
		return ret
	}
	return *o.OutputFormat
}

// GetOutputFormatOk returns a tuple with the OutputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetOutputFormatOk() (*string, bool) {
	if o == nil || o.OutputFormat == nil {
		return nil, false
	}
	return o.OutputFormat, true
}

// HasOutputFormat returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasOutputFormat() bool {
	if o != nil && o.OutputFormat != nil {
		return true
	}

	return false
}

// SetOutputFormat gets a reference to the given string and assigns it to the OutputFormat field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetOutputFormat(v string) {
	o.OutputFormat = &v
}

// GetPullInterval returns the PullInterval field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetPullInterval() string {
	if o == nil || o.PullInterval == nil {
		var ret string
		return ret
	}
	return *o.PullInterval
}

// GetPullIntervalOk returns a tuple with the PullInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetPullIntervalOk() (*string, bool) {
	if o == nil || o.PullInterval == nil {
		return nil, false
	}
	return o.PullInterval, true
}

// HasPullInterval returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasPullInterval() bool {
	if o != nil && o.PullInterval != nil {
		return true
	}

	return false
}

// SetPullInterval gets a reference to the given string and assigns it to the PullInterval field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetPullInterval(v string) {
	o.PullInterval = &v
}

// GetRegion returns the Region field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetRegion() string {
	if o == nil || o.Region == nil {
		var ret string
		return ret
	}
	return *o.Region
}

// GetRegionOk returns a tuple with the Region field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetRegionOk() (*string, bool) {
	if o == nil || o.Region == nil {
		return nil, false
	}
	return o.Region, true
}

// HasRegion returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasRegion() bool {
	if o != nil && o.Region != nil {
		return true
	}

	return false
}

// SetRegion gets a reference to the given string and assigns it to the Region field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetRegion(v string) {
	o.Region = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GwUpdateRemoteAccessSessionLogsGoogleChronicle) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GwUpdateRemoteAccessSessionLogsGoogleChronicle) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CustomerId != nil {
		toSerialize["customer-id"] = o.CustomerId
	}
	if o.Enable != nil {
		toSerialize["enable"] = o.Enable
	}
	if o.GcpKey != nil {
		toSerialize["gcp-key"] = o.GcpKey
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.LogType != nil {
		toSerialize["log-type"] = o.LogType
	}
	if o.OutputFormat != nil {
		toSerialize["output-format"] = o.OutputFormat
	}
	if o.PullInterval != nil {
		toSerialize["pull-interval"] = o.PullInterval
	}
	if o.Region != nil {
		toSerialize["region"] = o.Region
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle struct {
	value *GwUpdateRemoteAccessSessionLogsGoogleChronicle
	isSet bool
}

func (v NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle) Get() *GwUpdateRemoteAccessSessionLogsGoogleChronicle {
	return v.value
}

func (v *NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle) Set(val *GwUpdateRemoteAccessSessionLogsGoogleChronicle) {
	v.value = val
	v.isSet = true
}

func (v NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle) IsSet() bool {
	return v.isSet
}

func (v *NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGwUpdateRemoteAccessSessionLogsGoogleChronicle(val *GwUpdateRemoteAccessSessionLogsGoogleChronicle) *NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle {
	return &NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle{value: val, isSet: true}
}

func (v NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGwUpdateRemoteAccessSessionLogsGoogleChronicle) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


