/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GetSecretValue struct for GetSecretValue
type GetSecretValue struct {
	// for personal password manager
	Accessibility *string `json:"accessibility,omitempty"`
	// Retrieve the Secret value without checking the Gateway's cache [true/false]. This flag is only relevant when using the RestAPI
	IgnoreCache *string `json:"ignore-cache,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Secret name
	Names []string `json:"names"`
	// Print the secret value with json-pretty-print (not relevent to SDK)
	PrettyPrint *bool `json:"pretty-print,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Secret version, if negative value N is provided the last N versions will return (maximum 20)
	Version *int32 `json:"version,omitempty"`
}

// NewGetSecretValue instantiates a new GetSecretValue object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGetSecretValue(names []string, ) *GetSecretValue {
	this := GetSecretValue{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var ignoreCache string = "false"
	this.IgnoreCache = &ignoreCache
	var json bool = false
	this.Json = &json
	this.Names = names
	return &this
}

// NewGetSecretValueWithDefaults instantiates a new GetSecretValue object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGetSecretValueWithDefaults() *GetSecretValue {
	this := GetSecretValue{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var ignoreCache string = "false"
	this.IgnoreCache = &ignoreCache
	var json bool = false
	this.Json = &json
	return &this
}

// GetAccessibility returns the Accessibility field value if set, zero value otherwise.
func (o *GetSecretValue) GetAccessibility() string {
	if o == nil || o.Accessibility == nil {
		var ret string
		return ret
	}
	return *o.Accessibility
}

// GetAccessibilityOk returns a tuple with the Accessibility field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetAccessibilityOk() (*string, bool) {
	if o == nil || o.Accessibility == nil {
		return nil, false
	}
	return o.Accessibility, true
}

// HasAccessibility returns a boolean if a field has been set.
func (o *GetSecretValue) HasAccessibility() bool {
	if o != nil && o.Accessibility != nil {
		return true
	}

	return false
}

// SetAccessibility gets a reference to the given string and assigns it to the Accessibility field.
func (o *GetSecretValue) SetAccessibility(v string) {
	o.Accessibility = &v
}

// GetIgnoreCache returns the IgnoreCache field value if set, zero value otherwise.
func (o *GetSecretValue) GetIgnoreCache() string {
	if o == nil || o.IgnoreCache == nil {
		var ret string
		return ret
	}
	return *o.IgnoreCache
}

// GetIgnoreCacheOk returns a tuple with the IgnoreCache field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetIgnoreCacheOk() (*string, bool) {
	if o == nil || o.IgnoreCache == nil {
		return nil, false
	}
	return o.IgnoreCache, true
}

// HasIgnoreCache returns a boolean if a field has been set.
func (o *GetSecretValue) HasIgnoreCache() bool {
	if o != nil && o.IgnoreCache != nil {
		return true
	}

	return false
}

// SetIgnoreCache gets a reference to the given string and assigns it to the IgnoreCache field.
func (o *GetSecretValue) SetIgnoreCache(v string) {
	o.IgnoreCache = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GetSecretValue) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GetSecretValue) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GetSecretValue) SetJson(v bool) {
	o.Json = &v
}

// GetNames returns the Names field value
func (o *GetSecretValue) GetNames() []string {
	if o == nil  {
		var ret []string
		return ret
	}

	return o.Names
}

// GetNamesOk returns a tuple with the Names field value
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetNamesOk() (*[]string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Names, true
}

// SetNames sets field value
func (o *GetSecretValue) SetNames(v []string) {
	o.Names = v
}

// GetPrettyPrint returns the PrettyPrint field value if set, zero value otherwise.
func (o *GetSecretValue) GetPrettyPrint() bool {
	if o == nil || o.PrettyPrint == nil {
		var ret bool
		return ret
	}
	return *o.PrettyPrint
}

// GetPrettyPrintOk returns a tuple with the PrettyPrint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetPrettyPrintOk() (*bool, bool) {
	if o == nil || o.PrettyPrint == nil {
		return nil, false
	}
	return o.PrettyPrint, true
}

// HasPrettyPrint returns a boolean if a field has been set.
func (o *GetSecretValue) HasPrettyPrint() bool {
	if o != nil && o.PrettyPrint != nil {
		return true
	}

	return false
}

// SetPrettyPrint gets a reference to the given bool and assigns it to the PrettyPrint field.
func (o *GetSecretValue) SetPrettyPrint(v bool) {
	o.PrettyPrint = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GetSecretValue) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GetSecretValue) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GetSecretValue) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GetSecretValue) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GetSecretValue) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GetSecretValue) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *GetSecretValue) GetVersion() int32 {
	if o == nil || o.Version == nil {
		var ret int32
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetSecretValue) GetVersionOk() (*int32, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *GetSecretValue) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int32 and assigns it to the Version field.
func (o *GetSecretValue) SetVersion(v int32) {
	o.Version = &v
}

func (o GetSecretValue) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Accessibility != nil {
		toSerialize["accessibility"] = o.Accessibility
	}
	if o.IgnoreCache != nil {
		toSerialize["ignore-cache"] = o.IgnoreCache
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["names"] = o.Names
	}
	if o.PrettyPrint != nil {
		toSerialize["pretty-print"] = o.PrettyPrint
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableGetSecretValue struct {
	value *GetSecretValue
	isSet bool
}

func (v NullableGetSecretValue) Get() *GetSecretValue {
	return v.value
}

func (v *NullableGetSecretValue) Set(val *GetSecretValue) {
	v.value = val
	v.isSet = true
}

func (v NullableGetSecretValue) IsSet() bool {
	return v.isSet
}

func (v *NullableGetSecretValue) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGetSecretValue(val *GetSecretValue) *NullableGetSecretValue {
	return &NullableGetSecretValue{value: val, isSet: true}
}

func (v NullableGetSecretValue) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGetSecretValue) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


