/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretUpdateGoogleWorkspace dynamicSecretUpdateGoogleWorkspace is a command that updates a Google Workspace dynamic secret
type DynamicSecretUpdateGoogleWorkspace struct {
	AccessMode string `json:"access-mode"`
	// Admin user email
	AdminEmail string `json:"admin-email"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Base64-encoded service account private key text
	GcpKey *string `json:"gcp-key,omitempty"`
	// A group email, relevant only for group access-mode
	GroupEmail *string `json:"group-email,omitempty"`
	GroupRole *string `json:"group-role,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Dynamic secret name
	NewName *string `json:"new-name,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// Name of the admin role to assign to the user, relevant only for role access-mode
	RoleName *string `json:"role-name,omitempty"`
	RoleScope *string `json:"role-scope,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Destination URL to inject secrets
	SecureAccessUrl *string `json:"secure-access-url,omitempty"`
	// Enable Web Secure Remote Access
	SecureAccessWeb *bool `json:"secure-access-web,omitempty"`
	// Secure browser via Akeyless Web Access Bastion
	SecureAccessWebBrowsing *bool `json:"secure-access-web-browsing,omitempty"`
	// Web-Proxy via Akeyless Web Access Bastion
	SecureAccessWebProxy *bool `json:"secure-access-web-proxy,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Name of existing target to use in dynamic secret creation
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
}

// NewDynamicSecretUpdateGoogleWorkspace instantiates a new DynamicSecretUpdateGoogleWorkspace object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretUpdateGoogleWorkspace(accessMode string, adminEmail string, name string, ) *DynamicSecretUpdateGoogleWorkspace {
	this := DynamicSecretUpdateGoogleWorkspace{}
	this.AccessMode = accessMode
	this.AdminEmail = adminEmail
	var json bool = false
	this.Json = &json
	this.Name = name
	var secureAccessWeb bool = true
	this.SecureAccessWeb = &secureAccessWeb
	var secureAccessWebBrowsing bool = false
	this.SecureAccessWebBrowsing = &secureAccessWebBrowsing
	var secureAccessWebProxy bool = false
	this.SecureAccessWebProxy = &secureAccessWebProxy
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretUpdateGoogleWorkspaceWithDefaults instantiates a new DynamicSecretUpdateGoogleWorkspace object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretUpdateGoogleWorkspaceWithDefaults() *DynamicSecretUpdateGoogleWorkspace {
	this := DynamicSecretUpdateGoogleWorkspace{}
	var json bool = false
	this.Json = &json
	var secureAccessWeb bool = true
	this.SecureAccessWeb = &secureAccessWeb
	var secureAccessWebBrowsing bool = false
	this.SecureAccessWebBrowsing = &secureAccessWebBrowsing
	var secureAccessWebProxy bool = false
	this.SecureAccessWebProxy = &secureAccessWebProxy
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// GetAccessMode returns the AccessMode field value
func (o *DynamicSecretUpdateGoogleWorkspace) GetAccessMode() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AccessMode
}

// GetAccessModeOk returns a tuple with the AccessMode field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetAccessModeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AccessMode, true
}

// SetAccessMode sets field value
func (o *DynamicSecretUpdateGoogleWorkspace) SetAccessMode(v string) {
	o.AccessMode = v
}

// GetAdminEmail returns the AdminEmail field value
func (o *DynamicSecretUpdateGoogleWorkspace) GetAdminEmail() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AdminEmail
}

// GetAdminEmailOk returns a tuple with the AdminEmail field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetAdminEmailOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AdminEmail, true
}

// SetAdminEmail sets field value
func (o *DynamicSecretUpdateGoogleWorkspace) SetAdminEmail(v string) {
	o.AdminEmail = v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetDescription(v string) {
	o.Description = &v
}

// GetGcpKey returns the GcpKey field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetGcpKey() string {
	if o == nil || o.GcpKey == nil {
		var ret string
		return ret
	}
	return *o.GcpKey
}

// GetGcpKeyOk returns a tuple with the GcpKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetGcpKeyOk() (*string, bool) {
	if o == nil || o.GcpKey == nil {
		return nil, false
	}
	return o.GcpKey, true
}

// HasGcpKey returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasGcpKey() bool {
	if o != nil && o.GcpKey != nil {
		return true
	}

	return false
}

// SetGcpKey gets a reference to the given string and assigns it to the GcpKey field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetGcpKey(v string) {
	o.GcpKey = &v
}

// GetGroupEmail returns the GroupEmail field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetGroupEmail() string {
	if o == nil || o.GroupEmail == nil {
		var ret string
		return ret
	}
	return *o.GroupEmail
}

// GetGroupEmailOk returns a tuple with the GroupEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetGroupEmailOk() (*string, bool) {
	if o == nil || o.GroupEmail == nil {
		return nil, false
	}
	return o.GroupEmail, true
}

// HasGroupEmail returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasGroupEmail() bool {
	if o != nil && o.GroupEmail != nil {
		return true
	}

	return false
}

// SetGroupEmail gets a reference to the given string and assigns it to the GroupEmail field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetGroupEmail(v string) {
	o.GroupEmail = &v
}

// GetGroupRole returns the GroupRole field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetGroupRole() string {
	if o == nil || o.GroupRole == nil {
		var ret string
		return ret
	}
	return *o.GroupRole
}

// GetGroupRoleOk returns a tuple with the GroupRole field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetGroupRoleOk() (*string, bool) {
	if o == nil || o.GroupRole == nil {
		return nil, false
	}
	return o.GroupRole, true
}

// HasGroupRole returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasGroupRole() bool {
	if o != nil && o.GroupRole != nil {
		return true
	}

	return false
}

// SetGroupRole gets a reference to the given string and assigns it to the GroupRole field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetGroupRole(v string) {
	o.GroupRole = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretUpdateGoogleWorkspace) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretUpdateGoogleWorkspace) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetNewName(v string) {
	o.NewName = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetRoleName returns the RoleName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetRoleName() string {
	if o == nil || o.RoleName == nil {
		var ret string
		return ret
	}
	return *o.RoleName
}

// GetRoleNameOk returns a tuple with the RoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetRoleNameOk() (*string, bool) {
	if o == nil || o.RoleName == nil {
		return nil, false
	}
	return o.RoleName, true
}

// HasRoleName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasRoleName() bool {
	if o != nil && o.RoleName != nil {
		return true
	}

	return false
}

// SetRoleName gets a reference to the given string and assigns it to the RoleName field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetRoleName(v string) {
	o.RoleName = &v
}

// GetRoleScope returns the RoleScope field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetRoleScope() string {
	if o == nil || o.RoleScope == nil {
		var ret string
		return ret
	}
	return *o.RoleScope
}

// GetRoleScopeOk returns a tuple with the RoleScope field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetRoleScopeOk() (*string, bool) {
	if o == nil || o.RoleScope == nil {
		return nil, false
	}
	return o.RoleScope, true
}

// HasRoleScope returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasRoleScope() bool {
	if o != nil && o.RoleScope != nil {
		return true
	}

	return false
}

// SetRoleScope gets a reference to the given string and assigns it to the RoleScope field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetRoleScope(v string) {
	o.RoleScope = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessUrl returns the SecureAccessUrl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessUrl() string {
	if o == nil || o.SecureAccessUrl == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessUrl
}

// GetSecureAccessUrlOk returns a tuple with the SecureAccessUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessUrlOk() (*string, bool) {
	if o == nil || o.SecureAccessUrl == nil {
		return nil, false
	}
	return o.SecureAccessUrl, true
}

// HasSecureAccessUrl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasSecureAccessUrl() bool {
	if o != nil && o.SecureAccessUrl != nil {
		return true
	}

	return false
}

// SetSecureAccessUrl gets a reference to the given string and assigns it to the SecureAccessUrl field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetSecureAccessUrl(v string) {
	o.SecureAccessUrl = &v
}

// GetSecureAccessWeb returns the SecureAccessWeb field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessWeb() bool {
	if o == nil || o.SecureAccessWeb == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWeb
}

// GetSecureAccessWebOk returns a tuple with the SecureAccessWeb field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessWebOk() (*bool, bool) {
	if o == nil || o.SecureAccessWeb == nil {
		return nil, false
	}
	return o.SecureAccessWeb, true
}

// HasSecureAccessWeb returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasSecureAccessWeb() bool {
	if o != nil && o.SecureAccessWeb != nil {
		return true
	}

	return false
}

// SetSecureAccessWeb gets a reference to the given bool and assigns it to the SecureAccessWeb field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetSecureAccessWeb(v bool) {
	o.SecureAccessWeb = &v
}

// GetSecureAccessWebBrowsing returns the SecureAccessWebBrowsing field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessWebBrowsing() bool {
	if o == nil || o.SecureAccessWebBrowsing == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWebBrowsing
}

// GetSecureAccessWebBrowsingOk returns a tuple with the SecureAccessWebBrowsing field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessWebBrowsingOk() (*bool, bool) {
	if o == nil || o.SecureAccessWebBrowsing == nil {
		return nil, false
	}
	return o.SecureAccessWebBrowsing, true
}

// HasSecureAccessWebBrowsing returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasSecureAccessWebBrowsing() bool {
	if o != nil && o.SecureAccessWebBrowsing != nil {
		return true
	}

	return false
}

// SetSecureAccessWebBrowsing gets a reference to the given bool and assigns it to the SecureAccessWebBrowsing field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetSecureAccessWebBrowsing(v bool) {
	o.SecureAccessWebBrowsing = &v
}

// GetSecureAccessWebProxy returns the SecureAccessWebProxy field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessWebProxy() bool {
	if o == nil || o.SecureAccessWebProxy == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWebProxy
}

// GetSecureAccessWebProxyOk returns a tuple with the SecureAccessWebProxy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetSecureAccessWebProxyOk() (*bool, bool) {
	if o == nil || o.SecureAccessWebProxy == nil {
		return nil, false
	}
	return o.SecureAccessWebProxy, true
}

// HasSecureAccessWebProxy returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasSecureAccessWebProxy() bool {
	if o != nil && o.SecureAccessWebProxy != nil {
		return true
	}

	return false
}

// SetSecureAccessWebProxy gets a reference to the given bool and assigns it to the SecureAccessWebProxy field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetSecureAccessWebProxy(v bool) {
	o.SecureAccessWebProxy = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGoogleWorkspace) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGoogleWorkspace) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretUpdateGoogleWorkspace) SetUserTtl(v string) {
	o.UserTtl = &v
}

func (o DynamicSecretUpdateGoogleWorkspace) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["access-mode"] = o.AccessMode
	}
	if true {
		toSerialize["admin-email"] = o.AdminEmail
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.GcpKey != nil {
		toSerialize["gcp-key"] = o.GcpKey
	}
	if o.GroupEmail != nil {
		toSerialize["group-email"] = o.GroupEmail
	}
	if o.GroupRole != nil {
		toSerialize["group-role"] = o.GroupRole
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.RoleName != nil {
		toSerialize["role-name"] = o.RoleName
	}
	if o.RoleScope != nil {
		toSerialize["role-scope"] = o.RoleScope
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessUrl != nil {
		toSerialize["secure-access-url"] = o.SecureAccessUrl
	}
	if o.SecureAccessWeb != nil {
		toSerialize["secure-access-web"] = o.SecureAccessWeb
	}
	if o.SecureAccessWebBrowsing != nil {
		toSerialize["secure-access-web-browsing"] = o.SecureAccessWebBrowsing
	}
	if o.SecureAccessWebProxy != nil {
		toSerialize["secure-access-web-proxy"] = o.SecureAccessWebProxy
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretUpdateGoogleWorkspace struct {
	value *DynamicSecretUpdateGoogleWorkspace
	isSet bool
}

func (v NullableDynamicSecretUpdateGoogleWorkspace) Get() *DynamicSecretUpdateGoogleWorkspace {
	return v.value
}

func (v *NullableDynamicSecretUpdateGoogleWorkspace) Set(val *DynamicSecretUpdateGoogleWorkspace) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretUpdateGoogleWorkspace) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretUpdateGoogleWorkspace) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretUpdateGoogleWorkspace(val *DynamicSecretUpdateGoogleWorkspace) *NullableDynamicSecretUpdateGoogleWorkspace {
	return &NullableDynamicSecretUpdateGoogleWorkspace{value: val, isSet: true}
}

func (v NullableDynamicSecretUpdateGoogleWorkspace) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretUpdateGoogleWorkspace) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


