/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DeactivateAcmeAccount deactivateAcmeAccount is a command that Deactivates \\ Deletes an acme external account
type DeactivateAcmeAccount struct {
	// The acme account id to deactivate
	AcmeAccountId string `json:"acme-account-id"`
	// The name of the PKI certificate issuer
	CertIssuerName string `json:"cert-issuer-name"`
	// Delete the account
	DeleteAccount *bool `json:"delete-account,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDeactivateAcmeAccount instantiates a new DeactivateAcmeAccount object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeactivateAcmeAccount(acmeAccountId string, certIssuerName string, ) *DeactivateAcmeAccount {
	this := DeactivateAcmeAccount{}
	this.AcmeAccountId = acmeAccountId
	this.CertIssuerName = certIssuerName
	var json bool = false
	this.Json = &json
	return &this
}

// NewDeactivateAcmeAccountWithDefaults instantiates a new DeactivateAcmeAccount object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeactivateAcmeAccountWithDefaults() *DeactivateAcmeAccount {
	this := DeactivateAcmeAccount{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAcmeAccountId returns the AcmeAccountId field value
func (o *DeactivateAcmeAccount) GetAcmeAccountId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AcmeAccountId
}

// GetAcmeAccountIdOk returns a tuple with the AcmeAccountId field value
// and a boolean to check if the value has been set.
func (o *DeactivateAcmeAccount) GetAcmeAccountIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AcmeAccountId, true
}

// SetAcmeAccountId sets field value
func (o *DeactivateAcmeAccount) SetAcmeAccountId(v string) {
	o.AcmeAccountId = v
}

// GetCertIssuerName returns the CertIssuerName field value
func (o *DeactivateAcmeAccount) GetCertIssuerName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.CertIssuerName
}

// GetCertIssuerNameOk returns a tuple with the CertIssuerName field value
// and a boolean to check if the value has been set.
func (o *DeactivateAcmeAccount) GetCertIssuerNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CertIssuerName, true
}

// SetCertIssuerName sets field value
func (o *DeactivateAcmeAccount) SetCertIssuerName(v string) {
	o.CertIssuerName = v
}

// GetDeleteAccount returns the DeleteAccount field value if set, zero value otherwise.
func (o *DeactivateAcmeAccount) GetDeleteAccount() bool {
	if o == nil || o.DeleteAccount == nil {
		var ret bool
		return ret
	}
	return *o.DeleteAccount
}

// GetDeleteAccountOk returns a tuple with the DeleteAccount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeactivateAcmeAccount) GetDeleteAccountOk() (*bool, bool) {
	if o == nil || o.DeleteAccount == nil {
		return nil, false
	}
	return o.DeleteAccount, true
}

// HasDeleteAccount returns a boolean if a field has been set.
func (o *DeactivateAcmeAccount) HasDeleteAccount() bool {
	if o != nil && o.DeleteAccount != nil {
		return true
	}

	return false
}

// SetDeleteAccount gets a reference to the given bool and assigns it to the DeleteAccount field.
func (o *DeactivateAcmeAccount) SetDeleteAccount(v bool) {
	o.DeleteAccount = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DeactivateAcmeAccount) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeactivateAcmeAccount) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DeactivateAcmeAccount) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DeactivateAcmeAccount) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DeactivateAcmeAccount) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeactivateAcmeAccount) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DeactivateAcmeAccount) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DeactivateAcmeAccount) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DeactivateAcmeAccount) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeactivateAcmeAccount) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DeactivateAcmeAccount) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DeactivateAcmeAccount) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DeactivateAcmeAccount) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["acme-account-id"] = o.AcmeAccountId
	}
	if true {
		toSerialize["cert-issuer-name"] = o.CertIssuerName
	}
	if o.DeleteAccount != nil {
		toSerialize["delete-account"] = o.DeleteAccount
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDeactivateAcmeAccount struct {
	value *DeactivateAcmeAccount
	isSet bool
}

func (v NullableDeactivateAcmeAccount) Get() *DeactivateAcmeAccount {
	return v.value
}

func (v *NullableDeactivateAcmeAccount) Set(val *DeactivateAcmeAccount) {
	v.value = val
	v.isSet = true
}

func (v NullableDeactivateAcmeAccount) IsSet() bool {
	return v.isSet
}

func (v *NullableDeactivateAcmeAccount) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeactivateAcmeAccount(val *DeactivateAcmeAccount) *NullableDeactivateAcmeAccount {
	return &NullableDeactivateAcmeAccount{value: val, isSet: true}
}

func (v NullableDeactivateAcmeAccount) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeactivateAcmeAccount) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


