/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateRotatedSecret createRotatedSecret is a command that creates a rotated secret [Deprecated: Use rotated-secret-create commands]
type CreateRotatedSecret struct {
	ProviderType *string `json:"ProviderType,omitempty"`
	// API ID to rotate (relevant only for rotator-type=api-key)
	ApiId *string `json:"api-id,omitempty"`
	// API key to rotate (relevant only for rotator-type=api-key)
	ApiKey *string `json:"api-key,omitempty"`
	// ApplicationId (used in azure)
	ApplicationId *string `json:"application-id,omitempty"`
	// The credentials to connect with use-user-creds/use-target-creds
	AuthenticationCredentials *string `json:"authentication-credentials,omitempty"`
	// Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation [true/false]
	AutoRotate *string `json:"auto-rotate,omitempty"`
	// Aws Region (relevant only for aws)
	AwsRegion *string `json:"aws-region,omitempty"`
	// Secret payload to be sent with rotation request (relevant only for rotator-type=custom)
	CustomPayload *string `json:"custom-payload,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Base64-encoded service account private key text
	GcpKey *string `json:"gcp-key,omitempty"`
	// The email of the gcp service account to rotate
	GcpServiceAccountEmail *string `json:"gcp-service-account-email,omitempty"`
	// The key id of the gcp service account to rotate
	GcpServiceAccountKeyId *string `json:"gcp-service-account-key-id,omitempty"`
	// Create a new access key without deleting the old key from AWS for backup (relevant only for AWS) [true/false]
	GraceRotation *string `json:"grace-rotation,omitempty"`
	// Host provider type [explicit/target], Default Host provider is explicit, Relevant only for Secure Remote Access of ssh cert issuer, ldap rotated secret and ldap dynamic secret
	HostProvider *string `json:"host-provider,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Deprecated - use description
	Metadata *string `json:"metadata,omitempty"`
	// Secret name
	Name string `json:"name"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// Rotate the value of the secret after SRA session ends [true/false]
	RotateAfterDisconnect *string `json:"rotate-after-disconnect,omitempty"`
	// rotated-username password (relevant only for rotator-type=password)
	RotatedPassword *string `json:"rotated-password,omitempty"`
	// username to be rotated, if selected use-self-creds at rotator-creds-type, this username will try to rotate it's own password, if use-target-creds is selected, target credentials will be use to rotate the rotated-password (relevant only for rotator-type=password)
	RotatedUsername *string `json:"rotated-username,omitempty"`
	// The Hour of the rotation in UTC. Default rotation-hour is 14:00
	RotationHour *int32 `json:"rotation-hour,omitempty"`
	// The number of days to wait between every automatic key rotation (1-365)
	RotationInterval *string `json:"rotation-interval,omitempty"`
	RotatorCredsType *string `json:"rotator-creds-type,omitempty"`
	// Custom rotation command (relevant only for ssh target)
	RotatorCustomCmd *string `json:"rotator-custom-cmd,omitempty"`
	// Rotator Type
	RotatorType string `json:"rotator-type"`
	// Rotate same password for each host from the Linked Target (relevant only for Linked Target)
	SamePassword *string `json:"same-password,omitempty"`
	// Allow providing external user for a domain users (relevant only for rdp)
	SecureAccessAllowExternalUser *bool `json:"secure-access-allow-external-user,omitempty"`
	// The AWS account id (relevant only for aws)
	SecureAccessAwsAccountId *string `json:"secure-access-aws-account-id,omitempty"`
	// The AWS native cli
	SecureAccessAwsNativeCli *bool `json:"secure-access-aws-native-cli,omitempty"`
	// Path to the SSH Certificate Issuer for your Akeyless Bastion
	SecureAccessBastionIssuer *string `json:"secure-access-bastion-issuer,omitempty"`
	// The DB name (relevant only for DB Dynamic-Secret)
	SecureAccessDbName *string `json:"secure-access-db-name,omitempty"`
	// The db schema (relevant only for mssql or postgresql)
	SecureAccessDbSchema *string `json:"secure-access-db-schema,omitempty"`
	// Enable this flag to prevent simultaneous use of the same secret
	SecureAccessDisableConcurrentConnections *bool `json:"secure-access-disable-concurrent-connections,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Target servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts - Relevant only for Dynamic Secrets/producers)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// Required when the Dynamic Secret is used for a domain user (relevant only for RDP Dynamic-Secret)
	SecureAccessRdpDomain *string `json:"secure-access-rdp-domain,omitempty"`
	// Override the RDP Domain username (relevant only for rdp)
	SecureAccessRdpUser *string `json:"secure-access-rdp-user,omitempty"`
	// Destination URL to inject secrets
	SecureAccessUrl *string `json:"secure-access-url,omitempty"`
	// Enable Web Secure Remote Access
	SecureAccessWeb *bool `json:"secure-access-web,omitempty"`
	// Secure browser via Akeyless Web Access Bastion (relevant only for aws or azure)
	SecureAccessWebBrowsing *bool `json:"secure-access-web-browsing,omitempty"`
	// Web-Proxy via Akeyless Web Access Bastion (relevant only for aws or azure)
	SecureAccessWebProxy *bool `json:"secure-access-web-proxy,omitempty"`
	// Deprecated: use RotatedPassword
	SshPassword *string `json:"ssh-password,omitempty"`
	// Deprecated: use RotatedUser
	SshUsername *string `json:"ssh-username,omitempty"`
	// The name of the storage account key to rotate [key1/key2/kerb1/kerb2] (relevat to azure-storage-account)
	StorageAccountKeyName *string `json:"storage-account-key-name,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// A list of linked targets to be associated, Relevant only for Secure Remote Access for ssh cert issuer, ldap rotated secret and ldap dynamic secret, To specify multiple targets use argument multiple times
	Target *[]string `json:"target,omitempty"`
	// Target name
	TargetName string `json:"target-name"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// LDAP User Attribute, Default value \"cn\"
	UserAttribute *string `json:"user-attribute,omitempty"`
	// LDAP User Base DN
	UserDn *string `json:"user-dn,omitempty"`
}

// NewCreateRotatedSecret instantiates a new CreateRotatedSecret object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateRotatedSecret(name string, rotatorType string, targetName string, ) *CreateRotatedSecret {
	this := CreateRotatedSecret{}
	var authenticationCredentials string = "use-user-creds"
	this.AuthenticationCredentials = &authenticationCredentials
	var awsRegion string = "us-east-2"
	this.AwsRegion = &awsRegion
	var json bool = false
	this.Json = &json
	this.Name = name
	var rotateAfterDisconnect string = "false"
	this.RotateAfterDisconnect = &rotateAfterDisconnect
	this.RotatorType = rotatorType
	var secureAccessAllowExternalUser bool = false
	this.SecureAccessAllowExternalUser = &secureAccessAllowExternalUser
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var secureAccessWebBrowsing bool = false
	this.SecureAccessWebBrowsing = &secureAccessWebBrowsing
	var secureAccessWebProxy bool = false
	this.SecureAccessWebProxy = &secureAccessWebProxy
	this.TargetName = targetName
	var userAttribute string = "cn"
	this.UserAttribute = &userAttribute
	return &this
}

// NewCreateRotatedSecretWithDefaults instantiates a new CreateRotatedSecret object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateRotatedSecretWithDefaults() *CreateRotatedSecret {
	this := CreateRotatedSecret{}
	var authenticationCredentials string = "use-user-creds"
	this.AuthenticationCredentials = &authenticationCredentials
	var awsRegion string = "us-east-2"
	this.AwsRegion = &awsRegion
	var json bool = false
	this.Json = &json
	var rotateAfterDisconnect string = "false"
	this.RotateAfterDisconnect = &rotateAfterDisconnect
	var secureAccessAllowExternalUser bool = false
	this.SecureAccessAllowExternalUser = &secureAccessAllowExternalUser
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var secureAccessWebBrowsing bool = false
	this.SecureAccessWebBrowsing = &secureAccessWebBrowsing
	var secureAccessWebProxy bool = false
	this.SecureAccessWebProxy = &secureAccessWebProxy
	var userAttribute string = "cn"
	this.UserAttribute = &userAttribute
	return &this
}

// GetProviderType returns the ProviderType field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetProviderType() string {
	if o == nil || o.ProviderType == nil {
		var ret string
		return ret
	}
	return *o.ProviderType
}

// GetProviderTypeOk returns a tuple with the ProviderType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetProviderTypeOk() (*string, bool) {
	if o == nil || o.ProviderType == nil {
		return nil, false
	}
	return o.ProviderType, true
}

// HasProviderType returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasProviderType() bool {
	if o != nil && o.ProviderType != nil {
		return true
	}

	return false
}

// SetProviderType gets a reference to the given string and assigns it to the ProviderType field.
func (o *CreateRotatedSecret) SetProviderType(v string) {
	o.ProviderType = &v
}

// GetApiId returns the ApiId field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetApiId() string {
	if o == nil || o.ApiId == nil {
		var ret string
		return ret
	}
	return *o.ApiId
}

// GetApiIdOk returns a tuple with the ApiId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetApiIdOk() (*string, bool) {
	if o == nil || o.ApiId == nil {
		return nil, false
	}
	return o.ApiId, true
}

// HasApiId returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasApiId() bool {
	if o != nil && o.ApiId != nil {
		return true
	}

	return false
}

// SetApiId gets a reference to the given string and assigns it to the ApiId field.
func (o *CreateRotatedSecret) SetApiId(v string) {
	o.ApiId = &v
}

// GetApiKey returns the ApiKey field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetApiKey() string {
	if o == nil || o.ApiKey == nil {
		var ret string
		return ret
	}
	return *o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetApiKeyOk() (*string, bool) {
	if o == nil || o.ApiKey == nil {
		return nil, false
	}
	return o.ApiKey, true
}

// HasApiKey returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasApiKey() bool {
	if o != nil && o.ApiKey != nil {
		return true
	}

	return false
}

// SetApiKey gets a reference to the given string and assigns it to the ApiKey field.
func (o *CreateRotatedSecret) SetApiKey(v string) {
	o.ApiKey = &v
}

// GetApplicationId returns the ApplicationId field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetApplicationId() string {
	if o == nil || o.ApplicationId == nil {
		var ret string
		return ret
	}
	return *o.ApplicationId
}

// GetApplicationIdOk returns a tuple with the ApplicationId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetApplicationIdOk() (*string, bool) {
	if o == nil || o.ApplicationId == nil {
		return nil, false
	}
	return o.ApplicationId, true
}

// HasApplicationId returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasApplicationId() bool {
	if o != nil && o.ApplicationId != nil {
		return true
	}

	return false
}

// SetApplicationId gets a reference to the given string and assigns it to the ApplicationId field.
func (o *CreateRotatedSecret) SetApplicationId(v string) {
	o.ApplicationId = &v
}

// GetAuthenticationCredentials returns the AuthenticationCredentials field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetAuthenticationCredentials() string {
	if o == nil || o.AuthenticationCredentials == nil {
		var ret string
		return ret
	}
	return *o.AuthenticationCredentials
}

// GetAuthenticationCredentialsOk returns a tuple with the AuthenticationCredentials field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetAuthenticationCredentialsOk() (*string, bool) {
	if o == nil || o.AuthenticationCredentials == nil {
		return nil, false
	}
	return o.AuthenticationCredentials, true
}

// HasAuthenticationCredentials returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasAuthenticationCredentials() bool {
	if o != nil && o.AuthenticationCredentials != nil {
		return true
	}

	return false
}

// SetAuthenticationCredentials gets a reference to the given string and assigns it to the AuthenticationCredentials field.
func (o *CreateRotatedSecret) SetAuthenticationCredentials(v string) {
	o.AuthenticationCredentials = &v
}

// GetAutoRotate returns the AutoRotate field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetAutoRotate() string {
	if o == nil || o.AutoRotate == nil {
		var ret string
		return ret
	}
	return *o.AutoRotate
}

// GetAutoRotateOk returns a tuple with the AutoRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetAutoRotateOk() (*string, bool) {
	if o == nil || o.AutoRotate == nil {
		return nil, false
	}
	return o.AutoRotate, true
}

// HasAutoRotate returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasAutoRotate() bool {
	if o != nil && o.AutoRotate != nil {
		return true
	}

	return false
}

// SetAutoRotate gets a reference to the given string and assigns it to the AutoRotate field.
func (o *CreateRotatedSecret) SetAutoRotate(v string) {
	o.AutoRotate = &v
}

// GetAwsRegion returns the AwsRegion field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetAwsRegion() string {
	if o == nil || o.AwsRegion == nil {
		var ret string
		return ret
	}
	return *o.AwsRegion
}

// GetAwsRegionOk returns a tuple with the AwsRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetAwsRegionOk() (*string, bool) {
	if o == nil || o.AwsRegion == nil {
		return nil, false
	}
	return o.AwsRegion, true
}

// HasAwsRegion returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasAwsRegion() bool {
	if o != nil && o.AwsRegion != nil {
		return true
	}

	return false
}

// SetAwsRegion gets a reference to the given string and assigns it to the AwsRegion field.
func (o *CreateRotatedSecret) SetAwsRegion(v string) {
	o.AwsRegion = &v
}

// GetCustomPayload returns the CustomPayload field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetCustomPayload() string {
	if o == nil || o.CustomPayload == nil {
		var ret string
		return ret
	}
	return *o.CustomPayload
}

// GetCustomPayloadOk returns a tuple with the CustomPayload field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetCustomPayloadOk() (*string, bool) {
	if o == nil || o.CustomPayload == nil {
		return nil, false
	}
	return o.CustomPayload, true
}

// HasCustomPayload returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasCustomPayload() bool {
	if o != nil && o.CustomPayload != nil {
		return true
	}

	return false
}

// SetCustomPayload gets a reference to the given string and assigns it to the CustomPayload field.
func (o *CreateRotatedSecret) SetCustomPayload(v string) {
	o.CustomPayload = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *CreateRotatedSecret) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateRotatedSecret) SetDescription(v string) {
	o.Description = &v
}

// GetGcpKey returns the GcpKey field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetGcpKey() string {
	if o == nil || o.GcpKey == nil {
		var ret string
		return ret
	}
	return *o.GcpKey
}

// GetGcpKeyOk returns a tuple with the GcpKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetGcpKeyOk() (*string, bool) {
	if o == nil || o.GcpKey == nil {
		return nil, false
	}
	return o.GcpKey, true
}

// HasGcpKey returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasGcpKey() bool {
	if o != nil && o.GcpKey != nil {
		return true
	}

	return false
}

// SetGcpKey gets a reference to the given string and assigns it to the GcpKey field.
func (o *CreateRotatedSecret) SetGcpKey(v string) {
	o.GcpKey = &v
}

// GetGcpServiceAccountEmail returns the GcpServiceAccountEmail field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetGcpServiceAccountEmail() string {
	if o == nil || o.GcpServiceAccountEmail == nil {
		var ret string
		return ret
	}
	return *o.GcpServiceAccountEmail
}

// GetGcpServiceAccountEmailOk returns a tuple with the GcpServiceAccountEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetGcpServiceAccountEmailOk() (*string, bool) {
	if o == nil || o.GcpServiceAccountEmail == nil {
		return nil, false
	}
	return o.GcpServiceAccountEmail, true
}

// HasGcpServiceAccountEmail returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasGcpServiceAccountEmail() bool {
	if o != nil && o.GcpServiceAccountEmail != nil {
		return true
	}

	return false
}

// SetGcpServiceAccountEmail gets a reference to the given string and assigns it to the GcpServiceAccountEmail field.
func (o *CreateRotatedSecret) SetGcpServiceAccountEmail(v string) {
	o.GcpServiceAccountEmail = &v
}

// GetGcpServiceAccountKeyId returns the GcpServiceAccountKeyId field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetGcpServiceAccountKeyId() string {
	if o == nil || o.GcpServiceAccountKeyId == nil {
		var ret string
		return ret
	}
	return *o.GcpServiceAccountKeyId
}

// GetGcpServiceAccountKeyIdOk returns a tuple with the GcpServiceAccountKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetGcpServiceAccountKeyIdOk() (*string, bool) {
	if o == nil || o.GcpServiceAccountKeyId == nil {
		return nil, false
	}
	return o.GcpServiceAccountKeyId, true
}

// HasGcpServiceAccountKeyId returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasGcpServiceAccountKeyId() bool {
	if o != nil && o.GcpServiceAccountKeyId != nil {
		return true
	}

	return false
}

// SetGcpServiceAccountKeyId gets a reference to the given string and assigns it to the GcpServiceAccountKeyId field.
func (o *CreateRotatedSecret) SetGcpServiceAccountKeyId(v string) {
	o.GcpServiceAccountKeyId = &v
}

// GetGraceRotation returns the GraceRotation field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetGraceRotation() string {
	if o == nil || o.GraceRotation == nil {
		var ret string
		return ret
	}
	return *o.GraceRotation
}

// GetGraceRotationOk returns a tuple with the GraceRotation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetGraceRotationOk() (*string, bool) {
	if o == nil || o.GraceRotation == nil {
		return nil, false
	}
	return o.GraceRotation, true
}

// HasGraceRotation returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasGraceRotation() bool {
	if o != nil && o.GraceRotation != nil {
		return true
	}

	return false
}

// SetGraceRotation gets a reference to the given string and assigns it to the GraceRotation field.
func (o *CreateRotatedSecret) SetGraceRotation(v string) {
	o.GraceRotation = &v
}

// GetHostProvider returns the HostProvider field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetHostProvider() string {
	if o == nil || o.HostProvider == nil {
		var ret string
		return ret
	}
	return *o.HostProvider
}

// GetHostProviderOk returns a tuple with the HostProvider field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetHostProviderOk() (*string, bool) {
	if o == nil || o.HostProvider == nil {
		return nil, false
	}
	return o.HostProvider, true
}

// HasHostProvider returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasHostProvider() bool {
	if o != nil && o.HostProvider != nil {
		return true
	}

	return false
}

// SetHostProvider gets a reference to the given string and assigns it to the HostProvider field.
func (o *CreateRotatedSecret) SetHostProvider(v string) {
	o.HostProvider = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateRotatedSecret) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *CreateRotatedSecret) SetKey(v string) {
	o.Key = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetMetadata() string {
	if o == nil || o.Metadata == nil {
		var ret string
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetMetadataOk() (*string, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given string and assigns it to the Metadata field.
func (o *CreateRotatedSecret) SetMetadata(v string) {
	o.Metadata = &v
}

// GetName returns the Name field value
func (o *CreateRotatedSecret) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateRotatedSecret) SetName(v string) {
	o.Name = v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *CreateRotatedSecret) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetRotateAfterDisconnect returns the RotateAfterDisconnect field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetRotateAfterDisconnect() string {
	if o == nil || o.RotateAfterDisconnect == nil {
		var ret string
		return ret
	}
	return *o.RotateAfterDisconnect
}

// GetRotateAfterDisconnectOk returns a tuple with the RotateAfterDisconnect field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotateAfterDisconnectOk() (*string, bool) {
	if o == nil || o.RotateAfterDisconnect == nil {
		return nil, false
	}
	return o.RotateAfterDisconnect, true
}

// HasRotateAfterDisconnect returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasRotateAfterDisconnect() bool {
	if o != nil && o.RotateAfterDisconnect != nil {
		return true
	}

	return false
}

// SetRotateAfterDisconnect gets a reference to the given string and assigns it to the RotateAfterDisconnect field.
func (o *CreateRotatedSecret) SetRotateAfterDisconnect(v string) {
	o.RotateAfterDisconnect = &v
}

// GetRotatedPassword returns the RotatedPassword field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetRotatedPassword() string {
	if o == nil || o.RotatedPassword == nil {
		var ret string
		return ret
	}
	return *o.RotatedPassword
}

// GetRotatedPasswordOk returns a tuple with the RotatedPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotatedPasswordOk() (*string, bool) {
	if o == nil || o.RotatedPassword == nil {
		return nil, false
	}
	return o.RotatedPassword, true
}

// HasRotatedPassword returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasRotatedPassword() bool {
	if o != nil && o.RotatedPassword != nil {
		return true
	}

	return false
}

// SetRotatedPassword gets a reference to the given string and assigns it to the RotatedPassword field.
func (o *CreateRotatedSecret) SetRotatedPassword(v string) {
	o.RotatedPassword = &v
}

// GetRotatedUsername returns the RotatedUsername field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetRotatedUsername() string {
	if o == nil || o.RotatedUsername == nil {
		var ret string
		return ret
	}
	return *o.RotatedUsername
}

// GetRotatedUsernameOk returns a tuple with the RotatedUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotatedUsernameOk() (*string, bool) {
	if o == nil || o.RotatedUsername == nil {
		return nil, false
	}
	return o.RotatedUsername, true
}

// HasRotatedUsername returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasRotatedUsername() bool {
	if o != nil && o.RotatedUsername != nil {
		return true
	}

	return false
}

// SetRotatedUsername gets a reference to the given string and assigns it to the RotatedUsername field.
func (o *CreateRotatedSecret) SetRotatedUsername(v string) {
	o.RotatedUsername = &v
}

// GetRotationHour returns the RotationHour field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetRotationHour() int32 {
	if o == nil || o.RotationHour == nil {
		var ret int32
		return ret
	}
	return *o.RotationHour
}

// GetRotationHourOk returns a tuple with the RotationHour field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotationHourOk() (*int32, bool) {
	if o == nil || o.RotationHour == nil {
		return nil, false
	}
	return o.RotationHour, true
}

// HasRotationHour returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasRotationHour() bool {
	if o != nil && o.RotationHour != nil {
		return true
	}

	return false
}

// SetRotationHour gets a reference to the given int32 and assigns it to the RotationHour field.
func (o *CreateRotatedSecret) SetRotationHour(v int32) {
	o.RotationHour = &v
}

// GetRotationInterval returns the RotationInterval field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetRotationInterval() string {
	if o == nil || o.RotationInterval == nil {
		var ret string
		return ret
	}
	return *o.RotationInterval
}

// GetRotationIntervalOk returns a tuple with the RotationInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotationIntervalOk() (*string, bool) {
	if o == nil || o.RotationInterval == nil {
		return nil, false
	}
	return o.RotationInterval, true
}

// HasRotationInterval returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasRotationInterval() bool {
	if o != nil && o.RotationInterval != nil {
		return true
	}

	return false
}

// SetRotationInterval gets a reference to the given string and assigns it to the RotationInterval field.
func (o *CreateRotatedSecret) SetRotationInterval(v string) {
	o.RotationInterval = &v
}

// GetRotatorCredsType returns the RotatorCredsType field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetRotatorCredsType() string {
	if o == nil || o.RotatorCredsType == nil {
		var ret string
		return ret
	}
	return *o.RotatorCredsType
}

// GetRotatorCredsTypeOk returns a tuple with the RotatorCredsType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotatorCredsTypeOk() (*string, bool) {
	if o == nil || o.RotatorCredsType == nil {
		return nil, false
	}
	return o.RotatorCredsType, true
}

// HasRotatorCredsType returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasRotatorCredsType() bool {
	if o != nil && o.RotatorCredsType != nil {
		return true
	}

	return false
}

// SetRotatorCredsType gets a reference to the given string and assigns it to the RotatorCredsType field.
func (o *CreateRotatedSecret) SetRotatorCredsType(v string) {
	o.RotatorCredsType = &v
}

// GetRotatorCustomCmd returns the RotatorCustomCmd field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetRotatorCustomCmd() string {
	if o == nil || o.RotatorCustomCmd == nil {
		var ret string
		return ret
	}
	return *o.RotatorCustomCmd
}

// GetRotatorCustomCmdOk returns a tuple with the RotatorCustomCmd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotatorCustomCmdOk() (*string, bool) {
	if o == nil || o.RotatorCustomCmd == nil {
		return nil, false
	}
	return o.RotatorCustomCmd, true
}

// HasRotatorCustomCmd returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasRotatorCustomCmd() bool {
	if o != nil && o.RotatorCustomCmd != nil {
		return true
	}

	return false
}

// SetRotatorCustomCmd gets a reference to the given string and assigns it to the RotatorCustomCmd field.
func (o *CreateRotatedSecret) SetRotatorCustomCmd(v string) {
	o.RotatorCustomCmd = &v
}

// GetRotatorType returns the RotatorType field value
func (o *CreateRotatedSecret) GetRotatorType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.RotatorType
}

// GetRotatorTypeOk returns a tuple with the RotatorType field value
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetRotatorTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.RotatorType, true
}

// SetRotatorType sets field value
func (o *CreateRotatedSecret) SetRotatorType(v string) {
	o.RotatorType = v
}

// GetSamePassword returns the SamePassword field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSamePassword() string {
	if o == nil || o.SamePassword == nil {
		var ret string
		return ret
	}
	return *o.SamePassword
}

// GetSamePasswordOk returns a tuple with the SamePassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSamePasswordOk() (*string, bool) {
	if o == nil || o.SamePassword == nil {
		return nil, false
	}
	return o.SamePassword, true
}

// HasSamePassword returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSamePassword() bool {
	if o != nil && o.SamePassword != nil {
		return true
	}

	return false
}

// SetSamePassword gets a reference to the given string and assigns it to the SamePassword field.
func (o *CreateRotatedSecret) SetSamePassword(v string) {
	o.SamePassword = &v
}

// GetSecureAccessAllowExternalUser returns the SecureAccessAllowExternalUser field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessAllowExternalUser() bool {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessAllowExternalUser
}

// GetSecureAccessAllowExternalUserOk returns a tuple with the SecureAccessAllowExternalUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessAllowExternalUserOk() (*bool, bool) {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		return nil, false
	}
	return o.SecureAccessAllowExternalUser, true
}

// HasSecureAccessAllowExternalUser returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessAllowExternalUser() bool {
	if o != nil && o.SecureAccessAllowExternalUser != nil {
		return true
	}

	return false
}

// SetSecureAccessAllowExternalUser gets a reference to the given bool and assigns it to the SecureAccessAllowExternalUser field.
func (o *CreateRotatedSecret) SetSecureAccessAllowExternalUser(v bool) {
	o.SecureAccessAllowExternalUser = &v
}

// GetSecureAccessAwsAccountId returns the SecureAccessAwsAccountId field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessAwsAccountId() string {
	if o == nil || o.SecureAccessAwsAccountId == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessAwsAccountId
}

// GetSecureAccessAwsAccountIdOk returns a tuple with the SecureAccessAwsAccountId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessAwsAccountIdOk() (*string, bool) {
	if o == nil || o.SecureAccessAwsAccountId == nil {
		return nil, false
	}
	return o.SecureAccessAwsAccountId, true
}

// HasSecureAccessAwsAccountId returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessAwsAccountId() bool {
	if o != nil && o.SecureAccessAwsAccountId != nil {
		return true
	}

	return false
}

// SetSecureAccessAwsAccountId gets a reference to the given string and assigns it to the SecureAccessAwsAccountId field.
func (o *CreateRotatedSecret) SetSecureAccessAwsAccountId(v string) {
	o.SecureAccessAwsAccountId = &v
}

// GetSecureAccessAwsNativeCli returns the SecureAccessAwsNativeCli field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessAwsNativeCli() bool {
	if o == nil || o.SecureAccessAwsNativeCli == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessAwsNativeCli
}

// GetSecureAccessAwsNativeCliOk returns a tuple with the SecureAccessAwsNativeCli field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessAwsNativeCliOk() (*bool, bool) {
	if o == nil || o.SecureAccessAwsNativeCli == nil {
		return nil, false
	}
	return o.SecureAccessAwsNativeCli, true
}

// HasSecureAccessAwsNativeCli returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessAwsNativeCli() bool {
	if o != nil && o.SecureAccessAwsNativeCli != nil {
		return true
	}

	return false
}

// SetSecureAccessAwsNativeCli gets a reference to the given bool and assigns it to the SecureAccessAwsNativeCli field.
func (o *CreateRotatedSecret) SetSecureAccessAwsNativeCli(v bool) {
	o.SecureAccessAwsNativeCli = &v
}

// GetSecureAccessBastionIssuer returns the SecureAccessBastionIssuer field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessBastionIssuer() string {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionIssuer
}

// GetSecureAccessBastionIssuerOk returns a tuple with the SecureAccessBastionIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessBastionIssuerOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		return nil, false
	}
	return o.SecureAccessBastionIssuer, true
}

// HasSecureAccessBastionIssuer returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessBastionIssuer() bool {
	if o != nil && o.SecureAccessBastionIssuer != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionIssuer gets a reference to the given string and assigns it to the SecureAccessBastionIssuer field.
func (o *CreateRotatedSecret) SetSecureAccessBastionIssuer(v string) {
	o.SecureAccessBastionIssuer = &v
}

// GetSecureAccessDbName returns the SecureAccessDbName field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessDbName() string {
	if o == nil || o.SecureAccessDbName == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessDbName
}

// GetSecureAccessDbNameOk returns a tuple with the SecureAccessDbName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessDbNameOk() (*string, bool) {
	if o == nil || o.SecureAccessDbName == nil {
		return nil, false
	}
	return o.SecureAccessDbName, true
}

// HasSecureAccessDbName returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessDbName() bool {
	if o != nil && o.SecureAccessDbName != nil {
		return true
	}

	return false
}

// SetSecureAccessDbName gets a reference to the given string and assigns it to the SecureAccessDbName field.
func (o *CreateRotatedSecret) SetSecureAccessDbName(v string) {
	o.SecureAccessDbName = &v
}

// GetSecureAccessDbSchema returns the SecureAccessDbSchema field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessDbSchema() string {
	if o == nil || o.SecureAccessDbSchema == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessDbSchema
}

// GetSecureAccessDbSchemaOk returns a tuple with the SecureAccessDbSchema field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessDbSchemaOk() (*string, bool) {
	if o == nil || o.SecureAccessDbSchema == nil {
		return nil, false
	}
	return o.SecureAccessDbSchema, true
}

// HasSecureAccessDbSchema returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessDbSchema() bool {
	if o != nil && o.SecureAccessDbSchema != nil {
		return true
	}

	return false
}

// SetSecureAccessDbSchema gets a reference to the given string and assigns it to the SecureAccessDbSchema field.
func (o *CreateRotatedSecret) SetSecureAccessDbSchema(v string) {
	o.SecureAccessDbSchema = &v
}

// GetSecureAccessDisableConcurrentConnections returns the SecureAccessDisableConcurrentConnections field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessDisableConcurrentConnections() bool {
	if o == nil || o.SecureAccessDisableConcurrentConnections == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessDisableConcurrentConnections
}

// GetSecureAccessDisableConcurrentConnectionsOk returns a tuple with the SecureAccessDisableConcurrentConnections field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessDisableConcurrentConnectionsOk() (*bool, bool) {
	if o == nil || o.SecureAccessDisableConcurrentConnections == nil {
		return nil, false
	}
	return o.SecureAccessDisableConcurrentConnections, true
}

// HasSecureAccessDisableConcurrentConnections returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessDisableConcurrentConnections() bool {
	if o != nil && o.SecureAccessDisableConcurrentConnections != nil {
		return true
	}

	return false
}

// SetSecureAccessDisableConcurrentConnections gets a reference to the given bool and assigns it to the SecureAccessDisableConcurrentConnections field.
func (o *CreateRotatedSecret) SetSecureAccessDisableConcurrentConnections(v bool) {
	o.SecureAccessDisableConcurrentConnections = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *CreateRotatedSecret) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *CreateRotatedSecret) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessRdpDomain returns the SecureAccessRdpDomain field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessRdpDomain() string {
	if o == nil || o.SecureAccessRdpDomain == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpDomain
}

// GetSecureAccessRdpDomainOk returns a tuple with the SecureAccessRdpDomain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessRdpDomainOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpDomain == nil {
		return nil, false
	}
	return o.SecureAccessRdpDomain, true
}

// HasSecureAccessRdpDomain returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessRdpDomain() bool {
	if o != nil && o.SecureAccessRdpDomain != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpDomain gets a reference to the given string and assigns it to the SecureAccessRdpDomain field.
func (o *CreateRotatedSecret) SetSecureAccessRdpDomain(v string) {
	o.SecureAccessRdpDomain = &v
}

// GetSecureAccessRdpUser returns the SecureAccessRdpUser field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessRdpUser() string {
	if o == nil || o.SecureAccessRdpUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpUser
}

// GetSecureAccessRdpUserOk returns a tuple with the SecureAccessRdpUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessRdpUserOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpUser == nil {
		return nil, false
	}
	return o.SecureAccessRdpUser, true
}

// HasSecureAccessRdpUser returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessRdpUser() bool {
	if o != nil && o.SecureAccessRdpUser != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpUser gets a reference to the given string and assigns it to the SecureAccessRdpUser field.
func (o *CreateRotatedSecret) SetSecureAccessRdpUser(v string) {
	o.SecureAccessRdpUser = &v
}

// GetSecureAccessUrl returns the SecureAccessUrl field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessUrl() string {
	if o == nil || o.SecureAccessUrl == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessUrl
}

// GetSecureAccessUrlOk returns a tuple with the SecureAccessUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessUrlOk() (*string, bool) {
	if o == nil || o.SecureAccessUrl == nil {
		return nil, false
	}
	return o.SecureAccessUrl, true
}

// HasSecureAccessUrl returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessUrl() bool {
	if o != nil && o.SecureAccessUrl != nil {
		return true
	}

	return false
}

// SetSecureAccessUrl gets a reference to the given string and assigns it to the SecureAccessUrl field.
func (o *CreateRotatedSecret) SetSecureAccessUrl(v string) {
	o.SecureAccessUrl = &v
}

// GetSecureAccessWeb returns the SecureAccessWeb field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessWeb() bool {
	if o == nil || o.SecureAccessWeb == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWeb
}

// GetSecureAccessWebOk returns a tuple with the SecureAccessWeb field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessWebOk() (*bool, bool) {
	if o == nil || o.SecureAccessWeb == nil {
		return nil, false
	}
	return o.SecureAccessWeb, true
}

// HasSecureAccessWeb returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessWeb() bool {
	if o != nil && o.SecureAccessWeb != nil {
		return true
	}

	return false
}

// SetSecureAccessWeb gets a reference to the given bool and assigns it to the SecureAccessWeb field.
func (o *CreateRotatedSecret) SetSecureAccessWeb(v bool) {
	o.SecureAccessWeb = &v
}

// GetSecureAccessWebBrowsing returns the SecureAccessWebBrowsing field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessWebBrowsing() bool {
	if o == nil || o.SecureAccessWebBrowsing == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWebBrowsing
}

// GetSecureAccessWebBrowsingOk returns a tuple with the SecureAccessWebBrowsing field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessWebBrowsingOk() (*bool, bool) {
	if o == nil || o.SecureAccessWebBrowsing == nil {
		return nil, false
	}
	return o.SecureAccessWebBrowsing, true
}

// HasSecureAccessWebBrowsing returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessWebBrowsing() bool {
	if o != nil && o.SecureAccessWebBrowsing != nil {
		return true
	}

	return false
}

// SetSecureAccessWebBrowsing gets a reference to the given bool and assigns it to the SecureAccessWebBrowsing field.
func (o *CreateRotatedSecret) SetSecureAccessWebBrowsing(v bool) {
	o.SecureAccessWebBrowsing = &v
}

// GetSecureAccessWebProxy returns the SecureAccessWebProxy field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSecureAccessWebProxy() bool {
	if o == nil || o.SecureAccessWebProxy == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWebProxy
}

// GetSecureAccessWebProxyOk returns a tuple with the SecureAccessWebProxy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSecureAccessWebProxyOk() (*bool, bool) {
	if o == nil || o.SecureAccessWebProxy == nil {
		return nil, false
	}
	return o.SecureAccessWebProxy, true
}

// HasSecureAccessWebProxy returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSecureAccessWebProxy() bool {
	if o != nil && o.SecureAccessWebProxy != nil {
		return true
	}

	return false
}

// SetSecureAccessWebProxy gets a reference to the given bool and assigns it to the SecureAccessWebProxy field.
func (o *CreateRotatedSecret) SetSecureAccessWebProxy(v bool) {
	o.SecureAccessWebProxy = &v
}

// GetSshPassword returns the SshPassword field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSshPassword() string {
	if o == nil || o.SshPassword == nil {
		var ret string
		return ret
	}
	return *o.SshPassword
}

// GetSshPasswordOk returns a tuple with the SshPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSshPasswordOk() (*string, bool) {
	if o == nil || o.SshPassword == nil {
		return nil, false
	}
	return o.SshPassword, true
}

// HasSshPassword returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSshPassword() bool {
	if o != nil && o.SshPassword != nil {
		return true
	}

	return false
}

// SetSshPassword gets a reference to the given string and assigns it to the SshPassword field.
func (o *CreateRotatedSecret) SetSshPassword(v string) {
	o.SshPassword = &v
}

// GetSshUsername returns the SshUsername field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetSshUsername() string {
	if o == nil || o.SshUsername == nil {
		var ret string
		return ret
	}
	return *o.SshUsername
}

// GetSshUsernameOk returns a tuple with the SshUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetSshUsernameOk() (*string, bool) {
	if o == nil || o.SshUsername == nil {
		return nil, false
	}
	return o.SshUsername, true
}

// HasSshUsername returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasSshUsername() bool {
	if o != nil && o.SshUsername != nil {
		return true
	}

	return false
}

// SetSshUsername gets a reference to the given string and assigns it to the SshUsername field.
func (o *CreateRotatedSecret) SetSshUsername(v string) {
	o.SshUsername = &v
}

// GetStorageAccountKeyName returns the StorageAccountKeyName field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetStorageAccountKeyName() string {
	if o == nil || o.StorageAccountKeyName == nil {
		var ret string
		return ret
	}
	return *o.StorageAccountKeyName
}

// GetStorageAccountKeyNameOk returns a tuple with the StorageAccountKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetStorageAccountKeyNameOk() (*string, bool) {
	if o == nil || o.StorageAccountKeyName == nil {
		return nil, false
	}
	return o.StorageAccountKeyName, true
}

// HasStorageAccountKeyName returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasStorageAccountKeyName() bool {
	if o != nil && o.StorageAccountKeyName != nil {
		return true
	}

	return false
}

// SetStorageAccountKeyName gets a reference to the given string and assigns it to the StorageAccountKeyName field.
func (o *CreateRotatedSecret) SetStorageAccountKeyName(v string) {
	o.StorageAccountKeyName = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *CreateRotatedSecret) SetTags(v []string) {
	o.Tags = &v
}

// GetTarget returns the Target field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetTarget() []string {
	if o == nil || o.Target == nil {
		var ret []string
		return ret
	}
	return *o.Target
}

// GetTargetOk returns a tuple with the Target field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetTargetOk() (*[]string, bool) {
	if o == nil || o.Target == nil {
		return nil, false
	}
	return o.Target, true
}

// HasTarget returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasTarget() bool {
	if o != nil && o.Target != nil {
		return true
	}

	return false
}

// SetTarget gets a reference to the given []string and assigns it to the Target field.
func (o *CreateRotatedSecret) SetTarget(v []string) {
	o.Target = &v
}

// GetTargetName returns the TargetName field value
func (o *CreateRotatedSecret) GetTargetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetTargetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.TargetName, true
}

// SetTargetName sets field value
func (o *CreateRotatedSecret) SetTargetName(v string) {
	o.TargetName = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateRotatedSecret) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateRotatedSecret) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserAttribute returns the UserAttribute field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetUserAttribute() string {
	if o == nil || o.UserAttribute == nil {
		var ret string
		return ret
	}
	return *o.UserAttribute
}

// GetUserAttributeOk returns a tuple with the UserAttribute field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetUserAttributeOk() (*string, bool) {
	if o == nil || o.UserAttribute == nil {
		return nil, false
	}
	return o.UserAttribute, true
}

// HasUserAttribute returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasUserAttribute() bool {
	if o != nil && o.UserAttribute != nil {
		return true
	}

	return false
}

// SetUserAttribute gets a reference to the given string and assigns it to the UserAttribute field.
func (o *CreateRotatedSecret) SetUserAttribute(v string) {
	o.UserAttribute = &v
}

// GetUserDn returns the UserDn field value if set, zero value otherwise.
func (o *CreateRotatedSecret) GetUserDn() string {
	if o == nil || o.UserDn == nil {
		var ret string
		return ret
	}
	return *o.UserDn
}

// GetUserDnOk returns a tuple with the UserDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateRotatedSecret) GetUserDnOk() (*string, bool) {
	if o == nil || o.UserDn == nil {
		return nil, false
	}
	return o.UserDn, true
}

// HasUserDn returns a boolean if a field has been set.
func (o *CreateRotatedSecret) HasUserDn() bool {
	if o != nil && o.UserDn != nil {
		return true
	}

	return false
}

// SetUserDn gets a reference to the given string and assigns it to the UserDn field.
func (o *CreateRotatedSecret) SetUserDn(v string) {
	o.UserDn = &v
}

func (o CreateRotatedSecret) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ProviderType != nil {
		toSerialize["ProviderType"] = o.ProviderType
	}
	if o.ApiId != nil {
		toSerialize["api-id"] = o.ApiId
	}
	if o.ApiKey != nil {
		toSerialize["api-key"] = o.ApiKey
	}
	if o.ApplicationId != nil {
		toSerialize["application-id"] = o.ApplicationId
	}
	if o.AuthenticationCredentials != nil {
		toSerialize["authentication-credentials"] = o.AuthenticationCredentials
	}
	if o.AutoRotate != nil {
		toSerialize["auto-rotate"] = o.AutoRotate
	}
	if o.AwsRegion != nil {
		toSerialize["aws-region"] = o.AwsRegion
	}
	if o.CustomPayload != nil {
		toSerialize["custom-payload"] = o.CustomPayload
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.GcpKey != nil {
		toSerialize["gcp-key"] = o.GcpKey
	}
	if o.GcpServiceAccountEmail != nil {
		toSerialize["gcp-service-account-email"] = o.GcpServiceAccountEmail
	}
	if o.GcpServiceAccountKeyId != nil {
		toSerialize["gcp-service-account-key-id"] = o.GcpServiceAccountKeyId
	}
	if o.GraceRotation != nil {
		toSerialize["grace-rotation"] = o.GraceRotation
	}
	if o.HostProvider != nil {
		toSerialize["host-provider"] = o.HostProvider
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.RotateAfterDisconnect != nil {
		toSerialize["rotate-after-disconnect"] = o.RotateAfterDisconnect
	}
	if o.RotatedPassword != nil {
		toSerialize["rotated-password"] = o.RotatedPassword
	}
	if o.RotatedUsername != nil {
		toSerialize["rotated-username"] = o.RotatedUsername
	}
	if o.RotationHour != nil {
		toSerialize["rotation-hour"] = o.RotationHour
	}
	if o.RotationInterval != nil {
		toSerialize["rotation-interval"] = o.RotationInterval
	}
	if o.RotatorCredsType != nil {
		toSerialize["rotator-creds-type"] = o.RotatorCredsType
	}
	if o.RotatorCustomCmd != nil {
		toSerialize["rotator-custom-cmd"] = o.RotatorCustomCmd
	}
	if true {
		toSerialize["rotator-type"] = o.RotatorType
	}
	if o.SamePassword != nil {
		toSerialize["same-password"] = o.SamePassword
	}
	if o.SecureAccessAllowExternalUser != nil {
		toSerialize["secure-access-allow-external-user"] = o.SecureAccessAllowExternalUser
	}
	if o.SecureAccessAwsAccountId != nil {
		toSerialize["secure-access-aws-account-id"] = o.SecureAccessAwsAccountId
	}
	if o.SecureAccessAwsNativeCli != nil {
		toSerialize["secure-access-aws-native-cli"] = o.SecureAccessAwsNativeCli
	}
	if o.SecureAccessBastionIssuer != nil {
		toSerialize["secure-access-bastion-issuer"] = o.SecureAccessBastionIssuer
	}
	if o.SecureAccessDbName != nil {
		toSerialize["secure-access-db-name"] = o.SecureAccessDbName
	}
	if o.SecureAccessDbSchema != nil {
		toSerialize["secure-access-db-schema"] = o.SecureAccessDbSchema
	}
	if o.SecureAccessDisableConcurrentConnections != nil {
		toSerialize["secure-access-disable-concurrent-connections"] = o.SecureAccessDisableConcurrentConnections
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessRdpDomain != nil {
		toSerialize["secure-access-rdp-domain"] = o.SecureAccessRdpDomain
	}
	if o.SecureAccessRdpUser != nil {
		toSerialize["secure-access-rdp-user"] = o.SecureAccessRdpUser
	}
	if o.SecureAccessUrl != nil {
		toSerialize["secure-access-url"] = o.SecureAccessUrl
	}
	if o.SecureAccessWeb != nil {
		toSerialize["secure-access-web"] = o.SecureAccessWeb
	}
	if o.SecureAccessWebBrowsing != nil {
		toSerialize["secure-access-web-browsing"] = o.SecureAccessWebBrowsing
	}
	if o.SecureAccessWebProxy != nil {
		toSerialize["secure-access-web-proxy"] = o.SecureAccessWebProxy
	}
	if o.SshPassword != nil {
		toSerialize["ssh-password"] = o.SshPassword
	}
	if o.SshUsername != nil {
		toSerialize["ssh-username"] = o.SshUsername
	}
	if o.StorageAccountKeyName != nil {
		toSerialize["storage-account-key-name"] = o.StorageAccountKeyName
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.Target != nil {
		toSerialize["target"] = o.Target
	}
	if true {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserAttribute != nil {
		toSerialize["user-attribute"] = o.UserAttribute
	}
	if o.UserDn != nil {
		toSerialize["user-dn"] = o.UserDn
	}
	return json.Marshal(toSerialize)
}

type NullableCreateRotatedSecret struct {
	value *CreateRotatedSecret
	isSet bool
}

func (v NullableCreateRotatedSecret) Get() *CreateRotatedSecret {
	return v.value
}

func (v *NullableCreateRotatedSecret) Set(val *CreateRotatedSecret) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateRotatedSecret) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateRotatedSecret) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateRotatedSecret(val *CreateRotatedSecret) *NullableCreateRotatedSecret {
	return &NullableCreateRotatedSecret{value: val, isSet: true}
}

func (v NullableCreateRotatedSecret) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateRotatedSecret) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


