%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x3F8000003F800000", "0x3F8000003F800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM1":  ["0x4000000040000000", "0x4000000040000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM2":  ["0x4040000040400000", "0x4040000040400000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x4080000040800000", "0x4080000040800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x3F8000003F800000", "0x3F8000003F800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x4000000040000000", "0x4000000040000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0x4040000040400000", "0x4040000040400000", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x4080000040800000", "0x4080000040800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000"],
    "XMM9":  ["0x4000000040000000", "0x4000000040000000", "0x4000000040000000", "0x4000000040000000"],
    "XMM10": ["0x4040000040400000", "0x4040000040400000", "0x4040000040400000", "0x4040000040400000"],
    "XMM11": ["0x4080000040800000", "0x4080000040800000", "0x4080000040800000", "0x4080000040800000"],
    "XMM12": ["0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000"],
    "XMM13": ["0x4000000040000000", "0x4000000040000000", "0x4000000040000000", "0x4000000040000000"],
    "XMM14": ["0x4040000040400000", "0x4040000040400000", "0x4040000040400000", "0x4040000040400000"],
    "XMM15": ["0x4080000040800000", "0x4080000040800000", "0x4080000040800000", "0x4080000040800000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]
vmovapd ymm3, [rdx + 32 * 3]
vmovapd ymm4, [rdx + 32 * 4]
vmovapd ymm5, [rdx + 32 * 4]
vmovapd ymm6, [rdx + 32 * 4]
vmovapd ymm7, [rdx + 32 * 4]
vmovapd ymm8, [rdx + 32 * 0]
vmovapd ymm9, [rdx + 32 * 1]
vmovapd ymm10, [rdx + 32 * 2]
vmovapd ymm11, [rdx + 32 * 3]

; 128-bit registers
vsqrtps xmm0, xmm0
vsqrtps xmm1, xmm1
vsqrtps xmm2, xmm2
vsqrtps xmm3, xmm3

; 256-bit registers
vsqrtps ymm8, ymm8
vsqrtps ymm9, ymm9
vsqrtps ymm10, ymm10
vsqrtps ymm11, ymm11

; 128-bit memory operand
vsqrtps xmm4, [rdx + 32 * 0]
vsqrtps xmm5, [rdx + 32 * 1]
vsqrtps xmm6, [rdx + 32 * 2]
vsqrtps xmm7, [rdx + 32 * 3]

; 256-bit memory operand
vsqrtps ymm12, [rdx + 32 * 0]
vsqrtps ymm13, [rdx + 32 * 1]
vsqrtps ymm14, [rdx + 32 * 2]
vsqrtps ymm15, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x3F8000003F800000 ; 1.0
dq 0x3F8000003F800000
dq 0x3F8000003F800000
dq 0x3F8000003F800000

dq 0x4080000040800000 ; 4.0
dq 0x4080000040800000
dq 0x4080000040800000
dq 0x4080000040800000

dq 0x4110000041100000 ; 9.0
dq 0x4110000041100000
dq 0x4110000041100000
dq 0x4110000041100000

dq 0x4180000041800000 ; 16.0
dq 0x4180000041800000
dq 0x4180000041800000
dq 0x4180000041800000

dq 0x41C8000041C80000 ; 25.0
dq 0x41C8000041C80000
dq 0x41C8000041C80000
dq 0x41C8000041C80000
