%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x4142434440A00000", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM1": ["0x4142434440800000", "0x5152535455565758", "0x5152535455565758", "0x5152535455565758"],
    "XMM2": ["0x4142434441C80000", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x4142434441800000", "0x5152535455565758", "0x5152535455565758", "0x5152535455565758"],
    "XMM4": ["0x4142434441D00000", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM5": ["0x4142434441800000", "0x5152535455565758", "0x5152535455565758", "0x5152535455565758"],
    "XMM6": ["0x4142434441C80000", "0x5152535455565758", "0x5152535455565758", "0x5152535455565758"],
    "XMM7": ["0x4142434442240000", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]
vmovapd ymm3, [rdx + 32 * 3]
vmovapd ymm4, [rdx + 32 * 4]

; Register only
vaddss xmm0, xmm0, xmm1
vaddss xmm2, xmm2, xmm3

; Memory operand
vaddss xmm4, xmm4, [rdx + 32 * 0]
vaddss xmm5, xmm5, [rdx + 32 * 1]

; Merging different src into destination
vpxor xmm7, xmm7, xmm7
vmovapd ymm5, [rdx + 32 * 3]
vmovapd ymm6, [rdx + 32 * 4]
vaddss xmm7, xmm5, xmm6

hlt

align 32
.data:
dq 0x414243443F800000 ; 1.0
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434440800000 ; 4.0
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434441100000 ; 9.0
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434441800000 ; 16.0
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434441C80000 ; 25.0
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758
