/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.Macro;
import org.netbeans.modules.print.util.UI;
import org.netbeans.spi.print.PrintPage;

final class Paper
extends JComponent {
    private int myNumber;
    private double myScale;
    private PrintPage myPage;
    private boolean myIsPainting;
    private int myPaperWidth;
    private int myPaperHeight;
    private int myPageX;
    private int myPageY;
    private int myPageWidth;
    private int myPageHeight;
    private int myHeaderY;
    private boolean myHasHeader;
    private String myHeaderLeft;
    private String myHeaderCenter;
    private String myHeaderRight;
    private Color myHeaderColor;
    private Font myHeaderFont;
    private int myFooterY;
    private boolean myHasFooter;
    private String myFooterLeft;
    private String myFooterCenter;
    private String myFooterRight;
    private Color myFooterColor;
    private Font myFooterFont;
    private boolean myHasBorder;
    private Color myBorderColor;
    private String myName;
    private String myCount;
    private String myRowNumber;
    private String myColumnNumber;
    private Date myLastModified;
    private int myRow;
    private int myColumn;
    private static final int NUMBER_FONT_SIZE = 35;
    private static final int SHADOW_WIDTH = 10;
    private static final int NUMBER_X = (int)Math.round(35.0);
    private static final int NUMBER_Y = (int)Math.round(52.5);
    private static final Color NUMBER_FONT_COLOR = new Color(125, 125, 255);
    private static final String USER_NAME = System.getProperty("user.name");
    private static final Font NUMBER_FONT_NAME = new Font("Serif", 1, 35);

    Paper(PrintPage printPage, String string, Date date) {
        this.myPage = printPage;
        this.myName = string;
        this.myLastModified = date;
        this.myPaperWidth = Config.getDefault().getPaperWidth();
        this.myPaperHeight = Config.getDefault().getPaperHeight();
        this.myPageX = Config.getDefault().getPageX();
        this.myPageY = Config.getDefault().getPageY();
        this.myPageWidth = Config.getDefault().getPageWidth();
        this.myPageHeight = Config.getDefault().getPageHeight();
        this.myHasBorder = Config.getDefault().hasBorder();
        this.myBorderColor = Config.getDefault().getBorderColor();
        this.myIsPainting = true;
    }

    void setCoordinate(int n, int n2, int n3, double d) {
        this.myNumber = n;
        this.myRow = n2;
        this.myColumn = n3;
        this.myRowNumber = String.valueOf(n2 + 1);
        this.myColumnNumber = String.valueOf(n3 + 1);
        this.setScale(d);
    }

    void setCount(int n) {
        this.myCount = String.valueOf(n);
        this.myHeaderY = Config.getDefault().getHeaderY();
        this.myHasHeader = Config.getDefault().hasHeader();
        this.myHeaderLeft = this.expandTitle(Config.getDefault().getHeaderLeft());
        this.myHeaderCenter = this.expandTitle(Config.getDefault().getHeaderCenter());
        this.myHeaderRight = this.expandTitle(Config.getDefault().getHeaderRight());
        this.myHeaderColor = Config.getDefault().getHeaderColor();
        this.myHeaderFont = Config.getDefault().getHeaderFont();
        this.myFooterY = Config.getDefault().getFooterY();
        this.myHasFooter = Config.getDefault().hasFooter();
        this.myFooterLeft = this.expandTitle(Config.getDefault().getFooterLeft());
        this.myFooterCenter = this.expandTitle(Config.getDefault().getFooterCenter());
        this.myFooterRight = this.expandTitle(Config.getDefault().getFooterRight());
        this.myFooterColor = Config.getDefault().getFooterColor();
        this.myFooterFont = Config.getDefault().getFooterFont();
    }

    int getRow() {
        return this.myRow;
    }

    int getColumn() {
        return this.myColumn;
    }

    void setScale(double d) {
        this.myScale = d;
        if (this.myIsPainting) {
            this.setPreferredSize(new Dimension((int)Math.floor((double)(this.myPaperWidth + 10) * this.myScale), (int)Math.floor((double)(this.myPaperHeight + 10) * this.myScale)));
        } else {
            this.setPreferredSize(new Dimension(this.myPaperWidth, this.myPaperHeight));
        }
    }

    int getPaperWidth() {
        return this.myPaperWidth + 10;
    }

    int getPaperHeight() {
        return this.myPaperHeight + 10;
    }

    @Override
    public void print(Graphics graphics) {
        this.myIsPainting = false;
        this.setScale(1.0);
        super.print(graphics);
        this.myIsPainting = true;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = Config.getDefault().getGraphics(graphics);
        if (this.myIsPainting) {
            graphics2D.scale(this.myScale, this.myScale);
        }
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(this.myPageX, this.myPageY, this.myPageWidth, this.myPageHeight);
        graphics2D.translate(this.myPageX, this.myPageY);
        this.myPage.print(graphics2D);
        graphics2D.translate(-this.myPageX, -this.myPageY);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.myPaperWidth, this.myPageY);
        graphics2D.fillRect(0, this.myPageY + this.myPageHeight, this.myPaperWidth, this.myPaperHeight);
        if (this.myHasHeader) {
            this.drawTitle(graphics2D, this.myHeaderLeft, this.myHeaderCenter, this.myHeaderRight, this.myHeaderY, this.myHeaderColor, this.myHeaderFont);
        }
        if (this.myHasFooter) {
            this.drawTitle(graphics2D, this.myFooterLeft, this.myFooterCenter, this.myFooterRight, this.myFooterY, this.myFooterColor, this.myFooterFont);
        }
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.myPageX, this.myPaperHeight);
        graphics2D.fillRect(this.myPageX + this.myPageWidth, 0, this.myPaperWidth, this.myPaperHeight);
        if (this.myIsPainting) {
            graphics2D.setColor(Color.gray.darker());
            graphics2D.fillRect(this.myPaperWidth, 10, 11, this.myPaperHeight);
            graphics2D.fillRect(10, this.myPaperHeight, this.myPaperWidth, 11);
            graphics2D.setColor(Color.lightGray);
            graphics2D.fillRect(this.myPaperWidth, 0, 11, 11);
            graphics2D.fillRect(0, this.myPaperHeight, 11, 11);
        }
        if (this.myIsPainting) {
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, this.myPaperWidth, this.myPaperHeight);
        }
        if (this.myHasBorder) {
            graphics2D.setColor(this.myBorderColor);
            graphics2D.drawRect(this.myPageX, this.myPageY, this.myPageWidth, this.myPageHeight);
        }
        if (this.myIsPainting) {
            graphics2D.setColor(NUMBER_FONT_COLOR);
            graphics2D.setFont(NUMBER_FONT_NAME);
            graphics2D.drawString(Integer.toString(this.myNumber), NUMBER_X, NUMBER_Y);
        }
    }

    private void drawTitle(Graphics2D graphics2D, String string, String string2, String string3, int n, Color color, Font font) {
        graphics2D.setColor(color);
        this.drawTitle(graphics2D, string, this.myPageX, n, font);
        this.drawTitle(graphics2D, string2, this.myPageX + (this.myPageWidth - this.getWidth(string2, font)) / 2, n, font);
        this.drawTitle(graphics2D, string3, this.myPageX + this.myPageWidth - this.getWidth(string3, font), n, font);
    }

    private void drawTitle(Graphics2D graphics2D, String string, int n, int n2, Font font) {
        graphics2D.setFont(font);
        graphics2D.drawString(string, n, n2);
    }

    private String expandTitle(String string) {
        Date date = new Date(System.currentTimeMillis());
        string = UI.replace(string, Macro.NAME.getName(), this.myName);
        string = UI.replace(string, Macro.ROW.getName(), this.myRowNumber);
        string = UI.replace(string, Macro.COLUMN.getName(), this.myColumnNumber);
        string = UI.replace(string, Macro.USER.getName(), USER_NAME);
        string = UI.replace(string, Macro.COUNT.getName(), this.myCount);
        string = UI.replace(string, Macro.MODIFIED_DATE.getName(), this.getDate(this.myLastModified));
        string = UI.replace(string, Macro.MODIFIED_TIME.getName(), this.getTime(this.myLastModified));
        string = UI.replace(string, Macro.PRINTED_DATE.getName(), this.getDate(date));
        string = UI.replace(string, Macro.PRINTED_TIME.getName(), this.getTime(date));
        return string;
    }

    private int getWidth(String string, Font font) {
        return (int)Math.ceil(font.getStringBounds(string, Config.FONT_RENDER_CONTEXT).getWidth());
    }

    private String getDate(Date date) {
        return this.getTimestamp(date, "yyyy.MM.dd");
    }

    private String getTime(Date date) {
        return this.getTimestamp(date, "HH:mm:ss");
    }

    private String getTimestamp(Date date, String string) {
        return new SimpleDateFormat(string).format(date);
    }
}

